/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractModelCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="deploy")
public class Deploy
extends AbstractModelCommand<Main> {
    @CommandLine.Option(names={"--dry-run"})
    Boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-y", "--deployer", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-yn", "--deployer-name", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xy", "--exclude-deployer", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xyn", "--exclude-deployer-name", "1.5.0"));
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedDeployerTypes(this.collectEntries(this.composite.includedDeployerTypes(), true));
            context.setIncludedDeployerNames(this.collectEntries(this.composite.includedDeployerNames()));
            context.setExcludedDeployerTypes(this.collectEntries(this.composite.excludedDeployerTypes(), true));
            context.setExcludedDeployerNames(this.collectEntries(this.composite.excludedDeployerNames()));
        }
        Workflows.deploy((JReleaserContext)context).execute();
    }

    @Override
    protected Boolean dryrun() {
        return this.dryrun;
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.DEPLOY;
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedDeployerTypes() {
            return null != this.include ? this.include.includedDeployerTypes : null;
        }

        String[] includedDeployerNames() {
            return null != this.include ? this.include.includedDeployerNames : null;
        }

        String[] excludedDeployerTypes() {
            return null != this.exclude ? this.exclude.excludedDeployerTypes : null;
        }

        String[] excludedDeployerNames() {
            return null != this.exclude ? this.exclude.excludedDeployerNames : null;
        }
    }

    static class Exclude {
        @CommandLine.Option(names={"-xy", "--exclude-deployer"}, paramLabel="<deployer>")
        String[] excludedDeployerTypes;
        @CommandLine.Option(names={"-xyn", "--exclude-deployer-name"}, paramLabel="<name>")
        String[] excludedDeployerNames;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-y", "--deployer"}, paramLabel="<deployer>")
        String[] includedDeployerTypes;
        @CommandLine.Option(names={"-yn", "--deployer-name"}, paramLabel="<name>")
        String[] includedDeployerNames;

        Include() {
        }
    }
}

