/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.resolver;

import com.github.mustachejava.MustacheResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class ClasspathResolver
implements MustacheResolver {
    private final String resourceRoot;

    public ClasspathResolver() {
        this.resourceRoot = null;
    }

    public ClasspathResolver(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        InputStream is;
        String fullResourceName;
        String normalizeResourceName;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        URL resource = ccl.getResource(normalizeResourceName = URI.create(fullResourceName = this.concatResourceRootAndResourceName(resourceName)).normalize().getPath());
        if (resource != null) {
            if (resource.getProtocol().equals("jar")) {
                if (normalizeResourceName.endsWith("/")) {
                    return null;
                }
                if (ccl.getResource(normalizeResourceName + "/") != null) {
                    return null;
                }
            } else if (resource.getProtocol().equals("file") && new File(resource.getPath()).isDirectory()) {
                return null;
            }
        }
        if ((is = ccl.getResourceAsStream(normalizeResourceName)) == null) {
            ClassLoader classLoader = ClasspathResolver.class.getClassLoader();
            is = classLoader.getResourceAsStream(normalizeResourceName);
        }
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return null;
    }

    private String concatResourceRootAndResourceName(String resourceName) {
        if (this.resourceRoot == null || resourceName == null) {
            return resourceName;
        }
        if (resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot.substring(0, this.resourceRoot.length() - 1) + resourceName;
        }
        if (resourceName.startsWith("/") && !this.resourceRoot.endsWith("/") || !resourceName.startsWith("/") && this.resourceRoot.endsWith("/")) {
            return this.resourceRoot + resourceName;
        }
        return this.resourceRoot + "/" + resourceName;
    }
}

