import birdbath.ClassAd;
import birdbath.Transaction;
import condor.UniverseType;
import junit.framework.AssertionFailedError;

public class ScheddTestCase1
	extends AbstractScheddTestCase
{
	protected void runTest()
		throws Throwable
	{
		String owner = System.getProperty("JOB_OWNER");

		if (null == owner)
		{
			throw new AssertionFailedError("Please set JOB_OWNER.");
		}

		Transaction transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		try
		{
			int cluster1 = transaction.createCluster();
			int cluster2 = transaction.createCluster();
			int job = transaction.createJob(cluster2);

			transaction.submit(cluster2,
							   job,
							   owner,
							   UniverseType.VANILLA,
							   "/bin/sleep",
							   "30",
							   "OpSys != \"WINNT50\"",
							   null,
							   null);

			transaction.commit();

			schedd.requestReschedule();

			ClassAd ad;
			int status;
			do
			{
				Thread.sleep(10 * 1000);

				//            JobStatus
				//            : Integer which indicates the current status of the job, where
				//            1 = Idle, 2 = Running, 3 = Removed, 4 = Completed, and 5 = Held.

				status = Integer.valueOf(new ClassAd(schedd.getJobAd(cluster2, job)).get("JobStatus")).intValue();
			}
			while (4 != status);

			transaction = schedd.createTransaction();
			transaction.begin(10 * 60);

			transaction.closeSpool(cluster2, job);
		}
		finally
		{
			transaction.commit();
		}
	}
}
