#!/usr/bin/env perl
#
# Copyright 2014 Bill Taylor
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License. You may
# obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.


my $fetch_work_static_slot = 'TESTNAME = fetch_work_static_slot
	TESTNUMBER = 1
	TOTALTESTS = 4
	VERSION = 1
';

my $fetch_work_pslot = 'TESTNAME = fetch_work_pslot
	TESTNUMBER = 2
	TOTALTESTS = 4
	VERSION = 1
';



my $classad_filename = $ARGV[0];
my @argsin = split /\-/, $classad_filename;
my $testname = $argsin[0];
my $version = $argsin[1];
my $out_dir = "--RESULTS--";
my $outfile = "$out_dir/fetch$argsin[1]";

if ( ! -d $out_dir )
{
  `mkdir $out_dir`;
}

my $filename = "$out_dir/$classad_filename\.fetchjob";
open(OUT, ">$filename") || die "Can't open $filename: $!\n";

print OUT "testname: $argsin[0] version:$argsin[1]\n";
my @currentdir = `pwd`;

print OUT "current fetchwork locatioon\n";
foreach my $line (@currentdir) {
	print OUT "$line";
}

print OUT "Current files are:\n";
my @files = `ls -alh`;
foreach my $line (@files) {
	print OUT "$line";
}
print OUT "These files have contents:\n";
opendir DS, "." or die "Can not open dataset: $1\n";
foreach my $subfile (readdir DS)
{
	next if $subfile =~ /^\.\.?$/;
	if(-f $subfile) {
		print OUT "File:$subfile contains:\n";
		open(XX,"<$subfile") or print OUT "Failed to open:$subfile :$!\n";
		while (<XX>) {
			print OUT "$_";
		}
	}
}

#open(FETCH, ">$outfile") || die "Can't open $outfile: $!\n";
if("$testname" eq "fetch_work_static_slot"){
	print OUT "expect $testname == fetch_work_static_slot\n";
	#print FETCH "$fetch_work_static_slot";
	print "$fetch_work_static_slot";
} elsif("$testname" eq "fetch_work_pslot"){
	print OUT "expect $testname == fetch_work_pslot\n";
	#print FETCH "$fetch_work_static_slot";
	print "$fetch_work_pslot";
} else {
	print OUT "failed $testname != fetch_work_static_slot\n";
}
#close(FETCH);
