use super::THEME;
use anyhow::Result;
use dialoguer::Input;
use pimalaya_email::{EmailSender, SendmailConfig};

pub(crate) fn configure() -> Result<EmailSender> {
    Ok(EmailSender::Sendmail(SendmailConfig {
        cmd: Input::with_theme(&*THEME)
            .with_prompt("Enter an external command to send a mail: ")
            .default("/usr/bin/msmtp".to_owned())
            .interact()?,
    }))
}
