/*-----------------------------------------------------------------------------
 * HEALPix Java code supported by the Gaia project.
 * Copyright (C) 2006-2011 Gaia Data Processing and Analysis Consortium
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *-----------------------------------------------------------------------------
 */

package healpix.plot3d.canvas3d;

/**
 * Some color factor to get them from a static way.
 * 
 * @version $Id: ColorConstants.java 30580 2007-09-05 15:02:18Z nbach $
 */
public class ColorConstants {
	/**
	 * BLUE Color factor value
	 */
	public static final double BASE_BLUE_FACTOR = 0.19f;

	/**
	 * GREEN Color factor value
	 */
	public static final double BASE_GREEN_FACTOR = 0.29f;

	/**
	 * RED Color factor value
	 */
	public static final double BASE_RED_FACTOR = 0.36f;

	/**
	 * BLUE Color offset value
	 */
	public static final double BASE_BLUE_OFFSET = 0.029f;

	/**
	 * GREEN Color offset value
	 */
	public static final double BASE_GREEN_OFFSET = -0.18f;

	/**
	 * RED Color offset value
	 */
	public static final double BASE_RED_OFFSET = -0.46f;

	/**
	 * Creates a new ColorConstants object.
	 */
	public ColorConstants() {
	}
}
