/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import nom.tam.util.ArrayFuncs;
import org.junit.Assert;
import org.junit.Test;

public class ArrayFuncs2Test {
    @Test
    public void test() {
        int[][][] test1 = new int[10][9][8];
        boolean[][] test2 = new boolean[][]{new boolean[5], new boolean[4], new boolean[3], new boolean[2]};
        double[][] test3 = new double[10][20];
        StringBuffer[][] test4 = new StringBuffer[3][2];
        Assert.assertEquals((String)"getBaseClass()", Integer.TYPE, (Object)ArrayFuncs.getBaseClass(test1));
        Assert.assertEquals((String)"getBaseLength()", (long)4L, (long)ArrayFuncs.getBaseLength(test1));
        Assert.assertEquals((String)"computeSize()", (long)2880L, (long)ArrayFuncs.computeSize(test1));
        Assert.assertEquals((String)"computeLSize()", (long)2880L, (long)ArrayFuncs.computeLSize(test1));
        Assert.assertEquals((String)"getBaseClass(boolean)", Boolean.TYPE, (Object)ArrayFuncs.getBaseClass(test2));
        Assert.assertEquals((String)"getBaseLength(boolean)", (long)1L, (long)ArrayFuncs.getBaseLength(test2));
        Assert.assertEquals((String)"computeSize() not rect", (long)14L, (long)ArrayFuncs.computeSize(test2));
        Assert.assertEquals((String)"computeLSize() not rect", (long)14L, (long)ArrayFuncs.computeLSize(test2));
        Assert.assertEquals((String)"getBaseClass(double)", Double.TYPE, (Object)ArrayFuncs.getBaseClass(test3));
        Assert.assertEquals((String)"getBaseLength(double)", (long)8L, (long)ArrayFuncs.getBaseLength(test3));
        Assert.assertEquals((String)"computeSize(double)", (long)1600L, (long)ArrayFuncs.computeSize(test3));
        Assert.assertEquals((String)"computeLSize(double)", (long)1600L, (long)ArrayFuncs.computeLSize(test3));
        Assert.assertEquals((String)"getBaseClass(StrBuf)", StringBuffer.class, (Object)ArrayFuncs.getBaseClass(test4));
        Assert.assertEquals((String)"getBaseLength(StrBuf)", (long)-1L, (long)ArrayFuncs.getBaseLength(test4));
        Assert.assertEquals((String)"computeSize(StrBuf)", (long)0L, (long)ArrayFuncs.computeSize(test4));
        Assert.assertEquals((String)"computeLSize(StrBuf)", (long)0L, (long)ArrayFuncs.computeLSize(test4));
        Object[] agg = new Object[]{test1, test2, test3, test4};
        Assert.assertEquals((String)"getBaseClass(Object[])", Object.class, (Object)ArrayFuncs.getBaseClass(agg));
        Assert.assertEquals((String)"getBaseLength(Object[])", (long)-1L, (long)ArrayFuncs.getBaseLength(agg));
        Assert.assertEquals((String)"computeSize(Object[])", (long)4494L, (long)ArrayFuncs.computeSize(agg));
        Assert.assertEquals((String)"computeLSize(Object[])", (long)4494L, (long)ArrayFuncs.computeLSize(agg));
        try {
            float[][] data = new float[10000][30000];
            long expect = 1200000000L;
            Assert.assertEquals((String)"computLSize(big)", (long)ArrayFuncs.computeLSize(data), (long)expect);
        }
        catch (Error e) {
            System.out.println("Unable to allocate large array. Test skipped");
        }
        for (int i = 0; i < test1.length; ++i) {
            for (int j = 0; j < test1[i].length; ++j) {
                for (int k = 0; k < test1[i][j].length; ++k) {
                    test1[i][j][k] = i + j + k;
                }
            }
        }
        int[][][] test5 = (int[][][])ArrayFuncs.deepClone(test1);
        Assert.assertEquals((String)"deepClone()", (Object)true, (Object)ArrayFuncs.arrayEquals(test1, test5));
        test5[1][1][1] = -3;
        Assert.assertEquals((String)"arrayEquals()", (Object)false, (Object)ArrayFuncs.arrayEquals(test1, test5));
        int[] dimsOrig = ArrayFuncs.getDimensions(test1);
        int[] test6 = (int[])ArrayFuncs.flatten(test1);
        int[] dims = ArrayFuncs.getDimensions(test6);
        Assert.assertEquals((String)"getDimensions()", (long)3L, (long)dimsOrig.length);
        Assert.assertEquals((String)"getDimensions()", (long)10L, (long)dimsOrig[0]);
        Assert.assertEquals((String)"getDimensions()", (long)9L, (long)dimsOrig[1]);
        Assert.assertEquals((String)"getDimensions()", (long)8L, (long)dimsOrig[2]);
        Assert.assertEquals((String)"flatten()", (long)1L, (long)dims.length);
        int[] newdims = new int[]{8, 9, 10};
        int[][][] test7 = (int[][][])ArrayFuncs.curl(test6, newdims);
        int[] dimsAfter = ArrayFuncs.getDimensions(test7);
        Assert.assertEquals((String)"curl()", (long)3L, (long)dimsAfter.length);
        Assert.assertEquals((String)"getDimensions()", (long)8L, (long)dimsAfter[0]);
        Assert.assertEquals((String)"getDimensions()", (long)9L, (long)dimsAfter[1]);
        Assert.assertEquals((String)"getDimensions()", (long)10L, (long)dimsAfter[2]);
        byte[][][] xtest1 = (byte[][][])ArrayFuncs.convertArray(test1, Byte.TYPE);
        Assert.assertEquals((String)"convertArray(toByte)", Byte.TYPE, (Object)ArrayFuncs.getBaseClass(xtest1));
        Assert.assertEquals((String)"convertArray(tobyte)", (long)test1[3][3][3], (long)xtest1[3][3][3]);
        double[][][] xtest2 = (double[][][])ArrayFuncs.convertArray(test1, Double.TYPE);
        Assert.assertEquals((String)"convertArray(toByte)", Double.TYPE, (Object)ArrayFuncs.getBaseClass(xtest2));
        Assert.assertEquals((String)"convertArray(tobyte)", (long)test1[3][3][3], (long)((int)xtest2[3][3][3]));
        int[] xtest3 = (int[])ArrayFuncs.newInstance(Integer.TYPE, 20);
        int[] xtd = ArrayFuncs.getDimensions(xtest3);
        Assert.assertEquals((String)"newInstance(vector)", (long)1L, (long)xtd.length);
        Assert.assertEquals((String)"newInstance(vector)", (long)20L, (long)xtd[0]);
        double[][][][] xtest4 = (double[][][][])ArrayFuncs.newInstance(Double.TYPE, new int[]{5, 4, 3, 2});
        xtd = ArrayFuncs.getDimensions(xtest4);
        Assert.assertEquals((String)"newInstance(tensor)", (long)4L, (long)xtd.length);
        Assert.assertEquals((String)"newInstance(tensor)", (long)5L, (long)xtd[0]);
        Assert.assertEquals((String)"newInstance(tensor)", (long)4L, (long)xtd[1]);
        Assert.assertEquals((String)"newInstance(tensor)", (long)3L, (long)xtd[2]);
        Assert.assertEquals((String)"newInstance(tensor)", (long)2L, (long)xtd[3]);
        Assert.assertEquals((String)"nElements()", (long)120L, (long)ArrayFuncs.nElements(xtest4));
        Assert.assertEquals((String)"nLElements()", (long)120L, (long)ArrayFuncs.nLElements(xtest4));
        ArrayFuncs.testPattern(xtest4, (byte)-1);
        Assert.assertEquals((String)"testPattern()", (double)-1.0, (double)xtest4[0][0][0][0], (double)0.0);
        Assert.assertEquals((String)"testPattern()", (double)118.0, (double)xtest4[4][3][2][1], (double)0.0);
        double[] xtest4x = (double[])ArrayFuncs.getBaseArray(xtest4);
        Assert.assertEquals((String)"getBaseArray()", (long)2L, (long)xtest4x.length);
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] y = new double[x.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = x[i] + 1.0E-10;
        }
        Assert.assertEquals((String)"eqTest", (Object)false, (Object)ArrayFuncs.arrayEquals(x, y));
        Assert.assertEquals((String)"eqTest2", (Object)true, (Object)ArrayFuncs.arrayEquals(x, y, 0.0, 1.0E-9));
        Assert.assertEquals((String)"eqTest3", (Object)true, (Object)ArrayFuncs.arrayEquals(x, y, 1.0E-5, 1.0E-9));
        Assert.assertEquals((String)"eqTest4", (Object)false, (Object)ArrayFuncs.arrayEquals(x, y, 0.0, 1.0E-11));
        Assert.assertEquals((String)"eqTest5", (Object)false, (Object)ArrayFuncs.arrayEquals(x, y, 1.0E-5, 0.0));
        float[] fx = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        float[] fy = new float[fx.length];
        for (int i = 0; i < fy.length; ++i) {
            fy[i] = fx[i] + 1.0E-5f;
        }
        Assert.assertEquals((String)"eqTest6", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy));
        Assert.assertEquals((String)"eqTest7", (Object)true, (Object)ArrayFuncs.arrayEquals(fx, fy, 1.0E-4, 0.0));
        Assert.assertEquals((String)"eqTest8", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy, 1.0E-6, 0.0));
        Assert.assertEquals((String)"eqTest9", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy, 0.0, 0.0));
        Assert.assertEquals((String)"eqTest10", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy, 0.0, 1.0E-4));
    }
}

