/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class RandomGroupsTest {
    @Test
    public void test() throws Exception {
        int j;
        int i;
        float[][] fa = new float[20][20];
        float[] pa = new float[3];
        BufferedFile bf = new BufferedFile("rg1.fits", "rw");
        Object[][] data = new Object[1][2];
        data[0][0] = pa;
        data[0][1] = fa;
        BasicHDU hdu = Fits.makeHDU(data);
        Header hdr = hdu.getHeader();
        hdr.addValue("GCOUNT", 20L, "Number of groups");
        hdr.write(bf);
        for (int i2 = 0; i2 < 20; ++i2) {
            int j2;
            for (j2 = 0; j2 < pa.length; ++j2) {
                pa[j2] = i2 + j2;
            }
            for (j2 = 0; j2 < fa.length; ++j2) {
                fa[j2][j2] = i2 * j2;
            }
            bf.writeArray(data);
        }
        byte[] padding = new byte[FitsUtil.padding(20L * ArrayFuncs.computeLSize(data))];
        bf.write(padding);
        bf.flush();
        bf.close();
        Fits f = new Fits("rg1.fits");
        BasicHDU[] hdus = f.read();
        data = (Object[][])hdus[0].getKernel();
        for (i = 0; i < data.length; ++i) {
            pa = (float[])data[i][0];
            fa = (float[][])data[i][1];
            for (j = 0; j < pa.length; ++j) {
                Assert.assertEquals((String)("paramTest:" + i + " " + j), (double)(i + j), (double)pa[j], (double)0.0);
            }
            for (j = 0; j < fa.length; ++j) {
                Assert.assertEquals((String)("dataTest:" + i + " " + j), (double)(i * j), (double)fa[j][j], (double)0.0);
            }
        }
        f = new Fits();
        f.addHDU(Fits.makeHDU(data));
        bf = new BufferedFile("rg2.fits", "rw");
        f.write(bf);
        bf.flush();
        bf.close();
        f = new Fits("rg2.fits");
        data = (Object[][])f.read()[0].getKernel();
        for (i = 0; i < data.length; ++i) {
            pa = (float[])data[i][0];
            fa = (float[][])data[i][1];
            for (j = 0; j < pa.length; ++j) {
                Assert.assertEquals((String)("paramTest:" + i + " " + j), (double)(i + j), (double)pa[j], (double)0.0);
            }
            for (j = 0; j < fa.length; ++j) {
                Assert.assertEquals((String)("dataTest:" + i + " " + j), (double)(i * j), (double)fa[j][j], (double)0.0);
            }
        }
    }
}

