/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.Fits;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCommentsMap;
import nom.tam.fits.ImageHDU;
import nom.tam.util.BufferedFile;
import nom.tam.util.Cursor;
import org.junit.Assert;
import org.junit.Test;

public class HeaderTest {
    @Test
    public void simpleImages() throws Exception {
        float[][] img = new float[300][300];
        Fits f = new Fits();
        ImageHDU hdu = (ImageHDU)Fits.makeHDU(img);
        BufferedFile bf = new BufferedFile("ht1.fits", "rw");
        f.addHDU(hdu);
        f.write(bf);
        bf.close();
        f = new Fits("ht1.fits");
        hdu = (ImageHDU)f.getHDU(0);
        Header hdr = hdu.getHeader();
        Assert.assertEquals((String)"NAXIS", (long)2L, (long)hdr.getIntValue("NAXIS"));
        Assert.assertEquals((String)"NAXIS1", (long)300L, (long)hdr.getIntValue("NAXIS1"));
        Assert.assertEquals((String)"NAXIS2", (long)300L, (long)hdr.getIntValue("NAXIS2"));
        Assert.assertEquals((String)"NAXIS2a", (long)300L, (long)hdr.getIntValue("NAXIS2", -1));
        Assert.assertEquals((String)"NAXIS3", (long)-1L, (long)hdr.getIntValue("NAXIS3", -1));
        Assert.assertEquals((String)"BITPIX", (long)-32L, (long)hdr.getIntValue("BITPIX"));
        Cursor c = hdr.iterator();
        HeaderCard hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"SIMPLE_1", (Object)"SIMPLE", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"BITPIX_2", (Object)"BITPIX", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"NAXIS_3", (Object)"NAXIS", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"NAXIS1_4", (Object)"NAXIS1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"NAXIS2_5", (Object)"NAXIS2", (Object)hc.getKey());
    }

    @Test
    public void extendTest() throws Exception {
        Fits f = new Fits("ht1.fits");
        Header h = f.getHDU(0).getHeader();
        h.addValue("TESTKEY", "TESTVAL", "TESTCOMM");
        h.rewrite();
        f.getStream().close();
        f = new Fits("ht1.fits");
        h = f.getHDU(0).getHeader();
        h.addValue("TESTKEY2", "TESTVAL2", null);
        Cursor c = h.iterator();
        Assert.assertEquals((String)"E1", (Object)((HeaderCard)c.next()).getKey(), (Object)"SIMPLE");
        Assert.assertEquals((String)"E2", (Object)((HeaderCard)c.next()).getKey(), (Object)"BITPIX");
        Assert.assertEquals((String)"E3", (Object)((HeaderCard)c.next()).getKey(), (Object)"NAXIS");
        Assert.assertEquals((String)"E4", (Object)((HeaderCard)c.next()).getKey(), (Object)"NAXIS1");
        Assert.assertEquals((String)"E5", (Object)((HeaderCard)c.next()).getKey(), (Object)"NAXIS2");
        Assert.assertEquals((String)"E6", (Object)((HeaderCard)c.next()).getKey(), (Object)"EXTEND");
        Assert.assertEquals((String)"E7", (Object)((HeaderCard)c.next()).getKey(), (Object)"TESTKEY2");
        Assert.assertEquals((String)"E8", (Object)((HeaderCard)c.next()).getKey(), (Object)"TESTKEY");
    }

    @Test
    public void cursorTest() throws Exception {
        Fits f = new Fits("ht1.fits");
        ImageHDU hdu = (ImageHDU)f.getHDU(0);
        Header hdr = hdu.getHeader();
        Cursor c = hdr.iterator();
        c.setKey("XXX");
        c.add("CTYPE1", new HeaderCard("CTYPE1", "GLON-CAR", "Galactic Longitude"));
        c.add("CTYPE2", new HeaderCard("CTYPE2", "GLAT-CAR", "Galactic Latitude"));
        c.setKey("CTYPE1");
        c.add("CRVAL1", new HeaderCard("CRVAL1", 0.0, "Longitude at reference"));
        c.setKey("CTYPE2");
        c.add("CRVAL2", new HeaderCard("CRVAL2", -90.0, "Latitude at reference"));
        c.setKey("CTYPE1");
        c.add("CRPIX1", new HeaderCard("CRPIX1", 150.0, "Reference Pixel X"));
        c.setKey("CTYPE2");
        c.add("CRPIX2", new HeaderCard("CRPIX2", 0.0, "Reference pixel Y"));
        c.add("INV2", new HeaderCard("INV2", true, "Invertible axis"));
        c.add("SYM2", new HeaderCard("SYM2", "YZ SYMMETRIC", "Symmetries..."));
        Assert.assertEquals((String)"CTYPE1", (Object)"GLON-CAR", (Object)hdr.getStringValue("CTYPE1"));
        Assert.assertEquals((String)"CRPIX2", (double)0.0, (double)hdr.getDoubleValue("CRPIX2", -2.0), (double)0.0);
        c.setKey("CRVAL1");
        HeaderCard hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CRVAL1_c", (Object)"CRVAL1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CRPIX1_c", (Object)"CRPIX1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CTYPE1_c", (Object)"CTYPE1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CRVAL2_c", (Object)"CRVAL2", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CRPIX2_c", (Object)"CRPIX2", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"INV2_c", (Object)"INV2", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"SYM2_c", (Object)"SYM2", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CTYPE2_c", (Object)"CTYPE2", (Object)hc.getKey());
        hdr.findCard("CRPIX1");
        hdr.addValue("INTVAL1", 1L, "An integer value");
        hdr.addValue("LOG1", true, "A true value");
        hdr.addValue("LOGB1", false, "A false value");
        hdr.addValue("FLT1", 1.34, "A float value");
        hdr.addValue("FLT2", -1.23456789E-134, "A very long float");
        hdr.insertComment("Comment after flt2");
        c.setKey("INTVAL1");
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"INTVAL1", (Object)"INTVAL1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"LOG1", (Object)"LOG1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"LOGB1", (Object)"LOGB1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"FLT1", (Object)"FLT1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"FLT2", (Object)"FLT2", (Object)hc.getKey());
        c.next();
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"CRPIX1x", (Object)"CRPIX1", (Object)hc.getKey());
        Assert.assertEquals((String)"FLT1", (double)1.34, (double)hdr.getDoubleValue("FLT1", 0.0), (double)0.0);
        c.setKey("FLT1");
        c.next();
        c.remove();
        Assert.assertEquals((String)"FLT1", (double)0.0, (double)hdr.getDoubleValue("FLT1", 0.0), (double)0.0);
        c.setKey("LOGB1");
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"AftDel1", (Object)"LOGB1", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"AftDel2", (Object)"FLT2", (Object)hc.getKey());
        hc = (HeaderCard)c.next();
        Assert.assertEquals((String)"AftDel3", (Object)"Comment after flt2", (Object)hc.getComment());
    }

    @Test
    public void testBadHeader() throws Exception {
        Fits f = new Fits("ht1.fits");
        ImageHDU hdu = (ImageHDU)f.getHDU(0);
        Header hdr = hdu.getHeader();
        Cursor c = hdr.iterator();
        c = hdr.iterator();
        c.next();
        c.next();
        c.remove();
        boolean thrown = false;
        try {
            hdr.rewrite();
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertEquals((String)"BITPIX delete", (Object)true, (Object)thrown);
    }

    @Test
    public void testUpdateHeaderComments() throws Exception {
        byte[][] z = new byte[4][4];
        Fits f = new Fits();
        f.addHDU(FitsFactory.HDUFactory(z));
        BufferedFile bf = new BufferedFile("hx1.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("hx1.fits");
        HeaderCard c1 = f.getHDU(0).getHeader().findCard("SIMPLE");
        Assert.assertEquals((String)"tuhc1", (Object)c1.getComment(), (Object)HeaderCommentsMap.getComment("header:simple:1"));
        c1 = f.getHDU(0).getHeader().findCard("BITPIX");
        Assert.assertEquals((String)"tuhc2", (Object)c1.getComment(), (Object)HeaderCommentsMap.getComment("header:bitpix:1"));
        HeaderCommentsMap.updateComment("header:bitpix:1", "A byte array");
        HeaderCommentsMap.deleteComment("header:simple:1");
        f = new Fits();
        f.addHDU(FitsFactory.HDUFactory(z));
        bf = new BufferedFile("hx2.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("hx2.fits");
        c1 = f.getHDU(0).getHeader().findCard("SIMPLE");
        Assert.assertEquals((String)"tuhc1", (Object)c1.getComment(), null);
        c1 = f.getHDU(0).getHeader().findCard("BITPIX");
        Assert.assertEquals((String)"tuhc2", (Object)c1.getComment(), (Object)"A byte array");
    }

    @Test
    public void testRewrite() throws Exception {
        Fits f = new Fits("ht1.fits");
        ImageHDU hdu = (ImageHDU)f.getHDU(0);
        Header hdr = hdu.getHeader();
        Cursor c = hdr.iterator();
        int nc = hdr.getNumberOfCards();
        int nb = (nc - 1) / 36;
        while (hdr.rewriteable()) {
            int nbx = (hdr.getNumberOfCards() - 1) / 36;
            Assert.assertEquals((String)("Rewrite:" + nbx), (Object)(nb == nbx ? 1 : 0), (Object)hdr.rewriteable());
            c.add(new HeaderCard("DUMMY" + nbx, null, null));
        }
    }

    @Test
    public void longStringTest() throws Exception {
        Header hdr = new Fits("ht1.fits").getHDU(0).getHeader();
        String seq = "0123456789";
        String lng = "";
        for (int i = 0; i < 20; ++i) {
            lng = lng + seq;
        }
        Assert.assertEquals((String)"Initial state:", (Object)false, (Object)Header.getLongStringsEnabled());
        Header.setLongStringsEnabled(true);
        Assert.assertEquals((String)"Set state:", (Object)true, (Object)Header.getLongStringsEnabled());
        hdr.addValue("LONG1", lng, "Here is a comment");
        hdr.addValue("LONG2", "xx'yy'zz" + lng, "Another comment");
        hdr.addValue("SHORT", "A STRING ENDING IN A &", null);
        hdr.addValue("LONGISH", lng + "&", null);
        hdr.addValue("LONGSTRN", "OGIP 1.0", "Uses long strings");
        String sixty = seq + seq + seq + seq + seq + seq;
        hdr.addValue("APOS1", sixty + "''''''''''", "Should be 70 chars long");
        hdr.addValue("APOS2", sixty + " ''''''''''", "Should be 71 chars long");
        BufferedFile bf = new BufferedFile("ht4.hdr", "rw");
        hdr.write(bf);
        bf.close();
        String val = hdr.getStringValue("LONG1");
        Assert.assertEquals((String)"LongT1", (Object)val, (Object)lng);
        val = hdr.getStringValue("LONG2");
        Assert.assertEquals((String)"LongT2", (Object)val, (Object)("xx'yy'zz" + lng));
        Assert.assertEquals((String)"APOS1", (long)hdr.getStringValue("APOS1").length(), (long)70L);
        Assert.assertEquals((String)"APOS2", (long)hdr.getStringValue("APOS2").length(), (long)71L);
        Header.setLongStringsEnabled(false);
        val = hdr.getStringValue("LONG1");
        Assert.assertEquals((String)"LongT3", (Object)true, (Object)(!val.equals(lng) ? 1 : 0));
        Assert.assertEquals((String)"Longt4", (Object)true, (Object)(val.length() <= 70 ? 1 : 0));
        Assert.assertEquals((String)"longamp1", (Object)hdr.getStringValue("SHORT"), (Object)"A STRING ENDING IN A &");
        bf = new BufferedFile("ht4.hdr", "r");
        hdr = new Header(bf);
        Assert.assertEquals((String)"Set state2:", (Object)true, (Object)Header.getLongStringsEnabled());
        val = hdr.getStringValue("LONG1");
        Assert.assertEquals((String)"LongT5", (Object)val, (Object)lng);
        val = hdr.getStringValue("LONG2");
        Assert.assertEquals((String)"LongT6", (Object)val, (Object)("xx'yy'zz" + lng));
        Assert.assertEquals((String)"longamp2", (Object)hdr.getStringValue("LONGISH"), (Object)(lng + "&"));
        Assert.assertEquals((String)"APOS1b", (long)hdr.getStringValue("APOS1").length(), (long)70L);
        Assert.assertEquals((String)"APOS2b", (long)hdr.getStringValue("APOS2").length(), (long)71L);
        Assert.assertEquals((String)"APOS2c", (Object)hdr.getStringValue("APOS2"), (Object)(sixty + " ''''''''''"));
        Assert.assertEquals((String)"longamp1b", (Object)hdr.getStringValue("SHORT"), (Object)"A STRING ENDING IN A &");
        Assert.assertEquals((String)"longamp2b", (Object)hdr.getStringValue("LONGISH"), (Object)(lng + "&"));
        int cnt = hdr.getNumberOfCards();
        hdr.removeCard("LONG1");
        Assert.assertEquals((String)"deltest", (long)(cnt - 3), (long)hdr.getNumberOfCards());
        Header.setLongStringsEnabled(false);
        hdr.removeCard("LONG2");
        Assert.assertEquals((String)"deltest2", (long)(cnt - 4), (long)hdr.getNumberOfCards());
    }
}

