/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import java.io.FileOutputStream;
import java.lang.reflect.Array;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinaryTableTest {
    byte[] bytes = new byte[50];
    byte[][] bits = new byte[50][2];
    boolean[] bools = new boolean[50];
    short[][] shorts = new short[50][3];
    int[] ints = new int[50];
    float[][][] floats = new float[50][4][4];
    double[] doubles = new double[50];
    long[] longs = new long[50];
    String[] strings = new String[50];
    float[][] vf = new float[50][];
    short[][] vs = new short[50][];
    double[][] vd = new double[50][];
    boolean[][] vbool = new boolean[50][];
    float[][][] vc = new float[50][][];
    double[][][] vdc = new double[50][][];
    float[][] complex = new float[50][2];
    float[][][] complex_arr = new float[50][4][2];
    double[][] dcomplex = new double[50][2];
    double[][][] dcomplex_arr = new double[50][4][2];

    @Before
    public void initialize() {
        for (int i = 0; i < this.bytes.length; ++i) {
            int j;
            this.bytes[i] = (byte)(2 * i);
            this.bits[i][0] = this.bytes[i];
            this.bits[i][1] = ~this.bytes[i];
            this.bools[i] = this.bytes[i] % 8 == 0;
            this.shorts[i][0] = (short)(2 * i);
            this.shorts[i][1] = (short)(3 * i);
            this.shorts[i][2] = (short)(4 * i);
            this.ints[i] = i * i;
            for (int j2 = 0; j2 < 4; ++j2) {
                for (int k = 0; k < 4; ++k) {
                    this.floats[i][j2][k] = (float)((double)i + (double)j2 * Math.exp(k));
                }
            }
            this.doubles[i] = 3.0 * Math.sin(i);
            this.longs[i] = i * i * i * i;
            this.strings[i] = "abcdefghijklmnopqrstuvwxzy".substring(0, i % 20);
            this.vf[i] = new float[i + 1];
            this.vf[i][i / 2] = i * 3;
            this.vs[i] = new short[i / 10 + 1];
            this.vs[i][i / 10] = (short)(-i);
            this.vd[i] = new double[i % 2 == 0 ? 1 : 2];
            this.vd[i][0] = 99.99;
            this.vbool[i] = new boolean[i / 10];
            if (i >= 10) {
                this.vbool[i][0] = i % 2 == 1;
            }
            int m5 = i % 5;
            this.vc[i] = new float[m5][];
            for (j = 0; j < m5; ++j) {
                this.vc[i][j] = new float[2];
                this.vc[i][j][0] = i;
                this.vc[i][j][1] = -j;
            }
            this.vdc[i] = new double[m5][];
            for (j = 0; j < m5; ++j) {
                this.vdc[i][j] = new double[2];
                this.vdc[i][j][0] = -j;
                this.vdc[i][j][1] = i;
            }
            double rad = (double)(2 * i) * Math.PI / (double)this.bytes.length;
            this.complex[i][0] = (float)Math.cos(rad);
            this.complex[i][1] = (float)Math.sin(rad);
            this.dcomplex[i][0] = this.complex[i][0];
            this.dcomplex[i][1] = this.complex[i][1];
            for (int j3 = 0; j3 < 4; ++j3) {
                this.complex_arr[i][j3][0] = (float)(j3 + 1) * this.complex[i][0];
                this.complex_arr[i][j3][1] = (float)(j3 + 1) * this.complex[i][1];
                this.dcomplex_arr[i][j3][0] = (float)(j3 + 1) * this.complex[i][0];
                this.dcomplex_arr[i][j3][1] = (float)(j3 + 1) * this.complex[i][1];
            }
        }
    }

    @Test
    public void testSimpleIO() throws Exception {
        FitsFactory.setUseAsciiTables(false);
        Fits f = new Fits();
        Object[] data = new Object[]{this.bytes, this.bits, this.bools, this.shorts, this.ints, this.floats, this.doubles, this.longs, this.strings, this.complex, this.dcomplex, this.complex_arr, this.dcomplex_arr};
        f.addHDU(Fits.makeHDU(data));
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        bhdu.setColumnName(0, "bytes", null);
        bhdu.setColumnName(1, "bits", "bits later on");
        bhdu.setColumnName(6, "doubles", null);
        bhdu.setColumnName(5, "floats", "4 x 4 array");
        BufferedFile bf = new BufferedFile("bt1.fits", "rw");
        f.write(bf);
        bf.flush();
        bf.close();
        f = new Fits("bt1.fits");
        f.read();
        Assert.assertEquals((String)"NHDU", (long)2L, (long)f.getNumberOfHDUs());
        BinaryTableHDU thdu = (BinaryTableHDU)f.getHDU(1);
        Header hdr = thdu.getHeader();
        Assert.assertEquals((String)"HDR1", (long)data.length, (long)hdr.getIntValue("TFIELDS"));
        Assert.assertEquals((String)"HDR2", (long)2L, (long)hdr.getIntValue("NAXIS"));
        Assert.assertEquals((String)"HDR3", (long)8L, (long)hdr.getIntValue("BITPIX"));
        Assert.assertEquals((String)"HDR4", (Object)"BINTABLE", (Object)hdr.getStringValue("XTENSION"));
        Assert.assertEquals((String)"HDR5", (Object)"bytes", (Object)hdr.getStringValue("TTYPE1"));
        Assert.assertEquals((String)"HDR6", (Object)"doubles", (Object)hdr.getStringValue("TTYPE7"));
        for (int i = 0; i < data.length; ++i) {
            Object col = thdu.getColumn(i);
            if (i == 8) {
                String[] st = (String[])col;
                for (int j = 0; j < st.length; ++j) {
                    st[j] = st[j].trim();
                }
            }
            Assert.assertEquals((String)("Data" + i), (Object)true, (Object)ArrayFuncs.arrayEquals(data[i], col));
        }
    }

    @Test
    public void testSimpleComplex() throws Exception {
        try {
            FitsFactory.setUseAsciiTables(false);
            Fits f = new Fits();
            Object[] data = new Object[]{this.bytes, this.bits, this.bools, this.shorts, this.ints, this.floats, this.doubles, this.longs, this.strings, this.complex, this.dcomplex, this.complex_arr, this.dcomplex_arr};
            BinaryTableHDU bhdu = (BinaryTableHDU)Fits.makeHDU(data);
            bhdu.setComplexColumn(9);
            bhdu.setComplexColumn(10);
            bhdu.setComplexColumn(11);
            bhdu.setComplexColumn(12);
            f.addHDU(bhdu);
            bhdu.setColumnName(9, "Complex1", null);
            BufferedFile bf = new BufferedFile("bt1c.fits", "rw");
            f.write(bf);
            bf.flush();
            bf.close();
            f = new Fits("bt1c.fits");
            f.read();
            Assert.assertEquals((String)"NHDUc", (long)2L, (long)f.getNumberOfHDUs());
            BinaryTableHDU thdu = null;
            thdu = (BinaryTableHDU)f.getHDU(1);
            Header hdr = thdu.getHeader();
            for (int i = 0; i < data.length; ++i) {
                Object col = thdu.getColumn(i);
                if (i == 8) {
                    String[] st = (String[])col;
                    for (int j = 0; j < st.length; ++j) {
                        st[j] = st[j].trim();
                    }
                }
                int n = Array.getLength(data[i]);
                Assert.assertEquals((String)("DataC" + i), (Object)true, (Object)ArrayFuncs.arrayEquals(data[i], col));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    @Test
    public void testRowDelete() throws Exception {
        Fits f = new Fits("bt1.fits");
        f.read();
        BinaryTableHDU thdu = (BinaryTableHDU)f.getHDU(1);
        Assert.assertEquals((String)"Del1", (long)50L, (long)thdu.getNRows());
        thdu.deleteRows(10, 20);
        Assert.assertEquals((String)"Del2", (long)30L, (long)thdu.getNRows());
        double[] dbl = (double[])thdu.getColumn(6);
        Assert.assertEquals((String)"del3", (double)dbl[9], (double)this.doubles[9], (double)0.0);
        Assert.assertEquals((String)"del4", (double)dbl[10], (double)this.doubles[30], (double)0.0);
        BufferedFile bf = new BufferedFile("bt1x.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("bt1x.fits");
        f.read();
        thdu = (BinaryTableHDU)f.getHDU(1);
        dbl = (double[])thdu.getColumn(6);
        Assert.assertEquals((String)"del5", (long)30L, (long)thdu.getNRows());
        Assert.assertEquals((String)"del6", (long)13L, (long)thdu.getNCols());
        Assert.assertEquals((String)"del7", (double)dbl[9], (double)this.doubles[9], (double)0.0);
        Assert.assertEquals((String)"del8", (double)dbl[10], (double)this.doubles[30], (double)0.0);
        thdu.deleteRows(20);
        Assert.assertEquals((String)"del9", (long)20L, (long)thdu.getNRows());
        dbl = (double[])thdu.getColumn(6);
        Assert.assertEquals((String)"del10", (long)20L, (long)dbl.length);
        Assert.assertEquals((String)"del11", (double)dbl[0], (double)this.doubles[0], (double)0.0);
        Assert.assertEquals((String)"del12", (double)dbl[19], (double)this.doubles[39], (double)0.0);
    }

    @Test
    public void testVar() throws Exception {
        try {
            Object[] data = new Object[]{this.floats, this.vf, this.vs, this.vd, this.shorts, this.vbool, this.vc, this.vdc};
            BasicHDU hdu = Fits.makeHDU(data);
            Fits f = new Fits();
            f.addHDU(hdu);
            BufferedDataOutputStream bdos = new BufferedDataOutputStream(new FileOutputStream("bt2.fits"));
            f.write(bdos);
            bdos.close();
            f = new Fits("bt2.fits");
            f.read();
            BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
            Header hdr = bhdu.getHeader();
            Assert.assertEquals((String)"var1", (Object)true, (Object)(hdr.getIntValue("PCOUNT") > 0 ? 1 : 0));
            Assert.assertEquals((String)"var2", (long)data.length, (long)hdr.getIntValue("TFIELDS"));
            for (int i = 0; i < data.length; ++i) {
                Assert.assertEquals((String)("vardata" + i), (Object)true, (Object)ArrayFuncs.arrayEquals(data[i], bhdu.getColumn(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    @Test
    public void testSet() throws Exception {
        Fits f = new Fits("bt2.fits");
        f.read();
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        Header hdr = bhdu.getHeader();
        float[] dta = (float[])bhdu.getElement(4, 1);
        dta = new float[]{22.0f, 21.0f, 20.0f};
        bhdu.setElement(4, 1, dta);
        BufferedDataOutputStream bdos = new BufferedDataOutputStream(new FileOutputStream("bt2a.fits"));
        f.write(bdos);
        bdos.close();
        f = new Fits("bt2a.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        float[] xdta = (float[])bhdu.getElement(4, 1);
        Assert.assertEquals((String)"ts1", (Object)true, (Object)ArrayFuncs.arrayEquals(dta, xdta));
        Assert.assertEquals((String)"ts2", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(3, 1), this.vf[3]));
        Assert.assertEquals((String)"ts4", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(5, 1), this.vf[5]));
        Assert.assertEquals((String)"ts5", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), dta));
        float[] tvf = new float[]{101.0f, 102.0f, 103.0f, 104.0f};
        this.vf[4] = tvf;
        bhdu.setColumn(1, (Object)this.vf);
        Assert.assertEquals((String)"ts6", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(3, 1), this.vf[3]));
        Assert.assertEquals((String)"ts7", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), this.vf[4]));
        Assert.assertEquals((String)"ts8", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(5, 1), this.vf[5]));
        bdos = new BufferedDataOutputStream(new FileOutputStream("bt2b.fits"));
        f.write(bdos);
        bdos.close();
        f = new Fits("bt2b.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        Assert.assertEquals((String)"ts9", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(3, 1), this.vf[3]));
        Assert.assertEquals((String)"ts10", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), this.vf[4]));
        Assert.assertEquals((String)"ts11", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(5, 1), this.vf[5]));
        Object[] rw = bhdu.getRow(4);
        float[] trw = new float[]{-1.0f, -2.0f, -3.0f, -4.0f, -5.0f, -6.0f};
        rw[1] = trw;
        bhdu.setRow(4, rw);
        Assert.assertEquals((String)"ts12", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(3, 1), this.vf[3]));
        Assert.assertEquals((String)"ts13", (Object)false, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), this.vf[4]));
        Assert.assertEquals((String)"ts14", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), trw));
        Assert.assertEquals((String)"ts15", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(5, 1), this.vf[5]));
        bdos = new BufferedDataOutputStream(new FileOutputStream("bt2c.fits"));
        f.write(bdos);
        bdos.close();
        f = new Fits("bt2c.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        Assert.assertEquals((String)"ts16", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(3, 1), this.vf[3]));
        Assert.assertEquals((String)"ts17", (Object)false, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), this.vf[4]));
        Assert.assertEquals((String)"ts18", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(4, 1), trw));
        Assert.assertEquals((String)"ts19", (Object)true, (Object)ArrayFuncs.arrayEquals(bhdu.getElement(5, 1), this.vf[5]));
    }

    @Test
    public void buildByColumn() throws Exception {
        BinaryTable btab = new BinaryTable();
        btab.addColumn(this.floats);
        btab.addColumn(this.vf);
        btab.addColumn(this.strings);
        btab.addColumn(this.vbool);
        btab.addColumn(this.ints);
        btab.addColumn(this.vc);
        btab.addColumn(this.complex);
        Fits f = new Fits();
        f.addHDU(Fits.makeHDU(btab));
        BufferedDataOutputStream bdos = new BufferedDataOutputStream(new FileOutputStream("bt3.fits"));
        f.write(bdos);
        f = new Fits("bt3.fits");
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        btab = (BinaryTable)bhdu.getData();
        Assert.assertEquals((String)"col1", (Object)true, (Object)ArrayFuncs.arrayEquals(this.floats, bhdu.getColumn(0)));
        Assert.assertEquals((String)"col2", (Object)true, (Object)ArrayFuncs.arrayEquals(this.vf, bhdu.getColumn(1)));
        Assert.assertEquals((String)"col6", (Object)true, (Object)ArrayFuncs.arrayEquals(this.vc, bhdu.getColumn(5)));
        Assert.assertEquals((String)"col7", (Object)true, (Object)ArrayFuncs.arrayEquals(this.complex, bhdu.getColumn(6)));
        String[] col = (String[])bhdu.getColumn(2);
        for (int i = 0; i < col.length; ++i) {
            col[i] = col[i].trim();
        }
        Assert.assertEquals((String)"coi3", (Object)true, (Object)ArrayFuncs.arrayEquals(this.strings, col));
        Assert.assertEquals((String)"col4", (Object)true, (Object)ArrayFuncs.arrayEquals(this.vbool, bhdu.getColumn(3)));
        Assert.assertEquals((String)"col5", (Object)true, (Object)ArrayFuncs.arrayEquals(this.ints, bhdu.getColumn(4)));
    }

    @Test
    public void buildByRow() throws Exception {
        int i;
        Fits f = new Fits("bt2.fits");
        f.read();
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        Header hdr = bhdu.getHeader();
        BinaryTable btab = (BinaryTable)bhdu.getData();
        for (int i2 = 0; i2 < 50; ++i2) {
            Object[] row = btab.getRow(i2);
            float[] qx = (float[])row[1];
            float[][] p = (float[][])row[0];
            p[0][0] = (float)((double)i2 * Math.sin(i2));
            btab.addRow(row);
        }
        f = new Fits();
        f.addHDU(Fits.makeHDU(btab));
        BufferedFile bf = new BufferedFile("bt4.fits", "rw");
        f.write(bf);
        bf.flush();
        bf.close();
        f = new Fits("bt4.fits");
        btab = (BinaryTable)f.getHDU(1).getData();
        Assert.assertEquals((String)"row1", (long)100L, (long)btab.getNRows());
        float[][][] xf = (float[][][])btab.getColumn(0);
        Assert.assertEquals((String)"row2", (double)0.0, (double)xf[50][0][0], (double)0.0);
        Assert.assertEquals((String)"row3", (double)((float)(49.0 * Math.sin(49.0))), (double)xf[99][0][0], (double)0.0);
        for (int i3 = 0; i3 < xf.length; i3 += 3) {
            boolean[] ba = (boolean[])btab.getElement(i3, 5);
            float[] fx = (float[])btab.getElement(i3, 1);
            int trow = i3 % 50;
            Assert.assertEquals((String)"row4", (Object)true, (Object)ArrayFuncs.arrayEquals(ba, this.vbool[trow]));
            Assert.assertEquals((String)"row6", (Object)true, (Object)ArrayFuncs.arrayEquals(fx, this.vf[trow]));
        }
        float[][][] cmplx = (float[][][])btab.getColumn(6);
        for (i = 0; i < this.vc.length; ++i) {
            for (int j = 0; j < this.vc[i].length; ++j) {
                Assert.assertEquals((String)("rowvc" + i + "_" + j), (Object)true, (Object)ArrayFuncs.arrayEquals(this.vc[i][j], cmplx[i + this.vc.length][j]));
            }
        }
        f.getHDU(1).getData();
        xf = (float[][][])btab.getColumn(0);
        Assert.assertEquals((String)"row7", (double)0.0, (double)xf[50][0][0], (double)0.0);
        Assert.assertEquals((String)"row8", (double)((float)(49.0 * Math.sin(49.0))), (double)xf[99][0][0], (double)0.0);
        for (i = 0; i < xf.length; i += 3) {
            boolean[] ba = (boolean[])btab.getElement(i, 5);
            float[] fx = (float[])btab.getElement(i, 1);
            int trow = i % 50;
            Assert.assertEquals((String)"row9", (Object)true, (Object)ArrayFuncs.arrayEquals(ba, this.vbool[trow]));
            Assert.assertEquals((String)"row11", (Object)true, (Object)ArrayFuncs.arrayEquals(fx, this.vf[trow]));
        }
    }

    @Test
    public void testObj() throws Exception {
        Object[][] x = new Object[5][3];
        for (int i = 0; i < 5; ++i) {
            x[i][0] = new float[]{i};
            x[i][1] = new String("AString" + i);
            x[i][2] = new int[][]{{i, 2 * i}, {3 * i, 4 * i}};
        }
        Fits f = new Fits();
        BasicHDU hdu = Fits.makeHDU(x);
        f.addHDU(hdu);
        BufferedFile bf = new BufferedFile("bt5.fits", "rw");
        f.write(bf);
        bf.close();
        BinaryTableHDU xhdu = (BinaryTableHDU)hdu;
        Assert.assertEquals((String)"delcol1", (long)3L, (long)xhdu.getNCols());
        xhdu.deleteColumnsIndexOne(1, 1);
        Assert.assertEquals((String)"delcol2", (long)2L, (long)xhdu.getNCols());
        xhdu.deleteColumnsIndexZero(1, 1);
        Assert.assertEquals((String)"delcol3", (long)1L, (long)xhdu.getNCols());
        bf = new BufferedFile("bt6.fits", "rw");
        f.write(bf);
        f = new Fits("bt6.fits");
        xhdu = (BinaryTableHDU)f.getHDU(1);
        Assert.assertEquals((String)"delcol4", (long)1L, (long)xhdu.getNCols());
    }

    @Test
    public void testDegenerate() throws Exception {
        String[] sa = new String[10];
        int[][] ia = new int[10][0];
        Fits f = new Fits();
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = "";
        }
        Object[] data = new Object[]{sa, ia};
        BinaryTableHDU bhdu = (BinaryTableHDU)Fits.makeHDU(data);
        Header hdr = bhdu.getHeader();
        f.addHDU(bhdu);
        BufferedFile bf = new BufferedFile("bt7.fits", "rw");
        f.write(bf);
        bf.close();
        Assert.assertEquals((String)"degen1", (long)2L, (long)hdr.getIntValue("TFIELDS"));
        Assert.assertEquals((String)"degen2", (long)10L, (long)hdr.getIntValue("NAXIS2"));
        Assert.assertEquals((String)"degen3", (long)0L, (long)hdr.getIntValue("NAXIS1"));
        f = new Fits("bt7.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        hdr = bhdu.getHeader();
        Assert.assertEquals((String)"degen4", (long)2L, (long)hdr.getIntValue("TFIELDS"));
        Assert.assertEquals((String)"degen5", (long)10L, (long)hdr.getIntValue("NAXIS2"));
        Assert.assertEquals((String)"degen6", (long)0L, (long)hdr.getIntValue("NAXIS1"));
    }

    @Test
    public void testDegen2() throws Exception {
        FitsFactory.setUseAsciiTables(false);
        Object[] data = new Object[]{new String[]{"a", "b", "c", "d", "e", "f"}, new int[]{1, 2, 3, 4, 5, 6}, new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f}, new String[]{"", "", "", "", "", ""}, new String[]{"a", "", "c", "", "e", "f"}, new String[]{"", "b", "c", "d", "e", "f"}, new String[]{"a", "b", "c", "d", "e", ""}, new String[]{null, null, null, null, null, null}, new String[]{"a", null, "c", null, "e", "f"}, new String[]{null, "b", "c", "d", "e", "f"}, new String[]{"a", "b", "c", "d", "e", null}};
        Fits f = new Fits();
        f.addHDU(Fits.makeHDU(data));
        BufferedFile ff = new BufferedFile("bt8.fits", "rw");
        f.write(ff);
        f = new Fits("bt8.fits");
        BinaryTableHDU bhdu = (BinaryTableHDU)f.getHDU(1);
        Assert.assertEquals((String)"deg21", (Object)"e", (Object)bhdu.getElement(4, data.length - 1));
        Assert.assertEquals((String)"deg22", (Object)"", (Object)bhdu.getElement(5, data.length - 1));
        String[] col = (String[])bhdu.getColumn(0);
        Assert.assertEquals((String)"deg23", (Object)"a", (Object)col[0]);
        Assert.assertEquals((String)"deg24", (Object)"f", (Object)col[5]);
        col = (String[])bhdu.getColumn(3);
        Assert.assertEquals((String)"deg25", (Object)"", (Object)col[0]);
        Assert.assertEquals((String)"deg26", (Object)"", (Object)col[5]);
        col = (String[])bhdu.getColumn(7);
        Assert.assertEquals((String)"deg27", (Object)"", (Object)col[0]);
        Assert.assertEquals((String)"deg28", (Object)"", (Object)col[5]);
        col = (String[])bhdu.getColumn(8);
        Assert.assertEquals((String)"deg29", (Object)"a", (Object)col[0]);
        Assert.assertEquals((String)"deg210", (Object)"", (Object)col[1]);
    }

    @Test
    public void testMultHDU() throws Exception {
        BinaryTableHDU hdu;
        BufferedFile ff = new BufferedFile("bt9.fits", "rw");
        Object[] data = new Object[]{this.bytes, this.bits, this.bools, this.shorts, this.ints, this.floats, this.doubles, this.longs, this.strings};
        Fits f = new Fits();
        f.addHDU(Fits.makeHDU(data));
        f.addHDU(Fits.makeHDU(data));
        f.write(ff);
        ff.close();
        f = new Fits("bt9.fits");
        f.readHDU();
        int count = 0;
        while ((hdu = (BinaryTableHDU)f.readHDU()) != null) {
            int nrow = hdu.getHeader().getIntValue("NAXIS2");
            ++count;
            Assert.assertEquals((long)nrow, (long)50L);
            for (int i = 0; i < nrow; ++i) {
                Object[] o = hdu.getRow(i);
            }
        }
        Assert.assertEquals((long)count, (long)2L);
    }

    @Test
    public void testByteArray() {
        String[] sarr = new String[]{"abc", " de", "f"};
        byte[] barr = new byte[]{97, 98, 99, 32, 98, 99, 97, 98, 32};
        byte[] obytes = FitsUtil.stringsToByteArray(sarr, 3);
        Assert.assertEquals((String)"blen", (long)obytes.length, (long)9L);
        Assert.assertEquals((String)"b1", (long)obytes[0], (long)97L);
        Assert.assertEquals((String)"b1", (long)obytes[1], (long)98L);
        Assert.assertEquals((String)"b1", (long)obytes[2], (long)99L);
        Assert.assertEquals((String)"b1", (long)obytes[3], (long)32L);
        Assert.assertEquals((String)"b1", (long)obytes[4], (long)100L);
        Assert.assertEquals((String)"b1", (long)obytes[5], (long)101L);
        Assert.assertEquals((String)"b1", (long)obytes[6], (long)102L);
        Assert.assertEquals((String)"b1", (long)obytes[7], (long)32L);
        Assert.assertEquals((String)"b1", (long)obytes[8], (long)32L);
        String[] ostrings = FitsUtil.byteArrayToStrings(barr, 3);
        Assert.assertEquals((String)"slen", (long)ostrings.length, (long)3L);
        Assert.assertEquals((String)"s1", (Object)ostrings[0], (Object)"abc");
        Assert.assertEquals((String)"s2", (Object)ostrings[1], (Object)"bc");
        Assert.assertEquals((String)"s3", (Object)ostrings[2], (Object)"ab");
    }

    @Test
    public void columnMetaTest() throws Exception {
        Object[] data = new Object[]{this.shorts, this.ints, this.floats, this.doubles};
        Fits f = new Fits();
        BinaryTableHDU bhdu = (BinaryTableHDU)Fits.makeHDU(data);
        f.addHDU(bhdu);
        int oldNCols = bhdu.getNCols();
        for (int i = 0; i < bhdu.getNCols(); ++i) {
            bhdu.setColumnMeta(i, "TTYPE", "NAM" + (i + 1), null, false);
            bhdu.setColumnMeta(i, "TCOMM", true, "Comment in comment", false);
            bhdu.setColumnMeta(i, "TUNIT", "UNIT" + (i + 1), null, true);
            bhdu.setColumnMeta(i, "TX", i + 1, (String)null, true);
            bhdu.setColumnMeta(i, "TY", 2.0 * (double)(i + 1), null, true);
        }
        BufferedFile ff = new BufferedFile("bt10.fits", "rw");
        f.write(ff);
        ff.close();
        f = new Fits("bt10.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        Header hdr = bhdu.getHeader();
        Assert.assertEquals((String)"metaCount", (long)oldNCols, (long)bhdu.getNCols());
        for (int i = 0; i < bhdu.getNCols(); ++i) {
            hdr.findCard("TTYPE" + (i + 1));
            HeaderCard hc = hdr.nextCard();
            Assert.assertEquals((String)("M" + i + "0"), (Object)("TTYPE" + (i + 1)), (Object)hc.getKey());
            hc = hdr.nextCard();
            Assert.assertEquals((String)("M" + i + "A"), (Object)("TCOMM" + (i + 1)), (Object)hc.getKey());
            hc = hdr.nextCard();
            Assert.assertEquals((String)("M" + i + "B"), (Object)("TFORM" + (i + 1)), (Object)hc.getKey());
            hc = hdr.nextCard();
            if (hc.getKey().startsWith("TDIM")) {
                hc = hdr.nextCard();
            }
            Assert.assertEquals((String)("M" + i + "C"), (Object)("TUNIT" + (i + 1)), (Object)hc.getKey());
            hc = hdr.nextCard();
            Assert.assertEquals((String)("M" + i + "D"), (Object)("TX" + (i + 1)), (Object)hc.getKey());
            hc = hdr.nextCard();
            Assert.assertEquals((String)("M" + i + "E"), (Object)("TY" + (i + 1)), (Object)hc.getKey());
        }
    }

    @Test
    public void specialStringsTest() throws Exception {
        int i;
        String[] strings = new String[]{"abc", "abc\u0000", "abc\nabc", "abc\u0000abc", "abc\u007f", "abc\u0001def\u0002ghi\u0003"};
        String[] results1 = new String[]{strings[0], strings[0], strings[2], strings[0], strings[4], strings[5]};
        String[] results2 = new String[]{strings[0], strings[0], "abc abc", strings[0], "abc ", "abc def ghi "};
        FitsFactory.setUseAsciiTables(false);
        FitsFactory.setCheckAsciiStrings(false);
        Fits f = new Fits();
        Object[] objs = new Object[]{strings};
        BinaryTableHDU bhdu = (BinaryTableHDU)Fits.makeHDU(objs);
        f.addHDU(bhdu);
        BufferedFile bf = new BufferedFile("bt11a.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("bt11a.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        String[] vals = (String[])bhdu.getColumn(0);
        for (i = 0; i < strings.length; ++i) {
            Assert.assertEquals((String)("ssa" + i), (Object)results1[i], (Object)vals[i]);
        }
        FitsFactory.setCheckAsciiStrings(true);
        System.err.println("  A warning about invalid ASCII strings should follow.");
        f = new Fits();
        bhdu = (BinaryTableHDU)Fits.makeHDU(objs);
        f.addHDU(bhdu);
        bf = new BufferedFile("bt11b.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("bt11b.fits");
        bhdu = (BinaryTableHDU)f.getHDU(1);
        vals = (String[])bhdu.getColumn(0);
        for (i = 0; i < strings.length; ++i) {
            Assert.assertEquals((String)("ssb" + i), (Object)results2[i], (Object)vals[i]);
        }
        FitsFactory.setCheckAsciiStrings(false);
    }
}

