/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.CloseIS;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.RandomAccess;

public class FitsUtil {
    private static boolean wroteCheckingError = false;

    public static void reposition(Object o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + "   Exception:" + e);
        }
    }

    public static long findOffset(Object o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static int padding(int size) {
        return FitsUtil.padding((long)size);
    }

    public static int padding(long size) {
        int mod = (int)(size % 2880L);
        if (mod > 0) {
            mod = 2880 - mod;
        }
        return mod;
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    public static long addPadding(long size) {
        return size + (long)FitsUtil.padding(size);
    }

    static InputStream decompress(InputStream compressed) throws FitsException {
        PushbackInputStream pb = new PushbackInputStream(compressed, 2);
        int mag1 = -1;
        int mag2 = -1;
        try {
            mag1 = pb.read();
            mag2 = pb.read();
            if (mag1 == 31 && mag2 == 139) {
                pb.unread(mag2);
                pb.unread(mag1);
                return new GZIPInputStream(pb);
            }
            if (mag1 == 31 && mag2 == 157) {
                pb.unread(mag2);
                pb.unread(mag1);
                return FitsUtil.compressInputStream(pb);
            }
            if (mag1 == 66 && mag2 == 90) {
                if (System.getenv("BZIP_DECOMPRESSOR") != null) {
                    pb.unread(mag2);
                    pb.unread(mag1);
                    return FitsUtil.bunzipper(pb);
                }
                String cname = "org.apache.tools.bzip2.CBZip2InputStream";
                try {
                    Constructor<?> con = Class.forName(cname).getConstructor(InputStream.class);
                    return (InputStream)con.newInstance(pb);
                }
                catch (Exception e) {
                    System.err.println("Unable to find constructor for BZIP2 decompression.  Is the Apache BZIP jar in the classpath?");
                    throw new FitsException("No CBZip2InputStream class found for bzip2 compressed file");
                }
            }
            pb.unread(mag2);
            pb.unread(mag1);
            return pb;
        }
        catch (IOException e) {
            throw new FitsException("Unable to analyze input stream");
        }
    }

    static InputStream compressInputStream(final InputStream compressed) throws FitsException {
        try {
            Process proc = new ProcessBuilder("uncompress", "-c").start();
            final OutputStream input = proc.getOutputStream();
            Thread copier = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = compressed.read(buffer, 0, buffer.length)) > 0) {
                            input.write(buffer, 0, len);
                        }
                        compressed.close();
                        input.close();
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            });
            copier.start();
            return proc.getInputStream();
        }
        catch (Exception e) {
            throw new FitsException("Unable to read .Z compressed stream.\nIs `uncompress' in the path?\n:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompressed(File test) {
        InputStream fis = null;
        try {
            if (test.exists()) {
                fis = new FileInputStream(test);
                int mag1 = fis.read();
                int mag2 = fis.read();
                fis.close();
                if (mag1 == 31 && (mag2 == 139 || mag2 == 157)) {
                    boolean bl = true;
                    return bl;
                }
                if (mag1 == 66 && mag2 == 90) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    public static boolean isCompressed(String filename) {
        if (filename == null) {
            return false;
        }
        Object fis = null;
        File test = new File(filename);
        if (test.exists()) {
            return FitsUtil.isCompressed(test);
        }
        int len = filename.length();
        return len > 2 && (filename.substring(len - 3).equalsIgnoreCase(".gz") || filename.substring(len - 2).equals(".Z"));
    }

    public static int maxLength(String[] o) throws FitsException {
        int max = 0;
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null || o[i].length() <= max) continue;
            max = o[i].length();
        }
        return max;
    }

    public static byte[] stringsToByteArray(String[] o, int maxLen) {
        byte[] res = new byte[o.length * maxLen];
        for (int i = 0; i < o.length; ++i) {
            byte[] bstr = null;
            bstr = o[i] == null ? new byte[]{} : AsciiFuncs.getBytes(o[i]);
            int cnt = bstr.length;
            if (cnt > maxLen) {
                cnt = maxLen;
            }
            System.arraycopy(bstr, 0, res, i * maxLen, cnt);
            for (int j = cnt; j < maxLen; ++j) {
                res[i * maxLen + j] = 32;
            }
        }
        return res;
    }

    public static String[] byteArrayToStrings(byte[] o, int maxLen) {
        boolean checking = FitsFactory.getCheckAsciiStrings();
        String[] res = new String[o.length / maxLen];
        for (int i = 0; i < res.length; ++i) {
            int start;
            int end = start + maxLen;
            for (start = i * maxLen; start < end && o[start] == 32; ++start) {
            }
            while (end > start && o[end - 1] == 32) {
                --end;
            }
            boolean errFound = false;
            for (int j = start; j < end; ++j) {
                if (o[j] == 0) {
                    end = j;
                    break;
                }
                if (!checking || o[j] >= 32 && o[j] <= 126) continue;
                errFound = true;
                o[j] = 32;
            }
            res[i] = AsciiFuncs.asciiString(o, start, end - start);
            if (!errFound || wroteCheckingError) continue;
            System.err.println("Warning: Invalid ASCII character[s] detected in string:" + res[i]);
            System.err.println("   Converted to space[s].  Any subsequent invalid characters will be converted silently");
            wroteCheckingError = true;
        }
        return res;
    }

    static byte[] booleanToByte(boolean[] bool) {
        byte[] byt = new byte[bool.length];
        for (int i = 0; i < bool.length; ++i) {
            byt[i] = bool[i] ? 84 : 70;
        }
        return byt;
    }

    static boolean[] byteToBoolean(byte[] byt) {
        boolean[] bool = new boolean[byt.length];
        for (int i = 0; i < byt.length; ++i) {
            bool[i] = byt[i] == 84;
        }
        return bool;
    }

    public static InputStream getURLStream(URL url, int level) throws IOException {
        if (level > 5) {
            throw new IOException("Two many levels of redirection in URL");
        }
        URLConnection conn = url.openConnection();
        Map<String, List<String>> hdrs = conn.getHeaderFields();
        String[] keys = hdrs.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String val;
            String key = keys[i];
            if (key == null || !key.toLowerCase().equals("location") || (val = hdrs.get(key).get(0)) == null || (val = val.trim()).length() <= 0) continue;
            return FitsUtil.getURLStream(new URL(val), level + 1);
        }
        return conn.getInputStream();
    }

    public static void pad(ArrayDataOutput stream, long size) throws FitsException {
        FitsUtil.pad(stream, size, (byte)0);
    }

    public static void pad(ArrayDataOutput stream, long size, byte fill) throws FitsException {
        int len = FitsUtil.padding(size);
        if (len > 0) {
            byte[] buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = fill;
            }
            try {
                stream.write(buf);
                stream.flush();
            }
            catch (Exception e) {
                throw new FitsException("Unable to write padding", e);
            }
        }
    }

    static InputStream bunzipper(final InputStream pb) throws FitsException {
        Thread t;
        OutputStream out;
        Process p;
        String cmd = System.getenv("BZIP_DECOMPRESSOR");
        if (cmd.indexOf(" -") < 0) {
            cmd = cmd + " -";
        }
        String[] flds = cmd.split(" +");
        try {
            p = new ProcessBuilder(flds).start();
            out = p.getOutputStream();
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int len;
                        byte[] buf = new byte[16384];
                        long total = 0L;
                        while ((len = pb.read(buf)) > 0) {
                            try {
                                out.write(buf, 0, len);
                            }
                            catch (Exception e) {
                                break;
                            }
                            total += (long)len;
                        }
                        pb.close();
                        out.close();
                    }
                    catch (IOException e) {
                        throw new Error("Error reading BZIP compression using: " + System.getenv("BZIP_DECOMPRESSOR"), e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new FitsException("Error initiating BZIP decompression: " + e);
        }
        t.start();
        return new CloseIS(p.getInputStream(), pb, out);
    }
}

