/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.UndefinedHDU;

public class FitsFactory {
    private static boolean useAsciiTables = true;
    private static boolean useHierarch = false;
    private static boolean checkAsciiStrings = false;
    private static boolean allowTerminalJunk = false;

    public static void setUseAsciiTables(boolean flag) {
        useAsciiTables = flag;
    }

    static boolean getUseAsciiTables() {
        return useAsciiTables;
    }

    public static void setUseHierarch(boolean flag) {
        useHierarch = flag;
    }

    public static void setCheckAsciiStrings(boolean flag) {
        checkAsciiStrings = flag;
    }

    static boolean getCheckAsciiStrings() {
        return checkAsciiStrings;
    }

    public static boolean getUseHierarch() {
        return useHierarch;
    }

    public static void setAllowTerminalJunk(boolean flag) {
        allowTerminalJunk = flag;
    }

    public static boolean getAllowTerminalJunk() {
        return allowTerminalJunk;
    }

    public static Data dataFactory(Header hdr) throws FitsException {
        if (ImageHDU.isHeader(hdr)) {
            Data d = ImageHDU.manufactureData(hdr);
            hdr.afterExtend();
            return d;
        }
        if (RandomGroupsHDU.isHeader(hdr)) {
            return RandomGroupsHDU.manufactureData(hdr);
        }
        if (useAsciiTables && AsciiTableHDU.isHeader(hdr)) {
            return AsciiTableHDU.manufactureData(hdr);
        }
        if (BinaryTableHDU.isHeader(hdr)) {
            return BinaryTableHDU.manufactureData(hdr);
        }
        if (UndefinedHDU.isHeader(hdr)) {
            return UndefinedHDU.manufactureData(hdr);
        }
        throw new FitsException("Unrecognizable header in dataFactory");
    }

    public static BasicHDU HDUFactory(Object o) throws FitsException {
        Data d;
        Header h;
        if (o instanceof Header) {
            h = (Header)o;
            d = FitsFactory.dataFactory(h);
        } else if (ImageHDU.isData(o)) {
            d = ImageHDU.encapsulate(o);
            h = ImageHDU.manufactureHeader(d);
        } else if (RandomGroupsHDU.isData(o)) {
            d = RandomGroupsHDU.encapsulate(o);
            h = RandomGroupsHDU.manufactureHeader(d);
        } else if (useAsciiTables && AsciiTableHDU.isData(o)) {
            d = AsciiTableHDU.encapsulate(o);
            h = AsciiTableHDU.manufactureHeader(d);
        } else if (BinaryTableHDU.isData(o)) {
            d = BinaryTableHDU.encapsulate(o);
            h = BinaryTableHDU.manufactureHeader(d);
        } else if (UndefinedHDU.isData(o)) {
            d = UndefinedHDU.encapsulate(o);
            h = UndefinedHDU.manufactureHeader(d);
        } else {
            throw new FitsException("Invalid data presented to HDUFactory");
        }
        return FitsFactory.HDUFactory(h, d);
    }

    public static BasicHDU HDUFactory(Header hdr, Data d) throws FitsException {
        if (d instanceof ImageData) {
            return new ImageHDU(hdr, d);
        }
        if (d instanceof RandomGroupsData) {
            return new RandomGroupsHDU(hdr, d);
        }
        if (d instanceof AsciiTable) {
            return new AsciiTableHDU(hdr, d);
        }
        if (d instanceof BinaryTable) {
            return new BinaryTableHDU(hdr, d);
        }
        if (d instanceof UndefinedData) {
            return new UndefinedHDU(hdr, d);
        }
        return null;
    }
}

