/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    private final Class<T> enumType;

    public EnumOptionHandler(CmdLineParser parser, Option option, Setter<? super T> setter, Class<T> enumType) {
        super(parser, option, setter);
        this.enumType = enumType;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String s = params.getParameter(0);
        Enum value = null;
        for (Enum o : (Enum[])this.enumType.getEnumConstants()) {
            if (!o.name().equalsIgnoreCase(s)) continue;
            value = o;
            break;
        }
        if (value == null) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(params.getOptionName(), s));
        }
        this.setter.addValue(value);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        String n = this.enumType.getName();
        int idx = n.lastIndexOf(46);
        if (idx >= 0) {
            n = n.substring(idx + 1);
        }
        return n.toUpperCase();
    }
}

