/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer.util;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtil {
    public static final EnumSet<ElementKind> OUTLINE_WORTHY_ELEMENT = EnumSet.of(ElementKind.ANNOTATION_TYPE, new ElementKind[]{ElementKind.CLASS, ElementKind.CONSTRUCTOR, ElementKind.ENUM, ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.INSTANCE_INIT, ElementKind.INTERFACE, ElementKind.METHOD, ElementKind.STATIC_INIT, ElementKind.PACKAGE});
    public static final EnumSet<Tree.Kind> OUTLINE_WORTHY_TREE = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

    public static boolean isType(Element e) {
        if (e == null) {
            return false;
        }
        switch (e.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                TypeKind kind = e.asType().getKind();
                return !kind.isPrimitive() && kind != TypeKind.VOID;
            }
        }
        return false;
    }

    public static String getPackageName(CompilationUnitTree cu) {
        ExpressionTree packageName = cu.getPackageName();
        if (packageName == null) {
            return "";
        }
        return packageName.toString();
    }

    public static String getFullMethodName(Types types, ExecutableElement e) {
        return TreeUtil.buildMethodName(new StringBuilder(), types, e).toString();
    }

    public static StringBuilder buildMethodName(StringBuilder buf, Types types, ExecutableElement e) {
        buf.append(e.getSimpleName()).append('(');
        boolean first = true;
        List<? extends VariableElement> parameters = TreeUtil.safeGetParameters(e);
        for (VariableElement variableElement : parameters) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(types.erasure(variableElement.asType()));
        }
        return buf.append(')');
    }

    private static List<? extends VariableElement> safeGetParameters(ExecutableElement e) {
        try {
            return e.getParameters();
        }
        catch (Exception _) {
            return Collections.emptyList();
        }
    }

    public static Element getElement(Tree t) {
        Element r = TreeUtil.getElement((JCTree)t);
        if (r != null && r.asType() != null && r.asType().getKind().isPrimitive()) {
            return null;
        }
        return r;
    }

    private static Element getElement(JCTree t) {
        t = TreeInfo.skipParens(t);
        switch (t.tag) {
            case 3: {
                return ((JCTree.JCClassDecl)t).sym;
            }
            case 4: {
                return ((JCTree.JCMethodDecl)t).sym;
            }
            case 5: {
                return ((JCTree.JCVariableDecl)t).sym;
            }
            case 34: {
                return ((JCTree.JCFieldAccess)t).sym;
            }
            case 26: {
                return TreeUtil.getElement(((JCTree.JCMethodInvocation)t).meth);
            }
            case 35: {
                return ((JCTree.JCIdent)t).sym;
            }
            case 27: {
                return ((JCTree.JCNewClass)t).constructor;
            }
        }
        return null;
    }

    public static boolean isLocal(Element e) {
        for (e = e.getEnclosingElement(); e != null; e = e.getEnclosingElement()) {
            switch (e.getKind()) {
                case CONSTRUCTOR: 
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: 
                case INSTANCE_INIT: 
                case STATIC_INIT: {
                    return true;
                }
                case PACKAGE: {
                    return false;
                }
            }
        }
        return false;
    }

    public static String getPrimaryTypeName(CompilationUnitTree cu) {
        String name = cu.getSourceFile().getName();
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        if ((idx = name.lastIndexOf(92)) >= 0) {
            name = name.substring(idx + 1);
        }
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }
}

