/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer.util;

import java.io.PrintWriter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonWriter {
    private final PrintWriter w;
    private boolean first = true;
    private int indentLevel = 0;
    private static final boolean INDENT = JsonWriter.initIndent();

    public JsonWriter(PrintWriter w) {
        this.w = w;
    }

    private void nl(int diff) {
        if (!INDENT) {
            return;
        }
        this.w.println();
        this.indentLevel += diff;
        for (int i = 0; i < this.indentLevel; ++i) {
            this.w.print("  ");
        }
    }

    private void sep() {
        if (this.first) {
            this.first = false;
        } else {
            this.w.print(',');
            this.nl(0);
        }
    }

    private void quote(Object value) {
        this.w.print('\"');
        this.w.print(value);
        this.w.print('\"');
    }

    public JsonWriter startArray() {
        this.sep();
        this.w.print('[');
        this.nl(1);
        this.first = true;
        return this;
    }

    public JsonWriter endArray() {
        this.nl(-1);
        this.w.print(']');
        this.first = false;
        return this;
    }

    public JsonWriter startObject() {
        this.sep();
        this.w.print('{');
        this.nl(1);
        this.first = true;
        return this;
    }

    public JsonWriter endObject() {
        this.nl(-1);
        this.w.print('}');
        this.first = false;
        return this;
    }

    public JsonWriter property(String key, Collection<? extends Writable> values) {
        this.key(key);
        this.startArray();
        for (Writable writable : values) {
            this.startObject();
            writable.write(this);
            this.endObject();
        }
        return this.endArray();
    }

    public JsonWriter propertyUnquoted(String key, Object value) {
        this.key_(key);
        this.w.print(value);
        return this;
    }

    public JsonWriter property(String key, Writable value) {
        this.key(key);
        this.object(value);
        return this;
    }

    public JsonWriter property(String key, Object value) {
        this.key_(key);
        this.quote(value);
        return this;
    }

    public JsonWriter property(String key, boolean value) {
        this.key_(key);
        this.w.print(value);
        return this;
    }

    public JsonWriter property(String key, int value) {
        this.key_(key);
        this.w.print(value);
        return this;
    }

    public JsonWriter property(String key, long value) {
        this.key_(key);
        this.w.print(value);
        return this;
    }

    public JsonWriter key(String key) {
        this.sep();
        this.quote(key);
        this.w.print(':');
        this.first = true;
        return this;
    }

    private void key_(String key) {
        this.key(key);
        this.first = false;
    }

    public JsonWriter object(String str) {
        this.sep();
        this.quote(str);
        return this;
    }

    public JsonWriter object(int n) {
        this.sep();
        this.w.print(n);
        return this;
    }

    public JsonWriter object(Writable root) {
        this.startObject();
        root.write(this);
        return this.endObject();
    }

    static boolean initIndent() {
        try {
            return Boolean.getBoolean("sorcerer.debug");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static interface Writable {
        public void write(JsonWriter var1);
    }
}

