/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.jvnet.sorcerer.Analyzer;

public final class IOUtil {
    public static void copy(File input, File output) throws IOException {
        IOUtil.copy(new FileInputStream(input), output);
    }

    public static void copy(String resourceName, File output) throws IOException {
        InputStream i = Analyzer.class.getResourceAsStream(resourceName);
        IOUtil.copy(i, output);
    }

    public static void copy(InputStream i, File output) throws IOException {
        int len;
        FileOutputStream o = new FileOutputStream(output);
        byte[] buf = new byte[4096];
        while ((len = i.read(buf)) >= 0) {
            ((OutputStream)o).write(buf, 0, len);
        }
        i.close();
        ((OutputStream)o).close();
    }

    public static String readFully(InputStream i) throws IOException {
        int len;
        StringBuilder b = new StringBuilder();
        InputStreamReader r = new InputStreamReader(i);
        char[] buf = new char[4096];
        while ((len = r.read(buf)) >= 0) {
            b.append(buf, 0, len);
        }
        i.close();
        return b.toString();
    }
}

