/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jvnet.sorcerer.Analyzer;
import org.jvnet.sorcerer.Dependency;
import org.jvnet.sorcerer.FrameSetGenerator;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.util.DiagnosticPrinter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    @Argument
    List<String> files = new ArrayList<String>();
    @Option(name="-d", usage="Directory to write all HTML files")
    File outDir;
    @Option(name="-css", usage="CSS file to be used instead of the default one")
    File userCss;
    @Option(name="-javadoc", usage="Link to external javadoc")
    List<String> javadocs = new ArrayList<String>();
    @Option(name="-cp", usage="Classpath for analyzing source file")
    List<String> paths = new ArrayList<String>();
    @Option(name="-jarpath", usage="Path for recursively scanning *.jar")
    List<String> jarpaths = new ArrayList<String>();
    @Option(name="-auto", usage="Automatically scan jar files and source files.\nSpecify the project root directory as the argument.")
    boolean auto = false;
    @Option(name="-debug", usage="Produce output with debug information")
    boolean debug = false;
    private static final Set<String> IGNORABLE = new HashSet<String>(Arrays.asList("CVS", ".svn", "classes", "test-classes"));

    public static void main(String[] args) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokens = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            urls.add(new File(tokens.nextToken()).toURI().toURL());
        }
        urls.add(new File(new File(System.getProperty("java.home")), "../lib/tools.jar").toURI().toURL());
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        Thread.currentThread().setContextClassLoader(cl);
        Class<?> main = cl.loadClass(Main.class.getName());
        try {
            System.exit((Integer)main.getMethod("doMain", String[].class).invoke(null, new Object[]{args}));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw e;
        }
    }

    public static int doMain(String[] args) throws Exception {
        Main m = new Main();
        CmdLineParser p = new CmdLineParser(m);
        try {
            p.parseArgument(args);
            if (m.files.isEmpty()) {
                Main.printUsage(p, System.err);
                return -1;
            }
            m.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            Main.printUsage(p, System.err);
            return -1;
        }
        return 0;
    }

    private static void printUsage(CmdLineParser p, PrintStream out) {
        out.println("Sorcerer: Java source code cross-reference generator");
        out.println("Usage: sorcerer [<options>...] <src files/dirs>... ");
        p.printUsage(out);
    }

    private void run() throws IOException, CmdLineException {
        if (this.debug) {
            System.setProperty("sorcerer.debug", "true");
        }
        Analyzer a = new Analyzer();
        for (String f : this.files) {
            File file = new File(f);
            if (!file.exists()) {
                throw new CmdLineException("No such file nor directory exists: " + file);
            }
            if (file.isDirectory()) {
                if (this.auto) {
                    this.autoScan(file, a);
                    continue;
                }
                a.addSourceFolder(file);
                continue;
            }
            a.addSourceFile(file);
        }
        for (String path : this.paths) {
            StringTokenizer tokens = new StringTokenizer(path, File.pathSeparator);
            while (tokens.hasMoreTokens()) {
                a.addClasspath(new File(tokens.nextToken()));
            }
        }
        for (String lib : this.jarpaths) {
            this.jarScan(new File(lib), a);
        }
        ParsedSourceSet pss = a.analyze(new DiagnosticPrinter());
        this.addDependency(pss.getDependencies());
        new FrameSetGenerator(pss).generateAll(this.outDir);
    }

    private void autoScan(File f, Analyzer a) {
        File[] files;
        String name = f.getName();
        if (IGNORABLE.contains(name)) {
            return;
        }
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                this.autoScan(file, a);
            }
        }
        if (name.endsWith(".jar")) {
            a.addClasspath(f);
            return;
        }
        if (name.endsWith(".java")) {
            a.addSourceFile(f);
        }
    }

    private void jarScan(File f, Analyzer a) {
        File[] files;
        String name = f.getName();
        if (IGNORABLE.contains(name)) {
            return;
        }
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                this.jarScan(file, a);
            }
        }
        if (name.endsWith(".jar")) {
            a.addClasspath(f);
        }
    }

    private void addDependency(List<Dependency> dependencies) throws IOException {
        for (String url : this.javadocs) {
            dependencies.add(new Dependency.Javadoc(url, new URL(url)));
        }
    }
}

