/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer.ant;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.jvnet.sorcerer.Analyzer;
import org.jvnet.sorcerer.Dependency;
import org.jvnet.sorcerer.FrameSetGenerator;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.ant.Javadoc;
import org.jvnet.sorcerer.util.DiagnosticPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SorcererTask
extends MatchingTask {
    private File dir;
    private File destDir;
    private String encoding;
    private String windowTitle;
    private int tabWidth = 8;
    private final List<Javadoc> javadocs = new ArrayList<Javadoc>();
    private Path classpath = new Path(null);

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setSrcdir(File srcdir) {
        this.dir = srcdir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addJavadoc(Javadoc j) {
        this.javadocs.add(j);
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void execute() throws BuildException {
        try {
            this.classpath.setProject(this.getProject());
            Analyzer a = new Analyzer();
            if (this.encoding != null) {
                a.setSourceEncoding(this.encoding);
            }
            DirectoryScanner ds = this.getDirectoryScanner(this.dir);
            for (String f : ds.getIncludedFiles()) {
                a.addSourceFile(new File(this.dir, f));
            }
            for (String p : this.classpath.list()) {
                a.addClasspath(this.getProject().resolveFile(p));
            }
            a.setTabWidth(this.tabWidth);
            ParsedSourceSet pss = a.analyze(new DiagnosticPrinter());
            this.addDependencies(pss.getDependencies());
            FrameSetGenerator fsg = new FrameSetGenerator(pss);
            if (this.windowTitle != null) {
                fsg.setTitle(this.windowTitle);
            }
            fsg.generateAll(this.destDir);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void addDependencies(List<Dependency> dependencies) throws IOException {
        for (Javadoc j : this.javadocs) {
            dependencies.add(new Dependency.Javadoc(j.getTitle(), new URL(j.getHref()), j.getPackageList()));
        }
    }
}

