/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import antlr.Token;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jvnet.sorcerer.JavaScriptStreamWriter;
import org.jvnet.sorcerer.ParsedType;
import org.jvnet.sorcerer.ReservedWords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tag
implements Iterable<Tag>,
Comparable<Tag> {
    final long sp;
    final long ep;
    Tag firstChild;
    Tag nextSibling;

    protected Tag(long sp, long ep) {
        this.sp = sp;
        this.ep = ep;
    }

    protected Tag(LineMap lineMap, Token t) {
        this.sp = lineMap.getPosition(t.getLine(), t.getColumn());
        this.ep = this.sp + (long)t.getText().length();
    }

    protected Tag(CompilationUnitTree unitTree, SourcePositions srcPos, Tree r) {
        this.sp = srcPos.getStartPosition(unitTree, r);
        this.ep = srcPos.getEndPosition(unitTree, r);
    }

    @Override
    public Iterator<Tag> iterator() {
        return new Iterator<Tag>(){
            Tag next;
            {
                this.next = Tag.this.firstChild;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Tag next() {
                Tag r = this.next;
                this.next = this.next.nextSibling;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final int compareTo(Tag that) {
        long r = this.sp - that.sp;
        if (r != 0L) {
            return this.sign(r);
        }
        r = that.ep - this.ep;
        return this.sign(r);
    }

    private int sign(long r) {
        if (r > 0L) {
            return 1;
        }
        if (r < 0L) {
            return -1;
        }
        return 0;
    }

    abstract void write(JavaScriptStreamWriter var1);

    protected final void writeChildren(String functionName, JavaScriptStreamWriter w) {
        w.beginMethod(functionName);
        for (Tag t : this) {
            t.write(w);
        }
        w.endMethod();
    }

    public void collectSymbols(JavaScriptStreamWriter w) {
        for (Tag t : this) {
            t.collectSymbols(w);
        }
    }

    public static final class Root
    extends Tag {
        public Root(long length) {
            super(0L, length);
        }

        void write(JavaScriptStreamWriter w) {
            this.writeChildren("classDef", w);
        }
    }

    public static final class MethodRef
    extends Tag {
        private final ExecutableElement method;

        public MethodRef(long sp, long ep, ExecutableElement method) {
            super(sp, ep);
            this.method = method;
        }

        public void collectSymbols(JavaScriptStreamWriter w) {
            w.collect(this.method);
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild.nextSibling == null);
            w.beginMethod("N");
            w.ref(this.method);
            w.endMethod();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MethodDecl
    extends Tag {
        private final Set<ParsedType.Match> overridden;
        private final Set<ParsedType.Match> overriding;
        private final ExecutableElement method;

        public MethodDecl(CompilationUnitTree unitTree, SourcePositions srcPos, MethodTree r, ExecutableElement e, Set<ParsedType.Match> overridden, Set<ParsedType.Match> overriding) {
            super(unitTree, srcPos, r);
            this.method = e;
            this.overridden = overridden;
            this.overriding = overriding;
        }

        @Override
        public void collectSymbols(JavaScriptStreamWriter w) {
            w.collect(this.method);
            this.collectSet(w, this.overridden);
            this.collectSet(w, this.overriding);
            super.collectSymbols(w);
        }

        private void collectSet(JavaScriptStreamWriter w, Set<ParsedType.Match> ms) {
            for (ParsedType.Match m : ms) {
                w.collect(m.method);
            }
        }

        @Override
        void write(JavaScriptStreamWriter w) {
            w.beginMethod("M");
            w.ref(this.method);
            this.writeSet(w, this.overridden);
            this.writeSet(w, this.overriding);
            this.writeChildren("$", w);
            w.endMethod();
        }

        private void writeSet(JavaScriptStreamWriter w, Set<ParsedType.Match> ms) {
            w.beginArray();
            for (ParsedType.Match m : ms) {
                w.ref(m.method);
            }
            w.endArray();
        }
    }

    public static final class LocalVarRef
    extends Tag {
        private final VariableElement decl;

        public LocalVarRef(CompilationUnitTree unitTree, SourcePositions srcPos, Tree r, VariableElement decl) {
            super(unitTree, srcPos, r);
            this.decl = decl;
        }

        public LocalVarRef(long sp, long ep, VariableElement decl) {
            super(sp, ep);
            this.decl = decl;
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild.nextSibling == null);
            w.beginMethod("W");
            w.ref(this.decl);
            w.endMethod();
        }
    }

    public static final class LocalVarDecl
    extends Tag {
        private final VariableElement var;

        public LocalVarDecl(CompilationUnitTree cu, SourcePositions srcPos, VariableTree vt, VariableElement var) {
            super(cu, srcPos, vt);
            this.var = var;
        }

        public LocalVarDecl(LineMap lineMap, Token t, VariableElement var) {
            super(lineMap, t);
            this.var = var;
        }

        public void collectSymbols(JavaScriptStreamWriter w) {
            super.collectSymbols(w);
            w.collect(this.var);
        }

        void write(JavaScriptStreamWriter w) {
            w.beginMethod("V");
            w.ref(this.var);
            this.writeChildren("$", w);
            w.endMethod();
        }
    }

    public static final class FieldRef
    extends Tag {
        private final VariableElement decl;

        public FieldRef(CompilationUnitTree unitTree, SourcePositions srcPos, Tree r, VariableElement decl) {
            super(unitTree, srcPos, r);
            this.decl = decl;
        }

        public FieldRef(long sp, long ep, VariableElement decl) {
            super(sp, ep);
            this.decl = decl;
        }

        public void collectSymbols(JavaScriptStreamWriter w) {
            w.collect(this.decl.getEnclosingElement());
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild.nextSibling == null);
            w.beginMethod("G");
            w.ref((TypeElement)this.decl.getEnclosingElement());
            w.writeModifiers(this.decl);
            w.sep();
            w.string(this.decl.getSimpleName());
            w.endMethod();
        }
    }

    public static final class FieldDecl
    extends Tag {
        public FieldDecl(CompilationUnitTree cu, SourcePositions srcPos, VariableTree vt) {
            super(cu, srcPos, vt);
        }

        public FieldDecl(LineMap lineMap, Token t) {
            super(lineMap, t);
        }

        void write(JavaScriptStreamWriter w) {
            this.writeChildren("F", w);
        }
    }

    public static final class TypeRef
    extends Tag {
        private final TypeElement type;

        public TypeRef(CompilationUnitTree unitTree, SourcePositions srcPos, Tree r, TypeElement type) {
            super(unitTree, srcPos, r);
            this.type = type;
        }

        public TypeRef(long sp, long ep, TypeElement type) {
            super(sp, ep);
            this.type = type;
        }

        public void collectSymbols(JavaScriptStreamWriter w) {
            w.collect(this.type);
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild.nextSibling == null);
            w.beginMethod("T");
            w.ref(this.type);
            w.endMethod();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassDecl
    extends Tag {
        private final TypeElement type;
        private final List<ParsedType> descendants;

        public ClassDecl(CompilationUnitTree unitTree, SourcePositions srcPos, ClassTree ct, TypeElement e, List<ParsedType> descendants) {
            super(unitTree, srcPos, ct);
            this.type = e;
            this.descendants = descendants;
        }

        @Override
        void write(JavaScriptStreamWriter w) {
            w.beginMethod("C");
            w.ref(this.type);
            w.beginArray();
            for (ParsedType d : this.descendants) {
                w.ref(d.element);
            }
            w.endArray();
            this.writeChildren("$", w);
            w.endMethod();
        }

        @Override
        public void collectSymbols(JavaScriptStreamWriter w) {
            w.collect(this.type);
            for (ParsedType d : this.descendants) {
                w.collect(d.element);
            }
            super.collectSymbols(w);
        }
    }

    public static final class DeclName
    extends Tag {
        Token debug;

        public DeclName(LineMap m, Token token) {
            super(m, token);
            this.debug = token;
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild.nextSibling == null);
            w.beginMethod("I");
            this.firstChild.write(w);
            w.endMethod();
        }
    }

    public static final class Literal
    extends Tag {
        public Literal(CompilationUnitTree unitTree, SourcePositions srcPos, Tree r) {
            super(unitTree, srcPos, r);
        }

        void write(JavaScriptStreamWriter w) {
            this.writeChildren("L", w);
        }
    }

    public static final class SourceText
    extends Tag {
        private final String text;

        public SourceText(long sp, long ep, String text) {
            super(sp, ep);
            this.text = text;
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild == null);
            if (this.text.equals(" ")) {
                w.sep().print("_");
                return;
            }
            StringBuilder buf = new StringBuilder();
            int len = this.text.length();
            block8: for (int i = 0; i < len; ++i) {
                char ch = this.text.charAt(i);
                switch (ch) {
                    case '\r': {
                        if (i != len - 1 && this.text.charAt(i + 1) == '\n') continue block8;
                    }
                    case '\n': {
                        if (buf.length() > 0) {
                            w.sep();
                            w.string(buf);
                            buf.setLength(0);
                        }
                        w.sep();
                        w.print("nl");
                        continue block8;
                    }
                    case ' ': {
                        int j;
                        for (j = i; j < len && this.text.charAt(j) == ' '; ++j) {
                        }
                        int k = j - i;
                        if (k >= 4) {
                            if (buf.length() > 0) {
                                w.sep();
                                w.string(buf);
                                buf.setLength(0);
                            }
                            w.sep();
                            w.print("w(");
                            w.print(k);
                            w.print(")");
                        } else {
                            while (j > i) {
                                buf.append(' ');
                                --j;
                            }
                        }
                        i += k - 1;
                        continue block8;
                    }
                    case '\t': {
                        throw new IllegalStateException();
                    }
                    case '<': {
                        buf.append("&lt;");
                        continue block8;
                    }
                    case '&': {
                        buf.append("&amp;");
                        continue block8;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            if (buf.length() > 0) {
                w.sep();
                w.string(buf);
                buf.setLength(0);
            }
        }
    }

    public static final class Killer
    extends Tag {
        public Killer(LineMap lineMap, Token t) {
            super(lineMap, t);
        }

        void write(JavaScriptStreamWriter w) {
        }
    }

    public static final class Parenthesis
    extends Tag {
        public Parenthesis(long sp, long ep) {
            super(sp, ep);
        }

        void write(JavaScriptStreamWriter w) {
            this.writeChildren("P", w);
        }
    }

    public static final class CurlyBracket
    extends Tag {
        public CurlyBracket(long sp, long ep) {
            super(sp, ep);
        }

        void write(JavaScriptStreamWriter w) {
            this.writeChildren("B", w);
        }
    }

    public static final class Comment
    extends Tag {
        public Comment(LineMap lineMap, Token t) {
            super(lineMap, t);
        }

        void write(JavaScriptStreamWriter w) {
            this.writeChildren("O", w);
        }
    }

    public static final class ReservedWord
    extends Tag {
        private final String token;

        public ReservedWord(LineMap lineMap, Token t) {
            super(lineMap, t);
            this.token = t.getText();
        }

        void write(JavaScriptStreamWriter w) {
            assert (this.firstChild.nextSibling == null);
            String t = ReservedWords.TOKENMAP.get(this.token);
            assert (t != null);
            w.sep().print(t);
        }
    }
}

