/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.jvnet.sorcerer.ClosedHashMultiMap;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.RefererFinder;
import org.jvnet.sorcerer.util.TreeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParsedType
extends ClosedHashMultiMap<Name, ExecutableElement> {
    public final TypeElement element;
    public final ParsedType superClass;
    public final ParsedType[] interfaces;
    public final List<ParsedType> descendants = new ArrayList<ParsedType>();
    CompilationUnitTree[] referers = EMPTY_CUT_ARRAY;
    private static final ParsedType[] EMPTY_ARRAY = new ParsedType[0];
    private static final CompilationUnitTree[] EMPTY_CUT_ARRAY = new CompilationUnitTree[0];

    public ParsedType(ParsedSourceSet pss, TypeElement element) {
        pss.parsedTypes.put(element, this);
        this.element = element;
        TypeMirror sc = element.getSuperclass();
        switch (sc.getKind()) {
            case NONE: 
            case ERROR: {
                this.superClass = null;
                break;
            }
            case DECLARED: {
                this.superClass = pss.getParsedType((TypeElement)((DeclaredType)sc).asElement());
                this.superClass.descendants.add(this);
                break;
            }
            default: {
                throw new IllegalStateException("invalid super class: " + ((Object)sc).toString());
            }
        }
        List<? extends TypeMirror> intf = element.getInterfaces();
        if (intf.isEmpty()) {
            this.interfaces = EMPTY_ARRAY;
        } else {
            this.interfaces = new ParsedType[intf.size()];
            int i = 0;
            for (TypeMirror typeMirror : intf) {
                ParsedType pt = pss.getParsedType((TypeElement)((DeclaredType)typeMirror).asElement());
                pt.descendants.add(this);
                this.interfaces[i++] = pt;
            }
        }
        this.putAll(ElementFilter.methodsIn(pss.getElements().getAllMembers(element)));
    }

    public String getPackageLocalName() {
        if (this.element.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            return this.element.getSimpleName().toString();
        }
        return ParsedType.buildPackageLocalName(this.element, new StringBuilder()).toString();
    }

    private static StringBuilder buildPackageLocalName(Element e, StringBuilder buf) {
        Element p = e.getEnclosingElement();
        if (p.getKind() != ElementKind.PACKAGE) {
            ParsedType.buildPackageLocalName(p, buf);
        }
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(e.getSimpleName());
        return buf;
    }

    public boolean isLocal() {
        return TreeUtil.isLocal(this.element);
    }

    public boolean isInvalid() {
        String s = this.element.getQualifiedName().toString();
        for (int i = s.length() - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '.') continue;
            return true;
        }
        return false;
    }

    public Set<Match> findOverriddenMethods(Elements elements, ExecutableElement e) {
        QueryResult r = new QueryResult(elements, e);
        r.scanAncestors(this);
        return r.result;
    }

    public Set<Match> findOverridingMethods(Elements elements, ExecutableElement e) {
        QueryResult r = new QueryResult(elements, e);
        r.scanDescendants(this);
        return r.result;
    }

    public CompilationUnitTree[] getReferers() {
        return this.referers;
    }

    public Map<Element, Set<TreePath>> findReferers() {
        return RefererFinder.find(this);
    }

    @Override
    protected Name getKey(ExecutableElement value) {
        return value.getSimpleName();
    }

    public static final class Match {
        public final ParsedType owner;
        public final ExecutableElement method;

        public Match(ParsedType owner, ExecutableElement method) {
            this.owner = owner;
            this.method = method;
        }

        public boolean equals(Object o) {
            Match that = (Match)o;
            return this.method.equals(that.method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }
    }

    private static final class QueryResult {
        private final Set<ParsedType> visited = new HashSet<ParsedType>();
        private final Set<Match> result = new HashSet<Match>();
        private final Elements elements;
        private final TypeElement owner;
        private final ExecutableElement method;

        public QueryResult(Elements elements, ExecutableElement method) {
            this.elements = elements;
            this.owner = (TypeElement)method.getEnclosingElement();
            this.method = method;
        }

        private void scanOverridden(ParsedType t) {
            if (!this.visited.add(t)) {
                return;
            }
            block0: for (ExecutableElement m : t.get(t.getKey(this.method))) {
                if (!this.elements.overrides(this.method, m, this.owner)) continue;
                Iterator<Match> itr = this.result.iterator();
                while (itr.hasNext()) {
                    Match r = itr.next();
                    if (this.elements.overrides(r.method, m, this.owner)) continue block0;
                    if (!this.elements.overrides(m, r.method, this.owner)) continue;
                    itr.remove();
                }
                this.result.add(new Match(t, m));
            }
            this.scanAncestors(t);
        }

        void scanAncestors(ParsedType t) {
            if (t.superClass != null) {
                this.scanOverridden(t.superClass);
            }
            for (ParsedType i : t.interfaces) {
                this.scanOverridden(i);
            }
        }

        private void scanOverriding(ParsedType t) {
            if (!this.visited.add(t)) {
                return;
            }
            block0: for (ExecutableElement m : t.get(t.getKey(this.method))) {
                if (!this.elements.overrides(m, this.method, t.element)) continue;
                Iterator<Match> itr = this.result.iterator();
                while (itr.hasNext()) {
                    Match r = itr.next();
                    if (this.elements.overrides(m, r.method, t.element)) continue block0;
                    if (!this.elements.overrides(r.method, m, this.owner)) continue;
                    itr.remove();
                }
                this.result.add(new Match(t, m));
            }
            this.scanDescendants(t);
        }

        void scanDescendants(ParsedType t) {
            for (ParsedType i : t.descendants) {
                this.scanOverriding(i);
            }
        }
    }
}

