/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;
import org.jvnet.sorcerer.ShortNameVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutlineNameVisitor
extends SimpleElementVisitor6<String, Void> {
    public static final OutlineNameVisitor INSTANCE = new OutlineNameVisitor();

    private OutlineNameVisitor() {
    }

    @Override
    public String visitType(TypeElement t, Void _) {
        return t.getSimpleName().toString();
    }

    @Override
    public String visitVariable(VariableElement v, Void _) {
        return v.getSimpleName().toString();
    }

    @Override
    public String visitExecutable(ExecutableElement e, Void _) {
        StringBuilder buf = new StringBuilder();
        if (e.getKind() == ElementKind.CONSTRUCTOR) {
            buf.append(e.getEnclosingElement().getSimpleName());
        } else {
            buf.append(e.getSimpleName());
        }
        buf.append('(');
        boolean first = true;
        for (VariableElement variableElement : e.getParameters()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(variableElement.asType().accept(ShortNameVisitor.INSTANCE, null));
        }
        buf.append(')');
        if (e.getKind() != ElementKind.CONSTRUCTOR) {
            buf.append(':');
            buf.append(e.getReturnType().accept(ShortNameVisitor.INSTANCE, null));
        }
        return buf.toString();
    }
}

