/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.util.TreePath;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.jvnet.sorcerer.AbstractWriter;
import org.jvnet.sorcerer.Analyzer;
import org.jvnet.sorcerer.AstGenerator;
import org.jvnet.sorcerer.ClassUsageJsWriter;
import org.jvnet.sorcerer.Dependency;
import org.jvnet.sorcerer.PackageSet;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.ParsedType;
import org.jvnet.sorcerer.util.IOUtil;
import org.jvnet.sorcerer.util.JsonWriter;
import org.jvnet.sorcerer.util.TreeUtil;

public class FrameSetGenerator
extends AbstractWriter {
    private String title = "Sorcerer report";
    private final PackageElement unnamed;
    private static final List<String> RESOURCES = new ArrayList<String>();

    public FrameSetGenerator(ParsedSourceSet pss) {
        super(pss);
        this.unnamed = pss.getElements().getPackageElement("");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private String getPackagePath(PackageElement pe) {
        if (pe.equals(this.unnamed)) {
            return ".";
        }
        return pe.getQualifiedName().toString().replace('.', '/');
    }

    public void generateAll(File outDir) throws IOException {
        for (CompilationUnitTree cu : this.pss.getCompilationUnits()) {
            ExpressionTree packageName = cu.getPackageName();
            String pkg = packageName == null ? "" : packageName.toString().replace('.', '/') + '/';
            String name = TreeUtil.getPrimaryTypeName(cu);
            File out = new File(outDir, pkg + name + ".js");
            File parent = out.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            AstGenerator gen = new AstGenerator(this.pss, cu);
            gen.write(out);
        }
        this.generateIndex(new PrintWriter(this.open(outDir, "index.html")));
        this.generatePackageListJs(new PrintWriter(this.openDefault(outDir, "package-list.js")));
        this.generatePackageList(new PrintWriter(this.openDefault(outDir, "package-list")));
        for (PackageElement p : this.pss.getPackageElement()) {
            File dir = new File(outDir, this.getPackagePath(p));
            dir.mkdirs();
            this.generateClassListJs(p, new PrintWriter(this.openDefault(dir, "class-list.js")));
        }
        for (TypeElement e : this.pss.getClassElements()) {
            ClassTree ct;
            Element pkg = e.getEnclosingElement();
            if (pkg.getKind() != ElementKind.PACKAGE || (ct = this.pss.getTrees().getTree(e)) == null) continue;
            TreePath treePath = this.pss.getTreePathByClass().get(ct);
            String primaryName = TreeUtil.getPrimaryTypeName(treePath.getCompilationUnit());
            if (ct.getSimpleName().toString().equals(primaryName)) continue;
            PrintWriter w = new PrintWriter(this.openDefault(outDir, ((PackageElement)pkg).getQualifiedName().toString().replace('.', '/') + '/' + ct.getSimpleName() + ".js"));
            w.println("redirect('" + ct.getSimpleName() + "','" + primaryName + ".js');");
            w.close();
        }
        System.out.println("Generating usage index");
        this.generateProjectUsageJs(new PrintWriter(this.openDefault(outDir, "project-usage.js")));
        ClassUsageJsWriter cujw = new ClassUsageJsWriter(this.pss);
        for (ParsedType pt : this.pss.getParsedTypes()) {
            if (pt.getReferers().length == 0 || pt.isLocal() || pt.isInvalid()) continue;
            File out = new File(outDir, pt.element.getQualifiedName().toString().replace('.', '/') + "-usage.js");
            out.getParentFile().mkdirs();
            cujw.write(pt, new PrintWriter(out));
        }
        System.out.println("Generating static resource files");
        this.copyResource(outDir, "sorcerer.js");
        this.copyResource(outDir, "style.css");
        new File(outDir, "menu").mkdir();
        this.copyResource(outDir, "menu/menu.css");
        this.copyResource(outDir, "menu/rightarrow.gif");
        this.copyResource(outDir, "menu/menu.js");
        for (String res : RESOURCES) {
            File o = new File(outDir, res);
            o.getParentFile().mkdirs();
            InputStream in = Analyzer.class.getResourceAsStream(res);
            if (in == null) {
                throw new Error("Resource " + res + " not found");
            }
            IOUtil.copy(in, o);
        }
    }

    private void copyResource(File outDir, String resourceName) throws IOException {
        IOUtil.copy(resourceName, new File(outDir, resourceName));
    }

    public void generateIndex(PrintWriter w) throws IOException {
        this.generateWithMacro("index.html", w, "title", this.title);
    }

    private void generateWithMacro(String resourceName, PrintWriter w, String key, String value) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resourceName)));
        while ((line = r.readLine()) != null) {
            line = line.replaceAll("\\$\\{" + key + "\\}", value);
            w.println(line);
        }
        r.close();
        w.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePackageListJs(PrintWriter w) throws IOException {
        PackageSet packageNames = new PackageSet();
        for (PackageElement pe : this.pss.getPackageElement()) {
            packageNames.add(pe.getQualifiedName().toString());
        }
        packageNames.sort();
        try {
            w.println("setProject(");
            JsonWriter jw = new JsonWriter(w);
            jw.startArray();
            jw.startObject();
            jw.property("name", "Project");
            jw.propertyUnquoted("linker", "linker.self");
            jw.property("packages", packageNames);
            jw.endObject();
            for (Dependency dep : this.pss.getDependencies()) {
                jw.object(dep);
            }
            jw.endArray();
            w.println(");");
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePackageList(PrintWriter w) throws IOException {
        try {
            for (PackageElement pe : this.pss.getPackageElement()) {
                w.println(pe.getQualifiedName());
            }
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClassListJs(PackageElement p, PrintWriter w) throws IOException {
        try {
            w.printf("setClassList(\"%s\",", p.getQualifiedName());
            JsonWriter jw = new JsonWriter(w);
            jw.startArray();
            for (TypeElement t : this.pss.getClassElements(p)) {
                if (this.pss.getTrees().getTree(t) == null) continue;
                jw.startObject();
                jw.property("name", t.getSimpleName());
                jw.property("kind", this.getKindString(t.getKind()));
                jw.property("script", t.getQualifiedName().toString().replace('.', '/') + ".js");
                jw.property("access", this.getAccessLevel(t));
                jw.endObject();
            }
            jw.endArray();
            w.println(");");
        }
        finally {
            w.close();
        }
    }

    public void generateProjectUsageJs(PrintWriter w) throws IOException {
        TreeMap<PackageElement, HashSet<ParsedType>> pkgs = new TreeMap<PackageElement, HashSet<ParsedType>>(ParsedSourceSet.PACKAGENAME_COMPARATOR);
        for (ParsedType pt : this.pss.getParsedTypes()) {
            if (pt.getReferers().length == 0) continue;
            PackageElement packageElement = this.pss.getElements().getPackageOf(pt.element);
            HashSet<ParsedType> types = (HashSet<ParsedType>)pkgs.get(packageElement);
            if (types == null) {
                types = new HashSet<ParsedType>();
                pkgs.put(packageElement, types);
            }
            if (pt.isLocal()) continue;
            types.add(pt);
        }
        w.println("setProjectUsage(");
        JsonWriter js = new JsonWriter(w);
        js.startArray();
        for (Map.Entry entry : pkgs.entrySet()) {
            js.startObject();
            js.property("package", ((PackageElement)entry.getKey()).getQualifiedName());
            js.key("classes");
            js.startArray();
            Object[] names = new String[((Set)entry.getValue()).size()];
            int idx = 0;
            for (ParsedType pt : (Set)entry.getValue()) {
                names[idx++] = pt.getPackageLocalName();
            }
            Arrays.sort(names);
            for (Object n : names) {
                js.object((String)n);
            }
            js.endArray();
            js.endObject();
        }
        js.endArray();
        w.println(")");
        w.close();
    }

    static {
        RESOURCES.addAll(Arrays.asList("package-tree.html", "package-toolbar.html", "package-container.html", "outline-view.html", "outline-toolbar.html", "outline-container.html", "search-pane.html", "search-toolbar.html", "search-container.html", "source-view.html", "eclipse-public-license.url", "left-pane.js", "left-pane.css", "resource-files/yahoo.js", "resource-files/dom.js", "resource-files/event.js", "resource-files/container.js", "resource-files/close.gif", "resource-files/opentype.gif", "resource-files/package.gif", "resource-files/library.gif", "resource-files/layout-flat.gif", "resource-files/layout-hierarchical.gif", "resource-files/tree/noicon.css", "resource-files/tree/ln.gif", "resource-files/tree/loading.gif", "resource-files/tree/tn.gif", "resource-files/tree/vline.gif", "resource-files/tree/treeview.js", "resource-files/tree/license.txt"));
        for (String name : new String[]{"lm", "lp", "tm", "tp"}) {
            for (String folder : new String[]{"noicon"}) {
                RESOURCES.add("resource-files/tree/" + folder + "/" + name + ".gif");
                RESOURCES.add("resource-files/tree/" + folder + "/" + name + "h.gif");
            }
        }
        for (String name : new String[]{"file", "package", "prj", "type"}) {
            RESOURCES.add("resource-files/search/" + name + "_mode.gif");
        }
        for (String name : new String[]{"alphab_sort_co.gif", "fields_co.gif", "localtypes_co.gif", "public_co.gif", "static_co.gif"}) {
            RESOURCES.add("resource-files/outline-filter/" + name);
        }
        String[] modifiers = new String[]{"public", "protected", "private", "default"};
        for (String kind : new String[]{"annotation", "interface", "enum", "class", "field", "method"}) {
            for (String mod : modifiers) {
                RESOURCES.add("resource-files/" + kind + '_' + mod + ".gif");
            }
        }
    }
}

