/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import org.jvnet.sorcerer.PackageSet;
import org.jvnet.sorcerer.util.JsonWriter;

public abstract class Dependency
implements JsonWriter.Writable {
    public final PackageSet packageNames = new PackageSet();
    public final String name;
    public final URL baseUrl;

    private Dependency(String name, URL baseUrl) {
        this.name = name;
        this.baseUrl = baseUrl;
    }

    public void write(JsonWriter w) {
        w.property("name", this.name);
        w.property("baseURL", this.baseUrl);
        w.propertyUnquoted("linker", this.getLinker());
        w.property("packages", this.packageNames);
    }

    abstract String getLinker();

    public static final class Sorcerer
    extends Dependency {
        public Sorcerer(String name, URL baseUrl) {
            super(name, baseUrl);
        }

        String getLinker() {
            return "linker.sorcerer";
        }
    }

    public static final class Javadoc
    extends Dependency {
        public Javadoc(String name, URL baseUrl) throws IOException {
            this(name, baseUrl, (File)null);
        }

        public Javadoc(String name, URL baseUrl, File localPackageInfo) throws IOException {
            super(name, baseUrl);
            URL pkgList = localPackageInfo == null ? new URL(baseUrl, "package-list") : localPackageInfo.toURI().toURL();
            this.parsePackageInfo(pkgList);
        }

        String getLinker() {
            return "linker.javadoc";
        }

        private void parsePackageInfo(URL packageInfo) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(packageInfo.openStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                this.packageNames.add(line);
            }
            Collections.sort(this.packageNames);
        }
    }
}

