/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ClosedHashMultiMap<K, V> {
    private Object[] table = new Object[31];
    private int count;
    private int threshold = 9;
    private static final float loadFactor = 0.3f;
    private static final int initialCapacity = 31;

    protected abstract K getKey(V var1);

    private void rehash() {
        int oldCapacity = this.table.length;
        Object[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Object[] newMap = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldMap[i] == null) continue;
            int index = (oldMap[i].hashCode() & Integer.MAX_VALUE) % newMap.length;
            while (newMap[index] != null) {
                index = this.nextHash(index);
            }
            newMap[index] = oldMap[i];
        }
        this.threshold = (int)((float)newCapacity * 0.3f);
        this.table = newMap;
    }

    public void put(V value) {
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int index = (this.getKey(value).hashCode() & Integer.MAX_VALUE) % this.table.length;
        while (this.table[index] != null) {
            index = this.nextHash(index);
        }
        this.table[index] = value;
        ++this.count;
    }

    public void putAll(Iterable<? extends V> values) {
        for (V v : values) {
            this.put(v);
        }
    }

    private int nextHash(int index) {
        index = (index + 1) % this.table.length;
        return index;
    }

    public Iterable<V> get(final K key) {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Itr();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Itr
            implements Iterator<V> {
                int index;

                Itr() {
                    this.index = (key.hashCode() & Integer.MAX_VALUE) % ClosedHashMultiMap.this.table.length;
                }

                @Override
                public boolean hasNext() {
                    while (ClosedHashMultiMap.this.table[this.index] != null && !ClosedHashMultiMap.this.getKey(ClosedHashMultiMap.this.table[this.index]).equals(key)) {
                        this.index = ClosedHashMultiMap.this.nextHash(this.index);
                    }
                    return ClosedHashMultiMap.this.table[this.index] != null;
                }

                @Override
                public V next() {
                    Object r = ClosedHashMultiMap.this.table[this.index];
                    this.index = ClosedHashMultiMap.this.nextHash(this.index);
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        };
    }
}

