/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.TreeScanner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jvnet.sorcerer.util.TreeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassReferenceBuilder
extends TreeScanner<Void, Void> {
    private final Map<TypeElement, Set<CompilationUnitTree>> index = new HashMap<TypeElement, Set<CompilationUnitTree>>();
    private CompilationUnitTree cu;
    private final Set<TypeElement> discovered = new HashSet<TypeElement>();

    public static Map<TypeElement, Set<CompilationUnitTree>> build(Collection<CompilationUnitTree> sourceFiles) {
        ClassReferenceBuilder crb = new ClassReferenceBuilder();
        for (CompilationUnitTree cu : sourceFiles) {
            crb.scan(cu);
        }
        return crb.index;
    }

    private ClassReferenceBuilder() {
    }

    private void scan(CompilationUnitTree cu) {
        this.cu = cu;
        this.discovered.clear();
        cu.accept(this, null);
    }

    private void record(TypeElement t) {
        if (t.asType().getKind().isPrimitive()) {
            throw new IllegalStateException();
        }
        if (this.discovered.add(t)) {
            Set<CompilationUnitTree> set = this.index.get(t);
            if (set == null) {
                set = new HashSet<CompilationUnitTree>();
                this.index.put(t, set);
            }
            set.add(this.cu);
        }
    }

    protected void candidate(Element e) {
        if (e == null) {
            return;
        }
        switch (e.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                this.record((TypeElement)e);
                break;
            }
            case ENUM_CONSTANT: 
            case METHOD: 
            case CONSTRUCTOR: 
            case FIELD: {
                Element p = e.getEnclosingElement();
                if (!TreeUtil.isType(p)) break;
                this.record((TypeElement)p);
            }
        }
    }

    @Override
    public Void visitIdentifier(IdentifierTree id, Void _) {
        this.candidate(TreeUtil.getElement(id));
        return (Void)super.visitIdentifier(id, _);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree mst, Void _) {
        this.candidate(TreeUtil.getElement(mst));
        return (Void)super.visitMemberSelect(mst, _);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree mi, Void _) {
        this.candidate(TreeUtil.getElement(mi));
        return (Void)super.visitMethodInvocation(mi, _);
    }
}

