/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTool;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.jvnet.sorcerer.AnalysisException;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.util.TabExpandingFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer {
    private final List<File> sourceFiles = new ArrayList<File>();
    private final List<File> classpath = new ArrayList<File>();
    private Charset encoding;
    private Locale locale;
    private int tabWidth = 8;

    public void addSourceFile(File file) {
        this.sourceFiles.add(file);
    }

    public void addSourceFolder(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.addSourceFolder(f);
                continue;
            }
            if (!f.getName().endsWith(".java")) continue;
            this.addSourceFile(f);
        }
    }

    public void addClasspath(File f) {
        this.classpath.add(f);
    }

    public void setSourceEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public ParsedSourceSet analyze() throws IOException, AnalysisException {
        DiagnosticCollector listener = new DiagnosticCollector();
        ParsedSourceSet r = this.analyze(listener);
        if (listener.getDiagnostics().isEmpty()) {
            return r;
        }
        throw new AnalysisException(listener.getDiagnostics());
    }

    public ParsedSourceSet analyze(DiagnosticListener<? super JavaFileObject> errorListener) throws IOException {
        return new ParsedSourceSet(this.configure(errorListener), this.tabWidth);
    }

    protected JavacTask configure(DiagnosticListener<? super JavaFileObject> errorListener) throws IOException {
        JavacTool javac = JavacTool.create();
        TabExpandingFileManager fileManager = new TabExpandingFileManager(javac.getStandardFileManager(errorListener, this.locale, this.encoding), this.encoding, this.tabWidth);
        fileManager.setLocation(StandardLocation.CLASS_PATH, this.classpath);
        List<String> options = Collections.emptyList();
        Iterable<? extends JavaFileObject> files = fileManager.getJavaFileObjectsFromFiles(this.sourceFiles);
        JavaCompiler.CompilationTask task = javac.getTask(null, (JavaFileManager)fileManager, errorListener, options, null, files);
        return (JavacTask)task;
    }
}

