/* -*- c++ -*- */
/* 
 * Copyright 2014 Balint Seeber <balint256@gmail.com>
 * Copyright 2013 Bastian Bloessl <bloessl@ccs-labs.org>.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef INCLUDED_BAZ_BURST_TAGGER_IMPL_H
#define INCLUDED_BAZ_BURST_TAGGER_IMPL_H

#include <baz_burst_tagger.h>

namespace gr {
namespace baz {

class burst_tagger_impl : public burst_tagger {
private:
	void add_eob(uint64_t item);
	void add_sob(uint64_t item);

	pmt::pmt_t d_tag_name, d_ignore_name;
	int d_copy, d_current_length;
	float d_mult;
	unsigned int d_pad_front, d_pad_rear;
	unsigned int d_to_pad_front/*, d_to_pad_rear*/;
	bool d_in_burst, d_drop_residue, d_verbose;
	uint64_t d_count, d_work_count;
public:
	burst_tagger_impl(const std::string& tag_name = "length", float mult = 1, unsigned int pad_front = 0, unsigned int pad_rear = 0, bool drop_residue = true, bool verbose = true);
	~burst_tagger_impl();

	void forecast (int noutput_items, gr_vector_int &ninput_items_required);
	int general_work(int noutput_items, gr_vector_int& ninput_items, gr_vector_const_void_star &input_items, gr_vector_void_star &output_items);
};

} // namespace baz
} // namespace gr

#endif /* INCLUDED_BAZ_BURST_TAGGER_IMPL_H */
