---
id: node
title: Node
sidebar_label: Node
---

## What

Display the currently active node version.

## Sample Configuration

```json
{
  "type": "node",
  "style": "powerline",
  "powerline_symbol": "\uE0B0",
  "foreground": "#ffffff",
  "background": "#6CA35E",
  "properties": {
    "prefix": " \uE718 "
  }
}
```

## Properties

- home_enabled: `boolean` - display the segment in the HOME folder or not - defaults to `false`
- missing_command_text: `string` - text to display when the command is missing - defaults to empty
- display_mode: `string` - determines when the segment is displayed
  - `always`: The segment is always displayed
  - `files`: The segment is only displayed when `*.js`, `*.ts`, or `package.json` files are present (default)
- fetch_package_manager: `boolean` - define if the current project uses Yarn or NPM - defaults to `false`
- yarn_icon: `string` - the icon/text to display when using Yarn - defaults to ` \uF61A`
- npm_icon: `string` - the icon/text to display when using NPM - defaults to ` \uE71E`
- template: `string` - A go [text/template][go-text-template] template extended with [sprig][sprig] utilizing the
properties below. Defaults to `{{ .Full }}`

## Template Properties

- `.Full`: `string` - the full version
- `.Major`: `string` - major number
- `.Minor`: `string` - minor number
- `.Patch`: `string` - patch number
- `.Prerelease`: `string` - prerelease info text
- `.BuildMetadata`: `string` - build metadata
- `.Error`: `string` - when fetching the version string errors
- `.PackageManagerIcon`: `string` - the Yarn on NPM icon when setting `fetch_package_manager` to `true`
- `.Mismatch`: `boolean` - if the version in `.nvmrc` matches with `.Full`

[go-text-template]: https://golang.org/pkg/text/template/
[sprig]: https://masterminds.github.io/sprig/
