# v6.2

Bug fix release

# v6.2.4000

## Breaking Changes

None

## Features

* docs: minor updates to docs + website

## Bug Fixes

* core: regression bug when comparing a non-str string (eg generic) with a string ([issue #845](https://github.com/lmorg/murex/issues/845))

# v6.2.3000

## Breaking Changes

None

## Deprecation Warnings

Please read out [compatibility commitment](/./compatibility.md) to understand how features are deprecated.

* the `?` pipe is deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`. It will be officially removed in v7.0
  
* the `=` and `let` builtins are deprecated and will be removed in v7.0. They've been marked as deprecated in the documentation for several versions but you'll now receive a deprecation warning when using them. This warning will not impact any functions that call them (they bypass the stdout and stderr pipes and write directly to your TTY). The change is very simple, Murex supported expressions as first class primitives, so you can simply drop the `=` and `let` command names from your expressions

* automatic conversion of backtick `` ` `` to single quote `'` has been deprecated and will be removed in v7.0. The only reason this ever existed was a hack to enable quotes in `=`. Worse still, this behaviour wasn't documented anywhere

## Features

Features marked as **EXPERIMENTAL** are provided without assurances of future breaking changes. All other features are considered stable as part of Murex's [compatibility commitment](/./compatibility.md).

* preview: progress bar to show how far through the preview document

* docs: more improvements to documentation

## Bug Fixes

* caching: suppress cache.db connect message when in debug mode ([issue #825](https://github.com/lmorg/murex/issues/825))

* `murex-package`: package errors should be ignored in `murex-package list` ([issue #826](https://github.com/lmorg/murex/issues/826) [docs](/docs/commands/murex-package.md))

* `export`: exporting a non-existing variable would cause a crash ([issue #824](https://github.com/lmorg/murex/issues/824))

* `murex-docs`: integrations docs were missing from compiled executable ([read more](/docs/commands/murex-docs.md))

* integrations: ChatGPT preview instructions were incorrect ([read more](/docs/integrations/chatgpt.md))

* core: crash handler was always disabled due to incorrectly flipping a boolean

* `expr`: re-write of `==` and `!=` operators to fix comparison bugs ([issue #831](https://github.com/lmorg/murex/issues/831) [docs](/docs/commands/expr.md))

* `expr`: when run as a statement, only the first parameter was used ([issue #827](https://github.com/lmorg/murex/issues/827) [docs](/docs/commands/expr.md))

* `expr`: panic when converting arrays and objects to a numeric scala ([issue #829](https://github.com/lmorg/murex/issues/829) [docs](/docs/commands/expr.md))

* `expr`: `:` was treated as `<` in expressions ([issue #832](https://github.com/lmorg/murex/issues/832) [docs](/docs/commands/expr.md))

* `expr`: empty arrays return `null` ([docs](/docs/commands/expr.md)))

* core: `go test` compilation errors on Windows fixed

* readline: in preview, backspace characters where not pushing character positions (this bug only appeared in previewing UNIX man pages)

* readline: final character in preview checked to see if it is a wide character

* readline: tab widths in preview off by one

## Special Thanks

Thank yous for this release goes to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) plus all who raise bug reports.

You rock!

<hr>

Published: 19.07.2024 at 08:54

## See Also

* [ChatGPT](../integrations/chatgpt.md):
  How to enable ChatGPT hints
* [Define Environmental Variable: `export`](../commands/export.md):
  Define an environmental variable and set it's value
* [Expressions: `expr`](../commands/expr.md):
  Expressions: mathematical, string comparisons, logical operators
* [How To Contribute](../Murex/CONTRIBUTING.md):
  Murex is community project. We gratefully accept contributions
* [Murex Package Manager: `murex-package`](../commands/murex-package.md):
  Murex's package manager
* [Murex's Offline Documentation: `murex-docs`](../commands/murex-docs.md):
  Displays the man pages for Murex builtins
* [Operators And Tokens](../user-guide/operators-and-tokens.md):
  All supported operators and tokens

<hr/>

This document was generated from [gen/changelog/v6.2_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v6.2_doc.yaml).