//
// Copyright (c) 2014-2019 Cesanta Software Limited
// All rights reserved
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package mgrpc

//XXXgo:generate stringer -type=transport transport.go

// transport is an enum of supported transport protocols
type transport int

const (
	// tHTTP_POST delivers the commands by issuing HTTP POST request and waiting
	// for the response.
	tHTTP_POST transport = iota
	// tWebSocket creates a permanent connection to the destination and
	// encapsulates Clubby frames into WebSocket frames.
	tWebSocket
	// tPlainTCP creates a permanent connection to the destination over plain TCP.
	tPlainTCP
	// tSerial creates a permanent connection to the destination over serial port.
	tSerial
	tMQTT
	tAzureDM
	tGCP
	tWatson
	tUDP
)
