// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeBigint(t *testing.T) {
	SkipByDefaultInCI(t)
	tests := []ModifyTypeTest{
		{
			"BIGINT",
			"TINYINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0)",
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1)",
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(1)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-00:00:01", "00:00:00", "00:00:01"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(2001), int64(2002), int64(2015)},
			false,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-00:02:56", "-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{float64(-1.048576e+06), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576\x00\x00", "-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"BIGINT",
			"INT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{float64(-8.388608e+06), float64(-1.048576e+06), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{float64(-8388608), float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.000000000000000000000000000000", "-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{uint64(18446744073701163008), uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608\x00\x00", "-1048576\x00\x00", "-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{int64(-16777216), int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{float64(-1.6777216e+07), float64(-8.388608e+06), float64(-1.048576e+06), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{float64(-16777216), float64(-8388608), float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216.000000000000000", "-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216.000000000000000", "-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216.000000000000000000000000000000", "-8388608.000000000000000000000000000000", "-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{uint64(18446744073692774400), uint64(18446744073701163008), uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216\x00", "-8388608\x00\x00", "-1048576\x00\x00", "-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{"-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-16777216), (1,-8388608), (2,-1048576), (3,-65536), (4,-32768), (5,-4096), (6,-256), (7,-128), (8,-16), (9,-2), (10,-1), (11,0), (12,1), (13,2), (14,15), (15,127), (16,255), (17,4095), (18,32767), (19,65535), (20,1048575), (21,8388607), (22,16777215)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{int64(-268435456), int64(-16777216), int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{float64(-2.68435456e+08), float64(-1.6777216e+07), float64(-8.388608e+06), float64(-1.048576e+06), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{float64(-268435456), float64(-16777216), float64(-8388608), float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456.0", "-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456.0", "-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456.0", "-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456.000000000000000", "-16777216.000000000000000", "-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456.000000000000000", "-16777216.000000000000000", "-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456.000000000000000000000000000000", "-16777216.000000000000000000000000000000", "-8388608.000000000000000000000000000000", "-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{uint64(18446744073441116160), uint64(18446744073692774400), uint64(18446744073701163008), uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216\x00", "-8388608\x00\x00", "-1048576\x00\x00", "-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16777216\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16777216\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{"-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-268435456), (1,-16777216), (2,-8388608), (3,-1048576), (4,-65536), (5,-32768), (6,-4096), (7,-256), (8,-128), (9,-16), (10,-2), (11,-1), (12,0), (13,1), (14,2), (15,15), (16,127), (17,255), (18,4095), (19,32767), (20,65535), (21,1048575), (22,8388607), (23,16777215), (24,268435455)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455), int64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08), float64(2.147483648e+09)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455), float64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000", "2147483647.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{int64(-2147483648), int64(-268435456), int64(-16777216), int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607), int64(16777215), int64(268435455), int64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{float64(-2.147483648e+09), float64(-2.68435456e+08), float64(-1.6777216e+07), float64(-8.388608e+06), float64(-1.048576e+06), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08), float64(2.147483648e+09)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{float64(-2147483648), float64(-268435456), float64(-16777216), float64(-8388608), float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455), float64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648.0", "-268435456.0", "-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648.0", "-268435456.0", "-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648.0", "-268435456.0", "-16777216.0", "-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648.000000000000000", "-268435456.000000000000000", "-16777216.000000000000000", "-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648.000000000000000", "-268435456.000000000000000", "-16777216.000000000000000", "-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648.000000000000000000000000000000", "-268435456.000000000000000000000000000000", "-16777216.000000000000000000000000000000", "-8388608.000000000000000000000000000000", "-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000", "2147483647.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{uint64(18446744071562067968), uint64(18446744073441116160), uint64(18446744073692774400), uint64(18446744073701163008), uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-268435456\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16777216\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-268435456\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16777216\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{"-2147483648", "-268435456", "-16777216", "-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('B','C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A','B','C')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('C','A','B')",
			"(0,-2147483648), (1,-268435456), (2,-16777216), (3,-8388608), (4,-1048576), (5,-65536), (6,-32768), (7,-4096), (8,-256), (9,-128), (10,-16), (11,-2), (12,-1), (13,0), (14,1), (15,2), (16,15), (17,127), (18,255), (19,4095), (20,32767), (21,65535), (22,1048575), (23,8388607), (24,16777215), (25,268435455), (26,2147483647)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"BIGINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"BIGINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1.048575e+06), float64(8.388607e+06), float64(1.6777215e+07), float64(2.68435456e+08), float64(2.147483648e+09), float64(4.294967296e+09)},
			false,
		},
		{
			"BIGINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607), float64(16777215), float64(268435455), float64(2147483647), float64(4294967295)},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0", "4294967295.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0", "4294967295.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0", "16777215.0", "268435455.0", "2147483647.0", "4294967295.0"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000", "4294967295.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000", "16777215.000000000000000", "268435455.000000000000000", "2147483647.000000000000000", "4294967295.000000000000000"},
			false,
		},
		{
			"BIGINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000", "16777215.000000000000000000000000000000", "268435455.000000000000000000000000000000", "2147483647.000000000000000000000000000000", "4294967295.000000000000000000000000000000"},
			false,
		},
		{
			"BIGINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"BIGINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"BIGINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607), uint64(16777215), uint64(268435455), uint64(2147483647), uint64(4294967295)},
			false,
		},
		{
			"BIGINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00", "16777215\x00\x00", "268435455\x00", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4294967295\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "16777215\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "268435455\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2147483647\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4294967295\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607", "16777215", "268435455", "2147483647", "4294967295"},
			false,
		},
		{
			"BIGINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607), (11,16777215), (12,268435455), (13,2147483647), (14,4294967295)",
			[]interface{}{},
			true,
		},
		{
			"BIGINT",
			"SET('A')",
			"(0,0), (1,1), (2,2),