# Table of contents

* [Introduction to DNSControl](index.md)

## Getting Started

* [Overview](getting-started.md)
* [Examples](examples.md)
* [Migrating zones to DNSControl](migrating.md)
* [TypeScript autocomplete and type checking](typescript.md)
* [Providers](providers.md)

## Language Reference

* [JavaScript DSL](js.md)
* Top Level Functions
  * [D](language-reference/top-level-functions/D.md)
  * [DEFAULTS](language-reference/top-level-functions/DEFAULTS.md)
  * [DOMAIN_ELSEWHERE](language-reference/top-level-functions/DOMAIN_ELSEWHERE.md)
  * [DOMAIN_ELSEWHERE_AUTO](language-reference/top-level-functions/DOMAIN_ELSEWHERE_AUTO.md)
  * [D_EXTEND](language-reference/top-level-functions/D_EXTEND.md)
  * [FETCH](language-reference/top-level-functions/FETCH.md)
  * [IP](language-reference/top-level-functions/IP.md)
  * [NewDnsProvider](language-reference/top-level-functions/NewDnsProvider.md)
  * [NewRegistrar](language-reference/top-level-functions/NewRegistrar.md)
  * [PANIC](language-reference/top-level-functions/PANIC.md)
  * [REV](language-reference/top-level-functions/REV.md)
  * [REVCOMPAT](language-reference/top-level-functions/REVCOMPAT.md)
  * [getConfiguredDomains](language-reference/top-level-functions/getConfiguredDomains.md)
  * [require](language-reference/top-level-functions/require.md)
  * [require_glob](language-reference/top-level-functions/require_glob.md)
* Domain Modifiers
    * [A](language-reference/domain-modifiers/A.md)
    * [AAAA](language-reference/domain-modifiers/AAAA.md)
    * [ALIAS](language-reference/domain-modifiers/ALIAS.md)
    * [AUTODNSSEC_OFF](language-reference/domain-modifiers/AUTODNSSEC_OFF.md)
    * [AUTODNSSEC_ON](language-reference/domain-modifiers/AUTODNSSEC_ON.md)
    * [CAA](language-reference/domain-modifiers/CAA.md)
    * [CAA_BUILDER](language-reference/domain-modifiers/CAA_BUILDER.md)
    * [CNAME](language-reference/domain-modifiers/CNAME.md)
    * [DHCID](language-reference/domain-modifiers/DHCID.md)
    * [DNAME](language-reference/domain-modifiers/DNAME.md)
    * [DNSKEY](language-reference/domain-modifiers/DNSKEY.md)
    * [DISABLE_IGNORE_SAFETY_CHECK](language-reference/domain-modifiers/DISABLE_IGNORE_SAFETY_CHECK.md)
    * [DMARC_BUILDER](language-reference/domain-modifiers/DMARC_BUILDER.md)
    * [DS](language-reference/domain-modifiers/DS.md)
    * [DefaultTTL](language-reference/domain-modifiers/DefaultTTL.md)
    * [DnsProvider](language-reference/domain-modifiers/DnsProvider.md)
    * [FRAME](language-reference/domain-modifiers/FRAME.md)
    * [HTTPS](language-reference/domain-modifiers/HTTPS.md)
    * [IGNORE](language-reference/domain-modifiers/IGNORE.md)
    * [IGNORE_NAME](language-reference/domain-modifiers/IGNORE_NAME.md)
    * [IGNORE_TARGET](language-reference/domain-modifiers/IGNORE_TARGET.md)
    * [IMPORT_TRANSFORM](language-reference/domain-modifiers/IMPORT_TRANSFORM.md)
    * [INCLUDE](language-reference/domain-modifiers/INCLUDE.md)
    * [LOC](language-reference/domain-modifiers/LOC.md)
    * [LOC_BUILDER_DD](language-reference/domain-modifiers/LOC_BUILDER_DD.md)
    * [LOC_BUILDER_DMM_STR](language-reference/domain-modifiers/LOC_BUILDER_DMM_STR.md)
    * [LOC_BUILDER_DMS_STR](language-reference/domain-modifiers/LOC_BUILDER_DMS_STR.md)
    * [LOC_BUILDER_STR](language-reference/domain-modifiers/LOC_BUILDER_STR.md)
    * [M365_BUILDER](language-reference/domain-modifiers/M365_BUILDER.md)
    * [MX](language-reference/domain-modifiers/MX.md)
    * [NAMESERVER](language-reference/domain-modifiers/NAMESERVER.md)
    * [NAMESERVER_TTL](language-reference/domain-modifiers/NAMESERVER_TTL.md)
    * [NAPTR](language-reference/domain-modifiers/NAPTR.md)
    * [NO_PURGE](language-reference/domain-modifiers/NO_PURGE.md)
    * [NS](language-reference/domain-modifiers/NS.md)
    * [PTR](language-reference/domain-modifiers/PTR.md)
    * [PURGE](language-reference/domain-modifiers/PURGE.md)
    * [SOA](language-reference/domain-modifiers/SOA.md)
    * [SPF_BUILDER](language-reference/domain-modifiers/SPF_BUILDER.md)
    * [SRV](language-reference/domain-modifiers/SRV.md)
    * [SSHFP](language-reference/domain-modifiers/SSHFP.md)
    * [SVCB](language-reference/domain-modifiers/SVCB.md)
    * [TLSA](language-reference/domain-modifiers/TLSA.md)
    * [TXT](language-reference/domain-modifiers/TXT.md)
    * [URL](language-reference/domain-modifiers/URL.md)
    * [URL301](language-reference/domain-modifiers/URL301.md)
    * Service Provider specific
        * Akamai Edge Dns
            * [AKAMAICDN](language-reference/domain-modifiers/AKAMAICDN.md)
        * Amazon Route 53
            * [R53_ALIAS](language-reference/domain-modifiers/R53_ALIAS.md)
        * Azure DNS
            * [AZURE_ALIAS](language-reference/domain-modifiers/AZURE_ALIAS.md)
        * Cloudflare DNS
            * [CF_REDIRECT](language-reference/domain-modifiers/CF_REDIRECT.md)
            * [CF_TEMP_REDIRECT](language-reference/domain-modifiers/CF_TEMP_REDIRECT.md)
            * [CF_WORKER_ROUTE](language-reference/domain-modifiers/CF_WORKER_ROUTE.md)
        * ClouDNS
            * [CLOUDNS_WR](language-reference/domain-modifiers/CLOUDNS_WR.md)
        * NS1
            * [NS1_URLFWD](language-reference/domain-modifiers/NS1_URLFWD.md)
* Record Modifiers
    * [TTL](language-reference/record-modifiers/TTL.md)
    * Service Provider specific
        * Amazon Route 53
            * [R53_ZONE](language-reference/record-modifiers/R53_ZONE.md)
            * [R53_EVALUATE_TARGET_HEALTH](language-reference/record-modifiers/R53\_EVALUATE\_TARGET\_HEALTH.md)
* [Why CNAME/MX/NS targets require a "dot"](why-the-dot.md)

## Provider

* [Akamai Edge DNS](provider/akamaiedgedns.md)
* [Amazon Route 53](provider/route53.md)
* [AutoDNS](provider/autodns.md)
* [AXFR+DDNS](provider/axfrddns.md)
* [Azure DNS](provider/azure_dns.md)
* [Azure Private DNS](provider/azure_private_dns.md)
* [BIND](provider/bind.md)
* [Bunny DNS](provider/bunny\_dns.md)
* [Cloudflare](provider/cloudflareapi.md)
* [ClouDNS](provider/cloudns.md)
* [CSC Global](provider/cscglobal.md)
* [deSEC](provider/desec.md)
* [DigitalOcean](provider/digitalocean.md)
* [DNS Made Easy](provider/dnsmadeeasy.md)
* [DNSimple](provider/dnsimple.md)
* [DNS-over-HTTPS](provider/dnsoverhttps.md)
* [DOMAINNAMESHOP](provider/domainnameshop.md)
* [Dynadot](provider/dynadot.md)
* [easyname](provider/easyname.md)
* [Exoscale](provider/exoscale.md)
* [Gandi_v5](provider/gandi_v5.md)
* [Gcore](provider/gcore.md)
* [Google Cloud DNS](provider/gcloud.md)
* [Hetzner DNS Console](provider/hetzner.md)
* [HEXONET](provider/hexonet.md)
* [hosting.de](provider/hostingde.md)
* [Huawei Cloud DNS](provider/huaweicloud.md)
* [Hurricane Electric DNS](provider/hedns.md)
* [Internet.bs](provider/internetbs.md)
* [INWX](provider/inwx.md)
* [Linode](provider/linode.md)
* [Loopia](provider/loopia.md)
* [LuaDNS](provider/luadns.md)
* [Microsoft DNS Server on Microsoft Windows Server](provider/msdns.md)
* [Mythic Beasts](provider/mythicbeasts.md)
* [Namecheap](provider/namecheap.md)
* [Name.com](provider/namedotcom.md)
* [Netcup](provider/netcup.md)
* [Netlify](provider/netlify.md)
* [NS1](provider/ns1.md)
* [OpenSRS](provider/opensrs.md)
* [Oracle Cloud](provider/oracle.md)
* [OVH](provider/ovh.md)
* [Packetframe](provider/packetframe.md)
* [Porkbun](provider/porkbun.md)
* [PowerDNS](provider/powerdns.md)
* [Realtime Register](provider/realtimeregister.md)
* [RWTH DNS-Admin](provider/rwth.md)
* [SoftLayer DNS](provider/softlayer.md)
* [TransIP](provider/transip.md)
* [Vultr](provider/vultr.md)

## Commands

* [preview/push](preview-push.md)
* [check-creds](check-creds.md)
* [get-zones](get-zones.md)
* [get-certs](get-certs.md)
* [fmt](fmt.md)
* [creds.json](creds-json.md)
* [Global Flag](globalflags.md)
* [Disabling Colors](colors.md)

## Advanced features

* [CI/CD example for GitLab](ci-cd-gitlab.md)
* [CLI variables](cli-variables.md)
* [Nameservers and Delegations](nameservers.md)
* [Notifications](notifications.md)
* [Useful code tricks](code-tricks.md)
* [JSON Reports](json-reports.md)

## Developer info

* [Code Style Guide](styleguide-code.md)
* [Documentation Style Guide](styleguide-doc.md)
* [DNSControl is an opinionated system](opinions.md)
* [Writing new DNS providers](writing-providers.md)
* [Creating new DNS Resource Types (rtypes)](adding-new-rtypes.md)
* [Integration Tests](integration-tests.md)
* [Unit Testing DNS Data](unittests.md)
* [Bug Triage Process](bug-triage.md)
* [Bring-Your-Own-Secrets for automated testing](byo-secrets.md)
* [Debugging with dlv](debugging-with-dlv.md)
* [ALIAS Records](alias.md)
* [TXT record testing](testing-txt-records.md)
* [DNS records ordering](ordering.md)

## Release

* [How to build and ship a release](release-engineering.md)
* [Changelog v3.16.0](v316.md)
* [GitHub releases](https://github.com/StackExchange/dnscontrol/releases/latest)
