-- This file is part of the Grid LSC User Environment (GLUE)
-- 
-- GLUE is free software: you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation, either version 3 of the License, or (at your option) any later
-- version.
-- 
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
-- FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
-- details.
-- 
-- You should have received a copy of the GNU General Public License along
-- with this program.  If not, see <http://www.gnu.org/licenses/>.

CREATE TABLE waveburst
(
-- The table records events generated by waveburst DSO.

-- LIGO/LSC site that created this entry
      creator_db         INTEGER NOT NULL WITH DEFAULT 1,
-- Process which generated this entry
      process_id         CHAR(13) FOR BIT DATA NOT NULL, 
-- Filter identifier (indicates type of filter, plus parameters).  May be null
      filter_id          CHAR(13) FOR BIT DATA, 
-- Unique identifier for this event
      event_id           CHAR(13) FOR BIT DATA NOT NULL, 
-- Unique identifier for this simulation, can be NULL if no simulated signal is injected
      simulation_id      CHAR(13) FOR BIT DATA, 
      comment            VARCHAR(64), 
-- Wave burst DSO applies coincidence between two interferometers from the start
-- to veto out events that are not simultaneously observed by two interferometers.
      ifo_1              CHAR(2) NOT NULL, 
      ifo_2              CHAR(2) NOT NULL, 
      channel_1          VARCHAR(64) NOT NULL, 
      channel_2          VARCHAR(64) NOT NULL, 
-- Number of pixels in the cluster and surrounding halo corresponding to this event
-- volume=core_size+halo
      volume             INTEGER, 
-- Number of pixels in the cluster without halo
      core_size          INTEGER, 
      xcorrelation       REAL, 
      rcorrelation       REAL,
      likelihood         REAL, 
      power              REAL, 
      max_amplitude      REAL, 
      rel_start_time     DOUBLE, 
      rel_stop_time      DOUBLE, 
      duration           DOUBLE, 
      start_time         INTEGER, 
      start_time_ns      INTEGER, 
      stop_time          INTEGER, 
      stop_time_ns       INTEGER, 
      start_frequency    REAL, 
      stop_frequency     REAL, 
      bandwidth          REAL, 
-- 0 if no pixel mixing or swapping took place, 1 if pixel swapping was applied
-- 2 if pixel mixing was applied
      cluster_type       INTEGER, 
-- Simulation type as described in sim_type table
      sim_type    INTEGER, 
      
-- 1 if the cluster satisfies all the selection criteria, 0 otherwise for backward compatibility
      s_cut              INTEGER NOT NULL WITH DEFAULT 1,
      
-- Assigns an integer cluster id to each event within the job
-- Helps to match clusters in different channels
      cluster_id         INTEGER NOT NULL WITH DEFAULT 1,
-- Estimate the noise for the given cluster. It is used to set equivalen selection
-- cuts for different ifos
      noise_rms		 REAL,
-- Just in case
      extra		 DOUBLE,
      
-- Insertion time (automatically assigned by the database)
      insertion_time     TIMESTAMP WITH DEFAULT CURRENT TIMESTAMP,
      
      CONSTRAINT wb_pk 
      PRIMARY KEY (event_id, creator_db),

      CONSTRAINT wb_fk_si
      FOREIGN KEY (simulation_id, creator_db)
          REFERENCES sim_inst(simulation_id,creator_db)
          ON DELETE CASCADE,

      CONSTRAINT wb_fk_st
      FOREIGN KEY (sim_type)
          REFERENCES sim_type(sim_type)
          ON DELETE CASCADE,

      CONSTRAINT wb_fk_pid
      FOREIGN KEY (process_id, creator_db)
          REFERENCES process(process_id, creator_db),

      CONSTRAINT wb_fk_filt
      FOREIGN KEY (filter_id, creator_db)
          REFERENCES filter(filter_id, creator_db)

)   
-- The following line is needed for this table to be replicated to other sites
DATA CAPTURE CHANGES
;
-- Create an index based on process_id
CREATE INDEX wb_pid_ind ON waveburst(process_id)
;
ALTER TABLE waveburst append on
;
