/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util.builders;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.util.builders.ButtonBuilder;

public class TextButtonBuilder<B extends TextButtonBuilder<B, T>, T extends TextButton>
extends ButtonBuilder<B, T> {
    private BitmapFont font;
    private Color fontColor;
    private Color downFontColor;
    private Color overFontColor;
    private Color checkedFontColor;
    private Color checkedOverFontColor;
    private Color disabledFontColor;
    private String text;
    private int align;

    public B font(BitmapFont font) {
        this.font = font;
        return (B)this;
    }

    public B font(String name) {
        this.font = App.skin.getFont(name);
        return (B)this;
    }

    public B fontColor(Color color) {
        this.fontColor = color;
        return (B)this;
    }

    public B downFontColor(Color color) {
        this.downFontColor = color;
        return (B)this;
    }

    public B overFontColor(Color color) {
        this.overFontColor = color;
        return (B)this;
    }

    public B checkedFontColor(Color color) {
        this.checkedFontColor = color;
        return (B)this;
    }

    public B checkedOverFontColor(Color color) {
        this.checkedOverFontColor = color;
        return (B)this;
    }

    public B disabledFontColor(Color color) {
        this.disabledFontColor = color;
        return (B)this;
    }

    public B text(String text) {
        this.text = text;
        return (B)this;
    }

    public B align(int align) {
        this.align = align;
        return (B)this;
    }

    @Override
    public T set(T button) {
        super.set(button);
        ((TextButton)button).setText(this.text);
        ((TextButton)button).getLabel().setAlignment(this.align);
        return button;
    }

    @Override
    public <S extends TextButton.TextButtonStyle> S set(S style) {
        style.font = this.font;
        style.fontColor = this.fontColor;
        style.downFontColor = this.downFontColor;
        style.overFontColor = this.overFontColor;
        style.checkedFontColor = this.checkedFontColor;
        style.checkedOverFontColor = this.checkedOverFontColor;
        style.disabledFontColor = this.disabledFontColor;
        return super.set(style);
    }

    @Override
    public T create() {
        TextButton.TextButtonStyle style = this.set(new TextButton.TextButtonStyle());
        return (T)this.set((TextButton.TextButtonStyle)((Object)new TextButton("", style)));
    }
}

