/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;

public class CompositeDrawable
extends BaseDrawable
implements TransformDrawable {
    private Drawable[] drawables;

    public CompositeDrawable(Drawable ... drawables) {
        this.drawables = drawables;
    }

    @Override
    public void draw(Batch batch, float x, float y, float width, float height) {
        Drawable[] drawableArray = this.drawables;
        int n = this.drawables.length;
        int n2 = 0;
        while (n2 < n) {
            Drawable drawable = drawableArray[n2];
            drawable.draw(batch, x, y, width, height);
            ++n2;
        }
    }

    @Override
    public void draw(Batch batch, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        Drawable[] drawableArray = this.drawables;
        int n = this.drawables.length;
        int n2 = 0;
        while (n2 < n) {
            Drawable drawable = drawableArray[n2];
            ((TransformDrawable)drawable).draw(batch, x, y, originX, originY, width, height, scaleX, scaleY, rotation);
            ++n2;
        }
    }

    @Override
    public float getMinWidth() {
        return this.drawables[0].getMinWidth();
    }

    @Override
    public float getMinHeight() {
        return this.drawables[0].getMinHeight();
    }
}

