subroutine uv_shift_mosaic(line,error)
  use clean_def
  use clean_default
  use clean_arrays
  use phys_const
  use gkernel_types
  use gkernel_interfaces
  use gbl_message
  use imager_interfaces, except_this => uv_shift_mosaic
  !-------------------------------------------------------------------
  ! @ private
  !  IMAGER 
  !   Support routine for command
  !       UV_SHIFT  MAP_CENTER 
  !                 Xpos Ypos UNIT [Angle]
  !
  !   Phase shift a Mosaic or Single Dish UV Table to a new
  !   common phase center and orientation
  !     Offx OffY are offsets in Angle UNIT 
  !               (default 0,0)
  !     Angle     is the final position angle from North in Degree
  !               (default: no change)
  !
  !   Also called implicitely (with no command line arguments, i.e.
  !   no change of Phase Center unless the UV Table is with
  !   Phase Offsets )
  !   by command UV_MAP for Mosaics
  !-------------------------------------------------------------------
  character(len=*), intent(in) :: line  ! Command line
  logical error                         ! Logical error flag
  !
  character(len=*), parameter :: rname='UV_SHIFT'
  character(len=80) :: mess
  type(projection_t) :: proj
  real(8) :: newoff(3), newabs(3), oldabs(3)
  real(4) :: cs(2), angold
  real(8), allocatable :: rpos(:,:)
  real(8) :: freq
  logical :: precise=.true.
  logical :: shift, doit, lshift
  integer :: nc,nu,nv,i,ier,loff,moff,xoff,yoff
  !
  loff = huv%gil%column_pointer(code_uvt_loff)
  moff = huv%gil%column_pointer(code_uvt_moff)
  xoff = huv%gil%column_pointer(code_uvt_xoff)
  yoff = huv%gil%column_pointer(code_uvt_yoff)
  newoff = 0.d0
  !
  oldabs = [huv%gil%a0,huv%gil%d0,huv%gil%pang]   !!! Patch map_center
  !
  if (themap%nfields.eq.0) then
    call map_message(seve%i,rname,'UV data is a single field') 
    shift = .false.
  else 
    if (themap%nfields.gt.0) then
      if (xoff.ne.0 .or. yoff.ne.0) then
        call map_message(seve%i,rname,'Mosaic UV data is already in Pointing offsets')
        ! Nothing to do if no new position is specified
        if (sic_narg(0).eq.0) return
      else
        call map_message(seve%e,rname,'Mosaic UV data is already in Pointing offsets')
        call map_message(seve%e,rname,'Mosaic UV data has no Pointing columns')
        error = .true.
        return
      endif
    else
      call map_message(seve%w,rname,'Mosaic UV data is in Phase offsets')
    endif
    !
    write(mess,'(A,I0,A)') 'Mosaic UV data has ',abs(themap%nfields),' fields'
    call map_message(seve%i,rname,mess)
    !
    ! Compute the mean offset as phase center position
    newoff(1) = minval(themap%offxy(1,:)) + maxval(themap%offxy(1,:))
    newoff(2) = minval(themap%offxy(2,:)) + maxval(themap%offxy(2,:))
    newoff = newoff*0.5d0
    ! ZZZ why -pang??? Seems it comes from this comment:
    !  "note Position Angle convention differ in GreG and astronomy"
    call gwcs_projec(huv%gil%a0,huv%gil%d0,-huv%gil%pang,huv%gil%ptyp,proj,error)
    if (error)  return
    call rel_to_abs(proj,newoff(1),newoff(2),newabs(1),newabs(2),1)
    !
    ! Should we set SHIFT = .true. in all cases ?
    ! No: changes are only required if the offsets are non zero.
    shift = any(newoff.ne.0d0)
  endif                  
  !
  ! Check if command line specify another center and/or orientation
  call map_center(line,rname,huv,lshift,newabs,error)
  if (error) return
  !
  ! Shifting is the Combination of Phase-->Pointing conversion
  ! and User requested shift through MAP_CENTER or command line arguments
  shift = shift .or. lshift 
  !
  if (.not.shift) then
    call map_message(seve%w,rname,'No shift required')
  else
    !
    doit = .true.   ! Make absolutely sure we do the shift ...
    call uv_shift (newabs,huv%gil%a0,huv%gil%d0,huv%gil%pang,newoff,doit)
    if (.not.doit) then
      call map_message(seve%w,rname,'Shift is below possible precision')
      return
    endif
    !
    ! Compute observing frequency, and new phase center in wavelengths
    !
    if (precise) then
      nc = huv%gil%nchan
      allocate(rpos(2,nc),stat=ier)
      do i=1,huv%gil%nchan
        freq = gdf_uv_frequency(huv,dble(i))
        rpos(1:2,i) = - freq * f_to_k * newoff(1:2)
      enddo
    else
      nc = 1
      allocate(rpos(2,1),stat=ier)
      freq = gdf_uv_frequency(huv)
      rpos(1:2,1) = - freq * f_to_k * newoff(1:2)
    endif
    !
    ! Define the rotation
    cs  = [1.0,0.0]
    angold = huv%gil%pang
    huv%gil%pang = newabs(3)
    cs(1)  =  cos(huv%gil%pang-angold)
    cs(2)  = -sin(huv%gil%pang-angold)
    !
    ! Recenter all channels, Loop over line table
    ! We work in place - We do not play with UV buffers
    !
    nu = huv%gil%dim(1)
    nv = huv%gil%nvisi
    call shift_uvdata (huv,nu,nv,duv,cs,nc,rpos)
    !
    ! Set the new Phase center
    huv%gil%a0 = newabs(1)
    huv%gil%d0 = newabs(2)  
  endif
  !
  ! Done if Single Field (0) or already Pointing columns (>0)
  if (themap%nfields.ge.0) return
  !
  ! If not: Convert the LOFF - MOFF columns into Pointing columns...
  huv%gil%column_pointer(code_uvt_xoff) = loff
  huv%gil%column_pointer(code_uvt_yoff) = moff
  huv%gil%column_size(code_uvt_xoff) = 1
  huv%gil%column_size(code_uvt_yoff) = 1
  !
  huv%gil%column_pointer(code_uvt_loff) = 0
  huv%gil%column_pointer(code_uvt_moff) = 0
  huv%gil%column_size(code_uvt_loff) = 0
  huv%gil%column_size(code_uvt_moff) = 0
  !
  themap%nfields = abs(themap%nfields)
  !
end subroutine uv_shift_mosaic
!
