/*
 ============================================================================
 Name		: BenchmarkDocument.h
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : Declares document class for application.
 ============================================================================
 */

#ifndef __BENCHMARKDOCUMENT_h__
#define __BENCHMARKDOCUMENT_h__

// INCLUDES
#include <akndoc.h>

// FORWARD DECLARATIONS
class CBenchmarkAppUi;
class CEikApplication;

// CLASS DECLARATION

/**
 * CBenchmarkDocument application class.
 * An instance of class CBenchmarkDocument is the Document part of the
 * AVKON application framework for the Benchmark example application.
 */
class CBenchmarkDocument : public CAknDocument
	{
public:
	// Constructors and destructor

	/**
	 * NewL.
	 * Two-phased constructor.
	 * Construct a CBenchmarkDocument for the AVKON application aApp
	 * using two phase construction, and return a pointer
	 * to the created object.
	 * @param aApp Application creating this document.
	 * @return A pointer to the created instance of CBenchmarkDocument.
	 */
	static CBenchmarkDocument* NewL(CEikApplication& aApp);

	/**
	 * NewLC.
	 * Two-phased constructor.
	 * Construct a CBenchmarkDocument for the AVKON application aApp
	 * using two phase construction, and return a pointer
	 * to the created object.
	 * @param aApp Application creating this document.
	 * @return A pointer to the created instance of CBenchmarkDocument.
	 */
	static CBenchmarkDocument* NewLC(CEikApplication& aApp);

	/**
	 * ~CBenchmarkDocument
	 * Virtual Destructor.
	 */
	virtual ~CBenchmarkDocument();

public:
	// Functions from base classes

	/**
	 * CreateAppUiL
	 * From CEikDocument, CreateAppUiL.
	 * Create a CBenchmarkAppUi object and return a pointer to it.
	 * The object returned is owned by the Uikon framework.
	 * @return Pointer to created instance of AppUi.
	 */
	CEikAppUi* CreateAppUiL();

private:
	// Constructors

	/**
	 * ConstructL
	 * 2nd phase constructor.
	 */
	void ConstructL();

	/**
	 * CBenchmarkDocument.
	 * C++ default constructor.
	 * @param aApp Application creating this document.
	 */
	CBenchmarkDocument(CEikApplication& aApp);

	};

#endif // __BENCHMARKDOCUMENT_h__
// End of File
