/*
 ============================================================================
 Name		: BenchmarkApplication.h
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : Declares main application class.
 ============================================================================
 */

#ifndef __BENCHMARKAPPLICATION_H__
#define __BENCHMARKAPPLICATION_H__

// INCLUDES
#include <aknapp.h>
#include "Benchmark.hrh"

// UID for the application;
// this should correspond to the uid defined in the mmp file
const TUid KUidBenchmarkApp =
	{
	_UID3
	};

// CLASS DECLARATION

/**
 * CBenchmarkApplication application class.
 * Provides factory to create concrete document object.
 * An instance of CBenchmarkApplication is the application part of the
 * AVKON application framework for the Benchmark example application.
 */
class CBenchmarkApplication : public CAknApplication
	{
public:
	// Functions from base classes

	/**
	 * From CApaApplication, AppDllUid.
	 * @return Application's UID (KUidBenchmarkApp).
	 */
	TUid AppDllUid() const;

protected:
	// Functions from base classes

	/**
	 * From CApaApplication, CreateDocumentL.
	 * Creates CBenchmarkDocument document object. The returned
	 * pointer in not owned by the CBenchmarkApplication object.
	 * @return A pointer to the created document object.
	 */
	CApaDocument* CreateDocumentL();
	};

#endif // __BENCHMARKAPPLICATION_H__
// End of File
