/*
 ============================================================================
 Name		: BenchmarkAppView.h
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : Declares view class for application.
 ============================================================================
 */

#ifndef __BENCHMARKAPPVIEW_h__
#define __BENCHMARKAPPVIEW_h__

// INCLUDES
#include <coecntrl.h>

// CLASS DECLARATION
class CBenchmarkAppView : public CCoeControl
	{
public:
	// New methods

	/**
	 * NewL.
	 * Two-phased constructor.
	 * Create a CBenchmarkAppView object, which will draw itself to aRect.
	 * @param aRect The rectangle this view will be drawn to.
	 * @return a pointer to the created instance of CBenchmarkAppView.
	 */
	static CBenchmarkAppView* NewL(const TRect& aRect);

	/**
	 * NewLC.
	 * Two-phased constructor.
	 * Create a CBenchmarkAppView object, which will draw itself
	 * to aRect.
	 * @param aRect Rectangle this view will be drawn to.
	 * @return A pointer to the created instance of CBenchmarkAppView.
	 */
	static CBenchmarkAppView* NewLC(const TRect& aRect);

	/**
	 * ~CBenchmarkAppView
	 * Virtual Destructor.
	 */
	virtual ~CBenchmarkAppView();

public:
	// Functions from base classes

	/**
	 * From CCoeControl, Draw
	 * Draw this CBenchmarkAppView to the screen.
	 * @param aRect the rectangle of this view that needs updating
	 */
	void Draw(const TRect& aRect) const;

	/**
	 * From CoeControl, SizeChanged.
	 * Called by framework when the view size is changed.
	 */
	virtual void SizeChanged();

	/**
	 * From CoeControl, HandlePointerEventL.
	 * Called by framework when a pointer touch event occurs.
	 * Note: although this method is compatible with earlier SDKs, 
	 * it will not be called in SDKs without Touch support.
	 * @param aPointerEvent the information about this event
	 */
	virtual void HandlePointerEventL(const TPointerEvent& aPointerEvent);

private:
	// Constructors

	/**
	 * ConstructL
	 * 2nd phase constructor.
	 * Perform the second phase construction of a
	 * CBenchmarkAppView object.
	 * @param aRect The rectangle this view will be drawn to.
	 */
	void ConstructL(const TRect& aRect);

	/**
	 * CBenchmarkAppView.
	 * C++ default constructor.
	 */
	CBenchmarkAppView();

	};

#endif // __BENCHMARKAPPVIEW_h__
// End of File
