// -*- Mode: C++ -*-

//          GiSTpredicate.cpp
//
// Copyright (c) 1996, Regents of the University of California
// $Header: /cvsroot/gigabase/gigabase/GiST/libGiST/GiSTpredicate.cpp,v 1.1 2008/04/04 11:02:29 knizhnik Exp $

#include "GiST.h"

int PtrPredicate::Consistent(const GiSTentry& entry) const
{
    return !entry.IsLeaf() || entry.Ptr() == page;
}

GiSTobject* PtrPredicate::Copy() const
{
    return new PtrPredicate(page);
}

#ifdef PRINTING_OBJECTS
void PtrPredicate::Print(ostream& os) const
{
    os << "ptr = " << page;
}
#endif
