--# -path=.:prelude

concrete LexiconIce of Lexicon = CatIce **
  open ParadigmsIce, IrregIce, Prelude in {

	lin
		bank_N = mkN "banki" masculine ;
		boss_N = mkN "stjóri" masculine ;
		cousin_N = mkN "frændi" masculine ; -- frænka is the feminine equivalent
		glove_N = mkN "hanski" masculine ;
		lamp_N = mkN "lampi" masculine ;
		pen_N = mkN "penni" masculine ;
		school_N = mkN "skóli" masculine ;
		student_N = mkN "nemandi" masculine ;
		teacher_N = mkN "kennari" masculine ;
		university_N = mkN "háskóli" masculine ;
		window_N = mkN "gluggi" masculine ;
		boat_N = mkN "bátur" masculine ;
		boy_N = mkN "strákur" masculine ;
		cheese_N = mkN "ostur" masculine ;
		dog_N = mkN "hundur" masculine ;
		fish_N = mkN "fiskur" masculine ;
		garden_N = mkN "garður"  masculine ;
		glove_N = mkN "hanski" masculine ;
		hat_N = mkN "hattur" masculine ;
		horse_N = mkN "hestur" masculine ;
		king_N = mkN "konungur" masculine ;
		priest_N = mkN "prestur" masculine ;
		snake_N = mkN "snákur" masculine ;
		sock_N = mkN "sokkur" masculine ;
		belly_N = mkN "magi" masculine ;
		fire_N = mkN "eldur" "eldar" masculine ;
		chair_N = mkN "stóll" masculine ;
		car_N = mkN "bíll" masculine ;
		stone_N = mkN "steinn" masculine ;
		rock_N = mkN "klettur" masculine ;
		wing_N = mkN "vængur" masculine ;
		mouth_N = mkN "munnur" masculine ;
		sand_N = mkN "sandur" masculine ;
		wind_N = mkN "vindur" masculine ;
		worm_N = mkN "ormur" masculine ;
		friend_N = mkN "vinur" "vinar" "vinir" masculine ;
		brother_N2 = mkN2 (mkN "bróðir" "bróður" "bræður" masculine) (mkPrep [] genitive) ;
		father_N2 = mkN2 (mkN "faðir" "föður" "feður" masculine) (mkPrep [] genitive) ;
		man_N = mkN "maður" "manns" "menn" masculine ;
		husband_N = mkCompoundN "eigin" (man_N) ;
		policeman_N = mkCompoundN "lögreglu" (mkN "þjónn" masculine) ; 
		smoke_N = mkN "reykur" "reykjar" "reykir" masculine;
		restaurant_N = mkCompoundN "veitinga" (mkN "staður" "staðar" "staðir" masculine) ;
		road_N = mkN "vegur" "vegar" "vegir" masculine ;
		forest_N = mkN "skógur" masculine ;
		enemy_N = mkCompoundN "ó" (friend_N) ;
		peace_N = mkN "friður" masculine ;
		industry_N = mkN "iðnaður" masculine ;
		leg_N = mkCompoundN "fót" (mkN "leggur" "leggjar" "leggir" masculine) ;
		beer_N = mkN "öl" neuter ;
		bird_N = mkN "fugl" masculine ;
		cat_N = mkN "köttur" "kattar" "kettir" masculine ;
		sky_N = mkN "himinn" masculine ;
		neck_N = mkN "háls" masculine ;
		snow_N = mkN "snjór" masculine ;
		ice_N = mkN "ís" masculine ;
		head_N = mkN "haus" masculine ;
		foot_N = mkN "fótur" "fætur" masculine ;
		day_N = mkN "dagur" masculine ;
		bark_N = mkN "börkur" "barkar" "berkir" masculine ;
		wood_N = mkN "viður" "viðar" "viðir" masculine ;
		fruit_N = mkN "ávöxtur" "ávaxtar" "ávextir" masculine ;
		shoe_N = mkN "skór" "skór" masculine ;
		sea_N = mkN "sjór" "sjó" "sjó" "sjós" "sjóir" "sjói" "sjóum" "sjóa" masculine ;
		paper_N = mkN "pappír" masculine ;
		doctor_N = mkN "læknir" "lækni" "lækni" "læknis" "læknar" "lækna" "læknum" "lækna" masculine ;
		fridge_N = mkCompoundN "ís" (mkN "skápur" "skáps" "skápar" masculine) ;
		cap_N = mkN "húfa" feminine ;
		fat_N = mkN "fita" feminine ;
		fog_N = mkN "þoka" feminine ;
		tail_N = mkN "rófa" feminine ;
		apple_N = mkN "epli" neuter ;
		baby_N = mkN "barn" neuter ;
		bike_N = mkN "hjól" neuter ;
		boot_N = mkN "sígvél" neuter ;
		bread_N = mkN "brauð" neuter ;
		butter_N = mkN "smjör" neuter ;
		carpet_N = mkN "teppi" neuter ;
		ceiling_N = mkN "loft" neuter ;
		child_N = mkN "barn" neuter ;
		country_N = mkN "land" neuter ;
		floor_N = mkN "gólf" neuter ;
		house_N = mkN "hús" neuter ;
		lake_N = mkN "vatn" neuter ;
		meat_N = mkN "kjöt" neuter ;
		moon_N = mkN "tungl" neuter ;
		mountain_N = mkN "fjall" neuter ;
		newspaper_N = mkN "dagblað" neuter ;
		plastic_N = mkN "plat" neuter ;
		radio_N = mkN "útvarp" neuter ;
		religion_N = mkN "trúarbragð" neuter ;
		roof_N = mkN "þak" neuter ;
		rubber_N = mkN "gúmmí" neuter ;
		ship_N = mkN "skip" neuter ;
		silver_N = mkN "silfur" neuter ;
		steel_N = mkN "stál" neuter ;
		table_N = mkN "borð" neuter ;
		television_N = mkN "sjónvarp" neuter ;
		village_N = mkN "þorp" neuter ;
		war_N = mkN "stríð" neuter ;
		water_N = mkN "vatn" neuter ;
		wine_N = mkN "vín" neuter ;
		song_N = mkN "lag" neuter ;
		number_N = mkN "númer" neuter ;
		animal_N = mkN "dýr" neuter ;
		back_N = mkN "bak" neuter ;
		blood_N = mkN "blóð" neuter ;
		bone_N = mkN "bein" neuter ;
		breast_N = mkN "brjóst" neuter ;
		dust_N = mkN "ryk" neuter ;
		ear_N = mkN "eyra" neuter ;
		egg_N = mkN "egg" neuter ;
		eye_N = mkN "auga" neuter ;
		flower_N = mkN "blóm" neuter ;
		grass_N = mkN "gras" neuter ;
		hair_N = mkN "hár" neuter ;
		heart_N = mkN "hjarta" neuter ;
		horn_N = mkN "horn" neuter ;
		knee_N = mkN "hné" neuter ;
		leaf_N = mkN "lauf" neuter ;
		name_N = mkN "nafn" neuter ;
		nose_N = mkN "nef" neuter ;
		rope_N = mkN "reipi" neuter ;
		salt_N = mkN "salt" neuter ;
		seed_N = mkN "fræ" neuter ;
		stick_N = mkN "prik" neuter ;
		year_N = mkN "ár" neuter ;
		language_N = mkN "tungumál" neuter ;
		gold_N = mkN "gull" neuter ;
		iron_N = mkN "járn" neuter ;
		leather_N = mkN "leður" neuter ;


		airplane_N = mkN "flugvél" "flugvélar" feminine ;
		apartment_N = mkN "íbúð" "íbúðir" feminine ;
		art_N = mkN "list" "listir" feminine ;
		camera_N = mkN "myndavél" "myndavélar" feminine ;
		church_N = mkN "kirkja" feminine ;
		city_N = mkN "borg" "borgir" feminine ;
		coat_N = mkN "kápa" feminine ;
		computer_N = mkN "tölva" feminine ;
		door_N = mkN "hurð" "hurðir" feminine ;
		girl_N = mkNPlGen "stelpa" feminine ;
		harbour_N = mkN "höfn" "hafnir" feminine ;
		hill_N = mkN "hæð" "hæðir" feminine ;
		love_N = mkN "ást" "ástir" feminine ;
		oil_N = mkN "olía" feminine ;
		planet_N = mkN "pláneta" feminine ;
		queen_N = mkN "drottning" feminine ;
		shirt_N = mkN "skyrta" feminine ;
		shop_N = mkN "búð" "búðir" feminine ;
		sister_N = mkN "systir" "systur" feminine ;
		star_N = mkN "stjarna" feminine ;
		stove_N = mkN "eldavél" "eldavélar" feminine ;
		sun_N = mkN "sól" "sólir" feminine ;
		train_N = mkN "lest" "lestir" feminine ;
		earth_N = mkN "jörð" "jarðir" feminine ;
		feather_N = mkN "fjöður" "fjaðrir" feminine ;
		fog_N = mkN "þoka" feminine ;
		guts_N = mkN "görn" "garnir" feminine ;
		liver_N = mkN "lifur" "lifrar" feminine ;
		person_N = mkN "persóna" feminine ;
		rain_N = mkN "rigning" feminine ;
		skin_N = mkN "húð" "húðir" feminine ;
		tongue_N = mkNPlGen "tunga" feminine ;
		rule_N = mkN "regla" feminine ;
		question_N = mkN "spurning" feminine ;
		reason_N = mkNPlGen "ástæða" feminine ;
		river_N = mkN "á" "ár" feminine ;
		louse_N = mkN "lús" "lýs" feminine ;
		book_N = mkN "bók" "bókar" "bækur" feminine ;
		night_N = mkN "nótt" "nætur" "nætur" "nótta" feminine ;
		root_N = mkN "rót" "rótar" "rætur" feminine ;
		factory = mkN "verksmiðja" feminine ;
		fingernail_N = mkN "nögl" "naglar" "neglur" feminine ;
		sheep_N = mkN "kind" "kindar" "kindur" feminine ;
		tooth_N = mkN "tönn" "tannar" "tennur" feminine ;
		mother_N2 = mkN2 (mkN "móðir" "mæður" feminine) (mkPrep [] genitive) ;
		distance_N3 = mkN3 (mkN "vegalend" "vegalengdir" feminine) (mkPrep "frá" dative) (mkPrep "til" genitive) ;
		ashes_N = mkN "aska" feminine ;
		woman_N = mkN "kona" "konu" "konur" "kvenna" feminine ;
		wife_N = mkCompoundN "eigin" (woman_N) ;
		cow_N = mkN "belja" feminine ;
		factory_N = mkN "verksmiðja" feminine ;
		milk_N = mkN "mjólk" "mjólk" "mjólk" "mjólkur" "mjólk" "mjólk" "mjólk" "mjólkur" feminine ;
		music_N = mkN "tónlist" "tónlist" "tónlist" "tónlistar" "tónlist" "tónlist" "tónlist" "tónlistar" feminine ;
		fat_N = mkN "fita" feminine ;
		hand_N = mkN "hönd" "hönd" "hendi" "handar" "hendur" "hendur" "höndum" "handa" feminine ;
		grammar_N = mkN "málfræði" "málfræði" "málfræði" "málfræði" "málfræði" "málfræði" "málfræði" "málfræði" feminine ;
		tree_N = mkN "tré" neuter ;
		-- either vísindi (neuter and only in plural) or fræði (feminine and only in singular) :)
		--science_N
		paris_PN = mkPN "París" feminine ;
		cloud_N = mkN "ský" neuter ;
		-- left_Ord =
		bad_A = mkA "vondur" "vond" "verri" ;
		beautiful_A = mkA "fallegur" ;
		big_A = mkA "stór" "stór" "stærri" ;
		black_A = mkA "svartur" ;
		blue_A = mkA "blár" "blá" ;
		broad_A = mkA "breiður" ;
		brown_A = mkA "brúnn" ;
		clean_A = mkA "hreinn" ;
		clever_A = mkA "klár" "klár" ;
		cold_A = mkA "kaldur" ;
		dirty_A = mkA "skítugur" ;
		empty_A = mkA "tómur" ;
		easy_A2V = mkA2 (mkA "auðveldur") (lin Prep {s = "fyrir"; c = accusative}) ;
		fun_AV = mkA "skemmtilegur" ;
		good_A = mkA "góður" "góð" "betri" ;
		green_A = mkA "grænn" ;
		hot_A = mkA "heitur" ;
		important_A = mkA "mikilvægur" ;
		long_A = mkA "langur" ;
		married_A2 = mkA2 (mkA "giftur") (lin Prep {s = []; c = dative}) ;
		narrow_A = mkA "þröngur" ;
		new_A = mkA "nýr" "ný" ;
		--old_A = mkA "gamall"
		probable_AS = mkA "líklegur" ;
		red_A = mkA "rauður" ;
		short_A = mkA "stuttur" "stutt" "syttri" ;
		small_A = mkA "lítill" "lítil" "minni" ;
		stupid_A = mkA "heimskur" ;
		thick_A = mkA "þykkur" ;
		thin_A = mkA "þunnur" "þunn" "þynnri" ;
		ugly_A = mkA "ljótur" ;
		warm_A = mkA "heitur" ;
		white_A = mkA "hvítur" ;
		yellow_A = mkA "gulur" ;
		young_A = mkA "ungur" "ung" "yngri" ;
		correct_A = mkA "réttur" ;
		dry_A = mkA "þurr" "þurr" ;
		dull_A = mkA "leðinilegur" ;
		full_A = mkA "fullur" ;
		heavy_A = mkA "þungur" "þung" "þyngri" ;
		near_A = mkA "nálægur" ;
		rotten_A = mkA "rotinn" ;
		round_A = mkA "kringlóttur" ;
		sharp_A = mkA "beittur" ;
		smooth_A = mkA "sléttur" ;
		straight_A = mkA "beinn" ;
		wet_A = mkA "blautur" ;
		wide_A = mkA "víður" ;
		ready_A = mkA "tilbúinn" ;
		uncertain_A = mkA "óviss" "óviss" "óvissari" ;
		--other_A = regA "other" ;

		-- Old paradigms
		already_Adv = mkAdv "þegar" ;
		far_Adv = mkAdv "langt" ;
		fly_V = IrregIce.fljúga_V ;
		john_PN = mkPN "Jón" masculine ;

		now_Adv = mkAdv "núna" ;
		today_Adv = mkAdv "í dag" ;

		
		live_V = mkV "lifa" ;
		stop_V = mkV "stansa" "stansa" "stansaði" "stansaður" ;
		jump_V = mkV "hoppa" "hoppa" ;
		breathe_V = mkV "anda" "anda" "andaði" "andaður"; -- some bug somewhere...
		sew_V = mkV "sauma" "sauma" "saumaði" "saumaður" ;
		smell_V = mkV "þefa" "þefa" "þefaði" "þefaður" ;
		spit_V = mkV "hrækja" ;
		swell_V = mkV "bólgna" "bólgna" "bólgnaði" "bólgnaður" ;
		swim_V = mkV "synda" ;
		think_V = mkV "hugsa" "hugsa" "hugsaði" "hugsaður" ;
		vomit_V = mkV "æla" ;

		love_V2 = mkV2 (mkV "elska" "elska" "elskaði" "elskaður") ;
		listen_V2 = mkV2 (mkV "hlusta" "hlusta" "hlustaði" "hlustaður") (mkPrep "á" accusative) ;
		close_V2 = mkV2 (mkV "loka" "loka" "lokaði" "lokaður") ;
		answer_V2S = mkV2 (mkV "svara" "svara" "svaraði" "svaraður") (mkPrep "" dative) ;
		eat_V2 = mkV2 (mkV "borða" "borða" "borðaði" "borðaður") ;
		forget_V2 = mkV2 (mkV "gleyma") ;
		hate_V2 = mkV2 (mkV "hata" "hata" "hataði" "hataður") ;
		hear_V2 = mkV2 (mkV "heyra") ;
		learn_V2 = mkV2 (mkV "læra") ;
		lose_V2 = mkV2 (mkV "týna") ;
		open_V2 = mkV2 (mkV "opna" "opna" "opnaði" "opnaður") ;
		paint_V2A = mkV2 (mkV "mála" "mála" "málaði" "málaður") ;
		speak_V2 = mkV2 (mkV "tala" "tala" "talaði" "talaður") ;
		teach_V2 = mkV2 (mkV "kenna") ;
		understand_V2 = mkV2 (mkV "skilja") ;
		watch_V2 = mkV2 (mkV "horfa") ;
		write_V2 = mkV2 (mkV "skrifa" "skrifa" "skrifaði" "skrifaður") ;
		do_V2 = mkV2 (mkV "gera") ;
		count_V2 = mkV2 (mkV "telja") ;
		cut_V2 = mkV2 (mkV "klippa") ;
		hit_V2 = mkV2 (mkV "berja") ;
		hunt_V2 = mkV2 (mkV "veiða") ;
		pull_V2 = mkV2 (mkV "toga" "toga" "togaði" "togaður") ;
		push_V2 = mkV2 (mkV "ýta") ;
		rub_V2 = mkV2 (mkV "nudda" "nudda" "nuddaði" "nuddaður") ;
		scratch_V2 = mkV2 (mkV "klóra" "klóra" "klóraði" "klóraður") ;
		split_V2 = mkV2 (mkV "skipta") ;
		squeeze_V2 = mkV2 (mkV "kreista") ;
		throw_V2 = mkV2 (mkV "kasta" "kasta" "kastaði" "kastaður") ;

		turn_V = mkV "beygja" "beygi" ;
		bite_V2 = mkV2 IrregIce.bíta_V ;
		break_V2 = mkV2 IrregIce.brjóta_V ;
		wait_V2 = mkV2 (IrregIce.bíða_V) (mkPrep "eftir" dative) ;
		wash_V2 = mkV2 IrregIce.þrífa_V ;
		suck_V2 = mkV2 IrregIce.sjúga_V ;
		wipe_V2 = mkV2 IrregIce.strjúka_V ;
		lie_V = IrregIce.ljúga_V ;
		freeze_V = IrregIce.frjósa_V ;
		float_V = IrregIce.fljóta_V ;
		flow_V = mkV "flæða" ;
		go_V = IrregIce.fara_V ;
		leave_V2 = mkV2 IrregIce.fara_V ;
		seek_V2 = mkV2 (mkV "leita" "leita" "leitaði" "leitaður") ;
		travel_V = mkV "ferða" "ferða" "ferðaði" "ferðaður" ; -- this verb only exists in the middle voice
		know_V2 = mkV2 IrregIce.vita_V ;
		know_VQ = IrregIce.vita_V ;
		know_VS = IrregIce.vita_V ;
		ask_V2Q = mkV2 (mkV "spyrja" "spyr" "spurði" "spurður") (mkPrep "" accusative) ;
		find_V2 = mkV2 IrregIce.finna_V ;
		win_V2 = mkV2 IrregIce.vinna_V ;
		fall_V = IrregIce.detta_V ;
		burn_V = IrregIce.brenna_V ;
		drink_V2 = mkV2 IrregIce.drekka_V ;
		add_V3 = mkV3 (mkV "bæta" "bæti" "bætti" "bættur") (mkPrep "" dative) (mkPrep "við" accusative) ;
		beg_V2V = mkV3 IrregIce.biðja_V (mkPrep "" accusative) (mkPrep "um að" accusative) ;
		read_V2 = mkV2 IrregIce.lesa_V ;
		kill_V2 = mkV2 IrregIce.drepa_V ;
		give_V3 = mkV3 IrregIce.gefa_V ;
		sit_V = IrregIce.sitja_V ;
		hope_VS = mkV "vona" "vona" "vonaði" "vonaður" ;
		wonder_VQ = mkV "velta" ;
		play_V2 = mkV2 IrregIce.leika_V ;
		laugh_V = IrregIce.hlæja_V ;
		hold_V2 = mkV2 IrregIce.halda_V ;
		die_V = IrregIce.deyja_V ;
		run_V = IrregIce.hlaupa_V ;
		walk_V = IrregIce.ganga_V ;
		dig_V = IrregIce.grafa_V ;
		see_V2 = mkV2 IrregIce.sjá_V ;
		blow_V = IrregIce.blása_V ;
		sleep_V = IrregIce.sofa_V ;
		put_V2 = mkV2 IrregIce.láta_V ;
		buy_V2 = mkV2 (mkV "kaupa" "kaupi" "keypti" "keyptur" "keypt") ;
		tie_V2 = mkV2 IrregIce.binda_V ;
		stab_V2 = mkV2 IrregIce.stinga_V ;
		come_V = IrregIce.koma_V ;
		play_V = IrregIce.leika_V ;
		sing_V = IrregIce.syngja_V ;
		stand_V = IrregIce.standa_V ;
		become_VA = IrregIce.verða_V ;
		talk_V3 = mkV3 (mkV "tala" "tala" "talaði" "talaður") (mkPrep "við" accusative) (mkPrep "um" accusative) ;
		send_V3 = mkV3 (mkV "senda") (mkPrep "" accusative) (mkPrep "með" accusative) ;
		say_VS = mkV "segja" "segi" "sagði" "sagður";
		sell_V3 = mkV3 (mkV "selja") (mkPrep "" dative) (mkPrep "" dative) ;
} ;
