--# -path=.:../../translator

concrete LargeLibraryBrowserAPI of LargeLibraryBrowser = open Prelude in {

lincat 
  A, A2, AP, AdA, AdN, AdV, Adv, Ant, CAdv, CN, Card, Cl, ClSlash, Comp, Conj, Det, Dig, Digit, Digits, 
  IAdv, IComp, IDet, IP, IQuant, Imp, Interj, ListAP, ListAdv, 
  ListCN, ListIAdv, ListNP, ListRS, ListS, N, N2, N3, NP, Num, Numeral, 
  Ord, PConj, PN, Phr, Pol, Predet, Prep, Pron, QCl, QS, QVP, Quant, RCl, RP, RS, S, SC, SSlash, 
  Sub10, Sub100, Sub1000, Sub1000000, Subj, Temp, Tense, Text, Utt, V, V2, V2A, V2Q, V2S, V2V, V3, 
  VA, VP, VPSlash, VQ, VS, VV, Voc = Term ;

oper Term = {s : Str ; f,x,swap : Str ; par : Str * Str ; flat : Bool} ;

oper mkTerm = overload {
  mkTerm : Str -> Term = \f -> 
    {s = f ; f = f ; x,swap = [] ; par = noPar ; flat = False} ;
  mkTerm : Str -> Term -> Term = \f,x -> 
    appTerm f (fullTerm x) ;
  mkTerm : Str -> (_,_ : Term) -> Term = \f,x,y -> 
    appTerm f (concatTerm x y) ; 
  mkTerm : Str -> (_,_,_ : Term) -> Term = \f,x,y,z -> 
    appTerm f (fullTerm x ++ concatTerm y z) ; 
  mkTerm : Str -> (_,_,_,_ : Term) -> Term = \f,x,y,z,u -> 
    appTerm f (fullTerm x ++ fullTerm y ++ fullTerm z ++ fullTerm u) ;
  } ;

  noPar  = <[],[]> ;
  yesPar = <"(",")"> ;

  appTerm : Str -> Str -> Term = \f,x -> {s = f ++ x ; f = f ; x = x ; swap = [] ; par = yesPar ; flat = False} ;
  useTerm : Term -> Str = \t -> t.f ++ t.x ++ t.swap ;
  fullTerm : Term -> Str = \t -> t.par.p1 ++ t.f ++ t.x ++ t.swap ++ t.par.p2 ;
  flatTerm : Term -> Term = \t -> {s = t.x ; f = [] ; x = t.x ; swap = t.swap ; par = noPar ; flat = False} ;
  flatIfTerm : Term -> Term = \t -> case t.flat of {
    True  => flatTerm t ;
    False => t
    } ;
  mkFlat : Term -> Term = \t -> {s = t.s ; f = t.f ; x = t.x ; swap = t.swap ; par = t.par ; flat = True} ;
  mkSwap : Term -> Term = \t -> {s = t.s ; f = t.f ; x = [] ; swap = t.x ; par = t.par ; flat = False} ;
  mkSwapTerm : Str -> Term -> Term -> Term = \f,x,y -> 
    let xs = fullTerm x ; ys = fullTerm y in
    {s = f ++ xs ++ ys ; f = f ; x = xs ; swap = ys ; par = yesPar ; flat = False} ;
  concatTerm : Term -> Term -> Str = \t,u ->
    (t.par.p1 ++ t.f ++ t.x ++ t.par.p2 ++ fullTerm u ++ t.swap) ;

  hide : Str -> Str = \f -> [] ;
  hideOpt : Str -> Str = \f -> [] | f ;

lin AAnter = mkTerm "anteriorAnt" ;
lin ASimul = mkTerm (hideOpt "simultaneousAnt") ;
lin AdAP ada_1 ap_2 = mkTerm "mkAP" ada_1 (flatIfTerm ap_2) ;
lin AdAdv ada_1 adv_2 = mkTerm "mkAdv" ada_1 adv_2 ;
lin AdNum adn_1 card_2 = mkTerm "mkCard" adn_1 card_2 ;
lin AdVVP adv_1 vp_2 = mkTerm "mkVP" adv_1 vp_2 ;
lin AdVVPSlash adv_1 vpslash_2 = mkTerm "mkVPSlash" adv_1 vpslash_2 ;
--lin AddAdvQVP qvp_1 iadv_2 = mkTerm "mkQVP" qvp_1 iadv_2 ;
lin AdjCN ap_1 cn_2 = mkTerm "mkCN" ap_1 cn_2 ;
lin AdjOrd ord_1 = mkTerm "mkAP" ord_1 ;
lin AdnCAdv cadv_1 = mkTerm "mkAdN" cadv_1 ;
lin AdvAP ap_1 adv_2 = mkTerm "mkAP" ap_1 adv_2 ;
lin AdvCN cn_1 adv_2 = mkTerm "mkCN" cn_1 adv_2 ;
lin AdvIAdv iadv_1 adv_2 = mkTerm "mkIAdv" iadv_1 adv_2 ;
lin AdvIP ip_1 adv_2 = mkTerm "mkIP" ip_1 adv_2 ;
lin AdvNP np_1 adv_2 = mkTerm "mkNP" np_1 adv_2 ;
--lin AdvQVP vp_1 iadv_2 = mkTerm "mkQVP" vp_1 iadv_2 ;
lin AdvS adv_1 s_2 = mkTerm "mkS" adv_1 s_2 ;
lin AdvSlash clslash_1 adv_2 = mkTerm "mkClSlash" clslash_1 adv_2 ;
lin AdvVP vp_1 adv_2 = mkTerm "mkVP" vp_1 adv_2 ;
lin AdvVPSlash vpslash_1 adv_2 = mkTerm "mkVPSlash" vpslash_1 adv_2 ;
lin ApposCN cn_1 np_2 = mkTerm "mkCN" cn_1 np_2 ;
lin BaseAP ap_1 ap_2 = mkFlat (mkTerm "mkListAP" ap_1 ap_2) ;
lin BaseAdv adv_1 adv_2 = mkFlat (mkTerm "mkListAdv" adv_1 adv_2) ;
lin BaseCN cn_1 cn_2 = mkTerm "mkListCN" cn_1 cn_2 ;
--lin BaseIAdv iadv_1 iadv_2 = mkTerm "mkListIAdv" iadv_1 iadv_2 ;
lin BaseNP np_1 np_2 =mkFlat (mkTerm "mkListNP" np_1 np_2) ;
lin BaseRS rs_1 rs_2 = mkTerm "mkListRS" rs_1 rs_2 ;
lin BaseS s_1 s_2 = mkFlat (mkTerm "mkListS" s_1 s_2) ;
lin CAdvAP cadv_1 ap_2 np_3 = mkTerm "mkAP" cadv_1 ap_2 np_3 ;
lin CleftAdv adv_1 s_2 = mkTerm "mkCl" adv_1 s_2 ;
lin CleftNP np_1 rs_2 = mkTerm "mkCl" np_1 rs_2 ;
lin CompAP ap_1 = mkFlat (mkTerm "mkComp" (flatIfTerm ap_1)) ;
lin CompAdv adv_1 = mkFlat (mkTerm "mkComp" adv_1) ;
lin CompCN cn_1 = mkFlat (mkTerm "mkComp" (flatIfTerm cn_1)) ;
lin CompIAdv iadv_1 = mkTerm "mkIComp" iadv_1 ;
lin CompIP ip_1 = mkTerm "mkIComp" ip_1 ;
lin CompNP np_1 = mkFlat (mkTerm "mkComp" np_1) ;
lin ComparA a_1 np_2 = mkTerm "comparAP" a_1 np_2 ;
lin ComparAdvAdj cadv_1 a_2 np_3 = mkTerm "mkAdv" cadv_1 a_2 np_3 ;
lin ComparAdvAdjS cadv_1 a_2 s_3 = mkTerm "mkAdv" cadv_1 a_2 s_3 ;
lin ComplA2 a2_1 np_2 = mkTerm "mkAP" a2_1 np_2 ;
lin ComplN2 n2_1 np_2 = mkTerm "mkCN" (flatIfTerm n2_1) np_2 ;
lin ComplN3 n3_1 np_2 = mkFlat (mkTerm "mkN2" n3_1 np_2) ;
lin ComplSlash vpslash_1 np_2 = mkFlat (mkTerm "mkVP" (flatIfTerm vpslash_1) np_2) ;
--lin ComplSlashIP vpslash_1 ip_2 = mkTerm "mkQVP" vpslash_1 ip_2 ;
lin ComplVA va_1 ap_2 = mkFlat (mkTerm "mkVP" va_1 (flatIfTerm ap_2)) ;
lin ComplVQ vq_1 qs_2 = mkTerm "mkVP" vq_1 qs_2 ;
lin ComplVS vs_1 s_2 = mkTerm "mkVP" vs_1 s_2 ;
lin ComplVV vv_1 vp_2 = mkFlat (mkTerm "mkVP" vv_1 vp_2) ;
lin ConjAP conj_1 listap_2 = mkTerm "mkAP" conj_1 (flatIfTerm listap_2) ;
lin ConjAdv conj_1 listadv_2 = mkTerm "mkAdv" conj_1 (flatIfTerm listadv_2) ;
lin ConjCN conj_1 listcn_2 = mkTerm "mkCN" conj_1 listcn_2 ;
lin ConjIAdv conj_1 listiadv_2 = mkTerm "mkIAdv" conj_1 listiadv_2 ;
lin ConjNP conj_1 listnp_2 = mkTerm "mkNP" conj_1 (flatIfTerm listnp_2) ;
lin ConjRS conj_1 listrs_2 = mkTerm "mkRS" conj_1 listrs_2 ;
lin ConjS conj_1 lists_2 = mkTerm "mkS" conj_1 (flatIfTerm lists_2) ;
lin ConsAP ap_1 listap_2 = mkTerm "mkListAP" ap_1 listap_2 ;
lin ConsAdv adv_1 listadv_2 = mkTerm "mkListAdv" adv_1 listadv_2 ;
lin ConsCN cn_1 listcn_2 = mkTerm "mkListCN" cn_1 listcn_2 ;
--lin ConsIAdv iadv_1 listiadv_2 = mkTerm "mkListIAdv" iadv_1 listiadv_2 ;
lin ConsNP np_1 listnp_2 = mkTerm "mkListNP" np_1 listnp_2 ;
lin ConsRS rs_1 listrs_2 = mkTerm "mkListRS" rs_1 listrs_2 ;
lin ConsS s_1 lists_2 = mkTerm "mkListS" s_1 lists_2 ;
lin D_0 = mkTerm "n0_Dig" ;
lin D_1 = mkTerm "n1_Dig" ;
lin D_2 = mkTerm "n2_Dig" ;
lin D_3 = mkTerm "n3_Dig" ;
lin D_4 = mkTerm "n4_Dig" ;
lin D_5 = mkTerm "n5_Dig" ;
lin D_6 = mkTerm "n6_Dig" ;
lin D_7 = mkTerm "n7_Dig" ;
lin D_8 = mkTerm "n8_Dig" ;
lin D_9 = mkTerm "n9_Dig" ;
lin DefArt = mkTerm "the_Quant" ;
lin DetCN det_1 cn_2 = mkTerm "mkNP" (flatIfTerm det_1) (flatIfTerm cn_2) ;
lin DetNP det_1 = mkTerm "mkNP" det_1 ;
lin DetQuant quant_1 num_2 = mkFlat (mkTerm "mkDet" quant_1 num_2) ;
lin DetQuantOrd quant_1 num_2 ord_3 = mkTerm "mkDet" quant_1 num_2 ord_3 ;
lin EmbedQS qs_1 = mkTerm "mkSC" qs_1 ;
lin EmbedS s_1 = mkTerm "mkSC" s_1 ;
lin EmbedVP vp_1 = mkTerm "mkSC" vp_1 ;
lin ExistIP ip_1 = mkTerm "mkQCl" ip_1 ;
lin ExistNP np_1 = mkTerm "mkCl" np_1 ;
lin ExtAdvS adv_1 s_2 = mkTerm "mkS" adv_1 s_2 ;
lin FunRP prep_1 np_2 rp_3 = mkTerm "mkRP" prep_1 np_2 rp_3 ;
lin GenericCl vp_1 = mkTerm "genericCl" vp_1 ;
lin IDig dig_1 = mkTerm "mkDigits" (mkTerm "\"999999\"") ; -- mkTerm "mkDigits" dig_1 ;
lin IIDig dig_1 digits_2 = mkTerm "mkDigits" (mkTerm "\"999\"") ; -- mkTerm "mkDigits" dig_1 digits_2 ;
lin IdRP = mkTerm "which_RP" ;
lin IdetCN idet_1 cn_2 = mkTerm "mkIP" idet_1 cn_2 ;
lin IdetIP idet_1 = mkTerm "mkIP" idet_1 ;
lin IdetQuant iquant_1 num_2 = mkTerm "mkIDet" iquant_1 num_2 ;
--lin ImpP3 np_1 vp_2 = mkTerm "mkUtt" np_1 vp_2 ;
lin ImpPl1 vp_1 = mkTerm "lets_Utt" vp_1 ;
lin ImpVP vp_1 = mkTerm "mkImp" vp_1 ;
lin ImpersCl vp_1 = mkTerm "mkCl" vp_1 ;
lin IndefArt = mkTerm "a_Quant" ;
lin MassNP cn_1 = mkTerm "mkNP" cn_1 ;
lin NoPConj = mkTerm (hide "NoPConj") ;
lin NoVoc = mkTerm (hide "NoVoc") ;
lin NumCard card_1 = mkTerm "mkNum" card_1 ;
lin NumDigits digits_1 = mkTerm "mkCard" digits_1 ;
lin NumNumeral numeral_1 = mkTerm "mkCard" numeral_1 ;
lin NumPl = mkTerm "pluralNum" ;
lin NumSg = mkTerm (hideOpt "singularNum") ;
lin OrdDigits digits_1 = mkTerm "mkOrd" digits_1 ;
lin OrdNumeral numeral_1 = mkTerm "mkOrd" numeral_1 ;
lin OrdSuperl a_1 = mkTerm "mkOrd" a_1 ;
lin PConjConj conj_1 = mkTerm "mkPConj" conj_1 ;
lin PNeg = mkTerm "negativePol" ;
lin PPartNP np_1 v2_2 = mkTerm "mkNP" np_1 v2_2 ;
lin PPos = mkTerm (hideOpt "positivePol") ;
lin PassV2 v2_1 = mkTerm "passiveVP" v2_1 ;
lin PhrUtt pconj_1 utt_2 voc_3 = mkFlat (mkTerm "mkPhr" pconj_1 utt_2 voc_3) ;
lin PositA a_1 = mkFlat (mkTerm "mkAP" a_1) ;
lin PositAdAAdj a_1 = mkTerm "mkAdA" a_1 ;
lin PositAdvAdj a_1 = mkTerm "mkAdv" a_1 ;
lin PossPron pron_1 = mkTerm "mkQuant" pron_1 ;
lin PredSCVP sc_1 vp_2 = mkTerm "mkCl" sc_1 vp_2 ;
--lin PredVP np_1 vp_2 = mkTerm "mkCl" np_1 vp_2 ;
lin PredVP np_1 vp_2 = mkTerm "mkCl" np_1 (flatIfTerm vp_2) ;
lin PredetNP predet_1 np_2 = mkTerm "mkNP" predet_1 np_2 ;
lin PrepIP prep_1 ip_2 = mkTerm "mkIAdv" prep_1 ip_2 ;
lin PrepNP prep_1 np_2 = mkTerm "mkAdv" prep_1 np_2 ;
lin ProgrVP vp_1 = mkTerm "progressiveVP" vp_1 ;
lin QuestCl cl_1 = mkTerm "mkQCl" cl_1 ;
lin QuestIAdv iadv_1 cl_2 = mkTerm "mkQCl" iadv_1 cl_2 ;
lin QuestIComp icomp_1 np_2 = mkTerm "mkQCl" icomp_1 np_2 ;
lin QuestQVP ip_1 qvp_2 = mkTerm "mkQCl" ip_1 qvp_2 ;
lin QuestSlash ip_1 clslash_2 = mkTerm "mkQCl" ip_1 clslash_2 ;
lin QuestVP ip_1 vp_2 = mkTerm "mkQCl" ip_1 (flatIfTerm vp_2) ;
lin ReflA2 a2_1 = mkTerm "reflAP" a2_1 ;
lin ReflVP vpslash_1 = mkTerm "reflexiveVP" vpslash_1 ;
lin RelCN cn_1 rs_2 = mkTerm "mkCN" cn_1 rs_2 ;
lin RelCl cl_1 = mkTerm "mkRCl" cl_1 ;
lin RelNP np_1 rs_2 = mkTerm "mkNP" np_1 rs_2 ;
lin RelS s_1 rs_2 = mkTerm "mkS" s_1 rs_2 ;
lin RelSlash rp_1 clslash_2 = mkTerm "mkRCl" rp_1 clslash_2 ;
lin RelVP rp_1 vp_2 = mkTerm "mkRCl" rp_1 (flatIfTerm vp_2) ;
lin SSubjS s_1 subj_2 s_3 = mkTerm "mkS" s_1 subj_2 s_3 ;
lin SentAP ap_1 sc_2 = mkTerm "mkAP" ap_1 sc_2 ;
lin SentCN cn_1 sc_2 = mkTerm "mkCN" cn_1 sc_2 ;
lin Slash2V3 v3_1 np_2 = mkTerm "mkVPSlash" v3_1 np_2 ;
lin Slash3V3 v3_1 np_2 = mkFlat (mkSwapTerm "mkVPSlash" v3_1 np_2) ;
lin SlashPrep cl_1 prep_2 = mkTerm "mkClSlash" cl_1 prep_2 ;
lin SlashV2A v2a_1 ap_2 = mkFlat (mkSwapTerm "mkVPSlash" v2a_1 ap_2) ;
lin SlashV2Q v2q_1 qs_2 = mkFlat (mkSwapTerm "mkVPSlash" v2q_1 qs_2) ;
lin SlashV2S v2s_1 s_2 = mkFlat (mkSwapTerm "mkVPSlash" v2s_1 s_2) ;
lin SlashV2V v2v_1 vp_2 = mkFlat (mkSwapTerm "mkVPSlash" v2v_1 vp_2) ;
lin SlashV2VNP v2v_1 np_2 vpslash_3 = mkTerm "mkVPSlash" v2v_1 np_2 vpslash_3 ;
lin SlashV2a v2_1 = mkFlat (mkTerm "mkVPSlash" v2_1) ;
lin SlashVP np_1 vpslash_2 = mkTerm "mkClSlash" np_1 vpslash_2 ;
lin SlashVS np_1 vs_2 sslash_3 = mkTerm "mkClSlash" np_1 vs_2 sslash_3 ;
lin SlashVV vv_1 vpslash_2 = mkTerm "mkVPSlash" vv_1 vpslash_2 ;
lin SubjS subj_1 s_2 = mkTerm "mkAdv" subj_1 s_2 ;
lin TEmpty = mkTerm (hideOpt "emptyText") ;
lin TExclMark phr_1 text_2 = mkTerm "mkText" (flatIfTerm phr_1) (mkTerm "exclMarkPunct") text_2 ;
lin TFullStop phr_1 text_2 = mkTerm "mkText" (flatIfTerm phr_1) text_2 ;
lin TCond = mkTerm "conditionalTense" ;
lin TFut = mkTerm "futureTense" ;
lin TPast = mkTerm "pastTense" ;
lin TPres = mkTerm (hideOpt "presentTense") ;
lin TQuestMark phr_1 text_2 = mkTerm "mkText" (flatIfTerm phr_1) (mkTerm "questMarkPunct") text_2 ;
lin TTAnt tense_1 ant_2 = mkTerm "mkTense" tense_1 ant_2 ;
--lin Use2N3 n3_1 = mkTerm "mkN2" n3_1 ;
--lin Use3N3 n3_1 = mkTerm "mkN2" n3_1 ;
lin UseA2 a2_1 = mkTerm "mkAP" a2_1 ;
lin UseCl temp_1 pol_2 cl_3 = mkTerm "mkS" (flatTerm temp_1) pol_2 cl_3 ;
lin UseComp comp_1 = mkFlat (mkTerm "mkVP" (flatIfTerm comp_1)) ;
lin UseComparA a_1 = mkTerm "mkAP" a_1 ;
--lin UseCopula = mkTerm "UseCopula" ;
lin UseN n_1 = mkFlat (mkTerm "mkCN" n_1) ;
lin UseN2 n2_1 = mkTerm "mkCN" n2_1 ;
lin UsePN pn_1 = mkTerm "mkNP" pn_1 ;
lin UsePron pron_1 = mkTerm "mkNP" pron_1 ;
lin UseQCl temp_1 pol_2 qcl_3 = mkTerm "mkQS" (flatTerm temp_1) pol_2 qcl_3 ;
lin UseRCl temp_1 pol_2 rcl_3 = mkTerm "mkRS" (flatTerm temp_1) pol_2 rcl_3 ;
lin UseSlash temp_1 pol_2 clslash_3 = mkTerm "mkSSlash" temp_1 pol_2 clslash_3 ;
lin UseV v_1 = mkFlat (mkTerm "mkVP" v_1) ;
lin UttAP ap_1 = mkTerm "mkUtt" ap_1 ;
lin UttAdv adv_1 = mkTerm "mkUtt" adv_1 ;
lin UttCN cn_1 = mkTerm "mkUtt" cn_1 ;
lin UttCard card_1 = mkTerm "mkUtt" card_1 ;
lin UttIAdv iadv_1 = mkTerm "mkUtt" iadv_1 ;
lin UttIP ip_1 = mkTerm "mkUtt" ip_1 ;
lin UttImpPl pol_1 imp_2 = mkTerm "mkUtt" (mkTerm "pluralImpForm") pol_1 imp_2 ;
lin UttImpPol pol_1 imp_2 = mkTerm "mkUtt" (mkTerm "politeImpForm") pol_1 imp_2 ;
lin UttImpSg pol_1 imp_2 = mkTerm "mkUtt" pol_1 imp_2 ;
--lin UttInterj interj_1 = mkTerm "mkUtt" interj_1 ;
lin UttNP np_1 = mkTerm "mkUtt" np_1 ;
lin UttQS qs_1 = mkFlat (mkTerm "mkUtt" qs_1) ;
lin UttS s_1 = mkFlat (mkTerm "mkUtt" s_1) ;
lin UttVP vp_1 = mkTerm "mkUtt" vp_1 ;
lin VocNP np_1 = mkTerm "mkVoc" np_1 ;

  lin
    i_NP = mkTerm "i_NP" ;
    you_NP = mkTerm "you_NP" ;
    he_NP = mkTerm "he_NP" ;
    she_NP = mkTerm "she_NP" ;
    we_NP = mkTerm "we_NP" ;
    youPl_NP = mkTerm "youPl_NP" ;
    youPol_NP = mkTerm "youPol_NP" ;
    they_NP = mkTerm "they_NP" ;

    a_Det = mkTerm "a_Det" ;
    the_Det = mkTerm "the_Det" ;
    aPl_Det = mkTerm "aPl_Det" ;
    thePl_Det = mkTerm "thePl_Det" ;

lin above_Prep = mkTerm "above_Prep" ;
lin after_Prep = mkTerm "after_Prep" ;
lin all_Predet = mkTerm "all_Predet" ;
lin almost_AdA = mkTerm "almost_AdA" ;
lin almost_AdN = mkTerm "almost_AdN" ;
lin although_Subj = mkTerm "although_Subj" ;
lin always_AdV = mkTerm "always_AdV" ;
lin and_Conj = mkTerm "and_Conj" ;
lin as_CAdv = mkTerm "as_CAdv" ;
lin at_least_AdN = mkTerm "at_least_AdN" ;
lin at_most_AdN = mkTerm "at_most_AdN" ;
lin because_Subj = mkTerm "because_Subj" ;
lin before_Prep = mkTerm "before_Prep" ;
lin behind_Prep = mkTerm "behind_Prep" ;
lin between_Prep = mkTerm "between_Prep" ;
lin both7and_DConj = mkTerm "both7and_DConj" ;
lin but_PConj = mkTerm "but_PConj" ;
lin by8agent_Prep = mkTerm "by8agent_Prep" ;
lin by8means_Prep = mkTerm "by8means_Prep" ;
lin can8know_VV = mkTerm "can8know_VV" ;
lin can_VV = mkTerm "can_VV" ;
lin during_Prep = mkTerm "during_Prep" ;
lin either7or_DConj = mkTerm "either7or_DConj" ;
lin every_Det = mkTerm "every_Det" ;
lin everybody_NP = mkTerm "everybody_NP" ;
lin everything_NP = mkTerm "everything_NP" ;
lin everywhere_Adv = mkTerm "everywhere_Adv" ;
lin except_Prep = mkTerm "except_Prep" ;
lin few_Det = mkTerm "few_Det" ;
lin for_Prep = mkTerm "for_Prep" ;
lin from_Prep = mkTerm "from_Prep" ;
lin have_V2 = mkTerm "have_V2" ;
lin he_Pron = mkTerm "he_Pron" ;
lin here7from_Adv = mkTerm "here7from_Adv" ;
lin here7to_Adv = mkTerm "here7to_Adv" ;
lin here_Adv = mkTerm "here_Adv" ;
lin how8many_IDet = mkTerm "how8many_IDet" ;
lin how8much_IAdv = mkTerm "how8much_IAdv" ;
lin how_IAdv = mkTerm "how_IAdv" ;
lin i_Pron = mkTerm "i_Pron" ;
lin if_Subj = mkTerm "if_Subj" ;
lin if_then_Conj = mkTerm "if_then_Conj" ;
lin in8front_Prep = mkTerm "in8front_Prep" ;
lin in_Prep = mkTerm "in_Prep" ;
lin it_Pron = mkTerm "it_Pron" ;
lin language_title_Utt = mkTerm "language_title_Utt" ;
lin less_CAdv = mkTerm "less_CAdv" ;
lin many_Det = mkTerm "many_Det" ;
lin more_CAdv = mkTerm "more_CAdv" ;
lin most_Predet = mkTerm "most_Predet" ;
lin much_Det = mkTerm "much_Det" ;
lin must_VV = mkTerm "must_VV" ;
lin no_Quant = mkTerm "no_Quant" ;
lin no_Utt = mkTerm "no_Utt" ;
lin nobody_NP = mkTerm "nobody_NP" ;
lin not_Predet = mkTerm "not_Predet" ;
lin nothing_NP = mkTerm "nothing_NP" ;
lin on_Prep = mkTerm "on_Prep" ;
lin only_Predet = mkTerm "only_Predet" ;
lin or_Conj = mkTerm "or_Conj" ;
lin otherwise_PConj = mkTerm "otherwise_PConj" ;
lin part_Prep = mkTerm "part_Prep" ;
lin please_Voc = mkTerm "please_Voc" ;
lin possess_Prep = mkTerm "possess_Prep" ;
lin quite_Adv = mkTerm "quite_Adv" ;
lin she_Pron = mkTerm "she_Pron" ;
lin so_AdA = mkTerm "so_AdA" ;
lin somePl_Det = mkTerm "somePl_Det" ;
lin someSg_Det = mkTerm "someSg_Det" ;
lin somebody_NP = mkTerm "somebody_NP" ;
lin something_NP = mkTerm "something_NP" ;
lin somewhere_Adv = mkTerm "somewhere_Adv" ;
lin that_Quant = mkTerm "that_Quant" ;
lin that_Subj = mkTerm "that_Subj" ;
lin there7from_Adv = mkTerm "there7from_Adv" ;
lin there7to_Adv = mkTerm "there7to_Adv" ;
lin there_Adv = mkTerm "there_Adv" ;
lin therefore_PConj = mkTerm "therefore_PConj" ;
lin they_Pron = mkTerm "they_Pron" ;
lin this_Quant = mkTerm "this_Quant" ;
lin through_Prep = mkTerm "through_Prep" ;
lin to_Prep = mkTerm "to_Prep" ;
lin too_AdA = mkTerm "too_AdA" ;
lin under_Prep = mkTerm "under_Prep" ;
lin very_AdA = mkTerm "very_AdA" ;
lin want_VV = mkTerm "want_VV" ;
lin we_Pron = mkTerm "we_Pron" ;
lin whatPl_IP = mkTerm "whatPl_IP" ;
lin whatSg_IP = mkTerm "whatSg_IP" ;
lin when_IAdv = mkTerm "when_IAdv" ;
lin when_Subj = mkTerm "when_Subj" ;
lin where_IAdv = mkTerm "where_IAdv" ;
lin which_IQuant = mkTerm "which_IQuant" ;
lin whoPl_IP = mkTerm "whoPl_IP" ;
lin whoSg_IP = mkTerm "whoSg_IP" ;
lin why_IAdv = mkTerm "why_IAdv" ;
lin with_Prep = mkTerm "with_Prep" ;
lin without_Prep = mkTerm "without_Prep" ;
lin yes_Utt = mkTerm "yes_Utt" ;
lin youPl_Pron = mkTerm "youPl_Pron" ;
lin youPol_Pron = mkTerm "youPol_Pron" ;
lin youSg_Pron = mkTerm "youSg_Pron" ;
lin a_bomb_N = mkTerm "a_bomb_N" ;
lin a_fortiori_Adv = mkTerm "a_fortiori_Adv" ;
lin a_la_carte_Adv = mkTerm "a_la_carte_Adv" ;
lin a_la_mode_Adv = mkTerm "a_la_mode_Adv" ;
lin a_level_N = mkTerm "a_level_N" ;
lin a_posteriori_A = mkTerm "a_posteriori_A" ;
lin a_priori_A = mkTerm "a_priori_A" ;
lin aa_N = mkTerm "aa_N" ;
lin aachen_PN = mkTerm "aachen_PN" ;
lin aalii_N = mkTerm "aalii_N" ;
lin aardvark_N = mkTerm "aardvark_N" ;
lin aardwolf_N = mkTerm "aardwolf_N" ;
lin aarhus_PN = mkTerm "aarhus_PN" ;
lin ab_initio_Adv = mkTerm "ab_initio_Adv" ;
lin aba_N = mkTerm "aba_N" ;
lin abaca_N = mkTerm "abaca_N" ;
lin aback_Adv = mkTerm "aback_Adv" ;
lin abactinal_A = mkTerm "abactinal_A" ;
lin abacus_N = mkTerm "abacus_N" ;
lin abaft_Adv = mkTerm "abaft_Adv" ;
lin abaft_Prep = mkTerm "abaft_Prep" ;
lin abalone_N = mkTerm "abalone_N" ;
lin abampere_N = mkTerm "abampere_N" ;
lin abandon_N = mkTerm "abandon_N" ;
lin abandon_V2 = mkTerm "abandon_V2" ;
lin abandonment_N = mkTerm "abandonment_N" ;
lin abarticulation_N = mkTerm "abarticulation_N" ;
lin abase_V2 = mkTerm "abase_V2" ;
lin abasement_N = mkTerm "abasement_N" ;
lin abash_V2 = mkTerm "abash_V2" ;
lin abashment_N = mkTerm "abashment_N" ;
lin abasia_N = mkTerm "abasia_N" ;
lin abasic_A = mkTerm "abasic_A" ;
lin abatable_A = mkTerm "abatable_A" ;
lin abate_V = mkTerm "abate_V" ;
lin abate_V2 = mkTerm "abate_V2" ;
lin abatement_N = mkTerm "abatement_N" ;
lin abator_N = mkTerm "abator_N" ;
lin abattis_N = mkTerm "abattis_N" ;
lin abattoir_N = mkTerm "abattoir_N" ;
lin abaxial_A = mkTerm "abaxial_A" ;
lin abaya_N = mkTerm "abaya_N" ;
lin abbacy_N = mkTerm "abbacy_N" ;
lin abbatial_A = mkTerm "abbatial_A" ;
lin abbe_N = mkTerm "abbe_N" ;
lin abbess_N = mkTerm "abbess_N" ;
lin abbey_N = mkTerm "abbey_N" ;
lin abbot_N = mkTerm "abbot_N" ;
lin abbreviate_V2 = mkTerm "abbreviate_V2" ;
lin abbreviation_N = mkTerm "abbreviation_N" ;
lin abc_N = mkTerm "abc_N" ;
lin abcoulomb_N = mkTerm "abcoulomb_N" ;
lin abdicable_A = mkTerm "abdicable_A" ;
lin abdicate_V = mkTerm "abdicate_V" ;
lin abdicate_V2 = mkTerm "abdicate_V2" ;
lin abdication_N = mkTerm "abdication_N" ;
lin abdicator_N = mkTerm "abdicator_N" ;
lin abdomen_N = mkTerm "abdomen_N" ;
lin abdominal_A = mkTerm "abdominal_A" ;
lin abdominal_N = mkTerm "abdominal_N" ;
lin abdominocentesis_N = mkTerm "abdominocentesis_N" ;
lin abdominoplasty_N = mkTerm "abdominoplasty_N" ;
lin abdominous_A = mkTerm "abdominous_A" ;
lin abdominousness_N = mkTerm "abdominousness_N" ;
lin abdominovesical_A = mkTerm "abdominovesical_A" ;
lin abducent_A = mkTerm "abducent_A" ;
lin abducent_N = mkTerm "abducent_N" ;
lin abduct_V2 = mkTerm "abduct_V2" ;
lin abduction_N = mkTerm "abduction_N" ;
lin abductor_N = mkTerm "abductor_N" ;
lin abe_PN = mkTerm "abe_PN" ;
lin abeam_Adv = mkTerm "abeam_Adv" ;
lin abecedarian_A = mkTerm "abecedarian_A" ;
lin abecedarian_N = mkTerm "abecedarian_N" ;
lin abecedarius_N = mkTerm "abecedarius_N" ;
lin abed_Adv = mkTerm "abed_Adv" ;
lin abelia_N = mkTerm "abelia_N" ;
lin abelian_A = mkTerm "abelian_A" ;
lin abelmosk_N = mkTerm "abelmosk_N" ;
lin abercarn_PN = mkTerm "abercarn_PN" ;
lin aberdare_PN = mkTerm "aberdare_PN" ;
lin aberdeen_PN = mkTerm "aberdeen_PN" ;
lin abergavenny_PN = mkTerm "abergavenny_PN" ;
lin abergele_PN = mkTerm "abergele_PN" ;
lin aberrance_N = mkTerm "aberrance_N" ;
lin aberrant_A = mkTerm "aberrant_A" ;
lin aberrant_N = mkTerm "aberrant_N" ;
lin aberration_N = mkTerm "aberration_N" ;
lin abertillery_PN = mkTerm "abertillery_PN" ;
lin aberystwyth_PN = mkTerm "aberystwyth_PN" ;
lin abet_V = mkTerm "abet_V" ;
lin abet_V2 = mkTerm "abet_V2" ;
lin abetalipoproteinemia_N = mkTerm "abetalipoproteinemia_N" ;
lin abetment_N = mkTerm "abetment_N" ;
lin abettor_N = mkTerm "abettor_N" ;
lin abeyance_N = mkTerm "abeyance_N" ;
lin abeyant_A = mkTerm "abeyant_A" ;
lin abfarad_N = mkTerm "abfarad_N" ;
lin abhenry_N = mkTerm "abhenry_N" ;
lin abhor_V2 = mkTerm "abhor_V2" ;
lin abhorrence_N = mkTerm "abhorrence_N" ;
lin abhorrent_A = mkTerm "abhorrent_A" ;
lin abhorrer_N = mkTerm "abhorrer_N" ;
lin abidance_N = mkTerm "abidance_N" ;
lin abide_V = mkTerm "abide_V" ;
lin abide_V2 = mkTerm "abide_V2" ;
lin abide_by_V2 = mkTerm "abide_by_V2" ;
lin abience_N = mkTerm "abience_N" ;
lin abient_A = mkTerm "abient_A" ;
lin ability_N = mkTerm "ability_N" ;
lin abingdon_PN = mkTerm "abingdon_PN" ;
lin abiogenesis_N = mkTerm "abiogenesis_N" ;
lin abiogenetic_A = mkTerm "abiogenetic_A" ;
lin abiogenist_N = mkTerm "abiogenist_N" ;
lin abiotrophy_N = mkTerm "abiotrophy_N" ;
lin abject_A = mkTerm "abject_A" ;
lin abjection_N = mkTerm "abjection_N" ;
lin abjuration_N = mkTerm "abjuration_N" ;
lin abjure_V2 = mkTerm "abjure_V2" ;
lin abjurer_N = mkTerm "abjurer_N" ;
lin ablactation_N = mkTerm "ablactation_N" ;
lin ablated_A = mkTerm "ablated_A" ;
lin ablation_N = mkTerm "ablation_N" ;
lin ablative_A = mkTerm "ablative_A" ;
lin ablative_N = mkTerm "ablative_N" ;
lin ablaut_N = mkTerm "ablaut_N" ;
lin ablaze_A = mkTerm "ablaze_A" ;
lin able_A = mkTerm "able_A" ;
lin able_bodied_A = mkTerm "able_bodied_A" ;
lin ableism_N = mkTerm "ableism_N" ;
lin ablepharia_N = mkTerm "ablepharia_N" ;
lin abloom_A = mkTerm "abloom_A" ;
lin ablution_N = mkTerm "ablution_N" ;
lin ablutionary_A = mkTerm "ablutionary_A" ;
lin abnegation_N = mkTerm "abnegation_N" ;
lin abnegator_N = mkTerm "abnegator_N" ;
lin abnormal_A = mkTerm "abnormal_A" ;
lin abnormality_N = mkTerm "abnormality_N" ;
lin abo_N = mkTerm "abo_N" ;
lin aboard_Adv = mkTerm "aboard_Adv" ;
lin aboard_Prep = mkTerm "aboard_Prep" ;
lin abocclusion_N = mkTerm "abocclusion_N" ;
lin abode_N = mkTerm "abode_N" ;
lin abohm_N = mkTerm "abohm_N" ;
lin abolish_V2 = mkTerm "abolish_V2" ;
lin abolishable_A = mkTerm "abolishable_A" ;
lin abolition_N = mkTerm "abolition_N" ;
lin abolitionary_A = mkTerm "abolitionary_A" ;
lin abolitionism_N = mkTerm "abolitionism_N" ;
lin abolitionist_N = mkTerm "abolitionist_N" ;
lin abomasal_A = mkTerm "abomasal_A" ;
lin abomasum_N = mkTerm "abomasum_N" ;
lin abominable_A = mkTerm "abominable_A" ;
lin abominate_V2 = mkTerm "abominate_V2" ;
lin abomination_N = mkTerm "abomination_N" ;
lin abominator_N = mkTerm "abominator_N" ;
lin aborad_Adv = mkTerm "aborad_Adv" ;
lin aboral_A = mkTerm "aboral_A" ;
lin aboriginal_A = mkTerm "aboriginal_A" ;
lin aborigine_N = mkTerm "aborigine_N" ;
lin abort_N = mkTerm "abort_N" ;
lin abort_V = mkTerm "abort_V" ;
lin abort_V2 = mkTerm "abort_V2" ;
lin aborticide_N = mkTerm "aborticide_N" ;
lin abortifacient_A = mkTerm "abortifacient_A" ;
lin abortifacient_N = mkTerm "abortifacient_N" ;
lin abortion_N = mkTerm "abortion_N" ;
lin abortionistFem_N = mkTerm "abortionistFem_N" ;
lin abortionistMasc_N = mkTerm "abortionistMasc_N" ;
lin abortive_A = mkTerm "abortive_A" ;
lin abortus_N = mkTerm "abortus_N" ;
lin abound_V = mkTerm "abound_V" ;
lin about_AdN = mkTerm "about_AdN" ;
lin about_Adv = mkTerm "about_Adv" ;
lin about_Prep = mkTerm "about_Prep" ;
lin about_face_N = mkTerm "about_face_N" ;
lin about_face_V = mkTerm "about_face_V" ;
lin above_A = mkTerm "above_A" ;
lin above_Adv = mkTerm "above_Adv" ;
lin above_N = mkTerm "above_N" ;
lin above_board_A = mkTerm "above_board_A" ;
lin above_board_Adv = mkTerm "above_board_Adv" ;
lin above_mentioned_A = mkTerm "above_mentioned_A" ;
lin above_named_A = mkTerm "above_named_A" ;
lin aboveboard_A = mkTerm "aboveboard_A" ;
lin aboveground_A = mkTerm "aboveground_A" ;
lin abracadabra_N = mkTerm "abracadabra_N" ;
lin abrachia_N = mkTerm "abrachia_N" ;
lin abrade_V2 = mkTerm "abrade_V2" ;
lin abrader_N = mkTerm "abrader_N" ;
lin abraham_PN = mkTerm "abraham_PN" ;
lin abranchiate_A = mkTerm "abranchiate_A" ;
lin abrasion_N = mkTerm "abrasion_N" ;
lin abrasive_A = mkTerm "abrasive_A" ;
lin abrasive_N = mkTerm "abrasive_N" ;
lin abrasiveness_N = mkTerm "abrasiveness_N" ;
lin abreast_Adv = mkTerm "abreast_Adv" ;
lin abridge_V2 = mkTerm "abridge_V2" ;
lin abridgement_N = mkTerm "abridgement_N" ;
lin abridger_N = mkTerm "abridger_N" ;
lin abroach_A = mkTerm "abroach_A" ;
lin abroad_A = mkTerm "abroad_A" ;
lin abroad_Adv = mkTerm "abroad_Adv" ;
lin abrocome_N = mkTerm "abrocome_N" ;
lin abrogate_V2 = mkTerm "abrogate_V2" ;
lin abrogation_N = mkTerm "abrogation_N" ;
lin abrogator_N = mkTerm "abrogator_N" ;
lin abrupt_A = mkTerm "abrupt_A" ;
lin abruptness_N = mkTerm "abruptness_N" ;
lin abscess_N = mkTerm "abscess_N" ;
lin abscessed_A = mkTerm "abscessed_A" ;
lin abscissa_N = mkTerm "abscissa_N" ;
lin abscission_N = mkTerm "abscission_N" ;
lin abscond_V = mkTerm "abscond_V" ;
lin absconder_N = mkTerm "absconder_N" ;
lin abscondment_N = mkTerm "abscondment_N" ;
lin abseiler_N = mkTerm "abseiler_N" ;
lin absence_N = mkTerm "absence_N" ;
lin absent_A = mkTerm "absent_A" ;
lin absent_Prep = mkTerm "absent_Prep" ;
lin absent_V2 = mkTerm "absent_V2" ;
lin absent_minded_A = mkTerm "absent_minded_A" ;
lin absentee_N = mkTerm "absentee_N" ;
lin absenteeism_N = mkTerm "absenteeism_N" ;
lin absentmindedness_N = mkTerm "absentmindedness_N" ;
lin absinthe_N = mkTerm "absinthe_N" ;
lin absolute_A = mkTerm "absolute_A" ;
lin absolute_N = mkTerm "absolute_N" ;
lin absoluteness_N = mkTerm "absoluteness_N" ;
lin absolution_N = mkTerm "absolution_N" ;
lin absolutism_N = mkTerm "absolutism_N" ;
lin absolutist_A = mkTerm "absolutist_A" ;
lin absolutist_N = mkTerm "absolutist_N" ;
lin absolve_V2 = mkTerm "absolve_V2" ;
lin absolver_N = mkTerm "absolver_N" ;
lin absolvitory_A = mkTerm "absolvitory_A" ;
lin absorb_V2 = mkTerm "absorb_V2" ;
lin absorbable_A = mkTerm "absorbable_A" ;
lin absorbate_N = mkTerm "absorbate_N" ;
lin absorbefacient_A = mkTerm "absorbefacient_A" ;
lin absorbency_N = mkTerm "absorbency_N" ;
lin absorbent_A = mkTerm "absorbent_A" ;
lin absorbent_N = mkTerm "absorbent_N" ;
lin absorber_N = mkTerm "absorber_N" ;
lin absorbing_A = mkTerm "absorbing_A" ;
lin absorption_N = mkTerm "absorption_N" ;
lin absorptivity_N = mkTerm "absorptivity_N" ;
lin abstain_V = mkTerm "abstain_V" ;
lin abstainer_N = mkTerm "abstainer_N" ;
lin abstemious_A = mkTerm "abstemious_A" ;
lin abstemiousness_N = mkTerm "abstemiousness_N" ;
lin abstention_N = mkTerm "abstention_N" ;
lin abstinence_N = mkTerm "abstinence_N" ;
lin abstinent_A = mkTerm "abstinent_A" ;
lin abstract_A = mkTerm "abstract_A" ;
lin abstract_N = mkTerm "abstract_N" ;
lin abstract_V2 = mkTerm "abstract_V2" ;
lin abstractedness_N = mkTerm "abstractedness_N" ;
lin abstraction_N = mkTerm "abstraction_N" ;
lin abstractionism_N = mkTerm "abstractionism_N" ;
lin abstractionist_N = mkTerm "abstractionist_N" ;
lin abstractive_A = mkTerm "abstractive_A" ;
lin abstractness_N = mkTerm "abstractness_N" ;
lin abstractor_N = mkTerm "abstractor_N" ;
lin abstruse_A = mkTerm "abstruse_A" ;
lin abstruseness_N = mkTerm "abstruseness_N" ;
lin absurd_A = mkTerm "absurd_A" ;
lin absurd_N = mkTerm "absurd_N" ;
lin absurdity_N = mkTerm "absurdity_N" ;
lin abulia_N = mkTerm "abulia_N" ;
lin abulic_A = mkTerm "abulic_A" ;
lin abundance_N = mkTerm "abundance_N" ;
lin abundant_A = mkTerm "abundant_A" ;
lin abuse_N = mkTerm "abuse_N" ;
lin abuse_V2 = mkTerm "abuse_V2" ;
lin abuser_N = mkTerm "abuser_N" ;
lin abusive_A = mkTerm "abusive_A" ;
lin abut_V = mkTerm "abut_V" ;
lin abutment_N = mkTerm "abutment_N" ;
lin abutter_N = mkTerm "abutter_N" ;
lin abuzz_A = mkTerm "abuzz_A" ;
lin abvolt_N = mkTerm "abvolt_N" ;
lin abwatt_N = mkTerm "abwatt_N" ;
lin abysm_N = mkTerm "abysm_N" ;
lin abysmal_A = mkTerm "abysmal_A" ;
lin abyss_N = mkTerm "abyss_N" ;
lin abyssal_A = mkTerm "abyssal_A" ;
lin acacia_N = mkTerm "acacia_N" ;
lin academia_N = mkTerm "academia_N" ;
lin academic_A = mkTerm "academic_A" ;
lin academic_N = mkTerm "academic_N" ;
lin academicianFem_N = mkTerm "academicianFem_N" ;
lin academicianMasc_N = mkTerm "academicianMasc_N" ;
lin academicianship_N = mkTerm "academicianship_N" ;
lin academy_N = mkTerm "academy_N" ;
lin acanthion_N = mkTerm "acanthion_N" ;
lin acanthocephalan_N = mkTerm "acanthocephalan_N" ;
lin acanthocyte_N = mkTerm "acanthocyte_N" ;
lin acanthocytosis_N = mkTerm "acanthocytosis_N" ;
lin acanthoid_A = mkTerm "acanthoid_A" ;
lin acantholysis_N = mkTerm "acantholysis_N" ;
lin acanthoma_N = mkTerm "acanthoma_N" ;
lin acanthosis_N = mkTerm "acanthosis_N" ;
lin acanthotic_A = mkTerm "acanthotic_A" ;
lin acanthus_N = mkTerm "acanthus_N" ;
lin acapnic_A = mkTerm "acapnic_A" ;
lin acardia_N = mkTerm "acardia_N" ;
lin acariasis_N = mkTerm "acariasis_N" ;
lin acaricide_N = mkTerm "acaricide_N" ;
lin acarid_N = mkTerm "acarid_N" ;
lin acarine_N = mkTerm "acarine_N" ;
lin acarophobia_N = mkTerm "acarophobia_N" ;
lin acarpelous_A = mkTerm "acarpelous_A" ;
lin acarpous_A = mkTerm "acarpous_A" ;
lin acarus_N = mkTerm "acarus_N" ;
lin acatalectic_A = mkTerm "acatalectic_A" ;
lin acatalectic_N = mkTerm "acatalectic_N" ;
lin acataphasia_N = mkTerm "acataphasia_N" ;
lin acathexia_N = mkTerm "acathexia_N" ;
lin acathexis_N = mkTerm "acathexis_N" ;
lin acaudate_A = mkTerm "acaudate_A" ;
lin acaulescent_A = mkTerm "acaulescent_A" ;
lin accede_V = mkTerm "accede_V" ;
lin accelerando_A = mkTerm "accelerando_A" ;
lin accelerando_Adv = mkTerm "accelerando_Adv" ;
lin accelerando_N = mkTerm "accelerando_N" ;
lin accelerate_V = mkTerm "accelerate_V" ;
lin accelerate_V2 = mkTerm "accelerate_V2" ;
lin acceleration_N = mkTerm "acceleration_N" ;
lin accelerative_A = mkTerm "accelerative_A" ;
lin accelerator_N = mkTerm "accelerator_N" ;
lin accelerometer_N = mkTerm "accelerometer_N" ;
lin accent_N = mkTerm "accent_N" ;
lin accent_V2 = mkTerm "accent_V2" ;
lin accentor_N = mkTerm "accentor_N" ;
lin accentual_A = mkTerm "accentual_A" ;
lin accentuate_V2 = mkTerm "accentuate_V2" ;
lin accentuation_N = mkTerm "accentuation_N" ;
lin accept_V = mkTerm "accept_V" ;
lin accept_V2 = mkTerm "accept_V2" ;
lin accept_VS = mkTerm "accept_VS" ;
lin acceptability_N = mkTerm "acceptability_N" ;
lin acceptable_A = mkTerm "acceptable_A" ;
lin acceptance_N = mkTerm "acceptance_N" ;
lin acceptation_N = mkTerm "acceptation_N" ;
lin accepted_A = mkTerm "accepted_A" ;
lin acceptive_A = mkTerm "acceptive_A" ;
lin acceptor_N = mkTerm "acceptor_N" ;
lin access_N = mkTerm "access_N" ;
lin access_V2 = mkTerm "access_V2" ;
lin accessary_A = mkTerm "accessary_A" ;
lin accessary_N = mkTerm "accessary_N" ;
lin accessibility_N = mkTerm "accessibility_N" ;
lin accessible_A = mkTerm "accessible_A" ;
lin accession_N = mkTerm "accession_N" ;
lin accessional_A = mkTerm "accessional_A" ;
lin accessorial_A = mkTerm "accessorial_A" ;
lin accessory_A = mkTerm "accessory_A" ;
lin accessory_N = mkTerm "accessory_N" ;
lin accidence_N = mkTerm "accidence_N" ;
lin accident_N = mkTerm "accident_N" ;
lin accident_prone_A = mkTerm "accident_prone_A" ;
lin accidental_A = mkTerm "accidental_A" ;
lin accidental_N = mkTerm "accidental_N" ;
lin accipitrine_A = mkTerm "accipitrine_A" ;
lin acclaim_N = mkTerm "acclaim_N" ;
lin acclaim_V2 = mkTerm "acclaim_V2" ;
lin acclamation_N = mkTerm "acclamation_N" ;
lin acclimate_V = mkTerm "acclimate_V" ;
lin acclimate_V2 = mkTerm "acclimate_V2" ;
lin acclimation_N = mkTerm "acclimation_N" ;
lin acclimatization_N = mkTerm "acclimatization_N" ;
lin acclimatize_V = mkTerm "acclimatize_V" ;
lin acclimatize_V2 = mkTerm "acclimatize_V2" ;
lin acclivitous_A = mkTerm "acclivitous_A" ;
lin acclivity_N = mkTerm "acclivity_N" ;
lin accolade_N = mkTerm "accolade_N" ;
lin accommodate_V = mkTerm "accommodate_V" ;
lin accommodate_V2 = mkTerm "accommodate_V2" ;
lin accommodation_N = mkTerm "accommodation_N" ;
lin accommodational_A = mkTerm "accommodational_A" ;
lin accommodative_A = mkTerm "accommodative_A" ;
lin accompaniment_N = mkTerm "accompaniment_N" ;
lin accompanist_N = mkTerm "accompanist_N" ;
lin accompany_V2 = mkTerm "accompany_V2" ;
lin accomplice_N = mkTerm "accomplice_N" ;
lin accomplish_V2 = mkTerm "accomplish_V2" ;
lin accomplishable_A = mkTerm "accomplishable_A" ;
lin accomplished_A = mkTerm "accomplished_A" ;
lin accomplishment_N = mkTerm "accomplishment_N" ;
lin accord_N = mkTerm "accord_N" ;
lin accord_V = mkTerm "accord_V" ;
lin accordance_N = mkTerm "accordance_N" ;
lin accordant_A = mkTerm "accordant_A" ;
lin according_to_Prep = mkTerm "according_to_Prep" ;
lin accordingly_Adv = mkTerm "accordingly_Adv" ;
lin accordion_N = mkTerm "accordion_N" ;
lin accordionist_N = mkTerm "accordionist_N" ;
lin accost_V2 = mkTerm "accost_V2" ;
lin accouchement_N = mkTerm "accouchement_N" ;
lin account_N = mkTerm "account_N" ;
lin account_V = mkTerm "account_V" ;
lin account_V2 = mkTerm "account_V2" ;
lin account_for_V2 = mkTerm "account_for_V2" ;
lin accountability_N = mkTerm "accountability_N" ;
lin accountable_A = mkTerm "accountable_A" ;
lin accountancy_N = mkTerm "accountancy_N" ;
lin accountant_N = mkTerm "accountant_N" ;
lin accountantship_N = mkTerm "accountantship_N" ;
lin accounting_A = mkTerm "accounting_A" ;
lin accounting_N = mkTerm "accounting_N" ;
lin accoutered_A = mkTerm "accoutered_A" ;
lin accra_PN = mkTerm "accra_PN" ;
lin accredit_V2 = mkTerm "accredit_V2" ;
lin accreditation_N = mkTerm "accreditation_N" ;
lin accretion_N = mkTerm "accretion_N" ;
lin accretionary_A = mkTerm "accretionary_A" ;
lin accretive_A = mkTerm "accretive_A" ;
lin accrington_PN = mkTerm "accrington_PN" ;
lin accrue_V = mkTerm "accrue_V" ;
lin accrue_V2 = mkTerm "accrue_V2" ;
lin acculturation_N = mkTerm "acculturation_N" ;
lin acculturational_A = mkTerm "acculturational_A" ;
lin accumbent_A = mkTerm "accumbent_A" ;
lin accumulate_V = mkTerm "accumulate_V" ;
lin accumulate_V2 = mkTerm "accumulate_V2" ;
lin accumulation_N = mkTerm "accumulation_N" ;
lin accumulative_A = mkTerm "accumulative_A" ;
lin accumulator_N = mkTerm "accumulator_N" ;
lin accuracy_N = mkTerm "accuracy_N" ;
lin accurate_A = mkTerm "accurate_A" ;
lin accursed_A = mkTerm "accursed_A" ;
lin accurst_A = mkTerm "accurst_A" ;
lin accusation_N = mkTerm "accusation_N" ;
lin accusative_A = mkTerm "accusative_A" ;
lin accusative_N = mkTerm "accusative_N" ;
lin accusatorial_A = mkTerm "accusatorial_A" ;
lin accuse_V2 = mkTerm "accuse_V2" ;
lin accused_A = mkTerm "accused_A" ;
lin accused_N = mkTerm "accused_N" ;
lin accuserFem_N = mkTerm "accuserFem_N" ;
lin accuserMasc_N = mkTerm "accuserMasc_N" ;
lin accusingly_Adv = mkTerm "accusingly_Adv" ;
lin accustom_V2 = mkTerm "accustom_V2" ;
lin ace_A = mkTerm "ace_A" ;
lin ace_N = mkTerm "ace_N" ;
lin acebutolol_N = mkTerm "acebutolol_N" ;
lin acentric_A = mkTerm "acentric_A" ;
lin acephalia_N = mkTerm "acephalia_N" ;
lin acephalous_A = mkTerm "acephalous_A" ;
lin acerate_A = mkTerm "acerate_A" ;
lin acerb_A = mkTerm "acerb_A" ;
lin acerbity_N = mkTerm "acerbity_N" ;
lin acerola_N = mkTerm "acerola_N" ;
lin acervate_A = mkTerm "acervate_A" ;
lin acervulus_N = mkTerm "acervulus_N" ;
lin acetabular_A = mkTerm "acetabular_A" ;
lin acetabulum_N = mkTerm "acetabulum_N" ;
lin acetal_N = mkTerm "acetal_N" ;
lin acetaldehyde_N = mkTerm "acetaldehyde_N" ;
lin acetaldol_N = mkTerm "acetaldol_N" ;
lin acetamide_N = mkTerm "acetamide_N" ;
lin acetaminophen_N = mkTerm "acetaminophen_N" ;
lin acetanilide_N = mkTerm "acetanilide_N" ;
lin acetate_N = mkTerm "acetate_N" ;
lin acetic_A = mkTerm "acetic_A" ;
lin acetin_N = mkTerm "acetin_N" ;
lin acetone_N = mkTerm "acetone_N" ;
lin acetonic_A = mkTerm "acetonic_A" ;
lin acetophenetidin_N = mkTerm "acetophenetidin_N" ;
lin acetose_A = mkTerm "acetose_A" ;
lin acetum_N = mkTerm "acetum_N" ;
lin acetyl_N = mkTerm "acetyl_N" ;
lin acetylation_N = mkTerm "acetylation_N" ;
lin acetylcholine_N = mkTerm "acetylcholine_N" ;
lin acetylene_N = mkTerm "acetylene_N" ;
lin acetylenic_A = mkTerm "acetylenic_A" ;
lin acetylic_A = mkTerm "acetylic_A" ;
lin ache_N = mkTerm "ache_N" ;
lin ache_V = mkTerm "ache_V" ;
lin ache_for_V2 = mkTerm "ache_for_V2" ;
lin achene_N = mkTerm "achene_N" ;
lin achenial_A = mkTerm "achenial_A" ;
lin achievability_N = mkTerm "achievability_N" ;
lin achievable_A = mkTerm "achievable_A" ;
lin achieve_V2 = mkTerm "achieve_V2" ;
lin achievement_N = mkTerm "achievement_N" ;
lin achiever_N = mkTerm "achiever_N" ;
lin achillea_N = mkTerm "achillea_N" ;
lin achilles_PN = mkTerm "achilles_PN" ;
lin achimenes_N = mkTerm "achimenes_N" ;
lin achira_N = mkTerm "achira_N" ;
lin achlamydeous_A = mkTerm "achlamydeous_A" ;
lin achlorhydria_N = mkTerm "achlorhydria_N" ;
lin achlorhydric_A = mkTerm "achlorhydric_A" ;
lin acholia_N = mkTerm "acholia_N" ;
lin achondrite_N = mkTerm "achondrite_N" ;
lin achondritic_A = mkTerm "achondritic_A" ;
lin achondroplasia_N = mkTerm "achondroplasia_N" ;
lin achondroplastic_A = mkTerm "achondroplastic_A" ;
lin achromatic_A = mkTerm "achromatic_A" ;
lin achromatin_N = mkTerm "achromatin_N" ;
lin achromatinic_A = mkTerm "achromatinic_A" ;
lin achromatous_A = mkTerm "achromatous_A" ;
lin achromia_N = mkTerm "achromia_N" ;
lin achromic_A = mkTerm "achromic_A" ;
lin achylia_N = mkTerm "achylia_N" ;
lin acicula_N = mkTerm "acicula_N" ;
lin aciculate_A = mkTerm "aciculate_A" ;
lin acid_A = mkTerm "acid_A" ;
lin acid_N = mkTerm "acid_N" ;
lin acidemia_N = mkTerm "acidemia_N" ;
lin acidic_A = mkTerm "acidic_A" ;
lin acidification_N = mkTerm "acidification_N" ;
lin acidify_V = mkTerm "acidify_V" ;
lin acidify_V2 = mkTerm "acidify_V2" ;
lin acidimetric_A = mkTerm "acidimetric_A" ;
lin acidimetry_N = mkTerm "acidimetry_N" ;
lin acidity_N = mkTerm "acidity_N" ;
lin acidophil_N = mkTerm "acidophil_N" ;
lin acidophilic_A = mkTerm "acidophilic_A" ;
lin acidophilus_N = mkTerm "acidophilus_N" ;
lin acidosis_N = mkTerm "acidosis_N" ;
lin acidotic_A = mkTerm "acidotic_A" ;
lin acidulated_A = mkTerm "acidulated_A" ;
lin acidulous_A = mkTerm "acidulous_A" ;
lin acinar_A = mkTerm "acinar_A" ;
lin acinus_N = mkTerm "acinus_N" ;
lin ack_ack_N = mkTerm "ack_ack_N" ;
lin ackee_N = mkTerm "ackee_N" ;
lin acknowledge_V2 = mkTerm "acknowledge_V2" ;
lin acknowledge_VS = mkTerm "acknowledge_VS" ;
lin acknowledgeable_A = mkTerm "acknowledgeable_A" ;
lin acknowledgement_N = mkTerm "acknowledgement_N" ;
lin acme_N = mkTerm "acme_N" ;
lin acne_N = mkTerm "acne_N" ;
lin acned_A = mkTerm "acned_A" ;
lin acneiform_A = mkTerm "acneiform_A" ;
lin acold_A = mkTerm "acold_A" ;
lin acolyte_N = mkTerm "acolyte_N" ;
lin aconite_N = mkTerm "aconite_N" ;
lin acorea_N = mkTerm "acorea_N" ;
lin acorn_N = mkTerm "acorn_N" ;
lin acorn_cup_N = mkTerm "acorn_cup_N" ;
lin acoustic_A = mkTerm "acoustic_A" ;
lin acoustic_N = mkTerm "acoustic_N" ;
lin acoustician_N = mkTerm "acoustician_N" ;
lin acoustics_N = mkTerm "acoustics_N" ;
lin acquaint_V2 = mkTerm "acquaint_V2" ;
lin acquaintance_N = mkTerm "acquaintance_N" ;
lin acquaintanceship_N = mkTerm "acquaintanceship_N" ;
lin acquiesce_V = mkTerm "acquiesce_V" ;
lin acquiescence_N = mkTerm "acquiescence_N" ;
lin acquiescent_A = mkTerm "acquiescent_A" ;
lin acquirable_A = mkTerm "acquirable_A" ;
lin acquire_V2 = mkTerm "acquire_V2" ;
lin acquirement_N = mkTerm "acquirement_N" ;
lin acquirer_N = mkTerm "acquirer_N" ;
lin acquiring_N = mkTerm "acquiring_N" ;
lin acquisition_N = mkTerm "acquisition_N" ;
lin acquisitive_A = mkTerm "acquisitive_A" ;
lin acquisitiveness_N = mkTerm "acquisitiveness_N" ;
lin acquit_V2 = mkTerm "acquit_V2" ;
lin acquittal_N = mkTerm "acquittal_N" ;
lin acquittance_N = mkTerm "acquittance_N" ;
lin acre_N = mkTerm "acre_N" ;
lin acreage_N = mkTerm "acreage_N" ;
lin acrid_A = mkTerm "acrid_A" ;
lin acridity_N = mkTerm "acridity_N" ;
lin acrimonious_A = mkTerm "acrimonious_A" ;
lin acrimony_N = mkTerm "acrimony_N" ;
lin acritical_A = mkTerm "acritical_A" ;
lin acroanesthesia_N = mkTerm "acroanesthesia_N" ;
lin acrobatFem_N = mkTerm "acrobatFem_N" ;
lin acrobatMasc_N = mkTerm "acrobatMasc_N" ;
lin acrobatic_A = mkTerm "acrobatic_A" ;
lin acrobatics_N = mkTerm "acrobatics_N" ;
lin acrocarp_N = mkTerm "acrocarp_N" ;
lin acrocarpous_A = mkTerm "acrocarpous_A" ;
lin acrocentric_A = mkTerm "acrocentric_A" ;
lin acrocyanosis_N = mkTerm "acrocyanosis_N" ;
lin acrodont_N = mkTerm "acrodont_N" ;
lin acrogen_N = mkTerm "acrogen_N" ;
lin acrogenic_A = mkTerm "acrogenic_A" ;
lin acromegalic_A = mkTerm "acromegalic_A" ;
lin acromegaly_N = mkTerm "acromegaly_N" ;
lin acromicria_N = mkTerm "acromicria_N" ;
lin acromion_N = mkTerm "acromion_N" ;
lin acromphalus_N = mkTerm "acromphalus_N" ;
lin acromyotonia_N = mkTerm "acromyotonia_N" ;
lin acronym_N = mkTerm "acronym_N" ;
lin acronymic_A = mkTerm "acronymic_A" ;
lin acropetal_A = mkTerm "acropetal_A" ;
lin acrophobia_N = mkTerm "acrophobia_N" ;
lin acrophobic_A = mkTerm "acrophobic_A" ;
lin acrophony_N = mkTerm "acrophony_N" ;
lin acropolis_N = mkTerm "acropolis_N" ;
lin acroscopic_A = mkTerm "acroscopic_A" ;
lin acrosome_N = mkTerm "acrosome_N" ;
lin across_Adv = mkTerm "across_Adv" ;
lin across_Prep = mkTerm "across_Prep" ;
lin acrostic_N = mkTerm "acrostic_N" ;
lin acrylamide_N = mkTerm "acrylamide_N" ;
lin acrylic_N = mkTerm "acrylic_N" ;
lin act_N = mkTerm "act_N" ;
lin act_V = mkTerm "act_V" ;
lin act_V2 = mkTerm "act_V2" ;
lin act_on_V2 = mkTerm "act_on_V2" ;
lin act_out_V2 = mkTerm "act_out_V2" ;
lin act_up_V = mkTerm "act_up_V" ;
lin act_upon_V2 = mkTerm "act_upon_V2" ;
lin actable_A = mkTerm "actable_A" ;
lin actin_N = mkTerm "actin_N" ;
lin actinal_A = mkTerm "actinal_A" ;
lin acting_A = mkTerm "acting_A" ;
lin acting_N = mkTerm "acting_N" ;
lin actinia_N = mkTerm "actinia_N" ;
lin actinic_A = mkTerm "actinic_A" ;
lin actinism_N = mkTerm "actinism_N" ;
lin actinium_N = mkTerm "actinium_N" ;
lin actinoid_A = mkTerm "actinoid_A" ;
lin actinoid_N = mkTerm "actinoid_N" ;
lin actinolite_N = mkTerm "actinolite_N" ;
lin actinometer_N = mkTerm "actinometer_N" ;
lin actinometric_A = mkTerm "actinometric_A" ;
lin actinometry_N = mkTerm "actinometry_N" ;
lin actinomorphic_A = mkTerm "actinomorphic_A" ;
lin actinomyces_N = mkTerm "actinomyces_N" ;
lin actinomycetal_A = mkTerm "actinomycetal_A" ;
lin actinomycete_N = mkTerm "actinomycete_N" ;
lin actinomycin_N = mkTerm "actinomycin_N" ;
lin actinomycosis_N = mkTerm "actinomycosis_N" ;
lin actinomycotic_A = mkTerm "actinomycotic_A" ;
lin actinomyxidian_N = mkTerm "actinomyxidian_N" ;
lin actinopod_N = mkTerm "actinopod_N" ;
lin action_N = mkTerm "action_N" ;
lin actionable_A = mkTerm "actionable_A" ;
lin activate_V2 = mkTerm "activate_V2" ;
lin activation_N = mkTerm "activation_N" ;
lin activator_N = mkTerm "activator_N" ;
lin active_A = mkTerm "active_A" ;
lin active_N = mkTerm "active_N" ;
lin activeness_N = mkTerm "activeness_N" ;
lin activism_N = mkTerm "activism_N" ;
lin activistFem_N = mkTerm "activistFem_N" ;
lin activistMasc_N = mkTerm "activistMasc_N" ;
lin activist_A = mkTerm "activist_A" ;
lin activity_N = mkTerm "activity_N" ;
lin actomyosin_N = mkTerm "actomyosin_N" ;
lin actor_1_N = mkTerm "actor_1_N" ;
lin actor_2_N = mkTerm "actor_2_N" ;
lin actress_N = mkTerm "actress_N" ;
lin actual_A = mkTerm "actual_A" ;
lin actuality_N = mkTerm "actuality_N" ;
lin actually_Adv = mkTerm "actually_Adv" ;
lin actuarial_A = mkTerm "actuarial_A" ;
lin actuary_N = mkTerm "actuary_N" ;
lin actuate_V2 = mkTerm "actuate_V2" ;
lin actuator_N = mkTerm "actuator_N" ;
lin acuate_A = mkTerm "acuate_A" ;
lin acuity_N = mkTerm "acuity_N" ;
lin aculea_N = mkTerm "aculea_N" ;
lin aculeate_A = mkTerm "aculeate_A" ;
lin aculeus_N = mkTerm "aculeus_N" ;
lin acumen_N = mkTerm "acumen_N" ;
lin acuminate_A = mkTerm "acuminate_A" ;
lin acupressure_N = mkTerm "acupressure_N" ;
lin acupuncture_N = mkTerm "acupuncture_N" ;
lin acute_A = mkTerm "acute_A" ;
lin acuteness_N = mkTerm "acuteness_N" ;
lin acyclic_A = mkTerm "acyclic_A" ;
lin acyclovir_N = mkTerm "acyclovir_N" ;
lin acyl_N = mkTerm "acyl_N" ;
lin acylation_N = mkTerm "acylation_N" ;
lin ad_N = mkTerm "ad_N" ;
lin ad_PN = mkTerm "ad_PN" ;
lin ad_hoc_A = mkTerm "ad_hoc_A" ;
lin ad_hoc_Adv = mkTerm "ad_hoc_Adv" ;
lin ad_infinitum_Adv = mkTerm "ad_infinitum_Adv" ;
lin ad_interim_Adv = mkTerm "ad_interim_Adv" ;
lin ad_lib_A = mkTerm "ad_lib_A" ;
lin ad_lib_Adv = mkTerm "ad_lib_Adv" ;
lin ad_lib_V = mkTerm "ad_lib_V" ;
lin ad_libitum_Adv = mkTerm "ad_libitum_Adv" ;
lin ad_man_N = mkTerm "ad_man_N" ;
lin ad_nauseam_Adv = mkTerm "ad_nauseam_Adv" ;
lin ad_valorem_Adv = mkTerm "ad_valorem_Adv" ;
lin ada_PN = mkTerm "ada_PN" ;
lin adactylia_N = mkTerm "adactylia_N" ;
lin adactylous_A = mkTerm "adactylous_A" ;
lin adage_N = mkTerm "adage_N" ;
lin adagio_A = mkTerm "adagio_A" ;
lin adagio_Adv = mkTerm "adagio_Adv" ;
lin adagio_N = mkTerm "adagio_N" ;
lin adam_PN = mkTerm "adam_PN" ;
lin adamance_N = mkTerm "adamance_N" ;
lin adamant_A = mkTerm "adamant_A" ;
lin adamant_N = mkTerm "adamant_N" ;
lin adamantine_A = mkTerm "adamantine_A" ;
lin adapt_V = mkTerm "adapt_V" ;
lin adapt_V2 = mkTerm "adapt_V2" ;
lin adaptability_N = mkTerm "adaptability_N" ;
lin adaptable_A = mkTerm "adaptable_A" ;
lin adaptation_N = mkTerm "adaptation_N" ;
lin adaptational_A = mkTerm "adaptational_A" ;
lin adapter_N = mkTerm "adapter_N" ;
lin adaptive_A = mkTerm "adaptive_A" ;
lin adaptor_N = mkTerm "adaptor_N" ;
lin adaxial_A = mkTerm "adaxial_A" ;
lin add_V = mkTerm "add_V" ;
lin add_V2 = mkTerm "add_V2" ;
lin add_VS = mkTerm "add_VS" ;
lin add_in_V = mkTerm "add_in_V" ;
lin add_on_to_V2 = mkTerm "add_on_to_V2" ;
lin add_up_V = mkTerm "add_up_V" ;
lin add_up_V2 = mkTerm "add_up_V2" ;
lin add_up_to_V2 = mkTerm "add_up_to_V2" ;
lin addable_A = mkTerm "addable_A" ;
lin addax_N = mkTerm "addax_N" ;
lin added_A = mkTerm "added_A" ;
lin addend_N = mkTerm "addend_N" ;
lin addendum_N = mkTerm "addendum_N" ;
lin adder_N = mkTerm "adder_N" ;
lin addict_N = mkTerm "addict_N" ;
lin addict_V2 = mkTerm "addict_V2" ;
lin addiction_N = mkTerm "addiction_N" ;
lin addictive_A = mkTerm "addictive_A" ;
lin adding_machine_N = mkTerm "adding_machine_N" ;
lin addis_ababa_PN = mkTerm "addis_ababa_PN" ;
lin addition_N = mkTerm "addition_N" ;
lin additional_A = mkTerm "additional_A" ;
lin additionally_Adv = mkTerm "additionally_Adv" ;
lin additive_A = mkTerm "additive_A" ;
lin additive_N = mkTerm "additive_N" ;
lin addle_A = mkTerm "addle_A" ;
lin addle_V = mkTerm "addle_V" ;
lin addle_V2 = mkTerm "addle_V2" ;
lin addle_brained_A = mkTerm "addle_brained_A" ;
lin addle_head_N = mkTerm "addle_head_N" ;
lin addle_pated_A = mkTerm "addle_pated_A" ;
lin address_N = mkTerm "address_N" ;
lin address_V2 = mkTerm "address_V2" ;
lin addressable_A = mkTerm "addressable_A" ;
lin addressee_N = mkTerm "addressee_N" ;
lin addressograph_N = mkTerm "addressograph_N" ;
lin adduce_V2 = mkTerm "adduce_V2" ;
lin adducent_A = mkTerm "adducent_A" ;
lin adducer_N = mkTerm "adducer_N" ;
lin adducing_N = mkTerm "adducing_N" ;
lin adduct_N = mkTerm "adduct_N" ;
lin adduction_N = mkTerm "adduction_N" ;
lin adductor_N = mkTerm "adductor_N" ;
lin adelaide_PN = mkTerm "adelaide_PN" ;
lin adelgid_N = mkTerm "adelgid_N" ;
lin adenine_N = mkTerm "adenine_N" ;
lin adenitis_N = mkTerm "adenitis_N" ;
lin adenocarcinoma_N = mkTerm "adenocarcinoma_N" ;
lin adenocarcinomatous_A = mkTerm "adenocarcinomatous_A" ;
lin adenoid_A = mkTerm "adenoid_A" ;
lin adenoidal_A = mkTerm "adenoidal_A" ;
lin adenoidectomy_N = mkTerm "adenoidectomy_N" ;
lin adenoma_N = mkTerm "adenoma_N" ;
lin adenomegaly_N = mkTerm "adenomegaly_N" ;
lin adenopathy_N = mkTerm "adenopathy_N" ;
lin adenosine_N = mkTerm "adenosine_N" ;
lin adenovirus_N = mkTerm "adenovirus_N" ;
lin adept_A = mkTerm "adept_A" ;
lin adept_N = mkTerm "adept_N" ;
lin adeptness_N = mkTerm "adeptness_N" ;
lin adequacy_N = mkTerm "adequacy_N" ;
lin adequate_A = mkTerm "adequate_A" ;
lin adesite_N = mkTerm "adesite_N" ;
lin adhere_V = mkTerm "adhere_V" ;
lin adherence_N = mkTerm "adherence_N" ;
lin adherent_A = mkTerm "adherent_A" ;
lin adherent_N = mkTerm "adherent_N" ;
lin adhesion_N = mkTerm "adhesion_N" ;
lin adhesive_A = mkTerm "adhesive_A" ;
lin adhesive_N = mkTerm "adhesive_N" ;
lin adhesiveness_N = mkTerm "adhesiveness_N" ;
lin adhocracy_N = mkTerm "adhocracy_N" ;
lin adiabatic_A = mkTerm "adiabatic_A" ;
lin adience_N = mkTerm "adience_N" ;
lin adient_A = mkTerm "adient_A" ;
lin adieu_N = mkTerm "adieu_N" ;
lin adipose_A = mkTerm "adipose_A" ;
lin adiposity_N = mkTerm "adiposity_N" ;
lin adit_N = mkTerm "adit_N" ;
lin adjacency_N = mkTerm "adjacency_N" ;
lin adjacent_A = mkTerm "adjacent_A" ;
lin adjectival_A = mkTerm "adjectival_A" ;
lin adjective_A = mkTerm "adjective_A" ;
lin adjective_N = mkTerm "adjective_N" ;
lin adjoin_V = mkTerm "adjoin_V" ;
lin adjoin_V2 = mkTerm "adjoin_V2" ;
lin adjourn_V = mkTerm "adjourn_V" ;
lin adjourn_V2 = mkTerm "adjourn_V2" ;
lin adjournment_N = mkTerm "adjournment_N" ;
lin adjudge_V2 = mkTerm "adjudge_V2" ;
lin adjudicate_V = mkTerm "adjudicate_V" ;
lin adjudicate_V2 = mkTerm "adjudicate_V2" ;
lin adjudication_N = mkTerm "adjudication_N" ;
lin adjudicative_A = mkTerm "adjudicative_A" ;
lin adjudicator_N = mkTerm "adjudicator_N" ;
lin adjunct_A = mkTerm "adjunct_A" ;
lin adjunct_N = mkTerm "adjunct_N" ;
lin adjunctive_A = mkTerm "adjunctive_A" ;
lin adjuration_N = mkTerm "adjuration_N" ;
lin adjuratory_A = mkTerm "adjuratory_A" ;
lin adjure_V2 = mkTerm "adjure_V2" ;
lin adjust_V = mkTerm "adjust_V" ;
lin adjust_V2 = mkTerm "adjust_V2" ;
lin adjustable_A = mkTerm "adjustable_A" ;
lin adjuster_N = mkTerm "adjuster_N" ;
lin adjustive_A = mkTerm "adjustive_A" ;
lin adjustment_N = mkTerm "adjustment_N" ;
lin adjutant_N = mkTerm "adjutant_N" ;
lin adjuvant_A = mkTerm "adjuvant_A" ;
lin adjuvant_N = mkTerm "adjuvant_N" ;
lin admass_N = mkTerm "admass_N" ;
lin administer_V = mkTerm "administer_V" ;
lin administer_V2 = mkTerm "administer_V2" ;
lin administrable_A = mkTerm "administrable_A" ;
lin administration_N = mkTerm "administration_N" ;
lin administrative_A = mkTerm "administrative_A" ;
lin administratorFem_N = mkTerm "administratorFem_N" ;
lin administratorMasc_N = mkTerm "administratorMasc_N" ;
lin administrivia_N = mkTerm "administrivia_N" ;
lin admirability_N = mkTerm "admirability_N" ;
lin admirable_A = mkTerm "admirable_A" ;
lin admiral_N = mkTerm "admiral_N" ;
lin admiralty_N = mkTerm "admiralty_N" ;
lin admiration_N = mkTerm "admiration_N" ;
lin admire_V2 = mkTerm "admire_V2" ;
lin admirer_N = mkTerm "admirer_N" ;
lin admiringly_Adv = mkTerm "admiringly_Adv" ;
lin admissibility_N = mkTerm "admissibility_N" ;
lin admissible_A = mkTerm "admissible_A" ;
lin admission_N = mkTerm "admission_N" ;
lin admissive_A = mkTerm "admissive_A" ;
lin admit_V = mkTerm "admit_V" ;
lin admit_V2 = mkTerm "admit_V2" ;
lin admit_VS = mkTerm "admit_VS" ;
lin admittable_A = mkTerm "admittable_A" ;
lin admittance_N = mkTerm "admittance_N" ;
lin admittedly_Adv = mkTerm "admittedly_Adv" ;
lin admix_V = mkTerm "admix_V" ;
lin admix_V2 = mkTerm "admix_V2" ;
lin admixture_N = mkTerm "admixture_N" ;
lin admonish_V2 = mkTerm "admonish_V2" ;
lin admonisher_N = mkTerm "admonisher_N" ;
lin admonition_N = mkTerm "admonition_N" ;
lin admonitory_A = mkTerm "admonitory_A" ;
lin adnate_A = mkTerm "adnate_A" ;
lin adnexa_N = mkTerm "adnexa_N" ;
lin adnexal_A = mkTerm "adnexal_A" ;
lin adnoun_N = mkTerm "adnoun_N" ;
lin ado_N = mkTerm "ado_N" ;
lin adobe_N = mkTerm "adobe_N" ;
lin adobo_N = mkTerm "adobo_N" ;
lin adolescence_N = mkTerm "adolescence_N" ;
lin adolescent_A = mkTerm "adolescent_A" ;
lin adolescent_N = mkTerm "adolescent_N" ;
lin adonis_N = mkTerm "adonis_N" ;
lin adopt_V2 = mkTerm "adopt_V2" ;
lin adoptable_A = mkTerm "adoptable_A" ;
lin adoptee_N = mkTerm "adoptee_N" ;
lin adoption_N = mkTerm "adoption_N" ;
lin adoptive_A = mkTerm "adoptive_A" ;
lin adorability_N = mkTerm "adorability_N" ;
lin adorable_A = mkTerm "adorable_A" ;
lin adoration_N = mkTerm "adoration_N" ;
lin adore_V2 = mkTerm "adore_V2" ;
lin adorer_N = mkTerm "adorer_N" ;
lin adoring_A = mkTerm "adoring_A" ;
lin adorn_V2 = mkTerm "adorn_V2" ;
lin adornment_N = mkTerm "adornment_N" ;
lin adoxography_N = mkTerm "adoxography_N" ;
lin adrenal_A = mkTerm "adrenal_A" ;
lin adrenalectomy_N = mkTerm "adrenalectomy_N" ;
lin adrenalin_N = mkTerm "adrenalin_N" ;
lin adrenarche_N = mkTerm "adrenarche_N" ;
lin adrenergic_A = mkTerm "adrenergic_A" ;
lin adrenergic_N = mkTerm "adrenergic_N" ;
lin adrenocortical_A = mkTerm "adrenocortical_A" ;
lin adrenocorticotropic_A = mkTerm "adrenocorticotropic_A" ;
lin adrenosterone_N = mkTerm "adrenosterone_N" ;
lin adrian_PN = mkTerm "adrian_PN" ;
lin adrift_A = mkTerm "adrift_A" ;
lin adrift_Adv = mkTerm "adrift_Adv" ;
lin adroit_A = mkTerm "adroit_A" ;
lin adroitness_N = mkTerm "adroitness_N" ;
lin adscititious_A = mkTerm "adscititious_A" ;
lin adscript_A = mkTerm "adscript_A" ;
lin adsorbable_A = mkTerm "adsorbable_A" ;
lin adsorbate_N = mkTerm "adsorbate_N" ;
lin adsorbent_A = mkTerm "adsorbent_A" ;
lin adsorbent_N = mkTerm "adsorbent_N" ;
lin adsorption_N = mkTerm "adsorption_N" ;
lin adulation_N = mkTerm "adulation_N" ;
lin adulatory_A = mkTerm "adulatory_A" ;
lin adult_A = mkTerm "adult_A" ;
lin adult_N = mkTerm "adult_N" ;
lin adulterant_N = mkTerm "adulterant_N" ;
lin adulterate_A = mkTerm "adulterate_A" ;
lin adulterate_V2 = mkTerm "adulterate_V2" ;
lin adulterating_A = mkTerm "adulterating_A" ;
lin adulteration_N = mkTerm "adulteration_N" ;
lin adulterator_N = mkTerm "adulterator_N" ;
lin adulterer_N = mkTerm "adulterer_N" ;
lin adulteress_N = mkTerm "adulteress_N" ;
lin adulterine_A = mkTerm "adulterine_A" ;
lin adulterous_A = mkTerm "adulterous_A" ;
lin adultery_N = mkTerm "adultery_N" ;
lin adulthood_N = mkTerm "adulthood_N" ;
lin adumbrate_V2 = mkTerm "adumbrate_V2" ;
lin adumbration_N = mkTerm "adumbration_N" ;
lin adumbrative_A = mkTerm "adumbrative_A" ;
lin adust_A = mkTerm "adust_A" ;
lin advance_N = mkTerm "advance_N" ;
lin advance_V = mkTerm "advance_V" ;
lin advance_V2 = mkTerm "advance_V2" ;
lin advanced_A = mkTerm "advanced_A" ;
lin advancement_N = mkTerm "advancement_N" ;
lin advancer_N = mkTerm "advancer_N" ;
lin advantage_N = mkTerm "advantage_N" ;
lin advantage_V2 = mkTerm "advantage_V2" ;
lin advantageous_A = mkTerm "advantageous_A" ;
lin advection_N = mkTerm "advection_N" ;
lin advective_A = mkTerm "advective_A" ;
lin advent_N = mkTerm "advent_N" ;
lin adventistFem_N = mkTerm "adventistFem_N" ;
lin adventistMasc_N = mkTerm "adventistMasc_N" ;
lin adventitial_A = mkTerm "adventitial_A" ;
lin adventitious_A = mkTerm "adventitious_A" ;
lin adventive_A = mkTerm "adventive_A" ;
lin adventure_N = mkTerm "adventure_N" ;
lin adventure_V2 = mkTerm "adventure_V2" ;
lin adventurer_N = mkTerm "adventurer_N" ;
lin adventuresome_A = mkTerm "adventuresome_A" ;
lin adventuress_N = mkTerm "adventuress_N" ;
lin adventurism_N = mkTerm "adventurism_N" ;
lin adventuristic_A = mkTerm "adventuristic_A" ;
lin adventurous_A = mkTerm "adventurous_A" ;
lin adventurousness_N = mkTerm "adventurousness_N" ;
lin adverb_N = mkTerm "adverb_N" ;
lin adverbial_A = mkTerm "adverbial_A" ;
lin adverbial_N = mkTerm "adverbial_N" ;
lin adversary_N = mkTerm "adversary_N" ;
lin adversative_A = mkTerm "adversative_A" ;
lin adverse_A = mkTerm "adverse_A" ;
lin adversity_N = mkTerm "adversity_N" ;
lin advert_N = mkTerm "advert_N" ;
lin advert_V = mkTerm "advert_V" ;
lin advertence_N = mkTerm "advertence_N" ;
lin advertent_A = mkTerm "advertent_A" ;
lin advertise_V = mkTerm "advertise_V" ;
lin advertise_V2 = mkTerm "advertise_V2" ;
lin advertisement_N = mkTerm "advertisement_N" ;
lin advertiser_N = mkTerm "advertiser_N" ;
lin advertising_N = mkTerm "advertising_N" ;
lin advertorial_N = mkTerm "advertorial_N" ;
lin advice_N = mkTerm "advice_N" ;
lin advisability_N = mkTerm "advisability_N" ;
lin advisable_A = mkTerm "advisable_A" ;
lin advise_V = mkTerm "advise_V" ;
lin advise_V2 = mkTerm "advise_V2" ;
lin advise_VS = mkTerm "advise_VS" ;
lin advisee_N = mkTerm "advisee_N" ;
lin adviserFem_N = mkTerm "adviserFem_N" ;
lin adviserMasc_N = mkTerm "adviserMasc_N" ;
lin advisor_N = mkTerm "advisor_N" ;
lin advisory_A = mkTerm "advisory_A" ;
lin advisory_N = mkTerm "advisory_N" ;
lin advocacy_N = mkTerm "advocacy_N" ;
lin advocateFem_N = mkTerm "advocateFem_N" ;
lin advocateMasc_N = mkTerm "advocateMasc_N" ;
lin advocate_V2 = mkTerm "advocate_V2" ;
lin advocate_VS = mkTerm "advocate_VS" ;
lin advowson_N = mkTerm "advowson_N" ;
lin adynamia_N = mkTerm "adynamia_N" ;
lin adynamic_A = mkTerm "adynamic_A" ;
lin adz_N = mkTerm "adz_N" ;
lin adze_N = mkTerm "adze_N" ;
lin aecial_A = mkTerm "aecial_A" ;
lin aeciospore_N = mkTerm "aeciospore_N" ;
lin aecium_N = mkTerm "aecium_N" ;
lin aegis_N = mkTerm "aegis_N" ;
lin aeolotropic_A = mkTerm "aeolotropic_A" ;
lin aeon_N = mkTerm "aeon_N" ;
lin aerate_V2 = mkTerm "aerate_V2" ;
lin aeration_N = mkTerm "aeration_N" ;
lin aerator_N = mkTerm "aerator_N" ;
lin aerial_A = mkTerm "aerial_A" ;
lin aerial_N = mkTerm "aerial_N" ;
lin aerialist_N = mkTerm "aerialist_N" ;
lin aerides_N = mkTerm "aerides_N" ;
lin aerie_N = mkTerm "aerie_N" ;
lin aeriferous_A = mkTerm "aeriferous_A" ;
lin aeriform_A = mkTerm "aeriform_A" ;
lin aerobatics_N = mkTerm "aerobatics_N" ;
lin aerobe_N = mkTerm "aerobe_N" ;
lin aerobic_A = mkTerm "aerobic_A" ;
lin aerobics_N = mkTerm "aerobics_N" ;
lin aerobiosis_N = mkTerm "aerobiosis_N" ;
lin aerobiotic_A = mkTerm "aerobiotic_A" ;
lin aerodontalgia_N = mkTerm "aerodontalgia_N" ;
lin aerodrome_N = mkTerm "aerodrome_N" ;
lin aerodynamic_A = mkTerm "aerodynamic_A" ;
lin aerodynamics_N = mkTerm "aerodynamics_N" ;
lin aerolite_N = mkTerm "aerolite_N" ;
lin aerolitic_A = mkTerm "aerolitic_A" ;
lin aerological_A = mkTerm "aerological_A" ;
lin aerology_N = mkTerm "aerology_N" ;
lin aeromechanic_A = mkTerm "aeromechanic_A" ;
lin aeromechanics_N = mkTerm "aeromechanics_N" ;
lin aeromedical_A = mkTerm "aeromedical_A" ;
lin aeromedicine_N = mkTerm "aeromedicine_N" ;
lin aeronaut_N = mkTerm "aeronaut_N" ;
lin aeronautical_A = mkTerm "aeronautical_A" ;
lin aeronautics_N = mkTerm "aeronautics_N" ;
lin aerophagia_N = mkTerm "aerophagia_N" ;
lin aerophilatelic_A = mkTerm "aerophilatelic_A" ;
lin aerophilately_N = mkTerm "aerophilately_N" ;
lin aerophile_N = mkTerm "aerophile_N" ;
lin aeroplane_N = mkTerm "aeroplane_N" ;
lin aerosol_N = mkTerm "aerosol_N" ;
lin aerosolized_A = mkTerm "aerosolized_A" ;
lin aerospace_A = mkTerm "aerospace_A" ;
lin aerospace_N = mkTerm "aerospace_N" ;
lin aertex_N = mkTerm "aertex_N" ;
lin aery_N = mkTerm "aery_N" ;
lin aeschynanthus_N = mkTerm "aeschynanthus_N" ;
lin aesculapian_A = mkTerm "aesculapian_A" ;
lin aestheteFem_N = mkTerm "aestheteFem_N" ;
lin aestheteMasc_N = mkTerm "aestheteMasc_N" ;
lin aesthetic_A = mkTerm "aesthetic_A" ;
lin aesthetic_N = mkTerm "aesthetic_N" ;
lin aesthetical_A = mkTerm "aesthetical_A" ;
lin aesthetics_N = mkTerm "aesthetics_N" ;
lin aestival_A = mkTerm "aestival_A" ;
lin aether_N = mkTerm "aether_N" ;
lin aetiology_N = mkTerm "aetiology_N" ;
lin afar_Adv = mkTerm "afar_Adv" ;
lin afebrile_A = mkTerm "afebrile_A" ;
lin affability_N = mkTerm "affability_N" ;
lin affable_A = mkTerm "affable_A" ;
lin affair_N = mkTerm "affair_N" ;
lin affairs_N = mkTerm "affairs_N" ;
lin affect_N = mkTerm "affect_N" ;
lin affect_V2 = mkTerm "affect_V2" ;
lin affectation_N = mkTerm "affectation_N" ;
lin affected_A = mkTerm "affected_A" ;
lin affectedness_N = mkTerm "affectedness_N" ;
lin affecting_A = mkTerm "affecting_A" ;
lin affection_N = mkTerm "affection_N" ;
lin affectional_A = mkTerm "affectional_A" ;
lin affectionate_A = mkTerm "affectionate_A" ;
lin affectionateness_N = mkTerm "affectionateness_N" ;
lin affenpinscher_N = mkTerm "affenpinscher_N" ;
lin afferent_A = mkTerm "afferent_A" ;
lin affiance_V2 = mkTerm "affiance_V2" ;
lin affiant_N = mkTerm "affiant_N" ;
lin affidavit_N = mkTerm "affidavit_N" ;
lin affiliate_N = mkTerm "affiliate_N" ;
lin affiliate_V = mkTerm "affiliate_V" ;
lin affiliate_V2 = mkTerm "affiliate_V2" ;
lin affiliation_N = mkTerm "affiliation_N" ;
lin affinal_A = mkTerm "affinal_A" ;
lin affine_A = mkTerm "affine_A" ;
lin affine_N = mkTerm "affine_N" ;
lin affined_A = mkTerm "affined_A" ;
lin affinity_N = mkTerm "affinity_N" ;
lin affirm_V = mkTerm "affirm_V" ;
lin affirm_V2 = mkTerm "affirm_V2" ;
lin affirm_VS = mkTerm "affirm_VS" ;
lin affirmable_A = mkTerm "affirmable_A" ;
lin affirmation_N = mkTerm "affirmation_N" ;
lin affirmative_A = mkTerm "affirmative_A" ;
lin affirmative_N = mkTerm "affirmative_N" ;
lin affirmativeness_N = mkTerm "affirmativeness_N" ;
lin affix_N = mkTerm "affix_N" ;
lin affix_V2 = mkTerm "affix_V2" ;
lin affixal_A = mkTerm "affixal_A" ;
lin affixation_N = mkTerm "affixation_N" ;
lin afflatus_N = mkTerm "afflatus_N" ;
lin afflict_V2 = mkTerm "afflict_V2" ;
lin affliction_N = mkTerm "affliction_N" ;
lin afflictive_A = mkTerm "afflictive_A" ;
lin affluence_N = mkTerm "affluence_N" ;
lin affluent_A = mkTerm "affluent_A" ;
lin affluent_N = mkTerm "affluent_N" ;
lin afford_V2 = mkTerm "afford_V2" ;
lin afford_V2V = mkTerm "afford_V2V" ;
lin affordable_A = mkTerm "affordable_A" ;
lin afforest_V2 = mkTerm "afforest_V2" ;
lin afforestation_N = mkTerm "afforestation_N" ;
lin affranchise_V2 = mkTerm "affranchise_V2" ;
lin affray_N = mkTerm "affray_N" ;
lin affricate_N = mkTerm "affricate_N" ;
lin affrication_N = mkTerm "affrication_N" ;
lin affront_N = mkTerm "affront_N" ;
lin affront_V2 = mkTerm "affront_V2" ;
lin affusion_N = mkTerm "affusion_N" ;
lin afghanFem_N = mkTerm "afghanFem_N" ;
lin afghanMasc_N = mkTerm "afghanMasc_N" ;
lin afghan_A = mkTerm "afghan_A" ;
lin afghani_N = mkTerm "afghani_N" ;
lin afghanistan_PN = mkTerm "afghanistan_PN" ;
lin afghanistaniFem_N = mkTerm "afghanistaniFem_N" ;
lin afghanistaniMasc_N = mkTerm "afghanistaniMasc_N" ;
lin afghanistani_A = mkTerm "afghanistani_A" ;
lin afibrinogenemia_N = mkTerm "afibrinogenemia_N" ;
lin aficionado_N = mkTerm "aficionado_N" ;
lin afield_Adv = mkTerm "afield_Adv" ;
lin afire_A = mkTerm "afire_A" ;
lin aflame_A = mkTerm "aflame_A" ;
lin aflare_A = mkTerm "aflare_A" ;
lin aflatoxin_N = mkTerm "aflatoxin_N" ;
lin afloat_A = mkTerm "afloat_A" ;
lin aflutter_A = mkTerm "aflutter_A" ;
lin afoot_A = mkTerm "afoot_A" ;
lin afoot_Adv = mkTerm "afoot_Adv" ;
lin afore_Adv = mkTerm "afore_Adv" ;
lin afore_Prep = mkTerm "afore_Prep" ;
lin aforementioned_A = mkTerm "aforementioned_A" ;
lin aforesaid_A = mkTerm "aforesaid_A" ;
lin aforethought_Adv = mkTerm "aforethought_Adv" ;
lin afoul_Adv = mkTerm "afoul_Adv" ;
lin afraid_A = mkTerm "afraid_A" ;
lin afresh_Adv = mkTerm "afresh_Adv" ;
lin africa_PN = mkTerm "africa_PN" ;
lin africanFem_N = mkTerm "africanFem_N" ;
lin africanMasc_N = mkTerm "africanMasc_N" ;
lin african_A = mkTerm "african_A" ;
lin afrikanerFem_N = mkTerm "afrikanerFem_N" ;
lin afrikanerMasc_N = mkTerm "afrikanerMasc_N" ;
lin afrikaner_A = mkTerm "afrikaner_A" ;
lin afro_americanFem_N = mkTerm "afro_americanFem_N" ;
lin afro_americanMasc_N = mkTerm "afro_americanMasc_N" ;
lin afro_asian_A = mkTerm "afro_asian_A" ;
lin afro_wig_N = mkTerm "afro_wig_N" ;
lin afropavo_N = mkTerm "afropavo_N" ;
lin aft_A = mkTerm "aft_A" ;
lin aft_Adv = mkTerm "aft_Adv" ;
lin after_A = mkTerm "after_A" ;
lin after_Adv = mkTerm "after_Adv" ;
lin after_Subj = mkTerm "after_Subj" ;
lin afterbirth_N = mkTerm "afterbirth_N" ;
lin afterburner_N = mkTerm "afterburner_N" ;
lin aftercare_N = mkTerm "aftercare_N" ;
lin afterdamp_N = mkTerm "afterdamp_N" ;
lin afterdeck_N = mkTerm "afterdeck_N" ;
lin aftereffect_N = mkTerm "aftereffect_N" ;
lin afterglow_N = mkTerm "afterglow_N" ;
lin afterimage_N = mkTerm "afterimage_N" ;
lin afterlife_N = mkTerm "afterlife_N" ;
lin aftermath_N = mkTerm "aftermath_N" ;
lin aftermost_A = mkTerm "aftermost_A" ;
lin afternoon_N = mkTerm "afternoon_N" ;
lin afterpains_N = mkTerm "afterpains_N" ;
lin afterpiece_N = mkTerm "afterpiece_N" ;
lin aftershaft_N = mkTerm "aftershaft_N" ;
lin aftershafted_A = mkTerm "aftershafted_A" ;
lin aftershock_N = mkTerm "aftershock_N" ;
lin aftertaste_N = mkTerm "aftertaste_N" ;
lin afterthought_N = mkTerm "afterthought_N" ;
lin afterwards_Adv = mkTerm "afterwards_Adv" ;
lin afterworld_N = mkTerm "afterworld_N" ;
lin again_Adv = mkTerm "again_Adv" ;
lin against_Prep = mkTerm "against_Prep" ;
lin agal_N = mkTerm "agal_N" ;
lin agalactia_N = mkTerm "agalactia_N" ;
lin agama_N = mkTerm "agama_N" ;
lin agamete_N = mkTerm "agamete_N" ;
lin agamic_A = mkTerm "agamic_A" ;
lin agamid_N = mkTerm "agamid_N" ;
lin agammaglobulinemia_N = mkTerm "agammaglobulinemia_N" ;
lin agapanthus_N = mkTerm "agapanthus_N" ;
lin agape_A = mkTerm "agape_A" ;
lin agape_N = mkTerm "agape_N" ;
lin agar_N = mkTerm "agar_N" ;
lin agar_agar_N = mkTerm "agar_agar_N" ;
lin agaric_N = mkTerm "agaric_N" ;
lin agate_N = mkTerm "agate_N" ;
lin agateware_N = mkTerm "agateware_N" ;
lin agatha_PN = mkTerm "agatha_PN" ;
lin agave_N = mkTerm "agave_N" ;
lin agaze_A = mkTerm "agaze_A" ;
lin age_N = mkTerm "age_N" ;
lin age_V = mkTerm "age_V" ;
lin age_bracket_N = mkTerm "age_bracket_N" ;
lin age_group_N = mkTerm "age_group_N" ;
lin age_long_A = mkTerm "age_long_A" ;
lin age_old_A = mkTerm "age_old_A" ;
lin aged_N = mkTerm "aged_N" ;
lin aged_Prep = mkTerm "aged_Prep" ;
lin agedness_N = mkTerm "agedness_N" ;
lin ageing_N = mkTerm "ageing_N" ;
lin ageism_N = mkTerm "ageism_N" ;
lin ageless_A = mkTerm "ageless_A" ;
lin agelessness_N = mkTerm "agelessness_N" ;
lin agency_N = mkTerm "agency_N" ;
lin agenda_N = mkTerm "agenda_N" ;
lin agenesis_N = mkTerm "agenesis_N" ;
lin agentFem_N = mkTerm "agentFem_N" ;
lin agentMasc_N = mkTerm "agentMasc_N" ;
lin agent_provocateur_N = mkTerm "agent_provocateur_N" ;
lin agential_A = mkTerm "agential_A" ;
lin agerasia_N = mkTerm "agerasia_N" ;
lin ageratum_N = mkTerm "ageratum_N" ;
lin aggie_PN = mkTerm "aggie_PN" ;
lin agglomerate_A = mkTerm "agglomerate_A" ;
lin agglomerate_N = mkTerm "agglomerate_N" ;
lin agglomerate_V = mkTerm "agglomerate_V" ;
lin agglomerate_V2 = mkTerm "agglomerate_V2" ;
lin agglomeration_N = mkTerm "agglomeration_N" ;
lin agglomerator_N = mkTerm "agglomerator_N" ;
lin agglutinate_A = mkTerm "agglutinate_A" ;
lin agglutinate_V2 = mkTerm "agglutinate_V2" ;
lin agglutination_N = mkTerm "agglutination_N" ;
lin agglutinative_A = mkTerm "agglutinative_A" ;
lin agglutinin_N = mkTerm "agglutinin_N" ;
lin agglutinogen_N = mkTerm "agglutinogen_N" ;
lin aggrandize_V2 = mkTerm "aggrandize_V2" ;
lin aggrandizement_N = mkTerm "aggrandizement_N" ;
lin aggravate_V2 = mkTerm "aggravate_V2" ;
lin aggravating_A = mkTerm "aggravating_A" ;
lin aggravation_N = mkTerm "aggravation_N" ;
lin aggravator_N = mkTerm "aggravator_N" ;
lin aggregate_A = mkTerm "aggregate_A" ;
lin aggregate_N = mkTerm "aggregate_N" ;
lin aggregate_V = mkTerm "aggregate_V" ;
lin aggregate_V2 = mkTerm "aggregate_V2" ;
lin aggregation_N = mkTerm "aggregation_N" ;
lin aggression_N = mkTerm "aggression_N" ;
lin aggressive_A = mkTerm "aggressive_A" ;
lin aggressiveness_N = mkTerm "aggressiveness_N" ;
lin aggressorFem_N = mkTerm "aggressorFem_N" ;
lin aggressorMasc_N = mkTerm "aggressorMasc_N" ;
lin aggrieve_V2 = mkTerm "aggrieve_V2" ;
lin aggro_N = mkTerm "aggro_N" ;
lin aghast_A = mkTerm "aghast_A" ;
lin agile_A = mkTerm "agile_A" ;
lin agility_N = mkTerm "agility_N" ;
lin agin_Prep = mkTerm "agin_Prep" ;
lin aging_N = mkTerm "aging_N" ;
lin agio_N = mkTerm "agio_N" ;
lin agitate_V = mkTerm "agitate_V" ;
lin agitate_V2 = mkTerm "agitate_V2" ;
lin agitation_N = mkTerm "agitation_N" ;
lin agitative_A = mkTerm "agitative_A" ;
lin agitator_N = mkTerm "agitator_N" ;
lin agitprop_N = mkTerm "agitprop_N" ;
lin agleam_A = mkTerm "agleam_A" ;
lin aglet_N = mkTerm "aglet_N" ;
lin aglow_A = mkTerm "aglow_A" ;
lin agm_N = mkTerm "agm_N" ;
lin agnail_N = mkTerm "agnail_N" ;
lin agnate_A = mkTerm "agnate_A" ;
lin agnate_N = mkTerm "agnate_N" ;
lin agnes_PN = mkTerm "agnes_PN" ;
lin agnomen_N = mkTerm "agnomen_N" ;
lin agnosia_N = mkTerm "agnosia_N" ;
lin agnostic_A = mkTerm "agnostic_A" ;
lin agnostic_N = mkTerm "agnostic_N" ;
lin agnosticism_N = mkTerm "agnosticism_N" ;
lin ago_Adv = mkTerm "ago_Adv" ;
lin ago_Prep = mkTerm "ago_Prep" ;
lin agog_A = mkTerm "agog_A" ;
lin agon_N = mkTerm "agon_N" ;
lin agonadal_A = mkTerm "agonadal_A" ;
lin agonal_A = mkTerm "agonal_A" ;
lin agonist_N = mkTerm "agonist_N" ;
lin agonistic_A = mkTerm "agonistic_A" ;
lin agonize_V = mkTerm "agonize_V" ;
lin agonized_A = mkTerm "agonized_A" ;
lin agonizingly_Adv = mkTerm "agonizingly_Adv" ;
lin agony_N = mkTerm "agony_N" ;
lin agora_N = mkTerm "agora_N" ;
lin agoraphobia_N = mkTerm "agoraphobia_N" ;
lin agoraphobic_A = mkTerm "agoraphobic_A" ;
lin agouti_N = mkTerm "agouti_N" ;
lin agra_PN = mkTerm "agra_PN" ;
lin agranulocytic_A = mkTerm "agranulocytic_A" ;
lin agranulocytosis_N = mkTerm "agranulocytosis_N" ;
lin agrapha_N = mkTerm "agrapha_N" ;
lin agraphia_N = mkTerm "agraphia_N" ;
lin agraphic_A = mkTerm "agraphic_A" ;
lin agrarian_A = mkTerm "agrarian_A" ;
lin agree_V = mkTerm "agree_V" ;
lin agree_VS = mkTerm "agree_VS" ;
lin agree_VV = mkTerm "agree_VV" ;
lin agree_on_V = mkTerm "agree_on_V" ;
lin agree_with_V2 = mkTerm "agree_with_V2" ;
lin agreeable_A = mkTerm "agreeable_A" ;
lin agreeableness_N = mkTerm "agreeableness_N" ;
lin agreed_A = mkTerm "agreed_A" ;
lin agreement_N = mkTerm "agreement_N" ;
lin agrestic_A = mkTerm "agrestic_A" ;
lin agribusiness_N = mkTerm "agribusiness_N" ;
lin agricultural_A = mkTerm "agricultural_A" ;
lin agriculture_N = mkTerm "agriculture_N" ;
lin agriculturist_N = mkTerm "agriculturist_N" ;
lin agrimonia_N = mkTerm "agrimonia_N" ;
lin agrobiologic_A = mkTerm "agrobiologic_A" ;
lin agrobiology_N = mkTerm "agrobiology_N" ;
lin agrologic_A = mkTerm "agrologic_A" ;
lin agrology_N = mkTerm "agrology_N" ;
lin agromania_N = mkTerm "agromania_N" ;
lin agronomic_A = mkTerm "agronomic_A" ;
lin agronomist_N = mkTerm "agronomist_N" ;
lin agronomy_N = mkTerm "agronomy_N" ;
lin aground_A = mkTerm "aground_A" ;
lin aground_Adv = mkTerm "aground_Adv" ;
lin agrypnia_N = mkTerm "agrypnia_N" ;
lin agrypnotic_A = mkTerm "agrypnotic_A" ;
lin agua_N = mkTerm "agua_N" ;
lin ague_N = mkTerm "ague_N" ;
lin agueweed_N = mkTerm "agueweed_N" ;
lin aguish_A = mkTerm "aguish_A" ;
lin ah_Interj = mkTerm "ah_Interj" ;
lin ahead_Adv = mkTerm "ahead_Adv" ;
lin ahead_of_Prep = mkTerm "ahead_of_Prep" ;
lin ahimsa_N = mkTerm "ahimsa_N" ;
lin ahistorical_A = mkTerm "ahistorical_A" ;
lin ahmedabad_PN = mkTerm "ahmedabad_PN" ;
lin aid_N = mkTerm "aid_N" ;
lin aid_V = mkTerm "aid_V" ;
lin aid_V2 = mkTerm "aid_V2" ;
lin aide_N = mkTerm "aide_N" ;
lin aide_de_camp_N = mkTerm "aide_de_camp_N" ;
lin aide_memoire_N = mkTerm "aide_memoire_N" ;
lin aids_N = mkTerm "aids_N" ;
lin aigret_N = mkTerm "aigret_N" ;
lin aigrette_N = mkTerm "aigrette_N" ;
lin aikido_N = mkTerm "aikido_N" ;
lin ail_V = mkTerm "ail_V" ;
lin ail_V2 = mkTerm "ail_V2" ;
lin ailanthus_N = mkTerm "ailanthus_N" ;
lin aileron_N = mkTerm "aileron_N" ;
lin ailment_N = mkTerm "ailment_N" ;
lin ailurophobia_N = mkTerm "ailurophobia_N" ;
lin aim_N = mkTerm "aim_N" ;
lin aim_V = mkTerm "aim_V" ;
lin aim_V2 = mkTerm "aim_V2" ;
lin aim_VV = mkTerm "aim_VV" ;
lin aim_at_V2 = mkTerm "aim_at_V2" ;
lin aimless_A = mkTerm "aimless_A" ;
lin aioli_N = mkTerm "aioli_N" ;
lin air_N = mkTerm "air_N" ;
lin air_V = mkTerm "air_V" ;
lin air_V2 = mkTerm "air_V2" ;
lin air_bladder_N = mkTerm "air_bladder_N" ;
lin air_conditioned_A = mkTerm "air_conditioned_A" ;
lin air_conditioning_N = mkTerm "air_conditioning_N" ;
lin air_cooled_A = mkTerm "air_cooled_A" ;
lin air_minded_A = mkTerm "air_minded_A" ;
lin air_pump_N = mkTerm "air_pump_N" ;
lin air_raid_N = mkTerm "air_raid_N" ;
lin air_shaft_N = mkTerm "air_shaft_N" ;
lin air_sick_A = mkTerm "air_sick_A" ;
lin air_sickness_N = mkTerm "air_sickness_N" ;
lin air_to_air_A = mkTerm "air_to_air_A" ;
lin air_to_ground_A = mkTerm "air_to_ground_A" ;
lin airbed_N = mkTerm "airbed_N" ;
lin airborne_A = mkTerm "airborne_A" ;
lin airbrake_N = mkTerm "airbrake_N" ;
lin airbrush_N = mkTerm "airbrush_N" ;
lin airburst_N = mkTerm "airburst_N" ;
lin airbus_N = mkTerm "airbus_N" ;
lin aircraft_N = mkTerm "aircraft_N" ;
lin aircraftman_N = mkTerm "aircraftman_N" ;
lin aircraftsman_N = mkTerm "aircraftsman_N" ;
lin aircrew_N = mkTerm "aircrew_N" ;
lin aircrewman_N = mkTerm "aircrewman_N" ;
lin airdock_N = mkTerm "airdock_N" ;
lin airdrie_PN = mkTerm "airdrie_PN" ;
lin airdrop_N = mkTerm "airdrop_N" ;
lin aireborough_PN = mkTerm "aireborough_PN" ;
lin airedale_N = mkTerm "airedale_N" ;
lin airfare_N = mkTerm "airfare_N" ;
lin airfield_N = mkTerm "airfield_N" ;
lin airflow_N = mkTerm "airflow_N" ;
lin airfoil_N = mkTerm "airfoil_N" ;
lin airforce_N = mkTerm "airforce_N" ;
lin airframe_N = mkTerm "airframe_N" ;
lin airhead_N = mkTerm "airhead_N" ;
lin airheaded_A = mkTerm "airheaded_A" ;
lin airiness_N = mkTerm "airiness_N" ;
lin airing_N = mkTerm "airing_N" ;
lin airing_cupboard_N = mkTerm "airing_cupboard_N" ;
lin airless_A = mkTerm "airless_A" ;
lin airlift_N = mkTerm "airlift_N" ;
lin airline_N = mkTerm "airline_N" ;
lin airliner_N = mkTerm "airliner_N" ;
lin airlock_N = mkTerm "airlock_N" ;
lin airmail_N = mkTerm "airmail_N" ;
lin airmailer_N = mkTerm "airmailer_N" ;
lin airman_N = mkTerm "airman_N" ;
lin airplane_N = mkTerm "airplane_N" ;
lin airplay_N = mkTerm "airplay_N" ;
lin airport_N = mkTerm "airport_N" ;
lin airs_N = mkTerm "airs_N" ;
lin airscrew_N = mkTerm "airscrew_N" ;
lin airship_N = mkTerm "airship_N" ;
lin airspace_N = mkTerm "airspace_N" ;
lin airspeed_N = mkTerm "airspeed_N" ;
lin airstream_N = mkTerm "airstream_N" ;
lin airstrip_N = mkTerm "airstrip_N" ;
lin airtight_A = mkTerm "airtight_A" ;
lin airway_N = mkTerm "airway_N" ;
lin airwoman_N = mkTerm "airwoman_N" ;
lin airworthiness_N = mkTerm "airworthiness_N" ;
lin airworthy_A = mkTerm "airworthy_A" ;
lin airy_A = mkTerm "airy_A" ;
lin aisle_N = mkTerm "aisle_N" ;
lin aitch_N = mkTerm "aitch_N" ;
lin aitchbone_N = mkTerm "aitchbone_N" ;
lin ajar_A = mkTerm "ajar_A" ;
lin aka_Prep = mkTerm "aka_Prep" ;
lin akaa_PN = mkTerm "akaa_PN" ;
lin akaryocyte_N = mkTerm "akaryocyte_N" ;
lin akimbo_Adv = mkTerm "akimbo_Adv" ;
lin akin_A = mkTerm "akin_A" ;
lin akinesis_N = mkTerm "akinesis_N" ;
lin akron_PN = mkTerm "akron_PN" ;
lin al_PN = mkTerm "al_PN" ;
lin ala_N = mkTerm "ala_N" ;
lin alabama_PN = mkTerm "alabama_PN" ;
lin alabaster_A = mkTerm "alabaster_A" ;
lin alabaster_N = mkTerm "alabaster_N" ;
lin alacritous_A = mkTerm "alacritous_A" ;
lin alacrity_N = mkTerm "alacrity_N" ;
lin alahärmä_PN = mkTerm "alahärmä_PN" ;
lin alajärvi_PN = mkTerm "alajärvi_PN" ;
lin alalia_N = mkTerm "alalia_N" ;
lin alan_PN = mkTerm "alan_PN" ;
lin alanine_N = mkTerm "alanine_N" ;
lin alar_A = mkTerm "alar_A" ;
lin alarm_N = mkTerm "alarm_N" ;
lin alarm_V2 = mkTerm "alarm_V2" ;
lin alarm_clock_N = mkTerm "alarm_clock_N" ;
lin alarming_A = mkTerm "alarming_A" ;
lin alarmism_N = mkTerm "alarmism_N" ;
lin alarmist_N = mkTerm "alarmist_N" ;
lin alas_Interj = mkTerm "alas_Interj" ;
lin alaska_PN = mkTerm "alaska_PN" ;
lin alastaro_PN = mkTerm "alastaro_PN" ;
lin alastrim_N = mkTerm "alastrim_N" ;
lin alate_A = mkTerm "alate_A" ;
lin alavieska_PN = mkTerm "alavieska_PN" ;
lin alavus_PN = mkTerm "alavus_PN" ;
lin alb_N = mkTerm "alb_N" ;
lin albacore_N = mkTerm "albacore_N" ;
lin albania_PN = mkTerm "albania_PN" ;
lin albanian_A = mkTerm "albanian_A" ;
lin albanian_N = mkTerm "albanian_N" ;
lin albatross_N = mkTerm "albatross_N" ;
lin albedo_N = mkTerm "albedo_N" ;
lin albeit_Subj = mkTerm "albeit_Subj" ;
lin albert_PN = mkTerm "albert_PN" ;
lin alberta_PN = mkTerm "alberta_PN" ;
lin albescent_A = mkTerm "albescent_A" ;
lin albinal_A = mkTerm "albinal_A" ;
lin albinism_N = mkTerm "albinism_N" ;
lin albino_N = mkTerm "albino_N" ;
lin albite_N = mkTerm "albite_N" ;
lin albitic_A = mkTerm "albitic_A" ;
lin albizzia_N = mkTerm "albizzia_N" ;
lin albuca_N = mkTerm "albuca_N" ;
lin albuginea_N = mkTerm "albuginea_N" ;
lin album_N = mkTerm "album_N" ;
lin albumen_N = mkTerm "albumen_N" ;
lin albumin_N = mkTerm "albumin_N" ;
lin albuminous_A = mkTerm "albuminous_A" ;
lin albuminuria_N = mkTerm "albuminuria_N" ;
lin albuminuric_A = mkTerm "albuminuric_A" ;
lin albuterol_N = mkTerm "albuterol_N" ;
lin alcalde_N = mkTerm "alcalde_N" ;
lin alcazar_N = mkTerm "alcazar_N" ;
lin alchemic_A = mkTerm "alchemic_A" ;
lin alchemist_N = mkTerm "alchemist_N" ;
lin alchemistic_A = mkTerm "alchemistic_A" ;
lin alchemy_N = mkTerm "alchemy_N" ;
lin alcohol_N = mkTerm "alcohol_N" ;
lin alcoholic_A = mkTerm "alcoholic_A" ;
lin alcoholic_N = mkTerm "alcoholic_N" ;
lin alcoholism_N = mkTerm "alcoholism_N" ;
lin alcove_N = mkTerm "alcove_N" ;
lin aldehyde_N = mkTerm "aldehyde_N" ;
lin aldehydic_A = mkTerm "aldehydic_A" ;
lin alder_N = mkTerm "alder_N" ;
lin alderfly_N = mkTerm "alderfly_N" ;
lin alderman_N = mkTerm "alderman_N" ;
lin aldermanic_A = mkTerm "aldermanic_A" ;
lin aldershot_PN = mkTerm "aldershot_PN" ;
lin aldohexose_N = mkTerm "aldohexose_N" ;
lin aldol_N = mkTerm "aldol_N" ;
lin aldose_N = mkTerm "aldose_N" ;
lin aldosterone_N = mkTerm "aldosterone_N" ;
lin aldosteronism_N = mkTerm "aldosteronism_N" ;
lin ale_N = mkTerm "ale_N" ;
lin ale_house_N = mkTerm "ale_house_N" ;
lin aleatory_A = mkTerm "aleatory_A" ;
lin alee_A = mkTerm "alee_A" ;
lin alee_Adv = mkTerm "alee_Adv" ;
lin alembic_N = mkTerm "alembic_N" ;
lin alendronate_N = mkTerm "alendronate_N" ;
lin aleph_N = mkTerm "aleph_N" ;
lin aleppo_PN = mkTerm "aleppo_PN" ;
lin alert_A = mkTerm "alert_A" ;
lin alert_N = mkTerm "alert_N" ;
lin alert_V2 = mkTerm "alert_V2" ;
lin alertness_N = mkTerm "alertness_N" ;
lin alessandria_PN = mkTerm "alessandria_PN" ;
lin aleurone_N = mkTerm "aleurone_N" ;
lin aleuronic_A = mkTerm "aleuronic_A" ;
lin alewife_N = mkTerm "alewife_N" ;
lin alex_PN = mkTerm "alex_PN" ;
lin alexander_PN = mkTerm "alexander_PN" ;
lin alexandra_PN = mkTerm "alexandra_PN" ;
lin alexandria_PN = mkTerm "alexandria_PN" ;
lin alexandrine_N = mkTerm "alexandrine_N" ;
lin alexandrite_N = mkTerm "alexandrite_N" ;
lin alexia_N = mkTerm "alexia_N" ;
lin alexic_A = mkTerm "alexic_A" ;
lin alexic_N = mkTerm "alexic_N" ;
lin alf_PN = mkTerm "alf_PN" ;
lin alfalfa_N = mkTerm "alfalfa_N" ;
lin alfred_PN = mkTerm "alfred_PN" ;
lin alfresco_A = mkTerm "alfresco_A" ;
lin alfresco_Adv = mkTerm "alfresco_Adv" ;
lin alfreton_PN = mkTerm "alfreton_PN" ;
lin alga_N = mkTerm "alga_N" ;
lin algal_A = mkTerm "algal_A" ;
lin algarroba_N = mkTerm "algarroba_N" ;
lin algebra_N = mkTerm "algebra_N" ;
lin algebraic_A = mkTerm "algebraic_A" ;
lin algebraical_A = mkTerm "algebraical_A" ;
lin algebraist_N = mkTerm "algebraist_N" ;
lin alger_PN = mkTerm "alger_PN" ;
lin algeria_PN = mkTerm "algeria_PN" ;
lin algerian_A = mkTerm "algerian_A" ;
lin algerian_N = mkTerm "algerian_N" ;
lin algid_A = mkTerm "algid_A" ;
lin algidity_N = mkTerm "algidity_N" ;
lin algin_N = mkTerm "algin_N" ;
lin algoid_A = mkTerm "algoid_A" ;
lin algolagnia_N = mkTerm "algolagnia_N" ;
lin algolagnic_A = mkTerm "algolagnic_A" ;
lin algometer_N = mkTerm "algometer_N" ;
lin algometric_A = mkTerm "algometric_A" ;
lin algometry_N = mkTerm "algometry_N" ;
lin algophobia_N = mkTerm "algophobia_N" ;
lin algophobic_A = mkTerm "algophobic_A" ;
lin algorism_N = mkTerm "algorism_N" ;
lin algorithm_N = mkTerm "algorithm_N" ;
lin algorithmic_A = mkTerm "algorithmic_A" ;
lin ali_PN = mkTerm "ali_PN" ;
lin alias_Adv = mkTerm "alias_Adv" ;
lin alias_N = mkTerm "alias_N" ;
lin alibi_N = mkTerm "alibi_N" ;
lin alicante_PN = mkTerm "alicante_PN" ;
lin alice_PN = mkTerm "alice_PN" ;
lin alidade_N = mkTerm "alidade_N" ;
lin alienFem_N = mkTerm "alienFem_N" ;
lin alienMasc_N = mkTerm "alienMasc_N" ;
lin alien_A = mkTerm "alien_A" ;
lin alienable_A = mkTerm "alienable_A" ;
lin alienage_N = mkTerm "alienage_N" ;
lin alienate_V2 = mkTerm "alienate_V2" ;
lin alienating_A = mkTerm "alienating_A" ;
lin alienation_N = mkTerm "alienation_N" ;
lin alienator_N = mkTerm "alienator_N" ;
lin alienee_N = mkTerm "alienee_N" ;
lin alienism_N = mkTerm "alienism_N" ;
lin alienist_N = mkTerm "alienist_N" ;
lin alienor_N = mkTerm "alienor_N" ;
lin alight_A = mkTerm "alight_A" ;
lin alight_V = mkTerm "alight_V" ;
lin align_V = mkTerm "align_V" ;
lin align_V2 = mkTerm "align_V2" ;
lin alignment_N = mkTerm "alignment_N" ;
lin alike_A = mkTerm "alike_A" ;
lin alike_Adv = mkTerm "alike_Adv" ;
lin alimentary_A = mkTerm "alimentary_A" ;
lin alimentative_A = mkTerm "alimentative_A" ;
lin alimony_N = mkTerm "alimony_N" ;
lin aliphatic_A = mkTerm "aliphatic_A" ;
lin aliquant_N = mkTerm "aliquant_N" ;
lin aliquot_A = mkTerm "aliquot_A" ;
lin aliquot_N = mkTerm "aliquot_N" ;
lin alison_PN = mkTerm "alison_PN" ;
lin aliterate_N = mkTerm "aliterate_N" ;
lin alive_A = mkTerm "alive_A" ;
lin aliyah_N = mkTerm "aliyah_N" ;
lin alizarin_N = mkTerm "alizarin_N" ;
lin alkahest_N = mkTerm "alkahest_N" ;
lin alkahestic_A = mkTerm "alkahestic_A" ;
lin alkalemia_N = mkTerm "alkalemia_N" ;
lin alkalescent_A = mkTerm "alkalescent_A" ;
lin alkali_N = mkTerm "alkali_N" ;
lin alkalimetry_N = mkTerm "alkalimetry_N" ;
lin alkaline_A = mkTerm "alkaline_A" ;
lin alkalinity_N = mkTerm "alkalinity_N" ;
lin alkalinuria_N = mkTerm "alkalinuria_N" ;
lin alkaloid_N = mkTerm "alkaloid_N" ;
lin alkaloidal_A = mkTerm "alkaloidal_A" ;
lin alkalosis_N = mkTerm "alkalosis_N" ;
lin alkalotic_A = mkTerm "alkalotic_A" ;
lin alkapton_N = mkTerm "alkapton_N" ;
lin alkaptonuria_N = mkTerm "alkaptonuria_N" ;
lin alkene_N = mkTerm "alkene_N" ;
lin alkyd_N = mkTerm "alkyd_N" ;
lin alkyl_N = mkTerm "alkyl_N" ;
lin alkylbenzene_N = mkTerm "alkylbenzene_N" ;
lin alkylbenzenesulfonate_N = mkTerm "alkylbenzenesulfonate_N" ;
lin alkylic_A = mkTerm "alkylic_A" ;
lin all_A = mkTerm "all_A" ;
lin all_mains_A = mkTerm "all_mains_A" ;
lin all_round_A = mkTerm "all_round_A" ;
lin all_rounder_N = mkTerm "all_rounder_N" ;
lin allah_PN = mkTerm "allah_PN" ;
lin allahabad_PN = mkTerm "allahabad_PN" ;
lin allamanda_N = mkTerm "allamanda_N" ;
lin allan_PN = mkTerm "allan_PN" ;
lin allantoic_A = mkTerm "allantoic_A" ;
lin allantoid_A = mkTerm "allantoid_A" ;
lin allantois_N = mkTerm "allantois_N" ;
lin allargando_A = mkTerm "allargando_A" ;
lin allay_V2 = mkTerm "allay_V2" ;
lin allegation_N = mkTerm "allegation_N" ;
lin allege_V2 = mkTerm "allege_V2" ;
lin allege_VS = mkTerm "allege_VS" ;
lin alleged_A = mkTerm "alleged_A" ;
lin allegedly_AdA = mkTerm "allegedly_AdA" ;
lin allegedly_AdV = mkTerm "allegedly_AdV" ;
lin allegiance_N = mkTerm "allegiance_N" ;
lin allegiant_A = mkTerm "allegiant_A" ;
lin allegoric_A = mkTerm "allegoric_A" ;
lin allegorical_A = mkTerm "allegorical_A" ;
lin allegorizer_N = mkTerm "allegorizer_N" ;
lin allegory_N = mkTerm "allegory_N" ;
lin allegretto_A = mkTerm "allegretto_A" ;
lin allegretto_Adv = mkTerm "allegretto_Adv" ;
lin allegretto_N = mkTerm "allegretto_N" ;
lin allegro_A = mkTerm "allegro_A" ;
lin allegro_Adv = mkTerm "allegro_Adv" ;
lin allegro_N = mkTerm "allegro_N" ;
lin allele_N = mkTerm "allele_N" ;
lin allelic_A = mkTerm "allelic_A" ;
lin allemande_N = mkTerm "allemande_N" ;
lin allen_PN = mkTerm "allen_PN" ;
lin allergen_N = mkTerm "allergen_N" ;
lin allergenic_A = mkTerm "allergenic_A" ;
lin allergic_A = mkTerm "allergic_A" ;
lin allergist_N = mkTerm "allergist_N" ;
lin allergology_N = mkTerm "allergology_N" ;
lin allergy_N = mkTerm "allergy_N" ;
lin alleviate_V2 = mkTerm "alleviate_V2" ;
lin alleviation_N = mkTerm "alleviation_N" ;
lin alleviative_A = mkTerm "alleviative_A" ;
lin alleviator_N = mkTerm "alleviator_N" ;
lin alley_N = mkTerm "alley_N" ;
lin alleyway_N = mkTerm "alleyway_N" ;
lin alliaceous_A = mkTerm "alliaceous_A" ;
lin alliance_N = mkTerm "alliance_N" ;
lin allied_A = mkTerm "allied_A" ;
lin allies_N = mkTerm "allies_N" ;
lin alligator_N = mkTerm "alligator_N" ;
lin alligatored_A = mkTerm "alligatored_A" ;
lin alligatorfish_N = mkTerm "alligatorfish_N" ;
lin alliteration_N = mkTerm "alliteration_N" ;
lin alliterative_A = mkTerm "alliterative_A" ;
lin alliterator_N = mkTerm "alliterator_N" ;
lin alloa_PN = mkTerm "alloa_PN" ;
lin allocable_A = mkTerm "allocable_A" ;
lin allocate_V = mkTerm "allocate_V" ;
lin allocate_V2 = mkTerm "allocate_V2" ;
lin allocation_N = mkTerm "allocation_N" ;
lin allocator_N = mkTerm "allocator_N" ;
lin allochronic_A = mkTerm "allochronic_A" ;
lin allochthonous_A = mkTerm "allochthonous_A" ;
lin allocution_N = mkTerm "allocution_N" ;
lin allogamous_A = mkTerm "allogamous_A" ;
lin allogamy_N = mkTerm "allogamy_N" ;
lin allogeneic_A = mkTerm "allogeneic_A" ;
lin allograph_N = mkTerm "allograph_N" ;
lin allographic_A = mkTerm "allographic_A" ;
lin allomerism_N = mkTerm "allomerism_N" ;
lin allomerous_A = mkTerm "allomerous_A" ;
lin allometric_A = mkTerm "allometric_A" ;
lin allometry_N = mkTerm "allometry_N" ;
lin allomorph_N = mkTerm "allomorph_N" ;
lin allomorphic_A = mkTerm "allomorphic_A" ;
lin allopathic_A = mkTerm "allopathic_A" ;
lin allopathy_N = mkTerm "allopathy_N" ;
lin allopatric_A = mkTerm "allopatric_A" ;
lin allopatry_N = mkTerm "allopatry_N" ;
lin allophone_N = mkTerm "allophone_N" ;
lin allophonic_A = mkTerm "allophonic_A" ;
lin allopurinol_N = mkTerm "allopurinol_N" ;
lin allosaur_N = mkTerm "allosaur_N" ;
lin allot_V2 = mkTerm "allot_V2" ;
lin allotment_N = mkTerm "allotment_N" ;
lin allotrope_N = mkTerm "allotrope_N" ;
lin allotropic_A = mkTerm "allotropic_A" ;
lin allotropy_N = mkTerm "allotropy_N" ;
lin allover_A = mkTerm "allover_A" ;
lin allow_V2 = mkTerm "allow_V2" ;
lin allow_V2V = mkTerm "allow_V2V" ;
lin allow_for_V2 = mkTerm "allow_for_V2" ;
lin allow_of_V2 = mkTerm "allow_of_V2" ;
lin allowable_A = mkTerm "allowable_A" ;
lin allowance_N = mkTerm "allowance_N" ;
lin alloy_N = mkTerm "alloy_N" ;
lin alloy_V2 = mkTerm "alloy_V2" ;
lin allspice_N = mkTerm "allspice_N" ;
lin allude_V = mkTerm "allude_V" ;
lin allure_N = mkTerm "allure_N" ;
lin allure_V2 = mkTerm "allure_V2" ;
lin allurement_N = mkTerm "allurement_N" ;
lin alluring_A = mkTerm "alluring_A" ;
lin allusion_N = mkTerm "allusion_N" ;
lin allusive_A = mkTerm "allusive_A" ;
lin allusiveness_N = mkTerm "allusiveness_N" ;
lin alluvial_A = mkTerm "alluvial_A" ;
lin alluvion_N = mkTerm "alluvion_N" ;
lin ally_N = mkTerm "ally_N" ;
lin ally_V2 = mkTerm "ally_V2" ;
lin allyl_N = mkTerm "allyl_N" ;
lin allylic_A = mkTerm "allylic_A" ;
lin alma_ata_PN = mkTerm "alma_ata_PN" ;
lin alma_mater_N = mkTerm "alma_mater_N" ;
lin almanac_N = mkTerm "almanac_N" ;
lin almandine_N = mkTerm "almandine_N" ;
lin almandite_N = mkTerm "almandite_N" ;
lin almeria_PN = mkTerm "almeria_PN" ;
lin almighty_A = mkTerm "almighty_A" ;
lin almighty_N = mkTerm "almighty_N" ;
lin almond_N = mkTerm "almond_N" ;
lin almond_eyed_A = mkTerm "almond_eyed_A" ;
lin almoner_N = mkTerm "almoner_N" ;
lin almost_Adv = mkTerm "almost_Adv" ;
lin almost_Predet = mkTerm "almost_Predet" ;
lin alms_N = mkTerm "alms_N" ;
lin alms_box_N = mkTerm "alms_box_N" ;
lin alms_giving_N = mkTerm "alms_giving_N" ;
lin alms_house_N = mkTerm "alms_house_N" ;
lin almsgiver_N = mkTerm "almsgiver_N" ;
lin alnwick_PN = mkTerm "alnwick_PN" ;
lin alocasia_N = mkTerm "alocasia_N" ;
lin aloe_N = mkTerm "aloe_N" ;
lin aloft_Adv = mkTerm "aloft_Adv" ;
lin aloha_N = mkTerm "aloha_N" ;
lin alone_A = mkTerm "alone_A" ;
lin aloneness_N = mkTerm "aloneness_N" ;
lin along_Adv = mkTerm "along_Adv" ;
lin along_Prep = mkTerm "along_Prep" ;
lin alongside_Adv = mkTerm "alongside_Adv" ;
lin alongside_Prep = mkTerm "alongside_Prep" ;
lin aloof_A = mkTerm "aloof_A" ;
lin aloof_Adv = mkTerm "aloof_Adv" ;
lin aloofness_N = mkTerm "aloofness_N" ;
lin alopecia_N = mkTerm "alopecia_N" ;
lin alopecic_A = mkTerm "alopecic_A" ;
lin aloud_Adv = mkTerm "aloud_Adv" ;
lin alp_N = mkTerm "alp_N" ;
lin alpaca_N = mkTerm "alpaca_N" ;
lin alpenstock_N = mkTerm "alpenstock_N" ;
lin alpestrine_A = mkTerm "alpestrine_A" ;
lin alpha_A = mkTerm "alpha_A" ;
lin alpha_N = mkTerm "alpha_N" ;
lin alphabet_N = mkTerm "alphabet_N" ;
lin alphabetic_A = mkTerm "alphabetic_A" ;
lin alphabetical_A = mkTerm "alphabetical_A" ;
lin alphabetization_N = mkTerm "alphabetization_N" ;
lin alphabetized_A = mkTerm "alphabetized_A" ;
lin alphabetizer_N = mkTerm "alphabetizer_N" ;
lin alphanumeric_A = mkTerm "alphanumeric_A" ;
lin alphanumerics_N = mkTerm "alphanumerics_N" ;
lin alphavirus_N = mkTerm "alphavirus_N" ;
lin alpine_A = mkTerm "alpine_A" ;
lin alpinist_N = mkTerm "alpinist_N" ;
lin alprazolam_N = mkTerm "alprazolam_N" ;
lin already_AdV = mkTerm "already_AdV" ;
lin already_Adv = mkTerm "already_Adv" ;
lin alright_A = mkTerm "alright_A" ;
lin alright_Adv = mkTerm "alright_Adv" ;
lin alsatianFem_N = mkTerm "alsatianFem_N" ;
lin alsatianMasc_N = mkTerm "alsatianMasc_N" ;
lin also_AdV = mkTerm "also_AdV" ;
lin also_Adv = mkTerm "also_Adv" ;
lin also_ran_N = mkTerm "also_ran_N" ;
lin alstroemeria_N = mkTerm "alstroemeria_N" ;
lin altar_N = mkTerm "altar_N" ;
lin altar_piece_N = mkTerm "altar_piece_N" ;
lin altazimuth_N = mkTerm "altazimuth_N" ;
lin alter_V = mkTerm "alter_V" ;
lin alter_V2 = mkTerm "alter_V2" ;
lin alter_ego_N = mkTerm "alter_ego_N" ;
lin alterability_N = mkTerm "alterability_N" ;
lin alterable_A = mkTerm "alterable_A" ;
lin alteration_N = mkTerm "alteration_N" ;
lin altercation_N = mkTerm "altercation_N" ;
lin altered_A = mkTerm "altered_A" ;
lin alternate_A = mkTerm "alternate_A" ;
lin alternate_V = mkTerm "alternate_V" ;
lin alternate_V2 = mkTerm "alternate_V2" ;
lin alternation_N = mkTerm "alternation_N" ;
lin alternative_A = mkTerm "alternative_A" ;
lin alternative_N = mkTerm "alternative_N" ;
lin alternator_N = mkTerm "alternator_N" ;
lin althea_N = mkTerm "althea_N" ;
lin altimeter_N = mkTerm "altimeter_N" ;
lin altissimo_A = mkTerm "altissimo_A" ;
lin altitude_N = mkTerm "altitude_N" ;
lin altitudinal_A = mkTerm "altitudinal_A" ;
lin altitudinous_A = mkTerm "altitudinous_A" ;
lin alto_A = mkTerm "alto_A" ;
lin alto_N = mkTerm "alto_N" ;
lin altocumulus_N = mkTerm "altocumulus_N" ;
lin altogether_Adv = mkTerm "altogether_Adv" ;
lin alton_PN = mkTerm "alton_PN" ;
lin altostratus_N = mkTerm "altostratus_N" ;
lin altricial_A = mkTerm "altricial_A" ;
lin altrincham_PN = mkTerm "altrincham_PN" ;
lin altruism_N = mkTerm "altruism_N" ;
lin altruist_N = mkTerm "altruist_N" ;
lin altruistic_A = mkTerm "altruistic_A" ;
lin alula_N = mkTerm "alula_N" ;
lin alular_A = mkTerm "alular_A" ;
lin alum_N = mkTerm "alum_N" ;
lin alumina_N = mkTerm "alumina_N" ;
lin aluminate_N = mkTerm "aluminate_N" ;
lin aluminiferous_A = mkTerm "aluminiferous_A" ;
lin aluminium_N = mkTerm "aluminium_N" ;
lin aluminous_A = mkTerm "aluminous_A" ;
lin aluminum_N = mkTerm "aluminum_N" ;
lin alumna_N = mkTerm "alumna_N" ;
lin alumnus_N = mkTerm "alumnus_N" ;
lin alumroot_N = mkTerm "alumroot_N" ;
lin alundum_N = mkTerm "alundum_N" ;
lin alvechurch_PN = mkTerm "alvechurch_PN" ;
lin alveolar_A = mkTerm "alveolar_A" ;
lin alveolar_N = mkTerm "alveolar_N" ;
lin alveolate_A = mkTerm "alveolate_A" ;
lin alveolitis_N = mkTerm "alveolitis_N" ;
lin alveolus_N = mkTerm "alveolus_N" ;
lin alvine_A = mkTerm "alvine_A" ;
lin always_Adv = mkTerm "always_Adv" ;
lin alyssum_N = mkTerm "alyssum_N" ;
lin amah_N = mkTerm "amah_N" ;
lin amain_Adv = mkTerm "amain_Adv" ;
lin amalgam_N = mkTerm "amalgam_N" ;
lin amalgamate_A = mkTerm "amalgamate_A" ;
lin amalgamate_V = mkTerm "amalgamate_V" ;
lin amalgamate_V2 = mkTerm "amalgamate_V2" ;
lin amalgamation_N = mkTerm "amalgamation_N" ;
lin amalgamative_A = mkTerm "amalgamative_A" ;
lin amalgamator_N = mkTerm "amalgamator_N" ;
lin amanda_PN = mkTerm "amanda_PN" ;
lin amanuensis_N = mkTerm "amanuensis_N" ;
lin amaranth_N = mkTerm "amaranth_N" ;
lin amaranthine_A = mkTerm "amaranthine_A" ;
lin amarelle_N = mkTerm "amarelle_N" ;
lin amaretto_N = mkTerm "amaretto_N" ;
lin amaryllis_N = mkTerm "amaryllis_N" ;
lin amass_V2 = mkTerm "amass_V2" ;
lin amastia_N = mkTerm "amastia_N" ;
lin amateurFem_N = mkTerm "amateurFem_N" ;
lin amateurMasc_N = mkTerm "amateurMasc_N" ;
lin amateur_A = mkTerm "amateur_A" ;
lin amateurish_A = mkTerm "amateurish_A" ;
lin amateurishness_N = mkTerm "amateurishness_N" ;
lin amateurism_N = mkTerm "amateurism_N" ;
lin amative_A = mkTerm "amative_A" ;
lin amatory_A = mkTerm "amatory_A" ;
lin amaurosis_N = mkTerm "amaurosis_N" ;
lin amaurotic_A = mkTerm "amaurotic_A" ;
lin amaze_V2 = mkTerm "amaze_V2" ;
lin amaze_V2V = mkTerm "amaze_V2V" ;
lin amazement_N = mkTerm "amazement_N" ;
lin amazing_A = mkTerm "amazing_A" ;
lin amazon_N = mkTerm "amazon_N" ;
lin ambages_N = mkTerm "ambages_N" ;
lin ambassador_N = mkTerm "ambassador_N" ;
lin ambassadorial_A = mkTerm "ambassadorial_A" ;
lin ambassadorship_N = mkTerm "ambassadorship_N" ;
lin ambassadress_N = mkTerm "ambassadress_N" ;
lin amber_A = mkTerm "amber_A" ;
lin amber_N = mkTerm "amber_N" ;
lin ambergris_N = mkTerm "ambergris_N" ;
lin amberjack_N = mkTerm "amberjack_N" ;
lin ambidexterity_N = mkTerm "ambidexterity_N" ;
lin ambidextrous_A = mkTerm "ambidextrous_A" ;
lin ambience_N = mkTerm "ambience_N" ;
lin ambient_A = mkTerm "ambient_A" ;
lin ambiguity_N = mkTerm "ambiguity_N" ;
lin ambiguous_A = mkTerm "ambiguous_A" ;
lin ambit_N = mkTerm "ambit_N" ;
lin ambition_N = mkTerm "ambition_N" ;
lin ambitious_A = mkTerm "ambitious_A" ;
lin ambivalence_N = mkTerm "ambivalence_N" ;
lin ambivalent_A = mkTerm "ambivalent_A" ;
lin ambiversion_N = mkTerm "ambiversion_N" ;
lin ambiversive_A = mkTerm "ambiversive_A" ;
lin amble_N = mkTerm "amble_N" ;
lin amble_V = mkTerm "amble_V" ;
lin amblygonite_N = mkTerm "amblygonite_N" ;
lin amblyopia_N = mkTerm "amblyopia_N" ;
lin amblyopic_A = mkTerm "amblyopic_A" ;
lin amboyna_N = mkTerm "amboyna_N" ;
lin ambrosia_N = mkTerm "ambrosia_N" ;
lin ambrosial_A = mkTerm "ambrosial_A" ;
lin ambulacral_A = mkTerm "ambulacral_A" ;
lin ambulacrum_N = mkTerm "ambulacrum_N" ;
lin ambulance_N = mkTerm "ambulance_N" ;
lin ambulant_A = mkTerm "ambulant_A" ;
lin ambulation_N = mkTerm "ambulation_N" ;
lin ambulatory_A = mkTerm "ambulatory_A" ;
lin ambulatory_N = mkTerm "ambulatory_N" ;
lin ambuscade_N = mkTerm "ambuscade_N" ;
lin ambuscade_V2 = mkTerm "ambuscade_V2" ;
lin ambush_N = mkTerm "ambush_N" ;
lin ambush_V2 = mkTerm "ambush_V2" ;
lin ambusher_N = mkTerm "ambusher_N" ;
lin ambystomid_N = mkTerm "ambystomid_N" ;
lin amebiasis_N = mkTerm "amebiasis_N" ;
lin ameboid_A = mkTerm "ameboid_A" ;
lin ameer_N = mkTerm "ameer_N" ;
lin amelia_N = mkTerm "amelia_N" ;
lin ameliorate_V = mkTerm "ameliorate_V" ;
lin ameliorate_V2 = mkTerm "ameliorate_V2" ;
lin amelioration_N = mkTerm "amelioration_N" ;
lin ameloblast_N = mkTerm "ameloblast_N" ;
lin amelogenesis_N = mkTerm "amelogenesis_N" ;
lin amen_Interj = mkTerm "amen_Interj" ;
lin amenability_N = mkTerm "amenability_N" ;
lin amenable_A = mkTerm "amenable_A" ;
lin amend_V = mkTerm "amend_V" ;
lin amend_V2 = mkTerm "amend_V2" ;
lin amend_V2V = mkTerm "amend_V2V" ;
lin amendable_A = mkTerm "amendable_A" ;
lin amendatory_A = mkTerm "amendatory_A" ;
lin amendment_N = mkTerm "amendment_N" ;
lin amenity_N = mkTerm "amenity_N" ;
lin amenorrhea_N = mkTerm "amenorrhea_N" ;
lin amenorrheic_A = mkTerm "amenorrheic_A" ;
lin amentiferous_A = mkTerm "amentiferous_A" ;
lin amerciable_A = mkTerm "amerciable_A" ;
lin america_PN = mkTerm "america_PN" ;
lin americanFem_N = mkTerm "americanFem_N" ;
lin americanMasc_N = mkTerm "americanMasc_N" ;
lin american_A = mkTerm "american_A" ;
lin americanism_N = mkTerm "americanism_N" ;
lin americanize_V2 = mkTerm "americanize_V2" ;
lin americium_N = mkTerm "americium_N" ;
lin amesbury_PN = mkTerm "amesbury_PN" ;
lin ametabolic_A = mkTerm "ametabolic_A" ;
lin amethyst_A = mkTerm "amethyst_A" ;
lin amethyst_N = mkTerm "amethyst_N" ;
lin amethystine_A = mkTerm "amethystine_A" ;
lin ametria_N = mkTerm "ametria_N" ;
lin ametropia_N = mkTerm "ametropia_N" ;
lin ametropic_A = mkTerm "ametropic_A" ;
lin amiability_N = mkTerm "amiability_N" ;
lin amiable_A = mkTerm "amiable_A" ;
lin amicability_N = mkTerm "amicability_N" ;
lin amicable_A = mkTerm "amicable_A" ;
lin amid_Prep = mkTerm "amid_Prep" ;
lin amide_N = mkTerm "amide_N" ;
lin amidship_A = mkTerm "amidship_A" ;
lin amidship_Adv = mkTerm "amidship_Adv" ;
lin amidships_Adv = mkTerm "amidships_Adv" ;
lin amidst_Prep = mkTerm "amidst_Prep" ;
lin amiens_PN = mkTerm "amiens_PN" ;
lin amigo_N = mkTerm "amigo_N" ;
lin amine_N = mkTerm "amine_N" ;
lin amino_A = mkTerm "amino_A" ;
lin amino_N = mkTerm "amino_N" ;
lin aminoaciduria_N = mkTerm "aminoaciduria_N" ;
lin aminomethane_N = mkTerm "aminomethane_N" ;
lin aminophylline_N = mkTerm "aminophylline_N" ;
lin aminopyrine_N = mkTerm "aminopyrine_N" ;
lin amiodarone_N = mkTerm "amiodarone_N" ;
lin amir_N = mkTerm "amir_N" ;
lin amiss_A = mkTerm "amiss_A" ;
lin amiss_Adv = mkTerm "amiss_Adv" ;
lin amitosis_N = mkTerm "amitosis_N" ;
lin amitotic_A = mkTerm "amitotic_A" ;
lin amitriptyline_N = mkTerm "amitriptyline_N" ;
lin amity_N = mkTerm "amity_N" ;
lin ammanford_PN = mkTerm "ammanford_PN" ;
lin ammeter_N = mkTerm "ammeter_N" ;
lin ammine_N = mkTerm "ammine_N" ;
lin ammino_A = mkTerm "ammino_A" ;
lin ammobium_N = mkTerm "ammobium_N" ;
lin ammonia_N = mkTerm "ammonia_N" ;
lin ammoniac_A = mkTerm "ammoniac_A" ;
lin ammoniac_N = mkTerm "ammoniac_N" ;
lin ammoniated_A = mkTerm "ammoniated_A" ;
lin ammonification_N = mkTerm "ammonification_N" ;
lin ammonite_N = mkTerm "ammonite_N" ;
lin ammonitic_A = mkTerm "ammonitic_A" ;
lin ammonium_N = mkTerm "ammonium_N" ;
lin ammoniuria_N = mkTerm "ammoniuria_N" ;
lin ammunition_N = mkTerm "ammunition_N" ;
lin amnesia_N = mkTerm "amnesia_N" ;
lin amnesic_A = mkTerm "amnesic_A" ;
lin amnesic_N = mkTerm "amnesic_N" ;
lin amnestic_A = mkTerm "amnestic_A" ;
lin amnesty_N = mkTerm "amnesty_N" ;
lin amniocentesis_N = mkTerm "amniocentesis_N" ;
lin amnion_N = mkTerm "amnion_N" ;
lin amniote_N = mkTerm "amniote_N" ;
lin amniotic_A = mkTerm "amniotic_A" ;
lin amobarbital_N = mkTerm "amobarbital_N" ;
lin amoeba_N = mkTerm "amoeba_N" ;
lin amoebic_A = mkTerm "amoebic_A" ;
lin among_Prep = mkTerm "among_Prep" ;
lin amongst_Prep = mkTerm "amongst_Prep" ;
lin amora_N = mkTerm "amora_N" ;
lin amoral_A = mkTerm "amoral_A" ;
lin amoralism_N = mkTerm "amoralism_N" ;
lin amoralist_N = mkTerm "amoralist_N" ;
lin amorality_N = mkTerm "amorality_N" ;
lin amorist_N = mkTerm "amorist_N" ;
lin amoristic_A = mkTerm "amoristic_A" ;
lin amorous_A = mkTerm "amorous_A" ;
lin amorousness_N = mkTerm "amorousness_N" ;
lin amorpha_N = mkTerm "amorpha_N" ;
lin amorphophallus_N = mkTerm "amorphophallus_N" ;
lin amorphous_A = mkTerm "amorphous_A" ;
lin amort_A = mkTerm "amort_A" ;
lin amortization_N = mkTerm "amortization_N" ;
lin amortize_V2 = mkTerm "amortize_V2" ;
lin amount_N = mkTerm "amount_N" ;
lin amount_V = mkTerm "amount_V" ;
lin amour_N = mkTerm "amour_N" ;
lin amour_propre_N = mkTerm "amour_propre_N" ;
lin amoxicillin_N = mkTerm "amoxicillin_N" ;
lin amp_Conj = mkTerm "amp_Conj" ;
lin amp_N = mkTerm "amp_N" ;
lin amperage_N = mkTerm "amperage_N" ;
lin ampere_N = mkTerm "ampere_N" ;
lin ampersand_N = mkTerm "ampersand_N" ;
lin amphetamine_N = mkTerm "amphetamine_N" ;
lin amphibia_N = mkTerm "amphibia_N" ;
lin amphibian_N = mkTerm "amphibian_N" ;
lin amphibiotic_A = mkTerm "amphibiotic_A" ;
lin amphibious_A = mkTerm "amphibious_A" ;
lin amphibole_N = mkTerm "amphibole_N" ;
lin amphibolite_N = mkTerm "amphibolite_N" ;
lin amphibology_N = mkTerm "amphibology_N" ;
lin amphibrach_N = mkTerm "amphibrach_N" ;
lin amphictyony_N = mkTerm "amphictyony_N" ;
lin amphidiploid_N = mkTerm "amphidiploid_N" ;
lin amphidiploidy_N = mkTerm "amphidiploidy_N" ;
lin amphigory_N = mkTerm "amphigory_N" ;
lin amphimixis_N = mkTerm "amphimixis_N" ;
lin amphipod_N = mkTerm "amphipod_N" ;
lin amphiprostylar_A = mkTerm "amphiprostylar_A" ;
lin amphisbaena_N = mkTerm "amphisbaena_N" ;
lin amphistylar_A = mkTerm "amphistylar_A" ;
lin amphitheatre_N = mkTerm "amphitheatre_N" ;
lin amphitheatric_A = mkTerm "amphitheatric_A" ;
lin amphitropous_A = mkTerm "amphitropous_A" ;
lin amphiuma_N = mkTerm "amphiuma_N" ;
lin amphora_N = mkTerm "amphora_N" ;
lin amphoric_A = mkTerm "amphoric_A" ;
lin amphoteric_A = mkTerm "amphoteric_A" ;
lin amphotericin_N = mkTerm "amphotericin_N" ;
lin ampicillin_N = mkTerm "ampicillin_N" ;
lin ample_A = mkTerm "ample_A" ;
lin ampleness_N = mkTerm "ampleness_N" ;
lin amplification_N = mkTerm "amplification_N" ;
lin amplifier_N = mkTerm "amplifier_N" ;
lin amplify_V2 = mkTerm "amplify_V2" ;
lin amplitude_N = mkTerm "amplitude_N" ;
lin ampoule_N = mkTerm "ampoule_N" ;
lin ampulla_N = mkTerm "ampulla_N" ;
lin ampullar_A = mkTerm "ampullar_A" ;
lin amputate_V2 = mkTerm "amputate_V2" ;
lin amputation_N = mkTerm "amputation_N" ;
lin amputator_N = mkTerm "amputator_N" ;
lin amputee_N = mkTerm "amputee_N" ;
lin amrinone_N = mkTerm "amrinone_N" ;
lin amsterdam_PN = mkTerm "amsterdam_PN" ;
lin amuck_A = mkTerm "amuck_A" ;
lin amuck_Adv = mkTerm "amuck_Adv" ;
lin amulet_N = mkTerm "amulet_N" ;
lin amuse_V2 = mkTerm "amuse_V2" ;
lin amusement_N = mkTerm "amusement_N" ;
lin amusing_A = mkTerm "amusing_A" ;
lin amy_PN = mkTerm "amy_PN" ;
lin amygdala_N = mkTerm "amygdala_N" ;
lin amygdalin_N = mkTerm "amygdalin_N" ;
lin amygdaline_A = mkTerm "amygdaline_A" ;
lin amygdaloid_N = mkTerm "amygdaloid_N" ;
lin amygdalotomy_N = mkTerm "amygdalotomy_N" ;
lin amyl_N = mkTerm "amyl_N" ;
lin amylase_N = mkTerm "amylase_N" ;
lin amyloid_N = mkTerm "amyloid_N" ;
lin amyloidosis_N = mkTerm "amyloidosis_N" ;
lin amylolysis_N = mkTerm "amylolysis_N" ;
lin amylolytic_A = mkTerm "amylolytic_A" ;
lin amyotrophia_N = mkTerm "amyotrophia_N" ;
lin amyxia_N = mkTerm "amyxia_N" ;
lin ana_N = mkTerm "ana_N" ;
lin anabatic_A = mkTerm "anabatic_A" ;
lin anabiosis_N = mkTerm "anabiosis_N" ;
lin anabiotic_A = mkTerm "anabiotic_A" ;
lin anabolic_A = mkTerm "anabolic_A" ;
lin anabolism_N = mkTerm "anabolism_N" ;
lin anachronic_A = mkTerm "anachronic_A" ;
lin anachronism_N = mkTerm "anachronism_N" ;
lin anachronistic_A = mkTerm "anachronistic_A" ;
lin anachronistically_Adv = mkTerm "anachronistically_Adv" ;
lin anaclinal_A = mkTerm "anaclinal_A" ;
lin anaclisis_N = mkTerm "anaclisis_N" ;
lin anaclitic_A = mkTerm "anaclitic_A" ;
lin anacoluthia_N = mkTerm "anacoluthia_N" ;
lin anacoluthic_A = mkTerm "anacoluthic_A" ;
lin anaconda_N = mkTerm "anaconda_N" ;
lin anadiplosis_N = mkTerm "anadiplosis_N" ;
lin anadromous_A = mkTerm "anadromous_A" ;
lin anaemia_N = mkTerm "anaemia_N" ;
lin anaemic_A = mkTerm "anaemic_A" ;
lin anaerobe_N = mkTerm "anaerobe_N" ;
lin anaerobic_A = mkTerm "anaerobic_A" ;
lin anaesthesia_N = mkTerm "anaesthesia_N" ;
lin anaesthetic_A = mkTerm "anaesthetic_A" ;
lin anaesthetic_N = mkTerm "anaesthetic_N" ;
lin anaesthetist_N = mkTerm "anaesthetist_N" ;
lin anaglyph_N = mkTerm "anaglyph_N" ;
lin anaglyphic_A = mkTerm "anaglyphic_A" ;
lin anaglyphy_N = mkTerm "anaglyphy_N" ;
lin anagnost_N = mkTerm "anagnost_N" ;
lin anagoge_N = mkTerm "anagoge_N" ;
lin anagogic_A = mkTerm "anagogic_A" ;
lin anagram_N = mkTerm "anagram_N" ;
lin anagrammatic_A = mkTerm "anagrammatic_A" ;
lin anagrams_N = mkTerm "anagrams_N" ;
lin anal_A = mkTerm "anal_A" ;
lin analbuminemia_N = mkTerm "analbuminemia_N" ;
lin analects_N = mkTerm "analects_N" ;
lin analeptic_A = mkTerm "analeptic_A" ;
lin analeptic_N = mkTerm "analeptic_N" ;
lin analgesia_N = mkTerm "analgesia_N" ;
lin analgesic_A = mkTerm "analgesic_A" ;
lin analgesic_N = mkTerm "analgesic_N" ;
lin analog_N = mkTerm "analog_N" ;
lin analogical_A = mkTerm "analogical_A" ;
lin analogist_N = mkTerm "analogist_N" ;
lin analogous_A = mkTerm "analogous_A" ;
lin analogue_A = mkTerm "analogue_A" ;
lin analogue_N = mkTerm "analogue_N" ;
lin analogy_N = mkTerm "analogy_N" ;
lin analphabet_N = mkTerm "analphabet_N" ;
lin analphabetic_A = mkTerm "analphabetic_A" ;
lin analysand_N = mkTerm "analysand_N" ;
lin analysis_N = mkTerm "analysis_N" ;
lin analyst_N = mkTerm "analyst_N" ;
lin analytic_A = mkTerm "analytic_A" ;
lin analytical_A = mkTerm "analytical_A" ;
lin analyticity_N = mkTerm "analyticity_N" ;
lin analyzable_A = mkTerm "analyzable_A" ;
lin analyze_V2 = mkTerm "analyze_V2" ;
lin analyzer_N = mkTerm "analyzer_N" ;
lin anamnestic_A = mkTerm "anamnestic_A" ;
lin anamorphic_A = mkTerm "anamorphic_A" ;
lin anamorphism_N = mkTerm "anamorphism_N" ;
lin anamorphosis_N = mkTerm "anamorphosis_N" ;
lin anapaest_N = mkTerm "anapaest_N" ;
lin anapaestic_A = mkTerm "anapaestic_A" ;
lin anapest_N = mkTerm "anapest_N" ;
lin anapestic_A = mkTerm "anapestic_A" ;
lin anaphase_N = mkTerm "anaphase_N" ;
lin anaphasic_A = mkTerm "anaphasic_A" ;
lin anaphor_N = mkTerm "anaphor_N" ;
lin anaphora_N = mkTerm "anaphora_N" ;
lin anaphoric_A = mkTerm "anaphoric_A" ;
lin anaphrodisia_N = mkTerm "anaphrodisia_N" ;
lin anaphrodisiac_A = mkTerm "anaphrodisiac_A" ;
lin anaphylactic_A = mkTerm "anaphylactic_A" ;
lin anaphylaxis_N = mkTerm "anaphylaxis_N" ;
lin anaplasia_N = mkTerm "anaplasia_N" ;
lin anaplasmosis_N = mkTerm "anaplasmosis_N" ;
lin anaplastic_A = mkTerm "anaplastic_A" ;
lin anapsid_N = mkTerm "anapsid_N" ;
lin anarchic_A = mkTerm "anarchic_A" ;
lin anarchism_N = mkTerm "anarchism_N" ;
lin anarchistFem_N = mkTerm "anarchistFem_N" ;
lin anarchistMasc_N = mkTerm "anarchistMasc_N" ;
lin anarchistic_A = mkTerm "anarchistic_A" ;
lin anarchy_N = mkTerm "anarchy_N" ;
lin anarthria_N = mkTerm "anarthria_N" ;
lin anasarca_N = mkTerm "anasarca_N" ;
lin anasarcous_A = mkTerm "anasarcous_A" ;
lin anaspid_N = mkTerm "anaspid_N" ;
lin anastalsis_N = mkTerm "anastalsis_N" ;
lin anastigmat_N = mkTerm "anastigmat_N" ;
lin anastigmatic_A = mkTerm "anastigmatic_A" ;
lin anastomosis_N = mkTerm "anastomosis_N" ;
lin anastomotic_A = mkTerm "anastomotic_A" ;
lin anastrophe_N = mkTerm "anastrophe_N" ;
lin anastylosis_N = mkTerm "anastylosis_N" ;
lin anathema_N = mkTerm "anathema_N" ;
lin anathematization_N = mkTerm "anathematization_N" ;
lin anathematize_V = mkTerm "anathematize_V" ;
lin anathematize_V2 = mkTerm "anathematize_V2" ;
lin anatomic_A = mkTerm "anatomic_A" ;
lin anatomical_A = mkTerm "anatomical_A" ;
lin anatomist_N = mkTerm "anatomist_N" ;
lin anatomy_N = mkTerm "anatomy_N" ;
lin anatotitan_N = mkTerm "anatotitan_N" ;
lin anatoxin_N = mkTerm "anatoxin_N" ;
lin anatropous_A = mkTerm "anatropous_A" ;
lin ancestor_N = mkTerm "ancestor_N" ;
lin ancestral_A = mkTerm "ancestral_A" ;
lin ancestress_N = mkTerm "ancestress_N" ;
lin ancestry_N = mkTerm "ancestry_N" ;
lin anchor_N = mkTerm "anchor_N" ;
lin anchor_V = mkTerm "anchor_V" ;
lin anchor_V2 = mkTerm "anchor_V2" ;
lin anchorage_N = mkTerm "anchorage_N" ;
lin anchorite_N = mkTerm "anchorite_N" ;
lin anchoritic_A = mkTerm "anchoritic_A" ;
lin anchorman_N = mkTerm "anchorman_N" ;
lin anchovy_N = mkTerm "anchovy_N" ;
lin anchusa_N = mkTerm "anchusa_N" ;
lin ancient_A = mkTerm "ancient_A" ;
lin ancient_N = mkTerm "ancient_N" ;
lin ancientness_N = mkTerm "ancientness_N" ;
lin ancillary_A = mkTerm "ancillary_A" ;
lin ancona_PN = mkTerm "ancona_PN" ;
lin andante_A = mkTerm "andante_A" ;
lin andante_Adv = mkTerm "andante_Adv" ;
lin andante_N = mkTerm "andante_N" ;
lin andantino_A = mkTerm "andantino_A" ;
lin andesite_N = mkTerm "andesite_N" ;
lin andiron_N = mkTerm "andiron_N" ;
lin andorra_PN = mkTerm "andorra_PN" ;
lin andorran_A = mkTerm "andorran_A" ;
lin andorran_N = mkTerm "andorran_N" ;
lin andover_PN = mkTerm "andover_PN" ;
lin andradite_N = mkTerm "andradite_N" ;
lin andrena_N = mkTerm "andrena_N" ;
lin andrew_PN = mkTerm "andrew_PN" ;
lin androecium_N = mkTerm "androecium_N" ;
lin androgen_N = mkTerm "androgen_N" ;
lin androgenesis_N = mkTerm "androgenesis_N" ;
lin androgenetic_A = mkTerm "androgenetic_A" ;
lin androgenic_A = mkTerm "androgenic_A" ;
lin androglossia_N = mkTerm "androglossia_N" ;
lin androgynous_A = mkTerm "androgynous_A" ;
lin androgyny_N = mkTerm "androgyny_N" ;
lin android_N = mkTerm "android_N" ;
lin andromeda_N = mkTerm "andromeda_N" ;
lin androphobia_N = mkTerm "androphobia_N" ;
lin androsterone_N = mkTerm "androsterone_N" ;
lin andryala_N = mkTerm "andryala_N" ;
lin andy_PN = mkTerm "andy_PN" ;
lin anecdotal_A = mkTerm "anecdotal_A" ;
lin anecdote_N = mkTerm "anecdote_N" ;
lin anecdotic_A = mkTerm "anecdotic_A" ;
lin anecdotist_N = mkTerm "anecdotist_N" ;
lin anechoic_A = mkTerm "anechoic_A" ;
lin anemia_N = mkTerm "anemia_N" ;
lin anemic_A = mkTerm "anemic_A" ;
lin anemographic_A = mkTerm "anemographic_A" ;
lin anemography_N = mkTerm "anemography_N" ;
lin anemometer_N = mkTerm "anemometer_N" ;
lin anemometric_A = mkTerm "anemometric_A" ;
lin anemometry_N = mkTerm "anemometry_N" ;
lin anemone_N = mkTerm "anemone_N" ;
lin anemophilous_A = mkTerm "anemophilous_A" ;
lin anencephalic_A = mkTerm "anencephalic_A" ;
lin anencephaly_N = mkTerm "anencephaly_N" ;
lin anenst_Prep = mkTerm "anenst_Prep" ;
lin anent_Prep = mkTerm "anent_Prep" ;
lin anergy_N = mkTerm "anergy_N" ;
lin aneroid_A = mkTerm "aneroid_A" ;
lin aneroid_N = mkTerm "aneroid_N" ;
lin anesthesia_N = mkTerm "anesthesia_N" ;
lin anesthesiologist_N = mkTerm "anesthesiologist_N" ;
lin anesthesiology_N = mkTerm "anesthesiology_N" ;
lin anesthetic_A = mkTerm "anesthetic_A" ;
lin anesthetic_N = mkTerm "anesthetic_N" ;
lin anesthetist_N = mkTerm "anesthetist_N" ;
lin anesthetize_V2 = mkTerm "anesthetize_V2" ;
lin anesthyl_N = mkTerm "anesthyl_N" ;
lin anestrous_A = mkTerm "anestrous_A" ;
lin anestrus_N = mkTerm "anestrus_N" ;
lin aneuploid_A = mkTerm "aneuploid_A" ;
lin aneuploidy_N = mkTerm "aneuploidy_N" ;
lin aneurysm_N = mkTerm "aneurysm_N" ;
lin aneurysmal_A = mkTerm "aneurysmal_A" ;
lin anew_Adv = mkTerm "anew_Adv" ;
lin anfractuous_A = mkTerm "anfractuous_A" ;
lin angel_N = mkTerm "angel_N" ;
lin angela_PN = mkTerm "angela_PN" ;
lin angelfish_N = mkTerm "angelfish_N" ;
lin angelic_A = mkTerm "angelic_A" ;
lin angelica_N = mkTerm "angelica_N" ;
lin angelim_N = mkTerm "angelim_N" ;
lin angelology_N = mkTerm "angelology_N" ;
lin angelus_N = mkTerm "angelus_N" ;
lin anger_N = mkTerm "anger_N" ;
lin anger_V2 = mkTerm "anger_V2" ;
lin angers_PN = mkTerm "angers_PN" ;
lin angie_PN = mkTerm "angie_PN" ;
lin angiitis_N = mkTerm "angiitis_N" ;
lin angina_N = mkTerm "angina_N" ;
lin anginal_A = mkTerm "anginal_A" ;
lin angiocardiogram_N = mkTerm "angiocardiogram_N" ;
lin angiocarp_N = mkTerm "angiocarp_N" ;
lin angiocarpic_A = mkTerm "angiocarpic_A" ;
lin angioedema_N = mkTerm "angioedema_N" ;
lin angiogenesis_N = mkTerm "angiogenesis_N" ;
lin angiogram_N = mkTerm "angiogram_N" ;
lin angiography_N = mkTerm "angiography_N" ;
lin angiologist_N = mkTerm "angiologist_N" ;
lin angiology_N = mkTerm "angiology_N" ;
lin angioma_N = mkTerm "angioma_N" ;
lin angiomatous_A = mkTerm "angiomatous_A" ;
lin angiopathy_N = mkTerm "angiopathy_N" ;
lin angioplasty_N = mkTerm "angioplasty_N" ;
lin angiopteris_N = mkTerm "angiopteris_N" ;
lin angiosarcoma_N = mkTerm "angiosarcoma_N" ;
lin angioscope_N = mkTerm "angioscope_N" ;
lin angiosperm_N = mkTerm "angiosperm_N" ;
lin angiospermous_A = mkTerm "angiospermous_A" ;
lin angiotelectasia_N = mkTerm "angiotelectasia_N" ;
lin angiotensin_N = mkTerm "angiotensin_N" ;
lin angle_N = mkTerm "angle_N" ;
lin angle_V = mkTerm "angle_V" ;
lin angle_V2 = mkTerm "angle_V2" ;
lin angle_dozer_N = mkTerm "angle_dozer_N" ;
lin angle_for_V2 = mkTerm "angle_for_V2" ;
lin angle_iron_N = mkTerm "angle_iron_N" ;
lin angle_park_V = mkTerm "angle_park_V" ;
lin angle_park_V2 = mkTerm "angle_park_V2" ;
lin angler_N = mkTerm "angler_N" ;
lin anglewing_N = mkTerm "anglewing_N" ;
lin anglican_A = mkTerm "anglican_A" ;
lin anglican_N = mkTerm "anglican_N" ;
lin anglicism_N = mkTerm "anglicism_N" ;
lin anglicize_V2 = mkTerm "anglicize_V2" ;
lin angling_N = mkTerm "angling_N" ;
lin anglo_catholic_A = mkTerm "anglo_catholic_A" ;
lin anglo_catholic_N = mkTerm "anglo_catholic_N" ;
lin anglo_indian_A = mkTerm "anglo_indian_A" ;
lin anglo_indian_N = mkTerm "anglo_indian_N" ;
lin anglo_saxon_A = mkTerm "anglo_saxon_A" ;
lin anglo_saxon_N = mkTerm "anglo_saxon_N" ;
lin anglomania_N = mkTerm "anglomania_N" ;
lin anglophilFem_N = mkTerm "anglophilFem_N" ;
lin anglophilMasc_N = mkTerm "anglophilMasc_N" ;
lin anglophileFem_N = mkTerm "anglophileFem_N" ;
lin anglophileMasc_N = mkTerm "anglophileMasc_N" ;
lin anglophobe_N = mkTerm "anglophobe_N" ;
lin anglophobia_N = mkTerm "anglophobia_N" ;
lin angola_PN = mkTerm "angola_PN" ;
lin angolan_A = mkTerm "angolan_A" ;
lin angolan_N = mkTerm "angolan_N" ;
lin angora_N = mkTerm "angora_N" ;
lin angostura_N = mkTerm "angostura_N" ;
lin angrecum_N = mkTerm "angrecum_N" ;
lin angry_A = mkTerm "angry_A" ;
lin angst_N = mkTerm "angst_N" ;
lin angstrom_N = mkTerm "angstrom_N" ;
lin anguilla_PN = mkTerm "anguilla_PN" ;
lin anguillan_A = mkTerm "anguillan_A" ;
lin anguillan_N = mkTerm "anguillan_N" ;
lin anguine_A = mkTerm "anguine_A" ;
lin anguish_N = mkTerm "anguish_N" ;
lin anguished_A = mkTerm "anguished_A" ;
lin angular_A = mkTerm "angular_A" ;
lin angularity_N = mkTerm "angularity_N" ;
lin angulation_N = mkTerm "angulation_N" ;
lin angus_PN = mkTerm "angus_PN" ;
lin angwantibo_N = mkTerm "angwantibo_N" ;
lin anhedonia_N = mkTerm "anhedonia_N" ;
lin anhidrosis_N = mkTerm "anhidrosis_N" ;
lin anhydride_N = mkTerm "anhydride_N" ;
lin anhydrous_A = mkTerm "anhydrous_A" ;
lin ani_N = mkTerm "ani_N" ;
lin anicteric_A = mkTerm "anicteric_A" ;
lin anil_N = mkTerm "anil_N" ;
lin anile_A = mkTerm "anile_A" ;
lin aniline_N = mkTerm "aniline_N" ;
lin anima_N = mkTerm "anima_N" ;
lin animadversion_N = mkTerm "animadversion_N" ;
lin animadvert_V = mkTerm "animadvert_V" ;
lin animal_A = mkTerm "animal_A" ;
lin animal_N = mkTerm "animal_N" ;
lin animalcule_N = mkTerm "animalcule_N" ;
lin animalism_N = mkTerm "animalism_N" ;
lin animalistic_A = mkTerm "animalistic_A" ;
lin animality_N = mkTerm "animality_N" ;
lin animalization_N = mkTerm "animalization_N" ;
lin animate_A = mkTerm "animate_A" ;
lin animate_V2 = mkTerm "animate_V2" ;
lin animatedly_A = mkTerm "animatedly_A" ;
lin animatedly_Adv = mkTerm "animatedly_Adv" ;
lin animateness_N = mkTerm "animateness_N" ;
lin animating_A = mkTerm "animating_A" ;
lin animation_N = mkTerm "animation_N" ;
lin animatism_N = mkTerm "animatism_N" ;
lin animatistic_A = mkTerm "animatistic_A" ;
lin animator_N = mkTerm "animator_N" ;
lin animatronics_N = mkTerm "animatronics_N" ;
lin anime_N = mkTerm "anime_N" ;
lin animism_N = mkTerm "animism_N" ;
lin animist_A = mkTerm "animist_A" ;
lin animist_N = mkTerm "animist_N" ;
lin animosity_N = mkTerm "animosity_N" ;
lin animus_N = mkTerm "animus_N" ;
lin anion_N = mkTerm "anion_N" ;
lin anionic_A = mkTerm "anionic_A" ;
lin anise_N = mkTerm "anise_N" ;
lin aniseed_N = mkTerm "aniseed_N" ;
lin aniseikonia_N = mkTerm "aniseikonia_N" ;
lin aniseikonic_A = mkTerm "aniseikonic_A" ;
lin anisette_N = mkTerm "anisette_N" ;
lin anisogamete_N = mkTerm "anisogamete_N" ;
lin anisogametic_A = mkTerm "anisogametic_A" ;
lin anisogamic_A = mkTerm "anisogamic_A" ;
lin anisogamy_N = mkTerm "anisogamy_N" ;
lin anisometric_A = mkTerm "anisometric_A" ;
lin anisometropia_N = mkTerm "anisometropia_N" ;
lin anisometropic_A = mkTerm "anisometropic_A" ;
lin anisotropic_A = mkTerm "anisotropic_A" ;
lin anisotropy_N = mkTerm "anisotropy_N" ;
lin anita_PN = mkTerm "anita_PN" ;
lin anjala_PN = mkTerm "anjala_PN" ;
lin anjou_N = mkTerm "anjou_N" ;
lin ankara_PN = mkTerm "ankara_PN" ;
lin ankle_N = mkTerm "ankle_N" ;
lin anklebone_N = mkTerm "anklebone_N" ;
lin anklet_N = mkTerm "anklet_N" ;
lin ankus_N = mkTerm "ankus_N" ;
lin ankylosaur_N = mkTerm "ankylosaur_N" ;
lin ankylosis_N = mkTerm "ankylosis_N" ;
lin ankylotic_A = mkTerm "ankylotic_A" ;
lin ann_PN = mkTerm "ann_PN" ;
lin anna_N = mkTerm "anna_N" ;
lin anna_PN = mkTerm "anna_PN" ;
lin annabel_PN = mkTerm "annabel_PN" ;
lin annalist_N = mkTerm "annalist_N" ;
lin annalistic_A = mkTerm "annalistic_A" ;
lin annals_N = mkTerm "annals_N" ;
lin annan_PN = mkTerm "annan_PN" ;
lin anne_PN = mkTerm "anne_PN" ;
lin anneal_V2 = mkTerm "anneal_V2" ;
lin annealing_N = mkTerm "annealing_N" ;
lin annelid_A = mkTerm "annelid_A" ;
lin annelid_N = mkTerm "annelid_N" ;
lin annex_N = mkTerm "annex_N" ;
lin annex_V2 = mkTerm "annex_V2" ;
lin annexation_N = mkTerm "annexation_N" ;
lin annexational_A = mkTerm "annexational_A" ;
lin annexe_N = mkTerm "annexe_N" ;
lin annfield_PN = mkTerm "annfield_PN" ;
lin annfield_plain_PN = mkTerm "annfield_plain_PN" ;
lin annie_PN = mkTerm "annie_PN" ;
lin annihilate_V2 = mkTerm "annihilate_V2" ;
lin annihilating_A = mkTerm "annihilating_A" ;
lin annihilation_N = mkTerm "annihilation_N" ;
lin annihilative_A = mkTerm "annihilative_A" ;
lin annihilator_N = mkTerm "annihilator_N" ;
lin anniversary_N = mkTerm "anniversary_N" ;
lin annotate_V2 = mkTerm "annotate_V2" ;
lin annotation_N = mkTerm "annotation_N" ;
lin annotator_N = mkTerm "annotator_N" ;
lin announce_V2 = mkTerm "announce_V2" ;
lin announce_VS = mkTerm "announce_VS" ;
lin announcement_N = mkTerm "announcement_N" ;
lin announcer_N = mkTerm "announcer_N" ;
lin annoy_V2 = mkTerm "annoy_V2" ;
lin annoyance_N = mkTerm "annoyance_N" ;
lin annoying_A = mkTerm "annoying_A" ;
lin annual_A = mkTerm "annual_A" ;
lin annual_N = mkTerm "annual_N" ;
lin annuitant_N = mkTerm "annuitant_N" ;
lin annuity_N = mkTerm "annuity_N" ;
lin annul_V2 = mkTerm "annul_V2" ;
lin annular_A = mkTerm "annular_A" ;
lin annulet_N = mkTerm "annulet_N" ;
lin annulment_N = mkTerm "annulment_N" ;
lin annulus_N = mkTerm "annulus_N" ;
lin annum_N = mkTerm "annum_N" ;
lin annunciate_V2 = mkTerm "annunciate_V2" ;
lin annunciation_N = mkTerm "annunciation_N" ;
lin annunciator_N = mkTerm "annunciator_N" ;
lin annunciatory_A = mkTerm "annunciatory_A" ;
lin anoa_N = mkTerm "anoa_N" ;
lin anode_N = mkTerm "anode_N" ;
lin anodic_A = mkTerm "anodic_A" ;
lin anodyne_A = mkTerm "anodyne_A" ;
lin anodyne_N = mkTerm "anodyne_N" ;
lin anoint_V2 = mkTerm "anoint_V2" ;
lin anointer_N = mkTerm "anointer_N" ;
lin anointing_N = mkTerm "anointing_N" ;
lin anointment_N = mkTerm "anointment_N" ;
lin anomalist_N = mkTerm "anomalist_N" ;
lin anomalops_N = mkTerm "anomalops_N" ;
lin anomalopteryx_N = mkTerm "anomalopteryx_N" ;
lin anomalous_A = mkTerm "anomalous_A" ;
lin anomaly_N = mkTerm "anomaly_N" ;
lin anomie_N = mkTerm "anomie_N" ;
lin anon_Adv = mkTerm "anon_Adv" ;
lin anon_PN = mkTerm "anon_PN" ;
lin anonymity_N = mkTerm "anonymity_N" ;
lin anonymous_A = mkTerm "anonymous_A" ;
lin anoperineal_A = mkTerm "anoperineal_A" ;
lin anopheles_N = mkTerm "anopheles_N" ;
lin anopheline_A = mkTerm "anopheline_A" ;
lin anopheline_N = mkTerm "anopheline_N" ;
lin anopia_N = mkTerm "anopia_N" ;
lin anorak_N = mkTerm "anorak_N" ;
lin anorchism_N = mkTerm "anorchism_N" ;
lin anorectal_A = mkTerm "anorectal_A" ;
lin anorectic_A = mkTerm "anorectic_A" ;
lin anorexia_N = mkTerm "anorexia_N" ;
lin anorexic_A = mkTerm "anorexic_A" ;
lin anorexic_N = mkTerm "anorexic_N" ;
lin anorgasmia_N = mkTerm "anorgasmia_N" ;
lin anorthite_N = mkTerm "anorthite_N" ;
lin anorthitic_A = mkTerm "anorthitic_A" ;
lin anorthopia_N = mkTerm "anorthopia_N" ;
lin anosmia_N = mkTerm "anosmia_N" ;
lin anosmic_A = mkTerm "anosmic_A" ;
lin another_Det = mkTerm "another_Det" ;
lin another_Quant = mkTerm "another_Quant" ;
lin anovulation_N = mkTerm "anovulation_N" ;
lin anoxemia_N = mkTerm "anoxemia_N" ;
lin anoxemic_A = mkTerm "anoxemic_A" ;
lin anoxia_N = mkTerm "anoxia_N" ;
lin anoxic_A = mkTerm "anoxic_A" ;
lin anserine_A = mkTerm "anserine_A" ;
lin anshan_PN = mkTerm "anshan_PN" ;
lin answer_N = mkTerm "answer_N" ;
lin answer_V = mkTerm "answer_V" ;
lin answer_V2 = mkTerm "answer_V2" ;
lin answer_back_V2 = mkTerm "answer_back_V2" ;
lin answer_for_V2 = mkTerm "answer_for_V2" ;
lin answerable_A = mkTerm "answerable_A" ;
lin ant_N = mkTerm "ant_N" ;
lin ant_eater_N = mkTerm "ant_eater_N" ;
lin ant_hill_N = mkTerm "ant_hill_N" ;
lin antacid_A = mkTerm "antacid_A" ;
lin antacid_N = mkTerm "antacid_N" ;
lin antagonism_N = mkTerm "antagonism_N" ;
lin antagonist_N = mkTerm "antagonist_N" ;
lin antagonistic_A = mkTerm "antagonistic_A" ;
lin antagonize_V2 = mkTerm "antagonize_V2" ;
lin antapex_N = mkTerm "antapex_N" ;
lin antarctic_A = mkTerm "antarctic_A" ;
lin antbird_N = mkTerm "antbird_N" ;
lin ante_N = mkTerm "ante_N" ;
lin ante_meridiem_Adv = mkTerm "ante_meridiem_Adv" ;
lin antebellum_A = mkTerm "antebellum_A" ;
lin antecedence_N = mkTerm "antecedence_N" ;
lin antecedent_A = mkTerm "antecedent_A" ;
lin antecedent_N = mkTerm "antecedent_N" ;
lin antechamber_N = mkTerm "antechamber_N" ;
lin antecubital_A = mkTerm "antecubital_A" ;
lin antedate_V2 = mkTerm "antedate_V2" ;
lin antediluvian_A = mkTerm "antediluvian_A" ;
lin antediluvian_N = mkTerm "antediluvian_N" ;
lin antefix_N = mkTerm "antefix_N" ;
lin antelope_N = mkTerm "antelope_N" ;
lin antemeridian_A = mkTerm "antemeridian_A" ;
lin antemortem_A = mkTerm "antemortem_A" ;
lin antenatal_A = mkTerm "antenatal_A" ;
lin antenna_N = mkTerm "antenna_N" ;
lin antennal_A = mkTerm "antennal_A" ;
lin antenuptial_A = mkTerm "antenuptial_A" ;
lin antepenult_N = mkTerm "antepenult_N" ;
lin antepenultimate_A = mkTerm "antepenultimate_A" ;
lin anterior_A = mkTerm "anterior_A" ;
lin anteriority_N = mkTerm "anteriority_N" ;
lin anterograde_A = mkTerm "anterograde_A" ;
lin anteroom_N = mkTerm "anteroom_N" ;
lin anthea_PN = mkTerm "anthea_PN" ;
lin anthelmintic_A = mkTerm "anthelmintic_A" ;
lin anthem_N = mkTerm "anthem_N" ;
lin anther_N = mkTerm "anther_N" ;
lin antheral_A = mkTerm "antheral_A" ;
lin antheridial_A = mkTerm "antheridial_A" ;
lin antheridiophore_N = mkTerm "antheridiophore_N" ;
lin antheridium_N = mkTerm "antheridium_N" ;
lin antherozoid_N = mkTerm "antherozoid_N" ;
lin anthologist_N = mkTerm "anthologist_N" ;
lin anthology_N = mkTerm "anthology_N" ;
lin anthony_PN = mkTerm "anthony_PN" ;
lin anthophagous_A = mkTerm "anthophagous_A" ;
lin anthophyllite_N = mkTerm "anthophyllite_N" ;
lin anthozoan_N = mkTerm "anthozoan_N" ;
lin anthracite_N = mkTerm "anthracite_N" ;
lin anthracitic_A = mkTerm "anthracitic_A" ;
lin anthracosis_N = mkTerm "anthracosis_N" ;
lin anthrax_N = mkTerm "anthrax_N" ;
lin anthropic_A = mkTerm "anthropic_A" ;
lin anthropocentric_A = mkTerm "anthropocentric_A" ;
lin anthropocentrism_N = mkTerm "anthropocentrism_N" ;
lin anthropogenesis_N = mkTerm "anthropogenesis_N" ;
lin anthropogenetic_A = mkTerm "anthropogenetic_A" ;
lin anthropoid_A = mkTerm "anthropoid_A" ;
lin anthropoid_N = mkTerm "anthropoid_N" ;
lin anthropolatry_N = mkTerm "anthropolatry_N" ;
lin anthropological_A = mkTerm "anthropological_A" ;
lin anthropologistFem_N = mkTerm "anthropologistFem_N" ;
lin anthropologistMasc_N = mkTerm "anthropologistMasc_N" ;
lin anthropology_N = mkTerm "anthropology_N" ;
lin anthropometric_A = mkTerm "anthropometric_A" ;
lin anthropometry_N = mkTerm "anthropometry_N" ;
lin anthropomorphic_A = mkTerm "anthropomorphic_A" ;
lin anthropomorphism_N = mkTerm "anthropomorphism_N" ;
lin anthropophagous_A = mkTerm "anthropophagous_A" ;
lin anthropophagy_N = mkTerm "anthropophagy_N" ;
lin anthroposophy_N = mkTerm "anthroposophy_N" ;
lin anthurium_N = mkTerm "anthurium_N" ;
lin anti_A = mkTerm "anti_A" ;
lin anti_N = mkTerm "anti_N" ;
lin anti_Prep = mkTerm "anti_Prep" ;
lin anti_aircraft_A = mkTerm "anti_aircraft_A" ;
lin anti_aircraft_N = mkTerm "anti_aircraft_N" ;
lin anti_hero_N = mkTerm "anti_hero_N" ;
lin anti_personnel_A = mkTerm "anti_personnel_A" ;
lin anti_semite_A = mkTerm "anti_semite_A" ;
lin anti_semite_N = mkTerm "anti_semite_N" ;
lin anti_semitic_A = mkTerm "anti_semitic_A" ;
lin anti_semitism_N = mkTerm "anti_semitism_N" ;
lin antiadrenergic_A = mkTerm "antiadrenergic_A" ;
lin antialiasing_N = mkTerm "antialiasing_N" ;
lin antiapartheid_A = mkTerm "antiapartheid_A" ;
lin antiarrhythmic_N = mkTerm "antiarrhythmic_N" ;
lin antiauthoritarian_A = mkTerm "antiauthoritarian_A" ;
lin antibacterial_A = mkTerm "antibacterial_A" ;
lin antibacterial_N = mkTerm "antibacterial_N" ;
lin antibaryon_N = mkTerm "antibaryon_N" ;
lin antibiosis_N = mkTerm "antibiosis_N" ;
lin antibiotic_A = mkTerm "antibiotic_A" ;
lin antibiotic_N = mkTerm "antibiotic_N" ;
lin antibody_N = mkTerm "antibody_N" ;
lin antic_A = mkTerm "antic_A" ;
lin antic_N = mkTerm "antic_N" ;
lin anticancer_A = mkTerm "anticancer_A" ;
lin anticatalyst_N = mkTerm "anticatalyst_N" ;
lin anticholinergic_A = mkTerm "anticholinergic_A" ;
lin anticholinergic_N = mkTerm "anticholinergic_N" ;
lin anticholinesterase_N = mkTerm "anticholinesterase_N" ;
lin anticipant_A = mkTerm "anticipant_A" ;
lin anticipate_V = mkTerm "anticipate_V" ;
lin anticipate_V2 = mkTerm "anticipate_V2" ;
lin anticipate_VS = mkTerm "anticipate_VS" ;
lin anticipate_VV = mkTerm "anticipate_VV" ;
lin anticipation_N = mkTerm "anticipation_N" ;
lin anticipator_N = mkTerm "anticipator_N" ;
lin anticipatory_A = mkTerm "anticipatory_A" ;
lin anticlimactic_A = mkTerm "anticlimactic_A" ;
lin anticlimax_N = mkTerm "anticlimax_N" ;
lin anticlinal_A = mkTerm "anticlinal_A" ;
lin anticlockwise_Adv = mkTerm "anticlockwise_Adv" ;
lin anticoagulant_N = mkTerm "anticoagulant_N" ;
lin anticoagulation_N = mkTerm "anticoagulation_N" ;
lin anticoagulative_A = mkTerm "anticoagulative_A" ;
lin anticonvulsant_N = mkTerm "anticonvulsant_N" ;
lin antics_N = mkTerm "antics_N" ;
lin anticyclone_N = mkTerm "anticyclone_N" ;
lin anticyclonic_A = mkTerm "anticyclonic_A" ;
lin antidepressant_N = mkTerm "antidepressant_N" ;
lin antidiabetic_N = mkTerm "antidiabetic_N" ;
lin antidiarrheal_N = mkTerm "antidiarrheal_N" ;
lin antidiuretic_N = mkTerm "antidiuretic_N" ;
lin antidotal_A = mkTerm "antidotal_A" ;
lin antidote_N = mkTerm "antidote_N" ;
lin antidromic_A = mkTerm "antidromic_A" ;
lin antiemetic_N = mkTerm "antiemetic_N" ;
lin antiestablishmentarianism_N = mkTerm "antiestablishmentarianism_N" ;
lin antifeminist_N = mkTerm "antifeminist_N" ;
lin antiferromagnetic_A = mkTerm "antiferromagnetic_A" ;
lin antiferromagnetism_N = mkTerm "antiferromagnetism_N" ;
lin antiflatulent_N = mkTerm "antiflatulent_N" ;
lin antifreeze_N = mkTerm "antifreeze_N" ;
lin antifungal_N = mkTerm "antifungal_N" ;
lin antigen_N = mkTerm "antigen_N" ;
lin antigenic_A = mkTerm "antigenic_A" ;
lin antigram_N = mkTerm "antigram_N" ;
lin antigua_PN = mkTerm "antigua_PN" ;
lin antiguan_A = mkTerm "antiguan_A" ;
lin antiguan_N = mkTerm "antiguan_N" ;
lin antiheretical_A = mkTerm "antiheretical_A" ;
lin antihistamine_N = mkTerm "antihistamine_N" ;
lin antihypertensive_N = mkTerm "antihypertensive_N" ;
lin antiknock_A = mkTerm "antiknock_A" ;
lin antiknock_N = mkTerm "antiknock_N" ;
lin antilepton_N = mkTerm "antilepton_N" ;
lin antilogarithm_N = mkTerm "antilogarithm_N" ;
lin antimacassar_N = mkTerm "antimacassar_N" ;
lin antimagnetic_A = mkTerm "antimagnetic_A" ;
lin antimalarial_N = mkTerm "antimalarial_N" ;
lin antimatter_N = mkTerm "antimatter_N" ;
lin antimeson_N = mkTerm "antimeson_N" ;
lin antimetabolite_N = mkTerm "antimetabolite_N" ;
lin antimicrobial_A = mkTerm "antimicrobial_A" ;
lin antimonial_A = mkTerm "antimonial_A" ;
lin antimonic_A = mkTerm "antimonic_A" ;
lin antimonopoly_A = mkTerm "antimonopoly_A" ;
lin antimony_N = mkTerm "antimony_N" ;
lin antimuon_N = mkTerm "antimuon_N" ;
lin antimycin_N = mkTerm "antimycin_N" ;
lin antineoplastic_N = mkTerm "antineoplastic_N" ;
lin antineutrino_N = mkTerm "antineutrino_N" ;
lin antineutron_N = mkTerm "antineutron_N" ;
lin antinode_N = mkTerm "antinode_N" ;
lin antinomasia_N = mkTerm "antinomasia_N" ;
lin antinomian_A = mkTerm "antinomian_A" ;
lin antinomian_N = mkTerm "antinomian_N" ;
lin antinomianism_N = mkTerm "antinomianism_N" ;
lin antinomy_N = mkTerm "antinomy_N" ;
lin antioxidant_N = mkTerm "antioxidant_N" ;
lin antiparallel_A = mkTerm "antiparallel_A" ;
lin antiparticle_N = mkTerm "antiparticle_N" ;
lin antipasto_N = mkTerm "antipasto_N" ;
lin antipathetic_A = mkTerm "antipathetic_A" ;
lin antipathy_N = mkTerm "antipathy_N" ;
lin antiperspirant_N = mkTerm "antiperspirant_N" ;
lin antiphlogistic_A = mkTerm "antiphlogistic_A" ;
lin antiphon_N = mkTerm "antiphon_N" ;
lin antiphonary_A = mkTerm "antiphonary_A" ;
lin antiphonary_N = mkTerm "antiphonary_N" ;
lin antiphony_N = mkTerm "antiphony_N" ;
lin antiphrasis_N = mkTerm "antiphrasis_N" ;
lin antipodal_A = mkTerm "antipodal_A" ;
lin antipodal_N = mkTerm "antipodal_N" ;
lin antipode_N = mkTerm "antipode_N" ;
lin antipodes_N = mkTerm "antipodes_N" ;
lin antipollution_A = mkTerm "antipollution_A" ;
lin antipope_N = mkTerm "antipope_N" ;
lin antiproton_N = mkTerm "antiproton_N" ;
lin antiprotozoal_N = mkTerm "antiprotozoal_N" ;
lin antipruritic_N = mkTerm "antipruritic_N" ;
lin antipyresis_N = mkTerm "antipyresis_N" ;
lin antipyretic_A = mkTerm "antipyretic_A" ;
lin antipyretic_N = mkTerm "antipyretic_N" ;
lin antiquarian_A = mkTerm "antiquarian_A" ;
lin antiquarian_N = mkTerm "antiquarian_N" ;
lin antiquark_N = mkTerm "antiquark_N" ;
lin antiquary_N = mkTerm "antiquary_N" ;
lin antiquated_A = mkTerm "antiquated_A" ;
lin antique_A = mkTerm "antique_A" ;
lin antique_N = mkTerm "antique_N" ;
lin antiquity_N = mkTerm "antiquity_N" ;
lin antiredeposition_N = mkTerm "antiredeposition_N" ;
lin antirrhinum_N = mkTerm "antirrhinum_N" ;
lin antisatellite_A = mkTerm "antisatellite_A" ;
lin antisepsis_N = mkTerm "antisepsis_N" ;
lin antiseptic_A = mkTerm "antiseptic_A" ;
lin antiseptic_N = mkTerm "antiseptic_N" ;
lin antiserum_N = mkTerm "antiserum_N" ;
lin antisocial_A = mkTerm "antisocial_A" ;
lin antispasmodic_N = mkTerm "antispasmodic_N" ;
lin antistrophe_N = mkTerm "antistrophe_N" ;
lin antistrophic_A = mkTerm "antistrophic_A" ;
lin antisubmarine_A = mkTerm "antisubmarine_A" ;
lin antisyphilitic_N = mkTerm "antisyphilitic_N" ;
lin antitank_A = mkTerm "antitank_A" ;
lin antitauon_N = mkTerm "antitauon_N" ;
lin antithesis_N = mkTerm "antithesis_N" ;
lin antithetic_A = mkTerm "antithetic_A" ;
lin antithetical_A = mkTerm "antithetical_A" ;
lin antithyroid_A = mkTerm "antithyroid_A" ;
lin antitoxic_A = mkTerm "antitoxic_A" ;
lin antitoxin_N = mkTerm "antitoxin_N" ;
lin antitrade_A = mkTerm "antitrade_A" ;
lin antitrade_N = mkTerm "antitrade_N" ;
lin antitrades_N = mkTerm "antitrades_N" ;
lin antitussive_N = mkTerm "antitussive_N" ;
lin antitype_N = mkTerm "antitype_N" ;
lin antitypic_A = mkTerm "antitypic_A" ;
lin antivenin_N = mkTerm "antivenin_N" ;
lin antiviral_A = mkTerm "antiviral_A" ;
lin antiviral_N = mkTerm "antiviral_N" ;
lin antler_N = mkTerm "antler_N" ;
lin antlered_A = mkTerm "antlered_A" ;
lin antony_PN = mkTerm "antony_PN" ;
lin antonym_N = mkTerm "antonym_N" ;
lin antonymous_A = mkTerm "antonymous_A" ;
lin antonymy_N = mkTerm "antonymy_N" ;
lin antrim_PN = mkTerm "antrim_PN" ;
lin antrorse_A = mkTerm "antrorse_A" ;
lin antrum_N = mkTerm "antrum_N" ;
lin antsy_A = mkTerm "antsy_A" ;
lin antwerp_PN = mkTerm "antwerp_PN" ;
lin anuran_A = mkTerm "anuran_A" ;
lin anuresis_N = mkTerm "anuresis_N" ;
lin anuretic_A = mkTerm "anuretic_A" ;
lin anurous_A = mkTerm "anurous_A" ;
lin anus_N = mkTerm "anus_N" ;
lin anvil_N = mkTerm "anvil_N" ;
lin anxiety_N = mkTerm "anxiety_N" ;
lin anxiolytic_A = mkTerm "anxiolytic_A" ;
lin anxious_A = mkTerm "anxious_A" ;
lin anxiousness_N = mkTerm "anxiousness_N" ;
lin anyPl_Det = mkTerm "anyPl_Det" ;
lin anySg_Det = mkTerm "anySg_Det" ;
lin any_Adv = mkTerm "any_Adv" ;
lin anybody_NP = mkTerm "anybody_NP" ;
lin anyhow_Adv = mkTerm "anyhow_Adv" ;
lin anymore_Adv = mkTerm "anymore_Adv" ;
lin anyone_NP = mkTerm "anyone_NP" ;
lin anyplace_Adv = mkTerm "anyplace_Adv" ;
lin anything_NP = mkTerm "anything_NP" ;
lin anyway_Adv = mkTerm "anyway_Adv" ;
lin anywhere_Adv = mkTerm "anywhere_Adv" ;
lin aorist_N = mkTerm "aorist_N" ;
lin aoristic_A = mkTerm "aoristic_A" ;
lin aorta_N = mkTerm "aorta_N" ;
lin aortal_A = mkTerm "aortal_A" ;
lin aortitis_N = mkTerm "aortitis_N" ;
lin aoudad_N = mkTerm "aoudad_N" ;
lin apace_Adv = mkTerm "apace_Adv" ;
lin apache_N = mkTerm "apache_N" ;
lin apadana_N = mkTerm "apadana_N" ;
lin apar_N = mkTerm "apar_N" ;
lin apart_Adv = mkTerm "apart_Adv" ;
lin apart_from_Prep = mkTerm "apart_from_Prep" ;
lin apartheid_N = mkTerm "apartheid_N" ;
lin apartment_N = mkTerm "apartment_N" ;
lin apathetic_A = mkTerm "apathetic_A" ;
lin apathy_N = mkTerm "apathy_N" ;
lin apatite_N = mkTerm "apatite_N" ;
lin apatosaur_N = mkTerm "apatosaur_N" ;
lin ape_N = mkTerm "ape_N" ;
lin ape_V2 = mkTerm "ape_V2" ;
lin apeldoorn_PN = mkTerm "apeldoorn_PN" ;
lin apercu_N = mkTerm "apercu_N" ;
lin aperea_N = mkTerm "aperea_N" ;
lin aperient_A = mkTerm "aperient_A" ;
lin aperient_N = mkTerm "aperient_N" ;
lin aperiodic_A = mkTerm "aperiodic_A" ;
lin aperitif_N = mkTerm "aperitif_N" ;
lin aperture_N = mkTerm "aperture_N" ;
lin apery_N = mkTerm "apery_N" ;
lin apetalous_A = mkTerm "apetalous_A" ;
lin apex_N = mkTerm "apex_N" ;
lin aphaeresis_N = mkTerm "aphaeresis_N" ;
lin aphaeretic_A = mkTerm "aphaeretic_A" ;
lin aphagia_N = mkTerm "aphagia_N" ;
lin aphakia_N = mkTerm "aphakia_N" ;
lin aphakic_A = mkTerm "aphakic_A" ;
lin aphakic_N = mkTerm "aphakic_N" ;
lin aphanite_N = mkTerm "aphanite_N" ;
lin aphanitic_A = mkTerm "aphanitic_A" ;
lin aphasia_N = mkTerm "aphasia_N" ;
lin aphasic_A = mkTerm "aphasic_A" ;
lin aphasic_N = mkTerm "aphasic_N" ;
lin aphelion_N = mkTerm "aphelion_N" ;
lin apheresis_N = mkTerm "apheresis_N" ;
lin aphesis_N = mkTerm "aphesis_N" ;
lin aphetic_A = mkTerm "aphetic_A" ;
lin aphid_N = mkTerm "aphid_N" ;
lin aphis_N = mkTerm "aphis_N" ;
lin aphonia_N = mkTerm "aphonia_N" ;
lin aphonic_A = mkTerm "aphonic_A" ;
lin aphorism_N = mkTerm "aphorism_N" ;
lin aphorist_N = mkTerm "aphorist_N" ;
lin aphoristic_A = mkTerm "aphoristic_A" ;
lin aphotic_A = mkTerm "aphotic_A" ;
lin aphrodisia_N = mkTerm "aphrodisia_N" ;
lin aphrodisiac_A = mkTerm "aphrodisiac_A" ;
lin aphrodisiac_N = mkTerm "aphrodisiac_N" ;
lin aphyllous_A = mkTerm "aphyllous_A" ;
lin apian_A = mkTerm "apian_A" ;
lin apiarian_A = mkTerm "apiarian_A" ;
lin apiarist_N = mkTerm "apiarist_N" ;
lin apiary_N = mkTerm "apiary_N" ;
lin apical_A = mkTerm "apical_A" ;
lin apiculate_A = mkTerm "apiculate_A" ;
lin apicultural_A = mkTerm "apicultural_A" ;
lin apiculture_N = mkTerm "apiculture_N" ;
lin apiece_Adv = mkTerm "apiece_Adv" ;
lin apish_A = mkTerm "apish_A" ;
lin apishamore_N = mkTerm "apishamore_N" ;
lin apivorous_A = mkTerm "apivorous_A" ;
lin aplacental_A = mkTerm "aplacental_A" ;
lin aplanatic_A = mkTerm "aplanatic_A" ;
lin aplasia_N = mkTerm "aplasia_N" ;
lin aplite_N = mkTerm "aplite_N" ;
lin aplitic_A = mkTerm "aplitic_A" ;
lin aplomb_N = mkTerm "aplomb_N" ;
lin apnea_N = mkTerm "apnea_N" ;
lin apneic_A = mkTerm "apneic_A" ;
lin apoapsis_N = mkTerm "apoapsis_N" ;
lin apocalypse_N = mkTerm "apocalypse_N" ;
lin apocalyptic_A = mkTerm "apocalyptic_A" ;
lin apocarpous_A = mkTerm "apocarpous_A" ;
lin apochromatic_A = mkTerm "apochromatic_A" ;
lin apocope_N = mkTerm "apocope_N" ;
lin apocrine_A = mkTerm "apocrine_A" ;
lin apocrypha_N = mkTerm "apocrypha_N" ;
lin apocryphal_A = mkTerm "apocryphal_A" ;
lin apocynaceous_A = mkTerm "apocynaceous_A" ;
lin apodal_A = mkTerm "apodal_A" ;
lin apodeme_N = mkTerm "apodeme_N" ;
lin apodictic_A = mkTerm "apodictic_A" ;
lin apoenzyme_N = mkTerm "apoenzyme_N" ;
lin apogamic_A = mkTerm "apogamic_A" ;
lin apogamy_N = mkTerm "apogamy_N" ;
lin apogean_A = mkTerm "apogean_A" ;
lin apogee_N = mkTerm "apogee_N" ;
lin apojove_N = mkTerm "apojove_N" ;
lin apolemia_N = mkTerm "apolemia_N" ;
lin apolitical_A = mkTerm "apolitical_A" ;
lin apologetic_A = mkTerm "apologetic_A" ;
lin apologetics_N = mkTerm "apologetics_N" ;
lin apologist_N = mkTerm "apologist_N" ;
lin apologize_V = mkTerm "apologize_V" ;
lin apology_N = mkTerm "apology_N" ;
lin apomict_N = mkTerm "apomict_N" ;
lin apomictic_A = mkTerm "apomictic_A" ;
lin apomixis_N = mkTerm "apomixis_N" ;
lin apomorphine_N = mkTerm "apomorphine_N" ;
lin aponeurosis_N = mkTerm "aponeurosis_N" ;
lin aponeurotic_A = mkTerm "aponeurotic_A" ;
lin apopemptic_A = mkTerm "apopemptic_A" ;
lin apophasis_N = mkTerm "apophasis_N" ;
lin apophatic_A = mkTerm "apophatic_A" ;
lin apophatism_N = mkTerm "apophatism_N" ;
lin apophthegm_N = mkTerm "apophthegm_N" ;
lin apophyseal_A = mkTerm "apophyseal_A" ;
lin apophysis_N = mkTerm "apophysis_N" ;
lin apoplectic_A = mkTerm "apoplectic_A" ;
lin apoplectiform_A = mkTerm "apoplectiform_A" ;
lin apoplexy_N = mkTerm "apoplexy_N" ;
lin apoptosis_N = mkTerm "apoptosis_N" ;
lin aposelene_N = mkTerm "aposelene_N" ;
lin aposiopesis_N = mkTerm "aposiopesis_N" ;
lin aposiopetic_A = mkTerm "aposiopetic_A" ;
lin apostasy_N = mkTerm "apostasy_N" ;
lin apostate_A = mkTerm "apostate_A" ;
lin apostate_N = mkTerm "apostate_N" ;
lin apostle_N = mkTerm "apostle_N" ;
lin apostleship_N = mkTerm "apostleship_N" ;
lin apostolic_A = mkTerm "apostolic_A" ;
lin apostrophe_N = mkTerm "apostrophe_N" ;
lin apostrophic_A = mkTerm "apostrophic_A" ;
lin apostrophize_V2 = mkTerm "apostrophize_V2" ;
lin apothecary_N = mkTerm "apothecary_N" ;
lin apothecial_A = mkTerm "apothecial_A" ;
lin apothecium_N = mkTerm "apothecium_N" ;
lin apothegm_N = mkTerm "apothegm_N" ;
lin apothegmatic_A = mkTerm "apothegmatic_A" ;
lin apotheosis_N = mkTerm "apotheosis_N" ;
lin apotropaic_A = mkTerm "apotropaic_A" ;
lin appal_V2 = mkTerm "appal_V2" ;
lin appalling_A = mkTerm "appalling_A" ;
lin appalling_N = mkTerm "appalling_N" ;
lin appanage_N = mkTerm "appanage_N" ;
lin apparatchik_N = mkTerm "apparatchik_N" ;
lin apparatus_N = mkTerm "apparatus_N" ;
lin apparel_N = mkTerm "apparel_N" ;
lin apparel_V2 = mkTerm "apparel_V2" ;
lin appareled_A = mkTerm "appareled_A" ;
lin apparent_A = mkTerm "apparent_A" ;
lin apparentness_N = mkTerm "apparentness_N" ;
lin apparition_N = mkTerm "apparition_N" ;
lin apparitional_A = mkTerm "apparitional_A" ;
lin appeal_N = mkTerm "appeal_N" ;
lin appeal_V = mkTerm "appeal_V" ;
lin appeal_V2 = mkTerm "appeal_V2" ;
lin appealable_A = mkTerm "appealable_A" ;
lin appealing_A = mkTerm "appealing_A" ;
lin appear_V = mkTerm "appear_V" ;
lin appear_VA = mkTerm "appear_VA" ;
lin appear_VS = mkTerm "appear_VS" ;
lin appear_VV = mkTerm "appear_VV" ;
lin appearance_N = mkTerm "appearance_N" ;
lin appeasable_A = mkTerm "appeasable_A" ;
lin appease_V2 = mkTerm "appease_V2" ;
lin appeasement_N = mkTerm "appeasement_N" ;
lin appeaser_N = mkTerm "appeaser_N" ;
lin appellant_A = mkTerm "appellant_A" ;
lin appellant_N = mkTerm "appellant_N" ;
lin appellate_A = mkTerm "appellate_A" ;
lin appellation_N = mkTerm "appellation_N" ;
lin appellative_A = mkTerm "appellative_A" ;
lin append_V2 = mkTerm "append_V2" ;
lin appendage_N = mkTerm "appendage_N" ;
lin appendaged_A = mkTerm "appendaged_A" ;
lin appendant_A = mkTerm "appendant_A" ;
lin appendectomy_N = mkTerm "appendectomy_N" ;
lin appendicitis_N = mkTerm "appendicitis_N" ;
lin appendicle_N = mkTerm "appendicle_N" ;
lin appendicular_A = mkTerm "appendicular_A" ;
lin appendicularia_N = mkTerm "appendicularia_N" ;
lin appendix_N = mkTerm "appendix_N" ;
lin apperception_N = mkTerm "apperception_N" ;
lin apperceptive_A = mkTerm "apperceptive_A" ;
lin appertain_V = mkTerm "appertain_V" ;
lin appetent_A = mkTerm "appetent_A" ;
lin appetite_N = mkTerm "appetite_N" ;
lin appetitive_A = mkTerm "appetitive_A" ;
lin appetizer_N = mkTerm "appetizer_N" ;
lin appetizing_A = mkTerm "appetizing_A" ;
lin appetizingness_N = mkTerm "appetizingness_N" ;
lin applaud_V = mkTerm "applaud_V" ;
lin applaud_V2 = mkTerm "applaud_V2" ;
lin applaudable_A = mkTerm "applaudable_A" ;
lin applause_N = mkTerm "applause_N" ;
lin apple_N = mkTerm "apple_N" ;
lin applecart_N = mkTerm "applecart_N" ;
lin applejack_N = mkTerm "applejack_N" ;
lin applesauce_N = mkTerm "applesauce_N" ;
lin applet_N = mkTerm "applet_N" ;
lin applewood_N = mkTerm "applewood_N" ;
lin appliance_N = mkTerm "appliance_N" ;
lin applicability_N = mkTerm "applicability_N" ;
lin applicable_A = mkTerm "applicable_A" ;
lin applicant_N = mkTerm "applicant_N" ;
lin application_1_N = mkTerm "application_1_N" ;
lin application_2_N = mkTerm "application_2_N" ;
lin application_3_N = mkTerm "application_3_N" ;
lin applicative_A = mkTerm "applicative_A" ;
lin applicator_N = mkTerm "applicator_N" ;
lin applied_A = mkTerm "applied_A" ;
lin applique_N = mkTerm "applique_N" ;
lin applique_V2 = mkTerm "applique_V2" ;
lin apply_V = mkTerm "apply_V" ;
lin apply_V2 = mkTerm "apply_V2" ;
lin apply_V2V = mkTerm "apply_V2V" ;
lin apply_VV = mkTerm "apply_VV" ;
lin apply_for_V2 = mkTerm "apply_for_V2" ;
lin appoint_V2 = mkTerm "appoint_V2" ;
lin appoint_V2V = mkTerm "appoint_V2V" ;
lin appoint_V3 = mkTerm "appoint_V3" ;
lin appointed_A = mkTerm "appointed_A" ;
lin appointee_N = mkTerm "appointee_N" ;
lin appointive_A = mkTerm "appointive_A" ;
lin appointment_N = mkTerm "appointment_N" ;
lin apportion_V2 = mkTerm "apportion_V2" ;
lin apportionment_N = mkTerm "apportionment_N" ;
lin apposite_A = mkTerm "apposite_A" ;
lin apposition_N = mkTerm "apposition_N" ;
lin appositional_A = mkTerm "appositional_A" ;
lin appositively_Adv = mkTerm "appositively_Adv" ;
lin appraisal_N = mkTerm "appraisal_N" ;
lin appraise_V2 = mkTerm "appraise_V2" ;
lin appraiser_N = mkTerm "appraiser_N" ;
lin appreciable_A = mkTerm "appreciable_A" ;
lin appreciate_V = mkTerm "appreciate_V" ;
lin appreciate_V2 = mkTerm "appreciate_V2" ;
lin appreciation_N = mkTerm "appreciation_N" ;
lin appreciative_A = mkTerm "appreciative_A" ;
lin appreciator_N = mkTerm "appreciator_N" ;
lin apprehend_V2 = mkTerm "apprehend_V2" ;
lin apprehender_N = mkTerm "apprehender_N" ;
lin apprehensible_A = mkTerm "apprehensible_A" ;
lin apprehension_N = mkTerm "apprehension_N" ;
lin apprehensive_A = mkTerm "apprehensive_A" ;
lin apprentice_N = mkTerm "apprentice_N" ;
lin apprentice_V2 = mkTerm "apprentice_V2" ;
lin apprenticeship_N = mkTerm "apprenticeship_N" ;
lin appressed_A = mkTerm "appressed_A" ;
lin apprise_V2 = mkTerm "apprise_V2" ;
lin appro_N = mkTerm "appro_N" ;
lin approach_N = mkTerm "approach_N" ;
lin approach_V = mkTerm "approach_V" ;
lin approach_V2 = mkTerm "approach_V2" ;
lin approachability_N = mkTerm "approachability_N" ;
lin approachable_A = mkTerm "approachable_A" ;
lin approbation_N = mkTerm "approbation_N" ;
lin appropriable_A = mkTerm "appropriable_A" ;
lin appropriate_A = mkTerm "appropriate_A" ;
lin appropriate_V2 = mkTerm "appropriate_V2" ;
lin appropriateness_N = mkTerm "appropriateness_N" ;
lin appropriation_N = mkTerm "appropriation_N" ;
lin appropriative_A = mkTerm "appropriative_A" ;
lin appropriator_N = mkTerm "appropriator_N" ;
lin approval_N = mkTerm "approval_N" ;
lin approve_V = mkTerm "approve_V" ;
lin approve_V2 = mkTerm "approve_V2" ;
lin approved_A = mkTerm "approved_A" ;
lin approver_N = mkTerm "approver_N" ;
lin approvingly_Adv = mkTerm "approvingly_Adv" ;
lin approx_PN = mkTerm "approx_PN" ;
lin approximate_A = mkTerm "approximate_A" ;
lin approximate_V = mkTerm "approximate_V" ;
lin approximate_V2 = mkTerm "approximate_V2" ;
lin approximately_Adv = mkTerm "approximately_Adv" ;
lin approximation_N = mkTerm "approximation_N" ;
lin appurtenance_N = mkTerm "appurtenance_N" ;
lin apr_PN = mkTerm "apr_PN" ;
lin apractic_A = mkTerm "apractic_A" ;
lin apraxia_N = mkTerm "apraxia_N" ;
lin apres_ski_A = mkTerm "apres_ski_A" ;
lin apricot_N = mkTerm "apricot_N" ;
lin apron_N = mkTerm "apron_N" ;
lin apropos_A = mkTerm "apropos_A" ;
lin apropos_Adv = mkTerm "apropos_Adv" ;
lin apropos_Prep = mkTerm "apropos_Prep" ;
lin apse_N = mkTerm "apse_N" ;
lin apsidal_A = mkTerm "apsidal_A" ;
lin apt_A = mkTerm "apt_A" ;
lin apteral_A = mkTerm "apteral_A" ;
lin apterous_A = mkTerm "apterous_A" ;
lin aptitude_N = mkTerm "aptitude_N" ;
lin aptitudinal_A = mkTerm "aptitudinal_A" ;
lin aptness_N = mkTerm "aptness_N" ;
lin apud_Prep = mkTerm "apud_Prep" ;
lin aquaculture_N = mkTerm "aquaculture_N" ;
lin aqualung_N = mkTerm "aqualung_N" ;
lin aquamarine_N = mkTerm "aquamarine_N" ;
lin aquanaut_N = mkTerm "aquanaut_N" ;
lin aquaphobia_N = mkTerm "aquaphobia_N" ;
lin aquaplane_N = mkTerm "aquaplane_N" ;
lin aquaplane_V = mkTerm "aquaplane_V" ;
lin aquarium_N = mkTerm "aquarium_N" ;
lin aquarius_PN = mkTerm "aquarius_PN" ;
lin aquatic_A = mkTerm "aquatic_A" ;
lin aquatic_N = mkTerm "aquatic_N" ;
lin aquatint_N = mkTerm "aquatint_N" ;
lin aquavit_N = mkTerm "aquavit_N" ;
lin aqueduct_N = mkTerm "aqueduct_N" ;
lin aqueous_A = mkTerm "aqueous_A" ;
lin aquicultural_A = mkTerm "aquicultural_A" ;
lin aquifer_N = mkTerm "aquifer_N" ;
lin aquiferous_A = mkTerm "aquiferous_A" ;
lin aquiline_A = mkTerm "aquiline_A" ;
lin arab_A = mkTerm "arab_A" ;
lin arab_N = mkTerm "arab_N" ;
lin arabesque_N = mkTerm "arabesque_N" ;
lin arabianFem_N = mkTerm "arabianFem_N" ;
lin arabianMasc_N = mkTerm "arabianMasc_N" ;
lin arabian_A = mkTerm "arabian_A" ;
lin arabic_A = mkTerm "arabic_A" ;
lin arability_N = mkTerm "arability_N" ;
lin arabist_N = mkTerm "arabist_N" ;
lin arable_A = mkTerm "arable_A" ;
lin arachnid_N = mkTerm "arachnid_N" ;
lin arachnoid_A = mkTerm "arachnoid_A" ;
lin arachnoid_N = mkTerm "arachnoid_N" ;
lin arachnophobia_N = mkTerm "arachnophobia_N" ;
lin aragonite_N = mkTerm "aragonite_N" ;
lin aralia_N = mkTerm "aralia_N" ;
lin arame_N = mkTerm "arame_N" ;
lin araneidal_A = mkTerm "araneidal_A" ;
lin arariba_N = mkTerm "arariba_N" ;
lin araroba_N = mkTerm "araroba_N" ;
lin araucaria_N = mkTerm "araucaria_N" ;
lin arbiter_N = mkTerm "arbiter_N" ;
lin arbitrable_A = mkTerm "arbitrable_A" ;
lin arbitrage_N = mkTerm "arbitrage_N" ;
lin arbitrageur_N = mkTerm "arbitrageur_N" ;
lin arbitral_A = mkTerm "arbitral_A" ;
lin arbitrament_N = mkTerm "arbitrament_N" ;
lin arbitrary_A = mkTerm "arbitrary_A" ;
lin arbitrate_V = mkTerm "arbitrate_V" ;
lin arbitrate_V2 = mkTerm "arbitrate_V2" ;
lin arbitration_N = mkTerm "arbitration_N" ;
lin arbitrative_A = mkTerm "arbitrative_A" ;
lin arbitrator_N = mkTerm "arbitrator_N" ;
lin arbor_N = mkTerm "arbor_N" ;
lin arboraceous_A = mkTerm "arboraceous_A" ;
lin arboreal_A = mkTerm "arboreal_A" ;
lin arboretum_N = mkTerm "arboretum_N" ;
lin arborical_A = mkTerm "arborical_A" ;
lin arboriculture_N = mkTerm "arboriculture_N" ;
lin arborolatry_N = mkTerm "arborolatry_N" ;
lin arborvitae_N = mkTerm "arborvitae_N" ;
lin arbour_N = mkTerm "arbour_N" ;
lin arbovirus_N = mkTerm "arbovirus_N" ;
lin arbroath_PN = mkTerm "arbroath_PN" ;
lin arbutus_N = mkTerm "arbutus_N" ;
lin arc_N = mkTerm "arc_N" ;
lin arc_lamp_N = mkTerm "arc_lamp_N" ;
lin arc_light_N = mkTerm "arc_light_N" ;
lin arcade_N = mkTerm "arcade_N" ;
lin arcadian_A = mkTerm "arcadian_A" ;
lin arcadian_N = mkTerm "arcadian_N" ;
lin arcane_A = mkTerm "arcane_A" ;
lin arced_A = mkTerm "arced_A" ;
lin arcella_N = mkTerm "arcella_N" ;
lin arch_A = mkTerm "arch_A" ;
lin arch_N = mkTerm "arch_N" ;
lin arch_V = mkTerm "arch_V" ;
lin arch_V2 = mkTerm "arch_V2" ;
lin archaebacteria_N = mkTerm "archaebacteria_N" ;
lin archaeological_A = mkTerm "archaeological_A" ;
lin archaeologist_N = mkTerm "archaeologist_N" ;
lin archaeology_N = mkTerm "archaeology_N" ;
lin archaeopteryx_N = mkTerm "archaeopteryx_N" ;
lin archaeornis_N = mkTerm "archaeornis_N" ;
lin archaic_A = mkTerm "archaic_A" ;
lin archaism_N = mkTerm "archaism_N" ;
lin archaist_N = mkTerm "archaist_N" ;
lin archaistic_A = mkTerm "archaistic_A" ;
lin archangel_N = mkTerm "archangel_N" ;
lin archangelic_A = mkTerm "archangelic_A" ;
lin archbishop_N = mkTerm "archbishop_N" ;
lin archbishopric_N = mkTerm "archbishopric_N" ;
lin archdeacon_N = mkTerm "archdeacon_N" ;
lin archdeaconry_N = mkTerm "archdeaconry_N" ;
lin archdiocesan_A = mkTerm "archdiocesan_A" ;
lin archdiocese_N = mkTerm "archdiocese_N" ;
lin archducal_A = mkTerm "archducal_A" ;
lin archduchess_N = mkTerm "archduchess_N" ;
lin archduchy_N = mkTerm "archduchy_N" ;
lin archduke_N = mkTerm "archduke_N" ;
lin archean_A = mkTerm "archean_A" ;
lin archegonial_A = mkTerm "archegonial_A" ;
lin archegonium_N = mkTerm "archegonium_N" ;
lin archenteron_N = mkTerm "archenteron_N" ;
lin archeozoic_A = mkTerm "archeozoic_A" ;
lin archer_N = mkTerm "archer_N" ;
lin archerfish_N = mkTerm "archerfish_N" ;
lin archery_N = mkTerm "archery_N" ;
lin archespore_N = mkTerm "archespore_N" ;
lin archesporial_A = mkTerm "archesporial_A" ;
lin archetypal_A = mkTerm "archetypal_A" ;
lin archetype_N = mkTerm "archetype_N" ;
lin archiannelid_N = mkTerm "archiannelid_N" ;
lin archidiaconal_A = mkTerm "archidiaconal_A" ;
lin archidiaconate_N = mkTerm "archidiaconate_N" ;
lin archiepiscopal_A = mkTerm "archiepiscopal_A" ;
lin archil_N = mkTerm "archil_N" ;
lin archimandrite_N = mkTerm "archimandrite_N" ;
lin archine_N = mkTerm "archine_N" ;
lin archipallium_N = mkTerm "archipallium_N" ;
lin archipelagic_A = mkTerm "archipelagic_A" ;
lin archipelago_N = mkTerm "archipelago_N" ;
lin architectFem_N = mkTerm "architectFem_N" ;
lin architectMasc_N = mkTerm "architectMasc_N" ;
lin architectonics_N = mkTerm "architectonics_N" ;
lin architectural_A = mkTerm "architectural_A" ;
lin architecture_N = mkTerm "architecture_N" ;
lin architeuthis_N = mkTerm "architeuthis_N" ;
lin architrave_N = mkTerm "architrave_N" ;
lin archival_A = mkTerm "archival_A" ;
lin archive_N = mkTerm "archive_N" ;
lin archives_N = mkTerm "archives_N" ;
lin archivist_N = mkTerm "archivist_N" ;
lin archosaur_N = mkTerm "archosaur_N" ;
lin archosaurian_A = mkTerm "archosaurian_A" ;
lin archpriest_N = mkTerm "archpriest_N" ;
lin archway_N = mkTerm "archway_N" ;
lin arco_A = mkTerm "arco_A" ;
lin arctic_A = mkTerm "arctic_A" ;
lin arctic_N = mkTerm "arctic_N" ;
lin arctiid_N = mkTerm "arctiid_N" ;
lin arcus_N = mkTerm "arcus_N" ;
lin ardeb_N = mkTerm "ardeb_N" ;
lin ardent_A = mkTerm "ardent_A" ;
lin ardor_N = mkTerm "ardor_N" ;
lin ardour_N = mkTerm "ardour_N" ;
lin ardrossan_PN = mkTerm "ardrossan_PN" ;
lin arduous_A = mkTerm "arduous_A" ;
lin arduousness_N = mkTerm "arduousness_N" ;
lin are_N = mkTerm "are_N" ;
lin area_1_N = mkTerm "area_1_N" ;
lin area_2_N = mkTerm "area_2_N" ;
lin area_3_N = mkTerm "area_3_N" ;
lin area_4_N = mkTerm "area_4_N" ;
lin area_5_N = mkTerm "area_5_N" ;
lin area_6_N = mkTerm "area_6_N" ;
lin areal_A = mkTerm "areal_A" ;
lin areaway_N = mkTerm "areaway_N" ;
lin areca_N = mkTerm "areca_N" ;
lin areflexia_N = mkTerm "areflexia_N" ;
lin arena_N = mkTerm "arena_N" ;
lin arenaceous_A = mkTerm "arenaceous_A" ;
lin arenavirus_N = mkTerm "arenavirus_N" ;
lin arenicolous_A = mkTerm "arenicolous_A" ;
lin areola_N = mkTerm "areola_N" ;
lin areolar_A = mkTerm "areolar_A" ;
lin arete_N = mkTerm "arete_N" ;
lin arethusa_N = mkTerm "arethusa_N" ;
lin argali_N = mkTerm "argali_N" ;
lin argent_A = mkTerm "argent_A" ;
lin argent_N = mkTerm "argent_N" ;
lin argentic_A = mkTerm "argentic_A" ;
lin argentiferous_A = mkTerm "argentiferous_A" ;
lin argentina_PN = mkTerm "argentina_PN" ;
lin argentine_N = mkTerm "argentine_N" ;
lin argentine_PN = mkTerm "argentine_PN" ;
lin argentinian_A = mkTerm "argentinian_A" ;
lin argentinian_N = mkTerm "argentinian_N" ;
lin argentinosaur_N = mkTerm "argentinosaur_N" ;
lin argentite_N = mkTerm "argentite_N" ;
lin argentous_A = mkTerm "argentous_A" ;
lin argil_N = mkTerm "argil_N" ;
lin argillaceous_A = mkTerm "argillaceous_A" ;
lin argillite_N = mkTerm "argillite_N" ;
lin arginine_N = mkTerm "arginine_N" ;
lin argon_N = mkTerm "argon_N" ;
lin argonaut_N = mkTerm "argonaut_N" ;
lin argosy_N = mkTerm "argosy_N" ;
lin argot_N = mkTerm "argot_N" ;
lin arguable_A = mkTerm "arguable_A" ;
lin argue_V = mkTerm "argue_V" ;
lin argue_V2 = mkTerm "argue_V2" ;
lin argue_VS = mkTerm "argue_VS" ;
lin argue_down_V2 = mkTerm "argue_down_V2" ;
lin argue_out_V2 = mkTerm "argue_out_V2" ;
lin argument_N = mkTerm "argument_N" ;
lin argumentation_N = mkTerm "argumentation_N" ;
lin argumentative_A = mkTerm "argumentative_A" ;
lin argus_N = mkTerm "argus_N" ;
lin argus_eyed_A = mkTerm "argus_eyed_A" ;
lin argyle_N = mkTerm "argyle_N" ;
lin argyll_N = mkTerm "argyll_N" ;
lin argyrodite_N = mkTerm "argyrodite_N" ;
lin aria_N = mkTerm "aria_N" ;
lin arianist_N = mkTerm "arianist_N" ;
lin arid_A = mkTerm "arid_A" ;
lin aridity_N = mkTerm "aridity_N" ;
lin aries_PN = mkTerm "aries_PN" ;
lin arietta_N = mkTerm "arietta_N" ;
lin aright_Adv = mkTerm "aright_Adv" ;
lin aril_N = mkTerm "aril_N" ;
lin ariled_A = mkTerm "ariled_A" ;
lin ariose_A = mkTerm "ariose_A" ;
lin arioso_N = mkTerm "arioso_N" ;
lin arise_V = mkTerm "arise_V" ;
lin arista_N = mkTerm "arista_N" ;
lin aristocracy_N = mkTerm "aristocracy_N" ;
lin aristocrat_N = mkTerm "aristocrat_N" ;
lin aristocratic_A = mkTerm "aristocratic_A" ;
lin arithmancy_N = mkTerm "arithmancy_N" ;
lin arithmetic_N = mkTerm "arithmetic_N" ;
lin arithmetical_A = mkTerm "arithmetical_A" ;
lin arithmetician_N = mkTerm "arithmetician_N" ;
lin arity_N = mkTerm "arity_N" ;
lin arizona_PN = mkTerm "arizona_PN" ;
lin ark_N = mkTerm "ark_N" ;
lin arkansas_PN = mkTerm "arkansas_PN" ;
lin arm_1_N = mkTerm "arm_1_N" ;
lin arm_2_N = mkTerm "arm_2_N" ;
lin arm_V = mkTerm "arm_V" ;
lin arm_V2 = mkTerm "arm_V2" ;
lin arm_hole_N = mkTerm "arm_hole_N" ;
lin armada_N = mkTerm "armada_N" ;
lin armadale_PN = mkTerm "armadale_PN" ;
lin armadillo_N = mkTerm "armadillo_N" ;
lin armageddon_PN = mkTerm "armageddon_PN" ;
lin armagh_PN = mkTerm "armagh_PN" ;
lin armament_N = mkTerm "armament_N" ;
lin armamentarium_N = mkTerm "armamentarium_N" ;
lin armature_N = mkTerm "armature_N" ;
lin armband_N = mkTerm "armband_N" ;
lin armchair_N = mkTerm "armchair_N" ;
lin armed_A = mkTerm "armed_A" ;
lin armenian_N = mkTerm "armenian_N" ;
lin armet_N = mkTerm "armet_N" ;
lin armful_N = mkTerm "armful_N" ;
lin armiger_N = mkTerm "armiger_N" ;
lin armilla_N = mkTerm "armilla_N" ;
lin armillary_A = mkTerm "armillary_A" ;
lin arming_N = mkTerm "arming_N" ;
lin armistice_N = mkTerm "armistice_N" ;
lin armless_A = mkTerm "armless_A" ;
lin armlet_N = mkTerm "armlet_N" ;
lin armlike_A = mkTerm "armlike_A" ;
lin armoire_N = mkTerm "armoire_N" ;
lin armored_A = mkTerm "armored_A" ;
lin armorial_A = mkTerm "armorial_A" ;
lin armour_N = mkTerm "armour_N" ;
lin armour_plate_N = mkTerm "armour_plate_N" ;
lin armoured_A = mkTerm "armoured_A" ;
lin armourer_N = mkTerm "armourer_N" ;
lin armoury_N = mkTerm "armoury_N" ;
lin armpit_N = mkTerm "armpit_N" ;
lin armrest_N = mkTerm "armrest_N" ;
lin arms_race_N = mkTerm "arms_race_N" ;
lin arms_runner_N = mkTerm "arms_runner_N" ;
lin army_N = mkTerm "army_N" ;
lin armyworm_N = mkTerm "armyworm_N" ;
lin arnhem_PN = mkTerm "arnhem_PN" ;
lin arnica_N = mkTerm "arnica_N" ;
lin arnold_PN = mkTerm "arnold_PN" ;
lin aroid_A = mkTerm "aroid_A" ;
lin aroma_N = mkTerm "aroma_N" ;
lin aromatherapy_N = mkTerm "aromatherapy_N" ;
lin aromatic_A = mkTerm "aromatic_A" ;
lin arose_V2 = mkTerm "arose_V2" ;
lin around_AdN = mkTerm "around_AdN" ;
lin around_Adv = mkTerm "around_Adv" ;
lin around_Prep = mkTerm "around_Prep" ;
lin arousal_N = mkTerm "arousal_N" ;
lin arouse_V2 = mkTerm "arouse_V2" ;
lin arouse_V2V = mkTerm "arouse_V2V" ;
lin arpeggio_N = mkTerm "arpeggio_N" ;
lin arpent_N = mkTerm "arpent_N" ;
lin arquebus_N = mkTerm "arquebus_N" ;
lin arr_PN = mkTerm "arr_PN" ;
lin arrack_N = mkTerm "arrack_N" ;
lin arraign_V2 = mkTerm "arraign_V2" ;
lin arraignment_N = mkTerm "arraignment_N" ;
lin arrange_V = mkTerm "arrange_V" ;
lin arrange_V2 = mkTerm "arrange_V2" ;
lin arrangement_N = mkTerm "arrangement_N" ;
lin arranger_N = mkTerm "arranger_N" ;
lin arrant_A = mkTerm "arrant_A" ;
lin arras_N = mkTerm "arras_N" ;
lin array_N = mkTerm "array_N" ;
lin array_V2 = mkTerm "array_V2" ;
lin arrears_N = mkTerm "arrears_N" ;
lin arrest_N = mkTerm "arrest_N" ;
lin arrest_V2 = mkTerm "arrest_V2" ;
lin arrester_N = mkTerm "arrester_N" ;
lin arresting_A = mkTerm "arresting_A" ;
lin arrhythmic_A = mkTerm "arrhythmic_A" ;
lin arriere_pensee_N = mkTerm "arriere_pensee_N" ;
lin arrival_N = mkTerm "arrival_N" ;
lin arrive_V = mkTerm "arrive_V" ;
lin arroba_N = mkTerm "arroba_N" ;
lin arrogance_N = mkTerm "arrogance_N" ;
lin arrogant_A = mkTerm "arrogant_A" ;
lin arrogate_V2 = mkTerm "arrogate_V2" ;
lin arrogator_N = mkTerm "arrogator_N" ;
lin arrondissement_N = mkTerm "arrondissement_N" ;
lin arrow_N = mkTerm "arrow_N" ;
lin arrowhead_N = mkTerm "arrowhead_N" ;
lin arrowroot_N = mkTerm "arrowroot_N" ;
lin arrowsmith_N = mkTerm "arrowsmith_N" ;
lin arrowworm_N = mkTerm "arrowworm_N" ;
lin arroyo_N = mkTerm "arroyo_N" ;
lin arse_N = mkTerm "arse_N" ;
lin arsehole_N = mkTerm "arsehole_N" ;
lin arsenal_N = mkTerm "arsenal_N" ;
lin arsenate_N = mkTerm "arsenate_N" ;
lin arsenic_N = mkTerm "arsenic_N" ;
lin arsenical_A = mkTerm "arsenical_A" ;
lin arsenical_N = mkTerm "arsenical_N" ;
lin arsenide_N = mkTerm "arsenide_N" ;
lin arsenious_A = mkTerm "arsenious_A" ;
lin arsenopyrite_N = mkTerm "arsenopyrite_N" ;
lin arsine_N = mkTerm "arsine_N" ;
lin arson_N = mkTerm "arson_N" ;
lin arsonist_N = mkTerm "arsonist_N" ;
lin art_N = mkTerm "art_N" ;
lin art_PN = mkTerm "art_PN" ;
lin artefact_N = mkTerm "artefact_N" ;
lin artemisia_N = mkTerm "artemisia_N" ;
lin arterial_A = mkTerm "arterial_A" ;
lin arteriectasis_N = mkTerm "arteriectasis_N" ;
lin arteriogram_N = mkTerm "arteriogram_N" ;
lin arteriography_N = mkTerm "arteriography_N" ;
lin arteriolar_A = mkTerm "arteriolar_A" ;
lin arteriole_N = mkTerm "arteriole_N" ;
lin arteriolosclerosis_N = mkTerm "arteriolosclerosis_N" ;
lin arteriosclerosis_N = mkTerm "arteriosclerosis_N" ;
lin arteriosclerotic_A = mkTerm "arteriosclerotic_A" ;
lin arteriovenous_A = mkTerm "arteriovenous_A" ;
lin arteritis_N = mkTerm "arteritis_N" ;
lin artery_N = mkTerm "artery_N" ;
lin artesian_A = mkTerm "artesian_A" ;
lin artful_A = mkTerm "artful_A" ;
lin artfulness_N = mkTerm "artfulness_N" ;
lin arthralgia_N = mkTerm "arthralgia_N" ;
lin arthralgic_A = mkTerm "arthralgic_A" ;
lin arthritic_A = mkTerm "arthritic_A" ;
lin arthritic_N = mkTerm "arthritic_N" ;
lin arthritis_N = mkTerm "arthritis_N" ;
lin arthrocentesis_N = mkTerm "arthrocentesis_N" ;
lin arthrodesis_N = mkTerm "arthrodesis_N" ;
lin arthrogram_N = mkTerm "arthrogram_N" ;
lin arthrography_N = mkTerm "arthrography_N" ;
lin arthromere_N = mkTerm "arthromere_N" ;
lin arthromeric_A = mkTerm "arthromeric_A" ;
lin arthropathy_N = mkTerm "arthropathy_N" ;
lin arthroplasty_N = mkTerm "arthroplasty_N" ;
lin arthropod_N = mkTerm "arthropod_N" ;
lin arthropodal_A = mkTerm "arthropodal_A" ;
lin arthroscope_N = mkTerm "arthroscope_N" ;
lin arthroscopy_N = mkTerm "arthroscopy_N" ;
lin arthrospore_N = mkTerm "arthrospore_N" ;
lin arthrosporic_A = mkTerm "arthrosporic_A" ;
lin arthur_PN = mkTerm "arthur_PN" ;
lin artichoke_N = mkTerm "artichoke_N" ;
lin article_N = mkTerm "article_N" ;
lin article_V2 = mkTerm "article_V2" ;
lin articular_A = mkTerm "articular_A" ;
lin articulate_A = mkTerm "articulate_A" ;
lin articulate_V = mkTerm "articulate_V" ;
lin articulate_V2 = mkTerm "articulate_V2" ;
lin articulation_N = mkTerm "articulation_N" ;
lin articulator_N = mkTerm "articulator_N" ;
lin articulatory_A = mkTerm "articulatory_A" ;
lin artie_PN = mkTerm "artie_PN" ;
lin artifact_N = mkTerm "artifact_N" ;
lin artifactual_A = mkTerm "artifactual_A" ;
lin artifice_N = mkTerm "artifice_N" ;
lin artificer_N = mkTerm "artificer_N" ;
lin artificial_A = mkTerm "artificial_A" ;
lin artificiality_N = mkTerm "artificiality_N" ;
lin artillery_N = mkTerm "artillery_N" ;
lin artilleryman_N = mkTerm "artilleryman_N" ;
lin artiodactyl_A = mkTerm "artiodactyl_A" ;
lin artisan_N = mkTerm "artisan_N" ;
lin artist_N = mkTerm "artist_N" ;
lin artiste_N = mkTerm "artiste_N" ;
lin artistic_A = mkTerm "artistic_A" ;
lin artistry_N = mkTerm "artistry_N" ;
lin artjärvi_PN = mkTerm "artjärvi_PN" ;
lin artless_A = mkTerm "artless_A" ;
lin artlessness_N = mkTerm "artlessness_N" ;
lin artwork_N = mkTerm "artwork_N" ;
lin arty_A = mkTerm "arty_A" ;
lin arty_crafty_A = mkTerm "arty_crafty_A" ;
lin arum_N = mkTerm "arum_N" ;
lin arundinaceous_A = mkTerm "arundinaceous_A" ;
lin aryanFem_N = mkTerm "aryanFem_N" ;
lin aryanMasc_N = mkTerm "aryanMasc_N" ;
lin aryan_A = mkTerm "aryan_A" ;
lin arytenoid_N = mkTerm "arytenoid_N" ;
lin as_Prep = mkTerm "as_Prep" ;
lin as_Subj = mkTerm "as_Subj" ;
lin as_for_Prep = mkTerm "as_for_Prep" ;
lin as_long_as_Subj = mkTerm "as_long_as_Subj" ;
lin as_of_Prep = mkTerm "as_of_Prep" ;
lin as_opposed_to_Prep = mkTerm "as_opposed_to_Prep" ;
lin as_per_Prep = mkTerm "as_per_Prep" ;
lin as_regards_Prep = mkTerm "as_regards_Prep" ;
lin as_well_Adv = mkTerm "as_well_Adv" ;
lin as_well_as_Conj = mkTerm "as_well_as_Conj" ;
lin asafetida_N = mkTerm "asafetida_N" ;
lin asana_N = mkTerm "asana_N" ;
lin asap_PN = mkTerm "asap_PN" ;
lin asarabacca_N = mkTerm "asarabacca_N" ;
lin asbestos_N = mkTerm "asbestos_N" ;
lin asbestosis_N = mkTerm "asbestosis_N" ;
lin ascariasis_N = mkTerm "ascariasis_N" ;
lin ascend_V = mkTerm "ascend_V" ;
lin ascend_V2 = mkTerm "ascend_V2" ;
lin ascendable_A = mkTerm "ascendable_A" ;
lin ascendancy_N = mkTerm "ascendancy_N" ;
lin ascendant_A = mkTerm "ascendant_A" ;
lin ascendant_N = mkTerm "ascendant_N" ;
lin ascendency_N = mkTerm "ascendency_N" ;
lin ascendent_N = mkTerm "ascendent_N" ;
lin ascender_N = mkTerm "ascender_N" ;
lin ascension_N = mkTerm "ascension_N" ;
lin ascensional_A = mkTerm "ascensional_A" ;
lin ascent_N = mkTerm "ascent_N" ;
lin ascertain_V2 = mkTerm "ascertain_V2" ;
lin ascertainable_A = mkTerm "ascertainable_A" ;
lin ascetic_A = mkTerm "ascetic_A" ;
lin ascetic_N = mkTerm "ascetic_N" ;
lin asceticism_N = mkTerm "asceticism_N" ;
lin ascidian_N = mkTerm "ascidian_N" ;
lin ascites_N = mkTerm "ascites_N" ;
lin ascitic_A = mkTerm "ascitic_A" ;
lin asclepiad_N = mkTerm "asclepiad_N" ;
lin asclepiadaceous_A = mkTerm "asclepiadaceous_A" ;
lin ascocarp_N = mkTerm "ascocarp_N" ;
lin ascocarpous_A = mkTerm "ascocarpous_A" ;
lin ascolichen_N = mkTerm "ascolichen_N" ;
lin ascoma_N = mkTerm "ascoma_N" ;
lin ascomycete_N = mkTerm "ascomycete_N" ;
lin ascomycetous_A = mkTerm "ascomycetous_A" ;
lin ascorbic_A = mkTerm "ascorbic_A" ;
lin ascospore_N = mkTerm "ascospore_N" ;
lin ascosporic_A = mkTerm "ascosporic_A" ;
lin ascot_N = mkTerm "ascot_N" ;
lin ascot_PN = mkTerm "ascot_PN" ;
lin ascribable_A = mkTerm "ascribable_A" ;
lin ascribe_V2 = mkTerm "ascribe_V2" ;
lin ascription_N = mkTerm "ascription_N" ;
lin ascus_N = mkTerm "ascus_N" ;
lin asdic_N = mkTerm "asdic_N" ;
lin asepsis_N = mkTerm "asepsis_N" ;
lin aseptic_A = mkTerm "aseptic_A" ;
lin asexual_A = mkTerm "asexual_A" ;
lin asexuality_N = mkTerm "asexuality_N" ;
lin ash_N = mkTerm "ash_N" ;
lin ash_bin_N = mkTerm "ash_bin_N" ;
lin ash_can_N = mkTerm "ash_can_N" ;
lin ash_key_N = mkTerm "ash_key_N" ;
lin ash_pan_N = mkTerm "ash_pan_N" ;
lin ashamed_A = mkTerm "ashamed_A" ;
lin ashbourne_PN = mkTerm "ashbourne_PN" ;
lin ashby_PN = mkTerm "ashby_PN" ;
lin ashby_de_la_zouch_PN = mkTerm "ashby_de_la_zouch_PN" ;
lin ashby_woulds_PN = mkTerm "ashby_woulds_PN" ;
lin ashcake_N = mkTerm "ashcake_N" ;
lin ashen_A = mkTerm "ashen_A" ;
lin ashford_PN = mkTerm "ashford_PN" ;
lin ashington_PN = mkTerm "ashington_PN" ;
lin ashlar_N = mkTerm "ashlar_N" ;
lin ashore_Adv = mkTerm "ashore_Adv" ;
lin ashram_N = mkTerm "ashram_N" ;
lin ashton_in_makerfield_PN = mkTerm "ashton_in_makerfield_PN" ;
lin ashton_under_lyne_PN = mkTerm "ashton_under_lyne_PN" ;
lin ashtray_N = mkTerm "ashtray_N" ;
lin ashy_A = mkTerm "ashy_A" ;
lin asian_A = mkTerm "asian_A" ;
lin asian_N = mkTerm "asian_N" ;
lin asiatic_A = mkTerm "asiatic_A" ;
lin asiatic_N = mkTerm "asiatic_N" ;
lin aside_Adv = mkTerm "aside_Adv" ;
lin aside_N = mkTerm "aside_N" ;
lin aside_from_Prep = mkTerm "aside_from_Prep" ;
lin asikkala_PN = mkTerm "asikkala_PN" ;
lin asinine_A = mkTerm "asinine_A" ;
lin asininity_N = mkTerm "asininity_N" ;
lin ask_V = mkTerm "ask_V" ;
lin ask_V2 = mkTerm "ask_V2" ;
lin ask_V2V = mkTerm "ask_V2V" ;
lin ask_VQ = mkTerm "ask_VQ" ;
lin ask_about_V2 = mkTerm "ask_about_V2" ;
lin ask_after_V2 = mkTerm "ask_after_V2" ;
lin ask_around_V = mkTerm "ask_around_V" ;
lin ask_around_V2 = mkTerm "ask_around_V2" ;
lin ask_for_V2 = mkTerm "ask_for_V2" ;
lin ask_for_V3 = mkTerm "ask_for_V3" ;
lin ask_in_V2 = mkTerm "ask_in_V2" ;
lin ask_out_V2 = mkTerm "ask_out_V2" ;
lin ask_over_V2 = mkTerm "ask_over_V2" ;
lin ask_round_V2 = mkTerm "ask_round_V2" ;
lin askainen_PN = mkTerm "askainen_PN" ;
lin askance_A = mkTerm "askance_A" ;
lin askance_Adv = mkTerm "askance_Adv" ;
lin askern_PN = mkTerm "askern_PN" ;
lin askew_A = mkTerm "askew_A" ;
lin askew_Adv = mkTerm "askew_Adv" ;
lin asking_N = mkTerm "asking_N" ;
lin askola_PN = mkTerm "askola_PN" ;
lin aslant_A = mkTerm "aslant_A" ;
lin aslant_Adv = mkTerm "aslant_Adv" ;
lin asleep_A = mkTerm "asleep_A" ;
lin asleep_Adv = mkTerm "asleep_Adv" ;
lin asocial_A = mkTerm "asocial_A" ;
lin asp_N = mkTerm "asp_N" ;
lin asparaginase_N = mkTerm "asparaginase_N" ;
lin asparagine_N = mkTerm "asparagine_N" ;
lin asparagus_N = mkTerm "asparagus_N" ;
lin aspartame_N = mkTerm "aspartame_N" ;
lin aspect_N = mkTerm "aspect_N" ;
lin aspectual_A = mkTerm "aspectual_A" ;
lin aspen_N = mkTerm "aspen_N" ;
lin asper_N = mkTerm "asper_N" ;
lin aspergill_N = mkTerm "aspergill_N" ;
lin aspergillosis_N = mkTerm "aspergillosis_N" ;
lin asperity_N = mkTerm "asperity_N" ;
lin asperse_V2 = mkTerm "asperse_V2" ;
lin aspersion_N = mkTerm "aspersion_N" ;
lin aspersorium_N = mkTerm "aspersorium_N" ;
lin asphalt_N = mkTerm "asphalt_N" ;
lin asphalt_V2 = mkTerm "asphalt_V2" ;
lin asphaltic_A = mkTerm "asphaltic_A" ;
lin aspheric_A = mkTerm "aspheric_A" ;
lin asphodel_N = mkTerm "asphodel_N" ;
lin asphyxia_N = mkTerm "asphyxia_N" ;
lin asphyxiate_V2 = mkTerm "asphyxiate_V2" ;
lin asphyxiating_A = mkTerm "asphyxiating_A" ;
lin asphyxiation_N = mkTerm "asphyxiation_N" ;
lin aspic_N = mkTerm "aspic_N" ;
lin aspidistra_N = mkTerm "aspidistra_N" ;
lin aspirant_A = mkTerm "aspirant_A" ;
lin aspirant_N = mkTerm "aspirant_N" ;
lin aspirate_N = mkTerm "aspirate_N" ;
lin aspirate_V2 = mkTerm "aspirate_V2" ;
lin aspiration_N = mkTerm "aspiration_N" ;
lin aspirator_N = mkTerm "aspirator_N" ;
lin aspire_V = mkTerm "aspire_V" ;
lin aspire_VV = mkTerm "aspire_VV" ;
lin aspirin_N = mkTerm "aspirin_N" ;
lin aspull_PN = mkTerm "aspull_PN" ;
lin ass_N = mkTerm "ass_N" ;
lin assagai_N = mkTerm "assagai_N" ;
lin assail_V2 = mkTerm "assail_V2" ;
lin assailability_N = mkTerm "assailability_N" ;
lin assailable_A = mkTerm "assailable_A" ;
lin assailant_N = mkTerm "assailant_N" ;
lin assassin_N = mkTerm "assassin_N" ;
lin assassinate_V2 = mkTerm "assassinate_V2" ;
lin assassination_N = mkTerm "assassination_N" ;
lin assault_N = mkTerm "assault_N" ;
lin assault_V2 = mkTerm "assault_V2" ;
lin assaultive_A = mkTerm "assaultive_A" ;
lin assay_N = mkTerm "assay_N" ;
lin assay_V2 = mkTerm "assay_V2" ;
lin assayer_N = mkTerm "assayer_N" ;
lin assegai_N = mkTerm "assegai_N" ;
lin assemblage_N = mkTerm "assemblage_N" ;
lin assemble_V = mkTerm "assemble_V" ;
lin assemble_V2 = mkTerm "assemble_V2" ;
lin assembler_N = mkTerm "assembler_N" ;
lin assembly_N = mkTerm "assembly_N" ;
lin assemblyman_N = mkTerm "assemblyman_N" ;
lin assemblywoman_N = mkTerm "assemblywoman_N" ;
lin assent_N = mkTerm "assent_N" ;
lin assent_V = mkTerm "assent_V" ;
lin assenter_N = mkTerm "assenter_N" ;
lin assentient_A = mkTerm "assentient_A" ;
lin assert_V = mkTerm "assert_V" ;
lin assert_V2 = mkTerm "assert_V2" ;
lin assert_VS = mkTerm "assert_VS" ;
lin asserter_N = mkTerm "asserter_N" ;
lin assertion_N = mkTerm "assertion_N" ;
lin assertive_A = mkTerm "assertive_A" ;
lin assertiveness_N = mkTerm "assertiveness_N" ;
lin assess_V2 = mkTerm "assess_V2" ;
lin assessable_A = mkTerm "assessable_A" ;
lin assessee_N = mkTerm "assessee_N" ;
lin assessment_N = mkTerm "assessment_N" ;
lin assessor_N = mkTerm "assessor_N" ;
lin asset_N = mkTerm "asset_N" ;
lin assets_N = mkTerm "assets_N" ;
lin asseverate_V2 = mkTerm "asseverate_V2" ;
lin asseveration_N = mkTerm "asseveration_N" ;
lin asshole_N = mkTerm "asshole_N" ;
lin assibilation_N = mkTerm "assibilation_N" ;
lin assiduity_N = mkTerm "assiduity_N" ;
lin assiduous_A = mkTerm "assiduous_A" ;
lin assign_V2 = mkTerm "assign_V2" ;
lin assign_V2V = mkTerm "assign_V2V" ;
lin assignable_A = mkTerm "assignable_A" ;
lin assignation_N = mkTerm "assignation_N" ;
lin assignee_N = mkTerm "assignee_N" ;
lin assignment_N = mkTerm "assignment_N" ;
lin assignor_N = mkTerm "assignor_N" ;
lin assimilable_A = mkTerm "assimilable_A" ;
lin assimilate_V = mkTerm "assimilate_V" ;
lin assimilate_V2 = mkTerm "assimilate_V2" ;
lin assimilation_N = mkTerm "assimilation_N" ;
lin assimilative_A = mkTerm "assimilative_A" ;
lin assist_N = mkTerm "assist_N" ;
lin assist_V = mkTerm "assist_V" ;
lin assist_V2 = mkTerm "assist_V2" ;
lin assistance_N = mkTerm "assistance_N" ;
lin assistantFem_N = mkTerm "assistantFem_N" ;
lin assistantMasc_N = mkTerm "assistantMasc_N" ;
lin assistant_A = mkTerm "assistant_A" ;
lin assistive_A = mkTerm "assistive_A" ;
lin assize_N = mkTerm "assize_N" ;
lin assizes_N = mkTerm "assizes_N" ;
lin assoc_N = mkTerm "assoc_N" ;
lin associability_N = mkTerm "associability_N" ;
lin associable_A = mkTerm "associable_A" ;
lin associate_A = mkTerm "associate_A" ;
lin associate_N = mkTerm "associate_N" ;
lin associate_V = mkTerm "associate_V" ;
lin associate_V2 = mkTerm "associate_V2" ;
lin associated_A = mkTerm "associated_A" ;
lin associateship_N = mkTerm "associateship_N" ;
lin association_N = mkTerm "association_N" ;
lin associational_A = mkTerm "associational_A" ;
lin associationism_N = mkTerm "associationism_N" ;
lin associative_A = mkTerm "associative_A" ;
lin assonance_N = mkTerm "assonance_N" ;
lin assonant_A = mkTerm "assonant_A" ;
lin assorted_A = mkTerm "assorted_A" ;
lin assortment_N = mkTerm "assortment_N" ;
lin asst_N = mkTerm "asst_N" ;
lin assuage_V2 = mkTerm "assuage_V2" ;
lin assuasive_A = mkTerm "assuasive_A" ;
lin assume_V2 = mkTerm "assume_V2" ;
lin assume_VS = mkTerm "assume_VS" ;
lin assumption_N = mkTerm "assumption_N" ;
lin assumptive_A = mkTerm "assumptive_A" ;
lin assurance_N = mkTerm "assurance_N" ;
lin assure_V2 = mkTerm "assure_V2" ;
lin assure_V2S = mkTerm "assure_V2S" ;
lin assuredly_Adv = mkTerm "assuredly_Adv" ;
lin assuredness_N = mkTerm "assuredness_N" ;
lin assurgent_A = mkTerm "assurgent_A" ;
lin assuring_A = mkTerm "assuring_A" ;
lin astasia_N = mkTerm "astasia_N" ;
lin astatic_A = mkTerm "astatic_A" ;
lin astatine_N = mkTerm "astatine_N" ;
lin aster_N = mkTerm "aster_N" ;
lin astereognosis_N = mkTerm "astereognosis_N" ;
lin asteriated_A = mkTerm "asteriated_A" ;
lin asterion_N = mkTerm "asterion_N" ;
lin asterisk_N = mkTerm "asterisk_N" ;
lin asterisked_A = mkTerm "asterisked_A" ;
lin asterism_N = mkTerm "asterism_N" ;
lin asterismal_A = mkTerm "asterismal_A" ;
lin astern_Adv = mkTerm "astern_Adv" ;
lin asternal_A = mkTerm "asternal_A" ;
lin asteroid_A = mkTerm "asteroid_A" ;
lin asteroid_N = mkTerm "asteroid_N" ;
lin asteroidal_A = mkTerm "asteroidal_A" ;
lin asthenia_N = mkTerm "asthenia_N" ;
lin asthenic_A = mkTerm "asthenic_A" ;
lin asthenosphere_N = mkTerm "asthenosphere_N" ;
lin asthma_N = mkTerm "asthma_N" ;
lin asthmatic_A = mkTerm "asthmatic_A" ;
lin asthmatic_N = mkTerm "asthmatic_N" ;
lin astigmatic_A = mkTerm "astigmatic_A" ;
lin astigmatism_N = mkTerm "astigmatism_N" ;
lin astilbe_N = mkTerm "astilbe_N" ;
lin astir_A = mkTerm "astir_A" ;
lin astir_Adv = mkTerm "astir_Adv" ;
lin astomatal_A = mkTerm "astomatal_A" ;
lin astomatous_A = mkTerm "astomatous_A" ;
lin aston_PN = mkTerm "aston_PN" ;
lin astonish_V2 = mkTerm "astonish_V2" ;
lin astonishing_A = mkTerm "astonishing_A" ;
lin astonishment_N = mkTerm "astonishment_N" ;
lin astound_V2 = mkTerm "astound_V2" ;
lin astounding_A = mkTerm "astounding_A" ;
lin astragalar_A = mkTerm "astragalar_A" ;
lin astrakhan_N = mkTerm "astrakhan_N" ;
lin astral_A = mkTerm "astral_A" ;
lin astrantia_N = mkTerm "astrantia_N" ;
lin astraphobia_N = mkTerm "astraphobia_N" ;
lin astray_A = mkTerm "astray_A" ;
lin astray_Adv = mkTerm "astray_Adv" ;
lin astride_A = mkTerm "astride_A" ;
lin astride_Adv = mkTerm "astride_Adv" ;
lin astride_Prep = mkTerm "astride_Prep" ;
lin astringency_N = mkTerm "astringency_N" ;
lin astringent_A = mkTerm "astringent_A" ;
lin astringent_N = mkTerm "astringent_N" ;
lin astrocyte_N = mkTerm "astrocyte_N" ;
lin astrocytic_A = mkTerm "astrocytic_A" ;
lin astrodome_N = mkTerm "astrodome_N" ;
lin astrodynamics_N = mkTerm "astrodynamics_N" ;
lin astrogator_N = mkTerm "astrogator_N" ;
lin astroglia_N = mkTerm "astroglia_N" ;
lin astrolabe_N = mkTerm "astrolabe_N" ;
lin astrolatry_N = mkTerm "astrolatry_N" ;
lin astrologer_N = mkTerm "astrologer_N" ;
lin astrological_A = mkTerm "astrological_A" ;
lin astrology_N = mkTerm "astrology_N" ;
lin astrometry_N = mkTerm "astrometry_N" ;
lin astronaut_N = mkTerm "astronaut_N" ;
lin astronautic_A = mkTerm "astronautic_A" ;
lin astronautics_N = mkTerm "astronautics_N" ;
lin astronomer_N = mkTerm "astronomer_N" ;
lin astronomic_A = mkTerm "astronomic_A" ;
lin astronomical_A = mkTerm "astronomical_A" ;
lin astronomy_N = mkTerm "astronomy_N" ;
lin astrophysical_A = mkTerm "astrophysical_A" ;
lin astrophysicist_N = mkTerm "astrophysicist_N" ;
lin astrophysics_N = mkTerm "astrophysics_N" ;
lin astute_A = mkTerm "astute_A" ;
lin astuteness_N = mkTerm "astuteness_N" ;
lin astylar_A = mkTerm "astylar_A" ;
lin asunder_Adv = mkTerm "asunder_Adv" ;
lin asylum_N = mkTerm "asylum_N" ;
lin asymmetric_A = mkTerm "asymmetric_A" ;
lin asymmetrical_A = mkTerm "asymmetrical_A" ;
lin asymmetry_N = mkTerm "asymmetry_N" ;
lin asymptomatic_A = mkTerm "asymptomatic_A" ;
lin asymptote_N = mkTerm "asymptote_N" ;
lin asymptotic_A = mkTerm "asymptotic_A" ;
lin asynchronism_N = mkTerm "asynchronism_N" ;
lin asynchronous_A = mkTerm "asynchronous_A" ;
lin asynclitism_N = mkTerm "asynclitism_N" ;
lin asyndetic_A = mkTerm "asyndetic_A" ;
lin asyndeton_N = mkTerm "asyndeton_N" ;
lin asynergic_A = mkTerm "asynergic_A" ;
lin asynergy_N = mkTerm "asynergy_N" ;
lin asystole_N = mkTerm "asystole_N" ;
lin at_N = mkTerm "at_N" ;
lin at_Prep = mkTerm "at_Prep" ;
lin at_all_Adv = mkTerm "at_all_Adv" ;
lin at_home_Adv = mkTerm "at_home_Adv" ;
lin at_home_N = mkTerm "at_home_N" ;
lin at_last_Adv = mkTerm "at_last_Adv" ;
lin at_long_last_Adv = mkTerm "at_long_last_Adv" ;
lin at_the_behest_of_Prep = mkTerm "at_the_behest_of_Prep" ;
lin at_times_Adv = mkTerm "at_times_Adv" ;
lin atabrine_N = mkTerm "atabrine_N" ;
lin ataractic_A = mkTerm "ataractic_A" ;
lin ataraxia_N = mkTerm "ataraxia_N" ;
lin atavism_N = mkTerm "atavism_N" ;
lin atavist_N = mkTerm "atavist_N" ;
lin atavistic_A = mkTerm "atavistic_A" ;
lin ataxia_N = mkTerm "ataxia_N" ;
lin ataxic_A = mkTerm "ataxic_A" ;
lin atelectasis_N = mkTerm "atelectasis_N" ;
lin ateleiosis_N = mkTerm "ateleiosis_N" ;
lin ateleiotic_A = mkTerm "ateleiotic_A" ;
lin atelier_N = mkTerm "atelier_N" ;
lin atenolol_N = mkTerm "atenolol_N" ;
lin athanor_N = mkTerm "athanor_N" ;
lin atheism_N = mkTerm "atheism_N" ;
lin atheist_A = mkTerm "atheist_A" ;
lin atheist_N = mkTerm "atheist_N" ;
lin atheistic_A = mkTerm "atheistic_A" ;
lin athenaeum_N = mkTerm "athenaeum_N" ;
lin athenianFem_N = mkTerm "athenianFem_N" ;
lin athenianMasc_N = mkTerm "athenianMasc_N" ;
lin athenian_A = mkTerm "athenian_A" ;
lin athens_1_PN = mkTerm "athens_1_PN" ;
lin athens_2_PN = mkTerm "athens_2_PN" ;
lin atherogenesis_N = mkTerm "atherogenesis_N" ;
lin atheroma_N = mkTerm "atheroma_N" ;
lin atheromatous_A = mkTerm "atheromatous_A" ;
lin atherosclerosis_N = mkTerm "atherosclerosis_N" ;
lin atherosclerotic_A = mkTerm "atherosclerotic_A" ;
lin atherstone_PN = mkTerm "atherstone_PN" ;
lin athetosis_N = mkTerm "athetosis_N" ;
lin athirst_A = mkTerm "athirst_A" ;
lin athlete_N = mkTerm "athlete_N" ;
lin athletic_A = mkTerm "athletic_A" ;
lin athleticism_N = mkTerm "athleticism_N" ;
lin athletics_N = mkTerm "athletics_N" ;
lin athlone_PN = mkTerm "athlone_PN" ;
lin athwart_Adv = mkTerm "athwart_Adv" ;
lin athwart_Prep = mkTerm "athwart_Prep" ;
lin atilt_A = mkTerm "atilt_A" ;
lin atlanta_PN = mkTerm "atlanta_PN" ;
lin atlantic_A = mkTerm "atlantic_A" ;
lin atlantic_PN = mkTerm "atlantic_PN" ;
lin atlas_N = mkTerm "atlas_N" ;
lin atmometer_N = mkTerm "atmometer_N" ;
lin atmosphere_N = mkTerm "atmosphere_N" ;
lin atmospheric_A = mkTerm "atmospheric_A" ;
lin atmospherics_N = mkTerm "atmospherics_N" ;
lin atole_N = mkTerm "atole_N" ;
lin atoll_N = mkTerm "atoll_N" ;
lin atom_N = mkTerm "atom_N" ;
lin atomic_A = mkTerm "atomic_A" ;
lin atomism_N = mkTerm "atomism_N" ;
lin atomistic_A = mkTerm "atomistic_A" ;
lin atomization_N = mkTerm "atomization_N" ;
lin atomize_V2 = mkTerm "atomize_V2" ;
lin atomizer_N = mkTerm "atomizer_N" ;
lin atonal_A = mkTerm "atonal_A" ;
lin atonalistic_A = mkTerm "atonalistic_A" ;
lin atonality_N = mkTerm "atonality_N" ;
lin atone_V = mkTerm "atone_V" ;
lin atonement_N = mkTerm "atonement_N" ;
lin atonic_A = mkTerm "atonic_A" ;
lin atonicity_N = mkTerm "atonicity_N" ;
lin atop_Adv = mkTerm "atop_Adv" ;
lin atop_Prep = mkTerm "atop_Prep" ;
lin atopognosia_N = mkTerm "atopognosia_N" ;
lin atorvastatin_N = mkTerm "atorvastatin_N" ;
lin atrabilious_A = mkTerm "atrabilious_A" ;
lin atrazine_N = mkTerm "atrazine_N" ;
lin atresia_N = mkTerm "atresia_N" ;
lin atrial_A = mkTerm "atrial_A" ;
lin atrioventricular_A = mkTerm "atrioventricular_A" ;
lin atrium_N = mkTerm "atrium_N" ;
lin atrocious_A = mkTerm "atrocious_A" ;
lin atrocity_N = mkTerm "atrocity_N" ;
lin atrophic_A = mkTerm "atrophic_A" ;
lin atrophy_N = mkTerm "atrophy_N" ;
lin atrophy_V = mkTerm "atrophy_V" ;
lin atrophy_V2 = mkTerm "atrophy_V2" ;
lin atropine_N = mkTerm "atropine_N" ;
lin attach_V = mkTerm "attach_V" ;
lin attach_V2 = mkTerm "attach_V2" ;
lin attachable_A = mkTerm "attachable_A" ;
lin attache_N = mkTerm "attache_N" ;
lin attachment_N = mkTerm "attachment_N" ;
lin attack_N = mkTerm "attack_N" ;
lin attack_V2 = mkTerm "attack_V2" ;
lin attacker_N = mkTerm "attacker_N" ;
lin attain_V = mkTerm "attain_V" ;
lin attain_V2 = mkTerm "attain_V2" ;
lin attainable_A = mkTerm "attainable_A" ;
lin attainder_N = mkTerm "attainder_N" ;
lin attainment_N = mkTerm "attainment_N" ;
lin attar_N = mkTerm "attar_N" ;
lin attempt_1_N = mkTerm "attempt_1_N" ;
lin attempt_2_N = mkTerm "attempt_2_N" ;
lin attempt_V2 = mkTerm "attempt_V2" ;
lin attempt_VV = mkTerm "attempt_VV" ;
lin attempted_A = mkTerm "attempted_A" ;
lin attend_V = mkTerm "attend_V" ;
lin attend_V2 = mkTerm "attend_V2" ;
lin attendance_N = mkTerm "attendance_N" ;
lin attendant_A = mkTerm "attendant_A" ;
lin attendant_N = mkTerm "attendant_N" ;
lin attention_N = mkTerm "attention_N" ;
lin attentional_A = mkTerm "attentional_A" ;
lin attentive_A = mkTerm "attentive_A" ;
lin attentiveness_N = mkTerm "attentiveness_N" ;
lin attenuate_A = mkTerm "attenuate_A" ;
lin attenuate_V2 = mkTerm "attenuate_V2" ;
lin attenuation_N = mkTerm "attenuation_N" ;
lin attenuator_N = mkTerm "attenuator_N" ;
lin attest_V = mkTerm "attest_V" ;
lin attest_V2 = mkTerm "attest_V2" ;
lin attest_VS = mkTerm "attest_VS" ;
lin attestation_N = mkTerm "attestation_N" ;
lin attester_N = mkTerm "attester_N" ;
lin attic_A = mkTerm "attic_A" ;
lin attic_N = mkTerm "attic_N" ;
lin attire_N = mkTerm "attire_N" ;
lin attire_V2 = mkTerm "attire_V2" ;
lin attitude_N = mkTerm "attitude_N" ;
lin attitudinal_A = mkTerm "attitudinal_A" ;
lin attitudinize_V = mkTerm "attitudinize_V" ;
lin attorney_N = mkTerm "attorney_N" ;
lin attorneyship_N = mkTerm "attorneyship_N" ;
lin attosecond_N = mkTerm "attosecond_N" ;
lin attract_V2 = mkTerm "attract_V2" ;
lin attractable_A = mkTerm "attractable_A" ;
lin attraction_N = mkTerm "attraction_N" ;
lin attractive_A = mkTerm "attractive_A" ;
lin attractiveness_N = mkTerm "attractiveness_N" ;
lin attractor_N = mkTerm "attractor_N" ;
lin attributable_A = mkTerm "attributable_A" ;
lin attribute_N = mkTerm "attribute_N" ;
lin attribute_V2 = mkTerm "attribute_V2" ;
lin attribution_N = mkTerm "attribution_N" ;
lin attributive_A = mkTerm "attributive_A" ;
lin attrited_A = mkTerm "attrited_A" ;
lin attrition_N = mkTerm "attrition_N" ;
lin attritional_A = mkTerm "attritional_A" ;
lin attune_V2 = mkTerm "attune_V2" ;
lin atypical_A = mkTerm "atypical_A" ;
lin atypicality_N = mkTerm "atypicality_N" ;
lin au_fait_A = mkTerm "au_fait_A" ;
lin au_fond_Adv = mkTerm "au_fond_Adv" ;
lin au_pair_N = mkTerm "au_pair_N" ;
lin aubergine_N = mkTerm "aubergine_N" ;
lin aubrietia_N = mkTerm "aubrietia_N" ;
lin auburn_A = mkTerm "auburn_A" ;
lin auckland_PN = mkTerm "auckland_PN" ;
lin auction_N = mkTerm "auction_N" ;
lin auction_V2 = mkTerm "auction_V2" ;
lin auction_off_V2 = mkTerm "auction_off_V2" ;
lin auctioneer_N = mkTerm "auctioneer_N" ;
lin audacious_A = mkTerm "audacious_A" ;
lin audacity_N = mkTerm "audacity_N" ;
lin audibility_N = mkTerm "audibility_N" ;
lin audible_A = mkTerm "audible_A" ;
lin audible_N = mkTerm "audible_N" ;
lin audience_N = mkTerm "audience_N" ;
lin audile_N = mkTerm "audile_N" ;
lin audio_A = mkTerm "audio_A" ;
lin audio_N = mkTerm "audio_N" ;
lin audio_lingual_A = mkTerm "audio_lingual_A" ;
lin audiocassette_N = mkTerm "audiocassette_N" ;
lin audiogram_N = mkTerm "audiogram_N" ;
lin audiology_N = mkTerm "audiology_N" ;
lin audiometer_N = mkTerm "audiometer_N" ;
lin audiometric_A = mkTerm "audiometric_A" ;
lin audiometry_N = mkTerm "audiometry_N" ;
lin audiotape_N = mkTerm "audiotape_N" ;
lin audiovisual_A = mkTerm "audiovisual_A" ;
lin audiovisual_N = mkTerm "audiovisual_N" ;
lin audit_N = mkTerm "audit_N" ;
lin audit_V2 = mkTerm "audit_V2" ;
lin audition_N = mkTerm "audition_N" ;
lin audition_V = mkTerm "audition_V" ;
lin audition_V2 = mkTerm "audition_V2" ;
lin auditor_N = mkTerm "auditor_N" ;
lin auditorium_N = mkTerm "auditorium_N" ;
lin auditory_A = mkTerm "auditory_A" ;
lin audley_PN = mkTerm "audley_PN" ;
lin audrey_PN = mkTerm "audrey_PN" ;
lin aug_PN = mkTerm "aug_PN" ;
lin augend_N = mkTerm "augend_N" ;
lin auger_N = mkTerm "auger_N" ;
lin aught_N = mkTerm "aught_N" ;
lin augite_N = mkTerm "augite_N" ;
lin augitic_A = mkTerm "augitic_A" ;
lin augment_V = mkTerm "augment_V" ;
lin augment_V2 = mkTerm "augment_V2" ;
lin augmentation_N = mkTerm "augmentation_N" ;
lin augmentative_A = mkTerm "augmentative_A" ;
lin augsburg_PN = mkTerm "augsburg_PN" ;
lin augur_N = mkTerm "augur_N" ;
lin augur_V = mkTerm "augur_V" ;
lin augur_V2 = mkTerm "augur_V2" ;
lin augury_N = mkTerm "augury_N" ;
lin august_A = mkTerm "august_A" ;
lin augustan_A = mkTerm "augustan_A" ;
lin auk_N = mkTerm "auk_N" ;
lin auklet_N = mkTerm "auklet_N" ;
lin auld_A = mkTerm "auld_A" ;
lin auld_lang_syne_N = mkTerm "auld_lang_syne_N" ;
lin aunt_N = mkTerm "aunt_N" ;
lin auntie_N = mkTerm "auntie_N" ;
lin aunty_N = mkTerm "aunty_N" ;
lin aura_N = mkTerm "aura_N" ;
lin aura_PN = mkTerm "aura_PN" ;
lin aural_A = mkTerm "aural_A" ;
lin aureate_A = mkTerm "aureate_A" ;
lin aureole_N = mkTerm "aureole_N" ;
lin auricle_N = mkTerm "auricle_N" ;
lin auricula_N = mkTerm "auricula_N" ;
lin auricular_A = mkTerm "auricular_A" ;
lin auriculare_N = mkTerm "auriculare_N" ;
lin auriculate_A = mkTerm "auriculate_A" ;
lin auriferous_A = mkTerm "auriferous_A" ;
lin auriform_A = mkTerm "auriform_A" ;
lin aurochs_N = mkTerm "aurochs_N" ;
lin aurora_N = mkTerm "aurora_N" ;
lin auroral_A = mkTerm "auroral_A" ;
lin aurous_A = mkTerm "aurous_A" ;
lin auscultation_N = mkTerm "auscultation_N" ;
lin auscultatory_A = mkTerm "auscultatory_A" ;
lin auspice_N = mkTerm "auspice_N" ;
lin auspices_N = mkTerm "auspices_N" ;
lin auspicious_A = mkTerm "auspicious_A" ;
lin auspiciousness_N = mkTerm "auspiciousness_N" ;
lin aussie_N = mkTerm "aussie_N" ;
lin austenite_N = mkTerm "austenite_N" ;
lin austenitic_A = mkTerm "austenitic_A" ;
lin austere_A = mkTerm "austere_A" ;
lin austereness_N = mkTerm "austereness_N" ;
lin austerity_N = mkTerm "austerity_N" ;
lin austral_A = mkTerm "austral_A" ;
lin austral_N = mkTerm "austral_N" ;
lin australia_PN = mkTerm "australia_PN" ;
lin australianFem_N = mkTerm "australianFem_N" ;
lin australianMasc_N = mkTerm "australianMasc_N" ;
lin australian_A = mkTerm "australian_A" ;
lin australopithecine_A = mkTerm "australopithecine_A" ;
lin australopithecine_N = mkTerm "australopithecine_N" ;
lin austria_PN = mkTerm "austria_PN" ;
lin austrianFem_N = mkTerm "austrianFem_N" ;
lin austrianMasc_N = mkTerm "austrianMasc_N" ;
lin austrian_A = mkTerm "austrian_A" ;
lin autacoid_N = mkTerm "autacoid_N" ;
lin autacoidal_A = mkTerm "autacoidal_A" ;
lin autarchic_A = mkTerm "autarchic_A" ;
lin autarchy_N = mkTerm "autarchy_N" ;
lin autarkic_A = mkTerm "autarkic_A" ;
lin autarky_N = mkTerm "autarky_N" ;
lin auteur_N = mkTerm "auteur_N" ;
lin authentic_A = mkTerm "authentic_A" ;
lin authenticate_V2 = mkTerm "authenticate_V2" ;
lin authentication_N = mkTerm "authentication_N" ;
lin authenticity_N = mkTerm "authenticity_N" ;
lin author_N = mkTerm "author_N" ;
lin authore_V2 = mkTerm "authore_V2" ;
lin authoress_N = mkTerm "authoress_N" ;
lin authorial_A = mkTerm "authorial_A" ;
lin authoritarian_A = mkTerm "authoritarian_A" ;
lin authoritarian_N = mkTerm "authoritarian_N" ;
lin authoritarianism_N = mkTerm "authoritarianism_N" ;
lin authoritative_A = mkTerm "authoritative_A" ;
lin authority_1_N = mkTerm "authority_1_N" ;
lin authority_2_N = mkTerm "authority_2_N" ;
lin authorization_N = mkTerm "authorization_N" ;
lin authorize_V2 = mkTerm "authorize_V2" ;
lin authorize_V2V = mkTerm "authorize_V2V" ;
lin authorizer_N = mkTerm "authorizer_N" ;
lin authorship_N = mkTerm "authorship_N" ;
lin autism_N = mkTerm "autism_N" ;
lin autistic_A = mkTerm "autistic_A" ;
lin auto_N = mkTerm "auto_N" ;
lin auto_changer_N = mkTerm "auto_changer_N" ;
lin auto_da_fe_N = mkTerm "auto_da_fe_N" ;
lin autoantibody_N = mkTerm "autoantibody_N" ;
lin autobahn_N = mkTerm "autobahn_N" ;
lin autobiographer_N = mkTerm "autobiographer_N" ;
lin autobiographic_A = mkTerm "autobiographic_A" ;
lin autobiographical_A = mkTerm "autobiographical_A" ;
lin autobiography_N = mkTerm "autobiography_N" ;
lin autocatalysis_N = mkTerm "autocatalysis_N" ;
lin autocatalytic_A = mkTerm "autocatalytic_A" ;
lin autochthon_N = mkTerm "autochthon_N" ;
lin autochthonal_A = mkTerm "autochthonal_A" ;
lin autochthonous_A = mkTerm "autochthonous_A" ;
lin autoclave_N = mkTerm "autoclave_N" ;
lin autocracy_N = mkTerm "autocracy_N" ;
lin autocrat_N = mkTerm "autocrat_N" ;
lin autocratic_A = mkTerm "autocratic_A" ;
lin autodidact_N = mkTerm "autodidact_N" ;
lin autodidactic_A = mkTerm "autodidactic_A" ;
lin autoecious_A = mkTerm "autoecious_A" ;
lin autoerotic_A = mkTerm "autoerotic_A" ;
lin autoeroticism_N = mkTerm "autoeroticism_N" ;
lin autofluorescence_N = mkTerm "autofluorescence_N" ;
lin autofluorescent_A = mkTerm "autofluorescent_A" ;
lin autofocus_N = mkTerm "autofocus_N" ;
lin autogamous_A = mkTerm "autogamous_A" ;
lin autogamy_N = mkTerm "autogamy_N" ;
lin autogenetic_A = mkTerm "autogenetic_A" ;
lin autogenous_A = mkTerm "autogenous_A" ;
lin autogiro_N = mkTerm "autogiro_N" ;
lin autograft_N = mkTerm "autograft_N" ;
lin autograph_N = mkTerm "autograph_N" ;
lin autograph_V2 = mkTerm "autograph_V2" ;
lin autographic_A = mkTerm "autographic_A" ;
lin autogyro_N = mkTerm "autogyro_N" ;
lin autoicous_A = mkTerm "autoicous_A" ;
lin autoimmune_A = mkTerm "autoimmune_A" ;
lin autoimmunity_N = mkTerm "autoimmunity_N" ;
lin autoinjector_N = mkTerm "autoinjector_N" ;
lin autoloader_N = mkTerm "autoloader_N" ;
lin autologous_A = mkTerm "autologous_A" ;
lin autolysis_N = mkTerm "autolysis_N" ;
lin autolytic_A = mkTerm "autolytic_A" ;
lin automat_N = mkTerm "automat_N" ;
lin automate_V2 = mkTerm "automate_V2" ;
lin automated_A = mkTerm "automated_A" ;
lin automatic_A = mkTerm "automatic_A" ;
lin automatic_N = mkTerm "automatic_N" ;
lin automation_N = mkTerm "automation_N" ;
lin automatism_N = mkTerm "automatism_N" ;
lin automaton_N = mkTerm "automaton_N" ;
lin automobile_N = mkTerm "automobile_N" ;
lin automotive_A = mkTerm "automotive_A" ;
lin automysophobia_N = mkTerm "automysophobia_N" ;
lin autonomic_A = mkTerm "autonomic_A" ;
lin autonomous_A = mkTerm "autonomous_A" ;
lin autonomy_N = mkTerm "autonomy_N" ;
lin autophyte_N = mkTerm "autophyte_N" ;
lin autopilot_N = mkTerm "autopilot_N" ;
lin autoplastic_A = mkTerm "autoplastic_A" ;
lin autoplasty_N = mkTerm "autoplasty_N" ;
lin autopsy_N = mkTerm "autopsy_N" ;
lin autoradiograph_N = mkTerm "autoradiograph_N" ;
lin autoradiographic_A = mkTerm "autoradiographic_A" ;
lin autoradiography_N = mkTerm "autoradiography_N" ;
lin autoregulation_N = mkTerm "autoregulation_N" ;
lin autosemantic_A = mkTerm "autosemantic_A" ;
lin autosexing_N = mkTerm "autosexing_N" ;
lin autosomal_A = mkTerm "autosomal_A" ;
lin autosome_N = mkTerm "autosome_N" ;
lin autostrada_N = mkTerm "autostrada_N" ;
lin autosuggestion_N = mkTerm "autosuggestion_N" ;
lin autotelic_A = mkTerm "autotelic_A" ;
lin autotelism_N = mkTerm "autotelism_N" ;
lin autotomic_A = mkTerm "autotomic_A" ;
lin autotomy_N = mkTerm "autotomy_N" ;
lin autotrophic_A = mkTerm "autotrophic_A" ;
lin autotype_N = mkTerm "autotype_N" ;
lin autotypic_A = mkTerm "autotypic_A" ;
lin auttoinen_PN = mkTerm "auttoinen_PN" ;
lin autumn_N = mkTerm "autumn_N" ;
lin autumnal_A = mkTerm "autumnal_A" ;
lin auxesis_N = mkTerm "auxesis_N" ;
lin auxetic_A = mkTerm "auxetic_A" ;
lin auxiliary_A = mkTerm "auxiliary_A" ;
lin auxiliary_N = mkTerm "auxiliary_N" ;
lin auxin_N = mkTerm "auxin_N" ;
lin auxinic_A = mkTerm "auxinic_A" ;
lin avadavat_N = mkTerm "avadavat_N" ;
lin avail_N = mkTerm "avail_N" ;
lin avail_V = mkTerm "avail_V" ;
lin avail_V2 = mkTerm "avail_V2" ;
lin availability_N = mkTerm "availability_N" ;
lin available_A = mkTerm "available_A" ;
lin avalanche_N = mkTerm "avalanche_N" ;
lin avant_garde_N = mkTerm "avant_garde_N" ;
lin avaram_N = mkTerm "avaram_N" ;
lin avarice_N = mkTerm "avarice_N" ;
lin avaricious_A = mkTerm "avaricious_A" ;
lin avascular_A = mkTerm "avascular_A" ;
lin avatar_N = mkTerm "avatar_N" ;
lin ave_PN = mkTerm "ave_PN" ;
lin aveley_PN = mkTerm "aveley_PN" ;
lin avellan_A = mkTerm "avellan_A" ;
lin avenge_V2 = mkTerm "avenge_V2" ;
lin avenger_N = mkTerm "avenger_N" ;
lin avens_N = mkTerm "avens_N" ;
lin avenue_N = mkTerm "avenue_N" ;
lin aver_V2 = mkTerm "aver_V2" ;
lin average_A = mkTerm "average_A" ;
lin average_N = mkTerm "average_N" ;
lin average_V = mkTerm "average_V" ;
lin average_V2 = mkTerm "average_V2" ;
lin averageness_N = mkTerm "averageness_N" ;
lin averr_VS = mkTerm "averr_VS" ;
lin averse_A = mkTerm "averse_A" ;
lin aversion_N = mkTerm "aversion_N" ;
lin aversive_A = mkTerm "aversive_A" ;
lin avert_V2 = mkTerm "avert_V2" ;
lin averting_N = mkTerm "averting_N" ;
lin avian_A = mkTerm "avian_A" ;
lin aviary_N = mkTerm "aviary_N" ;
lin aviation_N = mkTerm "aviation_N" ;
lin aviatorFem_N = mkTerm "aviatorFem_N" ;
lin aviatorMasc_N = mkTerm "aviatorMasc_N" ;
lin aviatrix_N = mkTerm "aviatrix_N" ;
lin avid_A = mkTerm "avid_A" ;
lin avidity_N = mkTerm "avidity_N" ;
lin avifauna_N = mkTerm "avifauna_N" ;
lin avifaunal_A = mkTerm "avifaunal_A" ;
lin avignon_PN = mkTerm "avignon_PN" ;
lin avionic_A = mkTerm "avionic_A" ;
lin avionics_N = mkTerm "avionics_N" ;
lin avirulent_A = mkTerm "avirulent_A" ;
lin avitaminosis_N = mkTerm "avitaminosis_N" ;
lin avitaminotic_A = mkTerm "avitaminotic_A" ;
lin avo_N = mkTerm "avo_N" ;
lin avocado_A = mkTerm "avocado_A" ;
lin avocado_N = mkTerm "avocado_N" ;
lin avocation_N = mkTerm "avocation_N" ;
lin avocational_A = mkTerm "avocational_A" ;
lin avocet_N = mkTerm "avocet_N" ;
lin avoid_V2 = mkTerm "avoid_V2" ;
lin avoid_VV = mkTerm "avoid_VV" ;
lin avoidable_A = mkTerm "avoidable_A" ;
lin avoidance_N = mkTerm "avoidance_N" ;
lin avoirdupois_N = mkTerm "avoirdupois_N" ;
lin avon_PN = mkTerm "avon_PN" ;
lin avouch_V = mkTerm "avouch_V" ;
lin avouch_V2 = mkTerm "avouch_V2" ;
lin avow_V2 = mkTerm "avow_V2" ;
lin avowal_N = mkTerm "avowal_N" ;
lin avowedly_Adv = mkTerm "avowedly_Adv" ;
lin avower_N = mkTerm "avower_N" ;
lin avulsion_N = mkTerm "avulsion_N" ;
lin avuncular_A = mkTerm "avuncular_A" ;
lin await_V2 = mkTerm "await_V2" ;
lin awake_A = mkTerm "awake_A" ;
lin awake_V = mkTerm "awake_V" ;
lin awaken_V2 = mkTerm "awaken_V2" ;
lin awakening_N = mkTerm "awakening_N" ;
lin award_N = mkTerm "award_N" ;
lin award_V2 = mkTerm "award_V2" ;
lin award_V3 = mkTerm "award_V3" ;
lin aware_A = mkTerm "aware_A" ;
lin aware_of_A2 = mkTerm "aware_of_A2" ;
lin awareness_N = mkTerm "awareness_N" ;
lin awash_A = mkTerm "awash_A" ;
lin away_1_Adv = mkTerm "away_1_Adv" ;
lin away_2_Adv = mkTerm "away_2_Adv" ;
lin away_A = mkTerm "away_A" ;
lin awayness_N = mkTerm "awayness_N" ;
lin awe_N = mkTerm "awe_N" ;
lin awe_V2 = mkTerm "awe_V2" ;
lin awe_inspiring_A = mkTerm "awe_inspiring_A" ;
lin awe_stricken_A = mkTerm "awe_stricken_A" ;
lin awe_struck_A = mkTerm "awe_struck_A" ;
lin aweary_A = mkTerm "aweary_A" ;
lin aweigh_A = mkTerm "aweigh_A" ;
lin aweigh_Adv = mkTerm "aweigh_Adv" ;
lin aweless_A = mkTerm "aweless_A" ;
lin awesome_A = mkTerm "awesome_A" ;
lin awful_A = mkTerm "awful_A" ;
lin awfulness_N = mkTerm "awfulness_N" ;
lin awheel_A = mkTerm "awheel_A" ;
lin awhile_Adv = mkTerm "awhile_Adv" ;
lin awkward_A = mkTerm "awkward_A" ;
lin awkwardness_N = mkTerm "awkwardness_N" ;
lin awl_N = mkTerm "awl_N" ;
lin awlwort_N = mkTerm "awlwort_N" ;
lin awn_N = mkTerm "awn_N" ;
lin awned_A = mkTerm "awned_A" ;
lin awning_N = mkTerm "awning_N" ;
lin awninged_A = mkTerm "awninged_A" ;
lin awnless_A = mkTerm "awnless_A" ;
lin awol_PN = mkTerm "awol_PN" ;
lin awry_A = mkTerm "awry_A" ;
lin awry_Adv = mkTerm "awry_Adv" ;
lin ax_N = mkTerm "ax_N" ;
lin ax_V2 = mkTerm "ax_V2" ;
lin axe_N = mkTerm "axe_N" ;
lin axe_V2 = mkTerm "axe_V2" ;
lin axenic_A = mkTerm "axenic_A" ;
lin axial_A = mkTerm "axial_A" ;
lin axil_N = mkTerm "axil_N" ;
lin axile_A = mkTerm "axile_A" ;
lin axillary_A = mkTerm "axillary_A" ;
lin axiological_A = mkTerm "axiological_A" ;
lin axiology_N = mkTerm "axiology_N" ;
lin axiom_N = mkTerm "axiom_N" ;
lin axiomatic_A = mkTerm "axiomatic_A" ;
lin axis_N = mkTerm "axis_N" ;
lin axle_N = mkTerm "axle_N" ;
lin axletree_N = mkTerm "axletree_N" ;
lin axolemma_N = mkTerm "axolemma_N" ;
lin axolotl_N = mkTerm "axolotl_N" ;
lin axon_N = mkTerm "axon_N" ;
lin axonal_A = mkTerm "axonal_A" ;
lin axseed_N = mkTerm "axseed_N" ;
lin ay_Adv = mkTerm "ay_Adv" ;
lin ayah_N = mkTerm "ayah_N" ;
lin ayapana_N = mkTerm "ayapana_N" ;
lin ayatollah_N = mkTerm "ayatollah_N" ;
lin aycliffe_PN = mkTerm "aycliffe_PN" ;
lin aye_Adv = mkTerm "aye_Adv" ;
lin aye_Interj = mkTerm "aye_Interj" ;
lin ayin_N = mkTerm "ayin_N" ;
lin aylesbury_PN = mkTerm "aylesbury_PN" ;
lin aylesford_PN = mkTerm "aylesford_PN" ;
lin ayr_PN = mkTerm "ayr_PN" ;
lin ayran_N = mkTerm "ayran_N" ;
lin azadirachtin_N = mkTerm "azadirachtin_N" ;
lin azalea_N = mkTerm "azalea_N" ;
lin azathioprine_N = mkTerm "azathioprine_N" ;
lin azide_N = mkTerm "azide_N" ;
lin azido_A = mkTerm "azido_A" ;
lin azimuth_N = mkTerm "azimuth_N" ;
lin azimuthal_A = mkTerm "azimuthal_A" ;
lin azithromycin_N = mkTerm "azithromycin_N" ;
lin azo_A = mkTerm "azo_A" ;
lin azoic_A = mkTerm "azoic_A" ;
lin azonal_A = mkTerm "azonal_A" ;
lin azonic_A = mkTerm "azonic_A" ;
lin azote_N = mkTerm "azote_N" ;
lin azotemic_A = mkTerm "azotemic_A" ;
lin azotic_A = mkTerm "azotic_A" ;
lin azoturia_N = mkTerm "azoturia_N" ;
lin aztreonam_N = mkTerm "aztreonam_N" ;
lin azure_A = mkTerm "azure_A" ;
lin azure_N = mkTerm "azure_N" ;
lin azurite_N = mkTerm "azurite_N" ;
lin azygous_A = mkTerm "azygous_A" ;
lin azymia_N = mkTerm "azymia_N" ;
lin b_ed_N = mkTerm "b_ed_N" ;
lin ba_N = mkTerm "ba_N" ;
lin baa_N = mkTerm "baa_N" ;
lin baa_V = mkTerm "baa_V" ;
lin baa_lamb_N = mkTerm "baa_lamb_N" ;
lin baas_N = mkTerm "baas_N" ;
lin baba_N = mkTerm "baba_N" ;
lin babassu_N = mkTerm "babassu_N" ;
lin babbitting_N = mkTerm "babbitting_N" ;
lin babble_N = mkTerm "babble_N" ;
lin babble_V = mkTerm "babble_V" ;
lin babble_V2 = mkTerm "babble_V2" ;
lin babbler_N = mkTerm "babbler_N" ;
lin babe_N = mkTerm "babe_N" ;
lin babel_N = mkTerm "babel_N" ;
lin babelike_A = mkTerm "babelike_A" ;
lin babirusa_N = mkTerm "babirusa_N" ;
lin babka_N = mkTerm "babka_N" ;
lin baboo_N = mkTerm "baboo_N" ;
lin baboon_N = mkTerm "baboon_N" ;
lin baboonish_A = mkTerm "baboonish_A" ;
lin babs_PN = mkTerm "babs_PN" ;
lin babu_N = mkTerm "babu_N" ;
lin babushka_N = mkTerm "babushka_N" ;
lin baby_N = mkTerm "baby_N" ;
lin baby_V2 = mkTerm "baby_V2" ;
lin baby_faced_A = mkTerm "baby_faced_A" ;
lin baby_farmer_N = mkTerm "baby_farmer_N" ;
lin baby_minder_N = mkTerm "baby_minder_N" ;
lin baby_talk_N = mkTerm "baby_talk_N" ;
lin babyhood_N = mkTerm "babyhood_N" ;
lin babyish_A = mkTerm "babyish_A" ;
lin babysit_V = mkTerm "babysit_V" ;
lin babysitter_N = mkTerm "babysitter_N" ;
lin babysitting_N = mkTerm "babysitting_N" ;
lin baccalaureate_N = mkTerm "baccalaureate_N" ;
lin baccarat_N = mkTerm "baccarat_N" ;
lin baccate_A = mkTerm "baccate_A" ;
lin bacchanal_A = mkTerm "bacchanal_A" ;
lin bacchanal_N = mkTerm "bacchanal_N" ;
lin bacchanalian_A = mkTerm "bacchanalian_A" ;
lin bacchant_N = mkTerm "bacchant_N" ;
lin bacchante_N = mkTerm "bacchante_N" ;
lin bacchantic_A = mkTerm "bacchantic_A" ;
lin baccivorous_A = mkTerm "baccivorous_A" ;
lin baccy_N = mkTerm "baccy_N" ;
lin bachelor_N = mkTerm "bachelor_N" ;
lin bachelorhood_N = mkTerm "bachelorhood_N" ;
lin bacillar_A = mkTerm "bacillar_A" ;
lin bacillus_N = mkTerm "bacillus_N" ;
lin bacitracin_N = mkTerm "bacitracin_N" ;
lin back_A = mkTerm "back_A" ;
lin back_Adv = mkTerm "back_Adv" ;
lin back_N = mkTerm "back_N" ;
lin back_V = mkTerm "back_V" ;
lin back_away_V = mkTerm "back_away_V" ;
lin back_breaking_A = mkTerm "back_breaking_A" ;
lin back_down_N = mkTerm "back_down_N" ;
lin back_down_V = mkTerm "back_down_V" ;
lin back_formation_N = mkTerm "back_formation_N" ;
lin back_into_V3 = mkTerm "back_into_V3" ;
lin back_off_V = mkTerm "back_off_V" ;
lin back_out_V = mkTerm "back_out_V" ;
lin back_out_of_V2 = mkTerm "back_out_of_V2" ;
lin back_out_of_V3 = mkTerm "back_out_of_V3" ;
lin back_to_Prep = mkTerm "back_to_Prep" ;
lin back_up_1_V2 = mkTerm "back_up_1_V2" ;
lin back_up_2_V2 = mkTerm "back_up_2_V2" ;
lin back_up_N = mkTerm "back_up_N" ;
lin back_up_V = mkTerm "back_up_V" ;
lin backache_N = mkTerm "backache_N" ;
lin backband_N = mkTerm "backband_N" ;
lin backbeat_N = mkTerm "backbeat_N" ;
lin backbench_N = mkTerm "backbench_N" ;
lin backbencher_N = mkTerm "backbencher_N" ;
lin backbend_N = mkTerm "backbend_N" ;
lin backbite_V = mkTerm "backbite_V" ;
lin backbite_V2 = mkTerm "backbite_V2" ;
lin backbiter_N = mkTerm "backbiter_N" ;
lin backblast_N = mkTerm "backblast_N" ;
lin backboard_N = mkTerm "backboard_N" ;
lin backbone_N = mkTerm "backbone_N" ;
lin backchat_N = mkTerm "backchat_N" ;
lin backcloth_N = mkTerm "backcloth_N" ;
lin backdate_V2 = mkTerm "backdate_V2" ;
lin backdoor_N = mkTerm "backdoor_N" ;
lin backdrop_N = mkTerm "backdrop_N" ;
lin backerFem_N = mkTerm "backerFem_N" ;
lin backerMasc_N = mkTerm "backerMasc_N" ;
lin backfield_N = mkTerm "backfield_N" ;
lin backfire_N = mkTerm "backfire_N" ;
lin backfire_V = mkTerm "backfire_V" ;
lin backflow_N = mkTerm "backflow_N" ;
lin backgammon_N = mkTerm "backgammon_N" ;
lin background_N = mkTerm "background_N" ;
lin backgrounder_N = mkTerm "backgrounder_N" ;
lin backhand_A = mkTerm "backhand_A" ;
lin backhand_N = mkTerm "backhand_N" ;
lin backhanded_A = mkTerm "backhanded_A" ;
lin backhander_N = mkTerm "backhander_N" ;
lin backhoe_N = mkTerm "backhoe_N" ;
lin backing_N = mkTerm "backing_N" ;
lin backlash_N = mkTerm "backlash_N" ;
lin backless_A = mkTerm "backless_A" ;
lin backlighting_N = mkTerm "backlighting_N" ;
lin backlog_N = mkTerm "backlog_N" ;
lin backmost_A = mkTerm "backmost_A" ;
lin backpack_N = mkTerm "backpack_N" ;
lin backpacker_N = mkTerm "backpacker_N" ;
lin backpedal_V = mkTerm "backpedal_V" ;
lin backpedaling_V = mkTerm "backpedaling_V" ;
lin backplate_N = mkTerm "backplate_N" ;
lin backroom_N = mkTerm "backroom_N" ;
lin backsaw_N = mkTerm "backsaw_N" ;
lin backscratcher_N = mkTerm "backscratcher_N" ;
lin backseat_N = mkTerm "backseat_N" ;
lin backsheesh_N = mkTerm "backsheesh_N" ;
lin backside_N = mkTerm "backside_N" ;
lin backslapper_N = mkTerm "backslapper_N" ;
lin backslide_V = mkTerm "backslide_V" ;
lin backsliding_N = mkTerm "backsliding_N" ;
lin backspace_V = mkTerm "backspace_V" ;
lin backspin_N = mkTerm "backspin_N" ;
lin backstage_Adv = mkTerm "backstage_Adv" ;
lin backstair_A = mkTerm "backstair_A" ;
lin backstairs_N = mkTerm "backstairs_N" ;
lin backstay_N = mkTerm "backstay_N" ;
lin backstitch_N = mkTerm "backstitch_N" ;
lin backstop_N = mkTerm "backstop_N" ;
lin backstroke_N = mkTerm "backstroke_N" ;
lin backstroker_N = mkTerm "backstroker_N" ;
lin backswept_A = mkTerm "backswept_A" ;
lin backswimmer_N = mkTerm "backswimmer_N" ;
lin backsword_N = mkTerm "backsword_N" ;
lin backtalk_N = mkTerm "backtalk_N" ;
lin backward_A = mkTerm "backward_A" ;
lin backward_Adv = mkTerm "backward_Adv" ;
lin backwards_A = mkTerm "backwards_A" ;
lin backwards_Adv = mkTerm "backwards_Adv" ;
lin backwash_N = mkTerm "backwash_N" ;
lin backwater_N = mkTerm "backwater_N" ;
lin backwoods_N = mkTerm "backwoods_N" ;
lin backwoodsman_N = mkTerm "backwoodsman_N" ;
lin backworth_PN = mkTerm "backworth_PN" ;
lin backyard_N = mkTerm "backyard_N" ;
lin bacon_N = mkTerm "bacon_N" ;
lin bacteremia_N = mkTerm "bacteremia_N" ;
lin bacteremic_A = mkTerm "bacteremic_A" ;
lin bacteria_N = mkTerm "bacteria_N" ;
lin bacterial_A = mkTerm "bacterial_A" ;
lin bactericidal_A = mkTerm "bactericidal_A" ;
lin bactericide_N = mkTerm "bactericide_N" ;
lin bacteriochlorophyll_N = mkTerm "bacteriochlorophyll_N" ;
lin bacteriological_A = mkTerm "bacteriological_A" ;
lin bacteriologist_N = mkTerm "bacteriologist_N" ;
lin bacteriology_N = mkTerm "bacteriology_N" ;
lin bacteriolysis_N = mkTerm "bacteriolysis_N" ;
lin bacteriolytic_A = mkTerm "bacteriolytic_A" ;
lin bacteriophage_N = mkTerm "bacteriophage_N" ;
lin bacteriophagic_A = mkTerm "bacteriophagic_A" ;
lin bacteriostasis_N = mkTerm "bacteriostasis_N" ;
lin bacteriostat_N = mkTerm "bacteriostat_N" ;
lin bacteriostatic_A = mkTerm "bacteriostatic_A" ;
lin bacterium_N = mkTerm "bacterium_N" ;
lin bacteroid_N = mkTerm "bacteroid_N" ;
lin bacteroidal_A = mkTerm "bacteroidal_A" ;
lin bacup_PN = mkTerm "bacup_PN" ;
lin bad_A = mkTerm "bad_A" ;
lin bad_N = mkTerm "bad_N" ;
lin badajoz_PN = mkTerm "badajoz_PN" ;
lin badalona_PN = mkTerm "badalona_PN" ;
lin baddeleyite_N = mkTerm "baddeleyite_N" ;
lin badge_N = mkTerm "badge_N" ;
lin badger_N = mkTerm "badger_N" ;
lin badger_V2 = mkTerm "badger_V2" ;
lin badgering_N = mkTerm "badgering_N" ;
lin badinage_N = mkTerm "badinage_N" ;
lin badlands_N = mkTerm "badlands_N" ;
lin badly_behaved_A = mkTerm "badly_behaved_A" ;
lin badminton_N = mkTerm "badminton_N" ;
lin badness_N = mkTerm "badness_N" ;
lin baedeker_N = mkTerm "baedeker_N" ;
lin baffle_N = mkTerm "baffle_N" ;
lin baffle_V2 = mkTerm "baffle_V2" ;
lin baffled_N = mkTerm "baffled_N" ;
lin baffling_A = mkTerm "baffling_A" ;
lin bag_N = mkTerm "bag_N" ;
lin bag_V = mkTerm "bag_V" ;
lin bag_V2 = mkTerm "bag_V2" ;
lin bag_out_V2 = mkTerm "bag_out_V2" ;
lin bagasse_N = mkTerm "bagasse_N" ;
lin bagassosis_N = mkTerm "bagassosis_N" ;
lin bagatelle_N = mkTerm "bagatelle_N" ;
lin bagel_N = mkTerm "bagel_N" ;
lin baggage_N = mkTerm "baggage_N" ;
lin baggageman_N = mkTerm "baggageman_N" ;
lin bagger_N = mkTerm "bagger_N" ;
lin baggy_A = mkTerm "baggy_A" ;
lin baghdad_PN = mkTerm "baghdad_PN" ;
lin bagman_N = mkTerm "bagman_N" ;
lin bagnio_N = mkTerm "bagnio_N" ;
lin bagpipe_N = mkTerm "bagpipe_N" ;
lin baguet_N = mkTerm "baguet_N" ;
lin bahamas_PN = mkTerm "bahamas_PN" ;
lin bahamian_A = mkTerm "bahamian_A" ;
lin bahamian_N = mkTerm "bahamian_N" ;
lin bahasa_N = mkTerm "bahasa_N" ;
lin bahrain_PN = mkTerm "bahrain_PN" ;
lin bahraini_A = mkTerm "bahraini_A" ;
lin bahraini_N = mkTerm "bahraini_N" ;
lin baht_N = mkTerm "baht_N" ;
lin bail_N = mkTerm "bail_N" ;
lin bail_V = mkTerm "bail_V" ;
lin bail_V2 = mkTerm "bail_V2" ;
lin bail_out_V = mkTerm "bail_out_V" ;
lin bail_out_V2 = mkTerm "bail_out_V2" ;
lin bail_out_of_V3 = mkTerm "bail_out_of_V3" ;
lin bail_out_on_V2 = mkTerm "bail_out_on_V2" ;
lin bail_up_V = mkTerm "bail_up_V" ;
lin bailable_A = mkTerm "bailable_A" ;
lin bailee_N = mkTerm "bailee_N" ;
lin bailey_N = mkTerm "bailey_N" ;
lin bailey_PN = mkTerm "bailey_PN" ;
lin bailiff_N = mkTerm "bailiff_N" ;
lin bailiffship_N = mkTerm "bailiffship_N" ;
lin bailiwick_N = mkTerm "bailiwick_N" ;
lin bailment_N = mkTerm "bailment_N" ;
lin bailor_N = mkTerm "bailor_N" ;
lin bairn_N = mkTerm "bairn_N" ;
lin bait_N = mkTerm "bait_N" ;
lin bait_V = mkTerm "bait_V" ;
lin bait_V2 = mkTerm "bait_V2" ;
lin baiting_N = mkTerm "baiting_N" ;
lin baiza_N = mkTerm "baiza_N" ;
lin baize_N = mkTerm "baize_N" ;
lin bake_V = mkTerm "bake_V" ;
lin bake_V2 = mkTerm "bake_V2" ;
lin bakelite_N = mkTerm "bakelite_N" ;
lin baker_N = mkTerm "baker_N" ;
lin bakery_N = mkTerm "bakery_N" ;
lin baking_N = mkTerm "baking_N" ;
lin baking_hot_A = mkTerm "baking_hot_A" ;
lin baking_powder_N = mkTerm "baking_powder_N" ;
lin baklava_N = mkTerm "baklava_N" ;
lin baksheesh_N = mkTerm "baksheesh_N" ;
lin baku_PN = mkTerm "baku_PN" ;
lin balaclava_N = mkTerm "balaclava_N" ;
lin balagan_N = mkTerm "balagan_N" ;
lin balalaika_N = mkTerm "balalaika_N" ;
lin balance_N = mkTerm "balance_N" ;
lin balance_V = mkTerm "balance_V" ;
lin balance_V2 = mkTerm "balance_V2" ;
lin balance_sheet_N = mkTerm "balance_sheet_N" ;
lin balance_wheel_N = mkTerm "balance_wheel_N" ;
lin balanced_A = mkTerm "balanced_A" ;
lin balancer_N = mkTerm "balancer_N" ;
lin balanitis_N = mkTerm "balanitis_N" ;
lin balanoposthitis_N = mkTerm "balanoposthitis_N" ;
lin balas_N = mkTerm "balas_N" ;
lin balata_N = mkTerm "balata_N" ;
lin balboa_N = mkTerm "balboa_N" ;
lin balbriggan_N = mkTerm "balbriggan_N" ;
lin balconied_A = mkTerm "balconied_A" ;
lin balcony_N = mkTerm "balcony_N" ;
lin bald_A = mkTerm "bald_A" ;
lin bald_head_N = mkTerm "bald_head_N" ;
lin bald_pate_N = mkTerm "bald_pate_N" ;
lin baldachin_N = mkTerm "baldachin_N" ;
lin balderdash_N = mkTerm "balderdash_N" ;
lin balding_A = mkTerm "balding_A" ;
lin baldness_N = mkTerm "baldness_N" ;
lin baldock_PN = mkTerm "baldock_PN" ;
lin baldric_N = mkTerm "baldric_N" ;
lin bale_N = mkTerm "bale_N" ;
lin bale_V2 = mkTerm "bale_V2" ;
lin baleful_A = mkTerm "baleful_A" ;
lin balk_N = mkTerm "balk_N" ;
lin balk_V = mkTerm "balk_V" ;
lin balk_V2 = mkTerm "balk_V2" ;
lin balker_N = mkTerm "balker_N" ;
lin balkiness_N = mkTerm "balkiness_N" ;
lin balkline_N = mkTerm "balkline_N" ;
lin ball_N = mkTerm "ball_N" ;
lin ball_V = mkTerm "ball_V" ;
lin ball_V2 = mkTerm "ball_V2" ;
lin ball_cartridge_N = mkTerm "ball_cartridge_N" ;
lin ball_dress_N = mkTerm "ball_dress_N" ;
lin ball_up_V2 = mkTerm "ball_up_V2" ;
lin ballad_N = mkTerm "ballad_N" ;
lin ballade_N = mkTerm "ballade_N" ;
lin ballast_N = mkTerm "ballast_N" ;
lin ballast_V2 = mkTerm "ballast_V2" ;
lin ballbearing_N = mkTerm "ballbearing_N" ;
lin ballcock_N = mkTerm "ballcock_N" ;
lin ballerina_N = mkTerm "ballerina_N" ;
lin ballet_N = mkTerm "ballet_N" ;
lin ballet_dancer_N = mkTerm "ballet_dancer_N" ;
lin ballet_skirt_N = mkTerm "ballet_skirt_N" ;
lin balletic_A = mkTerm "balletic_A" ;
lin balletomane_N = mkTerm "balletomane_N" ;
lin balletomania_N = mkTerm "balletomania_N" ;
lin ballgame_N = mkTerm "ballgame_N" ;
lin ballistic_A = mkTerm "ballistic_A" ;
lin ballistics_N = mkTerm "ballistics_N" ;
lin ballistocardiogram_N = mkTerm "ballistocardiogram_N" ;
lin ballistocardiograph_N = mkTerm "ballistocardiograph_N" ;
lin ballock_N = mkTerm "ballock_N" ;
lin balloon_N = mkTerm "balloon_N" ;
lin balloon_V = mkTerm "balloon_V" ;
lin balloon_V2 = mkTerm "balloon_V2" ;
lin balloonfish_N = mkTerm "balloonfish_N" ;
lin ballooning_N = mkTerm "ballooning_N" ;
lin balloonist_N = mkTerm "balloonist_N" ;
lin ballot_N = mkTerm "ballot_N" ;
lin ballot_V = mkTerm "ballot_V" ;
lin ballot_box_N = mkTerm "ballot_box_N" ;
lin ballottement_N = mkTerm "ballottement_N" ;
lin ballpark_N = mkTerm "ballpark_N" ;
lin ballpen_N = mkTerm "ballpen_N" ;
lin ballplayer_N = mkTerm "ballplayer_N" ;
lin ballpoint_N = mkTerm "ballpoint_N" ;
lin ballpoint_pen_N = mkTerm "ballpoint_pen_N" ;
lin ballroom_N = mkTerm "ballroom_N" ;
lin balls_up_N = mkTerm "balls_up_N" ;
lin balls_up_V2 = mkTerm "balls_up_V2" ;
lin ballup_N = mkTerm "ballup_N" ;
lin bally_A = mkTerm "bally_A" ;
lin bally_Adv = mkTerm "bally_Adv" ;
lin ballyhoo_N = mkTerm "ballyhoo_N" ;
lin balm_N = mkTerm "balm_N" ;
lin balminess_N = mkTerm "balminess_N" ;
lin balmoral_N = mkTerm "balmoral_N" ;
lin balmy_A = mkTerm "balmy_A" ;
lin baloney_N = mkTerm "baloney_N" ;
lin balsa_N = mkTerm "balsa_N" ;
lin balsam_N = mkTerm "balsam_N" ;
lin balsamic_A = mkTerm "balsamic_A" ;
lin balsamroot_N = mkTerm "balsamroot_N" ;
lin baltic_sea_PN = mkTerm "baltic_sea_PN" ;
lin baltimore_PN = mkTerm "baltimore_PN" ;
lin baluster_N = mkTerm "baluster_N" ;
lin balustrade_N = mkTerm "balustrade_N" ;
lin bambino_N = mkTerm "bambino_N" ;
lin bamboo_N = mkTerm "bamboo_N" ;
lin bamboozle_V2 = mkTerm "bamboozle_V2" ;
lin ban_N = mkTerm "ban_N" ;
lin ban_V2 = mkTerm "ban_V2" ;
lin banal_A = mkTerm "banal_A" ;
lin banality_N = mkTerm "banality_N" ;
lin banana_N = mkTerm "banana_N" ;
lin banausic_A = mkTerm "banausic_A" ;
lin banbury_PN = mkTerm "banbury_PN" ;
lin band_N = mkTerm "band_N" ;
lin band_V = mkTerm "band_V" ;
lin band_V2 = mkTerm "band_V2" ;
lin band_saw_N = mkTerm "band_saw_N" ;
lin bandage_N = mkTerm "bandage_N" ;
lin bandage_V2 = mkTerm "bandage_V2" ;
lin bandanna_N = mkTerm "bandanna_N" ;
lin bandbox_N = mkTerm "bandbox_N" ;
lin bandeau_N = mkTerm "bandeau_N" ;
lin banderilla_N = mkTerm "banderilla_N" ;
lin banderillero_N = mkTerm "banderillero_N" ;
lin bandicoot_N = mkTerm "bandicoot_N" ;
lin bandit_N = mkTerm "bandit_N" ;
lin banditry_N = mkTerm "banditry_N" ;
lin bandleader_N = mkTerm "bandleader_N" ;
lin bandmaster_N = mkTerm "bandmaster_N" ;
lin bandoleer_N = mkTerm "bandoleer_N" ;
lin bandolier_N = mkTerm "bandolier_N" ;
lin bandoneon_N = mkTerm "bandoneon_N" ;
lin bandsman_N = mkTerm "bandsman_N" ;
lin bandstand_N = mkTerm "bandstand_N" ;
lin bandung_PN = mkTerm "bandung_PN" ;
lin bandwagon_N = mkTerm "bandwagon_N" ;
lin bandwidth_N = mkTerm "bandwidth_N" ;
lin bandy_A = mkTerm "bandy_A" ;
lin bandy_V2 = mkTerm "bandy_V2" ;
lin bandy_legged_A = mkTerm "bandy_legged_A" ;
lin bane_N = mkTerm "bane_N" ;
lin baneberry_N = mkTerm "baneberry_N" ;
lin baneful_A = mkTerm "baneful_A" ;
lin bang_Adv = mkTerm "bang_Adv" ;
lin bang_N = mkTerm "bang_N" ;
lin bang_V = mkTerm "bang_V" ;
lin bang_V2 = mkTerm "bang_V2" ;
lin bang_about_V = mkTerm "bang_about_V" ;
lin bang_around_V = mkTerm "bang_around_V" ;
lin bang_on_V = mkTerm "bang_on_V" ;
lin bang_on_about_V2 = mkTerm "bang_on_about_V2" ;
lin bang_out_V2 = mkTerm "bang_out_V2" ;
lin bang_up_V2 = mkTerm "bang_up_V2" ;
lin bangalore_PN = mkTerm "bangalore_PN" ;
lin banger_N = mkTerm "banger_N" ;
lin banging_N = mkTerm "banging_N" ;
lin bangkok_PN = mkTerm "bangkok_PN" ;
lin bangladesh_PN = mkTerm "bangladesh_PN" ;
lin bangladeshi_A = mkTerm "bangladeshi_A" ;
lin bangladeshi_N = mkTerm "bangladeshi_N" ;
lin bangle_N = mkTerm "bangle_N" ;
lin bangor_PN = mkTerm "bangor_PN" ;
lin banian_N = mkTerm "banian_N" ;
lin banian_tree_N = mkTerm "banian_tree_N" ;
lin banish_V2 = mkTerm "banish_V2" ;
lin banishment_N = mkTerm "banishment_N" ;
lin banister_N = mkTerm "banister_N" ;
lin banjo_N = mkTerm "banjo_N" ;
lin bank_1_N = mkTerm "bank_1_N" ;
lin bank_2_N = mkTerm "bank_2_N" ;
lin bank_V = mkTerm "bank_V" ;
lin bank_V2 = mkTerm "bank_V2" ;
lin bank_bill_N = mkTerm "bank_bill_N" ;
lin bank_book_N = mkTerm "bank_book_N" ;
lin bank_draft_N = mkTerm "bank_draft_N" ;
lin bank_on_V2 = mkTerm "bank_on_V2" ;
lin bank_rate_N = mkTerm "bank_rate_N" ;
lin bankable_A = mkTerm "bankable_A" ;
lin banker_N = mkTerm "banker_N" ;
lin banking_N = mkTerm "banking_N" ;
lin banknote_N = mkTerm "banknote_N" ;
lin bankroll_N = mkTerm "bankroll_N" ;
lin bankrupt_A = mkTerm "bankrupt_A" ;
lin bankrupt_N = mkTerm "bankrupt_N" ;
lin bankrupt_V2 = mkTerm "bankrupt_V2" ;
lin bankruptcy_N = mkTerm "bankruptcy_N" ;
lin banksia_N = mkTerm "banksia_N" ;
lin banner_A = mkTerm "banner_A" ;
lin banner_N = mkTerm "banner_N" ;
lin bannerlike_Adv = mkTerm "bannerlike_Adv" ;
lin banning_order_N = mkTerm "banning_order_N" ;
lin bannister_N = mkTerm "bannister_N" ;
lin bannock_N = mkTerm "bannock_N" ;
lin bannockburn_PN = mkTerm "bannockburn_PN" ;
lin banns_N = mkTerm "banns_N" ;
lin banquet_N = mkTerm "banquet_N" ;
lin banquet_V = mkTerm "banquet_V" ;
lin banquet_V2 = mkTerm "banquet_V2" ;
lin banquette_N = mkTerm "banquette_N" ;
lin banshee_N = mkTerm "banshee_N" ;
lin bant_V = mkTerm "bant_V" ;
lin bantam_A = mkTerm "bantam_A" ;
lin bantam_N = mkTerm "bantam_N" ;
lin bantamweight_N = mkTerm "bantamweight_N" ;
lin banteng_N = mkTerm "banteng_N" ;
lin banter_N = mkTerm "banter_N" ;
lin banter_V = mkTerm "banter_V" ;
lin banter_V2 = mkTerm "banter_V2" ;
lin banteringly_Adv = mkTerm "banteringly_Adv" ;
lin banting_N = mkTerm "banting_N" ;
lin bantry_PN = mkTerm "bantry_PN" ;
lin bantu_A = mkTerm "bantu_A" ;
lin bantu_N = mkTerm "bantu_N" ;
lin banyan_N = mkTerm "banyan_N" ;
lin banzai_N = mkTerm "banzai_N" ;
lin baobab_N = mkTerm "baobab_N" ;
lin bap_N = mkTerm "bap_N" ;
lin baptism_N = mkTerm "baptism_N" ;
lin baptismal_A = mkTerm "baptismal_A" ;
lin baptist_A = mkTerm "baptist_A" ;
lin baptist_N = mkTerm "baptist_N" ;
lin baptize_V2 = mkTerm "baptize_V2" ;
lin bar_1_N = mkTerm "bar_1_N" ;
lin bar_2_N = mkTerm "bar_2_N" ;
lin bar_Prep = mkTerm "bar_Prep" ;
lin bar_V2 = mkTerm "bar_V2" ;
lin baracaldo_PN = mkTerm "baracaldo_PN" ;
lin barb_N = mkTerm "barb_N" ;
lin barbadian_A = mkTerm "barbadian_A" ;
lin barbadian_N = mkTerm "barbadian_N" ;
lin barbados_PN = mkTerm "barbados_PN" ;
lin barbara_PN = mkTerm "barbara_PN" ;
lin barbarian_A = mkTerm "barbarian_A" ;
lin barbarian_N = mkTerm "barbarian_N" ;
lin barbaric_A = mkTerm "barbaric_A" ;
lin barbarism_N = mkTerm "barbarism_N" ;
lin barbarity_N = mkTerm "barbarity_N" ;
lin barbarization_N = mkTerm "barbarization_N" ;
lin barbarize_V2 = mkTerm "barbarize_V2" ;
lin barbarous_A = mkTerm "barbarous_A" ;
lin barbasco_N = mkTerm "barbasco_N" ;
lin barbecue_N = mkTerm "barbecue_N" ;
lin barbecue_V2 = mkTerm "barbecue_V2" ;
lin barbecuing_N = mkTerm "barbecuing_N" ;
lin barbed_A = mkTerm "barbed_A" ;
lin barbel_N = mkTerm "barbel_N" ;
lin barbell_N = mkTerm "barbell_N" ;
lin barber_N = mkTerm "barber_N" ;
lin barberry_N = mkTerm "barberry_N" ;
lin barbershop_N = mkTerm "barbershop_N" ;
lin barbet_N = mkTerm "barbet_N" ;
lin barbette_N = mkTerm "barbette_N" ;
lin barbican_N = mkTerm "barbican_N" ;
lin barbital_N = mkTerm "barbital_N" ;
lin barbitone_N = mkTerm "barbitone_N" ;
lin barbiturate_N = mkTerm "barbiturate_N" ;
lin barbu_N = mkTerm "barbu_N" ;
lin barcarole_N = mkTerm "barcarole_N" ;
lin barcarolle_N = mkTerm "barcarolle_N" ;
lin barcelona_PN = mkTerm "barcelona_PN" ;
lin bard_N = mkTerm "bard_N" ;
lin bardic_A = mkTerm "bardic_A" ;
lin bardolatry_N = mkTerm "bardolatry_N" ;
lin bare_A = mkTerm "bare_A" ;
lin bare_V2 = mkTerm "bare_V2" ;
lin bareback_A = mkTerm "bareback_A" ;
lin bareback_Adv = mkTerm "bareback_Adv" ;
lin barebacked_A = mkTerm "barebacked_A" ;
lin barebacked_Adv = mkTerm "barebacked_Adv" ;
lin bareboat_N = mkTerm "bareboat_N" ;
lin bareboating_N = mkTerm "bareboating_N" ;
lin barefaced_A = mkTerm "barefaced_A" ;
lin barefoot_A = mkTerm "barefoot_A" ;
lin barefoot_Adv = mkTerm "barefoot_Adv" ;
lin barefooted_A = mkTerm "barefooted_A" ;
lin barefooted_Adv = mkTerm "barefooted_Adv" ;
lin barehanded_A = mkTerm "barehanded_A" ;
lin bareheaded_A = mkTerm "bareheaded_A" ;
lin barelegged_A = mkTerm "barelegged_A" ;
lin barely_Adv = mkTerm "barely_Adv" ;
lin bareness_N = mkTerm "bareness_N" ;
lin bargain_N = mkTerm "bargain_N" ;
lin bargain_V = mkTerm "bargain_V" ;
lin bargain_V2 = mkTerm "bargain_V2" ;
lin bargain_down_V2 = mkTerm "bargain_down_V2" ;
lin bargain_for_V2 = mkTerm "bargain_for_V2" ;
lin bargain_on_V2 = mkTerm "bargain_on_V2" ;
lin bargainer_N = mkTerm "bargainer_N" ;
lin bargaining_N = mkTerm "bargaining_N" ;
lin barge_N = mkTerm "barge_N" ;
lin barge_V = mkTerm "barge_V" ;
lin barge_in_V = mkTerm "barge_in_V" ;
lin barge_into_V2 = mkTerm "barge_into_V2" ;
lin bargee_N = mkTerm "bargee_N" ;
lin bargello_N = mkTerm "bargello_N" ;
lin bargepole_N = mkTerm "bargepole_N" ;
lin bargoed_PN = mkTerm "bargoed_PN" ;
lin bari_PN = mkTerm "bari_PN" ;
lin baric_A = mkTerm "baric_A" ;
lin barilla_N = mkTerm "barilla_N" ;
lin baritone_A = mkTerm "baritone_A" ;
lin baritone_N = mkTerm "baritone_N" ;
lin barium_N = mkTerm "barium_N" ;
lin bark_N = mkTerm "bark_N" ;
lin bark_V = mkTerm "bark_V" ;
lin bark_V2 = mkTerm "bark_V2" ;
lin barker_N = mkTerm "barker_N" ;
lin barking_PN = mkTerm "barking_PN" ;
lin barky_A = mkTerm "barky_A" ;
lin barley_N = mkTerm "barley_N" ;
lin barley_sugar_N = mkTerm "barley_sugar_N" ;
lin barley_water_N = mkTerm "barley_water_N" ;
lin barleycorn_N = mkTerm "barleycorn_N" ;
lin barm_N = mkTerm "barm_N" ;
lin barmaid_N = mkTerm "barmaid_N" ;
lin barman_N = mkTerm "barman_N" ;
lin barmbrack_N = mkTerm "barmbrack_N" ;
lin barmy_A = mkTerm "barmy_A" ;
lin barn_N = mkTerm "barn_N" ;
lin barn_door_N = mkTerm "barn_door_N" ;
lin barnacle_N = mkTerm "barnacle_N" ;
lin barnard_castle_PN = mkTerm "barnard_castle_PN" ;
lin barnburner_N = mkTerm "barnburner_N" ;
lin barnet_PN = mkTerm "barnet_PN" ;
lin barnful_N = mkTerm "barnful_N" ;
lin barnoldswick_PN = mkTerm "barnoldswick_PN" ;
lin barnsley_PN = mkTerm "barnsley_PN" ;
lin barnstaple_PN = mkTerm "barnstaple_PN" ;
lin barnstorm_V = mkTerm "barnstorm_V" ;
lin barnstormer_N = mkTerm "barnstormer_N" ;
lin barnyard_N = mkTerm "barnyard_N" ;
lin barograph_N = mkTerm "barograph_N" ;
lin barographic_A = mkTerm "barographic_A" ;
lin barometer_N = mkTerm "barometer_N" ;
lin barometric_A = mkTerm "barometric_A" ;
lin baron_N = mkTerm "baron_N" ;
lin baronage_N = mkTerm "baronage_N" ;
lin baronduki_N = mkTerm "baronduki_N" ;
lin baroness_N = mkTerm "baroness_N" ;
lin baronet_N = mkTerm "baronet_N" ;
lin baronetage_N = mkTerm "baronetage_N" ;
lin baronetcy_N = mkTerm "baronetcy_N" ;
lin barong_N = mkTerm "barong_N" ;
lin baronial_A = mkTerm "baronial_A" ;
lin barony_N = mkTerm "barony_N" ;
lin baroque_A = mkTerm "baroque_A" ;
lin baroque_N = mkTerm "baroque_N" ;
lin baroreceptor_N = mkTerm "baroreceptor_N" ;
lin barosaur_N = mkTerm "barosaur_N" ;
lin barouche_N = mkTerm "barouche_N" ;
lin barque_N = mkTerm "barque_N" ;
lin barra_N = mkTerm "barra_N" ;
lin barrack_N = mkTerm "barrack_N" ;
lin barrack_V = mkTerm "barrack_V" ;
lin barrack_V2 = mkTerm "barrack_V2" ;
lin barracking_N = mkTerm "barracking_N" ;
lin barracks_N = mkTerm "barracks_N" ;
lin barracouta_N = mkTerm "barracouta_N" ;
lin barracuda_N = mkTerm "barracuda_N" ;
lin barrage_N = mkTerm "barrage_N" ;
lin barramundi_N = mkTerm "barramundi_N" ;
lin barranquilla_PN = mkTerm "barranquilla_PN" ;
lin barrator_N = mkTerm "barrator_N" ;
lin barratry_N = mkTerm "barratry_N" ;
lin barrel_N = mkTerm "barrel_N" ;
lin barrel_V2 = mkTerm "barrel_V2" ;
lin barreled_A = mkTerm "barreled_A" ;
lin barrelfish_N = mkTerm "barrelfish_N" ;
lin barrelhouse_N = mkTerm "barrelhouse_N" ;
lin barrels_N = mkTerm "barrels_N" ;
lin barren_A = mkTerm "barren_A" ;
lin barren_N = mkTerm "barren_N" ;
lin barrenness_N = mkTerm "barrenness_N" ;
lin barrenwort_N = mkTerm "barrenwort_N" ;
lin barrette_N = mkTerm "barrette_N" ;
lin barrhead_PN = mkTerm "barrhead_PN" ;
lin barricade_N = mkTerm "barricade_N" ;
lin barricade_V2 = mkTerm "barricade_V2" ;
lin barrier_N = mkTerm "barrier_N" ;
lin barring_N = mkTerm "barring_N" ;
lin barrio_N = mkTerm "barrio_N" ;
lin barrister_N = mkTerm "barrister_N" ;
lin barroom_N = mkTerm "barroom_N" ;
lin barrow_N = mkTerm "barrow_N" ;
lin barrow_boy_N = mkTerm "barrow_boy_N" ;
lin barrow_in_furness_PN = mkTerm "barrow_in_furness_PN" ;
lin barrow_man_N = mkTerm "barrow_man_N" ;
lin barry_PN = mkTerm "barry_PN" ;
lin bart_PN = mkTerm "bart_PN" ;
lin bartender_N = mkTerm "bartender_N" ;
lin barter_N = mkTerm "barter_N" ;
lin barter_V = mkTerm "barter_V" ;
lin barter_V2 = mkTerm "barter_V2" ;
lin barterer_N = mkTerm "barterer_N" ;
lin bartholomew_PN = mkTerm "bartholomew_PN" ;
lin bartlett_N = mkTerm "bartlett_N" ;
lin barton_upon_humber_PN = mkTerm "barton_upon_humber_PN" ;
lin bartonia_N = mkTerm "bartonia_N" ;
lin barycenter_N = mkTerm "barycenter_N" ;
lin barye_N = mkTerm "barye_N" ;
lin baryon_N = mkTerm "baryon_N" ;
lin baryta_N = mkTerm "baryta_N" ;
lin barytic_A = mkTerm "barytic_A" ;
lin bas_relief_N = mkTerm "bas_relief_N" ;
lin basal_A = mkTerm "basal_A" ;
lin basalt_N = mkTerm "basalt_N" ;
lin basaltic_A = mkTerm "basaltic_A" ;
lin bascule_N = mkTerm "bascule_N" ;
lin base_A = mkTerm "base_A" ;
lin base_N = mkTerm "base_N" ;
lin base_V = mkTerm "base_V" ;
lin base_V2 = mkTerm "base_V2" ;
lin baseball_N = mkTerm "baseball_N" ;
lin baseboard_N = mkTerm "baseboard_N" ;
lin basel_PN = mkTerm "basel_PN" ;
lin baseless_A = mkTerm "baseless_A" ;
lin baseline_N = mkTerm "baseline_N" ;
lin baseman_N = mkTerm "baseman_N" ;
lin basement_N = mkTerm "basement_N" ;
lin baseness_N = mkTerm "baseness_N" ;
lin basenji_N = mkTerm "basenji_N" ;
lin bash_N = mkTerm "bash_N" ;
lin bash_V2 = mkTerm "bash_V2" ;
lin bash_about_V2 = mkTerm "bash_about_V2" ;
lin bash_in_V2 = mkTerm "bash_in_V2" ;
lin bash_out_V2 = mkTerm "bash_out_V2" ;
lin bash_up_V2 = mkTerm "bash_up_V2" ;
lin bashful_A = mkTerm "bashful_A" ;
lin basic_A = mkTerm "basic_A" ;
lin basic_N = mkTerm "basic_N" ;
lin basically_Adv = mkTerm "basically_Adv" ;
lin basics_N = mkTerm "basics_N" ;
lin basidial_A = mkTerm "basidial_A" ;
lin basidiocarp_N = mkTerm "basidiocarp_N" ;
lin basidiolichen_N = mkTerm "basidiolichen_N" ;
lin basidiomycete_N = mkTerm "basidiomycete_N" ;
lin basidiomycetous_A = mkTerm "basidiomycetous_A" ;
lin basidiospore_N = mkTerm "basidiospore_N" ;
lin basidiosporous_A = mkTerm "basidiosporous_A" ;
lin basidium_N = mkTerm "basidium_N" ;
lin basifixed_A = mkTerm "basifixed_A" ;
lin basil_N = mkTerm "basil_N" ;
lin basil_PN = mkTerm "basil_PN" ;
lin basilar_A = mkTerm "basilar_A" ;
lin basildon_PN = mkTerm "basildon_PN" ;
lin basileus_N = mkTerm "basileus_N" ;
lin basilica_N = mkTerm "basilica_N" ;
lin basilican_A = mkTerm "basilican_A" ;
lin basilisk_N = mkTerm "basilisk_N" ;
lin basin_N = mkTerm "basin_N" ;
lin basinal_A = mkTerm "basinal_A" ;
lin basined_A = mkTerm "basined_A" ;
lin basinet_N = mkTerm "basinet_N" ;
lin basingstoke_PN = mkTerm "basingstoke_PN" ;
lin basipetal_A = mkTerm "basipetal_A" ;
lin basis_N = mkTerm "basis_N" ;
lin basiscopic_A = mkTerm "basiscopic_A" ;
lin bask_V = mkTerm "bask_V" ;
lin basket_N = mkTerm "basket_N" ;
lin basketball_N = mkTerm "basketball_N" ;
lin basketry_N = mkTerm "basketry_N" ;
lin basketweaver_N = mkTerm "basketweaver_N" ;
lin basophil_N = mkTerm "basophil_N" ;
lin basophilia_N = mkTerm "basophilia_N" ;
lin basophilic_A = mkTerm "basophilic_A" ;
lin basque_A = mkTerm "basque_A" ;
lin bass_A = mkTerm "bass_A" ;
lin bass_N = mkTerm "bass_N" ;
lin bassarisk_N = mkTerm "bassarisk_N" ;
lin basset_N = mkTerm "basset_N" ;
lin bassine_N = mkTerm "bassine_N" ;
lin bassinet_N = mkTerm "bassinet_N" ;
lin bassist_N = mkTerm "bassist_N" ;
lin bassoon_N = mkTerm "bassoon_N" ;
lin bassoonist_N = mkTerm "bassoonist_N" ;
lin basswood_N = mkTerm "basswood_N" ;
lin bast_N = mkTerm "bast_N" ;
lin bastard_N = mkTerm "bastard_N" ;
lin bastardization_N = mkTerm "bastardization_N" ;
lin bastardize_V2 = mkTerm "bastardize_V2" ;
lin bastardly_A = mkTerm "bastardly_A" ;
lin bastardy_N = mkTerm "bastardy_N" ;
lin baste_N = mkTerm "baste_N" ;
lin baste_V2 = mkTerm "baste_V2" ;
lin baster_N = mkTerm "baster_N" ;
lin bastille_N = mkTerm "bastille_N" ;
lin bastinado_N = mkTerm "bastinado_N" ;
lin bastinado_V2 = mkTerm "bastinado_V2" ;
lin basting_N = mkTerm "basting_N" ;
lin bastion_N = mkTerm "bastion_N" ;
lin bastioned_A = mkTerm "bastioned_A" ;
lin bastnasite_N = mkTerm "bastnasite_N" ;
lin basuco_N = mkTerm "basuco_N" ;
lin bat_N = mkTerm "bat_N" ;
lin bat_V = mkTerm "bat_V" ;
lin bat_V2 = mkTerm "bat_V2" ;
lin bat_in_V = mkTerm "bat_in_V" ;
lin batch_N = mkTerm "batch_N" ;
lin bate_V2 = mkTerm "bate_V2" ;
lin batfish_N = mkTerm "batfish_N" ;
lin bath_N = mkTerm "bath_N" ;
lin bath_PN = mkTerm "bath_PN" ;
lin bath_V = mkTerm "bath_V" ;
lin bath_V2 = mkTerm "bath_V2" ;
lin bath_chair_N = mkTerm "bath_chair_N" ;
lin bathe_N = mkTerm "bathe_N" ;
lin bathe_V = mkTerm "bathe_V" ;
lin bathe_V2 = mkTerm "bathe_V2" ;
lin bather_N = mkTerm "bather_N" ;
lin bathetic_A = mkTerm "bathetic_A" ;
lin bathgate_PN = mkTerm "bathgate_PN" ;
lin bathhouse_N = mkTerm "bathhouse_N" ;
lin bathing_N = mkTerm "bathing_N" ;
lin bathing_cap_N = mkTerm "bathing_cap_N" ;
lin bathing_costume_N = mkTerm "bathing_costume_N" ;
lin bathing_machine_N = mkTerm "bathing_machine_N" ;
lin bathing_suit_N = mkTerm "bathing_suit_N" ;
lin batholith_N = mkTerm "batholith_N" ;
lin batholithic_A = mkTerm "batholithic_A" ;
lin bathos_N = mkTerm "bathos_N" ;
lin bathrobe_N = mkTerm "bathrobe_N" ;
lin bathroom_N = mkTerm "bathroom_N" ;
lin bathtub_N = mkTerm "bathtub_N" ;
lin bathyal_A = mkTerm "bathyal_A" ;
lin bathymeter_N = mkTerm "bathymeter_N" ;
lin bathymetric_A = mkTerm "bathymetric_A" ;
lin bathymetry_N = mkTerm "bathymetry_N" ;
lin bathyscaphe_N = mkTerm "bathyscaphe_N" ;
lin bathysphere_N = mkTerm "bathysphere_N" ;
lin batik_N = mkTerm "batik_N" ;
lin batiste_N = mkTerm "batiste_N" ;
lin batley_PN = mkTerm "batley_PN" ;
lin batman_N = mkTerm "batman_N" ;
lin baton_N = mkTerm "baton_N" ;
lin batrachomyomachia_N = mkTerm "batrachomyomachia_N" ;
lin bats_A = mkTerm "bats_A" ;
lin batsman_N = mkTerm "batsman_N" ;
lin battalion_N = mkTerm "battalion_N" ;
lin batten_N = mkTerm "batten_N" ;
lin batten_V = mkTerm "batten_V" ;
lin batten_V2 = mkTerm "batten_V2" ;
lin batter_N = mkTerm "batter_N" ;
lin batter_V = mkTerm "batter_V" ;
lin batter_V2 = mkTerm "batter_V2" ;
lin battering_N = mkTerm "battering_N" ;
lin battery_1_N = mkTerm "battery_1_N" ;
lin battery_2_N = mkTerm "battery_2_N" ;
lin batting_N = mkTerm "batting_N" ;
lin battle_N = mkTerm "battle_N" ;
lin battle_V = mkTerm "battle_V" ;
lin battle_V2 = mkTerm "battle_V2" ;
lin battle_axe_N = mkTerm "battle_axe_N" ;
lin battle_cruiser_N = mkTerm "battle_cruiser_N" ;
lin battledore_N = mkTerm "battledore_N" ;
lin battledress_N = mkTerm "battledress_N" ;
lin battlefield_N = mkTerm "battlefield_N" ;
lin battlefront_N = mkTerm "battlefront_N" ;
lin battleful_A = mkTerm "battleful_A" ;
lin battleground_N = mkTerm "battleground_N" ;
lin battlement_N = mkTerm "battlement_N" ;
lin battlemented_A = mkTerm "battlemented_A" ;
lin battleship_N = mkTerm "battleship_N" ;
lin battue_N = mkTerm "battue_N" ;
lin batty_A = mkTerm "batty_A" ;
lin batwing_A = mkTerm "batwing_A" ;
lin batwing_N = mkTerm "batwing_N" ;
lin bauble_N = mkTerm "bauble_N" ;
lin baud_N = mkTerm "baud_N" ;
lin baulk_N = mkTerm "baulk_N" ;
lin baulk_V = mkTerm "baulk_V" ;
lin baulk_V2 = mkTerm "baulk_V2" ;
lin bauxite_N = mkTerm "bauxite_N" ;
lin bauxitic_A = mkTerm "bauxitic_A" ;
lin bawbee_N = mkTerm "bawbee_N" ;
lin bawd_N = mkTerm "bawd_N" ;
lin bawdry_N = mkTerm "bawdry_N" ;
lin bawdy_A = mkTerm "bawdy_A" ;
lin bawdy_N = mkTerm "bawdy_N" ;
lin bawl_V = mkTerm "bawl_V" ;
lin bawl_V2 = mkTerm "bawl_V2" ;
lin bawl_out_V2 = mkTerm "bawl_out_V2" ;
lin bawler_N = mkTerm "bawler_N" ;
lin bay_A = mkTerm "bay_A" ;
lin bay_N = mkTerm "bay_N" ;
lin bay_V = mkTerm "bay_V" ;
lin bay_wreath_N = mkTerm "bay_wreath_N" ;
lin baya_N = mkTerm "baya_N" ;
lin bayat_N = mkTerm "bayat_N" ;
lin bayberry_N = mkTerm "bayberry_N" ;
lin bayonet_N = mkTerm "bayonet_N" ;
lin bayonet_V2 = mkTerm "bayonet_V2" ;
lin bayou_N = mkTerm "bayou_N" ;
lin bazaar_N = mkTerm "bazaar_N" ;
lin bazooka_N = mkTerm "bazooka_N" ;
lin bbc_PN = mkTerm "bbc_PN" ;
lin bdellium_N = mkTerm "bdellium_N" ;
lin beach_N = mkTerm "beach_N" ;
lin beach_V2 = mkTerm "beach_V2" ;
lin beachcomber_N = mkTerm "beachcomber_N" ;
lin beachfront_N = mkTerm "beachfront_N" ;
lin beachhead_N = mkTerm "beachhead_N" ;
lin beachwear_N = mkTerm "beachwear_N" ;
lin beacon_N = mkTerm "beacon_N" ;
lin beacon_fire_N = mkTerm "beacon_fire_N" ;
lin beacon_light_N = mkTerm "beacon_light_N" ;
lin beaconsfield_PN = mkTerm "beaconsfield_PN" ;
lin bead_N = mkTerm "bead_N" ;
lin beaded_A = mkTerm "beaded_A" ;
lin beading_N = mkTerm "beading_N" ;
lin beadle_N = mkTerm "beadle_N" ;
lin beads_N = mkTerm "beads_N" ;
lin beadsman_N = mkTerm "beadsman_N" ;
lin beady_A = mkTerm "beady_A" ;
lin beagle_N = mkTerm "beagle_N" ;
lin beagling_N = mkTerm "beagling_N" ;
lin beak_N = mkTerm "beak_N" ;
lin beaked_A = mkTerm "beaked_A" ;
lin beaker_N = mkTerm "beaker_N" ;
lin beakless_A = mkTerm "beakless_A" ;
lin beaklike_A = mkTerm "beaklike_A" ;
lin beam_N = mkTerm "beam_N" ;
lin beam_V = mkTerm "beam_V" ;
lin beam_V2 = mkTerm "beam_V2" ;
lin beamish_A = mkTerm "beamish_A" ;
lin beamy_A = mkTerm "beamy_A" ;
lin bean_N = mkTerm "bean_N" ;
lin beanbag_N = mkTerm "beanbag_N" ;
lin beanball_N = mkTerm "beanball_N" ;
lin beanfeast_N = mkTerm "beanfeast_N" ;
lin beanie_N = mkTerm "beanie_N" ;
lin beano_N = mkTerm "beano_N" ;
lin beanstalk_N = mkTerm "beanstalk_N" ;
lin bear_N = mkTerm "bear_N" ;
lin bear_V = mkTerm "bear_V" ;
lin bear_V2 = mkTerm "bear_V2" ;
lin bear_down_on_V2 = mkTerm "bear_down_on_V2" ;
lin bear_on_V2 = mkTerm "bear_on_V2" ;
lin bear_out_V2 = mkTerm "bear_out_V2" ;
lin bear_up_V = mkTerm "bear_up_V" ;
lin bear_up_under_V2 = mkTerm "bear_up_under_V2" ;
lin bear_with_V2 = mkTerm "bear_with_V2" ;
lin bearable_A = mkTerm "bearable_A" ;
lin bearberry_N = mkTerm "bearberry_N" ;
lin beard_N = mkTerm "beard_N" ;
lin beard_V2 = mkTerm "beard_V2" ;
lin beardless_A = mkTerm "beardless_A" ;
lin bearer_N = mkTerm "bearer_N" ;
lin bearing_N = mkTerm "bearing_N" ;
lin bearish_A = mkTerm "bearish_A" ;
lin bearnaise_N = mkTerm "bearnaise_N" ;
lin bearsden_PN = mkTerm "bearsden_PN" ;
lin bearskin_N = mkTerm "bearskin_N" ;
lin beast_N = mkTerm "beast_N" ;
lin beastliness_N = mkTerm "beastliness_N" ;
lin beastly_A = mkTerm "beastly_A" ;
lin beastly_Adv = mkTerm "beastly_Adv" ;
lin beat_N = mkTerm "beat_N" ;
lin beat_V = mkTerm "beat_V" ;
lin beat_V2 = mkTerm "beat_V2" ;
lin beat_back_V = mkTerm "beat_back_V" ;
lin beat_down_V = mkTerm "beat_down_V" ;
lin beat_down_V2 = mkTerm "beat_down_V2" ;
lin beat_out_V2 = mkTerm "beat_out_V2" ;
lin beat_up_V2 = mkTerm "beat_up_V2" ;
lin beatable_A = mkTerm "beatable_A" ;
lin beaten_A = mkTerm "beaten_A" ;
lin beater_N = mkTerm "beater_N" ;
lin beatific_A = mkTerm "beatific_A" ;
lin beatification_N = mkTerm "beatification_N" ;
lin beatify_V2 = mkTerm "beatify_V2" ;
lin beating_N = mkTerm "beating_N" ;
lin beatitude_N = mkTerm "beatitude_N" ;
lin beatnik_N = mkTerm "beatnik_N" ;
lin beatrice_PN = mkTerm "beatrice_PN" ;
lin beau_N = mkTerm "beau_N" ;
lin beaugregory_N = mkTerm "beaugregory_N" ;
lin beaujolais_N = mkTerm "beaujolais_N" ;
lin beaumaris_PN = mkTerm "beaumaris_PN" ;
lin beauteous_A = mkTerm "beauteous_A" ;
lin beautician_N = mkTerm "beautician_N" ;
lin beautification_N = mkTerm "beautification_N" ;
lin beautiful_A = mkTerm "beautiful_A" ;
lin beautify_V2 = mkTerm "beautify_V2" ;
lin beauty_N = mkTerm "beauty_N" ;
lin beauty_parlour_N = mkTerm "beauty_parlour_N" ;
lin beauty_salon_N = mkTerm "beauty_salon_N" ;
lin beauty_sleep_N = mkTerm "beauty_sleep_N" ;
lin beauty_spot_N = mkTerm "beauty_spot_N" ;
lin beaver_N = mkTerm "beaver_N" ;
lin beaver_V = mkTerm "beaver_V" ;
lin beaver_away_V = mkTerm "beaver_away_V" ;
lin beaver_away_at_V2 = mkTerm "beaver_away_at_V2" ;
lin bebington_PN = mkTerm "bebington_PN" ;
lin becalmed_A = mkTerm "becalmed_A" ;
lin because_of_Prep = mkTerm "because_of_Prep" ;
lin beccles_PN = mkTerm "beccles_PN" ;
lin beck_N = mkTerm "beck_N" ;
lin becket_N = mkTerm "becket_N" ;
lin beckon_V = mkTerm "beckon_V" ;
lin beckon_V2 = mkTerm "beckon_V2" ;
lin become_V = mkTerm "become_V" ;
lin become_V2 = mkTerm "become_V2" ;
lin become_VA = mkTerm "become_VA" ;
lin becomingly_Adv = mkTerm "becomingly_Adv" ;
lin becomingness_N = mkTerm "becomingness_N" ;
lin bed_N = mkTerm "bed_N" ;
lin bed_V2 = mkTerm "bed_V2" ;
lin bed_down_V = mkTerm "bed_down_V" ;
lin bed_out_V2 = mkTerm "bed_out_V2" ;
lin bedaubed_A = mkTerm "bedaubed_A" ;
lin bedbug_N = mkTerm "bedbug_N" ;
lin bedclothes_N = mkTerm "bedclothes_N" ;
lin beddau_PN = mkTerm "beddau_PN" ;
lin bedder_N = mkTerm "bedder_N" ;
lin bedding_N = mkTerm "bedding_N" ;
lin bedecked_A = mkTerm "bedecked_A" ;
lin bedevil_V2 = mkTerm "bedevil_V2" ;
lin bedevilment_N = mkTerm "bedevilment_N" ;
lin bedewed_A = mkTerm "bedewed_A" ;
lin bedfast_A = mkTerm "bedfast_A" ;
lin bedfellow_N = mkTerm "bedfellow_N" ;
lin bedford_PN = mkTerm "bedford_PN" ;
lin bedfordshire_PN = mkTerm "bedfordshire_PN" ;
lin bedimmed_A = mkTerm "bedimmed_A" ;
lin bedlam_N = mkTerm "bedlam_N" ;
lin bedlamite_N = mkTerm "bedlamite_N" ;
lin bedless_A = mkTerm "bedless_A" ;
lin bedlington_PN = mkTerm "bedlington_PN" ;
lin bedouin_N = mkTerm "bedouin_N" ;
lin bedpan_N = mkTerm "bedpan_N" ;
lin bedpost_N = mkTerm "bedpost_N" ;
lin bedraggled_A = mkTerm "bedraggled_A" ;
lin bedrest_N = mkTerm "bedrest_N" ;
lin bedridden_A = mkTerm "bedridden_A" ;
lin bedrock_N = mkTerm "bedrock_N" ;
lin bedroll_N = mkTerm "bedroll_N" ;
lin bedroom_N = mkTerm "bedroom_N" ;
lin bedroomed_A = mkTerm "bedroomed_A" ;
lin bedside_N = mkTerm "bedside_N" ;
lin bedsit_N = mkTerm "bedsit_N" ;
lin bedsitter_N = mkTerm "bedsitter_N" ;
lin bedsitting_room_N = mkTerm "bedsitting_room_N" ;
lin bedsore_N = mkTerm "bedsore_N" ;
lin bedspread_N = mkTerm "bedspread_N" ;
lin bedspring_N = mkTerm "bedspring_N" ;
lin bedstead_N = mkTerm "bedstead_N" ;
lin bedstraw_N = mkTerm "bedstraw_N" ;
lin bedtime_N = mkTerm "bedtime_N" ;
lin bedwas_PN = mkTerm "bedwas_PN" ;
lin bedwetter_N = mkTerm "bedwetter_N" ;
lin bee_N = mkTerm "bee_N" ;
lin beebread_N = mkTerm "beebread_N" ;
lin beech_N = mkTerm "beech_N" ;
lin beechen_A = mkTerm "beechen_A" ;
lin beechnut_N = mkTerm "beechnut_N" ;
lin beef_1_N = mkTerm "beef_1_N" ;
lin beef_2_N = mkTerm "beef_2_N" ;
lin beef_3_N = mkTerm "beef_3_N" ;
lin beef_V = mkTerm "beef_V" ;
lin beef_up_V2 = mkTerm "beef_up_V2" ;
lin beefcake_N = mkTerm "beefcake_N" ;
lin beefeater_N = mkTerm "beefeater_N" ;
lin beefsteak_N = mkTerm "beefsteak_N" ;
lin beefwood_N = mkTerm "beefwood_N" ;
lin beefy_A = mkTerm "beefy_A" ;
lin beehive_N = mkTerm "beehive_N" ;
lin beekeeper_N = mkTerm "beekeeper_N" ;
lin beekeeping_N = mkTerm "beekeeping_N" ;
lin beeline_N = mkTerm "beeline_N" ;
lin beep_N = mkTerm "beep_N" ;
lin beeper_N = mkTerm "beeper_N" ;
lin beer_N = mkTerm "beer_N" ;
lin beery_A = mkTerm "beery_A" ;
lin beeswax_N = mkTerm "beeswax_N" ;
lin beeswax_V2 = mkTerm "beeswax_V2" ;
lin beet_N = mkTerm "beet_N" ;
lin beetle_A = mkTerm "beetle_A" ;
lin beetle_N = mkTerm "beetle_N" ;
lin beetle_V = mkTerm "beetle_V" ;
lin beetle_browed_A = mkTerm "beetle_browed_A" ;
lin beetroot_N = mkTerm "beetroot_N" ;
lin befall_V = mkTerm "befall_V" ;
lin befall_V2 = mkTerm "befall_V2" ;
lin befit_V2 = mkTerm "befit_V2" ;
lin befitting_A = mkTerm "befitting_A" ;
lin befogged_A = mkTerm "befogged_A" ;
lin before_Adv = mkTerm "before_Adv" ;
lin before_Subj = mkTerm "before_Subj" ;
lin beforehand_A = mkTerm "beforehand_A" ;
lin beforehand_Adv = mkTerm "beforehand_Adv" ;
lin befoul_V2 = mkTerm "befoul_V2" ;
lin befoulment_N = mkTerm "befoulment_N" ;
lin befriend_V2 = mkTerm "befriend_V2" ;
lin beg_V = mkTerm "beg_V" ;
lin beg_V2 = mkTerm "beg_V2" ;
lin beget_V2 = mkTerm "beget_V2" ;
lin begetter_N = mkTerm "begetter_N" ;
lin beggar_N = mkTerm "beggar_N" ;
lin beggar_V2 = mkTerm "beggar_V2" ;
lin beggarly_A = mkTerm "beggarly_A" ;
lin beggarman_N = mkTerm "beggarman_N" ;
lin beggarweed_N = mkTerm "beggarweed_N" ;
lin beggarwoman_N = mkTerm "beggarwoman_N" ;
lin beggary_N = mkTerm "beggary_N" ;
lin begin_V = mkTerm "begin_V" ;
lin begin_V2 = mkTerm "begin_V2" ;
lin begin_ing_VV = mkTerm "begin_ing_VV" ;
lin begin_to_VV = mkTerm "begin_to_VV" ;
lin begin_with_V = mkTerm "begin_with_V" ;
lin beginner_N = mkTerm "beginner_N" ;
lin beginning_N = mkTerm "beginning_N" ;
lin begonia_N = mkTerm "begonia_N" ;
lin begrimed_A = mkTerm "begrimed_A" ;
lin begrudge_V2 = mkTerm "begrudge_V2" ;
lin beguile_V2 = mkTerm "beguile_V2" ;
lin beguilement_N = mkTerm "beguilement_N" ;
lin beguiling_A = mkTerm "beguiling_A" ;
lin beguine_N = mkTerm "beguine_N" ;
lin begum_N = mkTerm "begum_N" ;
lin behalf_N = mkTerm "behalf_N" ;
lin behave_V = mkTerm "behave_V" ;
lin behaved_A = mkTerm "behaved_A" ;
lin behavior_N = mkTerm "behavior_N" ;
lin behavioral_A = mkTerm "behavioral_A" ;
lin behavioristic_A = mkTerm "behavioristic_A" ;
lin behaviour_N = mkTerm "behaviour_N" ;
lin behaviourism_N = mkTerm "behaviourism_N" ;
lin behaviourist_N = mkTerm "behaviourist_N" ;
lin behead_V2 = mkTerm "behead_V2" ;
lin behest_N = mkTerm "behest_N" ;
lin behind_Adv = mkTerm "behind_Adv" ;
lin behind_N = mkTerm "behind_N" ;
lin behindhand_A = mkTerm "behindhand_A" ;
lin behither_Prep = mkTerm "behither_Prep" ;
lin behold_V2 = mkTerm "behold_V2" ;
lin beholden_A = mkTerm "beholden_A" ;
lin beholder_N = mkTerm "beholder_N" ;
lin behove_V2 = mkTerm "behove_V2" ;
lin beige_A = mkTerm "beige_A" ;
lin beige_N = mkTerm "beige_N" ;
lin beijing_PN = mkTerm "beijing_PN" ;
lin being_A = mkTerm "being_A" ;
lin being_N = mkTerm "being_N" ;
lin beirut_PN = mkTerm "beirut_PN" ;
lin beith_PN = mkTerm "beith_PN" ;
lin bejewelled_A = mkTerm "bejewelled_A" ;
lin belabour_V2 = mkTerm "belabour_V2" ;
lin belated_A = mkTerm "belated_A" ;
lin belay_N = mkTerm "belay_N" ;
lin belay_V2 = mkTerm "belay_V2" ;
lin belaying_pin_N = mkTerm "belaying_pin_N" ;
lin belch_N = mkTerm "belch_N" ;
lin belch_V = mkTerm "belch_V" ;
lin belch_V2 = mkTerm "belch_V2" ;
lin belching_N = mkTerm "belching_N" ;
lin beldam_N = mkTerm "beldam_N" ;
lin beldame_N = mkTerm "beldame_N" ;
lin beleaguer_V2 = mkTerm "beleaguer_V2" ;
lin belem_PN = mkTerm "belem_PN" ;
lin belemnite_N = mkTerm "belemnite_N" ;
lin belemnitic_A = mkTerm "belemnitic_A" ;
lin belfast_PN = mkTerm "belfast_PN" ;
lin belfry_N = mkTerm "belfry_N" ;
lin belgian_A = mkTerm "belgian_A" ;
lin belgian_N = mkTerm "belgian_N" ;
lin belgium_PN = mkTerm "belgium_PN" ;
lin belgrade_PN = mkTerm "belgrade_PN" ;
lin belie_V2 = mkTerm "belie_V2" ;
lin belief_N = mkTerm "belief_N" ;
lin believable_A = mkTerm "believable_A" ;
lin believe_V = mkTerm "believe_V" ;
lin believe_V2 = mkTerm "believe_V2" ;
lin believe_VS = mkTerm "believe_VS" ;
lin believer_N = mkTerm "believer_N" ;
lin believing_N = mkTerm "believing_N" ;
lin belike_Adv = mkTerm "belike_Adv" ;
lin belinda_PN = mkTerm "belinda_PN" ;
lin belittle_V2 = mkTerm "belittle_V2" ;
lin belittling_A = mkTerm "belittling_A" ;
lin belittling_N = mkTerm "belittling_N" ;
lin bell_N = mkTerm "bell_N" ;
lin bell_V2 = mkTerm "bell_V2" ;
lin bell_bottomed_A = mkTerm "bell_bottomed_A" ;
lin bell_buoy_N = mkTerm "bell_buoy_N" ;
lin bell_flower_N = mkTerm "bell_flower_N" ;
lin bell_founder_N = mkTerm "bell_founder_N" ;
lin bell_foundry_N = mkTerm "bell_foundry_N" ;
lin bell_metal_N = mkTerm "bell_metal_N" ;
lin bell_push_N = mkTerm "bell_push_N" ;
lin bell_ringer_N = mkTerm "bell_ringer_N" ;
lin bell_tent_N = mkTerm "bell_tent_N" ;
lin bella_PN = mkTerm "bella_PN" ;
lin belladonna_N = mkTerm "belladonna_N" ;
lin bellarmine_N = mkTerm "bellarmine_N" ;
lin bellbird_N = mkTerm "bellbird_N" ;
lin bellboy_N = mkTerm "bellboy_N" ;
lin belle_N = mkTerm "belle_N" ;
lin belle_PN = mkTerm "belle_PN" ;
lin belletristic_A = mkTerm "belletristic_A" ;
lin bellhop_N = mkTerm "bellhop_N" ;
lin bellicose_A = mkTerm "bellicose_A" ;
lin bellicosity_N = mkTerm "bellicosity_N" ;
lin belligerence_N = mkTerm "belligerence_N" ;
lin belligerency_N = mkTerm "belligerency_N" ;
lin belligerent_A = mkTerm "belligerent_A" ;
lin belligerent_N = mkTerm "belligerent_N" ;
lin bellow_N = mkTerm "bellow_N" ;
lin bellow_V = mkTerm "bellow_V" ;
lin bellow_V2 = mkTerm "bellow_V2" ;
lin bellows_N = mkTerm "bellows_N" ;
lin bellpull_N = mkTerm "bellpull_N" ;
lin bellshill_PN = mkTerm "bellshill_PN" ;
lin bellwether_N = mkTerm "bellwether_N" ;
lin bellwort_N = mkTerm "bellwort_N" ;
lin belly_N = mkTerm "belly_N" ;
lin belly_V = mkTerm "belly_V" ;
lin belly_V2 = mkTerm "belly_V2" ;
lin bellyache_N = mkTerm "bellyache_N" ;
lin bellyache_V = mkTerm "bellyache_V" ;
lin bellyband_N = mkTerm "bellyband_N" ;
lin bellyflop_N = mkTerm "bellyflop_N" ;
lin bellyful_N = mkTerm "bellyful_N" ;
lin bellyland_V = mkTerm "bellyland_V" ;
lin bellylaugh_N = mkTerm "bellylaugh_N" ;
lin bellylaugh_V = mkTerm "bellylaugh_V" ;
lin bellyless_A = mkTerm "bellyless_A" ;
lin belo_horizonte_PN = mkTerm "belo_horizonte_PN" ;
lin belong_to_V2 = mkTerm "belong_to_V2" ;
lin belong_with_V2 = mkTerm "belong_with_V2" ;
lin belonging_N = mkTerm "belonging_N" ;
lin beloved_A = mkTerm "beloved_A" ;
lin beloved_N = mkTerm "beloved_N" ;
lin below_Adv = mkTerm "below_Adv" ;
lin below_Prep = mkTerm "below_Prep" ;
lin belowground_A = mkTerm "belowground_A" ;
lin belper_PN = mkTerm "belper_PN" ;
lin belt_N = mkTerm "belt_N" ;
lin belt_V2 = mkTerm "belt_V2" ;
lin belt_out_V2 = mkTerm "belt_out_V2" ;
lin belt_up_V = mkTerm "belt_up_V" ;
lin belting_N = mkTerm "belting_N" ;
lin beltlike_A = mkTerm "beltlike_A" ;
lin beltway_N = mkTerm "beltway_N" ;
lin beluga_N = mkTerm "beluga_N" ;
lin belvedere_N = mkTerm "belvedere_N" ;
lin bemoan_V2 = mkTerm "bemoan_V2" ;
lin bemused_A = mkTerm "bemused_A" ;
lin ben_N = mkTerm "ben_N" ;
lin ben_PN = mkTerm "ben_PN" ;
lin bench_N = mkTerm "bench_N" ;
lin benchmark_N = mkTerm "benchmark_N" ;
lin bend_N = mkTerm "bend_N" ;
lin bend_V = mkTerm "bend_V" ;
lin bend_V2 = mkTerm "bend_V2" ;
lin bend_down_V = mkTerm "bend_down_V" ;
lin bend_over_V = mkTerm "bend_over_V" ;
lin bend_over_backwards_V = mkTerm "bend_over_backwards_V" ;
lin bendability_N = mkTerm "bendability_N" ;
lin bendable_A = mkTerm "bendable_A" ;
lin bender_N = mkTerm "bender_N" ;
lin bending_N = mkTerm "bending_N" ;
lin beneath_Adv = mkTerm "beneath_Adv" ;
lin beneath_Prep = mkTerm "beneath_Prep" ;
lin benedick_N = mkTerm "benedick_N" ;
lin benedictine_A = mkTerm "benedictine_A" ;
lin benedictine_N = mkTerm "benedictine_N" ;
lin benediction_N = mkTerm "benediction_N" ;
lin benedictory_A = mkTerm "benedictory_A" ;
lin benefaction_N = mkTerm "benefaction_N" ;
lin benefactor_N = mkTerm "benefactor_N" ;
lin benefactress_N = mkTerm "benefactress_N" ;
lin benefic_A = mkTerm "benefic_A" ;
lin benefice_N = mkTerm "benefice_N" ;
lin beneficed_A = mkTerm "beneficed_A" ;
lin beneficence_N = mkTerm "beneficence_N" ;
lin beneficent_A = mkTerm "beneficent_A" ;
lin beneficial_A = mkTerm "beneficial_A" ;
lin beneficiary_A = mkTerm "beneficiary_A" ;
lin beneficiary_N = mkTerm "beneficiary_N" ;
lin benefit_N = mkTerm "benefit_N" ;
lin benefit_V = mkTerm "benefit_V" ;
lin benefit_V2 = mkTerm "benefit_V2" ;
lin benevolence_N = mkTerm "benevolence_N" ;
lin benevolent_A = mkTerm "benevolent_A" ;
lin bengali_A = mkTerm "bengali_A" ;
lin bengali_N = mkTerm "bengali_N" ;
lin benighted_A = mkTerm "benighted_A" ;
lin benign_A = mkTerm "benign_A" ;
lin benignant_A = mkTerm "benignant_A" ;
lin benignity_N = mkTerm "benignity_N" ;
lin benin_PN = mkTerm "benin_PN" ;
lin beninese_A = mkTerm "beninese_A" ;
lin beninese_N = mkTerm "beninese_N" ;
lin benison_N = mkTerm "benison_N" ;
lin benjamin_PN = mkTerm "benjamin_PN" ;
lin bennet_N = mkTerm "bennet_N" ;
lin benny_PN = mkTerm "benny_PN" ;
lin bennäs_PN = mkTerm "bennäs_PN" ;
lin bent_A = mkTerm "bent_A" ;
lin bent_N = mkTerm "bent_N" ;
lin benthic_A = mkTerm "benthic_A" ;
lin benthos_N = mkTerm "benthos_N" ;
lin bentonite_N = mkTerm "bentonite_N" ;
lin bentonitic_A = mkTerm "bentonitic_A" ;
lin bentwood_N = mkTerm "bentwood_N" ;
lin benumbed_A = mkTerm "benumbed_A" ;
lin benzedrine_N = mkTerm "benzedrine_N" ;
lin benzene_N = mkTerm "benzene_N" ;
lin benzenoid_A = mkTerm "benzenoid_A" ;
lin benzine_N = mkTerm "benzine_N" ;
lin benzoate_N = mkTerm "benzoate_N" ;
lin benzocaine_N = mkTerm "benzocaine_N" ;
lin benzodiazepine_N = mkTerm "benzodiazepine_N" ;
lin benzofuran_N = mkTerm "benzofuran_N" ;
lin benzoic_A = mkTerm "benzoic_A" ;
lin benzoin_N = mkTerm "benzoin_N" ;
lin benzol_N = mkTerm "benzol_N" ;
lin benzyl_N = mkTerm "benzyl_N" ;
lin benzylic_A = mkTerm "benzylic_A" ;
lin beograd_PN = mkTerm "beograd_PN" ;
lin bequeath_V2 = mkTerm "bequeath_V2" ;
lin bequest_N = mkTerm "bequest_N" ;
lin berate_V2 = mkTerm "berate_V2" ;
lin berating_N = mkTerm "berating_N" ;
lin bereave_V2 = mkTerm "bereave_V2" ;
lin bereaved_N = mkTerm "bereaved_N" ;
lin bereavement_N = mkTerm "bereavement_N" ;
lin bereft_A = mkTerm "bereft_A" ;
lin beret_N = mkTerm "beret_N" ;
lin berg_N = mkTerm "berg_N" ;
lin bergamo_PN = mkTerm "bergamo_PN" ;
lin bergamot_N = mkTerm "bergamot_N" ;
lin bergen_PN = mkTerm "bergen_PN" ;
lin bergenia_N = mkTerm "bergenia_N" ;
lin beri_beri_N = mkTerm "beri_beri_N" ;
lin berk_N = mkTerm "berk_N" ;
lin berkelium_N = mkTerm "berkelium_N" ;
lin berkhamsted_PN = mkTerm "berkhamsted_PN" ;
lin berkshire_PN = mkTerm "berkshire_PN" ;
lin berlin_N = mkTerm "berlin_N" ;
lin berlin_PN = mkTerm "berlin_PN" ;
lin berm_N = mkTerm "berm_N" ;
lin bermuda_PN = mkTerm "bermuda_PN" ;
lin bermudan_A = mkTerm "bermudan_A" ;
lin bermudan_N = mkTerm "bermudan_N" ;
lin bern_PN = mkTerm "bern_PN" ;
lin bernard_PN = mkTerm "bernard_PN" ;
lin bernie_PN = mkTerm "bernie_PN" ;
lin beroe_N = mkTerm "beroe_N" ;
lin berried_A = mkTerm "berried_A" ;
lin berry_N = mkTerm "berry_N" ;
lin berserk_A = mkTerm "berserk_A" ;
lin berserker_N = mkTerm "berserker_N" ;
lin bert_PN = mkTerm "bert_PN" ;
lin berth_N = mkTerm "berth_N" ;
lin berth_V = mkTerm "berth_V" ;
lin berth_V2 = mkTerm "berth_V2" ;
lin bertha_PN = mkTerm "bertha_PN" ;
lin bertie_PN = mkTerm "bertie_PN" ;
lin berwick_upon_tweed_PN = mkTerm "berwick_upon_tweed_PN" ;
lin beryl_N = mkTerm "beryl_N" ;
lin beryl_PN = mkTerm "beryl_PN" ;
lin beryllium_N = mkTerm "beryllium_N" ;
lin beseech_V2 = mkTerm "beseech_V2" ;
lin beseeching_A = mkTerm "beseeching_A" ;
lin beseem_V2 = mkTerm "beseem_V2" ;
lin beset_V2 = mkTerm "beset_V2" ;
lin beshrew_V2 = mkTerm "beshrew_V2" ;
lin beside_Prep = mkTerm "beside_Prep" ;
lin besides_Adv = mkTerm "besides_Adv" ;
lin besides_Prep = mkTerm "besides_Prep" ;
lin besiege_V2 = mkTerm "besiege_V2" ;
lin besieger_N = mkTerm "besieger_N" ;
lin besmear_V2 = mkTerm "besmear_V2" ;
lin besmirch_V2 = mkTerm "besmirch_V2" ;
lin besom_N = mkTerm "besom_N" ;
lin besotted_A = mkTerm "besotted_A" ;
lin bespangled_A = mkTerm "bespangled_A" ;
lin bespattered_A = mkTerm "bespattered_A" ;
lin bespeak_V2 = mkTerm "bespeak_V2" ;
lin bespectacled_A = mkTerm "bespectacled_A" ;
lin bespoke_A = mkTerm "bespoke_A" ;
lin besprent_A = mkTerm "besprent_A" ;
lin bess_PN = mkTerm "bess_PN" ;
lin bessie_PN = mkTerm "bessie_PN" ;
lin best_Adv = mkTerm "best_Adv" ;
lin best_N = mkTerm "best_N" ;
lin best_V2 = mkTerm "best_V2" ;
lin best_seller_N = mkTerm "best_seller_N" ;
lin bestial_A = mkTerm "bestial_A" ;
lin bestiality_N = mkTerm "bestiality_N" ;
lin bestiary_N = mkTerm "bestiary_N" ;
lin bestir_V2 = mkTerm "bestir_V2" ;
lin bestow_V2 = mkTerm "bestow_V2" ;
lin bestowal_N = mkTerm "bestowal_N" ;
lin bestrew_V2 = mkTerm "bestrew_V2" ;
lin bestride_V2 = mkTerm "bestride_V2" ;
lin bestselling_A = mkTerm "bestselling_A" ;
lin bestubbled_A = mkTerm "bestubbled_A" ;
lin bet_N = mkTerm "bet_N" ;
lin bet_V = mkTerm "bet_V" ;
lin bet_V2 = mkTerm "bet_V2" ;
lin bet_VS = mkTerm "bet_VS" ;
lin beta_A = mkTerm "beta_A" ;
lin beta_N = mkTerm "beta_N" ;
lin betaine_N = mkTerm "betaine_N" ;
lin betake_V2 = mkTerm "betake_V2" ;
lin betatron_N = mkTerm "betatron_N" ;
lin bete_noire_N = mkTerm "bete_noire_N" ;
lin betel_N = mkTerm "betel_N" ;
lin betel_nut_N = mkTerm "betel_nut_N" ;
lin beth_N = mkTerm "beth_N" ;
lin bethel_N = mkTerm "bethel_N" ;
lin bethink_V2 = mkTerm "bethink_V2" ;
lin bethune_PN = mkTerm "bethune_PN" ;
lin betide_V2 = mkTerm "betide_V2" ;
lin betimes_Adv = mkTerm "betimes_Adv" ;
lin betoken_V2 = mkTerm "betoken_V2" ;
lin betray_V2 = mkTerm "betray_V2" ;
lin betrayal_N = mkTerm "betrayal_N" ;
lin betrayer_N = mkTerm "betrayer_N" ;
lin betroth_V2 = mkTerm "betroth_V2" ;
lin betrothal_N = mkTerm "betrothal_N" ;
lin betrothedFem_N = mkTerm "betrothedFem_N" ;
lin betrothedMasc_N = mkTerm "betrothedMasc_N" ;
lin betsy_PN = mkTerm "betsy_PN" ;
lin better_A = mkTerm "better_A" ;
lin better_Adv = mkTerm "better_Adv" ;
lin better_N = mkTerm "better_N" ;
lin better_V2 = mkTerm "better_V2" ;
lin bettering_A = mkTerm "bettering_A" ;
lin betterment_N = mkTerm "betterment_N" ;
lin bettong_N = mkTerm "bettong_N" ;
lin bettor_N = mkTerm "bettor_N" ;
lin betty_PN = mkTerm "betty_PN" ;
lin betulaceous_A = mkTerm "betulaceous_A" ;
lin between_Adv = mkTerm "between_Adv" ;
lin betwixen_Prep = mkTerm "betwixen_Prep" ;
lin betwixt_Prep = mkTerm "betwixt_Prep" ;
lin bevatron_N = mkTerm "bevatron_N" ;
lin bevel_N = mkTerm "bevel_N" ;
lin bevel_V2 = mkTerm "bevel_V2" ;
lin beverage_N = mkTerm "beverage_N" ;
lin beverley_PN = mkTerm "beverley_PN" ;
lin bevy_N = mkTerm "bevy_N" ;
lin bewail_V2 = mkTerm "bewail_V2" ;
lin beware_V = mkTerm "beware_V" ;
lin beware_V2 = mkTerm "beware_V2" ;
lin bewdley_PN = mkTerm "bewdley_PN" ;
lin bewilder_V2 = mkTerm "bewilder_V2" ;
lin bewilderedly_Adv = mkTerm "bewilderedly_Adv" ;
lin bewildering_A = mkTerm "bewildering_A" ;
lin bewilderment_N = mkTerm "bewilderment_N" ;
lin bewitch_V2 = mkTerm "bewitch_V2" ;
lin bewitchery_N = mkTerm "bewitchery_N" ;
lin bewitching_A = mkTerm "bewitching_A" ;
lin bexhill_PN = mkTerm "bexhill_PN" ;
lin bexley_PN = mkTerm "bexley_PN" ;
lin bey_N = mkTerm "bey_N" ;
lin beyond_Adv = mkTerm "beyond_Adv" ;
lin beyond_Prep = mkTerm "beyond_Prep" ;
lin bezant_N = mkTerm "bezant_N" ;
lin bezel_N = mkTerm "bezel_N" ;
lin bezique_N = mkTerm "bezique_N" ;
lin bgcolor_N = mkTerm "bgcolor_N" ;
lin bhakti_N = mkTerm "bhakti_N" ;
lin bhang_N = mkTerm "bhang_N" ;
lin bhutan_PN = mkTerm "bhutan_PN" ;
lin bhutani_A = mkTerm "bhutani_A" ;
lin bhutani_N = mkTerm "bhutani_N" ;
lin bialy_N = mkTerm "bialy_N" ;
lin biannually_Adv = mkTerm "biannually_Adv" ;
lin bias_A = mkTerm "bias_A" ;
lin bias_N = mkTerm "bias_N" ;
lin bias_V2 = mkTerm "bias_V2" ;
lin biauricular_A = mkTerm "biauricular_A" ;
lin biaxial_A = mkTerm "biaxial_A" ;
lin bib_N = mkTerm "bib_N" ;
lin bib_V = mkTerm "bib_V" ;
lin bibbed_A = mkTerm "bibbed_A" ;
lin bible_N = mkTerm "bible_N" ;
lin bibless_A = mkTerm "bibless_A" ;
lin biblical_A = mkTerm "biblical_A" ;
lin bibliographer_N = mkTerm "bibliographer_N" ;
lin bibliographic_A = mkTerm "bibliographic_A" ;
lin bibliography_N = mkTerm "bibliography_N" ;
lin bibliolatrous_A = mkTerm "bibliolatrous_A" ;
lin bibliolatry_N = mkTerm "bibliolatry_N" ;
lin bibliomania_N = mkTerm "bibliomania_N" ;
lin bibliomaniacal_A = mkTerm "bibliomaniacal_A" ;
lin bibliophile_N = mkTerm "bibliophile_N" ;
lin bibliophilic_A = mkTerm "bibliophilic_A" ;
lin bibliopole_N = mkTerm "bibliopole_N" ;
lin bibliopolic_A = mkTerm "bibliopolic_A" ;
lin bibliotheca_N = mkTerm "bibliotheca_N" ;
lin bibliothecal_A = mkTerm "bibliothecal_A" ;
lin bibliotic_A = mkTerm "bibliotic_A" ;
lin bibliotics_N = mkTerm "bibliotics_N" ;
lin bibliotist_N = mkTerm "bibliotist_N" ;
lin bibulous_A = mkTerm "bibulous_A" ;
lin bicameral_A = mkTerm "bicameral_A" ;
lin bicapsular_A = mkTerm "bicapsular_A" ;
lin bicarbonate_N = mkTerm "bicarbonate_N" ;
lin bicentenary_N = mkTerm "bicentenary_N" ;
lin bicentennial_A = mkTerm "bicentennial_A" ;
lin bicentennial_N = mkTerm "bicentennial_N" ;
lin bicentric_A = mkTerm "bicentric_A" ;
lin bicephalous_A = mkTerm "bicephalous_A" ;
lin biceps_N = mkTerm "biceps_N" ;
lin bicester_PN = mkTerm "bicester_PN" ;
lin bichromate_N = mkTerm "bichromate_N" ;
lin bichromated_A = mkTerm "bichromated_A" ;
lin bicipital_A = mkTerm "bicipital_A" ;
lin bicker_N = mkTerm "bicker_N" ;
lin bicker_V = mkTerm "bicker_V" ;
lin bicolor_A = mkTerm "bicolor_A" ;
lin biconcave_A = mkTerm "biconcave_A" ;
lin biconvex_A = mkTerm "biconvex_A" ;
lin bicorn_A = mkTerm "bicorn_A" ;
lin bicorn_N = mkTerm "bicorn_N" ;
lin bicuspid_A = mkTerm "bicuspid_A" ;
lin bicycle_N = mkTerm "bicycle_N" ;
lin bicycle_V = mkTerm "bicycle_V" ;
lin bicyclic_A = mkTerm "bicyclic_A" ;
lin bicycling_N = mkTerm "bicycling_N" ;
lin bicylindrical_A = mkTerm "bicylindrical_A" ;
lin bid_N = mkTerm "bid_N" ;
lin bid_V = mkTerm "bid_V" ;
lin bid_V2 = mkTerm "bid_V2" ;
lin bid_up_V = mkTerm "bid_up_V" ;
lin biddable_A = mkTerm "biddable_A" ;
lin bidder_N = mkTerm "bidder_N" ;
lin bidding_N = mkTerm "bidding_N" ;
lin biddulph_PN = mkTerm "biddulph_PN" ;
lin bide_V2 = mkTerm "bide_V2" ;
lin bideford_PN = mkTerm "bideford_PN" ;
lin bidentate_A = mkTerm "bidentate_A" ;
lin bidet_N = mkTerm "bidet_N" ;
lin bidirectional_A = mkTerm "bidirectional_A" ;
lin bielefeld_PN = mkTerm "bielefeld_PN" ;
lin biennial_A = mkTerm "biennial_A" ;
lin biennial_N = mkTerm "biennial_N" ;
lin bier_N = mkTerm "bier_N" ;
lin biface_A = mkTerm "biface_A" ;
lin biff_N = mkTerm "biff_N" ;
lin biff_V2 = mkTerm "biff_V2" ;
lin bifid_A = mkTerm "bifid_A" ;
lin bifilar_A = mkTerm "bifilar_A" ;
lin biflagellate_A = mkTerm "biflagellate_A" ;
lin bifocal_A = mkTerm "bifocal_A" ;
lin bifocals_N = mkTerm "bifocals_N" ;
lin bifoliate_A = mkTerm "bifoliate_A" ;
lin biform_A = mkTerm "biform_A" ;
lin bifurcate_A = mkTerm "bifurcate_A" ;
lin bifurcate_V = mkTerm "bifurcate_V" ;
lin bifurcate_V2 = mkTerm "bifurcate_V2" ;
lin bifurcation_N = mkTerm "bifurcation_N" ;
lin big_A = mkTerm "big_A" ;
lin big_boned_A = mkTerm "big_boned_A" ;
lin big_up_V2 = mkTerm "big_up_V2" ;
lin bigamist_N = mkTerm "bigamist_N" ;
lin bigamous_A = mkTerm "bigamous_A" ;
lin bigamy_N = mkTerm "bigamy_N" ;
lin bigeminal_A = mkTerm "bigeminal_A" ;
lin bigeneric_A = mkTerm "bigeneric_A" ;
lin bigeye_N = mkTerm "bigeye_N" ;
lin biggin_N = mkTerm "biggin_N" ;
lin biggish_A = mkTerm "biggish_A" ;
lin biggleswade_PN = mkTerm "biggleswade_PN" ;
lin bighead_N = mkTerm "bighead_N" ;
lin bigheaded_A = mkTerm "bigheaded_A" ;
lin bigheartedness_N = mkTerm "bigheartedness_N" ;
lin bighorn_N = mkTerm "bighorn_N" ;
lin bight_N = mkTerm "bight_N" ;
lin bigmouthed_A = mkTerm "bigmouthed_A" ;
lin bignoniaceous_A = mkTerm "bignoniaceous_A" ;
lin bignoniad_N = mkTerm "bignoniad_N" ;
lin bigos_N = mkTerm "bigos_N" ;
lin bigot_N = mkTerm "bigot_N" ;
lin bigoted_A = mkTerm "bigoted_A" ;
lin bigotry_N = mkTerm "bigotry_N" ;
lin bigram_N = mkTerm "bigram_N" ;
lin bigwig_N = mkTerm "bigwig_N" ;
lin bijou_A = mkTerm "bijou_A" ;
lin bijou_N = mkTerm "bijou_N" ;
lin bike_N = mkTerm "bike_N" ;
lin bike_V = mkTerm "bike_V" ;
lin bikini_N = mkTerm "bikini_N" ;
lin bilabial_A = mkTerm "bilabial_A" ;
lin bilabial_N = mkTerm "bilabial_N" ;
lin bilabiate_A = mkTerm "bilabiate_A" ;
lin bilateral_A = mkTerm "bilateral_A" ;
lin bilateralism_N = mkTerm "bilateralism_N" ;
lin bilaterality_N = mkTerm "bilaterality_N" ;
lin bilbao_PN = mkTerm "bilbao_PN" ;
lin bilberry_N = mkTerm "bilberry_N" ;
lin bile_N = mkTerm "bile_N" ;
lin bile_duct_N = mkTerm "bile_duct_N" ;
lin bilge_N = mkTerm "bilge_N" ;
lin bilge_water_N = mkTerm "bilge_water_N" ;
lin bilgy_A = mkTerm "bilgy_A" ;
lin bilharzia_N = mkTerm "bilharzia_N" ;
lin biliary_A = mkTerm "biliary_A" ;
lin bilimbi_N = mkTerm "bilimbi_N" ;
lin bilinear_A = mkTerm "bilinear_A" ;
lin bilingual_A = mkTerm "bilingual_A" ;
lin bilingual_N = mkTerm "bilingual_N" ;
lin bilingualism_N = mkTerm "bilingualism_N" ;
lin bilious_A = mkTerm "bilious_A" ;
lin biliousness_N = mkTerm "biliousness_N" ;
lin bilirubin_N = mkTerm "bilirubin_N" ;
lin bilk_V2 = mkTerm "bilk_V2" ;
lin bill_N = mkTerm "bill_N" ;
lin bill_PN = mkTerm "bill_PN" ;
lin bill_V = mkTerm "bill_V" ;
lin bill_V2 = mkTerm "bill_V2" ;
lin bill_poster_N = mkTerm "bill_poster_N" ;
lin bill_sticker_N = mkTerm "bill_sticker_N" ;
lin billabong_N = mkTerm "billabong_N" ;
lin billboard_N = mkTerm "billboard_N" ;
lin billericay_PN = mkTerm "billericay_PN" ;
lin billet_N = mkTerm "billet_N" ;
lin billet_V2 = mkTerm "billet_V2" ;
lin billet_doux_N = mkTerm "billet_doux_N" ;
lin billfish_N = mkTerm "billfish_N" ;
lin billfold_N = mkTerm "billfold_N" ;
lin billhook_N = mkTerm "billhook_N" ;
lin billiard_A = mkTerm "billiard_A" ;
lin billiard_marker_N = mkTerm "billiard_marker_N" ;
lin billiard_player_N = mkTerm "billiard_player_N" ;
lin billiard_room_N = mkTerm "billiard_room_N" ;
lin billiard_table_N = mkTerm "billiard_table_N" ;
lin billiards_N = mkTerm "billiards_N" ;
lin billingsgate_N = mkTerm "billingsgate_N" ;
lin billington_PN = mkTerm "billington_PN" ;
lin billion_A = mkTerm "billion_A" ;
lin billion_N = mkTerm "billion_N" ;
lin billionaire_N = mkTerm "billionaire_N" ;
lin billionth_A = mkTerm "billionth_A" ;
lin billionth_N = mkTerm "billionth_N" ;
lin billow_N = mkTerm "billow_N" ;
lin billow_V = mkTerm "billow_V" ;
lin billowy_A = mkTerm "billowy_A" ;
lin billy_N = mkTerm "billy_N" ;
lin billy_PN = mkTerm "billy_PN" ;
lin billy_goat_N = mkTerm "billy_goat_N" ;
lin billy_ho_N = mkTerm "billy_ho_N" ;
lin billy_o_N = mkTerm "billy_o_N" ;
lin bilobate_A = mkTerm "bilobate_A" ;
lin bilocation_N = mkTerm "bilocation_N" ;
lin bilocular_A = mkTerm "bilocular_A" ;
lin biltong_N = mkTerm "biltong_N" ;
lin bimbo_N = mkTerm "bimbo_N" ;
lin bimester_N = mkTerm "bimester_N" ;
lin bimestrial_A = mkTerm "bimestrial_A" ;
lin bimetal_A = mkTerm "bimetal_A" ;
lin bimetal_N = mkTerm "bimetal_N" ;
lin bimetallic_A = mkTerm "bimetallic_A" ;
lin bimetallism_N = mkTerm "bimetallism_N" ;
lin bimetallist_N = mkTerm "bimetallist_N" ;
lin bimetallistic_A = mkTerm "bimetallistic_A" ;
lin bimillenial_A = mkTerm "bimillenial_A" ;
lin bimillennium_N = mkTerm "bimillennium_N" ;
lin bimodal_A = mkTerm "bimodal_A" ;
lin bimolecular_A = mkTerm "bimolecular_A" ;
lin bimonthly_A = mkTerm "bimonthly_A" ;
lin bimonthly_Adv = mkTerm "bimonthly_Adv" ;
lin bimonthly_N = mkTerm "bimonthly_N" ;
lin bimorphemic_A = mkTerm "bimorphemic_A" ;
lin bimotored_A = mkTerm "bimotored_A" ;
lin bin_N = mkTerm "bin_N" ;
lin binary_A = mkTerm "binary_A" ;
lin binary_N = mkTerm "binary_N" ;
lin binate_A = mkTerm "binate_A" ;
lin binaural_A = mkTerm "binaural_A" ;
lin bind_N = mkTerm "bind_N" ;
lin bind_V = mkTerm "bind_V" ;
lin bind_V2 = mkTerm "bind_V2" ;
lin bindable_A = mkTerm "bindable_A" ;
lin binder_N = mkTerm "binder_N" ;
lin bindery_N = mkTerm "bindery_N" ;
lin binding_A = mkTerm "binding_A" ;
lin binding_N = mkTerm "binding_N" ;
lin bindweed_N = mkTerm "bindweed_N" ;
lin bine_N = mkTerm "bine_N" ;
lin binge_N = mkTerm "binge_N" ;
lin bingley_PN = mkTerm "bingley_PN" ;
lin bingo_N = mkTerm "bingo_N" ;
lin binnacle_N = mkTerm "binnacle_N" ;
lin binocular_A = mkTerm "binocular_A" ;
lin binoculars_N = mkTerm "binoculars_N" ;
lin binomial_A = mkTerm "binomial_A" ;
lin binomial_N = mkTerm "binomial_N" ;
lin binturong_N = mkTerm "binturong_N" ;
lin binucleate_A = mkTerm "binucleate_A" ;
lin bio_N = mkTerm "bio_N" ;
lin bioassay_N = mkTerm "bioassay_N" ;
lin biocatalyst_N = mkTerm "biocatalyst_N" ;
lin biocatalytic_A = mkTerm "biocatalytic_A" ;
lin biochemical_A = mkTerm "biochemical_A" ;
lin biochemist_N = mkTerm "biochemist_N" ;
lin biochemistry_N = mkTerm "biochemistry_N" ;
lin biochip_N = mkTerm "biochip_N" ;
lin bioclimatic_A = mkTerm "bioclimatic_A" ;
lin bioclimatology_N = mkTerm "bioclimatology_N" ;
lin biodegradable_A = mkTerm "biodegradable_A" ;
lin biodiversity_N = mkTerm "biodiversity_N" ;
lin bioelectricity_N = mkTerm "bioelectricity_N" ;
lin bioethics_N = mkTerm "bioethics_N" ;
lin biofeedback_N = mkTerm "biofeedback_N" ;
lin biogenesis_N = mkTerm "biogenesis_N" ;
lin biogenetic_A = mkTerm "biogenetic_A" ;
lin biogenic_A = mkTerm "biogenic_A" ;
lin biogenous_A = mkTerm "biogenous_A" ;
lin biogeographic_A = mkTerm "biogeographic_A" ;
lin biogeography_N = mkTerm "biogeography_N" ;
lin biograph_N = mkTerm "biograph_N" ;
lin biographer_N = mkTerm "biographer_N" ;
lin biographic_A = mkTerm "biographic_A" ;
lin biographical_A = mkTerm "biographical_A" ;
lin biography_N = mkTerm "biography_N" ;
lin biohazard_N = mkTerm "biohazard_N" ;
lin biological_A = mkTerm "biological_A" ;
lin biologism_N = mkTerm "biologism_N" ;
lin biologist_N = mkTerm "biologist_N" ;
lin biologistic_A = mkTerm "biologistic_A" ;
lin biology_N = mkTerm "biology_N" ;
lin bioluminescence_N = mkTerm "bioluminescence_N" ;
lin bioluminescent_A = mkTerm "bioluminescent_A" ;
lin biomass_N = mkTerm "biomass_N" ;
lin biome_N = mkTerm "biome_N" ;
lin biomedical_A = mkTerm "biomedical_A" ;
lin biomedicine_N = mkTerm "biomedicine_N" ;
lin biometrics_N = mkTerm "biometrics_N" ;
lin bionic_A = mkTerm "bionic_A" ;
lin bionics_N = mkTerm "bionics_N" ;
lin biont_N = mkTerm "biont_N" ;
lin biophysicist_N = mkTerm "biophysicist_N" ;
lin biophysics_N = mkTerm "biophysics_N" ;
lin biopiracy_N = mkTerm "biopiracy_N" ;
lin biopsy_N = mkTerm "biopsy_N" ;
lin bioremediation_N = mkTerm "bioremediation_N" ;
lin biosafety_N = mkTerm "biosafety_N" ;
lin bioscope_N = mkTerm "bioscope_N" ;
lin biosphere_N = mkTerm "biosphere_N" ;
lin biosynthesis_N = mkTerm "biosynthesis_N" ;
lin biosynthetic_A = mkTerm "biosynthetic_A" ;
lin biosystematic_A = mkTerm "biosystematic_A" ;
lin biosystematics_N = mkTerm "biosystematics_N" ;
lin biota_N = mkTerm "biota_N" ;
lin biotechnology_N = mkTerm "biotechnology_N" ;
lin bioterrorism_N = mkTerm "bioterrorism_N" ;
lin biotic_A = mkTerm "biotic_A" ;
lin biotin_N = mkTerm "biotin_N" ;
lin biotite_N = mkTerm "biotite_N" ;
lin biotitic_A = mkTerm "biotitic_A" ;
lin biotype_N = mkTerm "biotype_N" ;
lin biotypic_A = mkTerm "biotypic_A" ;
lin bioweapon_N = mkTerm "bioweapon_N" ;
lin biparous_A = mkTerm "biparous_A" ;
lin bipartisan_A = mkTerm "bipartisan_A" ;
lin bipartite_A = mkTerm "bipartite_A" ;
lin biped_N = mkTerm "biped_N" ;
lin bipedal_A = mkTerm "bipedal_A" ;
lin bipedalism_N = mkTerm "bipedalism_N" ;
lin bipinnate_A = mkTerm "bipinnate_A" ;
lin bipinnatifid_A = mkTerm "bipinnatifid_A" ;
lin biplane_N = mkTerm "biplane_N" ;
lin bipolar_A = mkTerm "bipolar_A" ;
lin biprism_N = mkTerm "biprism_N" ;
lin biquadrate_N = mkTerm "biquadrate_N" ;
lin biquadratic_A = mkTerm "biquadratic_A" ;
lin biquadratic_N = mkTerm "biquadratic_N" ;
lin biracial_A = mkTerm "biracial_A" ;
lin biradial_A = mkTerm "biradial_A" ;
lin birch_A = mkTerm "birch_A" ;
lin birch_N = mkTerm "birch_N" ;
lin birch_V2 = mkTerm "birch_V2" ;
lin birch_rod_N = mkTerm "birch_rod_N" ;
lin bird's_eye_A = mkTerm "bird's_eye_A" ;
lin bird_N = mkTerm "bird_N" ;
lin bird_fancier_N = mkTerm "bird_fancier_N" ;
lin birdbath_N = mkTerm "birdbath_N" ;
lin birdcage_N = mkTerm "birdcage_N" ;
lin birdcall_N = mkTerm "birdcall_N" ;
lin birdhouse_N = mkTerm "birdhouse_N" ;
lin birdie_N = mkTerm "birdie_N" ;
lin birdlime_N = mkTerm "birdlime_N" ;
lin birdnesting_N = mkTerm "birdnesting_N" ;
lin birdwatcher_N = mkTerm "birdwatcher_N" ;
lin birefringent_A = mkTerm "birefringent_A" ;
lin biretta_N = mkTerm "biretta_N" ;
lin birkenhead_PN = mkTerm "birkenhead_PN" ;
lin birling_N = mkTerm "birling_N" ;
lin biro_N = mkTerm "biro_N" ;
lin birr_N = mkTerm "birr_N" ;
lin birstall_PN = mkTerm "birstall_PN" ;
lin birth_N = mkTerm "birth_N" ;
lin birth_control_N = mkTerm "birth_control_N" ;
lin birthday_N = mkTerm "birthday_N" ;
lin birthmark_N = mkTerm "birthmark_N" ;
lin birthplace_N = mkTerm "birthplace_N" ;
lin birthrate_N = mkTerm "birthrate_N" ;
lin birthright_N = mkTerm "birthright_N" ;
lin birthwort_N = mkTerm "birthwort_N" ;
lin birtley_PN = mkTerm "birtley_PN" ;
lin biryani_N = mkTerm "biryani_N" ;
lin biscuit_N = mkTerm "biscuit_N" ;
lin bise_N = mkTerm "bise_N" ;
lin bisect_V2 = mkTerm "bisect_V2" ;
lin bisection_N = mkTerm "bisection_N" ;
lin bisectional_A = mkTerm "bisectional_A" ;
lin biserrate_A = mkTerm "biserrate_A" ;
lin bisexual_A = mkTerm "bisexual_A" ;
lin bisexual_N = mkTerm "bisexual_N" ;
lin bisexuality_N = mkTerm "bisexuality_N" ;
lin bishop's_cleeve_PN = mkTerm "bishop's_cleeve_PN" ;
lin bishop's_stortford_PN = mkTerm "bishop's_stortford_PN" ;
lin bishop_N = mkTerm "bishop_N" ;
lin bishop_auckland_PN = mkTerm "bishop_auckland_PN" ;
lin bishopbriggs_PN = mkTerm "bishopbriggs_PN" ;
lin bishopric_N = mkTerm "bishopric_N" ;
lin bishopry_N = mkTerm "bishopry_N" ;
lin bismuth_N = mkTerm "bismuth_N" ;
lin bismuthal_A = mkTerm "bismuthal_A" ;
lin bismuthic_A = mkTerm "bismuthic_A" ;
lin bison_N = mkTerm "bison_N" ;
lin bisontine_A = mkTerm "bisontine_A" ;
lin bisque_N = mkTerm "bisque_N" ;
lin bister_N = mkTerm "bister_N" ;
lin bistered_A = mkTerm "bistered_A" ;
lin bistro_N = mkTerm "bistro_N" ;
lin bistroic_A = mkTerm "bistroic_A" ;
lin bit_N = mkTerm "bit_N" ;
lin bitartrate_N = mkTerm "bitartrate_N" ;
lin bitch_N = mkTerm "bitch_N" ;
lin bitch_V = mkTerm "bitch_V" ;
lin bitch_up_V2 = mkTerm "bitch_up_V2" ;
lin bitchery_N = mkTerm "bitchery_N" ;
lin bitchy_A = mkTerm "bitchy_A" ;
lin bite_N = mkTerm "bite_N" ;
lin bite_V = mkTerm "bite_V" ;
lin bite_V2 = mkTerm "bite_V2" ;
lin biter_N = mkTerm "biter_N" ;
lin bitewing_N = mkTerm "bitewing_N" ;
lin biting_A = mkTerm "biting_A" ;
lin bitmap_N = mkTerm "bitmap_N" ;
lin bitok_N = mkTerm "bitok_N" ;
lin bitter_A = mkTerm "bitter_A" ;
lin bitter_N = mkTerm "bitter_N" ;
lin bitter_sweet_A = mkTerm "bitter_sweet_A" ;
lin bittercress_N = mkTerm "bittercress_N" ;
lin bitterish_A = mkTerm "bitterish_A" ;
lin bittern_N = mkTerm "bittern_N" ;
lin bitterness_N = mkTerm "bitterness_N" ;
lin bitternut_N = mkTerm "bitternut_N" ;
lin bitterroot_N = mkTerm "bitterroot_N" ;
lin bitters_N = mkTerm "bitters_N" ;
lin bittersweet_N = mkTerm "bittersweet_N" ;
lin bitthead_N = mkTerm "bitthead_N" ;
lin bitty_A = mkTerm "bitty_A" ;
lin bitumastic_N = mkTerm "bitumastic_N" ;
lin bitumen_N = mkTerm "bitumen_N" ;
lin bituminoid_A = mkTerm "bituminoid_A" ;
lin bituminous_A = mkTerm "bituminous_A" ;
lin bivalent_A = mkTerm "bivalent_A" ;
lin bivalve_A = mkTerm "bivalve_A" ;
lin bivalve_N = mkTerm "bivalve_N" ;
lin bivariate_A = mkTerm "bivariate_A" ;
lin bivouac_N = mkTerm "bivouac_N" ;
lin bivouac_V = mkTerm "bivouac_V" ;
lin biweekly_N = mkTerm "biweekly_N" ;
lin biz_N = mkTerm "biz_N" ;
lin bizarre_A = mkTerm "bizarre_A" ;
lin bizonal_A = mkTerm "bizonal_A" ;
lin blab_V = mkTerm "blab_V" ;
lin blab_V2 = mkTerm "blab_V2" ;
lin blabber_V = mkTerm "blabber_V" ;
lin blabber_V2 = mkTerm "blabber_V2" ;
lin blabbermouth_N = mkTerm "blabbermouth_N" ;
lin blabbermouthed_A = mkTerm "blabbermouthed_A" ;
lin black_A = mkTerm "black_A" ;
lin black_N = mkTerm "black_N" ;
lin black_V2 = mkTerm "black_V2" ;
lin black_beetle_N = mkTerm "black_beetle_N" ;
lin black_lead_N = mkTerm "black_lead_N" ;
lin black_lead_V2 = mkTerm "black_lead_V2" ;
lin black_out_V = mkTerm "black_out_V" ;
lin blackamoor_N = mkTerm "blackamoor_N" ;
lin blackball_V2 = mkTerm "blackball_V2" ;
lin blackberry_N = mkTerm "blackberry_N" ;
lin blackbird_N = mkTerm "blackbird_N" ;
lin blackboard_N = mkTerm "blackboard_N" ;
lin blackbuck_N = mkTerm "blackbuck_N" ;
lin blackburn_PN = mkTerm "blackburn_PN" ;
lin blackcap_N = mkTerm "blackcap_N" ;
lin blackcock_N = mkTerm "blackcock_N" ;
lin blackcurrant_N = mkTerm "blackcurrant_N" ;
lin blacken_V = mkTerm "blacken_V" ;
lin blacken_V2 = mkTerm "blacken_V2" ;
lin blackening_N = mkTerm "blackening_N" ;
lin blackface_N = mkTerm "blackface_N" ;
lin blackfish_N = mkTerm "blackfish_N" ;
lin blackfly_N = mkTerm "blackfly_N" ;
lin blackguard_N = mkTerm "blackguard_N" ;
lin blackguard_V2 = mkTerm "blackguard_V2" ;
lin blackguardly_A = mkTerm "blackguardly_A" ;
lin blackhall_PN = mkTerm "blackhall_PN" ;
lin blackhead_N = mkTerm "blackhead_N" ;
lin blackheart_N = mkTerm "blackheart_N" ;
lin blacking_N = mkTerm "blacking_N" ;
lin blackish_A = mkTerm "blackish_A" ;
lin blackjack_N = mkTerm "blackjack_N" ;
lin blackleg_N = mkTerm "blackleg_N" ;
lin blackleg_V = mkTerm "blackleg_V" ;
lin blackleg_V2 = mkTerm "blackleg_V2" ;
lin blacklist_N = mkTerm "blacklist_N" ;
lin blacklist_V2 = mkTerm "blacklist_V2" ;
lin blackmail_N = mkTerm "blackmail_N" ;
lin blackmail_V2 = mkTerm "blackmail_V2" ;
lin blackmailer_N = mkTerm "blackmailer_N" ;
lin blackness_N = mkTerm "blackness_N" ;
lin blackout_N = mkTerm "blackout_N" ;
lin blackpoll_N = mkTerm "blackpoll_N" ;
lin blackpool_PN = mkTerm "blackpool_PN" ;
lin blackshirt_N = mkTerm "blackshirt_N" ;
lin blacksmith_N = mkTerm "blacksmith_N" ;
lin blacksnake_N = mkTerm "blacksnake_N" ;
lin blackthorn_N = mkTerm "blackthorn_N" ;
lin blacktop_N = mkTerm "blacktop_N" ;
lin blackwash_N = mkTerm "blackwash_N" ;
lin blackwater_A = mkTerm "blackwater_A" ;
lin blackwater_N = mkTerm "blackwater_N" ;
lin blackwood_N = mkTerm "blackwood_N" ;
lin blackwood_PN = mkTerm "blackwood_PN" ;
lin bladder_N = mkTerm "bladder_N" ;
lin bladderpod_N = mkTerm "bladderpod_N" ;
lin bladderwort_N = mkTerm "bladderwort_N" ;
lin bladderwrack_N = mkTerm "bladderwrack_N" ;
lin bladdery_A = mkTerm "bladdery_A" ;
lin blade_N = mkTerm "blade_N" ;
lin bladed_A = mkTerm "bladed_A" ;
lin blae_A = mkTerm "blae_A" ;
lin blaeberry_N = mkTerm "blaeberry_N" ;
lin blaenau_ffestiniog_PN = mkTerm "blaenau_ffestiniog_PN" ;
lin blaenavon_PN = mkTerm "blaenavon_PN" ;
lin blaengwrach_PN = mkTerm "blaengwrach_PN" ;
lin blah_N = mkTerm "blah_N" ;
lin blahs_N = mkTerm "blahs_N" ;
lin blain_N = mkTerm "blain_N" ;
lin blaina_PN = mkTerm "blaina_PN" ;
lin blairgowrie_PN = mkTerm "blairgowrie_PN" ;
lin blame_N = mkTerm "blame_N" ;
lin blame_V = mkTerm "blame_V" ;
lin blame_V2 = mkTerm "blame_V2" ;
lin blameless_A = mkTerm "blameless_A" ;
lin blamelessness_N = mkTerm "blamelessness_N" ;
lin blameworthiness_N = mkTerm "blameworthiness_N" ;
lin blameworthy_A = mkTerm "blameworthy_A" ;
lin blanc_N = mkTerm "blanc_N" ;
lin blanch_V = mkTerm "blanch_V" ;
lin blanch_V2 = mkTerm "blanch_V2" ;
lin blancmange_N = mkTerm "blancmange_N" ;
lin bland_A = mkTerm "bland_A" ;
lin blandishment_N = mkTerm "blandishment_N" ;
lin blandness_N = mkTerm "blandness_N" ;
lin blank_A = mkTerm "blank_A" ;
lin blank_N = mkTerm "blank_N" ;
lin blank_out_V = mkTerm "blank_out_V" ;
lin blank_out_V2 = mkTerm "blank_out_V2" ;
lin blanket_N = mkTerm "blanket_N" ;
lin blanket_V2 = mkTerm "blanket_V2" ;
lin blankness_N = mkTerm "blankness_N" ;
lin blanquillo_N = mkTerm "blanquillo_N" ;
lin blantyre_PN = mkTerm "blantyre_PN" ;
lin blare_N = mkTerm "blare_N" ;
lin blare_V = mkTerm "blare_V" ;
lin blare_V2 = mkTerm "blare_V2" ;
lin blare_out_V = mkTerm "blare_out_V" ;
lin blarney_N = mkTerm "blarney_N" ;
lin blase_A = mkTerm "blase_A" ;
lin blaspheme_V = mkTerm "blaspheme_V" ;
lin blaspheme_V2 = mkTerm "blaspheme_V2" ;
lin blasphemer_N = mkTerm "blasphemer_N" ;
lin blasphemous_A = mkTerm "blasphemous_A" ;
lin blasphemy_N = mkTerm "blasphemy_N" ;
lin blast_N = mkTerm "blast_N" ;
lin blast_V = mkTerm "blast_V" ;
lin blast_V2 = mkTerm "blast_V2" ;
lin blast_away_V = mkTerm "blast_away_V" ;
lin blast_furnace_N = mkTerm "blast_furnace_N" ;
lin blast_off_N = mkTerm "blast_off_N" ;
lin blast_off_V = mkTerm "blast_off_V" ;
lin blastema_N = mkTerm "blastema_N" ;
lin blastemal_A = mkTerm "blastemal_A" ;
lin blaster_N = mkTerm "blaster_N" ;
lin blastocoel_N = mkTerm "blastocoel_N" ;
lin blastocoelic_A = mkTerm "blastocoelic_A" ;
lin blastocyst_N = mkTerm "blastocyst_N" ;
lin blastocyte_N = mkTerm "blastocyte_N" ;
lin blastoderm_N = mkTerm "blastoderm_N" ;
lin blastodermatic_A = mkTerm "blastodermatic_A" ;
lin blastogenesis_N = mkTerm "blastogenesis_N" ;
lin blastogenetic_A = mkTerm "blastogenetic_A" ;
lin blastoma_N = mkTerm "blastoma_N" ;
lin blastomere_N = mkTerm "blastomere_N" ;
lin blastomeric_A = mkTerm "blastomeric_A" ;
lin blastomycete_N = mkTerm "blastomycete_N" ;
lin blastomycosis_N = mkTerm "blastomycosis_N" ;
lin blastomycotic_A = mkTerm "blastomycotic_A" ;
lin blastoporal_A = mkTerm "blastoporal_A" ;
lin blastopore_N = mkTerm "blastopore_N" ;
lin blastospheric_A = mkTerm "blastospheric_A" ;
lin blastula_N = mkTerm "blastula_N" ;
lin blatancy_N = mkTerm "blatancy_N" ;
lin blatant_A = mkTerm "blatant_A" ;
lin blather_N = mkTerm "blather_N" ;
lin blather_V = mkTerm "blather_V" ;
lin blaxploitation_N = mkTerm "blaxploitation_N" ;
lin blaze_N = mkTerm "blaze_N" ;
lin blaze_V = mkTerm "blaze_V" ;
lin blaze_V2 = mkTerm "blaze_V2" ;
lin blaze_away_V = mkTerm "blaze_away_V" ;
lin blazer_N = mkTerm "blazer_N" ;
lin blazon_N = mkTerm "blazon_N" ;
lin blazon_V2 = mkTerm "blazon_V2" ;
lin blazonry_N = mkTerm "blazonry_N" ;
lin bldg_PN = mkTerm "bldg_PN" ;
lin bldgs_PN = mkTerm "bldgs_PN" ;
lin bleach_N = mkTerm "bleach_N" ;
lin bleach_V = mkTerm "bleach_V" ;
lin bleach_V2 = mkTerm "bleach_V2" ;
lin bleacher_N = mkTerm "bleacher_N" ;
lin bleachers_N = mkTerm "bleachers_N" ;
lin bleaching_powder_N = mkTerm "bleaching_powder_N" ;
lin bleak_A = mkTerm "bleak_A" ;
lin bleakness_N = mkTerm "bleakness_N" ;
lin bleary_A = mkTerm "bleary_A" ;
lin bleary_eyed_A = mkTerm "bleary_eyed_A" ;
lin bleat_N = mkTerm "bleat_N" ;
lin bleat_V = mkTerm "bleat_V" ;
lin bleat_V2 = mkTerm "bleat_V2" ;
lin blebbed_A = mkTerm "blebbed_A" ;
lin blebby_A = mkTerm "blebby_A" ;
lin bleed_V = mkTerm "bleed_V" ;
lin bleed_V2 = mkTerm "bleed_V2" ;
lin bleed_VS = mkTerm "bleed_VS" ;
lin bleed_off_V = mkTerm "bleed_off_V" ;
lin bleeding_N = mkTerm "bleeding_N" ;
lin bleep_N = mkTerm "bleep_N" ;
lin bleep_V = mkTerm "bleep_V" ;
lin blemish_N = mkTerm "blemish_N" ;
lin blemish_V2 = mkTerm "blemish_V2" ;
lin blench_V = mkTerm "blench_V" ;
lin blend_N = mkTerm "blend_N" ;
lin blend_V = mkTerm "blend_V" ;
lin blend_V2 = mkTerm "blend_V2" ;
lin blender_N = mkTerm "blender_N" ;
lin blenny_N = mkTerm "blenny_N" ;
lin blepharism_N = mkTerm "blepharism_N" ;
lin blepharitis_N = mkTerm "blepharitis_N" ;
lin blepharospasm_N = mkTerm "blepharospasm_N" ;
lin bless_V2 = mkTerm "bless_V2" ;
lin blessedly_Adv = mkTerm "blessedly_Adv" ;
lin blessedness_N = mkTerm "blessedness_N" ;
lin blessing_N = mkTerm "blessing_N" ;
lin bletchley_PN = mkTerm "bletchley_PN" ;
lin blether_N = mkTerm "blether_N" ;
lin bletia_N = mkTerm "bletia_N" ;
lin bleu_N = mkTerm "bleu_N" ;
lin blewits_N = mkTerm "blewits_N" ;
lin blidworth_PN = mkTerm "blidworth_PN" ;
lin blight_N = mkTerm "blight_N" ;
lin blight_V2 = mkTerm "blight_V2" ;
lin blighter_N = mkTerm "blighter_N" ;
lin blighty_N = mkTerm "blighty_N" ;
lin blimp_N = mkTerm "blimp_N" ;
lin blimpish_A = mkTerm "blimpish_A" ;
lin blind_A = mkTerm "blind_A" ;
lin blind_N = mkTerm "blind_N" ;
lin blind_V2 = mkTerm "blind_V2" ;
lin blindfold_A = mkTerm "blindfold_A" ;
lin blindfold_N = mkTerm "blindfold_N" ;
lin blindfold_V2 = mkTerm "blindfold_V2" ;
lin blindman's_buff_N = mkTerm "blindman's_buff_N" ;
lin blindness_N = mkTerm "blindness_N" ;
lin blindworm_N = mkTerm "blindworm_N" ;
lin bling_N = mkTerm "bling_N" ;
lin blini_N = mkTerm "blini_N" ;
lin blink_N = mkTerm "blink_N" ;
lin blink_V = mkTerm "blink_V" ;
lin blink_V2 = mkTerm "blink_V2" ;
lin blinker_N = mkTerm "blinker_N" ;
lin blinks_N = mkTerm "blinks_N" ;
lin blintz_N = mkTerm "blintz_N" ;
lin blip_N = mkTerm "blip_N" ;
lin bliss_N = mkTerm "bliss_N" ;
lin bliss_out_V = mkTerm "bliss_out_V" ;
lin blissful_A = mkTerm "blissful_A" ;
lin blister_N = mkTerm "blister_N" ;
lin blister_V = mkTerm "blister_V" ;
lin blister_V2 = mkTerm "blister_V2" ;
lin blithe_A = mkTerm "blithe_A" ;
lin blithering_A = mkTerm "blithering_A" ;
lin blithesome_A = mkTerm "blithesome_A" ;
lin blitz_N = mkTerm "blitz_N" ;
lin blitz_V2 = mkTerm "blitz_V2" ;
lin blizzard_N = mkTerm "blizzard_N" ;
lin bloat_N = mkTerm "bloat_N" ;
lin bloated_A = mkTerm "bloated_A" ;
lin bloater_N = mkTerm "bloater_N" ;
lin blob_N = mkTerm "blob_N" ;
lin bloc_N = mkTerm "bloc_N" ;
lin block_N = mkTerm "block_N" ;
lin block_V2 = mkTerm "block_V2" ;
lin block_in_V2 = mkTerm "block_in_V2" ;
lin block_off_V2 = mkTerm "block_off_V2" ;
lin block_out_V2 = mkTerm "block_out_V2" ;
lin block_up_V2 = mkTerm "block_up_V2" ;
lin blockade_N = mkTerm "blockade_N" ;
lin blockade_V2 = mkTerm "blockade_V2" ;
lin blockade_runner_N = mkTerm "blockade_runner_N" ;
lin blockading_A = mkTerm "blockading_A" ;
lin blockage_N = mkTerm "blockage_N" ;
lin blockbuster_N = mkTerm "blockbuster_N" ;
lin blocker_N = mkTerm "blocker_N" ;
lin blockhead_N = mkTerm "blockhead_N" ;
lin blockheaded_A = mkTerm "blockheaded_A" ;
lin blockhouse_N = mkTerm "blockhouse_N" ;
lin blocking_N = mkTerm "blocking_N" ;
lin blockish_A = mkTerm "blockish_A" ;
lin blog_N = mkTerm "blog_N" ;
lin blogger_N = mkTerm "blogger_N" ;
lin bloke_N = mkTerm "bloke_N" ;
lin blolly_N = mkTerm "blolly_N" ;
lin blond_A = mkTerm "blond_A" ;
lin blonde_A = mkTerm "blonde_A" ;
lin blonde_N = mkTerm "blonde_N" ;
lin blood_N = mkTerm "blood_N" ;
lin blood_V2 = mkTerm "blood_V2" ;
lin blood_bath_N = mkTerm "blood_bath_N" ;
lin blood_donor_N = mkTerm "blood_donor_N" ;
lin blood_group_N = mkTerm "blood_group_N" ;
lin blood_heat_N = mkTerm "blood_heat_N" ;
lin blood_letting_N = mkTerm "blood_letting_N" ;
lin blood_money_N = mkTerm "blood_money_N" ;
lin blood_poisoning_N = mkTerm "blood_poisoning_N" ;
lin blood_pressure_N = mkTerm "blood_pressure_N" ;
lin blood_relation_N = mkTerm "blood_relation_N" ;
lin blood_transfusion_N = mkTerm "blood_transfusion_N" ;
lin blood_type_N = mkTerm "blood_type_N" ;
lin blood_vessel_N = mkTerm "blood_vessel_N" ;
lin bloodberry_N = mkTerm "bloodberry_N" ;
lin bloodcurdling_A = mkTerm "bloodcurdling_A" ;
lin bloodguilt_N = mkTerm "bloodguilt_N" ;
lin bloodguilty_A = mkTerm "bloodguilty_A" ;
lin bloodhound_N = mkTerm "bloodhound_N" ;
lin bloodiness_N = mkTerm "bloodiness_N" ;
lin bloodleaf_N = mkTerm "bloodleaf_N" ;
lin bloodless_A = mkTerm "bloodless_A" ;
lin bloodlust_N = mkTerm "bloodlust_N" ;
lin bloodmobile_N = mkTerm "bloodmobile_N" ;
lin bloodroot_N = mkTerm "bloodroot_N" ;
lin bloodshed_N = mkTerm "bloodshed_N" ;
lin bloodshot_A = mkTerm "bloodshot_A" ;
lin bloodstain_N = mkTerm "bloodstain_N" ;
lin bloodstained_A = mkTerm "bloodstained_A" ;
lin bloodstock_N = mkTerm "bloodstock_N" ;
lin bloodstone_N = mkTerm "bloodstone_N" ;
lin bloodstream_N = mkTerm "bloodstream_N" ;
lin bloodsucker_N = mkTerm "bloodsucker_N" ;
lin bloodsucking_A = mkTerm "bloodsucking_A" ;
lin bloodthirstiness_N = mkTerm "bloodthirstiness_N" ;
lin bloodthirsty_A = mkTerm "bloodthirsty_A" ;
lin bloodworm_N = mkTerm "bloodworm_N" ;
lin bloodwort_N = mkTerm "bloodwort_N" ;
lin bloody_A = mkTerm "bloody_A" ;
lin bloody_Adv = mkTerm "bloody_Adv" ;
lin bloody_minded_A = mkTerm "bloody_minded_A" ;
lin bloom_N = mkTerm "bloom_N" ;
lin bloom_V = mkTerm "bloom_V" ;
lin bloomer_N = mkTerm "bloomer_N" ;
lin bloomers_N = mkTerm "bloomers_N" ;
lin blooming_N = mkTerm "blooming_N" ;
lin blossom_N = mkTerm "blossom_N" ;
lin blossom_V = mkTerm "blossom_V" ;
lin blossoming_N = mkTerm "blossoming_N" ;
lin blot_N = mkTerm "blot_N" ;
lin blot_V2 = mkTerm "blot_V2" ;
lin blot_out_V = mkTerm "blot_out_V" ;
lin blotch_N = mkTerm "blotch_N" ;
lin blotched_A = mkTerm "blotched_A" ;
lin blotchy_A = mkTerm "blotchy_A" ;
lin blotter_N = mkTerm "blotter_N" ;
lin blotting_paper_N = mkTerm "blotting_paper_N" ;
lin blotto_A = mkTerm "blotto_A" ;
lin blouse_N = mkTerm "blouse_N" ;
lin blow_N = mkTerm "blow_N" ;
lin blow_V = mkTerm "blow_V" ;
lin blow_V2 = mkTerm "blow_V2" ;
lin blow_away_V = mkTerm "blow_away_V" ;
lin blow_away_V2 = mkTerm "blow_away_V2" ;
lin blow_down_V2 = mkTerm "blow_down_V2" ;
lin blow_dry_V2 = mkTerm "blow_dry_V2" ;
lin blow_in_V = mkTerm "blow_in_V" ;
lin blow_off_V = mkTerm "blow_off_V" ;
lin blow_off_V2 = mkTerm "blow_off_V2" ;
lin blow_out_V2 = mkTerm "blow_out_V2" ;
lin blow_over_V = mkTerm "blow_over_V" ;
lin blow_up_N = mkTerm "blow_up_N" ;
lin blow_up_V = mkTerm "blow_up_V" ;
lin blow_up_V2 = mkTerm "blow_up_V2" ;
lin blowback_N = mkTerm "blowback_N" ;
lin blower_N = mkTerm "blower_N" ;
lin blowfish_N = mkTerm "blowfish_N" ;
lin blowfly_N = mkTerm "blowfly_N" ;
lin blowgun_N = mkTerm "blowgun_N" ;
lin blowhole_N = mkTerm "blowhole_N" ;
lin blowing_N = mkTerm "blowing_N" ;
lin blowing_up_N = mkTerm "blowing_up_N" ;
lin blowlamp_N = mkTerm "blowlamp_N" ;
lin blowout_N = mkTerm "blowout_N" ;
lin blowpipe_N = mkTerm "blowpipe_N" ;
lin blowsy_A = mkTerm "blowsy_A" ;
lin blowtorch_N = mkTerm "blowtorch_N" ;
lin blowtube_N = mkTerm "blowtube_N" ;
lin blowy_A = mkTerm "blowy_A" ;
lin blowzy_A = mkTerm "blowzy_A" ;
lin blubber_N = mkTerm "blubber_N" ;
lin blubber_V = mkTerm "blubber_V" ;
lin blubber_V2 = mkTerm "blubber_V2" ;
lin blubberer_N = mkTerm "blubberer_N" ;
lin blubbery_A = mkTerm "blubbery_A" ;
lin blucher_N = mkTerm "blucher_N" ;
lin bludgeon_N = mkTerm "bludgeon_N" ;
lin bludgeon_V2 = mkTerm "bludgeon_V2" ;
lin bludgeoner_N = mkTerm "bludgeoner_N" ;
lin blue_A = mkTerm "blue_A" ;
lin blue_N = mkTerm "blue_N" ;
lin blue_V2 = mkTerm "blue_V2" ;
lin blue_collar_A = mkTerm "blue_collar_A" ;
lin blue_jacket_N = mkTerm "blue_jacket_N" ;
lin blue_pencil_V2 = mkTerm "blue_pencil_V2" ;
lin bluebell_N = mkTerm "bluebell_N" ;
lin blueberry_N = mkTerm "blueberry_N" ;
lin bluebird_N = mkTerm "bluebird_N" ;
lin bluebonnet_N = mkTerm "bluebonnet_N" ;
lin bluebottle_N = mkTerm "bluebottle_N" ;
lin bluecoat_N = mkTerm "bluecoat_N" ;
lin bluefin_N = mkTerm "bluefin_N" ;
lin bluefish_N = mkTerm "bluefish_N" ;
lin bluegill_N = mkTerm "bluegill_N" ;
lin bluegrass_N = mkTerm "bluegrass_N" ;
lin bluehead_N = mkTerm "bluehead_N" ;
lin bluepoint_N = mkTerm "bluepoint_N" ;
lin blueprint_N = mkTerm "blueprint_N" ;
lin blues_N = mkTerm "blues_N" ;
lin bluestem_N = mkTerm "bluestem_N" ;
lin bluestocking_N = mkTerm "bluestocking_N" ;
lin bluestone_N = mkTerm "bluestone_N" ;
lin bluethroat_N = mkTerm "bluethroat_N" ;
lin bluetick_N = mkTerm "bluetick_N" ;
lin bluetongue_N = mkTerm "bluetongue_N" ;
lin blueweed_N = mkTerm "blueweed_N" ;
lin bluewing_N = mkTerm "bluewing_N" ;
lin bluff_A = mkTerm "bluff_A" ;
lin bluff_N = mkTerm "bluff_N" ;
lin bluff_V = mkTerm "bluff_V" ;
lin bluff_V2 = mkTerm "bluff_V2" ;
lin bluffer_N = mkTerm "bluffer_N" ;
lin bluffness_N = mkTerm "bluffness_N" ;
lin bluing_N = mkTerm "bluing_N" ;
lin bluish_A = mkTerm "bluish_A" ;
lin blunder_N = mkTerm "blunder_N" ;
lin blunder_V = mkTerm "blunder_V" ;
lin blunder_V2 = mkTerm "blunder_V2" ;
lin blunderbuss_N = mkTerm "blunderbuss_N" ;
lin blunderer_N = mkTerm "blunderer_N" ;
lin blunt_A = mkTerm "blunt_A" ;
lin blunt_V2 = mkTerm "blunt_V2" ;
lin bluntness_N = mkTerm "bluntness_N" ;
lin blur_N = mkTerm "blur_N" ;
lin blur_V = mkTerm "blur_V" ;
lin blur_V2 = mkTerm "blur_V2" ;
lin blurb_N = mkTerm "blurb_N" ;
lin blurt_V2 = mkTerm "blurt_V2" ;
lin blurt_out_V2 = mkTerm "blurt_out_V2" ;
lin blush_N = mkTerm "blush_N" ;
lin blush_V = mkTerm "blush_V" ;
lin blushful_A = mkTerm "blushful_A" ;
lin bluster_N = mkTerm "bluster_N" ;
lin bluster_V = mkTerm "bluster_V" ;
lin bluster_V2 = mkTerm "bluster_V2" ;
lin blustery_A = mkTerm "blustery_A" ;
lin blvd_N = mkTerm "blvd_N" ;
lin blyth_PN = mkTerm "blyth_PN" ;
lin bma_N = mkTerm "bma_N" ;
lin bmus_N = mkTerm "bmus_N" ;
lin bo'ness_PN = mkTerm "bo'ness_PN" ;
lin bo'sn_N = mkTerm "bo'sn_N" ;
lin bo'sun_N = mkTerm "bo'sun_N" ;
lin boa_N = mkTerm "boa_N" ;
lin boa_constrictor_N = mkTerm "boa_constrictor_N" ;
lin boar_N = mkTerm "boar_N" ;
lin board_1_N = mkTerm "board_1_N" ;
lin board_2_N = mkTerm "board_2_N" ;
lin board_V2 = mkTerm "board_V2" ;
lin board_out_V2 = mkTerm "board_out_V2" ;
lin board_up_V2 = mkTerm "board_up_V2" ;
lin boarder_N = mkTerm "boarder_N" ;
lin boarding_N = mkTerm "boarding_N" ;
lin boarding_card_N = mkTerm "boarding_card_N" ;
lin boarding_house_N = mkTerm "boarding_house_N" ;
lin boarding_school_N = mkTerm "boarding_school_N" ;
lin boardroom_N = mkTerm "boardroom_N" ;
lin boards_N = mkTerm "boards_N" ;
lin boardwalk_N = mkTerm "boardwalk_N" ;
lin boarfish_N = mkTerm "boarfish_N" ;
lin boarhound_N = mkTerm "boarhound_N" ;
lin boast_N = mkTerm "boast_N" ;
lin boast_V = mkTerm "boast_V" ;
lin boast_V2 = mkTerm "boast_V2" ;
lin boast_VS = mkTerm "boast_VS" ;
lin boaster_N = mkTerm "boaster_N" ;
lin boastful_A = mkTerm "boastful_A" ;
lin boastfulness_N = mkTerm "boastfulness_N" ;
lin boat_N = mkTerm "boat_N" ;
lin boat_V = mkTerm "boat_V" ;
lin boat_hook_N = mkTerm "boat_hook_N" ;
lin boat_house_N = mkTerm "boat_house_N" ;
lin boat_race_N = mkTerm "boat_race_N" ;
lin boat_train_N = mkTerm "boat_train_N" ;
lin boatbill_N = mkTerm "boatbill_N" ;
lin boatbuilder_N = mkTerm "boatbuilder_N" ;
lin boater_N = mkTerm "boater_N" ;
lin boating_N = mkTerm "boating_N" ;
lin boatload_N = mkTerm "boatload_N" ;
lin boatman_N = mkTerm "boatman_N" ;
lin boatmanship_N = mkTerm "boatmanship_N" ;
lin boatswain_N = mkTerm "boatswain_N" ;
lin boatyard_N = mkTerm "boatyard_N" ;
lin bob_N = mkTerm "bob_N" ;
lin bob_PN = mkTerm "bob_PN" ;
lin bob_V = mkTerm "bob_V" ;
lin bob_V2 = mkTerm "bob_V2" ;
lin bobbin_N = mkTerm "bobbin_N" ;
lin bobble_N = mkTerm "bobble_N" ;
lin bobby_N = mkTerm "bobby_N" ;
lin bobby_PN = mkTerm "bobby_PN" ;
lin bobby_soxer_N = mkTerm "bobby_soxer_N" ;
lin bobcat_N = mkTerm "bobcat_N" ;
lin bobolink_N = mkTerm "bobolink_N" ;
lin bobsled_N = mkTerm "bobsled_N" ;
lin bobsledding_N = mkTerm "bobsledding_N" ;
lin bobsleigh_N = mkTerm "bobsleigh_N" ;
lin bobtail_A = mkTerm "bobtail_A" ;
lin bobtail_N = mkTerm "bobtail_N" ;
lin bobwhite_N = mkTerm "bobwhite_N" ;
lin bocce_N = mkTerm "bocce_N" ;
lin bocconia_N = mkTerm "bocconia_N" ;
lin boche_A = mkTerm "boche_A" ;
lin bochum_PN = mkTerm "bochum_PN" ;
lin bock_N = mkTerm "bock_N" ;
lin bodacious_A = mkTerm "bodacious_A" ;
lin bode_V = mkTerm "bode_V" ;
lin bode_V2 = mkTerm "bode_V2" ;
lin bodega_N = mkTerm "bodega_N" ;
lin bodice_N = mkTerm "bodice_N" ;
lin bodied_A = mkTerm "bodied_A" ;
lin bodiless_A = mkTerm "bodiless_A" ;
lin bodily_A = mkTerm "bodily_A" ;
lin bodily_Adv = mkTerm "bodily_Adv" ;
lin boding_N = mkTerm "boding_N" ;
lin bodkin_N = mkTerm "bodkin_N" ;
lin bodmin_PN = mkTerm "bodmin_PN" ;
lin body_N = mkTerm "body_N" ;
lin body_servant_N = mkTerm "body_servant_N" ;
lin body_snatcher_N = mkTerm "body_snatcher_N" ;
lin bodybuilder_N = mkTerm "bodybuilder_N" ;
lin bodybuilding_N = mkTerm "bodybuilding_N" ;
lin bodyguard_N = mkTerm "bodyguard_N" ;
lin bodywork_N = mkTerm "bodywork_N" ;
lin boer_A = mkTerm "boer_A" ;
lin boer_N = mkTerm "boer_N" ;
lin boffin_N = mkTerm "boffin_N" ;
lin boffo_A = mkTerm "boffo_A" ;
lin bog_N = mkTerm "bog_N" ;
lin bog_V = mkTerm "bog_V" ;
lin bog_V2 = mkTerm "bog_V2" ;
lin bog_down_V = mkTerm "bog_down_V" ;
lin bog_in_V = mkTerm "bog_in_V" ;
lin bog_into_V2 = mkTerm "bog_into_V2" ;
lin bog_off_V = mkTerm "bog_off_V" ;
lin bogey_N = mkTerm "bogey_N" ;
lin bogeyman_N = mkTerm "bogeyman_N" ;
lin boggle_V = mkTerm "boggle_V" ;
lin boggy_A = mkTerm "boggy_A" ;
lin bogie_N = mkTerm "bogie_N" ;
lin bognor_PN = mkTerm "bognor_PN" ;
lin bognor_regis_PN = mkTerm "bognor_regis_PN" ;
lin bogota_PN = mkTerm "bogota_PN" ;
lin bogus_A = mkTerm "bogus_A" ;
lin bogy_N = mkTerm "bogy_N" ;
lin bohemia_N = mkTerm "bohemia_N" ;
lin bohemian_A = mkTerm "bohemian_A" ;
lin bohemian_N = mkTerm "bohemian_N" ;
lin bohemianism_N = mkTerm "bohemianism_N" ;
lin bohrium_N = mkTerm "bohrium_N" ;
lin boil_N = mkTerm "boil_N" ;
lin boil_V = mkTerm "boil_V" ;
lin boil_V2 = mkTerm "boil_V2" ;
lin boil_down_V2 = mkTerm "boil_down_V2" ;
lin boil_down_to_V2 = mkTerm "boil_down_to_V2" ;
lin boil_over_V = mkTerm "boil_over_V" ;
lin boil_up_V = mkTerm "boil_up_V" ;
lin boil_up_V2 = mkTerm "boil_up_V2" ;
lin boiler_N = mkTerm "boiler_N" ;
lin boilerplate_N = mkTerm "boilerplate_N" ;
lin boilersuit_N = mkTerm "boilersuit_N" ;
lin boiling_Adv = mkTerm "boiling_Adv" ;
lin boiling_N = mkTerm "boiling_N" ;
lin boiling_point_N = mkTerm "boiling_point_N" ;
lin boisterous_A = mkTerm "boisterous_A" ;
lin boisterousness_N = mkTerm "boisterousness_N" ;
lin bola_N = mkTerm "bola_N" ;
lin bold_1_A = mkTerm "bold_1_A" ;
lin bold_2_A = mkTerm "bold_2_A" ;
lin boldface_N = mkTerm "boldface_N" ;
lin boldness_N = mkTerm "boldness_N" ;
lin boldon_PN = mkTerm "boldon_PN" ;
lin bole_N = mkTerm "bole_N" ;
lin bolero_N = mkTerm "bolero_N" ;
lin bolete_N = mkTerm "bolete_N" ;
lin bolide_N = mkTerm "bolide_N" ;
lin bolivar_N = mkTerm "bolivar_N" ;
lin bolivia_N = mkTerm "bolivia_N" ;
lin bolivia_PN = mkTerm "bolivia_PN" ;
lin bolivian_A = mkTerm "bolivian_A" ;
lin bolivian_N = mkTerm "bolivian_N" ;
lin boliviano_N = mkTerm "boliviano_N" ;
lin boll_N = mkTerm "boll_N" ;
lin bollard_N = mkTerm "bollard_N" ;
lin bollington_PN = mkTerm "bollington_PN" ;
lin bollock_N = mkTerm "bollock_N" ;
lin bollworm_N = mkTerm "bollworm_N" ;
lin bolo_N = mkTerm "bolo_N" ;
lin bologna_N = mkTerm "bologna_N" ;
lin bologna_PN = mkTerm "bologna_PN" ;
lin bologram_N = mkTerm "bologram_N" ;
lin bolographic_A = mkTerm "bolographic_A" ;
lin bolometer_N = mkTerm "bolometer_N" ;
lin bolometric_A = mkTerm "bolometric_A" ;
lin boloney_N = mkTerm "boloney_N" ;
lin bolshevik_N = mkTerm "bolshevik_N" ;
lin bolshy_A = mkTerm "bolshy_A" ;
lin bolsover_PN = mkTerm "bolsover_PN" ;
lin bolster_N = mkTerm "bolster_N" ;
lin bolster_V = mkTerm "bolster_V" ;
lin bolster_V2 = mkTerm "bolster_V2" ;
lin bolster_up_V2 = mkTerm "bolster_up_V2" ;
lin bolt_Adv = mkTerm "bolt_Adv" ;
lin bolt_N = mkTerm "bolt_N" ;
lin bolt_V = mkTerm "bolt_V" ;
lin bolt_V2 = mkTerm "bolt_V2" ;
lin bolt_hole_N = mkTerm "bolt_hole_N" ;
lin bolti_N = mkTerm "bolti_N" ;
lin bolton_PN = mkTerm "bolton_PN" ;
lin bolton_le_sands_PN = mkTerm "bolton_le_sands_PN" ;
lin bolus_N = mkTerm "bolus_N" ;
lin bolzano_PN = mkTerm "bolzano_PN" ;
lin bomb_N = mkTerm "bomb_N" ;
lin bomb_V = mkTerm "bomb_V" ;
lin bomb_V2 = mkTerm "bomb_V2" ;
lin bomb_proof_A = mkTerm "bomb_proof_A" ;
lin bomb_sight_N = mkTerm "bomb_sight_N" ;
lin bomb_site_N = mkTerm "bomb_site_N" ;
lin bombard_V2 = mkTerm "bombard_V2" ;
lin bombardier_N = mkTerm "bombardier_N" ;
lin bombardment_N = mkTerm "bombardment_N" ;
lin bombardon_N = mkTerm "bombardon_N" ;
lin bombast_N = mkTerm "bombast_N" ;
lin bombastic_A = mkTerm "bombastic_A" ;
lin bombay_PN = mkTerm "bombay_PN" ;
lin bombazine_N = mkTerm "bombazine_N" ;
lin bomber_N = mkTerm "bomber_N" ;
lin bombie_N = mkTerm "bombie_N" ;
lin bombing_N = mkTerm "bombing_N" ;
lin bomblet_N = mkTerm "bomblet_N" ;
lin bombshell_N = mkTerm "bombshell_N" ;
lin bombycid_N = mkTerm "bombycid_N" ;
lin bon_mot_N = mkTerm "bon_mot_N" ;
lin bona_fide_A = mkTerm "bona_fide_A" ;
lin bona_fide_Adv = mkTerm "bona_fide_Adv" ;
lin bonanza_N = mkTerm "bonanza_N" ;
lin bonbon_N = mkTerm "bonbon_N" ;
lin bond_N = mkTerm "bond_N" ;
lin bond_V2 = mkTerm "bond_V2" ;
lin bond_holder_N = mkTerm "bond_holder_N" ;
lin bondable_A = mkTerm "bondable_A" ;
lin bondage_N = mkTerm "bondage_N" ;
lin bonding_N = mkTerm "bonding_N" ;
lin bondman_N = mkTerm "bondman_N" ;
lin bondsman_N = mkTerm "bondsman_N" ;
lin bonduc_N = mkTerm "bonduc_N" ;
lin bondwoman_N = mkTerm "bondwoman_N" ;
lin bone_A = mkTerm "bone_A" ;
lin bone_N = mkTerm "bone_N" ;
lin bone_V2 = mkTerm "bone_V2" ;
lin bone_dry_A = mkTerm "bone_dry_A" ;
lin bone_head_N = mkTerm "bone_head_N" ;
lin bone_idle_A = mkTerm "bone_idle_A" ;
lin bone_lazy_A = mkTerm "bone_lazy_A" ;
lin bone_setter_N = mkTerm "bone_setter_N" ;
lin bone_up_V = mkTerm "bone_up_V" ;
lin bone_up_on_V2 = mkTerm "bone_up_on_V2" ;
lin bonefish_N = mkTerm "bonefish_N" ;
lin boneless_A = mkTerm "boneless_A" ;
lin bonelike_A = mkTerm "bonelike_A" ;
lin bonemeal_N = mkTerm "bonemeal_N" ;
lin boner_N = mkTerm "boner_N" ;
lin bones_N = mkTerm "bones_N" ;
lin boneset_N = mkTerm "boneset_N" ;
lin boneshaker_N = mkTerm "boneshaker_N" ;
lin bonfire_N = mkTerm "bonfire_N" ;
lin bong_N = mkTerm "bong_N" ;
lin bongo_N = mkTerm "bongo_N" ;
lin bonheur_N = mkTerm "bonheur_N" ;
lin bonhomie_N = mkTerm "bonhomie_N" ;
lin bonito_N = mkTerm "bonito_N" ;
lin bonkers_A = mkTerm "bonkers_A" ;
lin bonn_PN = mkTerm "bonn_PN" ;
lin bonnet_N = mkTerm "bonnet_N" ;
lin bonny_A = mkTerm "bonny_A" ;
lin bonnybridge_PN = mkTerm "bonnybridge_PN" ;
lin bonnyrigg_PN = mkTerm "bonnyrigg_PN" ;
lin bonsai_N = mkTerm "bonsai_N" ;
lin bonus_N = mkTerm "bonus_N" ;
lin bony_A = mkTerm "bony_A" ;
lin bonyness_N = mkTerm "bonyness_N" ;
lin bonzer_A = mkTerm "bonzer_A" ;
lin boo_N = mkTerm "boo_N" ;
lin boo_V = mkTerm "boo_V" ;
lin boo_V2 = mkTerm "boo_V2" ;
lin boob_N = mkTerm "boob_N" ;
lin boob_V = mkTerm "boob_V" ;
lin booboisie_N = mkTerm "booboisie_N" ;
lin booby_N = mkTerm "booby_N" ;
lin booby_trap_N = mkTerm "booby_trap_N" ;
lin boodle_N = mkTerm "boodle_N" ;
lin booger_N = mkTerm "booger_N" ;
lin boogie_N = mkTerm "boogie_N" ;
lin boogie_woogie_N = mkTerm "boogie_woogie_N" ;
lin book_N = mkTerm "book_N" ;
lin book_V2 = mkTerm "book_V2" ;
lin book_end_N = mkTerm "book_end_N" ;
lin book_in_V2 = mkTerm "book_in_V2" ;
lin book_into_V2 = mkTerm "book_into_V2" ;
lin book_keeper_N = mkTerm "book_keeper_N" ;
lin book_out_V = mkTerm "book_out_V" ;
lin book_up_V = mkTerm "book_up_V" ;
lin bookable_A = mkTerm "bookable_A" ;
lin bookbinder_N = mkTerm "bookbinder_N" ;
lin bookbindery_N = mkTerm "bookbindery_N" ;
lin bookbinding_N = mkTerm "bookbinding_N" ;
lin bookcase_N = mkTerm "bookcase_N" ;
lin bookclub_N = mkTerm "bookclub_N" ;
lin bookdealer_N = mkTerm "bookdealer_N" ;
lin booker_N = mkTerm "booker_N" ;
lin bookie_N = mkTerm "bookie_N" ;
lin booking_N = mkTerm "booking_N" ;
lin bookish_A = mkTerm "bookish_A" ;
lin bookishness_N = mkTerm "bookishness_N" ;
lin bookkeeping_N = mkTerm "bookkeeping_N" ;
lin booklet_N = mkTerm "booklet_N" ;
lin booklouse_N = mkTerm "booklouse_N" ;
lin bookmaker_N = mkTerm "bookmaker_N" ;
lin bookmark_N = mkTerm "bookmark_N" ;
lin bookmarker_N = mkTerm "bookmarker_N" ;
lin bookmobile_N = mkTerm "bookmobile_N" ;
lin bookplate_N = mkTerm "bookplate_N" ;
lin bookseller_N = mkTerm "bookseller_N" ;
lin bookshelf_N = mkTerm "bookshelf_N" ;
lin bookshop_N = mkTerm "bookshop_N" ;
lin bookstall_N = mkTerm "bookstall_N" ;
lin bookstore_N = mkTerm "bookstore_N" ;
lin bookworm_N = mkTerm "bookworm_N" ;
lin boom_N = mkTerm "boom_N" ;
lin boom_V = mkTerm "boom_V" ;
lin boom_V2 = mkTerm "boom_V2" ;
lin boomerang_N = mkTerm "boomerang_N" ;
lin boon_A = mkTerm "boon_A" ;
lin boon_N = mkTerm "boon_N" ;
lin boondoggle_N = mkTerm "boondoggle_N" ;
lin boor_N = mkTerm "boor_N" ;
lin boorish_A = mkTerm "boorish_A" ;
lin boorishness_N = mkTerm "boorishness_N" ;
lin boost_N = mkTerm "boost_N" ;
lin boost_V2 = mkTerm "boost_V2" ;
lin booster_N = mkTerm "booster_N" ;
lin boot_N = mkTerm "boot_N" ;
lin boot_V2 = mkTerm "boot_V2" ;
lin boot_up_V2 = mkTerm "boot_up_V2" ;
lin bootblack_N = mkTerm "bootblack_N" ;
lin bootee_N = mkTerm "bootee_N" ;
lin booth_N = mkTerm "booth_N" ;
lin boothose_N = mkTerm "boothose_N" ;
lin bootjack_N = mkTerm "bootjack_N" ;
lin bootlace_N = mkTerm "bootlace_N" ;
lin bootle_PN = mkTerm "bootle_PN" ;
lin bootleg_A = mkTerm "bootleg_A" ;
lin bootleg_N = mkTerm "bootleg_N" ;
lin bootleg_V2 = mkTerm "bootleg_V2" ;
lin bootlegger_N = mkTerm "bootlegger_N" ;
lin bootlegging_N = mkTerm "bootlegging_N" ;
lin bootless_A = mkTerm "bootless_A" ;
lin bootlicking_A = mkTerm "bootlicking_A" ;
lin bootmaker_N = mkTerm "bootmaker_N" ;
lin bootstrap_N = mkTerm "bootstrap_N" ;
lin booty_N = mkTerm "booty_N" ;
lin booze_N = mkTerm "booze_N" ;
lin booze_V = mkTerm "booze_V" ;
lin booze_up_N = mkTerm "booze_up_N" ;
lin boozer_N = mkTerm "boozer_N" ;
lin boozy_A = mkTerm "boozy_A" ;
lin bop_N = mkTerm "bop_N" ;
lin bopeep_N = mkTerm "bopeep_N" ;
lin boracic_A = mkTerm "boracic_A" ;
lin borage_N = mkTerm "borage_N" ;
lin borate_N = mkTerm "borate_N" ;
lin borated_A = mkTerm "borated_A" ;
lin borax_N = mkTerm "borax_N" ;
lin bordeaux_N = mkTerm "bordeaux_N" ;
lin bordeaux_PN = mkTerm "bordeaux_PN" ;
lin bordelaise_N = mkTerm "bordelaise_N" ;
lin border_N = mkTerm "border_N" ;
lin border_V = mkTerm "border_V" ;
lin border_V2 = mkTerm "border_V2" ;
lin border_on_V2 = mkTerm "border_on_V2" ;
lin borderer_N = mkTerm "borderer_N" ;
lin borderland_N = mkTerm "borderland_N" ;
lin borderline_A = mkTerm "borderline_A" ;
lin borderline_N = mkTerm "borderline_N" ;
lin borders_PN = mkTerm "borders_PN" ;
lin bordon_PN = mkTerm "bordon_PN" ;
lin bore_N = mkTerm "bore_N" ;
lin bore_V = mkTerm "bore_V" ;
lin bore_V2 = mkTerm "bore_V2" ;
lin bore_hole_N = mkTerm "bore_hole_N" ;
lin boreal_A = mkTerm "boreal_A" ;
lin bored_A = mkTerm "bored_A" ;
lin boredom_N = mkTerm "boredom_N" ;
lin borer_N = mkTerm "borer_N" ;
lin boric_A = mkTerm "boric_A" ;
lin boring_A = mkTerm "boring_A" ;
lin boring_N = mkTerm "boring_N" ;
lin boringness_N = mkTerm "boringness_N" ;
lin boris_PN = mkTerm "boris_PN" ;
lin bornite_N = mkTerm "bornite_N" ;
lin boron_N = mkTerm "boron_N" ;
lin boronic_A = mkTerm "boronic_A" ;
lin borosilicate_N = mkTerm "borosilicate_N" ;
lin borough_N = mkTerm "borough_N" ;
lin borrelia_N = mkTerm "borrelia_N" ;
lin borrow_V = mkTerm "borrow_V" ;
lin borrow_V2 = mkTerm "borrow_V2" ;
lin borrow_VV = mkTerm "borrow_VV" ;
lin borrower_N = mkTerm "borrower_N" ;
lin borrowing_N = mkTerm "borrowing_N" ;
lin borsch_N = mkTerm "borsch_N" ;
lin borstal_N = mkTerm "borstal_N" ;
lin borzoi_N = mkTerm "borzoi_N" ;
lin bosc_N = mkTerm "bosc_N" ;
lin bosh_N = mkTerm "bosh_N" ;
lin bosk_N = mkTerm "bosk_N" ;
lin boskopoid_A = mkTerm "boskopoid_A" ;
lin bosky_A = mkTerm "bosky_A" ;
lin bosom_N = mkTerm "bosom_N" ;
lin bosomed_A = mkTerm "bosomed_A" ;
lin bosomy_A = mkTerm "bosomy_A" ;
lin boson_N = mkTerm "boson_N" ;
lin boss_A = mkTerm "boss_A" ;
lin boss_N = mkTerm "boss_N" ;
lin boss_V2 = mkTerm "boss_V2" ;
lin boss_about_V2 = mkTerm "boss_about_V2" ;
lin boss_around_V2 = mkTerm "boss_around_V2" ;
lin boss_eyed_A = mkTerm "boss_eyed_A" ;
lin bossism_N = mkTerm "bossism_N" ;
lin bossy_A = mkTerm "bossy_A" ;
lin boston_PN = mkTerm "boston_PN" ;
lin bot_N = mkTerm "bot_N" ;
lin bota_N = mkTerm "bota_N" ;
lin botanic_A = mkTerm "botanic_A" ;
lin botanical_A = mkTerm "botanical_A" ;
lin botanical_N = mkTerm "botanical_N" ;
lin botanist_N = mkTerm "botanist_N" ;
lin botanize_V = mkTerm "botanize_V" ;
lin botany_N = mkTerm "botany_N" ;
lin botch_N = mkTerm "botch_N" ;
lin botch_V2 = mkTerm "botch_V2" ;
lin botch_up_V2 = mkTerm "botch_up_V2" ;
lin botcher_N = mkTerm "botcher_N" ;
lin botchy_A = mkTerm "botchy_A" ;
lin botfly_N = mkTerm "botfly_N" ;
lin both_Adv = mkTerm "both_Adv" ;
lin both_Det = mkTerm "both_Det" ;
lin bother_N = mkTerm "bother_N" ;
lin bother_V = mkTerm "bother_V" ;
lin bother_V2 = mkTerm "bother_V2" ;
lin bother_V2V = mkTerm "bother_V2V" ;
lin bother_VV = mkTerm "bother_VV" ;
lin bothersome_A = mkTerm "bothersome_A" ;
lin botonee_A = mkTerm "botonee_A" ;
lin botryoid_A = mkTerm "botryoid_A" ;
lin botswana_PN = mkTerm "botswana_PN" ;
lin bottle_N = mkTerm "bottle_N" ;
lin bottle_V2 = mkTerm "bottle_V2" ;
lin bottle_away_V = mkTerm "bottle_away_V" ;
lin bottle_fed_A = mkTerm "bottle_fed_A" ;
lin bottle_green_A = mkTerm "bottle_green_A" ;
lin bottle_out_V = mkTerm "bottle_out_V" ;
lin bottle_up_V2 = mkTerm "bottle_up_V2" ;
lin bottlebrush_N = mkTerm "bottlebrush_N" ;
lin bottlecap_N = mkTerm "bottlecap_N" ;
lin bottleneck_N = mkTerm "bottleneck_N" ;
lin bottler_N = mkTerm "bottler_N" ;
lin bottom_A = mkTerm "bottom_A" ;
lin bottom_N = mkTerm "bottom_N" ;
lin bottom_V = mkTerm "bottom_V" ;
lin bottom_out_V = mkTerm "bottom_out_V" ;
lin bottomed_A = mkTerm "bottomed_A" ;
lin bottomland_N = mkTerm "bottomland_N" ;
lin bottomless_A = mkTerm "bottomless_A" ;
lin bottomlessness_N = mkTerm "bottomlessness_N" ;
lin bottommost_A = mkTerm "bottommost_A" ;
lin bottrop_PN = mkTerm "bottrop_PN" ;
lin botuliform_A = mkTerm "botuliform_A" ;
lin botulin_N = mkTerm "botulin_N" ;
lin botulinal_A = mkTerm "botulinal_A" ;
lin botulinus_N = mkTerm "botulinus_N" ;
lin botulism_N = mkTerm "botulism_N" ;
lin boucle_N = mkTerm "boucle_N" ;
lin boudoir_N = mkTerm "boudoir_N" ;
lin bouffant_A = mkTerm "bouffant_A" ;
lin bouffant_N = mkTerm "bouffant_N" ;
lin bougainvillea_N = mkTerm "bougainvillea_N" ;
lin bough_N = mkTerm "bough_N" ;
lin boughed_A = mkTerm "boughed_A" ;
lin boughless_A = mkTerm "boughless_A" ;
lin boughten_A = mkTerm "boughten_A" ;
lin bouillabaisse_N = mkTerm "bouillabaisse_N" ;
lin bouillon_N = mkTerm "bouillon_N" ;
lin boulder_N = mkTerm "boulder_N" ;
lin boulevard_N = mkTerm "boulevard_N" ;
lin boulevardier_N = mkTerm "boulevardier_N" ;
lin boulle_N = mkTerm "boulle_N" ;
lin bounce_N = mkTerm "bounce_N" ;
lin bounce_V = mkTerm "bounce_V" ;
lin bounce_V2 = mkTerm "bounce_V2" ;
lin bounce_back_V = mkTerm "bounce_back_V" ;
lin bounce_into_V2 = mkTerm "bounce_into_V2" ;
lin bounce_off_V2 = mkTerm "bounce_off_V2" ;
lin bouncer_N = mkTerm "bouncer_N" ;
lin bouncy_A = mkTerm "bouncy_A" ;
lin bound_N = mkTerm "bound_N" ;
lin bound_V = mkTerm "bound_V" ;
lin bound_V2 = mkTerm "bound_V2" ;
lin bound_V2V = mkTerm "bound_V2V" ;
lin boundary_N = mkTerm "boundary_N" ;
lin bounden_A = mkTerm "bounden_A" ;
lin bounder_N = mkTerm "bounder_N" ;
lin boundless_A = mkTerm "boundless_A" ;
lin bounteous_A = mkTerm "bounteous_A" ;
lin bountied_A = mkTerm "bountied_A" ;
lin bountiful_A = mkTerm "bountiful_A" ;
lin bounty_N = mkTerm "bounty_N" ;
lin bouquet_N = mkTerm "bouquet_N" ;
lin bourbon_N = mkTerm "bourbon_N" ;
lin bourgeois_A = mkTerm "bourgeois_A" ;
lin bourgeois_N = mkTerm "bourgeois_N" ;
lin bourgeoisie_N = mkTerm "bourgeoisie_N" ;
lin bourguignon_N = mkTerm "bourguignon_N" ;
lin bourn_N = mkTerm "bourn_N" ;
lin bourne_N = mkTerm "bourne_N" ;
lin bourne_PN = mkTerm "bourne_PN" ;
lin bournemouth_PN = mkTerm "bournemouth_PN" ;
lin bourse_N = mkTerm "bourse_N" ;
lin bourtree_N = mkTerm "bourtree_N" ;
lin boustrophedon_N = mkTerm "boustrophedon_N" ;
lin boustrophedonic_A = mkTerm "boustrophedonic_A" ;
lin bout_N = mkTerm "bout_N" ;
lin boutique_N = mkTerm "boutique_N" ;
lin boutonniere_N = mkTerm "boutonniere_N" ;
lin bovid_N = mkTerm "bovid_N" ;
lin bovine_A = mkTerm "bovine_A" ;
lin bovine_N = mkTerm "bovine_N" ;
lin bovril_N = mkTerm "bovril_N" ;
lin bow_N = mkTerm "bow_N" ;
lin bow_V = mkTerm "bow_V" ;
lin bow_V2 = mkTerm "bow_V2" ;
lin bow_wow_N = mkTerm "bow_wow_N" ;
lin bowburn_PN = mkTerm "bowburn_PN" ;
lin bowdlerization_N = mkTerm "bowdlerization_N" ;
lin bowdlerize_V2 = mkTerm "bowdlerize_V2" ;
lin bowel_N = mkTerm "bowel_N" ;
lin bower_N = mkTerm "bower_N" ;
lin bowerbird_N = mkTerm "bowerbird_N" ;
lin bowery_A = mkTerm "bowery_A" ;
lin bowfin_N = mkTerm "bowfin_N" ;
lin bowfront_A = mkTerm "bowfront_A" ;
lin bowhead_N = mkTerm "bowhead_N" ;
lin bowie_N = mkTerm "bowie_N" ;
lin bowie_knife_N = mkTerm "bowie_knife_N" ;
lin bowing_N = mkTerm "bowing_N" ;
lin bowl_N = mkTerm "bowl_N" ;
lin bowl_V = mkTerm "bowl_V" ;
lin bowl_V2 = mkTerm "bowl_V2" ;
lin bowl_out_V2 = mkTerm "bowl_out_V2" ;
lin bowl_over_V2 = mkTerm "bowl_over_V2" ;
lin bowleg_N = mkTerm "bowleg_N" ;
lin bowler_N = mkTerm "bowler_N" ;
lin bowline_N = mkTerm "bowline_N" ;
lin bowling_N = mkTerm "bowling_N" ;
lin bowling_green_N = mkTerm "bowling_green_N" ;
lin bowls_N = mkTerm "bowls_N" ;
lin bowman_N = mkTerm "bowman_N" ;
lin bowsprit_N = mkTerm "bowsprit_N" ;
lin bowstring_N = mkTerm "bowstring_N" ;
lin box_N = mkTerm "box_N" ;
lin box_V = mkTerm "box_V" ;
lin box_V2 = mkTerm "box_V2" ;
lin box_in_V2 = mkTerm "box_in_V2" ;
lin box_kite_N = mkTerm "box_kite_N" ;
lin box_number_N = mkTerm "box_number_N" ;
lin box_office_N = mkTerm "box_office_N" ;
lin box_up_V2 = mkTerm "box_up_V2" ;
lin boxcar_N = mkTerm "boxcar_N" ;
lin boxcars_N = mkTerm "boxcars_N" ;
lin boxer_N = mkTerm "boxer_N" ;
lin boxfish_N = mkTerm "boxfish_N" ;
lin boxful_N = mkTerm "boxful_N" ;
lin boxing_N = mkTerm "boxing_N" ;
lin boxing_day_N = mkTerm "boxing_day_N" ;
lin boxing_day_PN = mkTerm "boxing_day_PN" ;
lin boxing_glove_N = mkTerm "boxing_glove_N" ;
lin boxing_match_N = mkTerm "boxing_match_N" ;
lin boxlike_A = mkTerm "boxlike_A" ;
lin boxwood_N = mkTerm "boxwood_N" ;
lin boy_N = mkTerm "boy_N" ;
lin boycott_N = mkTerm "boycott_N" ;
lin boycott_V2 = mkTerm "boycott_V2" ;
lin boyfriend_N = mkTerm "boyfriend_N" ;
lin boyhood_N = mkTerm "boyhood_N" ;
lin boyish_A = mkTerm "boyish_A" ;
lin boyishness_N = mkTerm "boyishness_N" ;
lin boysenberry_N = mkTerm "boysenberry_N" ;
lin boza_N = mkTerm "boza_N" ;
lin bra_N = mkTerm "bra_N" ;
lin brace_N = mkTerm "brace_N" ;
lin brace_V = mkTerm "brace_V" ;
lin brace_V2 = mkTerm "brace_V2" ;
lin brace_up_V = mkTerm "brace_up_V" ;
lin bracelet_N = mkTerm "bracelet_N" ;
lin bracer_N = mkTerm "bracer_N" ;
lin bracero_N = mkTerm "bracero_N" ;
lin brachial_A = mkTerm "brachial_A" ;
lin brachiate_A = mkTerm "brachiate_A" ;
lin brachiation_N = mkTerm "brachiation_N" ;
lin brachiopod_A = mkTerm "brachiopod_A" ;
lin brachiopod_N = mkTerm "brachiopod_N" ;
lin brachium_N = mkTerm "brachium_N" ;
lin brachycephalic_A = mkTerm "brachycephalic_A" ;
lin brachycephalic_N = mkTerm "brachycephalic_N" ;
lin brachycephaly_N = mkTerm "brachycephaly_N" ;
lin brachydactylic_A = mkTerm "brachydactylic_A" ;
lin brachydactyly_N = mkTerm "brachydactyly_N" ;
lin brachypterous_A = mkTerm "brachypterous_A" ;
lin brachyuran_N = mkTerm "brachyuran_N" ;
lin brachyurous_A = mkTerm "brachyurous_A" ;
lin bracken_N = mkTerm "bracken_N" ;
lin bracket_N = mkTerm "bracket_N" ;
lin bracket_V2 = mkTerm "bracket_V2" ;
lin brackish_A = mkTerm "brackish_A" ;
lin brackishness_N = mkTerm "brackishness_N" ;
lin bracknell_PN = mkTerm "bracknell_PN" ;
lin bract_N = mkTerm "bract_N" ;
lin bracteal_A = mkTerm "bracteal_A" ;
lin bracteate_A = mkTerm "bracteate_A" ;
lin bracteolate_A = mkTerm "bracteolate_A" ;
lin bracteole_N = mkTerm "bracteole_N" ;
lin brad_N = mkTerm "brad_N" ;
lin bradawl_N = mkTerm "bradawl_N" ;
lin bradford_PN = mkTerm "bradford_PN" ;
lin bradford_on_avon_PN = mkTerm "bradford_on_avon_PN" ;
lin bradycardia_N = mkTerm "bradycardia_N" ;
lin brae_N = mkTerm "brae_N" ;
lin brag_N = mkTerm "brag_N" ;
lin brag_V = mkTerm "brag_V" ;
lin braggadocio_N = mkTerm "braggadocio_N" ;
lin braggart_N = mkTerm "braggart_N" ;
lin bragger_N = mkTerm "bragger_N" ;
lin bragging_N = mkTerm "bragging_N" ;
lin brahman_N = mkTerm "brahman_N" ;
lin brahmin_N = mkTerm "brahmin_N" ;
lin brahminic_A = mkTerm "brahminic_A" ;
lin braid_N = mkTerm "braid_N" ;
lin braid_V2 = mkTerm "braid_V2" ;
lin brail_N = mkTerm "brail_N" ;
lin braille_N = mkTerm "braille_N" ;
lin brain_N = mkTerm "brain_N" ;
lin brain_V2 = mkTerm "brain_V2" ;
lin brain_fag_N = mkTerm "brain_fag_N" ;
lin brain_teaser_N = mkTerm "brain_teaser_N" ;
lin brainchild_N = mkTerm "brainchild_N" ;
lin brainless_A = mkTerm "brainless_A" ;
lin brainsick_A = mkTerm "brainsick_A" ;
lin brainstem_N = mkTerm "brainstem_N" ;
lin brainstorm_N = mkTerm "brainstorm_N" ;
lin brainstorming_N = mkTerm "brainstorming_N" ;
lin braintree_PN = mkTerm "braintree_PN" ;
lin brainwash_V2 = mkTerm "brainwash_V2" ;
lin brainwashing_N = mkTerm "brainwashing_N" ;
lin brainwave_N = mkTerm "brainwave_N" ;
lin brainworker_N = mkTerm "brainworker_N" ;
lin brainy_A = mkTerm "brainy_A" ;
lin braise_V2 = mkTerm "braise_V2" ;
lin braising_N = mkTerm "braising_N" ;
lin brake_N = mkTerm "brake_N" ;
lin brake_V = mkTerm "brake_V" ;
lin brake_V2 = mkTerm "brake_V2" ;
lin brakeman_N = mkTerm "brakeman_N" ;
lin braky_A = mkTerm "braky_A" ;
lin bramble_N = mkTerm "bramble_N" ;
lin brambling_N = mkTerm "brambling_N" ;
lin bran_N = mkTerm "bran_N" ;
lin bran_new_A = mkTerm "bran_new_A" ;
lin branch_N = mkTerm "branch_N" ;
lin branch_V = mkTerm "branch_V" ;
lin branch_out_V = mkTerm "branch_out_V" ;
lin branched_A = mkTerm "branched_A" ;
lin branchial_A = mkTerm "branchial_A" ;
lin branchiate_A = mkTerm "branchiate_A" ;
lin branching_N = mkTerm "branching_N" ;
lin branchiopod_A = mkTerm "branchiopod_A" ;
lin branchless_A = mkTerm "branchless_A" ;
lin branchlet_N = mkTerm "branchlet_N" ;
lin branchy_A = mkTerm "branchy_A" ;
lin brand_N = mkTerm "brand_N" ;
lin brand_V2 = mkTerm "brand_V2" ;
lin brand_new_A = mkTerm "brand_new_A" ;
lin branderburgh_PN = mkTerm "branderburgh_PN" ;
lin branding_iron_N = mkTerm "branding_iron_N" ;
lin brandish_V2 = mkTerm "brandish_V2" ;
lin brandy_N = mkTerm "brandy_N" ;
lin brandy_ball_N = mkTerm "brandy_ball_N" ;
lin brandy_snap_N = mkTerm "brandy_snap_N" ;
lin brant_N = mkTerm "brant_N" ;
lin brash_A = mkTerm "brash_A" ;
lin brashness_N = mkTerm "brashness_N" ;
lin brasilia_PN = mkTerm "brasilia_PN" ;
lin brass_N = mkTerm "brass_N" ;
lin brassard_N = mkTerm "brassard_N" ;
lin brassavola_N = mkTerm "brassavola_N" ;
lin brassbound_A = mkTerm "brassbound_A" ;
lin brasserie_N = mkTerm "brasserie_N" ;
lin brassie_N = mkTerm "brassie_N" ;
lin brassiere_N = mkTerm "brassiere_N" ;
lin brassy_A = mkTerm "brassy_A" ;
lin brat_N = mkTerm "brat_N" ;
lin bratislava_PN = mkTerm "bratislava_PN" ;
lin brattice_N = mkTerm "brattice_N" ;
lin bratty_A = mkTerm "bratty_A" ;
lin bratwurst_N = mkTerm "bratwurst_N" ;
lin braunschweig_PN = mkTerm "braunschweig_PN" ;
lin braunton_PN = mkTerm "braunton_PN" ;
lin bravado_N = mkTerm "bravado_N" ;
lin brave_A = mkTerm "brave_A" ;
lin brave_N = mkTerm "brave_N" ;
lin brave_V2 = mkTerm "brave_V2" ;
lin bravery_N = mkTerm "bravery_N" ;
lin bravo_N = mkTerm "bravo_N" ;
lin bravura_N = mkTerm "bravura_N" ;
lin brawl_N = mkTerm "brawl_N" ;
lin brawl_V = mkTerm "brawl_V" ;
lin brawler_N = mkTerm "brawler_N" ;
lin brawn_N = mkTerm "brawn_N" ;
lin brawny_A = mkTerm "brawny_A" ;
lin bray_N = mkTerm "bray_N" ;
lin bray_V2 = mkTerm "bray_V2" ;
lin braze_V2 = mkTerm "braze_V2" ;
lin brazen_A = mkTerm "brazen_A" ;
lin brazen_V2 = mkTerm "brazen_V2" ;
lin brazen_faced_A = mkTerm "brazen_faced_A" ;
lin brazier_N = mkTerm "brazier_N" ;
lin brazil_PN = mkTerm "brazil_PN" ;
lin brazilian_A = mkTerm "brazilian_A" ;
lin brazilian_N = mkTerm "brazilian_N" ;
lin brazilwood_N = mkTerm "brazilwood_N" ;
lin breach_N = mkTerm "breach_N" ;
lin breach_V2 = mkTerm "breach_V2" ;
lin bread_N = mkTerm "bread_N" ;
lin breadbasket_N = mkTerm "breadbasket_N" ;
lin breadboard_N = mkTerm "breadboard_N" ;
lin breadcrumb_N = mkTerm "breadcrumb_N" ;
lin breadfruit_N = mkTerm "breadfruit_N" ;
lin breadline_N = mkTerm "breadline_N" ;
lin breadroot_N = mkTerm "breadroot_N" ;
lin breadstick_N = mkTerm "breadstick_N" ;
lin breadstuff_N = mkTerm "breadstuff_N" ;
lin breadth_N = mkTerm "breadth_N" ;
lin breadthways_Adv = mkTerm "breadthways_Adv" ;
lin breadthwise_Adv = mkTerm "breadthwise_Adv" ;
lin breadwinner_N = mkTerm "breadwinner_N" ;
lin break_N = mkTerm "break_N" ;
lin break_V = mkTerm "break_V" ;
lin break_V2 = mkTerm "break_V2" ;
lin break_apart_V = mkTerm "break_apart_V" ;
lin break_away_V = mkTerm "break_away_V" ;
lin break_down_V = mkTerm "break_down_V" ;
lin break_down_V2 = mkTerm "break_down_V2" ;
lin break_in_N = mkTerm "break_in_N" ;
lin break_in_V = mkTerm "break_in_V" ;
lin break_in_V2 = mkTerm "break_in_V2" ;
lin break_in_on_V2 = mkTerm "break_in_on_V2" ;
lin break_into_V2 = mkTerm "break_into_V2" ;
lin break_off_V2 = mkTerm "break_off_V2" ;
lin break_out_V = mkTerm "break_out_V" ;
lin break_out_V2 = mkTerm "break_out_V2" ;
lin break_out_in_V2 = mkTerm "break_out_in_V2" ;
lin break_out_of_V2 = mkTerm "break_out_of_V2" ;
lin break_through_V2 = mkTerm "break_through_V2" ;
lin break_up_N = mkTerm "break_up_N" ;
lin break_up_V = mkTerm "break_up_V" ;
lin break_up_V2 = mkTerm "break_up_V2" ;
lin breakable_A = mkTerm "breakable_A" ;
lin breakable_N = mkTerm "breakable_N" ;
lin breakableness_N = mkTerm "breakableness_N" ;
lin breakage_N = mkTerm "breakage_N" ;
lin breakaway_A = mkTerm "breakaway_A" ;
lin breakaway_N = mkTerm "breakaway_N" ;
lin breakaways_N = mkTerm "breakaways_N" ;
lin breakax_N = mkTerm "breakax_N" ;
lin breakdown_N = mkTerm "breakdown_N" ;
lin breaker_N = mkTerm "breaker_N" ;
lin breakfast_N = mkTerm "breakfast_N" ;
lin breakfast_V = mkTerm "breakfast_V" ;
lin breakneck_A = mkTerm "breakneck_A" ;
lin breakout_N = mkTerm "breakout_N" ;
lin breakthrough_N = mkTerm "breakthrough_N" ;
lin breakwater_N = mkTerm "breakwater_N" ;
lin bream_N = mkTerm "bream_N" ;
lin breast_N = mkTerm "breast_N" ;
lin breast_V2 = mkTerm "breast_V2" ;
lin breast_deep_Adv = mkTerm "breast_deep_Adv" ;
lin breast_fed_A = mkTerm "breast_fed_A" ;
lin breast_high_Adv = mkTerm "breast_high_Adv" ;
lin breast_plate_N = mkTerm "breast_plate_N" ;
lin breastfeed_V = mkTerm "breastfeed_V" ;
lin breastfeed_V2 = mkTerm "breastfeed_V2" ;
lin breastless_A = mkTerm "breastless_A" ;
lin breaston_PN = mkTerm "breaston_PN" ;
lin breaststroke_N = mkTerm "breaststroke_N" ;
lin breaststroker_N = mkTerm "breaststroker_N" ;
lin breastwork_N = mkTerm "breastwork_N" ;
lin breath_N = mkTerm "breath_N" ;
lin breathalyser_N = mkTerm "breathalyser_N" ;
lin breathalyzer_N = mkTerm "breathalyzer_N" ;
lin breathe_V = mkTerm "breathe_V" ;
lin breathe_V2 = mkTerm "breathe_V2" ;
lin breather_N = mkTerm "breather_N" ;
lin breathing_N = mkTerm "breathing_N" ;
lin breathing_space_N = mkTerm "breathing_space_N" ;
lin breathless_A = mkTerm "breathless_A" ;
lin breathtaking_A = mkTerm "breathtaking_A" ;
lin breccia_N = mkTerm "breccia_N" ;
lin brecknock_PN = mkTerm "brecknock_PN" ;
lin breda_PN = mkTerm "breda_PN" ;
lin breech_N = mkTerm "breech_N" ;
lin breech_block_N = mkTerm "breech_block_N" ;
lin breechcloth_N = mkTerm "breechcloth_N" ;
lin breeched_A = mkTerm "breeched_A" ;
lin breeches_N = mkTerm "breeches_N" ;
lin breeches_buoy_N = mkTerm "breeches_buoy_N" ;
lin breechloader_N = mkTerm "breechloader_N" ;
lin breed_N = mkTerm "breed_N" ;
lin breed_V = mkTerm "breed_V" ;
lin breed_V2 = mkTerm "breed_V2" ;
lin breeder_N = mkTerm "breeder_N" ;
lin breeding_N = mkTerm "breeding_N" ;
lin breedsall_PN = mkTerm "breedsall_PN" ;
lin breeze_N = mkTerm "breeze_N" ;
lin breeze_V = mkTerm "breeze_V" ;
lin breeze_along_V = mkTerm "breeze_along_V" ;
lin breeze_in_V = mkTerm "breeze_in_V" ;
lin breeze_into_V2 = mkTerm "breeze_into_V2" ;
lin breeze_through_V2 = mkTerm "breeze_through_V2" ;
lin breeziness_N = mkTerm "breeziness_N" ;
lin breezy_A = mkTerm "breezy_A" ;
lin bregma_N = mkTerm "bregma_N" ;
lin bregmatic_A = mkTerm "bregmatic_A" ;
lin bremen_PN = mkTerm "bremen_PN" ;
lin bremerhaven_PN = mkTerm "bremerhaven_PN" ;
lin bren_N = mkTerm "bren_N" ;
lin bren_gun_N = mkTerm "bren_gun_N" ;
lin brenda_PN = mkTerm "brenda_PN" ;
lin brent_PN = mkTerm "brent_PN" ;
lin brentwood_PN = mkTerm "brentwood_PN" ;
lin brescia_PN = mkTerm "brescia_PN" ;
lin brest_PN = mkTerm "brest_PN" ;
lin brethren_N = mkTerm "brethren_N" ;
lin breve_N = mkTerm "breve_N" ;
lin brevet_N = mkTerm "brevet_N" ;
lin breviary_N = mkTerm "breviary_N" ;
lin brevity_N = mkTerm "brevity_N" ;
lin brew_N = mkTerm "brew_N" ;
lin brew_V = mkTerm "brew_V" ;
lin brew_V2 = mkTerm "brew_V2" ;
lin brewer_N = mkTerm "brewer_N" ;
lin brewery_N = mkTerm "brewery_N" ;
lin brewing_N = mkTerm "brewing_N" ;
lin brewpub_N = mkTerm "brewpub_N" ;
lin brian_PN = mkTerm "brian_PN" ;
lin briar_N = mkTerm "briar_N" ;
lin briard_N = mkTerm "briard_N" ;
lin briarroot_N = mkTerm "briarroot_N" ;
lin briarwood_N = mkTerm "briarwood_N" ;
lin bribable_A = mkTerm "bribable_A" ;
lin bribe_N = mkTerm "bribe_N" ;
lin bribe_V = mkTerm "bribe_V" ;
lin bribe_V2 = mkTerm "bribe_V2" ;
lin briber_N = mkTerm "briber_N" ;
lin bribery_N = mkTerm "bribery_N" ;
lin bric_a_brac_N = mkTerm "bric_a_brac_N" ;
lin brick_N = mkTerm "brick_N" ;
lin brick_V2 = mkTerm "brick_V2" ;
lin brick_field_N = mkTerm "brick_field_N" ;
lin brick_in_V2 = mkTerm "brick_in_V2" ;
lin brick_up_V2 = mkTerm "brick_up_V2" ;
lin brickbat_N = mkTerm "brickbat_N" ;
lin bricket_wood_PN = mkTerm "bricket_wood_PN" ;
lin brickkiln_N = mkTerm "brickkiln_N" ;
lin bricklayer_N = mkTerm "bricklayer_N" ;
lin bricklaying_N = mkTerm "bricklaying_N" ;
lin brickwork_N = mkTerm "brickwork_N" ;
lin brickyard_N = mkTerm "brickyard_N" ;
lin bridal_A = mkTerm "bridal_A" ;
lin bridal_N = mkTerm "bridal_N" ;
lin bride_N = mkTerm "bride_N" ;
lin bridecake_N = mkTerm "bridecake_N" ;
lin bridegroom_N = mkTerm "bridegroom_N" ;
lin bridesmaid_N = mkTerm "bridesmaid_N" ;
lin bridge_N = mkTerm "bridge_N" ;
lin bridge_V2 = mkTerm "bridge_V2" ;
lin bridgeable_A = mkTerm "bridgeable_A" ;
lin bridgehead_N = mkTerm "bridgehead_N" ;
lin bridgend_PN = mkTerm "bridgend_PN" ;
lin bridget_PN = mkTerm "bridget_PN" ;
lin bridgnorth_PN = mkTerm "bridgnorth_PN" ;
lin bridgwater_PN = mkTerm "bridgwater_PN" ;
lin bridle_N = mkTerm "bridle_N" ;
lin bridle_V = mkTerm "bridle_V" ;
lin bridle_V2 = mkTerm "bridle_V2" ;
lin bridle_path_N = mkTerm "bridle_path_N" ;
lin bridle_road_N = mkTerm "bridle_road_N" ;
lin bridlington_PN = mkTerm "bridlington_PN" ;
lin bridoon_N = mkTerm "bridoon_N" ;
lin bridport_PN = mkTerm "bridport_PN" ;
lin brief_A = mkTerm "brief_A" ;
lin brief_N = mkTerm "brief_N" ;
lin brief_V2 = mkTerm "brief_V2" ;
lin briefcase_N = mkTerm "briefcase_N" ;
lin briefing_N = mkTerm "briefing_N" ;
lin briefless_A = mkTerm "briefless_A" ;
lin briefness_N = mkTerm "briefness_N" ;
lin brier_N = mkTerm "brier_N" ;
lin brig_N = mkTerm "brig_N" ;
lin brig_PN = mkTerm "brig_PN" ;
lin brigade_N = mkTerm "brigade_N" ;
lin brigadier_N = mkTerm "brigadier_N" ;
lin brigand_N = mkTerm "brigand_N" ;
lin brigandine_N = mkTerm "brigandine_N" ;
lin brigantine_N = mkTerm "brigantine_N" ;
lin brighouse_PN = mkTerm "brighouse_PN" ;
lin bright_A = mkTerm "bright_A" ;
lin bright_Adv = mkTerm "bright_Adv" ;
lin brighten_V = mkTerm "brighten_V" ;
lin brighten_V2 = mkTerm "brighten_V2" ;
lin brighten_up_V = mkTerm "brighten_up_V" ;
lin brighten_up_V2 = mkTerm "brighten_up_V2" ;
lin brightlingsea_PN = mkTerm "brightlingsea_PN" ;
lin brightness_N = mkTerm "brightness_N" ;
lin brighton_PN = mkTerm "brighton_PN" ;
lin brill_N = mkTerm "brill_N" ;
lin brilliance_N = mkTerm "brilliance_N" ;
lin brilliancy_N = mkTerm "brilliancy_N" ;
lin brilliant_A = mkTerm "brilliant_A" ;
lin brilliantine_N = mkTerm "brilliantine_N" ;
lin brim_N = mkTerm "brim_N" ;
lin brim_V = mkTerm "brim_V" ;
lin brimful_A = mkTerm "brimful_A" ;
lin brimfull_A = mkTerm "brimfull_A" ;
lin brimless_A = mkTerm "brimless_A" ;
lin brimstone_N = mkTerm "brimstone_N" ;
lin brindled_A = mkTerm "brindled_A" ;
lin brine_N = mkTerm "brine_N" ;
lin bring_V2 = mkTerm "bring_V2" ;
lin bring_V3 = mkTerm "bring_V3" ;
lin bring_about_V2 = mkTerm "bring_about_V2" ;
lin bring_along_V2 = mkTerm "bring_along_V2" ;
lin bring_around_V2 = mkTerm "bring_around_V2" ;
lin bring_away_V2 = mkTerm "bring_away_V2" ;
lin bring_back_V2 = mkTerm "bring_back_V2" ;
lin bring_down_V2 = mkTerm "bring_down_V2" ;
lin bring_forth_V = mkTerm "bring_forth_V" ;
lin bring_forth_V2 = mkTerm "bring_forth_V2" ;
lin bring_forward_V2 = mkTerm "bring_forward_V2" ;
lin bring_in_V2 = mkTerm "bring_in_V2" ;
lin bring_off_V2 = mkTerm "bring_off_V2" ;
lin bring_on_V2 = mkTerm "bring_on_V2" ;
lin bring_out_V2 = mkTerm "bring_out_V2" ;
lin bring_out_in_V3 = mkTerm "bring_out_in_V3" ;
lin bring_over_V2 = mkTerm "bring_over_V2" ;
lin bring_round_V2 = mkTerm "bring_round_V2" ;
lin bring_to_V2 = mkTerm "bring_to_V2" ;
lin bring_up_V2 = mkTerm "bring_up_V2" ;
lin brininess_N = mkTerm "brininess_N" ;
lin brink_N = mkTerm "brink_N" ;
lin brinkmanship_N = mkTerm "brinkmanship_N" ;
lin briny_A = mkTerm "briny_A" ;
lin brioche_N = mkTerm "brioche_N" ;
lin briquet_N = mkTerm "briquet_N" ;
lin briquette_N = mkTerm "briquette_N" ;
lin brisance_N = mkTerm "brisance_N" ;
lin brisant_A = mkTerm "brisant_A" ;
lin brisbane_PN = mkTerm "brisbane_PN" ;
lin brisk_A = mkTerm "brisk_A" ;
lin brisket_N = mkTerm "brisket_N" ;
lin brisling_N = mkTerm "brisling_N" ;
lin bristle_N = mkTerm "bristle_N" ;
lin bristle_V = mkTerm "bristle_V" ;
lin bristlegrass_N = mkTerm "bristlegrass_N" ;
lin bristlelike_A = mkTerm "bristlelike_A" ;
lin bristletail_N = mkTerm "bristletail_N" ;
lin bristly_A = mkTerm "bristly_A" ;
lin bristol_PN = mkTerm "bristol_PN" ;
lin brit_N = mkTerm "brit_N" ;
lin britain_PN = mkTerm "britain_PN" ;
lin britannic_A = mkTerm "britannic_A" ;
lin britches_N = mkTerm "britches_N" ;
lin british_A = mkTerm "british_A" ;
lin britisher_N = mkTerm "britisher_N" ;
lin briton_A = mkTerm "briton_A" ;
lin briton_N = mkTerm "briton_N" ;
lin brittle_A = mkTerm "brittle_A" ;
lin brittle_N = mkTerm "brittle_N" ;
lin brittlebush_N = mkTerm "brittlebush_N" ;
lin brittleness_N = mkTerm "brittleness_N" ;
lin brixham_PN = mkTerm "brixham_PN" ;
lin brno_PN = mkTerm "brno_PN" ;
lin broach_V = mkTerm "broach_V" ;
lin broach_V2 = mkTerm "broach_V2" ;
lin broad_A = mkTerm "broad_A" ;
lin broad_N = mkTerm "broad_N" ;
lin broad_minded_A = mkTerm "broad_minded_A" ;
lin broad_mindedness_N = mkTerm "broad_mindedness_N" ;
lin broadax_N = mkTerm "broadax_N" ;
lin broadband_A = mkTerm "broadband_A" ;
lin broadbill_N = mkTerm "broadbill_N" ;
lin broadcast_Adv = mkTerm "broadcast_Adv" ;
lin broadcast_N = mkTerm "broadcast_N" ;
lin broadcast_V = mkTerm "broadcast_V" ;
lin broadcast_V2 = mkTerm "broadcast_V2" ;
lin broadcaster_N = mkTerm "broadcaster_N" ;
lin broadcasting_N = mkTerm "broadcasting_N" ;
lin broadcloth_N = mkTerm "broadcloth_N" ;
lin broaden_V = mkTerm "broaden_V" ;
lin broaden_V2 = mkTerm "broaden_V2" ;
lin broadening_N = mkTerm "broadening_N" ;
lin broadleaf_A = mkTerm "broadleaf_A" ;
lin broadloom_A = mkTerm "broadloom_A" ;
lin broadloom_N = mkTerm "broadloom_N" ;
lin broadly_speaking_Adv = mkTerm "broadly_speaking_Adv" ;
lin broadness_N = mkTerm "broadness_N" ;
lin broadsheet_N = mkTerm "broadsheet_N" ;
lin broadside_A = mkTerm "broadside_A" ;
lin broadside_Adv = mkTerm "broadside_Adv" ;
lin broadside_N = mkTerm "broadside_N" ;
lin broadsword_N = mkTerm "broadsword_N" ;
lin broadtail_N = mkTerm "broadtail_N" ;
lin broadways_Adv = mkTerm "broadways_Adv" ;
lin broadwise_Adv = mkTerm "broadwise_Adv" ;
lin broby_PN = mkTerm "broby_PN" ;
lin brocade_N = mkTerm "brocade_N" ;
lin brocade_V2 = mkTerm "brocade_V2" ;
lin broccoli_N = mkTerm "broccoli_N" ;
lin brochette_N = mkTerm "brochette_N" ;
lin brochure_N = mkTerm "brochure_N" ;
lin brocket_N = mkTerm "brocket_N" ;
lin brodiaea_N = mkTerm "brodiaea_N" ;
lin brogan_N = mkTerm "brogan_N" ;
lin brogue_N = mkTerm "brogue_N" ;
lin broil_N = mkTerm "broil_N" ;
lin broil_V = mkTerm "broil_V" ;
lin broil_V2 = mkTerm "broil_V2" ;
lin broiler_N = mkTerm "broiler_N" ;
lin broke_A = mkTerm "broke_A" ;
lin broken_A = mkTerm "broken_A" ;
lin broken_hearted_A = mkTerm "broken_hearted_A" ;
lin broker_N = mkTerm "broker_N" ;
lin brokerage_N = mkTerm "brokerage_N" ;
lin brolly_N = mkTerm "brolly_N" ;
lin brome_N = mkTerm "brome_N" ;
lin bromic_A = mkTerm "bromic_A" ;
lin bromide_N = mkTerm "bromide_N" ;
lin bromidic_A = mkTerm "bromidic_A" ;
lin bromine_N = mkTerm "bromine_N" ;
lin bromley_PN = mkTerm "bromley_PN" ;
lin bromoform_N = mkTerm "bromoform_N" ;
lin bromsgrove_PN = mkTerm "bromsgrove_PN" ;
lin bronchial_A = mkTerm "bronchial_A" ;
lin bronchiolar_A = mkTerm "bronchiolar_A" ;
lin bronchiole_N = mkTerm "bronchiole_N" ;
lin bronchiolitis_N = mkTerm "bronchiolitis_N" ;
lin bronchitic_A = mkTerm "bronchitic_A" ;
lin bronchitis_N = mkTerm "bronchitis_N" ;
lin bronchodilator_N = mkTerm "bronchodilator_N" ;
lin bronchopneumonia_N = mkTerm "bronchopneumonia_N" ;
lin bronchoscope_N = mkTerm "bronchoscope_N" ;
lin bronchoscopic_A = mkTerm "bronchoscopic_A" ;
lin bronchospasm_N = mkTerm "bronchospasm_N" ;
lin bronchus_N = mkTerm "bronchus_N" ;
lin bronco_N = mkTerm "bronco_N" ;
lin bronze_A = mkTerm "bronze_A" ;
lin bronze_N = mkTerm "bronze_N" ;
lin bronze_V = mkTerm "bronze_V" ;
lin bronze_V2 = mkTerm "bronze_V2" ;
lin brooch_N = mkTerm "brooch_N" ;
lin brood_N = mkTerm "brood_N" ;
lin brood_V = mkTerm "brood_V" ;
lin brood_hen_N = mkTerm "brood_hen_N" ;
lin brood_mare_N = mkTerm "brood_mare_N" ;
lin brooding_N = mkTerm "brooding_N" ;
lin broody_A = mkTerm "broody_A" ;
lin brook_N = mkTerm "brook_N" ;
lin brook_V2 = mkTerm "brook_V2" ;
lin brooklet_N = mkTerm "brooklet_N" ;
lin brooklime_N = mkTerm "brooklime_N" ;
lin brookweed_N = mkTerm "brookweed_N" ;
lin broom_N = mkTerm "broom_N" ;
lin broomcorn_N = mkTerm "broomcorn_N" ;
lin broomstick_N = mkTerm "broomstick_N" ;
lin broomweed_N = mkTerm "broomweed_N" ;
lin bros_PN = mkTerm "bros_PN" ;
lin broth_N = mkTerm "broth_N" ;
lin brothel_N = mkTerm "brothel_N" ;
lin brother_N = mkTerm "brother_N" ;
lin brother_in_law_N = mkTerm "brother_in_law_N" ;
lin brotherhood_N = mkTerm "brotherhood_N" ;
lin brotherly_A = mkTerm "brotherly_A" ;
lin brotherly_Adv = mkTerm "brotherly_Adv" ;
lin brotula_N = mkTerm "brotula_N" ;
lin brougham_N = mkTerm "brougham_N" ;
lin brought_V = mkTerm "brought_V" ;
lin broughton_PN = mkTerm "broughton_PN" ;
lin brouhaha_N = mkTerm "brouhaha_N" ;
lin brow_N = mkTerm "brow_N" ;
lin browbeat_V2 = mkTerm "browbeat_V2" ;
lin brown_A = mkTerm "brown_A" ;
lin brown_N = mkTerm "brown_N" ;
lin brown_V = mkTerm "brown_V" ;
lin brown_V2 = mkTerm "brown_V2" ;
lin brownie_N = mkTerm "brownie_N" ;
lin brownish_A = mkTerm "brownish_A" ;
lin brownstone_N = mkTerm "brownstone_N" ;
lin browntail_N = mkTerm "browntail_N" ;
lin browse_N = mkTerm "browse_N" ;
lin browse_V = mkTerm "browse_V" ;
lin browser_N = mkTerm "browser_N" ;
lin broxburn_PN = mkTerm "broxburn_PN" ;
lin bruce_PN = mkTerm "bruce_PN" ;
lin brucellosis_N = mkTerm "brucellosis_N" ;
lin brucine_N = mkTerm "brucine_N" ;
lin bruges_PN = mkTerm "bruges_PN" ;
lin bruin_N = mkTerm "bruin_N" ;
lin bruise_N = mkTerm "bruise_N" ;
lin bruise_V = mkTerm "bruise_V" ;
lin bruise_V2 = mkTerm "bruise_V2" ;
lin bruiser_N = mkTerm "bruiser_N" ;
lin bruit_V2 = mkTerm "bruit_V2" ;
lin brumal_A = mkTerm "brumal_A" ;
lin brumous_A = mkTerm "brumous_A" ;
lin brunch_N = mkTerm "brunch_N" ;
lin brunei_PN = mkTerm "brunei_PN" ;
lin bruneian_A = mkTerm "bruneian_A" ;
lin bruneian_N = mkTerm "bruneian_N" ;
lin brunet_A = mkTerm "brunet_A" ;
lin brunet_N = mkTerm "brunet_N" ;
lin brunetteFem_N = mkTerm "brunetteFem_N" ;
lin brunetteMasc_N = mkTerm "brunetteMasc_N" ;
lin brunswick_PN = mkTerm "brunswick_PN" ;
lin brunt_N = mkTerm "brunt_N" ;
lin brush_N = mkTerm "brush_N" ;
lin brush_V = mkTerm "brush_V" ;
lin brush_V2 = mkTerm "brush_V2" ;
lin brush_aside_V = mkTerm "brush_aside_V" ;
lin brush_off_N = mkTerm "brush_off_N" ;
lin brush_off_V2 = mkTerm "brush_off_V2" ;
lin brush_up_N = mkTerm "brush_up_N" ;
lin brush_up_V2 = mkTerm "brush_up_V2" ;
lin brushlike_A = mkTerm "brushlike_A" ;
lin brushwood_N = mkTerm "brushwood_N" ;
lin brushwork_N = mkTerm "brushwork_N" ;
lin brusque_A = mkTerm "brusque_A" ;
lin brusqueness_N = mkTerm "brusqueness_N" ;
lin brussels_PN = mkTerm "brussels_PN" ;
lin brut_A = mkTerm "brut_A" ;
lin brutal_A = mkTerm "brutal_A" ;
lin brutality_N = mkTerm "brutality_N" ;
lin brutalization_N = mkTerm "brutalization_N" ;
lin brutalize_V2 = mkTerm "brutalize_V2" ;
lin brute_N = mkTerm "brute_N" ;
lin brutish_A = mkTerm "brutish_A" ;
lin bruxism_N = mkTerm "bruxism_N" ;
lin bryan_PN = mkTerm "bryan_PN" ;
lin bryanthus_N = mkTerm "bryanthus_N" ;
lin bryony_N = mkTerm "bryony_N" ;
lin bryophyte_N = mkTerm "bryophyte_N" ;
lin bryophytic_A = mkTerm "bryophytic_A" ;
lin bryozoan_N = mkTerm "bryozoan_N" ;
lin bsc_N = mkTerm "bsc_N" ;
lin bst_PN = mkTerm "bst_PN" ;
lin bt_PN = mkTerm "bt_PN" ;
lin bubaline_A = mkTerm "bubaline_A" ;
lin bubble_N = mkTerm "bubble_N" ;
lin bubble_V = mkTerm "bubble_V" ;
lin bubble_over_V = mkTerm "bubble_over_V" ;
lin bubbler_N = mkTerm "bubbler_N" ;
lin bubbliness_N = mkTerm "bubbliness_N" ;
lin bubbly_A = mkTerm "bubbly_A" ;
lin bubbly_N = mkTerm "bubbly_N" ;
lin bubo_N = mkTerm "bubo_N" ;
lin bubonic_A = mkTerm "bubonic_A" ;
lin bucarest_PN = mkTerm "bucarest_PN" ;
lin buccal_A = mkTerm "buccal_A" ;
lin buccaneer_N = mkTerm "buccaneer_N" ;
lin buck_N = mkTerm "buck_N" ;
lin buck_V = mkTerm "buck_V" ;
lin buck_V2 = mkTerm "buck_V2" ;
lin buck_up_V2 = mkTerm "buck_up_V2" ;
lin buckboard_N = mkTerm "buckboard_N" ;
lin bucket_N = mkTerm "bucket_N" ;
lin bucket_V = mkTerm "bucket_V" ;
lin bucket_down_V = mkTerm "bucket_down_V" ;
lin bucketful_N = mkTerm "bucketful_N" ;
lin buckeye_N = mkTerm "buckeye_N" ;
lin buckhaven_PN = mkTerm "buckhaven_PN" ;
lin buckie_PN = mkTerm "buckie_PN" ;
lin buckingham_PN = mkTerm "buckingham_PN" ;
lin buckinghamshire_PN = mkTerm "buckinghamshire_PN" ;
lin buckle_N = mkTerm "buckle_N" ;
lin buckle_V = mkTerm "buckle_V" ;
lin buckle_V2 = mkTerm "buckle_V2" ;
lin buckle_down_V = mkTerm "buckle_down_V" ;
lin buckle_under_V = mkTerm "buckle_under_V" ;
lin buckle_up_V = mkTerm "buckle_up_V" ;
lin buckler_N = mkTerm "buckler_N" ;
lin buckley_PN = mkTerm "buckley_PN" ;
lin buckleya_N = mkTerm "buckleya_N" ;
lin buckminsterfullerene_N = mkTerm "buckminsterfullerene_N" ;
lin buckram_N = mkTerm "buckram_N" ;
lin bucksaw_N = mkTerm "bucksaw_N" ;
lin bucksburn_PN = mkTerm "bucksburn_PN" ;
lin buckshee_A = mkTerm "buckshee_A" ;
lin buckshot_N = mkTerm "buckshot_N" ;
lin buckskin_N = mkTerm "buckskin_N" ;
lin buckskins_N = mkTerm "buckskins_N" ;
lin buckthorn_N = mkTerm "buckthorn_N" ;
lin bucktooth_N = mkTerm "bucktooth_N" ;
lin buckwheat_N = mkTerm "buckwheat_N" ;
lin bucolic_A = mkTerm "bucolic_A" ;
lin bucolics_N = mkTerm "bucolics_N" ;
lin bud_N = mkTerm "bud_N" ;
lin bud_V = mkTerm "bud_V" ;
lin budapest_PN = mkTerm "budapest_PN" ;
lin buddhism_N = mkTerm "buddhism_N" ;
lin buddhistFem_N = mkTerm "buddhistFem_N" ;
lin buddhistMasc_N = mkTerm "buddhistMasc_N" ;
lin budding_N = mkTerm "budding_N" ;
lin buddy_N = mkTerm "buddy_N" ;
lin budge_V = mkTerm "budge_V" ;
lin budge_V2 = mkTerm "budge_V2" ;
lin budge_up_V = mkTerm "budge_up_V" ;
lin budgerigar_N = mkTerm "budgerigar_N" ;
lin budget_N = mkTerm "budget_N" ;
lin budget_V = mkTerm "budget_V" ;
lin budget_V2 = mkTerm "budget_V2" ;
lin budgetary_A = mkTerm "budgetary_A" ;
lin budgie_N = mkTerm "budgie_N" ;
lin buenos_aires_PN = mkTerm "buenos_aires_PN" ;
lin buff_A = mkTerm "buff_A" ;
lin buff_N = mkTerm "buff_N" ;
lin buff_V2 = mkTerm "buff_V2" ;
lin buff_up_V2 = mkTerm "buff_up_V2" ;
lin buff_up_on_V2 = mkTerm "buff_up_on_V2" ;
lin buffalo_N = mkTerm "buffalo_N" ;
lin buffalo_PN = mkTerm "buffalo_PN" ;
lin buffalofish_N = mkTerm "buffalofish_N" ;
lin buffer_N = mkTerm "buffer_N" ;
lin buffer_V2 = mkTerm "buffer_V2" ;
lin buffet_N = mkTerm "buffet_N" ;
lin buffet_V = mkTerm "buffet_V" ;
lin buffet_V2 = mkTerm "buffet_V2" ;
lin bufflehead_N = mkTerm "bufflehead_N" ;
lin buffoon_N = mkTerm "buffoon_N" ;
lin buffoonery_N = mkTerm "buffoonery_N" ;
lin buffoonish_A = mkTerm "buffoonish_A" ;
lin bufo_N = mkTerm "bufo_N" ;
lin bug_N = mkTerm "bug_N" ;
lin bug_V2 = mkTerm "bug_V2" ;
lin bug_hunter_N = mkTerm "bug_hunter_N" ;
lin bug_off_V = mkTerm "bug_off_V" ;
lin bug_out_V = mkTerm "bug_out_V" ;
lin bugaboo_N = mkTerm "bugaboo_N" ;
lin bugbane_N = mkTerm "bugbane_N" ;
lin bugbear_N = mkTerm "bugbear_N" ;
lin bugger_N = mkTerm "bugger_N" ;
lin bugger_V = mkTerm "bugger_V" ;
lin bugger_V2 = mkTerm "bugger_V2" ;
lin bugger_all_N = mkTerm "bugger_all_N" ;
lin buggery_N = mkTerm "buggery_N" ;
lin bugginess_N = mkTerm "bugginess_N" ;
lin buggy_A = mkTerm "buggy_A" ;
lin buggy_N = mkTerm "buggy_N" ;
lin bugle_N = mkTerm "bugle_N" ;
lin bugler_N = mkTerm "bugler_N" ;
lin bugleweed_N = mkTerm "bugleweed_N" ;
lin bugloss_N = mkTerm "bugloss_N" ;
lin buhl_N = mkTerm "buhl_N" ;
lin build_N = mkTerm "build_N" ;
lin build_V = mkTerm "build_V" ;
lin build_V2 = mkTerm "build_V2" ;
lin build_up_N = mkTerm "build_up_N" ;
lin build_up_V2 = mkTerm "build_up_V2" ;
lin builder_N = mkTerm "builder_N" ;
lin building_N = mkTerm "building_N" ;
lin building_society_N = mkTerm "building_society_N" ;
lin built_in_A = mkTerm "built_in_A" ;
lin built_up_A = mkTerm "built_up_A" ;
lin bulb_N = mkTerm "bulb_N" ;
lin bulbaceous_A = mkTerm "bulbaceous_A" ;
lin bulbar_A = mkTerm "bulbar_A" ;
lin bulbed_A = mkTerm "bulbed_A" ;
lin bulbil_N = mkTerm "bulbil_N" ;
lin bulblike_A = mkTerm "bulblike_A" ;
lin bulbous_A = mkTerm "bulbous_A" ;
lin bulbul_N = mkTerm "bulbul_N" ;
lin bulgaria_PN = mkTerm "bulgaria_PN" ;
lin bulgarianFem_N = mkTerm "bulgarianFem_N" ;
lin bulgarianMasc_N = mkTerm "bulgarianMasc_N" ;
lin bulgarian_A = mkTerm "bulgarian_A" ;
lin bulge_N = mkTerm "bulge_N" ;
lin bulge_V = mkTerm "bulge_V" ;
lin bulge_V2 = mkTerm "bulge_V2" ;
lin bulgur_N = mkTerm "bulgur_N" ;
lin bulimarexia_N = mkTerm "bulimarexia_N" ;
lin bulimia_N = mkTerm "bulimia_N" ;
lin bulimic_A = mkTerm "bulimic_A" ;
lin bulimic_N = mkTerm "bulimic_N" ;
lin bulk_N = mkTerm "bulk_N" ;
lin bulk_V = mkTerm "bulk_V" ;
lin bulk_out_V2 = mkTerm "bulk_out_V2" ;
lin bulk_up_V = mkTerm "bulk_up_V" ;
lin bulkhead_N = mkTerm "bulkhead_N" ;
lin bulkiness_N = mkTerm "bulkiness_N" ;
lin bulkington_PN = mkTerm "bulkington_PN" ;
lin bulky_A = mkTerm "bulky_A" ;
lin bull's_eye_N = mkTerm "bull's_eye_N" ;
lin bull_N = mkTerm "bull_N" ;
lin bull_headed_A = mkTerm "bull_headed_A" ;
lin bull_neck_N = mkTerm "bull_neck_N" ;
lin bull_terrier_N = mkTerm "bull_terrier_N" ;
lin bulla_N = mkTerm "bulla_N" ;
lin bullace_N = mkTerm "bullace_N" ;
lin bullate_A = mkTerm "bullate_A" ;
lin bullbrier_N = mkTerm "bullbrier_N" ;
lin bulldog_N = mkTerm "bulldog_N" ;
lin bulldoze_V2 = mkTerm "bulldoze_V2" ;
lin bulldozer_N = mkTerm "bulldozer_N" ;
lin bullet_N = mkTerm "bullet_N" ;
lin bullet_headed_A = mkTerm "bullet_headed_A" ;
lin bullethead_N = mkTerm "bullethead_N" ;
lin bulletin_N = mkTerm "bulletin_N" ;
lin bulletproof_A = mkTerm "bulletproof_A" ;
lin bullfight_N = mkTerm "bullfight_N" ;
lin bullfighter_N = mkTerm "bullfighter_N" ;
lin bullfighting_N = mkTerm "bullfighting_N" ;
lin bullfinch_N = mkTerm "bullfinch_N" ;
lin bullfrog_N = mkTerm "bullfrog_N" ;
lin bullhead_N = mkTerm "bullhead_N" ;
lin bullhorn_N = mkTerm "bullhorn_N" ;
lin bullion_N = mkTerm "bullion_N" ;
lin bullish_A = mkTerm "bullish_A" ;
lin bullnecked_A = mkTerm "bullnecked_A" ;
lin bullnose_N = mkTerm "bullnose_N" ;
lin bullock_N = mkTerm "bullock_N" ;
lin bullocky_A = mkTerm "bullocky_A" ;
lin bullpen_N = mkTerm "bullpen_N" ;
lin bullring_N = mkTerm "bullring_N" ;
lin bullshit_N = mkTerm "bullshit_N" ;
lin bullshit_V = mkTerm "bullshit_V" ;
lin bullshot_N = mkTerm "bullshot_N" ;
lin bully_A = mkTerm "bully_A" ;
lin bully_N = mkTerm "bully_N" ;
lin bully_V = mkTerm "bully_V" ;
lin bully_V2 = mkTerm "bully_V2" ;
lin bullyboy_N = mkTerm "bullyboy_N" ;
lin bullying_N = mkTerm "bullying_N" ;
lin bulrush_N = mkTerm "bulrush_N" ;
lin bulwark_N = mkTerm "bulwark_N" ;
lin bum_A = mkTerm "bum_A" ;
lin bum_N = mkTerm "bum_N" ;
lin bum_V = mkTerm "bum_V" ;
lin bum_V2 = mkTerm "bum_V2" ;
lin bumblebee_N = mkTerm "bumblebee_N" ;
lin bumbling_A = mkTerm "bumbling_A" ;
lin bumboat_N = mkTerm "bumboat_N" ;
lin bumf_N = mkTerm "bumf_N" ;
lin bummer_N = mkTerm "bummer_N" ;
lin bump_Adv = mkTerm "bump_Adv" ;
lin bump_N = mkTerm "bump_N" ;
lin bump_V = mkTerm "bump_V" ;
lin bump_V2 = mkTerm "bump_V2" ;
lin bump_into_V2 = mkTerm "bump_into_V2" ;
lin bump_off_V2 = mkTerm "bump_off_V2" ;
lin bump_up_V2 = mkTerm "bump_up_V2" ;
lin bumper_N = mkTerm "bumper_N" ;
lin bumpiness_N = mkTerm "bumpiness_N" ;
lin bumpkin_N = mkTerm "bumpkin_N" ;
lin bumpkinly_A = mkTerm "bumpkinly_A" ;
lin bumptious_A = mkTerm "bumptious_A" ;
lin bumptiousness_N = mkTerm "bumptiousness_N" ;
lin bumpy_A = mkTerm "bumpy_A" ;
lin bun_N = mkTerm "bun_N" ;
lin buna_N = mkTerm "buna_N" ;
lin bunch_N = mkTerm "bunch_N" ;
lin bunch_V = mkTerm "bunch_V" ;
lin bunch_V2 = mkTerm "bunch_V2" ;
lin bunchberry_N = mkTerm "bunchberry_N" ;
lin bunchgrass_N = mkTerm "bunchgrass_N" ;
lin bunchy_A = mkTerm "bunchy_A" ;
lin bunco_N = mkTerm "bunco_N" ;
lin bundle_N = mkTerm "bundle_N" ;
lin bundle_V = mkTerm "bundle_V" ;
lin bundle_V2 = mkTerm "bundle_V2" ;
lin bundle_off_V2 = mkTerm "bundle_off_V2" ;
lin bundle_out_V2 = mkTerm "bundle_out_V2" ;
lin bundle_up_V = mkTerm "bundle_up_V" ;
lin bundle_up_V2 = mkTerm "bundle_up_V2" ;
lin bundling_N = mkTerm "bundling_N" ;
lin bunfight_N = mkTerm "bunfight_N" ;
lin bung_N = mkTerm "bung_N" ;
lin bung_V2 = mkTerm "bung_V2" ;
lin bung_hole_N = mkTerm "bung_hole_N" ;
lin bungaloid_A = mkTerm "bungaloid_A" ;
lin bungalow_N = mkTerm "bungalow_N" ;
lin bungee_N = mkTerm "bungee_N" ;
lin bungle_N = mkTerm "bungle_N" ;
lin bungle_V = mkTerm "bungle_V" ;
lin bungle_V2 = mkTerm "bungle_V2" ;
lin bungler_N = mkTerm "bungler_N" ;
lin bunion_N = mkTerm "bunion_N" ;
lin bunk_N = mkTerm "bunk_N" ;
lin bunk_V = mkTerm "bunk_V" ;
lin bunk_off_V = mkTerm "bunk_off_V" ;
lin bunker_N = mkTerm "bunker_N" ;
lin bunker_V = mkTerm "bunker_V" ;
lin bunker_V2 = mkTerm "bunker_V2" ;
lin bunkmate_N = mkTerm "bunkmate_N" ;
lin bunkum_N = mkTerm "bunkum_N" ;
lin bunny_N = mkTerm "bunny_N" ;
lin bunsen_N = mkTerm "bunsen_N" ;
lin bunt_N = mkTerm "bunt_N" ;
lin buntal_N = mkTerm "buntal_N" ;
lin bunter_N = mkTerm "bunter_N" ;
lin bunting_N = mkTerm "bunting_N" ;
lin bunyavirus_N = mkTerm "bunyavirus_N" ;
lin buoy_N = mkTerm "buoy_N" ;
lin buoy_V = mkTerm "buoy_V" ;
lin buoy_V2 = mkTerm "buoy_V2" ;
lin buoy_up_V2 = mkTerm "buoy_up_V2" ;
lin buoyancy_N = mkTerm "buoyancy_N" ;
lin buoyant_A = mkTerm "buoyant_A" ;
lin bur_N = mkTerm "bur_N" ;
lin burberry_N = mkTerm "burberry_N" ;
lin burble_V = mkTerm "burble_V" ;
lin burble_VS = mkTerm "burble_VS" ;
lin burbot_N = mkTerm "burbot_N" ;
lin burden_N = mkTerm "burden_N" ;
lin burden_V2 = mkTerm "burden_V2" ;
lin burdenless_A = mkTerm "burdenless_A" ;
lin burdensome_A = mkTerm "burdensome_A" ;
lin burdensomeness_N = mkTerm "burdensomeness_N" ;
lin burdock_N = mkTerm "burdock_N" ;
lin bureau_N = mkTerm "bureau_N" ;
lin bureaucracy_N = mkTerm "bureaucracy_N" ;
lin bureaucrat_N = mkTerm "bureaucrat_N" ;
lin bureaucratic_A = mkTerm "bureaucratic_A" ;
lin burette_N = mkTerm "burette_N" ;
lin burg_N = mkTerm "burg_N" ;
lin burgeon_V = mkTerm "burgeon_V" ;
lin burgess_N = mkTerm "burgess_N" ;
lin burgess_PN = mkTerm "burgess_PN" ;
lin burgh_N = mkTerm "burgh_N" ;
lin burgher_N = mkTerm "burgher_N" ;
lin burglar_N = mkTerm "burglar_N" ;
lin burglar_alarm_N = mkTerm "burglar_alarm_N" ;
lin burglar_proof_A = mkTerm "burglar_proof_A" ;
lin burglarious_A = mkTerm "burglarious_A" ;
lin burglary_N = mkTerm "burglary_N" ;
lin burgle_V = mkTerm "burgle_V" ;
lin burgle_V2 = mkTerm "burgle_V2" ;
lin burgomaster_N = mkTerm "burgomaster_N" ;
lin burgoo_N = mkTerm "burgoo_N" ;
lin burgos_PN = mkTerm "burgos_PN" ;
lin burgrass_N = mkTerm "burgrass_N" ;
lin burgrave_N = mkTerm "burgrave_N" ;
lin burgundy_N = mkTerm "burgundy_N" ;
lin burial_N = mkTerm "burial_N" ;
lin burial_ground_N = mkTerm "burial_ground_N" ;
lin burin_N = mkTerm "burin_N" ;
lin burke_V2 = mkTerm "burke_V2" ;
lin burl_N = mkTerm "burl_N" ;
lin burlap_N = mkTerm "burlap_N" ;
lin burled_A = mkTerm "burled_A" ;
lin burlesque_A = mkTerm "burlesque_A" ;
lin burlesque_N = mkTerm "burlesque_N" ;
lin burlesque_V2 = mkTerm "burlesque_V2" ;
lin burley_PN = mkTerm "burley_PN" ;
lin burly_A = mkTerm "burly_A" ;
lin burma_PN = mkTerm "burma_PN" ;
lin burmese_A = mkTerm "burmese_A" ;
lin burmese_N = mkTerm "burmese_N" ;
lin burn_N = mkTerm "burn_N" ;
lin burn_V = mkTerm "burn_V" ;
lin burn_V2 = mkTerm "burn_V2" ;
lin burn_down_V = mkTerm "burn_down_V" ;
lin burn_down_V2 = mkTerm "burn_down_V2" ;
lin burn_off_V2 = mkTerm "burn_off_V2" ;
lin burn_out_V = mkTerm "burn_out_V" ;
lin burn_up_N = mkTerm "burn_up_N" ;
lin burn_up_V = mkTerm "burn_up_V" ;
lin burn_up_V2 = mkTerm "burn_up_V2" ;
lin burnable_A = mkTerm "burnable_A" ;
lin burner_N = mkTerm "burner_N" ;
lin burnham_on_sea_PN = mkTerm "burnham_on_sea_PN" ;
lin burning_A = mkTerm "burning_A" ;
lin burning_N = mkTerm "burning_N" ;
lin burnish_V = mkTerm "burnish_V" ;
lin burnish_V2 = mkTerm "burnish_V2" ;
lin burnley_PN = mkTerm "burnley_PN" ;
lin burnous_N = mkTerm "burnous_N" ;
lin burnouse_N = mkTerm "burnouse_N" ;
lin burntisland_PN = mkTerm "burntisland_PN" ;
lin burntwood_PN = mkTerm "burntwood_PN" ;
lin burp_N = mkTerm "burp_N" ;
lin burp_V = mkTerm "burp_V" ;
lin burp_V2 = mkTerm "burp_V2" ;
lin burqa_N = mkTerm "burqa_N" ;
lin burr_N = mkTerm "burr_N" ;
lin burr_drill_N = mkTerm "burr_drill_N" ;
lin burrawong_N = mkTerm "burrawong_N" ;
lin burrfish_N = mkTerm "burrfish_N" ;
lin burrito_N = mkTerm "burrito_N" ;
lin burrlike_A = mkTerm "burrlike_A" ;
lin burro_N = mkTerm "burro_N" ;
lin burrow_N = mkTerm "burrow_N" ;
lin burrow_V = mkTerm "burrow_V" ;
lin burrow_V2 = mkTerm "burrow_V2" ;
lin burry_port_PN = mkTerm "burry_port_PN" ;
lin bursa_N = mkTerm "bursa_N" ;
lin bursal_A = mkTerm "bursal_A" ;
lin bursar_N = mkTerm "bursar_N" ;
lin bursary_N = mkTerm "bursary_N" ;
lin burscough_PN = mkTerm "burscough_PN" ;
lin bursiform_A = mkTerm "bursiform_A" ;
lin bursitis_N = mkTerm "bursitis_N" ;
lin burst_N = mkTerm "burst_N" ;
lin burst_V = mkTerm "burst_V" ;
lin burst_V2 = mkTerm "burst_V2" ;
lin burst_into_V2 = mkTerm "burst_into_V2" ;
lin burthen_N = mkTerm "burthen_N" ;
lin burthen_V2 = mkTerm "burthen_V2" ;
lin burton_N = mkTerm "burton_N" ;
lin burton_upon_trent_PN = mkTerm "burton_upon_trent_PN" ;
lin burundi_PN = mkTerm "burundi_PN" ;
lin burundian_A = mkTerm "burundian_A" ;
lin burundian_N = mkTerm "burundian_N" ;
lin bury_PN = mkTerm "bury_PN" ;
lin bury_V = mkTerm "bury_V" ;
lin bury_V2 = mkTerm "bury_V2" ;
lin bury_st__edmunds_PN = mkTerm "bury_st__edmunds_PN" ;
lin burying_N = mkTerm "burying_N" ;
lin burying_ground_N = mkTerm "burying_ground_N" ;
lin bus_N = mkTerm "bus_N" ;
lin bus_V = mkTerm "bus_V" ;
lin bus_V2 = mkTerm "bus_V2" ;
lin busbar_N = mkTerm "busbar_N" ;
lin busboy_N = mkTerm "busboy_N" ;
lin busby_N = mkTerm "busby_N" ;
lin bush_N = mkTerm "bush_N" ;
lin bushbuck_N = mkTerm "bushbuck_N" ;
lin bushel_N = mkTerm "bushel_N" ;
lin bushing_N = mkTerm "bushing_N" ;
lin bushman_N = mkTerm "bushman_N" ;
lin bushtit_N = mkTerm "bushtit_N" ;
lin bushwhacker_N = mkTerm "bushwhacker_N" ;
lin bushwhacking_A = mkTerm "bushwhacking_A" ;
lin bushy_A = mkTerm "bushy_A" ;
lin business_N = mkTerm "business_N" ;
lin businesslike_A = mkTerm "businesslike_A" ;
lin businessman_N = mkTerm "businessman_N" ;
lin businessperson_N = mkTerm "businessperson_N" ;
lin businesswoman_N = mkTerm "businesswoman_N" ;
lin busker_N = mkTerm "busker_N" ;
lin buskin_N = mkTerm "buskin_N" ;
lin busload_N = mkTerm "busload_N" ;
lin busman_N = mkTerm "busman_N" ;
lin buspirone_N = mkTerm "buspirone_N" ;
lin bust_N = mkTerm "bust_N" ;
lin bust_V = mkTerm "bust_V" ;
lin bust_V2 = mkTerm "bust_V2" ;
lin bust_up_N = mkTerm "bust_up_N" ;
lin bust_up_V = mkTerm "bust_up_V" ;
lin bustard_N = mkTerm "bustard_N" ;
lin buster_N = mkTerm "buster_N" ;
lin bustier_N = mkTerm "bustier_N" ;
lin bustle_N = mkTerm "bustle_N" ;
lin bustle_V = mkTerm "bustle_V" ;
lin bustle_V2 = mkTerm "bustle_V2" ;
lin busy_A = mkTerm "busy_A" ;
lin busy_V2 = mkTerm "busy_V2" ;
lin busybody_N = mkTerm "busybody_N" ;
lin busyness_N = mkTerm "busyness_N" ;
lin busywork_N = mkTerm "busywork_N" ;
lin but_Adv = mkTerm "but_Adv" ;
lin but_Conj = mkTerm "but_Conj" ;
lin but_N = mkTerm "but_N" ;
lin but_Prep = mkTerm "but_Prep" ;
lin butacaine_N = mkTerm "butacaine_N" ;
lin butadiene_N = mkTerm "butadiene_N" ;
lin butane_N = mkTerm "butane_N" ;
lin butanone_N = mkTerm "butanone_N" ;
lin butch_A = mkTerm "butch_A" ;
lin butch_N = mkTerm "butch_N" ;
lin butcher_N = mkTerm "butcher_N" ;
lin butcher_V2 = mkTerm "butcher_V2" ;
lin butcherbird_N = mkTerm "butcherbird_N" ;
lin butchery_N = mkTerm "butchery_N" ;
lin buteonine_A = mkTerm "buteonine_A" ;
lin buteonine_N = mkTerm "buteonine_N" ;
lin butler_N = mkTerm "butler_N" ;
lin butt_N = mkTerm "butt_N" ;
lin butt_V = mkTerm "butt_V" ;
lin butt_V2 = mkTerm "butt_V2" ;
lin butt_in_V = mkTerm "butt_in_V" ;
lin butt_out_V = mkTerm "butt_out_V" ;
lin butte_N = mkTerm "butte_N" ;
lin butter_N = mkTerm "butter_N" ;
lin butter_V2 = mkTerm "butter_V2" ;
lin butter_up_V2 = mkTerm "butter_up_V2" ;
lin butterbean_N = mkTerm "butterbean_N" ;
lin butterbur_N = mkTerm "butterbur_N" ;
lin buttercrunch_N = mkTerm "buttercrunch_N" ;
lin buttercup_N = mkTerm "buttercup_N" ;
lin butterfat_N = mkTerm "butterfat_N" ;
lin butterfingers_N = mkTerm "butterfingers_N" ;
lin butterfish_N = mkTerm "butterfish_N" ;
lin butterfly_N = mkTerm "butterfly_N" ;
lin buttermilk_N = mkTerm "buttermilk_N" ;
lin butternut_N = mkTerm "butternut_N" ;
lin butterscotch_N = mkTerm "butterscotch_N" ;
lin butterweed_N = mkTerm "butterweed_N" ;
lin butterwort_N = mkTerm "butterwort_N" ;
lin buttery_A = mkTerm "buttery_A" ;
lin buttery_N = mkTerm "buttery_N" ;
lin buttinsky_N = mkTerm "buttinsky_N" ;
lin buttock_N = mkTerm "buttock_N" ;
lin buttocks_N = mkTerm "buttocks_N" ;
lin button_N = mkTerm "button_N" ;
lin button_V = mkTerm "button_V" ;
lin button_V2 = mkTerm "button_V2" ;
lin buttoned_up_A = mkTerm "buttoned_up_A" ;
lin buttonhole_N = mkTerm "buttonhole_N" ;
lin buttonhole_V2 = mkTerm "buttonhole_V2" ;
lin buttonhook_N = mkTerm "buttonhook_N" ;
lin buttonwood_N = mkTerm "buttonwood_N" ;
lin buttony_A = mkTerm "buttony_A" ;
lin buttress_N = mkTerm "buttress_N" ;
lin buttress_V2 = mkTerm "buttress_V2" ;
lin butty_N = mkTerm "butty_N" ;
lin butut_N = mkTerm "butut_N" ;
lin butyl_N = mkTerm "butyl_N" ;
lin butylene_N = mkTerm "butylene_N" ;
lin butyraceous_A = mkTerm "butyraceous_A" ;
lin butyric_A = mkTerm "butyric_A" ;
lin butyrin_N = mkTerm "butyrin_N" ;
lin buxom_A = mkTerm "buxom_A" ;
lin buxomness_N = mkTerm "buxomness_N" ;
lin buxton_PN = mkTerm "buxton_PN" ;
lin buy_N = mkTerm "buy_N" ;
lin buy_V = mkTerm "buy_V" ;
lin buy_V2 = mkTerm "buy_V2" ;
lin buy_back_V2 = mkTerm "buy_back_V2" ;
lin buy_in_V2 = mkTerm "buy_in_V2" ;
lin buy_into_V2 = mkTerm "buy_into_V2" ;
lin buy_off_V2 = mkTerm "buy_off_V2" ;
lin buy_out_V2 = mkTerm "buy_out_V2" ;
lin buy_up_V2 = mkTerm "buy_up_V2" ;
lin buyerFem_N = mkTerm "buyerFem_N" ;
lin buyerMasc_N = mkTerm "buyerMasc_N" ;
lin buying_N = mkTerm "buying_N" ;
lin buyout_N = mkTerm "buyout_N" ;
lin buzz_N = mkTerm "buzz_N" ;
lin buzz_V = mkTerm "buzz_V" ;
lin buzz_V2 = mkTerm "buzz_V2" ;
lin buzz_around_V2 = mkTerm "buzz_around_V2" ;
lin buzz_off_V = mkTerm "buzz_off_V" ;
lin buzzard_N = mkTerm "buzzard_N" ;
lin buzzer_N = mkTerm "buzzer_N" ;
lin buzzword_N = mkTerm "buzzword_N" ;
lin bvm_N = mkTerm "bvm_N" ;
lin by_Adv = mkTerm "by_Adv" ;
lin by_Prep = mkTerm "by_Prep" ;
lin by_and_large_Adv = mkTerm "by_and_large_Adv" ;
lin by_election_N = mkTerm "by_election_N" ;
lin by_means_of_Prep = mkTerm "by_means_of_Prep" ;
lin by_virtue_of_Prep = mkTerm "by_virtue_of_Prep" ;
lin bye_Interj = mkTerm "bye_Interj" ;
lin bye_N = mkTerm "bye_N" ;
lin bye_bye_Interj = mkTerm "bye_bye_Interj" ;
lin bye_law_N = mkTerm "bye_law_N" ;
lin bygone_A = mkTerm "bygone_A" ;
lin bygone_N = mkTerm "bygone_N" ;
lin bylaw_N = mkTerm "bylaw_N" ;
lin bypass_N = mkTerm "bypass_N" ;
lin bypass_V2 = mkTerm "bypass_V2" ;
lin bypath_N = mkTerm "bypath_N" ;
lin byplay_N = mkTerm "byplay_N" ;
lin byproduct_N = mkTerm "byproduct_N" ;
lin byroad_N = mkTerm "byroad_N" ;
lin byssus_N = mkTerm "byssus_N" ;
lin bystander_N = mkTerm "bystander_N" ;
lin byte_N = mkTerm "byte_N" ;
lin byway_N = mkTerm "byway_N" ;
lin byword_N = mkTerm "byword_N" ;
lin byzantine_A = mkTerm "byzantine_A" ;
lin c_in_c_PN = mkTerm "c_in_c_PN" ;
lin c_of_e_N = mkTerm "c_of_e_N" ;
lin ca'canny_N = mkTerm "ca'canny_N" ;
lin cab_N = mkTerm "cab_N" ;
lin cab_rank_N = mkTerm "cab_rank_N" ;
lin cabal_N = mkTerm "cabal_N" ;
lin cabala_N = mkTerm "cabala_N" ;
lin cabalist_N = mkTerm "cabalist_N" ;
lin cabalistic_A = mkTerm "cabalistic_A" ;
lin cabana_N = mkTerm "cabana_N" ;
lin cabaret_N = mkTerm "cabaret_N" ;
lin cabbage_N = mkTerm "cabbage_N" ;
lin cabbageworm_N = mkTerm "cabbageworm_N" ;
lin cabby_N = mkTerm "cabby_N" ;
lin caber_N = mkTerm "caber_N" ;
lin cabin_N = mkTerm "cabin_N" ;
lin cabinet_N = mkTerm "cabinet_N" ;
lin cabinet_maker_N = mkTerm "cabinet_maker_N" ;
lin cabinetmaking_N = mkTerm "cabinetmaking_N" ;
lin cabinetwork_N = mkTerm "cabinetwork_N" ;
lin cable's_length_N = mkTerm "cable's_length_N" ;
lin cable_N = mkTerm "cable_N" ;
lin cable_V = mkTerm "cable_V" ;
lin cable_V2 = mkTerm "cable_V2" ;
lin cable_car_N = mkTerm "cable_car_N" ;
lin cable_length_N = mkTerm "cable_length_N" ;
lin cable_railway_N = mkTerm "cable_railway_N" ;
lin cablegram_N = mkTerm "cablegram_N" ;
lin cabman_N = mkTerm "cabman_N" ;
lin cabochon_N = mkTerm "cabochon_N" ;
lin caboodle_N = mkTerm "caboodle_N" ;
lin caboose_N = mkTerm "caboose_N" ;
lin cabotage_N = mkTerm "cabotage_N" ;
lin cabstand_N = mkTerm "cabstand_N" ;
lin cacao_N = mkTerm "cacao_N" ;
lin cacao_bean_N = mkTerm "cacao_bean_N" ;
lin cacao_tree_N = mkTerm "cacao_tree_N" ;
lin cache_N = mkTerm "cache_N" ;
lin cache_V2 = mkTerm "cache_V2" ;
lin cachectic_A = mkTerm "cachectic_A" ;
lin cachet_N = mkTerm "cachet_N" ;
lin cachexia_N = mkTerm "cachexia_N" ;
lin cachinnation_N = mkTerm "cachinnation_N" ;
lin cachou_N = mkTerm "cachou_N" ;
lin cacique_N = mkTerm "cacique_N" ;
lin cackle_N = mkTerm "cackle_N" ;
lin cackle_V = mkTerm "cackle_V" ;
lin cackler_N = mkTerm "cackler_N" ;
lin cackly_A = mkTerm "cackly_A" ;
lin cacodemon_N = mkTerm "cacodemon_N" ;
lin cacodemonic_A = mkTerm "cacodemonic_A" ;
lin cacodyl_N = mkTerm "cacodyl_N" ;
lin cacodylic_A = mkTerm "cacodylic_A" ;
lin cacogenesis_N = mkTerm "cacogenesis_N" ;
lin cacophonous_A = mkTerm "cacophonous_A" ;
lin cacophony_N = mkTerm "cacophony_N" ;
lin cactus_N = mkTerm "cactus_N" ;
lin cacuminal_A = mkTerm "cacuminal_A" ;
lin cad_N = mkTerm "cad_N" ;
lin cadaster_N = mkTerm "cadaster_N" ;
lin cadastral_A = mkTerm "cadastral_A" ;
lin cadaver_N = mkTerm "cadaver_N" ;
lin cadaverine_N = mkTerm "cadaverine_N" ;
lin cadaverous_A = mkTerm "cadaverous_A" ;
lin caddie_N = mkTerm "caddie_N" ;
lin caddish_A = mkTerm "caddish_A" ;
lin caddisworm_N = mkTerm "caddisworm_N" ;
lin caddy_N = mkTerm "caddy_N" ;
lin cadence_N = mkTerm "cadence_N" ;
lin cadenced_A = mkTerm "cadenced_A" ;
lin cadenza_N = mkTerm "cadenza_N" ;
lin cadet_N = mkTerm "cadet_N" ;
lin cadetship_N = mkTerm "cadetship_N" ;
lin cadge_V = mkTerm "cadge_V" ;
lin cadge_V2 = mkTerm "cadge_V2" ;
lin cadger_N = mkTerm "cadger_N" ;
lin cadiz_PN = mkTerm "cadiz_PN" ;
lin cadmium_N = mkTerm "cadmium_N" ;
lin cadre_N = mkTerm "cadre_N" ;
lin caducean_A = mkTerm "caducean_A" ;
lin caduceus_N = mkTerm "caduceus_N" ;
lin caducous_A = mkTerm "caducous_A" ;
lin caecilian_A = mkTerm "caecilian_A" ;
lin caecilian_N = mkTerm "caecilian_N" ;
lin caen_PN = mkTerm "caen_PN" ;
lin caerleon_PN = mkTerm "caerleon_PN" ;
lin caernarfon_PN = mkTerm "caernarfon_PN" ;
lin caerphilly_PN = mkTerm "caerphilly_PN" ;
lin caesar_N = mkTerm "caesar_N" ;
lin caesarian_A = mkTerm "caesarian_A" ;
lin caespitose_A = mkTerm "caespitose_A" ;
lin caesura_N = mkTerm "caesura_N" ;
lin caesural_A = mkTerm "caesural_A" ;
lin cafe_N = mkTerm "cafe_N" ;
lin cafe_au_lait_N = mkTerm "cafe_au_lait_N" ;
lin cafeteria_N = mkTerm "cafeteria_N" ;
lin caff_N = mkTerm "caff_N" ;
lin caffeine_N = mkTerm "caffeine_N" ;
lin caffeinic_A = mkTerm "caffeinic_A" ;
lin caffeinism_N = mkTerm "caffeinism_N" ;
lin caftan_N = mkTerm "caftan_N" ;
lin cage_N = mkTerm "cage_N" ;
lin cage_V2 = mkTerm "cage_V2" ;
lin cagey_A = mkTerm "cagey_A" ;
lin cagily_Adv = mkTerm "cagily_Adv" ;
lin cagliari_PN = mkTerm "cagliari_PN" ;
lin cagoule_N = mkTerm "cagoule_N" ;
lin cahoot_N = mkTerm "cahoot_N" ;
lin caiman_N = mkTerm "caiman_N" ;
lin cairn_N = mkTerm "cairn_N" ;
lin cairned_A = mkTerm "cairned_A" ;
lin cairngorm_N = mkTerm "cairngorm_N" ;
lin cairo_PN = mkTerm "cairo_PN" ;
lin caisson_N = mkTerm "caisson_N" ;
lin caitiff_A = mkTerm "caitiff_A" ;
lin caitiff_N = mkTerm "caitiff_N" ;
lin cajole_V2 = mkTerm "cajole_V2" ;
lin cajolery_N = mkTerm "cajolery_N" ;
lin cake_N = mkTerm "cake_N" ;
lin cake_V = mkTerm "cake_V" ;
lin cake_V2 = mkTerm "cake_V2" ;
lin cakewalk_N = mkTerm "cakewalk_N" ;
lin calaba_N = mkTerm "calaba_N" ;
lin calabash_N = mkTerm "calabash_N" ;
lin caladenia_N = mkTerm "caladenia_N" ;
lin caladium_N = mkTerm "caladium_N" ;
lin calamint_N = mkTerm "calamint_N" ;
lin calamitous_A = mkTerm "calamitous_A" ;
lin calamity_N = mkTerm "calamity_N" ;
lin calamus_N = mkTerm "calamus_N" ;
lin calando_A = mkTerm "calando_A" ;
lin calanthe_N = mkTerm "calanthe_N" ;
lin calash_N = mkTerm "calash_N" ;
lin calcaneal_A = mkTerm "calcaneal_A" ;
lin calcareous_A = mkTerm "calcareous_A" ;
lin calced_A = mkTerm "calced_A" ;
lin calceolaria_N = mkTerm "calceolaria_N" ;
lin calceolate_A = mkTerm "calceolate_A" ;
lin calceus_N = mkTerm "calceus_N" ;
lin calcic_A = mkTerm "calcic_A" ;
lin calcicolous_A = mkTerm "calcicolous_A" ;
lin calciferous_A = mkTerm "calciferous_A" ;
lin calcific_A = mkTerm "calcific_A" ;
lin calcification_N = mkTerm "calcification_N" ;
lin calcifugous_A = mkTerm "calcifugous_A" ;
lin calcify_V = mkTerm "calcify_V" ;
lin calcify_V2 = mkTerm "calcify_V2" ;
lin calcimine_N = mkTerm "calcimine_N" ;
lin calcination_N = mkTerm "calcination_N" ;
lin calcine_V = mkTerm "calcine_V" ;
lin calcine_V2 = mkTerm "calcine_V2" ;
lin calcite_N = mkTerm "calcite_N" ;
lin calcitic_A = mkTerm "calcitic_A" ;
lin calcitonin_N = mkTerm "calcitonin_N" ;
lin calcium_N = mkTerm "calcium_N" ;
lin calculable_A = mkTerm "calculable_A" ;
lin calculate_V = mkTerm "calculate_V" ;
lin calculate_V2 = mkTerm "calculate_V2" ;
lin calculate_VS = mkTerm "calculate_VS" ;
lin calculatingly_Adv = mkTerm "calculatingly_Adv" ;
lin calculation_N = mkTerm "calculation_N" ;
lin calculator_N = mkTerm "calculator_N" ;
lin calculous_A = mkTerm "calculous_A" ;
lin calculus_N = mkTerm "calculus_N" ;
lin calcutta_PN = mkTerm "calcutta_PN" ;
lin caldera_N = mkTerm "caldera_N" ;
lin caldicot_PN = mkTerm "caldicot_PN" ;
lin caldron_N = mkTerm "caldron_N" ;
lin calefacient_A = mkTerm "calefacient_A" ;
lin calefaction_N = mkTerm "calefaction_N" ;
lin calefactory_A = mkTerm "calefactory_A" ;
lin calendar_N = mkTerm "calendar_N" ;
lin calender_N = mkTerm "calender_N" ;
lin calender_V2 = mkTerm "calender_V2" ;
lin calendric_A = mkTerm "calendric_A" ;
lin calendula_N = mkTerm "calendula_N" ;
lin calf_N = mkTerm "calf_N" ;
lin calf_love_N = mkTerm "calf_love_N" ;
lin cali_PN = mkTerm "cali_PN" ;
lin caliber_N = mkTerm "caliber_N" ;
lin calibrate_V2 = mkTerm "calibrate_V2" ;
lin calibration_N = mkTerm "calibration_N" ;
lin calibre_N = mkTerm "calibre_N" ;
lin caliche_N = mkTerm "caliche_N" ;
lin calico_A = mkTerm "calico_A" ;
lin calico_N = mkTerm "calico_N" ;
lin calif_N = mkTerm "calif_N" ;
lin california_PN = mkTerm "california_PN" ;
lin californian_A = mkTerm "californian_A" ;
lin californian_N = mkTerm "californian_N" ;
lin californium_N = mkTerm "californium_N" ;
lin caliginous_A = mkTerm "caliginous_A" ;
lin caliper_N = mkTerm "caliper_N" ;
lin caliph_N = mkTerm "caliph_N" ;
lin caliphate_N = mkTerm "caliphate_N" ;
lin calisaya_N = mkTerm "calisaya_N" ;
lin calisthenic_A = mkTerm "calisthenic_A" ;
lin calisthenics_N = mkTerm "calisthenics_N" ;
lin calk_N = mkTerm "calk_N" ;
lin calk_V2 = mkTerm "calk_V2" ;
lin call_N = mkTerm "call_N" ;
lin call_V = mkTerm "call_V" ;
lin call_V2 = mkTerm "call_V2" ;
lin call_after_V2 = mkTerm "call_after_V2" ;
lin call_around_V = mkTerm "call_around_V" ;
lin call_back_V2 = mkTerm "call_back_V2" ;
lin call_box_N = mkTerm "call_box_N" ;
lin call_for_V2V = mkTerm "call_for_V2V" ;
lin call_forth_V2 = mkTerm "call_forth_V2" ;
lin call_girl_N = mkTerm "call_girl_N" ;
lin call_in_V = mkTerm "call_in_V" ;
lin call_in_V2 = mkTerm "call_in_V2" ;
lin call_off_V2 = mkTerm "call_off_V2" ;
lin call_on_V = mkTerm "call_on_V" ;
lin call_on_V2 = mkTerm "call_on_V2" ;
lin call_out_V2 = mkTerm "call_out_V2" ;
lin call_over_N = mkTerm "call_over_N" ;
lin call_over_V = mkTerm "call_over_V" ;
lin call_round_V = mkTerm "call_round_V" ;
lin call_up_N = mkTerm "call_up_N" ;
lin call_up_V2 = mkTerm "call_up_V2" ;
lin callable_A = mkTerm "callable_A" ;
lin called_A = mkTerm "called_A" ;
lin caller_A = mkTerm "caller_A" ;
lin caller_N = mkTerm "caller_N" ;
lin calliandra_N = mkTerm "calliandra_N" ;
lin calligrapher_N = mkTerm "calligrapher_N" ;
lin calligraphic_A = mkTerm "calligraphic_A" ;
lin calligraphy_N = mkTerm "calligraphy_N" ;
lin calling_N = mkTerm "calling_N" ;
lin calliope_N = mkTerm "calliope_N" ;
lin calliopsis_N = mkTerm "calliopsis_N" ;
lin callipygian_A = mkTerm "callipygian_A" ;
lin callisthenics_N = mkTerm "callisthenics_N" ;
lin callithump_N = mkTerm "callithump_N" ;
lin callithumpian_A = mkTerm "callithumpian_A" ;
lin callosity_N = mkTerm "callosity_N" ;
lin callosotomy_N = mkTerm "callosotomy_N" ;
lin callous_A = mkTerm "callous_A" ;
lin calloused_A = mkTerm "calloused_A" ;
lin callousness_N = mkTerm "callousness_N" ;
lin callow_A = mkTerm "callow_A" ;
lin callowness_N = mkTerm "callowness_N" ;
lin callsign_N = mkTerm "callsign_N" ;
lin callus_N = mkTerm "callus_N" ;
lin calm_A = mkTerm "calm_A" ;
lin calm_N = mkTerm "calm_N" ;
lin calm_V = mkTerm "calm_V" ;
lin calm_V2 = mkTerm "calm_V2" ;
lin calm_down_V2 = mkTerm "calm_down_V2" ;
lin calme_down_V = mkTerm "calme_down_V" ;
lin calmness_N = mkTerm "calmness_N" ;
lin calne_PN = mkTerm "calne_PN" ;
lin calomel_N = mkTerm "calomel_N" ;
lin calor_PN = mkTerm "calor_PN" ;
lin caloric_A = mkTerm "caloric_A" ;
lin calorie_N = mkTerm "calorie_N" ;
lin calorifacient_A = mkTerm "calorifacient_A" ;
lin calorific_A = mkTerm "calorific_A" ;
lin calorimeter_N = mkTerm "calorimeter_N" ;
lin calorimetric_A = mkTerm "calorimetric_A" ;
lin calorimetry_N = mkTerm "calorimetry_N" ;
lin calosoma_N = mkTerm "calosoma_N" ;
lin calpac_N = mkTerm "calpac_N" ;
lin calque_N = mkTerm "calque_N" ;
lin caltrop_N = mkTerm "caltrop_N" ;
lin calumet_N = mkTerm "calumet_N" ;
lin calumniate_V2 = mkTerm "calumniate_V2" ;
lin calumniatory_A = mkTerm "calumniatory_A" ;
lin calumny_N = mkTerm "calumny_N" ;
lin calvaria_N = mkTerm "calvaria_N" ;
lin calvary_N = mkTerm "calvary_N" ;
lin calve_V = mkTerm "calve_V" ;
lin calverton_PN = mkTerm "calverton_PN" ;
lin calving_N = mkTerm "calving_N" ;
lin calvinism_N = mkTerm "calvinism_N" ;
lin calvinist_N = mkTerm "calvinist_N" ;
lin calyceal_A = mkTerm "calyceal_A" ;
lin calycular_A = mkTerm "calycular_A" ;
lin calyculate_A = mkTerm "calyculate_A" ;
lin calyculus_N = mkTerm "calyculus_N" ;
lin calypso_N = mkTerm "calypso_N" ;
lin calyptra_N = mkTerm "calyptra_N" ;
lin calyptrate_A = mkTerm "calyptrate_A" ;
lin calyx_N = mkTerm "calyx_N" ;
lin cam_N = mkTerm "cam_N" ;
lin camail_N = mkTerm "camail_N" ;
lin camaraderie_N = mkTerm "camaraderie_N" ;
lin camas_N = mkTerm "camas_N" ;
lin camber_N = mkTerm "camber_N" ;
lin camber_V = mkTerm "camber_V" ;
lin camber_V2 = mkTerm "camber_V2" ;
lin cambial_A = mkTerm "cambial_A" ;
lin cambium_N = mkTerm "cambium_N" ;
lin cambodia_PN = mkTerm "cambodia_PN" ;
lin cambodian_A = mkTerm "cambodian_A" ;
lin cambodian_N = mkTerm "cambodian_N" ;
lin cambourne_PN = mkTerm "cambourne_PN" ;
lin cambric_N = mkTerm "cambric_N" ;
lin cambridge_PN = mkTerm "cambridge_PN" ;
lin cambridgeshire_PN = mkTerm "cambridgeshire_PN" ;
lin cambuslang_PN = mkTerm "cambuslang_PN" ;
lin camcorder_N = mkTerm "camcorder_N" ;
lin camden_PN = mkTerm "camden_PN" ;
lin camel_N = mkTerm "camel_N" ;
lin camel_hair_N = mkTerm "camel_hair_N" ;
lin camellia_N = mkTerm "camellia_N" ;
lin camelpox_N = mkTerm "camelpox_N" ;
lin camembert_N = mkTerm "camembert_N" ;
lin cameo_N = mkTerm "cameo_N" ;
lin camera_N = mkTerm "camera_N" ;
lin cameraman_N = mkTerm "cameraman_N" ;
lin cameroon_PN = mkTerm "cameroon_PN" ;
lin cameroonian_A = mkTerm "cameroonian_A" ;
lin cameroonian_N = mkTerm "cameroonian_N" ;
lin camion_N = mkTerm "camion_N" ;
lin camise_N = mkTerm "camise_N" ;
lin camisole_N = mkTerm "camisole_N" ;
lin camlet_N = mkTerm "camlet_N" ;
lin camomile_N = mkTerm "camomile_N" ;
lin camouflage_N = mkTerm "camouflage_N" ;
lin camouflage_V2 = mkTerm "camouflage_V2" ;
lin camp_A = mkTerm "camp_A" ;
lin camp_N = mkTerm "camp_N" ;
lin camp_V = mkTerm "camp_V" ;
lin camp_V2 = mkTerm "camp_V2" ;
lin camp_bed_N = mkTerm "camp_bed_N" ;
lin camp_chair_N = mkTerm "camp_chair_N" ;
lin camp_fire_N = mkTerm "camp_fire_N" ;
lin camp_follower_N = mkTerm "camp_follower_N" ;
lin camp_out_V = mkTerm "camp_out_V" ;
lin camp_stool_N = mkTerm "camp_stool_N" ;
lin campaign_N = mkTerm "campaign_N" ;
lin campaign_V = mkTerm "campaign_V" ;
lin campaigner_N = mkTerm "campaigner_N" ;
lin campaigning_N = mkTerm "campaigning_N" ;
lin campanile_N = mkTerm "campanile_N" ;
lin campanula_N = mkTerm "campanula_N" ;
lin campanulate_A = mkTerm "campanulate_A" ;
lin campbeltown_PN = mkTerm "campbeltown_PN" ;
lin camper_N = mkTerm "camper_N" ;
lin campestral_A = mkTerm "campestral_A" ;
lin camphor_N = mkTerm "camphor_N" ;
lin camphoraceous_A = mkTerm "camphoraceous_A" ;
lin camphorated_A = mkTerm "camphorated_A" ;
lin camphoric_A = mkTerm "camphoric_A" ;
lin camping_N = mkTerm "camping_N" ;
lin campion_N = mkTerm "campion_N" ;
lin campmate_N = mkTerm "campmate_N" ;
lin campsite_N = mkTerm "campsite_N" ;
lin campus_N = mkTerm "campus_N" ;
lin campylotropous_A = mkTerm "campylotropous_A" ;
lin camshaft_N = mkTerm "camshaft_N" ;
lin camwood_N = mkTerm "camwood_N" ;
lin can_1_VV = mkTerm "can_1_VV" ;
lin can_2_VV = mkTerm "can_2_VV" ;
lin can_N = mkTerm "can_N" ;
lin can_V2 = mkTerm "can_V2" ;
lin canada_PN = mkTerm "canada_PN" ;
lin canadian_A = mkTerm "canadian_A" ;
lin canadian_N = mkTerm "canadian_N" ;
lin canal_N = mkTerm "canal_N" ;
lin canalicular_A = mkTerm "canalicular_A" ;
lin canaliculate_A = mkTerm "canaliculate_A" ;
lin canaliculus_N = mkTerm "canaliculus_N" ;
lin canalization_N = mkTerm "canalization_N" ;
lin canalize_V2 = mkTerm "canalize_V2" ;
lin canape_N = mkTerm "canape_N" ;
lin canard_N = mkTerm "canard_N" ;
lin canary_A = mkTerm "canary_A" ;
lin canary_N = mkTerm "canary_N" ;
lin canary_bird_N = mkTerm "canary_bird_N" ;
lin canary_wine_N = mkTerm "canary_wine_N" ;
lin canasta_N = mkTerm "canasta_N" ;
lin canavanine_N = mkTerm "canavanine_N" ;
lin canberra_PN = mkTerm "canberra_PN" ;
lin cancan_N = mkTerm "cancan_N" ;
lin cancel_V = mkTerm "cancel_V" ;
lin cancel_V2 = mkTerm "cancel_V2" ;
lin cancel_out_V2 = mkTerm "cancel_out_V2" ;
lin cancellate_A = mkTerm "cancellate_A" ;
lin cancellation_N = mkTerm "cancellation_N" ;
lin cancer_N = mkTerm "cancer_N" ;
lin cancer_PN = mkTerm "cancer_PN" ;
lin cancerous_A = mkTerm "cancerous_A" ;
lin cancerweed_N = mkTerm "cancerweed_N" ;
lin cancroid_A = mkTerm "cancroid_A" ;
lin cancroid_N = mkTerm "cancroid_N" ;
lin candelabrum_N = mkTerm "candelabrum_N" ;
lin candelilla_N = mkTerm "candelilla_N" ;
lin candescent_A = mkTerm "candescent_A" ;
lin candid_A = mkTerm "candid_A" ;
lin candida_N = mkTerm "candida_N" ;
lin candidacy_N = mkTerm "candidacy_N" ;
lin candidateFem_N = mkTerm "candidateFem_N" ;
lin candidateMasc_N = mkTerm "candidateMasc_N" ;
lin candidature_N = mkTerm "candidature_N" ;
lin candidiasis_N = mkTerm "candidiasis_N" ;
lin candle_N = mkTerm "candle_N" ;
lin candle_power_N = mkTerm "candle_power_N" ;
lin candlelight_N = mkTerm "candlelight_N" ;
lin candlemaker_N = mkTerm "candlemaker_N" ;
lin candlenut_N = mkTerm "candlenut_N" ;
lin candlepin_N = mkTerm "candlepin_N" ;
lin candlepins_N = mkTerm "candlepins_N" ;
lin candlesnuffer_N = mkTerm "candlesnuffer_N" ;
lin candlestick_N = mkTerm "candlestick_N" ;
lin candlewick_N = mkTerm "candlewick_N" ;
lin candlewood_N = mkTerm "candlewood_N" ;
lin candor_N = mkTerm "candor_N" ;
lin candour_N = mkTerm "candour_N" ;
lin candy_N = mkTerm "candy_N" ;
lin candy_V = mkTerm "candy_V" ;
lin candy_V2 = mkTerm "candy_V2" ;
lin candy_floss_N = mkTerm "candy_floss_N" ;
lin candytuft_N = mkTerm "candytuft_N" ;
lin cane_N = mkTerm "cane_N" ;
lin cane_V2 = mkTerm "cane_V2" ;
lin canebrake_N = mkTerm "canebrake_N" ;
lin canella_N = mkTerm "canella_N" ;
lin canescent_A = mkTerm "canescent_A" ;
lin canfield_N = mkTerm "canfield_N" ;
lin cangue_N = mkTerm "cangue_N" ;
lin canicular_A = mkTerm "canicular_A" ;
lin canine_A = mkTerm "canine_A" ;
lin canine_N = mkTerm "canine_N" ;
lin canistel_N = mkTerm "canistel_N" ;
lin canister_N = mkTerm "canister_N" ;
lin canker_N = mkTerm "canker_N" ;
lin canker_V2 = mkTerm "canker_V2" ;
lin cankerous_A = mkTerm "cankerous_A" ;
lin cankerworm_N = mkTerm "cankerworm_N" ;
lin canna_N = mkTerm "canna_N" ;
lin cannabin_N = mkTerm "cannabin_N" ;
lin cannabis_N = mkTerm "cannabis_N" ;
lin cannelloni_N = mkTerm "cannelloni_N" ;
lin cannery_N = mkTerm "cannery_N" ;
lin cannes_PN = mkTerm "cannes_PN" ;
lin cannibal_N = mkTerm "cannibal_N" ;
lin cannibalic_A = mkTerm "cannibalic_A" ;
lin cannibalism_N = mkTerm "cannibalism_N" ;
lin cannibalistic_A = mkTerm "cannibalistic_A" ;
lin cannibalize_V2 = mkTerm "cannibalize_V2" ;
lin cannikin_N = mkTerm "cannikin_N" ;
lin cannock_PN = mkTerm "cannock_PN" ;
lin cannon_1_N = mkTerm "cannon_1_N" ;
lin cannon_2_N = mkTerm "cannon_2_N" ;
lin cannon_fodder_N = mkTerm "cannon_fodder_N" ;
lin cannonade_N = mkTerm "cannonade_N" ;
lin cannonball_N = mkTerm "cannonball_N" ;
lin cannula_N = mkTerm "cannula_N" ;
lin cannulation_N = mkTerm "cannulation_N" ;
lin canny_A = mkTerm "canny_A" ;
lin canoe_N = mkTerm "canoe_N" ;
lin canoe_V2 = mkTerm "canoe_V2" ;
lin canoeist_N = mkTerm "canoeist_N" ;
lin canon_N = mkTerm "canon_N" ;
lin canonic_A = mkTerm "canonic_A" ;
lin canonical_A = mkTerm "canonical_A" ;
lin canonist_A = mkTerm "canonist_A" ;
lin canonist_N = mkTerm "canonist_N" ;
lin canonization_N = mkTerm "canonization_N" ;
lin canonize_V2 = mkTerm "canonize_V2" ;
lin canopied_A = mkTerm "canopied_A" ;
lin canopy_N = mkTerm "canopy_N" ;
lin canorous_A = mkTerm "canorous_A" ;
lin cant_N = mkTerm "cant_N" ;
lin cant_V = mkTerm "cant_V" ;
lin cant_V2 = mkTerm "cant_V2" ;
lin cantab_PN = mkTerm "cantab_PN" ;
lin cantabile_A = mkTerm "cantabile_A" ;
lin cantala_N = mkTerm "cantala_N" ;
lin cantaloupe_N = mkTerm "cantaloupe_N" ;
lin cantankerous_A = mkTerm "cantankerous_A" ;
lin cantata_N = mkTerm "cantata_N" ;
lin canteen_N = mkTerm "canteen_N" ;
lin canter_N = mkTerm "canter_N" ;
lin canter_V = mkTerm "canter_V" ;
lin canter_V2 = mkTerm "canter_V2" ;
lin canterbury_PN = mkTerm "canterbury_PN" ;
lin canthus_N = mkTerm "canthus_N" ;
lin canticle_N = mkTerm "canticle_N" ;
lin cantilever_N = mkTerm "cantilever_N" ;
lin cantillation_N = mkTerm "cantillation_N" ;
lin cantle_N = mkTerm "cantle_N" ;
lin canto_N = mkTerm "canto_N" ;
lin canton_N = mkTerm "canton_N" ;
lin canton_PN = mkTerm "canton_PN" ;
lin cantonal_A = mkTerm "cantonal_A" ;
lin cantonment_N = mkTerm "cantonment_N" ;
lin cantor_N = mkTerm "cantor_N" ;
lin canty_A = mkTerm "canty_A" ;
lin canuck_N = mkTerm "canuck_N" ;
lin canvas_N = mkTerm "canvas_N" ;
lin canvasback_N = mkTerm "canvasback_N" ;
lin canvass_N = mkTerm "canvass_N" ;
lin canvass_V = mkTerm "canvass_V" ;
lin canvass_V2 = mkTerm "canvass_V2" ;
lin canvasser_N = mkTerm "canvasser_N" ;
lin canvey_PN = mkTerm "canvey_PN" ;
lin canvey_island_PN = mkTerm "canvey_island_PN" ;
lin canyon_N = mkTerm "canyon_N" ;
lin canyonside_N = mkTerm "canyonside_N" ;
lin cap_1_N = mkTerm "cap_1_N" ;
lin cap_2_N = mkTerm "cap_2_N" ;
lin cap_V2 = mkTerm "cap_V2" ;
lin cap_a_pie_Adv = mkTerm "cap_a_pie_Adv" ;
lin cap_off_V2 = mkTerm "cap_off_V2" ;
lin capability_N = mkTerm "capability_N" ;
lin capable_of_A2 = mkTerm "capable_of_A2" ;
lin capacious_A = mkTerm "capacious_A" ;
lin capaciousness_N = mkTerm "capaciousness_N" ;
lin capacitance_N = mkTerm "capacitance_N" ;
lin capacitive_A = mkTerm "capacitive_A" ;
lin capacitor_N = mkTerm "capacitor_N" ;
lin capacity_N = mkTerm "capacity_N" ;
lin caparison_N = mkTerm "caparison_N" ;
lin caparison_V2 = mkTerm "caparison_V2" ;
lin cape_N = mkTerm "cape_N" ;
lin cape_town_PN = mkTerm "cape_town_PN" ;
lin capelin_N = mkTerm "capelin_N" ;
lin caper_N = mkTerm "caper_N" ;
lin caper_V = mkTerm "caper_V" ;
lin capercaillie_N = mkTerm "capercaillie_N" ;
lin capful_N = mkTerm "capful_N" ;
lin capillarity_N = mkTerm "capillarity_N" ;
lin capillary_A = mkTerm "capillary_A" ;
lin capillary_N = mkTerm "capillary_N" ;
lin capital_1_N = mkTerm "capital_1_N" ;
lin capital_2_N = mkTerm "capital_2_N" ;
lin capital_3_N = mkTerm "capital_3_N" ;
lin capital_A = mkTerm "capital_A" ;
lin capitalism_A = mkTerm "capitalism_A" ;
lin capitalism_N = mkTerm "capitalism_N" ;
lin capitalist_A = mkTerm "capitalist_A" ;
lin capitalist_N = mkTerm "capitalist_N" ;
lin capitalistic_A = mkTerm "capitalistic_A" ;
lin capitalization_N = mkTerm "capitalization_N" ;
lin capitalize_V = mkTerm "capitalize_V" ;
lin capitalize_V2 = mkTerm "capitalize_V2" ;
lin capitate_A = mkTerm "capitate_A" ;
lin capitate_N = mkTerm "capitate_N" ;
lin capitation_N = mkTerm "capitation_N" ;
lin capitol_N = mkTerm "capitol_N" ;
lin capitular_A = mkTerm "capitular_A" ;
lin capitulate_V = mkTerm "capitulate_V" ;
lin capitulate_V2 = mkTerm "capitulate_V2" ;
lin capitulation_N = mkTerm "capitulation_N" ;
lin capitulum_N = mkTerm "capitulum_N" ;
lin capo_N = mkTerm "capo_N" ;
lin capon_N = mkTerm "capon_N" ;
lin capote_N = mkTerm "capote_N" ;
lin cappella_N = mkTerm "cappella_N" ;
lin cappuccino_N = mkTerm "cappuccino_N" ;
lin capriccio_N = mkTerm "capriccio_N" ;
lin caprice_N = mkTerm "caprice_N" ;
lin capricious_A = mkTerm "capricious_A" ;
lin capriciousness_N = mkTerm "capriciousness_N" ;
lin capricorn_PN = mkTerm "capricorn_PN" ;
lin caprifig_N = mkTerm "caprifig_N" ;
lin caprine_A = mkTerm "caprine_A" ;
lin capriole_N = mkTerm "capriole_N" ;
lin capsaicin_N = mkTerm "capsaicin_N" ;
lin capsicum_N = mkTerm "capsicum_N" ;
lin capsid_N = mkTerm "capsid_N" ;
lin capsize_V = mkTerm "capsize_V" ;
lin capsize_V2 = mkTerm "capsize_V2" ;
lin capsizing_N = mkTerm "capsizing_N" ;
lin capstan_N = mkTerm "capstan_N" ;
lin capstone_N = mkTerm "capstone_N" ;
lin capsular_A = mkTerm "capsular_A" ;
lin capsulate_A = mkTerm "capsulate_A" ;
lin capsule_N = mkTerm "capsule_N" ;
lin capt_PN = mkTerm "capt_PN" ;
lin captain_N = mkTerm "captain_N" ;
lin captain_V2 = mkTerm "captain_V2" ;
lin captainship_N = mkTerm "captainship_N" ;
lin caption_N = mkTerm "caption_N" ;
lin captious_A = mkTerm "captious_A" ;
lin captivate_V2 = mkTerm "captivate_V2" ;
lin captivation_N = mkTerm "captivation_N" ;
lin captiveFem_N = mkTerm "captiveFem_N" ;
lin captiveMasc_N = mkTerm "captiveMasc_N" ;
lin captive_A = mkTerm "captive_A" ;
lin captivity_N = mkTerm "captivity_N" ;
lin captopril_N = mkTerm "captopril_N" ;
lin captor_N = mkTerm "captor_N" ;
lin capture_N = mkTerm "capture_N" ;
lin capture_V2 = mkTerm "capture_V2" ;
lin capuchin_N = mkTerm "capuchin_N" ;
lin capulin_N = mkTerm "capulin_N" ;
lin caput_N = mkTerm "caput_N" ;
lin capybara_N = mkTerm "capybara_N" ;
lin car_N = mkTerm "car_N" ;
lin car_V = mkTerm "car_V" ;
lin car_ferry_N = mkTerm "car_ferry_N" ;
lin carabao_N = mkTerm "carabao_N" ;
lin carabiner_N = mkTerm "carabiner_N" ;
lin caracal_N = mkTerm "caracal_N" ;
lin caracara_N = mkTerm "caracara_N" ;
lin caracas_PN = mkTerm "caracas_PN" ;
lin caracolito_N = mkTerm "caracolito_N" ;
lin carafe_N = mkTerm "carafe_N" ;
lin carambola_N = mkTerm "carambola_N" ;
lin caramel_A = mkTerm "caramel_A" ;
lin caramel_N = mkTerm "caramel_N" ;
lin carancha_N = mkTerm "carancha_N" ;
lin caranday_N = mkTerm "caranday_N" ;
lin carangid_A = mkTerm "carangid_A" ;
lin carapace_N = mkTerm "carapace_N" ;
lin carat_N = mkTerm "carat_N" ;
lin caravan_N = mkTerm "caravan_N" ;
lin caravanning_N = mkTerm "caravanning_N" ;
lin caravanserai_N = mkTerm "caravanserai_N" ;
lin caraway_N = mkTerm "caraway_N" ;
lin carbamate_N = mkTerm "carbamate_N" ;
lin carbide_N = mkTerm "carbide_N" ;
lin carbine_N = mkTerm "carbine_N" ;
lin carbineer_N = mkTerm "carbineer_N" ;
lin carbocyclic_A = mkTerm "carbocyclic_A" ;
lin carbohydrate_N = mkTerm "carbohydrate_N" ;
lin carbolated_A = mkTerm "carbolated_A" ;
lin carbolic_A = mkTerm "carbolic_A" ;
lin carbomycin_N = mkTerm "carbomycin_N" ;
lin carbon_N = mkTerm "carbon_N" ;
lin carbon_paper_N = mkTerm "carbon_paper_N" ;
lin carbonaceous_A = mkTerm "carbonaceous_A" ;
lin carbonado_N = mkTerm "carbonado_N" ;
lin carbonara_N = mkTerm "carbonara_N" ;
lin carbonate_N = mkTerm "carbonate_N" ;
lin carbonated_A = mkTerm "carbonated_A" ;
lin carbonation_N = mkTerm "carbonation_N" ;
lin carbonic_A = mkTerm "carbonic_A" ;
lin carboniferous_A = mkTerm "carboniferous_A" ;
lin carbonization_N = mkTerm "carbonization_N" ;
lin carbonize_V2 = mkTerm "carbonize_V2" ;
lin carbonyl_A = mkTerm "carbonyl_A" ;
lin carbonyl_N = mkTerm "carbonyl_N" ;
lin carborundum_N = mkTerm "carborundum_N" ;
lin carboxyl_A = mkTerm "carboxyl_A" ;
lin carboxyl_N = mkTerm "carboxyl_N" ;
lin carboy_N = mkTerm "carboy_N" ;
lin carbuncle_N = mkTerm "carbuncle_N" ;
lin carbuncled_A = mkTerm "carbuncled_A" ;
lin carburettor_N = mkTerm "carburettor_N" ;
lin carcase_N = mkTerm "carcase_N" ;
lin carcass_N = mkTerm "carcass_N" ;
lin carcinogen_N = mkTerm "carcinogen_N" ;
lin carcinogenic_A = mkTerm "carcinogenic_A" ;
lin carcinoid_N = mkTerm "carcinoid_N" ;
lin carcinoma_N = mkTerm "carcinoma_N" ;
lin carcinomatous_A = mkTerm "carcinomatous_A" ;
lin carcinosarcoma_N = mkTerm "carcinosarcoma_N" ;
lin card_1_N = mkTerm "card_1_N" ;
lin card_2_N = mkTerm "card_2_N" ;
lin card_V2 = mkTerm "card_V2" ;
lin card_sharper_N = mkTerm "card_sharper_N" ;
lin cardamom_N = mkTerm "cardamom_N" ;
lin cardboard_A = mkTerm "cardboard_A" ;
lin cardboard_N = mkTerm "cardboard_N" ;
lin cardcase_N = mkTerm "cardcase_N" ;
lin cardenden_PN = mkTerm "cardenden_PN" ;
lin cardholder_N = mkTerm "cardholder_N" ;
lin cardia_N = mkTerm "cardia_N" ;
lin cardiac_A = mkTerm "cardiac_A" ;
lin cardiff_PN = mkTerm "cardiff_PN" ;
lin cardigan_N = mkTerm "cardigan_N" ;
lin cardigan_PN = mkTerm "cardigan_PN" ;
lin cardinal_A = mkTerm "cardinal_A" ;
lin cardinal_N = mkTerm "cardinal_N" ;
lin cardinalate_N = mkTerm "cardinalate_N" ;
lin cardinalfish_N = mkTerm "cardinalfish_N" ;
lin cardinality_N = mkTerm "cardinality_N" ;
lin cardinalship_N = mkTerm "cardinalship_N" ;
lin cardiograph_N = mkTerm "cardiograph_N" ;
lin cardiographic_A = mkTerm "cardiographic_A" ;
lin cardiography_N = mkTerm "cardiography_N" ;
lin cardioid_N = mkTerm "cardioid_N" ;
lin cardiologic_A = mkTerm "cardiologic_A" ;
lin cardiologistFem_N = mkTerm "cardiologistFem_N" ;
lin cardiologistMasc_N = mkTerm "cardiologistMasc_N" ;
lin cardiology_N = mkTerm "cardiology_N" ;
lin cardiomegaly_N = mkTerm "cardiomegaly_N" ;
lin cardiomyopathy_N = mkTerm "cardiomyopathy_N" ;
lin cardiopulmonary_A = mkTerm "cardiopulmonary_A" ;
lin cardiospasm_N = mkTerm "cardiospasm_N" ;
lin cardiovascular_A = mkTerm "cardiovascular_A" ;
lin carditis_N = mkTerm "carditis_N" ;
lin cardoon_N = mkTerm "cardoon_N" ;
lin cardroom_N = mkTerm "cardroom_N" ;
lin cardsharp_N = mkTerm "cardsharp_N" ;
lin care_N = mkTerm "care_N" ;
lin care_V = mkTerm "care_V" ;
lin care_for_V2 = mkTerm "care_for_V2" ;
lin careen_V = mkTerm "careen_V" ;
lin careen_V2 = mkTerm "careen_V2" ;
lin career_N = mkTerm "career_N" ;
lin career_V = mkTerm "career_V" ;
lin careerism_N = mkTerm "careerism_N" ;
lin careerist_N = mkTerm "careerist_N" ;
lin carefree_A = mkTerm "carefree_A" ;
lin carefreeness_N = mkTerm "carefreeness_N" ;
lin careful_A = mkTerm "careful_A" ;
lin carefulness_N = mkTerm "carefulness_N" ;
lin caregiver_N = mkTerm "caregiver_N" ;
lin careladen_A = mkTerm "careladen_A" ;
lin careless_A = mkTerm "careless_A" ;
lin carelessness_N = mkTerm "carelessness_N" ;
lin carer_N = mkTerm "carer_N" ;
lin caress_N = mkTerm "caress_N" ;
lin caress_V2 = mkTerm "caress_V2" ;
lin caressing_A = mkTerm "caressing_A" ;
lin caressing_N = mkTerm "caressing_N" ;
lin caret_N = mkTerm "caret_N" ;
lin caretaker_N = mkTerm "caretaker_N" ;
lin careworn_A = mkTerm "careworn_A" ;
lin carful_N = mkTerm "carful_N" ;
lin cargo_N = mkTerm "cargo_N" ;
lin carhop_N = mkTerm "carhop_N" ;
lin caribou_N = mkTerm "caribou_N" ;
lin caricature_N = mkTerm "caricature_N" ;
lin caricature_V2 = mkTerm "caricature_V2" ;
lin caricaturist_N = mkTerm "caricaturist_N" ;
lin caries_N = mkTerm "caries_N" ;
lin carillon_N = mkTerm "carillon_N" ;
lin carillonneur_N = mkTerm "carillonneur_N" ;
lin carina_N = mkTerm "carina_N" ;
lin carinal_A = mkTerm "carinal_A" ;
lin carinate_N = mkTerm "carinate_N" ;
lin carioca_N = mkTerm "carioca_N" ;
lin carious_A = mkTerm "carious_A" ;
lin carissa_N = mkTerm "carissa_N" ;
lin carjacking_N = mkTerm "carjacking_N" ;
lin carl_PN = mkTerm "carl_PN" ;
lin carlisle_PN = mkTerm "carlisle_PN" ;
lin carload_N = mkTerm "carload_N" ;
lin carlow_PN = mkTerm "carlow_PN" ;
lin carluke_PN = mkTerm "carluke_PN" ;
lin carmarthen_PN = mkTerm "carmarthen_PN" ;
lin carmelite_A = mkTerm "carmelite_A" ;
lin carmelite_N = mkTerm "carmelite_N" ;
lin carminative_A = mkTerm "carminative_A" ;
lin carminative_N = mkTerm "carminative_N" ;
lin carmine_A = mkTerm "carmine_A" ;
lin carmine_N = mkTerm "carmine_N" ;
lin carnage_N = mkTerm "carnage_N" ;
lin carnal_A = mkTerm "carnal_A" ;
lin carnallite_N = mkTerm "carnallite_N" ;
lin carnassial_A = mkTerm "carnassial_A" ;
lin carnation_A = mkTerm "carnation_A" ;
lin carnation_N = mkTerm "carnation_N" ;
lin carnauba_N = mkTerm "carnauba_N" ;
lin carnelian_N = mkTerm "carnelian_N" ;
lin carnforth_PN = mkTerm "carnforth_PN" ;
lin carnival_N = mkTerm "carnival_N" ;
lin carnivore_N = mkTerm "carnivore_N" ;
lin carnivorous_A = mkTerm "carnivorous_A" ;
lin carnosaur_N = mkTerm "carnosaur_N" ;
lin carnotite_N = mkTerm "carnotite_N" ;
lin carnoustie_PN = mkTerm "carnoustie_PN" ;
lin carob_N = mkTerm "carob_N" ;
lin caroche_N = mkTerm "caroche_N" ;
lin carol_N = mkTerm "carol_N" ;
lin carol_PN = mkTerm "carol_PN" ;
lin carol_V2 = mkTerm "carol_V2" ;
lin carole_PN = mkTerm "carole_PN" ;
lin caroler_N = mkTerm "caroler_N" ;
lin carolina_PN = mkTerm "carolina_PN" ;
lin caroline_N = mkTerm "caroline_N" ;
lin caroline_PN = mkTerm "caroline_PN" ;
lin caroling_N = mkTerm "caroling_N" ;
lin caroller_N = mkTerm "caroller_N" ;
lin carolyn_PN = mkTerm "carolyn_PN" ;
lin carom_N = mkTerm "carom_N" ;
lin carotene_N = mkTerm "carotene_N" ;
lin carotenemia_N = mkTerm "carotenemia_N" ;
lin carotenoid_N = mkTerm "carotenoid_N" ;
lin carotid_A = mkTerm "carotid_A" ;
lin carousal_N = mkTerm "carousal_N" ;
lin carouse_N = mkTerm "carouse_N" ;
lin carouse_V2 = mkTerm "carouse_V2" ;
lin carousel_N = mkTerm "carousel_N" ;
lin carp_N = mkTerm "carp_N" ;
lin carp_V = mkTerm "carp_V" ;
lin carp_V2 = mkTerm "carp_V2" ;
lin carpal_A = mkTerm "carpal_A" ;
lin carpal_N = mkTerm "carpal_N" ;
lin carpel_N = mkTerm "carpel_N" ;
lin carpellary_A = mkTerm "carpellary_A" ;
lin carpellate_A = mkTerm "carpellate_A" ;
lin carpenter_N = mkTerm "carpenter_N" ;
lin carpenteria_N = mkTerm "carpenteria_N" ;
lin carpentry_N = mkTerm "carpentry_N" ;
lin carper_N = mkTerm "carper_N" ;
lin carpet_N = mkTerm "carpet_N" ;
lin carpet_V2 = mkTerm "carpet_V2" ;
lin carpet_beater_N = mkTerm "carpet_beater_N" ;
lin carpet_knight_N = mkTerm "carpet_knight_N" ;
lin carpet_sweeper_N = mkTerm "carpet_sweeper_N" ;
lin carpetbag_A = mkTerm "carpetbag_A" ;
lin carpetbag_N = mkTerm "carpetbag_N" ;
lin carpetbagger_N = mkTerm "carpetbagger_N" ;
lin carpetweed_N = mkTerm "carpetweed_N" ;
lin carpophagous_A = mkTerm "carpophagous_A" ;
lin carpophore_N = mkTerm "carpophore_N" ;
lin carport_N = mkTerm "carport_N" ;
lin carpospore_N = mkTerm "carpospore_N" ;
lin carposporic_A = mkTerm "carposporic_A" ;
lin carposporous_A = mkTerm "carposporous_A" ;
lin carrack_N = mkTerm "carrack_N" ;
lin carrageenin_N = mkTerm "carrageenin_N" ;
lin carrel_N = mkTerm "carrel_N" ;
lin carriage_N = mkTerm "carriage_N" ;
lin carriageway_N = mkTerm "carriageway_N" ;
lin carrie_PN = mkTerm "carrie_PN" ;
lin carried_away_V = mkTerm "carried_away_V" ;
lin carrier_N = mkTerm "carrier_N" ;
lin carrier_bag_N = mkTerm "carrier_bag_N" ;
lin carrier_pigeon_N = mkTerm "carrier_pigeon_N" ;
lin carrion_N = mkTerm "carrion_N" ;
lin carrion_crow_N = mkTerm "carrion_crow_N" ;
lin carron_PN = mkTerm "carron_PN" ;
lin carrot_N = mkTerm "carrot_N" ;
lin carroty_A = mkTerm "carroty_A" ;
lin carry_N = mkTerm "carry_N" ;
lin carry_V = mkTerm "carry_V" ;
lin carry_V2 = mkTerm "carry_V2" ;
lin carry_forward_V2 = mkTerm "carry_forward_V2" ;
lin carry_off_V2 = mkTerm "carry_off_V2" ;
lin carry_on_V = mkTerm "carry_on_V" ;
lin carry_on_V2 = mkTerm "carry_on_V2" ;
lin carry_on_about_V2 = mkTerm "carry_on_about_V2" ;
lin carry_on_with_V2 = mkTerm "carry_on_with_V2" ;
lin carry_out_V = mkTerm "carry_out_V" ;
lin carry_out_V2 = mkTerm "carry_out_V2" ;
lin carry_over_V2 = mkTerm "carry_over_V2" ;
lin carry_through_V2 = mkTerm "carry_through_V2" ;
lin carryall_N = mkTerm "carryall_N" ;
lin carrycot_N = mkTerm "carrycot_N" ;
lin carsick_A = mkTerm "carsick_A" ;
lin carsickness_N = mkTerm "carsickness_N" ;
lin cart_N = mkTerm "cart_N" ;
lin cart_V2 = mkTerm "cart_V2" ;
lin cart_off_V2 = mkTerm "cart_off_V2" ;
lin cart_out_V = mkTerm "cart_out_V" ;
lin cart_track_N = mkTerm "cart_track_N" ;
lin cartage_N = mkTerm "cartage_N" ;
lin cartagena_PN = mkTerm "cartagena_PN" ;
lin carte_blanche_N = mkTerm "carte_blanche_N" ;
lin cartel_N = mkTerm "cartel_N" ;
lin carter_N = mkTerm "carter_N" ;
lin carthorse_N = mkTerm "carthorse_N" ;
lin cartilage_N = mkTerm "cartilage_N" ;
lin cartilaginification_N = mkTerm "cartilaginification_N" ;
lin cartilaginous_A = mkTerm "cartilaginous_A" ;
lin cartload_N = mkTerm "cartload_N" ;
lin cartographer_N = mkTerm "cartographer_N" ;
lin cartographic_A = mkTerm "cartographic_A" ;
lin cartography_N = mkTerm "cartography_N" ;
lin carton_N = mkTerm "carton_N" ;
lin cartoon_N = mkTerm "cartoon_N" ;
lin cartoon_V2 = mkTerm "cartoon_V2" ;
lin cartoonistFem_N = mkTerm "cartoonistFem_N" ;
lin cartoonistMasc_N = mkTerm "cartoonistMasc_N" ;
lin cartouche_N = mkTerm "cartouche_N" ;
lin cartridge_N = mkTerm "cartridge_N" ;
lin cartridge_belt_N = mkTerm "cartridge_belt_N" ;
lin cartridge_paper_N = mkTerm "cartridge_paper_N" ;
lin cartroad_N = mkTerm "cartroad_N" ;
lin cartwheel_N = mkTerm "cartwheel_N" ;
lin cartwright_N = mkTerm "cartwright_N" ;
lin caruncle_N = mkTerm "caruncle_N" ;
lin caruncular_A = mkTerm "caruncular_A" ;
lin carunculate_A = mkTerm "carunculate_A" ;
lin carve_V = mkTerm "carve_V" ;
lin carve_V2 = mkTerm "carve_V2" ;
lin carve_out_V2 = mkTerm "carve_out_V2" ;
lin carve_up_V2 = mkTerm "carve_up_V2" ;
lin carvedilol_N = mkTerm "carvedilol_N" ;
lin carver_N = mkTerm "carver_N" ;
lin carving_N = mkTerm "carving_N" ;
lin carving_fork_N = mkTerm "carving_fork_N" ;
lin carving_knife_N = mkTerm "carving_knife_N" ;
lin caryatid_N = mkTerm "caryatid_N" ;
lin caryophyllaceous_A = mkTerm "caryophyllaceous_A" ;
lin casaba_N = mkTerm "casaba_N" ;
lin casablanca_PN = mkTerm "casablanca_PN" ;
lin cascade_N = mkTerm "cascade_N" ;
lin cascade_V = mkTerm "cascade_V" ;
lin cascara_N = mkTerm "cascara_N" ;
lin cascarilla_N = mkTerm "cascarilla_N" ;
lin case_N = mkTerm "case_N" ;
lin case_V2 = mkTerm "case_V2" ;
lin case_hardened_A = mkTerm "case_hardened_A" ;
lin case_history_N = mkTerm "case_history_N" ;
lin case_law_N = mkTerm "case_law_N" ;
lin casebook_A = mkTerm "casebook_A" ;
lin casebook_N = mkTerm "casebook_N" ;
lin casein_N = mkTerm "casein_N" ;
lin casement_N = mkTerm "casement_N" ;
lin caseous_A = mkTerm "caseous_A" ;
lin casern_N = mkTerm "casern_N" ;
lin casework_N = mkTerm "casework_N" ;
lin caseworm_N = mkTerm "caseworm_N" ;
lin cash_N = mkTerm "cash_N" ;
lin cash_V = mkTerm "cash_V" ;
lin cash_V2 = mkTerm "cash_V2" ;
lin cash_in_V2 = mkTerm "cash_in_V2" ;
lin cash_in_on_V2 = mkTerm "cash_in_on_V2" ;
lin cash_out_V2 = mkTerm "cash_out_V2" ;
lin cash_up_V = mkTerm "cash_up_V" ;
lin cashable_A = mkTerm "cashable_A" ;
lin cashbox_N = mkTerm "cashbox_N" ;
lin cashew_N = mkTerm "cashew_N" ;
lin cashier_N = mkTerm "cashier_N" ;
lin cashier_V2 = mkTerm "cashier_V2" ;
lin cashmere_N = mkTerm "cashmere_N" ;
lin casing_N = mkTerm "casing_N" ;
lin casino_N = mkTerm "casino_N" ;
lin cask_N = mkTerm "cask_N" ;
lin casket_N = mkTerm "casket_N" ;
lin caspase_N = mkTerm "caspase_N" ;
lin casque_N = mkTerm "casque_N" ;
lin casquet_N = mkTerm "casquet_N" ;
lin cassareep_N = mkTerm "cassareep_N" ;
lin cassava_N = mkTerm "cassava_N" ;
lin casserole_N = mkTerm "casserole_N" ;
lin cassette_N = mkTerm "cassette_N" ;
lin cassia_N = mkTerm "cassia_N" ;
lin cassiri_N = mkTerm "cassiri_N" ;
lin cassiterite_N = mkTerm "cassiterite_N" ;
lin cassock_N = mkTerm "cassock_N" ;
lin cassocked_A = mkTerm "cassocked_A" ;
lin cassowary_N = mkTerm "cassowary_N" ;
lin cast_N = mkTerm "cast_N" ;
lin cast_V = mkTerm "cast_V" ;
lin cast_V2 = mkTerm "cast_V2" ;
lin cast_about_for_V2 = mkTerm "cast_about_for_V2" ;
lin cast_around_V = mkTerm "cast_around_V" ;
lin cast_around_for_V2 = mkTerm "cast_around_for_V2" ;
lin cast_aside_V2 = mkTerm "cast_aside_V2" ;
lin cast_iron_A = mkTerm "cast_iron_A" ;
lin cast_off_A = mkTerm "cast_off_A" ;
lin cast_off_V = mkTerm "cast_off_V" ;
lin cast_off_V2 = mkTerm "cast_off_V2" ;
lin cast_out_V2 = mkTerm "cast_out_V2" ;
lin cast_round_for_V2 = mkTerm "cast_round_for_V2" ;
lin cast_up_V2 = mkTerm "cast_up_V2" ;
lin castaway_N = mkTerm "castaway_N" ;
lin caste_N = mkTerm "caste_N" ;
lin castellated_A = mkTerm "castellated_A" ;
lin caster_N = mkTerm "caster_N" ;
lin castigate_V2 = mkTerm "castigate_V2" ;
lin castigation_N = mkTerm "castigation_N" ;
lin casting_N = mkTerm "casting_N" ;
lin castle_N = mkTerm "castle_N" ;
lin castle_V = mkTerm "castle_V" ;
lin castleford_PN = mkTerm "castleford_PN" ;
lin castor_N = mkTerm "castor_N" ;
lin castor_oil_N = mkTerm "castor_oil_N" ;
lin castrate_V2 = mkTerm "castrate_V2" ;
lin castration_N = mkTerm "castration_N" ;
lin castrato_N = mkTerm "castrato_N" ;
lin casual_A = mkTerm "casual_A" ;
lin casualness_N = mkTerm "casualness_N" ;
lin casualty_N = mkTerm "casualty_N" ;
lin casuarina_N = mkTerm "casuarina_N" ;
lin casuist_N = mkTerm "casuist_N" ;
lin casuistic_A = mkTerm "casuistic_A" ;
lin casuistical_A = mkTerm "casuistical_A" ;
lin casuistry_N = mkTerm "casuistry_N" ;
lin casus_belli_N = mkTerm "casus_belli_N" ;
lin cat_N = mkTerm "cat_N" ;
lin cat_nap_N = mkTerm "cat_nap_N" ;
lin cat_o'_nine_tails_N = mkTerm "cat_o'_nine_tails_N" ;
lin cat_sleep_N = mkTerm "cat_sleep_N" ;
lin catabiosis_N = mkTerm "catabiosis_N" ;
lin catabolic_A = mkTerm "catabolic_A" ;
lin catabolism_N = mkTerm "catabolism_N" ;
lin catachresis_N = mkTerm "catachresis_N" ;
lin catachrestic_A = mkTerm "catachrestic_A" ;
lin cataclinal_A = mkTerm "cataclinal_A" ;
lin cataclysm_N = mkTerm "cataclysm_N" ;
lin cataclysmal_A = mkTerm "cataclysmal_A" ;
lin cataclysmic_A = mkTerm "cataclysmic_A" ;
lin catacomb_N = mkTerm "catacomb_N" ;
lin catacorner_A = mkTerm "catacorner_A" ;
lin catadromous_A = mkTerm "catadromous_A" ;
lin catafalque_N = mkTerm "catafalque_N" ;
lin catalanFem_N = mkTerm "catalanFem_N" ;
lin catalanMasc_N = mkTerm "catalanMasc_N" ;
lin catalan_A = mkTerm "catalan_A" ;
lin catalase_N = mkTerm "catalase_N" ;
lin catalatic_A = mkTerm "catalatic_A" ;
lin catalectic_A = mkTerm "catalectic_A" ;
lin catalectic_N = mkTerm "catalectic_N" ;
lin catalepsy_N = mkTerm "catalepsy_N" ;
lin cataleptic_A = mkTerm "cataleptic_A" ;
lin cataleptic_N = mkTerm "cataleptic_N" ;
lin catalexis_N = mkTerm "catalexis_N" ;
lin catalog_N = mkTerm "catalog_N" ;
lin catalog_V2 = mkTerm "catalog_V2" ;
lin cataloger_N = mkTerm "cataloger_N" ;
lin catalogue_N = mkTerm "catalogue_N" ;
lin catalogue_V2 = mkTerm "catalogue_V2" ;
lin catalpa_N = mkTerm "catalpa_N" ;
lin catalufa_N = mkTerm "catalufa_N" ;
lin catalysis_N = mkTerm "catalysis_N" ;
lin catalyst_N = mkTerm "catalyst_N" ;
lin catalytic_A = mkTerm "catalytic_A" ;
lin catamaran_N = mkTerm "catamaran_N" ;
lin catamite_N = mkTerm "catamite_N" ;
lin catananche_N = mkTerm "catananche_N" ;
lin catania_PN = mkTerm "catania_PN" ;
lin cataphasia_N = mkTerm "cataphasia_N" ;
lin cataphatic_A = mkTerm "cataphatic_A" ;
lin cataphatism_N = mkTerm "cataphatism_N" ;
lin cataphyll_N = mkTerm "cataphyll_N" ;
lin cataplasia_N = mkTerm "cataplasia_N" ;
lin cataplastic_A = mkTerm "cataplastic_A" ;
lin catapult_N = mkTerm "catapult_N" ;
lin catapult_V2 = mkTerm "catapult_V2" ;
lin catapultic_A = mkTerm "catapultic_A" ;
lin cataract_N = mkTerm "cataract_N" ;
lin catarrh_N = mkTerm "catarrh_N" ;
lin catarrhal_A = mkTerm "catarrhal_A" ;
lin catarrhine_A = mkTerm "catarrhine_A" ;
lin catastrophe_N = mkTerm "catastrophe_N" ;
lin catastrophic_A = mkTerm "catastrophic_A" ;
lin catatonia_N = mkTerm "catatonia_N" ;
lin catatonic_A = mkTerm "catatonic_A" ;
lin catbird_N = mkTerm "catbird_N" ;
lin catboat_N = mkTerm "catboat_N" ;
lin catcall_N = mkTerm "catcall_N" ;
lin catcall_V = mkTerm "catcall_V" ;
lin catch_N = mkTerm "catch_N" ;
lin catch_V2 = mkTerm "catch_V2" ;
lin catch_at_V2 = mkTerm "catch_at_V2" ;
lin catch_crop_N = mkTerm "catch_crop_N" ;
lin catch_on_V = mkTerm "catch_on_V" ;
lin catch_out_V2 = mkTerm "catch_out_V2" ;
lin catch_up_V = mkTerm "catch_up_V" ;
lin catch_up_V2 = mkTerm "catch_up_V2" ;
lin catch_up_in_V2 = mkTerm "catch_up_in_V2" ;
lin catch_up_on_V2 = mkTerm "catch_up_on_V2" ;
lin catch_up_with_V2 = mkTerm "catch_up_with_V2" ;
lin catchall_N = mkTerm "catchall_N" ;
lin catcher_N = mkTerm "catcher_N" ;
lin catching_N = mkTerm "catching_N" ;
lin catchment_N = mkTerm "catchment_N" ;
lin catchment_area_N = mkTerm "catchment_area_N" ;
lin catchment_basin_N = mkTerm "catchment_basin_N" ;
lin catchpenny_A = mkTerm "catchpenny_A" ;
lin catchphrase_N = mkTerm "catchphrase_N" ;
lin catchup_N = mkTerm "catchup_N" ;
lin catchword_N = mkTerm "catchword_N" ;
lin catchy_A = mkTerm "catchy_A" ;
lin catechesis_N = mkTerm "catechesis_N" ;
lin catechetical_A = mkTerm "catechetical_A" ;
lin catechin_N = mkTerm "catechin_N" ;
lin catechism_N = mkTerm "catechism_N" ;
lin catechismal_A = mkTerm "catechismal_A" ;
lin catechist_N = mkTerm "catechist_N" ;
lin catechistic_A = mkTerm "catechistic_A" ;
lin catechize_V2 = mkTerm "catechize_V2" ;
lin catecholamine_N = mkTerm "catecholamine_N" ;
lin catechu_N = mkTerm "catechu_N" ;
lin catechumen_N = mkTerm "catechumen_N" ;
lin categorem_N = mkTerm "categorem_N" ;
lin categorematic_A = mkTerm "categorematic_A" ;
lin categorial_A = mkTerm "categorial_A" ;
lin categoric_A = mkTerm "categoric_A" ;
lin categorical_A = mkTerm "categorical_A" ;
lin categorization_N = mkTerm "categorization_N" ;
lin categorize_V2 = mkTerm "categorize_V2" ;
lin category_N = mkTerm "category_N" ;
lin catena_N = mkTerm "catena_N" ;
lin catenary_N = mkTerm "catenary_N" ;
lin catenulate_A = mkTerm "catenulate_A" ;
lin cater_V = mkTerm "cater_V" ;
lin cater_for_V2 = mkTerm "cater_for_V2" ;
lin cater_to_V2 = mkTerm "cater_to_V2" ;
lin caterer_N = mkTerm "caterer_N" ;
lin catering_N = mkTerm "catering_N" ;
lin caterpillar_N = mkTerm "caterpillar_N" ;
lin caterwaul_N = mkTerm "caterwaul_N" ;
lin caterwaul_V = mkTerm "caterwaul_V" ;
lin catfish_N = mkTerm "catfish_N" ;
lin catgut_N = mkTerm "catgut_N" ;
lin cath_PN = mkTerm "cath_PN" ;
lin catharsis_N = mkTerm "catharsis_N" ;
lin cathartic_A = mkTerm "cathartic_A" ;
lin cathartic_N = mkTerm "cathartic_N" ;
lin cathectic_A = mkTerm "cathectic_A" ;
lin cathedra_N = mkTerm "cathedra_N" ;
lin cathedral_A = mkTerm "cathedral_A" ;
lin cathedral_N = mkTerm "cathedral_N" ;
lin catherine_PN = mkTerm "catherine_PN" ;
lin catheter_N = mkTerm "catheter_N" ;
lin catheterization_N = mkTerm "catheterization_N" ;
lin cathexis_N = mkTerm "cathexis_N" ;
lin cathode_N = mkTerm "cathode_N" ;
lin cathodic_A = mkTerm "cathodic_A" ;
lin catholicFem_N = mkTerm "catholicFem_N" ;
lin catholicMasc_N = mkTerm "catholicMasc_N" ;
lin catholic_A = mkTerm "catholic_A" ;
lin catholicism_N = mkTerm "catholicism_N" ;
lin catholicity_N = mkTerm "catholicity_N" ;
lin cathy_PN = mkTerm "cathy_PN" ;
lin cation_N = mkTerm "cation_N" ;
lin cationic_A = mkTerm "cationic_A" ;
lin catkin_N = mkTerm "catkin_N" ;
lin catkinate_A = mkTerm "catkinate_A" ;
lin catling_N = mkTerm "catling_N" ;
lin catmint_N = mkTerm "catmint_N" ;
lin catoptric_A = mkTerm "catoptric_A" ;
lin catoptrics_N = mkTerm "catoptrics_N" ;
lin catostomid_N = mkTerm "catostomid_N" ;
lin catsup_N = mkTerm "catsup_N" ;
lin cattail_N = mkTerm "cattail_N" ;
lin cattalo_N = mkTerm "cattalo_N" ;
lin cattiness_N = mkTerm "cattiness_N" ;
lin cattish_A = mkTerm "cattish_A" ;
lin cattle_N = mkTerm "cattle_N" ;
lin cattle_cake_N = mkTerm "cattle_cake_N" ;
lin cattleman_N = mkTerm "cattleman_N" ;
lin cattleship_N = mkTerm "cattleship_N" ;
lin cattleya_N = mkTerm "cattleya_N" ;
lin catty_A = mkTerm "catty_A" ;
lin catty_N = mkTerm "catty_N" ;
lin catwalk_N = mkTerm "catwalk_N" ;
lin caucasianFem_N = mkTerm "caucasianFem_N" ;
lin caucasianMasc_N = mkTerm "caucasianMasc_N" ;
lin caucasian_A = mkTerm "caucasian_A" ;
lin caucus_N = mkTerm "caucus_N" ;
lin cauda_N = mkTerm "cauda_N" ;
lin caudal_A = mkTerm "caudal_A" ;
lin caudate_A = mkTerm "caudate_A" ;
lin caudex_N = mkTerm "caudex_N" ;
lin caul_N = mkTerm "caul_N" ;
lin cauldron_N = mkTerm "cauldron_N" ;
lin caulescent_A = mkTerm "caulescent_A" ;
lin cauliflower_N = mkTerm "cauliflower_N" ;
lin cauline_A = mkTerm "cauline_A" ;
lin caulk_N = mkTerm "caulk_N" ;
lin caulk_V2 = mkTerm "caulk_V2" ;
lin causal_A = mkTerm "causal_A" ;
lin causalgia_N = mkTerm "causalgia_N" ;
lin causality_N = mkTerm "causality_N" ;
lin causation_N = mkTerm "causation_N" ;
lin causative_A = mkTerm "causative_A" ;
lin cause_N = mkTerm "cause_N" ;
lin cause_V2 = mkTerm "cause_V2" ;
lin cause_V2V = mkTerm "cause_V2V" ;
lin causeless_A = mkTerm "causeless_A" ;
lin causerie_N = mkTerm "causerie_N" ;
lin causeway_N = mkTerm "causeway_N" ;
lin causing_N = mkTerm "causing_N" ;
lin caustic_A = mkTerm "caustic_A" ;
lin caustic_N = mkTerm "caustic_N" ;
lin cauterize_V2 = mkTerm "cauterize_V2" ;
lin cautery_N = mkTerm "cautery_N" ;
lin caution_N = mkTerm "caution_N" ;
lin caution_V = mkTerm "caution_V" ;
lin caution_V2 = mkTerm "caution_V2" ;
lin caution_V2V = mkTerm "caution_V2V" ;
lin caution_VS = mkTerm "caution_VS" ;
lin cautionary_A = mkTerm "cautionary_A" ;
lin cautious_A = mkTerm "cautious_A" ;
lin cavalcade_N = mkTerm "cavalcade_N" ;
lin cavalier_A = mkTerm "cavalier_A" ;
lin cavalier_N = mkTerm "cavalier_N" ;
lin cavalry_N = mkTerm "cavalry_N" ;
lin cavalryman_N = mkTerm "cavalryman_N" ;
lin cavan_PN = mkTerm "cavan_PN" ;
lin cave_N = mkTerm "cave_N" ;
lin cave_V = mkTerm "cave_V" ;
lin cave_V2 = mkTerm "cave_V2" ;
lin cave_dweller_N = mkTerm "cave_dweller_N" ;
lin cave_in_N = mkTerm "cave_in_N" ;
lin cave_in_V = mkTerm "cave_in_V" ;
lin caveat_N = mkTerm "caveat_N" ;
lin caveman_N = mkTerm "caveman_N" ;
lin cavern_N = mkTerm "cavern_N" ;
lin cavernous_A = mkTerm "cavernous_A" ;
lin cavetto_N = mkTerm "cavetto_N" ;
lin caviar_N = mkTerm "caviar_N" ;
lin cavil_V = mkTerm "cavil_V" ;
lin cavity_N = mkTerm "cavity_N" ;
lin cavort_V = mkTerm "cavort_V" ;
lin cavy_N = mkTerm "cavy_N" ;
lin caw_N = mkTerm "caw_N" ;
lin caw_V = mkTerm "caw_V" ;
lin caw_V2 = mkTerm "caw_V2" ;
lin cayenne_N = mkTerm "cayenne_N" ;
lin cayenne_pepper_N = mkTerm "cayenne_pepper_N" ;
lin cayman_N = mkTerm "cayman_N" ;
lin cayuse_N = mkTerm "cayuse_N" ;
lin cbi_N = mkTerm "cbi_N" ;
lin cc_N = mkTerm "cc_N" ;
lin cd_N = mkTerm "cd_N" ;
lin cdr_PN = mkTerm "cdr_PN" ;
lin cdre_PN = mkTerm "cdre_PN" ;
lin cease_N = mkTerm "cease_N" ;
lin cease_V = mkTerm "cease_V" ;
lin cease_V2 = mkTerm "cease_V2" ;
lin cease_fire_N = mkTerm "cease_fire_N" ;
lin ceasefire_N = mkTerm "ceasefire_N" ;
lin ceaseless_A = mkTerm "ceaseless_A" ;
lin cecal_A = mkTerm "cecal_A" ;
lin cecil_PN = mkTerm "cecil_PN" ;
lin cecilia_PN = mkTerm "cecilia_PN" ;
lin cecily_PN = mkTerm "cecily_PN" ;
lin cecropia_N = mkTerm "cecropia_N" ;
lin cecum_N = mkTerm "cecum_N" ;
lin cedar_N = mkTerm "cedar_N" ;
lin cedarn_A = mkTerm "cedarn_A" ;
lin cede_V2 = mkTerm "cede_V2" ;
lin cedi_N = mkTerm "cedi_N" ;
lin cedilla_N = mkTerm "cedilla_N" ;
lin cedric_PN = mkTerm "cedric_PN" ;
lin cefadroxil_N = mkTerm "cefadroxil_N" ;
lin cefn_mawr_PN = mkTerm "cefn_mawr_PN" ;
lin cefoperazone_N = mkTerm "cefoperazone_N" ;
lin cefotaxime_N = mkTerm "cefotaxime_N" ;
lin ceftazidime_N = mkTerm "ceftazidime_N" ;
lin ceftriaxone_N = mkTerm "ceftriaxone_N" ;
lin cefuroxime_N = mkTerm "cefuroxime_N" ;
lin ceibo_N = mkTerm "ceibo_N" ;
lin ceilidh_N = mkTerm "ceilidh_N" ;
lin ceiling_N = mkTerm "ceiling_N" ;
lin ceilinged_A = mkTerm "ceilinged_A" ;
lin celandine_N = mkTerm "celandine_N" ;
lin celebrant_N = mkTerm "celebrant_N" ;
lin celebrate_V2 = mkTerm "celebrate_V2" ;
lin celebrated_A = mkTerm "celebrated_A" ;
lin celebration_N = mkTerm "celebration_N" ;
lin celebratory_A = mkTerm "celebratory_A" ;
lin celebrity_N = mkTerm "celebrity_N" ;
lin celecoxib_N = mkTerm "celecoxib_N" ;
lin celeriac_N = mkTerm "celeriac_N" ;
lin celerity_N = mkTerm "celerity_N" ;
lin celery_N = mkTerm "celery_N" ;
lin celesta_N = mkTerm "celesta_N" ;
lin celestial_A = mkTerm "celestial_A" ;
lin celestite_N = mkTerm "celestite_N" ;
lin celia_PN = mkTerm "celia_PN" ;
lin celiac_A = mkTerm "celiac_A" ;
lin celibacy_N = mkTerm "celibacy_N" ;
lin celibate_A = mkTerm "celibate_A" ;
lin celibate_N = mkTerm "celibate_N" ;
lin celiocentesis_N = mkTerm "celiocentesis_N" ;
lin celioma_N = mkTerm "celioma_N" ;
lin celioscopy_N = mkTerm "celioscopy_N" ;
lin cell_N = mkTerm "cell_N" ;
lin cellar_N = mkTerm "cellar_N" ;
lin cellarage_N = mkTerm "cellarage_N" ;
lin cellblock_N = mkTerm "cellblock_N" ;
lin cellistFem_N = mkTerm "cellistFem_N" ;
lin cellistMasc_N = mkTerm "cellistMasc_N" ;
lin cello_N = mkTerm "cello_N" ;
lin cellophane_N = mkTerm "cellophane_N" ;
lin cellular_A = mkTerm "cellular_A" ;
lin cellularity_N = mkTerm "cellularity_N" ;
lin cellulite_N = mkTerm "cellulite_N" ;
lin cellulitis_N = mkTerm "cellulitis_N" ;
lin celluloid_A = mkTerm "celluloid_A" ;
lin celluloid_N = mkTerm "celluloid_N" ;
lin cellulose_N = mkTerm "cellulose_N" ;
lin cellulosic_N = mkTerm "cellulosic_N" ;
lin cellulosid_A = mkTerm "cellulosid_A" ;
lin celom_N = mkTerm "celom_N" ;
lin celt_N = mkTerm "celt_N" ;
lin celtic_A = mkTerm "celtic_A" ;
lin celtic_N = mkTerm "celtic_N" ;
lin celtuce_N = mkTerm "celtuce_N" ;
lin cement_N = mkTerm "cement_N" ;
lin cement_V2 = mkTerm "cement_V2" ;
lin cement_mixer_N = mkTerm "cement_mixer_N" ;
lin cementite_N = mkTerm "cementite_N" ;
lin cementitious_A = mkTerm "cementitious_A" ;
lin cementum_N = mkTerm "cementum_N" ;
lin cemetery_N = mkTerm "cemetery_N" ;
lin cenobite_N = mkTerm "cenobite_N" ;
lin cenobitic_A = mkTerm "cenobitic_A" ;
lin cenogenesis_N = mkTerm "cenogenesis_N" ;
lin cenogenetic_A = mkTerm "cenogenetic_A" ;
lin cenotaph_N = mkTerm "cenotaph_N" ;
lin censer_N = mkTerm "censer_N" ;
lin censor_N = mkTerm "censor_N" ;
lin censor_V2 = mkTerm "censor_V2" ;
lin censorial_A = mkTerm "censorial_A" ;
lin censoring_N = mkTerm "censoring_N" ;
lin censorious_A = mkTerm "censorious_A" ;
lin censorship_N = mkTerm "censorship_N" ;
lin censure_N = mkTerm "censure_N" ;
lin censure_V2 = mkTerm "censure_V2" ;
lin census_N = mkTerm "census_N" ;
lin cent_N = mkTerm "cent_N" ;
lin centas_N = mkTerm "centas_N" ;
lin centaur_N = mkTerm "centaur_N" ;
lin centaury_N = mkTerm "centaury_N" ;
lin centavo_N = mkTerm "centavo_N" ;
lin centenarian_A = mkTerm "centenarian_A" ;
lin centenarian_N = mkTerm "centenarian_N" ;
lin centenary_A = mkTerm "centenary_A" ;
lin centenary_N = mkTerm "centenary_N" ;
lin centennial_A = mkTerm "centennial_A" ;
lin centennial_N = mkTerm "centennial_N" ;
lin center_A = mkTerm "center_A" ;
lin centered_A = mkTerm "centered_A" ;
lin centerfold_N = mkTerm "centerfold_N" ;
lin centering_N = mkTerm "centering_N" ;
lin centerline_N = mkTerm "centerline_N" ;
lin centesimal_A = mkTerm "centesimal_A" ;
lin centesimo_N = mkTerm "centesimo_N" ;
lin centesis_N = mkTerm "centesis_N" ;
lin centigrade_A = mkTerm "centigrade_A" ;
lin centiliter_N = mkTerm "centiliter_N" ;
lin centime_N = mkTerm "centime_N" ;
lin centimetre_N = mkTerm "centimetre_N" ;
lin centimo_N = mkTerm "centimo_N" ;
lin centipede_N = mkTerm "centipede_N" ;
lin centner_N = mkTerm "centner_N" ;
lin central_A = mkTerm "central_A" ;
lin central_N = mkTerm "central_N" ;
lin centralism_N = mkTerm "centralism_N" ;
lin centralist_A = mkTerm "centralist_A" ;
lin centrality_N = mkTerm "centrality_N" ;
lin centralization_N = mkTerm "centralization_N" ;
lin centralize_V = mkTerm "centralize_V" ;
lin centralize_V2 = mkTerm "centralize_V2" ;
lin centre_N = mkTerm "centre_N" ;
lin centre_V = mkTerm "centre_V" ;
lin centre_V2 = mkTerm "centre_V2" ;
lin centre_bit_N = mkTerm "centre_bit_N" ;
lin centre_board_N = mkTerm "centre_board_N" ;
lin centrepiece_N = mkTerm "centrepiece_N" ;
lin centrex_N = mkTerm "centrex_N" ;
lin centric_A = mkTerm "centric_A" ;
lin centrifugal_A = mkTerm "centrifugal_A" ;
lin centrifugation_N = mkTerm "centrifugation_N" ;
lin centrifuge_N = mkTerm "centrifuge_N" ;
lin centriole_N = mkTerm "centriole_N" ;
lin centripetal_A = mkTerm "centripetal_A" ;
lin centrism_N = mkTerm "centrism_N" ;
lin centrist_A = mkTerm "centrist_A" ;
lin centrist_N = mkTerm "centrist_N" ;
lin centroid_N = mkTerm "centroid_N" ;
lin centroidal_A = mkTerm "centroidal_A" ;
lin centromere_N = mkTerm "centromere_N" ;
lin centromeric_A = mkTerm "centromeric_A" ;
lin centrosome_N = mkTerm "centrosome_N" ;
lin centrosomic_A = mkTerm "centrosomic_A" ;
lin centrum_N = mkTerm "centrum_N" ;
lin centurion_N = mkTerm "centurion_N" ;
lin century_N = mkTerm "century_N" ;
lin cephalexin_N = mkTerm "cephalexin_N" ;
lin cephalhematoma_N = mkTerm "cephalhematoma_N" ;
lin cephalic_A = mkTerm "cephalic_A" ;
lin cephalochordate_N = mkTerm "cephalochordate_N" ;
lin cephaloglycin_N = mkTerm "cephaloglycin_N" ;
lin cephalometry_N = mkTerm "cephalometry_N" ;
lin cephalopod_A = mkTerm "cephalopod_A" ;
lin cephalopod_N = mkTerm "cephalopod_N" ;
lin cephaloridine_N = mkTerm "cephaloridine_N" ;
lin cephalosporin_N = mkTerm "cephalosporin_N" ;
lin cephalothin_N = mkTerm "cephalothin_N" ;
lin ceramic_A = mkTerm "ceramic_A" ;
lin ceramic_N = mkTerm "ceramic_N" ;
lin ceramics_N = mkTerm "ceramics_N" ;
lin ceras_N = mkTerm "ceras_N" ;
lin cerate_N = mkTerm "cerate_N" ;
lin ceratodus_N = mkTerm "ceratodus_N" ;
lin ceratopsian_N = mkTerm "ceratopsian_N" ;
lin ceratosaur_N = mkTerm "ceratosaur_N" ;
lin ceratozamia_N = mkTerm "ceratozamia_N" ;
lin cercaria_N = mkTerm "cercaria_N" ;
lin cercarial_A = mkTerm "cercarial_A" ;
lin cere_N = mkTerm "cere_N" ;
lin cereal_A = mkTerm "cereal_A" ;
lin cereal_N = mkTerm "cereal_N" ;
lin cerebellar_A = mkTerm "cerebellar_A" ;
lin cerebellum_N = mkTerm "cerebellum_N" ;
lin cerebral_A = mkTerm "cerebral_A" ;
lin cerebration_N = mkTerm "cerebration_N" ;
lin cerebrospinal_A = mkTerm "cerebrospinal_A" ;
lin cerebrovascular_A = mkTerm "cerebrovascular_A" ;
lin cerebrum_N = mkTerm "cerebrum_N" ;
lin cerecloth_N = mkTerm "cerecloth_N" ;
lin ceremonial_A = mkTerm "ceremonial_A" ;
lin ceremonial_N = mkTerm "ceremonial_N" ;
lin ceremonious_A = mkTerm "ceremonious_A" ;
lin ceremoniousness_N = mkTerm "ceremoniousness_N" ;
lin ceremony_N = mkTerm "ceremony_N" ;
lin ceresin_N = mkTerm "ceresin_N" ;
lin ceric_A = mkTerm "ceric_A" ;
lin ceriman_N = mkTerm "ceriman_N" ;
lin cerise_A = mkTerm "cerise_A" ;
lin cerise_N = mkTerm "cerise_N" ;
lin cerium_N = mkTerm "cerium_N" ;
lin cerivastatin_N = mkTerm "cerivastatin_N" ;
lin cernuous_A = mkTerm "cernuous_A" ;
lin cero_N = mkTerm "cero_N" ;
lin cerous_A = mkTerm "cerous_A" ;
lin cert_N = mkTerm "cert_N" ;
lin certain_1_A = mkTerm "certain_1_A" ;
lin certain_2_A = mkTerm "certain_2_A" ;
lin certainty_N = mkTerm "certainty_N" ;
lin certifiable_A = mkTerm "certifiable_A" ;
lin certificate_N = mkTerm "certificate_N" ;
lin certificate_V2 = mkTerm "certificate_V2" ;
lin certification_N = mkTerm "certification_N" ;
lin certificatory_A = mkTerm "certificatory_A" ;
lin certified_A = mkTerm "certified_A" ;
lin certify_V = mkTerm "certify_V" ;
lin certify_V2 = mkTerm "certify_V2" ;
lin certiorari_N = mkTerm "certiorari_N" ;
lin certitude_N = mkTerm "certitude_N" ;
lin cerulean_A = mkTerm "cerulean_A" ;
lin cerumen_N = mkTerm "cerumen_N" ;
lin ceruminous_A = mkTerm "ceruminous_A" ;
lin cerussite_N = mkTerm "cerussite_N" ;
lin cervical_A = mkTerm "cervical_A" ;
lin cervicitis_N = mkTerm "cervicitis_N" ;
lin cervine_A = mkTerm "cervine_A" ;
lin cervix_N = mkTerm "cervix_N" ;
lin cesarean_A = mkTerm "cesarean_A" ;
lin cesium_N = mkTerm "cesium_N" ;
lin cessation_N = mkTerm "cessation_N" ;
lin cession_N = mkTerm "cession_N" ;
lin cesspit_N = mkTerm "cesspit_N" ;
lin cesspool_N = mkTerm "cesspool_N" ;
lin cetacean_A = mkTerm "cetacean_A" ;
lin cetacean_N = mkTerm "cetacean_N" ;
lin cetrimide_N = mkTerm "cetrimide_N" ;
lin ceylon_PN = mkTerm "ceylon_PN" ;
lin cf_PN = mkTerm "cf_PN" ;
lin cf__Adv = mkTerm "cf__Adv" ;
lin cgs_N = mkTerm "cgs_N" ;
lin chabazite_N = mkTerm "chabazite_N" ;
lin chachalaca_N = mkTerm "chachalaca_N" ;
lin chachka_N = mkTerm "chachka_N" ;
lin chacma_N = mkTerm "chacma_N" ;
lin chad_N = mkTerm "chad_N" ;
lin chad_PN = mkTerm "chad_PN" ;
lin chadian_A = mkTerm "chadian_A" ;
lin chadian_N = mkTerm "chadian_N" ;
lin chador_N = mkTerm "chador_N" ;
lin chaenactis_N = mkTerm "chaenactis_N" ;
lin chaeta_N = mkTerm "chaeta_N" ;
lin chaetal_A = mkTerm "chaetal_A" ;
lin chaetodon_N = mkTerm "chaetodon_N" ;
lin chaetognathan_A = mkTerm "chaetognathan_A" ;
lin chafe_N = mkTerm "chafe_N" ;
lin chafe_V = mkTerm "chafe_V" ;
lin chafe_V2 = mkTerm "chafe_V2" ;
lin chafeweed_N = mkTerm "chafeweed_N" ;
lin chaff_N = mkTerm "chaff_N" ;
lin chaff_V2 = mkTerm "chaff_V2" ;
lin chaffinch_N = mkTerm "chaffinch_N" ;
lin chaffweed_N = mkTerm "chaffweed_N" ;
lin chaffy_A = mkTerm "chaffy_A" ;
lin chafing_N = mkTerm "chafing_N" ;
lin chafing_dish_N = mkTerm "chafing_dish_N" ;
lin chagrin_N = mkTerm "chagrin_N" ;
lin chagrin_V2 = mkTerm "chagrin_V2" ;
lin chain_N = mkTerm "chain_N" ;
lin chain_V2 = mkTerm "chain_V2" ;
lin chain_armour_N = mkTerm "chain_armour_N" ;
lin chain_gang_N = mkTerm "chain_gang_N" ;
lin chain_letter_N = mkTerm "chain_letter_N" ;
lin chain_mail_N = mkTerm "chain_mail_N" ;
lin chain_smoker_N = mkTerm "chain_smoker_N" ;
lin chain_stitch_N = mkTerm "chain_stitch_N" ;
lin chain_store_N = mkTerm "chain_store_N" ;
lin chair_N = mkTerm "chair_N" ;
lin chair_V2 = mkTerm "chair_V2" ;
lin chair_lift_N = mkTerm "chair_lift_N" ;
lin chairman_N = mkTerm "chairman_N" ;
lin chairmanship_N = mkTerm "chairmanship_N" ;
lin chaise_N = mkTerm "chaise_N" ;
lin chaise_longue_N = mkTerm "chaise_longue_N" ;
lin chaja_N = mkTerm "chaja_N" ;
lin chalaza_N = mkTerm "chalaza_N" ;
lin chalazion_N = mkTerm "chalazion_N" ;
lin chalcedony_N = mkTerm "chalcedony_N" ;
lin chalcocite_N = mkTerm "chalcocite_N" ;
lin chalcopyrite_N = mkTerm "chalcopyrite_N" ;
lin chaldron_N = mkTerm "chaldron_N" ;
lin chalet_N = mkTerm "chalet_N" ;
lin chalfont_PN = mkTerm "chalfont_PN" ;
lin chalfont_st_giles_PN = mkTerm "chalfont_st_giles_PN" ;
lin chalfont_st_peter_PN = mkTerm "chalfont_st_peter_PN" ;
lin chalice_N = mkTerm "chalice_N" ;
lin chalk_N = mkTerm "chalk_N" ;
lin chalk_V2 = mkTerm "chalk_V2" ;
lin chalk_out_V2 = mkTerm "chalk_out_V2" ;
lin chalk_up_V2 = mkTerm "chalk_up_V2" ;
lin chalk_up_to_V3 = mkTerm "chalk_up_to_V3" ;
lin chalkpit_N = mkTerm "chalkpit_N" ;
lin chalky_A = mkTerm "chalky_A" ;
lin challah_N = mkTerm "challah_N" ;
lin challenge_N = mkTerm "challenge_N" ;
lin challenge_V = mkTerm "challenge_V" ;
lin challenge_V2 = mkTerm "challenge_V2" ;
lin challengeable_A = mkTerm "challengeable_A" ;
lin challenger_N = mkTerm "challenger_N" ;
lin challis_N = mkTerm "challis_N" ;
lin chalybeate_A = mkTerm "chalybeate_A" ;
lin chamber_N = mkTerm "chamber_N" ;
lin chambered_A = mkTerm "chambered_A" ;
lin chamberlain_N = mkTerm "chamberlain_N" ;
lin chambermaid_N = mkTerm "chambermaid_N" ;
lin chamberpot_N = mkTerm "chamberpot_N" ;
lin chambray_N = mkTerm "chambray_N" ;
lin chameleon_N = mkTerm "chameleon_N" ;
lin chammy_leather_N = mkTerm "chammy_leather_N" ;
lin chamois_N = mkTerm "chamois_N" ;
lin chamois_leather_N = mkTerm "chamois_leather_N" ;
lin chamosite_N = mkTerm "chamosite_N" ;
lin champ_N = mkTerm "champ_N" ;
lin champ_V = mkTerm "champ_V" ;
lin champ_V2 = mkTerm "champ_V2" ;
lin champagne_N = mkTerm "champagne_N" ;
lin champerty_N = mkTerm "champerty_N" ;
lin champion_A = mkTerm "champion_A" ;
lin champion_Adv = mkTerm "champion_Adv" ;
lin champion_N = mkTerm "champion_N" ;
lin champion_V2 = mkTerm "champion_V2" ;
lin championship_N = mkTerm "championship_N" ;
lin champleve_A = mkTerm "champleve_A" ;
lin chanar_N = mkTerm "chanar_N" ;
lin chance_N = mkTerm "chance_N" ;
lin chance_V = mkTerm "chance_V" ;
lin chance_V2 = mkTerm "chance_V2" ;
lin chance_upon_V2 = mkTerm "chance_upon_V2" ;
lin chancel_N = mkTerm "chancel_N" ;
lin chancellery_N = mkTerm "chancellery_N" ;
lin chancellor_N = mkTerm "chancellor_N" ;
lin chancellorship_N = mkTerm "chancellorship_N" ;
lin chancery_N = mkTerm "chancery_N" ;
lin chancre_N = mkTerm "chancre_N" ;
lin chancroid_N = mkTerm "chancroid_N" ;
lin chancroidal_A = mkTerm "chancroidal_A" ;
lin chancrous_A = mkTerm "chancrous_A" ;
lin chancy_A = mkTerm "chancy_A" ;
lin chandelier_N = mkTerm "chandelier_N" ;
lin chandelle_N = mkTerm "chandelle_N" ;
lin chandler_N = mkTerm "chandler_N" ;
lin chandlery_N = mkTerm "chandlery_N" ;
lin chanfron_N = mkTerm "chanfron_N" ;
lin changchun_PN = mkTerm "changchun_PN" ;
lin change_N = mkTerm "change_N" ;
lin change_V = mkTerm "change_V" ;
lin change_V2 = mkTerm "change_V2" ;
lin change_over_V2 = mkTerm "change_over_V2" ;
lin changeable_A = mkTerm "changeable_A" ;
lin changeableness_N = mkTerm "changeableness_N" ;
lin changeful_A = mkTerm "changeful_A" ;
lin changeless_A = mkTerm "changeless_A" ;
lin changelessness_N = mkTerm "changelessness_N" ;
lin changeling_N = mkTerm "changeling_N" ;
lin changeover_N = mkTerm "changeover_N" ;
lin changer_N = mkTerm "changer_N" ;
lin changing_A = mkTerm "changing_A" ;
lin changsha_PN = mkTerm "changsha_PN" ;
lin channel_N = mkTerm "channel_N" ;
lin channel_V2 = mkTerm "channel_V2" ;
lin channelization_N = mkTerm "channelization_N" ;
lin channels_N = mkTerm "channels_N" ;
lin chant_N = mkTerm "chant_N" ;
lin chant_V = mkTerm "chant_V" ;
lin chant_V2 = mkTerm "chant_V2" ;
lin chanter_N = mkTerm "chanter_N" ;
lin chanterelle_N = mkTerm "chanterelle_N" ;
lin chantey_N = mkTerm "chantey_N" ;
lin chantlike_A = mkTerm "chantlike_A" ;
lin chantry_N = mkTerm "chantry_N" ;
lin chaos_N = mkTerm "chaos_N" ;
lin chaotic_A = mkTerm "chaotic_A" ;
lin chap_N = mkTerm "chap_N" ;
lin chap_V = mkTerm "chap_V" ;
lin chap_V2 = mkTerm "chap_V2" ;
lin chapatti_N = mkTerm "chapatti_N" ;
lin chapel_N = mkTerm "chapel_N" ;
lin chapelgoer_N = mkTerm "chapelgoer_N" ;
lin chaperon_N = mkTerm "chaperon_N" ;
lin chaperon_V2 = mkTerm "chaperon_V2" ;
lin chapfallen_A = mkTerm "chapfallen_A" ;
lin chaplain_N = mkTerm "chaplain_N" ;
lin chaplaincy_N = mkTerm "chaplaincy_N" ;
lin chaplet_N = mkTerm "chaplet_N" ;
lin chapleted_A = mkTerm "chapleted_A" ;
lin chapman_N = mkTerm "chapman_N" ;
lin chapter_N = mkTerm "chapter_N" ;
lin chapterhouse_N = mkTerm "chapterhouse_N" ;
lin char_N = mkTerm "char_N" ;
lin char_V = mkTerm "char_V" ;
lin char_V2 = mkTerm "char_V2" ;
lin charabanc_N = mkTerm "charabanc_N" ;
lin characin_N = mkTerm "characin_N" ;
lin character_1_N = mkTerm "character_1_N" ;
lin character_2_N = mkTerm "character_2_N" ;
lin characteristic_A = mkTerm "characteristic_A" ;
lin characteristic_N = mkTerm "characteristic_N" ;
lin characterization_N = mkTerm "characterization_N" ;
lin characterize_V2 = mkTerm "characterize_V2" ;
lin characterless_A = mkTerm "characterless_A" ;
lin charade_N = mkTerm "charade_N" ;
lin charades_N = mkTerm "charades_N" ;
lin charcoal_A = mkTerm "charcoal_A" ;
lin charcoal_N = mkTerm "charcoal_N" ;
lin charcoal_burner_N = mkTerm "charcoal_burner_N" ;
lin charcuterie_N = mkTerm "charcuterie_N" ;
lin chard_N = mkTerm "chard_N" ;
lin chard_PN = mkTerm "chard_PN" ;
lin charge_1_N = mkTerm "charge_1_N" ;
lin charge_2_N = mkTerm "charge_2_N" ;
lin charge_V = mkTerm "charge_V" ;
lin charge_V2 = mkTerm "charge_V2" ;
lin charge_account_N = mkTerm "charge_account_N" ;
lin charge_d'affaires_N = mkTerm "charge_d'affaires_N" ;
lin charge_off_V = mkTerm "charge_off_V" ;
lin charge_sheet_N = mkTerm "charge_sheet_N" ;
lin charge_up_V2 = mkTerm "charge_up_V2" ;
lin charge_with_V3 = mkTerm "charge_with_V3" ;
lin chargeable_A = mkTerm "chargeable_A" ;
lin charger_N = mkTerm "charger_N" ;
lin chariot_N = mkTerm "chariot_N" ;
lin charioteer_N = mkTerm "charioteer_N" ;
lin charisma_N = mkTerm "charisma_N" ;
lin charismatic_A = mkTerm "charismatic_A" ;
lin charitable_A = mkTerm "charitable_A" ;
lin charitableness_N = mkTerm "charitableness_N" ;
lin charity_N = mkTerm "charity_N" ;
lin charivari_N = mkTerm "charivari_N" ;
lin charlady_N = mkTerm "charlady_N" ;
lin charlatan_N = mkTerm "charlatan_N" ;
lin charlatanism_N = mkTerm "charlatanism_N" ;
lin charles_PN = mkTerm "charles_PN" ;
lin charleston_N = mkTerm "charleston_N" ;
lin charlie_PN = mkTerm "charlie_PN" ;
lin charlock_N = mkTerm "charlock_N" ;
lin charlotte_N = mkTerm "charlotte_N" ;
lin charlotte_PN = mkTerm "charlotte_PN" ;
lin charm_N = mkTerm "charm_N" ;
lin charm_V = mkTerm "charm_V" ;
lin charm_V2 = mkTerm "charm_V2" ;
lin charmer_N = mkTerm "charmer_N" ;
lin charming_A = mkTerm "charming_A" ;
lin charnel_A = mkTerm "charnel_A" ;
lin charnel_house_N = mkTerm "charnel_house_N" ;
lin chart_N = mkTerm "chart_N" ;
lin chart_V2 = mkTerm "chart_V2" ;
lin chartaceous_A = mkTerm "chartaceous_A" ;
lin charter_N = mkTerm "charter_N" ;
lin charter_V2 = mkTerm "charter_V2" ;
lin charter_party_N = mkTerm "charter_party_N" ;
lin charterhouse_N = mkTerm "charterhouse_N" ;
lin chartism_N = mkTerm "chartism_N" ;
lin chartist_N = mkTerm "chartist_N" ;
lin chartless_A = mkTerm "chartless_A" ;
lin chartreuse_A = mkTerm "chartreuse_A" ;
lin chartreuse_N = mkTerm "chartreuse_N" ;
lin charwoman_N = mkTerm "charwoman_N" ;
lin chary_A = mkTerm "chary_A" ;
lin charybdis_PN = mkTerm "charybdis_PN" ;
lin chas_PN = mkTerm "chas_PN" ;
lin chase_N = mkTerm "chase_N" ;
lin chase_V = mkTerm "chase_V" ;
lin chase_V2 = mkTerm "chase_V2" ;
lin chase_down_V2 = mkTerm "chase_down_V2" ;
lin chase_off_V2 = mkTerm "chase_off_V2" ;
lin chase_up_V2 = mkTerm "chase_up_V2" ;
lin chaser_N = mkTerm "chaser_N" ;
lin chasm_N = mkTerm "chasm_N" ;
lin chasse_N = mkTerm "chasse_N" ;
lin chassis_N = mkTerm "chassis_N" ;
lin chaste_A = mkTerm "chaste_A" ;
lin chasten_V2 = mkTerm "chasten_V2" ;
lin chasteness_N = mkTerm "chasteness_N" ;
lin chastise_V2 = mkTerm "chastise_V2" ;
lin chastisement_N = mkTerm "chastisement_N" ;
lin chastity_N = mkTerm "chastity_N" ;
lin chasuble_N = mkTerm "chasuble_N" ;
lin chat_N = mkTerm "chat_N" ;
lin chat_V = mkTerm "chat_V" ;
lin chat_up_V2 = mkTerm "chat_up_V2" ;
lin chateau_N = mkTerm "chateau_N" ;
lin chatelaine_N = mkTerm "chatelaine_N" ;
lin chatham_PN = mkTerm "chatham_PN" ;
lin chattel_N = mkTerm "chattel_N" ;
lin chatter_N = mkTerm "chatter_N" ;
lin chatter_V = mkTerm "chatter_V" ;
lin chatterbox_N = mkTerm "chatterbox_N" ;
lin chatterer_N = mkTerm "chatterer_N" ;
lin chatty_A = mkTerm "chatty_A" ;
lin chauffeur_N = mkTerm "chauffeur_N" ;
lin chauffeur_V2 = mkTerm "chauffeur_V2" ;
lin chauffeuse_N = mkTerm "chauffeuse_N" ;
lin chaulmoogra_N = mkTerm "chaulmoogra_N" ;
lin chauvinism_N = mkTerm "chauvinism_N" ;
lin chauvinist_N = mkTerm "chauvinist_N" ;
lin chauvinistic_A = mkTerm "chauvinistic_A" ;
lin chaw_N = mkTerm "chaw_N" ;
lin chaw_V2 = mkTerm "chaw_V2" ;
lin chaw_bacon_N = mkTerm "chaw_bacon_N" ;
lin cheadle_PN = mkTerm "cheadle_PN" ;
lin cheap_A = mkTerm "cheap_A" ;
lin cheapen_V = mkTerm "cheapen_V" ;
lin cheapen_V2 = mkTerm "cheapen_V2" ;
lin cheapjack_A = mkTerm "cheapjack_A" ;
lin cheapjack_N = mkTerm "cheapjack_N" ;
lin cheapness_N = mkTerm "cheapness_N" ;
lin cheapskate_N = mkTerm "cheapskate_N" ;
lin cheat_N = mkTerm "cheat_N" ;
lin cheat_V = mkTerm "cheat_V" ;
lin cheat_V2 = mkTerm "cheat_V2" ;
lin cheat_on_V2 = mkTerm "cheat_on_V2" ;
lin cheat_out_of_V3 = mkTerm "cheat_out_of_V3" ;
lin chebab_N = mkTerm "chebab_N" ;
lin check_N = mkTerm "check_N" ;
lin check_V = mkTerm "check_V" ;
lin check_V2 = mkTerm "check_V2" ;
lin check_back_V = mkTerm "check_back_V" ;
lin check_by_V2 = mkTerm "check_by_V2" ;
lin check_for_V2 = mkTerm "check_for_V2" ;
lin check_in_V = mkTerm "check_in_V" ;
lin check_in_V2 = mkTerm "check_in_V2" ;
lin check_into_V2 = mkTerm "check_into_V2" ;
lin check_off_V2 = mkTerm "check_off_V2" ;
lin check_on_V2 = mkTerm "check_on_V2" ;
lin check_out_V = mkTerm "check_out_V" ;
lin check_out_V2 = mkTerm "check_out_V2" ;
lin check_out_of_V2 = mkTerm "check_out_of_V2" ;
lin check_over_V2 = mkTerm "check_over_V2" ;
lin check_through_V2 = mkTerm "check_through_V2" ;
lin check_up_on_V2 = mkTerm "check_up_on_V2" ;
lin check_with_V2 = mkTerm "check_with_V2" ;
lin checkbook_N = mkTerm "checkbook_N" ;
lin checker_N = mkTerm "checker_N" ;
lin checker_V2 = mkTerm "checker_V2" ;
lin checkerbloom_N = mkTerm "checkerbloom_N" ;
lin checkerboard_N = mkTerm "checkerboard_N" ;
lin checkers_N = mkTerm "checkers_N" ;
lin checklist_N = mkTerm "checklist_N" ;
lin checkmate_N = mkTerm "checkmate_N" ;
lin checkmate_V2 = mkTerm "checkmate_V2" ;
lin checkout_N = mkTerm "checkout_N" ;
lin checkpoint_N = mkTerm "checkpoint_N" ;
lin checkroom_N = mkTerm "checkroom_N" ;
lin checksum_N = mkTerm "checksum_N" ;
lin checkup_N = mkTerm "checkup_N" ;
lin cheddar_N = mkTerm "cheddar_N" ;
lin cheek_N = mkTerm "cheek_N" ;
lin cheek_V2 = mkTerm "cheek_V2" ;
lin cheekbone_N = mkTerm "cheekbone_N" ;
lin cheekpiece_N = mkTerm "cheekpiece_N" ;
lin cheeky_A = mkTerm "cheeky_A" ;
lin cheep_N = mkTerm "cheep_N" ;
lin cheep_V = mkTerm "cheep_V" ;
lin cheer_N = mkTerm "cheer_N" ;
lin cheer_V = mkTerm "cheer_V" ;
lin cheer_V2 = mkTerm "cheer_V2" ;
lin cheer_on_V2 = mkTerm "cheer_on_V2" ;
lin cheer_up_V = mkTerm "cheer_up_V" ;
lin cheer_up_V2 = mkTerm "cheer_up_V2" ;
lin cheerer_N = mkTerm "cheerer_N" ;
lin cheerful_A = mkTerm "cheerful_A" ;
lin cheerfulness_N = mkTerm "cheerfulness_N" ;
lin cheering_N = mkTerm "cheering_N" ;
lin cheerleader_N = mkTerm "cheerleader_N" ;
lin cheerless_A = mkTerm "cheerless_A" ;
lin cheerlessness_N = mkTerm "cheerlessness_N" ;
lin cheers_Interj = mkTerm "cheers_Interj" ;
lin cheery_A = mkTerm "cheery_A" ;
lin cheese_N = mkTerm "cheese_N" ;
lin cheeseboard_N = mkTerm "cheeseboard_N" ;
lin cheeseburger_N = mkTerm "cheeseburger_N" ;
lin cheesecake_N = mkTerm "cheesecake_N" ;
lin cheesecloth_N = mkTerm "cheesecloth_N" ;
lin cheeselike_A = mkTerm "cheeselike_A" ;
lin cheesemonger_N = mkTerm "cheesemonger_N" ;
lin cheeseparing_A = mkTerm "cheeseparing_A" ;
lin cheetah_N = mkTerm "cheetah_N" ;
lin chef_N = mkTerm "chef_N" ;
lin chef_d'oeuvre_N = mkTerm "chef_d'oeuvre_N" ;
lin cheilitis_N = mkTerm "cheilitis_N" ;
lin cheilosis_N = mkTerm "cheilosis_N" ;
lin chela_N = mkTerm "chela_N" ;
lin chelate_A = mkTerm "chelate_A" ;
lin chelate_N = mkTerm "chelate_N" ;
lin chelation_N = mkTerm "chelation_N" ;
lin chelicera_N = mkTerm "chelicera_N" ;
lin cheliceral_A = mkTerm "cheliceral_A" ;
lin chelicerous_A = mkTerm "chelicerous_A" ;
lin cheliferous_A = mkTerm "cheliferous_A" ;
lin chelmsford_PN = mkTerm "chelmsford_PN" ;
lin chelonian_A = mkTerm "chelonian_A" ;
lin chelonian_N = mkTerm "chelonian_N" ;
lin chelsea_PN = mkTerm "chelsea_PN" ;
lin cheltenham_PN = mkTerm "cheltenham_PN" ;
lin chelyabinsk_PN = mkTerm "chelyabinsk_PN" ;
lin chemical_A = mkTerm "chemical_A" ;
lin chemical_N = mkTerm "chemical_N" ;
lin chemiluminescence_N = mkTerm "chemiluminescence_N" ;
lin chemiluminescent_A = mkTerm "chemiluminescent_A" ;
lin chemise_N = mkTerm "chemise_N" ;
lin chemisorption_N = mkTerm "chemisorption_N" ;
lin chemisorptive_A = mkTerm "chemisorptive_A" ;
lin chemistFem_N = mkTerm "chemistFem_N" ;
lin chemistMasc_N = mkTerm "chemistMasc_N" ;
lin chemistry_N = mkTerm "chemistry_N" ;
lin chemoreceptive_A = mkTerm "chemoreceptive_A" ;
lin chemoreceptor_N = mkTerm "chemoreceptor_N" ;
lin chemosis_N = mkTerm "chemosis_N" ;
lin chemosurgery_N = mkTerm "chemosurgery_N" ;
lin chemosynthesis_N = mkTerm "chemosynthesis_N" ;
lin chemotaxis_N = mkTerm "chemotaxis_N" ;
lin chemotherapeutic_A = mkTerm "chemotherapeutic_A" ;
lin chemotherapy_N = mkTerm "chemotherapy_N" ;
lin chengchow_PN = mkTerm "chengchow_PN" ;
lin chengtu_PN = mkTerm "chengtu_PN" ;
lin chenille_N = mkTerm "chenille_N" ;
lin chepstow_PN = mkTerm "chepstow_PN" ;
lin cheque_N = mkTerm "cheque_N" ;
lin chequebook_N = mkTerm "chequebook_N" ;
lin chequer_V2 = mkTerm "chequer_V2" ;
lin cherimoya_N = mkTerm "cherimoya_N" ;
lin cherish_V2 = mkTerm "cherish_V2" ;
lin cheroot_N = mkTerm "cheroot_N" ;
lin cherry_A = mkTerm "cherry_A" ;
lin cherry_N = mkTerm "cherry_N" ;
lin cherrystone_N = mkTerm "cherrystone_N" ;
lin chert_N = mkTerm "chert_N" ;
lin cherty_A = mkTerm "cherty_A" ;
lin cherub_N = mkTerm "cherub_N" ;
lin cherubic_A = mkTerm "cherubic_A" ;
lin chervil_N = mkTerm "chervil_N" ;
lin chesham_PN = mkTerm "chesham_PN" ;
lin cheshire_PN = mkTerm "cheshire_PN" ;
lin chess_N = mkTerm "chess_N" ;
lin chessboard_N = mkTerm "chessboard_N" ;
lin chessman_N = mkTerm "chessman_N" ;
lin chest_N = mkTerm "chest_N" ;
lin chester_PN = mkTerm "chester_PN" ;
lin chester_le_street_PN = mkTerm "chester_le_street_PN" ;
lin chesterfield_N = mkTerm "chesterfield_N" ;
lin chesterfield_PN = mkTerm "chesterfield_PN" ;
lin chestnut_A = mkTerm "chestnut_A" ;
lin chestnut_N = mkTerm "chestnut_N" ;
lin chetrum_N = mkTerm "chetrum_N" ;
lin cheval_glass_N = mkTerm "cheval_glass_N" ;
lin chevron_N = mkTerm "chevron_N" ;
lin chevrotain_N = mkTerm "chevrotain_N" ;
lin chew_N = mkTerm "chew_N" ;
lin chew_V = mkTerm "chew_V" ;
lin chew_V2 = mkTerm "chew_V2" ;
lin chew_off_V2 = mkTerm "chew_off_V2" ;
lin chew_on_V2 = mkTerm "chew_on_V2" ;
lin chew_out_V2 = mkTerm "chew_out_V2" ;
lin chew_over_V2 = mkTerm "chew_over_V2" ;
lin chew_up_V2 = mkTerm "chew_up_V2" ;
lin chewable_A = mkTerm "chewable_A" ;
lin chewer_N = mkTerm "chewer_N" ;
lin chewing_gum_N = mkTerm "chewing_gum_N" ;
lin chewink_N = mkTerm "chewink_N" ;
lin chewy_A = mkTerm "chewy_A" ;
lin chez_Prep = mkTerm "chez_Prep" ;
lin chi_N = mkTerm "chi_N" ;
lin chianti_N = mkTerm "chianti_N" ;
lin chiaroscuro_N = mkTerm "chiaroscuro_N" ;
lin chiasma_N = mkTerm "chiasma_N" ;
lin chiasmal_A = mkTerm "chiasmal_A" ;
lin chiasmus_N = mkTerm "chiasmus_N" ;
lin chic_A = mkTerm "chic_A" ;
lin chic_N = mkTerm "chic_N" ;
lin chicago_PN = mkTerm "chicago_PN" ;
lin chicane_N = mkTerm "chicane_N" ;
lin chicanery_N = mkTerm "chicanery_N" ;
lin chichester_PN = mkTerm "chichester_PN" ;
lin chichi_A = mkTerm "chichi_A" ;
lin chichi_N = mkTerm "chichi_N" ;
lin chichipe_N = mkTerm "chichipe_N" ;
lin chick_N = mkTerm "chick_N" ;
lin chickadee_N = mkTerm "chickadee_N" ;
lin chicken_A = mkTerm "chicken_A" ;
lin chicken_N = mkTerm "chicken_N" ;
lin chicken_hearted_A = mkTerm "chicken_hearted_A" ;
lin chicken_out_V = mkTerm "chicken_out_V" ;
lin chicken_run_N = mkTerm "chicken_run_N" ;
lin chickenfeed_N = mkTerm "chickenfeed_N" ;
lin chickenpox_N = mkTerm "chickenpox_N" ;
lin chickenshit_N = mkTerm "chickenshit_N" ;
lin chickeree_N = mkTerm "chickeree_N" ;
lin chickpea_N = mkTerm "chickpea_N" ;
lin chickweed_N = mkTerm "chickweed_N" ;
lin chicle_N = mkTerm "chicle_N" ;
lin chicory_N = mkTerm "chicory_N" ;
lin chide_V = mkTerm "chide_V" ;
lin chide_V2 = mkTerm "chide_V2" ;
lin chiding_N = mkTerm "chiding_N" ;
lin chief_A = mkTerm "chief_A" ;
lin chief_N = mkTerm "chief_N" ;
lin chieftainFem_N = mkTerm "chieftainFem_N" ;
lin chieftainMasc_N = mkTerm "chieftainMasc_N" ;
lin chieftaincy_N = mkTerm "chieftaincy_N" ;
lin chiffon_N = mkTerm "chiffon_N" ;
lin chiffonier_N = mkTerm "chiffonier_N" ;
lin chigetai_N = mkTerm "chigetai_N" ;
lin chignon_N = mkTerm "chignon_N" ;
lin chigoe_N = mkTerm "chigoe_N" ;
lin chilblain_N = mkTerm "chilblain_N" ;
lin chilblained_A = mkTerm "chilblained_A" ;
lin child's_play_N = mkTerm "child's_play_N" ;
lin child_N = mkTerm "child_N" ;
lin child_bearing_N = mkTerm "child_bearing_N" ;
lin childbearing_A = mkTerm "childbearing_A" ;
lin childbirth_N = mkTerm "childbirth_N" ;
lin childcare_N = mkTerm "childcare_N" ;
lin childhood_N = mkTerm "childhood_N" ;
lin childish_A = mkTerm "childish_A" ;
lin childishness_N = mkTerm "childishness_N" ;
lin childless_A = mkTerm "childless_A" ;
lin childlessness_N = mkTerm "childlessness_N" ;
lin childlike_A = mkTerm "childlike_A" ;
lin chile_PN = mkTerm "chile_PN" ;
lin chileanFem_N = mkTerm "chileanFem_N" ;
lin chileanMasc_N = mkTerm "chileanMasc_N" ;
lin chilean_A = mkTerm "chilean_A" ;
lin chili_N = mkTerm "chili_N" ;
lin chill_A = mkTerm "chill_A" ;
lin chill_N = mkTerm "chill_N" ;
lin chill_V = mkTerm "chill_V" ;
lin chill_V2 = mkTerm "chill_V2" ;
lin chill_out_V = mkTerm "chill_out_V" ;
lin chilliness_N = mkTerm "chilliness_N" ;
lin chilly_A = mkTerm "chilly_A" ;
lin chilly_N = mkTerm "chilly_N" ;
lin chimaera_N = mkTerm "chimaera_N" ;
lin chime_N = mkTerm "chime_N" ;
lin chime_V = mkTerm "chime_V" ;
lin chime_V2 = mkTerm "chime_V2" ;
lin chime_in_V = mkTerm "chime_in_V" ;
lin chimera_N = mkTerm "chimera_N" ;
lin chimeric_A = mkTerm "chimeric_A" ;
lin chimerical_A = mkTerm "chimerical_A" ;
lin chimney_N = mkTerm "chimney_N" ;
lin chimney_sweep_N = mkTerm "chimney_sweep_N" ;
lin chimneybreast_N = mkTerm "chimneybreast_N" ;
lin chimneypiece_N = mkTerm "chimneypiece_N" ;
lin chimneypot_N = mkTerm "chimneypot_N" ;
lin chimneystack_N = mkTerm "chimneystack_N" ;
lin chimneysweeper_N = mkTerm "chimneysweeper_N" ;
lin chimp_N = mkTerm "chimp_N" ;
lin chimpanzee_N = mkTerm "chimpanzee_N" ;
lin chin_N = mkTerm "chin_N" ;
lin chin_strap_N = mkTerm "chin_strap_N" ;
lin chin_wagging_N = mkTerm "chin_wagging_N" ;
lin china_N = mkTerm "china_N" ;
lin china_PN = mkTerm "china_PN" ;
lin china_closet_N = mkTerm "china_closet_N" ;
lin chinaberry_N = mkTerm "chinaberry_N" ;
lin chinaware_N = mkTerm "chinaware_N" ;
lin chincapin_N = mkTerm "chincapin_N" ;
lin chincherinchee_N = mkTerm "chincherinchee_N" ;
lin chinchilla_N = mkTerm "chinchilla_N" ;
lin chinchow_PN = mkTerm "chinchow_PN" ;
lin chine_N = mkTerm "chine_N" ;
lin chineseFem_N = mkTerm "chineseFem_N" ;
lin chineseMasc_N = mkTerm "chineseMasc_N" ;
lin chinese_A = mkTerm "chinese_A" ;
lin chink_N = mkTerm "chink_N" ;
lin chink_V = mkTerm "chink_V" ;
lin chink_V2 = mkTerm "chink_V2" ;
lin chinless_A = mkTerm "chinless_A" ;
lin chino_N = mkTerm "chino_N" ;
lin chinoiserie_N = mkTerm "chinoiserie_N" ;
lin chinook_N = mkTerm "chinook_N" ;
lin chintz_N = mkTerm "chintz_N" ;
lin chip_N = mkTerm "chip_N" ;
lin chip_V = mkTerm "chip_V" ;
lin chip_V2 = mkTerm "chip_V2" ;
lin chip_away_V = mkTerm "chip_away_V" ;
lin chip_away_at_V2 = mkTerm "chip_away_at_V2" ;
lin chip_in_V = mkTerm "chip_in_V" ;
lin chipboard_N = mkTerm "chipboard_N" ;
lin chipmunk_N = mkTerm "chipmunk_N" ;
lin chipolata_N = mkTerm "chipolata_N" ;
lin chipotle_N = mkTerm "chipotle_N" ;
lin chippendale_N = mkTerm "chippendale_N" ;
lin chippenham_PN = mkTerm "chippenham_PN" ;
lin chipper_A = mkTerm "chipper_A" ;
lin chips_N = mkTerm "chips_N" ;
lin chiralgia_N = mkTerm "chiralgia_N" ;
lin chiromantic_A = mkTerm "chiromantic_A" ;
lin chiropodist_N = mkTerm "chiropodist_N" ;
lin chiropody_N = mkTerm "chiropody_N" ;
lin chiropractic_N = mkTerm "chiropractic_N" ;
lin chiropractor_N = mkTerm "chiropractor_N" ;
lin chirp_N = mkTerm "chirp_N" ;
lin chirp_V = mkTerm "chirp_V" ;
lin chirp_V2 = mkTerm "chirp_V2" ;
lin chirpiness_N = mkTerm "chirpiness_N" ;
lin chirpy_A = mkTerm "chirpy_A" ;
lin chirrup_N = mkTerm "chirrup_N" ;
lin chirrup_V = mkTerm "chirrup_V" ;
lin chirrup_V2 = mkTerm "chirrup_V2" ;
lin chisel_N = mkTerm "chisel_N" ;
lin chisel_V2 = mkTerm "chisel_V2" ;
lin chiseled_A = mkTerm "chiseled_A" ;
lin chiseller_N = mkTerm "chiseller_N" ;
lin chit_N = mkTerm "chit_N" ;
lin chit_chat_N = mkTerm "chit_chat_N" ;
lin chitchat_N = mkTerm "chitchat_N" ;
lin chitin_N = mkTerm "chitin_N" ;
lin chitinous_A = mkTerm "chitinous_A" ;
lin chiton_N = mkTerm "chiton_N" ;
lin chitterlings_N = mkTerm "chitterlings_N" ;
lin chivalric_A = mkTerm "chivalric_A" ;
lin chivalrous_A = mkTerm "chivalrous_A" ;
lin chivalry_N = mkTerm "chivalry_N" ;
lin chive_N = mkTerm "chive_N" ;
lin chives_N = mkTerm "chives_N" ;
lin chivvy_V2 = mkTerm "chivvy_V2" ;
lin chlamydeous_A = mkTerm "chlamydeous_A" ;
lin chlamydia_N = mkTerm "chlamydia_N" ;
lin chlamydial_A = mkTerm "chlamydial_A" ;
lin chlamydospore_N = mkTerm "chlamydospore_N" ;
lin chlamys_N = mkTerm "chlamys_N" ;
lin chloasma_N = mkTerm "chloasma_N" ;
lin chloe_PN = mkTerm "chloe_PN" ;
lin chlorambucil_N = mkTerm "chlorambucil_N" ;
lin chloramine_N = mkTerm "chloramine_N" ;
lin chloramphenicol_N = mkTerm "chloramphenicol_N" ;
lin chlorate_N = mkTerm "chlorate_N" ;
lin chlordiazepoxide_N = mkTerm "chlordiazepoxide_N" ;
lin chlorella_N = mkTerm "chlorella_N" ;
lin chlorenchyma_N = mkTerm "chlorenchyma_N" ;
lin chlorhexidine_N = mkTerm "chlorhexidine_N" ;
lin chloride_N = mkTerm "chloride_N" ;
lin chlorinate_V2 = mkTerm "chlorinate_V2" ;
lin chlorination_N = mkTerm "chlorination_N" ;
lin chlorine_N = mkTerm "chlorine_N" ;
lin chlorinity_N = mkTerm "chlorinity_N" ;
lin chlorite_N = mkTerm "chlorite_N" ;
lin chloroacetophenone_N = mkTerm "chloroacetophenone_N" ;
lin chlorobenzene_N = mkTerm "chlorobenzene_N" ;
lin chlorobenzylidenemalononitrile_N = mkTerm "chlorobenzylidenemalononitrile_N" ;
lin chlorofluorocarbon_N = mkTerm "chlorofluorocarbon_N" ;
lin chloroform_N = mkTerm "chloroform_N" ;
lin chlorophyll_N = mkTerm "chlorophyll_N" ;
lin chlorophyllose_A = mkTerm "chlorophyllose_A" ;
lin chloropicrin_N = mkTerm "chloropicrin_N" ;
lin chloroplast_N = mkTerm "chloroplast_N" ;
lin chloroprene_N = mkTerm "chloroprene_N" ;
lin chloroquine_N = mkTerm "chloroquine_N" ;
lin chlorosis_N = mkTerm "chlorosis_N" ;
lin chlorothiazide_N = mkTerm "chlorothiazide_N" ;
lin chlorotic_A = mkTerm "chlorotic_A" ;
lin chlorpromazine_N = mkTerm "chlorpromazine_N" ;
lin chlorpyrifos_N = mkTerm "chlorpyrifos_N" ;
lin chlortetracycline_N = mkTerm "chlortetracycline_N" ;
lin chlorthalidone_N = mkTerm "chlorthalidone_N" ;
lin choanocyte_N = mkTerm "choanocyte_N" ;
lin choc_N = mkTerm "choc_N" ;
lin choc_ice_N = mkTerm "choc_ice_N" ;
lin chock_Adv = mkTerm "chock_Adv" ;
lin chock_N = mkTerm "chock_N" ;
lin chock_V2 = mkTerm "chock_V2" ;
lin chock_a_block_A = mkTerm "chock_a_block_A" ;
lin chock_a_block_Adv = mkTerm "chock_a_block_Adv" ;
lin chock_full_A = mkTerm "chock_full_A" ;
lin chocolate_A = mkTerm "chocolate_A" ;
lin chocolate_N = mkTerm "chocolate_N" ;
lin choice_A = mkTerm "choice_A" ;
lin choice_N = mkTerm "choice_N" ;
lin choir_N = mkTerm "choir_N" ;
lin choir_school_N = mkTerm "choir_school_N" ;
lin choirboy_N = mkTerm "choirboy_N" ;
lin choirmaster_N = mkTerm "choirmaster_N" ;
lin choke_N = mkTerm "choke_N" ;
lin choke_V = mkTerm "choke_V" ;
lin choke_V2 = mkTerm "choke_V2" ;
lin choke_damp_N = mkTerm "choke_damp_N" ;
lin choke_off_V2 = mkTerm "choke_off_V2" ;
lin choke_out_V2 = mkTerm "choke_out_V2" ;
lin choke_up_V = mkTerm "choke_up_V" ;
lin choke_up_V2 = mkTerm "choke_up_V2" ;
lin chokecherry_N = mkTerm "chokecherry_N" ;
lin chokehold_N = mkTerm "chokehold_N" ;
lin chokepoint_N = mkTerm "chokepoint_N" ;
lin choker_N = mkTerm "choker_N" ;
lin chokey_N = mkTerm "chokey_N" ;
lin choking_N = mkTerm "choking_N" ;
lin choky_A = mkTerm "choky_A" ;
lin choky_N = mkTerm "choky_N" ;
lin cholangiography_N = mkTerm "cholangiography_N" ;
lin cholangitis_N = mkTerm "cholangitis_N" ;
lin cholecystectomy_N = mkTerm "cholecystectomy_N" ;
lin cholecystitis_N = mkTerm "cholecystitis_N" ;
lin cholecystokinin_N = mkTerm "cholecystokinin_N" ;
lin cholelithiasis_N = mkTerm "cholelithiasis_N" ;
lin cholelithotomy_N = mkTerm "cholelithotomy_N" ;
lin choler_N = mkTerm "choler_N" ;
lin cholera_N = mkTerm "cholera_N" ;
lin choleraic_A = mkTerm "choleraic_A" ;
lin choleric_A = mkTerm "choleric_A" ;
lin cholesterol_N = mkTerm "cholesterol_N" ;
lin choline_N = mkTerm "choline_N" ;
lin cholinergic_A = mkTerm "cholinergic_A" ;
lin cholinesterase_N = mkTerm "cholinesterase_N" ;
lin cholla_N = mkTerm "cholla_N" ;
lin chomping_N = mkTerm "chomping_N" ;
lin chon_N = mkTerm "chon_N" ;
lin chondrin_N = mkTerm "chondrin_N" ;
lin chondrite_N = mkTerm "chondrite_N" ;
lin chondritic_A = mkTerm "chondritic_A" ;
lin chondroma_N = mkTerm "chondroma_N" ;
lin chondrosarcoma_N = mkTerm "chondrosarcoma_N" ;
lin chondrule_N = mkTerm "chondrule_N" ;
lin choose_V2 = mkTerm "choose_V2" ;
lin choose_VV = mkTerm "choose_VV" ;
lin choose_up_V = mkTerm "choose_up_V" ;
lin choose_up_V2 = mkTerm "choose_up_V2" ;
lin choosey_A = mkTerm "choosey_A" ;
lin choosy_A = mkTerm "choosy_A" ;
lin chop_N = mkTerm "chop_N" ;
lin chop_V = mkTerm "chop_V" ;
lin chop_V2 = mkTerm "chop_V2" ;
lin chop_chop_Adv = mkTerm "chop_chop_Adv" ;
lin chop_down_V2 = mkTerm "chop_down_V2" ;
lin chop_house_N = mkTerm "chop_house_N" ;
lin chop_off_V = mkTerm "chop_off_V" ;
lin chop_out_V = mkTerm "chop_out_V" ;
lin chop_suey_N = mkTerm "chop_suey_N" ;
lin chop_up_V2 = mkTerm "chop_up_V2" ;
lin chopine_N = mkTerm "chopine_N" ;
lin chopper_N = mkTerm "chopper_N" ;
lin choppiness_N = mkTerm "choppiness_N" ;
lin choppy_A = mkTerm "choppy_A" ;
lin chopstick_N = mkTerm "chopstick_N" ;
lin chopwell_PN = mkTerm "chopwell_PN" ;
lin choragic_A = mkTerm "choragic_A" ;
lin choragus_N = mkTerm "choragus_N" ;
lin choral_A = mkTerm "choral_A" ;
lin chorale_N = mkTerm "chorale_N" ;
lin chord_N = mkTerm "chord_N" ;
lin chordal_A = mkTerm "chordal_A" ;
lin chordamesoderm_N = mkTerm "chordamesoderm_N" ;
lin chordate_A = mkTerm "chordate_A" ;
lin chordate_N = mkTerm "chordate_N" ;
lin chorditis_N = mkTerm "chorditis_N" ;
lin chordophone_N = mkTerm "chordophone_N" ;
lin chore_N = mkTerm "chore_N" ;
lin chorea_N = mkTerm "chorea_N" ;
lin choreographer_N = mkTerm "choreographer_N" ;
lin choreographic_A = mkTerm "choreographic_A" ;
lin choreography_N = mkTerm "choreography_N" ;
lin choric_A = mkTerm "choric_A" ;
lin chorioallantois_N = mkTerm "chorioallantois_N" ;
lin choriomeningitis_N = mkTerm "choriomeningitis_N" ;
lin chorion_N = mkTerm "chorion_N" ;
lin chorionic_A = mkTerm "chorionic_A" ;
lin chorioretinitis_N = mkTerm "chorioretinitis_N" ;
lin chorister_N = mkTerm "chorister_N" ;
lin chorizo_N = mkTerm "chorizo_N" ;
lin chorley_PN = mkTerm "chorley_PN" ;
lin choroid_N = mkTerm "choroid_N" ;
lin chortle_N = mkTerm "chortle_N" ;
lin chortle_V = mkTerm "chortle_V" ;
lin chorus_N = mkTerm "chorus_N" ;
lin chorus_V2 = mkTerm "chorus_V2" ;
lin chorus_girl_N = mkTerm "chorus_girl_N" ;
lin chosen_A = mkTerm "chosen_A" ;
lin chosen_N = mkTerm "chosen_N" ;
lin chough_N = mkTerm "chough_N" ;
lin chow_N = mkTerm "chow_N" ;
lin chow_down_V = mkTerm "chow_down_V" ;
lin chow_down_on_V2 = mkTerm "chow_down_on_V2" ;
lin chowchow_N = mkTerm "chowchow_N" ;
lin chowder_N = mkTerm "chowder_N" ;
lin chrestomathy_N = mkTerm "chrestomathy_N" ;
lin chris_PN = mkTerm "chris_PN" ;
lin chrism_N = mkTerm "chrism_N" ;
lin chrissie_PN = mkTerm "chrissie_PN" ;
lin chrissy_PN = mkTerm "chrissy_PN" ;
lin christ_N = mkTerm "christ_N" ;
lin christ_PN = mkTerm "christ_PN" ;
lin christchurch_PN = mkTerm "christchurch_PN" ;
lin christella_N = mkTerm "christella_N" ;
lin christen_V2 = mkTerm "christen_V2" ;
lin christendom_N = mkTerm "christendom_N" ;
lin christening_N = mkTerm "christening_N" ;
lin christian_A = mkTerm "christian_A" ;
lin christian_N = mkTerm "christian_N" ;
lin christian_PN = mkTerm "christian_PN" ;
lin christianity_N = mkTerm "christianity_N" ;
lin christianly_A = mkTerm "christianly_A" ;
lin christina_PN = mkTerm "christina_PN" ;
lin christine_PN = mkTerm "christine_PN" ;
lin christless_A = mkTerm "christless_A" ;
lin christlike_A = mkTerm "christlike_A" ;
lin christmas_N = mkTerm "christmas_N" ;
lin christmas_PN = mkTerm "christmas_PN" ;
lin christmas_box_N = mkTerm "christmas_box_N" ;
lin christmas_tree_N = mkTerm "christmas_tree_N" ;
lin christmastide_N = mkTerm "christmastide_N" ;
lin christmastime_N = mkTerm "christmastime_N" ;
lin christopher_PN = mkTerm "christopher_PN" ;
lin chromate_N = mkTerm "chromate_N" ;
lin chromatic_A = mkTerm "chromatic_A" ;
lin chromatid_N = mkTerm "chromatid_N" ;
lin chromatin_N = mkTerm "chromatin_N" ;
lin chromatinic_A = mkTerm "chromatinic_A" ;
lin chromatism_N = mkTerm "chromatism_N" ;
lin chromatogram_N = mkTerm "chromatogram_N" ;
lin chromatographic_A = mkTerm "chromatographic_A" ;
lin chromatography_N = mkTerm "chromatography_N" ;
lin chrome_N = mkTerm "chrome_N" ;
lin chromesthesia_N = mkTerm "chromesthesia_N" ;
lin chromite_N = mkTerm "chromite_N" ;
lin chromium_N = mkTerm "chromium_N" ;
lin chromoblastomycosis_N = mkTerm "chromoblastomycosis_N" ;
lin chromogen_N = mkTerm "chromogen_N" ;
lin chromolithography_N = mkTerm "chromolithography_N" ;
lin chromophore_N = mkTerm "chromophore_N" ;
lin chromoplast_N = mkTerm "chromoplast_N" ;
lin chromosomal_A = mkTerm "chromosomal_A" ;
lin chromosome_N = mkTerm "chromosome_N" ;
lin chromosphere_N = mkTerm "chromosphere_N" ;
lin chronic_A = mkTerm "chronic_A" ;
lin chronicle_N = mkTerm "chronicle_N" ;
lin chronicle_V2 = mkTerm "chronicle_V2" ;
lin chronicler_N = mkTerm "chronicler_N" ;
lin chronograph_N = mkTerm "chronograph_N" ;
lin chronological_A = mkTerm "chronological_A" ;
lin chronology_N = mkTerm "chronology_N" ;
lin chronometer_N = mkTerm "chronometer_N" ;
lin chronoscope_N = mkTerm "chronoscope_N" ;
lin chrysalis_N = mkTerm "chrysalis_N" ;
lin chrysanthemum_N = mkTerm "chrysanthemum_N" ;
lin chrysoberyl_N = mkTerm "chrysoberyl_N" ;
lin chrysolite_N = mkTerm "chrysolite_N" ;
lin chrysoprase_N = mkTerm "chrysoprase_N" ;
lin chrysotherapy_N = mkTerm "chrysotherapy_N" ;
lin chrysotile_N = mkTerm "chrysotile_N" ;
lin chthonian_A = mkTerm "chthonian_A" ;
lin chub_N = mkTerm "chub_N" ;
lin chubbiness_N = mkTerm "chubbiness_N" ;
lin chubby_A = mkTerm "chubby_A" ;
lin chuck_N = mkTerm "chuck_N" ;
lin chuck_V2 = mkTerm "chuck_V2" ;
lin chuck_away_V2 = mkTerm "chuck_away_V2" ;
lin chuck_in_V2 = mkTerm "chuck_in_V2" ;
lin chuck_out_V2 = mkTerm "chuck_out_V2" ;
lin chuck_up_V = mkTerm "chuck_up_V" ;
lin chuck_up_V2 = mkTerm "chuck_up_V2" ;
lin chucker_out_N = mkTerm "chucker_out_N" ;
lin chuckle_N = mkTerm "chuckle_N" ;
lin chuckle_V = mkTerm "chuckle_V" ;
lin chuckle_VS = mkTerm "chuckle_VS" ;
lin chuckwalla_N = mkTerm "chuckwalla_N" ;
lin chufa_N = mkTerm "chufa_N" ;
lin chuffed_A = mkTerm "chuffed_A" ;
lin chug_N = mkTerm "chug_N" ;
lin chug_V = mkTerm "chug_V" ;
lin chukka_N = mkTerm "chukka_N" ;
lin chukker_N = mkTerm "chukker_N" ;
lin chum_N = mkTerm "chum_N" ;
lin chum_V = mkTerm "chum_V" ;
lin chumminess_N = mkTerm "chumminess_N" ;
lin chummy_A = mkTerm "chummy_A" ;
lin chump_N = mkTerm "chump_N" ;
lin chunga_N = mkTerm "chunga_N" ;
lin chungking_PN = mkTerm "chungking_PN" ;
lin chunk_N = mkTerm "chunk_N" ;
lin chunky_A = mkTerm "chunky_A" ;
lin chunnel_N = mkTerm "chunnel_N" ;
lin church_N = mkTerm "church_N" ;
lin churchgoer_N = mkTerm "churchgoer_N" ;
lin churchgoing_A = mkTerm "churchgoing_A" ;
lin churchly_A = mkTerm "churchly_A" ;
lin churchman_N = mkTerm "churchman_N" ;
lin churchwarden_N = mkTerm "churchwarden_N" ;
lin churchyard_N = mkTerm "churchyard_N" ;
lin churidars_N = mkTerm "churidars_N" ;
lin churl_N = mkTerm "churl_N" ;
lin churlish_A = mkTerm "churlish_A" ;
lin churn_N = mkTerm "churn_N" ;
lin churn_V = mkTerm "churn_V" ;
lin churn_V2 = mkTerm "churn_V2" ;
lin churn_out_V2 = mkTerm "churn_out_V2" ;
lin chute_N = mkTerm "chute_N" ;
lin chutney_N = mkTerm "chutney_N" ;
lin chutzpa_N = mkTerm "chutzpa_N" ;
lin chutzpanik_N = mkTerm "chutzpanik_N" ;
lin chylaceous_A = mkTerm "chylaceous_A" ;
lin chyle_N = mkTerm "chyle_N" ;
lin chyliferous_A = mkTerm "chyliferous_A" ;
lin chylific_A = mkTerm "chylific_A" ;
lin chylomicron_N = mkTerm "chylomicron_N" ;
lin chyme_N = mkTerm "chyme_N" ;
lin cia_N = mkTerm "cia_N" ;
lin cicada_N = mkTerm "cicada_N" ;
lin cicala_N = mkTerm "cicala_N" ;
lin cicatrice_N = mkTerm "cicatrice_N" ;
lin cicatrix_N = mkTerm "cicatrix_N" ;
lin cicero_N = mkTerm "cicero_N" ;
lin cicerone_N = mkTerm "cicerone_N" ;
lin cichlid_N = mkTerm "cichlid_N" ;
lin cid_N = mkTerm "cid_N" ;
lin cider_N = mkTerm "cider_N" ;
lin ciderpress_N = mkTerm "ciderpress_N" ;
lin cif_PN = mkTerm "cif_PN" ;
lin cigar_N = mkTerm "cigar_N" ;
lin cigar_shaped_A = mkTerm "cigar_shaped_A" ;
lin cigarette_N = mkTerm "cigarette_N" ;
lin cigarette_case_N = mkTerm "cigarette_case_N" ;
lin cigarette_holder_N = mkTerm "cigarette_holder_N" ;
lin cigarette_paper_N = mkTerm "cigarette_paper_N" ;
lin cigarillo_N = mkTerm "cigarillo_N" ;
lin ciliary_A = mkTerm "ciliary_A" ;
lin ciliate_A = mkTerm "ciliate_A" ;
lin ciliate_N = mkTerm "ciliate_N" ;
lin cilium_N = mkTerm "cilium_N" ;
lin cimetidine_N = mkTerm "cimetidine_N" ;
lin cinch_N = mkTerm "cinch_N" ;
lin cinch_V2 = mkTerm "cinch_V2" ;
lin cinchona_N = mkTerm "cinchona_N" ;
lin cinchonine_N = mkTerm "cinchonine_N" ;
lin cincinnati_PN = mkTerm "cincinnati_PN" ;
lin cincture_N = mkTerm "cincture_N" ;
lin cinder_N = mkTerm "cinder_N" ;
lin cinder_track_N = mkTerm "cinder_track_N" ;
lin cinderella_N = mkTerm "cinderella_N" ;
lin cinderford_PN = mkTerm "cinderford_PN" ;
lin cine_camera_N = mkTerm "cine_camera_N" ;
lin cine_film_N = mkTerm "cine_film_N" ;
lin cine_projector_N = mkTerm "cine_projector_N" ;
lin cinema_N = mkTerm "cinema_N" ;
lin cinematic_A = mkTerm "cinematic_A" ;
lin cinematographer_N = mkTerm "cinematographer_N" ;
lin cinematography_N = mkTerm "cinematography_N" ;
lin cineraria_N = mkTerm "cineraria_N" ;
lin cinerary_A = mkTerm "cinerary_A" ;
lin cingulum_N = mkTerm "cingulum_N" ;
lin cinnabar_N = mkTerm "cinnabar_N" ;
lin cinnamon_N = mkTerm "cinnamon_N" ;
lin cinquefoil_N = mkTerm "cinquefoil_N" ;
lin cipher_N = mkTerm "cipher_N" ;
lin cipher_V = mkTerm "cipher_V" ;
lin cipher_V2 = mkTerm "cipher_V2" ;
lin ciprofloxacin_N = mkTerm "ciprofloxacin_N" ;
lin circa_Prep = mkTerm "circa_Prep" ;
lin circadian_A = mkTerm "circadian_A" ;
lin circle_N = mkTerm "circle_N" ;
lin circle_V = mkTerm "circle_V" ;
lin circle_V2 = mkTerm "circle_V2" ;
lin circlet_N = mkTerm "circlet_N" ;
lin circuit_N = mkTerm "circuit_N" ;
lin circuitous_A = mkTerm "circuitous_A" ;
lin circuitry_N = mkTerm "circuitry_N" ;
lin circular_A = mkTerm "circular_A" ;
lin circular_N = mkTerm "circular_N" ;
lin circularity_N = mkTerm "circularity_N" ;
lin circularization_N = mkTerm "circularization_N" ;
lin circularize_V2 = mkTerm "circularize_V2" ;
lin circulate_V = mkTerm "circulate_V" ;
lin circulate_V2 = mkTerm "circulate_V2" ;
lin circulation_N = mkTerm "circulation_N" ;
lin circulative_A = mkTerm "circulative_A" ;
lin circulatory_A = mkTerm "circulatory_A" ;
lin circumcise_V2 = mkTerm "circumcise_V2" ;
lin circumcision_N = mkTerm "circumcision_N" ;
lin circumduction_N = mkTerm "circumduction_N" ;
lin circumference_N = mkTerm "circumference_N" ;
lin circumferential_A = mkTerm "circumferential_A" ;
lin circumflex_N = mkTerm "circumflex_N" ;
lin circumlocution_N = mkTerm "circumlocution_N" ;
lin circumlocutious_A = mkTerm "circumlocutious_A" ;
lin circumnavigate_V2 = mkTerm "circumnavigate_V2" ;
lin circumnavigation_N = mkTerm "circumnavigation_N" ;
lin circumpolar_A = mkTerm "circumpolar_A" ;
lin circumscribe_V2 = mkTerm "circumscribe_V2" ;
lin circumscription_N = mkTerm "circumscription_N" ;
lin circumspect_A = mkTerm "circumspect_A" ;
lin circumspection_N = mkTerm "circumspection_N" ;
lin circumstance_N = mkTerm "circumstance_N" ;
lin circumstances_N = mkTerm "circumstances_N" ;
lin circumstantial_A = mkTerm "circumstantial_A" ;
lin circumvent_V2 = mkTerm "circumvent_V2" ;
lin circumvention_N = mkTerm "circumvention_N" ;
lin circumvolution_N = mkTerm "circumvolution_N" ;
lin circus_N = mkTerm "circus_N" ;
lin cirencester_PN = mkTerm "cirencester_PN" ;
lin cirque_N = mkTerm "cirque_N" ;
lin cirrhosis_N = mkTerm "cirrhosis_N" ;
lin cirrocumulus_N = mkTerm "cirrocumulus_N" ;
lin cirrostratus_N = mkTerm "cirrostratus_N" ;
lin cirrus_N = mkTerm "cirrus_N" ;
lin cisalpine_A = mkTerm "cisalpine_A" ;
lin cisco_N = mkTerm "cisco_N" ;
lin cismontane_A = mkTerm "cismontane_A" ;
lin cissy_A = mkTerm "cissy_A" ;
lin cissy_N = mkTerm "cissy_N" ;
lin cistern_N = mkTerm "cistern_N" ;
lin cisterna_N = mkTerm "cisterna_N" ;
lin citadel_N = mkTerm "citadel_N" ;
lin citation_N = mkTerm "citation_N" ;
lin cite_V2 = mkTerm "cite_V2" ;
lin citified_A = mkTerm "citified_A" ;
lin citizenFem_N = mkTerm "citizenFem_N" ;
lin citizenMasc_N = mkTerm "citizenMasc_N" ;
lin citizenry_N = mkTerm "citizenry_N" ;
lin citizenship_N = mkTerm "citizenship_N" ;
lin citrange_N = mkTerm "citrange_N" ;
lin citrate_N = mkTerm "citrate_N" ;
lin citric_A = mkTerm "citric_A" ;
lin citrine_N = mkTerm "citrine_N" ;
lin citron_N = mkTerm "citron_N" ;
lin citronwood_N = mkTerm "citronwood_N" ;
lin citrous_A = mkTerm "citrous_A" ;
lin citrulline_N = mkTerm "citrulline_N" ;
lin citrus_N = mkTerm "citrus_N" ;
lin cittern_N = mkTerm "cittern_N" ;
lin city_N = mkTerm "city_N" ;
lin cityscape_N = mkTerm "cityscape_N" ;
lin citywide_A = mkTerm "citywide_A" ;
lin civet_N = mkTerm "civet_N" ;
lin civet_cat_N = mkTerm "civet_cat_N" ;
lin civic_A = mkTerm "civic_A" ;
lin civics_N = mkTerm "civics_N" ;
lin civies_N = mkTerm "civies_N" ;
lin civil_A = mkTerm "civil_A" ;
lin civilian_A = mkTerm "civilian_A" ;
lin civilian_N = mkTerm "civilian_N" ;
lin civilisation_N = mkTerm "civilisation_N" ;
lin civility_N = mkTerm "civility_N" ;
lin civilization_N = mkTerm "civilization_N" ;
lin civilize_V2 = mkTerm "civilize_V2" ;
lin civvy_street_PN = mkTerm "civvy_street_PN" ;
lin clabber_N = mkTerm "clabber_N" ;
lin clack_N = mkTerm "clack_N" ;
lin clack_V = mkTerm "clack_V" ;
lin clackmannon_PN = mkTerm "clackmannon_PN" ;
lin clacton_PN = mkTerm "clacton_PN" ;
lin clad_V = mkTerm "clad_V" ;
lin clad_V2 = mkTerm "clad_V2" ;
lin clade_N = mkTerm "clade_N" ;
lin cladistics_N = mkTerm "cladistics_N" ;
lin cladode_N = mkTerm "cladode_N" ;
lin cladogram_N = mkTerm "cladogram_N" ;
lin clag_up_V2 = mkTerm "clag_up_V2" ;
lin claim_N = mkTerm "claim_N" ;
lin claim_V = mkTerm "claim_V" ;
lin claim_V2 = mkTerm "claim_V2" ;
lin claim_VS = mkTerm "claim_VS" ;
lin claimant_N = mkTerm "claimant_N" ;
lin clairvoyance_N = mkTerm "clairvoyance_N" ;
lin clairvoyant_A = mkTerm "clairvoyant_A" ;
lin clairvoyant_N = mkTerm "clairvoyant_N" ;
lin clam_N = mkTerm "clam_N" ;
lin clam_V = mkTerm "clam_V" ;
lin clam_up_V = mkTerm "clam_up_V" ;
lin clamant_A = mkTerm "clamant_A" ;
lin clamatorial_A = mkTerm "clamatorial_A" ;
lin clambake_N = mkTerm "clambake_N" ;
lin clamber_N = mkTerm "clamber_N" ;
lin clamber_V = mkTerm "clamber_V" ;
lin clammy_A = mkTerm "clammy_A" ;
lin clammyweed_N = mkTerm "clammyweed_N" ;
lin clamor_N = mkTerm "clamor_N" ;
lin clamorous_A = mkTerm "clamorous_A" ;
lin clamour_N = mkTerm "clamour_N" ;
lin clamour_V = mkTerm "clamour_V" ;
lin clamour_V2 = mkTerm "clamour_V2" ;
lin clamp_N = mkTerm "clamp_N" ;
lin clamp_V = mkTerm "clamp_V" ;
lin clamp_V2 = mkTerm "clamp_V2" ;
lin clamp_down_N = mkTerm "clamp_down_N" ;
lin clamp_down_V = mkTerm "clamp_down_V" ;
lin clamp_down_on_V2 = mkTerm "clamp_down_on_V2" ;
lin clamshell_N = mkTerm "clamshell_N" ;
lin clan_N = mkTerm "clan_N" ;
lin clandestine_A = mkTerm "clandestine_A" ;
lin clang_N = mkTerm "clang_N" ;
lin clang_V = mkTerm "clang_V" ;
lin clang_V2 = mkTerm "clang_V2" ;
lin clanger_N = mkTerm "clanger_N" ;
lin clangorous_A = mkTerm "clangorous_A" ;
lin clangour_N = mkTerm "clangour_N" ;
lin clank_N = mkTerm "clank_N" ;
lin clank_V = mkTerm "clank_V" ;
lin clank_V2 = mkTerm "clank_V2" ;
lin clank_in_V = mkTerm "clank_in_V" ;
lin clannish_A = mkTerm "clannish_A" ;
lin clannishness_N = mkTerm "clannishness_N" ;
lin clansman_N = mkTerm "clansman_N" ;
lin clap_N = mkTerm "clap_N" ;
lin clap_V = mkTerm "clap_V" ;
lin clap_V2 = mkTerm "clap_V2" ;
lin clapboard_N = mkTerm "clapboard_N" ;
lin clapper_N = mkTerm "clapper_N" ;
lin clapperboard_N = mkTerm "clapperboard_N" ;
lin claptrap_N = mkTerm "claptrap_N" ;
lin claque_N = mkTerm "claque_N" ;
lin clare_PN = mkTerm "clare_PN" ;
lin clarence_N = mkTerm "clarence_N" ;
lin claret_N = mkTerm "claret_N" ;
lin clarification_N = mkTerm "clarification_N" ;
lin clarify_V = mkTerm "clarify_V" ;
lin clarify_V2 = mkTerm "clarify_V2" ;
lin clarinet_N = mkTerm "clarinet_N" ;
lin clarinetistFem_N = mkTerm "clarinetistFem_N" ;
lin clarinetistMasc_N = mkTerm "clarinetistMasc_N" ;
lin clarion_A = mkTerm "clarion_A" ;
lin clarion_N = mkTerm "clarion_N" ;
lin clarity_N = mkTerm "clarity_N" ;
lin clarkston_PN = mkTerm "clarkston_PN" ;
lin claro_N = mkTerm "claro_N" ;
lin clarrie_PN = mkTerm "clarrie_PN" ;
lin clary_N = mkTerm "clary_N" ;
lin clash_N = mkTerm "clash_N" ;
lin clash_V = mkTerm "clash_V" ;
lin clash_V2 = mkTerm "clash_V2" ;
lin clasp_N = mkTerm "clasp_N" ;
lin clasp_V = mkTerm "clasp_V" ;
lin clasp_V2 = mkTerm "clasp_V2" ;
lin clasp_knife_N = mkTerm "clasp_knife_N" ;
lin class_N = mkTerm "class_N" ;
lin class_V2 = mkTerm "class_V2" ;
lin class_conscious_A = mkTerm "class_conscious_A" ;
lin class_feeling_N = mkTerm "class_feeling_N" ;
lin class_fellow_N = mkTerm "class_fellow_N" ;
lin class_list_N = mkTerm "class_list_N" ;
lin class_warfare_N = mkTerm "class_warfare_N" ;
lin classic_A = mkTerm "classic_A" ;
lin classic_N = mkTerm "classic_N" ;
lin classical_A = mkTerm "classical_A" ;
lin classicism_N = mkTerm "classicism_N" ;
lin classicist_N = mkTerm "classicist_N" ;
lin classicistic_A = mkTerm "classicistic_A" ;
lin classics_N = mkTerm "classics_N" ;
lin classifiable_A = mkTerm "classifiable_A" ;
lin classification_N = mkTerm "classification_N" ;
lin classificatory_A = mkTerm "classificatory_A" ;
lin classified_A = mkTerm "classified_A" ;
lin classifier_N = mkTerm "classifier_N" ;
lin classify_V2 = mkTerm "classify_V2" ;
lin classless_A = mkTerm "classless_A" ;
lin classmate_N = mkTerm "classmate_N" ;
lin classroom_N = mkTerm "classroom_N" ;
lin classwork_N = mkTerm "classwork_N" ;
lin classy_A = mkTerm "classy_A" ;
lin clast_N = mkTerm "clast_N" ;
lin clastic_A = mkTerm "clastic_A" ;
lin clathrate_A = mkTerm "clathrate_A" ;
lin clatter_N = mkTerm "clatter_N" ;
lin clatter_V = mkTerm "clatter_V" ;
lin clatter_V2 = mkTerm "clatter_V2" ;
lin clattery_A = mkTerm "clattery_A" ;
lin claud_PN = mkTerm "claud_PN" ;
lin claude_PN = mkTerm "claude_PN" ;
lin clausal_A = mkTerm "clausal_A" ;
lin clause_N = mkTerm "clause_N" ;
lin claustrophobe_N = mkTerm "claustrophobe_N" ;
lin claustrophobia_N = mkTerm "claustrophobia_N" ;
lin claustrophobic_A = mkTerm "claustrophobic_A" ;
lin claustrum_N = mkTerm "claustrum_N" ;
lin clavichord_N = mkTerm "clavichord_N" ;
lin clavicle_N = mkTerm "clavicle_N" ;
lin clavier_N = mkTerm "clavier_N" ;
lin claw_N = mkTerm "claw_N" ;
lin claw_V2 = mkTerm "claw_V2" ;
lin claw_back_V2 = mkTerm "claw_back_V2" ;
lin clawback_N = mkTerm "clawback_N" ;
lin clawfoot_N = mkTerm "clawfoot_N" ;
lin clawhammer_N = mkTerm "clawhammer_N" ;
lin clawlike_A = mkTerm "clawlike_A" ;
lin clay_N = mkTerm "clay_N" ;
lin clay_cross_PN = mkTerm "clay_cross_PN" ;
lin clayey_A = mkTerm "clayey_A" ;
lin claymore_N = mkTerm "claymore_N" ;
lin claystone_N = mkTerm "claystone_N" ;
lin clean_A = mkTerm "clean_A" ;
lin clean_N = mkTerm "clean_N" ;
lin clean_V = mkTerm "clean_V" ;
lin clean_V2 = mkTerm "clean_V2" ;
lin clean_bowled_A = mkTerm "clean_bowled_A" ;
lin clean_cut_A = mkTerm "clean_cut_A" ;
lin clean_limbed_A = mkTerm "clean_limbed_A" ;
lin clean_living_A = mkTerm "clean_living_A" ;
lin clean_out_V = mkTerm "clean_out_V" ;
lin clean_out_V2 = mkTerm "clean_out_V2" ;
lin clean_shaven_A = mkTerm "clean_shaven_A" ;
lin clean_up_N = mkTerm "clean_up_N" ;
lin clean_up_V = mkTerm "clean_up_V" ;
lin clean_up_V2 = mkTerm "clean_up_V2" ;
lin cleanable_A = mkTerm "cleanable_A" ;
lin cleaner_N = mkTerm "cleaner_N" ;
lin cleaners_N = mkTerm "cleaners_N" ;
lin cleaning_N = mkTerm "cleaning_N" ;
lin cleanliness_N = mkTerm "cleanliness_N" ;
lin cleanly_A = mkTerm "cleanly_A" ;
lin cleanness_N = mkTerm "cleanness_N" ;
lin cleanse_V2 = mkTerm "cleanse_V2" ;
lin cleanser_N = mkTerm "cleanser_N" ;
lin cleansing_A = mkTerm "cleansing_A" ;
lin clear_A = mkTerm "clear_A" ;
lin clear_Adv = mkTerm "clear_Adv" ;
lin clear_N = mkTerm "clear_N" ;
lin clear_V = mkTerm "clear_V" ;
lin clear_V2 = mkTerm "clear_V2" ;
lin clear_away_V = mkTerm "clear_away_V" ;
lin clear_away_V2 = mkTerm "clear_away_V2" ;
lin clear_cut_Adv = mkTerm "clear_cut_Adv" ;
lin clear_headed_A = mkTerm "clear_headed_A" ;
lin clear_off_V = mkTerm "clear_off_V" ;
lin clear_out_V = mkTerm "clear_out_V" ;
lin clear_out_V2 = mkTerm "clear_out_V2" ;
lin clear_sighted_A = mkTerm "clear_sighted_A" ;
lin clear_up_V = mkTerm "clear_up_V" ;
lin clear_up_V2 = mkTerm "clear_up_V2" ;
lin clearance_N = mkTerm "clearance_N" ;
lin clearing_N = mkTerm "clearing_N" ;
lin clearing_house_N = mkTerm "clearing_house_N" ;
lin clearness_N = mkTerm "clearness_N" ;
lin clearway_N = mkTerm "clearway_N" ;
lin cleat_N = mkTerm "cleat_N" ;
lin cleator_moor_PN = mkTerm "cleator_moor_PN" ;
lin cleats_N = mkTerm "cleats_N" ;
lin cleavable_A = mkTerm "cleavable_A" ;
lin cleavage_N = mkTerm "cleavage_N" ;
lin cleave_V = mkTerm "cleave_V" ;
lin cleave_V2 = mkTerm "cleave_V2" ;
lin cleaver_N = mkTerm "cleaver_N" ;
lin cleavers_N = mkTerm "cleavers_N" ;
lin cleethorpes_PN = mkTerm "cleethorpes_PN" ;
lin clef_N = mkTerm "clef_N" ;
lin cleft_A = mkTerm "cleft_A" ;
lin cleft_N = mkTerm "cleft_N" ;
lin cleistogamous_A = mkTerm "cleistogamous_A" ;
lin cleistogamy_N = mkTerm "cleistogamy_N" ;
lin cleistothecium_N = mkTerm "cleistothecium_N" ;
lin clem_PN = mkTerm "clem_PN" ;
lin clematis_N = mkTerm "clematis_N" ;
lin clemency_N = mkTerm "clemency_N" ;
lin clement_A = mkTerm "clement_A" ;
lin clement_PN = mkTerm "clement_PN" ;
lin clementine_N = mkTerm "clementine_N" ;
lin clench_V2 = mkTerm "clench_V2" ;
lin clerestory_N = mkTerm "clerestory_N" ;
lin clergy_N = mkTerm "clergy_N" ;
lin clergyman_N = mkTerm "clergyman_N" ;
lin cleric_N = mkTerm "cleric_N" ;
lin clerical_A = mkTerm "clerical_A" ;
lin clericalism_N = mkTerm "clericalism_N" ;
lin clericalist_N = mkTerm "clericalist_N" ;
lin clerihew_N = mkTerm "clerihew_N" ;
lin clerk_N = mkTerm "clerk_N" ;
lin clerk_V = mkTerm "clerk_V" ;
lin clerkship_N = mkTerm "clerkship_N" ;
lin clermont_ferrand_PN = mkTerm "clermont_ferrand_PN" ;
lin clevedon_PN = mkTerm "clevedon_PN" ;
lin cleveland_PN = mkTerm "cleveland_PN" ;
lin clever_A = mkTerm "clever_A" ;
lin cleverness_N = mkTerm "cleverness_N" ;
lin clevis_N = mkTerm "clevis_N" ;
lin clew_N = mkTerm "clew_N" ;
lin clew_V2 = mkTerm "clew_V2" ;
lin clews_N = mkTerm "clews_N" ;
lin cliche_N = mkTerm "cliche_N" ;
lin cliched_A = mkTerm "cliched_A" ;
lin click_N = mkTerm "click_N" ;
lin click_V = mkTerm "click_V" ;
lin click_through_V2 = mkTerm "click_through_V2" ;
lin client_N = mkTerm "client_N" ;
lin clientage_N = mkTerm "clientage_N" ;
lin clientele_N = mkTerm "clientele_N" ;
lin cliff_N = mkTerm "cliff_N" ;
lin cliff_PN = mkTerm "cliff_PN" ;
lin cliff_hanger_N = mkTerm "cliff_hanger_N" ;
lin clifford_PN = mkTerm "clifford_PN" ;
lin climacteric_N = mkTerm "climacteric_N" ;
lin climactic_A = mkTerm "climactic_A" ;
lin climate_N = mkTerm "climate_N" ;
lin climatic_A = mkTerm "climatic_A" ;
lin climatologist_N = mkTerm "climatologist_N" ;
lin climatology_N = mkTerm "climatology_N" ;
lin climax_N = mkTerm "climax_N" ;
lin climax_V = mkTerm "climax_V" ;
lin climax_V2 = mkTerm "climax_V2" ;
lin climb_N = mkTerm "climb_N" ;
lin climb_V = mkTerm "climb_V" ;
lin climb_V2 = mkTerm "climb_V2" ;
lin climb_down_N = mkTerm "climb_down_N" ;
lin climb_down_V = mkTerm "climb_down_V" ;
lin climber_N = mkTerm "climber_N" ;
lin clime_N = mkTerm "clime_N" ;
lin clinch_N = mkTerm "clinch_N" ;
lin clinch_V = mkTerm "clinch_V" ;
lin clinch_V2 = mkTerm "clinch_V2" ;
lin clincher_N = mkTerm "clincher_N" ;
lin cling_N = mkTerm "cling_N" ;
lin cling_V = mkTerm "cling_V" ;
lin cling_on_V = mkTerm "cling_on_V" ;
lin cling_on_to_V2 = mkTerm "cling_on_to_V2" ;
lin cling_to_V2 = mkTerm "cling_to_V2" ;
lin clingfish_N = mkTerm "clingfish_N" ;
lin clinic_N = mkTerm "clinic_N" ;
lin clinical_A = mkTerm "clinical_A" ;
lin clinician_N = mkTerm "clinician_N" ;
lin clinid_N = mkTerm "clinid_N" ;
lin clink_N = mkTerm "clink_N" ;
lin clink_V = mkTerm "clink_V" ;
lin clink_V2 = mkTerm "clink_V2" ;
lin clinker_N = mkTerm "clinker_N" ;
lin clinker_built_A = mkTerm "clinker_built_A" ;
lin clinocephaly_N = mkTerm "clinocephaly_N" ;
lin clinodactyly_N = mkTerm "clinodactyly_N" ;
lin clinometer_N = mkTerm "clinometer_N" ;
lin clinquant_A = mkTerm "clinquant_A" ;
lin clintonia_N = mkTerm "clintonia_N" ;
lin clip_N = mkTerm "clip_N" ;
lin clip_V2 = mkTerm "clip_V2" ;
lin clip_joint_N = mkTerm "clip_joint_N" ;
lin clip_on_A = mkTerm "clip_on_A" ;
lin clipboard_N = mkTerm "clipboard_N" ;
lin clipper_N = mkTerm "clipper_N" ;
lin clipping_N = mkTerm "clipping_N" ;
lin clique_N = mkTerm "clique_N" ;
lin cliquish_A = mkTerm "cliquish_A" ;
lin clitheroe_PN = mkTerm "clitheroe_PN" ;
lin clitoral_A = mkTerm "clitoral_A" ;
lin clitoridectomy_N = mkTerm "clitoridectomy_N" ;
lin clitoris_N = mkTerm "clitoris_N" ;
lin clive_PN = mkTerm "clive_PN" ;
lin cloaca_N = mkTerm "cloaca_N" ;
lin cloak_N = mkTerm "cloak_N" ;
lin cloak_V2 = mkTerm "cloak_V2" ;
lin cloakmaker_N = mkTerm "cloakmaker_N" ;
lin cloakroom_N = mkTerm "cloakroom_N" ;
lin clobber_N = mkTerm "clobber_N" ;
lin clobber_V2 = mkTerm "clobber_V2" ;
lin cloche_N = mkTerm "cloche_N" ;
lin clock_N = mkTerm "clock_N" ;
lin clock_V = mkTerm "clock_V" ;
lin clock_V2 = mkTerm "clock_V2" ;
lin clock_dial_N = mkTerm "clock_dial_N" ;
lin clock_face_N = mkTerm "clock_face_N" ;
lin clock_golf_N = mkTerm "clock_golf_N" ;
lin clock_tower_N = mkTerm "clock_tower_N" ;
lin clock_watching_N = mkTerm "clock_watching_N" ;
lin clocking_N = mkTerm "clocking_N" ;
lin clocksmith_N = mkTerm "clocksmith_N" ;
lin clockwise_A = mkTerm "clockwise_A" ;
lin clockwise_Adv = mkTerm "clockwise_Adv" ;
lin clockwork_N = mkTerm "clockwork_N" ;
lin clod_N = mkTerm "clod_N" ;
lin cloddish_A = mkTerm "cloddish_A" ;
lin clodhopper_N = mkTerm "clodhopper_N" ;
lin clofibrate_N = mkTerm "clofibrate_N" ;
lin clog_N = mkTerm "clog_N" ;
lin clog_V = mkTerm "clog_V" ;
lin clog_V2 = mkTerm "clog_V2" ;
lin clog_dance_N = mkTerm "clog_dance_N" ;
lin clog_up_V2 = mkTerm "clog_up_V2" ;
lin cloggy_A = mkTerm "cloggy_A" ;
lin cloisonne_N = mkTerm "cloisonne_N" ;
lin cloister_N = mkTerm "cloister_N" ;
lin cloister_V2 = mkTerm "cloister_V2" ;
lin clomiphene_N = mkTerm "clomiphene_N" ;
lin clomipramine_N = mkTerm "clomipramine_N" ;
lin clonal_A = mkTerm "clonal_A" ;
lin clone_N = mkTerm "clone_N" ;
lin clone_V2 = mkTerm "clone_V2" ;
lin clonic_A = mkTerm "clonic_A" ;
lin clonidine_N = mkTerm "clonidine_N" ;
lin cloning_N = mkTerm "cloning_N" ;
lin clonus_N = mkTerm "clonus_N" ;
lin close_A = mkTerm "close_A" ;
lin close_Adv = mkTerm "close_Adv" ;
lin close_N = mkTerm "close_N" ;
lin close_V = mkTerm "close_V" ;
lin close_V2 = mkTerm "close_V2" ;
lin close_cropped_A = mkTerm "close_cropped_A" ;
lin close_cut_A = mkTerm "close_cut_A" ;
lin close_down_N = mkTerm "close_down_N" ;
lin close_down_V = mkTerm "close_down_V" ;
lin close_down_V2 = mkTerm "close_down_V2" ;
lin close_fisted_A = mkTerm "close_fisted_A" ;
lin close_fitting_A = mkTerm "close_fitting_A" ;
lin close_grained_A = mkTerm "close_grained_A" ;
lin close_hauled_A = mkTerm "close_hauled_A" ;
lin close_in_V = mkTerm "close_in_V" ;
lin close_in_on_V2 = mkTerm "close_in_on_V2" ;
lin close_in_upon_V2 = mkTerm "close_in_upon_V2" ;
lin close_off_V2 = mkTerm "close_off_V2" ;
lin close_on_V2 = mkTerm "close_on_V2" ;
lin close_out_V2 = mkTerm "close_out_V2" ;
lin close_set_A = mkTerm "close_set_A" ;
lin close_to_Prep = mkTerm "close_to_Prep" ;
lin close_up_N = mkTerm "close_up_N" ;
lin close_up_V = mkTerm "close_up_V" ;
lin close_up_V2 = mkTerm "close_up_V2" ;
lin closed_A = mkTerm "closed_A" ;
lin closeness_N = mkTerm "closeness_N" ;
lin closeout_N = mkTerm "closeout_N" ;
lin closer_N = mkTerm "closer_N" ;
lin closet_A = mkTerm "closet_A" ;
lin closet_N = mkTerm "closet_N" ;
lin closet_V2 = mkTerm "closet_V2" ;
lin closing_N = mkTerm "closing_N" ;
lin clostridium_N = mkTerm "clostridium_N" ;
lin closure_N = mkTerm "closure_N" ;
lin clot_N = mkTerm "clot_N" ;
lin clot_V = mkTerm "clot_V" ;
lin clot_V2 = mkTerm "clot_V2" ;
lin cloth_N = mkTerm "cloth_N" ;
lin clothe_V2 = mkTerm "clothe_V2" ;
lin clothes_N = mkTerm "clothes_N" ;
lin clothes_basket_N = mkTerm "clothes_basket_N" ;
lin clothes_hanger_N = mkTerm "clothes_hanger_N" ;
lin clothes_moth_N = mkTerm "clothes_moth_N" ;
lin clothes_peg_N = mkTerm "clothes_peg_N" ;
lin clothes_pin_N = mkTerm "clothes_pin_N" ;
lin clothesbrush_N = mkTerm "clothesbrush_N" ;
lin clotheshorse_N = mkTerm "clotheshorse_N" ;
lin clothesless_A = mkTerm "clothesless_A" ;
lin clothesline_N = mkTerm "clothesline_N" ;
lin clothier_N = mkTerm "clothier_N" ;
lin clothing_N = mkTerm "clothing_N" ;
lin cloud_N = mkTerm "cloud_N" ;
lin cloud_V = mkTerm "cloud_V" ;
lin cloud_V2 = mkTerm "cloud_V2" ;
lin cloud_bank_N = mkTerm "cloud_bank_N" ;
lin cloud_capped_A = mkTerm "cloud_capped_A" ;
lin cloud_cuckoo_land_N = mkTerm "cloud_cuckoo_land_N" ;
lin cloud_over_V = mkTerm "cloud_over_V" ;
lin cloudberry_N = mkTerm "cloudberry_N" ;
lin cloudburst_N = mkTerm "cloudburst_N" ;
lin cloudiness_N = mkTerm "cloudiness_N" ;
lin clouding_N = mkTerm "clouding_N" ;
lin cloudless_A = mkTerm "cloudless_A" ;
lin cloudlessness_N = mkTerm "cloudlessness_N" ;
lin cloudlike_A = mkTerm "cloudlike_A" ;
lin cloudy_A = mkTerm "cloudy_A" ;
lin clout_N = mkTerm "clout_N" ;
lin clout_V2 = mkTerm "clout_V2" ;
lin clove_N = mkTerm "clove_N" ;
lin clove_hitch_N = mkTerm "clove_hitch_N" ;
lin cloven_A = mkTerm "cloven_A" ;
lin clover_N = mkTerm "clover_N" ;
lin cloverleaf_N = mkTerm "cloverleaf_N" ;
lin clowder_N = mkTerm "clowder_N" ;
lin clown_N = mkTerm "clown_N" ;
lin clown_V = mkTerm "clown_V" ;
lin clown_about_V = mkTerm "clown_about_V" ;
lin clown_around_V = mkTerm "clown_around_V" ;
lin clowne_PN = mkTerm "clowne_PN" ;
lin clownish_A = mkTerm "clownish_A" ;
lin cloy_V = mkTerm "cloy_V" ;
lin cloy_V2 = mkTerm "cloy_V2" ;
lin cloyingly_Adv = mkTerm "cloyingly_Adv" ;
lin clozapine_N = mkTerm "clozapine_N" ;
lin cloze_A = mkTerm "cloze_A" ;
lin club_1_N = mkTerm "club_1_N" ;
lin club_2_N = mkTerm "club_2_N" ;
lin club_V = mkTerm "club_V" ;
lin club_V2 = mkTerm "club_V2" ;
lin club_footed_A = mkTerm "club_footed_A" ;
lin clubbable_A = mkTerm "clubbable_A" ;
lin clubbing_N = mkTerm "clubbing_N" ;
lin clubbish_A = mkTerm "clubbish_A" ;
lin clubfoot_N = mkTerm "clubfoot_N" ;
lin clubhouse_N = mkTerm "clubhouse_N" ;
lin clubroom_N = mkTerm "clubroom_N" ;
lin cluck_N = mkTerm "cluck_N" ;
lin cluck_V = mkTerm "cluck_V" ;
lin clue_N = mkTerm "clue_N" ;
lin clueless_A = mkTerm "clueless_A" ;
lin clumber_N = mkTerm "clumber_N" ;
lin clump_N = mkTerm "clump_N" ;
lin clump_V = mkTerm "clump_V" ;
lin clump_V2 = mkTerm "clump_V2" ;
lin clumsiness_N = mkTerm "clumsiness_N" ;
lin clumsy_A = mkTerm "clumsy_A" ;
lin clunch_N = mkTerm "clunch_N" ;
lin clunk_N = mkTerm "clunk_N" ;
lin clunk_V = mkTerm "clunk_V" ;
lin clunky_A = mkTerm "clunky_A" ;
lin clusia_N = mkTerm "clusia_N" ;
lin cluster_N = mkTerm "cluster_N" ;
lin cluster_V = mkTerm "cluster_V" ;
lin cluster_V2 = mkTerm "cluster_V2" ;
lin clutch_N = mkTerm "clutch_N" ;
lin clutch_V = mkTerm "clutch_V" ;
lin clutch_V2 = mkTerm "clutch_V2" ;
lin clutch_on_V = mkTerm "clutch_on_V" ;
lin clutter_N = mkTerm "clutter_N" ;
lin clutter_V2 = mkTerm "clutter_V2" ;
lin clwyd_PN = mkTerm "clwyd_PN" ;
lin clydach_PN = mkTerm "clydach_PN" ;
lin clydebank_PN = mkTerm "clydebank_PN" ;
lin clypeus_N = mkTerm "clypeus_N" ;
lin cm_N = mkTerm "cm_N" ;
lin co_N = mkTerm "co_N" ;
lin co_author_V2 = mkTerm "co_author_V2" ;
lin co_ed_N = mkTerm "co_ed_N" ;
lin co_edit_V2 = mkTerm "co_edit_V2" ;
lin co_exist_V = mkTerm "co_exist_V" ;
lin co_found_V2 = mkTerm "co_found_V2" ;
lin co_manage_V2 = mkTerm "co_manage_V2" ;
lin co_op_N = mkTerm "co_op_N" ;
lin co_opt_V2 = mkTerm "co_opt_V2" ;
lin co_respondent_N = mkTerm "co_respondent_N" ;
lin co_sponsor_V2 = mkTerm "co_sponsor_V2" ;
lin co_star_N = mkTerm "co_star_N" ;
lin co_star_V = mkTerm "co_star_V" ;
lin co_star_V2 = mkTerm "co_star_V2" ;
lin coach_1_N = mkTerm "coach_1_N" ;
lin coach_2_N = mkTerm "coach_2_N" ;
lin coach_3_N = mkTerm "coach_3_N" ;
lin coach_V = mkTerm "coach_V" ;
lin coach_V2 = mkTerm "coach_V2" ;
lin coach_builder_N = mkTerm "coach_builder_N" ;
lin coaching_N = mkTerm "coaching_N" ;
lin coachman_N = mkTerm "coachman_N" ;
lin coachwhip_N = mkTerm "coachwhip_N" ;
lin coadjutor_N = mkTerm "coadjutor_N" ;
lin coagulable_A = mkTerm "coagulable_A" ;
lin coagulant_N = mkTerm "coagulant_N" ;
lin coagulase_N = mkTerm "coagulase_N" ;
lin coagulate_A = mkTerm "coagulate_A" ;
lin coagulate_V = mkTerm "coagulate_V" ;
lin coagulate_V2 = mkTerm "coagulate_V2" ;
lin coagulation_N = mkTerm "coagulation_N" ;
lin coal_N = mkTerm "coal_N" ;
lin coal_V = mkTerm "coal_V" ;
lin coal_V2 = mkTerm "coal_V2" ;
lin coal_gas_N = mkTerm "coal_gas_N" ;
lin coal_hole_N = mkTerm "coal_hole_N" ;
lin coal_house_N = mkTerm "coal_house_N" ;
lin coal_scuttle_N = mkTerm "coal_scuttle_N" ;
lin coal_seam_N = mkTerm "coal_seam_N" ;
lin coal_tar_N = mkTerm "coal_tar_N" ;
lin coalbin_N = mkTerm "coalbin_N" ;
lin coalesce_V = mkTerm "coalesce_V" ;
lin coalescence_N = mkTerm "coalescence_N" ;
lin coalescent_A = mkTerm "coalescent_A" ;
lin coalface_N = mkTerm "coalface_N" ;
lin coalfield_N = mkTerm "coalfield_N" ;
lin coaling_station_N = mkTerm "coaling_station_N" ;
lin coalition_N = mkTerm "coalition_N" ;
lin coalman_N = mkTerm "coalman_N" ;
lin coalmine_N = mkTerm "coalmine_N" ;
lin coalpit_N = mkTerm "coalpit_N" ;
lin coalville_PN = mkTerm "coalville_PN" ;
lin coaming_N = mkTerm "coaming_N" ;
lin coarctate_A = mkTerm "coarctate_A" ;
lin coarctation_N = mkTerm "coarctation_N" ;
lin coarse_A = mkTerm "coarse_A" ;
lin coarsen_V = mkTerm "coarsen_V" ;
lin coarsen_V2 = mkTerm "coarsen_V2" ;
lin coarseness_N = mkTerm "coarseness_N" ;
lin coast_N = mkTerm "coast_N" ;
lin coast_V = mkTerm "coast_V" ;
lin coast_V2 = mkTerm "coast_V2" ;
lin coast_along_V = mkTerm "coast_along_V" ;
lin coastal_A = mkTerm "coastal_A" ;
lin coaster_N = mkTerm "coaster_N" ;
lin coastguard_N = mkTerm "coastguard_N" ;
lin coastguardsman_N = mkTerm "coastguardsman_N" ;
lin coastland_N = mkTerm "coastland_N" ;
lin coastline_N = mkTerm "coastline_N" ;
lin coastward_Adv = mkTerm "coastward_Adv" ;
lin coastwise_A = mkTerm "coastwise_A" ;
lin coastwise_Adv = mkTerm "coastwise_Adv" ;
lin coat_N = mkTerm "coat_N" ;
lin coat_V2 = mkTerm "coat_V2" ;
lin coat_hanger_N = mkTerm "coat_hanger_N" ;
lin coatbridge_PN = mkTerm "coatbridge_PN" ;
lin coatdress_N = mkTerm "coatdress_N" ;
lin coatee_N = mkTerm "coatee_N" ;
lin coati_N = mkTerm "coati_N" ;
lin coating_N = mkTerm "coating_N" ;
lin coatrack_N = mkTerm "coatrack_N" ;
lin coattail_N = mkTerm "coattail_N" ;
lin coauthorFem_N = mkTerm "coauthorFem_N" ;
lin coauthorMasc_N = mkTerm "coauthorMasc_N" ;
lin coax_V = mkTerm "coax_V" ;
lin coax_V2 = mkTerm "coax_V2" ;
lin coaxial_A = mkTerm "coaxial_A" ;
lin coaxing_N = mkTerm "coaxing_N" ;
lin coaxingly_Adv = mkTerm "coaxingly_Adv" ;
lin cob_N = mkTerm "cob_N" ;
lin cob_nut_N = mkTerm "cob_nut_N" ;
lin cobalt_N = mkTerm "cobalt_N" ;
lin cobaltite_N = mkTerm "cobaltite_N" ;
lin cobber_N = mkTerm "cobber_N" ;
lin cobble_N = mkTerm "cobble_N" ;
lin cobble_V2 = mkTerm "cobble_V2" ;
lin cobble_together_V2 = mkTerm "cobble_together_V2" ;
lin cobbler_N = mkTerm "cobbler_N" ;
lin cobblers_N = mkTerm "cobblers_N" ;
lin cobblestone_N = mkTerm "cobblestone_N" ;
lin cobham_PN = mkTerm "cobham_PN" ;
lin cobia_N = mkTerm "cobia_N" ;
lin cobra_N = mkTerm "cobra_N" ;
lin cobweb_N = mkTerm "cobweb_N" ;
lin cobwebby_A = mkTerm "cobwebby_A" ;
lin coca_N = mkTerm "coca_N" ;
lin coca_cola_N = mkTerm "coca_cola_N" ;
lin cocaine_N = mkTerm "cocaine_N" ;
lin cocarboxylase_N = mkTerm "cocarboxylase_N" ;
lin coccal_A = mkTerm "coccal_A" ;
lin coccidioidomycosis_N = mkTerm "coccidioidomycosis_N" ;
lin coccidiosis_N = mkTerm "coccidiosis_N" ;
lin coccidium_N = mkTerm "coccidium_N" ;
lin coccobacillus_N = mkTerm "coccobacillus_N" ;
lin coccoid_A = mkTerm "coccoid_A" ;
lin coccus_N = mkTerm "coccus_N" ;
lin coccygeal_A = mkTerm "coccygeal_A" ;
lin coccyx_N = mkTerm "coccyx_N" ;
lin cochin_N = mkTerm "cochin_N" ;
lin cochineal_N = mkTerm "cochineal_N" ;
lin cochlea_N = mkTerm "cochlea_N" ;
lin cochlear_A = mkTerm "cochlear_A" ;
lin cock_N = mkTerm "cock_N" ;
lin cock_V2 = mkTerm "cock_V2" ;
lin cock_a_doodle_doo_N = mkTerm "cock_a_doodle_doo_N" ;
lin cock_a_hoop_A = mkTerm "cock_a_hoop_A" ;
lin cock_a_hoop_Adv = mkTerm "cock_a_hoop_Adv" ;
lin cock_crow_N = mkTerm "cock_crow_N" ;
lin cock_up_V2 = mkTerm "cock_up_V2" ;
lin cockade_N = mkTerm "cockade_N" ;
lin cockamamie_A = mkTerm "cockamamie_A" ;
lin cockateel_N = mkTerm "cockateel_N" ;
lin cockatoo_N = mkTerm "cockatoo_N" ;
lin cockatrice_N = mkTerm "cockatrice_N" ;
lin cockchafer_N = mkTerm "cockchafer_N" ;
lin cocker_N = mkTerm "cocker_N" ;
lin cockerel_N = mkTerm "cockerel_N" ;
lin cockermouth_PN = mkTerm "cockermouth_PN" ;
lin cockeyed_A = mkTerm "cockeyed_A" ;
lin cockfight_N = mkTerm "cockfight_N" ;
lin cockfighting_N = mkTerm "cockfighting_N" ;
lin cockhorse_N = mkTerm "cockhorse_N" ;
lin cockle_N = mkTerm "cockle_N" ;
lin cocklebur_N = mkTerm "cocklebur_N" ;
lin cockleshell_N = mkTerm "cockleshell_N" ;
lin cockloft_N = mkTerm "cockloft_N" ;
lin cockney_A = mkTerm "cockney_A" ;
lin cockney_N = mkTerm "cockney_N" ;
lin cockpit_N = mkTerm "cockpit_N" ;
lin cockroach_N = mkTerm "cockroach_N" ;
lin cockscomb_N = mkTerm "cockscomb_N" ;
lin cockspur_N = mkTerm "cockspur_N" ;
lin cocksucker_N = mkTerm "cocksucker_N" ;
lin cocksure_A = mkTerm "cocksure_A" ;
lin cocktail_N = mkTerm "cocktail_N" ;
lin cockup_N = mkTerm "cockup_N" ;
lin cocky_A = mkTerm "cocky_A" ;
lin coco_N = mkTerm "coco_N" ;
lin cocoa_N = mkTerm "cocoa_N" ;
lin cocobolo_N = mkTerm "cocobolo_N" ;
lin coconut_N = mkTerm "coconut_N" ;
lin cocoon_N = mkTerm "cocoon_N" ;
lin cocoon_V2 = mkTerm "cocoon_V2" ;
lin cocooning_N = mkTerm "cocooning_N" ;
lin cocotte_N = mkTerm "cocotte_N" ;
lin cocozelle_N = mkTerm "cocozelle_N" ;
lin cocuswood_N = mkTerm "cocuswood_N" ;
lin cod_N = mkTerm "cod_N" ;
lin cod_PN = mkTerm "cod_PN" ;
lin cod_V = mkTerm "cod_V" ;
lin cod_V2 = mkTerm "cod_V2" ;
lin cod_liver_oil_N = mkTerm "cod_liver_oil_N" ;
lin coda_N = mkTerm "coda_N" ;
lin coddle_V2 = mkTerm "coddle_V2" ;
lin code_N = mkTerm "code_N" ;
lin code_V2 = mkTerm "code_V2" ;
lin codefendant_N = mkTerm "codefendant_N" ;
lin codeine_N = mkTerm "codeine_N" ;
lin codetalker_N = mkTerm "codetalker_N" ;
lin codex_N = mkTerm "codex_N" ;
lin codfish_N = mkTerm "codfish_N" ;
lin codger_N = mkTerm "codger_N" ;
lin codicil_N = mkTerm "codicil_N" ;
lin codification_N = mkTerm "codification_N" ;
lin codify_V2 = mkTerm "codify_V2" ;
lin codling_N = mkTerm "codling_N" ;
lin codon_N = mkTerm "codon_N" ;
lin codpiece_N = mkTerm "codpiece_N" ;
lin codsall_PN = mkTerm "codsall_PN" ;
lin coeducation_N = mkTerm "coeducation_N" ;
lin coeducational_A = mkTerm "coeducational_A" ;
lin coefficient_N = mkTerm "coefficient_N" ;
lin coelacanth_N = mkTerm "coelacanth_N" ;
lin coelenterate_N = mkTerm "coelenterate_N" ;
lin coelenteron_N = mkTerm "coelenteron_N" ;
lin coeliac_A = mkTerm "coeliac_A" ;
lin coelogyne_N = mkTerm "coelogyne_N" ;
lin coelophysis_N = mkTerm "coelophysis_N" ;
lin coelostat_N = mkTerm "coelostat_N" ;
lin coenzyme_N = mkTerm "coenzyme_N" ;
lin coequal_A = mkTerm "coequal_A" ;
lin coerce_V2 = mkTerm "coerce_V2" ;
lin coercion_N = mkTerm "coercion_N" ;
lin coercive_A = mkTerm "coercive_A" ;
lin coetaneous_A = mkTerm "coetaneous_A" ;
lin coeval_A = mkTerm "coeval_A" ;
lin coeval_N = mkTerm "coeval_N" ;
lin coexistence_N = mkTerm "coexistence_N" ;
lin coexistent_A = mkTerm "coexistent_A" ;
lin coextension_N = mkTerm "coextension_N" ;
lin coextensive_A = mkTerm "coextensive_A" ;
lin coextrude_V2 = mkTerm "coextrude_V2" ;
lin cofactor_N = mkTerm "cofactor_N" ;
lin coffee_N = mkTerm "coffee_N" ;
lin coffee_house_N = mkTerm "coffee_house_N" ;
lin coffee_mill_N = mkTerm "coffee_mill_N" ;
lin coffee_stall_N = mkTerm "coffee_stall_N" ;
lin coffeeberry_N = mkTerm "coffeeberry_N" ;
lin coffeecake_N = mkTerm "coffeecake_N" ;
lin coffeepot_N = mkTerm "coffeepot_N" ;
lin coffer_N = mkTerm "coffer_N" ;
lin coffer_dam_N = mkTerm "coffer_dam_N" ;
lin coffin_N = mkTerm "coffin_N" ;
lin cofounder_N = mkTerm "cofounder_N" ;
lin cog_N = mkTerm "cog_N" ;
lin cogency_N = mkTerm "cogency_N" ;
lin cogent_A = mkTerm "cogent_A" ;
lin cogged_A = mkTerm "cogged_A" ;
lin cogitable_A = mkTerm "cogitable_A" ;
lin cogitate_V = mkTerm "cogitate_V" ;
lin cogitate_V2 = mkTerm "cogitate_V2" ;
lin cogitation_N = mkTerm "cogitation_N" ;
lin cogitative_A = mkTerm "cogitative_A" ;
lin cognac_N = mkTerm "cognac_N" ;
lin cognate_A = mkTerm "cognate_A" ;
lin cognate_N = mkTerm "cognate_N" ;
lin cognition_N = mkTerm "cognition_N" ;
lin cognitive_A = mkTerm "cognitive_A" ;
lin cognizance_N = mkTerm "cognizance_N" ;
lin cognizant_A = mkTerm "cognizant_A" ;
lin cognomen_N = mkTerm "cognomen_N" ;
lin cogwheel_N = mkTerm "cogwheel_N" ;
lin cohabit_V = mkTerm "cohabit_V" ;
lin cohabitation_N = mkTerm "cohabitation_N" ;
lin cohere_V = mkTerm "cohere_V" ;
lin coherence_N = mkTerm "coherence_N" ;
lin coherency_N = mkTerm "coherency_N" ;
lin coherent_A = mkTerm "coherent_A" ;
lin cohesion_N = mkTerm "cohesion_N" ;
lin cohesive_A = mkTerm "cohesive_A" ;
lin cohesiveness_N = mkTerm "cohesiveness_N" ;
lin coho_N = mkTerm "coho_N" ;
lin cohomology_N = mkTerm "cohomology_N" ;
lin cohort_N = mkTerm "cohort_N" ;
lin coif_N = mkTerm "coif_N" ;
lin coiffeur_N = mkTerm "coiffeur_N" ;
lin coiffeuse_N = mkTerm "coiffeuse_N" ;
lin coiffure_N = mkTerm "coiffure_N" ;
lin coign_N = mkTerm "coign_N" ;
lin coil_N = mkTerm "coil_N" ;
lin coil_V = mkTerm "coil_V" ;
lin coil_V2 = mkTerm "coil_V2" ;
lin coimbatore_PN = mkTerm "coimbatore_PN" ;
lin coin_N = mkTerm "coin_N" ;
lin coin_V2 = mkTerm "coin_V2" ;
lin coinage_N = mkTerm "coinage_N" ;
lin coincide_V = mkTerm "coincide_V" ;
lin coincidence_N = mkTerm "coincidence_N" ;
lin coincident_A = mkTerm "coincident_A" ;
lin coincidental_A = mkTerm "coincidental_A" ;
lin coiner_N = mkTerm "coiner_N" ;
lin coinsurance_N = mkTerm "coinsurance_N" ;
lin coir_N = mkTerm "coir_N" ;
lin coital_A = mkTerm "coital_A" ;
lin coition_N = mkTerm "coition_N" ;
lin coitus_N = mkTerm "coitus_N" ;
lin coke_N = mkTerm "coke_N" ;
lin coke_V2 = mkTerm "coke_V2" ;
lin col_N = mkTerm "col_N" ;
lin col_PN = mkTerm "col_PN" ;
lin cola_N = mkTerm "cola_N" ;
lin colander_N = mkTerm "colander_N" ;
lin colchester_PN = mkTerm "colchester_PN" ;
lin colchicine_N = mkTerm "colchicine_N" ;
lin cold_A = mkTerm "cold_A" ;
lin cold_N = mkTerm "cold_N" ;
lin cold_blooded_A = mkTerm "cold_blooded_A" ;
lin cold_hearted_A = mkTerm "cold_hearted_A" ;
lin cold_shoulder_V2 = mkTerm "cold_shoulder_V2" ;
lin coldness_N = mkTerm "coldness_N" ;
lin coleshill_PN = mkTerm "coleshill_PN" ;
lin coleslaw_N = mkTerm "coleslaw_N" ;
lin coleus_N = mkTerm "coleus_N" ;
lin colic_N = mkTerm "colic_N" ;
lin colicky_A = mkTerm "colicky_A" ;
lin colicroot_N = mkTerm "colicroot_N" ;
lin colin_N = mkTerm "colin_N" ;
lin colin_PN = mkTerm "colin_PN" ;
lin coliphage_N = mkTerm "coliphage_N" ;
lin colitis_N = mkTerm "colitis_N" ;
lin coll_PN = mkTerm "coll_PN" ;
lin collaborate_V = mkTerm "collaborate_V" ;
lin collaboration_N = mkTerm "collaboration_N" ;
lin collaborationist_N = mkTerm "collaborationist_N" ;
lin collaborative_A = mkTerm "collaborative_A" ;
lin collaborator_N = mkTerm "collaborator_N" ;
lin collage_N = mkTerm "collage_N" ;
lin collagen_N = mkTerm "collagen_N" ;
lin collagenase_N = mkTerm "collagenase_N" ;
lin collagenous_A = mkTerm "collagenous_A" ;
lin collapsable_A = mkTerm "collapsable_A" ;
lin collapse_N = mkTerm "collapse_N" ;
lin collapse_V = mkTerm "collapse_V" ;
lin collapse_V2 = mkTerm "collapse_V2" ;
lin collapsible_A = mkTerm "collapsible_A" ;
lin collar_N = mkTerm "collar_N" ;
lin collar_V2 = mkTerm "collar_V2" ;
lin collarbone_N = mkTerm "collarbone_N" ;
lin collard_N = mkTerm "collard_N" ;
lin collards_N = mkTerm "collards_N" ;
lin collarless_A = mkTerm "collarless_A" ;
lin collate_V2 = mkTerm "collate_V2" ;
lin collateral_A = mkTerm "collateral_A" ;
lin collateral_N = mkTerm "collateral_N" ;
lin collation_N = mkTerm "collation_N" ;
lin colleague_N = mkTerm "colleague_N" ;
lin collect_A = mkTerm "collect_A" ;
lin collect_Adv = mkTerm "collect_Adv" ;
lin collect_N = mkTerm "collect_N" ;
lin collect_V = mkTerm "collect_V" ;
lin collect_V2 = mkTerm "collect_V2" ;
lin collectedly_Adv = mkTerm "collectedly_Adv" ;
lin collectible_A = mkTerm "collectible_A" ;
lin collectible_N = mkTerm "collectible_N" ;
lin collection_N = mkTerm "collection_N" ;
lin collective_A = mkTerm "collective_A" ;
lin collective_N = mkTerm "collective_N" ;
lin collectivism_N = mkTerm "collectivism_N" ;
lin collectivist_A = mkTerm "collectivist_A" ;
lin collectivist_N = mkTerm "collectivist_N" ;
lin collectivization_N = mkTerm "collectivization_N" ;
lin collectivize_V2 = mkTerm "collectivize_V2" ;
lin collector_N = mkTerm "collector_N" ;
lin colleen_N = mkTerm "colleen_N" ;
lin college_N = mkTerm "college_N" ;
lin collegial_A = mkTerm "collegial_A" ;
lin collegian_N = mkTerm "collegian_N" ;
lin collegiate_A = mkTerm "collegiate_A" ;
lin collembolan_N = mkTerm "collembolan_N" ;
lin collet_N = mkTerm "collet_N" ;
lin collide_V = mkTerm "collide_V" ;
lin collider_N = mkTerm "collider_N" ;
lin collie_N = mkTerm "collie_N" ;
lin collier_N = mkTerm "collier_N" ;
lin colliery_N = mkTerm "colliery_N" ;
lin colligation_N = mkTerm "colligation_N" ;
lin collimation_N = mkTerm "collimation_N" ;
lin collimator_N = mkTerm "collimator_N" ;
lin collinear_A = mkTerm "collinear_A" ;
lin collins_N = mkTerm "collins_N" ;
lin collision_N = mkTerm "collision_N" ;
lin collocate_V = mkTerm "collocate_V" ;
lin collocation_N = mkTerm "collocation_N" ;
lin collodion_N = mkTerm "collodion_N" ;
lin colloid_N = mkTerm "colloid_N" ;
lin colloidal_A = mkTerm "colloidal_A" ;
lin colloquial_A = mkTerm "colloquial_A" ;
lin colloquialism_N = mkTerm "colloquialism_N" ;
lin colloquium_N = mkTerm "colloquium_N" ;
lin colloquy_N = mkTerm "colloquy_N" ;
lin collotype_N = mkTerm "collotype_N" ;
lin collusion_N = mkTerm "collusion_N" ;
lin collusive_A = mkTerm "collusive_A" ;
lin colne_PN = mkTerm "colne_PN" ;
lin colobus_N = mkTerm "colobus_N" ;
lin cologne_N = mkTerm "cologne_N" ;
lin cologne_PN = mkTerm "cologne_PN" ;
lin colombia_PN = mkTerm "colombia_PN" ;
lin colombian_A = mkTerm "colombian_A" ;
lin colombian_N = mkTerm "colombian_N" ;
lin colombo_PN = mkTerm "colombo_PN" ;
lin colon_N = mkTerm "colon_N" ;
lin colonel_N = mkTerm "colonel_N" ;
lin colonial_A = mkTerm "colonial_A" ;
lin colonial_N = mkTerm "colonial_N" ;
lin colonialism_N = mkTerm "colonialism_N" ;
lin colonialist_N = mkTerm "colonialist_N" ;
lin colonic_A = mkTerm "colonic_A" ;
lin colonist_N = mkTerm "colonist_N" ;
lin colonization_N = mkTerm "colonization_N" ;
lin colonize_V2 = mkTerm "colonize_V2" ;
lin colonizer_N = mkTerm "colonizer_N" ;
lin colonnade_N = mkTerm "colonnade_N" ;
lin colonnaded_A = mkTerm "colonnaded_A" ;
lin colonoscope_N = mkTerm "colonoscope_N" ;
lin colonoscopy_N = mkTerm "colonoscopy_N" ;
lin colony_N = mkTerm "colony_N" ;
lin colophon_N = mkTerm "colophon_N" ;
lin colophony_N = mkTerm "colophony_N" ;
lin colorado_PN = mkTerm "colorado_PN" ;
lin coloration_N = mkTerm "coloration_N" ;
lin coloratura_N = mkTerm "coloratura_N" ;
lin colorcast_N = mkTerm "colorcast_N" ;
lin colorectal_A = mkTerm "colorectal_A" ;
lin colorfast_A = mkTerm "colorfast_A" ;
lin colorimeter_N = mkTerm "colorimeter_N" ;
lin colorimetric_A = mkTerm "colorimetric_A" ;
lin colorimetry_N = mkTerm "colorimetry_N" ;
lin colorist_N = mkTerm "colorist_N" ;
lin colorlessness_N = mkTerm "colorlessness_N" ;
lin colossal_A = mkTerm "colossal_A" ;
lin colossus_N = mkTerm "colossus_N" ;
lin colostomy_N = mkTerm "colostomy_N" ;
lin colostrum_N = mkTerm "colostrum_N" ;
lin colour_A = mkTerm "colour_A" ;
lin colour_N = mkTerm "colour_N" ;
lin colour_V = mkTerm "colour_V" ;
lin colour_V2 = mkTerm "colour_V2" ;
lin colour_V2A = mkTerm "colour_V2A" ;
lin colour_bar_N = mkTerm "colour_bar_N" ;
lin colour_blind_A = mkTerm "colour_blind_A" ;
lin colour_code_V2 = mkTerm "colour_code_V2" ;
lin colour_up_V = mkTerm "colour_up_V" ;
lin colour_wash_N = mkTerm "colour_wash_N" ;
lin coloured_A = mkTerm "coloured_A" ;
lin colourful_A = mkTerm "colourful_A" ;
lin colouring_N = mkTerm "colouring_N" ;
lin colourless_A = mkTerm "colourless_A" ;
lin colpitis_N = mkTerm "colpitis_N" ;
lin colpocele_N = mkTerm "colpocele_N" ;
lin colpocystitis_N = mkTerm "colpocystitis_N" ;
lin colpoxerosis_N = mkTerm "colpoxerosis_N" ;
lin colspan_N = mkTerm "colspan_N" ;
lin colt_N = mkTerm "colt_N" ;
lin colter_N = mkTerm "colter_N" ;
lin coltish_A = mkTerm "coltish_A" ;
lin coltsfoot_N = mkTerm "coltsfoot_N" ;
lin columbarium_N = mkTerm "columbarium_N" ;
lin columbia_PN = mkTerm "columbia_PN" ;
lin columbine_N = mkTerm "columbine_N" ;
lin columbium_N = mkTerm "columbium_N" ;
lin columbo_N = mkTerm "columbo_N" ;
lin columbus_PN = mkTerm "columbus_PN" ;
lin columella_N = mkTerm "columella_N" ;
lin column_N = mkTerm "column_N" ;
lin columnar_A = mkTerm "columnar_A" ;
lin columnea_N = mkTerm "columnea_N" ;
lin columned_A = mkTerm "columned_A" ;
lin columniation_N = mkTerm "columniation_N" ;
lin columniform_A = mkTerm "columniform_A" ;
lin columnistFem_N = mkTerm "columnistFem_N" ;
lin columnistMasc_N = mkTerm "columnistMasc_N" ;
lin colwyn_bay_PN = mkTerm "colwyn_bay_PN" ;
lin coma_N = mkTerm "coma_N" ;
lin comate_A = mkTerm "comate_A" ;
lin comatose_A = mkTerm "comatose_A" ;
lin comb_N = mkTerm "comb_N" ;
lin comb_V = mkTerm "comb_V" ;
lin comb_V2 = mkTerm "comb_V2" ;
lin comb_out_N = mkTerm "comb_out_N" ;
lin combat_N = mkTerm "combat_N" ;
lin combat_V = mkTerm "combat_V" ;
lin combat_V2 = mkTerm "combat_V2" ;
lin combatant_A = mkTerm "combatant_A" ;
lin combatant_N = mkTerm "combatant_N" ;
lin combative_A = mkTerm "combative_A" ;
lin combativeness_N = mkTerm "combativeness_N" ;
lin comber_N = mkTerm "comber_N" ;
lin combinable_A = mkTerm "combinable_A" ;
lin combination_N = mkTerm "combination_N" ;
lin combination_lock_N = mkTerm "combination_lock_N" ;
lin combinative_A = mkTerm "combinative_A" ;
lin combinatorial_A = mkTerm "combinatorial_A" ;
lin combine_N = mkTerm "combine_N" ;
lin combine_V = mkTerm "combine_V" ;
lin combine_V2 = mkTerm "combine_V2" ;
lin combine_VV = mkTerm "combine_VV" ;
lin combined_A = mkTerm "combined_A" ;
lin combining_N = mkTerm "combining_N" ;
lin combo_N = mkTerm "combo_N" ;
lin combretum_N = mkTerm "combretum_N" ;
lin comburent_A = mkTerm "comburent_A" ;
lin combustibility_N = mkTerm "combustibility_N" ;
lin combustible_A = mkTerm "combustible_A" ;
lin combustible_N = mkTerm "combustible_N" ;
lin combustion_N = mkTerm "combustion_N" ;
lin come_V = mkTerm "come_V" ;
lin come_about_V = mkTerm "come_about_V" ;
lin come_across_V = mkTerm "come_across_V" ;
lin come_across_V2 = mkTerm "come_across_V2" ;
lin come_along_V = mkTerm "come_along_V" ;
lin come_along_with_V2 = mkTerm "come_along_with_V2" ;
lin come_apart_V = mkTerm "come_apart_V" ;
lin come_around_V = mkTerm "come_around_V" ;
lin come_around_to_V2 = mkTerm "come_around_to_V2" ;
lin come_at_able_A = mkTerm "come_at_able_A" ;
lin come_away_V = mkTerm "come_away_V" ;
lin come_back_V = mkTerm "come_back_V" ;
lin come_before_V2 = mkTerm "come_before_V2" ;
lin come_by_V = mkTerm "come_by_V" ;
lin come_by_V2 = mkTerm "come_by_V2" ;
lin come_down_V = mkTerm "come_down_V" ;
lin come_down_on_V2 = mkTerm "come_down_on_V2" ;
lin come_down_upon_V2 = mkTerm "come_down_upon_V2" ;
lin come_down_with_V2 = mkTerm "come_down_with_V2" ;
lin come_forth_V = mkTerm "come_forth_V" ;
lin come_forth_with_V2 = mkTerm "come_forth_with_V2" ;
lin come_forward_V = mkTerm "come_forward_V" ;
lin come_from_V2 = mkTerm "come_from_V2" ;
lin come_in_V = mkTerm "come_in_V" ;
lin come_in_V2 = mkTerm "come_in_V2" ;
lin come_in_for_V2 = mkTerm "come_in_for_V2" ;
lin come_into_V2 = mkTerm "come_into_V2" ;
lin come_into_use_V = mkTerm "come_into_use_V" ;
lin come_off_V = mkTerm "come_off_V" ;
lin come_off_V2 = mkTerm "come_off_V2" ;
lin come_off_it_V = mkTerm "come_off_it_V" ;
lin come_on_N = mkTerm "come_on_N" ;
lin come_on_V = mkTerm "come_on_V" ;
lin come_out_V = mkTerm "come_out_V" ;
lin come_out_in_V2 = mkTerm "come_out_in_V2" ;
lin come_out_of_V2 = mkTerm "come_out_of_V2" ;
lin come_out_with_V2 = mkTerm "come_out_with_V2" ;
lin come_over_V = mkTerm "come_over_V" ;
lin come_over_V2 = mkTerm "come_over_V2" ;
lin come_round_V = mkTerm "come_round_V" ;
lin come_through_V = mkTerm "come_through_V" ;
lin come_through_with_V2 = mkTerm "come_through_with_V2" ;
lin come_to_V = mkTerm "come_to_V" ;
lin come_to_V2 = mkTerm "come_to_V2" ;
lin come_up_V = mkTerm "come_up_V" ;
lin come_up_against_V2 = mkTerm "come_up_against_V2" ;
lin come_up_to_V2 = mkTerm "come_up_to_V2" ;
lin come_up_with_V2 = mkTerm "come_up_with_V2" ;
lin come_upon_V2 = mkTerm "come_upon_V2" ;
lin come_with_V2 = mkTerm "come_with_V2" ;
lin comeback_N = mkTerm "comeback_N" ;
lin comedian_N = mkTerm "comedian_N" ;
lin comedic_A = mkTerm "comedic_A" ;
lin comedienne_N = mkTerm "comedienne_N" ;
lin comedown_N = mkTerm "comedown_N" ;
lin comedy_N = mkTerm "comedy_N" ;
lin comeliness_N = mkTerm "comeliness_N" ;
lin comely_A = mkTerm "comely_A" ;
lin comer_N = mkTerm "comer_N" ;
lin comestible_N = mkTerm "comestible_N" ;
lin comet_N = mkTerm "comet_N" ;
lin cometary_A = mkTerm "cometary_A" ;
lin comfit_N = mkTerm "comfit_N" ;
lin comfort_N = mkTerm "comfort_N" ;
lin comfort_V2 = mkTerm "comfort_V2" ;
lin comfortable_A = mkTerm "comfortable_A" ;
lin comfortableness_N = mkTerm "comfortableness_N" ;
lin comforter_N = mkTerm "comforter_N" ;
lin comforting_A = mkTerm "comforting_A" ;
lin comfortless_A = mkTerm "comfortless_A" ;
lin comfrey_N = mkTerm "comfrey_N" ;
lin comfy_A = mkTerm "comfy_A" ;
lin comic_A = mkTerm "comic_A" ;
lin comic_N = mkTerm "comic_N" ;
lin comical_A = mkTerm "comical_A" ;
lin comicality_N = mkTerm "comicality_N" ;
lin coming_A = mkTerm "coming_A" ;
lin coming_N = mkTerm "coming_N" ;
lin comity_N = mkTerm "comity_N" ;
lin comma_N = mkTerm "comma_N" ;
lin command_1_N = mkTerm "command_1_N" ;
lin command_2_N = mkTerm "command_2_N" ;
lin command_V = mkTerm "command_V" ;
lin command_V2 = mkTerm "command_V2" ;
lin commandant_N = mkTerm "commandant_N" ;
lin commandeer_V2 = mkTerm "commandeer_V2" ;
lin commander_N = mkTerm "commander_N" ;
lin commandership_N = mkTerm "commandership_N" ;
lin commandment_N = mkTerm "commandment_N" ;
lin commando_N = mkTerm "commando_N" ;
lin commelina_N = mkTerm "commelina_N" ;
lin commemorate_V2 = mkTerm "commemorate_V2" ;
lin commemoration_N = mkTerm "commemoration_N" ;
lin commemorative_A = mkTerm "commemorative_A" ;
lin commemorative_N = mkTerm "commemorative_N" ;
lin commence_V = mkTerm "commence_V" ;
lin commence_V2 = mkTerm "commence_V2" ;
lin commencement_N = mkTerm "commencement_N" ;
lin commend_V2 = mkTerm "commend_V2" ;
lin commendable_A = mkTerm "commendable_A" ;
lin commendation_N = mkTerm "commendation_N" ;
lin commensal_A = mkTerm "commensal_A" ;
lin commensal_N = mkTerm "commensal_N" ;
lin commensalism_N = mkTerm "commensalism_N" ;
lin commensurable_A = mkTerm "commensurable_A" ;
lin commensurate_A = mkTerm "commensurate_A" ;
lin commensurateness_N = mkTerm "commensurateness_N" ;
lin comment_N = mkTerm "comment_N" ;
lin comment_V = mkTerm "comment_V" ;
lin comment_V2 = mkTerm "comment_V2" ;
lin comment_VS = mkTerm "comment_VS" ;
lin commentary_N = mkTerm "commentary_N" ;
lin commentate_V = mkTerm "commentate_V" ;
lin commentator_N = mkTerm "commentator_N" ;
lin commerce_N = mkTerm "commerce_N" ;
lin commercial_A = mkTerm "commercial_A" ;
lin commercial_N = mkTerm "commercial_N" ;
lin commercialism_N = mkTerm "commercialism_N" ;
lin commercialization_N = mkTerm "commercialization_N" ;
lin commercialize_V2 = mkTerm "commercialize_V2" ;
lin commination_N = mkTerm "commination_N" ;
lin comminatory_A = mkTerm "comminatory_A" ;
lin commingle_V = mkTerm "commingle_V" ;
lin commingle_V2 = mkTerm "commingle_V2" ;
lin commiserate_V = mkTerm "commiserate_V" ;
lin commiseration_N = mkTerm "commiseration_N" ;
lin commiserative_A = mkTerm "commiserative_A" ;
lin commissar_N = mkTerm "commissar_N" ;
lin commissariat_N = mkTerm "commissariat_N" ;
lin commissary_N = mkTerm "commissary_N" ;
lin commission_N = mkTerm "commission_N" ;
lin commission_V2 = mkTerm "commission_V2" ;
lin commission_V2V = mkTerm "commission_V2V" ;
lin commissionaire_N = mkTerm "commissionaire_N" ;
lin commissioner_N = mkTerm "commissioner_N" ;
lin commissure_N = mkTerm "commissure_N" ;
lin commit_V2 = mkTerm "commit_V2" ;
lin commital_N = mkTerm "commital_N" ;
lin commitment_N = mkTerm "commitment_N" ;
lin committed_A = mkTerm "committed_A" ;
lin committedness_N = mkTerm "committedness_N" ;
lin committee_N = mkTerm "committee_N" ;
lin committeeman_N = mkTerm "committeeman_N" ;
lin committeewoman_N = mkTerm "committeewoman_N" ;
lin commode_1_N = mkTerm "commode_1_N" ;
lin commode_2_N = mkTerm "commode_2_N" ;
lin commodious_A = mkTerm "commodious_A" ;
lin commodity_N = mkTerm "commodity_N" ;
lin commodore_N = mkTerm "commodore_N" ;
lin common_1_A = mkTerm "common_1_A" ;
lin common_2_A = mkTerm "common_2_A" ;
lin common_N = mkTerm "common_N" ;
lin common_room_N = mkTerm "common_room_N" ;
lin commonage_N = mkTerm "commonage_N" ;
lin commonality_N = mkTerm "commonality_N" ;
lin commonalty_N = mkTerm "commonalty_N" ;
lin commoner_N = mkTerm "commoner_N" ;
lin commonness_N = mkTerm "commonness_N" ;
lin commonplace_A = mkTerm "commonplace_A" ;
lin commonplace_N = mkTerm "commonplace_N" ;
lin commons_N = mkTerm "commons_N" ;
lin commonsense_A = mkTerm "commonsense_A" ;
lin commonwealth_N = mkTerm "commonwealth_N" ;
lin commotion_N = mkTerm "commotion_N" ;
lin communal_A = mkTerm "communal_A" ;
lin communalism_N = mkTerm "communalism_N" ;
lin commune_N = mkTerm "commune_N" ;
lin commune_V = mkTerm "commune_V" ;
lin communicable_A = mkTerm "communicable_A" ;
lin communicant_N = mkTerm "communicant_N" ;
lin communicate_V = mkTerm "communicate_V" ;
lin communicate_V2 = mkTerm "communicate_V2" ;
lin communication_N = mkTerm "communication_N" ;
lin communicational_A = mkTerm "communicational_A" ;
lin communications_N = mkTerm "communications_N" ;
lin communicative_A = mkTerm "communicative_A" ;
lin communicativeness_N = mkTerm "communicativeness_N" ;
lin communicator_N = mkTerm "communicator_N" ;
lin communion_N = mkTerm "communion_N" ;
lin communique_N = mkTerm "communique_N" ;
lin communism_N = mkTerm "communism_N" ;
lin communist_A = mkTerm "communist_A" ;
lin communist_N = mkTerm "communist_N" ;
lin community_N = mkTerm "community_N" ;
lin communization_N = mkTerm "communization_N" ;
lin commutability_N = mkTerm "commutability_N" ;
lin commutable_A = mkTerm "commutable_A" ;
lin commutation_N = mkTerm "commutation_N" ;
lin commutative_A = mkTerm "commutative_A" ;
lin commutator_N = mkTerm "commutator_N" ;
lin commute_N = mkTerm "commute_N" ;
lin commute_V = mkTerm "commute_V" ;
lin commute_V2 = mkTerm "commute_V2" ;
lin commuter_N = mkTerm "commuter_N" ;
lin compact_A = mkTerm "compact_A" ;
lin compact_N = mkTerm "compact_N" ;
lin compact_V2 = mkTerm "compact_V2" ;
lin compaction_N = mkTerm "compaction_N" ;
lin compactness_N = mkTerm "compactness_N" ;
lin companion_N = mkTerm "companion_N" ;
lin companionability_N = mkTerm "companionability_N" ;
lin companionable_A = mkTerm "companionable_A" ;
lin companionate_A = mkTerm "companionate_A" ;
lin companionship_N = mkTerm "companionship_N" ;
lin companionway_N = mkTerm "companionway_N" ;
lin company_1_N = mkTerm "company_1_N" ;
lin company_2_N = mkTerm "company_2_N" ;
lin comparability_N = mkTerm "comparability_N" ;
lin comparable_A = mkTerm "comparable_A" ;
lin comparative_A = mkTerm "comparative_A" ;
lin comparative_N = mkTerm "comparative_N" ;
lin compare_N = mkTerm "compare_N" ;
lin compare_V = mkTerm "compare_V" ;
lin comparison_N = mkTerm "comparison_N" ;
lin compartment_N = mkTerm "compartment_N" ;
lin compartmental_A = mkTerm "compartmental_A" ;
lin compartmentalization_N = mkTerm "compartmentalization_N" ;
lin compartmentalize_V2 = mkTerm "compartmentalize_V2" ;
lin compartmented_A = mkTerm "compartmented_A" ;
lin compass_N = mkTerm "compass_N" ;
lin compass_V2 = mkTerm "compass_V2" ;
lin compassion_N = mkTerm "compassion_N" ;
lin compassionate_A = mkTerm "compassionate_A" ;
lin compatibility_N = mkTerm "compatibility_N" ;
lin compatible_A = mkTerm "compatible_A" ;
lin compatible_N = mkTerm "compatible_N" ;
lin compatriotFem_N = mkTerm "compatriotFem_N" ;
lin compatriotMasc_N = mkTerm "compatriotMasc_N" ;
lin compeer_N = mkTerm "compeer_N" ;
lin compel_V2 = mkTerm "compel_V2" ;
lin compel_V2V = mkTerm "compel_V2V" ;
lin compel_VV = mkTerm "compel_VV" ;
lin compelling_A = mkTerm "compelling_A" ;
lin compendious_A = mkTerm "compendious_A" ;
lin compendium_N = mkTerm "compendium_N" ;
lin compensable_A = mkTerm "compensable_A" ;
lin compensate_V = mkTerm "compensate_V" ;
lin compensate_V2 = mkTerm "compensate_V2" ;
lin compensation_N = mkTerm "compensation_N" ;
lin compensatory_A = mkTerm "compensatory_A" ;
lin compere_N = mkTerm "compere_N" ;
lin compere_V2 = mkTerm "compere_V2" ;
lin compete_V = mkTerm "compete_V" ;
lin competence_N = mkTerm "competence_N" ;
lin competent_A = mkTerm "competent_A" ;
lin competition_N = mkTerm "competition_N" ;
lin competitive_A = mkTerm "competitive_A" ;
lin competitiveness_N = mkTerm "competitiveness_N" ;
lin competitor_N = mkTerm "competitor_N" ;
lin compilation_N = mkTerm "compilation_N" ;
lin compile_V2 = mkTerm "compile_V2" ;
lin compiler_N = mkTerm "compiler_N" ;
lin complacence_N = mkTerm "complacence_N" ;
lin complacency_N = mkTerm "complacency_N" ;
lin complacent_A = mkTerm "complacent_A" ;
lin complain_V = mkTerm "complain_V" ;
lin complain_VS = mkTerm "complain_VS" ;
lin complainant_N = mkTerm "complainant_N" ;
lin complainingly_Adv = mkTerm "complainingly_Adv" ;
lin complaint_N = mkTerm "complaint_N" ;
lin complaisance_N = mkTerm "complaisance_N" ;
lin complaisant_A = mkTerm "complaisant_A" ;
lin complement_N = mkTerm "complement_N" ;
lin complement_V2 = mkTerm "complement_V2" ;
lin complemental_A = mkTerm "complemental_A" ;
lin complementarity_N = mkTerm "complementarity_N" ;
lin complementary_A = mkTerm "complementary_A" ;
lin complementation_N = mkTerm "complementation_N" ;
lin complete_A = mkTerm "complete_A" ;
lin complete_V = mkTerm "complete_V" ;
lin complete_V2 = mkTerm "complete_V2" ;
lin completeness_N = mkTerm "completeness_N" ;
lin completion_N = mkTerm "completion_N" ;
lin complex_A = mkTerm "complex_A" ;
lin complex_N = mkTerm "complex_N" ;
lin complexifier_N = mkTerm "complexifier_N" ;
lin complexion_N = mkTerm "complexion_N" ;
lin complexity_N = mkTerm "complexity_N" ;
lin compliance_N = mkTerm "compliance_N" ;
lin compliant_A = mkTerm "compliant_A" ;
lin complicate_V2 = mkTerm "complicate_V2" ;
lin complicated_A = mkTerm "complicated_A" ;
lin complicatedness_N = mkTerm "complicatedness_N" ;
lin complication_N = mkTerm "complication_N" ;
lin complicity_N = mkTerm "complicity_N" ;
lin compliment_N = mkTerm "compliment_N" ;
lin compliment_V2 = mkTerm "compliment_V2" ;
lin complimentary_A = mkTerm "complimentary_A" ;
lin complin_N = mkTerm "complin_N" ;
lin compline_N = mkTerm "compline_N" ;
lin comply_V = mkTerm "comply_V" ;
lin comply_V2 = mkTerm "comply_V2" ;
lin component_A = mkTerm "component_A" ;
lin component_N = mkTerm "component_N" ;
lin comport_V = mkTerm "comport_V" ;
lin comport_V2 = mkTerm "comport_V2" ;
lin comportment_N = mkTerm "comportment_N" ;
lin compos_mentis_A = mkTerm "compos_mentis_A" ;
lin compose_V = mkTerm "compose_V" ;
lin compose_V2 = mkTerm "compose_V2" ;
lin composer_N = mkTerm "composer_N" ;
lin composing_N = mkTerm "composing_N" ;
lin composite_A = mkTerm "composite_A" ;
lin composite_N = mkTerm "composite_N" ;
lin compositeness_N = mkTerm "compositeness_N" ;
lin composition_N = mkTerm "composition_N" ;
lin compositional_A = mkTerm "compositional_A" ;
lin compositor_N = mkTerm "compositor_N" ;
lin compost_N = mkTerm "compost_N" ;
lin compost_V2 = mkTerm "compost_V2" ;
lin composure_N = mkTerm "composure_N" ;
lin compote_N = mkTerm "compote_N" ;
lin compound_A = mkTerm "compound_A" ;
lin compound_N = mkTerm "compound_N" ;
lin compound_V = mkTerm "compound_V" ;
lin compound_V2 = mkTerm "compound_V2" ;
lin comprehend_V2 = mkTerm "comprehend_V2" ;
lin comprehensibility_N = mkTerm "comprehensibility_N" ;
lin comprehensible_A = mkTerm "comprehensible_A" ;
lin comprehension_N = mkTerm "comprehension_N" ;
lin comprehensive_A = mkTerm "comprehensive_A" ;
lin comprehensiveness_N = mkTerm "comprehensiveness_N" ;
lin compress_N = mkTerm "compress_N" ;
lin compress_V2 = mkTerm "compress_V2" ;
lin compressibility_N = mkTerm "compressibility_N" ;
lin compressible_A = mkTerm "compressible_A" ;
lin compression_N = mkTerm "compression_N" ;
lin compressor_N = mkTerm "compressor_N" ;
lin comprise_V2 = mkTerm "comprise_V2" ;
lin compromise_N = mkTerm "compromise_N" ;
lin compromise_V = mkTerm "compromise_V" ;
lin compromise_V2 = mkTerm "compromise_V2" ;
lin compromiser_N = mkTerm "compromiser_N" ;
lin compsognathus_N = mkTerm "compsognathus_N" ;
lin comptroller_N = mkTerm "comptroller_N" ;
lin comptrollership_N = mkTerm "comptrollership_N" ;
lin compulsion_N = mkTerm "compulsion_N" ;
lin compulsive_A = mkTerm "compulsive_A" ;
lin compulsive_N = mkTerm "compulsive_N" ;
lin compulsiveness_N = mkTerm "compulsiveness_N" ;
lin compulsory_A = mkTerm "compulsory_A" ;
lin compunction_N = mkTerm "compunction_N" ;
lin computable_A = mkTerm "computable_A" ;
lin computation_N = mkTerm "computation_N" ;
lin computational_A = mkTerm "computational_A" ;
lin compute_V = mkTerm "compute_V" ;
lin compute_V2 = mkTerm "compute_V2" ;
lin computer_N = mkTerm "computer_N" ;
lin computer_science_N = mkTerm "computer_science_N" ;
lin computerization_N = mkTerm "computerization_N" ;
lin computerize_V2 = mkTerm "computerize_V2" ;
lin computing_N = mkTerm "computing_N" ;
lin comrade_N = mkTerm "comrade_N" ;
lin comradely_A = mkTerm "comradely_A" ;
lin comradely_Adv = mkTerm "comradely_Adv" ;
lin comradeship_N = mkTerm "comradeship_N" ;
lin comune_A = mkTerm "comune_A" ;
lin con_Adv = mkTerm "con_Adv" ;
lin con_N = mkTerm "con_N" ;
lin con_V2 = mkTerm "con_V2" ;
lin con_man_N = mkTerm "con_man_N" ;
lin conacaste_N = mkTerm "conacaste_N" ;
lin concatenation_N = mkTerm "concatenation_N" ;
lin concave_A = mkTerm "concave_A" ;
lin concavity_N = mkTerm "concavity_N" ;
lin conceal_V2 = mkTerm "conceal_V2" ;
lin conceale_V = mkTerm "conceale_V" ;
lin concealment_N = mkTerm "concealment_N" ;
lin concede_V = mkTerm "concede_V" ;
lin concede_V2 = mkTerm "concede_V2" ;
lin concede_VS = mkTerm "concede_VS" ;
lin conceit_N = mkTerm "conceit_N" ;
lin conceited_A = mkTerm "conceited_A" ;
lin conceivable_A = mkTerm "conceivable_A" ;
lin conceivableness_N = mkTerm "conceivableness_N" ;
lin conceive_V = mkTerm "conceive_V" ;
lin conceive_V2 = mkTerm "conceive_V2" ;
lin concentrate_N = mkTerm "concentrate_N" ;
lin concentrate_V = mkTerm "concentrate_V" ;
lin concentrate_V2 = mkTerm "concentrate_V2" ;
lin concentrated_A = mkTerm "concentrated_A" ;
lin concentration_N = mkTerm "concentration_N" ;
lin concentric_A = mkTerm "concentric_A" ;
lin concentricity_N = mkTerm "concentricity_N" ;
lin concept_N = mkTerm "concept_N" ;
lin conception_N = mkTerm "conception_N" ;
lin conceptional_A = mkTerm "conceptional_A" ;
lin conceptive_A = mkTerm "conceptive_A" ;
lin conceptual_A = mkTerm "conceptual_A" ;
lin conceptualism_N = mkTerm "conceptualism_N" ;
lin conceptualistic_A = mkTerm "conceptualistic_A" ;
lin conceptualization_N = mkTerm "conceptualization_N" ;
lin concern_N = mkTerm "concern_N" ;
lin concern_V2 = mkTerm "concern_V2" ;
lin concerned_A = mkTerm "concerned_A" ;
lin concerning_Prep = mkTerm "concerning_Prep" ;
lin concert_N = mkTerm "concert_N" ;
lin concert_V2 = mkTerm "concert_V2" ;
lin concert_hall_N = mkTerm "concert_hall_N" ;
lin concertina_N = mkTerm "concertina_N" ;
lin concerto_N = mkTerm "concerto_N" ;
lin concession_N = mkTerm "concession_N" ;
lin concessionaire_N = mkTerm "concessionaire_N" ;
lin concessive_A = mkTerm "concessive_A" ;
lin conch_N = mkTerm "conch_N" ;
lin concha_N = mkTerm "concha_N" ;
lin conchfish_N = mkTerm "conchfish_N" ;
lin conchologist_N = mkTerm "conchologist_N" ;
lin conchology_N = mkTerm "conchology_N" ;
lin concierge_N = mkTerm "concierge_N" ;
lin conciliate_V2 = mkTerm "conciliate_V2" ;
lin conciliation_N = mkTerm "conciliation_N" ;
lin conciliator_N = mkTerm "conciliator_N" ;
lin conciliatory_A = mkTerm "conciliatory_A" ;
lin concise_A = mkTerm "concise_A" ;
lin conciseness_N = mkTerm "conciseness_N" ;
lin conclave_N = mkTerm "conclave_N" ;
lin conclude_V = mkTerm "conclude_V" ;
lin conclude_V2 = mkTerm "conclude_V2" ;
lin conclude_VS = mkTerm "conclude_VS" ;
lin conclusion_N = mkTerm "conclusion_N" ;
lin conclusive_A = mkTerm "conclusive_A" ;
lin concoct_V2 = mkTerm "concoct_V2" ;
lin concoction_N = mkTerm "concoction_N" ;
lin concomitance_N = mkTerm "concomitance_N" ;
lin concomitant_A = mkTerm "concomitant_A" ;
lin concomitant_N = mkTerm "concomitant_N" ;
lin concord_N = mkTerm "concord_N" ;
lin concordance_N = mkTerm "concordance_N" ;
lin concordant_A = mkTerm "concordant_A" ;
lin concordat_N = mkTerm "concordat_N" ;
lin concourse_N = mkTerm "concourse_N" ;
lin concrete_A = mkTerm "concrete_A" ;
lin concrete_N = mkTerm "concrete_N" ;
lin concrete_V = mkTerm "concrete_V" ;
lin concrete_V2 = mkTerm "concrete_V2" ;
lin concreteness_N = mkTerm "concreteness_N" ;
lin concretion_N = mkTerm "concretion_N" ;
lin concretism_N = mkTerm "concretism_N" ;
lin concretistic_A = mkTerm "concretistic_A" ;
lin concubinage_N = mkTerm "concubinage_N" ;
lin concubine_N = mkTerm "concubine_N" ;
lin concupiscence_N = mkTerm "concupiscence_N" ;
lin concur_V = mkTerm "concur_V" ;
lin concurrence_N = mkTerm "concurrence_N" ;
lin concurrent_A = mkTerm "concurrent_A" ;
lin concurrentness_N = mkTerm "concurrentness_N" ;
lin concuss_V2 = mkTerm "concuss_V2" ;
lin concussion_N = mkTerm "concussion_N" ;
lin condemn_V2 = mkTerm "condemn_V2" ;
lin condemnable_A = mkTerm "condemnable_A" ;
lin condemnation_N = mkTerm "condemnation_N" ;
lin condemnatory_A = mkTerm "condemnatory_A" ;
lin condensate_N = mkTerm "condensate_N" ;
lin condensation_N = mkTerm "condensation_N" ;
lin condense_V = mkTerm "condense_V" ;
lin condense_V2 = mkTerm "condense_V2" ;
lin condenser_N = mkTerm "condenser_N" ;
lin condensing_N = mkTerm "condensing_N" ;
lin condescend_V = mkTerm "condescend_V" ;
lin condescendingly_Adv = mkTerm "condescendingly_Adv" ;
lin condescension_N = mkTerm "condescension_N" ;
lin condign_A = mkTerm "condign_A" ;
lin condiment_N = mkTerm "condiment_N" ;
lin condition_1_N = mkTerm "condition_1_N" ;
lin condition_2_N = mkTerm "condition_2_N" ;
lin condition_V2 = mkTerm "condition_V2" ;
lin conditional_A = mkTerm "conditional_A" ;
lin conditionality_N = mkTerm "conditionality_N" ;
lin conditioner_N = mkTerm "conditioner_N" ;
lin conditioning_N = mkTerm "conditioning_N" ;
lin conditions_N = mkTerm "conditions_N" ;
lin condole_V = mkTerm "condole_V" ;
lin condolence_N = mkTerm "condolence_N" ;
lin condolent_A = mkTerm "condolent_A" ;
lin condom_N = mkTerm "condom_N" ;
lin condominium_N = mkTerm "condominium_N" ;
lin condonation_N = mkTerm "condonation_N" ;
lin condone_V2 = mkTerm "condone_V2" ;
lin condor_N = mkTerm "condor_N" ;
lin conduce_V = mkTerm "conduce_V" ;
lin conducive_A = mkTerm "conducive_A" ;
lin conduct_N = mkTerm "conduct_N" ;
lin conduct_V = mkTerm "conduct_V" ;
lin conduct_V2 = mkTerm "conduct_V2" ;
lin conductance_N = mkTerm "conductance_N" ;
lin conducting_N = mkTerm "conducting_N" ;
lin conduction_N = mkTerm "conduction_N" ;
lin conductive_A = mkTerm "conductive_A" ;
lin conductivity_N = mkTerm "conductivity_N" ;
lin conductor_N = mkTerm "conductor_N" ;
lin conductress_N = mkTerm "conductress_N" ;
lin conduit_N = mkTerm "conduit_N" ;
lin condylar_A = mkTerm "condylar_A" ;
lin condyle_N = mkTerm "condyle_N" ;
lin condylion_N = mkTerm "condylion_N" ;
lin cone_N = mkTerm "cone_N" ;
lin cone_V2 = mkTerm "cone_V2" ;
lin coneflower_N = mkTerm "coneflower_N" ;
lin conenose_N = mkTerm "conenose_N" ;
lin coney_N = mkTerm "coney_N" ;
lin confab_N = mkTerm "confab_N" ;
lin confab_V = mkTerm "confab_V" ;
lin confabulate_V = mkTerm "confabulate_V" ;
lin confabulation_N = mkTerm "confabulation_N" ;
lin confection_N = mkTerm "confection_N" ;
lin confectioner_N = mkTerm "confectioner_N" ;
lin confectionery_N = mkTerm "confectionery_N" ;
lin confederacy_N = mkTerm "confederacy_N" ;
lin confederate_A = mkTerm "confederate_A" ;
lin confederate_N = mkTerm "confederate_N" ;
lin confederate_V = mkTerm "confederate_V" ;
lin confederate_V2 = mkTerm "confederate_V2" ;
lin confederation_N = mkTerm "confederation_N" ;
lin confer_V = mkTerm "confer_V" ;
lin conferee_N = mkTerm "conferee_N" ;
lin conference_N = mkTerm "conference_N" ;
lin conferment_N = mkTerm "conferment_N" ;
lin conferrer_N = mkTerm "conferrer_N" ;
lin conferva_N = mkTerm "conferva_N" ;
lin confess_V = mkTerm "confess_V" ;
lin confess_V2 = mkTerm "confess_V2" ;
lin confess_VS = mkTerm "confess_VS" ;
lin confessedly_Adv = mkTerm "confessedly_Adv" ;
lin confession_N = mkTerm "confession_N" ;
lin confessional_N = mkTerm "confessional_N" ;
lin confessor_N = mkTerm "confessor_N" ;
lin confetti_N = mkTerm "confetti_N" ;
lin confidantFem_N = mkTerm "confidantFem_N" ;
lin confidantMasc_N = mkTerm "confidantMasc_N" ;
lin confidante_N = mkTerm "confidante_N" ;
lin confide_V = mkTerm "confide_V" ;
lin confide_V2 = mkTerm "confide_V2" ;
lin confide_VS = mkTerm "confide_VS" ;
lin confidence_N = mkTerm "confidence_N" ;
lin confident_A = mkTerm "confident_A" ;
lin confidential_A = mkTerm "confidential_A" ;
lin confidentiality_N = mkTerm "confidentiality_N" ;
lin configuration_N = mkTerm "configuration_N" ;
lin configurational_A = mkTerm "configurational_A" ;
lin configure_V2 = mkTerm "configure_V2" ;
lin confine_N = mkTerm "confine_N" ;
lin confine_V2 = mkTerm "confine_V2" ;
lin confinement_N = mkTerm "confinement_N" ;
lin confining_A = mkTerm "confining_A" ;
lin confirm_V2 = mkTerm "confirm_V2" ;
lin confirm_VS = mkTerm "confirm_VS" ;
lin confirmable_A = mkTerm "confirmable_A" ;
lin confirmation_N = mkTerm "confirmation_N" ;
lin confiscate_A = mkTerm "confiscate_A" ;
lin confiscate_V2 = mkTerm "confiscate_V2" ;
lin confiscation_N = mkTerm "confiscation_N" ;
lin confit_N = mkTerm "confit_N" ;
lin confiture_N = mkTerm "confiture_N" ;
lin conflagration_N = mkTerm "conflagration_N" ;
lin conflict_N = mkTerm "conflict_N" ;
lin conflict_V = mkTerm "conflict_V" ;
lin confluence_N = mkTerm "confluence_N" ;
lin confluent_A = mkTerm "confluent_A" ;
lin conform_V = mkTerm "conform_V" ;
lin conform_V2 = mkTerm "conform_V2" ;
lin conformable_A = mkTerm "conformable_A" ;
lin conformation_N = mkTerm "conformation_N" ;
lin conformist_A = mkTerm "conformist_A" ;
lin conformist_N = mkTerm "conformist_N" ;
lin conformity_N = mkTerm "conformity_N" ;
lin confound_V2 = mkTerm "confound_V2" ;
lin confounding_A = mkTerm "confounding_A" ;
lin confrere_N = mkTerm "confrere_N" ;
lin confront_V2 = mkTerm "confront_V2" ;
lin confrontation_N = mkTerm "confrontation_N" ;
lin confrontational_A = mkTerm "confrontational_A" ;
lin confucian_A = mkTerm "confucian_A" ;
lin confucian_N = mkTerm "confucian_N" ;
lin confusable_A = mkTerm "confusable_A" ;
lin confuse_V2 = mkTerm "confuse_V2" ;
lin confused_A = mkTerm "confused_A" ;
lin confusing_A = mkTerm "confusing_A" ;
lin confusion_N = mkTerm "confusion_N" ;
lin confutation_N = mkTerm "confutation_N" ;
lin confute_V2 = mkTerm "confute_V2" ;
lin conga_N = mkTerm "conga_N" ;
lin conge_N = mkTerm "conge_N" ;
lin congeal_V = mkTerm "congeal_V" ;
lin congeal_V2 = mkTerm "congeal_V2" ;
lin congealment_N = mkTerm "congealment_N" ;
lin congee_N = mkTerm "congee_N" ;
lin congener_N = mkTerm "congener_N" ;
lin congeneric_A = mkTerm "congeneric_A" ;
lin congenial_A = mkTerm "congenial_A" ;
lin congeniality_N = mkTerm "congeniality_N" ;
lin congenialness_N = mkTerm "congenialness_N" ;
lin congenital_A = mkTerm "congenital_A" ;
lin conger_N = mkTerm "conger_N" ;
lin conger_eel_N = mkTerm "conger_eel_N" ;
lin congested_A = mkTerm "congested_A" ;
lin congestion_N = mkTerm "congestion_N" ;
lin congestive_A = mkTerm "congestive_A" ;
lin congleton_PN = mkTerm "congleton_PN" ;
lin conglomerate_A = mkTerm "conglomerate_A" ;
lin conglomerate_N = mkTerm "conglomerate_N" ;
lin conglomerate_V = mkTerm "conglomerate_V" ;
lin conglomerate_V2 = mkTerm "conglomerate_V2" ;
lin conglomeration_N = mkTerm "conglomeration_N" ;
lin congo_PN = mkTerm "congo_PN" ;
lin congolese_A = mkTerm "congolese_A" ;
lin congolese_N = mkTerm "congolese_N" ;
lin congou_N = mkTerm "congou_N" ;
lin congratulate_V2 = mkTerm "congratulate_V2" ;
lin congratulation_N = mkTerm "congratulation_N" ;
lin congratulatory_A = mkTerm "congratulatory_A" ;
lin congregant_N = mkTerm "congregant_N" ;
lin congregate_V = mkTerm "congregate_V" ;
lin congregate_V2 = mkTerm "congregate_V2" ;
lin congregation_N = mkTerm "congregation_N" ;
lin congregational_A = mkTerm "congregational_A" ;
lin congress_N = mkTerm "congress_N" ;
lin congressional_A = mkTerm "congressional_A" ;
lin congressman_N = mkTerm "congressman_N" ;
lin congresswoman_N = mkTerm "congresswoman_N" ;
lin congruent_A = mkTerm "congruent_A" ;
lin congruity_N = mkTerm "congruity_N" ;
lin congruous_A = mkTerm "congruous_A" ;
lin conic_A = mkTerm "conic_A" ;
lin conical_A = mkTerm "conical_A" ;
lin conidiophore_N = mkTerm "conidiophore_N" ;
lin conidium_N = mkTerm "conidium_N" ;
lin conifer_N = mkTerm "conifer_N" ;
lin coniferous_A = mkTerm "coniferous_A" ;
lin conima_N = mkTerm "conima_N" ;
lin conjectural_A = mkTerm "conjectural_A" ;
lin conjecture_N = mkTerm "conjecture_N" ;
lin conjecture_V = mkTerm "conjecture_V" ;
lin conjecture_V2 = mkTerm "conjecture_V2" ;
lin conjoin_V = mkTerm "conjoin_V" ;
lin conjoin_V2 = mkTerm "conjoin_V2" ;
lin conjoint_A = mkTerm "conjoint_A" ;
lin conjugal_A = mkTerm "conjugal_A" ;
lin conjugate_A = mkTerm "conjugate_A" ;
lin conjugate_V = mkTerm "conjugate_V" ;
lin conjugate_V2 = mkTerm "conjugate_V2" ;
lin conjugation_N = mkTerm "conjugation_N" ;
lin conjunct_A = mkTerm "conjunct_A" ;
lin conjunction_N = mkTerm "conjunction_N" ;
lin conjunctiva_N = mkTerm "conjunctiva_N" ;
lin conjunctival_A = mkTerm "conjunctival_A" ;
lin conjunctive_A = mkTerm "conjunctive_A" ;
lin conjunctive_N = mkTerm "conjunctive_N" ;
lin conjunctivitis_N = mkTerm "conjunctivitis_N" ;
lin conjuncture_N = mkTerm "conjuncture_N" ;
lin conjuration_N = mkTerm "conjuration_N" ;
lin conjure_V = mkTerm "conjure_V" ;
lin conjure_V2 = mkTerm "conjure_V2" ;
lin conjure_up_V2 = mkTerm "conjure_up_V2" ;
lin conjurer_N = mkTerm "conjurer_N" ;
lin conjuring_N = mkTerm "conjuring_N" ;
lin conjuror_N = mkTerm "conjuror_N" ;
lin conk_N = mkTerm "conk_N" ;
lin conk_V = mkTerm "conk_V" ;
lin conk_out_V = mkTerm "conk_out_V" ;
lin conker_N = mkTerm "conker_N" ;
lin connah's_quay_PN = mkTerm "connah's_quay_PN" ;
lin connate_A = mkTerm "connate_A" ;
lin connatural_A = mkTerm "connatural_A" ;
lin connaught_PN = mkTerm "connaught_PN" ;
lin connect_V = mkTerm "connect_V" ;
lin connect_V2 = mkTerm "connect_V2" ;
lin connected_A = mkTerm "connected_A" ;
lin connecticut_PN = mkTerm "connecticut_PN" ;
lin connection_N = mkTerm "connection_N" ;
lin connective_A = mkTerm "connective_A" ;
lin connective_N = mkTerm "connective_N" ;
lin connectivity_N = mkTerm "connectivity_N" ;
lin connector_N = mkTerm "connector_N" ;
lin connexion_N = mkTerm "connexion_N" ;
lin connie_PN = mkTerm "connie_PN" ;
lin conning_A = mkTerm "conning_A" ;
lin connivance_N = mkTerm "connivance_N" ;
lin connive_V = mkTerm "connive_V" ;
lin connoisseur_N = mkTerm "connoisseur_N" ;
lin connotation_N = mkTerm "connotation_N" ;
lin connotational_A = mkTerm "connotational_A" ;
lin connotative_A = mkTerm "connotative_A" ;
lin connote_V2 = mkTerm "connote_V2" ;
lin connubial_A = mkTerm "connubial_A" ;
lin conodont_N = mkTerm "conodont_N" ;
lin conquer_V2 = mkTerm "conquer_V2" ;
lin conquerable_A = mkTerm "conquerable_A" ;
lin conqueror_N = mkTerm "conqueror_N" ;
lin conquest_N = mkTerm "conquest_N" ;
lin conquistador_N = mkTerm "conquistador_N" ;
lin cons_PN = mkTerm "cons_PN" ;
lin consanguinity_N = mkTerm "consanguinity_N" ;
lin conscience_N = mkTerm "conscience_N" ;
lin conscience_smitten_A = mkTerm "conscience_smitten_A" ;
lin conscienceless_A = mkTerm "conscienceless_A" ;
lin conscientious_A = mkTerm "conscientious_A" ;
lin conscientiousness_N = mkTerm "conscientiousness_N" ;
lin conscionable_A = mkTerm "conscionable_A" ;
lin conscious_A = mkTerm "conscious_A" ;
lin consciousness_N = mkTerm "consciousness_N" ;
lin conscript_N = mkTerm "conscript_N" ;
lin conscript_V2 = mkTerm "conscript_V2" ;
lin conscription_N = mkTerm "conscription_N" ;
lin consecrate_V2 = mkTerm "consecrate_V2" ;
lin consecration_N = mkTerm "consecration_N" ;
lin consecutive_A = mkTerm "consecutive_A" ;
lin consecutive_Adv = mkTerm "consecutive_Adv" ;
lin consensual_A = mkTerm "consensual_A" ;
lin consensus_N = mkTerm "consensus_N" ;
lin consent_N = mkTerm "consent_N" ;
lin consent_V = mkTerm "consent_V" ;
lin consent_V2V = mkTerm "consent_V2V" ;
lin consentaneous_A = mkTerm "consentaneous_A" ;
lin consequence_N = mkTerm "consequence_N" ;
lin consequent_A = mkTerm "consequent_A" ;
lin consequential_A = mkTerm "consequential_A" ;
lin conservancy_N = mkTerm "conservancy_N" ;
lin conservation_N = mkTerm "conservation_N" ;
lin conservatism_N = mkTerm "conservatism_N" ;
lin conservative_1_N = mkTerm "conservative_1_N" ;
lin conservative_2_N = mkTerm "conservative_2_N" ;
lin conservative_A = mkTerm "conservative_A" ;
lin conservatoire_N = mkTerm "conservatoire_N" ;
lin conservator_N = mkTerm "conservator_N" ;
lin conservatory_N = mkTerm "conservatory_N" ;
lin conserve_N = mkTerm "conserve_N" ;
lin conserve_V2 = mkTerm "conserve_V2" ;
lin consett_PN = mkTerm "consett_PN" ;
lin consider_V = mkTerm "consider_V" ;
lin consider_V2 = mkTerm "consider_V2" ;
lin consider_V2A = mkTerm "consider_V2A" ;
lin consider_V2V = mkTerm "consider_V2V" ;
lin consider_V3 = mkTerm "consider_V3" ;
lin consider_VS = mkTerm "consider_VS" ;
lin consider_VV = mkTerm "consider_VV" ;
lin considerable_A = mkTerm "considerable_A" ;
lin considerate_A = mkTerm "considerate_A" ;
lin considerateness_N = mkTerm "considerateness_N" ;
lin consideration_N = mkTerm "consideration_N" ;
lin considering_Prep = mkTerm "considering_Prep" ;
lin considering_Subj = mkTerm "considering_Subj" ;
lin consign_V2 = mkTerm "consign_V2" ;
lin consignee_N = mkTerm "consignee_N" ;
lin consigner_N = mkTerm "consigner_N" ;
lin consignment_N = mkTerm "consignment_N" ;
lin consignor_N = mkTerm "consignor_N" ;
lin consist_V = mkTerm "consist_V" ;
lin consistence_N = mkTerm "consistence_N" ;
lin consistency_N = mkTerm "consistency_N" ;
lin consistent_A = mkTerm "consistent_A" ;
lin consistory_N = mkTerm "consistory_N" ;
lin consolable_A = mkTerm "consolable_A" ;
lin consolation_N = mkTerm "consolation_N" ;
lin consolatory_A = mkTerm "consolatory_A" ;
lin console_N = mkTerm "console_N" ;
lin console_V2 = mkTerm "console_V2" ;
lin consolidate_V = mkTerm "consolidate_V" ;
lin consolidate_V2 = mkTerm "consolidate_V2" ;
lin consolidation_N = mkTerm "consolidation_N" ;
lin consolidative_A = mkTerm "consolidative_A" ;
lin consomme_N = mkTerm "consomme_N" ;
lin consonance_N = mkTerm "consonance_N" ;
lin consonant_A = mkTerm "consonant_A" ;
lin consonant_N = mkTerm "consonant_N" ;
lin consonantal_A = mkTerm "consonantal_A" ;
lin consort_N = mkTerm "consort_N" ;
lin consort_V = mkTerm "consort_V" ;
lin consortium_N = mkTerm "consortium_N" ;
lin conspecific_A = mkTerm "conspecific_A" ;
lin conspecific_N = mkTerm "conspecific_N" ;
lin conspectus_N = mkTerm "conspectus_N" ;
lin conspicuous_A = mkTerm "conspicuous_A" ;
lin conspicuousness_N = mkTerm "conspicuousness_N" ;
lin conspiracy_N = mkTerm "conspiracy_N" ;
lin conspirator_N = mkTerm "conspirator_N" ;
lin conspiratorial_A = mkTerm "conspiratorial_A" ;
lin conspire_V = mkTerm "conspire_V" ;
lin conspire_V2 = mkTerm "conspire_V2" ;
lin conspire_V2V = mkTerm "conspire_V2V" ;
lin constable_N = mkTerm "constable_N" ;
lin constabulary_N = mkTerm "constabulary_N" ;
lin constance_PN = mkTerm "constance_PN" ;
lin constancy_N = mkTerm "constancy_N" ;
lin constant_A = mkTerm "constant_A" ;
lin constant_N = mkTerm "constant_N" ;
lin constantan_N = mkTerm "constantan_N" ;
lin constellation_N = mkTerm "constellation_N" ;
lin consternation_N = mkTerm "consternation_N" ;
lin constipate_1_V2 = mkTerm "constipate_1_V2" ;
lin constipate_2_V2 = mkTerm "constipate_2_V2" ;
lin constipation_N = mkTerm "constipation_N" ;
lin constituency_N = mkTerm "constituency_N" ;
lin constituent_A = mkTerm "constituent_A" ;
lin constituent_N = mkTerm "constituent_N" ;
lin constitute_V2 = mkTerm "constitute_V2" ;
lin constitution_N = mkTerm "constitution_N" ;
lin constitutional_A = mkTerm "constitutional_A" ;
lin constitutional_N = mkTerm "constitutional_N" ;
lin constitutionalism_N = mkTerm "constitutionalism_N" ;
lin constitutionalist_N = mkTerm "constitutionalist_N" ;
lin constitutionalize_V2 = mkTerm "constitutionalize_V2" ;
lin constitutive_A = mkTerm "constitutive_A" ;
lin constrain_V2 = mkTerm "constrain_V2" ;
lin constrainedly_Adv = mkTerm "constrainedly_Adv" ;
lin constraint_N = mkTerm "constraint_N" ;
lin constrict_V2 = mkTerm "constrict_V2" ;
lin constricting_A = mkTerm "constricting_A" ;
lin constriction_N = mkTerm "constriction_N" ;
lin constrictor_N = mkTerm "constrictor_N" ;
lin construal_N = mkTerm "construal_N" ;
lin construct_V2 = mkTerm "construct_V2" ;
lin construction_N = mkTerm "construction_N" ;
lin constructional_A = mkTerm "constructional_A" ;
lin constructive_A = mkTerm "constructive_A" ;
lin constructiveness_N = mkTerm "constructiveness_N" ;
lin constructivism_N = mkTerm "constructivism_N" ;
lin constructivist_N = mkTerm "constructivist_N" ;
lin constructor_N = mkTerm "constructor_N" ;
lin construe_V = mkTerm "construe_V" ;
lin construe_V2 = mkTerm "construe_V2" ;
lin construe_V2V = mkTerm "construe_V2V" ;
lin consubstantial_A = mkTerm "consubstantial_A" ;
lin consubstantiation_N = mkTerm "consubstantiation_N" ;
lin consuetude_N = mkTerm "consuetude_N" ;
lin consuetudinary_N = mkTerm "consuetudinary_N" ;
lin consul_N = mkTerm "consul_N" ;
lin consular_A = mkTerm "consular_A" ;
lin consulate_N = mkTerm "consulate_N" ;
lin consulship_N = mkTerm "consulship_N" ;
lin consult_V = mkTerm "consult_V" ;
lin consult_V2 = mkTerm "consult_V2" ;
lin consultancy_N = mkTerm "consultancy_N" ;
lin consultant_N = mkTerm "consultant_N" ;
lin consultation_N = mkTerm "consultation_N" ;
lin consultative_A = mkTerm "consultative_A" ;
lin consumable_A = mkTerm "consumable_A" ;
lin consume_V = mkTerm "consume_V" ;
lin consume_V2 = mkTerm "consume_V2" ;
lin consumer_N = mkTerm "consumer_N" ;
lin consumerism_N = mkTerm "consumerism_N" ;
lin consummate_A = mkTerm "consummate_A" ;
lin consummate_V2 = mkTerm "consummate_V2" ;
lin consummation_N = mkTerm "consummation_N" ;
lin consumption_N = mkTerm "consumption_N" ;
lin consumptive_A = mkTerm "consumptive_A" ;
lin consumptive_N = mkTerm "consumptive_N" ;
lin cont_PN = mkTerm "cont_PN" ;
lin contact_N = mkTerm "contact_N" ;
lin contact_V2 = mkTerm "contact_V2" ;
lin contadino_N = mkTerm "contadino_N" ;
lin contagion_N = mkTerm "contagion_N" ;
lin contagious_A = mkTerm "contagious_A" ;
lin contain_V2 = mkTerm "contain_V2" ;
lin container_N = mkTerm "container_N" ;
lin containerful_N = mkTerm "containerful_N" ;
lin containment_N = mkTerm "containment_N" ;
lin contaminant_N = mkTerm "contaminant_N" ;
lin contaminate_V2 = mkTerm "contaminate_V2" ;
lin contamination_N = mkTerm "contamination_N" ;
lin contaminative_A = mkTerm "contaminative_A" ;
lin contemn_V2 = mkTerm "contemn_V2" ;
lin contemplate_V = mkTerm "contemplate_V" ;
lin contemplate_V2 = mkTerm "contemplate_V2" ;
lin contemplate_VS = mkTerm "contemplate_VS" ;
lin contemplation_N = mkTerm "contemplation_N" ;
lin contemplative_A = mkTerm "contemplative_A" ;
lin contemplative_N = mkTerm "contemplative_N" ;
lin contemporaneity_N = mkTerm "contemporaneity_N" ;
lin contemporaneous_A = mkTerm "contemporaneous_A" ;
lin contemporary_A = mkTerm "contemporary_A" ;
lin contemporary_N = mkTerm "contemporary_N" ;
lin contempt_N = mkTerm "contempt_N" ;
lin contemptible_A = mkTerm "contemptible_A" ;
lin contemptuous_of_A2 = mkTerm "contemptuous_of_A2" ;
lin contemptuousness_N = mkTerm "contemptuousness_N" ;
lin contend_V = mkTerm "contend_V" ;
lin contend_VS = mkTerm "contend_VS" ;
lin contender_N = mkTerm "contender_N" ;
lin content_A = mkTerm "content_A" ;
lin content_N = mkTerm "content_N" ;
lin content_V2 = mkTerm "content_V2" ;
lin contentedly_Adv = mkTerm "contentedly_Adv" ;
lin contentedness_N = mkTerm "contentedness_N" ;
lin contention_N = mkTerm "contention_N" ;
lin contentious_A = mkTerm "contentious_A" ;
lin contentment_N = mkTerm "contentment_N" ;
lin contents_N = mkTerm "contents_N" ;
lin conterminous_A = mkTerm "conterminous_A" ;
lin contest_N = mkTerm "contest_N" ;
lin contest_V = mkTerm "contest_V" ;
lin contest_V2 = mkTerm "contest_V2" ;
lin contestable_A = mkTerm "contestable_A" ;
lin contestant_N = mkTerm "contestant_N" ;
lin contestee_N = mkTerm "contestee_N" ;
lin contester_N = mkTerm "contester_N" ;
lin context_N = mkTerm "context_N" ;
lin contextual_A = mkTerm "contextual_A" ;
lin contextualism_N = mkTerm "contextualism_N" ;
lin contiguity_N = mkTerm "contiguity_N" ;
lin contiguous_A = mkTerm "contiguous_A" ;
lin continence_N = mkTerm "continence_N" ;
lin continent_A = mkTerm "continent_A" ;
lin continent_N = mkTerm "continent_N" ;
lin continental_A = mkTerm "continental_A" ;
lin contingency_N = mkTerm "contingency_N" ;
lin contingent_A = mkTerm "contingent_A" ;
lin contingent_N = mkTerm "contingent_N" ;
lin continual_A = mkTerm "continual_A" ;
lin continuance_N = mkTerm "continuance_N" ;
lin continuation_N = mkTerm "continuation_N" ;
lin continue_V = mkTerm "continue_V" ;
lin continue_V2 = mkTerm "continue_V2" ;
lin continue_VV = mkTerm "continue_VV" ;
lin continue_on_V = mkTerm "continue_on_V" ;
lin continued_A = mkTerm "continued_A" ;
lin continuing_A = mkTerm "continuing_A" ;
lin continuity_N = mkTerm "continuity_N" ;
lin continuous_A = mkTerm "continuous_A" ;
lin continuousness_N = mkTerm "continuousness_N" ;
lin continuum_N = mkTerm "continuum_N" ;
lin conto_N = mkTerm "conto_N" ;
lin contort_V2 = mkTerm "contort_V2" ;
lin contortion_N = mkTerm "contortion_N" ;
lin contortionist_N = mkTerm "contortionist_N" ;
lin contour_N = mkTerm "contour_N" ;
lin contour_V2 = mkTerm "contour_V2" ;
lin contra_Prep = mkTerm "contra_Prep" ;
lin contraband_N = mkTerm "contraband_N" ;
lin contrabass_A = mkTerm "contrabass_A" ;
lin contrabass_N = mkTerm "contrabass_N" ;
lin contrabassoon_N = mkTerm "contrabassoon_N" ;
lin contraception_N = mkTerm "contraception_N" ;
lin contraceptive_A = mkTerm "contraceptive_A" ;
lin contraceptive_N = mkTerm "contraceptive_N" ;
lin contract_N = mkTerm "contract_N" ;
lin contract_V = mkTerm "contract_V" ;
lin contract_V2 = mkTerm "contract_V2" ;
lin contract_V2V = mkTerm "contract_V2V" ;
lin contract_in_V = mkTerm "contract_in_V" ;
lin contract_out_V2 = mkTerm "contract_out_V2" ;
lin contract_out_of_V2 = mkTerm "contract_out_of_V2" ;
lin contractible_A = mkTerm "contractible_A" ;
lin contractile_A = mkTerm "contractile_A" ;
lin contractility_N = mkTerm "contractility_N" ;
lin contraction_N = mkTerm "contraction_N" ;
lin contractor_N = mkTerm "contractor_N" ;
lin contractual_A = mkTerm "contractual_A" ;
lin contracture_N = mkTerm "contracture_N" ;
lin contradict_V2 = mkTerm "contradict_V2" ;
lin contradiction_N = mkTerm "contradiction_N" ;
lin contradictoriness_N = mkTerm "contradictoriness_N" ;
lin contradictory_A = mkTerm "contradictory_A" ;
lin contradictory_N = mkTerm "contradictory_N" ;
lin contradistinction_N = mkTerm "contradistinction_N" ;
lin contradistinguish_V2 = mkTerm "contradistinguish_V2" ;
lin contrail_N = mkTerm "contrail_N" ;
lin contraindication_N = mkTerm "contraindication_N" ;
lin contralateral_A = mkTerm "contralateral_A" ;
lin contralto_N = mkTerm "contralto_N" ;
lin contraption_N = mkTerm "contraption_N" ;
lin contrapuntal_A = mkTerm "contrapuntal_A" ;
lin contrapuntist_N = mkTerm "contrapuntist_N" ;
lin contrarian_N = mkTerm "contrarian_N" ;
lin contrariety_N = mkTerm "contrariety_N" ;
lin contrariness_N = mkTerm "contrariness_N" ;
lin contrarious_A = mkTerm "contrarious_A" ;
lin contrariwise_Adv = mkTerm "contrariwise_Adv" ;
lin contrary_A = mkTerm "contrary_A" ;
lin contrary_N = mkTerm "contrary_N" ;
lin contrast_N = mkTerm "contrast_N" ;
lin contrast_V = mkTerm "contrast_V" ;
lin contrast_V2 = mkTerm "contrast_V2" ;
lin contrastingly_Adv = mkTerm "contrastingly_Adv" ;
lin contrastive_A = mkTerm "contrastive_A" ;
lin contrasty_A = mkTerm "contrasty_A" ;
lin contravene_V2 = mkTerm "contravene_V2" ;
lin contravention_N = mkTerm "contravention_N" ;
lin contretemps_N = mkTerm "contretemps_N" ;
lin contribute_V = mkTerm "contribute_V" ;
lin contribute_V2 = mkTerm "contribute_V2" ;
lin contribution_N = mkTerm "contribution_N" ;
lin contributor_N = mkTerm "contributor_N" ;
lin contributory_A = mkTerm "contributory_A" ;
lin contrite_A = mkTerm "contrite_A" ;
lin contrition_N = mkTerm "contrition_N" ;
lin contrivance_N = mkTerm "contrivance_N" ;
lin contrive_V = mkTerm "contrive_V" ;
lin contrive_V2 = mkTerm "contrive_V2" ;
lin contriver_N = mkTerm "contriver_N" ;
lin control_N = mkTerm "control_N" ;
lin control_V2 = mkTerm "control_V2" ;
lin controllable_A = mkTerm "controllable_A" ;
lin controlled_A = mkTerm "controlled_A" ;
lin controller_N = mkTerm "controller_N" ;
lin controllership_N = mkTerm "controllership_N" ;
lin controlling_A = mkTerm "controlling_A" ;
lin controversial_A = mkTerm "controversial_A" ;
lin controversialist_N = mkTerm "controversialist_N" ;
lin controversy_N = mkTerm "controversy_N" ;
lin controvert_V2 = mkTerm "controvert_V2" ;
lin contumacious_A = mkTerm "contumacious_A" ;
lin contumacy_N = mkTerm "contumacy_N" ;
lin contumelious_A = mkTerm "contumelious_A" ;
lin contumely_N = mkTerm "contumely_N" ;
lin contuse_V2 = mkTerm "contuse_V2" ;
lin contusion_N = mkTerm "contusion_N" ;
lin conundrum_N = mkTerm "conundrum_N" ;
lin conurbation_N = mkTerm "conurbation_N" ;
lin convalesce_V = mkTerm "convalesce_V" ;
lin convalescence_N = mkTerm "convalescence_N" ;
lin convalescent_A = mkTerm "convalescent_A" ;
lin convalescent_N = mkTerm "convalescent_N" ;
lin convection_N = mkTerm "convection_N" ;
lin convector_N = mkTerm "convector_N" ;
lin convene_V = mkTerm "convene_V" ;
lin convene_V2 = mkTerm "convene_V2" ;
lin convener_N = mkTerm "convener_N" ;
lin convenience_N = mkTerm "convenience_N" ;
lin convenient_A = mkTerm "convenient_A" ;
lin convent_N = mkTerm "convent_N" ;
lin conventicle_N = mkTerm "conventicle_N" ;
lin convention_N = mkTerm "convention_N" ;
lin conventional_A = mkTerm "conventional_A" ;
lin conventionality_N = mkTerm "conventionality_N" ;
lin conventionalization_N = mkTerm "conventionalization_N" ;
lin conventionalized_A = mkTerm "conventionalized_A" ;
lin conventioneer_N = mkTerm "conventioneer_N" ;
lin converge_V = mkTerm "converge_V" ;
lin convergence_N = mkTerm "convergence_N" ;
lin convergent_A = mkTerm "convergent_A" ;
lin conversant_A = mkTerm "conversant_A" ;
lin conversation_N = mkTerm "conversation_N" ;
lin conversational_A = mkTerm "conversational_A" ;
lin conversationalist_N = mkTerm "conversationalist_N" ;
lin converse_A = mkTerm "converse_A" ;
lin converse_N = mkTerm "converse_N" ;
lin converse_V = mkTerm "converse_V" ;
lin conversion_N = mkTerm "conversion_N" ;
lin convert_N = mkTerm "convert_N" ;
lin convert_V = mkTerm "convert_V" ;
lin convert_V2 = mkTerm "convert_V2" ;
lin converter_N = mkTerm "converter_N" ;
lin convertibility_N = mkTerm "convertibility_N" ;
lin convertible_A = mkTerm "convertible_A" ;
lin convertible_N = mkTerm "convertible_N" ;
lin convex_A = mkTerm "convex_A" ;
lin convexity_N = mkTerm "convexity_N" ;
lin convey_V2 = mkTerm "convey_V2" ;
lin conveyance_N = mkTerm "conveyance_N" ;
lin conveyancer_N = mkTerm "conveyancer_N" ;
lin conveyer_N = mkTerm "conveyer_N" ;
lin conveyer_belt_N = mkTerm "conveyer_belt_N" ;
lin conveyor_N = mkTerm "conveyor_N" ;
lin convict_N = mkTerm "convict_N" ;
lin convict_V2 = mkTerm "convict_V2" ;
lin conviction_N = mkTerm "conviction_N" ;
lin convince_V2 = mkTerm "convince_V2" ;
lin convince_V2V = mkTerm "convince_V2V" ;
lin convincible_A = mkTerm "convincible_A" ;
lin convincing_A = mkTerm "convincing_A" ;
lin convincingness_N = mkTerm "convincingness_N" ;
lin convivial_A = mkTerm "convivial_A" ;
lin conviviality_N = mkTerm "conviviality_N" ;
lin convocation_N = mkTerm "convocation_N" ;
lin convoke_V2 = mkTerm "convoke_V2" ;
lin convolute_A = mkTerm "convolute_A" ;
lin convoluted_A = mkTerm "convoluted_A" ;
lin convolution_N = mkTerm "convolution_N" ;
lin convolvulus_N = mkTerm "convolvulus_N" ;
lin convoy_N = mkTerm "convoy_N" ;
lin convoy_V2 = mkTerm "convoy_V2" ;
lin convulse_V2 = mkTerm "convulse_V2" ;
lin convulsion_N = mkTerm "convulsion_N" ;
lin convulsive_A = mkTerm "convulsive_A" ;
lin conwy_PN = mkTerm "conwy_PN" ;
lin cony_N = mkTerm "cony_N" ;
lin coo_N = mkTerm "coo_N" ;
lin coo_V = mkTerm "coo_V" ;
lin coo_V2 = mkTerm "coo_V2" ;
lin cook_N = mkTerm "cook_N" ;
lin cook_V = mkTerm "cook_V" ;
lin cook_V2 = mkTerm "cook_V2" ;
lin cookbook_N = mkTerm "cookbook_N" ;
lin cooker_N = mkTerm "cooker_N" ;
lin cookery_N = mkTerm "cookery_N" ;
lin cookery_book_N = mkTerm "cookery_book_N" ;
lin cookfire_N = mkTerm "cookfire_N" ;
lin cookham_PN = mkTerm "cookham_PN" ;
lin cookhouse_N = mkTerm "cookhouse_N" ;
lin cookie_N = mkTerm "cookie_N" ;
lin cooking_N = mkTerm "cooking_N" ;
lin cookout_N = mkTerm "cookout_N" ;
lin cookstove_N = mkTerm "cookstove_N" ;
lin cooky_N = mkTerm "cooky_N" ;
lin cool_A = mkTerm "cool_A" ;
lin cool_N = mkTerm "cool_N" ;
lin cool_V = mkTerm "cool_V" ;
lin cool_V2 = mkTerm "cool_V2" ;
lin cool_down_V = mkTerm "cool_down_V" ;
lin cool_down_V2 = mkTerm "cool_down_V2" ;
lin cool_headed_A = mkTerm "cool_headed_A" ;
lin cool_off_V = mkTerm "cool_off_V" ;
lin coolant_N = mkTerm "coolant_N" ;
lin cooler_N = mkTerm "cooler_N" ;
lin coolie_N = mkTerm "coolie_N" ;
lin cooling_N = mkTerm "cooling_N" ;
lin cooling_tower_N = mkTerm "cooling_tower_N" ;
lin coolness_N = mkTerm "coolness_N" ;
lin coon_N = mkTerm "coon_N" ;
lin coondog_N = mkTerm "coondog_N" ;
lin coonhound_N = mkTerm "coonhound_N" ;
lin coontie_N = mkTerm "coontie_N" ;
lin coop_N = mkTerm "coop_N" ;
lin coop_V2 = mkTerm "coop_V2" ;
lin coop_up_V2 = mkTerm "coop_up_V2" ;
lin cooper_N = mkTerm "cooper_N" ;
lin cooperate_V = mkTerm "cooperate_V" ;
lin cooperation_N = mkTerm "cooperation_N" ;
lin cooperative_A = mkTerm "cooperative_A" ;
lin cooperative_N = mkTerm "cooperative_N" ;
lin cooperator_N = mkTerm "cooperator_N" ;
lin coordinate_A = mkTerm "coordinate_A" ;
lin coordinate_N = mkTerm "coordinate_N" ;
lin coordinate_V = mkTerm "coordinate_V" ;
lin coordinate_V2 = mkTerm "coordinate_V2" ;
lin coordination_N = mkTerm "coordination_N" ;
lin coordinator_N = mkTerm "coordinator_N" ;
lin coot_N = mkTerm "coot_N" ;
lin cooter_N = mkTerm "cooter_N" ;
lin cop_N = mkTerm "cop_N" ;
lin cop_V2 = mkTerm "cop_V2" ;
lin cop_it_V = mkTerm "cop_it_V" ;
lin cop_off_V = mkTerm "cop_off_V" ;
lin cop_off_V2 = mkTerm "cop_off_V2" ;
lin cop_out_N = mkTerm "cop_out_N" ;
lin cop_out_V = mkTerm "cop_out_V" ;
lin copacetic_A = mkTerm "copacetic_A" ;
lin copaiba_N = mkTerm "copaiba_N" ;
lin copal_N = mkTerm "copal_N" ;
lin copalite_N = mkTerm "copalite_N" ;
lin copartner_N = mkTerm "copartner_N" ;
lin copartnership_N = mkTerm "copartnership_N" ;
lin cope_N = mkTerm "cope_N" ;
lin cope_V = mkTerm "cope_V" ;
lin copeck_N = mkTerm "copeck_N" ;
lin copenhagen_PN = mkTerm "copenhagen_PN" ;
lin copepod_N = mkTerm "copepod_N" ;
lin copernican_A = mkTerm "copernican_A" ;
lin copilot_N = mkTerm "copilot_N" ;
lin coping_N = mkTerm "coping_N" ;
lin coping_stone_N = mkTerm "coping_stone_N" ;
lin copious_A = mkTerm "copious_A" ;
lin coplanar_A = mkTerm "coplanar_A" ;
lin copolymer_N = mkTerm "copolymer_N" ;
lin copper_N = mkTerm "copper_N" ;
lin copper_V2 = mkTerm "copper_V2" ;
lin copper_bottom_V2 = mkTerm "copper_bottom_V2" ;
lin copper_bottomed_A = mkTerm "copper_bottomed_A" ;
lin copperhead_N = mkTerm "copperhead_N" ;
lin copperplate_N = mkTerm "copperplate_N" ;
lin coppersmith_N = mkTerm "coppersmith_N" ;
lin copperware_N = mkTerm "copperware_N" ;
lin coppery_A = mkTerm "coppery_A" ;
lin coppice_N = mkTerm "coppice_N" ;
lin coppull_PN = mkTerm "coppull_PN" ;
lin copra_N = mkTerm "copra_N" ;
lin coproduction_N = mkTerm "coproduction_N" ;
lin coprolalia_N = mkTerm "coprolalia_N" ;
lin coprolite_N = mkTerm "coprolite_N" ;
lin coprolith_N = mkTerm "coprolith_N" ;
lin coprophagy_N = mkTerm "coprophagy_N" ;
lin copse_N = mkTerm "copse_N" ;
lin copt_A = mkTerm "copt_A" ;
lin copt_N = mkTerm "copt_N" ;
lin coptic_N = mkTerm "coptic_N" ;
lin copula_N = mkTerm "copula_N" ;
lin copular_A = mkTerm "copular_A" ;
lin copulate_V = mkTerm "copulate_V" ;
lin copulation_N = mkTerm "copulation_N" ;
lin copulative_A = mkTerm "copulative_A" ;
lin copulative_N = mkTerm "copulative_N" ;
lin copy_N = mkTerm "copy_N" ;
lin copy_V = mkTerm "copy_V" ;
lin copy_V2 = mkTerm "copy_V2" ;
lin copybook_N = mkTerm "copybook_N" ;
lin copycat_N = mkTerm "copycat_N" ;
lin copyhold_N = mkTerm "copyhold_N" ;
lin copyholder_N = mkTerm "copyholder_N" ;
lin copying_N = mkTerm "copying_N" ;
lin copyist_N = mkTerm "copyist_N" ;
lin copyright_N = mkTerm "copyright_N" ;
lin copyright_V2 = mkTerm "copyright_V2" ;
lin copywriter_N = mkTerm "copywriter_N" ;
lin coquetry_N = mkTerm "coquetry_N" ;
lin coquette_N = mkTerm "coquette_N" ;
lin coquettish_A = mkTerm "coquettish_A" ;
lin coquille_N = mkTerm "coquille_N" ;
lin cor_anglais_N = mkTerm "cor_anglais_N" ;
lin coracle_N = mkTerm "coracle_N" ;
lin coral_A = mkTerm "coral_A" ;
lin coral_N = mkTerm "coral_N" ;
lin coral_reef_N = mkTerm "coral_reef_N" ;
lin coralbells_N = mkTerm "coralbells_N" ;
lin coralberry_N = mkTerm "coralberry_N" ;
lin coralwood_N = mkTerm "coralwood_N" ;
lin corbel_N = mkTerm "corbel_N" ;
lin corbelled_A = mkTerm "corbelled_A" ;
lin corbina_N = mkTerm "corbina_N" ;
lin corby_PN = mkTerm "corby_PN" ;
lin corchorus_N = mkTerm "corchorus_N" ;
lin cord_N = mkTerm "cord_N" ;
lin cord_V2 = mkTerm "cord_V2" ;
lin cordage_N = mkTerm "cordage_N" ;
lin cordate_A = mkTerm "cordate_A" ;
lin cordgrass_N = mkTerm "cordgrass_N" ;
lin cordial_A = mkTerm "cordial_A" ;
lin cordial_N = mkTerm "cordial_N" ;
lin cordiality_N = mkTerm "cordiality_N" ;
lin cordierite_N = mkTerm "cordierite_N" ;
lin cordite_N = mkTerm "cordite_N" ;
lin corditis_N = mkTerm "corditis_N" ;
lin cordless_A = mkTerm "cordless_A" ;
lin cordoba_N = mkTerm "cordoba_N" ;
lin cordoba_PN = mkTerm "cordoba_PN" ;
lin cordon_N = mkTerm "cordon_N" ;
lin cordon_V2 = mkTerm "cordon_V2" ;
lin cordon_bleu_A = mkTerm "cordon_bleu_A" ;
lin cordovan_N = mkTerm "cordovan_N" ;
lin cords_N = mkTerm "cords_N" ;
lin corduroy_N = mkTerm "corduroy_N" ;
lin cordwood_N = mkTerm "cordwood_N" ;
lin core_N = mkTerm "core_N" ;
lin core_V2 = mkTerm "core_V2" ;
lin coreference_N = mkTerm "coreference_N" ;
lin coreferent_A = mkTerm "coreferent_A" ;
lin coreferential_A = mkTerm "coreferential_A" ;
lin coreligionist_N = mkTerm "coreligionist_N" ;
lin coreopsis_N = mkTerm "coreopsis_N" ;
lin corer_N = mkTerm "corer_N" ;
lin corespondent_N = mkTerm "corespondent_N" ;
lin corgi_N = mkTerm "corgi_N" ;
lin coriaceous_A = mkTerm "coriaceous_A" ;
lin coriander_N = mkTerm "coriander_N" ;
lin corinthian_A = mkTerm "corinthian_A" ;
lin corinthian_N = mkTerm "corinthian_N" ;
lin cork_N = mkTerm "cork_N" ;
lin cork_PN = mkTerm "cork_PN" ;
lin cork_V2 = mkTerm "cork_V2" ;
lin corkage_N = mkTerm "corkage_N" ;
lin corkboard_N = mkTerm "corkboard_N" ;
lin corker_N = mkTerm "corker_N" ;
lin corkscrew_N = mkTerm "corkscrew_N" ;
lin corkwood_N = mkTerm "corkwood_N" ;
lin corm_N = mkTerm "corm_N" ;
lin cormorant_N = mkTerm "cormorant_N" ;
lin cormous_A = mkTerm "cormous_A" ;
lin corn_N = mkTerm "corn_N" ;
lin corn_V2 = mkTerm "corn_V2" ;
lin corn_exchange_N = mkTerm "corn_exchange_N" ;
lin cornbread_N = mkTerm "cornbread_N" ;
lin corncob_N = mkTerm "corncob_N" ;
lin corncrake_N = mkTerm "corncrake_N" ;
lin corncrib_N = mkTerm "corncrib_N" ;
lin cornea_N = mkTerm "cornea_N" ;
lin corneal_A = mkTerm "corneal_A" ;
lin cornelian_N = mkTerm "cornelian_N" ;
lin corneous_A = mkTerm "corneous_A" ;
lin corner_N = mkTerm "corner_N" ;
lin corner_V = mkTerm "corner_V" ;
lin corner_V2 = mkTerm "corner_V2" ;
lin corner_kick_N = mkTerm "corner_kick_N" ;
lin cornerback_N = mkTerm "cornerback_N" ;
lin cornerstone_N = mkTerm "cornerstone_N" ;
lin cornet_N = mkTerm "cornet_N" ;
lin cornetfish_N = mkTerm "cornetfish_N" ;
lin cornfield_N = mkTerm "cornfield_N" ;
lin cornflake_N = mkTerm "cornflake_N" ;
lin cornflour_N = mkTerm "cornflour_N" ;
lin cornflower_N = mkTerm "cornflower_N" ;
lin cornhusk_N = mkTerm "cornhusk_N" ;
lin cornhusker_N = mkTerm "cornhusker_N" ;
lin cornhusking_N = mkTerm "cornhusking_N" ;
lin cornice_N = mkTerm "cornice_N" ;
lin cornmeal_N = mkTerm "cornmeal_N" ;
lin cornpone_N = mkTerm "cornpone_N" ;
lin cornsilk_N = mkTerm "cornsilk_N" ;
lin cornsmut_N = mkTerm "cornsmut_N" ;
lin cornstalk_N = mkTerm "cornstalk_N" ;
lin cornstarch_N = mkTerm "cornstarch_N" ;
lin cornu_N = mkTerm "cornu_N" ;
lin cornucopia_N = mkTerm "cornucopia_N" ;
lin cornwall_PN = mkTerm "cornwall_PN" ;
lin corny_A = mkTerm "corny_A" ;
lin corolla_N = mkTerm "corolla_N" ;
lin corollary_N = mkTerm "corollary_N" ;
lin corona_N = mkTerm "corona_N" ;
lin coronary_A = mkTerm "coronary_A" ;
lin coronary_N = mkTerm "coronary_N" ;
lin coronation_N = mkTerm "coronation_N" ;
lin coroner_N = mkTerm "coroner_N" ;
lin coronet_N = mkTerm "coronet_N" ;
lin coroneted_A = mkTerm "coroneted_A" ;
lin coronilla_N = mkTerm "coronilla_N" ;
lin coronion_N = mkTerm "coronion_N" ;
lin corozo_N = mkTerm "corozo_N" ;
lin corp_PN = mkTerm "corp_PN" ;
lin corporal_A = mkTerm "corporal_A" ;
lin corporal_N = mkTerm "corporal_N" ;
lin corporate_A = mkTerm "corporate_A" ;
lin corporation_N = mkTerm "corporation_N" ;
lin corporatism_N = mkTerm "corporatism_N" ;
lin corporatist_A = mkTerm "corporatist_A" ;
lin corporatist_N = mkTerm "corporatist_N" ;
lin corporeal_A = mkTerm "corporeal_A" ;
lin corps_N = mkTerm "corps_N" ;
lin corps_de_ballet_N = mkTerm "corps_de_ballet_N" ;
lin corps_diplomatique_N = mkTerm "corps_diplomatique_N" ;
lin corpse_N = mkTerm "corpse_N" ;
lin corpulence_N = mkTerm "corpulence_N" ;
lin corpulent_A = mkTerm "corpulent_A" ;
lin corpus_N = mkTerm "corpus_N" ;
lin corpuscle_N = mkTerm "corpuscle_N" ;
lin corpuscular_A = mkTerm "corpuscular_A" ;
lin corral_N = mkTerm "corral_N" ;
lin corral_V2 = mkTerm "corral_V2" ;
lin correct_A = mkTerm "correct_A" ;
lin correct_V = mkTerm "correct_V" ;
lin correct_V2 = mkTerm "correct_V2" ;
lin correct_VS = mkTerm "correct_VS" ;
lin correctable_A = mkTerm "correctable_A" ;
lin correction_1_N = mkTerm "correction_1_N" ;
lin correction_2_N = mkTerm "correction_2_N" ;
lin correctional_A = mkTerm "correctional_A" ;
lin correctitude_N = mkTerm "correctitude_N" ;
lin corrective_A = mkTerm "corrective_A" ;
lin corrective_N = mkTerm "corrective_N" ;
lin correctness_N = mkTerm "correctness_N" ;
lin correlate_N = mkTerm "correlate_N" ;
lin correlate_V = mkTerm "correlate_V" ;
lin correlate_V2 = mkTerm "correlate_V2" ;
lin correlation_N = mkTerm "correlation_N" ;
lin correlational_A = mkTerm "correlational_A" ;
lin correlative_A = mkTerm "correlative_A" ;
lin correlative_N = mkTerm "correlative_N" ;
lin correspond_V = mkTerm "correspond_V" ;
lin correspond_V2 = mkTerm "correspond_V2" ;
lin correspondence_N = mkTerm "correspondence_N" ;
lin correspondent_N = mkTerm "correspondent_N" ;
lin corresponding_A = mkTerm "corresponding_A" ;
lin corridor_N = mkTerm "corridor_N" ;
lin corrie_N = mkTerm "corrie_N" ;
lin corrigenda_N = mkTerm "corrigenda_N" ;
lin corrigendum_N = mkTerm "corrigendum_N" ;
lin corrigible_A = mkTerm "corrigible_A" ;
lin corroborant_A = mkTerm "corroborant_A" ;
lin corroborate_V2 = mkTerm "corroborate_V2" ;
lin corroboration_N = mkTerm "corroboration_N" ;
lin corroborative_A = mkTerm "corroborative_A" ;
lin corrode_V = mkTerm "corrode_V" ;
lin corrode_V2 = mkTerm "corrode_V2" ;
lin corrosion_N = mkTerm "corrosion_N" ;
lin corrosive_A = mkTerm "corrosive_A" ;
lin corrosive_N = mkTerm "corrosive_N" ;
lin corrugate_V = mkTerm "corrugate_V" ;
lin corrugate_V2 = mkTerm "corrugate_V2" ;
lin corrugation_N = mkTerm "corrugation_N" ;
lin corrupt_A = mkTerm "corrupt_A" ;
lin corrupt_V = mkTerm "corrupt_V" ;
lin corrupt_V2 = mkTerm "corrupt_V2" ;
lin corruptibility_N = mkTerm "corruptibility_N" ;
lin corruptible_A = mkTerm "corruptible_A" ;
lin corruption_N = mkTerm "corruption_N" ;
lin corruptive_A = mkTerm "corruptive_A" ;
lin corruptness_N = mkTerm "corruptness_N" ;
lin corsage_N = mkTerm "corsage_N" ;
lin corsair_N = mkTerm "corsair_N" ;
lin corse_N = mkTerm "corse_N" ;
lin corselet_N = mkTerm "corselet_N" ;
lin corset_N = mkTerm "corset_N" ;
lin corsham_PN = mkTerm "corsham_PN" ;
lin corslet_N = mkTerm "corslet_N" ;
lin cortege_1_N = mkTerm "cortege_1_N" ;
lin cortege_2_N = mkTerm "cortege_2_N" ;
lin cortex_N = mkTerm "cortex_N" ;
lin cortical_A = mkTerm "cortical_A" ;
lin corticoafferent_A = mkTerm "corticoafferent_A" ;
lin corticoefferent_A = mkTerm "corticoefferent_A" ;
lin corticosteroid_N = mkTerm "corticosteroid_N" ;
lin corticosterone_N = mkTerm "corticosterone_N" ;
lin cortina_N = mkTerm "cortina_N" ;
lin cortisone_N = mkTerm "cortisone_N" ;
lin corundom_N = mkTerm "corundom_N" ;
lin corundum_N = mkTerm "corundum_N" ;
lin corunna_PN = mkTerm "corunna_PN" ;
lin coruscate_V = mkTerm "coruscate_V" ;
lin coruscation_N = mkTerm "coruscation_N" ;
lin corvee_N = mkTerm "corvee_N" ;
lin corvette_N = mkTerm "corvette_N" ;
lin corvine_A = mkTerm "corvine_A" ;
lin corydalis_N = mkTerm "corydalis_N" ;
lin corymb_N = mkTerm "corymb_N" ;
lin corymbose_A = mkTerm "corymbose_A" ;
lin corynebacterium_N = mkTerm "corynebacterium_N" ;
lin coryphantha_N = mkTerm "coryphantha_N" ;
lin corythosaur_N = mkTerm "corythosaur_N" ;
lin cos_N = mkTerm "cos_N" ;
lin coscoroba_N = mkTerm "coscoroba_N" ;
lin cosecant_N = mkTerm "cosecant_N" ;
lin coseismic_A = mkTerm "coseismic_A" ;
lin cosenza_PN = mkTerm "cosenza_PN" ;
lin cosh_N = mkTerm "cosh_N" ;
lin cosh_V2 = mkTerm "cosh_V2" ;
lin cosher_A = mkTerm "cosher_A" ;
lin cosignatory_A = mkTerm "cosignatory_A" ;
lin cosignatory_N = mkTerm "cosignatory_N" ;
lin cosigner_N = mkTerm "cosigner_N" ;
lin cosine_N = mkTerm "cosine_N" ;
lin cosiness_N = mkTerm "cosiness_N" ;
lin cosmetic_A = mkTerm "cosmetic_A" ;
lin cosmetic_N = mkTerm "cosmetic_N" ;
lin cosmetician_N = mkTerm "cosmetician_N" ;
lin cosmetologist_N = mkTerm "cosmetologist_N" ;
lin cosmetology_N = mkTerm "cosmetology_N" ;
lin cosmic_A = mkTerm "cosmic_A" ;
lin cosmid_N = mkTerm "cosmid_N" ;
lin cosmogony_N = mkTerm "cosmogony_N" ;
lin cosmographer_N = mkTerm "cosmographer_N" ;
lin cosmography_N = mkTerm "cosmography_N" ;
lin cosmolatry_N = mkTerm "cosmolatry_N" ;
lin cosmologic_A = mkTerm "cosmologic_A" ;
lin cosmologist_N = mkTerm "cosmologist_N" ;
lin cosmology_N = mkTerm "cosmology_N" ;
lin cosmonaut_N = mkTerm "cosmonaut_N" ;
lin cosmopolitan_A = mkTerm "cosmopolitan_A" ;
lin cosmopolitan_N = mkTerm "cosmopolitan_N" ;
lin cosmos_N = mkTerm "cosmos_N" ;
lin cosmotron_N = mkTerm "cosmotron_N" ;
lin cosset_V2 = mkTerm "cosset_V2" ;
lin cost_N = mkTerm "cost_N" ;
lin cost_V = mkTerm "cost_V" ;
lin cost_V2 = mkTerm "cost_V2" ;
lin cost_up_V2 = mkTerm "cost_up_V2" ;
lin costa_N = mkTerm "costa_N" ;
lin costa_rica_PN = mkTerm "costa_rica_PN" ;
lin costa_rican_A = mkTerm "costa_rican_A" ;
lin costa_rican_N = mkTerm "costa_rican_N" ;
lin costal_A = mkTerm "costal_A" ;
lin costate_A = mkTerm "costate_A" ;
lin costermonger_N = mkTerm "costermonger_N" ;
lin costia_N = mkTerm "costia_N" ;
lin costiasis_N = mkTerm "costiasis_N" ;
lin costing_N = mkTerm "costing_N" ;
lin costive_A = mkTerm "costive_A" ;
lin costliness_N = mkTerm "costliness_N" ;
lin costly_A = mkTerm "costly_A" ;
lin costmary_N = mkTerm "costmary_N" ;
lin costochondritis_N = mkTerm "costochondritis_N" ;
lin costs_N = mkTerm "costs_N" ;
lin costum_V2 = mkTerm "costum_V2" ;
lin costume_N = mkTerm "costume_N" ;
lin costumed_A = mkTerm "costumed_A" ;
lin costumier_N = mkTerm "costumier_N" ;
lin costusroot_N = mkTerm "costusroot_N" ;
lin cosy_A = mkTerm "cosy_A" ;
lin cosy_N = mkTerm "cosy_N" ;
lin cot_N = mkTerm "cot_N" ;
lin cotangent_N = mkTerm "cotangent_N" ;
lin cote_N = mkTerm "cote_N" ;
lin cotenant_N = mkTerm "cotenant_N" ;
lin coterie_N = mkTerm "coterie_N" ;
lin coterminous_A = mkTerm "coterminous_A" ;
lin cotilion_N = mkTerm "cotilion_N" ;
lin cotillion_N = mkTerm "cotillion_N" ;
lin cotinga_N = mkTerm "cotinga_N" ;
lin cotoneaster_N = mkTerm "cotoneaster_N" ;
lin cottage_N = mkTerm "cottage_N" ;
lin cottager_N = mkTerm "cottager_N" ;
lin cottar_N = mkTerm "cottar_N" ;
lin cotter_N = mkTerm "cotter_N" ;
lin cotton_N = mkTerm "cotton_N" ;
lin cotton_V = mkTerm "cotton_V" ;
lin cotton_cake_N = mkTerm "cotton_cake_N" ;
lin cotton_on_V = mkTerm "cotton_on_V" ;
lin cotton_plant_N = mkTerm "cotton_plant_N" ;
lin cotton_wool_N = mkTerm "cotton_wool_N" ;
lin cottonseed_N = mkTerm "cottonseed_N" ;
lin cottontail_N = mkTerm "cottontail_N" ;
lin cottonweed_N = mkTerm "cottonweed_N" ;
lin cottonwick_N = mkTerm "cottonwick_N" ;
lin cottonwood_N = mkTerm "cottonwood_N" ;
lin cottony_A = mkTerm "cottony_A" ;
lin cotyledon_N = mkTerm "cotyledon_N" ;
lin coucal_N = mkTerm "coucal_N" ;
lin couch_N = mkTerm "couch_N" ;
lin couch_V = mkTerm "couch_V" ;
lin couch_V2 = mkTerm "couch_V2" ;
lin couch_grass_N = mkTerm "couch_grass_N" ;
lin couchant_A = mkTerm "couchant_A" ;
lin couchette_N = mkTerm "couchette_N" ;
lin cougar_N = mkTerm "cougar_N" ;
lin cough_N = mkTerm "cough_N" ;
lin cough_V = mkTerm "cough_V" ;
lin cough_up_V2 = mkTerm "cough_up_V2" ;
lin coulisse_N = mkTerm "coulisse_N" ;
lin coulomb_N = mkTerm "coulomb_N" ;
lin coulter_N = mkTerm "coulter_N" ;
lin council_N = mkTerm "council_N" ;
lin council_board_N = mkTerm "council_board_N" ;
lin council_chamber_N = mkTerm "council_chamber_N" ;
lin councillor_N = mkTerm "councillor_N" ;
lin councillorship_N = mkTerm "councillorship_N" ;
lin councilman_N = mkTerm "councilman_N" ;
lin councilwoman_N = mkTerm "councilwoman_N" ;
lin counsel_N = mkTerm "counsel_N" ;
lin counsel_V2 = mkTerm "counsel_V2" ;
lin counselling_N = mkTerm "counselling_N" ;
lin counsellor_N = mkTerm "counsellor_N" ;
lin counselorship_N = mkTerm "counselorship_N" ;
lin count_1_N = mkTerm "count_1_N" ;
lin count_2_N = mkTerm "count_2_N" ;
lin count_V = mkTerm "count_V" ;
lin count_V2 = mkTerm "count_V2" ;
lin count_against_V2 = mkTerm "count_against_V2" ;
lin count_among_V2 = mkTerm "count_among_V2" ;
lin count_down_V2 = mkTerm "count_down_V2" ;
lin count_for_V2 = mkTerm "count_for_V2" ;
lin count_in_V2 = mkTerm "count_in_V2" ;
lin count_off_V2 = mkTerm "count_off_V2" ;
lin count_on_V2 = mkTerm "count_on_V2" ;
lin count_out_V2 = mkTerm "count_out_V2" ;
lin count_towards_V2 = mkTerm "count_towards_V2" ;
lin count_up_V2 = mkTerm "count_up_V2" ;
lin count_upon_V2 = mkTerm "count_upon_V2" ;
lin countable_A = mkTerm "countable_A" ;
lin countdown_N = mkTerm "countdown_N" ;
lin countenance_N = mkTerm "countenance_N" ;
lin countenance_V2 = mkTerm "countenance_V2" ;
lin counter_A = mkTerm "counter_A" ;
lin counter_Adv = mkTerm "counter_Adv" ;
lin counter_N = mkTerm "counter_N" ;
lin counter_V = mkTerm "counter_V" ;
lin counter_VS = mkTerm "counter_VS" ;
lin counter_example_N = mkTerm "counter_example_N" ;
lin counter_revolution_N = mkTerm "counter_revolution_N" ;
lin counter_revolutionary_A = mkTerm "counter_revolutionary_A" ;
lin counter_revolutionary_N = mkTerm "counter_revolutionary_N" ;
lin counteract_V2 = mkTerm "counteract_V2" ;
lin counteraction_N = mkTerm "counteraction_N" ;
lin counteractive_A = mkTerm "counteractive_A" ;
lin counterargument_N = mkTerm "counterargument_N" ;
lin counterattack_N = mkTerm "counterattack_N" ;
lin counterattack_V = mkTerm "counterattack_V" ;
lin counterattack_V2 = mkTerm "counterattack_V2" ;
lin counterattraction_N = mkTerm "counterattraction_N" ;
lin counterbalance_N = mkTerm "counterbalance_N" ;
lin counterbalance_V2 = mkTerm "counterbalance_V2" ;
lin counterblast_N = mkTerm "counterblast_N" ;
lin counterblow_N = mkTerm "counterblow_N" ;
lin counterbombardment_N = mkTerm "counterbombardment_N" ;
lin counterbore_N = mkTerm "counterbore_N" ;
lin countercharge_N = mkTerm "countercharge_N" ;
lin countercheck_N = mkTerm "countercheck_N" ;
lin counterclaim_N = mkTerm "counterclaim_N" ;
lin counterclockwise_A = mkTerm "counterclockwise_A" ;
lin counterclockwise_Adv = mkTerm "counterclockwise_Adv" ;
lin countercoup_N = mkTerm "countercoup_N" ;
lin counterculture_N = mkTerm "counterculture_N" ;
lin countercurrent_N = mkTerm "countercurrent_N" ;
lin counterdemonstration_N = mkTerm "counterdemonstration_N" ;
lin counterdemonstrator_N = mkTerm "counterdemonstrator_N" ;
lin counterespionage_N = mkTerm "counterespionage_N" ;
lin counterfactual_A = mkTerm "counterfactual_A" ;
lin counterfactuality_N = mkTerm "counterfactuality_N" ;
lin counterfeit_A = mkTerm "counterfeit_A" ;
lin counterfeit_N = mkTerm "counterfeit_N" ;
lin counterfeit_V2 = mkTerm "counterfeit_V2" ;
lin counterfeiter_N = mkTerm "counterfeiter_N" ;
lin counterfire_N = mkTerm "counterfire_N" ;
lin counterfoil_N = mkTerm "counterfoil_N" ;
lin counterglow_N = mkTerm "counterglow_N" ;
lin counterinsurgent_A = mkTerm "counterinsurgent_A" ;
lin counterintelligence_N = mkTerm "counterintelligence_N" ;
lin counterintuitive_A = mkTerm "counterintuitive_A" ;
lin counterirritant_N = mkTerm "counterirritant_N" ;
lin countermand_N = mkTerm "countermand_N" ;
lin countermand_V2 = mkTerm "countermand_V2" ;
lin countermarch_N = mkTerm "countermarch_N" ;
lin countermeasure_N = mkTerm "countermeasure_N" ;
lin countermine_N = mkTerm "countermine_N" ;
lin countermine_V = mkTerm "countermine_V" ;
lin countermine_V2 = mkTerm "countermine_V2" ;
lin counteroffensive_N = mkTerm "counteroffensive_N" ;
lin counteroffer_N = mkTerm "counteroffer_N" ;
lin counterpane_N = mkTerm "counterpane_N" ;
lin counterpart_N = mkTerm "counterpart_N" ;
lin counterperson_N = mkTerm "counterperson_N" ;
lin counterplea_N = mkTerm "counterplea_N" ;
lin counterplot_N = mkTerm "counterplot_N" ;
lin counterplot_V = mkTerm "counterplot_V" ;
lin counterplot_V2 = mkTerm "counterplot_V2" ;
lin counterpoint_N = mkTerm "counterpoint_N" ;
lin counterpoise_N = mkTerm "counterpoise_N" ;
lin counterpoise_V2 = mkTerm "counterpoise_V2" ;
lin counterproductive_A = mkTerm "counterproductive_A" ;
lin counterproposal_N = mkTerm "counterproposal_N" ;
lin counterpunch_N = mkTerm "counterpunch_N" ;
lin counterreformation_N = mkTerm "counterreformation_N" ;
lin counterrevolutionist_N = mkTerm "counterrevolutionist_N" ;
lin countershot_N = mkTerm "countershot_N" ;
lin countersign_N = mkTerm "countersign_N" ;
lin countersign_V2 = mkTerm "countersign_V2" ;
lin countersignature_N = mkTerm "countersignature_N" ;
lin countersink_N = mkTerm "countersink_N" ;
lin countersink_V2 = mkTerm "countersink_V2" ;
lin counterspy_N = mkTerm "counterspy_N" ;
lin counterstain_N = mkTerm "counterstain_N" ;
lin countersubversion_N = mkTerm "countersubversion_N" ;
lin countersuing_V2 = mkTerm "countersuing_V2" ;
lin countersuit_N = mkTerm "countersuit_N" ;
lin countertenor_A = mkTerm "countertenor_A" ;
lin countertenor_N = mkTerm "countertenor_N" ;
lin counterterror_A = mkTerm "counterterror_A" ;
lin counterterrorism_N = mkTerm "counterterrorism_N" ;
lin counterterrorist_N = mkTerm "counterterrorist_N" ;
lin countertop_N = mkTerm "countertop_N" ;
lin countertransference_N = mkTerm "countertransference_N" ;
lin countervail_V = mkTerm "countervail_V" ;
lin countervail_V2 = mkTerm "countervail_V2" ;
lin counterweight_N = mkTerm "counterweight_N" ;
lin countess_N = mkTerm "countess_N" ;
lin counting_house_N = mkTerm "counting_house_N" ;
lin countless_A = mkTerm "countless_A" ;
lin countrified_A = mkTerm "countrified_A" ;
lin country_N = mkTerm "country_N" ;
lin country_house_N = mkTerm "country_house_N" ;
lin country_seat_N = mkTerm "country_seat_N" ;
lin countryman_N = mkTerm "countryman_N" ;
lin countryside_N = mkTerm "countryside_N" ;
lin countrywide_A = mkTerm "countrywide_A" ;
lin countrywoman_N = mkTerm "countrywoman_N" ;
lin county_N = mkTerm "county_N" ;
lin countywide_A = mkTerm "countywide_A" ;
lin coup_N = mkTerm "coup_N" ;
lin coup_d'etat_N = mkTerm "coup_d'etat_N" ;
lin coup_de_grace_N = mkTerm "coup_de_grace_N" ;
lin coupe_N = mkTerm "coupe_N" ;
lin couple_N = mkTerm "couple_N" ;
lin couple_V = mkTerm "couple_V" ;
lin couple_V2 = mkTerm "couple_V2" ;
lin couplet_N = mkTerm "couplet_N" ;
lin coupling_N = mkTerm "coupling_N" ;
lin coupon_N = mkTerm "coupon_N" ;
lin courage_N = mkTerm "courage_N" ;
lin courageous_A = mkTerm "courageous_A" ;
lin courante_N = mkTerm "courante_N" ;
lin courbaril_N = mkTerm "courbaril_N" ;
lin courgette_N = mkTerm "courgette_N" ;
lin courier_N = mkTerm "courier_N" ;
lin courlan_N = mkTerm "courlan_N" ;
lin course_N = mkTerm "course_N" ;
lin course_V = mkTerm "course_V" ;
lin course_V2 = mkTerm "course_V2" ;
lin courser_N = mkTerm "courser_N" ;
lin coursework_N = mkTerm "coursework_N" ;
lin coursing_N = mkTerm "coursing_N" ;
lin court_1_N = mkTerm "court_1_N" ;
lin court_2_N = mkTerm "court_2_N" ;
lin court_V = mkTerm "court_V" ;
lin court_V2 = mkTerm "court_V2" ;
lin court_card_N = mkTerm "court_card_N" ;
lin court_martial_N = mkTerm "court_martial_N" ;
lin court_martial_V2 = mkTerm "court_martial_V2" ;
lin courteous_A = mkTerm "courteous_A" ;
lin courtesan_N = mkTerm "courtesan_N" ;
lin courtesy_N = mkTerm "courtesy_N" ;
lin courthouse_N = mkTerm "courthouse_N" ;
lin courtier_N = mkTerm "courtier_N" ;
lin courtliness_N = mkTerm "courtliness_N" ;
lin courtly_A = mkTerm "courtly_A" ;
lin courtroom_N = mkTerm "courtroom_N" ;
lin courtship_N = mkTerm "courtship_N" ;
lin courtyard_N = mkTerm "courtyard_N" ;
lin couscous_N = mkTerm "couscous_N" ;
lin cousin_N = mkTerm "cousin_N" ;
lin cousinly_A = mkTerm "cousinly_A" ;
lin couth_A = mkTerm "couth_A" ;
lin couthie_A = mkTerm "couthie_A" ;
lin couture_N = mkTerm "couture_N" ;
lin couturier_N = mkTerm "couturier_N" ;
lin couvade_N = mkTerm "couvade_N" ;
lin couverture_N = mkTerm "couverture_N" ;
lin covalence_N = mkTerm "covalence_N" ;
lin covalent_A = mkTerm "covalent_A" ;
lin covariance_N = mkTerm "covariance_N" ;
lin covariant_A = mkTerm "covariant_A" ;
lin covariation_N = mkTerm "covariation_N" ;
lin cove_N = mkTerm "cove_N" ;
lin coven_N = mkTerm "coven_N" ;
lin covenant_N = mkTerm "covenant_N" ;
lin covenant_V = mkTerm "covenant_V" ;
lin covenant_V2 = mkTerm "covenant_V2" ;
lin coventry_PN = mkTerm "coventry_PN" ;
lin cover_N = mkTerm "cover_N" ;
lin cover_V2 = mkTerm "cover_V2" ;
lin cover_for_V2 = mkTerm "cover_for_V2" ;
lin cover_up_N = mkTerm "cover_up_N" ;
lin cover_up_V2 = mkTerm "cover_up_V2" ;
lin coverage_N = mkTerm "coverage_N" ;
lin coverall_N = mkTerm "coverall_N" ;
lin covering_A = mkTerm "covering_A" ;
lin covering_N = mkTerm "covering_N" ;
lin coverlet_N = mkTerm "coverlet_N" ;
lin covert_A = mkTerm "covert_A" ;
lin covert_N = mkTerm "covert_N" ;
lin covet_V2 = mkTerm "covet_V2" ;
lin covetous_A = mkTerm "covetous_A" ;
lin covetousness_N = mkTerm "covetousness_N" ;
lin covey_N = mkTerm "covey_N" ;
lin cow_N = mkTerm "cow_N" ;
lin cow_V2 = mkTerm "cow_V2" ;
lin cowage_N = mkTerm "cowage_N" ;
lin coward_N = mkTerm "coward_N" ;
lin cowardice_N = mkTerm "cowardice_N" ;
lin cowardly_A = mkTerm "cowardly_A" ;
lin cowbarn_N = mkTerm "cowbarn_N" ;
lin cowbell_N = mkTerm "cowbell_N" ;
lin cowberry_N = mkTerm "cowberry_N" ;
lin cowbird_N = mkTerm "cowbird_N" ;
lin cowboy_N = mkTerm "cowboy_N" ;
lin cowcatcher_N = mkTerm "cowcatcher_N" ;
lin cowdenbeath_PN = mkTerm "cowdenbeath_PN" ;
lin cower_V = mkTerm "cower_V" ;
lin cowes_PN = mkTerm "cowes_PN" ;
lin cowfish_N = mkTerm "cowfish_N" ;
lin cowgirl_N = mkTerm "cowgirl_N" ;
lin cowhand_N = mkTerm "cowhand_N" ;
lin cowherb_N = mkTerm "cowherb_N" ;
lin cowherd_N = mkTerm "cowherd_N" ;
lin cowhide_N = mkTerm "cowhide_N" ;
lin cowhouse_N = mkTerm "cowhouse_N" ;
lin cowl_N = mkTerm "cowl_N" ;
lin cowled_A = mkTerm "cowled_A" ;
lin cowlick_N = mkTerm "cowlick_N" ;
lin cowling_N = mkTerm "cowling_N" ;
lin cowman_N = mkTerm "cowman_N" ;
lin coworker_N = mkTerm "coworker_N" ;
lin cowpea_N = mkTerm "cowpea_N" ;
lin cowpox_N = mkTerm "cowpox_N" ;
lin cowrie_N = mkTerm "cowrie_N" ;
lin cowshed_N = mkTerm "cowshed_N" ;
lin cowskin_N = mkTerm "cowskin_N" ;
lin cowslip_N = mkTerm "cowslip_N" ;
lin cox_N = mkTerm "cox_N" ;
lin cox_V = mkTerm "cox_V" ;
lin cox_V2 = mkTerm "cox_V2" ;
lin coxcomb_N = mkTerm "coxcomb_N" ;
lin coxsackievirus_N = mkTerm "coxsackievirus_N" ;
lin coxswain_N = mkTerm "coxswain_N" ;
lin coy_A = mkTerm "coy_A" ;
lin coydog_N = mkTerm "coydog_N" ;
lin coyness_N = mkTerm "coyness_N" ;
lin coyol_N = mkTerm "coyol_N" ;
lin coyote_N = mkTerm "coyote_N" ;
lin coypu_N = mkTerm "coypu_N" ;
lin cozen_V2 = mkTerm "cozen_V2" ;
lin coziness_N = mkTerm "coziness_N" ;
lin cozy_A = mkTerm "cozy_A" ;
lin cozy_up_V = mkTerm "cozy_up_V" ;
lin cozy_up_to_V2 = mkTerm "cozy_up_to_V2" ;
lin cp_PN = mkTerm "cp_PN" ;
lin cpl_PN = mkTerm "cpl_PN" ;
lin crab_N = mkTerm "crab_N" ;
lin crab_V = mkTerm "crab_V" ;
lin crab_V2 = mkTerm "crab_V2" ;
lin crab_apple_N = mkTerm "crab_apple_N" ;
lin crabbiness_N = mkTerm "crabbiness_N" ;
lin crabgrass_N = mkTerm "crabgrass_N" ;
lin crabwise_A = mkTerm "crabwise_A" ;
lin crack_N = mkTerm "crack_N" ;
lin crack_V2 = mkTerm "crack_V2" ;
lin crack_down_N = mkTerm "crack_down_N" ;
lin crack_down_V = mkTerm "crack_down_V" ;
lin crack_down_on_V2 = mkTerm "crack_down_on_V2" ;
lin crack_on_V = mkTerm "crack_on_V" ;
lin crack_up_N = mkTerm "crack_up_N" ;
lin crack_up_V = mkTerm "crack_up_V" ;
lin crack_up_V2 = mkTerm "crack_up_V2" ;
lin crack_up_at_V2 = mkTerm "crack_up_at_V2" ;
lin crackbrained_A = mkTerm "crackbrained_A" ;
lin cracker_N = mkTerm "cracker_N" ;
lin crackers_A = mkTerm "crackers_A" ;
lin cracking_N = mkTerm "cracking_N" ;
lin crackle_A = mkTerm "crackle_A" ;
lin crackle_N = mkTerm "crackle_N" ;
lin crackle_V = mkTerm "crackle_V" ;
lin crackle_china_N = mkTerm "crackle_china_N" ;
lin crackleware_N = mkTerm "crackleware_N" ;
lin crackling_N = mkTerm "crackling_N" ;
lin cracklings_N = mkTerm "cracklings_N" ;
lin crackpot_N = mkTerm "crackpot_N" ;
lin cracksman_N = mkTerm "cracksman_N" ;
lin cradle_N = mkTerm "cradle_N" ;
lin cradle_V2 = mkTerm "cradle_V2" ;
lin craft_N = mkTerm "craft_N" ;
lin craft_V2 = mkTerm "craft_V2" ;
lin craftiness_N = mkTerm "craftiness_N" ;
lin craftsman_N = mkTerm "craftsman_N" ;
lin craftsmanship_N = mkTerm "craftsmanship_N" ;
lin crafty_A = mkTerm "crafty_A" ;
lin crag_N = mkTerm "crag_N" ;
lin cragfast_A = mkTerm "cragfast_A" ;
lin cragged_A = mkTerm "cragged_A" ;
lin craggy_A = mkTerm "craggy_A" ;
lin cragsman_N = mkTerm "cragsman_N" ;
lin crake_N = mkTerm "crake_N" ;
lin cram_V = mkTerm "cram_V" ;
lin cram_V2 = mkTerm "cram_V2" ;
lin cram_full_A = mkTerm "cram_full_A" ;
lin cram_full_Adv = mkTerm "cram_full_Adv" ;
lin cram_in_V = mkTerm "cram_in_V" ;
lin cramlington_PN = mkTerm "cramlington_PN" ;
lin crammer_N = mkTerm "crammer_N" ;
lin cramp_N = mkTerm "cramp_N" ;
lin cramp_V2 = mkTerm "cramp_V2" ;
lin cramp_iron_N = mkTerm "cramp_iron_N" ;
lin crampon_N = mkTerm "crampon_N" ;
lin cran_N = mkTerm "cran_N" ;
lin cranberry_N = mkTerm "cranberry_N" ;
lin crane_N = mkTerm "crane_N" ;
lin crane_V = mkTerm "crane_V" ;
lin crane_V2 = mkTerm "crane_V2" ;
lin crane_fly_N = mkTerm "crane_fly_N" ;
lin cranesbill_N = mkTerm "cranesbill_N" ;
lin cranial_A = mkTerm "cranial_A" ;
lin craniology_N = mkTerm "craniology_N" ;
lin craniometer_N = mkTerm "craniometer_N" ;
lin craniometric_A = mkTerm "craniometric_A" ;
lin craniometry_N = mkTerm "craniometry_N" ;
lin craniotomy_N = mkTerm "craniotomy_N" ;
lin cranium_N = mkTerm "cranium_N" ;
lin crank_A = mkTerm "crank_A" ;
lin crank_N = mkTerm "crank_N" ;
lin crank_V2 = mkTerm "crank_V2" ;
lin crank_out_V = mkTerm "crank_out_V" ;
lin crank_up_V2 = mkTerm "crank_up_V2" ;
lin crankcase_N = mkTerm "crankcase_N" ;
lin crankiness_N = mkTerm "crankiness_N" ;
lin crankshaft_N = mkTerm "crankshaft_N" ;
lin cranky_A = mkTerm "cranky_A" ;
lin crannied_A = mkTerm "crannied_A" ;
lin cranny_N = mkTerm "cranny_N" ;
lin crap_N = mkTerm "crap_N" ;
lin crap_V = mkTerm "crap_V" ;
lin crap_shooting_N = mkTerm "crap_shooting_N" ;
lin crapaud_N = mkTerm "crapaud_N" ;
lin crape_N = mkTerm "crape_N" ;
lin crappie_N = mkTerm "crappie_N" ;
lin craps_N = mkTerm "craps_N" ;
lin crapshoot_N = mkTerm "crapshoot_N" ;
lin crapshooter_N = mkTerm "crapshooter_N" ;
lin crapulent_A = mkTerm "crapulent_A" ;
lin crapulous_A = mkTerm "crapulous_A" ;
lin crash_Adv = mkTerm "crash_Adv" ;
lin crash_N = mkTerm "crash_N" ;
lin crash_V = mkTerm "crash_V" ;
lin crash_dive_N = mkTerm "crash_dive_N" ;
lin crash_dive_V = mkTerm "crash_dive_V" ;
lin crash_helmet_N = mkTerm "crash_helmet_N" ;
lin crash_land_V = mkTerm "crash_land_V" ;
lin crash_land_V2 = mkTerm "crash_land_V2" ;
lin crash_landing_N = mkTerm "crash_landing_N" ;
lin crash_out_V = mkTerm "crash_out_V" ;
lin crass_A = mkTerm "crass_A" ;
lin crassness_N = mkTerm "crassness_N" ;
lin crate_N = mkTerm "crate_N" ;
lin crate_V2 = mkTerm "crate_V2" ;
lin crater_N = mkTerm "crater_N" ;
lin crater_V = mkTerm "crater_V" ;
lin craton_N = mkTerm "craton_N" ;
lin cravat_N = mkTerm "cravat_N" ;
lin crave_V = mkTerm "crave_V" ;
lin crave_V2 = mkTerm "crave_V2" ;
lin craven_A = mkTerm "craven_A" ;
lin craven_N = mkTerm "craven_N" ;
lin cravenness_N = mkTerm "cravenness_N" ;
lin craving_N = mkTerm "craving_N" ;
lin craw_N = mkTerm "craw_N" ;
lin crawfish_N = mkTerm "crawfish_N" ;
lin crawl_N = mkTerm "crawl_N" ;
lin crawl_V = mkTerm "crawl_V" ;
lin crawler_N = mkTerm "crawler_N" ;
lin crawley_PN = mkTerm "crawley_PN" ;
lin crawlspace_N = mkTerm "crawlspace_N" ;
lin crayfish_N = mkTerm "crayfish_N" ;
lin crayon_N = mkTerm "crayon_N" ;
lin crayon_V2 = mkTerm "crayon_V2" ;
lin craze_N = mkTerm "craze_N" ;
lin crazed_A = mkTerm "crazed_A" ;
lin craziness_N = mkTerm "craziness_N" ;
lin crazy_A = mkTerm "crazy_A" ;
lin crazy_N = mkTerm "crazy_N" ;
lin creak_N = mkTerm "creak_N" ;
lin creak_V = mkTerm "creak_V" ;
lin creaky_A = mkTerm "creaky_A" ;
lin cream_N = mkTerm "cream_N" ;
lin cream_V2 = mkTerm "cream_V2" ;
lin cream_off_V2 = mkTerm "cream_off_V2" ;
lin creamcups_N = mkTerm "creamcups_N" ;
lin creamery_N = mkTerm "creamery_N" ;
lin creaminess_N = mkTerm "creaminess_N" ;
lin creamy_A = mkTerm "creamy_A" ;
lin crease_N = mkTerm "crease_N" ;
lin crease_V = mkTerm "crease_V" ;
lin crease_V2 = mkTerm "crease_V2" ;
lin creaseless_A = mkTerm "creaseless_A" ;
lin creaseproof_A = mkTerm "creaseproof_A" ;
lin create_V = mkTerm "create_V" ;
lin create_V2 = mkTerm "create_V2" ;
lin creatine_N = mkTerm "creatine_N" ;
lin creation_N = mkTerm "creation_N" ;
lin creationism_N = mkTerm "creationism_N" ;
lin creative_A = mkTerm "creative_A" ;
lin creativeness_N = mkTerm "creativeness_N" ;
lin creativity_N = mkTerm "creativity_N" ;
lin creator_N = mkTerm "creator_N" ;
lin creature_N = mkTerm "creature_N" ;
lin creche_N = mkTerm "creche_N" ;
lin credence_N = mkTerm "credence_N" ;
lin credentialled_A = mkTerm "credentialled_A" ;
lin credenza_N = mkTerm "credenza_N" ;
lin credibility_N = mkTerm "credibility_N" ;
lin credible_A = mkTerm "credible_A" ;
lin credit_N = mkTerm "credit_N" ;
lin credit_V2 = mkTerm "credit_V2" ;
lin credit_side_N = mkTerm "credit_side_N" ;
lin credit_worthiness_N = mkTerm "credit_worthiness_N" ;
lin credit_worthy_A = mkTerm "credit_worthy_A" ;
lin creditable_A = mkTerm "creditable_A" ;
lin creditor_N = mkTerm "creditor_N" ;
lin credits_N = mkTerm "credits_N" ;
lin credo_N = mkTerm "credo_N" ;
lin credulity_N = mkTerm "credulity_N" ;
lin credulous_A = mkTerm "credulous_A" ;
lin credulousness_N = mkTerm "credulousness_N" ;
lin creed_N = mkTerm "creed_N" ;
lin creedal_A = mkTerm "creedal_A" ;
lin creek_N = mkTerm "creek_N" ;
lin creel_N = mkTerm "creel_N" ;
lin creep_N = mkTerm "creep_N" ;
lin creep_V = mkTerm "creep_V" ;
lin creep_in_V = mkTerm "creep_in_V" ;
lin creep_into_V2 = mkTerm "creep_into_V2" ;
lin creep_out_V2 = mkTerm "creep_out_V2" ;
lin creep_out_on_V2 = mkTerm "creep_out_on_V2" ;
lin creep_over_V2 = mkTerm "creep_over_V2" ;
lin creep_up_V = mkTerm "creep_up_V" ;
lin creep_up_on_V2 = mkTerm "creep_up_on_V2" ;
lin creeper_N = mkTerm "creeper_N" ;
lin creepiness_N = mkTerm "creepiness_N" ;
lin creeps_N = mkTerm "creeps_N" ;
lin creepy_A = mkTerm "creepy_A" ;
lin cremains_N = mkTerm "cremains_N" ;
lin cremate_V2 = mkTerm "cremate_V2" ;
lin cremation_N = mkTerm "cremation_N" ;
lin crematorium_N = mkTerm "crematorium_N" ;
lin crematory_N = mkTerm "crematory_N" ;
lin creme_de_menthe_N = mkTerm "creme_de_menthe_N" ;
lin crenate_A = mkTerm "crenate_A" ;
lin crenel_N = mkTerm "crenel_N" ;
lin crenelation_N = mkTerm "crenelation_N" ;
lin crenellated_A = mkTerm "crenellated_A" ;
lin crenulate_A = mkTerm "crenulate_A" ;
lin creole_A = mkTerm "creole_A" ;
lin creole_N = mkTerm "creole_N" ;
lin creosol_N = mkTerm "creosol_N" ;
lin creosote_N = mkTerm "creosote_N" ;
lin crepe_1_N = mkTerm "crepe_1_N" ;
lin crepe_2_N = mkTerm "crepe_2_N" ;
lin crepitate_V = mkTerm "crepitate_V" ;
lin crepitation_N = mkTerm "crepitation_N" ;
lin crepuscular_A = mkTerm "crepuscular_A" ;
lin cres_PN = mkTerm "cres_PN" ;
lin crescendo_A = mkTerm "crescendo_A" ;
lin crescendo_N = mkTerm "crescendo_N" ;
lin crescent_N = mkTerm "crescent_N" ;
lin cresol_N = mkTerm "cresol_N" ;
lin cress_N = mkTerm "cress_N" ;
lin crest_N = mkTerm "crest_N" ;
lin crest_V = mkTerm "crest_V" ;
lin crest_V2 = mkTerm "crest_V2" ;
lin crestfallen_A = mkTerm "crestfallen_A" ;
lin creswell_PN = mkTerm "creswell_PN" ;
lin cretaceous_A = mkTerm "cretaceous_A" ;
lin cretin_N = mkTerm "cretin_N" ;
lin cretinism_N = mkTerm "cretinism_N" ;
lin cretinous_A = mkTerm "cretinous_A" ;
lin cretonne_N = mkTerm "cretonne_N" ;
lin crevasse_N = mkTerm "crevasse_N" ;
lin crevice_N = mkTerm "crevice_N" ;
lin crew_N = mkTerm "crew_N" ;
lin crew_V = mkTerm "crew_V" ;
lin crew_cut_N = mkTerm "crew_cut_N" ;
lin crew_neck_N = mkTerm "crew_neck_N" ;
lin crewe_PN = mkTerm "crewe_PN" ;
lin crewelwork_N = mkTerm "crewelwork_N" ;
lin crewman_N = mkTerm "crewman_N" ;
lin crib_N = mkTerm "crib_N" ;
lin crib_V = mkTerm "crib_V" ;
lin crib_V2 = mkTerm "crib_V2" ;
lin cribbage_N = mkTerm "cribbage_N" ;
lin cribbage_board_N = mkTerm "cribbage_board_N" ;
lin crick_N = mkTerm "crick_N" ;
lin crick_V2 = mkTerm "crick_V2" ;
lin cricket_N = mkTerm "cricket_N" ;
lin cricketer_N = mkTerm "cricketer_N" ;
lin crieff_PN = mkTerm "crieff_PN" ;
lin crier_N = mkTerm "crier_N" ;
lin crime_N = mkTerm "crime_N" ;
lin crime_V2 = mkTerm "crime_V2" ;
lin criminal_A = mkTerm "criminal_A" ;
lin criminal_N = mkTerm "criminal_N" ;
lin criminalism_N = mkTerm "criminalism_N" ;
lin criminalization_N = mkTerm "criminalization_N" ;
lin criminalize_V2 = mkTerm "criminalize_V2" ;
lin criminative_A = mkTerm "criminative_A" ;
lin criminological_A = mkTerm "criminological_A" ;
lin criminologist_N = mkTerm "criminologist_N" ;
lin criminology_N = mkTerm "criminology_N" ;
lin crimp_N = mkTerm "crimp_N" ;
lin crimp_V2 = mkTerm "crimp_V2" ;
lin crimson_A = mkTerm "crimson_A" ;
lin crimson_N = mkTerm "crimson_N" ;
lin crimson_V = mkTerm "crimson_V" ;
lin crimson_V2 = mkTerm "crimson_V2" ;
lin cringe_V = mkTerm "cringe_V" ;
lin cringle_N = mkTerm "cringle_N" ;
lin crinkle_N = mkTerm "crinkle_N" ;
lin crinkle_V = mkTerm "crinkle_V" ;
lin crinkle_V2 = mkTerm "crinkle_V2" ;
lin crinkleroot_N = mkTerm "crinkleroot_N" ;
lin crinkly_A = mkTerm "crinkly_A" ;
lin crinoid_A = mkTerm "crinoid_A" ;
lin crinoid_N = mkTerm "crinoid_N" ;
lin crinoline_N = mkTerm "crinoline_N" ;
lin criollo_N = mkTerm "criollo_N" ;
lin cripple_N = mkTerm "cripple_N" ;
lin cripple_V2 = mkTerm "cripple_V2" ;
lin crippling_A = mkTerm "crippling_A" ;
lin crisis_N = mkTerm "crisis_N" ;
lin crisp_A = mkTerm "crisp_A" ;
lin crisp_N = mkTerm "crisp_N" ;
lin crisp_V = mkTerm "crisp_V" ;
lin crisp_V2 = mkTerm "crisp_V2" ;
lin crispate_A = mkTerm "crispate_A" ;
lin crispness_N = mkTerm "crispness_N" ;
lin criss_cross_V2 = mkTerm "criss_cross_V2" ;
lin crisscross_A = mkTerm "crisscross_A" ;
lin crisscross_Adv = mkTerm "crisscross_Adv" ;
lin crisscross_N = mkTerm "crisscross_N" ;
lin crisscross_V = mkTerm "crisscross_V" ;
lin cristobalite_N = mkTerm "cristobalite_N" ;
lin criterial_A = mkTerm "criterial_A" ;
lin criterion_N = mkTerm "criterion_N" ;
lin crith_N = mkTerm "crith_N" ;
lin critic_N = mkTerm "critic_N" ;
lin critical_1_A = mkTerm "critical_1_A" ;
lin critical_2_A = mkTerm "critical_2_A" ;
lin criticality_N = mkTerm "criticality_N" ;
lin criticism_N = mkTerm "criticism_N" ;
lin criticize_V = mkTerm "criticize_V" ;
lin criticize_V2 = mkTerm "criticize_V2" ;
lin critique_N = mkTerm "critique_N" ;
lin critter_N = mkTerm "critter_N" ;
lin croak_N = mkTerm "croak_N" ;
lin croak_V = mkTerm "croak_V" ;
lin croak_V2 = mkTerm "croak_V2" ;
lin croaker_N = mkTerm "croaker_N" ;
lin croaky_A = mkTerm "croaky_A" ;
lin crochet_N = mkTerm "crochet_N" ;
lin crochet_V = mkTerm "crochet_V" ;
lin crochet_V2 = mkTerm "crochet_V2" ;
lin crochet_hook_N = mkTerm "crochet_hook_N" ;
lin crocheting_N = mkTerm "crocheting_N" ;
lin crock_N = mkTerm "crock_N" ;
lin crock_V = mkTerm "crock_V" ;
lin crock_V2 = mkTerm "crock_V2" ;
lin crockery_N = mkTerm "crockery_N" ;
lin crocket_N = mkTerm "crocket_N" ;
lin crocketed_A = mkTerm "crocketed_A" ;
lin crocodile_N = mkTerm "crocodile_N" ;
lin crocolite_N = mkTerm "crocolite_N" ;
lin crocus_N = mkTerm "crocus_N" ;
lin croesus_PN = mkTerm "croesus_PN" ;
lin croft_N = mkTerm "croft_N" ;
lin crofter_N = mkTerm "crofter_N" ;
lin cromer_PN = mkTerm "cromer_PN" ;
lin cromlech_N = mkTerm "cromlech_N" ;
lin crone_N = mkTerm "crone_N" ;
lin crony_N = mkTerm "crony_N" ;
lin cronyism_N = mkTerm "cronyism_N" ;
lin crook_N = mkTerm "crook_N" ;
lin crook_PN = mkTerm "crook_PN" ;
lin crook_V = mkTerm "crook_V" ;
lin crook_V2 = mkTerm "crook_V2" ;
lin crook_back_A = mkTerm "crook_back_A" ;
lin crook_backed_A = mkTerm "crook_backed_A" ;
lin crooked_A = mkTerm "crooked_A" ;
lin crookedness_N = mkTerm "crookedness_N" ;
lin crookneck_N = mkTerm "crookneck_N" ;
lin croon_V = mkTerm "croon_V" ;
lin croon_V2 = mkTerm "croon_V2" ;
lin crooner_N = mkTerm "crooner_N" ;
lin crooning_N = mkTerm "crooning_N" ;
lin crop_N = mkTerm "crop_N" ;
lin crop_V = mkTerm "crop_V" ;
lin crop_V2 = mkTerm "crop_V2" ;
lin crop_dusting_N = mkTerm "crop_dusting_N" ;
lin crop_up_V = mkTerm "crop_up_V" ;
lin cropper_N = mkTerm "cropper_N" ;
lin croquet_N = mkTerm "croquet_N" ;
lin croquette_N = mkTerm "croquette_N" ;
lin crore_N = mkTerm "crore_N" ;
lin crosby_PN = mkTerm "crosby_PN" ;
lin crosier_N = mkTerm "crosier_N" ;
lin cross_A = mkTerm "cross_A" ;
lin cross_N = mkTerm "cross_N" ;
lin cross_V = mkTerm "cross_V" ;
lin cross_V2 = mkTerm "cross_V2" ;
lin cross_bench_N = mkTerm "cross_bench_N" ;
lin cross_bencher_N = mkTerm "cross_bencher_N" ;
lin cross_division_N = mkTerm "cross_division_N" ;
lin cross_examination_N = mkTerm "cross_examination_N" ;
lin cross_examine_V2 = mkTerm "cross_examine_V2" ;
lin cross_examiner_N = mkTerm "cross_examiner_N" ;
lin cross_fertilization_N = mkTerm "cross_fertilization_N" ;
lin cross_fertilize_V2 = mkTerm "cross_fertilize_V2" ;
lin cross_grained_A = mkTerm "cross_grained_A" ;
lin cross_heading_N = mkTerm "cross_heading_N" ;
lin cross_index_N = mkTerm "cross_index_N" ;
lin cross_index_V2 = mkTerm "cross_index_V2" ;
lin cross_legged_Adv = mkTerm "cross_legged_Adv" ;
lin cross_off_V2 = mkTerm "cross_off_V2" ;
lin cross_out_V2 = mkTerm "cross_out_V2" ;
lin cross_question_V2 = mkTerm "cross_question_V2" ;
lin cross_reference_N = mkTerm "cross_reference_N" ;
lin cross_section_N = mkTerm "cross_section_N" ;
lin cross_stitch_N = mkTerm "cross_stitch_N" ;
lin cross_up_V2 = mkTerm "cross_up_V2" ;
lin crossbar_N = mkTerm "crossbar_N" ;
lin crossbeam_N = mkTerm "crossbeam_N" ;
lin crossbill_N = mkTerm "crossbill_N" ;
lin crossbones_N = mkTerm "crossbones_N" ;
lin crossbow_N = mkTerm "crossbow_N" ;
lin crossbreed_N = mkTerm "crossbreed_N" ;
lin crossbreed_V2 = mkTerm "crossbreed_V2" ;
lin crosscheck_N = mkTerm "crosscheck_N" ;
lin crosscheck_V = mkTerm "crosscheck_V" ;
lin crosscheck_V2 = mkTerm "crosscheck_V2" ;
lin crosscountry_A = mkTerm "crosscountry_A" ;
lin crosscountry_Adv = mkTerm "crosscountry_Adv" ;
lin crosscurrent_N = mkTerm "crosscurrent_N" ;
lin crosscut_A = mkTerm "crosscut_A" ;
lin crosscut_N = mkTerm "crosscut_N" ;
lin crosse_N = mkTerm "crosse_N" ;
lin crosseyed_A = mkTerm "crosseyed_A" ;
lin crossfire_N = mkTerm "crossfire_N" ;
lin crosshairs_N = mkTerm "crosshairs_N" ;
lin crosshead_N = mkTerm "crosshead_N" ;
lin crossing_N = mkTerm "crossing_N" ;
lin crossjack_N = mkTerm "crossjack_N" ;
lin crossness_N = mkTerm "crossness_N" ;
lin crossopterygian_N = mkTerm "crossopterygian_N" ;
lin crossover_N = mkTerm "crossover_N" ;
lin crosspatch_N = mkTerm "crosspatch_N" ;
lin crosspiece_N = mkTerm "crosspiece_N" ;
lin crossroad_N = mkTerm "crossroad_N" ;
lin crossroads_N = mkTerm "crossroads_N" ;
lin crosstalk_N = mkTerm "crosstalk_N" ;
lin crosstown_A = mkTerm "crosstown_A" ;
lin crosstown_Adv = mkTerm "crosstown_Adv" ;
lin crosswalk_N = mkTerm "crosswalk_N" ;
lin crosswind_N = mkTerm "crosswind_N" ;
lin crosswise_A = mkTerm "crosswise_A" ;
lin crosswise_Adv = mkTerm "crosswise_Adv" ;
lin crossword_N = mkTerm "crossword_N" ;
lin crotalaria_N = mkTerm "crotalaria_N" ;
lin crotaphion_N = mkTerm "crotaphion_N" ;
lin crotch_N = mkTerm "crotch_N" ;
lin crotchet_N = mkTerm "crotchet_N" ;
lin crotchety_A = mkTerm "crotchety_A" ;
lin croton_N = mkTerm "croton_N" ;
lin crottle_N = mkTerm "crottle_N" ;
lin crouch_N = mkTerm "crouch_N" ;
lin crouch_V = mkTerm "crouch_V" ;
lin croup_N = mkTerm "croup_N" ;
lin croupier_N = mkTerm "croupier_N" ;
lin croupy_A = mkTerm "croupy_A" ;
lin crouton_N = mkTerm "crouton_N" ;
lin crow's_nest_N = mkTerm "crow's_nest_N" ;
lin crow_N = mkTerm "crow_N" ;
lin crow_V = mkTerm "crow_V" ;
lin crow_VS = mkTerm "crow_VS" ;
lin crowbait_N = mkTerm "crowbait_N" ;
lin crowbar_N = mkTerm "crowbar_N" ;
lin crowberry_N = mkTerm "crowberry_N" ;
lin crowborough_PN = mkTerm "crowborough_PN" ;
lin crowd_N = mkTerm "crowd_N" ;
lin crowd_V = mkTerm "crowd_V" ;
lin crowd_V2 = mkTerm "crowd_V2" ;
lin crowded_A = mkTerm "crowded_A" ;
lin crowding_N = mkTerm "crowding_N" ;
lin crown_N = mkTerm "crown_N" ;
lin crown_V2 = mkTerm "crown_V2" ;
lin crown_land_N = mkTerm "crown_land_N" ;
lin crownbeard_N = mkTerm "crownbeard_N" ;
lin crowning_A = mkTerm "crowning_A" ;
lin crowthorne_PN = mkTerm "crowthorne_PN" ;
lin croydon_PN = mkTerm "croydon_PN" ;
lin crozier_N = mkTerm "crozier_N" ;
lin crucial_A = mkTerm "crucial_A" ;
lin cruciate_A = mkTerm "cruciate_A" ;
lin crucible_N = mkTerm "crucible_N" ;
lin crucifer_N = mkTerm "crucifer_N" ;
lin cruciferous_A = mkTerm "cruciferous_A" ;
lin crucifix_N = mkTerm "crucifix_N" ;
lin crucifixion_N = mkTerm "crucifixion_N" ;
lin cruciform_A = mkTerm "cruciform_A" ;
lin crucify_V2 = mkTerm "crucify_V2" ;
lin crud_N = mkTerm "crud_N" ;
lin cruddy_A = mkTerm "cruddy_A" ;
lin crude_A = mkTerm "crude_A" ;
lin crudeness_N = mkTerm "crudeness_N" ;
lin crudites_N = mkTerm "crudites_N" ;
lin crudity_N = mkTerm "crudity_N" ;
lin cruel_A = mkTerm "cruel_A" ;
lin cruelty_N = mkTerm "cruelty_N" ;
lin cruet_N = mkTerm "cruet_N" ;
lin cruet_stand_N = mkTerm "cruet_stand_N" ;
lin cruise_N = mkTerm "cruise_N" ;
lin cruise_V = mkTerm "cruise_V" ;
lin cruise_through_V2 = mkTerm "cruise_through_V2" ;
lin cruiser_N = mkTerm "cruiser_N" ;
lin cruller_N = mkTerm "cruller_N" ;
lin crumb_N = mkTerm "crumb_N" ;
lin crumb_down_V = mkTerm "crumb_down_V" ;
lin crumble_V = mkTerm "crumble_V" ;
lin crumble_V2 = mkTerm "crumble_V2" ;
lin crumbliness_N = mkTerm "crumbliness_N" ;
lin crumbly_A = mkTerm "crumbly_A" ;
lin crumpet_N = mkTerm "crumpet_N" ;
lin crumple_V = mkTerm "crumple_V" ;
lin crumple_V2 = mkTerm "crumple_V2" ;
lin crunch_N = mkTerm "crunch_N" ;
lin crunch_V = mkTerm "crunch_V" ;
lin crunch_V2 = mkTerm "crunch_V2" ;
lin crupper_N = mkTerm "crupper_N" ;
lin crural_A = mkTerm "crural_A" ;
lin crus_N = mkTerm "crus_N" ;
lin crusade_N = mkTerm "crusade_N" ;
lin crusade_V = mkTerm "crusade_V" ;
lin crusader_N = mkTerm "crusader_N" ;
lin cruse_N = mkTerm "cruse_N" ;
lin crush_N = mkTerm "crush_N" ;
lin crush_V = mkTerm "crush_V" ;
lin crush_V2 = mkTerm "crush_V2" ;
lin crusher_N = mkTerm "crusher_N" ;
lin crushingly_Adv = mkTerm "crushingly_Adv" ;
lin crust_N = mkTerm "crust_N" ;
lin crust_V = mkTerm "crust_V" ;
lin crust_V2 = mkTerm "crust_V2" ;
lin crustacean_N = mkTerm "crustacean_N" ;
lin crustaceous_A = mkTerm "crustaceous_A" ;
lin crustal_A = mkTerm "crustal_A" ;
lin crustose_A = mkTerm "crustose_A" ;
lin crusty_A = mkTerm "crusty_A" ;
lin crutch_N = mkTerm "crutch_N" ;
lin crux_N = mkTerm "crux_N" ;
lin cruzeiro_N = mkTerm "cruzeiro_N" ;
lin cry_N = mkTerm "cry_N" ;
lin cry_V = mkTerm "cry_V" ;
lin cry_V2 = mkTerm "cry_V2" ;
lin cry_off_V2 = mkTerm "cry_off_V2" ;
lin cry_out_V = mkTerm "cry_out_V" ;
lin crybaby_N = mkTerm "crybaby_N" ;
lin cryesthesia_N = mkTerm "cryesthesia_N" ;
lin crying_N = mkTerm "crying_N" ;
lin cryoanesthesia_N = mkTerm "cryoanesthesia_N" ;
lin cryobiology_N = mkTerm "cryobiology_N" ;
lin cryocautery_N = mkTerm "cryocautery_N" ;
lin cryogen_N = mkTerm "cryogen_N" ;
lin cryogenic_A = mkTerm "cryogenic_A" ;
lin cryogenics_N = mkTerm "cryogenics_N" ;
lin cryolite_N = mkTerm "cryolite_N" ;
lin cryometer_N = mkTerm "cryometer_N" ;
lin cryonic_A = mkTerm "cryonic_A" ;
lin cryonics_N = mkTerm "cryonics_N" ;
lin cryophobia_N = mkTerm "cryophobia_N" ;
lin cryoscope_N = mkTerm "cryoscope_N" ;
lin cryostat_N = mkTerm "cryostat_N" ;
lin cryosurgery_N = mkTerm "cryosurgery_N" ;
lin crypt_N = mkTerm "crypt_N" ;
lin cryptanalysis_N = mkTerm "cryptanalysis_N" ;
lin cryptanalyst_N = mkTerm "cryptanalyst_N" ;
lin cryptanalytic_A = mkTerm "cryptanalytic_A" ;
lin cryptic_A = mkTerm "cryptic_A" ;
lin cryptobiosis_N = mkTerm "cryptobiosis_N" ;
lin cryptobiotic_A = mkTerm "cryptobiotic_A" ;
lin cryptococcosis_N = mkTerm "cryptococcosis_N" ;
lin cryptocoryne_N = mkTerm "cryptocoryne_N" ;
lin cryptogam_N = mkTerm "cryptogam_N" ;
lin cryptogamic_A = mkTerm "cryptogamic_A" ;
lin cryptogram_N = mkTerm "cryptogram_N" ;
lin cryptograph_N = mkTerm "cryptograph_N" ;
lin cryptographic_A = mkTerm "cryptographic_A" ;
lin cryptography_N = mkTerm "cryptography_N" ;
lin cryptomonad_N = mkTerm "cryptomonad_N" ;
lin cryptorchidy_N = mkTerm "cryptorchidy_N" ;
lin crystal_N = mkTerm "crystal_N" ;
lin crystal_gazing_N = mkTerm "crystal_gazing_N" ;
lin crystalline_A = mkTerm "crystalline_A" ;
lin crystallite_N = mkTerm "crystallite_N" ;
lin crystallization_N = mkTerm "crystallization_N" ;
lin crystallize_V = mkTerm "crystallize_V" ;
lin crystallize_V2 = mkTerm "crystallize_V2" ;
lin crystallographer_N = mkTerm "crystallographer_N" ;
lin crystallography_N = mkTerm "crystallography_N" ;
lin ctene_N = mkTerm "ctene_N" ;
lin ctenidium_N = mkTerm "ctenidium_N" ;
lin ctenoid_A = mkTerm "ctenoid_A" ;
lin ctenophore_N = mkTerm "ctenophore_N" ;
lin cub_N = mkTerm "cub_N" ;
lin cuba_PN = mkTerm "cuba_PN" ;
lin cuban_A = mkTerm "cuban_A" ;
lin cuban_N = mkTerm "cuban_N" ;
lin cubby_N = mkTerm "cubby_N" ;
lin cubbyhole_N = mkTerm "cubbyhole_N" ;
lin cube_N = mkTerm "cube_N" ;
lin cube_V2 = mkTerm "cube_V2" ;
lin cubeb_N = mkTerm "cubeb_N" ;
lin cubelike_A = mkTerm "cubelike_A" ;
lin cubic_A = mkTerm "cubic_A" ;
lin cubical_A = mkTerm "cubical_A" ;
lin cubicity_N = mkTerm "cubicity_N" ;
lin cubicle_N = mkTerm "cubicle_N" ;
lin cubism_N = mkTerm "cubism_N" ;
lin cubist_A = mkTerm "cubist_A" ;
lin cubist_N = mkTerm "cubist_N" ;
lin cubit_N = mkTerm "cubit_N" ;
lin cubital_A = mkTerm "cubital_A" ;
lin cubitiere_N = mkTerm "cubitiere_N" ;
lin cubitus_N = mkTerm "cubitus_N" ;
lin cuboid_N = mkTerm "cuboid_N" ;
lin cuckold_N = mkTerm "cuckold_N" ;
lin cuckold_V2 = mkTerm "cuckold_V2" ;
lin cuckoldom_N = mkTerm "cuckoldom_N" ;
lin cuckoldry_N = mkTerm "cuckoldry_N" ;
lin cuckoo_N = mkTerm "cuckoo_N" ;
lin cuckoo_clock_N = mkTerm "cuckoo_clock_N" ;
lin cuckoopint_N = mkTerm "cuckoopint_N" ;
lin cucumber_N = mkTerm "cucumber_N" ;
lin cucurbit_N = mkTerm "cucurbit_N" ;
lin cucurbitaceous_A = mkTerm "cucurbitaceous_A" ;
lin cud_N = mkTerm "cud_N" ;
lin cuddle_N = mkTerm "cuddle_N" ;
lin cuddle_V = mkTerm "cuddle_V" ;
lin cuddle_V2 = mkTerm "cuddle_V2" ;
lin cuddlesome_A = mkTerm "cuddlesome_A" ;
lin cuddly_A = mkTerm "cuddly_A" ;
lin cuddy_N = mkTerm "cuddy_N" ;
lin cudgel_N = mkTerm "cudgel_N" ;
lin cudgel_V2 = mkTerm "cudgel_V2" ;
lin cudweed_N = mkTerm "cudweed_N" ;
lin cudworth_PN = mkTerm "cudworth_PN" ;
lin cue_N = mkTerm "cue_N" ;
lin cuff_N = mkTerm "cuff_N" ;
lin cuff_V2 = mkTerm "cuff_V2" ;
lin cuffley_PN = mkTerm "cuffley_PN" ;
lin cufflink_N = mkTerm "cufflink_N" ;
lin cuirass_N = mkTerm "cuirass_N" ;
lin cuirassier_N = mkTerm "cuirassier_N" ;
lin cuisine_N = mkTerm "cuisine_N" ;
lin cuisse_N = mkTerm "cuisse_N" ;
lin cul_N = mkTerm "cul_N" ;
lin cul_de_sac_N = mkTerm "cul_de_sac_N" ;
lin culcheth_PN = mkTerm "culcheth_PN" ;
lin culdoscope_N = mkTerm "culdoscope_N" ;
lin culdoscopy_N = mkTerm "culdoscopy_N" ;
lin culinary_A = mkTerm "culinary_A" ;
lin cull_N = mkTerm "cull_N" ;
lin cull_V2 = mkTerm "cull_V2" ;
lin cullender_N = mkTerm "cullender_N" ;
lin cullis_N = mkTerm "cullis_N" ;
lin culm_N = mkTerm "culm_N" ;
lin culminate_V = mkTerm "culminate_V" ;
lin culminate_V2 = mkTerm "culminate_V2" ;
lin culmination_N = mkTerm "culmination_N" ;
lin culotte_N = mkTerm "culotte_N" ;
lin culpability_N = mkTerm "culpability_N" ;
lin culpable_A = mkTerm "culpable_A" ;
lin culprit_N = mkTerm "culprit_N" ;
lin cult_N = mkTerm "cult_N" ;
lin cultism_N = mkTerm "cultism_N" ;
lin cultist_N = mkTerm "cultist_N" ;
lin cultivable_A = mkTerm "cultivable_A" ;
lin cultivar_N = mkTerm "cultivar_N" ;
lin cultivate_V2 = mkTerm "cultivate_V2" ;
lin cultivation_N = mkTerm "cultivation_N" ;
lin cultivator_N = mkTerm "cultivator_N" ;
lin cultural_A = mkTerm "cultural_A" ;
lin culturati_N = mkTerm "culturati_N" ;
lin culture_N = mkTerm "culture_N" ;
lin cultured_A = mkTerm "cultured_A" ;
lin culverin_N = mkTerm "culverin_N" ;
lin culvert_N = mkTerm "culvert_N" ;
lin cum_N = mkTerm "cum_N" ;
lin cum_Prep = mkTerm "cum_Prep" ;
lin cumber_V2 = mkTerm "cumber_V2" ;
lin cumberland_PN = mkTerm "cumberland_PN" ;
lin cumbernauld_PN = mkTerm "cumbernauld_PN" ;
lin cumbersome_A = mkTerm "cumbersome_A" ;
lin cumbria_PN = mkTerm "cumbria_PN" ;
lin cumbrous_A = mkTerm "cumbrous_A" ;
lin cumin_N = mkTerm "cumin_N" ;
lin cummerbund_N = mkTerm "cummerbund_N" ;
lin cummings_N = mkTerm "cummings_N" ;
lin cumnock_PN = mkTerm "cumnock_PN" ;
lin cumulative_A = mkTerm "cumulative_A" ;
lin cumuliform_A = mkTerm "cumuliform_A" ;
lin cumulonimbus_N = mkTerm "cumulonimbus_N" ;
lin cumulous_A = mkTerm "cumulous_A" ;
lin cumulus_N = mkTerm "cumulus_N" ;
lin cuneate_A = mkTerm "cuneate_A" ;
lin cuneiform_A = mkTerm "cuneiform_A" ;
lin cuneiform_N = mkTerm "cuneiform_N" ;
lin cunner_N = mkTerm "cunner_N" ;
lin cunnilingus_N = mkTerm "cunnilingus_N" ;
lin cunning_A = mkTerm "cunning_A" ;
lin cunning_N = mkTerm "cunning_N" ;
lin cunt_N = mkTerm "cunt_N" ;
lin cup_N = mkTerm "cup_N" ;
lin cup_V2 = mkTerm "cup_V2" ;
lin cup_bearer_N = mkTerm "cup_bearer_N" ;
lin cup_final_N = mkTerm "cup_final_N" ;
lin cup_tie_N = mkTerm "cup_tie_N" ;
lin cupar_PN = mkTerm "cupar_PN" ;
lin cupboard_N = mkTerm "cupboard_N" ;
lin cupboard_love_N = mkTerm "cupboard_love_N" ;
lin cupcake_N = mkTerm "cupcake_N" ;
lin cupflower_N = mkTerm "cupflower_N" ;
lin cupful_N = mkTerm "cupful_N" ;
lin cupid_N = mkTerm "cupid_N" ;
lin cupid_PN = mkTerm "cupid_PN" ;
lin cupidity_N = mkTerm "cupidity_N" ;
lin cuplike_A = mkTerm "cuplike_A" ;
lin cupola_N = mkTerm "cupola_N" ;
lin cuppa_N = mkTerm "cuppa_N" ;
lin cupping_N = mkTerm "cupping_N" ;
lin cupric_A = mkTerm "cupric_A" ;
lin cuprite_N = mkTerm "cuprite_N" ;
lin cupro_nickel_N = mkTerm "cupro_nickel_N" ;
lin cupular_A = mkTerm "cupular_A" ;
lin cupule_N = mkTerm "cupule_N" ;
lin cur_N = mkTerm "cur_N" ;
lin curability_N = mkTerm "curability_N" ;
lin curable_A = mkTerm "curable_A" ;
lin curacao_N = mkTerm "curacao_N" ;
lin curacoa_N = mkTerm "curacoa_N" ;
lin curacy_N = mkTerm "curacy_N" ;
lin curandera_N = mkTerm "curandera_N" ;
lin curandero_N = mkTerm "curandero_N" ;
lin curassow_N = mkTerm "curassow_N" ;
lin curate_N = mkTerm "curate_N" ;
lin curative_A = mkTerm "curative_A" ;
lin curator_N = mkTerm "curator_N" ;
lin curatorial_A = mkTerm "curatorial_A" ;
lin curatorship_N = mkTerm "curatorship_N" ;
lin curb_N = mkTerm "curb_N" ;
lin curb_V2 = mkTerm "curb_V2" ;
lin curbside_N = mkTerm "curbside_N" ;
lin curbstone_N = mkTerm "curbstone_N" ;
lin curd_N = mkTerm "curd_N" ;
lin curdle_V = mkTerm "curdle_V" ;
lin curdle_V2 = mkTerm "curdle_V2" ;
lin curdling_N = mkTerm "curdling_N" ;
lin cure_N = mkTerm "cure_N" ;
lin cure_V = mkTerm "cure_V" ;
lin cure_V2 = mkTerm "cure_V2" ;
lin cure_all_N = mkTerm "cure_all_N" ;
lin curettage_N = mkTerm "curettage_N" ;
lin curette_N = mkTerm "curette_N" ;
lin curfew_N = mkTerm "curfew_N" ;
lin curie_N = mkTerm "curie_N" ;
lin curio_N = mkTerm "curio_N" ;
lin curiosa_N = mkTerm "curiosa_N" ;
lin curiosity_N = mkTerm "curiosity_N" ;
lin curious_A = mkTerm "curious_A" ;
lin curiousness_N = mkTerm "curiousness_N" ;
lin curitiba_PN = mkTerm "curitiba_PN" ;
lin curium_N = mkTerm "curium_N" ;
lin curl_N = mkTerm "curl_N" ;
lin curl_V = mkTerm "curl_V" ;
lin curl_up_V = mkTerm "curl_up_V" ;
lin curler_N = mkTerm "curler_N" ;
lin curlew_N = mkTerm "curlew_N" ;
lin curliness_N = mkTerm "curliness_N" ;
lin curling_N = mkTerm "curling_N" ;
lin curly_A = mkTerm "curly_A" ;
lin curmudgeon_N = mkTerm "curmudgeon_N" ;
lin currant_N = mkTerm "currant_N" ;
lin currawong_N = mkTerm "currawong_N" ;
lin currency_N = mkTerm "currency_N" ;
lin current_1_N = mkTerm "current_1_N" ;
lin current_2_N = mkTerm "current_2_N" ;
lin current_A = mkTerm "current_A" ;
lin currentness_N = mkTerm "currentness_N" ;
lin curricular_A = mkTerm "curricular_A" ;
lin curriculum_N = mkTerm "curriculum_N" ;
lin curriculum_vitae_N = mkTerm "curriculum_vitae_N" ;
lin currie_PN = mkTerm "currie_PN" ;
lin currier_N = mkTerm "currier_N" ;
lin currish_A = mkTerm "currish_A" ;
lin curry_N = mkTerm "curry_N" ;
lin curry_V2 = mkTerm "curry_V2" ;
lin curry_powder_N = mkTerm "curry_powder_N" ;
lin currycomb_N = mkTerm "currycomb_N" ;
lin curse_N = mkTerm "curse_N" ;
lin curse_V = mkTerm "curse_V" ;
lin curse_V2 = mkTerm "curse_V2" ;
lin cursive_A = mkTerm "cursive_A" ;
lin cursor_N = mkTerm "cursor_N" ;
lin cursorial_A = mkTerm "cursorial_A" ;
lin cursory_A = mkTerm "cursory_A" ;
lin curst_A = mkTerm "curst_A" ;
lin curt_A = mkTerm "curt_A" ;
lin curtail_V2 = mkTerm "curtail_V2" ;
lin curtailment_N = mkTerm "curtailment_N" ;
lin curtain_N = mkTerm "curtain_N" ;
lin curtain_V2 = mkTerm "curtain_V2" ;
lin curtain_call_N = mkTerm "curtain_call_N" ;
lin curtain_lecture_N = mkTerm "curtain_lecture_N" ;
lin curtain_raiser_N = mkTerm "curtain_raiser_N" ;
lin curtainless_A = mkTerm "curtainless_A" ;
lin curtal_A = mkTerm "curtal_A" ;
lin curtness_N = mkTerm "curtness_N" ;
lin curtsey_N = mkTerm "curtsey_N" ;
lin curtsey_V = mkTerm "curtsey_V" ;
lin curtsy_N = mkTerm "curtsy_N" ;
lin curtsy_V = mkTerm "curtsy_V" ;
lin curvaceously_Adv = mkTerm "curvaceously_Adv" ;
lin curvaceousness_N = mkTerm "curvaceousness_N" ;
lin curvature_N = mkTerm "curvature_N" ;
lin curve_N = mkTerm "curve_N" ;
lin curve_V = mkTerm "curve_V" ;
lin curve_V2 = mkTerm "curve_V2" ;
lin curvet_N = mkTerm "curvet_N" ;
lin curvilineal_A = mkTerm "curvilineal_A" ;
lin curvy_A = mkTerm "curvy_A" ;
lin cuscus_N = mkTerm "cuscus_N" ;
lin cushaw_N = mkTerm "cushaw_N" ;
lin cushion_N = mkTerm "cushion_N" ;
lin cushion_V2 = mkTerm "cushion_V2" ;
lin cushy_A = mkTerm "cushy_A" ;
lin cusk_N = mkTerm "cusk_N" ;
lin cusp_N = mkTerm "cusp_N" ;
lin cuspate_A = mkTerm "cuspate_A" ;
lin cuspidation_N = mkTerm "cuspidation_N" ;
lin cuspidor_N = mkTerm "cuspidor_N" ;
lin cuss_N = mkTerm "cuss_N" ;
lin cussed_A = mkTerm "cussed_A" ;
lin cussedness_N = mkTerm "cussedness_N" ;
lin custard_N = mkTerm "custard_N" ;
lin custodial_A = mkTerm "custodial_A" ;
lin custodian_N = mkTerm "custodian_N" ;
lin custodianship_N = mkTerm "custodianship_N" ;
lin custody_N = mkTerm "custody_N" ;
lin custom_N = mkTerm "custom_N" ;
lin custom_built_A = mkTerm "custom_built_A" ;
lin custom_made_A = mkTerm "custom_made_A" ;
lin customary_A = mkTerm "customary_A" ;
lin customerFem_N = mkTerm "customerFem_N" ;
lin customerMasc_N = mkTerm "customerMasc_N" ;
lin customhouse_N = mkTerm "customhouse_N" ;
lin customize_V2 = mkTerm "customize_V2" ;
lin customs_N = mkTerm "customs_N" ;
lin cut_N = mkTerm "cut_N" ;
lin cut_V = mkTerm "cut_V" ;
lin cut_V2 = mkTerm "cut_V2" ;
lin cut_across_V2 = mkTerm "cut_across_V2" ;
lin cut_back_V2 = mkTerm "cut_back_V2" ;
lin cut_back_on_V2 = mkTerm "cut_back_on_V2" ;
lin cut_down_V = mkTerm "cut_down_V" ;
lin cut_down_V2 = mkTerm "cut_down_V2" ;
lin cut_down_on_V2 = mkTerm "cut_down_on_V2" ;
lin cut_in_V = mkTerm "cut_in_V" ;
lin cut_in_V2 = mkTerm "cut_in_V2" ;
lin cut_in_on_V2 = mkTerm "cut_in_on_V2" ;
lin cut_it_out_V2 = mkTerm "cut_it_out_V2" ;
lin cut_off_V = mkTerm "cut_off_V" ;
lin cut_off_V2 = mkTerm "cut_off_V2" ;
lin cut_out_N = mkTerm "cut_out_N" ;
lin cut_out_V = mkTerm "cut_out_V" ;
lin cut_out_V2 = mkTerm "cut_out_V2" ;
lin cut_out_on_V2 = mkTerm "cut_out_on_V2" ;
lin cut_price_A = mkTerm "cut_price_A" ;
lin cut_rate_A = mkTerm "cut_rate_A" ;
lin cut_throat_A = mkTerm "cut_throat_A" ;
lin cut_throat_N = mkTerm "cut_throat_N" ;
lin cut_up_V = mkTerm "cut_up_V" ;
lin cut_up_V2 = mkTerm "cut_up_V2" ;
lin cutaneous_A = mkTerm "cutaneous_A" ;
lin cutaway_N = mkTerm "cutaway_N" ;
lin cutback_N = mkTerm "cutback_N" ;
lin cutch_N = mkTerm "cutch_N" ;
lin cute_A = mkTerm "cute_A" ;
lin cuteness_N = mkTerm "cuteness_N" ;
lin cuticle_N = mkTerm "cuticle_N" ;
lin cuticula_N = mkTerm "cuticula_N" ;
lin cuticular_A = mkTerm "cuticular_A" ;
lin cutin_N = mkTerm "cutin_N" ;
lin cutlas_N = mkTerm "cutlas_N" ;
lin cutlass_N = mkTerm "cutlass_N" ;
lin cutlassfish_N = mkTerm "cutlassfish_N" ;
lin cutler_N = mkTerm "cutler_N" ;
lin cutlery_N = mkTerm "cutlery_N" ;
lin cutlet_N = mkTerm "cutlet_N" ;
lin cutoff_N = mkTerm "cutoff_N" ;
lin cutpurse_N = mkTerm "cutpurse_N" ;
lin cutter_N = mkTerm "cutter_N" ;
lin cutting_N = mkTerm "cutting_N" ;
lin cutting_room_N = mkTerm "cutting_room_N" ;
lin cuttingly_Adv = mkTerm "cuttingly_Adv" ;
lin cuttlefish_N = mkTerm "cuttlefish_N" ;
lin cutwork_N = mkTerm "cutwork_N" ;
lin cutworm_N = mkTerm "cutworm_N" ;
lin cwmbran_PN = mkTerm "cwmbran_PN" ;
lin cwt_N = mkTerm "cwt_N" ;
lin cyan_N = mkTerm "cyan_N" ;
lin cyanamide_N = mkTerm "cyanamide_N" ;
lin cyanide_N = mkTerm "cyanide_N" ;
lin cyanobacteria_N = mkTerm "cyanobacteria_N" ;
lin cyanobacterial_A = mkTerm "cyanobacterial_A" ;
lin cyanogen_N = mkTerm "cyanogen_N" ;
lin cyanogenetic_A = mkTerm "cyanogenetic_A" ;
lin cyanohydrin_N = mkTerm "cyanohydrin_N" ;
lin cyanosis_N = mkTerm "cyanosis_N" ;
lin cyberart_N = mkTerm "cyberart_N" ;
lin cybercafe_N = mkTerm "cybercafe_N" ;
lin cybercrime_N = mkTerm "cybercrime_N" ;
lin cyberculture_N = mkTerm "cyberculture_N" ;
lin cybernaut_N = mkTerm "cybernaut_N" ;
lin cybernetic_A = mkTerm "cybernetic_A" ;
lin cybernetics_N = mkTerm "cybernetics_N" ;
lin cyberphobia_N = mkTerm "cyberphobia_N" ;
lin cyberpunk_N = mkTerm "cyberpunk_N" ;
lin cybersex_N = mkTerm "cybersex_N" ;
lin cyborg_N = mkTerm "cyborg_N" ;
lin cycad_N = mkTerm "cycad_N" ;
lin cyclamen_N = mkTerm "cyclamen_N" ;
lin cycle_N = mkTerm "cycle_N" ;
lin cycle_V = mkTerm "cycle_V" ;
lin cyclic_A = mkTerm "cyclic_A" ;
lin cyclical_A = mkTerm "cyclical_A" ;
lin cyclicity_N = mkTerm "cyclicity_N" ;
lin cycling_N = mkTerm "cycling_N" ;
lin cyclist_N = mkTerm "cyclist_N" ;
lin cyclobenzaprine_N = mkTerm "cyclobenzaprine_N" ;
lin cyclohexanol_N = mkTerm "cyclohexanol_N" ;
lin cycloid_A = mkTerm "cycloid_A" ;
lin cycloid_N = mkTerm "cycloid_N" ;
lin cyclone_N = mkTerm "cyclone_N" ;
lin cyclonic_A = mkTerm "cyclonic_A" ;
lin cyclooxygenase_N = mkTerm "cyclooxygenase_N" ;
lin cyclopaedia_N = mkTerm "cyclopaedia_N" ;
lin cyclopean_A = mkTerm "cyclopean_A" ;
lin cyclopia_N = mkTerm "cyclopia_N" ;
lin cyclopropane_N = mkTerm "cyclopropane_N" ;
lin cyclops_N = mkTerm "cyclops_N" ;
lin cycloserine_N = mkTerm "cycloserine_N" ;
lin cyclosis_N = mkTerm "cyclosis_N" ;
lin cyclostome_N = mkTerm "cyclostome_N" ;
lin cyclostyle_N = mkTerm "cyclostyle_N" ;
lin cyclostyle_V2 = mkTerm "cyclostyle_V2" ;
lin cyclothymia_N = mkTerm "cyclothymia_N" ;
lin cyclothymic_A = mkTerm "cyclothymic_A" ;
lin cyclotron_N = mkTerm "cyclotron_N" ;
lin cyder_N = mkTerm "cyder_N" ;
lin cygnet_N = mkTerm "cygnet_N" ;
lin cylinder_N = mkTerm "cylinder_N" ;
lin cylindrical_A = mkTerm "cylindrical_A" ;
lin cylindricality_N = mkTerm "cylindricality_N" ;
lin cyma_N = mkTerm "cyma_N" ;
lin cymbal_N = mkTerm "cymbal_N" ;
lin cymbalist_N = mkTerm "cymbalist_N" ;
lin cymbid_N = mkTerm "cymbid_N" ;
lin cyme_N = mkTerm "cyme_N" ;
lin cymene_N = mkTerm "cymene_N" ;
lin cymling_N = mkTerm "cymling_N" ;
lin cymose_A = mkTerm "cymose_A" ;
lin cymule_N = mkTerm "cymule_N" ;
lin cynancum_N = mkTerm "cynancum_N" ;
lin cynic_N = mkTerm "cynic_N" ;
lin cynical_A = mkTerm "cynical_A" ;
lin cynicism_N = mkTerm "cynicism_N" ;
lin cynodont_N = mkTerm "cynodont_N" ;
lin cynophobia_N = mkTerm "cynophobia_N" ;
lin cynosure_N = mkTerm "cynosure_N" ;
lin cynthia_PN = mkTerm "cynthia_PN" ;
lin cypher_N = mkTerm "cypher_N" ;
lin cypher_V = mkTerm "cypher_V" ;
lin cypher_V2 = mkTerm "cypher_V2" ;
lin cypress_N = mkTerm "cypress_N" ;
lin cyprian_A = mkTerm "cyprian_A" ;
lin cyprinid_A = mkTerm "cyprinid_A" ;
lin cyprinid_N = mkTerm "cyprinid_N" ;
lin cyprinodont_N = mkTerm "cyprinodont_N" ;
lin cypriot_A = mkTerm "cypriot_A" ;
lin cypriot_N = mkTerm "cypriot_N" ;
lin cypripedia_N = mkTerm "cypripedia_N" ;
lin cyproheptadine_N = mkTerm "cyproheptadine_N" ;
lin cyprus_PN = mkTerm "cyprus_PN" ;
lin cyril_PN = mkTerm "cyril_PN" ;
lin cyrilla_N = mkTerm "cyrilla_N" ;
lin cyrillic_A = mkTerm "cyrillic_A" ;
lin cyst_N = mkTerm "cyst_N" ;
lin cysteine_N = mkTerm "cysteine_N" ;
lin cystic_A = mkTerm "cystic_A" ;
lin cystine_N = mkTerm "cystine_N" ;
lin cystitis_N = mkTerm "cystitis_N" ;
lin cystocele_N = mkTerm "cystocele_N" ;
lin cystoplegia_N = mkTerm "cystoplegia_N" ;
lin cytoarchitectural_A = mkTerm "cytoarchitectural_A" ;
lin cytoarchitecture_N = mkTerm "cytoarchitecture_N" ;
lin cytochrome_N = mkTerm "cytochrome_N" ;
lin cytogenesis_N = mkTerm "cytogenesis_N" ;
lin cytogenetic_A = mkTerm "cytogenetic_A" ;
lin cytogeneticist_N = mkTerm "cytogeneticist_N" ;
lin cytogenetics_N = mkTerm "cytogenetics_N" ;
lin cytokine_N = mkTerm "cytokine_N" ;
lin cytokinesis_N = mkTerm "cytokinesis_N" ;
lin cytokinetic_A = mkTerm "cytokinetic_A" ;
lin cytological_A = mkTerm "cytological_A" ;
lin cytologist_N = mkTerm "cytologist_N" ;
lin cytology_N = mkTerm "cytology_N" ;
lin cytolysin_N = mkTerm "cytolysin_N" ;
lin cytolysis_N = mkTerm "cytolysis_N" ;
lin cytolytic_A = mkTerm "cytolytic_A" ;
lin cytomegalic_A = mkTerm "cytomegalic_A" ;
lin cytomegalovirus_N = mkTerm "cytomegalovirus_N" ;
lin cytopathogenic_A = mkTerm "cytopathogenic_A" ;
lin cytopenia_N = mkTerm "cytopenia_N" ;
lin cytophotometer_N = mkTerm "cytophotometer_N" ;
lin cytophotometric_A = mkTerm "cytophotometric_A" ;
lin cytophotometry_N = mkTerm "cytophotometry_N" ;
lin cytoplasm_N = mkTerm "cytoplasm_N" ;
lin cytoplasmic_A = mkTerm "cytoplasmic_A" ;
lin cytoplast_N = mkTerm "cytoplast_N" ;
lin cytoplastic_A = mkTerm "cytoplastic_A" ;
lin cytosine_N = mkTerm "cytosine_N" ;
lin cytoskeleton_N = mkTerm "cytoskeleton_N" ;
lin cytosol_N = mkTerm "cytosol_N" ;
lin cytostome_N = mkTerm "cytostome_N" ;
lin cytotoxic_A = mkTerm "cytotoxic_A" ;
lin cytotoxicity_N = mkTerm "cytotoxicity_N" ;
lin cytotoxin_N = mkTerm "cytotoxin_N" ;
lin czar_N = mkTerm "czar_N" ;
lin czarina_N = mkTerm "czarina_N" ;
lin czarist_A = mkTerm "czarist_A" ;
lin czech_A = mkTerm "czech_A" ;
lin czech_N = mkTerm "czech_N" ;
lin czechoslovak_A = mkTerm "czechoslovak_A" ;
lin czechoslovak_N = mkTerm "czechoslovak_N" ;
lin czechoslovakia_PN = mkTerm "czechoslovakia_PN" ;
lin czechoslovakian_A = mkTerm "czechoslovakian_A" ;
lin czechoslovakian_N = mkTerm "czechoslovakian_N" ;
lin d_day_PN = mkTerm "d_day_PN" ;
lin d_o_a__A = mkTerm "d_o_a__A" ;
lin dab_N = mkTerm "dab_N" ;
lin dab_V = mkTerm "dab_V" ;
lin dab_V2 = mkTerm "dab_V2" ;
lin dabble_V = mkTerm "dabble_V" ;
lin dabble_V2 = mkTerm "dabble_V2" ;
lin dabbler_N = mkTerm "dabbler_N" ;
lin dabchick_N = mkTerm "dabchick_N" ;
lin dacca_PN = mkTerm "dacca_PN" ;
lin dace_N = mkTerm "dace_N" ;
lin dacha_N = mkTerm "dacha_N" ;
lin dachshund_N = mkTerm "dachshund_N" ;
lin dacite_N = mkTerm "dacite_N" ;
lin dacitic_A = mkTerm "dacitic_A" ;
lin dacoit_N = mkTerm "dacoit_N" ;
lin dacoity_N = mkTerm "dacoity_N" ;
lin dacryocystitis_N = mkTerm "dacryocystitis_N" ;
lin dacryon_N = mkTerm "dacryon_N" ;
lin dactyl_N = mkTerm "dactyl_N" ;
lin dactylic_A = mkTerm "dactylic_A" ;
lin dactylomegaly_N = mkTerm "dactylomegaly_N" ;
lin dad_N = mkTerm "dad_N" ;
lin dada_N = mkTerm "dada_N" ;
lin daddy_N = mkTerm "daddy_N" ;
lin daddy_longlegs_N = mkTerm "daddy_longlegs_N" ;
lin dado_N = mkTerm "dado_N" ;
lin daedal_A = mkTerm "daedal_A" ;
lin daemon_N = mkTerm "daemon_N" ;
lin daffodil_N = mkTerm "daffodil_N" ;
lin daft_A = mkTerm "daft_A" ;
lin dagame_N = mkTerm "dagame_N" ;
lin dagga_N = mkTerm "dagga_N" ;
lin dagger_N = mkTerm "dagger_N" ;
lin daggerboard_N = mkTerm "daggerboard_N" ;
lin dago_N = mkTerm "dago_N" ;
lin daguerreotype_N = mkTerm "daguerreotype_N" ;
lin dahlia_N = mkTerm "dahlia_N" ;
lin dail_eireann_N = mkTerm "dail_eireann_N" ;
lin daily_A = mkTerm "daily_A" ;
lin daily_Adv = mkTerm "daily_Adv" ;
lin daily_N = mkTerm "daily_N" ;
lin daintiness_N = mkTerm "daintiness_N" ;
lin dainty_A = mkTerm "dainty_A" ;
lin dainty_N = mkTerm "dainty_N" ;
lin daiquiri_N = mkTerm "daiquiri_N" ;
lin dairy_N = mkTerm "dairy_N" ;
lin dairy_farm_N = mkTerm "dairy_farm_N" ;
lin dairy_farming_N = mkTerm "dairy_farming_N" ;
lin dairying_N = mkTerm "dairying_N" ;
lin dairymaid_N = mkTerm "dairymaid_N" ;
lin dairyman_N = mkTerm "dairyman_N" ;
lin dais_N = mkTerm "dais_N" ;
lin daisy_N = mkTerm "daisy_N" ;
lin daisy_PN = mkTerm "daisy_PN" ;
lin daisybush_N = mkTerm "daisybush_N" ;
lin daisylike_A = mkTerm "daisylike_A" ;
lin dakar_PN = mkTerm "dakar_PN" ;
lin dakota_PN = mkTerm "dakota_PN" ;
lin dalasi_N = mkTerm "dalasi_N" ;
lin dale_N = mkTerm "dale_N" ;
lin dalesman_N = mkTerm "dalesman_N" ;
lin daleth_N = mkTerm "daleth_N" ;
lin dalkeith_PN = mkTerm "dalkeith_PN" ;
lin dallas_PN = mkTerm "dallas_PN" ;
lin dalliance_N = mkTerm "dalliance_N" ;
lin dallier_N = mkTerm "dallier_N" ;
lin dallisgrass_N = mkTerm "dallisgrass_N" ;
lin dally_V = mkTerm "dally_V" ;
lin dalmatian_N = mkTerm "dalmatian_N" ;
lin dalry_PN = mkTerm "dalry_PN" ;
lin dalton_PN = mkTerm "dalton_PN" ;
lin dam_N = mkTerm "dam_N" ;
lin dam_V2 = mkTerm "dam_V2" ;
lin damage_N = mkTerm "damage_N" ;
lin damage_V2 = mkTerm "damage_V2" ;
lin damages_N = mkTerm "damages_N" ;
lin damaging_A = mkTerm "damaging_A" ;
lin damascene_A = mkTerm "damascene_A" ;
lin damascene_N = mkTerm "damascene_N" ;
lin damascene_V2 = mkTerm "damascene_V2" ;
lin damascus_PN = mkTerm "damascus_PN" ;
lin damask_A = mkTerm "damask_A" ;
lin damask_N = mkTerm "damask_N" ;
lin dame_N = mkTerm "dame_N" ;
lin dammar_N = mkTerm "dammar_N" ;
lin dammit_Interj = mkTerm "dammit_Interj" ;
lin damn_A = mkTerm "damn_A" ;
lin damn_Interj = mkTerm "damn_Interj" ;
lin damn_N = mkTerm "damn_N" ;
lin damn_V2 = mkTerm "damn_V2" ;
lin damnable_A = mkTerm "damnable_A" ;
lin damnation_N = mkTerm "damnation_N" ;
lin damnatory_A = mkTerm "damnatory_A" ;
lin damned_Adv = mkTerm "damned_Adv" ;
lin damned_N = mkTerm "damned_N" ;
lin damocles_PN = mkTerm "damocles_PN" ;
lin damourite_N = mkTerm "damourite_N" ;
lin damp_A = mkTerm "damp_A" ;
lin damp_N = mkTerm "damp_N" ;
lin damp_V = mkTerm "damp_V" ;
lin damp_V2 = mkTerm "damp_V2" ;
lin damp_down_V2 = mkTerm "damp_down_V2" ;
lin damp_off_V = mkTerm "damp_off_V" ;
lin dampen_V = mkTerm "dampen_V" ;
lin dampen_V2 = mkTerm "dampen_V2" ;
lin dampener_N = mkTerm "dampener_N" ;
lin damper_N = mkTerm "damper_N" ;
lin dampish_A = mkTerm "dampish_A" ;
lin dampness_N = mkTerm "dampness_N" ;
lin damsel_N = mkTerm "damsel_N" ;
lin damselfish_N = mkTerm "damselfish_N" ;
lin damselfly_N = mkTerm "damselfly_N" ;
lin damson_N = mkTerm "damson_N" ;
lin dan_PN = mkTerm "dan_PN" ;
lin danaid_N = mkTerm "danaid_N" ;
lin dance_N = mkTerm "dance_N" ;
lin dance_V = mkTerm "dance_V" ;
lin dance_V2 = mkTerm "dance_V2" ;
lin dance_band_N = mkTerm "dance_band_N" ;
lin dance_hall_N = mkTerm "dance_hall_N" ;
lin dance_orchestra_N = mkTerm "dance_orchestra_N" ;
lin danceable_A = mkTerm "danceable_A" ;
lin dancer_N = mkTerm "dancer_N" ;
lin dancing_N = mkTerm "dancing_N" ;
lin dandelion_N = mkTerm "dandelion_N" ;
lin dander_N = mkTerm "dander_N" ;
lin dandified_A = mkTerm "dandified_A" ;
lin dandle_V2 = mkTerm "dandle_V2" ;
lin dandruff_N = mkTerm "dandruff_N" ;
lin dandy_A = mkTerm "dandy_A" ;
lin dandy_N = mkTerm "dandy_N" ;
lin dane_N = mkTerm "dane_N" ;
lin danger_N = mkTerm "danger_N" ;
lin dangerous_A = mkTerm "dangerous_A" ;
lin dangerousness_N = mkTerm "dangerousness_N" ;
lin dangle_V = mkTerm "dangle_V" ;
lin dangle_V2 = mkTerm "dangle_V2" ;
lin dangleberry_N = mkTerm "dangleberry_N" ;
lin daniel_N = mkTerm "daniel_N" ;
lin daniel_PN = mkTerm "daniel_PN" ;
lin danishFem_N = mkTerm "danishFem_N" ;
lin danishMasc_N = mkTerm "danishMasc_N" ;
lin danish_A = mkTerm "danish_A" ;
lin dank_A = mkTerm "dank_A" ;
lin dankness_N = mkTerm "dankness_N" ;
lin danny_PN = mkTerm "danny_PN" ;
lin danse_macabre_N = mkTerm "danse_macabre_N" ;
lin danseur_N = mkTerm "danseur_N" ;
lin daphne_N = mkTerm "daphne_N" ;
lin daphne_PN = mkTerm "daphne_PN" ;
lin daphnia_N = mkTerm "daphnia_N" ;
lin dapper_A = mkTerm "dapper_A" ;
lin dapple_V2 = mkTerm "dapple_V2" ;
lin dapple_grey_A = mkTerm "dapple_grey_A" ;
lin dapple_grey_N = mkTerm "dapple_grey_N" ;
lin dapsone_N = mkTerm "dapsone_N" ;
lin daraf_N = mkTerm "daraf_N" ;
lin darby_PN = mkTerm "darby_PN" ;
lin dare_N = mkTerm "dare_N" ;
lin dare_V2 = mkTerm "dare_V2" ;
lin dare_VV = mkTerm "dare_VV" ;
lin daredevil_A = mkTerm "daredevil_A" ;
lin daredevil_N = mkTerm "daredevil_N" ;
lin daredevilry_N = mkTerm "daredevilry_N" ;
lin darenth_PN = mkTerm "darenth_PN" ;
lin darfield_PN = mkTerm "darfield_PN" ;
lin daring_N = mkTerm "daring_N" ;
lin daringly_Adv = mkTerm "daringly_Adv" ;
lin dark_A = mkTerm "dark_A" ;
lin dark_N = mkTerm "dark_N" ;
lin darken_V = mkTerm "darken_V" ;
lin darken_V2 = mkTerm "darken_V2" ;
lin darkey_N = mkTerm "darkey_N" ;
lin darkgrey_N = mkTerm "darkgrey_N" ;
lin darkie_N = mkTerm "darkie_N" ;
lin darkish_A = mkTerm "darkish_A" ;
lin darkling_A = mkTerm "darkling_A" ;
lin darkness_N = mkTerm "darkness_N" ;
lin darkroom_N = mkTerm "darkroom_N" ;
lin darky_N = mkTerm "darky_N" ;
lin darling_N = mkTerm "darling_N" ;
lin darlington_PN = mkTerm "darlington_PN" ;
lin darmstadt_PN = mkTerm "darmstadt_PN" ;
lin darmstadtium_N = mkTerm "darmstadtium_N" ;
lin darn_N = mkTerm "darn_N" ;
lin darn_V = mkTerm "darn_V" ;
lin darn_V2 = mkTerm "darn_V2" ;
lin darnel_N = mkTerm "darnel_N" ;
lin darner_N = mkTerm "darner_N" ;
lin darning_N = mkTerm "darning_N" ;
lin darning_needle_N = mkTerm "darning_needle_N" ;
lin dart_N = mkTerm "dart_N" ;
lin dart_V = mkTerm "dart_V" ;
lin dart_V2 = mkTerm "dart_V2" ;
lin dartboard_N = mkTerm "dartboard_N" ;
lin darter_N = mkTerm "darter_N" ;
lin dartford_PN = mkTerm "dartford_PN" ;
lin dartmouth_PN = mkTerm "dartmouth_PN" ;
lin darts_N = mkTerm "darts_N" ;
lin darwen_PN = mkTerm "darwen_PN" ;
lin dash_N = mkTerm "dash_N" ;
lin dash_V = mkTerm "dash_V" ;
lin dash_down_V2 = mkTerm "dash_down_V2" ;
lin dash_off_V = mkTerm "dash_off_V" ;
lin dash_off_V2 = mkTerm "dash_off_V2" ;
lin dashboard_N = mkTerm "dashboard_N" ;
lin dashiki_N = mkTerm "dashiki_N" ;
lin dashingly_Adv = mkTerm "dashingly_Adv" ;
lin dastard_N = mkTerm "dastard_N" ;
lin dastardliness_N = mkTerm "dastardliness_N" ;
lin dastardly_A = mkTerm "dastardly_A" ;
lin dasymeter_N = mkTerm "dasymeter_N" ;
lin dasyure_N = mkTerm "dasyure_N" ;
lin data_N = mkTerm "data_N" ;
lin database_N = mkTerm "database_N" ;
lin datable_A = mkTerm "datable_A" ;
lin date_1_N = mkTerm "date_1_N" ;
lin date_3_N = mkTerm "date_3_N" ;
lin date_7_N = mkTerm "date_7_N" ;
lin date_V = mkTerm "date_V" ;
lin date_V2 = mkTerm "date_V2" ;
lin dateless_A = mkTerm "dateless_A" ;
lin dateline_N = mkTerm "dateline_N" ;
lin dating_N = mkTerm "dating_N" ;
lin dative_A = mkTerm "dative_A" ;
lin dative_N = mkTerm "dative_N" ;
lin datum_N = mkTerm "datum_N" ;
lin daub_N = mkTerm "daub_N" ;
lin daub_V = mkTerm "daub_V" ;
lin daub_V2 = mkTerm "daub_V2" ;
lin dauber_N = mkTerm "dauber_N" ;
lin daughter_N = mkTerm "daughter_N" ;
lin daughter_in_law_N = mkTerm "daughter_in_law_N" ;
lin daughterly_A = mkTerm "daughterly_A" ;
lin daunt_V2 = mkTerm "daunt_V2" ;
lin daunting_A = mkTerm "daunting_A" ;
lin dauntless_A = mkTerm "dauntless_A" ;
lin dauntlessness_N = mkTerm "dauntlessness_N" ;
lin dauphin_N = mkTerm "dauphin_N" ;
lin davallia_N = mkTerm "davallia_N" ;
lin dave_PN = mkTerm "dave_PN" ;
lin davenport_N = mkTerm "davenport_N" ;
lin daventry_PN = mkTerm "daventry_PN" ;
lin davey_PN = mkTerm "davey_PN" ;
lin david_PN = mkTerm "david_PN" ;
lin davit_N = mkTerm "davit_N" ;
lin daw_N = mkTerm "daw_N" ;
lin dawah_N = mkTerm "dawah_N" ;
lin dawdle_V = mkTerm "dawdle_V" ;
lin dawdle_V2 = mkTerm "dawdle_V2" ;
lin dawdler_N = mkTerm "dawdler_N" ;
lin dawley_PN = mkTerm "dawley_PN" ;
lin dawlish_PN = mkTerm "dawlish_PN" ;
lin dawn_N = mkTerm "dawn_N" ;
lin dawn_PN = mkTerm "dawn_PN" ;
lin dawn_V = mkTerm "dawn_V" ;
lin dawn_on_V2 = mkTerm "dawn_on_V2" ;
lin day_N = mkTerm "day_N" ;
lin day_boarder_N = mkTerm "day_boarder_N" ;
lin day_labourer_N = mkTerm "day_labourer_N" ;
lin day_return_N = mkTerm "day_return_N" ;
lin day_school_N = mkTerm "day_school_N" ;
lin daybed_N = mkTerm "daybed_N" ;
lin daybook_N = mkTerm "daybook_N" ;
lin dayboy_N = mkTerm "dayboy_N" ;
lin daybreak_N = mkTerm "daybreak_N" ;
lin daycare_N = mkTerm "daycare_N" ;
lin daydream_N = mkTerm "daydream_N" ;
lin daydream_V = mkTerm "daydream_V" ;
lin daydreamer_N = mkTerm "daydreamer_N" ;
lin daygirl_N = mkTerm "daygirl_N" ;
lin daylight_N = mkTerm "daylight_N" ;
lin daylight_saving_A = mkTerm "daylight_saving_A" ;
lin daylight_saving_N = mkTerm "daylight_saving_N" ;
lin daylong_A = mkTerm "daylong_A" ;
lin daylong_Adv = mkTerm "daylong_Adv" ;
lin days_N = mkTerm "days_N" ;
lin dayspring_N = mkTerm "dayspring_N" ;
lin daytime_A = mkTerm "daytime_A" ;
lin daytime_N = mkTerm "daytime_N" ;
lin dayton_PN = mkTerm "dayton_PN" ;
lin daze_N = mkTerm "daze_N" ;
lin daze_V2 = mkTerm "daze_V2" ;
lin dazedly_Adv = mkTerm "dazedly_Adv" ;
lin dazzle_N = mkTerm "dazzle_N" ;
lin dazzle_V2 = mkTerm "dazzle_V2" ;
lin dazzling_A = mkTerm "dazzling_A" ;
lin ddt_N = mkTerm "ddt_N" ;
lin de_emphasize_V2 = mkTerm "de_emphasize_V2" ;
lin de_escalate_V2 = mkTerm "de_escalate_V2" ;
lin de_escalation_N = mkTerm "de_escalation_N" ;
lin de_facto_A = mkTerm "de_facto_A" ;
lin de_facto_Adv = mkTerm "de_facto_Adv" ;
lin de_ice_V2 = mkTerm "de_ice_V2" ;
lin de_jure_A = mkTerm "de_jure_A" ;
lin de_jure_Adv = mkTerm "de_jure_Adv" ;
lin de_luxe_A = mkTerm "de_luxe_A" ;
lin de_rigeur_A = mkTerm "de_rigeur_A" ;
lin de_trop_A = mkTerm "de_trop_A" ;
lin deacon_N = mkTerm "deacon_N" ;
lin deaconess_N = mkTerm "deaconess_N" ;
lin deactivate_V2 = mkTerm "deactivate_V2" ;
lin deactivation_N = mkTerm "deactivation_N" ;
lin dead_A = mkTerm "dead_A" ;
lin dead_Adv = mkTerm "dead_Adv" ;
lin dead_N = mkTerm "dead_N" ;
lin deaden_V2 = mkTerm "deaden_V2" ;
lin deadeye_N = mkTerm "deadeye_N" ;
lin deadhead_N = mkTerm "deadhead_N" ;
lin deadlight_N = mkTerm "deadlight_N" ;
lin deadline_N = mkTerm "deadline_N" ;
lin deadliness_N = mkTerm "deadliness_N" ;
lin deadlock_N = mkTerm "deadlock_N" ;
lin deadlock_V = mkTerm "deadlock_V" ;
lin deadlocked_A = mkTerm "deadlocked_A" ;
lin deadly_A = mkTerm "deadly_A" ;
lin deadness_N = mkTerm "deadness_N" ;
lin deadpan_A = mkTerm "deadpan_A" ;
lin deadpan_Adv = mkTerm "deadpan_Adv" ;
lin deadwood_N = mkTerm "deadwood_N" ;
lin deaf_A = mkTerm "deaf_A" ;
lin deaf_N = mkTerm "deaf_N" ;
lin deaf_aid_N = mkTerm "deaf_aid_N" ;
lin deaf_mute_N = mkTerm "deaf_mute_N" ;
lin deafen_V2 = mkTerm "deafen_V2" ;
lin deafening_A = mkTerm "deafening_A" ;
lin deafness_N = mkTerm "deafness_N" ;
lin deal_Adv = mkTerm "deal_Adv" ;
lin deal_N = mkTerm "deal_N" ;
lin deal_PN = mkTerm "deal_PN" ;
lin deal_V = mkTerm "deal_V" ;
lin deal_V2 = mkTerm "deal_V2" ;
lin dealer_N = mkTerm "dealer_N" ;
lin dealfish_N = mkTerm "dealfish_N" ;
lin dealignment_N = mkTerm "dealignment_N" ;
lin dealing_N = mkTerm "dealing_N" ;
lin dealings_N = mkTerm "dealings_N" ;
lin deamination_N = mkTerm "deamination_N" ;
lin dean_N = mkTerm "dean_N" ;
lin dean_PN = mkTerm "dean_PN" ;
lin deanery_N = mkTerm "deanery_N" ;
lin deanship_N = mkTerm "deanship_N" ;
lin dear_A = mkTerm "dear_A" ;
lin dear_Adv = mkTerm "dear_Adv" ;
lin dear_Interj = mkTerm "dear_Interj" ;
lin dear_N = mkTerm "dear_N" ;
lin dearest_N = mkTerm "dearest_N" ;
lin dearie_N = mkTerm "dearie_N" ;
lin dearness_N = mkTerm "dearness_N" ;
lin dearth_N = mkTerm "dearth_N" ;
lin deary_N = mkTerm "deary_N" ;
lin death_N = mkTerm "death_N" ;
lin death_mask_N = mkTerm "death_mask_N" ;
lin death_rate_N = mkTerm "death_rate_N" ;
lin death_roll_N = mkTerm "death_roll_N" ;
lin death_warrant_N = mkTerm "death_warrant_N" ;
lin deathbed_N = mkTerm "deathbed_N" ;
lin deathblow_N = mkTerm "deathblow_N" ;
lin deathless_A = mkTerm "deathless_A" ;
lin deathlike_A = mkTerm "deathlike_A" ;
lin deathly_A = mkTerm "deathly_A" ;
lin deathly_Adv = mkTerm "deathly_Adv" ;
lin deathtrap_N = mkTerm "deathtrap_N" ;
lin deb_N = mkTerm "deb_N" ;
lin debacle_N = mkTerm "debacle_N" ;
lin debag_V2 = mkTerm "debag_V2" ;
lin debar_V2 = mkTerm "debar_V2" ;
lin debark_V = mkTerm "debark_V" ;
lin debark_V2 = mkTerm "debark_V2" ;
lin debarkation_N = mkTerm "debarkation_N" ;
lin debarment_N = mkTerm "debarment_N" ;
lin debase_V2 = mkTerm "debase_V2" ;
lin debasement_N = mkTerm "debasement_N" ;
lin debaser_N = mkTerm "debaser_N" ;
lin debasing_A = mkTerm "debasing_A" ;
lin debatable_A = mkTerm "debatable_A" ;
lin debate_N = mkTerm "debate_N" ;
lin debate_V = mkTerm "debate_V" ;
lin debate_V2 = mkTerm "debate_V2" ;
lin debater_N = mkTerm "debater_N" ;
lin debauch_N = mkTerm "debauch_N" ;
lin debauch_V2 = mkTerm "debauch_V2" ;
lin debaucheeFem_N = mkTerm "debaucheeFem_N" ;
lin debaucheeMasc_N = mkTerm "debaucheeMasc_N" ;
lin debauchery_N = mkTerm "debauchery_N" ;
lin debbie_PN = mkTerm "debbie_PN" ;
lin debby_PN = mkTerm "debby_PN" ;
lin debenture_N = mkTerm "debenture_N" ;
lin debilitate_V2 = mkTerm "debilitate_V2" ;
lin debilitating_A = mkTerm "debilitating_A" ;
lin debilitation_N = mkTerm "debilitation_N" ;
lin debilitative_A = mkTerm "debilitative_A" ;
lin debility_N = mkTerm "debility_N" ;
lin debit_N = mkTerm "debit_N" ;
lin debit_V2 = mkTerm "debit_V2" ;
lin debit_side_N = mkTerm "debit_side_N" ;
lin debonair_A = mkTerm "debonair_A" ;
lin deborah_PN = mkTerm "deborah_PN" ;
lin debouch_V = mkTerm "debouch_V" ;
lin debouch_V2 = mkTerm "debouch_V2" ;
lin debridement_N = mkTerm "debridement_N" ;
lin debrief_V2 = mkTerm "debrief_V2" ;
lin debriefing_N = mkTerm "debriefing_N" ;
lin debris_N = mkTerm "debris_N" ;
lin debt_N = mkTerm "debt_N" ;
lin debtor_N = mkTerm "debtor_N" ;
lin debug_V2 = mkTerm "debug_V2" ;
lin debugger_N = mkTerm "debugger_N" ;
lin debunk_V2 = mkTerm "debunk_V2" ;
lin debut_1_N = mkTerm "debut_1_N" ;
lin debut_2_N = mkTerm "debut_2_N" ;
lin debut_V2 = mkTerm "debut_V2" ;
lin debutante_N = mkTerm "debutante_N" ;
lin dec_PN = mkTerm "dec_PN" ;
lin decade_N = mkTerm "decade_N" ;
lin decadence_N = mkTerm "decadence_N" ;
lin decadent_A = mkTerm "decadent_A" ;
lin decadent_N = mkTerm "decadent_N" ;
lin decagon_N = mkTerm "decagon_N" ;
lin decahedron_N = mkTerm "decahedron_N" ;
lin decal_N = mkTerm "decal_N" ;
lin decalcification_N = mkTerm "decalcification_N" ;
lin decalcomania_N = mkTerm "decalcomania_N" ;
lin decalescence_N = mkTerm "decalescence_N" ;
lin decalescent_A = mkTerm "decalescent_A" ;
lin decalogue_N = mkTerm "decalogue_N" ;
lin decameter_N = mkTerm "decameter_N" ;
lin decamp_V = mkTerm "decamp_V" ;
lin decampment_N = mkTerm "decampment_N" ;
lin decant_V2 = mkTerm "decant_V2" ;
lin decantation_N = mkTerm "decantation_N" ;
lin decanter_N = mkTerm "decanter_N" ;
lin decapitate_V2 = mkTerm "decapitate_V2" ;
lin decapitation_N = mkTerm "decapitation_N" ;
lin decapod_N = mkTerm "decapod_N" ;
lin decarbonize_V2 = mkTerm "decarbonize_V2" ;
lin decarboxylase_N = mkTerm "decarboxylase_N" ;
lin decarboxylation_N = mkTerm "decarboxylation_N" ;
lin decasyllabic_A = mkTerm "decasyllabic_A" ;
lin decasyllable_N = mkTerm "decasyllable_N" ;
lin decathlon_N = mkTerm "decathlon_N" ;
lin decay_N = mkTerm "decay_N" ;
lin decay_V = mkTerm "decay_V" ;
lin decayable_A = mkTerm "decayable_A" ;
lin decayed_A = mkTerm "decayed_A" ;
lin decease_N = mkTerm "decease_N" ;
lin decease_V = mkTerm "decease_V" ;
lin deceased_A = mkTerm "deceased_A" ;
lin deceit_N = mkTerm "deceit_N" ;
lin deceitful_A = mkTerm "deceitful_A" ;
lin deceitfulness_N = mkTerm "deceitfulness_N" ;
lin deceive_V2 = mkTerm "deceive_V2" ;
lin deceiver_N = mkTerm "deceiver_N" ;
lin deceivingly_Adv = mkTerm "deceivingly_Adv" ;
lin decelerate_V = mkTerm "decelerate_V" ;
lin decelerate_V2 = mkTerm "decelerate_V2" ;
lin deceleration_N = mkTerm "deceleration_N" ;
lin decency_N = mkTerm "decency_N" ;
lin decent_A = mkTerm "decent_A" ;
lin decentralization_N = mkTerm "decentralization_N" ;
lin decentralize_V2 = mkTerm "decentralize_V2" ;
lin deception_N = mkTerm "deception_N" ;
lin deceptive_A = mkTerm "deceptive_A" ;
lin deceptiveness_N = mkTerm "deceptiveness_N" ;
lin decibel_N = mkTerm "decibel_N" ;
lin decide_V = mkTerm "decide_V" ;
lin decide_V2 = mkTerm "decide_V2" ;
lin decide_VS = mkTerm "decide_VS" ;
lin decide_VV = mkTerm "decide_VV" ;
lin decide_on_V2 = mkTerm "decide_on_V2" ;
lin decide_upon_V2 = mkTerm "decide_upon_V2" ;
lin decided_A = mkTerm "decided_A" ;
lin decidua_N = mkTerm "decidua_N" ;
lin deciduous_A = mkTerm "deciduous_A" ;
lin decigram_N = mkTerm "decigram_N" ;
lin decile_N = mkTerm "decile_N" ;
lin deciliter_N = mkTerm "deciliter_N" ;
lin decimal_A = mkTerm "decimal_A" ;
lin decimal_N = mkTerm "decimal_N" ;
lin decimalization_N = mkTerm "decimalization_N" ;
lin decimalize_V2 = mkTerm "decimalize_V2" ;
lin decimate_V2 = mkTerm "decimate_V2" ;
lin decimation_N = mkTerm "decimation_N" ;
lin decimeter_N = mkTerm "decimeter_N" ;
lin decipher_V2 = mkTerm "decipher_V2" ;
lin decipherable_A = mkTerm "decipherable_A" ;
lin decipherer_N = mkTerm "decipherer_N" ;
lin decision_N = mkTerm "decision_N" ;
lin decision_making_N = mkTerm "decision_making_N" ;
lin decisive_A = mkTerm "decisive_A" ;
lin decisiveness_N = mkTerm "decisiveness_N" ;
lin deck_N = mkTerm "deck_N" ;
lin deck_V2 = mkTerm "deck_V2" ;
lin deck_out_V = mkTerm "deck_out_V" ;
lin decker_N = mkTerm "decker_N" ;
lin deckhand_N = mkTerm "deckhand_N" ;
lin deckle_N = mkTerm "deckle_N" ;
lin deckle_edged_A = mkTerm "deckle_edged_A" ;
lin deckled_A = mkTerm "deckled_A" ;
lin declaim_V = mkTerm "declaim_V" ;
lin declaim_V2 = mkTerm "declaim_V2" ;
lin declamation_N = mkTerm "declamation_N" ;
lin declamatory_A = mkTerm "declamatory_A" ;
lin declarable_A = mkTerm "declarable_A" ;
lin declaration_N = mkTerm "declaration_N" ;
lin declarative_A = mkTerm "declarative_A" ;
lin declare_V = mkTerm "declare_V" ;
lin declare_V2 = mkTerm "declare_V2" ;
lin declare_VS = mkTerm "declare_VS" ;
lin declassification_N = mkTerm "declassification_N" ;
lin declassify_V2 = mkTerm "declassify_V2" ;
lin declension_N = mkTerm "declension_N" ;
lin declination_N = mkTerm "declination_N" ;
lin decline_N = mkTerm "decline_N" ;
lin decline_V = mkTerm "decline_V" ;
lin decline_V2 = mkTerm "decline_V2" ;
lin decline_VV = mkTerm "decline_VV" ;
lin declinometer_N = mkTerm "declinometer_N" ;
lin declivitous_A = mkTerm "declivitous_A" ;
lin declivity_N = mkTerm "declivity_N" ;
lin declutch_V = mkTerm "declutch_V" ;
lin deco_N = mkTerm "deco_N" ;
lin decoction_N = mkTerm "decoction_N" ;
lin decode_V2 = mkTerm "decode_V2" ;
lin decoder_N = mkTerm "decoder_N" ;
lin decoding_N = mkTerm "decoding_N" ;
lin decoke_V2 = mkTerm "decoke_V2" ;
lin decolletage_N = mkTerm "decolletage_N" ;
lin decollete_A = mkTerm "decollete_A" ;
lin decolonization_N = mkTerm "decolonization_N" ;
lin decolonize_V2 = mkTerm "decolonize_V2" ;
lin decompose_V = mkTerm "decompose_V" ;
lin decompose_V2 = mkTerm "decompose_V2" ;
lin decomposition_N = mkTerm "decomposition_N" ;
lin decompositional_A = mkTerm "decompositional_A" ;
lin decompound_A = mkTerm "decompound_A" ;
lin decompress_V2 = mkTerm "decompress_V2" ;
lin decompression_N = mkTerm "decompression_N" ;
lin decongestant_N = mkTerm "decongestant_N" ;
lin deconsecrated_A = mkTerm "deconsecrated_A" ;
lin deconstruction_N = mkTerm "deconstruction_N" ;
lin deconstructionist_A = mkTerm "deconstructionist_A" ;
lin deconstructivism_N = mkTerm "deconstructivism_N" ;
lin decontaminate_V2 = mkTerm "decontaminate_V2" ;
lin decontamination_N = mkTerm "decontamination_N" ;
lin decontrol_V2 = mkTerm "decontrol_V2" ;
lin decor_N = mkTerm "decor_N" ;
lin decorate_V2 = mkTerm "decorate_V2" ;
lin decoration_N = mkTerm "decoration_N" ;
lin decorative_A = mkTerm "decorative_A" ;
lin decorativeness_N = mkTerm "decorativeness_N" ;
lin decorator_N = mkTerm "decorator_N" ;
lin decorous_A = mkTerm "decorous_A" ;
lin decortication_N = mkTerm "decortication_N" ;
lin decorum_N = mkTerm "decorum_N" ;
lin decoupage_N = mkTerm "decoupage_N" ;
lin decoy_N = mkTerm "decoy_N" ;
lin decoy_V2 = mkTerm "decoy_V2" ;
lin decrease_N = mkTerm "decrease_N" ;
lin decrease_V = mkTerm "decrease_V" ;
lin decrease_V2 = mkTerm "decrease_V2" ;
lin decree_N = mkTerm "decree_N" ;
lin decree_V2 = mkTerm "decree_V2" ;
lin decree_nisi_N = mkTerm "decree_nisi_N" ;
lin decrepit_A = mkTerm "decrepit_A" ;
lin decrepitation_N = mkTerm "decrepitation_N" ;
lin decrepitude_N = mkTerm "decrepitude_N" ;
lin decrescendo_A = mkTerm "decrescendo_A" ;
lin decrescendo_N = mkTerm "decrescendo_N" ;
lin decribe_V2 = mkTerm "decribe_V2" ;
lin decriminalization_N = mkTerm "decriminalization_N" ;
lin decry_V2 = mkTerm "decry_V2" ;
lin decubitus_N = mkTerm "decubitus_N" ;
lin decumary_N = mkTerm "decumary_N" ;
lin decurved_A = mkTerm "decurved_A" ;
lin decussate_A = mkTerm "decussate_A" ;
lin dedicate_V2 = mkTerm "dedicate_V2" ;
lin dedicated_A = mkTerm "dedicated_A" ;
lin dedication_N = mkTerm "dedication_N" ;
lin dedifferentiated_A = mkTerm "dedifferentiated_A" ;
lin dedifferentiation_N = mkTerm "dedifferentiation_N" ;
lin deduce_V2 = mkTerm "deduce_V2" ;
lin deducible_A = mkTerm "deducible_A" ;
lin deduct_V2 = mkTerm "deduct_V2" ;
lin deductible_A = mkTerm "deductible_A" ;
lin deductible_N = mkTerm "deductible_N" ;
lin deduction_N = mkTerm "deduction_N" ;
lin deductive_A = mkTerm "deductive_A" ;
lin deed_N = mkTerm "deed_N" ;
lin deed_box_N = mkTerm "deed_box_N" ;
lin deedpoll_N = mkTerm "deedpoll_N" ;
lin deem_V2 = mkTerm "deem_V2" ;
lin deem_V2A = mkTerm "deem_V2A" ;
lin deem_V2V = mkTerm "deem_V2V" ;
lin deep_A = mkTerm "deep_A" ;
lin deep_Adv = mkTerm "deep_Adv" ;
lin deep_N = mkTerm "deep_N" ;
lin deep_freeze_N = mkTerm "deep_freeze_N" ;
lin deep_freeze_V2 = mkTerm "deep_freeze_V2" ;
lin deep_laid_A = mkTerm "deep_laid_A" ;
lin deep_mined_A = mkTerm "deep_mined_A" ;
lin deep_rooted_A = mkTerm "deep_rooted_A" ;
lin deep_sea_A = mkTerm "deep_sea_A" ;
lin deep_seated_A = mkTerm "deep_seated_A" ;
lin deep_water_A = mkTerm "deep_water_A" ;
lin deepen_V = mkTerm "deepen_V" ;
lin deepen_V2 = mkTerm "deepen_V2" ;
lin deepening_N = mkTerm "deepening_N" ;
lin deepness_N = mkTerm "deepness_N" ;
lin deer_N = mkTerm "deer_N" ;
lin deerberry_N = mkTerm "deerberry_N" ;
lin deerskin_N = mkTerm "deerskin_N" ;
lin deerstalker_N = mkTerm "deerstalker_N" ;
lin deerstalking_N = mkTerm "deerstalking_N" ;
lin deface_V2 = mkTerm "deface_V2" ;
lin defacement_N = mkTerm "defacement_N" ;
lin defalcation_N = mkTerm "defalcation_N" ;
lin defamation_N = mkTerm "defamation_N" ;
lin defamatory_A = mkTerm "defamatory_A" ;
lin defame_V2 = mkTerm "defame_V2" ;
lin defamer_N = mkTerm "defamer_N" ;
lin default_N = mkTerm "default_N" ;
lin default_V = mkTerm "default_V" ;
lin defaulter_N = mkTerm "defaulter_N" ;
lin defeasible_A = mkTerm "defeasible_A" ;
lin defeat_N = mkTerm "defeat_N" ;
lin defeat_V2 = mkTerm "defeat_V2" ;
lin defeated_N = mkTerm "defeated_N" ;
lin defeatism_N = mkTerm "defeatism_N" ;
lin defeatist_N = mkTerm "defeatist_N" ;
lin defecate_V = mkTerm "defecate_V" ;
lin defecation_N = mkTerm "defecation_N" ;
lin defecator_N = mkTerm "defecator_N" ;
lin defect_N = mkTerm "defect_N" ;
lin defect_V = mkTerm "defect_V" ;
lin defection_N = mkTerm "defection_N" ;
lin defective_A = mkTerm "defective_A" ;
lin defectiveness_N = mkTerm "defectiveness_N" ;
lin defector_N = mkTerm "defector_N" ;
lin defence_N = mkTerm "defence_N" ;
lin defenceless_A = mkTerm "defenceless_A" ;
lin defencelessness_N = mkTerm "defencelessness_N" ;
lin defend_V2 = mkTerm "defend_V2" ;
lin defendable_A = mkTerm "defendable_A" ;
lin defendant_N = mkTerm "defendant_N" ;
lin defenderFem_N = mkTerm "defenderFem_N" ;
lin defenderMasc_N = mkTerm "defenderMasc_N" ;
lin defenestration_N = mkTerm "defenestration_N" ;
lin defense_N = mkTerm "defense_N" ;
lin defenseless_A = mkTerm "defenseless_A" ;
lin defenseless_Adv = mkTerm "defenseless_Adv" ;
lin defenselessness_N = mkTerm "defenselessness_N" ;
lin defensibility_N = mkTerm "defensibility_N" ;
lin defensible_A = mkTerm "defensible_A" ;
lin defensive_A = mkTerm "defensive_A" ;
lin defensive_N = mkTerm "defensive_N" ;
lin defensiveness_N = mkTerm "defensiveness_N" ;
lin defer_V = mkTerm "defer_V" ;
lin defer_V2 = mkTerm "defer_V2" ;
lin deference_N = mkTerm "deference_N" ;
lin deferent_A = mkTerm "deferent_A" ;
lin deferential_A = mkTerm "deferential_A" ;
lin deferment_N = mkTerm "deferment_N" ;
lin deferral_N = mkTerm "deferral_N" ;
lin defervescence_N = mkTerm "defervescence_N" ;
lin defervescent_A = mkTerm "defervescent_A" ;
lin defiance_N = mkTerm "defiance_N" ;
lin defiant_A = mkTerm "defiant_A" ;
lin defibrillation_N = mkTerm "defibrillation_N" ;
lin defibrillator_N = mkTerm "defibrillator_N" ;
lin deficiency_N = mkTerm "deficiency_N" ;
lin deficient_A = mkTerm "deficient_A" ;
lin deficit_N = mkTerm "deficit_N" ;
lin defilade_N = mkTerm "defilade_N" ;
lin defile_N = mkTerm "defile_N" ;
lin defile_V = mkTerm "defile_V" ;
lin defile_V2 = mkTerm "defile_V2" ;
lin defilement_N = mkTerm "defilement_N" ;
lin definable_A = mkTerm "definable_A" ;
lin define_V = mkTerm "define_V" ;
lin define_V2 = mkTerm "define_V2" ;
lin definite_A = mkTerm "definite_A" ;
lin definition_N = mkTerm "definition_N" ;
lin definitive_A = mkTerm "definitive_A" ;
lin deflagration_N = mkTerm "deflagration_N" ;
lin deflate_V2 = mkTerm "deflate_V2" ;
lin deflation_N = mkTerm "deflation_N" ;
lin deflationary_A = mkTerm "deflationary_A" ;
lin deflator_N = mkTerm "deflator_N" ;
lin deflect_V = mkTerm "deflect_V" ;
lin deflect_V2 = mkTerm "deflect_V2" ;
lin deflection_N = mkTerm "deflection_N" ;
lin deflective_A = mkTerm "deflective_A" ;
lin deflector_N = mkTerm "deflector_N" ;
lin defloration_N = mkTerm "defloration_N" ;
lin deflower_V2 = mkTerm "deflower_V2" ;
lin defoliant_N = mkTerm "defoliant_N" ;
lin defoliate_A = mkTerm "defoliate_A" ;
lin defoliate_V2 = mkTerm "defoliate_V2" ;
lin defoliation_N = mkTerm "defoliation_N" ;
lin defoliator_N = mkTerm "defoliator_N" ;
lin deforest_V2 = mkTerm "deforest_V2" ;
lin deforestation_N = mkTerm "deforestation_N" ;
lin deform_V2 = mkTerm "deform_V2" ;
lin deformation_N = mkTerm "deformation_N" ;
lin deformational_A = mkTerm "deformational_A" ;
lin deformity_N = mkTerm "deformity_N" ;
lin defraud_V2 = mkTerm "defraud_V2" ;
lin defray_V2 = mkTerm "defray_V2" ;
lin defrayal_N = mkTerm "defrayal_N" ;
lin defrayment_N = mkTerm "defrayment_N" ;
lin defrock_V2 = mkTerm "defrock_V2" ;
lin defrost_V2 = mkTerm "defrost_V2" ;
lin defroster_N = mkTerm "defroster_N" ;
lin deft_A = mkTerm "deft_A" ;
lin deftness_N = mkTerm "deftness_N" ;
lin defunct_A = mkTerm "defunct_A" ;
lin defuse_V2 = mkTerm "defuse_V2" ;
lin defy_V2 = mkTerm "defy_V2" ;
lin defy_V2V = mkTerm "defy_V2V" ;
lin degage_A = mkTerm "degage_A" ;
lin degauss_V2 = mkTerm "degauss_V2" ;
lin degaussing_N = mkTerm "degaussing_N" ;
lin degeneracy_N = mkTerm "degeneracy_N" ;
lin degenerate_A = mkTerm "degenerate_A" ;
lin degenerate_N = mkTerm "degenerate_N" ;
lin degenerate_V = mkTerm "degenerate_V" ;
lin degeneration_N = mkTerm "degeneration_N" ;
lin degenerative_A = mkTerm "degenerative_A" ;
lin degradation_N = mkTerm "degradation_N" ;
lin degrade_V2 = mkTerm "degrade_V2" ;
lin degree_1_N = mkTerm "degree_1_N" ;
lin degree_2_N = mkTerm "degree_2_N" ;
lin degree_3_N = mkTerm "degree_3_N" ;
lin degressive_A = mkTerm "degressive_A" ;
lin dehiscence_N = mkTerm "dehiscence_N" ;
lin dehiscent_A = mkTerm "dehiscent_A" ;
lin dehorn_V2 = mkTerm "dehorn_V2" ;
lin dehumanization_N = mkTerm "dehumanization_N" ;
lin dehumanize_V2 = mkTerm "dehumanize_V2" ;
lin dehydrate_V2 = mkTerm "dehydrate_V2" ;
lin dehydration_N = mkTerm "dehydration_N" ;
lin deictic_A = mkTerm "deictic_A" ;
lin deictic_N = mkTerm "deictic_N" ;
lin deific_A = mkTerm "deific_A" ;
lin deification_N = mkTerm "deification_N" ;
lin deify_V2 = mkTerm "deify_V2" ;
lin deign_V = mkTerm "deign_V" ;
lin deinocheirus_N = mkTerm "deinocheirus_N" ;
lin deinonychus_N = mkTerm "deinonychus_N" ;
lin deipnosophist_N = mkTerm "deipnosophist_N" ;
lin deirdre_PN = mkTerm "deirdre_PN" ;
lin deism_N = mkTerm "deism_N" ;
lin deist_A = mkTerm "deist_A" ;
lin deist_N = mkTerm "deist_N" ;
lin deity_N = mkTerm "deity_N" ;
lin deixis_N = mkTerm "deixis_N" ;
lin deject_V2 = mkTerm "deject_V2" ;
lin dejectedly_Adv = mkTerm "dejectedly_Adv" ;
lin dejection_N = mkTerm "dejection_N" ;
lin dekagram_N = mkTerm "dekagram_N" ;
lin dekaliter_N = mkTerm "dekaliter_N" ;
lin dekko_N = mkTerm "dekko_N" ;
lin delavirdine_N = mkTerm "delavirdine_N" ;
lin delaware_PN = mkTerm "delaware_PN" ;
lin delay_N = mkTerm "delay_N" ;
lin delay_V = mkTerm "delay_V" ;
lin delay_V2 = mkTerm "delay_V2" ;
lin delayed_action_A = mkTerm "delayed_action_A" ;
lin delayed_action_N = mkTerm "delayed_action_N" ;
lin delayer_N = mkTerm "delayer_N" ;
lin delectability_N = mkTerm "delectability_N" ;
lin delectable_A = mkTerm "delectable_A" ;
lin delectation_N = mkTerm "delectation_N" ;
lin delegacy_N = mkTerm "delegacy_N" ;
lin delegate_N = mkTerm "delegate_N" ;
lin delegate_V2 = mkTerm "delegate_V2" ;
lin delegating_N = mkTerm "delegating_N" ;
lin delegation_N = mkTerm "delegation_N" ;
lin delete_V2 = mkTerm "delete_V2" ;
lin deleterious_A = mkTerm "deleterious_A" ;
lin deletion_N = mkTerm "deletion_N" ;
lin delf_N = mkTerm "delf_N" ;
lin delft_N = mkTerm "delft_N" ;
lin delhi_PN = mkTerm "delhi_PN" ;
lin deliberate_A = mkTerm "deliberate_A" ;
lin deliberate_V = mkTerm "deliberate_V" ;
lin deliberate_V2 = mkTerm "deliberate_V2" ;
lin deliberation_N = mkTerm "deliberation_N" ;
lin deliberative_A = mkTerm "deliberative_A" ;
lin delible_A = mkTerm "delible_A" ;
lin delicacy_N = mkTerm "delicacy_N" ;
lin delicate_A = mkTerm "delicate_A" ;
lin delicatessen_N = mkTerm "delicatessen_N" ;
lin delicious_A = mkTerm "delicious_A" ;
lin delight_N = mkTerm "delight_N" ;
lin delight_V = mkTerm "delight_V" ;
lin delight_V2 = mkTerm "delight_V2" ;
lin delighted_A = mkTerm "delighted_A" ;
lin delightful_A = mkTerm "delightful_A" ;
lin delimit_V2 = mkTerm "delimit_V2" ;
lin delimitate_V2 = mkTerm "delimitate_V2" ;
lin delimitation_N = mkTerm "delimitation_N" ;
lin delineate_V2 = mkTerm "delineate_V2" ;
lin delineation_N = mkTerm "delineation_N" ;
lin delineative_A = mkTerm "delineative_A" ;
lin delinquency_N = mkTerm "delinquency_N" ;
lin delinquent_A = mkTerm "delinquent_A" ;
lin delinquent_N = mkTerm "delinquent_N" ;
lin deliquescent_A = mkTerm "deliquescent_A" ;
lin delirious_A = mkTerm "delirious_A" ;
lin delirium_N = mkTerm "delirium_N" ;
lin delirium_tremens_N = mkTerm "delirium_tremens_N" ;
lin deliver_V = mkTerm "deliver_V" ;
lin deliver_V2 = mkTerm "deliver_V2" ;
lin deliverable_A = mkTerm "deliverable_A" ;
lin deliverable_N = mkTerm "deliverable_N" ;
lin deliverance_N = mkTerm "deliverance_N" ;
lin deliverer_N = mkTerm "deliverer_N" ;
lin delivery_N = mkTerm "delivery_N" ;
lin deliveryman_N = mkTerm "deliveryman_N" ;
lin dell_N = mkTerm "dell_N" ;
lin delouse_V2 = mkTerm "delouse_V2" ;
lin delphic_A = mkTerm "delphic_A" ;
lin delphinium_N = mkTerm "delphinium_N" ;
lin delta_N = mkTerm "delta_N" ;
lin deltoid_A = mkTerm "deltoid_A" ;
lin deltoid_N = mkTerm "deltoid_N" ;
lin delude_V2 = mkTerm "delude_V2" ;
lin deluge_N = mkTerm "deluge_N" ;
lin deluge_V2 = mkTerm "deluge_V2" ;
lin delusion_N = mkTerm "delusion_N" ;
lin delusional_A = mkTerm "delusional_A" ;
lin delusive_A = mkTerm "delusive_A" ;
lin deluxe_A = mkTerm "deluxe_A" ;
lin delve_V = mkTerm "delve_V" ;
lin delve_V2 = mkTerm "delve_V2" ;
lin demagnetization_N = mkTerm "demagnetization_N" ;
lin demagnetize_V2 = mkTerm "demagnetize_V2" ;
lin demagogic_A = mkTerm "demagogic_A" ;
lin demagogue_N = mkTerm "demagogue_N" ;
lin demagoguery_N = mkTerm "demagoguery_N" ;
lin demagogy_N = mkTerm "demagogy_N" ;
lin demand_N = mkTerm "demand_N" ;
lin demand_V2 = mkTerm "demand_V2" ;
lin demand_VS = mkTerm "demand_VS" ;
lin demander_N = mkTerm "demander_N" ;
lin demanding_A = mkTerm "demanding_A" ;
lin demantoid_N = mkTerm "demantoid_N" ;
lin demarcate_V2 = mkTerm "demarcate_V2" ;
lin demarcation_N = mkTerm "demarcation_N" ;
lin demarche_N = mkTerm "demarche_N" ;
lin demean_V2 = mkTerm "demean_V2" ;
lin demeaning_A = mkTerm "demeaning_A" ;
lin demeanor_N = mkTerm "demeanor_N" ;
lin demeanour_N = mkTerm "demeanour_N" ;
lin demented_A = mkTerm "demented_A" ;
lin dementia_N = mkTerm "dementia_N" ;
lin demerara_N = mkTerm "demerara_N" ;
lin demerit_N = mkTerm "demerit_N" ;
lin demesne_N = mkTerm "demesne_N" ;
lin demiglace_N = mkTerm "demiglace_N" ;
lin demigod_N = mkTerm "demigod_N" ;
lin demijohn_N = mkTerm "demijohn_N" ;
lin demilitarization_N = mkTerm "demilitarization_N" ;
lin demilitarize_V2 = mkTerm "demilitarize_V2" ;
lin demimondaine_N = mkTerm "demimondaine_N" ;
lin demimonde_N = mkTerm "demimonde_N" ;
lin demineralization_N = mkTerm "demineralization_N" ;
lin demise_N = mkTerm "demise_N" ;
lin demist_V2 = mkTerm "demist_V2" ;
lin demister_N = mkTerm "demister_N" ;
lin demitasse_N = mkTerm "demitasse_N" ;
lin demiurge_N = mkTerm "demiurge_N" ;
lin demo_N = mkTerm "demo_N" ;
lin demob_V2 = mkTerm "demob_V2" ;
lin demobilization_N = mkTerm "demobilization_N" ;
lin demobilize_V2 = mkTerm "demobilize_V2" ;
lin democracy_N = mkTerm "democracy_N" ;
lin democrat_N = mkTerm "democrat_N" ;
lin democratic_A = mkTerm "democratic_A" ;
lin democratization_N = mkTerm "democratization_N" ;
lin democratize_V2 = mkTerm "democratize_V2" ;
lin demode_A = mkTerm "demode_A" ;
lin demodulation_N = mkTerm "demodulation_N" ;
lin demographer_N = mkTerm "demographer_N" ;
lin demographic_A = mkTerm "demographic_A" ;
lin demographic_N = mkTerm "demographic_N" ;
lin demography_N = mkTerm "demography_N" ;
lin demolish_V2 = mkTerm "demolish_V2" ;
lin demolition_N = mkTerm "demolition_N" ;
lin demon_N = mkTerm "demon_N" ;
lin demonetization_N = mkTerm "demonetization_N" ;
lin demonetize_V2 = mkTerm "demonetize_V2" ;
lin demoniac_A = mkTerm "demoniac_A" ;
lin demoniac_N = mkTerm "demoniac_N" ;
lin demoniacal_A = mkTerm "demoniacal_A" ;
lin demonic_A = mkTerm "demonic_A" ;
lin demonization_N = mkTerm "demonization_N" ;
lin demonize_V2 = mkTerm "demonize_V2" ;
lin demonstrability_N = mkTerm "demonstrability_N" ;
lin demonstrable_A = mkTerm "demonstrable_A" ;
lin demonstrate_V = mkTerm "demonstrate_V" ;
lin demonstrate_V2 = mkTerm "demonstrate_V2" ;
lin demonstrate_VS = mkTerm "demonstrate_VS" ;
lin demonstration_N = mkTerm "demonstration_N" ;
lin demonstrative_A = mkTerm "demonstrative_A" ;
lin demonstrativeness_N = mkTerm "demonstrativeness_N" ;
lin demonstrator_N = mkTerm "demonstrator_N" ;
lin demoralization_N = mkTerm "demoralization_N" ;
lin demoralize_V2 = mkTerm "demoralize_V2" ;
lin demoralizing_A = mkTerm "demoralizing_A" ;
lin demote_V2 = mkTerm "demote_V2" ;
lin demotic_A = mkTerm "demotic_A" ;
lin demotion_N = mkTerm "demotion_N" ;
lin demulcent_A = mkTerm "demulcent_A" ;
lin demulcent_N = mkTerm "demulcent_N" ;
lin demur_N = mkTerm "demur_N" ;
lin demur_V = mkTerm "demur_V" ;
lin demur_VS = mkTerm "demur_VS" ;
lin demure_A = mkTerm "demure_A" ;
lin demureness_N = mkTerm "demureness_N" ;
lin demurrage_N = mkTerm "demurrage_N" ;
lin demurrer_N = mkTerm "demurrer_N" ;
lin demyelination_N = mkTerm "demyelination_N" ;
lin demythologization_N = mkTerm "demythologization_N" ;
lin demythologized_A = mkTerm "demythologized_A" ;
lin den_N = mkTerm "den_N" ;
lin denain_PN = mkTerm "denain_PN" ;
lin denar_N = mkTerm "denar_N" ;
lin denary_A = mkTerm "denary_A" ;
lin denationalization_N = mkTerm "denationalization_N" ;
lin denationalize_V2 = mkTerm "denationalize_V2" ;
lin denaturant_N = mkTerm "denaturant_N" ;
lin denatured_A = mkTerm "denatured_A" ;
lin denazification_N = mkTerm "denazification_N" ;
lin denbigh_PN = mkTerm "denbigh_PN" ;
lin dendrite_N = mkTerm "dendrite_N" ;
lin dendritic_A = mkTerm "dendritic_A" ;
lin dendrobium_N = mkTerm "dendrobium_N" ;
lin dengue_N = mkTerm "dengue_N" ;
lin deniable_A = mkTerm "deniable_A" ;
lin denial_N = mkTerm "denial_N" ;
lin denier_N = mkTerm "denier_N" ;
lin denigrate_V2 = mkTerm "denigrate_V2" ;
lin denigration_N = mkTerm "denigration_N" ;
lin denim_N = mkTerm "denim_N" ;
lin denis_PN = mkTerm "denis_PN" ;
lin denise_PN = mkTerm "denise_PN" ;
lin denizen_N = mkTerm "denizen_N" ;
lin denmark_PN = mkTerm "denmark_PN" ;
lin dennis_PN = mkTerm "dennis_PN" ;
lin denny_PN = mkTerm "denny_PN" ;
lin denominate_V2 = mkTerm "denominate_V2" ;
lin denomination_N = mkTerm "denomination_N" ;
lin denominational_A = mkTerm "denominational_A" ;
lin denominationalism_N = mkTerm "denominationalism_N" ;
lin denominator_N = mkTerm "denominator_N" ;
lin denotative_A = mkTerm "denotative_A" ;
lin denotatum_N = mkTerm "denotatum_N" ;
lin denote_V2 = mkTerm "denote_V2" ;
lin denouement_N = mkTerm "denouement_N" ;
lin denounce_V2 = mkTerm "denounce_V2" ;
lin dense_A = mkTerm "dense_A" ;
lin denseness_N = mkTerm "denseness_N" ;
lin densimeter_N = mkTerm "densimeter_N" ;
lin densitometer_N = mkTerm "densitometer_N" ;
lin densitometry_N = mkTerm "densitometry_N" ;
lin density_N = mkTerm "density_N" ;
lin dent_N = mkTerm "dent_N" ;
lin dent_V = mkTerm "dent_V" ;
lin dent_V2 = mkTerm "dent_V2" ;
lin dental_A = mkTerm "dental_A" ;
lin dentate_A = mkTerm "dentate_A" ;
lin denticle_N = mkTerm "denticle_N" ;
lin denticulate_A = mkTerm "denticulate_A" ;
lin dentifrice_N = mkTerm "dentifrice_N" ;
lin dentine_N = mkTerm "dentine_N" ;
lin dentist_N = mkTerm "dentist_N" ;
lin dentistry_N = mkTerm "dentistry_N" ;
lin dentition_N = mkTerm "dentition_N" ;
lin denture_N = mkTerm "denture_N" ;
lin denudation_N = mkTerm "denudation_N" ;
lin denude_V2 = mkTerm "denude_V2" ;
lin denunciation_N = mkTerm "denunciation_N" ;
lin denver_PN = mkTerm "denver_PN" ;
lin deny_V2 = mkTerm "deny_V2" ;
lin deny_V3 = mkTerm "deny_V3" ;
lin deodar_N = mkTerm "deodar_N" ;
lin deodorant_N = mkTerm "deodorant_N" ;
lin deodorize_V2 = mkTerm "deodorize_V2" ;
lin deossification_N = mkTerm "deossification_N" ;
lin deoxyadenosine_N = mkTerm "deoxyadenosine_N" ;
lin deoxycytidine_N = mkTerm "deoxycytidine_N" ;
lin deoxyguanosine_N = mkTerm "deoxyguanosine_N" ;
lin deoxyribose_N = mkTerm "deoxyribose_N" ;
lin deoxythymidine_N = mkTerm "deoxythymidine_N" ;
lin dep_PN = mkTerm "dep_PN" ;
lin depart_V = mkTerm "depart_V" ;
lin departed_A = mkTerm "departed_A" ;
lin departed_N = mkTerm "departed_N" ;
lin departer_N = mkTerm "departer_N" ;
lin department_N = mkTerm "department_N" ;
lin departmental_A = mkTerm "departmental_A" ;
lin departure_N = mkTerm "departure_N" ;
lin depend_V = mkTerm "depend_V" ;
lin dependability_N = mkTerm "dependability_N" ;
lin dependable_A = mkTerm "dependable_A" ;
lin dependant_N = mkTerm "dependant_N" ;
lin dependence_N = mkTerm "dependence_N" ;
lin dependency_N = mkTerm "dependency_N" ;
lin dependent_A = mkTerm "dependent_A" ;
lin dependent_N = mkTerm "dependent_N" ;
lin depending_A = mkTerm "depending_A" ;
lin depersonalization_N = mkTerm "depersonalization_N" ;
lin depict_V2 = mkTerm "depict_V2" ;
lin depicting_N = mkTerm "depicting_N" ;
lin depiction_N = mkTerm "depiction_N" ;
lin depigmentation_N = mkTerm "depigmentation_N" ;
lin depilation_N = mkTerm "depilation_N" ;
lin depilatory_A = mkTerm "depilatory_A" ;
lin depilatory_N = mkTerm "depilatory_N" ;
lin depilous_A = mkTerm "depilous_A" ;
lin deplane_V = mkTerm "deplane_V" ;
lin depletable_A = mkTerm "depletable_A" ;
lin deplete_V2 = mkTerm "deplete_V2" ;
lin depletion_N = mkTerm "depletion_N" ;
lin deplorable_A = mkTerm "deplorable_A" ;
lin deplore_V2 = mkTerm "deplore_V2" ;
lin deploy_V = mkTerm "deploy_V" ;
lin deploy_V2 = mkTerm "deploy_V2" ;
lin deployment_N = mkTerm "deployment_N" ;
lin depolarization_N = mkTerm "depolarization_N" ;
lin deponent_N = mkTerm "deponent_N" ;
lin depopulate_V2 = mkTerm "depopulate_V2" ;
lin depopulation_N = mkTerm "depopulation_N" ;
lin deport_V2 = mkTerm "deport_V2" ;
lin deportation_N = mkTerm "deportation_N" ;
lin deportee_N = mkTerm "deportee_N" ;
lin deportment_N = mkTerm "deportment_N" ;
lin depose_V = mkTerm "depose_V" ;
lin depose_V2 = mkTerm "depose_V2" ;
lin deposit_N = mkTerm "deposit_N" ;
lin deposit_V2 = mkTerm "deposit_V2" ;
lin deposition_N = mkTerm "deposition_N" ;
lin depositor_N = mkTerm "depositor_N" ;
lin depository_N = mkTerm "depository_N" ;
lin depot_N = mkTerm "depot_N" ;
lin deprave_V2 = mkTerm "deprave_V2" ;
lin depravity_N = mkTerm "depravity_N" ;
lin deprecate_V2 = mkTerm "deprecate_V2" ;
lin deprecation_N = mkTerm "deprecation_N" ;
lin deprecative_A = mkTerm "deprecative_A" ;
lin depreciate_V = mkTerm "depreciate_V" ;
lin depreciate_V2 = mkTerm "depreciate_V2" ;
lin depreciation_N = mkTerm "depreciation_N" ;
lin depreciatory_A = mkTerm "depreciatory_A" ;
lin depredation_N = mkTerm "depredation_N" ;
lin depress_V2 = mkTerm "depress_V2" ;
lin depressant_A = mkTerm "depressant_A" ;
lin depressed_A = mkTerm "depressed_A" ;
lin depressing_A = mkTerm "depressing_A" ;
lin depression_N = mkTerm "depression_N" ;
lin depressive_A = mkTerm "depressive_A" ;
lin depressive_N = mkTerm "depressive_N" ;
lin depressor_N = mkTerm "depressor_N" ;
lin deprivation_N = mkTerm "deprivation_N" ;
lin deprive_V2 = mkTerm "deprive_V2" ;
lin dept_PN = mkTerm "dept_PN" ;
lin depth_N = mkTerm "depth_N" ;
lin depth_bomb_N = mkTerm "depth_bomb_N" ;
lin depth_charge_N = mkTerm "depth_charge_N" ;
lin depths_N = mkTerm "depths_N" ;
lin deputation_N = mkTerm "deputation_N" ;
lin depute_V2 = mkTerm "depute_V2" ;
lin deputize_V = mkTerm "deputize_V" ;
lin deputy_N = mkTerm "deputy_N" ;
lin derail_V2 = mkTerm "derail_V2" ;
lin derailment_N = mkTerm "derailment_N" ;
lin derange_V2 = mkTerm "derange_V2" ;
lin derangement_N = mkTerm "derangement_N" ;
lin derate_V2 = mkTerm "derate_V2" ;
lin derby_N = mkTerm "derby_N" ;
lin derby_PN = mkTerm "derby_PN" ;
lin derbyshire_PN = mkTerm "derbyshire_PN" ;
lin deregulate_V2 = mkTerm "deregulate_V2" ;
lin deregulation_N = mkTerm "deregulation_N" ;
lin dereham_PN = mkTerm "dereham_PN" ;
lin derek_PN = mkTerm "derek_PN" ;
lin derelict_A = mkTerm "derelict_A" ;
lin derelict_N = mkTerm "derelict_N" ;
lin dereliction_N = mkTerm "dereliction_N" ;
lin derequisition_V2 = mkTerm "derequisition_V2" ;
lin derestrict_V2 = mkTerm "derestrict_V2" ;
lin deride_V2 = mkTerm "deride_V2" ;
lin derision_N = mkTerm "derision_N" ;
lin derisive_A = mkTerm "derisive_A" ;
lin derisory_A = mkTerm "derisory_A" ;
lin derivable_A = mkTerm "derivable_A" ;
lin derivation_N = mkTerm "derivation_N" ;
lin derivational_A = mkTerm "derivational_A" ;
lin derivative_A = mkTerm "derivative_A" ;
lin derivative_N = mkTerm "derivative_N" ;
lin derive_V = mkTerm "derive_V" ;
lin derive_V2 = mkTerm "derive_V2" ;
lin deriving_N = mkTerm "deriving_N" ;
lin dermabrasion_N = mkTerm "dermabrasion_N" ;
lin dermal_A = mkTerm "dermal_A" ;
lin dermatitis_N = mkTerm "dermatitis_N" ;
lin dermatoglyphic_N = mkTerm "dermatoglyphic_N" ;
lin dermatoglyphics_N = mkTerm "dermatoglyphics_N" ;
lin dermatologic_A = mkTerm "dermatologic_A" ;
lin dermatologistFem_N = mkTerm "dermatologistFem_N" ;
lin dermatologistMasc_N = mkTerm "dermatologistMasc_N" ;
lin dermatology_N = mkTerm "dermatology_N" ;
lin dermatome_N = mkTerm "dermatome_N" ;
lin dermatomycosis_N = mkTerm "dermatomycosis_N" ;
lin dermatomyositis_N = mkTerm "dermatomyositis_N" ;
lin dermatosis_N = mkTerm "dermatosis_N" ;
lin dermis_N = mkTerm "dermis_N" ;
lin derogate_V = mkTerm "derogate_V" ;
lin derogation_N = mkTerm "derogation_N" ;
lin derogative_A = mkTerm "derogative_A" ;
lin derogatory_A = mkTerm "derogatory_A" ;
lin derrick_N = mkTerm "derrick_N" ;
lin derring_do_N = mkTerm "derring_do_N" ;
lin derringer_N = mkTerm "derringer_N" ;
lin derris_N = mkTerm "derris_N" ;
lin derv_N = mkTerm "derv_N" ;
lin dervish_N = mkTerm "dervish_N" ;
lin des_N = mkTerm "des_N" ;
lin des_PN = mkTerm "des_PN" ;
lin desalinate_V2 = mkTerm "desalinate_V2" ;
lin desalination_N = mkTerm "desalination_N" ;
lin desalinization_N = mkTerm "desalinization_N" ;
lin desalinize_V2 = mkTerm "desalinize_V2" ;
lin desalt_V2 = mkTerm "desalt_V2" ;
lin descale_V2 = mkTerm "descale_V2" ;
lin descant_N = mkTerm "descant_N" ;
lin descant_V = mkTerm "descant_V" ;
lin descend_V = mkTerm "descend_V" ;
lin descend_V2 = mkTerm "descend_V2" ;
lin descendant_A = mkTerm "descendant_A" ;
lin descendant_N = mkTerm "descendant_N" ;
lin descendants_N = mkTerm "descendants_N" ;
lin descender_N = mkTerm "descender_N" ;
lin descent_N = mkTerm "descent_N" ;
lin describable_A = mkTerm "describable_A" ;
lin describe_V2 = mkTerm "describe_V2" ;
lin describe_VS = mkTerm "describe_VS" ;
lin description_N = mkTerm "description_N" ;
lin descriptive_A = mkTerm "descriptive_A" ;
lin descriptivism_N = mkTerm "descriptivism_N" ;
lin descriptor_N = mkTerm "descriptor_N" ;
lin descry_V2 = mkTerm "descry_V2" ;
lin desecrate_V2 = mkTerm "desecrate_V2" ;
lin desecration_N = mkTerm "desecration_N" ;
lin desegrated_A = mkTerm "desegrated_A" ;
lin desegregate_V2 = mkTerm "desegregate_V2" ;
lin desegregation_N = mkTerm "desegregation_N" ;
lin desensitization_N = mkTerm "desensitization_N" ;
lin desensitize_V2 = mkTerm "desensitize_V2" ;
lin desensitizing_A = mkTerm "desensitizing_A" ;
lin desert_A = mkTerm "desert_A" ;
lin desert_N = mkTerm "desert_N" ;
lin desert_V = mkTerm "desert_V" ;
lin desert_V2 = mkTerm "desert_V2" ;
lin deserter_N = mkTerm "deserter_N" ;
lin desertification_N = mkTerm "desertification_N" ;
lin desertion_N = mkTerm "desertion_N" ;
lin deserts_N = mkTerm "deserts_N" ;
lin deserve_V = mkTerm "deserve_V" ;
lin deserve_V2 = mkTerm "deserve_V2" ;
lin deserve_VV = mkTerm "deserve_VV" ;
lin deservedly_Adv = mkTerm "deservedly_Adv" ;
lin deservingness_N = mkTerm "deservingness_N" ;
lin deshabille_N = mkTerm "deshabille_N" ;
lin desiccant_N = mkTerm "desiccant_N" ;
lin desiccate_V2 = mkTerm "desiccate_V2" ;
lin desideratum_N = mkTerm "desideratum_N" ;
lin design_N = mkTerm "design_N" ;
lin design_V = mkTerm "design_V" ;
lin design_V2 = mkTerm "design_V2" ;
lin designate_A = mkTerm "designate_A" ;
lin designate_V = mkTerm "designate_V" ;
lin designate_V2 = mkTerm "designate_V2" ;
lin designate_V2V = mkTerm "designate_V2V" ;
lin designate_VS = mkTerm "designate_VS" ;
lin designation_N = mkTerm "designation_N" ;
lin designative_A = mkTerm "designative_A" ;
lin designatum_N = mkTerm "designatum_N" ;
lin designedly_Adv = mkTerm "designedly_Adv" ;
lin designer_N = mkTerm "designer_N" ;
lin designing_N = mkTerm "designing_N" ;
lin desipramine_N = mkTerm "desipramine_N" ;
lin desirability_N = mkTerm "desirability_N" ;
lin desirable_A = mkTerm "desirable_A" ;
lin desire_N = mkTerm "desire_N" ;
lin desire_V2 = mkTerm "desire_V2" ;
lin desired_A = mkTerm "desired_A" ;
lin desirous_A = mkTerm "desirous_A" ;
lin desist_V = mkTerm "desist_V" ;
lin desk_N = mkTerm "desk_N" ;
lin desktop_A = mkTerm "desktop_A" ;
lin desktop_N = mkTerm "desktop_N" ;
lin desmid_N = mkTerm "desmid_N" ;
lin desmond_PN = mkTerm "desmond_PN" ;
lin desolate_A = mkTerm "desolate_A" ;
lin desolate_V2 = mkTerm "desolate_V2" ;
lin desolation_N = mkTerm "desolation_N" ;
lin desorption_N = mkTerm "desorption_N" ;
lin despair_N = mkTerm "despair_N" ;
lin despair_V = mkTerm "despair_V" ;
lin despairingly_Adv = mkTerm "despairingly_Adv" ;
lin despatch_N = mkTerm "despatch_N" ;
lin despatch_V2 = mkTerm "despatch_V2" ;
lin desperado_N = mkTerm "desperado_N" ;
lin desperate_A = mkTerm "desperate_A" ;
lin desperate_N = mkTerm "desperate_N" ;
lin desperation_N = mkTerm "desperation_N" ;
lin despicable_A = mkTerm "despicable_A" ;
lin despisal_N = mkTerm "despisal_N" ;
lin despise_V2 = mkTerm "despise_V2" ;
lin despite_N = mkTerm "despite_N" ;
lin despite_Prep = mkTerm "despite_Prep" ;
lin despiteful_A = mkTerm "despiteful_A" ;
lin despoil_V2 = mkTerm "despoil_V2" ;
lin despondency_N = mkTerm "despondency_N" ;
lin despondent_A = mkTerm "despondent_A" ;
lin despot_N = mkTerm "despot_N" ;
lin despotic_A = mkTerm "despotic_A" ;
lin despotism_N = mkTerm "despotism_N" ;
lin desquamation_N = mkTerm "desquamation_N" ;
lin dessau_PN = mkTerm "dessau_PN" ;
lin dessert_N = mkTerm "dessert_N" ;
lin dessertspoon_N = mkTerm "dessertspoon_N" ;
lin dessertspoonful_N = mkTerm "dessertspoonful_N" ;
lin dessiatine_N = mkTerm "dessiatine_N" ;
lin destabilization_N = mkTerm "destabilization_N" ;
lin destalinization_N = mkTerm "destalinization_N" ;
lin destination_N = mkTerm "destination_N" ;
lin destine_V2 = mkTerm "destine_V2" ;
lin destine_V2V = mkTerm "destine_V2V" ;
lin destiny_N = mkTerm "destiny_N" ;
lin destitute_A = mkTerm "destitute_A" ;
lin destitution_N = mkTerm "destitution_N" ;
lin destroy_V2 = mkTerm "destroy_V2" ;
lin destroyable_A = mkTerm "destroyable_A" ;
lin destroyer_N = mkTerm "destroyer_N" ;
lin destructibility_N = mkTerm "destructibility_N" ;
lin destructible_A = mkTerm "destructible_A" ;
lin destruction_N = mkTerm "destruction_N" ;
lin destructive_A = mkTerm "destructive_A" ;
lin destructiveness_N = mkTerm "destructiveness_N" ;
lin desuetude_N = mkTerm "desuetude_N" ;
lin desultory_A = mkTerm "desultory_A" ;
lin detach_V2 = mkTerm "detach_V2" ;
lin detachable_A = mkTerm "detachable_A" ;
lin detachment_N = mkTerm "detachment_N" ;
lin detail_N = mkTerm "detail_N" ;
lin detail_V2 = mkTerm "detail_V2" ;
lin detailed_A = mkTerm "detailed_A" ;
lin detain_V2 = mkTerm "detain_V2" ;
lin detainee_N = mkTerm "detainee_N" ;
lin detect_V2 = mkTerm "detect_V2" ;
lin detectable_A = mkTerm "detectable_A" ;
lin detection_N = mkTerm "detection_N" ;
lin detective_N = mkTerm "detective_N" ;
lin detector_N = mkTerm "detector_N" ;
lin detente_N = mkTerm "detente_N" ;
lin detention_N = mkTerm "detention_N" ;
lin deter_V2 = mkTerm "deter_V2" ;
lin detergency_N = mkTerm "detergency_N" ;
lin detergent_A = mkTerm "detergent_A" ;
lin detergent_N = mkTerm "detergent_N" ;
lin deteriorate_V = mkTerm "deteriorate_V" ;
lin deteriorate_V2 = mkTerm "deteriorate_V2" ;
lin deterioration_N = mkTerm "deterioration_N" ;
lin determent_N = mkTerm "determent_N" ;
lin determinable_A = mkTerm "determinable_A" ;
lin determinant_A = mkTerm "determinant_A" ;
lin determinant_N = mkTerm "determinant_N" ;
lin determinate_A = mkTerm "determinate_A" ;
lin determinateness_N = mkTerm "determinateness_N" ;
lin determination_N = mkTerm "determination_N" ;
lin determinative_A = mkTerm "determinative_A" ;
lin determinative_N = mkTerm "determinative_N" ;
lin determine_V = mkTerm "determine_V" ;
lin determine_V2 = mkTerm "determine_V2" ;
lin determine_V2V = mkTerm "determine_V2V" ;
lin determine_VS = mkTerm "determine_VS" ;
lin determine_VV = mkTerm "determine_VV" ;
lin determined_A = mkTerm "determined_A" ;
lin determiner_N = mkTerm "determiner_N" ;
lin determinism_N = mkTerm "determinism_N" ;
lin deterministic_A = mkTerm "deterministic_A" ;
lin deterrence_N = mkTerm "deterrence_N" ;
lin deterrent_A = mkTerm "deterrent_A" ;
lin deterrent_N = mkTerm "deterrent_N" ;
lin detest_V2 = mkTerm "detest_V2" ;
lin detestable_A = mkTerm "detestable_A" ;
lin detestation_N = mkTerm "detestation_N" ;
lin dethrone_V2 = mkTerm "dethrone_V2" ;
lin dethronement_N = mkTerm "dethronement_N" ;
lin detonate_V = mkTerm "detonate_V" ;
lin detonate_V2 = mkTerm "detonate_V2" ;
lin detonation_N = mkTerm "detonation_N" ;
lin detonative_A = mkTerm "detonative_A" ;
lin detonator_N = mkTerm "detonator_N" ;
lin detour_N = mkTerm "detour_N" ;
lin detour_V2 = mkTerm "detour_V2" ;
lin detox_N = mkTerm "detox_N" ;
lin detoxification_N = mkTerm "detoxification_N" ;
lin detract_V = mkTerm "detract_V" ;
lin detraction_N = mkTerm "detraction_N" ;
lin detractive_A = mkTerm "detractive_A" ;
lin detractor_N = mkTerm "detractor_N" ;
lin detrain_V = mkTerm "detrain_V" ;
lin detrain_V2 = mkTerm "detrain_V2" ;
lin detribalization_N = mkTerm "detribalization_N" ;
lin detribalize_V2 = mkTerm "detribalize_V2" ;
lin detriment_N = mkTerm "detriment_N" ;
lin detrimental_A = mkTerm "detrimental_A" ;
lin detritus_N = mkTerm "detritus_N" ;
lin detroit_PN = mkTerm "detroit_PN" ;
lin detumescence_N = mkTerm "detumescence_N" ;
lin deuce_N = mkTerm "deuce_N" ;
lin deuced_A = mkTerm "deuced_A" ;
lin deuteranopia_N = mkTerm "deuteranopia_N" ;
lin deuteranopic_A = mkTerm "deuteranopic_A" ;
lin deuterium_N = mkTerm "deuterium_N" ;
lin deuteron_N = mkTerm "deuteron_N" ;
lin deutschmark_N = mkTerm "deutschmark_N" ;
lin deutzia_N = mkTerm "deutzia_N" ;
lin devaluate_V2 = mkTerm "devaluate_V2" ;
lin devaluation_N = mkTerm "devaluation_N" ;
lin devalue_V2 = mkTerm "devalue_V2" ;
lin devastate_V2 = mkTerm "devastate_V2" ;
lin devastation_N = mkTerm "devastation_N" ;
lin develop_V = mkTerm "develop_V" ;
lin develop_V2 = mkTerm "develop_V2" ;
lin developed_A = mkTerm "developed_A" ;
lin developer_N = mkTerm "developer_N" ;
lin developing_A = mkTerm "developing_A" ;
lin development_N = mkTerm "development_N" ;
lin developmental_A = mkTerm "developmental_A" ;
lin deviant_A = mkTerm "deviant_A" ;
lin deviant_N = mkTerm "deviant_N" ;
lin deviate_V = mkTerm "deviate_V" ;
lin deviation_N = mkTerm "deviation_N" ;
lin deviationism_N = mkTerm "deviationism_N" ;
lin deviationist_N = mkTerm "deviationist_N" ;
lin device_N = mkTerm "device_N" ;
lin devil_N = mkTerm "devil_N" ;
lin devil_V = mkTerm "devil_V" ;
lin devil_V2 = mkTerm "devil_V2" ;
lin devil_may_care_A = mkTerm "devil_may_care_A" ;
lin devilish_A = mkTerm "devilish_A" ;
lin devilish_Adv = mkTerm "devilish_Adv" ;
lin devilment_N = mkTerm "devilment_N" ;
lin devilry_N = mkTerm "devilry_N" ;
lin deviltry_N = mkTerm "deviltry_N" ;
lin devilwood_N = mkTerm "devilwood_N" ;
lin devious_A = mkTerm "devious_A" ;
lin deviousness_N = mkTerm "deviousness_N" ;
lin devisal_N = mkTerm "devisal_N" ;
lin devise_N = mkTerm "devise_N" ;
lin devise_V2 = mkTerm "devise_V2" ;
lin devisee_N = mkTerm "devisee_N" ;
lin devising_N = mkTerm "devising_N" ;
lin devisor_N = mkTerm "devisor_N" ;
lin devitalization_N = mkTerm "devitalization_N" ;
lin devitalize_V2 = mkTerm "devitalize_V2" ;
lin devizes_PN = mkTerm "devizes_PN" ;
lin devoid_A = mkTerm "devoid_A" ;
lin devoir_N = mkTerm "devoir_N" ;
lin devolution_N = mkTerm "devolution_N" ;
lin devolve_V = mkTerm "devolve_V" ;
lin devolve_V2 = mkTerm "devolve_V2" ;
lin devon_PN = mkTerm "devon_PN" ;
lin devote_V2 = mkTerm "devote_V2" ;
lin devoted_A = mkTerm "devoted_A" ;
lin devotee_N = mkTerm "devotee_N" ;
lin devotion_N = mkTerm "devotion_N" ;
lin devotional_A = mkTerm "devotional_A" ;
lin devotional_N = mkTerm "devotional_N" ;
lin devour_V2 = mkTerm "devour_V2" ;
lin devourer_N = mkTerm "devourer_N" ;
lin devout_A = mkTerm "devout_A" ;
lin devoutness_N = mkTerm "devoutness_N" ;
lin devries_N = mkTerm "devries_N" ;
lin dew_N = mkTerm "dew_N" ;
lin dewberry_N = mkTerm "dewberry_N" ;
lin dewdrop_N = mkTerm "dewdrop_N" ;
lin dewlap_N = mkTerm "dewlap_N" ;
lin dewsbury_PN = mkTerm "dewsbury_PN" ;
lin dewy_A = mkTerm "dewy_A" ;
lin dexamethasone_N = mkTerm "dexamethasone_N" ;
lin dexter_A = mkTerm "dexter_A" ;
lin dexterity_N = mkTerm "dexterity_N" ;
lin dexterous_A = mkTerm "dexterous_A" ;
lin dextral_A = mkTerm "dextral_A" ;
lin dextrin_N = mkTerm "dextrin_N" ;
lin dextrocardia_N = mkTerm "dextrocardia_N" ;
lin dextrorotary_A = mkTerm "dextrorotary_A" ;
lin dextrorotation_N = mkTerm "dextrorotation_N" ;
lin dextrorse_A = mkTerm "dextrorse_A" ;
lin dextrose_N = mkTerm "dextrose_N" ;
lin dextrous_A = mkTerm "dextrous_A" ;
lin dg_PN = mkTerm "dg_PN" ;
lin dhak_N = mkTerm "dhak_N" ;
lin dhawa_N = mkTerm "dhawa_N" ;
lin dhole_N = mkTerm "dhole_N" ;
lin dhoti_N = mkTerm "dhoti_N" ;
lin dhow_N = mkTerm "dhow_N" ;
lin di_PN = mkTerm "di_PN" ;
lin diabatic_A = mkTerm "diabatic_A" ;
lin diabetes_N = mkTerm "diabetes_N" ;
lin diabetic_A = mkTerm "diabetic_A" ;
lin diabetic_N = mkTerm "diabetic_N" ;
lin diabolatry_N = mkTerm "diabolatry_N" ;
lin diabolic_A = mkTerm "diabolic_A" ;
lin diabolical_A = mkTerm "diabolical_A" ;
lin diabolism_N = mkTerm "diabolism_N" ;
lin diachronic_A = mkTerm "diachronic_A" ;
lin diacritic_A = mkTerm "diacritic_A" ;
lin diacritic_N = mkTerm "diacritic_N" ;
lin diacritical_A = mkTerm "diacritical_A" ;
lin diadem_N = mkTerm "diadem_N" ;
lin diadromous_A = mkTerm "diadromous_A" ;
lin diaeresis_N = mkTerm "diaeresis_N" ;
lin diagnosable_A = mkTerm "diagnosable_A" ;
lin diagnose_V2 = mkTerm "diagnose_V2" ;
lin diagnosis_N = mkTerm "diagnosis_N" ;
lin diagnostic_A = mkTerm "diagnostic_A" ;
lin diagnostician_N = mkTerm "diagnostician_N" ;
lin diagonal_A = mkTerm "diagonal_A" ;
lin diagonal_N = mkTerm "diagonal_N" ;
lin diagonalizable_A = mkTerm "diagonalizable_A" ;
lin diagonalization_N = mkTerm "diagonalization_N" ;
lin diagram_N = mkTerm "diagram_N" ;
lin diagrammatic_A = mkTerm "diagrammatic_A" ;
lin diagrammatical_A = mkTerm "diagrammatical_A" ;
lin diakinesis_N = mkTerm "diakinesis_N" ;
lin dial_N = mkTerm "dial_N" ;
lin dial_V2 = mkTerm "dial_V2" ;
lin dialect_N = mkTerm "dialect_N" ;
lin dialectal_A = mkTerm "dialectal_A" ;
lin dialectic_A = mkTerm "dialectic_A" ;
lin dialectic_N = mkTerm "dialectic_N" ;
lin dialectical_A = mkTerm "dialectical_A" ;
lin dialectician_N = mkTerm "dialectician_N" ;
lin dialectics_N = mkTerm "dialectics_N" ;
lin dialectology_N = mkTerm "dialectology_N" ;
lin dialog_N = mkTerm "dialog_N" ;
lin dialogue_N = mkTerm "dialogue_N" ;
lin dialysis_N = mkTerm "dialysis_N" ;
lin dialyzer_N = mkTerm "dialyzer_N" ;
lin diamagnet_N = mkTerm "diamagnet_N" ;
lin diamagnetic_A = mkTerm "diamagnetic_A" ;
lin diamagnetism_N = mkTerm "diamagnetism_N" ;
lin diamante_N = mkTerm "diamante_N" ;
lin diamantine_A = mkTerm "diamantine_A" ;
lin diameter_N = mkTerm "diameter_N" ;
lin diametral_A = mkTerm "diametral_A" ;
lin diametric_A = mkTerm "diametric_A" ;
lin diamine_N = mkTerm "diamine_N" ;
lin diamond_N = mkTerm "diamond_N" ;
lin diamondback_N = mkTerm "diamondback_N" ;
lin diana_PN = mkTerm "diana_PN" ;
lin diane_N = mkTerm "diane_N" ;
lin dianoetic_A = mkTerm "dianoetic_A" ;
lin diapason_N = mkTerm "diapason_N" ;
lin diapedesis_N = mkTerm "diapedesis_N" ;
lin diapensia_N = mkTerm "diapensia_N" ;
lin diaper_N = mkTerm "diaper_N" ;
lin diaphanous_A = mkTerm "diaphanous_A" ;
lin diapheromera_N = mkTerm "diapheromera_N" ;
lin diaphone_N = mkTerm "diaphone_N" ;
lin diaphoretic_A = mkTerm "diaphoretic_A" ;
lin diaphoretic_N = mkTerm "diaphoretic_N" ;
lin diaphragm_N = mkTerm "diaphragm_N" ;
lin diaphyseal_A = mkTerm "diaphyseal_A" ;
lin diaphysis_N = mkTerm "diaphysis_N" ;
lin diapir_N = mkTerm "diapir_N" ;
lin diapsid_N = mkTerm "diapsid_N" ;
lin diarchy_N = mkTerm "diarchy_N" ;
lin diarist_N = mkTerm "diarist_N" ;
lin diarrhea_N = mkTerm "diarrhea_N" ;
lin diarrheal_A = mkTerm "diarrheal_A" ;
lin diarrhoea_N = mkTerm "diarrhoea_N" ;
lin diary_N = mkTerm "diary_N" ;
lin diaspora_N = mkTerm "diaspora_N" ;
lin diastasis_N = mkTerm "diastasis_N" ;
lin diastema_N = mkTerm "diastema_N" ;
lin diastole_N = mkTerm "diastole_N" ;
lin diastolic_A = mkTerm "diastolic_A" ;
lin diastrophism_N = mkTerm "diastrophism_N" ;
lin diathermy_N = mkTerm "diathermy_N" ;
lin diathesis_N = mkTerm "diathesis_N" ;
lin diatom_N = mkTerm "diatom_N" ;
lin diatomic_A = mkTerm "diatomic_A" ;
lin diatonic_A = mkTerm "diatonic_A" ;
lin diatribe_N = mkTerm "diatribe_N" ;
lin diazepam_N = mkTerm "diazepam_N" ;
lin diazo_A = mkTerm "diazo_A" ;
lin diazonium_N = mkTerm "diazonium_N" ;
lin diazoxide_N = mkTerm "diazoxide_N" ;
lin dibber_N = mkTerm "dibber_N" ;
lin dibble_N = mkTerm "dibble_N" ;
lin dibble_V2 = mkTerm "dibble_V2" ;
lin dibranchiate_N = mkTerm "dibranchiate_N" ;
lin dibs_N = mkTerm "dibs_N" ;
lin dibucaine_N = mkTerm "dibucaine_N" ;
lin dicamptodon_N = mkTerm "dicamptodon_N" ;
lin dicarboxylic_A = mkTerm "dicarboxylic_A" ;
lin dice_N = mkTerm "dice_N" ;
lin dice_V = mkTerm "dice_V" ;
lin dice_V2 = mkTerm "dice_V2" ;
lin dice_box_N = mkTerm "dice_box_N" ;
lin dicer_N = mkTerm "dicer_N" ;
lin dicey_A = mkTerm "dicey_A" ;
lin dichloride_N = mkTerm "dichloride_N" ;
lin dichlorodiphenyltrichloroethane_N = mkTerm "dichlorodiphenyltrichloroethane_N" ;
lin dichondra_N = mkTerm "dichondra_N" ;
lin dichotomization_N = mkTerm "dichotomization_N" ;
lin dichotomous_A = mkTerm "dichotomous_A" ;
lin dichotomy_N = mkTerm "dichotomy_N" ;
lin dichroism_N = mkTerm "dichroism_N" ;
lin dichromacy_N = mkTerm "dichromacy_N" ;
lin dichromat_N = mkTerm "dichromat_N" ;
lin dichromatic_A = mkTerm "dichromatic_A" ;
lin dick_N = mkTerm "dick_N" ;
lin dick_PN = mkTerm "dick_PN" ;
lin dickens_N = mkTerm "dickens_N" ;
lin dicker_V = mkTerm "dicker_V" ;
lin dickey_N = mkTerm "dickey_N" ;
lin dickeybird_N = mkTerm "dickeybird_N" ;
lin dicky_A = mkTerm "dicky_A" ;
lin dicky_N = mkTerm "dicky_N" ;
lin dicky_PN = mkTerm "dicky_PN" ;
lin dicky_seat_N = mkTerm "dicky_seat_N" ;
lin dickybird_N = mkTerm "dickybird_N" ;
lin diclinous_A = mkTerm "diclinous_A" ;
lin dicloxacillin_N = mkTerm "dicloxacillin_N" ;
lin dicot_N = mkTerm "dicot_N" ;
lin dicotyledonous_A = mkTerm "dicotyledonous_A" ;
lin dictaphone_N = mkTerm "dictaphone_N" ;
lin dictate_N = mkTerm "dictate_N" ;
lin dictate_V = mkTerm "dictate_V" ;
lin dictate_V2 = mkTerm "dictate_V2" ;
lin dictate_VS = mkTerm "dictate_VS" ;
lin dictation_N = mkTerm "dictation_N" ;
lin dictator_N = mkTerm "dictator_N" ;
lin dictatorial_A = mkTerm "dictatorial_A" ;
lin dictatorship_N = mkTerm "dictatorship_N" ;
lin diction_N = mkTerm "diction_N" ;
lin dictionary_N = mkTerm "dictionary_N" ;
lin dictostylium_N = mkTerm "dictostylium_N" ;
lin dictum_N = mkTerm "dictum_N" ;
lin dictyopteran_A = mkTerm "dictyopteran_A" ;
lin dicumarol_N = mkTerm "dicumarol_N" ;
lin dicynodont_N = mkTerm "dicynodont_N" ;
lin didactic_A = mkTerm "didactic_A" ;
lin didacticism_N = mkTerm "didacticism_N" ;
lin didcot_PN = mkTerm "didcot_PN" ;
lin diddle_V2 = mkTerm "diddle_V2" ;
lin dideoxycytosine_N = mkTerm "dideoxycytosine_N" ;
lin dideoxyinosine_N = mkTerm "dideoxyinosine_N" ;
lin die_N = mkTerm "die_N" ;
lin die_V = mkTerm "die_V" ;
lin die_away_V = mkTerm "die_away_V" ;
lin die_back_V = mkTerm "die_back_V" ;
lin die_cast_A = mkTerm "die_cast_A" ;
lin die_down_V = mkTerm "die_down_V" ;
lin die_for_V2 = mkTerm "die_for_V2" ;
lin die_hard_N = mkTerm "die_hard_N" ;
lin die_off_V = mkTerm "die_off_V" ;
lin die_out_V = mkTerm "die_out_V" ;
lin dieback_N = mkTerm "dieback_N" ;
lin diemaker_N = mkTerm "diemaker_N" ;
lin diencephalon_N = mkTerm "diencephalon_N" ;
lin dieresis_N = mkTerm "dieresis_N" ;
lin diesel_N = mkTerm "diesel_N" ;
lin diestock_N = mkTerm "diestock_N" ;
lin diestrous_A = mkTerm "diestrous_A" ;
lin diestrus_N = mkTerm "diestrus_N" ;
lin diet_N = mkTerm "diet_N" ;
lin diet_V = mkTerm "diet_V" ;
lin diet_V2 = mkTerm "diet_V2" ;
lin dietary_A = mkTerm "dietary_A" ;
lin dietary_N = mkTerm "dietary_N" ;
lin dieter_N = mkTerm "dieter_N" ;
lin dietetics_N = mkTerm "dietetics_N" ;
lin diethylstilbesterol_N = mkTerm "diethylstilbesterol_N" ;
lin diethylstilbestrol_N = mkTerm "diethylstilbestrol_N" ;
lin dietician_N = mkTerm "dietician_N" ;
lin dietitian_N = mkTerm "dietitian_N" ;
lin differ_V = mkTerm "differ_V" ;
lin difference_N = mkTerm "difference_N" ;
lin different_A = mkTerm "different_A" ;
lin differentia_N = mkTerm "differentia_N" ;
lin differentiable_A = mkTerm "differentiable_A" ;
lin differential_A = mkTerm "differential_A" ;
lin differential_N = mkTerm "differential_N" ;
lin differentiate_V = mkTerm "differentiate_V" ;
lin differentiate_V2 = mkTerm "differentiate_V2" ;
lin differentiation_N = mkTerm "differentiation_N" ;
lin differentiator_N = mkTerm "differentiator_N" ;
lin difficult_A = mkTerm "difficult_A" ;
lin difficulty_N = mkTerm "difficulty_N" ;
lin diffidence_N = mkTerm "diffidence_N" ;
lin diffident_A = mkTerm "diffident_A" ;
lin difflugia_N = mkTerm "difflugia_N" ;
lin diffract_V2 = mkTerm "diffract_V2" ;
lin diffraction_N = mkTerm "diffraction_N" ;
lin diffuse_A = mkTerm "diffuse_A" ;
lin diffuse_V = mkTerm "diffuse_V" ;
lin diffuse_V2 = mkTerm "diffuse_V2" ;
lin diffuseness_N = mkTerm "diffuseness_N" ;
lin diffuser_N = mkTerm "diffuser_N" ;
lin diffusion_N = mkTerm "diffusion_N" ;
lin diflunisal_N = mkTerm "diflunisal_N" ;
lin dig_N = mkTerm "dig_N" ;
lin dig_V = mkTerm "dig_V" ;
lin dig_V2 = mkTerm "dig_V2" ;
lin dig_in_V = mkTerm "dig_in_V" ;
lin dig_into_V2 = mkTerm "dig_into_V2" ;
lin dig_out_V2 = mkTerm "dig_out_V2" ;
lin dig_up_V2 = mkTerm "dig_up_V2" ;
lin digest_N = mkTerm "digest_N" ;
lin digest_V = mkTerm "digest_V" ;
lin digest_V2 = mkTerm "digest_V2" ;
lin digester_N = mkTerm "digester_N" ;
lin digestibility_N = mkTerm "digestibility_N" ;
lin digestible_A = mkTerm "digestible_A" ;
lin digestion_N = mkTerm "digestion_N" ;
lin digestive_A = mkTerm "digestive_A" ;
lin digestive_N = mkTerm "digestive_N" ;
lin digger_N = mkTerm "digger_N" ;
lin digging_N = mkTerm "digging_N" ;
lin diggings_N = mkTerm "diggings_N" ;
lin dighted_A = mkTerm "dighted_A" ;
lin digit_N = mkTerm "digit_N" ;
lin digital_A = mkTerm "digital_A" ;
lin digitalis_N = mkTerm "digitalis_N" ;
lin digitalization_N = mkTerm "digitalization_N" ;
lin digitate_A = mkTerm "digitate_A" ;
lin digitigrade_A = mkTerm "digitigrade_A" ;
lin digitization_N = mkTerm "digitization_N" ;
lin digitizer_N = mkTerm "digitizer_N" ;
lin digitoxin_N = mkTerm "digitoxin_N" ;
lin diglyceride_N = mkTerm "diglyceride_N" ;
lin dignify_V2 = mkTerm "dignify_V2" ;
lin dignifying_A = mkTerm "dignifying_A" ;
lin dignitary_N = mkTerm "dignitary_N" ;
lin dignity_N = mkTerm "dignity_N" ;
lin digoxin_N = mkTerm "digoxin_N" ;
lin digraph_N = mkTerm "digraph_N" ;
lin digress_V = mkTerm "digress_V" ;
lin digression_N = mkTerm "digression_N" ;
lin digressive_A = mkTerm "digressive_A" ;
lin dihybrid_N = mkTerm "dihybrid_N" ;
lin dihydrostreptomycin_N = mkTerm "dihydrostreptomycin_N" ;
lin dijon_PN = mkTerm "dijon_PN" ;
lin dike_N = mkTerm "dike_N" ;
lin dike_V = mkTerm "dike_V" ;
lin dike_V2 = mkTerm "dike_V2" ;
lin dilapidated_A = mkTerm "dilapidated_A" ;
lin dilapidation_N = mkTerm "dilapidation_N" ;
lin dilatation_N = mkTerm "dilatation_N" ;
lin dilate_V = mkTerm "dilate_V" ;
lin dilate_V2 = mkTerm "dilate_V2" ;
lin dilation_N = mkTerm "dilation_N" ;
lin dilator_N = mkTerm "dilator_N" ;
lin dilatoriness_N = mkTerm "dilatoriness_N" ;
lin dilatory_A = mkTerm "dilatory_A" ;
lin dildo_N = mkTerm "dildo_N" ;
lin dilemma_N = mkTerm "dilemma_N" ;
lin dilettante_A = mkTerm "dilettante_A" ;
lin dilettante_N = mkTerm "dilettante_N" ;
lin diligence_N = mkTerm "diligence_N" ;
lin diligent_A = mkTerm "diligent_A" ;
lin dill_N = mkTerm "dill_N" ;
lin dillenia_N = mkTerm "dillenia_N" ;
lin dilly_dally_V = mkTerm "dilly_dally_V" ;
lin diltiazem_N = mkTerm "diltiazem_N" ;
lin dilutant_N = mkTerm "dilutant_N" ;
lin dilute_A = mkTerm "dilute_A" ;
lin dilute_V = mkTerm "dilute_V" ;
lin dilute_V2 = mkTerm "dilute_V2" ;
lin dilution_N = mkTerm "dilution_N" ;
lin diluvian_A = mkTerm "diluvian_A" ;
lin dim_A = mkTerm "dim_A" ;
lin dim_V = mkTerm "dim_V" ;
lin dim_V2 = mkTerm "dim_V2" ;
lin dime_N = mkTerm "dime_N" ;
lin dimenhydrinate_N = mkTerm "dimenhydrinate_N" ;
lin dimension_N = mkTerm "dimension_N" ;
lin dimensional_A = mkTerm "dimensional_A" ;
lin dimensionality_N = mkTerm "dimensionality_N" ;
lin dimensioning_A = mkTerm "dimensioning_A" ;
lin dimer_N = mkTerm "dimer_N" ;
lin dimethylglyoxime_N = mkTerm "dimethylglyoxime_N" ;
lin dimetrodon_N = mkTerm "dimetrodon_N" ;
lin diminish_V = mkTerm "diminish_V" ;
lin diminish_V2 = mkTerm "diminish_V2" ;
lin diminuendo_N = mkTerm "diminuendo_N" ;
lin diminution_N = mkTerm "diminution_N" ;
lin diminutive_A = mkTerm "diminutive_A" ;
lin diminutive_N = mkTerm "diminutive_N" ;
lin diminutiveness_N = mkTerm "diminutiveness_N" ;
lin dimity_N = mkTerm "dimity_N" ;
lin dimmer_N = mkTerm "dimmer_N" ;
lin dimness_N = mkTerm "dimness_N" ;
lin dimorphic_A = mkTerm "dimorphic_A" ;
lin dimorphism_N = mkTerm "dimorphism_N" ;
lin dimple_N = mkTerm "dimple_N" ;
lin dimple_V = mkTerm "dimple_V" ;
lin dimple_V2 = mkTerm "dimple_V2" ;
lin dimwit_N = mkTerm "dimwit_N" ;
lin din_N = mkTerm "din_N" ;
lin din_V = mkTerm "din_V" ;
lin din_V2 = mkTerm "din_V2" ;
lin dinar_N = mkTerm "dinar_N" ;
lin dine_V = mkTerm "dine_V" ;
lin dine_out_V = mkTerm "dine_out_V" ;
lin dine_out_on_V2 = mkTerm "dine_out_on_V2" ;
lin diner_N = mkTerm "diner_N" ;
lin dinette_N = mkTerm "dinette_N" ;
lin ding_N = mkTerm "ding_N" ;
lin ding_dong_Adv = mkTerm "ding_dong_Adv" ;
lin ding_dong_N = mkTerm "ding_dong_N" ;
lin dingbat_N = mkTerm "dingbat_N" ;
lin dingdong_Adv = mkTerm "dingdong_Adv" ;
lin dinghy_N = mkTerm "dinghy_N" ;
lin dinginess_N = mkTerm "dinginess_N" ;
lin dingle_N = mkTerm "dingle_N" ;
lin dingle_PN = mkTerm "dingle_PN" ;
lin dingo_N = mkTerm "dingo_N" ;
lin dingy_A = mkTerm "dingy_A" ;
lin dining_N = mkTerm "dining_N" ;
lin dining_car_N = mkTerm "dining_car_N" ;
lin dining_room_N = mkTerm "dining_room_N" ;
lin dining_table_N = mkTerm "dining_table_N" ;
lin dinky_A = mkTerm "dinky_A" ;
lin dinky_N = mkTerm "dinky_N" ;
lin dinner_N = mkTerm "dinner_N" ;
lin dinner_jacket_N = mkTerm "dinner_jacket_N" ;
lin dinner_party_N = mkTerm "dinner_party_N" ;
lin dinner_service_N = mkTerm "dinner_service_N" ;
lin dinner_set_N = mkTerm "dinner_set_N" ;
lin dinnertime_N = mkTerm "dinnertime_N" ;
lin dinnerware_N = mkTerm "dinnerware_N" ;
lin dinnington_PN = mkTerm "dinnington_PN" ;
lin dinoceras_N = mkTerm "dinoceras_N" ;
lin dinocerate_N = mkTerm "dinocerate_N" ;
lin dinoflagellate_N = mkTerm "dinoflagellate_N" ;
lin dinosaur_N = mkTerm "dinosaur_N" ;
lin dint_N = mkTerm "dint_N" ;
lin diocesan_A = mkTerm "diocesan_A" ;
lin diocesan_N = mkTerm "diocesan_N" ;
lin diocese_N = mkTerm "diocese_N" ;
lin diode_N = mkTerm "diode_N" ;
lin dioecious_A = mkTerm "dioecious_A" ;
lin diol_N = mkTerm "diol_N" ;
lin dioon_N = mkTerm "dioon_N" ;
lin diopter_N = mkTerm "diopter_N" ;
lin diorite_N = mkTerm "diorite_N" ;
lin dioxide_N = mkTerm "dioxide_N" ;
lin dioxin_N = mkTerm "dioxin_N" ;
lin dip_N = mkTerm "dip_N" ;
lin dip_V = mkTerm "dip_V" ;
lin dip_V2 = mkTerm "dip_V2" ;
lin dip_ed_N = mkTerm "dip_ed_N" ;
lin dip_in_V2 = mkTerm "dip_in_V2" ;
lin dip_into_V2 = mkTerm "dip_into_V2" ;
lin dip_out_V = mkTerm "dip_out_V" ;
lin diphenhydramine_N = mkTerm "diphenhydramine_N" ;
lin diphenylhydantoin_N = mkTerm "diphenylhydantoin_N" ;
lin diphtheria_N = mkTerm "diphtheria_N" ;
lin diphthong_N = mkTerm "diphthong_N" ;
lin diplegia_N = mkTerm "diplegia_N" ;
lin diplococcus_N = mkTerm "diplococcus_N" ;
lin diplodocus_N = mkTerm "diplodocus_N" ;
lin diploid_A = mkTerm "diploid_A" ;
lin diploid_N = mkTerm "diploid_N" ;
lin diploidy_N = mkTerm "diploidy_N" ;
lin diploma_N = mkTerm "diploma_N" ;
lin diplomacy_N = mkTerm "diplomacy_N" ;
lin diplomat_N = mkTerm "diplomat_N" ;
lin diplomate_N = mkTerm "diplomate_N" ;
lin diplomatic_A = mkTerm "diplomatic_A" ;
lin diplomatist_N = mkTerm "diplomatist_N" ;
lin diplopia_N = mkTerm "diplopia_N" ;
lin diplotene_N = mkTerm "diplotene_N" ;
lin dipolar_A = mkTerm "dipolar_A" ;
lin dipole_N = mkTerm "dipole_N" ;
lin dipper_N = mkTerm "dipper_N" ;
lin dipsomania_N = mkTerm "dipsomania_N" ;
lin dipsomaniac_N = mkTerm "dipsomaniac_N" ;
lin dipstick_N = mkTerm "dipstick_N" ;
lin dipterocarp_N = mkTerm "dipterocarp_N" ;
lin dipterous_A = mkTerm "dipterous_A" ;
lin diptych_N = mkTerm "diptych_N" ;
lin dir_N = mkTerm "dir_N" ;
lin dire_A = mkTerm "dire_A" ;
lin direct_A = mkTerm "direct_A" ;
lin direct_Adv = mkTerm "direct_Adv" ;
lin direct_V = mkTerm "direct_V" ;
lin direct_V2 = mkTerm "direct_V2" ;
lin direction_N = mkTerm "direction_N" ;
lin direction_finder_N = mkTerm "direction_finder_N" ;
lin directional_A = mkTerm "directional_A" ;
lin directionality_N = mkTerm "directionality_N" ;
lin directive_N = mkTerm "directive_N" ;
lin directivity_N = mkTerm "directivity_N" ;
lin directness_N = mkTerm "directness_N" ;
lin director_N = mkTerm "director_N" ;
lin directorate_N = mkTerm "directorate_N" ;
lin directorship_N = mkTerm "directorship_N" ;
lin directory_N = mkTerm "directory_N" ;
lin direful_A = mkTerm "direful_A" ;
lin dirge_N = mkTerm "dirge_N" ;
lin dirigible_N = mkTerm "dirigible_N" ;
lin dirk_N = mkTerm "dirk_N" ;
lin dirndl_N = mkTerm "dirndl_N" ;
lin dirt_A = mkTerm "dirt_A" ;
lin dirt_N = mkTerm "dirt_N" ;
lin dirt_cheap_A = mkTerm "dirt_cheap_A" ;
lin dirt_track_N = mkTerm "dirt_track_N" ;
lin dirtiness_N = mkTerm "dirtiness_N" ;
lin dirty_A = mkTerm "dirty_A" ;
lin dirty_V = mkTerm "dirty_V" ;
lin dirty_V2 = mkTerm "dirty_V2" ;
lin disa_N = mkTerm "disa_N" ;
lin disability_N = mkTerm "disability_N" ;
lin disable_V2 = mkTerm "disable_V2" ;
lin disabled_A = mkTerm "disabled_A" ;
lin disabled_N = mkTerm "disabled_N" ;
lin disablement_N = mkTerm "disablement_N" ;
lin disabling_A = mkTerm "disabling_A" ;
lin disabuse_V2 = mkTerm "disabuse_V2" ;
lin disaccharidase_N = mkTerm "disaccharidase_N" ;
lin disaccharide_N = mkTerm "disaccharide_N" ;
lin disadvantage_N = mkTerm "disadvantage_N" ;
lin disadvantageous_A = mkTerm "disadvantageous_A" ;
lin disaffected_A = mkTerm "disaffected_A" ;
lin disaffection_N = mkTerm "disaffection_N" ;
lin disafforest_V2 = mkTerm "disafforest_V2" ;
lin disagree_V = mkTerm "disagree_V" ;
lin disagree_V2 = mkTerm "disagree_V2" ;
lin disagree_VS = mkTerm "disagree_VS" ;
lin disagree_with_V2 = mkTerm "disagree_with_V2" ;
lin disagreeable_A = mkTerm "disagreeable_A" ;
lin disagreeableness_N = mkTerm "disagreeableness_N" ;
lin disagreement_N = mkTerm "disagreement_N" ;
lin disallow_V2 = mkTerm "disallow_V2" ;
lin disambiguation_N = mkTerm "disambiguation_N" ;
lin disambiguator_N = mkTerm "disambiguator_N" ;
lin disappear_V = mkTerm "disappear_V" ;
lin disappearance_N = mkTerm "disappearance_N" ;
lin disappoint_V2 = mkTerm "disappoint_V2" ;
lin disappointedly_Adv = mkTerm "disappointedly_Adv" ;
lin disappointing_A = mkTerm "disappointing_A" ;
lin disappointment_N = mkTerm "disappointment_N" ;
lin disapprobation_N = mkTerm "disapprobation_N" ;
lin disapproval_N = mkTerm "disapproval_N" ;
lin disapprove_V = mkTerm "disapprove_V" ;
lin disapprove_V2 = mkTerm "disapprove_V2" ;
lin disapprovingly_Adv = mkTerm "disapprovingly_Adv" ;
lin disarm_V = mkTerm "disarm_V" ;
lin disarm_V2 = mkTerm "disarm_V2" ;
lin disarmament_N = mkTerm "disarmament_N" ;
lin disarming_N = mkTerm "disarming_N" ;
lin disarrange_V2 = mkTerm "disarrange_V2" ;
lin disarrangement_N = mkTerm "disarrangement_N" ;
lin disarray_N = mkTerm "disarray_N" ;
lin disarray_V2 = mkTerm "disarray_V2" ;
lin disassociate_V2 = mkTerm "disassociate_V2" ;
lin disassociation_N = mkTerm "disassociation_N" ;
lin disaster_N = mkTerm "disaster_N" ;
lin disastrous_A = mkTerm "disastrous_A" ;
lin disavow_V2 = mkTerm "disavow_V2" ;
lin disavowable_A = mkTerm "disavowable_A" ;
lin disavowal_N = mkTerm "disavowal_N" ;
lin disband_V = mkTerm "disband_V" ;
lin disband_V2 = mkTerm "disband_V2" ;
lin disbandment_N = mkTerm "disbandment_N" ;
lin disbarment_N = mkTerm "disbarment_N" ;
lin disbelief_N = mkTerm "disbelief_N" ;
lin disbelieve_V = mkTerm "disbelieve_V" ;
lin disbelieve_V2 = mkTerm "disbelieve_V2" ;
lin disbeliever_N = mkTerm "disbeliever_N" ;
lin disbelievingly_Adv = mkTerm "disbelievingly_Adv" ;
lin disbud_V2 = mkTerm "disbud_V2" ;
lin disburden_V2 = mkTerm "disburden_V2" ;
lin disburse_V = mkTerm "disburse_V" ;
lin disburse_V2 = mkTerm "disburse_V2" ;
lin disbursement_N = mkTerm "disbursement_N" ;
lin disc_N = mkTerm "disc_N" ;
lin discalced_A = mkTerm "discalced_A" ;
lin discard_N = mkTerm "discard_N" ;
lin discard_V2 = mkTerm "discard_V2" ;
lin discern_V2 = mkTerm "discern_V2" ;
lin discernability_N = mkTerm "discernability_N" ;
lin discernible_A = mkTerm "discernible_A" ;
lin discerning_A = mkTerm "discerning_A" ;
lin discernment_N = mkTerm "discernment_N" ;
lin discharge_N = mkTerm "discharge_N" ;
lin discharge_V = mkTerm "discharge_V" ;
lin discharge_V2 = mkTerm "discharge_V2" ;
lin disciform_A = mkTerm "disciform_A" ;
lin discina_N = mkTerm "discina_N" ;
lin disciple_N = mkTerm "disciple_N" ;
lin discipleship_N = mkTerm "discipleship_N" ;
lin disciplinarian_N = mkTerm "disciplinarian_N" ;
lin disciplinary_A = mkTerm "disciplinary_A" ;
lin discipline_N = mkTerm "discipline_N" ;
lin discipline_V2 = mkTerm "discipline_V2" ;
lin disclaim_V2 = mkTerm "disclaim_V2" ;
lin disclaimer_N = mkTerm "disclaimer_N" ;
lin disclose_V = mkTerm "disclose_V" ;
lin disclose_V2 = mkTerm "disclose_V2" ;
lin disclose_VS = mkTerm "disclose_VS" ;
lin disclosure_N = mkTerm "disclosure_N" ;
lin disco_1_N = mkTerm "disco_1_N" ;
lin disco_2_N = mkTerm "disco_2_N" ;
lin discography_N = mkTerm "discography_N" ;
lin discoid_A = mkTerm "discoid_A" ;
lin discoloration_N = mkTerm "discoloration_N" ;
lin discolour_V = mkTerm "discolour_V" ;
lin discolour_V2 = mkTerm "discolour_V2" ;
lin discolouration_N = mkTerm "discolouration_N" ;
lin discombobulated_A = mkTerm "discombobulated_A" ;
lin discomfit_V2 = mkTerm "discomfit_V2" ;
lin discomfiture_N = mkTerm "discomfiture_N" ;
lin discomfort_N = mkTerm "discomfort_N" ;
lin discommode_V2 = mkTerm "discommode_V2" ;
lin discompose_V2 = mkTerm "discompose_V2" ;
lin discomposure_N = mkTerm "discomposure_N" ;
lin discomycete_N = mkTerm "discomycete_N" ;
lin discomycetous_A = mkTerm "discomycetous_A" ;
lin disconcert_V2 = mkTerm "disconcert_V2" ;
lin disconcerting_A = mkTerm "disconcerting_A" ;
lin disconfirming_A = mkTerm "disconfirming_A" ;
lin disconnect_V2 = mkTerm "disconnect_V2" ;
lin disconnection_N = mkTerm "disconnection_N" ;
lin disconsolate_A = mkTerm "disconsolate_A" ;
lin discontent_N = mkTerm "discontent_N" ;
lin discontent_V2 = mkTerm "discontent_V2" ;
lin discontentedly_Adv = mkTerm "discontentedly_Adv" ;
lin discontentment_N = mkTerm "discontentment_N" ;
lin discontinuance_N = mkTerm "discontinuance_N" ;
lin discontinue_V = mkTerm "discontinue_V" ;
lin discontinue_V2 = mkTerm "discontinue_V2" ;
lin discontinuity_N = mkTerm "discontinuity_N" ;
lin discontinuous_A = mkTerm "discontinuous_A" ;
lin discord_N = mkTerm "discord_N" ;
lin discordance_N = mkTerm "discordance_N" ;
lin discordant_A = mkTerm "discordant_A" ;
lin discorporate_A = mkTerm "discorporate_A" ;
lin discotheque_N = mkTerm "discotheque_N" ;
lin discount_N = mkTerm "discount_N" ;
lin discount_V = mkTerm "discount_V" ;
lin discount_V2 = mkTerm "discount_V2" ;
lin discountenance_V2 = mkTerm "discountenance_V2" ;
lin discourage_V2 = mkTerm "discourage_V2" ;
lin discouragement_N = mkTerm "discouragement_N" ;
lin discouraging_A = mkTerm "discouraging_A" ;
lin discourse_N = mkTerm "discourse_N" ;
lin discourse_V = mkTerm "discourse_V" ;
lin discourteous_A = mkTerm "discourteous_A" ;
lin discourtesy_N = mkTerm "discourtesy_N" ;
lin discover_V = mkTerm "discover_V" ;
lin discover_V2 = mkTerm "discover_V2" ;
lin discover_VS = mkTerm "discover_VS" ;
lin discovererFem_N = mkTerm "discovererFem_N" ;
lin discovererMasc_N = mkTerm "discovererMasc_N" ;
lin discovery_N = mkTerm "discovery_N" ;
lin discredit_N = mkTerm "discredit_N" ;
lin discredit_V2 = mkTerm "discredit_V2" ;
lin discreditable_A = mkTerm "discreditable_A" ;
lin discreet_A = mkTerm "discreet_A" ;
lin discrepancy_N = mkTerm "discrepancy_N" ;
lin discrepant_A = mkTerm "discrepant_A" ;
lin discrete_A = mkTerm "discrete_A" ;
lin discreteness_N = mkTerm "discreteness_N" ;
lin discretion_N = mkTerm "discretion_N" ;
lin discretionary_A = mkTerm "discretionary_A" ;
lin discriminable_A = mkTerm "discriminable_A" ;
lin discriminate_A = mkTerm "discriminate_A" ;
lin discriminate_V = mkTerm "discriminate_V" ;
lin discriminate_V2 = mkTerm "discriminate_V2" ;
lin discrimination_N = mkTerm "discrimination_N" ;
lin discriminative_A = mkTerm "discriminative_A" ;
lin discriminatory_A = mkTerm "discriminatory_A" ;
lin discursive_A = mkTerm "discursive_A" ;
lin discursiveness_N = mkTerm "discursiveness_N" ;
lin discus_N = mkTerm "discus_N" ;
lin discuss_V2 = mkTerm "discuss_V2" ;
lin discuss_VS = mkTerm "discuss_VS" ;
lin discussant_N = mkTerm "discussant_N" ;
lin discussion_N = mkTerm "discussion_N" ;
lin disdain_N = mkTerm "disdain_N" ;
lin disdain_V2 = mkTerm "disdain_V2" ;
lin disdainful_A = mkTerm "disdainful_A" ;
lin disease_N = mkTerm "disease_N" ;
lin diseased_A = mkTerm "diseased_A" ;
lin disembark_V = mkTerm "disembark_V" ;
lin disembark_V2 = mkTerm "disembark_V2" ;
lin disembarkation_N = mkTerm "disembarkation_N" ;
lin disembarrass_V2 = mkTerm "disembarrass_V2" ;
lin disembarrassment_N = mkTerm "disembarrassment_N" ;
lin disembody_V2 = mkTerm "disembody_V2" ;
lin disembowel_V2 = mkTerm "disembowel_V2" ;
lin disembowelment_N = mkTerm "disembowelment_N" ;
lin disenchant_V2 = mkTerm "disenchant_V2" ;
lin disenchanting_A = mkTerm "disenchanting_A" ;
lin disenchantment_N = mkTerm "disenchantment_N" ;
lin disencumber_V2 = mkTerm "disencumber_V2" ;
lin disenfranchise_V2 = mkTerm "disenfranchise_V2" ;
lin disenfranchisement_N = mkTerm "disenfranchisement_N" ;
lin disengage_V = mkTerm "disengage_V" ;
lin disengage_V2 = mkTerm "disengage_V2" ;
lin disengagement_N = mkTerm "disengagement_N" ;
lin disentangle_V = mkTerm "disentangle_V" ;
lin disentangle_V2 = mkTerm "disentangle_V2" ;
lin disentanglement_N = mkTerm "disentanglement_N" ;
lin disentangler_N = mkTerm "disentangler_N" ;
lin disequilibrium_N = mkTerm "disequilibrium_N" ;
lin disestablish_V2 = mkTerm "disestablish_V2" ;
lin disestablishment_N = mkTerm "disestablishment_N" ;
lin disesteem_N = mkTerm "disesteem_N" ;
lin disfavor_N = mkTerm "disfavor_N" ;
lin disfavour_N = mkTerm "disfavour_N" ;
lin disfavour_V2 = mkTerm "disfavour_V2" ;
lin disfigure_V2 = mkTerm "disfigure_V2" ;
lin disfigurement_N = mkTerm "disfigurement_N" ;
lin disfluency_N = mkTerm "disfluency_N" ;
lin disforest_V2 = mkTerm "disforest_V2" ;
lin disfranchise_V2 = mkTerm "disfranchise_V2" ;
lin disfranchisement_N = mkTerm "disfranchisement_N" ;
lin disgorge_V2 = mkTerm "disgorge_V2" ;
lin disgrace_N = mkTerm "disgrace_N" ;
lin disgrace_V2 = mkTerm "disgrace_V2" ;
lin disgraceful_A = mkTerm "disgraceful_A" ;
lin disgruntled_A = mkTerm "disgruntled_A" ;
lin disgruntlement_N = mkTerm "disgruntlement_N" ;
lin disguise_N = mkTerm "disguise_N" ;
lin disguise_V2 = mkTerm "disguise_V2" ;
lin disgust_N = mkTerm "disgust_N" ;
lin disgust_V2 = mkTerm "disgust_V2" ;
lin disgustedly_Adv = mkTerm "disgustedly_Adv" ;
lin disgusting_A = mkTerm "disgusting_A" ;
lin disgustingness_N = mkTerm "disgustingness_N" ;
lin dish_N = mkTerm "dish_N" ;
lin dish_V2 = mkTerm "dish_V2" ;
lin dish_out_V2 = mkTerm "dish_out_V2" ;
lin dish_up_V2 = mkTerm "dish_up_V2" ;
lin dishabille_N = mkTerm "dishabille_N" ;
lin disharmonious_A = mkTerm "disharmonious_A" ;
lin disharmony_N = mkTerm "disharmony_N" ;
lin dishcloth_N = mkTerm "dishcloth_N" ;
lin dishearten_V2 = mkTerm "dishearten_V2" ;
lin disheartenment_N = mkTerm "disheartenment_N" ;
lin disheveled_A = mkTerm "disheveled_A" ;
lin dishevelled_A = mkTerm "dishevelled_A" ;
lin dishful_N = mkTerm "dishful_N" ;
lin dishonest_A = mkTerm "dishonest_A" ;
lin dishonesty_N = mkTerm "dishonesty_N" ;
lin dishonorable_A = mkTerm "dishonorable_A" ;
lin dishonorableness_N = mkTerm "dishonorableness_N" ;
lin dishonour_N = mkTerm "dishonour_N" ;
lin dishonour_V2 = mkTerm "dishonour_V2" ;
lin dishonourable_A = mkTerm "dishonourable_A" ;
lin dishpan_N = mkTerm "dishpan_N" ;
lin dishrag_N = mkTerm "dishrag_N" ;
lin dishtowel_N = mkTerm "dishtowel_N" ;
lin dishwasher_N = mkTerm "dishwasher_N" ;
lin dishwashing_N = mkTerm "dishwashing_N" ;
lin dishwater_N = mkTerm "dishwater_N" ;
lin dishy_A = mkTerm "dishy_A" ;
lin disillusion_N = mkTerm "disillusion_N" ;
lin disillusion_V2 = mkTerm "disillusion_V2" ;
lin disillusionment_N = mkTerm "disillusionment_N" ;
lin disincentive_N = mkTerm "disincentive_N" ;
lin disinclination_N = mkTerm "disinclination_N" ;
lin disincline_V2 = mkTerm "disincline_V2" ;
lin disincline_V2V = mkTerm "disincline_V2V" ;
lin disinfect_V2 = mkTerm "disinfect_V2" ;
lin disinfectant_A = mkTerm "disinfectant_A" ;
lin disinfectant_N = mkTerm "disinfectant_N" ;
lin disinfection_N = mkTerm "disinfection_N" ;
lin disinfest_V2 = mkTerm "disinfest_V2" ;
lin disinfestation_N = mkTerm "disinfestation_N" ;
lin disinflation_N = mkTerm "disinflation_N" ;
lin disinformation_N = mkTerm "disinformation_N" ;
lin disingenuous_A = mkTerm "disingenuous_A" ;
lin disingenuousness_N = mkTerm "disingenuousness_N" ;
lin disinherit_V2 = mkTerm "disinherit_V2" ;
lin disinheritance_N = mkTerm "disinheritance_N" ;
lin disintegrate_V = mkTerm "disintegrate_V" ;
lin disintegrate_V2 = mkTerm "disintegrate_V2" ;
lin disintegration_N = mkTerm "disintegration_N" ;
lin disintegrative_A = mkTerm "disintegrative_A" ;
lin disinter_V2 = mkTerm "disinter_V2" ;
lin disinterest_N = mkTerm "disinterest_N" ;
lin disinterested_A = mkTerm "disinterested_A" ;
lin disinterestedness_N = mkTerm "disinterestedness_N" ;
lin disinterment_N = mkTerm "disinterment_N" ;
lin disinvestment_N = mkTerm "disinvestment_N" ;
lin disjoined_A = mkTerm "disjoined_A" ;
lin disjoint_A = mkTerm "disjoint_A" ;
lin disjoint_V2 = mkTerm "disjoint_V2" ;
lin disjointedly_Adv = mkTerm "disjointedly_Adv" ;
lin disjointedness_N = mkTerm "disjointedness_N" ;
lin disjunct_A = mkTerm "disjunct_A" ;
lin disjunction_N = mkTerm "disjunction_N" ;
lin disjunctive_A = mkTerm "disjunctive_A" ;
lin disk_N = mkTerm "disk_N" ;
lin diskette_N = mkTerm "diskette_N" ;
lin dislikable_A = mkTerm "dislikable_A" ;
lin dislike_N = mkTerm "dislike_N" ;
lin dislike_V2 = mkTerm "dislike_V2" ;
lin dislocate_V2 = mkTerm "dislocate_V2" ;
lin dislocation_N = mkTerm "dislocation_N" ;
lin dislodge_V2 = mkTerm "dislodge_V2" ;
lin dislodgement_N = mkTerm "dislodgement_N" ;
lin dislodgment_N = mkTerm "dislodgment_N" ;
lin disloyal_A = mkTerm "disloyal_A" ;
lin disloyalty_N = mkTerm "disloyalty_N" ;
lin dismal_A = mkTerm "dismal_A" ;
lin dismantle_V2 = mkTerm "dismantle_V2" ;
lin dismantlement_N = mkTerm "dismantlement_N" ;
lin dismantling_N = mkTerm "dismantling_N" ;
lin dismay_N = mkTerm "dismay_N" ;
lin dismay_V = mkTerm "dismay_V" ;
lin dismay_V2 = mkTerm "dismay_V2" ;
lin dismember_V2 = mkTerm "dismember_V2" ;
lin dismemberment_N = mkTerm "dismemberment_N" ;
lin dismiss_V2 = mkTerm "dismiss_V2" ;
lin dismissal_N = mkTerm "dismissal_N" ;
lin dismissible_A = mkTerm "dismissible_A" ;
lin dismissive_A = mkTerm "dismissive_A" ;
lin dismount_N = mkTerm "dismount_N" ;
lin dismount_V = mkTerm "dismount_V" ;
lin dismount_V2 = mkTerm "dismount_V2" ;
lin disobedience_N = mkTerm "disobedience_N" ;
lin disobedient_A = mkTerm "disobedient_A" ;
lin disobey_V2 = mkTerm "disobey_V2" ;
lin disoblige_V2 = mkTerm "disoblige_V2" ;
lin disobliging_A = mkTerm "disobliging_A" ;
lin disorder_N = mkTerm "disorder_N" ;
lin disorder_V2 = mkTerm "disorder_V2" ;
lin disorderliness_N = mkTerm "disorderliness_N" ;
lin disorderly_A = mkTerm "disorderly_A" ;
lin disorganization_N = mkTerm "disorganization_N" ;
lin disorganize_V2 = mkTerm "disorganize_V2" ;
lin disorient_V2 = mkTerm "disorient_V2" ;
lin disorientate_V2 = mkTerm "disorientate_V2" ;
lin disorientation_N = mkTerm "disorientation_N" ;
lin disorienting_A = mkTerm "disorienting_A" ;
lin disown_V2 = mkTerm "disown_V2" ;
lin disownment_N = mkTerm "disownment_N" ;
lin disparage_V2 = mkTerm "disparage_V2" ;
lin disparagement_N = mkTerm "disparagement_N" ;
lin disparagingly_Adv = mkTerm "disparagingly_Adv" ;
lin disparate_A = mkTerm "disparate_A" ;
lin disparateness_N = mkTerm "disparateness_N" ;
lin disparity_N = mkTerm "disparity_N" ;
lin dispassion_N = mkTerm "dispassion_N" ;
lin dispassionate_A = mkTerm "dispassionate_A" ;
lin dispassionateness_N = mkTerm "dispassionateness_N" ;
lin dispatch_N = mkTerm "dispatch_N" ;
lin dispatch_V2 = mkTerm "dispatch_V2" ;
lin dispatch_V2V = mkTerm "dispatch_V2V" ;
lin dispatch_box_N = mkTerm "dispatch_box_N" ;
lin dispatch_rider_N = mkTerm "dispatch_rider_N" ;
lin dispatcher_N = mkTerm "dispatcher_N" ;
lin dispel_V2 = mkTerm "dispel_V2" ;
lin dispensability_N = mkTerm "dispensability_N" ;
lin dispensable_A = mkTerm "dispensable_A" ;
lin dispensary_N = mkTerm "dispensary_N" ;
lin dispensation_N = mkTerm "dispensation_N" ;
lin dispense_V = mkTerm "dispense_V" ;
lin dispense_V2 = mkTerm "dispense_V2" ;
lin dispenser_N = mkTerm "dispenser_N" ;
lin dispersal_N = mkTerm "dispersal_N" ;
lin disperse_V = mkTerm "disperse_V" ;
lin disperse_V2 = mkTerm "disperse_V2" ;
lin dispersion_N = mkTerm "dispersion_N" ;
lin dispirit_V2 = mkTerm "dispirit_V2" ;
lin dispiritedly_Adv = mkTerm "dispiritedly_Adv" ;
lin displace_V2 = mkTerm "displace_V2" ;
lin displacement_N = mkTerm "displacement_N" ;
lin display_N = mkTerm "display_N" ;
lin display_V2 = mkTerm "display_V2" ;
lin display_VS = mkTerm "display_VS" ;
lin displease_V2 = mkTerm "displease_V2" ;
lin displeasing_A = mkTerm "displeasing_A" ;
lin displeasure_N = mkTerm "displeasure_N" ;
lin disport_V2 = mkTerm "disport_V2" ;
lin disposable_A = mkTerm "disposable_A" ;
lin disposable_N = mkTerm "disposable_N" ;
lin disposal_N = mkTerm "disposal_N" ;
lin dispose_V = mkTerm "dispose_V" ;
lin dispose_V2 = mkTerm "dispose_V2" ;
lin disposition_N = mkTerm "disposition_N" ;
lin dispossess_V2 = mkTerm "dispossess_V2" ;
lin dispossession_N = mkTerm "dispossession_N" ;
lin disproof_N = mkTerm "disproof_N" ;
lin disproportion_N = mkTerm "disproportion_N" ;
lin disproportionate_A = mkTerm "disproportionate_A" ;
lin disprove_V2 = mkTerm "disprove_V2" ;
lin disprove_VS = mkTerm "disprove_VS" ;
lin disputable_A = mkTerm "disputable_A" ;
lin disputant_N = mkTerm "disputant_N" ;
lin disputation_N = mkTerm "disputation_N" ;
lin disputatious_A = mkTerm "disputatious_A" ;
lin dispute_N = mkTerm "dispute_N" ;
lin dispute_V = mkTerm "dispute_V" ;
lin dispute_V2 = mkTerm "dispute_V2" ;
lin disqualification_N = mkTerm "disqualification_N" ;
lin disqualify_V2 = mkTerm "disqualify_V2" ;
lin disquiet_N = mkTerm "disquiet_N" ;
lin disquiet_V2 = mkTerm "disquiet_V2" ;
lin disquieting_A = mkTerm "disquieting_A" ;
lin disquietude_N = mkTerm "disquietude_N" ;
lin disquisition_N = mkTerm "disquisition_N" ;
lin disregard_N = mkTerm "disregard_N" ;
lin disregard_V2 = mkTerm "disregard_V2" ;
lin disrepair_N = mkTerm "disrepair_N" ;
lin disreputable_A = mkTerm "disreputable_A" ;
lin disrepute_N = mkTerm "disrepute_N" ;
lin disrespect_N = mkTerm "disrespect_N" ;
lin disrespectful_A = mkTerm "disrespectful_A" ;
lin disrobe_V = mkTerm "disrobe_V" ;
lin disrobe_V2 = mkTerm "disrobe_V2" ;
lin disrupt_V = mkTerm "disrupt_V" ;
lin disrupt_V2 = mkTerm "disrupt_V2" ;
lin disruption_N = mkTerm "disruption_N" ;
lin disruptive_A = mkTerm "disruptive_A" ;
lin dissatisfaction_N = mkTerm "dissatisfaction_N" ;
lin dissatisfy_V2 = mkTerm "dissatisfy_V2" ;
lin dissect_V2 = mkTerm "dissect_V2" ;
lin dissection_N = mkTerm "dissection_N" ;
lin dissemble_V = mkTerm "dissemble_V" ;
lin dissemble_V2 = mkTerm "dissemble_V2" ;
lin dissembler_N = mkTerm "dissembler_N" ;
lin disseminate_V = mkTerm "disseminate_V" ;
lin disseminate_V2 = mkTerm "disseminate_V2" ;
lin dissemination_N = mkTerm "dissemination_N" ;
lin dissension_N = mkTerm "dissension_N" ;
lin dissent_N = mkTerm "dissent_N" ;
lin dissent_V = mkTerm "dissent_V" ;
lin dissenter_N = mkTerm "dissenter_N" ;
lin dissentient_A = mkTerm "dissentient_A" ;
lin dissentious_A = mkTerm "dissentious_A" ;
lin dissertation_N = mkTerm "dissertation_N" ;
lin disservice_N = mkTerm "disservice_N" ;
lin dissever_V2 = mkTerm "dissever_V2" ;
lin dissidence_N = mkTerm "dissidence_N" ;
lin dissident_A = mkTerm "dissident_A" ;
lin dissident_N = mkTerm "dissident_N" ;
lin dissilience_N = mkTerm "dissilience_N" ;
lin dissilient_A = mkTerm "dissilient_A" ;
lin dissimilar_A = mkTerm "dissimilar_A" ;
lin dissimilarity_N = mkTerm "dissimilarity_N" ;
lin dissimilation_N = mkTerm "dissimilation_N" ;
lin dissimilitude_N = mkTerm "dissimilitude_N" ;
lin dissimulate_V = mkTerm "dissimulate_V" ;
lin dissimulate_V2 = mkTerm "dissimulate_V2" ;
lin dissimulation_N = mkTerm "dissimulation_N" ;
lin dissimulative_A = mkTerm "dissimulative_A" ;
lin dissipate_V = mkTerm "dissipate_V" ;
lin dissipate_V2 = mkTerm "dissipate_V2" ;
lin dissipation_N = mkTerm "dissipation_N" ;
lin dissociable_A = mkTerm "dissociable_A" ;
lin dissociate_V2 = mkTerm "dissociate_V2" ;
lin dissociation_N = mkTerm "dissociation_N" ;
lin dissociative_A = mkTerm "dissociative_A" ;
lin dissolubility_N = mkTerm "dissolubility_N" ;
lin dissoluble_A = mkTerm "dissoluble_A" ;
lin dissolute_A = mkTerm "dissolute_A" ;
lin dissoluteness_N = mkTerm "dissoluteness_N" ;
lin dissolution_N = mkTerm "dissolution_N" ;
lin dissolvable_A = mkTerm "dissolvable_A" ;
lin dissolve_N = mkTerm "dissolve_N" ;
lin dissolve_V = mkTerm "dissolve_V" ;
lin dissolve_V2 = mkTerm "dissolve_V2" ;
lin dissolving_N = mkTerm "dissolving_N" ;
lin dissonance_N = mkTerm "dissonance_N" ;
lin dissonant_A = mkTerm "dissonant_A" ;
lin dissuade_V2 = mkTerm "dissuade_V2" ;
lin dissuasion_N = mkTerm "dissuasion_N" ;
lin dissuasive_A = mkTerm "dissuasive_A" ;
lin dissyllable_N = mkTerm "dissyllable_N" ;
lin distaff_N = mkTerm "distaff_N" ;
lin distal_A = mkTerm "distal_A" ;
lin distance_N = mkTerm "distance_N" ;
lin distance_V2 = mkTerm "distance_V2" ;
lin distant_A = mkTerm "distant_A" ;
lin distaste_N = mkTerm "distaste_N" ;
lin distasteful_A = mkTerm "distasteful_A" ;
lin distastefulness_N = mkTerm "distastefulness_N" ;
lin distemper_N = mkTerm "distemper_N" ;
lin distemper_V2 = mkTerm "distemper_V2" ;
lin distend_V = mkTerm "distend_V" ;
lin distend_V2 = mkTerm "distend_V2" ;
lin distensible_A = mkTerm "distensible_A" ;
lin distension_N = mkTerm "distension_N" ;
lin distention_N = mkTerm "distention_N" ;
lin distil_V = mkTerm "distil_V" ;
lin distil_V2 = mkTerm "distil_V2" ;
lin distillate_N = mkTerm "distillate_N" ;
lin distillation_N = mkTerm "distillation_N" ;
lin distiller_N = mkTerm "distiller_N" ;
lin distillery_N = mkTerm "distillery_N" ;
lin distinct_A = mkTerm "distinct_A" ;
lin distinction_N = mkTerm "distinction_N" ;
lin distinctive_A = mkTerm "distinctive_A" ;
lin distinctiveness_N = mkTerm "distinctiveness_N" ;
lin distinctness_N = mkTerm "distinctness_N" ;
lin distinguish_V = mkTerm "distinguish_V" ;
lin distinguish_V2 = mkTerm "distinguish_V2" ;
lin distinguishable_A = mkTerm "distinguishable_A" ;
lin distinguished_A = mkTerm "distinguished_A" ;
lin distort_V2 = mkTerm "distort_V2" ;
lin distortable_A = mkTerm "distortable_A" ;
lin distortion_N = mkTerm "distortion_N" ;
lin distortionist_N = mkTerm "distortionist_N" ;
lin distract_V = mkTerm "distract_V" ;
lin distract_V2 = mkTerm "distract_V2" ;
lin distractedly_Adv = mkTerm "distractedly_Adv" ;
lin distraction_N = mkTerm "distraction_N" ;
lin distrain_V = mkTerm "distrain_V" ;
lin distraint_N = mkTerm "distraint_N" ;
lin distrait_A = mkTerm "distrait_A" ;
lin distraught_A = mkTerm "distraught_A" ;
lin distress_N = mkTerm "distress_N" ;
lin distress_V2 = mkTerm "distress_V2" ;
lin distressful_A = mkTerm "distressful_A" ;
lin distressing_A = mkTerm "distressing_A" ;
lin distributary_N = mkTerm "distributary_N" ;
lin distribute_V2 = mkTerm "distribute_V2" ;
lin distributed_A = mkTerm "distributed_A" ;
lin distribution_N = mkTerm "distribution_N" ;
lin distributional_A = mkTerm "distributional_A" ;
lin distributive_A = mkTerm "distributive_A" ;
lin distributor_N = mkTerm "distributor_N" ;
lin district_N = mkTerm "district_N" ;
lin distrust_N = mkTerm "distrust_N" ;
lin distrust_V2 = mkTerm "distrust_V2" ;
lin distrustful_A = mkTerm "distrustful_A" ;
lin distrustfulness_N = mkTerm "distrustfulness_N" ;
lin disturb_V2 = mkTerm "disturb_V2" ;
lin disturbance_N = mkTerm "disturbance_N" ;
lin disturber_N = mkTerm "disturber_N" ;
lin disturbing_A = mkTerm "disturbing_A" ;
lin disulfiram_N = mkTerm "disulfiram_N" ;
lin disunion_N = mkTerm "disunion_N" ;
lin disunite_V = mkTerm "disunite_V" ;
lin disunite_V2 = mkTerm "disunite_V2" ;
lin disunity_N = mkTerm "disunity_N" ;
lin disuse_N = mkTerm "disuse_N" ;
lin disused_A = mkTerm "disused_A" ;
lin disyllabic_A = mkTerm "disyllabic_A" ;
lin disyllable_N = mkTerm "disyllable_N" ;
lin dita_N = mkTerm "dita_N" ;
lin ditch_N = mkTerm "ditch_N" ;
lin ditch_V = mkTerm "ditch_V" ;
lin ditch_V2 = mkTerm "ditch_V2" ;
lin dither_N = mkTerm "dither_N" ;
lin dither_V = mkTerm "dither_V" ;
lin dithering_N = mkTerm "dithering_N" ;
lin dithyramb_N = mkTerm "dithyramb_N" ;
lin dithyrambic_A = mkTerm "dithyrambic_A" ;
lin ditto_N = mkTerm "ditto_N" ;
lin ditty_N = mkTerm "ditty_N" ;
lin diuresis_N = mkTerm "diuresis_N" ;
lin diurnal_A = mkTerm "diurnal_A" ;
lin diva_N = mkTerm "diva_N" ;
lin divagate_V = mkTerm "divagate_V" ;
lin divagation_N = mkTerm "divagation_N" ;
lin divan_N = mkTerm "divan_N" ;
lin divan_bed_N = mkTerm "divan_bed_N" ;
lin divarication_N = mkTerm "divarication_N" ;
lin dive_N = mkTerm "dive_N" ;
lin dive_V = mkTerm "dive_V" ;
lin dive_bomb_V = mkTerm "dive_bomb_V" ;
lin dive_bomb_V2 = mkTerm "dive_bomb_V2" ;
lin dive_bomber_N = mkTerm "dive_bomber_N" ;
lin dive_in_V = mkTerm "dive_in_V" ;
lin dive_into_V2 = mkTerm "dive_into_V2" ;
lin diver_N = mkTerm "diver_N" ;
lin diverge_V = mkTerm "diverge_V" ;
lin divergence_N = mkTerm "divergence_N" ;
lin divergency_N = mkTerm "divergency_N" ;
lin divergent_A = mkTerm "divergent_A" ;
lin divers_A = mkTerm "divers_A" ;
lin diverse_A = mkTerm "diverse_A" ;
lin diverseness_N = mkTerm "diverseness_N" ;
lin diversification_N = mkTerm "diversification_N" ;
lin diversify_V = mkTerm "diversify_V" ;
lin diversify_V2 = mkTerm "diversify_V2" ;
lin diversion_N = mkTerm "diversion_N" ;
lin diversionary_A = mkTerm "diversionary_A" ;
lin diversionist_N = mkTerm "diversionist_N" ;
lin diversity_N = mkTerm "diversity_N" ;
lin divert_V = mkTerm "divert_V" ;
lin diverticulitis_N = mkTerm "diverticulitis_N" ;
lin diverticulosis_N = mkTerm "diverticulosis_N" ;
lin diverticulum_N = mkTerm "diverticulum_N" ;
lin divertimento_N = mkTerm "divertimento_N" ;
lin dives_PN = mkTerm "dives_PN" ;
lin divest_V2 = mkTerm "divest_V2" ;
lin divestiture_N = mkTerm "divestiture_N" ;
lin dividable_A = mkTerm "dividable_A" ;
lin divide_N = mkTerm "divide_N" ;
lin divide_V = mkTerm "divide_V" ;
lin divide_V2 = mkTerm "divide_V2" ;
lin divide_up_V2 = mkTerm "divide_up_V2" ;
lin dividend_N = mkTerm "dividend_N" ;
lin dividend_warrant_N = mkTerm "dividend_warrant_N" ;
lin divider_N = mkTerm "divider_N" ;
lin divination_N = mkTerm "divination_N" ;
lin divinatory_A = mkTerm "divinatory_A" ;
lin divine_A = mkTerm "divine_A" ;
lin divine_N = mkTerm "divine_N" ;
lin divine_V = mkTerm "divine_V" ;
lin divine_V2 = mkTerm "divine_V2" ;
lin diviner_N = mkTerm "diviner_N" ;
lin diving_N = mkTerm "diving_N" ;
lin diving_bell_N = mkTerm "diving_bell_N" ;
lin diving_board_N = mkTerm "diving_board_N" ;
lin diving_dress_N = mkTerm "diving_dress_N" ;
lin diving_suit_N = mkTerm "diving_suit_N" ;
lin divinity_N = mkTerm "divinity_N" ;
lin divisibility_N = mkTerm "divisibility_N" ;
lin divisible_A = mkTerm "divisible_A" ;
lin division_1_N = mkTerm "division_1_N" ;
lin division_2_N = mkTerm "division_2_N" ;
lin division_3_N = mkTerm "division_3_N" ;
lin divisional_A = mkTerm "divisional_A" ;
lin divisor_N = mkTerm "divisor_N" ;
lin divorce_N = mkTerm "divorce_N" ;
lin divorce_V2 = mkTerm "divorce_V2" ;
lin divorcee_N = mkTerm "divorcee_N" ;
lin divot_N = mkTerm "divot_N" ;
lin divulge_V2 = mkTerm "divulge_V2" ;
lin divulgence_N = mkTerm "divulgence_N" ;
lin divvy_N = mkTerm "divvy_N" ;
lin divvy_out_V2 = mkTerm "divvy_out_V2" ;
lin divvy_up_V2 = mkTerm "divvy_up_V2" ;
lin dixie_N = mkTerm "dixie_N" ;
lin diy_N = mkTerm "diy_N" ;
lin dizygotic_A = mkTerm "dizygotic_A" ;
lin dizziness_N = mkTerm "dizziness_N" ;
lin dizzy_A = mkTerm "dizzy_A" ;
lin dizzy_V2 = mkTerm "dizzy_V2" ;
lin dj_N = mkTerm "dj_N" ;
lin djibouti_PN = mkTerm "djibouti_PN" ;
lin djiboutian_A = mkTerm "djiboutian_A" ;
lin djiboutian_N = mkTerm "djiboutian_N" ;
lin djinn_N = mkTerm "djinn_N" ;
lin djs_N = mkTerm "djs_N" ;
lin dlitt_N = mkTerm "dlitt_N" ;
lin dm_N = mkTerm "dm_N" ;
lin dna_N = mkTerm "dna_N" ;
lin dnepropetrovsk_PN = mkTerm "dnepropetrovsk_PN" ;
lin do_N = mkTerm "do_N" ;
lin do_V2 = mkTerm "do_V2" ;
lin do_gooder_N = mkTerm "do_gooder_N" ;
lin dob_in_V2 = mkTerm "dob_in_V2" ;
lin dobbin_N = mkTerm "dobbin_N" ;
lin dobra_N = mkTerm "dobra_N" ;
lin dobson_N = mkTerm "dobson_N" ;
lin docent_N = mkTerm "docent_N" ;
lin docile_A = mkTerm "docile_A" ;
lin docility_N = mkTerm "docility_N" ;
lin dock_N = mkTerm "dock_N" ;
lin dock_V = mkTerm "dock_V" ;
lin dock_V2 = mkTerm "dock_V2" ;
lin dockage_N = mkTerm "dockage_N" ;
lin docker_N = mkTerm "docker_N" ;
lin docket_N = mkTerm "docket_N" ;
lin docket_V2 = mkTerm "docket_V2" ;
lin docking_N = mkTerm "docking_N" ;
lin dockside_N = mkTerm "dockside_N" ;
lin dockyard_N = mkTerm "dockyard_N" ;
lin doctor_N = mkTerm "doctor_N" ;
lin doctor_V2 = mkTerm "doctor_V2" ;
lin doctoral_A = mkTerm "doctoral_A" ;
lin doctorate_N = mkTerm "doctorate_N" ;
lin doctorfish_N = mkTerm "doctorfish_N" ;
lin doctorspeak_N = mkTerm "doctorspeak_N" ;
lin doctrinaire_A = mkTerm "doctrinaire_A" ;
lin doctrinaire_N = mkTerm "doctrinaire_N" ;
lin doctrinal_A = mkTerm "doctrinal_A" ;
lin doctrine_N = mkTerm "doctrine_N" ;
lin document_N = mkTerm "document_N" ;
lin document_V2 = mkTerm "document_V2" ;
lin documentary_A = mkTerm "documentary_A" ;
lin documentary_N = mkTerm "documentary_N" ;
lin documentation_N = mkTerm "documentation_N" ;
lin dodder_N = mkTerm "dodder_N" ;
lin dodder_V = mkTerm "dodder_V" ;
lin dodderer_N = mkTerm "dodderer_N" ;
lin doddery_A = mkTerm "doddery_A" ;
lin doddle_N = mkTerm "doddle_N" ;
lin dodecagon_N = mkTerm "dodecagon_N" ;
lin dodecahedron_N = mkTerm "dodecahedron_N" ;
lin dodge_N = mkTerm "dodge_N" ;
lin dodge_V = mkTerm "dodge_V" ;
lin dodge_V2 = mkTerm "dodge_V2" ;
lin dodgem_N = mkTerm "dodgem_N" ;
lin dodger_N = mkTerm "dodger_N" ;
lin dodgy_A = mkTerm "dodgy_A" ;
lin dodo_N = mkTerm "dodo_N" ;
lin doe_N = mkTerm "doe_N" ;
lin doer_N = mkTerm "doer_N" ;
lin doeskin_N = mkTerm "doeskin_N" ;
lin doff_V2 = mkTerm "doff_V2" ;
lin dog's_tooth_N = mkTerm "dog's_tooth_N" ;
lin dog_N = mkTerm "dog_N" ;
lin dog_V2 = mkTerm "dog_V2" ;
lin dog_biscuit_N = mkTerm "dog_biscuit_N" ;
lin dog_cart_N = mkTerm "dog_cart_N" ;
lin dog_collar_N = mkTerm "dog_collar_N" ;
lin dog_eared_A = mkTerm "dog_eared_A" ;
lin dog_like_A = mkTerm "dog_like_A" ;
lin dogbane_N = mkTerm "dogbane_N" ;
lin doge_N = mkTerm "doge_N" ;
lin dogfight_N = mkTerm "dogfight_N" ;
lin dogfighter_N = mkTerm "dogfighter_N" ;
lin dogfish_N = mkTerm "dogfish_N" ;
lin doggedly_Adv = mkTerm "doggedly_Adv" ;
lin doggedness_N = mkTerm "doggedness_N" ;
lin doggerel_N = mkTerm "doggerel_N" ;
lin doggie_N = mkTerm "doggie_N" ;
lin dogging_A = mkTerm "dogging_A" ;
lin doggo_Adv = mkTerm "doggo_Adv" ;
lin doggy_N = mkTerm "doggy_N" ;
lin doghouse_N = mkTerm "doghouse_N" ;
lin dogie_N = mkTerm "dogie_N" ;
lin dogleg_N = mkTerm "dogleg_N" ;
lin dogma_N = mkTerm "dogma_N" ;
lin dogmatic_A = mkTerm "dogmatic_A" ;
lin dogmatism_N = mkTerm "dogmatism_N" ;
lin dogmatist_N = mkTerm "dogmatist_N" ;
lin dogmatize_V = mkTerm "dogmatize_V" ;
lin dogmatize_V2 = mkTerm "dogmatize_V2" ;
lin dogsbody_N = mkTerm "dogsbody_N" ;
lin dogsled_N = mkTerm "dogsled_N" ;
lin dogtooth_N = mkTerm "dogtooth_N" ;
lin dogtrot_N = mkTerm "dogtrot_N" ;
lin dogwatch_N = mkTerm "dogwatch_N" ;
lin dogwood_N = mkTerm "dogwood_N" ;
lin doh_N = mkTerm "doh_N" ;
lin doily_N = mkTerm "doily_N" ;
lin doing_N = mkTerm "doing_N" ;
lin dol_N = mkTerm "dol_N" ;
lin dolabriform_A = mkTerm "dolabriform_A" ;
lin dolce_Adv = mkTerm "dolce_Adv" ;
lin doldrums_N = mkTerm "doldrums_N" ;
lin dole_N = mkTerm "dole_N" ;
lin dole_V2 = mkTerm "dole_V2" ;
lin dole_out_V2 = mkTerm "dole_out_V2" ;
lin doleful_A = mkTerm "doleful_A" ;
lin dolefulness_N = mkTerm "dolefulness_N" ;
lin dolichocephalic_A = mkTerm "dolichocephalic_A" ;
lin dolichocephalic_N = mkTerm "dolichocephalic_N" ;
lin dolichocephaly_N = mkTerm "dolichocephaly_N" ;
lin doliolum_N = mkTerm "doliolum_N" ;
lin doll_N = mkTerm "doll_N" ;
lin doll_V = mkTerm "doll_V" ;
lin doll_V2 = mkTerm "doll_V2" ;
lin dollar_N = mkTerm "dollar_N" ;
lin dollarfish_N = mkTerm "dollarfish_N" ;
lin dollhouse_N = mkTerm "dollhouse_N" ;
lin dollop_N = mkTerm "dollop_N" ;
lin dolly_N = mkTerm "dolly_N" ;
lin dolly_PN = mkTerm "dolly_PN" ;
lin dolman_N = mkTerm "dolman_N" ;
lin dolmas_N = mkTerm "dolmas_N" ;
lin dolmen_N = mkTerm "dolmen_N" ;
lin dolomite_N = mkTerm "dolomite_N" ;
lin dolomitic_A = mkTerm "dolomitic_A" ;
lin dolor_N = mkTerm "dolor_N" ;
lin dolorous_A = mkTerm "dolorous_A" ;
lin dolour_N = mkTerm "dolour_N" ;
lin dolourous_A = mkTerm "dolourous_A" ;
lin dolphin_N = mkTerm "dolphin_N" ;
lin dolphinfish_N = mkTerm "dolphinfish_N" ;
lin dolt_N = mkTerm "dolt_N" ;
lin doltish_A = mkTerm "doltish_A" ;
lin domain_N = mkTerm "domain_N" ;
lin domatium_N = mkTerm "domatium_N" ;
lin dombeya_N = mkTerm "dombeya_N" ;
lin dome_N = mkTerm "dome_N" ;
lin domed_A = mkTerm "domed_A" ;
lin domesday_PN = mkTerm "domesday_PN" ;
lin domestic_A = mkTerm "domestic_A" ;
lin domestic_N = mkTerm "domestic_N" ;
lin domesticate_V2 = mkTerm "domesticate_V2" ;
lin domestication_N = mkTerm "domestication_N" ;
lin domesticity_N = mkTerm "domesticity_N" ;
lin domicile_N = mkTerm "domicile_N" ;
lin domiciliary_A = mkTerm "domiciliary_A" ;
lin dominance_N = mkTerm "dominance_N" ;
lin dominant_A = mkTerm "dominant_A" ;
lin dominant_N = mkTerm "dominant_N" ;
lin dominate_V = mkTerm "dominate_V" ;
lin dominate_V2 = mkTerm "dominate_V2" ;
lin domination_N = mkTerm "domination_N" ;
lin dominatrix_N = mkTerm "dominatrix_N" ;
lin domineer_V = mkTerm "domineer_V" ;
lin domineeringly_Adv = mkTerm "domineeringly_Adv" ;
lin dominic_PN = mkTerm "dominic_PN" ;
lin dominica_PN = mkTerm "dominica_PN" ;
lin dominical_A = mkTerm "dominical_A" ;
lin dominican_A = mkTerm "dominican_A" ;
lin dominican_N = mkTerm "dominican_N" ;
lin dominie_N = mkTerm "dominie_N" ;
lin dominion_N = mkTerm "dominion_N" ;
lin domino_N = mkTerm "domino_N" ;
lin dominoes_N = mkTerm "dominoes_N" ;
lin dominus_N = mkTerm "dominus_N" ;
lin don't_know_N = mkTerm "don't_know_N" ;
lin don_N = mkTerm "don_N" ;
lin don_PN = mkTerm "don_PN" ;
lin don_V2 = mkTerm "don_V2" ;
lin donald_PN = mkTerm "donald_PN" ;
lin donate_V = mkTerm "donate_V" ;
lin donate_V2 = mkTerm "donate_V2" ;
lin donation_N = mkTerm "donation_N" ;
lin doncaster_PN = mkTerm "doncaster_PN" ;
lin donegal_PN = mkTerm "donegal_PN" ;
lin donetsk_PN = mkTerm "donetsk_PN" ;
lin dong_N = mkTerm "dong_N" ;
lin dongle_N = mkTerm "dongle_N" ;
lin donjon_N = mkTerm "donjon_N" ;
lin donkey_N = mkTerm "donkey_N" ;
lin donkey_jacket_N = mkTerm "donkey_jacket_N" ;
lin donkey_work_N = mkTerm "donkey_work_N" ;
lin donna_N = mkTerm "donna_N" ;
lin donnish_A = mkTerm "donnish_A" ;
lin donor_N = mkTerm "donor_N" ;
lin doodad_N = mkTerm "doodad_N" ;
lin doodia_N = mkTerm "doodia_N" ;
lin doodle_V = mkTerm "doodle_V" ;
lin doodlebug_N = mkTerm "doodlebug_N" ;
lin doom_N = mkTerm "doom_N" ;
lin doom_V2 = mkTerm "doom_V2" ;
lin doomed_N = mkTerm "doomed_N" ;
lin doomsday_PN = mkTerm "doomsday_PN" ;
lin door_N = mkTerm "door_N" ;
lin door_to_door_A = mkTerm "door_to_door_A" ;
lin doorbell_N = mkTerm "doorbell_N" ;
lin doorcase_N = mkTerm "doorcase_N" ;
lin doorframe_N = mkTerm "doorframe_N" ;
lin doorhandle_N = mkTerm "doorhandle_N" ;
lin doorjamb_N = mkTerm "doorjamb_N" ;
lin doorkeeper_N = mkTerm "doorkeeper_N" ;
lin doorknob_N = mkTerm "doorknob_N" ;
lin doorknocker_N = mkTerm "doorknocker_N" ;
lin doorlock_N = mkTerm "doorlock_N" ;
lin doorman_N = mkTerm "doorman_N" ;
lin doormat_N = mkTerm "doormat_N" ;
lin doornail_N = mkTerm "doornail_N" ;
lin doorplate_N = mkTerm "doorplate_N" ;
lin doorpost_N = mkTerm "doorpost_N" ;
lin doorsill_N = mkTerm "doorsill_N" ;
lin doorstep_N = mkTerm "doorstep_N" ;
lin doorstop_N = mkTerm "doorstop_N" ;
lin doorstopper_N = mkTerm "doorstopper_N" ;
lin doorway_N = mkTerm "doorway_N" ;
lin dooryard_N = mkTerm "dooryard_N" ;
lin dopa_N = mkTerm "dopa_N" ;
lin dopamine_N = mkTerm "dopamine_N" ;
lin dope_N = mkTerm "dope_N" ;
lin dope_V2 = mkTerm "dope_V2" ;
lin dopey_A = mkTerm "dopey_A" ;
lin doppelganger_N = mkTerm "doppelganger_N" ;
lin dora_PN = mkTerm "dora_PN" ;
lin dorbeetle_N = mkTerm "dorbeetle_N" ;
lin dorchester_PN = mkTerm "dorchester_PN" ;
lin dordrecht_PN = mkTerm "dordrecht_PN" ;
lin doreen_PN = mkTerm "doreen_PN" ;
lin doric_A = mkTerm "doric_A" ;
lin doris_PN = mkTerm "doris_PN" ;
lin dorking_PN = mkTerm "dorking_PN" ;
lin dorm_N = mkTerm "dorm_N" ;
lin dormancy_N = mkTerm "dormancy_N" ;
lin dormant_A = mkTerm "dormant_A" ;
lin dormer_N = mkTerm "dormer_N" ;
lin dormer_window_N = mkTerm "dormer_window_N" ;
lin dormie_A = mkTerm "dormie_A" ;
lin dormitory_N = mkTerm "dormitory_N" ;
lin dormouse_N = mkTerm "dormouse_N" ;
lin dorothy_PN = mkTerm "dorothy_PN" ;
lin dorsal_A = mkTerm "dorsal_A" ;
lin dorset_PN = mkTerm "dorset_PN" ;
lin dorsiflexion_N = mkTerm "dorsiflexion_N" ;
lin dorsoventral_A = mkTerm "dorsoventral_A" ;
lin dorsum_N = mkTerm "dorsum_N" ;
lin dortmund_PN = mkTerm "dortmund_PN" ;
lin dory_N = mkTerm "dory_N" ;
lin dosage_N = mkTerm "dosage_N" ;
lin dose_N = mkTerm "dose_N" ;
lin dose_V2 = mkTerm "dose_V2" ;
lin dosemeter_N = mkTerm "dosemeter_N" ;
lin dosimetry_N = mkTerm "dosimetry_N" ;
lin doss_V = mkTerm "doss_V" ;
lin doss_about_V = mkTerm "doss_about_V" ;
lin doss_around_V = mkTerm "doss_around_V" ;
lin doss_down_V = mkTerm "doss_down_V" ;
lin doss_house_N = mkTerm "doss_house_N" ;
lin dossal_N = mkTerm "dossal_N" ;
lin dosser_N = mkTerm "dosser_N" ;
lin dossier_N = mkTerm "dossier_N" ;
lin dot_N = mkTerm "dot_N" ;
lin dot_V2 = mkTerm "dot_V2" ;
lin dotage_N = mkTerm "dotage_N" ;
lin dotard_N = mkTerm "dotard_N" ;
lin dote_V = mkTerm "dote_V" ;
lin dotterel_N = mkTerm "dotterel_N" ;
lin dottle_N = mkTerm "dottle_N" ;
lin dotty_A = mkTerm "dotty_A" ;
lin douai_PN = mkTerm "douai_PN" ;
lin double_A = mkTerm "double_A" ;
lin double_Adv = mkTerm "double_Adv" ;
lin double_N = mkTerm "double_N" ;
lin double_V = mkTerm "double_V" ;
lin double_V2 = mkTerm "double_V2" ;
lin double_as_V2 = mkTerm "double_as_V2" ;
lin double_back_V = mkTerm "double_back_V" ;
lin double_barrelled_A = mkTerm "double_barrelled_A" ;
lin double_bass_N = mkTerm "double_bass_N" ;
lin double_bedded_A = mkTerm "double_bedded_A" ;
lin double_breasted_A = mkTerm "double_breasted_A" ;
lin double_check_V2 = mkTerm "double_check_V2" ;
lin double_cross_N = mkTerm "double_cross_N" ;
lin double_cross_V2 = mkTerm "double_cross_V2" ;
lin double_dealer_N = mkTerm "double_dealer_N" ;
lin double_dealing_A = mkTerm "double_dealing_A" ;
lin double_dealing_N = mkTerm "double_dealing_N" ;
lin double_decker_N = mkTerm "double_decker_N" ;
lin double_dutch_N = mkTerm "double_dutch_N" ;
lin double_dyed_A = mkTerm "double_dyed_A" ;
lin double_edged_A = mkTerm "double_edged_A" ;
lin double_entry_N = mkTerm "double_entry_N" ;
lin double_faced_A = mkTerm "double_faced_A" ;
lin double_first_N = mkTerm "double_first_N" ;
lin double_jointed_A = mkTerm "double_jointed_A" ;
lin double_over_V = mkTerm "double_over_V" ;
lin double_park_V = mkTerm "double_park_V" ;
lin double_park_V2 = mkTerm "double_park_V2" ;
lin double_quick_A = mkTerm "double_quick_A" ;
lin double_quick_Adv = mkTerm "double_quick_Adv" ;
lin double_spacing_N = mkTerm "double_spacing_N" ;
lin double_talk_N = mkTerm "double_talk_N" ;
lin double_think_N = mkTerm "double_think_N" ;
lin double_up_V = mkTerm "double_up_V" ;
lin double_up_as_V2 = mkTerm "double_up_as_V2" ;
lin doubler_N = mkTerm "doubler_N" ;
lin doubles_N = mkTerm "doubles_N" ;
lin doublespeak_N = mkTerm "doublespeak_N" ;
lin doublet_N = mkTerm "doublet_N" ;
lin doubleton_N = mkTerm "doubleton_N" ;
lin doubletree_N = mkTerm "doubletree_N" ;
lin doubling_N = mkTerm "doubling_N" ;
lin doubloon_N = mkTerm "doubloon_N" ;
lin doubt_N = mkTerm "doubt_N" ;
lin doubt_V2 = mkTerm "doubt_V2" ;
lin doubt_VS = mkTerm "doubt_VS" ;
lin doubtful_A = mkTerm "doubtful_A" ;
lin doubting_A = mkTerm "doubting_A" ;
lin doubtless_Adv = mkTerm "doubtless_Adv" ;
lin douche_N = mkTerm "douche_N" ;
lin doug_PN = mkTerm "doug_PN" ;
lin dough_N = mkTerm "dough_N" ;
lin doughboy_N = mkTerm "doughboy_N" ;
lin doughnut_N = mkTerm "doughnut_N" ;
lin doughty_A = mkTerm "doughty_A" ;
lin doughy_A = mkTerm "doughy_A" ;
lin douglas_PN = mkTerm "douglas_PN" ;
lin dour_A = mkTerm "dour_A" ;
lin douroucouli_N = mkTerm "douroucouli_N" ;
lin douse_V2 = mkTerm "douse_V2" ;
lin dove_N = mkTerm "dove_N" ;
lin dovecote_N = mkTerm "dovecote_N" ;
lin dover_PN = mkTerm "dover_PN" ;
lin dovetail_N = mkTerm "dovetail_N" ;
lin dovetail_V = mkTerm "dovetail_V" ;
lin dovetail_V2 = mkTerm "dovetail_V2" ;
lin dovishness_N = mkTerm "dovishness_N" ;
lin dowager_N = mkTerm "dowager_N" ;
lin dowdiness_N = mkTerm "dowdiness_N" ;
lin dowdy_A = mkTerm "dowdy_A" ;
lin dowdy_N = mkTerm "dowdy_N" ;
lin dowel_N = mkTerm "dowel_N" ;
lin doweling_N = mkTerm "doweling_N" ;
lin dower_N = mkTerm "dower_N" ;
lin dower_V2 = mkTerm "dower_V2" ;
lin dowerless_A = mkTerm "dowerless_A" ;
lin dowitcher_N = mkTerm "dowitcher_N" ;
lin down_A = mkTerm "down_A" ;
lin down_Adv = mkTerm "down_Adv" ;
lin down_N = mkTerm "down_N" ;
lin down_PN = mkTerm "down_PN" ;
lin down_Prep = mkTerm "down_Prep" ;
lin down_V2 = mkTerm "down_V2" ;
lin down_and_out_N = mkTerm "down_and_out_N" ;
lin down_market_A = mkTerm "down_market_A" ;
lin down_to_earth_A = mkTerm "down_to_earth_A" ;
lin downbeat_N = mkTerm "downbeat_N" ;
lin downbound_A = mkTerm "downbound_A" ;
lin downcast_A = mkTerm "downcast_A" ;
lin downcast_N = mkTerm "downcast_N" ;
lin downdraft_N = mkTerm "downdraft_N" ;
lin downfall_N = mkTerm "downfall_N" ;
lin downfield_A = mkTerm "downfield_A" ;
lin downfield_Adv = mkTerm "downfield_Adv" ;
lin downgrade_N = mkTerm "downgrade_N" ;
lin downgrade_V2 = mkTerm "downgrade_V2" ;
lin downhearted_A = mkTerm "downhearted_A" ;
lin downheartedness_N = mkTerm "downheartedness_N" ;
lin downhill_Adv = mkTerm "downhill_Adv" ;
lin downhill_N = mkTerm "downhill_N" ;
lin downiness_N = mkTerm "downiness_N" ;
lin downing_street_PN = mkTerm "downing_street_PN" ;
lin download_N = mkTerm "download_N" ;
lin downloadable_A = mkTerm "downloadable_A" ;
lin downplay_V2 = mkTerm "downplay_V2" ;
lin downpour_N = mkTerm "downpour_N" ;
lin downright_A = mkTerm "downright_A" ;
lin downright_Adv = mkTerm "downright_Adv" ;
lin downrightness_N = mkTerm "downrightness_N" ;
lin downriver_Adv = mkTerm "downriver_Adv" ;
lin downscale_A = mkTerm "downscale_A" ;
lin downshift_N = mkTerm "downshift_N" ;
lin downside_N = mkTerm "downside_N" ;
lin downsize_V2 = mkTerm "downsize_V2" ;
lin downspin_N = mkTerm "downspin_N" ;
lin downstage_A = mkTerm "downstage_A" ;
lin downstage_Adv = mkTerm "downstage_Adv" ;
lin downstage_N = mkTerm "downstage_N" ;
lin downstair_A = mkTerm "downstair_A" ;
lin downstairs_A = mkTerm "downstairs_A" ;
lin downstairs_Adv = mkTerm "downstairs_Adv" ;
lin downstream_A = mkTerm "downstream_A" ;
lin downstream_Adv = mkTerm "downstream_Adv" ;
lin downstroke_N = mkTerm "downstroke_N" ;
lin downswing_N = mkTerm "downswing_N" ;
lin downtick_N = mkTerm "downtick_N" ;
lin downtime_N = mkTerm "downtime_N" ;
lin downtown_A = mkTerm "downtown_A" ;
lin downtown_Adv = mkTerm "downtown_Adv" ;
lin downtown_N = mkTerm "downtown_N" ;
lin downtrodden_A = mkTerm "downtrodden_A" ;
lin downturn_N = mkTerm "downturn_N" ;
lin downward_A = mkTerm "downward_A" ;
lin downward_Adv = mkTerm "downward_Adv" ;
lin downwards_Adv = mkTerm "downwards_Adv" ;
lin downwind_A = mkTerm "downwind_A" ;
lin downwind_Adv = mkTerm "downwind_Adv" ;
lin downy_A = mkTerm "downy_A" ;
lin dowry_N = mkTerm "dowry_N" ;
lin dowse_N = mkTerm "dowse_N" ;
lin dowse_V2 = mkTerm "dowse_V2" ;
lin dowser_N = mkTerm "dowser_N" ;
lin dowsing_N = mkTerm "dowsing_N" ;
lin doxazosin_N = mkTerm "doxazosin_N" ;
lin doxepin_N = mkTerm "doxepin_N" ;
lin doxology_N = mkTerm "doxology_N" ;
lin doxorubicin_N = mkTerm "doxorubicin_N" ;
lin doxycycline_N = mkTerm "doxycycline_N" ;
lin doyen_N = mkTerm "doyen_N" ;
lin doyenne_N = mkTerm "doyenne_N" ;
lin doyley_N = mkTerm "doyley_N" ;
lin doyly_N = mkTerm "doyly_N" ;
lin doz_N = mkTerm "doz_N" ;
lin doze_N = mkTerm "doze_N" ;
lin doze_V = mkTerm "doze_V" ;
lin doze_off_V = mkTerm "doze_off_V" ;
lin dozen_N = mkTerm "dozen_N" ;
lin dphil_N = mkTerm "dphil_N" ;
lin dr_PN = mkTerm "dr_PN" ;
lin drab_A = mkTerm "drab_A" ;
lin draba_N = mkTerm "draba_N" ;
lin drabness_N = mkTerm "drabness_N" ;
lin dracaena_N = mkTerm "dracaena_N" ;
lin drachma_N = mkTerm "drachma_N" ;
lin draconian_A = mkTerm "draconian_A" ;
lin dracontium_N = mkTerm "dracontium_N" ;
lin draft_N = mkTerm "draft_N" ;
lin draft_V2 = mkTerm "draft_V2" ;
lin draftee_N = mkTerm "draftee_N" ;
lin drafter_N = mkTerm "drafter_N" ;
lin drafting_N = mkTerm "drafting_N" ;
lin draftsman_N = mkTerm "draftsman_N" ;
lin drafty_A = mkTerm "drafty_A" ;
lin drag_N = mkTerm "drag_N" ;
lin drag_V = mkTerm "drag_V" ;
lin drag_V2 = mkTerm "drag_V2" ;
lin drag_down_V = mkTerm "drag_down_V" ;
lin drag_in_V = mkTerm "drag_in_V" ;
lin drag_on_V = mkTerm "drag_on_V" ;
lin dragee_N = mkTerm "dragee_N" ;
lin draggingly_Adv = mkTerm "draggingly_Adv" ;
lin draggled_A = mkTerm "draggled_A" ;
lin dragnet_N = mkTerm "dragnet_N" ;
lin dragoman_N = mkTerm "dragoman_N" ;
lin dragon_N = mkTerm "dragon_N" ;
lin dragonet_N = mkTerm "dragonet_N" ;
lin dragonfly_N = mkTerm "dragonfly_N" ;
lin dragonhead_N = mkTerm "dragonhead_N" ;
lin dragoon_N = mkTerm "dragoon_N" ;
lin dragoon_V2 = mkTerm "dragoon_V2" ;
lin dragsfjärd_PN = mkTerm "dragsfjärd_PN" ;
lin drain_N = mkTerm "drain_N" ;
lin drain_V = mkTerm "drain_V" ;
lin drain_V2 = mkTerm "drain_V2" ;
lin drainage_N = mkTerm "drainage_N" ;
lin drainage_basin_N = mkTerm "drainage_basin_N" ;
lin drainboard_N = mkTerm "drainboard_N" ;
lin draining_board_N = mkTerm "draining_board_N" ;
lin drainpipe_N = mkTerm "drainpipe_N" ;
lin drainplug_N = mkTerm "drainplug_N" ;
lin drake_N = mkTerm "drake_N" ;
lin dram_N = mkTerm "dram_N" ;
lin drama_N = mkTerm "drama_N" ;
lin dramatic_A = mkTerm "dramatic_A" ;
lin dramatics_N = mkTerm "dramatics_N" ;
lin dramatist_N = mkTerm "dramatist_N" ;
lin dramatization_N = mkTerm "dramatization_N" ;
lin dramatize_V2 = mkTerm "dramatize_V2" ;
lin dramaturgic_A = mkTerm "dramaturgic_A" ;
lin dramaturgy_N = mkTerm "dramaturgy_N" ;
lin drape_N = mkTerm "drape_N" ;
lin drape_V2 = mkTerm "drape_V2" ;
lin draper_N = mkTerm "draper_N" ;
lin drapery_N = mkTerm "drapery_N" ;
lin drastic_A = mkTerm "drastic_A" ;
lin drat_V2 = mkTerm "drat_V2" ;
lin draught_N = mkTerm "draught_N" ;
lin draught_V2 = mkTerm "draught_V2" ;
lin draught_horse_N = mkTerm "draught_horse_N" ;
lin draughts_N = mkTerm "draughts_N" ;
lin draughtsman_N = mkTerm "draughtsman_N" ;
lin draughty_A = mkTerm "draughty_A" ;
lin draw_1_V2 = mkTerm "draw_1_V2" ;
lin draw_2_V2 = mkTerm "draw_2_V2" ;
lin draw_N = mkTerm "draw_N" ;
lin draw_V = mkTerm "draw_V" ;
lin draw_back_V2 = mkTerm "draw_back_V2" ;
lin draw_down_V2 = mkTerm "draw_down_V2" ;
lin draw_even_V = mkTerm "draw_even_V" ;
lin draw_in_V = mkTerm "draw_in_V" ;
lin draw_into_V2 = mkTerm "draw_into_V2" ;
lin draw_off_V = mkTerm "draw_off_V" ;
lin draw_on_V = mkTerm "draw_on_V" ;
lin draw_on_V2 = mkTerm "draw_on_V2" ;
lin draw_out_V2 = mkTerm "draw_out_V2" ;
lin draw_up_V = mkTerm "draw_up_V" ;
lin draw_up_V2 = mkTerm "draw_up_V2" ;
lin drawback_N = mkTerm "drawback_N" ;
lin drawbar_N = mkTerm "drawbar_N" ;
lin drawbridge_N = mkTerm "drawbridge_N" ;
lin drawee_N = mkTerm "drawee_N" ;
lin drawer_N = mkTerm "drawer_N" ;
lin drawers_N = mkTerm "drawers_N" ;
lin drawing_N = mkTerm "drawing_N" ;
lin drawing_board_N = mkTerm "drawing_board_N" ;
lin drawing_pin_N = mkTerm "drawing_pin_N" ;
lin drawing_room_N = mkTerm "drawing_room_N" ;
lin drawknife_N = mkTerm "drawknife_N" ;
lin drawl_N = mkTerm "drawl_N" ;
lin drawl_V = mkTerm "drawl_V" ;
lin drawl_V2 = mkTerm "drawl_V2" ;
lin drawler_N = mkTerm "drawler_N" ;
lin drawnwork_N = mkTerm "drawnwork_N" ;
lin drawstring_N = mkTerm "drawstring_N" ;
lin dray_N = mkTerm "dray_N" ;
lin drayton_PN = mkTerm "drayton_PN" ;
lin dread_N = mkTerm "dread_N" ;
lin dread_V = mkTerm "dread_V" ;
lin dread_V2 = mkTerm "dread_V2" ;
lin dreadful_A = mkTerm "dreadful_A" ;
lin dreadfulness_N = mkTerm "dreadfulness_N" ;
lin dreadlock_N = mkTerm "dreadlock_N" ;
lin dreadnought_N = mkTerm "dreadnought_N" ;
lin dream_N = mkTerm "dream_N" ;
lin dream_V = mkTerm "dream_V" ;
lin dream_V2 = mkTerm "dream_V2" ;
lin dream_of_V2 = mkTerm "dream_of_V2" ;
lin dream_up_V2 = mkTerm "dream_up_V2" ;
lin dreamer_N = mkTerm "dreamer_N" ;
lin dreamland_N = mkTerm "dreamland_N" ;
lin dreamless_A = mkTerm "dreamless_A" ;
lin dreamlike_A = mkTerm "dreamlike_A" ;
lin dreamworld_N = mkTerm "dreamworld_N" ;
lin dreamy_A = mkTerm "dreamy_A" ;
lin drear_A = mkTerm "drear_A" ;
lin dreariness_N = mkTerm "dreariness_N" ;
lin dreary_A = mkTerm "dreary_A" ;
lin dredge_N = mkTerm "dredge_N" ;
lin dredge_V = mkTerm "dredge_V" ;
lin dredge_V2 = mkTerm "dredge_V2" ;
lin dredge_up_V2 = mkTerm "dredge_up_V2" ;
lin dredger_N = mkTerm "dredger_N" ;
lin dreg_N = mkTerm "dreg_N" ;
lin dregs_N = mkTerm "dregs_N" ;
lin drench_V2 = mkTerm "drench_V2" ;
lin drenching_N = mkTerm "drenching_N" ;
lin dresden_PN = mkTerm "dresden_PN" ;
lin dress_A = mkTerm "dress_A" ;
lin dress_N = mkTerm "dress_N" ;
lin dress_V = mkTerm "dress_V" ;
lin dress_V2 = mkTerm "dress_V2" ;
lin dress_down_V = mkTerm "dress_down_V" ;
lin dress_down_V2 = mkTerm "dress_down_V2" ;
lin dress_hanger_N = mkTerm "dress_hanger_N" ;
lin dress_up_V = mkTerm "dress_up_V" ;
lin dress_up_V2 = mkTerm "dress_up_V2" ;
lin dressage_N = mkTerm "dressage_N" ;
lin dresser_N = mkTerm "dresser_N" ;
lin dressing_N = mkTerm "dressing_N" ;
lin dressing_case_N = mkTerm "dressing_case_N" ;
lin dressing_down_N = mkTerm "dressing_down_N" ;
lin dressing_gown_N = mkTerm "dressing_gown_N" ;
lin dressing_table_N = mkTerm "dressing_table_N" ;
lin dressmaker_N = mkTerm "dressmaker_N" ;
lin dressmaking_N = mkTerm "dressmaking_N" ;
lin dressy_A = mkTerm "dressy_A" ;
lin drey_N = mkTerm "drey_N" ;
lin dribble_N = mkTerm "dribble_N" ;
lin dribble_V = mkTerm "dribble_V" ;
lin dribble_V2 = mkTerm "dribble_V2" ;
lin dribbler_N = mkTerm "dribbler_N" ;
lin driblet_N = mkTerm "driblet_N" ;
lin drier_N = mkTerm "drier_N" ;
lin driffield_PN = mkTerm "driffield_PN" ;
lin drift_N = mkTerm "drift_N" ;
lin drift_V = mkTerm "drift_V" ;
lin drift_V2 = mkTerm "drift_V2" ;
lin drift_apart_V = mkTerm "drift_apart_V" ;
lin drift_ice_N = mkTerm "drift_ice_N" ;
lin drift_net_N = mkTerm "drift_net_N" ;
lin drift_off_V = mkTerm "drift_off_V" ;
lin drift_wood_N = mkTerm "drift_wood_N" ;
lin driftage_N = mkTerm "driftage_N" ;
lin drifter_N = mkTerm "drifter_N" ;
lin driftfish_N = mkTerm "driftfish_N" ;
lin drifting_N = mkTerm "drifting_N" ;
lin drill_N = mkTerm "drill_N" ;
lin drill_V = mkTerm "drill_V" ;
lin drill_V2 = mkTerm "drill_V2" ;
lin drill_down_V = mkTerm "drill_down_V" ;
lin drill_down_through_V2 = mkTerm "drill_down_through_V2" ;
lin drill_into_V3 = mkTerm "drill_into_V3" ;
lin drilling_N = mkTerm "drilling_N" ;
lin drink_N = mkTerm "drink_N" ;
lin drink_V = mkTerm "drink_V" ;
lin drink_V2 = mkTerm "drink_V2" ;
lin drink_up_V2 = mkTerm "drink_up_V2" ;
lin drinkable_A = mkTerm "drinkable_A" ;
lin drinker_N = mkTerm "drinker_N" ;
lin drinking_N = mkTerm "drinking_N" ;
lin drinking_bout_N = mkTerm "drinking_bout_N" ;
lin drinking_fountain_N = mkTerm "drinking_fountain_N" ;
lin drinking_song_N = mkTerm "drinking_song_N" ;
lin drinking_water_N = mkTerm "drinking_water_N" ;
lin drip_N = mkTerm "drip_N" ;
lin drip_V = mkTerm "drip_V" ;
lin drip_V2 = mkTerm "drip_V2" ;
lin drip_dry_A = mkTerm "drip_dry_A" ;
lin drip_dry_V2 = mkTerm "drip_dry_V2" ;
lin dripless_A = mkTerm "dripless_A" ;
lin drippiness_N = mkTerm "drippiness_N" ;
lin dripping_N = mkTerm "dripping_N" ;
lin dripping_pan_N = mkTerm "dripping_pan_N" ;
lin drippings_N = mkTerm "drippings_N" ;
lin drippy_A = mkTerm "drippy_A" ;
lin dripstone_N = mkTerm "dripstone_N" ;
lin drive_N = mkTerm "drive_N" ;
lin drive_V = mkTerm "drive_V" ;
lin drive_V2 = mkTerm "drive_V2" ;
lin drive_V2V = mkTerm "drive_V2V" ;
lin drive_away_V2 = mkTerm "drive_away_V2" ;
lin drive_back_V2 = mkTerm "drive_back_V2" ;
lin drive_by_V = mkTerm "drive_by_V" ;
lin drive_down_V = mkTerm "drive_down_V" ;
lin drive_in_N = mkTerm "drive_in_N" ;
lin drive_off_V = mkTerm "drive_off_V" ;
lin drive_out_V2 = mkTerm "drive_out_V2" ;
lin drive_up_V = mkTerm "drive_up_V" ;
lin drive_up_V2 = mkTerm "drive_up_V2" ;
lin drivel_N = mkTerm "drivel_N" ;
lin drivel_V = mkTerm "drivel_V" ;
lin driveller_N = mkTerm "driveller_N" ;
lin driverFem_N = mkTerm "driverFem_N" ;
lin driverMasc_N = mkTerm "driverMasc_N" ;
lin driver_N = mkTerm "driver_N" ;
lin driveshaft_N = mkTerm "driveshaft_N" ;
lin driveway_N = mkTerm "driveway_N" ;
lin driving_A = mkTerm "driving_A" ;
lin driving_N = mkTerm "driving_N" ;
lin driving_belt_N = mkTerm "driving_belt_N" ;
lin driving_wheel_N = mkTerm "driving_wheel_N" ;
lin drizzle_N = mkTerm "drizzle_N" ;
lin drizzle_V = mkTerm "drizzle_V" ;
lin drizzly_A = mkTerm "drizzly_A" ;
lin drogheda_PN = mkTerm "drogheda_PN" ;
lin drogue_N = mkTerm "drogue_N" ;
lin droitwich_PN = mkTerm "droitwich_PN" ;
lin droll_A = mkTerm "droll_A" ;
lin drollery_N = mkTerm "drollery_N" ;
lin dromaeosaur_N = mkTerm "dromaeosaur_N" ;
lin dromedary_N = mkTerm "dromedary_N" ;
lin dronabinol_N = mkTerm "dronabinol_N" ;
lin drone_N = mkTerm "drone_N" ;
lin drone_V = mkTerm "drone_V" ;
lin drone_V2 = mkTerm "drone_V2" ;
lin drone_on_V = mkTerm "drone_on_V" ;
lin dronfield_PN = mkTerm "dronfield_PN" ;
lin drool_N = mkTerm "drool_N" ;
lin drool_V = mkTerm "drool_V" ;
lin droop_N = mkTerm "droop_N" ;
lin droop_V = mkTerm "droop_V" ;
lin droop_V2 = mkTerm "droop_V2" ;
lin droopingly_Adv = mkTerm "droopingly_Adv" ;
lin drop_N = mkTerm "drop_N" ;
lin drop_V = mkTerm "drop_V" ;
lin drop_V2 = mkTerm "drop_V2" ;
lin drop_around_V = mkTerm "drop_around_V" ;
lin drop_around_V2 = mkTerm "drop_around_V2" ;
lin drop_away_V = mkTerm "drop_away_V" ;
lin drop_back_V = mkTerm "drop_back_V" ;
lin drop_by_V = mkTerm "drop_by_V" ;
lin drop_curtain_N = mkTerm "drop_curtain_N" ;
lin drop_in_V = mkTerm "drop_in_V" ;
lin drop_in_on_V2 = mkTerm "drop_in_on_V2" ;
lin drop_kick_N = mkTerm "drop_kick_N" ;
lin drop_off_V = mkTerm "drop_off_V" ;
lin drop_off_V2 = mkTerm "drop_off_V2" ;
lin drop_out_V = mkTerm "drop_out_V" ;
lin drop_out_of_V2 = mkTerm "drop_out_of_V2" ;
lin drop_over_V = mkTerm "drop_over_V" ;
lin drop_round_V = mkTerm "drop_round_V" ;
lin drop_round_V2 = mkTerm "drop_round_V2" ;
lin drop_someone_in_it_V2 = mkTerm "drop_someone_in_it_V2" ;
lin drop_through_V = mkTerm "drop_through_V" ;
lin dropkick_N = mkTerm "dropkick_N" ;
lin dropkicker_N = mkTerm "dropkicker_N" ;
lin droplet_N = mkTerm "droplet_N" ;
lin dropline_N = mkTerm "dropline_N" ;
lin dropout_N = mkTerm "dropout_N" ;
lin dropper_N = mkTerm "dropper_N" ;
lin dropping_zone_N = mkTerm "dropping_zone_N" ;
lin droppings_N = mkTerm "droppings_N" ;
lin dropseed_N = mkTerm "dropseed_N" ;
lin dropsical_A = mkTerm "dropsical_A" ;
lin dropsy_N = mkTerm "dropsy_N" ;
lin droshky_N = mkTerm "droshky_N" ;
lin drosophila_N = mkTerm "drosophila_N" ;
lin dross_N = mkTerm "dross_N" ;
lin drought_N = mkTerm "drought_N" ;
lin drove_N = mkTerm "drove_N" ;
lin drover_N = mkTerm "drover_N" ;
lin drown_V = mkTerm "drown_V" ;
lin drown_V2 = mkTerm "drown_V2" ;
lin drown_in_V2 = mkTerm "drown_in_V2" ;
lin drown_out_V2 = mkTerm "drown_out_V2" ;
lin drowse_N = mkTerm "drowse_N" ;
lin drowse_V = mkTerm "drowse_V" ;
lin drowse_V2 = mkTerm "drowse_V2" ;
lin drowsiness_N = mkTerm "drowsiness_N" ;
lin drowsy_A = mkTerm "drowsy_A" ;
lin drub_V2 = mkTerm "drub_V2" ;
lin drubbing_N = mkTerm "drubbing_N" ;
lin drudge_N = mkTerm "drudge_N" ;
lin drudge_V = mkTerm "drudge_V" ;
lin drudgery_N = mkTerm "drudgery_N" ;
lin drug_N = mkTerm "drug_N" ;
lin drug_V2 = mkTerm "drug_V2" ;
lin drugget_N = mkTerm "drugget_N" ;
lin druggist_N = mkTerm "druggist_N" ;
lin drugless_A = mkTerm "drugless_A" ;
lin drugstore_N = mkTerm "drugstore_N" ;
lin druid_N = mkTerm "druid_N" ;
lin druidism_N = mkTerm "druidism_N" ;
lin drum_N = mkTerm "drum_N" ;
lin drum_V = mkTerm "drum_V" ;
lin drum_V2 = mkTerm "drum_V2" ;
lin drum_into_V2 = mkTerm "drum_into_V2" ;
lin drum_major_N = mkTerm "drum_major_N" ;
lin drum_majorette_N = mkTerm "drum_majorette_N" ;
lin drum_out_V2 = mkTerm "drum_out_V2" ;
lin drum_up_V2 = mkTerm "drum_up_V2" ;
lin drumbeat_N = mkTerm "drumbeat_N" ;
lin drumfire_N = mkTerm "drumfire_N" ;
lin drumhead_A = mkTerm "drumhead_A" ;
lin drumhead_N = mkTerm "drumhead_N" ;
lin drumlin_N = mkTerm "drumlin_N" ;
lin drummer_N = mkTerm "drummer_N" ;
lin drumming_N = mkTerm "drumming_N" ;
lin drumstick_N = mkTerm "drumstick_N" ;
lin drunk_A = mkTerm "drunk_A" ;
lin drunk_N = mkTerm "drunk_N" ;
lin drunkard_N = mkTerm "drunkard_N" ;
lin drunken_A = mkTerm "drunken_A" ;
lin drunkenness_N = mkTerm "drunkenness_N" ;
lin drupaceous_A = mkTerm "drupaceous_A" ;
lin drupe_N = mkTerm "drupe_N" ;
lin drupelet_N = mkTerm "drupelet_N" ;
lin drusen_N = mkTerm "drusen_N" ;
lin dry_A = mkTerm "dry_A" ;
lin dry_N = mkTerm "dry_N" ;
lin dry_V = mkTerm "dry_V" ;
lin dry_V2 = mkTerm "dry_V2" ;
lin dry_clean_V2 = mkTerm "dry_clean_V2" ;
lin dry_cleaner_N = mkTerm "dry_cleaner_N" ;
lin dry_cleaning_N = mkTerm "dry_cleaning_N" ;
lin dry_off_V2 = mkTerm "dry_off_V2" ;
lin dry_out_V = mkTerm "dry_out_V" ;
lin dry_out_V2 = mkTerm "dry_out_V2" ;
lin dry_shod_A = mkTerm "dry_shod_A" ;
lin dry_up_V = mkTerm "dry_up_V" ;
lin dry_up_V2 = mkTerm "dry_up_V2" ;
lin dry_walling_N = mkTerm "dry_walling_N" ;
lin dryad_N = mkTerm "dryad_N" ;
lin dryer_N = mkTerm "dryer_N" ;
lin drygoods_N = mkTerm "drygoods_N" ;
lin dryness_N = mkTerm "dryness_N" ;
lin dryopithecine_N = mkTerm "dryopithecine_N" ;
lin drypis_N = mkTerm "drypis_N" ;
lin dsc_N = mkTerm "dsc_N" ;
lin dscdna_N = mkTerm "dscdna_N" ;
lin dss_N = mkTerm "dss_N" ;
lin dti_N = mkTerm "dti_N" ;
lin dual_A = mkTerm "dual_A" ;
lin dualism_N = mkTerm "dualism_N" ;
lin dualist_N = mkTerm "dualist_N" ;
lin dualistic_A = mkTerm "dualistic_A" ;
lin duality_N = mkTerm "duality_N" ;
lin dub_N = mkTerm "dub_N" ;
lin dub_V2 = mkTerm "dub_V2" ;
lin dub_V3 = mkTerm "dub_V3" ;
lin dubbin_N = mkTerm "dubbin_N" ;
lin dubbing_N = mkTerm "dubbing_N" ;
lin dubiety_N = mkTerm "dubiety_N" ;
lin dubious_A = mkTerm "dubious_A" ;
lin dubiousness_N = mkTerm "dubiousness_N" ;
lin dublin_PN = mkTerm "dublin_PN" ;
lin dubliner_N = mkTerm "dubliner_N" ;
lin dubnium_N = mkTerm "dubnium_N" ;
lin ducal_A = mkTerm "ducal_A" ;
lin ducat_N = mkTerm "ducat_N" ;
lin duce_N = mkTerm "duce_N" ;
lin duchess_N = mkTerm "duchess_N" ;
lin duchy_A = mkTerm "duchy_A" ;
lin duchy_N = mkTerm "duchy_N" ;
lin duck_N = mkTerm "duck_N" ;
lin duck_V = mkTerm "duck_V" ;
lin duck_V2 = mkTerm "duck_V2" ;
lin duck_out_of_V2 = mkTerm "duck_out_of_V2" ;
lin duckbill_A = mkTerm "duckbill_A" ;
lin duckbilled_A = mkTerm "duckbilled_A" ;
lin duckboard_N = mkTerm "duckboard_N" ;
lin ducking_N = mkTerm "ducking_N" ;
lin ducking_stool_N = mkTerm "ducking_stool_N" ;
lin duckling_N = mkTerm "duckling_N" ;
lin duckpin_N = mkTerm "duckpin_N" ;
lin duckpins_N = mkTerm "duckpins_N" ;
lin duckweed_N = mkTerm "duckweed_N" ;
lin ducky_N = mkTerm "ducky_N" ;
lin duct_N = mkTerm "duct_N" ;
lin ductile_A = mkTerm "ductile_A" ;
lin ductility_N = mkTerm "ductility_N" ;
lin ductless_A = mkTerm "ductless_A" ;
lin ductule_N = mkTerm "ductule_N" ;
lin dud_A = mkTerm "dud_A" ;
lin dud_N = mkTerm "dud_N" ;
lin dude_N = mkTerm "dude_N" ;
lin dudeen_N = mkTerm "dudeen_N" ;
lin dudgeon_N = mkTerm "dudgeon_N" ;
lin dudley_PN = mkTerm "dudley_PN" ;
lin due_A = mkTerm "due_A" ;
lin due_Adv = mkTerm "due_Adv" ;
lin due_N = mkTerm "due_N" ;
lin due_to_Prep = mkTerm "due_to_Prep" ;
lin duel_N = mkTerm "duel_N" ;
lin duel_V = mkTerm "duel_V" ;
lin dueler_N = mkTerm "dueler_N" ;
lin duellist_N = mkTerm "duellist_N" ;
lin duenna_N = mkTerm "duenna_N" ;
lin duet_N = mkTerm "duet_N" ;
lin duff_N = mkTerm "duff_N" ;
lin duff_up_V2 = mkTerm "duff_up_V2" ;
lin duffel_N = mkTerm "duffel_N" ;
lin duffer_N = mkTerm "duffer_N" ;
lin duffle_N = mkTerm "duffle_N" ;
lin dug_N = mkTerm "dug_N" ;
lin dug_out_V = mkTerm "dug_out_V" ;
lin dugong_N = mkTerm "dugong_N" ;
lin dugout_N = mkTerm "dugout_N" ;
lin duisburg_PN = mkTerm "duisburg_PN" ;
lin duke_N = mkTerm "duke_N" ;
lin dukedom_N = mkTerm "dukedom_N" ;
lin dukinfield_PN = mkTerm "dukinfield_PN" ;
lin dulcet_A = mkTerm "dulcet_A" ;
lin dulciana_N = mkTerm "dulciana_N" ;
lin dulcimer_N = mkTerm "dulcimer_N" ;
lin dull_A = mkTerm "dull_A" ;
lin dull_V = mkTerm "dull_V" ;
lin dull_V2 = mkTerm "dull_V2" ;
lin dullard_N = mkTerm "dullard_N" ;
lin dullness_N = mkTerm "dullness_N" ;
lin dulse_N = mkTerm "dulse_N" ;
lin duly_AdV = mkTerm "duly_AdV" ;
lin duly_Adv = mkTerm "duly_Adv" ;
lin dumb_A = mkTerm "dumb_A" ;
lin dumb_down_V2 = mkTerm "dumb_down_V2" ;
lin dumbarton_PN = mkTerm "dumbarton_PN" ;
lin dumbbell_N = mkTerm "dumbbell_N" ;
lin dumbfound_V2 = mkTerm "dumbfound_V2" ;
lin dumbness_N = mkTerm "dumbness_N" ;
lin dumbwaiter_N = mkTerm "dumbwaiter_N" ;
lin dumdum_N = mkTerm "dumdum_N" ;
lin dumfries_PN = mkTerm "dumfries_PN" ;
lin dummy_A = mkTerm "dummy_A" ;
lin dummy_N = mkTerm "dummy_N" ;
lin dump_N = mkTerm "dump_N" ;
lin dump_V = mkTerm "dump_V" ;
lin dump_V2 = mkTerm "dump_V2" ;
lin dump_on_V2 = mkTerm "dump_on_V2" ;
lin dumpcart_N = mkTerm "dumpcart_N" ;
lin dumper_N = mkTerm "dumper_N" ;
lin dumpiness_N = mkTerm "dumpiness_N" ;
lin dumping_N = mkTerm "dumping_N" ;
lin dumpling_N = mkTerm "dumpling_N" ;
lin dumps_N = mkTerm "dumps_N" ;
lin dumpy_A = mkTerm "dumpy_A" ;
lin dun_A = mkTerm "dun_A" ;
lin dun_N = mkTerm "dun_N" ;
lin dun_V2 = mkTerm "dun_V2" ;
lin dun_laoghaire_PN = mkTerm "dun_laoghaire_PN" ;
lin duncan_PN = mkTerm "duncan_PN" ;
lin dunce_N = mkTerm "dunce_N" ;
lin dundalk_PN = mkTerm "dundalk_PN" ;
lin dundee_PN = mkTerm "dundee_PN" ;
lin dunderhead_N = mkTerm "dunderhead_N" ;
lin dune_N = mkTerm "dune_N" ;
lin dunfermline_PN = mkTerm "dunfermline_PN" ;
lin dung_N = mkTerm "dung_N" ;
lin dungeon_N = mkTerm "dungeon_N" ;
lin dunghill_N = mkTerm "dunghill_N" ;
lin dunk_N = mkTerm "dunk_N" ;
lin dunk_V2 = mkTerm "dunk_V2" ;
lin dunker_N = mkTerm "dunker_N" ;
lin dunkirk_PN = mkTerm "dunkirk_PN" ;
lin dunoon_PN = mkTerm "dunoon_PN" ;
lin dunstable_PN = mkTerm "dunstable_PN" ;
lin duo_N = mkTerm "duo_N" ;
lin duodecimal_A = mkTerm "duodecimal_A" ;
lin duodenal_A = mkTerm "duodenal_A" ;
lin duodenum_N = mkTerm "duodenum_N" ;
lin duologue_N = mkTerm "duologue_N" ;
lin dupe_N = mkTerm "dupe_N" ;
lin dupe_V2 = mkTerm "dupe_V2" ;
lin dupl_PN = mkTerm "dupl_PN" ;
lin duplex_A = mkTerm "duplex_A" ;
lin duplicable_A = mkTerm "duplicable_A" ;
lin duplicate_A = mkTerm "duplicate_A" ;
lin duplicate_N = mkTerm "duplicate_N" ;
lin duplicate_V2 = mkTerm "duplicate_V2" ;
lin duplication_N = mkTerm "duplication_N" ;
lin duplicator_N = mkTerm "duplicator_N" ;
lin duplicity_N = mkTerm "duplicity_N" ;
lin durability_N = mkTerm "durability_N" ;
lin durable_A = mkTerm "durable_A" ;
lin durable_N = mkTerm "durable_N" ;
lin durables_N = mkTerm "durables_N" ;
lin dural_A = mkTerm "dural_A" ;
lin durance_N = mkTerm "durance_N" ;
lin duration_N = mkTerm "duration_N" ;
lin durative_N = mkTerm "durative_N" ;
lin durban_PN = mkTerm "durban_PN" ;
lin durbar_N = mkTerm "durbar_N" ;
lin duress_N = mkTerm "duress_N" ;
lin durham_PN = mkTerm "durham_PN" ;
lin durian_N = mkTerm "durian_N" ;
lin durmast_N = mkTerm "durmast_N" ;
lin durra_N = mkTerm "durra_N" ;
lin durrington_PN = mkTerm "durrington_PN" ;
lin dursley_PN = mkTerm "dursley_PN" ;
lin durum_N = mkTerm "durum_N" ;
lin dusk_N = mkTerm "dusk_N" ;
lin dusky_A = mkTerm "dusky_A" ;
lin dusseldorf_PN = mkTerm "dusseldorf_PN" ;
lin dust_N = mkTerm "dust_N" ;
lin dust_V2 = mkTerm "dust_V2" ;
lin dust_bowl_N = mkTerm "dust_bowl_N" ;
lin dust_coat_N = mkTerm "dust_coat_N" ;
lin dust_jacket_N = mkTerm "dust_jacket_N" ;
lin dust_off_V = mkTerm "dust_off_V" ;
lin dust_sheet_N = mkTerm "dust_sheet_N" ;
lin dust_up_N = mkTerm "dust_up_N" ;
lin dust_wrapper_N = mkTerm "dust_wrapper_N" ;
lin dustbin_N = mkTerm "dustbin_N" ;
lin dustcart_N = mkTerm "dustcart_N" ;
lin dustcloth_N = mkTerm "dustcloth_N" ;
lin duster_N = mkTerm "duster_N" ;
lin dustiness_N = mkTerm "dustiness_N" ;
lin dustlike_A = mkTerm "dustlike_A" ;
lin dustman_N = mkTerm "dustman_N" ;
lin dustmop_N = mkTerm "dustmop_N" ;
lin dustpan_N = mkTerm "dustpan_N" ;
lin dusty_A = mkTerm "dusty_A" ;
lin dutchFem_N = mkTerm "dutchFem_N" ;
lin dutchMasc_N = mkTerm "dutchMasc_N" ;
lin dutch_A = mkTerm "dutch_A" ;
lin duteous_A = mkTerm "duteous_A" ;
lin dutiable_A = mkTerm "dutiable_A" ;
lin dutiful_A = mkTerm "dutiful_A" ;
lin dutifulness_N = mkTerm "dutifulness_N" ;
lin duty_N = mkTerm "duty_N" ;
lin duty_free_A = mkTerm "duty_free_A" ;
lin duvet_N = mkTerm "duvet_N" ;
lin dwarf_N = mkTerm "dwarf_N" ;
lin dwarf_V2 = mkTerm "dwarf_V2" ;
lin dwarfish_A = mkTerm "dwarfish_A" ;
lin dwarfishness_N = mkTerm "dwarfishness_N" ;
lin dwarfism_N = mkTerm "dwarfism_N" ;
lin dwell_V = mkTerm "dwell_V" ;
lin dwell_on_V2 = mkTerm "dwell_on_V2" ;
lin dwell_upon_V2 = mkTerm "dwell_upon_V2" ;
lin dweller_N = mkTerm "dweller_N" ;
lin dwelling_N = mkTerm "dwelling_N" ;
lin dwelling_house_N = mkTerm "dwelling_house_N" ;
lin dwindle_V = mkTerm "dwindle_V" ;
lin dwindling_N = mkTerm "dwindling_N" ;
lin dyadic_A = mkTerm "dyadic_A" ;
lin dyarchy_N = mkTerm "dyarchy_N" ;
lin dybbuk_N = mkTerm "dybbuk_N" ;
lin dye_N = mkTerm "dye_N" ;
lin dye_V = mkTerm "dye_V" ;
lin dye_V2 = mkTerm "dye_V2" ;
lin dye_works_N = mkTerm "dye_works_N" ;
lin dyed_in_the_wool_A = mkTerm "dyed_in_the_wool_A" ;
lin dyeing_N = mkTerm "dyeing_N" ;
lin dyer_N = mkTerm "dyer_N" ;
lin dyestuff_N = mkTerm "dyestuff_N" ;
lin dyewood_N = mkTerm "dyewood_N" ;
lin dyfed_PN = mkTerm "dyfed_PN" ;
lin dyke_N = mkTerm "dyke_N" ;
lin dyke_V = mkTerm "dyke_V" ;
lin dyke_V2 = mkTerm "dyke_V2" ;
lin dynamic_A = mkTerm "dynamic_A" ;
lin dynamic_N = mkTerm "dynamic_N" ;
lin dynamics_N = mkTerm "dynamics_N" ;
lin dynamism_N = mkTerm "dynamism_N" ;
lin dynamite_N = mkTerm "dynamite_N" ;
lin dynamite_V2 = mkTerm "dynamite_V2" ;
lin dynamiter_N = mkTerm "dynamiter_N" ;
lin dynamo_N = mkTerm "dynamo_N" ;
lin dynamometer_N = mkTerm "dynamometer_N" ;
lin dynast_N = mkTerm "dynast_N" ;
lin dynastic_A = mkTerm "dynastic_A" ;
lin dynasty_N = mkTerm "dynasty_N" ;
lin dyne_N = mkTerm "dyne_N" ;
lin dysaphia_N = mkTerm "dysaphia_N" ;
lin dysarthria_N = mkTerm "dysarthria_N" ;
lin dyscalculia_N = mkTerm "dyscalculia_N" ;
lin dyschezia_N = mkTerm "dyschezia_N" ;
lin dyscrasia_N = mkTerm "dyscrasia_N" ;
lin dysentery_N = mkTerm "dysentery_N" ;
lin dysfunction_N = mkTerm "dysfunction_N" ;
lin dysfunctional_A = mkTerm "dysfunctional_A" ;
lin dysgenesis_N = mkTerm "dysgenesis_N" ;
lin dysgenic_A = mkTerm "dysgenic_A" ;
lin dysgenics_N = mkTerm "dysgenics_N" ;
lin dysgraphia_N = mkTerm "dysgraphia_N" ;
lin dyskinesia_N = mkTerm "dyskinesia_N" ;
lin dyslectic_A = mkTerm "dyslectic_A" ;
lin dyslectic_N = mkTerm "dyslectic_N" ;
lin dyslexia_N = mkTerm "dyslexia_N" ;
lin dyslexic_A = mkTerm "dyslexic_A" ;
lin dyslogia_N = mkTerm "dyslogia_N" ;
lin dyslogistic_A = mkTerm "dyslogistic_A" ;
lin dysmenorrhea_N = mkTerm "dysmenorrhea_N" ;
lin dysomia_N = mkTerm "dysomia_N" ;
lin dysosmia_N = mkTerm "dysosmia_N" ;
lin dyspepsia_N = mkTerm "dyspepsia_N" ;
lin dyspeptic_A = mkTerm "dyspeptic_A" ;
lin dyspeptic_N = mkTerm "dyspeptic_N" ;
lin dysphagia_N = mkTerm "dysphagia_N" ;
lin dysphasia_N = mkTerm "dysphasia_N" ;
lin dysphemism_N = mkTerm "dysphemism_N" ;
lin dysphemistic_A = mkTerm "dysphemistic_A" ;
lin dysphonia_N = mkTerm "dysphonia_N" ;
lin dysphoria_N = mkTerm "dysphoria_N" ;
lin dysphoric_A = mkTerm "dysphoric_A" ;
lin dysplasia_N = mkTerm "dysplasia_N" ;
lin dysplastic_A = mkTerm "dysplastic_A" ;
lin dyspnea_N = mkTerm "dyspnea_N" ;
lin dysprosium_N = mkTerm "dysprosium_N" ;
lin dysthymia_N = mkTerm "dysthymia_N" ;
lin dystopia_N = mkTerm "dystopia_N" ;
lin dystopian_A = mkTerm "dystopian_A" ;
lin dystrophy_N = mkTerm "dystrophy_N" ;
lin dysuria_N = mkTerm "dysuria_N" ;
lin e'en_Adv = mkTerm "e'en_Adv" ;
lin e'er_Adv = mkTerm "e'er_Adv" ;
lin e_mail_N = mkTerm "e_mail_N" ;
lin each_Adv = mkTerm "each_Adv" ;
lin each_Det = mkTerm "each_Det" ;
lin eager_A = mkTerm "eager_A" ;
lin eagerness_N = mkTerm "eagerness_N" ;
lin eagle_N = mkTerm "eagle_N" ;
lin eagle_eyed_A = mkTerm "eagle_eyed_A" ;
lin eaglescliffe_PN = mkTerm "eaglescliffe_PN" ;
lin eaglet_N = mkTerm "eaglet_N" ;
lin ealing_PN = mkTerm "ealing_PN" ;
lin ear_N = mkTerm "ear_N" ;
lin ear_trumpet_N = mkTerm "ear_trumpet_N" ;
lin earache_N = mkTerm "earache_N" ;
lin eardrop_N = mkTerm "eardrop_N" ;
lin eardrum_N = mkTerm "eardrum_N" ;
lin eared_A = mkTerm "eared_A" ;
lin earflap_N = mkTerm "earflap_N" ;
lin earful_N = mkTerm "earful_N" ;
lin earl_N = mkTerm "earl_N" ;
lin earl_shilton_PN = mkTerm "earl_shilton_PN" ;
lin earldom_N = mkTerm "earldom_N" ;
lin earless_A = mkTerm "earless_A" ;
lin earlier_A = mkTerm "earlier_A" ;
lin earlier_Adv = mkTerm "earlier_Adv" ;
lin earliness_N = mkTerm "earliness_N" ;
lin earlobe_N = mkTerm "earlobe_N" ;
lin early_A = mkTerm "early_A" ;
lin early_Adv = mkTerm "early_Adv" ;
lin early_on_Adv = mkTerm "early_on_Adv" ;
lin early_warning_A = mkTerm "early_warning_A" ;
lin earlyish_A = mkTerm "earlyish_A" ;
lin earmark_N = mkTerm "earmark_N" ;
lin earmark_V2 = mkTerm "earmark_V2" ;
lin earmuff_N = mkTerm "earmuff_N" ;
lin earn_V = mkTerm "earn_V" ;
lin earn_V2 = mkTerm "earn_V2" ;
lin earner_N = mkTerm "earner_N" ;
lin earnest_A = mkTerm "earnest_A" ;
lin earnest_N = mkTerm "earnest_N" ;
lin earnest_money_N = mkTerm "earnest_money_N" ;
lin earnestness_N = mkTerm "earnestness_N" ;
lin earning_N = mkTerm "earning_N" ;
lin earnings_N = mkTerm "earnings_N" ;
lin earphone_N = mkTerm "earphone_N" ;
lin earpiece_N = mkTerm "earpiece_N" ;
lin earplug_N = mkTerm "earplug_N" ;
lin earring_N = mkTerm "earring_N" ;
lin earshot_N = mkTerm "earshot_N" ;
lin earth_N = mkTerm "earth_N" ;
lin earth_V2 = mkTerm "earth_V2" ;
lin earth_closet_N = mkTerm "earth_closet_N" ;
lin earthball_N = mkTerm "earthball_N" ;
lin earthborn_A = mkTerm "earthborn_A" ;
lin earthbound_A = mkTerm "earthbound_A" ;
lin earthen_A = mkTerm "earthen_A" ;
lin earthenware_N = mkTerm "earthenware_N" ;
lin earthlike_A = mkTerm "earthlike_A" ;
lin earthly_A = mkTerm "earthly_A" ;
lin earthnut_N = mkTerm "earthnut_N" ;
lin earthquake_N = mkTerm "earthquake_N" ;
lin earthshaking_A = mkTerm "earthshaking_A" ;
lin earthstar_N = mkTerm "earthstar_N" ;
lin earthtongue_N = mkTerm "earthtongue_N" ;
lin earthwork_N = mkTerm "earthwork_N" ;
lin earthworm_N = mkTerm "earthworm_N" ;
lin earthy_A = mkTerm "earthy_A" ;
lin earwax_N = mkTerm "earwax_N" ;
lin earwig_N = mkTerm "earwig_N" ;
lin ease_N = mkTerm "ease_N" ;
lin ease_V = mkTerm "ease_V" ;
lin ease_V2 = mkTerm "ease_V2" ;
lin ease_off_V2 = mkTerm "ease_off_V2" ;
lin ease_up_V = mkTerm "ease_up_V" ;
lin easel_N = mkTerm "easel_N" ;
lin easement_N = mkTerm "easement_N" ;
lin easiness_N = mkTerm "easiness_N" ;
lin easing_N = mkTerm "easing_N" ;
lin easington_PN = mkTerm "easington_PN" ;
lin east_A = mkTerm "east_A" ;
lin east_Adv = mkTerm "east_Adv" ;
lin east_N = mkTerm "east_N" ;
lin east_dereham_PN = mkTerm "east_dereham_PN" ;
lin east_grinstead_PN = mkTerm "east_grinstead_PN" ;
lin east_kilbride_PN = mkTerm "east_kilbride_PN" ;
lin east_retford_PN = mkTerm "east_retford_PN" ;
lin eastbound_A = mkTerm "eastbound_A" ;
lin eastbourne_PN = mkTerm "eastbourne_PN" ;
lin easter_N = mkTerm "easter_N" ;
lin easter_PN = mkTerm "easter_PN" ;
lin easterly_A = mkTerm "easterly_A" ;
lin easterly_Adv = mkTerm "easterly_Adv" ;
lin eastern_A = mkTerm "eastern_A" ;
lin easterner_N = mkTerm "easterner_N" ;
lin easternmost_A = mkTerm "easternmost_A" ;
lin eastleigh_PN = mkTerm "eastleigh_PN" ;
lin eastside_A = mkTerm "eastside_A" ;
lin eastward_A = mkTerm "eastward_A" ;
lin eastward_Adv = mkTerm "eastward_Adv" ;
lin eastwards_Adv = mkTerm "eastwards_Adv" ;
lin easy_A = mkTerm "easy_A" ;
lin easy_Adv = mkTerm "easy_Adv" ;
lin easy_V2V = mkTerm "easy_V2V" ;
lin easygoing_A = mkTerm "easygoing_A" ;
lin easygoingness_N = mkTerm "easygoingness_N" ;
lin eat_V = mkTerm "eat_V" ;
lin eat_V2 = mkTerm "eat_V2" ;
lin eat_away_V = mkTerm "eat_away_V" ;
lin eat_away_V2 = mkTerm "eat_away_V2" ;
lin eat_in_V = mkTerm "eat_in_V" ;
lin eat_into_V2 = mkTerm "eat_into_V2" ;
lin eat_out_V = mkTerm "eat_out_V" ;
lin eat_up_V2 = mkTerm "eat_up_V2" ;
lin eatable_A = mkTerm "eatable_A" ;
lin eatable_N = mkTerm "eatable_N" ;
lin eatage_N = mkTerm "eatage_N" ;
lin eater_N = mkTerm "eater_N" ;
lin eating_N = mkTerm "eating_N" ;
lin eating_apple_N = mkTerm "eating_apple_N" ;
lin eating_house_N = mkTerm "eating_house_N" ;
lin eau_de_cologne_N = mkTerm "eau_de_cologne_N" ;
lin eau_de_vie_N = mkTerm "eau_de_vie_N" ;
lin eaves_N = mkTerm "eaves_N" ;
lin eavesdrop_V = mkTerm "eavesdrop_V" ;
lin eavesdropper_N = mkTerm "eavesdropper_N" ;
lin ebay_N = mkTerm "ebay_N" ;
lin ebb_N = mkTerm "ebb_N" ;
lin ebb_V = mkTerm "ebb_V" ;
lin ebb_away_V = mkTerm "ebb_away_V" ;
lin ebbtide_N = mkTerm "ebbtide_N" ;
lin ebbw_vale_PN = mkTerm "ebbw_vale_PN" ;
lin eblis_N = mkTerm "eblis_N" ;
lin ebon_A = mkTerm "ebon_A" ;
lin ebonite_N = mkTerm "ebonite_N" ;
lin ebony_A = mkTerm "ebony_A" ;
lin ebony_N = mkTerm "ebony_N" ;
lin ebracteate_A = mkTerm "ebracteate_A" ;
lin ebullience_N = mkTerm "ebullience_N" ;
lin ebullient_A = mkTerm "ebullient_A" ;
lin eburnation_N = mkTerm "eburnation_N" ;
lin ec_N = mkTerm "ec_N" ;
lin ecarte_N = mkTerm "ecarte_N" ;
lin eccentric_A = mkTerm "eccentric_A" ;
lin eccentric_N = mkTerm "eccentric_N" ;
lin eccentricity_N = mkTerm "eccentricity_N" ;
lin ecchymosis_N = mkTerm "ecchymosis_N" ;
lin eccles_PN = mkTerm "eccles_PN" ;
lin ecclesiastic_N = mkTerm "ecclesiastic_N" ;
lin ecclesiastical_A = mkTerm "ecclesiastical_A" ;
lin ecclesiasticism_N = mkTerm "ecclesiasticism_N" ;
lin ecclesiology_N = mkTerm "ecclesiology_N" ;
lin eccrine_A = mkTerm "eccrine_A" ;
lin ecdemic_A = mkTerm "ecdemic_A" ;
lin echelon_N = mkTerm "echelon_N" ;
lin echidna_N = mkTerm "echidna_N" ;
lin echinocactus_N = mkTerm "echinocactus_N" ;
lin echinococcosis_N = mkTerm "echinococcosis_N" ;
lin echinococcus_N = mkTerm "echinococcus_N" ;
lin echinoderm_N = mkTerm "echinoderm_N" ;
lin echinus_N = mkTerm "echinus_N" ;
lin echo_N = mkTerm "echo_N" ;
lin echo_V = mkTerm "echo_V" ;
lin echo_V2 = mkTerm "echo_V2" ;
lin echo_sounder_N = mkTerm "echo_sounder_N" ;
lin echo_sounding_N = mkTerm "echo_sounding_N" ;
lin echocardiogram_N = mkTerm "echocardiogram_N" ;
lin echocardiograph_N = mkTerm "echocardiograph_N" ;
lin echocardiography_N = mkTerm "echocardiography_N" ;
lin echoencephalogram_N = mkTerm "echoencephalogram_N" ;
lin echoencephalograph_N = mkTerm "echoencephalograph_N" ;
lin echoencephalography_N = mkTerm "echoencephalography_N" ;
lin echoic_A = mkTerm "echoic_A" ;
lin echolalia_N = mkTerm "echolalia_N" ;
lin echoless_A = mkTerm "echoless_A" ;
lin echolocation_N = mkTerm "echolocation_N" ;
lin echovirus_N = mkTerm "echovirus_N" ;
lin eclair_N = mkTerm "eclair_N" ;
lin eclampsia_N = mkTerm "eclampsia_N" ;
lin eclat_N = mkTerm "eclat_N" ;
lin eclectic_A = mkTerm "eclectic_A" ;
lin eclectic_N = mkTerm "eclectic_N" ;
lin eclecticism_N = mkTerm "eclecticism_N" ;
lin eclipse_N = mkTerm "eclipse_N" ;
lin eclipse_V2 = mkTerm "eclipse_V2" ;
lin ecliptic_N = mkTerm "ecliptic_N" ;
lin eclogue_N = mkTerm "eclogue_N" ;
lin ecobabble_N = mkTerm "ecobabble_N" ;
lin ecological_A = mkTerm "ecological_A" ;
lin ecologist_N = mkTerm "ecologist_N" ;
lin ecology_N = mkTerm "ecology_N" ;
lin econometric_A = mkTerm "econometric_A" ;
lin econometrician_N = mkTerm "econometrician_N" ;
lin econometrics_N = mkTerm "econometrics_N" ;
lin economic_A = mkTerm "economic_A" ;
lin economical_A = mkTerm "economical_A" ;
lin economics_N = mkTerm "economics_N" ;
lin economist_N = mkTerm "economist_N" ;
lin economize_V = mkTerm "economize_V" ;
lin economize_V2 = mkTerm "economize_V2" ;
lin economizer_N = mkTerm "economizer_N" ;
lin economy_1_N = mkTerm "economy_1_N" ;
lin economy_2_N = mkTerm "economy_2_N" ;
lin ecosystem_N = mkTerm "ecosystem_N" ;
lin ecoterrorism_N = mkTerm "ecoterrorism_N" ;
lin ecotourism_N = mkTerm "ecotourism_N" ;
lin ecphonesis_N = mkTerm "ecphonesis_N" ;
lin ecstasy_N = mkTerm "ecstasy_N" ;
lin ecstatic_A = mkTerm "ecstatic_A" ;
lin ectasia_N = mkTerm "ectasia_N" ;
lin ectoderm_N = mkTerm "ectoderm_N" ;
lin ectodermal_A = mkTerm "ectodermal_A" ;
lin ectomorph_N = mkTerm "ectomorph_N" ;
lin ectomorphic_A = mkTerm "ectomorphic_A" ;
lin ectoparasite_N = mkTerm "ectoparasite_N" ;
lin ectopia_N = mkTerm "ectopia_N" ;
lin ectopic_A = mkTerm "ectopic_A" ;
lin ectoplasm_N = mkTerm "ectoplasm_N" ;
lin ectoproct_N = mkTerm "ectoproct_N" ;
lin ectrodactyly_N = mkTerm "ectrodactyly_N" ;
lin ecuador_PN = mkTerm "ecuador_PN" ;
lin ecuadorian_A = mkTerm "ecuadorian_A" ;
lin ecuadorian_N = mkTerm "ecuadorian_N" ;
lin ecumenic_A = mkTerm "ecumenic_A" ;
lin ecumenical_A = mkTerm "ecumenical_A" ;
lin ecumenism_N = mkTerm "ecumenism_N" ;
lin eczema_N = mkTerm "eczema_N" ;
lin ed_PN = mkTerm "ed_PN" ;
lin edacious_A = mkTerm "edacious_A" ;
lin edacity_N = mkTerm "edacity_N" ;
lin edaphosaurus_N = mkTerm "edaphosaurus_N" ;
lin eddie_PN = mkTerm "eddie_PN" ;
lin eddy_N = mkTerm "eddy_N" ;
lin eddy_PN = mkTerm "eddy_PN" ;
lin eddy_V = mkTerm "eddy_V" ;
lin edelweiss_N = mkTerm "edelweiss_N" ;
lin edema_N = mkTerm "edema_N" ;
lin edematous_A = mkTerm "edematous_A" ;
lin eden_PN = mkTerm "eden_PN" ;
lin edenbridge_PN = mkTerm "edenbridge_PN" ;
lin edental_A = mkTerm "edental_A" ;
lin edentate_N = mkTerm "edentate_N" ;
lin edentulous_A = mkTerm "edentulous_A" ;
lin edgar_PN = mkTerm "edgar_PN" ;
lin edge_N = mkTerm "edge_N" ;
lin edge_V = mkTerm "edge_V" ;
lin edge_V2 = mkTerm "edge_V2" ;
lin edge_out_V2 = mkTerm "edge_out_V2" ;
lin edge_up_V = mkTerm "edge_up_V" ;
lin edgeless_A = mkTerm "edgeless_A" ;
lin edger_N = mkTerm "edger_N" ;
lin edgeways_Adv = mkTerm "edgeways_Adv" ;
lin edgewise_Adv = mkTerm "edgewise_Adv" ;
lin edginess_N = mkTerm "edginess_N" ;
lin edging_N = mkTerm "edging_N" ;
lin edgy_A = mkTerm "edgy_A" ;
lin edibility_N = mkTerm "edibility_N" ;
lin edible_A = mkTerm "edible_A" ;
lin edible_N = mkTerm "edible_N" ;
lin edict_N = mkTerm "edict_N" ;
lin edification_N = mkTerm "edification_N" ;
lin edifice_N = mkTerm "edifice_N" ;
lin edify_V2 = mkTerm "edify_V2" ;
lin edifying_A = mkTerm "edifying_A" ;
lin edinburgh_PN = mkTerm "edinburgh_PN" ;
lin edit_V2 = mkTerm "edit_V2" ;
lin edith_PN = mkTerm "edith_PN" ;
lin editing_N = mkTerm "editing_N" ;
lin edition_N = mkTerm "edition_N" ;
lin editor_N = mkTerm "editor_N" ;
lin editorial_A = mkTerm "editorial_A" ;
lin editorial_N = mkTerm "editorial_N" ;
lin editorship_N = mkTerm "editorship_N" ;
lin edmontosaurus_N = mkTerm "edmontosaurus_N" ;
lin edmund_PN = mkTerm "edmund_PN" ;
lin edp_N = mkTerm "edp_N" ;
lin educate_V2 = mkTerm "educate_V2" ;
lin education_N = mkTerm "education_N" ;
lin educational_A = mkTerm "educational_A" ;
lin educationalist_N = mkTerm "educationalist_N" ;
lin educationist_N = mkTerm "educationist_N" ;
lin educative_A = mkTerm "educative_A" ;
lin educator_N = mkTerm "educator_N" ;
lin educe_V2 = mkTerm "educe_V2" ;
lin edutainment_N = mkTerm "edutainment_N" ;
lin edward_PN = mkTerm "edward_PN" ;
lin edwardian_A = mkTerm "edwardian_A" ;
lin edwardian_N = mkTerm "edwardian_N" ;
lin eec_N = mkTerm "eec_N" ;
lin eeg_N = mkTerm "eeg_N" ;
lin eel_N = mkTerm "eel_N" ;
lin eelblenny_N = mkTerm "eelblenny_N" ;
lin eelgrass_N = mkTerm "eelgrass_N" ;
lin eellike_A = mkTerm "eellike_A" ;
lin eelpout_N = mkTerm "eelpout_N" ;
lin eelworm_N = mkTerm "eelworm_N" ;
lin eerie_A = mkTerm "eerie_A" ;
lin eeriness_N = mkTerm "eeriness_N" ;
lin eery_A = mkTerm "eery_A" ;
lin eff_V = mkTerm "eff_V" ;
lin efface_V2 = mkTerm "efface_V2" ;
lin effaceable_A = mkTerm "effaceable_A" ;
lin effacement_N = mkTerm "effacement_N" ;
lin effect_N = mkTerm "effect_N" ;
lin effect_V2 = mkTerm "effect_V2" ;
lin effecter_N = mkTerm "effecter_N" ;
lin effective_A = mkTerm "effective_A" ;
lin effectiveness_N = mkTerm "effectiveness_N" ;
lin effector_N = mkTerm "effector_N" ;
lin effects_N = mkTerm "effects_N" ;
lin effectual_A = mkTerm "effectual_A" ;
lin effectuality_N = mkTerm "effectuality_N" ;
lin effectualness_N = mkTerm "effectualness_N" ;
lin effeminacy_N = mkTerm "effeminacy_N" ;
lin effeminate_A = mkTerm "effeminate_A" ;
lin effendi_N = mkTerm "effendi_N" ;
lin efferent_A = mkTerm "efferent_A" ;
lin effervesce_V = mkTerm "effervesce_V" ;
lin effervescence_N = mkTerm "effervescence_N" ;
lin effervescent_A = mkTerm "effervescent_A" ;
lin effete_A = mkTerm "effete_A" ;
lin effeteness_N = mkTerm "effeteness_N" ;
lin efficacious_A = mkTerm "efficacious_A" ;
lin efficacy_N = mkTerm "efficacy_N" ;
lin efficiency_N = mkTerm "efficiency_N" ;
lin efficient_A = mkTerm "efficient_A" ;
lin effigy_N = mkTerm "effigy_N" ;
lin effleurage_N = mkTerm "effleurage_N" ;
lin efflorescence_N = mkTerm "efflorescence_N" ;
lin efflorescent_A = mkTerm "efflorescent_A" ;
lin effluent_A = mkTerm "effluent_A" ;
lin effluent_N = mkTerm "effluent_N" ;
lin effluvium_N = mkTerm "effluvium_N" ;
lin efflux_N = mkTerm "efflux_N" ;
lin effort_N = mkTerm "effort_N" ;
lin effortful_A = mkTerm "effortful_A" ;
lin effortfulness_N = mkTerm "effortfulness_N" ;
lin effortless_A = mkTerm "effortless_A" ;
lin effortlessness_N = mkTerm "effortlessness_N" ;
lin effrontery_N = mkTerm "effrontery_N" ;
lin effulgence_N = mkTerm "effulgence_N" ;
lin effulgent_A = mkTerm "effulgent_A" ;
lin effusion_N = mkTerm "effusion_N" ;
lin effusive_A = mkTerm "effusive_A" ;
lin effusiveness_N = mkTerm "effusiveness_N" ;
lin eft_N = mkTerm "eft_N" ;
lin efta_N = mkTerm "efta_N" ;
lin eg_PN = mkTerm "eg_PN" ;
lin egad_Interj = mkTerm "egad_Interj" ;
lin egalitarian_A = mkTerm "egalitarian_A" ;
lin egalitarian_N = mkTerm "egalitarian_N" ;
lin egalitarianism_N = mkTerm "egalitarianism_N" ;
lin egality_N = mkTerm "egality_N" ;
lin egg_N = mkTerm "egg_N" ;
lin egg_V2 = mkTerm "egg_V2" ;
lin egg_beater_N = mkTerm "egg_beater_N" ;
lin egg_cup_N = mkTerm "egg_cup_N" ;
lin egg_on_V2 = mkTerm "egg_on_V2" ;
lin egg_whisk_N = mkTerm "egg_whisk_N" ;
lin eggar_N = mkTerm "eggar_N" ;
lin egghead_N = mkTerm "egghead_N" ;
lin eggnog_N = mkTerm "eggnog_N" ;
lin eggplant_N = mkTerm "eggplant_N" ;
lin eggshake_N = mkTerm "eggshake_N" ;
lin eggshell_N = mkTerm "eggshell_N" ;
lin eglantine_N = mkTerm "eglantine_N" ;
lin ego_N = mkTerm "ego_N" ;
lin egocentric_A = mkTerm "egocentric_A" ;
lin egocentric_N = mkTerm "egocentric_N" ;
lin egoism_N = mkTerm "egoism_N" ;
lin egoist_N = mkTerm "egoist_N" ;
lin egoistic_A = mkTerm "egoistic_A" ;
lin egoistical_A = mkTerm "egoistical_A" ;
lin egomania_N = mkTerm "egomania_N" ;
lin egomaniac_N = mkTerm "egomaniac_N" ;
lin egotism_N = mkTerm "egotism_N" ;
lin egotist_N = mkTerm "egotist_N" ;
lin egotistic_A = mkTerm "egotistic_A" ;
lin egotrip_N = mkTerm "egotrip_N" ;
lin egotrip_V = mkTerm "egotrip_V" ;
lin egregious_A = mkTerm "egregious_A" ;
lin egremont_PN = mkTerm "egremont_PN" ;
lin egress_N = mkTerm "egress_N" ;
lin egret_N = mkTerm "egret_N" ;
lin egypt_PN = mkTerm "egypt_PN" ;
lin egyptian_A = mkTerm "egyptian_A" ;
lin egyptian_N = mkTerm "egyptian_N" ;
lin eiche_PN = mkTerm "eiche_PN" ;
lin eider_N = mkTerm "eider_N" ;
lin eiderdown_N = mkTerm "eiderdown_N" ;
lin eidetic_A = mkTerm "eidetic_A" ;
lin eidos_N = mkTerm "eidos_N" ;
lin eigenvalue_N = mkTerm "eigenvalue_N" ;
lin eightpence_N = mkTerm "eightpence_N" ;
lin eightpenny_A = mkTerm "eightpenny_A" ;
lin eightsome_N = mkTerm "eightsome_N" ;
lin eileen_PN = mkTerm "eileen_PN" ;
lin eindhoven_PN = mkTerm "eindhoven_PN" ;
lin einsteinium_N = mkTerm "einsteinium_N" ;
lin eisegesis_N = mkTerm "eisegesis_N" ;
lin eisteddfod_N = mkTerm "eisteddfod_N" ;
lin either_Adv = mkTerm "either_Adv" ;
lin either_Det = mkTerm "either_Det" ;
lin ejaculate_V2 = mkTerm "ejaculate_V2" ;
lin ejaculation_N = mkTerm "ejaculation_N" ;
lin ejaculator_N = mkTerm "ejaculator_N" ;
lin eject_V = mkTerm "eject_V" ;
lin eject_V2 = mkTerm "eject_V2" ;
lin ejection_N = mkTerm "ejection_N" ;
lin ejector_N = mkTerm "ejector_N" ;
lin ejector_seat_N = mkTerm "ejector_seat_N" ;
lin eke_V2 = mkTerm "eke_V2" ;
lin eke_out_V2 = mkTerm "eke_out_V2" ;
lin ekenäs_PN = mkTerm "ekenäs_PN" ;
lin el_dorado_N = mkTerm "el_dorado_N" ;
lin el_salvador_PN = mkTerm "el_salvador_PN" ;
lin elaborate_A = mkTerm "elaborate_A" ;
lin elaborate_V = mkTerm "elaborate_V" ;
lin elaborate_V2 = mkTerm "elaborate_V2" ;
lin elaborateness_N = mkTerm "elaborateness_N" ;
lin elaboration_N = mkTerm "elaboration_N" ;
lin elaine_PN = mkTerm "elaine_PN" ;
lin elan_N = mkTerm "elan_N" ;
lin eland_N = mkTerm "eland_N" ;
lin elapid_N = mkTerm "elapid_N" ;
lin elapse_V = mkTerm "elapse_V" ;
lin elapsed_A = mkTerm "elapsed_A" ;
lin elasmobranch_N = mkTerm "elasmobranch_N" ;
lin elastance_N = mkTerm "elastance_N" ;
lin elastase_N = mkTerm "elastase_N" ;
lin elastic_A = mkTerm "elastic_A" ;
lin elastic_N = mkTerm "elastic_N" ;
lin elasticity_N = mkTerm "elasticity_N" ;
lin elasticized_A = mkTerm "elasticized_A" ;
lin elastin_N = mkTerm "elastin_N" ;
lin elastomer_N = mkTerm "elastomer_N" ;
lin elastoplast_N = mkTerm "elastoplast_N" ;
lin elastosis_N = mkTerm "elastosis_N" ;
lin elate_V2 = mkTerm "elate_V2" ;
lin elating_A = mkTerm "elating_A" ;
lin elation_N = mkTerm "elation_N" ;
lin elbow_N = mkTerm "elbow_N" ;
lin elbow_V2 = mkTerm "elbow_V2" ;
lin elbowing_N = mkTerm "elbowing_N" ;
lin elder_1_N = mkTerm "elder_1_N" ;
lin elder_2_N = mkTerm "elder_2_N" ;
lin elder_A = mkTerm "elder_A" ;
lin elderberry_N = mkTerm "elderberry_N" ;
lin elderly_A = mkTerm "elderly_A" ;
lin eldership_N = mkTerm "eldership_N" ;
lin elderslie_PN = mkTerm "elderslie_PN" ;
lin eldest_A = mkTerm "eldest_A" ;
lin eldritch_A = mkTerm "eldritch_A" ;
lin eleanor_PN = mkTerm "eleanor_PN" ;
lin elecampane_N = mkTerm "elecampane_N" ;
lin elect_A = mkTerm "elect_A" ;
lin elect_V = mkTerm "elect_V" ;
lin elect_V2 = mkTerm "elect_V2" ;
lin elect_V2V = mkTerm "elect_V2V" ;
lin elect_V3 = mkTerm "elect_V3" ;
lin elected_A = mkTerm "elected_A" ;
lin election_N = mkTerm "election_N" ;
lin electioneering_N = mkTerm "electioneering_N" ;
lin elective_A = mkTerm "elective_A" ;
lin elector_N = mkTerm "elector_N" ;
lin electoral_A = mkTerm "electoral_A" ;
lin electorate_N = mkTerm "electorate_N" ;
lin electric_A = mkTerm "electric_A" ;
lin electric_N = mkTerm "electric_N" ;
lin electrical_A = mkTerm "electrical_A" ;
lin electrician_N = mkTerm "electrician_N" ;
lin electricity_N = mkTerm "electricity_N" ;
lin electrification_N = mkTerm "electrification_N" ;
lin electrify_V2 = mkTerm "electrify_V2" ;
lin electrifying_A = mkTerm "electrifying_A" ;
lin electrocardiogram_N = mkTerm "electrocardiogram_N" ;
lin electrocardiograph_N = mkTerm "electrocardiograph_N" ;
lin electrocardiographic_A = mkTerm "electrocardiographic_A" ;
lin electrocautery_N = mkTerm "electrocautery_N" ;
lin electrochemical_A = mkTerm "electrochemical_A" ;
lin electrochemistry_N = mkTerm "electrochemistry_N" ;
lin electrocute_V2 = mkTerm "electrocute_V2" ;
lin electrocution_N = mkTerm "electrocution_N" ;
lin electrocutioner_N = mkTerm "electrocutioner_N" ;
lin electrode_N = mkTerm "electrode_N" ;
lin electrodeposition_N = mkTerm "electrodeposition_N" ;
lin electrodynamometer_N = mkTerm "electrodynamometer_N" ;
lin electroencephalogram_N = mkTerm "electroencephalogram_N" ;
lin electroencephalograph_N = mkTerm "electroencephalograph_N" ;
lin electroencephalographic_A = mkTerm "electroencephalographic_A" ;
lin electrograph_N = mkTerm "electrograph_N" ;
lin electrologist_N = mkTerm "electrologist_N" ;
lin electrolysis_N = mkTerm "electrolysis_N" ;
lin electrolyte_N = mkTerm "electrolyte_N" ;
lin electrolytic_A = mkTerm "electrolytic_A" ;
lin electrolytic_N = mkTerm "electrolytic_N" ;
lin electromagnet_N = mkTerm "electromagnet_N" ;
lin electromagnetic_A = mkTerm "electromagnetic_A" ;
lin electromagnetism_N = mkTerm "electromagnetism_N" ;
lin electromechanical_A = mkTerm "electromechanical_A" ;
lin electrometer_N = mkTerm "electrometer_N" ;
lin electromotive_A = mkTerm "electromotive_A" ;
lin electromyogram_N = mkTerm "electromyogram_N" ;
lin electromyograph_N = mkTerm "electromyograph_N" ;
lin electromyography_N = mkTerm "electromyography_N" ;
lin electron_N = mkTerm "electron_N" ;
lin electronegativity_N = mkTerm "electronegativity_N" ;
lin electronic_A = mkTerm "electronic_A" ;
lin electronics_N = mkTerm "electronics_N" ;
lin electrophoresis_N = mkTerm "electrophoresis_N" ;
lin electrophoretic_A = mkTerm "electrophoretic_A" ;
lin electrophorus_N = mkTerm "electrophorus_N" ;
lin electroplate_N = mkTerm "electroplate_N" ;
lin electroplate_V2 = mkTerm "electroplate_V2" ;
lin electroplater_N = mkTerm "electroplater_N" ;
lin electroretinogram_N = mkTerm "electroretinogram_N" ;
lin electroscope_N = mkTerm "electroscope_N" ;
lin electrosleep_N = mkTerm "electrosleep_N" ;
lin electrostatic_A = mkTerm "electrostatic_A" ;
lin electrostatics_N = mkTerm "electrostatics_N" ;
lin electrosurgery_N = mkTerm "electrosurgery_N" ;
lin electrotherapist_N = mkTerm "electrotherapist_N" ;
lin electrotherapy_N = mkTerm "electrotherapy_N" ;
lin electrum_N = mkTerm "electrum_N" ;
lin eleemosynary_A = mkTerm "eleemosynary_A" ;
lin elegance_N = mkTerm "elegance_N" ;
lin elegant_A = mkTerm "elegant_A" ;
lin elegiac_A = mkTerm "elegiac_A" ;
lin elegist_N = mkTerm "elegist_N" ;
lin elegy_N = mkTerm "elegy_N" ;
lin element_N = mkTerm "element_N" ;
lin elemental_A = mkTerm "elemental_A" ;
lin elementary_A = mkTerm "elementary_A" ;
lin elemi_N = mkTerm "elemi_N" ;
lin elephant_N = mkTerm "elephant_N" ;
lin elephantiasis_N = mkTerm "elephantiasis_N" ;
lin elephantine_A = mkTerm "elephantine_A" ;
lin elevate_V2 = mkTerm "elevate_V2" ;
lin elevation_N = mkTerm "elevation_N" ;
lin elevator_N = mkTerm "elevator_N" ;
lin elf_N = mkTerm "elf_N" ;
lin elfin_A = mkTerm "elfin_A" ;
lin elfish_A = mkTerm "elfish_A" ;
lin elgin_PN = mkTerm "elgin_PN" ;
lin elicit_V2 = mkTerm "elicit_V2" ;
lin elicitation_N = mkTerm "elicitation_N" ;
lin elide_V2 = mkTerm "elide_V2" ;
lin eligibility_N = mkTerm "eligibility_N" ;
lin eligible_A = mkTerm "eligible_A" ;
lin eliminate_V2 = mkTerm "eliminate_V2" ;
lin elimination_N = mkTerm "elimination_N" ;
lin eliminator_N = mkTerm "eliminator_N" ;
lin elimäki_PN = mkTerm "elimäki_PN" ;
lin elision_N = mkTerm "elision_N" ;
lin elite_A = mkTerm "elite_A" ;
lin elite_N = mkTerm "elite_N" ;
lin elitism_N = mkTerm "elitism_N" ;
lin elitistFem_N = mkTerm "elitistFem_N" ;
lin elitistMasc_N = mkTerm "elitistMasc_N" ;
lin elixir_N = mkTerm "elixir_N" ;
lin eliza_PN = mkTerm "eliza_PN" ;
lin elizabeth_PN = mkTerm "elizabeth_PN" ;
lin elizabethan_A = mkTerm "elizabethan_A" ;
lin elizabethan_N = mkTerm "elizabethan_N" ;
lin elk_N = mkTerm "elk_N" ;
lin ell_N = mkTerm "ell_N" ;
lin elland_PN = mkTerm "elland_PN" ;
lin ellen_PN = mkTerm "ellen_PN" ;
lin ellesmere_PN = mkTerm "ellesmere_PN" ;
lin ellesmere_port_PN = mkTerm "ellesmere_port_PN" ;
lin ellie_PN = mkTerm "ellie_PN" ;
lin ellipse_N = mkTerm "ellipse_N" ;
lin ellipsis_N = mkTerm "ellipsis_N" ;
lin ellipsoid_A = mkTerm "ellipsoid_A" ;
lin ellipsoid_N = mkTerm "ellipsoid_N" ;
lin elliptic_A = mkTerm "elliptic_A" ;
lin elliptical_A = mkTerm "elliptical_A" ;
lin elloughton_PN = mkTerm "elloughton_PN" ;
lin elm_N = mkTerm "elm_N" ;
lin elocution_N = mkTerm "elocution_N" ;
lin elocutionary_A = mkTerm "elocutionary_A" ;
lin elocutionistFem_N = mkTerm "elocutionistFem_N" ;
lin elocutionistMasc_N = mkTerm "elocutionistMasc_N" ;
lin elongate_A = mkTerm "elongate_A" ;
lin elongate_V = mkTerm "elongate_V" ;
lin elongate_V2 = mkTerm "elongate_V2" ;
lin elongation_N = mkTerm "elongation_N" ;
lin elope_V = mkTerm "elope_V" ;
lin elopement_N = mkTerm "elopement_N" ;
lin eloquence_N = mkTerm "eloquence_N" ;
lin eloquent_A = mkTerm "eloquent_A" ;
lin else_Adv = mkTerm "else_Adv" ;
lin elsewhere_Adv = mkTerm "elsewhere_Adv" ;
lin elsholtzia_N = mkTerm "elsholtzia_N" ;
lin elsie_PN = mkTerm "elsie_PN" ;
lin elstree_PN = mkTerm "elstree_PN" ;
lin eluate_N = mkTerm "eluate_N" ;
lin elucidate_V2 = mkTerm "elucidate_V2" ;
lin elucidation_N = mkTerm "elucidation_N" ;
lin elude_V2 = mkTerm "elude_V2" ;
lin elusive_A = mkTerm "elusive_A" ;
lin elusiveness_N = mkTerm "elusiveness_N" ;
lin elution_N = mkTerm "elution_N" ;
lin elver_N = mkTerm "elver_N" ;
lin elves_N = mkTerm "elves_N" ;
lin elvish_A = mkTerm "elvish_A" ;
lin ely_PN = mkTerm "ely_PN" ;
lin elysian_A = mkTerm "elysian_A" ;
lin elysium_PN = mkTerm "elysium_PN" ;
lin em_N = mkTerm "em_N" ;
lin emaciate_V2 = mkTerm "emaciate_V2" ;
lin emaciation_N = mkTerm "emaciation_N" ;
lin email_N = mkTerm "email_N" ;
lin emanate_V = mkTerm "emanate_V" ;
lin emanation_N = mkTerm "emanation_N" ;
lin emancipate_V2 = mkTerm "emancipate_V2" ;
lin emancipation_N = mkTerm "emancipation_N" ;
lin emancipative_A = mkTerm "emancipative_A" ;
lin emancipator_N = mkTerm "emancipator_N" ;
lin emarginate_A = mkTerm "emarginate_A" ;
lin emasculate_V2 = mkTerm "emasculate_V2" ;
lin emasculation_N = mkTerm "emasculation_N" ;
lin embalm_V2 = mkTerm "embalm_V2" ;
lin embalmer_N = mkTerm "embalmer_N" ;
lin embalmment_N = mkTerm "embalmment_N" ;
lin embankment_N = mkTerm "embankment_N" ;
lin embargo_N = mkTerm "embargo_N" ;
lin embargo_V2 = mkTerm "embargo_V2" ;
lin embark_V = mkTerm "embark_V" ;
lin embark_V2 = mkTerm "embark_V2" ;
lin embark_on_V2 = mkTerm "embark_on_V2" ;
lin embark_upon_V2 = mkTerm "embark_upon_V2" ;
lin embarkation_N = mkTerm "embarkation_N" ;
lin embarrass_V2 = mkTerm "embarrass_V2" ;
lin embarrassed_A = mkTerm "embarrassed_A" ;
lin embarrassing_A = mkTerm "embarrassing_A" ;
lin embarrassment_N = mkTerm "embarrassment_N" ;
lin embassy_N = mkTerm "embassy_N" ;
lin embattled_A = mkTerm "embattled_A" ;
lin embed_V2 = mkTerm "embed_V2" ;
lin embellish_V2 = mkTerm "embellish_V2" ;
lin embellishment_N = mkTerm "embellishment_N" ;
lin ember_N = mkTerm "ember_N" ;
lin embezzle_V2 = mkTerm "embezzle_V2" ;
lin embezzlement_N = mkTerm "embezzlement_N" ;
lin embezzler_N = mkTerm "embezzler_N" ;
lin embitter_V2 = mkTerm "embitter_V2" ;
lin embitterment_N = mkTerm "embitterment_N" ;
lin emblazon_V2 = mkTerm "emblazon_V2" ;
lin emblem_N = mkTerm "emblem_N" ;
lin emblematic_A = mkTerm "emblematic_A" ;
lin embodiment_N = mkTerm "embodiment_N" ;
lin embody_V2 = mkTerm "embody_V2" ;
lin embolden_V2 = mkTerm "embolden_V2" ;
lin embolectomy_N = mkTerm "embolectomy_N" ;
lin embolic_A = mkTerm "embolic_A" ;
lin embolism_N = mkTerm "embolism_N" ;
lin embolus_N = mkTerm "embolus_N" ;
lin embonpoint_A = mkTerm "embonpoint_A" ;
lin embonpoint_N = mkTerm "embonpoint_N" ;
lin emboss_V2 = mkTerm "emboss_V2" ;
lin embrace_N = mkTerm "embrace_N" ;
lin embrace_V = mkTerm "embrace_V" ;
lin embrace_V2 = mkTerm "embrace_V2" ;
lin embrasure_N = mkTerm "embrasure_N" ;
lin embrocation_N = mkTerm "embrocation_N" ;
lin embroider_V = mkTerm "embroider_V" ;
lin embroider_V2 = mkTerm "embroider_V2" ;
lin embroiderer_N = mkTerm "embroiderer_N" ;
lin embroideress_N = mkTerm "embroideress_N" ;
lin embroidery_N = mkTerm "embroidery_N" ;
lin embroil_V = mkTerm "embroil_V" ;
lin embroil_V2 = mkTerm "embroil_V2" ;
lin embryo_N = mkTerm "embryo_N" ;
lin embryologist_N = mkTerm "embryologist_N" ;
lin embryology_N = mkTerm "embryology_N" ;
lin embryonic_A = mkTerm "embryonic_A" ;
lin emeer_N = mkTerm "emeer_N" ;
lin emend_V2 = mkTerm "emend_V2" ;
lin emendation_N = mkTerm "emendation_N" ;
lin emerald_N = mkTerm "emerald_N" ;
lin emerge_V = mkTerm "emerge_V" ;
lin emergence_N = mkTerm "emergence_N" ;
lin emergency_N = mkTerm "emergency_N" ;
lin emergent_A = mkTerm "emergent_A" ;
lin emeritus_A = mkTerm "emeritus_A" ;
lin emeritus_N = mkTerm "emeritus_N" ;
lin emery_N = mkTerm "emery_N" ;
lin emetic_N = mkTerm "emetic_N" ;
lin emigrant_N = mkTerm "emigrant_N" ;
lin emigrate_V = mkTerm "emigrate_V" ;
lin emigrate_V2V = mkTerm "emigrate_V2V" ;
lin emigration_N = mkTerm "emigration_N" ;
lin emigre_N = mkTerm "emigre_N" ;
lin emily_PN = mkTerm "emily_PN" ;
lin eminence_N = mkTerm "eminence_N" ;
lin eminent_A = mkTerm "eminent_A" ;
lin emir_N = mkTerm "emir_N" ;
lin emirate_N = mkTerm "emirate_N" ;
lin emissary_N = mkTerm "emissary_N" ;
lin emission_N = mkTerm "emission_N" ;
lin emit_V2 = mkTerm "emit_V2" ;
lin emitter_N = mkTerm "emitter_N" ;
lin emma_PN = mkTerm "emma_PN" ;
lin emmenagogue_N = mkTerm "emmenagogue_N" ;
lin emmer_N = mkTerm "emmer_N" ;
lin emmetropia_N = mkTerm "emmetropia_N" ;
lin emmetropic_A = mkTerm "emmetropic_A" ;
lin emolument_N = mkTerm "emolument_N" ;
lin emoticon_N = mkTerm "emoticon_N" ;
lin emotion_N = mkTerm "emotion_N" ;
lin emotional_A = mkTerm "emotional_A" ;
lin emotionality_N = mkTerm "emotionality_N" ;
lin emotionless_A = mkTerm "emotionless_A" ;
lin emotionlessness_N = mkTerm "emotionlessness_N" ;
lin emotive_A = mkTerm "emotive_A" ;
lin empale_V2 = mkTerm "empale_V2" ;
lin empanel_V2 = mkTerm "empanel_V2" ;
lin empathic_A = mkTerm "empathic_A" ;
lin empathize_V = mkTerm "empathize_V" ;
lin empathy_N = mkTerm "empathy_N" ;
lin emperor_N = mkTerm "emperor_N" ;
lin emphasis_N = mkTerm "emphasis_N" ;
lin emphasize_V2 = mkTerm "emphasize_V2" ;
lin emphasize_VS = mkTerm "emphasize_VS" ;
lin emphasizing_N = mkTerm "emphasizing_N" ;
lin emphatic_A = mkTerm "emphatic_A" ;
lin emphysema_N = mkTerm "emphysema_N" ;
lin emphysematous_A = mkTerm "emphysematous_A" ;
lin empire_N = mkTerm "empire_N" ;
lin empiric_A = mkTerm "empiric_A" ;
lin empirical_A = mkTerm "empirical_A" ;
lin empiricism_N = mkTerm "empiricism_N" ;
lin empiricist_N = mkTerm "empiricist_N" ;
lin emplacement_N = mkTerm "emplacement_N" ;
lin emplane_V = mkTerm "emplane_V" ;
lin emplane_V2 = mkTerm "emplane_V2" ;
lin employ_N = mkTerm "employ_N" ;
lin employ_V2 = mkTerm "employ_V2" ;
lin employable_A = mkTerm "employable_A" ;
lin employable_N = mkTerm "employable_N" ;
lin employee_N = mkTerm "employee_N" ;
lin employer_N = mkTerm "employer_N" ;
lin employment_N = mkTerm "employment_N" ;
lin emporium_N = mkTerm "emporium_N" ;
lin empower_V2 = mkTerm "empower_V2" ;
lin empower_V2V = mkTerm "empower_V2V" ;
lin empress_N = mkTerm "empress_N" ;
lin emptiness_N = mkTerm "emptiness_N" ;
lin empty_A = mkTerm "empty_A" ;
lin empty_N = mkTerm "empty_N" ;
lin empty_V = mkTerm "empty_V" ;
lin empty_V2 = mkTerm "empty_V2" ;
lin empty_handed_A = mkTerm "empty_handed_A" ;
lin empty_headed_A = mkTerm "empty_headed_A" ;
lin empty_out_V2 = mkTerm "empty_out_V2" ;
lin emptying_N = mkTerm "emptying_N" ;
lin empurpled_A = mkTerm "empurpled_A" ;
lin empyema_N = mkTerm "empyema_N" ;
lin empyreal_A = mkTerm "empyreal_A" ;
lin empyrean_A = mkTerm "empyrean_A" ;
lin empyrean_N = mkTerm "empyrean_N" ;
lin emsworth_PN = mkTerm "emsworth_PN" ;
lin emu_N = mkTerm "emu_N" ;
lin emulate_V2 = mkTerm "emulate_V2" ;
lin emulation_N = mkTerm "emulation_N" ;
lin emulator_N = mkTerm "emulator_N" ;
lin emulous_A = mkTerm "emulous_A" ;
lin emulsifier_N = mkTerm "emulsifier_N" ;
lin emulsify_V2 = mkTerm "emulsify_V2" ;
lin emulsion_N = mkTerm "emulsion_N" ;
lin en_N = mkTerm "en_N" ;
lin en_clair_Adv = mkTerm "en_clair_Adv" ;
lin en_famille_Adv = mkTerm "en_famille_Adv" ;
lin en_masse_Adv = mkTerm "en_masse_Adv" ;
lin en_route_Adv = mkTerm "en_route_Adv" ;
lin enable_V2 = mkTerm "enable_V2" ;
lin enable_V2V = mkTerm "enable_V2V" ;
lin enable_VS = mkTerm "enable_VS" ;
lin enabling_A = mkTerm "enabling_A" ;
lin enact_V2 = mkTerm "enact_V2" ;
lin enact_V2V = mkTerm "enact_V2V" ;
lin enactment_N = mkTerm "enactment_N" ;
lin enalapril_N = mkTerm "enalapril_N" ;
lin enallage_N = mkTerm "enallage_N" ;
lin enamel_N = mkTerm "enamel_N" ;
lin enamel_V2 = mkTerm "enamel_V2" ;
lin enamelware_N = mkTerm "enamelware_N" ;
lin enamine_N = mkTerm "enamine_N" ;
lin enamored_A = mkTerm "enamored_A" ;
lin enamour_V2 = mkTerm "enamour_V2" ;
lin enanthem_N = mkTerm "enanthem_N" ;
lin enantiomorph_N = mkTerm "enantiomorph_N" ;
lin enantiomorphism_N = mkTerm "enantiomorphism_N" ;
lin enate_A = mkTerm "enate_A" ;
lin enate_N = mkTerm "enate_N" ;
lin enc_PN = mkTerm "enc_PN" ;
lin encainide_N = mkTerm "encainide_N" ;
lin encamp_V = mkTerm "encamp_V" ;
lin encamp_V2 = mkTerm "encamp_V2" ;
lin encampment_N = mkTerm "encampment_N" ;
lin encapsulation_N = mkTerm "encapsulation_N" ;
lin encase_V2 = mkTerm "encase_V2" ;
lin encasement_N = mkTerm "encasement_N" ;
lin encaustic_A = mkTerm "encaustic_A" ;
lin encaustic_N = mkTerm "encaustic_N" ;
lin encephalartos_N = mkTerm "encephalartos_N" ;
lin encephalitis_N = mkTerm "encephalitis_N" ;
lin encephalocele_N = mkTerm "encephalocele_N" ;
lin encephalogram_N = mkTerm "encephalogram_N" ;
lin encephalography_N = mkTerm "encephalography_N" ;
lin encephalomyelitis_N = mkTerm "encephalomyelitis_N" ;
lin enchain_V2 = mkTerm "enchain_V2" ;
lin enchant_V2 = mkTerm "enchant_V2" ;
lin enchanter_N = mkTerm "enchanter_N" ;
lin enchantingly_Adv = mkTerm "enchantingly_Adv" ;
lin enchantment_N = mkTerm "enchantment_N" ;
lin enchantress_N = mkTerm "enchantress_N" ;
lin enchilada_N = mkTerm "enchilada_N" ;
lin enchondroma_N = mkTerm "enchondroma_N" ;
lin encircle_V2 = mkTerm "encircle_V2" ;
lin encirclement_N = mkTerm "encirclement_N" ;
lin enclave_N = mkTerm "enclave_N" ;
lin enclose_V2 = mkTerm "enclose_V2" ;
lin enclosure_1_N = mkTerm "enclosure_1_N" ;
lin enclosure_2_N = mkTerm "enclosure_2_N" ;
lin enclosure_3_N = mkTerm "enclosure_3_N" ;
lin encode_V2 = mkTerm "encode_V2" ;
lin encoding_N = mkTerm "encoding_N" ;
lin encolure_N = mkTerm "encolure_N" ;
lin encomiastic_A = mkTerm "encomiastic_A" ;
lin encomium_N = mkTerm "encomium_N" ;
lin encompass_V2 = mkTerm "encompass_V2" ;
lin encompassment_N = mkTerm "encompassment_N" ;
lin encopresis_N = mkTerm "encopresis_N" ;
lin encore_N = mkTerm "encore_N" ;
lin encore_V2 = mkTerm "encore_V2" ;
lin encounter_N = mkTerm "encounter_N" ;
lin encounter_V2 = mkTerm "encounter_V2" ;
lin encourage_V2 = mkTerm "encourage_V2" ;
lin encourage_V2V = mkTerm "encourage_V2V" ;
lin encouragement_N = mkTerm "encouragement_N" ;
lin encouraging_A = mkTerm "encouraging_A" ;
lin encroach_V = mkTerm "encroach_V" ;
lin encroachment_N = mkTerm "encroachment_N" ;
lin encrust_V = mkTerm "encrust_V" ;
lin encrust_V2 = mkTerm "encrust_V2" ;
lin encrypt_V2 = mkTerm "encrypt_V2" ;
lin encryption_N = mkTerm "encryption_N" ;
lin encumber_V2 = mkTerm "encumber_V2" ;
lin encumbrance_N = mkTerm "encumbrance_N" ;
lin encyclical_A = mkTerm "encyclical_A" ;
lin encyclical_N = mkTerm "encyclical_N" ;
lin encyclopaedia_N = mkTerm "encyclopaedia_N" ;
lin encyclopaedic_A = mkTerm "encyclopaedic_A" ;
lin encyclopedia_N = mkTerm "encyclopedia_N" ;
lin encyclopedic_A = mkTerm "encyclopedic_A" ;
lin encyclopedist_N = mkTerm "encyclopedist_N" ;
lin encysted_A = mkTerm "encysted_A" ;
lin end_1_N = mkTerm "end_1_N" ;
lin end_2_N = mkTerm "end_2_N" ;
lin end_V = mkTerm "end_V" ;
lin end_V2 = mkTerm "end_V2" ;
lin end_all_N = mkTerm "end_all_N" ;
lin end_in_V2 = mkTerm "end_in_V2" ;
lin end_tail_V2 = mkTerm "end_tail_V2" ;
lin end_up_V2 = mkTerm "end_up_V2" ;
lin end_up_with_V2 = mkTerm "end_up_with_V2" ;
lin endameba_N = mkTerm "endameba_N" ;
lin endanger_V2 = mkTerm "endanger_V2" ;
lin endarterectomy_N = mkTerm "endarterectomy_N" ;
lin endarteritis_N = mkTerm "endarteritis_N" ;
lin endear_V2 = mkTerm "endear_V2" ;
lin endearingly_Adv = mkTerm "endearingly_Adv" ;
lin endearment_N = mkTerm "endearment_N" ;
lin endeavour_N = mkTerm "endeavour_N" ;
lin endeavour_V = mkTerm "endeavour_V" ;
lin endemic_A = mkTerm "endemic_A" ;
lin endemic_N = mkTerm "endemic_N" ;
lin endergonic_A = mkTerm "endergonic_A" ;
lin endermic_A = mkTerm "endermic_A" ;
lin endgame_N = mkTerm "endgame_N" ;
lin ending_N = mkTerm "ending_N" ;
lin endive_N = mkTerm "endive_N" ;
lin endless_A = mkTerm "endless_A" ;
lin endlessness_N = mkTerm "endlessness_N" ;
lin endocarditis_N = mkTerm "endocarditis_N" ;
lin endocardium_N = mkTerm "endocardium_N" ;
lin endocentric_A = mkTerm "endocentric_A" ;
lin endocervicitis_N = mkTerm "endocervicitis_N" ;
lin endocranium_N = mkTerm "endocranium_N" ;
lin endocrine_A = mkTerm "endocrine_A" ;
lin endocrinologist_N = mkTerm "endocrinologist_N" ;
lin endocrinology_N = mkTerm "endocrinology_N" ;
lin endoderm_N = mkTerm "endoderm_N" ;
lin endodontic_A = mkTerm "endodontic_A" ;
lin endodontics_N = mkTerm "endodontics_N" ;
lin endodontist_N = mkTerm "endodontist_N" ;
lin endoergic_A = mkTerm "endoergic_A" ;
lin endogamous_A = mkTerm "endogamous_A" ;
lin endogamy_N = mkTerm "endogamy_N" ;
lin endogenic_A = mkTerm "endogenic_A" ;
lin endogenous_A = mkTerm "endogenous_A" ;
lin endogeny_N = mkTerm "endogeny_N" ;
lin endolymph_N = mkTerm "endolymph_N" ;
lin endometrial_A = mkTerm "endometrial_A" ;
lin endometriosis_N = mkTerm "endometriosis_N" ;
lin endometrium_N = mkTerm "endometrium_N" ;
lin endomorph_N = mkTerm "endomorph_N" ;
lin endomorphic_A = mkTerm "endomorphic_A" ;
lin endomorphy_N = mkTerm "endomorphy_N" ;
lin endoneurium_N = mkTerm "endoneurium_N" ;
lin endonuclease_N = mkTerm "endonuclease_N" ;
lin endoparasite_N = mkTerm "endoparasite_N" ;
lin endoparasitic_A = mkTerm "endoparasitic_A" ;
lin endoplasm_N = mkTerm "endoplasm_N" ;
lin endorphin_N = mkTerm "endorphin_N" ;
lin endorse_V2 = mkTerm "endorse_V2" ;
lin endorsement_N = mkTerm "endorsement_N" ;
lin endorser_N = mkTerm "endorser_N" ;
lin endoscope_N = mkTerm "endoscope_N" ;
lin endoscopic_A = mkTerm "endoscopic_A" ;
lin endoscopy_N = mkTerm "endoscopy_N" ;
lin endoskeleton_N = mkTerm "endoskeleton_N" ;
lin endosperm_N = mkTerm "endosperm_N" ;
lin endospore_N = mkTerm "endospore_N" ;
lin endosteum_N = mkTerm "endosteum_N" ;
lin endothelial_A = mkTerm "endothelial_A" ;
lin endothelium_N = mkTerm "endothelium_N" ;
lin endothermic_A = mkTerm "endothermic_A" ;
lin endotoxin_N = mkTerm "endotoxin_N" ;
lin endow_V2 = mkTerm "endow_V2" ;
lin endowment_N = mkTerm "endowment_N" ;
lin endue_V2 = mkTerm "endue_V2" ;
lin endurable_A = mkTerm "endurable_A" ;
lin endurance_N = mkTerm "endurance_N" ;
lin endure_V = mkTerm "endure_V" ;
lin endure_V2 = mkTerm "endure_V2" ;
lin enduring_A = mkTerm "enduring_A" ;
lin endways_Adv = mkTerm "endways_Adv" ;
lin endwise_Adv = mkTerm "endwise_Adv" ;
lin enema_N = mkTerm "enema_N" ;
lin enemy_N = mkTerm "enemy_N" ;
lin energetic_A = mkTerm "energetic_A" ;
lin energid_N = mkTerm "energid_N" ;
lin energizer_N = mkTerm "energizer_N" ;
lin energizing_A = mkTerm "energizing_A" ;
lin energizing_N = mkTerm "energizing_N" ;
lin energy_N = mkTerm "energy_N" ;
lin enervate_V2 = mkTerm "enervate_V2" ;
lin enervation_N = mkTerm "enervation_N" ;
lin enfant_terrible_N = mkTerm "enfant_terrible_N" ;
lin enfeeble_V2 = mkTerm "enfeeble_V2" ;
lin enfeoffment_N = mkTerm "enfeoffment_N" ;
lin enfield_PN = mkTerm "enfield_PN" ;
lin enfilade_N = mkTerm "enfilade_N" ;
lin enflurane_N = mkTerm "enflurane_N" ;
lin enfold_V2 = mkTerm "enfold_V2" ;
lin enforce_V2 = mkTerm "enforce_V2" ;
lin enforceable_A = mkTerm "enforceable_A" ;
lin enforcement_N = mkTerm "enforcement_N" ;
lin enfranchise_V2 = mkTerm "enfranchise_V2" ;
lin enfranchisement_N = mkTerm "enfranchisement_N" ;
lin engage_V = mkTerm "engage_V" ;
lin engage_V2 = mkTerm "engage_V2" ;
lin engagement_N = mkTerm "engagement_N" ;
lin engelmannia_N = mkTerm "engelmannia_N" ;
lin engender_V2 = mkTerm "engender_V2" ;
lin engine_N = mkTerm "engine_N" ;
lin engine_driver_N = mkTerm "engine_driver_N" ;
lin engineer_N = mkTerm "engineer_N" ;
lin engineer_V = mkTerm "engineer_V" ;
lin engineer_V2 = mkTerm "engineer_V2" ;
lin engineering_N = mkTerm "engineering_N" ;
lin enginery_N = mkTerm "enginery_N" ;
lin england_PN = mkTerm "england_PN" ;
lin englishFem_N = mkTerm "englishFem_N" ;
lin englishMasc_N = mkTerm "englishMasc_N" ;
lin english_A = mkTerm "english_A" ;
lin engorgement_N = mkTerm "engorgement_N" ;
lin engraft_V2 = mkTerm "engraft_V2" ;
lin engram_N = mkTerm "engram_N" ;
lin engrave_V2 = mkTerm "engrave_V2" ;
lin engraver_N = mkTerm "engraver_N" ;
lin engraving_N = mkTerm "engraving_N" ;
lin engross_V2 = mkTerm "engross_V2" ;
lin engulf_V2 = mkTerm "engulf_V2" ;
lin enhance_V2 = mkTerm "enhance_V2" ;
lin enhanced_A = mkTerm "enhanced_A" ;
lin enhancement_N = mkTerm "enhancement_N" ;
lin enigma_N = mkTerm "enigma_N" ;
lin enigmatic_A = mkTerm "enigmatic_A" ;
lin enjambment_N = mkTerm "enjambment_N" ;
lin enjoin_V2 = mkTerm "enjoin_V2" ;
lin enjoy_V2 = mkTerm "enjoy_V2" ;
lin enjoy_VV = mkTerm "enjoy_VV" ;
lin enjoyable_A = mkTerm "enjoyable_A" ;
lin enjoyableness_N = mkTerm "enjoyableness_N" ;
lin enjoyer_N = mkTerm "enjoyer_N" ;
lin enjoyment_N = mkTerm "enjoyment_N" ;
lin enkephalin_N = mkTerm "enkephalin_N" ;
lin enkindle_V2 = mkTerm "enkindle_V2" ;
lin enlarge_V = mkTerm "enlarge_V" ;
lin enlarge_V2 = mkTerm "enlarge_V2" ;
lin enlargement_N = mkTerm "enlargement_N" ;
lin enlarger_N = mkTerm "enlarger_N" ;
lin enlighten_V2 = mkTerm "enlighten_V2" ;
lin enlightening_A = mkTerm "enlightening_A" ;
lin enlightenment_N = mkTerm "enlightenment_N" ;
lin enlist_V = mkTerm "enlist_V" ;
lin enlist_V2 = mkTerm "enlist_V2" ;
lin enlistment_N = mkTerm "enlistment_N" ;
lin enliven_V2 = mkTerm "enliven_V2" ;
lin enmesh_V2 = mkTerm "enmesh_V2" ;
lin enmity_N = mkTerm "enmity_N" ;
lin ennoble_V2 = mkTerm "ennoble_V2" ;
lin ennoblement_N = mkTerm "ennoblement_N" ;
lin ennobling_A = mkTerm "ennobling_A" ;
lin ennui_N = mkTerm "ennui_N" ;
lin ennumerate_V2 = mkTerm "ennumerate_V2" ;
lin eno_PN = mkTerm "eno_PN" ;
lin enoch_PN = mkTerm "enoch_PN" ;
lin enol_N = mkTerm "enol_N" ;
lin enolic_A = mkTerm "enolic_A" ;
lin enologist_N = mkTerm "enologist_N" ;
lin enology_N = mkTerm "enology_N" ;
lin enonkoski_PN = mkTerm "enonkoski_PN" ;
lin enontekiö_PN = mkTerm "enontekiö_PN" ;
lin enophile_N = mkTerm "enophile_N" ;
lin enormity_N = mkTerm "enormity_N" ;
lin enormous_A = mkTerm "enormous_A" ;
lin enormousness_N = mkTerm "enormousness_N" ;
lin enosis_N = mkTerm "enosis_N" ;
lin enough_A = mkTerm "enough_A" ;
lin enough_N = mkTerm "enough_N" ;
lin enough_Predet = mkTerm "enough_Predet" ;
lin enplane_V = mkTerm "enplane_V" ;
lin enplane_V2 = mkTerm "enplane_V2" ;
lin enquire_V = mkTerm "enquire_V" ;
lin enquire_V2 = mkTerm "enquire_V2" ;
lin enquirer_N = mkTerm "enquirer_N" ;
lin enquiringly_Adv = mkTerm "enquiringly_Adv" ;
lin enquiry_N = mkTerm "enquiry_N" ;
lin enrage_V2 = mkTerm "enrage_V2" ;
lin enrapture_V2 = mkTerm "enrapture_V2" ;
lin enrich_V2 = mkTerm "enrich_V2" ;
lin enrichment_N = mkTerm "enrichment_N" ;
lin enrol_V = mkTerm "enrol_V" ;
lin enrol_V2 = mkTerm "enrol_V2" ;
lin enroll_V = mkTerm "enroll_V" ;
lin enroll_V2 = mkTerm "enroll_V2" ;
lin enrollee_N = mkTerm "enrollee_N" ;
lin enrollment_N = mkTerm "enrollment_N" ;
lin enrolment_N = mkTerm "enrolment_N" ;
lin enschede_PN = mkTerm "enschede_PN" ;
lin ensconce_V2 = mkTerm "ensconce_V2" ;
lin ensemble_N = mkTerm "ensemble_N" ;
lin enshrine_V2 = mkTerm "enshrine_V2" ;
lin enshroud_V2 = mkTerm "enshroud_V2" ;
lin ensiform_A = mkTerm "ensiform_A" ;
lin ensign_N = mkTerm "ensign_N" ;
lin ensilage_N = mkTerm "ensilage_N" ;
lin enslave_V2 = mkTerm "enslave_V2" ;
lin enslavement_N = mkTerm "enslavement_N" ;
lin ensnare_V2 = mkTerm "ensnare_V2" ;
lin ensue_V = mkTerm "ensue_V" ;
lin ensure_V = mkTerm "ensure_V" ;
lin ensure_V2 = mkTerm "ensure_V2" ;
lin ensure_VS = mkTerm "ensure_VS" ;
lin entablature_N = mkTerm "entablature_N" ;
lin entail_N = mkTerm "entail_N" ;
lin entail_V2 = mkTerm "entail_V2" ;
lin entangle_V2 = mkTerm "entangle_V2" ;
lin entanglement_N = mkTerm "entanglement_N" ;
lin entasis_N = mkTerm "entasis_N" ;
lin entelechy_N = mkTerm "entelechy_N" ;
lin entellus_N = mkTerm "entellus_N" ;
lin entente_N = mkTerm "entente_N" ;
lin entente_cordiale_N = mkTerm "entente_cordiale_N" ;
lin enter_V = mkTerm "enter_V" ;
lin enter_V2 = mkTerm "enter_V2" ;
lin enter_for_V2 = mkTerm "enter_for_V2" ;
lin enter_into_V2 = mkTerm "enter_into_V2" ;
lin enteric_A = mkTerm "enteric_A" ;
lin enteritis_N = mkTerm "enteritis_N" ;
lin enterobiasis_N = mkTerm "enterobiasis_N" ;
lin enterokinase_N = mkTerm "enterokinase_N" ;
lin enterolith_N = mkTerm "enterolith_N" ;
lin enterolithiasis_N = mkTerm "enterolithiasis_N" ;
lin enteron_N = mkTerm "enteron_N" ;
lin enteropathy_N = mkTerm "enteropathy_N" ;
lin enteroptosis_N = mkTerm "enteroptosis_N" ;
lin enterostenosis_N = mkTerm "enterostenosis_N" ;
lin enterostomy_N = mkTerm "enterostomy_N" ;
lin enterotoxemia_N = mkTerm "enterotoxemia_N" ;
lin enterotoxin_N = mkTerm "enterotoxin_N" ;
lin enterovirus_N = mkTerm "enterovirus_N" ;
lin enterprise_N = mkTerm "enterprise_N" ;
lin enterprising_A = mkTerm "enterprising_A" ;
lin entertain_V2 = mkTerm "entertain_V2" ;
lin entertainer_N = mkTerm "entertainer_N" ;
lin entertaining_A = mkTerm "entertaining_A" ;
lin entertainment_N = mkTerm "entertainment_N" ;
lin enthral_V2 = mkTerm "enthral_V2" ;
lin enthrall_V2 = mkTerm "enthrall_V2" ;
lin enthrone_V2 = mkTerm "enthrone_V2" ;
lin enthronement_N = mkTerm "enthronement_N" ;
lin enthuse_V = mkTerm "enthuse_V" ;
lin enthusiasm_N = mkTerm "enthusiasm_N" ;
lin enthusiast_N = mkTerm "enthusiast_N" ;
lin enthusiastic_A = mkTerm "enthusiastic_A" ;
lin entice_V2 = mkTerm "entice_V2" ;
lin enticement_N = mkTerm "enticement_N" ;
lin entire_A = mkTerm "entire_A" ;
lin entirety_N = mkTerm "entirety_N" ;
lin entitle_V2V = mkTerm "entitle_V2V" ;
lin entitle_VS = mkTerm "entitle_VS" ;
lin entitlement_N = mkTerm "entitlement_N" ;
lin entity_N = mkTerm "entity_N" ;
lin entomb_V2 = mkTerm "entomb_V2" ;
lin entomion_N = mkTerm "entomion_N" ;
lin entomological_A = mkTerm "entomological_A" ;
lin entomologist_N = mkTerm "entomologist_N" ;
lin entomology_N = mkTerm "entomology_N" ;
lin entomophilous_A = mkTerm "entomophilous_A" ;
lin entomophobia_N = mkTerm "entomophobia_N" ;
lin entoproct_N = mkTerm "entoproct_N" ;
lin entourage_N = mkTerm "entourage_N" ;
lin entozoan_A = mkTerm "entozoan_A" ;
lin entozoic_A = mkTerm "entozoic_A" ;
lin entr'acte_N = mkTerm "entr'acte_N" ;
lin entrain_V = mkTerm "entrain_V" ;
lin entrain_V2 = mkTerm "entrain_V2" ;
lin entrance_N = mkTerm "entrance_N" ;
lin entrance_V2 = mkTerm "entrance_V2" ;
lin entrance_fee_N = mkTerm "entrance_fee_N" ;
lin entrance_money_N = mkTerm "entrance_money_N" ;
lin entrancement_N = mkTerm "entrancement_N" ;
lin entrant_N = mkTerm "entrant_N" ;
lin entrap_V2 = mkTerm "entrap_V2" ;
lin entrapment_N = mkTerm "entrapment_N" ;
lin entreat_V2 = mkTerm "entreat_V2" ;
lin entreatingly_Adv = mkTerm "entreatingly_Adv" ;
lin entreaty_N = mkTerm "entreaty_N" ;
lin entrecote_N = mkTerm "entrecote_N" ;
lin entree_N = mkTerm "entree_N" ;
lin entrench_V2 = mkTerm "entrench_V2" ;
lin entrenchment_N = mkTerm "entrenchment_N" ;
lin entrepot_N = mkTerm "entrepot_N" ;
lin entrepreneur_N = mkTerm "entrepreneur_N" ;
lin entrepreneurial_A = mkTerm "entrepreneurial_A" ;
lin entropy_N = mkTerm "entropy_N" ;
lin entrust_V2 = mkTerm "entrust_V2" ;
lin entry_1_N = mkTerm "entry_1_N" ;
lin entry_2_N = mkTerm "entry_2_N" ;
lin entwin_V = mkTerm "entwin_V" ;
lin entwine_V2 = mkTerm "entwine_V2" ;
lin enucleation_N = mkTerm "enucleation_N" ;
lin enumerate_V2 = mkTerm "enumerate_V2" ;
lin enumeration_N = mkTerm "enumeration_N" ;
lin enunciate_V = mkTerm "enunciate_V" ;
lin enunciate_V2 = mkTerm "enunciate_V2" ;
lin enunciation_N = mkTerm "enunciation_N" ;
lin enured_A = mkTerm "enured_A" ;
lin enuresis_N = mkTerm "enuresis_N" ;
lin envelop_V2 = mkTerm "envelop_V2" ;
lin envelope_N = mkTerm "envelope_N" ;
lin envelopment_N = mkTerm "envelopment_N" ;
lin envenom_V2 = mkTerm "envenom_V2" ;
lin enviable_A = mkTerm "enviable_A" ;
lin envious_A = mkTerm "envious_A" ;
lin environ_V2 = mkTerm "environ_V2" ;
lin environment_N = mkTerm "environment_N" ;
lin environmental_A = mkTerm "environmental_A" ;
lin environmentalism_N = mkTerm "environmentalism_N" ;
lin environmentalist_N = mkTerm "environmentalist_N" ;
lin environs_N = mkTerm "environs_N" ;
lin envisage_V2 = mkTerm "envisage_V2" ;
lin envision_V2 = mkTerm "envision_V2" ;
lin envision_VS = mkTerm "envision_VS" ;
lin envisioned_A = mkTerm "envisioned_A" ;
lin envoi_N = mkTerm "envoi_N" ;
lin envoy_N = mkTerm "envoy_N" ;
lin envy_N = mkTerm "envy_N" ;
lin envy_V2 = mkTerm "envy_V2" ;
lin enwrap_V2 = mkTerm "enwrap_V2" ;
lin enzootic_A = mkTerm "enzootic_A" ;
lin enzymatic_A = mkTerm "enzymatic_A" ;
lin enzyme_N = mkTerm "enzyme_N" ;
lin enzymologist_N = mkTerm "enzymologist_N" ;
lin enzymology_N = mkTerm "enzymology_N" ;
lin eohippus_N = mkTerm "eohippus_N" ;
lin eolith_N = mkTerm "eolith_N" ;
lin eolithic_A = mkTerm "eolithic_A" ;
lin eon_N = mkTerm "eon_N" ;
lin eonian_A = mkTerm "eonian_A" ;
lin eoraptor_N = mkTerm "eoraptor_N" ;
lin eosin_N = mkTerm "eosin_N" ;
lin eosinopenia_N = mkTerm "eosinopenia_N" ;
lin eosinophil_N = mkTerm "eosinophil_N" ;
lin eosinophilia_N = mkTerm "eosinophilia_N" ;
lin eosinophilic_A = mkTerm "eosinophilic_A" ;
lin epacris_N = mkTerm "epacris_N" ;
lin epanalepsis_N = mkTerm "epanalepsis_N" ;
lin epanaphora_N = mkTerm "epanaphora_N" ;
lin epanodos_N = mkTerm "epanodos_N" ;
lin epanorthosis_N = mkTerm "epanorthosis_N" ;
lin eparch_N = mkTerm "eparch_N" ;
lin eparchial_A = mkTerm "eparchial_A" ;
lin eparchy_N = mkTerm "eparchy_N" ;
lin epaulet_N = mkTerm "epaulet_N" ;
lin epaulette_N = mkTerm "epaulette_N" ;
lin epauliere_N = mkTerm "epauliere_N" ;
lin epee_N = mkTerm "epee_N" ;
lin ependyma_N = mkTerm "ependyma_N" ;
lin epenthesis_N = mkTerm "epenthesis_N" ;
lin epenthetic_A = mkTerm "epenthetic_A" ;
lin epergne_N = mkTerm "epergne_N" ;
lin ephah_N = mkTerm "ephah_N" ;
lin ephedra_N = mkTerm "ephedra_N" ;
lin ephedrine_N = mkTerm "ephedrine_N" ;
lin ephemera_N = mkTerm "ephemera_N" ;
lin ephemeral_A = mkTerm "ephemeral_A" ;
lin ephemerality_N = mkTerm "ephemerality_N" ;
lin ephemerid_N = mkTerm "ephemerid_N" ;
lin ephemeris_N = mkTerm "ephemeris_N" ;
lin ephemeron_N = mkTerm "ephemeron_N" ;
lin epic_A = mkTerm "epic_A" ;
lin epic_N = mkTerm "epic_N" ;
lin epicalyx_N = mkTerm "epicalyx_N" ;
lin epicanthus_N = mkTerm "epicanthus_N" ;
lin epicardia_N = mkTerm "epicardia_N" ;
lin epicardium_N = mkTerm "epicardium_N" ;
lin epicarp_N = mkTerm "epicarp_N" ;
lin epicarpal_A = mkTerm "epicarpal_A" ;
lin epicentre_N = mkTerm "epicentre_N" ;
lin epicondyle_N = mkTerm "epicondyle_N" ;
lin epicondylitis_N = mkTerm "epicondylitis_N" ;
lin epicranium_N = mkTerm "epicranium_N" ;
lin epicure_N = mkTerm "epicure_N" ;
lin epicurean_A = mkTerm "epicurean_A" ;
lin epicurean_N = mkTerm "epicurean_N" ;
lin epicureanism_N = mkTerm "epicureanism_N" ;
lin epicurism_N = mkTerm "epicurism_N" ;
lin epicycle_N = mkTerm "epicycle_N" ;
lin epicyclic_A = mkTerm "epicyclic_A" ;
lin epicycloid_N = mkTerm "epicycloid_N" ;
lin epideictic_A = mkTerm "epideictic_A" ;
lin epidemic_A = mkTerm "epidemic_A" ;
lin epidemic_N = mkTerm "epidemic_N" ;
lin epidemiologic_A = mkTerm "epidemiologic_A" ;
lin epidemiologist_N = mkTerm "epidemiologist_N" ;
lin epidemiology_N = mkTerm "epidemiology_N" ;
lin epidendron_N = mkTerm "epidendron_N" ;
lin epidermis_N = mkTerm "epidermis_N" ;
lin epidiascope_N = mkTerm "epidiascope_N" ;
lin epididymis_N = mkTerm "epididymis_N" ;
lin epididymitis_N = mkTerm "epididymitis_N" ;
lin epidural_A = mkTerm "epidural_A" ;
lin epigastric_A = mkTerm "epigastric_A" ;
lin epigastrium_N = mkTerm "epigastrium_N" ;
lin epigenesis_N = mkTerm "epigenesis_N" ;
lin epiglottis_N = mkTerm "epiglottis_N" ;
lin epiglottitis_N = mkTerm "epiglottitis_N" ;
lin epigone_N = mkTerm "epigone_N" ;
lin epigram_N = mkTerm "epigram_N" ;
lin epigrammatic_A = mkTerm "epigrammatic_A" ;
lin epigraph_N = mkTerm "epigraph_N" ;
lin epigraphy_N = mkTerm "epigraphy_N" ;
lin epikeratophakia_N = mkTerm "epikeratophakia_N" ;
lin epilation_N = mkTerm "epilation_N" ;
lin epilepsy_N = mkTerm "epilepsy_N" ;
lin epilepticFem_N = mkTerm "epilepticFem_N" ;
lin epilepticMasc_N = mkTerm "epilepticMasc_N" ;
lin epileptic_A = mkTerm "epileptic_A" ;
lin epilithic_A = mkTerm "epilithic_A" ;
lin epilogue_N = mkTerm "epilogue_N" ;
lin epimorphic_A = mkTerm "epimorphic_A" ;
lin epinephrine_N = mkTerm "epinephrine_N" ;
lin epiphany_N = mkTerm "epiphany_N" ;
lin epiphany_PN = mkTerm "epiphany_PN" ;
lin epiphenomenon_N = mkTerm "epiphenomenon_N" ;
lin epiphora_N = mkTerm "epiphora_N" ;
lin epiphyllum_N = mkTerm "epiphyllum_N" ;
lin epiphyseal_A = mkTerm "epiphyseal_A" ;
lin epiphysis_N = mkTerm "epiphysis_N" ;
lin epiphytic_A = mkTerm "epiphytic_A" ;
lin epiphytotic_A = mkTerm "epiphytotic_A" ;
lin epiplexis_N = mkTerm "epiplexis_N" ;
lin episcia_N = mkTerm "episcia_N" ;
lin episcleritis_N = mkTerm "episcleritis_N" ;
lin episcopacy_N = mkTerm "episcopacy_N" ;
lin episcopal_A = mkTerm "episcopal_A" ;
lin episcopalian_A = mkTerm "episcopalian_A" ;
lin episcopalian_N = mkTerm "episcopalian_N" ;
lin episcopate_N = mkTerm "episcopate_N" ;
lin episiotomy_N = mkTerm "episiotomy_N" ;
lin episode_N = mkTerm "episode_N" ;
lin episodic_A = mkTerm "episodic_A" ;
lin episome_N = mkTerm "episome_N" ;
lin epispadias_N = mkTerm "epispadias_N" ;
lin episteme_N = mkTerm "episteme_N" ;
lin epistemic_A = mkTerm "epistemic_A" ;
lin epistemologist_N = mkTerm "epistemologist_N" ;
lin epistemology_N = mkTerm "epistemology_N" ;
lin epistle_N = mkTerm "epistle_N" ;
lin epistolary_A = mkTerm "epistolary_A" ;
lin epitaph_N = mkTerm "epitaph_N" ;
lin epitaxy_N = mkTerm "epitaxy_N" ;
lin epithalamium_N = mkTerm "epithalamium_N" ;
lin epithelial_A = mkTerm "epithelial_A" ;
lin epitheliod_A = mkTerm "epitheliod_A" ;
lin epithelioma_N = mkTerm "epithelioma_N" ;
lin epithelium_N = mkTerm "epithelium_N" ;
lin epithet_N = mkTerm "epithet_N" ;
lin epitome_N = mkTerm "epitome_N" ;
lin epitomize_V2 = mkTerm "epitomize_V2" ;
lin epizoan_A = mkTerm "epizoan_A" ;
lin epizoic_A = mkTerm "epizoic_A" ;
lin epizootic_A = mkTerm "epizootic_A" ;
lin epoch_N = mkTerm "epoch_N" ;
lin epoch_making_A = mkTerm "epoch_making_A" ;
lin epochal_A = mkTerm "epochal_A" ;
lin eponym_N = mkTerm "eponym_N" ;
lin eponymous_A = mkTerm "eponymous_A" ;
lin eponymy_N = mkTerm "eponymy_N" ;
lin epos_N = mkTerm "epos_N" ;
lin epoxy_N = mkTerm "epoxy_N" ;
lin epping_PN = mkTerm "epping_PN" ;
lin epsilon_N = mkTerm "epsilon_N" ;
lin epsom_PN = mkTerm "epsom_PN" ;
lin eptatretus_N = mkTerm "eptatretus_N" ;
lin equable_A = mkTerm "equable_A" ;
lin equal_A = mkTerm "equal_A" ;
lin equal_N = mkTerm "equal_N" ;
lin equal_V2 = mkTerm "equal_V2" ;
lin equal_to_A2 = mkTerm "equal_to_A2" ;
lin equalitarian_N = mkTerm "equalitarian_N" ;
lin equality_N = mkTerm "equality_N" ;
lin equalization_N = mkTerm "equalization_N" ;
lin equalize_V2 = mkTerm "equalize_V2" ;
lin equalizer_N = mkTerm "equalizer_N" ;
lin equanimity_N = mkTerm "equanimity_N" ;
lin equatability_N = mkTerm "equatability_N" ;
lin equate_V2 = mkTerm "equate_V2" ;
lin equation_N = mkTerm "equation_N" ;
lin equator_N = mkTerm "equator_N" ;
lin equatorial_A = mkTerm "equatorial_A" ;
lin equatorial_N = mkTerm "equatorial_N" ;
lin equerry_N = mkTerm "equerry_N" ;
lin equestrian_A = mkTerm "equestrian_A" ;
lin equestrian_N = mkTerm "equestrian_N" ;
lin equiangular_A = mkTerm "equiangular_A" ;
lin equidistant_A = mkTerm "equidistant_A" ;
lin equidistribution_N = mkTerm "equidistribution_N" ;
lin equilateral_A = mkTerm "equilateral_A" ;
lin equilateral_N = mkTerm "equilateral_N" ;
lin equilibration_N = mkTerm "equilibration_N" ;
lin equilibrium_N = mkTerm "equilibrium_N" ;
lin equine_A = mkTerm "equine_A" ;
lin equine_N = mkTerm "equine_N" ;
lin equinoctial_A = mkTerm "equinoctial_A" ;
lin equinox_N = mkTerm "equinox_N" ;
lin equip_V2 = mkTerm "equip_V2" ;
lin equipage_N = mkTerm "equipage_N" ;
lin equipment_N = mkTerm "equipment_N" ;
lin equipoise_N = mkTerm "equipoise_N" ;
lin equipoised_A = mkTerm "equipoised_A" ;
lin equipotent_A = mkTerm "equipotent_A" ;
lin equiprobable_A = mkTerm "equiprobable_A" ;
lin equitable_A = mkTerm "equitable_A" ;
lin equity_N = mkTerm "equity_N" ;
lin equivalence_N = mkTerm "equivalence_N" ;
lin equivalent_A = mkTerm "equivalent_A" ;
lin equivalent_N = mkTerm "equivalent_N" ;
lin equivocal_A = mkTerm "equivocal_A" ;
lin equivocation_N = mkTerm "equivocation_N" ;
lin er_Interj = mkTerm "er_Interj" ;
lin era_N = mkTerm "era_N" ;
lin eradicable_A = mkTerm "eradicable_A" ;
lin eradicate_V2 = mkTerm "eradicate_V2" ;
lin eradication_N = mkTerm "eradication_N" ;
lin erase_V2 = mkTerm "erase_V2" ;
lin eraser_N = mkTerm "eraser_N" ;
lin erasure_N = mkTerm "erasure_N" ;
lin erbium_N = mkTerm "erbium_N" ;
lin ere_Adv = mkTerm "ere_Adv" ;
lin ere_Prep = mkTerm "ere_Prep" ;
lin erect_A = mkTerm "erect_A" ;
lin erect_V2 = mkTerm "erect_V2" ;
lin erectile_A = mkTerm "erectile_A" ;
lin erecting_N = mkTerm "erecting_N" ;
lin erection_N = mkTerm "erection_N" ;
lin erectness_N = mkTerm "erectness_N" ;
lin eremite_N = mkTerm "eremite_N" ;
lin eremitic_A = mkTerm "eremitic_A" ;
lin eremitism_N = mkTerm "eremitism_N" ;
lin erethism_N = mkTerm "erethism_N" ;
lin erfurt_PN = mkTerm "erfurt_PN" ;
lin erg_N = mkTerm "erg_N" ;
lin ergo_Adv = mkTerm "ergo_Adv" ;
lin ergodic_A = mkTerm "ergodic_A" ;
lin ergodicity_N = mkTerm "ergodicity_N" ;
lin ergonomic_A = mkTerm "ergonomic_A" ;
lin ergonomics_N = mkTerm "ergonomics_N" ;
lin ergonovine_N = mkTerm "ergonovine_N" ;
lin ergosterol_N = mkTerm "ergosterol_N" ;
lin ergot_N = mkTerm "ergot_N" ;
lin ergotamine_N = mkTerm "ergotamine_N" ;
lin ergotic_A = mkTerm "ergotic_A" ;
lin ergotism_N = mkTerm "ergotism_N" ;
lin ergotropic_A = mkTerm "ergotropic_A" ;
lin ergotropism_N = mkTerm "ergotropism_N" ;
lin eric_PN = mkTerm "eric_PN" ;
lin erica_N = mkTerm "erica_N" ;
lin erica_PN = mkTerm "erica_PN" ;
lin erin_PN = mkTerm "erin_PN" ;
lin eriogonum_N = mkTerm "eriogonum_N" ;
lin eristic_A = mkTerm "eristic_A" ;
lin eristic_N = mkTerm "eristic_N" ;
lin eritrea_PN = mkTerm "eritrea_PN" ;
lin eritrean_A = mkTerm "eritrean_A" ;
lin eritrean_N = mkTerm "eritrean_N" ;
lin erlangen_PN = mkTerm "erlangen_PN" ;
lin ermine_N = mkTerm "ermine_N" ;
lin ern_N = mkTerm "ern_N" ;
lin ernest_PN = mkTerm "ernest_PN" ;
lin ernie_PN = mkTerm "ernie_PN" ;
lin erode_V = mkTerm "erode_V" ;
lin erode_V2 = mkTerm "erode_V2" ;
lin erogenous_A = mkTerm "erogenous_A" ;
lin erose_A = mkTerm "erose_A" ;
lin erosion_N = mkTerm "erosion_N" ;
lin erosive_A = mkTerm "erosive_A" ;
lin erotic_A = mkTerm "erotic_A" ;
lin erotic_N = mkTerm "erotic_N" ;
lin eroticism_N = mkTerm "eroticism_N" ;
lin err_V = mkTerm "err_V" ;
lin errancy_N = mkTerm "errancy_N" ;
lin errand_N = mkTerm "errand_N" ;
lin errant_A = mkTerm "errant_A" ;
lin erratic_A = mkTerm "erratic_A" ;
lin erratum_N = mkTerm "erratum_N" ;
lin errhine_A = mkTerm "errhine_A" ;
lin erroneous_A = mkTerm "erroneous_A" ;
lin erroneousness_N = mkTerm "erroneousness_N" ;
lin error_N = mkTerm "error_N" ;
lin errorless_A = mkTerm "errorless_A" ;
lin ersatz_A = mkTerm "ersatz_A" ;
lin ersatz_N = mkTerm "ersatz_N" ;
lin erse_N = mkTerm "erse_N" ;
lin erstwhile_A = mkTerm "erstwhile_A" ;
lin eructation_N = mkTerm "eructation_N" ;
lin erudite_A = mkTerm "erudite_A" ;
lin eruditeness_N = mkTerm "eruditeness_N" ;
lin erudition_N = mkTerm "erudition_N" ;
lin erupt_V = mkTerm "erupt_V" ;
lin eruption_N = mkTerm "eruption_N" ;
lin eruptive_A = mkTerm "eruptive_A" ;
lin erwinia_N = mkTerm "erwinia_N" ;
lin eryngo_N = mkTerm "eryngo_N" ;
lin erysipelas_N = mkTerm "erysipelas_N" ;
lin erythema_N = mkTerm "erythema_N" ;
lin erythematous_A = mkTerm "erythematous_A" ;
lin erythrite_N = mkTerm "erythrite_N" ;
lin erythroblast_N = mkTerm "erythroblast_N" ;
lin erythroblastosis_N = mkTerm "erythroblastosis_N" ;
lin erythroderma_N = mkTerm "erythroderma_N" ;
lin erythroid_A = mkTerm "erythroid_A" ;
lin erythromycin_N = mkTerm "erythromycin_N" ;
lin erythropoiesis_N = mkTerm "erythropoiesis_N" ;
lin erythropoietic_A = mkTerm "erythropoietic_A" ;
lin erythropoietin_N = mkTerm "erythropoietin_N" ;
lin escadrille_N = mkTerm "escadrille_N" ;
lin escalade_N = mkTerm "escalade_N" ;
lin escalader_N = mkTerm "escalader_N" ;
lin escalate_V = mkTerm "escalate_V" ;
lin escalate_V2 = mkTerm "escalate_V2" ;
lin escalation_N = mkTerm "escalation_N" ;
lin escalator_N = mkTerm "escalator_N" ;
lin escalope_N = mkTerm "escalope_N" ;
lin escapade_N = mkTerm "escapade_N" ;
lin escape_N = mkTerm "escape_N" ;
lin escape_V = mkTerm "escape_V" ;
lin escape_V2 = mkTerm "escape_V2" ;
lin escape_VS = mkTerm "escape_VS" ;
lin escapee_N = mkTerm "escapee_N" ;
lin escapement_N = mkTerm "escapement_N" ;
lin escapism_N = mkTerm "escapism_N" ;
lin escapist_N = mkTerm "escapist_N" ;
lin escapologist_N = mkTerm "escapologist_N" ;
lin escapology_N = mkTerm "escapology_N" ;
lin escargot_N = mkTerm "escargot_N" ;
lin escarpment_N = mkTerm "escarpment_N" ;
lin eschar_N = mkTerm "eschar_N" ;
lin eschatological_A = mkTerm "eschatological_A" ;
lin eschatologist_N = mkTerm "eschatologist_N" ;
lin eschatology_N = mkTerm "eschatology_N" ;
lin escheat_N = mkTerm "escheat_N" ;
lin escherichia_N = mkTerm "escherichia_N" ;
lin eschew_V2 = mkTerm "eschew_V2" ;
lin escolar_N = mkTerm "escolar_N" ;
lin escort_N = mkTerm "escort_N" ;
lin escort_V2 = mkTerm "escort_V2" ;
lin escritoire_N = mkTerm "escritoire_N" ;
lin escrow_N = mkTerm "escrow_N" ;
lin escudo_N = mkTerm "escudo_N" ;
lin escutcheon_N = mkTerm "escutcheon_N" ;
lin esfahan_PN = mkTerm "esfahan_PN" ;
lin esker_N = mkTerm "esker_N" ;
lin eskimo_N = mkTerm "eskimo_N" ;
lin esmolol_N = mkTerm "esmolol_N" ;
lin esophageal_A = mkTerm "esophageal_A" ;
lin esophagitis_N = mkTerm "esophagitis_N" ;
lin esophagoscope_N = mkTerm "esophagoscope_N" ;
lin esophagus_N = mkTerm "esophagus_N" ;
lin esoteric_A = mkTerm "esoteric_A" ;
lin esoterica_N = mkTerm "esoterica_N" ;
lin esp_N = mkTerm "esp_N" ;
lin espadrille_N = mkTerm "espadrille_N" ;
lin espalier_N = mkTerm "espalier_N" ;
lin especial_A = mkTerm "especial_A" ;
lin esperanto_N = mkTerm "esperanto_N" ;
lin espionage_N = mkTerm "espionage_N" ;
lin esplanade_N = mkTerm "esplanade_N" ;
lin espoo_PN = mkTerm "espoo_PN" ;
lin espousal_N = mkTerm "espousal_N" ;
lin espouse_V2 = mkTerm "espouse_V2" ;
lin espresso_N = mkTerm "espresso_N" ;
lin esprit_N = mkTerm "esprit_N" ;
lin esprit_de_corps_N = mkTerm "esprit_de_corps_N" ;
lin espy_V2 = mkTerm "espy_V2" ;
lin esq_PN = mkTerm "esq_PN" ;
lin esquire_N = mkTerm "esquire_N" ;
lin essay_N = mkTerm "essay_N" ;
lin essay_V = mkTerm "essay_V" ;
lin essay_V2 = mkTerm "essay_V2" ;
lin essayist_N = mkTerm "essayist_N" ;
lin essen_PN = mkTerm "essen_PN" ;
lin essence_N = mkTerm "essence_N" ;
lin essential_A = mkTerm "essential_A" ;
lin essential_N = mkTerm "essential_N" ;
lin essentiality_N = mkTerm "essentiality_N" ;
lin essex_PN = mkTerm "essex_PN" ;
lin establish_V2 = mkTerm "establish_V2" ;
lin established_A = mkTerm "established_A" ;
lin establishment_N = mkTerm "establishment_N" ;
lin establishmentarianism_N = mkTerm "establishmentarianism_N" ;
lin estaminet_N = mkTerm "estaminet_N" ;
lin estate_N = mkTerm "estate_N" ;
lin estazolam_N = mkTerm "estazolam_N" ;
lin esteem_N = mkTerm "esteem_N" ;
lin esteem_V2 = mkTerm "esteem_V2" ;
lin ester_N = mkTerm "ester_N" ;
lin esther_PN = mkTerm "esther_PN" ;
lin esthete_N = mkTerm "esthete_N" ;
lin esthetic_A = mkTerm "esthetic_A" ;
lin esthetic_N = mkTerm "esthetic_N" ;
lin esthetical_A = mkTerm "esthetical_A" ;
lin esthetician_N = mkTerm "esthetician_N" ;
lin esthetics_N = mkTerm "esthetics_N" ;
lin estimable_A = mkTerm "estimable_A" ;
lin estimate_N = mkTerm "estimate_N" ;
lin estimate_V = mkTerm "estimate_V" ;
lin estimate_V2 = mkTerm "estimate_V2" ;
lin estimate_V2V = mkTerm "estimate_V2V" ;
lin estimate_VS = mkTerm "estimate_VS" ;
lin estimated_A = mkTerm "estimated_A" ;
lin estimation_N = mkTerm "estimation_N" ;
lin estivation_N = mkTerm "estivation_N" ;
lin estoppel_N = mkTerm "estoppel_N" ;
lin estradiol_N = mkTerm "estradiol_N" ;
lin estrange_V2 = mkTerm "estrange_V2" ;
lin estrangement_N = mkTerm "estrangement_N" ;
lin estranging_A = mkTerm "estranging_A" ;
lin estriol_N = mkTerm "estriol_N" ;
lin estrogen_N = mkTerm "estrogen_N" ;
lin estrogenic_A = mkTerm "estrogenic_A" ;
lin estrone_N = mkTerm "estrone_N" ;
lin estrous_A = mkTerm "estrous_A" ;
lin estrus_N = mkTerm "estrus_N" ;
lin estuarine_A = mkTerm "estuarine_A" ;
lin estuary_N = mkTerm "estuary_N" ;
lin et_al_PN = mkTerm "et_al_PN" ;
lin et_seq_PN = mkTerm "et_seq_PN" ;
lin eta_N = mkTerm "eta_N" ;
lin etagere_N = mkTerm "etagere_N" ;
lin etamine_N = mkTerm "etamine_N" ;
lin etanercept_N = mkTerm "etanercept_N" ;
lin etc_PN = mkTerm "etc_PN" ;
lin etcetera_N = mkTerm "etcetera_N" ;
lin etch_V = mkTerm "etch_V" ;
lin etch_V2 = mkTerm "etch_V2" ;
lin etcher_N = mkTerm "etcher_N" ;
lin etching_N = mkTerm "etching_N" ;
lin etd_N = mkTerm "etd_N" ;
lin eternal_A = mkTerm "eternal_A" ;
lin eternity_N = mkTerm "eternity_N" ;
lin ethane_N = mkTerm "ethane_N" ;
lin ethanol_N = mkTerm "ethanol_N" ;
lin ethchlorvynol_N = mkTerm "ethchlorvynol_N" ;
lin ethel_PN = mkTerm "ethel_PN" ;
lin ether_N = mkTerm "ether_N" ;
lin ethereal_A = mkTerm "ethereal_A" ;
lin ethernet_N = mkTerm "ethernet_N" ;
lin ethic_N = mkTerm "ethic_N" ;
lin ethical_A = mkTerm "ethical_A" ;
lin ethicism_N = mkTerm "ethicism_N" ;
lin ethicist_N = mkTerm "ethicist_N" ;
lin ethics_N = mkTerm "ethics_N" ;
lin ethiopia_PN = mkTerm "ethiopia_PN" ;
lin ethiopian_A = mkTerm "ethiopian_A" ;
lin ethiopian_N = mkTerm "ethiopian_N" ;
lin ethmoid_N = mkTerm "ethmoid_N" ;
lin ethnarch_N = mkTerm "ethnarch_N" ;
lin ethnic_A = mkTerm "ethnic_A" ;
lin ethnic_N = mkTerm "ethnic_N" ;
lin ethnicity_N = mkTerm "ethnicity_N" ;
lin ethnocentric_A = mkTerm "ethnocentric_A" ;
lin ethnocentrism_N = mkTerm "ethnocentrism_N" ;
lin ethnographer_N = mkTerm "ethnographer_N" ;
lin ethnographic_A = mkTerm "ethnographic_A" ;
lin ethnography_N = mkTerm "ethnography_N" ;
lin ethnological_A = mkTerm "ethnological_A" ;
lin ethnologist_N = mkTerm "ethnologist_N" ;
lin ethnology_N = mkTerm "ethnology_N" ;
lin ethologist_N = mkTerm "ethologist_N" ;
lin ethology_N = mkTerm "ethology_N" ;
lin ethos_N = mkTerm "ethos_N" ;
lin ethosuximide_N = mkTerm "ethosuximide_N" ;
lin ethyl_N = mkTerm "ethyl_N" ;
lin ethylene_N = mkTerm "ethylene_N" ;
lin etiolate_A = mkTerm "etiolate_A" ;
lin etiolation_N = mkTerm "etiolation_N" ;
lin etiological_A = mkTerm "etiological_A" ;
lin etiologist_N = mkTerm "etiologist_N" ;
lin etiology_N = mkTerm "etiology_N" ;
lin etiquette_N = mkTerm "etiquette_N" ;
lin etodolac_N = mkTerm "etodolac_N" ;
lin etude_N = mkTerm "etude_N" ;
lin etui_N = mkTerm "etui_N" ;
lin etymological_A = mkTerm "etymological_A" ;
lin etymologist_N = mkTerm "etymologist_N" ;
lin etymology_N = mkTerm "etymology_N" ;
lin etymon_N = mkTerm "etymon_N" ;
lin eubacteria_N = mkTerm "eubacteria_N" ;
lin eucalyptus_N = mkTerm "eucalyptus_N" ;
lin eucharist_N = mkTerm "eucharist_N" ;
lin euchre_N = mkTerm "euchre_N" ;
lin euclidean_A = mkTerm "euclidean_A" ;
lin eudemon_N = mkTerm "eudemon_N" ;
lin eudemonic_A = mkTerm "eudemonic_A" ;
lin eudemonism_N = mkTerm "eudemonism_N" ;
lin eudiometer_N = mkTerm "eudiometer_N" ;
lin eugene_PN = mkTerm "eugene_PN" ;
lin eugenic_A = mkTerm "eugenic_A" ;
lin eugenics_N = mkTerm "eugenics_N" ;
lin euglena_N = mkTerm "euglena_N" ;
lin euglenoid_N = mkTerm "euglenoid_N" ;
lin eukaryote_N = mkTerm "eukaryote_N" ;
lin eukaryotic_A = mkTerm "eukaryotic_A" ;
lin eulogist_N = mkTerm "eulogist_N" ;
lin eulogistic_A = mkTerm "eulogistic_A" ;
lin eulogize_V2 = mkTerm "eulogize_V2" ;
lin eulogy_N = mkTerm "eulogy_N" ;
lin eunice_PN = mkTerm "eunice_PN" ;
lin eunuch_N = mkTerm "eunuch_N" ;
lin euphemism_N = mkTerm "euphemism_N" ;
lin euphemistic_A = mkTerm "euphemistic_A" ;
lin euphonic_A = mkTerm "euphonic_A" ;
lin euphonious_A = mkTerm "euphonious_A" ;
lin euphonium_N = mkTerm "euphonium_N" ;
lin euphony_N = mkTerm "euphony_N" ;
lin euphorbium_N = mkTerm "euphorbium_N" ;
lin euphoria_N = mkTerm "euphoria_N" ;
lin euphoriant_A = mkTerm "euphoriant_A" ;
lin euphoriant_N = mkTerm "euphoriant_N" ;
lin euphoric_A = mkTerm "euphoric_A" ;
lin euphuism_N = mkTerm "euphuism_N" ;
lin eupnea_N = mkTerm "eupnea_N" ;
lin eura_PN = mkTerm "eura_PN" ;
lin eurajoki_PN = mkTerm "eurajoki_PN" ;
lin eurasia_PN = mkTerm "eurasia_PN" ;
lin eurasian_A = mkTerm "eurasian_A" ;
lin eurasian_N = mkTerm "eurasian_N" ;
lin eurhythmics_N = mkTerm "eurhythmics_N" ;
lin euro_N = mkTerm "euro_N" ;
lin eurodollar_N = mkTerm "eurodollar_N" ;
lin europe_PN = mkTerm "europe_PN" ;
lin european_A = mkTerm "european_A" ;
lin european_N = mkTerm "european_N" ;
lin european_union_NP = mkTerm "european_union_NP" ;
lin europium_N = mkTerm "europium_N" ;
lin eurovision_PN = mkTerm "eurovision_PN" ;
lin eurypterid_N = mkTerm "eurypterid_N" ;
lin eurythmics_N = mkTerm "eurythmics_N" ;
lin eurythmy_N = mkTerm "eurythmy_N" ;
lin eusporangiate_A = mkTerm "eusporangiate_A" ;
lin eusporangium_N = mkTerm "eusporangium_N" ;
lin eustachian_A = mkTerm "eustachian_A" ;
lin eutectic_N = mkTerm "eutectic_N" ;
lin euthanasia_N = mkTerm "euthanasia_N" ;
lin euthenics_N = mkTerm "euthenics_N" ;
lin eutherian_A = mkTerm "eutherian_A" ;
lin eutrophic_A = mkTerm "eutrophic_A" ;
lin eutrophication_N = mkTerm "eutrophication_N" ;
lin eva_PN = mkTerm "eva_PN" ;
lin evacuate_V2 = mkTerm "evacuate_V2" ;
lin evacuation_N = mkTerm "evacuation_N" ;
lin evacuee_N = mkTerm "evacuee_N" ;
lin evade_V2 = mkTerm "evade_V2" ;
lin evaluate_V = mkTerm "evaluate_V" ;
lin evaluate_V2 = mkTerm "evaluate_V2" ;
lin evaluation_N = mkTerm "evaluation_N" ;
lin evaluative_A = mkTerm "evaluative_A" ;
lin evaluator_N = mkTerm "evaluator_N" ;
lin evanescence_N = mkTerm "evanescence_N" ;
lin evanescent_A = mkTerm "evanescent_A" ;
lin evangelical_A = mkTerm "evangelical_A" ;
lin evangelicalism_N = mkTerm "evangelicalism_N" ;
lin evangelism_N = mkTerm "evangelism_N" ;
lin evangelist_N = mkTerm "evangelist_N" ;
lin evangelistic_A = mkTerm "evangelistic_A" ;
lin evaporable_A = mkTerm "evaporable_A" ;
lin evaporate_V = mkTerm "evaporate_V" ;
lin evaporate_V2 = mkTerm "evaporate_V2" ;
lin evaporate_VS = mkTerm "evaporate_VS" ;
lin evaporation_N = mkTerm "evaporation_N" ;
lin evaporative_A = mkTerm "evaporative_A" ;
lin evaporite_N = mkTerm "evaporite_N" ;
lin evasion_N = mkTerm "evasion_N" ;
lin evasive_A = mkTerm "evasive_A" ;
lin evasiveness_N = mkTerm "evasiveness_N" ;
lin eve_N = mkTerm "eve_N" ;
lin eve_PN = mkTerm "eve_PN" ;
lin evelyn_PN = mkTerm "evelyn_PN" ;
lin even_1_A = mkTerm "even_1_A" ;
lin even_2_A = mkTerm "even_2_A" ;
lin even_AdA = mkTerm "even_AdA" ;
lin even_AdV = mkTerm "even_AdV" ;
lin even_Adv = mkTerm "even_Adv" ;
lin even_N = mkTerm "even_N" ;
lin even_V2 = mkTerm "even_V2" ;
lin even_handed_A = mkTerm "even_handed_A" ;
lin even_out_V = mkTerm "even_out_V" ;
lin even_though_Subj = mkTerm "even_though_Subj" ;
lin evening_N = mkTerm "evening_N" ;
lin evenness_N = mkTerm "evenness_N" ;
lin evensong_N = mkTerm "evensong_N" ;
lin event_N = mkTerm "event_N" ;
lin eventful_A = mkTerm "eventful_A" ;
lin eventide_N = mkTerm "eventide_N" ;
lin eventration_N = mkTerm "eventration_N" ;
lin eventual_A = mkTerm "eventual_A" ;
lin eventuality_N = mkTerm "eventuality_N" ;
lin ever_AdV = mkTerm "ever_AdV" ;
lin ever_Adv = mkTerm "ever_Adv" ;
lin evergreen_A = mkTerm "evergreen_A" ;
lin evergreen_N = mkTerm "evergreen_N" ;
lin everlasting_A = mkTerm "everlasting_A" ;
lin everlasting_N = mkTerm "everlasting_N" ;
lin everlastingness_N = mkTerm "everlastingness_N" ;
lin evermore_Adv = mkTerm "evermore_Adv" ;
lin eversion_N = mkTerm "eversion_N" ;
lin every_bit_Adv = mkTerm "every_bit_Adv" ;
lin everyday_A = mkTerm "everyday_A" ;
lin everyman_N = mkTerm "everyman_N" ;
lin everyone_NP = mkTerm "everyone_NP" ;
lin everyplace_Adv = mkTerm "everyplace_Adv" ;
lin evesham_PN = mkTerm "evesham_PN" ;
lin evict_V2 = mkTerm "evict_V2" ;
lin eviction_N = mkTerm "eviction_N" ;
lin evidence_1_N = mkTerm "evidence_1_N" ;
lin evidence_2_N = mkTerm "evidence_2_N" ;
lin evidence_V2 = mkTerm "evidence_V2" ;
lin evident_A = mkTerm "evident_A" ;
lin evidential_A = mkTerm "evidential_A" ;
lin evidentiary_A = mkTerm "evidentiary_A" ;
lin evijärvi_PN = mkTerm "evijärvi_PN" ;
lin evil_A = mkTerm "evil_A" ;
lin evil_N = mkTerm "evil_N" ;
lin evil_doer_N = mkTerm "evil_doer_N" ;
lin evil_minded_A = mkTerm "evil_minded_A" ;
lin evince_V2 = mkTerm "evince_V2" ;
lin eviscerate_A = mkTerm "eviscerate_A" ;
lin eviscerate_V2 = mkTerm "eviscerate_V2" ;
lin evisceration_N = mkTerm "evisceration_N" ;
lin evitable_A = mkTerm "evitable_A" ;
lin evocation_N = mkTerm "evocation_N" ;
lin evocative_A = mkTerm "evocative_A" ;
lin evoke_V2 = mkTerm "evoke_V2" ;
lin evolution_N = mkTerm "evolution_N" ;
lin evolutionary_A = mkTerm "evolutionary_A" ;
lin evolutionistFem_N = mkTerm "evolutionistFem_N" ;
lin evolutionistMasc_N = mkTerm "evolutionistMasc_N" ;
lin evolve_V = mkTerm "evolve_V" ;
lin evolve_V2 = mkTerm "evolve_V2" ;
lin ewe_N = mkTerm "ewe_N" ;
lin ewell_PN = mkTerm "ewell_PN" ;
lin ewer_N = mkTerm "ewer_N" ;
lin ex_A = mkTerm "ex_A" ;
lin ex_directory_A = mkTerm "ex_directory_A" ;
lin ex_gratia_A = mkTerm "ex_gratia_A" ;
lin ex_officio_A = mkTerm "ex_officio_A" ;
lin ex_officio_Adv = mkTerm "ex_officio_Adv" ;
lin ex_service_A = mkTerm "ex_service_A" ;
lin ex_serviceman_N = mkTerm "ex_serviceman_N" ;
lin exabit_N = mkTerm "exabit_N" ;
lin exabyte_N = mkTerm "exabyte_N" ;
lin exacerbate_V2 = mkTerm "exacerbate_V2" ;
lin exacerbation_N = mkTerm "exacerbation_N" ;
lin exact_A = mkTerm "exact_A" ;
lin exact_V2 = mkTerm "exact_V2" ;
lin exacta_N = mkTerm "exacta_N" ;
lin exacting_A = mkTerm "exacting_A" ;
lin exaction_N = mkTerm "exaction_N" ;
lin exactitude_N = mkTerm "exactitude_N" ;
lin exactness_N = mkTerm "exactness_N" ;
lin exaggerate_V = mkTerm "exaggerate_V" ;
lin exaggerate_V2 = mkTerm "exaggerate_V2" ;
lin exaggeration_N = mkTerm "exaggeration_N" ;
lin exalt_V2 = mkTerm "exalt_V2" ;
lin exaltation_N = mkTerm "exaltation_N" ;
lin exam_N = mkTerm "exam_N" ;
lin examen_N = mkTerm "examen_N" ;
lin examination_N = mkTerm "examination_N" ;
lin examine_V2 = mkTerm "examine_V2" ;
lin examiner_N = mkTerm "examiner_N" ;
lin example_N = mkTerm "example_N" ;
lin exanthem_N = mkTerm "exanthem_N" ;
lin exarch_N = mkTerm "exarch_N" ;
lin exasperate_V2 = mkTerm "exasperate_V2" ;
lin exasperating_A = mkTerm "exasperating_A" ;
lin exasperation_N = mkTerm "exasperation_N" ;
lin exaugural_A = mkTerm "exaugural_A" ;
lin exbibit_N = mkTerm "exbibit_N" ;
lin excavate_V = mkTerm "excavate_V" ;
lin excavate_V2 = mkTerm "excavate_V2" ;
lin excavation_N = mkTerm "excavation_N" ;
lin excavator_N = mkTerm "excavator_N" ;
lin exceed_V2 = mkTerm "exceed_V2" ;
lin exceedance_N = mkTerm "exceedance_N" ;
lin exceeding_A = mkTerm "exceeding_A" ;
lin excel_V = mkTerm "excel_V" ;
lin excel_V2 = mkTerm "excel_V2" ;
lin excellence_N = mkTerm "excellence_N" ;
lin excellency_N = mkTerm "excellency_N" ;
lin excellent_A = mkTerm "excellent_A" ;
lin excelsior_N = mkTerm "excelsior_N" ;
lin except_Conj = mkTerm "except_Conj" ;
lin except_V2 = mkTerm "except_V2" ;
lin except_for_Prep = mkTerm "except_for_Prep" ;
lin exception_N = mkTerm "exception_N" ;
lin exceptionable_A = mkTerm "exceptionable_A" ;
lin exceptional_A = mkTerm "exceptional_A" ;
lin excerpt_N = mkTerm "excerpt_N" ;
lin excess_A = mkTerm "excess_A" ;
lin excess_N = mkTerm "excess_N" ;
lin excessive_A = mkTerm "excessive_A" ;
lin exchange_N = mkTerm "exchange_N" ;
lin exchange_V2 = mkTerm "exchange_V2" ;
lin exchangeability_N = mkTerm "exchangeability_N" ;
lin exchangeable_A = mkTerm "exchangeable_A" ;
lin exchanger_N = mkTerm "exchanger_N" ;
lin exchequer_N = mkTerm "exchequer_N" ;
lin excise_N = mkTerm "excise_N" ;
lin excise_V2 = mkTerm "excise_V2" ;
lin exciseman_N = mkTerm "exciseman_N" ;
lin excision_N = mkTerm "excision_N" ;
lin excitability_N = mkTerm "excitability_N" ;
lin excitable_A = mkTerm "excitable_A" ;
lin excitant_A = mkTerm "excitant_A" ;
lin excitation_N = mkTerm "excitation_N" ;
lin excite_V2 = mkTerm "excite_V2" ;
lin excited_A = mkTerm "excited_A" ;
lin excitement_N = mkTerm "excitement_N" ;
lin exciting_A = mkTerm "exciting_A" ;
lin excl_PN = mkTerm "excl_PN" ;
lin exclaim_V2 = mkTerm "exclaim_V2" ;
lin exclamation_N = mkTerm "exclamation_N" ;
lin exclamatory_A = mkTerm "exclamatory_A" ;
lin exclude_V2 = mkTerm "exclude_V2" ;
lin exclusion_N = mkTerm "exclusion_N" ;
lin exclusive_A = mkTerm "exclusive_A" ;
lin exclusive_N = mkTerm "exclusive_N" ;
lin excogitate_V2 = mkTerm "excogitate_V2" ;
lin excogitation_N = mkTerm "excogitation_N" ;
lin excogitative_A = mkTerm "excogitative_A" ;
lin excogitator_N = mkTerm "excogitator_N" ;
lin excommunicate_V2 = mkTerm "excommunicate_V2" ;
lin excommunication_N = mkTerm "excommunication_N" ;
lin excoriate_V2 = mkTerm "excoriate_V2" ;
lin excoriation_N = mkTerm "excoriation_N" ;
lin excrement_N = mkTerm "excrement_N" ;
lin excrescence_N = mkTerm "excrescence_N" ;
lin excrescent_A = mkTerm "excrescent_A" ;
lin excrete_V2 = mkTerm "excrete_V2" ;
lin excretion_N = mkTerm "excretion_N" ;
lin excretory_A = mkTerm "excretory_A" ;
lin excruciating_A = mkTerm "excruciating_A" ;
lin exculpate_V2 = mkTerm "exculpate_V2" ;
lin exculpation_N = mkTerm "exculpation_N" ;
lin exculpatory_A = mkTerm "exculpatory_A" ;
lin excursion_N = mkTerm "excursion_N" ;
lin excursionist_N = mkTerm "excursionist_N" ;
lin excusable_A = mkTerm "excusable_A" ;
lin excuse_N = mkTerm "excuse_N" ;
lin excuse_V2 = mkTerm "excuse_V2" ;
lin excuse_me_Interj = mkTerm "excuse_me_Interj" ;
lin execrable_A = mkTerm "execrable_A" ;
lin execrate_V2 = mkTerm "execrate_V2" ;
lin execration_N = mkTerm "execration_N" ;
lin executability_N = mkTerm "executability_N" ;
lin executant_N = mkTerm "executant_N" ;
lin execute_V2 = mkTerm "execute_V2" ;
lin execution_N = mkTerm "execution_N" ;
lin executioner_N = mkTerm "executioner_N" ;
lin executive_A = mkTerm "executive_A" ;
lin executive_N = mkTerm "executive_N" ;
lin executor_N = mkTerm "executor_N" ;
lin executrix_N = mkTerm "executrix_N" ;
lin exegesis_N = mkTerm "exegesis_N" ;
lin exegete_N = mkTerm "exegete_N" ;
lin exegetic_A = mkTerm "exegetic_A" ;
lin exemplar_N = mkTerm "exemplar_N" ;
lin exemplary_A = mkTerm "exemplary_A" ;
lin exemplification_N = mkTerm "exemplification_N" ;
lin exemplify_V2 = mkTerm "exemplify_V2" ;
lin exemplifying_A = mkTerm "exemplifying_A" ;
lin exempt_A = mkTerm "exempt_A" ;
lin exempt_V2 = mkTerm "exempt_V2" ;
lin exempt_V2V = mkTerm "exempt_V2V" ;
lin exemption_N = mkTerm "exemption_N" ;
lin exenteration_N = mkTerm "exenteration_N" ;
lin exercise_N = mkTerm "exercise_N" ;
lin exercise_V = mkTerm "exercise_V" ;
lin exercise_V2 = mkTerm "exercise_V2" ;
lin exercise_VV = mkTerm "exercise_VV" ;
lin exergonic_A = mkTerm "exergonic_A" ;
lin exert_V2 = mkTerm "exert_V2" ;
lin exertion_N = mkTerm "exertion_N" ;
lin exeter_PN = mkTerm "exeter_PN" ;
lin exfoliation_N = mkTerm "exfoliation_N" ;
lin exhalation_N = mkTerm "exhalation_N" ;
lin exhale_V = mkTerm "exhale_V" ;
lin exhale_V2 = mkTerm "exhale_V2" ;
lin exhaust_N = mkTerm "exhaust_N" ;
lin exhaust_V2 = mkTerm "exhaust_V2" ;
lin exhaust_pipe_N = mkTerm "exhaust_pipe_N" ;
lin exhaustible_A = mkTerm "exhaustible_A" ;
lin exhausting_A = mkTerm "exhausting_A" ;
lin exhaustion_N = mkTerm "exhaustion_N" ;
lin exhaustive_A = mkTerm "exhaustive_A" ;
lin exhibit_N = mkTerm "exhibit_N" ;
lin exhibit_V2 = mkTerm "exhibit_V2" ;
lin exhibition_N = mkTerm "exhibition_N" ;
lin exhibitioner_N = mkTerm "exhibitioner_N" ;
lin exhibitionism_N = mkTerm "exhibitionism_N" ;
lin exhibitionist_N = mkTerm "exhibitionist_N" ;
lin exhibitionistic_A = mkTerm "exhibitionistic_A" ;
lin exhibitor_N = mkTerm "exhibitor_N" ;
lin exhilarate_V2 = mkTerm "exhilarate_V2" ;
lin exhilarating_A = mkTerm "exhilarating_A" ;
lin exhilaration_N = mkTerm "exhilaration_N" ;
lin exhort_V2 = mkTerm "exhort_V2" ;
lin exhortation_N = mkTerm "exhortation_N" ;
lin exhortative_A = mkTerm "exhortative_A" ;
lin exhumation_N = mkTerm "exhumation_N" ;
lin exhume_V2 = mkTerm "exhume_V2" ;
lin exigency_N = mkTerm "exigency_N" ;
lin exigent_A = mkTerm "exigent_A" ;
lin exiguous_A = mkTerm "exiguous_A" ;
lin exile_N = mkTerm "exile_N" ;
lin exile_V2 = mkTerm "exile_V2" ;
lin exilic_A = mkTerm "exilic_A" ;
lin exist_V = mkTerm "exist_V" ;
lin existence_N = mkTerm "existence_N" ;
lin existent_A = mkTerm "existent_A" ;
lin existential_A = mkTerm "existential_A" ;
lin existentialism_N = mkTerm "existentialism_N" ;
lin existentialist_A = mkTerm "existentialist_A" ;
lin existentialist_N = mkTerm "existentialist_N" ;
lin existing_A = mkTerm "existing_A" ;
lin exit_N = mkTerm "exit_N" ;
lin exit_V = mkTerm "exit_V" ;
lin exmouth_PN = mkTerm "exmouth_PN" ;
lin exobiology_N = mkTerm "exobiology_N" ;
lin exocentric_A = mkTerm "exocentric_A" ;
lin exocrine_A = mkTerm "exocrine_A" ;
lin exode_N = mkTerm "exode_N" ;
lin exodontic_A = mkTerm "exodontic_A" ;
lin exodontics_N = mkTerm "exodontics_N" ;
lin exodontist_N = mkTerm "exodontist_N" ;
lin exodus_N = mkTerm "exodus_N" ;
lin exoergic_A = mkTerm "exoergic_A" ;
lin exogamous_A = mkTerm "exogamous_A" ;
lin exogamy_N = mkTerm "exogamy_N" ;
lin exogenous_A = mkTerm "exogenous_A" ;
lin exomphalos_N = mkTerm "exomphalos_N" ;
lin exon_N = mkTerm "exon_N" ;
lin exonerate_V2 = mkTerm "exonerate_V2" ;
lin exoneration_N = mkTerm "exoneration_N" ;
lin exonuclease_N = mkTerm "exonuclease_N" ;
lin exophthalmos_N = mkTerm "exophthalmos_N" ;
lin exorbitance_N = mkTerm "exorbitance_N" ;
lin exorbitant_A = mkTerm "exorbitant_A" ;
lin exorcism_N = mkTerm "exorcism_N" ;
lin exorcist_N = mkTerm "exorcist_N" ;
lin exorcize_V2 = mkTerm "exorcize_V2" ;
lin exordium_N = mkTerm "exordium_N" ;
lin exoskeleton_N = mkTerm "exoskeleton_N" ;
lin exosphere_N = mkTerm "exosphere_N" ;
lin exostosis_N = mkTerm "exostosis_N" ;
lin exoteric_A = mkTerm "exoteric_A" ;
lin exotherm_N = mkTerm "exotherm_N" ;
lin exothermic_A = mkTerm "exothermic_A" ;
lin exotic_A = mkTerm "exotic_A" ;
lin exoticism_N = mkTerm "exoticism_N" ;
lin exotoxin_N = mkTerm "exotoxin_N" ;
lin expand_V = mkTerm "expand_V" ;
lin expand_V2 = mkTerm "expand_V2" ;
lin expandable_A = mkTerm "expandable_A" ;
lin expanse_N = mkTerm "expanse_N" ;
lin expansion_N = mkTerm "expansion_N" ;
lin expansionism_N = mkTerm "expansionism_N" ;
lin expansionist_A = mkTerm "expansionist_A" ;
lin expansive_A = mkTerm "expansive_A" ;
lin expansiveness_N = mkTerm "expansiveness_N" ;
lin expatiate_V = mkTerm "expatiate_V" ;
lin expatiation_N = mkTerm "expatiation_N" ;
lin expatriate_N = mkTerm "expatriate_N" ;
lin expatriate_V2 = mkTerm "expatriate_V2" ;
lin expect_V = mkTerm "expect_V" ;
lin expect_V2 = mkTerm "expect_V2" ;
lin expect_V2V = mkTerm "expect_V2V" ;
lin expect_VS = mkTerm "expect_VS" ;
lin expect_VV = mkTerm "expect_VV" ;
lin expectable_A = mkTerm "expectable_A" ;
lin expectancy_N = mkTerm "expectancy_N" ;
lin expectant_A = mkTerm "expectant_A" ;
lin expectation_N = mkTerm "expectation_N" ;
lin expected_A = mkTerm "expected_A" ;
lin expectedness_N = mkTerm "expectedness_N" ;
lin expectorant_N = mkTerm "expectorant_N" ;
lin expectorate_V = mkTerm "expectorate_V" ;
lin expectorate_V2 = mkTerm "expectorate_V2" ;
lin expectoration_N = mkTerm "expectoration_N" ;
lin expedience_N = mkTerm "expedience_N" ;
lin expediency_N = mkTerm "expediency_N" ;
lin expedient_A = mkTerm "expedient_A" ;
lin expedient_N = mkTerm "expedient_N" ;
lin expedite_V2 = mkTerm "expedite_V2" ;
lin expedition_N = mkTerm "expedition_N" ;
lin expeditionary_A = mkTerm "expeditionary_A" ;
lin expeditious_A = mkTerm "expeditious_A" ;
lin expel_V2 = mkTerm "expel_V2" ;
lin expend_V2 = mkTerm "expend_V2" ;
lin expendable_A = mkTerm "expendable_A" ;
lin expending_N = mkTerm "expending_N" ;
lin expenditure_N = mkTerm "expenditure_N" ;
lin expense_N = mkTerm "expense_N" ;
lin expensive_A = mkTerm "expensive_A" ;
lin expensiveness_N = mkTerm "expensiveness_N" ;
lin experience_N = mkTerm "experience_N" ;
lin experience_V2 = mkTerm "experience_V2" ;
lin experienced_A = mkTerm "experienced_A" ;
lin experiential_A = mkTerm "experiential_A" ;
lin experiment_N = mkTerm "experiment_N" ;
lin experiment_V = mkTerm "experiment_V" ;
lin experiment_V2 = mkTerm "experiment_V2" ;
lin experimental_A = mkTerm "experimental_A" ;
lin experimentalism_N = mkTerm "experimentalism_N" ;
lin experimentation_N = mkTerm "experimentation_N" ;
lin experimenterFem_N = mkTerm "experimenterFem_N" ;
lin experimenterMasc_N = mkTerm "experimenterMasc_N" ;
lin expert_A = mkTerm "expert_A" ;
lin expert_N = mkTerm "expert_N" ;
lin expertise_N = mkTerm "expertise_N" ;
lin expertness_N = mkTerm "expertness_N" ;
lin expiable_A = mkTerm "expiable_A" ;
lin expiate_V2 = mkTerm "expiate_V2" ;
lin expiation_N = mkTerm "expiation_N" ;
lin expiatory_A = mkTerm "expiatory_A" ;
lin expiration_N = mkTerm "expiration_N" ;
lin expiratory_A = mkTerm "expiratory_A" ;
lin expire_V = mkTerm "expire_V" ;
lin expire_V2 = mkTerm "expire_V2" ;
lin expire_VS = mkTerm "expire_VS" ;
lin expiry_N = mkTerm "expiry_N" ;
lin explain_V2 = mkTerm "explain_V2" ;
lin explain_VS = mkTerm "explain_VS" ;
lin explain_away_V = mkTerm "explain_away_V" ;
lin explainable_A = mkTerm "explainable_A" ;
lin explanans_N = mkTerm "explanans_N" ;
lin explanation_N = mkTerm "explanation_N" ;
lin explanatory_A = mkTerm "explanatory_A" ;
lin expletive_N = mkTerm "expletive_N" ;
lin explicable_A = mkTerm "explicable_A" ;
lin explicandum_N = mkTerm "explicandum_N" ;
lin explicate_V2 = mkTerm "explicate_V2" ;
lin explication_N = mkTerm "explication_N" ;
lin explicit_A = mkTerm "explicit_A" ;
lin explicitness_N = mkTerm "explicitness_N" ;
lin explode_V = mkTerm "explode_V" ;
lin exploit_N = mkTerm "exploit_N" ;
lin exploit_V2 = mkTerm "exploit_V2" ;
lin exploitation_N = mkTerm "exploitation_N" ;
lin exploitative_A = mkTerm "exploitative_A" ;
lin exploiter_N = mkTerm "exploiter_N" ;
lin exploration_N = mkTerm "exploration_N" ;
lin exploratory_A = mkTerm "exploratory_A" ;
lin explore_V2 = mkTerm "explore_V2" ;
lin explore_VS = mkTerm "explore_VS" ;
lin explorerFem_N = mkTerm "explorerFem_N" ;
lin explorerMasc_N = mkTerm "explorerMasc_N" ;
lin explosion_N = mkTerm "explosion_N" ;
lin explosive_A = mkTerm "explosive_A" ;
lin explosive_N = mkTerm "explosive_N" ;
lin expo_N = mkTerm "expo_N" ;
lin exponent_1_N = mkTerm "exponent_1_N" ;
lin exponent_2_N = mkTerm "exponent_2_N" ;
lin exponential_A = mkTerm "exponential_A" ;
lin exponential_N = mkTerm "exponential_N" ;
lin exponentiation_N = mkTerm "exponentiation_N" ;
lin export_N = mkTerm "export_N" ;
lin export_V = mkTerm "export_V" ;
lin export_V2 = mkTerm "export_V2" ;
lin exportable_A = mkTerm "exportable_A" ;
lin exportation_N = mkTerm "exportation_N" ;
lin exporterFem_N = mkTerm "exporterFem_N" ;
lin exporterMasc_N = mkTerm "exporterMasc_N" ;
lin exporting_N = mkTerm "exporting_N" ;
lin expose_N = mkTerm "expose_N" ;
lin expose_V = mkTerm "expose_V" ;
lin expose_V2 = mkTerm "expose_V2" ;
lin exposition_N = mkTerm "exposition_N" ;
lin expositor_N = mkTerm "expositor_N" ;
lin expository_A = mkTerm "expository_A" ;
lin expostulate_V = mkTerm "expostulate_V" ;
lin expostulation_N = mkTerm "expostulation_N" ;
lin exposure_N = mkTerm "exposure_N" ;
lin expound_V2 = mkTerm "expound_V2" ;
lin expound_VS = mkTerm "expound_VS" ;
lin express_A = mkTerm "express_A" ;
lin express_Adv = mkTerm "express_Adv" ;
lin express_N = mkTerm "express_N" ;
lin express_V2 = mkTerm "express_V2" ;
lin expressible_A = mkTerm "expressible_A" ;
lin expression_N = mkTerm "expression_N" ;
lin expressionism_N = mkTerm "expressionism_N" ;
lin expressionistFem_N = mkTerm "expressionistFem_N" ;
lin expressionistMasc_N = mkTerm "expressionistMasc_N" ;
lin expressionist_A = mkTerm "expressionist_A" ;
lin expressionless_A = mkTerm "expressionless_A" ;
lin expressive_A = mkTerm "expressive_A" ;
lin expressiveness_N = mkTerm "expressiveness_N" ;
lin expressway_N = mkTerm "expressway_N" ;
lin expropriate_V2 = mkTerm "expropriate_V2" ;
lin expropriation_N = mkTerm "expropriation_N" ;
lin expulsion_N = mkTerm "expulsion_N" ;
lin expunction_N = mkTerm "expunction_N" ;
lin expunge_V2 = mkTerm "expunge_V2" ;
lin expurgate_V2 = mkTerm "expurgate_V2" ;
lin expurgation_N = mkTerm "expurgation_N" ;
lin expurgator_N = mkTerm "expurgator_N" ;
lin exquisite_A = mkTerm "exquisite_A" ;
lin exquisiteness_N = mkTerm "exquisiteness_N" ;
lin extant_A = mkTerm "extant_A" ;
lin extemporaneous_A = mkTerm "extemporaneous_A" ;
lin extemporary_A = mkTerm "extemporary_A" ;
lin extempore_A = mkTerm "extempore_A" ;
lin extempore_Adv = mkTerm "extempore_Adv" ;
lin extemporization_N = mkTerm "extemporization_N" ;
lin extemporize_V = mkTerm "extemporize_V" ;
lin extemporize_V2 = mkTerm "extemporize_V2" ;
lin extend_V = mkTerm "extend_V" ;
lin extend_V2 = mkTerm "extend_V2" ;
lin extended_A = mkTerm "extended_A" ;
lin extendible_A = mkTerm "extendible_A" ;
lin extensile_A = mkTerm "extensile_A" ;
lin extension_N = mkTerm "extension_N" ;
lin extensional_A = mkTerm "extensional_A" ;
lin extensive_A = mkTerm "extensive_A" ;
lin extent_N = mkTerm "extent_N" ;
lin extenuate_V2 = mkTerm "extenuate_V2" ;
lin extenuating_A = mkTerm "extenuating_A" ;
lin extenuation_N = mkTerm "extenuation_N" ;
lin exterior_A = mkTerm "exterior_A" ;
lin exterior_N = mkTerm "exterior_N" ;
lin exteriorize_V2 = mkTerm "exteriorize_V2" ;
lin exterminable_A = mkTerm "exterminable_A" ;
lin exterminate_V2 = mkTerm "exterminate_V2" ;
lin extermination_N = mkTerm "extermination_N" ;
lin exterminator_N = mkTerm "exterminator_N" ;
lin extern_N = mkTerm "extern_N" ;
lin external_A = mkTerm "external_A" ;
lin external_N = mkTerm "external_N" ;
lin externalization_N = mkTerm "externalization_N" ;
lin externalize_V2 = mkTerm "externalize_V2" ;
lin exteroception_N = mkTerm "exteroception_N" ;
lin exteroceptive_A = mkTerm "exteroceptive_A" ;
lin exteroceptor_N = mkTerm "exteroceptor_N" ;
lin exterritorial_A = mkTerm "exterritorial_A" ;
lin extinct_A = mkTerm "extinct_A" ;
lin extinction_N = mkTerm "extinction_N" ;
lin extinguish_V2 = mkTerm "extinguish_V2" ;
lin extinguishable_A = mkTerm "extinguishable_A" ;
lin extinguisher_N = mkTerm "extinguisher_N" ;
lin extirpate_V2 = mkTerm "extirpate_V2" ;
lin extirpation_N = mkTerm "extirpation_N" ;
lin extol_V2 = mkTerm "extol_V2" ;
lin extort_V = mkTerm "extort_V" ;
lin extort_V2 = mkTerm "extort_V2" ;
lin extortion_N = mkTerm "extortion_N" ;
lin extortionate_A = mkTerm "extortionate_A" ;
lin extra_A = mkTerm "extra_A" ;
lin extra_Adv = mkTerm "extra_Adv" ;
lin extra_N = mkTerm "extra_N" ;
lin extracellular_A = mkTerm "extracellular_A" ;
lin extract_N = mkTerm "extract_N" ;
lin extract_V2 = mkTerm "extract_V2" ;
lin extractable_A = mkTerm "extractable_A" ;
lin extraction_N = mkTerm "extraction_N" ;
lin extractor_N = mkTerm "extractor_N" ;
lin extracurricular_A = mkTerm "extracurricular_A" ;
lin extradite_V2 = mkTerm "extradite_V2" ;
lin extradition_N = mkTerm "extradition_N" ;
lin extrados_N = mkTerm "extrados_N" ;
lin extragalactic_A = mkTerm "extragalactic_A" ;
lin extrajudicial_A = mkTerm "extrajudicial_A" ;
lin extralegal_A = mkTerm "extralegal_A" ;
lin extralinguistic_A = mkTerm "extralinguistic_A" ;
lin extramarital_A = mkTerm "extramarital_A" ;
lin extramural_A = mkTerm "extramural_A" ;
lin extraneous_A = mkTerm "extraneous_A" ;
lin extraneousness_N = mkTerm "extraneousness_N" ;
lin extraordinariness_N = mkTerm "extraordinariness_N" ;
lin extraordinary_A = mkTerm "extraordinary_A" ;
lin extrapolate_V = mkTerm "extrapolate_V" ;
lin extrapolate_V2 = mkTerm "extrapolate_V2" ;
lin extrapolation_N = mkTerm "extrapolation_N" ;
lin extrasensory_A = mkTerm "extrasensory_A" ;
lin extrasystole_N = mkTerm "extrasystole_N" ;
lin extrasystolic_A = mkTerm "extrasystolic_A" ;
lin extraterrestrial_A = mkTerm "extraterrestrial_A" ;
lin extraterritorial_A = mkTerm "extraterritorial_A" ;
lin extratropical_A = mkTerm "extratropical_A" ;
lin extravagance_N = mkTerm "extravagance_N" ;
lin extravagant_A = mkTerm "extravagant_A" ;
lin extravaganza_N = mkTerm "extravaganza_N" ;
lin extravasation_N = mkTerm "extravasation_N" ;
lin extraversion_N = mkTerm "extraversion_N" ;
lin extreme_A = mkTerm "extreme_A" ;
lin extreme_N = mkTerm "extreme_N" ;
lin extremeness_N = mkTerm "extremeness_N" ;
lin extremism_N = mkTerm "extremism_N" ;
lin extremist_A = mkTerm "extremist_A" ;
lin extremist_N = mkTerm "extremist_N" ;
lin extremity_N = mkTerm "extremity_N" ;
lin extremum_N = mkTerm "extremum_N" ;
lin extricable_A = mkTerm "extricable_A" ;
lin extricate_V2 = mkTerm "extricate_V2" ;
lin extrication_N = mkTerm "extrication_N" ;
lin extrinsic_A = mkTerm "extrinsic_A" ;
lin extropic_A = mkTerm "extropic_A" ;
lin extropy_N = mkTerm "extropy_N" ;
lin extrospective_A = mkTerm "extrospective_A" ;
lin extroversion_N = mkTerm "extroversion_N" ;
lin extroversive_A = mkTerm "extroversive_A" ;
lin extrovert_A = mkTerm "extrovert_A" ;
lin extrovert_N = mkTerm "extrovert_N" ;
lin extroverted_A = mkTerm "extroverted_A" ;
lin extrovertish_A = mkTerm "extrovertish_A" ;
lin extrude_V2 = mkTerm "extrude_V2" ;
lin extrusion_N = mkTerm "extrusion_N" ;
lin extrusive_A = mkTerm "extrusive_A" ;
lin exuberance_N = mkTerm "exuberance_N" ;
lin exuberant_A = mkTerm "exuberant_A" ;
lin exudate_N = mkTerm "exudate_N" ;
lin exudation_N = mkTerm "exudation_N" ;
lin exude_V = mkTerm "exude_V" ;
lin exude_V2 = mkTerm "exude_V2" ;
lin exult_V = mkTerm "exult_V" ;
lin exultant_A = mkTerm "exultant_A" ;
lin exultation_N = mkTerm "exultation_N" ;
lin exurbia_N = mkTerm "exurbia_N" ;
lin exuviae_N = mkTerm "exuviae_N" ;
lin exuvial_A = mkTerm "exuvial_A" ;
lin eyas_N = mkTerm "eyas_N" ;
lin eye_N = mkTerm "eye_N" ;
lin eye_V2 = mkTerm "eye_V2" ;
lin eye_catching_A = mkTerm "eye_catching_A" ;
lin eye_opener_N = mkTerm "eye_opener_N" ;
lin eye_shadow_N = mkTerm "eye_shadow_N" ;
lin eye_up_V2 = mkTerm "eye_up_V2" ;
lin eyeball_N = mkTerm "eyeball_N" ;
lin eyeball_V2 = mkTerm "eyeball_V2" ;
lin eyebath_N = mkTerm "eyebath_N" ;
lin eyebrow_N = mkTerm "eyebrow_N" ;
lin eyecatching_A = mkTerm "eyecatching_A" ;
lin eyecup_N = mkTerm "eyecup_N" ;
lin eyedness_N = mkTerm "eyedness_N" ;
lin eyedrop_N = mkTerm "eyedrop_N" ;
lin eyeful_N = mkTerm "eyeful_N" ;
lin eyeglass_N = mkTerm "eyeglass_N" ;
lin eyelash_N = mkTerm "eyelash_N" ;
lin eyeless_A = mkTerm "eyeless_A" ;
lin eyelessness_N = mkTerm "eyelessness_N" ;
lin eyelet_N = mkTerm "eyelet_N" ;
lin eyelid_N = mkTerm "eyelid_N" ;
lin eyelike_A = mkTerm "eyelike_A" ;
lin eyeliner_N = mkTerm "eyeliner_N" ;
lin eyepatch_N = mkTerm "eyepatch_N" ;
lin eyepiece_N = mkTerm "eyepiece_N" ;
lin eyes_N = mkTerm "eyes_N" ;
lin eyeshot_N = mkTerm "eyeshot_N" ;
lin eyesight_N = mkTerm "eyesight_N" ;
lin eyesore_N = mkTerm "eyesore_N" ;
lin eyespot_N = mkTerm "eyespot_N" ;
lin eyestrain_N = mkTerm "eyestrain_N" ;
lin eyetooth_N = mkTerm "eyetooth_N" ;
lin eyewash_N = mkTerm "eyewash_N" ;
lin eyewitness_N = mkTerm "eyewitness_N" ;
lin eyrie_N = mkTerm "eyrie_N" ;
lin eyrir_N = mkTerm "eyrir_N" ;
lin eyry_N = mkTerm "eyry_N" ;
lin fa_N = mkTerm "fa_N" ;
lin fab_A = mkTerm "fab_A" ;
lin fabian_A = mkTerm "fabian_A" ;
lin fabian_N = mkTerm "fabian_N" ;
lin fable_N = mkTerm "fable_N" ;
lin fabled_A = mkTerm "fabled_A" ;
lin fabric_N = mkTerm "fabric_N" ;
lin fabricate_V2 = mkTerm "fabricate_V2" ;
lin fabrication_N = mkTerm "fabrication_N" ;
lin fabulist_N = mkTerm "fabulist_N" ;
lin fabulous_A = mkTerm "fabulous_A" ;
lin facade_N = mkTerm "facade_N" ;
lin face_N = mkTerm "face_N" ;
lin face_V = mkTerm "face_V" ;
lin face_V2 = mkTerm "face_V2" ;
lin face_ache_N = mkTerm "face_ache_N" ;
lin face_card_N = mkTerm "face_card_N" ;
lin face_cloth_N = mkTerm "face_cloth_N" ;
lin face_cream_N = mkTerm "face_cream_N" ;
lin face_lift_N = mkTerm "face_lift_N" ;
lin face_lifting_N = mkTerm "face_lifting_N" ;
lin face_off_V2 = mkTerm "face_off_V2" ;
lin face_pack_N = mkTerm "face_pack_N" ;
lin face_powder_N = mkTerm "face_powder_N" ;
lin face_saver_N = mkTerm "face_saver_N" ;
lin face_saving_A = mkTerm "face_saving_A" ;
lin face_saving_N = mkTerm "face_saving_N" ;
lin face_up_to_V2 = mkTerm "face_up_to_V2" ;
lin faceless_A = mkTerm "faceless_A" ;
lin faceplate_N = mkTerm "faceplate_N" ;
lin facer_N = mkTerm "facer_N" ;
lin facet_N = mkTerm "facet_N" ;
lin faceted_A = mkTerm "faceted_A" ;
lin facetious_A = mkTerm "facetious_A" ;
lin facetiousness_N = mkTerm "facetiousness_N" ;
lin facia_N = mkTerm "facia_N" ;
lin facial_A = mkTerm "facial_A" ;
lin facial_N = mkTerm "facial_N" ;
lin facile_A = mkTerm "facile_A" ;
lin facilitate_V2 = mkTerm "facilitate_V2" ;
lin facilitation_N = mkTerm "facilitation_N" ;
lin facilitative_A = mkTerm "facilitative_A" ;
lin facilitator_N = mkTerm "facilitator_N" ;
lin facilitatory_A = mkTerm "facilitatory_A" ;
lin facility_N = mkTerm "facility_N" ;
lin facing_N = mkTerm "facing_N" ;
lin facsimile_N = mkTerm "facsimile_N" ;
lin fact_N = mkTerm "fact_N" ;
lin fact_finding_A = mkTerm "fact_finding_A" ;
lin faction_N = mkTerm "faction_N" ;
lin factious_A = mkTerm "factious_A" ;
lin factitious_A = mkTerm "factitious_A" ;
lin factoid_N = mkTerm "factoid_N" ;
lin factor_N = mkTerm "factor_N" ;
lin factor_in_V = mkTerm "factor_in_V" ;
lin factorial_A = mkTerm "factorial_A" ;
lin factorial_N = mkTerm "factorial_N" ;
lin factorization_N = mkTerm "factorization_N" ;
lin factorize_V2 = mkTerm "factorize_V2" ;
lin factory_N = mkTerm "factory_N" ;
lin factotum_N = mkTerm "factotum_N" ;
lin factual_A = mkTerm "factual_A" ;
lin factuality_N = mkTerm "factuality_N" ;
lin facula_N = mkTerm "facula_N" ;
lin facultative_A = mkTerm "facultative_A" ;
lin faculty_N = mkTerm "faculty_N" ;
lin fad_N = mkTerm "fad_N" ;
lin faddish_A = mkTerm "faddish_A" ;
lin faddist_N = mkTerm "faddist_N" ;
lin faddy_A = mkTerm "faddy_A" ;
lin fade_N = mkTerm "fade_N" ;
lin fade_V = mkTerm "fade_V" ;
lin fade_V2 = mkTerm "fade_V2" ;
lin fadeout_N = mkTerm "fadeout_N" ;
lin fado_N = mkTerm "fado_N" ;
lin faecal_A = mkTerm "faecal_A" ;
lin faerie_N = mkTerm "faerie_N" ;
lin faery_N = mkTerm "faery_N" ;
lin faff_about_V = mkTerm "faff_about_V" ;
lin faff_around_V = mkTerm "faff_around_V" ;
lin fag_N = mkTerm "fag_N" ;
lin fag_V = mkTerm "fag_V" ;
lin fag_V2 = mkTerm "fag_V2" ;
lin fag_end_N = mkTerm "fag_end_N" ;
lin faggot_N = mkTerm "faggot_N" ;
lin fagot_N = mkTerm "fagot_N" ;
lin fagoting_N = mkTerm "fagoting_N" ;
lin faience_N = mkTerm "faience_N" ;
lin fail_N = mkTerm "fail_N" ;
lin fail_V = mkTerm "fail_V" ;
lin fail_V2 = mkTerm "fail_V2" ;
lin fail_VV = mkTerm "fail_VV" ;
lin fail_safe_A = mkTerm "fail_safe_A" ;
lin failing_N = mkTerm "failing_N" ;
lin faille_N = mkTerm "faille_N" ;
lin failure_N = mkTerm "failure_N" ;
lin fain_Adv = mkTerm "fain_Adv" ;
lin faineance_N = mkTerm "faineance_N" ;
lin faineant_A = mkTerm "faineant_A" ;
lin faint_A = mkTerm "faint_A" ;
lin faint_N = mkTerm "faint_N" ;
lin faint_V = mkTerm "faint_V" ;
lin faint_hearted_A = mkTerm "faint_hearted_A" ;
lin faintheartedness_N = mkTerm "faintheartedness_N" ;
lin faintness_N = mkTerm "faintness_N" ;
lin fair_A = mkTerm "fair_A" ;
lin fair_N = mkTerm "fair_N" ;
lin fair_minded_A = mkTerm "fair_minded_A" ;
lin fairground_N = mkTerm "fairground_N" ;
lin fairish_A = mkTerm "fairish_A" ;
lin fairlead_N = mkTerm "fairlead_N" ;
lin fairly_Adv = mkTerm "fairly_Adv" ;
lin fairness_N = mkTerm "fairness_N" ;
lin fairway_N = mkTerm "fairway_N" ;
lin fairy_N = mkTerm "fairy_N" ;
lin fairyland_N = mkTerm "fairyland_N" ;
lin fairytale_N = mkTerm "fairytale_N" ;
lin fait_accompli_N = mkTerm "fait_accompli_N" ;
lin faith_N = mkTerm "faith_N" ;
lin faith_healing_N = mkTerm "faith_healing_N" ;
lin faithful_A = mkTerm "faithful_A" ;
lin faithful_N = mkTerm "faithful_N" ;
lin faithfulness_N = mkTerm "faithfulness_N" ;
lin faithless_A = mkTerm "faithless_A" ;
lin faithlessness_N = mkTerm "faithlessness_N" ;
lin fake_A = mkTerm "fake_A" ;
lin fake_N = mkTerm "fake_N" ;
lin fake_V2 = mkTerm "fake_V2" ;
lin fakery_N = mkTerm "fakery_N" ;
lin fakir_N = mkTerm "fakir_N" ;
lin falafel_N = mkTerm "falafel_N" ;
lin falangist_N = mkTerm "falangist_N" ;
lin falcate_A = mkTerm "falcate_A" ;
lin falchion_N = mkTerm "falchion_N" ;
lin falcon_N = mkTerm "falcon_N" ;
lin falconer_N = mkTerm "falconer_N" ;
lin falconine_A = mkTerm "falconine_A" ;
lin falconry_N = mkTerm "falconry_N" ;
lin falkirk_PN = mkTerm "falkirk_PN" ;
lin fall_1_N = mkTerm "fall_1_N" ;
lin fall_2_N = mkTerm "fall_2_N" ;
lin fall_V = mkTerm "fall_V" ;
lin fall_about_V = mkTerm "fall_about_V" ;
lin fall_apart_V = mkTerm "fall_apart_V" ;
lin fall_back_V = mkTerm "fall_back_V" ;
lin fall_back_on_V2 = mkTerm "fall_back_on_V2" ;
lin fall_behind_V = mkTerm "fall_behind_V" ;
lin fall_behind_in_V2 = mkTerm "fall_behind_in_V2" ;
lin fall_down_V = mkTerm "fall_down_V" ;
lin fall_for_V2 = mkTerm "fall_for_V2" ;
lin fall_in_V = mkTerm "fall_in_V" ;
lin fall_into_V2 = mkTerm "fall_into_V2" ;
lin fall_off_V = mkTerm "fall_off_V" ;
lin fall_out_V = mkTerm "fall_out_V" ;
lin fall_out_with_V2 = mkTerm "fall_out_with_V2" ;
lin fall_over_V = mkTerm "fall_over_V" ;
lin fall_through_V = mkTerm "fall_through_V" ;
lin fall_under_V2 = mkTerm "fall_under_V2" ;
lin fallacious_A = mkTerm "fallacious_A" ;
lin fallaciousness_N = mkTerm "fallaciousness_N" ;
lin fallacy_N = mkTerm "fallacy_N" ;
lin fallboard_N = mkTerm "fallboard_N" ;
lin faller_N = mkTerm "faller_N" ;
lin fallibility_N = mkTerm "fallibility_N" ;
lin fallible_A = mkTerm "fallible_A" ;
lin fallopian_A = mkTerm "fallopian_A" ;
lin fallout_N = mkTerm "fallout_N" ;
lin fallow_A = mkTerm "fallow_A" ;
lin fallow_N = mkTerm "fallow_N" ;
lin fallow_deer_N = mkTerm "fallow_deer_N" ;
lin falls_N = mkTerm "falls_N" ;
lin falmouth_PN = mkTerm "falmouth_PN" ;
lin false_A = mkTerm "false_A" ;
lin false_Adv = mkTerm "false_Adv" ;
lin falsehood_N = mkTerm "falsehood_N" ;
lin falseness_N = mkTerm "falseness_N" ;
lin falsetto_A = mkTerm "falsetto_A" ;
lin falsetto_N = mkTerm "falsetto_N" ;
lin falsie_N = mkTerm "falsie_N" ;
lin falsification_N = mkTerm "falsification_N" ;
lin falsifier_N = mkTerm "falsifier_N" ;
lin falsify_V2 = mkTerm "falsify_V2" ;
lin falsity_N = mkTerm "falsity_N" ;
lin falter_V = mkTerm "falter_V" ;
lin falter_V2 = mkTerm "falter_V2" ;
lin falteringly_Adv = mkTerm "falteringly_Adv" ;
lin fame_N = mkTerm "fame_N" ;
lin fame_V2 = mkTerm "fame_V2" ;
lin familial_A = mkTerm "familial_A" ;
lin familiar_A = mkTerm "familiar_A" ;
lin familiar_N = mkTerm "familiar_N" ;
lin familiar_with_A2 = mkTerm "familiar_with_A2" ;
lin familiarity_N = mkTerm "familiarity_N" ;
lin familiarization_N = mkTerm "familiarization_N" ;
lin familiarize_V2 = mkTerm "familiarize_V2" ;
lin familiarizing_A = mkTerm "familiarizing_A" ;
lin family_N = mkTerm "family_N" ;
lin famine_N = mkTerm "famine_N" ;
lin famish_V = mkTerm "famish_V" ;
lin famish_V2 = mkTerm "famish_V2" ;
lin famotidine_N = mkTerm "famotidine_N" ;
lin famous_A = mkTerm "famous_A" ;
lin famulus_N = mkTerm "famulus_N" ;
lin fan_1_N = mkTerm "fan_1_N" ;
lin fan_2_N = mkTerm "fan_2_N" ;
lin fan_3_N = mkTerm "fan_3_N" ;
lin fan_V = mkTerm "fan_V" ;
lin fan_V2 = mkTerm "fan_V2" ;
lin fan_belt_N = mkTerm "fan_belt_N" ;
lin fanaloka_N = mkTerm "fanaloka_N" ;
lin fanaticFem_N = mkTerm "fanaticFem_N" ;
lin fanaticMasc_N = mkTerm "fanaticMasc_N" ;
lin fanatic_A = mkTerm "fanatic_A" ;
lin fanatical_A = mkTerm "fanatical_A" ;
lin fanaticism_N = mkTerm "fanaticism_N" ;
lin fanbase_N = mkTerm "fanbase_N" ;
lin fancier_N = mkTerm "fancier_N" ;
lin fanciful_A = mkTerm "fanciful_A" ;
lin fancy_A = mkTerm "fancy_A" ;
lin fancy_N = mkTerm "fancy_N" ;
lin fancy_V2 = mkTerm "fancy_V2" ;
lin fancy_free_A = mkTerm "fancy_free_A" ;
lin fandango_N = mkTerm "fandango_N" ;
lin fandom_A = mkTerm "fandom_A" ;
lin fandom_N = mkTerm "fandom_N" ;
lin fanfare_N = mkTerm "fanfare_N" ;
lin fang_N = mkTerm "fang_N" ;
lin fanged_A = mkTerm "fanged_A" ;
lin fanion_N = mkTerm "fanion_N" ;
lin fanjet_N = mkTerm "fanjet_N" ;
lin fanlight_N = mkTerm "fanlight_N" ;
lin fanlike_A = mkTerm "fanlike_A" ;
lin fanny_N = mkTerm "fanny_N" ;
lin fanny_PN = mkTerm "fanny_PN" ;
lin fansite_N = mkTerm "fansite_N" ;
lin fantail_N = mkTerm "fantail_N" ;
lin fantan_N = mkTerm "fantan_N" ;
lin fantasia_N = mkTerm "fantasia_N" ;
lin fantasist_N = mkTerm "fantasist_N" ;
lin fantasize_V = mkTerm "fantasize_V" ;
lin fantast_N = mkTerm "fantast_N" ;
lin fantastic_A = mkTerm "fantastic_A" ;
lin fantastically_Adv = mkTerm "fantastically_Adv" ;
lin fantasy_N = mkTerm "fantasy_N" ;
lin fantods_N = mkTerm "fantods_N" ;
lin fao_N = mkTerm "fao_N" ;
lin far_A = mkTerm "far_A" ;
lin far_AdA = mkTerm "far_AdA" ;
lin far_V2 = mkTerm "far_V2" ;
lin far_famed_A = mkTerm "far_famed_A" ;
lin far_fetched_A = mkTerm "far_fetched_A" ;
lin far_flung_A = mkTerm "far_flung_A" ;
lin far_from_Prep = mkTerm "far_from_Prep" ;
lin far_off_A = mkTerm "far_off_A" ;
lin far_reaching_A = mkTerm "far_reaching_A" ;
lin far_seeing_A = mkTerm "far_seeing_A" ;
lin far_sighted_A = mkTerm "far_sighted_A" ;
lin farad_N = mkTerm "farad_N" ;
lin farandole_N = mkTerm "farandole_N" ;
lin faraway_A = mkTerm "faraway_A" ;
lin farce_N = mkTerm "farce_N" ;
lin farcical_A = mkTerm "farcical_A" ;
lin fardel_N = mkTerm "fardel_N" ;
lin fare_N = mkTerm "fare_N" ;
lin fare_V = mkTerm "fare_V" ;
lin fare_stage_N = mkTerm "fare_stage_N" ;
lin farewell_N = mkTerm "farewell_N" ;
lin farfalle_N = mkTerm "farfalle_N" ;
lin farina_N = mkTerm "farina_N" ;
lin farinaceous_A = mkTerm "farinaceous_A" ;
lin farkleberry_N = mkTerm "farkleberry_N" ;
lin farm_N = mkTerm "farm_N" ;
lin farm_V = mkTerm "farm_V" ;
lin farm_V2 = mkTerm "farm_V2" ;
lin farm_out_V2 = mkTerm "farm_out_V2" ;
lin farmer_N = mkTerm "farmer_N" ;
lin farmerette_N = mkTerm "farmerette_N" ;
lin farmhand_N = mkTerm "farmhand_N" ;
lin farmhouse_N = mkTerm "farmhouse_N" ;
lin farming_N = mkTerm "farming_N" ;
lin farmland_N = mkTerm "farmland_N" ;
lin farmplace_N = mkTerm "farmplace_N" ;
lin farmstead_N = mkTerm "farmstead_N" ;
lin farmyard_N = mkTerm "farmyard_N" ;
lin farness_N = mkTerm "farness_N" ;
lin farnham_PN = mkTerm "farnham_PN" ;
lin farnworth_PN = mkTerm "farnworth_PN" ;
lin faro_N = mkTerm "faro_N" ;
lin farrago_N = mkTerm "farrago_N" ;
lin farrier_N = mkTerm "farrier_N" ;
lin farrow_N = mkTerm "farrow_N" ;
lin farrow_V = mkTerm "farrow_V" ;
lin farsi_N = mkTerm "farsi_N" ;
lin fart_N = mkTerm "fart_N" ;
lin fart_V = mkTerm "fart_V" ;
lin fart_about_V = mkTerm "fart_about_V" ;
lin fart_around_V = mkTerm "fart_around_V" ;
lin farther_A = mkTerm "farther_A" ;
lin farther_Adv = mkTerm "farther_Adv" ;
lin farthermost_A = mkTerm "farthermost_A" ;
lin farthest_Adv = mkTerm "farthest_Adv" ;
lin farthing_N = mkTerm "farthing_N" ;
lin farthingale_N = mkTerm "farthingale_N" ;
lin fartlek_N = mkTerm "fartlek_N" ;
lin fasces_N = mkTerm "fasces_N" ;
lin fascia_N = mkTerm "fascia_N" ;
lin fascicle_N = mkTerm "fascicle_N" ;
lin fasciculation_N = mkTerm "fasciculation_N" ;
lin fascinate_V2 = mkTerm "fascinate_V2" ;
lin fascinating_A = mkTerm "fascinating_A" ;
lin fascination_N = mkTerm "fascination_N" ;
lin fascioliasis_N = mkTerm "fascioliasis_N" ;
lin fasciolopsiasis_N = mkTerm "fasciolopsiasis_N" ;
lin fascism_N = mkTerm "fascism_N" ;
lin fascist_A = mkTerm "fascist_A" ;
lin fascist_N = mkTerm "fascist_N" ;
lin fascista_N = mkTerm "fascista_N" ;
lin fashion_N = mkTerm "fashion_N" ;
lin fashion_V2 = mkTerm "fashion_V2" ;
lin fashionable_A = mkTerm "fashionable_A" ;
lin fast_A = mkTerm "fast_A" ;
lin fast_N = mkTerm "fast_N" ;
lin fast_V = mkTerm "fast_V" ;
lin fastball_N = mkTerm "fastball_N" ;
lin fasten_V = mkTerm "fasten_V" ;
lin fasten_V2 = mkTerm "fasten_V2" ;
lin fasten_down_V2 = mkTerm "fasten_down_V2" ;
lin fasten_on_V2 = mkTerm "fasten_on_V2" ;
lin fasten_onto_V2 = mkTerm "fasten_onto_V2" ;
lin fasten_up_V2 = mkTerm "fasten_up_V2" ;
lin fastener_N = mkTerm "fastener_N" ;
lin fastening_N = mkTerm "fastening_N" ;
lin fastidious_A = mkTerm "fastidious_A" ;
lin fastidiousness_N = mkTerm "fastidiousness_N" ;
lin fastigiate_A = mkTerm "fastigiate_A" ;
lin fastnacht_N = mkTerm "fastnacht_N" ;
lin fastness_N = mkTerm "fastness_N" ;
lin fat_A = mkTerm "fat_A" ;
lin fat_N = mkTerm "fat_N" ;
lin fat_V2 = mkTerm "fat_V2" ;
lin fatal_A = mkTerm "fatal_A" ;
lin fatalism_N = mkTerm "fatalism_N" ;
lin fatalistFem_N = mkTerm "fatalistFem_N" ;
lin fatalistMasc_N = mkTerm "fatalistMasc_N" ;
lin fatalist_A = mkTerm "fatalist_A" ;
lin fatalistic_A = mkTerm "fatalistic_A" ;
lin fatality_N = mkTerm "fatality_N" ;
lin fatback_N = mkTerm "fatback_N" ;
lin fate_N = mkTerm "fate_N" ;
lin fate_V2 = mkTerm "fate_V2" ;
lin fateful_A = mkTerm "fateful_A" ;
lin fathead_N = mkTerm "fathead_N" ;
lin father_N = mkTerm "father_N" ;
lin father_V2 = mkTerm "father_V2" ;
lin father_in_law_N = mkTerm "father_in_law_N" ;
lin fatherhood_N = mkTerm "fatherhood_N" ;
lin fatherland_N = mkTerm "fatherland_N" ;
lin fatherless_A = mkTerm "fatherless_A" ;
lin fatherliness_N = mkTerm "fatherliness_N" ;
lin fatherly_A = mkTerm "fatherly_A" ;
lin fathom_N = mkTerm "fathom_N" ;
lin fathom_V2 = mkTerm "fathom_V2" ;
lin fathom_out_V2 = mkTerm "fathom_out_V2" ;
lin fathomable_A = mkTerm "fathomable_A" ;
lin fathomless_A = mkTerm "fathomless_A" ;
lin fatigability_N = mkTerm "fatigability_N" ;
lin fatigue_N = mkTerm "fatigue_N" ;
lin fatigue_V2 = mkTerm "fatigue_V2" ;
lin fatigue_party_N = mkTerm "fatigue_party_N" ;
lin fatigues_N = mkTerm "fatigues_N" ;
lin fatless_A = mkTerm "fatless_A" ;
lin fatness_N = mkTerm "fatness_N" ;
lin fatso_N = mkTerm "fatso_N" ;
lin fatten_V = mkTerm "fatten_V" ;
lin fatten_V2 = mkTerm "fatten_V2" ;
lin fatten_up_V2 = mkTerm "fatten_up_V2" ;
lin fattish_A = mkTerm "fattish_A" ;
lin fattism_N = mkTerm "fattism_N" ;
lin fatty_A = mkTerm "fatty_A" ;
lin fatuity_N = mkTerm "fatuity_N" ;
lin fatuous_A = mkTerm "fatuous_A" ;
lin fatuousness_N = mkTerm "fatuousness_N" ;
lin fatwa_N = mkTerm "fatwa_N" ;
lin fatwah_N = mkTerm "fatwah_N" ;
lin faubourg_N = mkTerm "faubourg_N" ;
lin faucal_A = mkTerm "faucal_A" ;
lin fauces_N = mkTerm "fauces_N" ;
lin faucet_N = mkTerm "faucet_N" ;
lin fauld_N = mkTerm "fauld_N" ;
lin fauldhouse_PN = mkTerm "fauldhouse_PN" ;
lin fault_N = mkTerm "fault_N" ;
lin fault_V2 = mkTerm "fault_V2" ;
lin fault_finder_N = mkTerm "fault_finder_N" ;
lin fault_finding_N = mkTerm "fault_finding_N" ;
lin faultless_A = mkTerm "faultless_A" ;
lin faultlessness_N = mkTerm "faultlessness_N" ;
lin faulty_A = mkTerm "faulty_A" ;
lin faun_N = mkTerm "faun_N" ;
lin fauna_N = mkTerm "fauna_N" ;
lin fauteuil_N = mkTerm "fauteuil_N" ;
lin fauvism_N = mkTerm "fauvism_N" ;
lin faux_pas_N = mkTerm "faux_pas_N" ;
lin faversham_PN = mkTerm "faversham_PN" ;
lin favism_N = mkTerm "favism_N" ;
lin favour_N = mkTerm "favour_N" ;
lin favour_V = mkTerm "favour_V" ;
lin favour_V2 = mkTerm "favour_V2" ;
lin favour_VS = mkTerm "favour_VS" ;
lin favourable_A = mkTerm "favourable_A" ;
lin favourableness_N = mkTerm "favourableness_N" ;
lin favoured_A = mkTerm "favoured_A" ;
lin favouriteFem_N = mkTerm "favouriteFem_N" ;
lin favouriteMasc_N = mkTerm "favouriteMasc_N" ;
lin favourite_A = mkTerm "favourite_A" ;
lin favouritism_N = mkTerm "favouritism_N" ;
lin favus_N = mkTerm "favus_N" ;
lin fawley_PN = mkTerm "fawley_PN" ;
lin fawn_N = mkTerm "fawn_N" ;
lin fawn_V = mkTerm "fawn_V" ;
lin fawn_on_V2 = mkTerm "fawn_on_V2" ;
lin fawn_over_V2 = mkTerm "fawn_over_V2" ;
lin fax_N = mkTerm "fax_N" ;
lin fbi_PN = mkTerm "fbi_PN" ;
lin fealty_N = mkTerm "fealty_N" ;
lin fear_N = mkTerm "fear_N" ;
lin fear_V = mkTerm "fear_V" ;
lin fear_V2 = mkTerm "fear_V2" ;
lin fear_VS = mkTerm "fear_VS" ;
lin fearful_A = mkTerm "fearful_A" ;
lin fearfulness_N = mkTerm "fearfulness_N" ;
lin fearless_A = mkTerm "fearless_A" ;
lin fearlessness_N = mkTerm "fearlessness_N" ;
lin fearsome_A = mkTerm "fearsome_A" ;
lin feasibility_N = mkTerm "feasibility_N" ;
lin feasible_A = mkTerm "feasible_A" ;
lin feast_N = mkTerm "feast_N" ;
lin feast_V = mkTerm "feast_V" ;
lin feast_V2 = mkTerm "feast_V2" ;
lin feast_day_N = mkTerm "feast_day_N" ;
lin feasting_N = mkTerm "feasting_N" ;
lin feat_N = mkTerm "feat_N" ;
lin feather_N = mkTerm "feather_N" ;
lin feather_V2 = mkTerm "feather_V2" ;
lin feather_boa_N = mkTerm "feather_boa_N" ;
lin featherbed_N = mkTerm "featherbed_N" ;
lin featherbed_V2 = mkTerm "featherbed_V2" ;
lin featherbedding_N = mkTerm "featherbedding_N" ;
lin featherbrained_A = mkTerm "featherbrained_A" ;
lin featheredge_N = mkTerm "featheredge_N" ;
lin featherfoil_N = mkTerm "featherfoil_N" ;
lin featherlike_A = mkTerm "featherlike_A" ;
lin featherstone_PN = mkTerm "featherstone_PN" ;
lin feathertop_N = mkTerm "feathertop_N" ;
lin featherweight_N = mkTerm "featherweight_N" ;
lin feathery_A = mkTerm "feathery_A" ;
lin feature_N = mkTerm "feature_N" ;
lin feature_V2 = mkTerm "feature_V2" ;
lin featureless_A = mkTerm "featureless_A" ;
lin feb_PN = mkTerm "feb_PN" ;
lin febrile_A = mkTerm "febrile_A" ;
lin feckless_A = mkTerm "feckless_A" ;
lin fecklessness_N = mkTerm "fecklessness_N" ;
lin fecula_N = mkTerm "fecula_N" ;
lin feculence_N = mkTerm "feculence_N" ;
lin feculent_A = mkTerm "feculent_A" ;
lin fecund_A = mkTerm "fecund_A" ;
lin fecundity_N = mkTerm "fecundity_N" ;
lin fed_N = mkTerm "fed_N" ;
lin fed_up_V = mkTerm "fed_up_V" ;
lin fedayeen_N = mkTerm "fedayeen_N" ;
lin fedelline_N = mkTerm "fedelline_N" ;
lin federal_A = mkTerm "federal_A" ;
lin federalism_N = mkTerm "federalism_N" ;
lin federalist_N = mkTerm "federalist_N" ;
lin federalization_N = mkTerm "federalization_N" ;
lin federate_A = mkTerm "federate_A" ;
lin federate_V = mkTerm "federate_V" ;
lin federate_V2 = mkTerm "federate_V2" ;
lin federation_N = mkTerm "federation_N" ;
lin fedora_N = mkTerm "fedora_N" ;
lin fee_N = mkTerm "fee_N" ;
lin fee_V2 = mkTerm "fee_V2" ;
lin feeble_A = mkTerm "feeble_A" ;
lin feeble_minded_A = mkTerm "feeble_minded_A" ;
lin feeblemindedness_N = mkTerm "feeblemindedness_N" ;
lin feebleness_N = mkTerm "feebleness_N" ;
lin feed_N = mkTerm "feed_N" ;
lin feed_V = mkTerm "feed_V" ;
lin feed_V2 = mkTerm "feed_V2" ;
lin feed_off_V2 = mkTerm "feed_off_V2" ;
lin feed_on_V2 = mkTerm "feed_on_V2" ;
lin feed_up_V2 = mkTerm "feed_up_V2" ;
lin feedback_N = mkTerm "feedback_N" ;
lin feeder_N = mkTerm "feeder_N" ;
lin feeding_N = mkTerm "feeding_N" ;
lin feeding_bottle_N = mkTerm "feeding_bottle_N" ;
lin feedlot_N = mkTerm "feedlot_N" ;
lin feedstock_N = mkTerm "feedstock_N" ;
lin feel_N = mkTerm "feel_N" ;
lin feel_V = mkTerm "feel_V" ;
lin feel_V2 = mkTerm "feel_V2" ;
lin feel_VA = mkTerm "feel_VA" ;
lin feel_VS = mkTerm "feel_VS" ;
lin feel_out_V = mkTerm "feel_out_V" ;
lin feel_up_V2 = mkTerm "feel_up_V2" ;
lin feel_up_to_V2 = mkTerm "feel_up_to_V2" ;
lin feeler_N = mkTerm "feeler_N" ;
lin feeling_N = mkTerm "feeling_N" ;
lin feelingly_Adv = mkTerm "feelingly_Adv" ;
lin feelings_N = mkTerm "feelings_N" ;
lin feetfirst_Adv = mkTerm "feetfirst_Adv" ;
lin feign_V2 = mkTerm "feign_V2" ;
lin feijoa_N = mkTerm "feijoa_N" ;
lin feint_N = mkTerm "feint_N" ;
lin feint_V = mkTerm "feint_V" ;
lin feist_N = mkTerm "feist_N" ;
lin feisty_A = mkTerm "feisty_A" ;
lin feldspar_N = mkTerm "feldspar_N" ;
lin felicitate_V2 = mkTerm "felicitate_V2" ;
lin felicitation_N = mkTerm "felicitation_N" ;
lin felicitous_A = mkTerm "felicitous_A" ;
lin felicity_N = mkTerm "felicity_N" ;
lin felicity_PN = mkTerm "felicity_PN" ;
lin feline_A = mkTerm "feline_A" ;
lin feline_N = mkTerm "feline_N" ;
lin felix_PN = mkTerm "felix_PN" ;
lin felixstowe_PN = mkTerm "felixstowe_PN" ;
lin fell_A = mkTerm "fell_A" ;
lin fell_N = mkTerm "fell_N" ;
lin fell_V2 = mkTerm "fell_V2" ;
lin fell_apart_V = mkTerm "fell_apart_V" ;
lin fell_off_V = mkTerm "fell_off_V" ;
lin fell_through_V = mkTerm "fell_through_V" ;
lin fellah_N = mkTerm "fellah_N" ;
lin fellatio_N = mkTerm "fellatio_N" ;
lin felloe_N = mkTerm "felloe_N" ;
lin fellow_A = mkTerm "fellow_A" ;
lin fellow_N = mkTerm "fellow_N" ;
lin fellow_feeling_N = mkTerm "fellow_feeling_N" ;
lin fellow_traveller_N = mkTerm "fellow_traveller_N" ;
lin fellowship_N = mkTerm "fellowship_N" ;
lin felon_N = mkTerm "felon_N" ;
lin felonious_A = mkTerm "felonious_A" ;
lin felony_N = mkTerm "felony_N" ;
lin felspar_N = mkTerm "felspar_N" ;
lin felt_N = mkTerm "felt_N" ;
lin felted_A = mkTerm "felted_A" ;
lin felucca_N = mkTerm "felucca_N" ;
lin felwort_N = mkTerm "felwort_N" ;
lin fem_PN = mkTerm "fem_PN" ;
lin female_A = mkTerm "female_A" ;
lin female_N = mkTerm "female_N" ;
lin femaleness_N = mkTerm "femaleness_N" ;
lin feminine_A = mkTerm "feminine_A" ;
lin feminine_N = mkTerm "feminine_N" ;
lin femininity_N = mkTerm "femininity_N" ;
lin feminism_N = mkTerm "feminism_N" ;
lin feministFem_N = mkTerm "feministFem_N" ;
lin feministMasc_N = mkTerm "feministMasc_N" ;
lin feminist_A = mkTerm "feminist_A" ;
lin feminization_N = mkTerm "feminization_N" ;
lin femoral_A = mkTerm "femoral_A" ;
lin femtochemistry_N = mkTerm "femtochemistry_N" ;
lin femtometer_N = mkTerm "femtometer_N" ;
lin femtosecond_N = mkTerm "femtosecond_N" ;
lin femtovolt_N = mkTerm "femtovolt_N" ;
lin femur_N = mkTerm "femur_N" ;
lin fen_N = mkTerm "fen_N" ;
lin fence_N = mkTerm "fence_N" ;
lin fence_V2 = mkTerm "fence_V2" ;
lin fence_in_V2 = mkTerm "fence_in_V2" ;
lin fence_off_V2 = mkTerm "fence_off_V2" ;
lin fencelike_A = mkTerm "fencelike_A" ;
lin fencer_N = mkTerm "fencer_N" ;
lin fencing_N = mkTerm "fencing_N" ;
lin fend_V = mkTerm "fend_V" ;
lin fend_V2 = mkTerm "fend_V2" ;
lin fend_for_V2 = mkTerm "fend_for_V2" ;
lin fend_off_V2 = mkTerm "fend_off_V2" ;
lin fender_N = mkTerm "fender_N" ;
lin fenestra_N = mkTerm "fenestra_N" ;
lin fenestral_A = mkTerm "fenestral_A" ;
lin fenestration_N = mkTerm "fenestration_N" ;
lin fennel_N = mkTerm "fennel_N" ;
lin fenoprofen_N = mkTerm "fenoprofen_N" ;
lin fenugreek_N = mkTerm "fenugreek_N" ;
lin feoff_N = mkTerm "feoff_N" ;
lin feral_A = mkTerm "feral_A" ;
lin fergusonite_N = mkTerm "fergusonite_N" ;
lin feria_N = mkTerm "feria_N" ;
lin ferial_A = mkTerm "ferial_A" ;
lin fermanagh_PN = mkTerm "fermanagh_PN" ;
lin fermata_N = mkTerm "fermata_N" ;
lin ferment_N = mkTerm "ferment_N" ;
lin ferment_V = mkTerm "ferment_V" ;
lin ferment_V2 = mkTerm "ferment_V2" ;
lin fermentable_A = mkTerm "fermentable_A" ;
lin fermentation_N = mkTerm "fermentation_N" ;
lin fermion_N = mkTerm "fermion_N" ;
lin fermium_N = mkTerm "fermium_N" ;
lin fern_N = mkTerm "fern_N" ;
lin ferned_A = mkTerm "ferned_A" ;
lin fernless_A = mkTerm "fernless_A" ;
lin fernlike_A = mkTerm "fernlike_A" ;
lin ferny_A = mkTerm "ferny_A" ;
lin ferocious_A = mkTerm "ferocious_A" ;
lin ferociousness_N = mkTerm "ferociousness_N" ;
lin ferocity_N = mkTerm "ferocity_N" ;
lin ferrara_PN = mkTerm "ferrara_PN" ;
lin ferret_N = mkTerm "ferret_N" ;
lin ferret_V = mkTerm "ferret_V" ;
lin ferret_V2 = mkTerm "ferret_V2" ;
lin ferret_out_V2 = mkTerm "ferret_out_V2" ;
lin ferric_A = mkTerm "ferric_A" ;
lin ferricyanide_N = mkTerm "ferricyanide_N" ;
lin ferrimagnetism_N = mkTerm "ferrimagnetism_N" ;
lin ferris_wheel_N = mkTerm "ferris_wheel_N" ;
lin ferrite_N = mkTerm "ferrite_N" ;
lin ferritin_N = mkTerm "ferritin_N" ;
lin ferrocerium_N = mkTerm "ferrocerium_N" ;
lin ferroconcrete_N = mkTerm "ferroconcrete_N" ;
lin ferrocyanide_N = mkTerm "ferrocyanide_N" ;
lin ferromagnetic_A = mkTerm "ferromagnetic_A" ;
lin ferromagnetism_N = mkTerm "ferromagnetism_N" ;
lin ferrous_A = mkTerm "ferrous_A" ;
lin ferrule_N = mkTerm "ferrule_N" ;
lin ferry_N = mkTerm "ferry_N" ;
lin ferry_V = mkTerm "ferry_V" ;
lin ferry_V2 = mkTerm "ferry_V2" ;
lin ferryboat_N = mkTerm "ferryboat_N" ;
lin ferryhill_PN = mkTerm "ferryhill_PN" ;
lin ferryman_N = mkTerm "ferryman_N" ;
lin fertile_A = mkTerm "fertile_A" ;
lin fertility_N = mkTerm "fertility_N" ;
lin fertilizable_A = mkTerm "fertilizable_A" ;
lin fertilization_N = mkTerm "fertilization_N" ;
lin fertilize_V2 = mkTerm "fertilize_V2" ;
lin fertilizer_N = mkTerm "fertilizer_N" ;
lin ferule_N = mkTerm "ferule_N" ;
lin fervency_N = mkTerm "fervency_N" ;
lin fervent_A = mkTerm "fervent_A" ;
lin fervid_A = mkTerm "fervid_A" ;
lin fervour_N = mkTerm "fervour_N" ;
lin fescue_N = mkTerm "fescue_N" ;
lin fess_up_V = mkTerm "fess_up_V" ;
lin fess_up_V2 = mkTerm "fess_up_V2" ;
lin fess_up_to_V2 = mkTerm "fess_up_to_V2" ;
lin fesse_N = mkTerm "fesse_N" ;
lin festal_A = mkTerm "festal_A" ;
lin fester_N = mkTerm "fester_N" ;
lin fester_V = mkTerm "fester_V" ;
lin festering_N = mkTerm "festering_N" ;
lin festination_N = mkTerm "festination_N" ;
lin festival_N = mkTerm "festival_N" ;
lin festive_A = mkTerm "festive_A" ;
lin festivity_N = mkTerm "festivity_N" ;
lin festoon_N = mkTerm "festoon_N" ;
lin festoon_V2 = mkTerm "festoon_V2" ;
lin festschrift_N = mkTerm "festschrift_N" ;
lin fetal_A = mkTerm "fetal_A" ;
lin fetch_N = mkTerm "fetch_N" ;
lin fetch_V2 = mkTerm "fetch_V2" ;
lin fetching_A = mkTerm "fetching_A" ;
lin fete_N = mkTerm "fete_N" ;
lin fete_V2 = mkTerm "fete_V2" ;
lin fete_day_N = mkTerm "fete_day_N" ;
lin feterita_N = mkTerm "feterita_N" ;
lin fetid_A = mkTerm "fetid_A" ;
lin fetish_N = mkTerm "fetish_N" ;
lin fetishism_N = mkTerm "fetishism_N" ;
lin fetishist_N = mkTerm "fetishist_N" ;
lin fetlock_N = mkTerm "fetlock_N" ;
lin fetology_N = mkTerm "fetology_N" ;
lin fetometry_N = mkTerm "fetometry_N" ;
lin fetoprotein_N = mkTerm "fetoprotein_N" ;
lin fetoscope_N = mkTerm "fetoscope_N" ;
lin fetoscopy_N = mkTerm "fetoscopy_N" ;
lin fetter_N = mkTerm "fetter_N" ;
lin fetter_V2 = mkTerm "fetter_V2" ;
lin fetterbush_N = mkTerm "fetterbush_N" ;
lin fettle_N = mkTerm "fettle_N" ;
lin fettuccine_N = mkTerm "fettuccine_N" ;
lin fetus_N = mkTerm "fetus_N" ;
lin feud_N = mkTerm "feud_N" ;
lin feudal_A = mkTerm "feudal_A" ;
lin feudalism_N = mkTerm "feudalism_N" ;
lin feudatory_A = mkTerm "feudatory_A" ;
lin feudatory_N = mkTerm "feudatory_N" ;
lin feude_V = mkTerm "feude_V" ;
lin fever_N = mkTerm "fever_N" ;
lin fevered_A = mkTerm "fevered_A" ;
lin feverfew_N = mkTerm "feverfew_N" ;
lin feverish_A = mkTerm "feverish_A" ;
lin feverroot_N = mkTerm "feverroot_N" ;
lin few_A = mkTerm "few_A" ;
lin few_N = mkTerm "few_N" ;
lin few_Num = mkTerm "few_Num" ;
lin fewer_A = mkTerm "fewer_A" ;
lin fewer_Det = mkTerm "fewer_Det" ;
lin fewer_than_AdN = mkTerm "fewer_than_AdN" ;
lin fewness_N = mkTerm "fewness_N" ;
lin fey_A = mkTerm "fey_A" ;
lin fez_N = mkTerm "fez_N" ;
lin fiance_N = mkTerm "fiance_N" ;
lin fiancee_N = mkTerm "fiancee_N" ;
lin fiasco_N = mkTerm "fiasco_N" ;
lin fiat_N = mkTerm "fiat_N" ;
lin fib_N = mkTerm "fib_N" ;
lin fib_V = mkTerm "fib_V" ;
lin fibber_N = mkTerm "fibber_N" ;
lin fibbing_N = mkTerm "fibbing_N" ;
lin fiber_N = mkTerm "fiber_N" ;
lin fiberboard_N = mkTerm "fiberboard_N" ;
lin fiberglass_N = mkTerm "fiberglass_N" ;
lin fiberscope_N = mkTerm "fiberscope_N" ;
lin fibre_N = mkTerm "fibre_N" ;
lin fibreboard_N = mkTerm "fibreboard_N" ;
lin fibreglass_N = mkTerm "fibreglass_N" ;
lin fibril_N = mkTerm "fibril_N" ;
lin fibrillation_N = mkTerm "fibrillation_N" ;
lin fibrillose_A = mkTerm "fibrillose_A" ;
lin fibrin_N = mkTerm "fibrin_N" ;
lin fibrinase_N = mkTerm "fibrinase_N" ;
lin fibrinogen_N = mkTerm "fibrinogen_N" ;
lin fibrinolysis_N = mkTerm "fibrinolysis_N" ;
lin fibrinopeptide_N = mkTerm "fibrinopeptide_N" ;
lin fibrinous_A = mkTerm "fibrinous_A" ;
lin fibroadenoma_N = mkTerm "fibroadenoma_N" ;
lin fibroblast_N = mkTerm "fibroblast_N" ;
lin fibrocalcific_A = mkTerm "fibrocalcific_A" ;
lin fibrocartilage_N = mkTerm "fibrocartilage_N" ;
lin fibrocartilaginous_A = mkTerm "fibrocartilaginous_A" ;
lin fibroma_N = mkTerm "fibroma_N" ;
lin fibromyositis_N = mkTerm "fibromyositis_N" ;
lin fibrosis_N = mkTerm "fibrosis_N" ;
lin fibrositis_N = mkTerm "fibrositis_N" ;
lin fibrosity_N = mkTerm "fibrosity_N" ;
lin fibrous_A = mkTerm "fibrous_A" ;
lin fibula_N = mkTerm "fibula_N" ;
lin fichu_N = mkTerm "fichu_N" ;
lin fickle_A = mkTerm "fickle_A" ;
lin fickleness_N = mkTerm "fickleness_N" ;
lin fictile_A = mkTerm "fictile_A" ;
lin fiction_N = mkTerm "fiction_N" ;
lin fictional_A = mkTerm "fictional_A" ;
lin fictionalization_N = mkTerm "fictionalization_N" ;
lin fictitious_A = mkTerm "fictitious_A" ;
lin fictive_A = mkTerm "fictive_A" ;
lin fiddle_N = mkTerm "fiddle_N" ;
lin fiddle_V2 = mkTerm "fiddle_V2" ;
lin fiddle_about_V = mkTerm "fiddle_about_V" ;
lin fiddle_around_V = mkTerm "fiddle_around_V" ;
lin fiddle_away_V2 = mkTerm "fiddle_away_V2" ;
lin fiddleneck_N = mkTerm "fiddleneck_N" ;
lin fiddler_N = mkTerm "fiddler_N" ;
lin fiddlestick_N = mkTerm "fiddlestick_N" ;
lin fidelity_N = mkTerm "fidelity_N" ;
lin fidget_N = mkTerm "fidget_N" ;
lin fidget_V = mkTerm "fidget_V" ;
lin fidget_V2 = mkTerm "fidget_V2" ;
lin fidgety_A = mkTerm "fidgety_A" ;
lin fiducial_A = mkTerm "fiducial_A" ;
lin fiduciary_A = mkTerm "fiduciary_A" ;
lin fiduciary_N = mkTerm "fiduciary_N" ;
lin fief_N = mkTerm "fief_N" ;
lin fiefdom_N = mkTerm "fiefdom_N" ;
lin field_1_N = mkTerm "field_1_N" ;
lin field_2_N = mkTerm "field_2_N" ;
lin field_3_N = mkTerm "field_3_N" ;
lin field_4_N = mkTerm "field_4_N" ;
lin field_V = mkTerm "field_V" ;
lin field_V2 = mkTerm "field_V2" ;
lin field_hospital_N = mkTerm "field_hospital_N" ;
lin field_officer_N = mkTerm "field_officer_N" ;
lin fielder_N = mkTerm "fielder_N" ;
lin fieldfare_N = mkTerm "fieldfare_N" ;
lin fielding_N = mkTerm "fielding_N" ;
lin fieldsman_N = mkTerm "fieldsman_N" ;
lin fieldstone_N = mkTerm "fieldstone_N" ;
lin fieldwork_N = mkTerm "fieldwork_N" ;
lin fieldworker_N = mkTerm "fieldworker_N" ;
lin fiend_N = mkTerm "fiend_N" ;
lin fiendish_A = mkTerm "fiendish_A" ;
lin fierce_A = mkTerm "fierce_A" ;
lin fierceness_N = mkTerm "fierceness_N" ;
lin fieriness_N = mkTerm "fieriness_N" ;
lin fiery_A = mkTerm "fiery_A" ;
lin fiesta_N = mkTerm "fiesta_N" ;
lin fife_N = mkTerm "fife_N" ;
lin fife_PN = mkTerm "fife_PN" ;
lin fig_N = mkTerm "fig_N" ;
lin fig_leaf_N = mkTerm "fig_leaf_N" ;
lin fight_N = mkTerm "fight_N" ;
lin fight_V = mkTerm "fight_V" ;
lin fight_V2 = mkTerm "fight_V2" ;
lin fight_back_V = mkTerm "fight_back_V" ;
lin fight_back_V2 = mkTerm "fight_back_V2" ;
lin fight_it_out_V2 = mkTerm "fight_it_out_V2" ;
lin fight_off_V2 = mkTerm "fight_off_V2" ;
lin fighter_N = mkTerm "fighter_N" ;
lin fighting_N = mkTerm "fighting_N" ;
lin figment_N = mkTerm "figment_N" ;
lin figural_A = mkTerm "figural_A" ;
lin figuration_N = mkTerm "figuration_N" ;
lin figurative_A = mkTerm "figurative_A" ;
lin figure_1_N = mkTerm "figure_1_N" ;
lin figure_2_N = mkTerm "figure_2_N" ;
lin figure_V = mkTerm "figure_V" ;
lin figure_VS = mkTerm "figure_VS" ;
lin figure_on_V2 = mkTerm "figure_on_V2" ;
lin figure_out_V2 = mkTerm "figure_out_V2" ;
lin figure_up_V2 = mkTerm "figure_up_V2" ;
lin figurehead_N = mkTerm "figurehead_N" ;
lin figurine_N = mkTerm "figurine_N" ;
lin figwort_N = mkTerm "figwort_N" ;
lin fiji_PN = mkTerm "fiji_PN" ;
lin fijian_A = mkTerm "fijian_A" ;
lin fijian_N = mkTerm "fijian_N" ;
lin filaggrin_N = mkTerm "filaggrin_N" ;
lin filament_N = mkTerm "filament_N" ;
lin filamentous_A = mkTerm "filamentous_A" ;
lin filar_A = mkTerm "filar_A" ;
lin filaria_N = mkTerm "filaria_N" ;
lin filarial_A = mkTerm "filarial_A" ;
lin filariasis_N = mkTerm "filariasis_N" ;
lin filariid_A = mkTerm "filariid_A" ;
lin filature_N = mkTerm "filature_N" ;
lin filbert_N = mkTerm "filbert_N" ;
lin filch_V2 = mkTerm "filch_V2" ;
lin file_N = mkTerm "file_N" ;
lin file_V = mkTerm "file_V" ;
lin file_V2 = mkTerm "file_V2" ;
lin file_away_V2 = mkTerm "file_away_V2" ;
lin file_for_V2 = mkTerm "file_for_V2" ;
lin filefish_N = mkTerm "filefish_N" ;
lin filename_N = mkTerm "filename_N" ;
lin filer_N = mkTerm "filer_N" ;
lin filet_N = mkTerm "filet_N" ;
lin filial_A = mkTerm "filial_A" ;
lin filibuster_N = mkTerm "filibuster_N" ;
lin filibuster_V = mkTerm "filibuster_V" ;
lin filicide_N = mkTerm "filicide_N" ;
lin filigree_N = mkTerm "filigree_N" ;
lin filing_N = mkTerm "filing_N" ;
lin filipino_A = mkTerm "filipino_A" ;
lin filipino_N = mkTerm "filipino_N" ;
lin fill_N = mkTerm "fill_N" ;
lin fill_V = mkTerm "fill_V" ;
lin fill_V2 = mkTerm "fill_V2" ;
lin fill_in_V = mkTerm "fill_in_V" ;
lin fill_in_V2 = mkTerm "fill_in_V2" ;
lin fill_in_for_V2 = mkTerm "fill_in_for_V2" ;
lin fill_in_on_V3 = mkTerm "fill_in_on_V3" ;
lin fill_out_V = mkTerm "fill_out_V" ;
lin fill_out_V2 = mkTerm "fill_out_V2" ;
lin fill_up_V2 = mkTerm "fill_up_V2" ;
lin filler_N = mkTerm "filler_N" ;
lin fillet_N = mkTerm "fillet_N" ;
lin fillet_V2 = mkTerm "fillet_V2" ;
lin filling_N = mkTerm "filling_N" ;
lin fillip_N = mkTerm "fillip_N" ;
lin filly_N = mkTerm "filly_N" ;
lin film_1_N = mkTerm "film_1_N" ;
lin film_2_N = mkTerm "film_2_N" ;
lin film_V = mkTerm "film_V" ;
lin film_V2 = mkTerm "film_V2" ;
lin film_star_N = mkTerm "film_star_N" ;
lin filmable_A = mkTerm "filmable_A" ;
lin filmdom_N = mkTerm "filmdom_N" ;
lin filming_N = mkTerm "filming_N" ;
lin filmmaker_N = mkTerm "filmmaker_N" ;
lin filmmaking_N = mkTerm "filmmaking_N" ;
lin filmography_N = mkTerm "filmography_N" ;
lin filmy_A = mkTerm "filmy_A" ;
lin filovirus_N = mkTerm "filovirus_N" ;
lin fils_N = mkTerm "fils_N" ;
lin filter_N = mkTerm "filter_N" ;
lin filter_V = mkTerm "filter_V" ;
lin filter_V2 = mkTerm "filter_V2" ;
lin filter_in_V = mkTerm "filter_in_V" ;
lin filter_out_V2 = mkTerm "filter_out_V2" ;
lin filtertipped_A = mkTerm "filtertipped_A" ;
lin filth_N = mkTerm "filth_N" ;
lin filthiness_N = mkTerm "filthiness_N" ;
lin filthy_A = mkTerm "filthy_A" ;
lin filtrate_N = mkTerm "filtrate_N" ;
lin filtrate_V = mkTerm "filtrate_V" ;
lin filtrate_V2 = mkTerm "filtrate_V2" ;
lin filtration_N = mkTerm "filtration_N" ;
lin fimbria_N = mkTerm "fimbria_N" ;
lin fimbriate_A = mkTerm "fimbriate_A" ;
lin fin_N = mkTerm "fin_N" ;
lin finable_A = mkTerm "finable_A" ;
lin finagle_V2 = mkTerm "finagle_V2" ;
lin finagler_N = mkTerm "finagler_N" ;
lin final_A = mkTerm "final_A" ;
lin final_N = mkTerm "final_N" ;
lin finale_N = mkTerm "finale_N" ;
lin finalist_N = mkTerm "finalist_N" ;
lin finality_N = mkTerm "finality_N" ;
lin finalization_N = mkTerm "finalization_N" ;
lin finalize_V2 = mkTerm "finalize_V2" ;
lin finally_Adv = mkTerm "finally_Adv" ;
lin finance_N = mkTerm "finance_N" ;
lin finance_V2 = mkTerm "finance_V2" ;
lin financial_A = mkTerm "financial_A" ;
lin financier_N = mkTerm "financier_N" ;
lin financing_N = mkTerm "financing_N" ;
lin finback_N = mkTerm "finback_N" ;
lin finch_N = mkTerm "finch_N" ;
lin find_N = mkTerm "find_N" ;
lin find_V = mkTerm "find_V" ;
lin find_V2 = mkTerm "find_V2" ;
lin find_V2A = mkTerm "find_V2A" ;
lin find_VS = mkTerm "find_VS" ;
lin find_out_V = mkTerm "find_out_V" ;
lin find_out_V2 = mkTerm "find_out_V2" ;
lin finder_N = mkTerm "finder_N" ;
lin finding_N = mkTerm "finding_N" ;
lin findings_N = mkTerm "findings_N" ;
lin fine_A = mkTerm "fine_A" ;
lin fine_Adv = mkTerm "fine_Adv" ;
lin fine_N = mkTerm "fine_N" ;
lin fine_V2 = mkTerm "fine_V2" ;
lin fine_tooth_A = mkTerm "fine_tooth_A" ;
lin fineable_A = mkTerm "fineable_A" ;
lin fineness_N = mkTerm "fineness_N" ;
lin finer_A = mkTerm "finer_A" ;
lin finery_N = mkTerm "finery_N" ;
lin finespun_A = mkTerm "finespun_A" ;
lin finesse_N = mkTerm "finesse_N" ;
lin finesse_V2 = mkTerm "finesse_V2" ;
lin finger_N = mkTerm "finger_N" ;
lin finger_V2 = mkTerm "finger_V2" ;
lin finger_alphabet_N = mkTerm "finger_alphabet_N" ;
lin finger_bowl_N = mkTerm "finger_bowl_N" ;
lin finger_plate_N = mkTerm "finger_plate_N" ;
lin finger_post_N = mkTerm "finger_post_N" ;
lin fingerboard_N = mkTerm "fingerboard_N" ;
lin fingering_N = mkTerm "fingering_N" ;
lin fingerless_A = mkTerm "fingerless_A" ;
lin fingerling_N = mkTerm "fingerling_N" ;
lin fingermark_N = mkTerm "fingermark_N" ;
lin fingernail_N = mkTerm "fingernail_N" ;
lin fingerprint_N = mkTerm "fingerprint_N" ;
lin fingerprinting_N = mkTerm "fingerprinting_N" ;
lin fingerstall_N = mkTerm "fingerstall_N" ;
lin fingertip_N = mkTerm "fingertip_N" ;
lin finial_N = mkTerm "finial_N" ;
lin finical_A = mkTerm "finical_A" ;
lin finicky_A = mkTerm "finicky_A" ;
lin finis_N = mkTerm "finis_N" ;
lin finish_N = mkTerm "finish_N" ;
lin finish_V = mkTerm "finish_V" ;
lin finish_V2 = mkTerm "finish_V2" ;
lin finish_off_V2 = mkTerm "finish_off_V2" ;
lin finish_up_V = mkTerm "finish_up_V" ;
lin finish_up_with_V2 = mkTerm "finish_up_with_V2" ;
lin finish_with_V2 = mkTerm "finish_with_V2" ;
lin finished_A = mkTerm "finished_A" ;
lin finisher_N = mkTerm "finisher_N" ;
lin finite_A = mkTerm "finite_A" ;
lin finiteness_N = mkTerm "finiteness_N" ;
lin fink_N = mkTerm "fink_N" ;
lin fink_on_V2 = mkTerm "fink_on_V2" ;
lin fink_out_V = mkTerm "fink_out_V" ;
lin finland_PN = mkTerm "finland_PN" ;
lin finnan_N = mkTerm "finnan_N" ;
lin finnan_haddie_N = mkTerm "finnan_haddie_N" ;
lin finnan_haddock_N = mkTerm "finnan_haddock_N" ;
lin finnishFem_N = mkTerm "finnishFem_N" ;
lin finnishMasc_N = mkTerm "finnishMasc_N" ;
lin finnish_A = mkTerm "finnish_A" ;
lin fiona_PN = mkTerm "fiona_PN" ;
lin fiord_N = mkTerm "fiord_N" ;
lin fipple_N = mkTerm "fipple_N" ;
lin fir_N = mkTerm "fir_N" ;
lin fir_cone_N = mkTerm "fir_cone_N" ;
lin fire_1_N = mkTerm "fire_1_N" ;
lin fire_2_N = mkTerm "fire_2_N" ;
lin fire_V = mkTerm "fire_V" ;
lin fire_V2 = mkTerm "fire_V2" ;
lin fire_alarm_N = mkTerm "fire_alarm_N" ;
lin fire_away_V = mkTerm "fire_away_V" ;
lin fire_back_V = mkTerm "fire_back_V" ;
lin fire_brigade_N = mkTerm "fire_brigade_N" ;
lin fire_control_N = mkTerm "fire_control_N" ;
lin fire_eater_N = mkTerm "fire_eater_N" ;
lin fire_engine_N = mkTerm "fire_engine_N" ;
lin fire_escape_N = mkTerm "fire_escape_N" ;
lin fire_extinguisher_N = mkTerm "fire_extinguisher_N" ;
lin fire_fighter_N = mkTerm "fire_fighter_N" ;
lin fire_hose_N = mkTerm "fire_hose_N" ;
lin fire_off_V2 = mkTerm "fire_off_V2" ;
lin fire_power_N = mkTerm "fire_power_N" ;
lin fire_raising_N = mkTerm "fire_raising_N" ;
lin fire_up_V = mkTerm "fire_up_V" ;
lin fire_up_V2 = mkTerm "fire_up_V2" ;
lin fire_walker_N = mkTerm "fire_walker_N" ;
lin fire_walking_N = mkTerm "fire_walking_N" ;
lin fire_watcher_N = mkTerm "fire_watcher_N" ;
lin fire_watching_N = mkTerm "fire_watching_N" ;
lin firearm_N = mkTerm "firearm_N" ;
lin fireball_N = mkTerm "fireball_N" ;
lin firebase_N = mkTerm "firebase_N" ;
lin firebird_N = mkTerm "firebird_N" ;
lin fireboat_N = mkTerm "fireboat_N" ;
lin firebomb_N = mkTerm "firebomb_N" ;
lin firebox_N = mkTerm "firebox_N" ;
lin firebrand_N = mkTerm "firebrand_N" ;
lin firebrat_N = mkTerm "firebrat_N" ;
lin firebreak_N = mkTerm "firebreak_N" ;
lin firebrick_N = mkTerm "firebrick_N" ;
lin firebug_N = mkTerm "firebug_N" ;
lin fireclay_N = mkTerm "fireclay_N" ;
lin firecracker_N = mkTerm "firecracker_N" ;
lin firedamp_N = mkTerm "firedamp_N" ;
lin firedog_N = mkTerm "firedog_N" ;
lin firefly_N = mkTerm "firefly_N" ;
lin fireguard_N = mkTerm "fireguard_N" ;
lin firelight_N = mkTerm "firelight_N" ;
lin firelighter_N = mkTerm "firelighter_N" ;
lin fireman_N = mkTerm "fireman_N" ;
lin firenze_PN = mkTerm "firenze_PN" ;
lin fireplace_N = mkTerm "fireplace_N" ;
lin fireplug_N = mkTerm "fireplug_N" ;
lin fireproof_A = mkTerm "fireproof_A" ;
lin fireside_N = mkTerm "fireside_N" ;
lin firestone_N = mkTerm "firestone_N" ;
lin firestorm_N = mkTerm "firestorm_N" ;
lin firetrap_N = mkTerm "firetrap_N" ;
lin firewall_N = mkTerm "firewall_N" ;
lin firewater_N = mkTerm "firewater_N" ;
lin fireweed_N = mkTerm "fireweed_N" ;
lin firewood_N = mkTerm "firewood_N" ;
lin firework_N = mkTerm "firework_N" ;
lin fireworks_N = mkTerm "fireworks_N" ;
lin firing_N = mkTerm "firing_N" ;
lin firing_line_N = mkTerm "firing_line_N" ;
lin firing_party_N = mkTerm "firing_party_N" ;
lin firing_squad_N = mkTerm "firing_squad_N" ;
lin firkin_N = mkTerm "firkin_N" ;
lin firm_A = mkTerm "firm_A" ;
lin firm_Adv = mkTerm "firm_Adv" ;
lin firm_N = mkTerm "firm_N" ;
lin firm_V = mkTerm "firm_V" ;
lin firm_V2 = mkTerm "firm_V2" ;
lin firm_up_V2 = mkTerm "firm_up_V2" ;
lin firmament_N = mkTerm "firmament_N" ;
lin firmamental_A = mkTerm "firmamental_A" ;
lin firmness_N = mkTerm "firmness_N" ;
lin firmware_N = mkTerm "firmware_N" ;
lin first_Adv = mkTerm "first_Adv" ;
lin first_class_A = mkTerm "first_class_A" ;
lin first_class_Adv = mkTerm "first_class_Adv" ;
lin first_hand_A = mkTerm "first_hand_A" ;
lin first_nighter_N = mkTerm "first_nighter_N" ;
lin first_rate_A = mkTerm "first_rate_A" ;
lin firstborn_A = mkTerm "firstborn_A" ;
lin firstborn_N = mkTerm "firstborn_N" ;
lin firstly_Adv = mkTerm "firstly_Adv" ;
lin firth_N = mkTerm "firth_N" ;
lin fisc_N = mkTerm "fisc_N" ;
lin fiscal_A = mkTerm "fiscal_A" ;
lin fish_N = mkTerm "fish_N" ;
lin fish_V = mkTerm "fish_V" ;
lin fish_V2 = mkTerm "fish_V2" ;
lin fish_for_V2 = mkTerm "fish_for_V2" ;
lin fish_hook_N = mkTerm "fish_hook_N" ;
lin fish_knife_N = mkTerm "fish_knife_N" ;
lin fish_out_V2 = mkTerm "fish_out_V2" ;
lin fish_slice_N = mkTerm "fish_slice_N" ;
lin fishball_N = mkTerm "fishball_N" ;
lin fishbone_N = mkTerm "fishbone_N" ;
lin fishbowl_N = mkTerm "fishbowl_N" ;
lin fishcake_N = mkTerm "fishcake_N" ;
lin fisher_N = mkTerm "fisher_N" ;
lin fisherman_N = mkTerm "fisherman_N" ;
lin fishery_N = mkTerm "fishery_N" ;
lin fisheye_A = mkTerm "fisheye_A" ;
lin fishing_N = mkTerm "fishing_N" ;
lin fishing_line_N = mkTerm "fishing_line_N" ;
lin fishing_rod_N = mkTerm "fishing_rod_N" ;
lin fishing_tackle_N = mkTerm "fishing_tackle_N" ;
lin fishmonger_N = mkTerm "fishmonger_N" ;
lin fishnet_N = mkTerm "fishnet_N" ;
lin fishpaste_N = mkTerm "fishpaste_N" ;
lin fishplate_N = mkTerm "fishplate_N" ;
lin fishpond_N = mkTerm "fishpond_N" ;
lin fishwife_N = mkTerm "fishwife_N" ;
lin fishy_A = mkTerm "fishy_A" ;
lin fissile_A = mkTerm "fissile_A" ;
lin fission_N = mkTerm "fission_N" ;
lin fissionable_A = mkTerm "fissionable_A" ;
lin fissiparity_N = mkTerm "fissiparity_N" ;
lin fissiparous_A = mkTerm "fissiparous_A" ;
lin fissure_N = mkTerm "fissure_N" ;
lin fist_N = mkTerm "fist_N" ;
lin fistfight_N = mkTerm "fistfight_N" ;
lin fistmele_N = mkTerm "fistmele_N" ;
lin fistula_N = mkTerm "fistula_N" ;
lin fistular_A = mkTerm "fistular_A" ;
lin fistulous_A = mkTerm "fistulous_A" ;
lin fit_A = mkTerm "fit_A" ;
lin fit_N = mkTerm "fit_N" ;
lin fit_V = mkTerm "fit_V" ;
lin fit_V2 = mkTerm "fit_V2" ;
lin fit_in_V = mkTerm "fit_in_V" ;
lin fit_in_V2 = mkTerm "fit_in_V2" ;
lin fit_in_with_V2 = mkTerm "fit_in_with_V2" ;
lin fit_into_V2 = mkTerm "fit_into_V2" ;
lin fit_out_V2 = mkTerm "fit_out_V2" ;
lin fit_out_with_V2 = mkTerm "fit_out_with_V2" ;
lin fit_up_V2 = mkTerm "fit_up_V2" ;
lin fitful_A = mkTerm "fitful_A" ;
lin fitfulness_N = mkTerm "fitfulness_N" ;
lin fitment_N = mkTerm "fitment_N" ;
lin fitness_N = mkTerm "fitness_N" ;
lin fitter_A = mkTerm "fitter_A" ;
lin fitter_N = mkTerm "fitter_N" ;
lin fitting_A = mkTerm "fitting_A" ;
lin fitting_N = mkTerm "fitting_N" ;
lin fivefold_A = mkTerm "fivefold_A" ;
lin fivepence_N = mkTerm "fivepence_N" ;
lin fivepenny_A = mkTerm "fivepenny_A" ;
lin fiver_N = mkTerm "fiver_N" ;
lin fives_N = mkTerm "fives_N" ;
lin fix_N = mkTerm "fix_N" ;
lin fix_V = mkTerm "fix_V" ;
lin fix_V2 = mkTerm "fix_V2" ;
lin fix_up_V2 = mkTerm "fix_up_V2" ;
lin fixate_V2 = mkTerm "fixate_V2" ;
lin fixation_N = mkTerm "fixation_N" ;
lin fixative_N = mkTerm "fixative_N" ;
lin fixed_A = mkTerm "fixed_A" ;
lin fixedness_N = mkTerm "fixedness_N" ;
lin fixer_N = mkTerm "fixer_N" ;
lin fixings_N = mkTerm "fixings_N" ;
lin fixture_N = mkTerm "fixture_N" ;
lin fizgig_N = mkTerm "fizgig_N" ;
lin fizz_N = mkTerm "fizz_N" ;
lin fizz_V = mkTerm "fizz_V" ;
lin fizzle_V = mkTerm "fizzle_V" ;
lin fizzle_out_V = mkTerm "fizzle_out_V" ;
lin fizzy_A = mkTerm "fizzy_A" ;
lin fjord_N = mkTerm "fjord_N" ;
lin flab_N = mkTerm "flab_N" ;
lin flabbergast_V2 = mkTerm "flabbergast_V2" ;
lin flabbiness_N = mkTerm "flabbiness_N" ;
lin flabby_A = mkTerm "flabby_A" ;
lin flaccid_A = mkTerm "flaccid_A" ;
lin flaccidity_N = mkTerm "flaccidity_N" ;
lin flag_N = mkTerm "flag_N" ;
lin flag_V = mkTerm "flag_V" ;
lin flag_V2 = mkTerm "flag_V2" ;
lin flag_captain_N = mkTerm "flag_captain_N" ;
lin flag_day_N = mkTerm "flag_day_N" ;
lin flag_down_V2 = mkTerm "flag_down_V2" ;
lin flag_up_V2 = mkTerm "flag_up_V2" ;
lin flagellant_N = mkTerm "flagellant_N" ;
lin flagellate_A = mkTerm "flagellate_A" ;
lin flagellate_N = mkTerm "flagellate_N" ;
lin flagellate_V2 = mkTerm "flagellate_V2" ;
lin flagellation_N = mkTerm "flagellation_N" ;
lin flagellum_N = mkTerm "flagellum_N" ;
lin flageolet_N = mkTerm "flageolet_N" ;
lin flagfish_N = mkTerm "flagfish_N" ;
lin flagging_N = mkTerm "flagging_N" ;
lin flagitious_A = mkTerm "flagitious_A" ;
lin flagon_N = mkTerm "flagon_N" ;
lin flagpole_N = mkTerm "flagpole_N" ;
lin flagrant_A = mkTerm "flagrant_A" ;
lin flagship_N = mkTerm "flagship_N" ;
lin flagstaff_N = mkTerm "flagstaff_N" ;
lin flagstone_N = mkTerm "flagstone_N" ;
lin flail_N = mkTerm "flail_N" ;
lin flail_V2 = mkTerm "flail_V2" ;
lin flair_N = mkTerm "flair_N" ;
lin flak_N = mkTerm "flak_N" ;
lin flake_N = mkTerm "flake_N" ;
lin flake_V = mkTerm "flake_V" ;
lin flake_out_V = mkTerm "flake_out_V" ;
lin flakiness_N = mkTerm "flakiness_N" ;
lin flaky_A = mkTerm "flaky_A" ;
lin flambeau_N = mkTerm "flambeau_N" ;
lin flamboyance_N = mkTerm "flamboyance_N" ;
lin flamboyant_A = mkTerm "flamboyant_A" ;
lin flame_N = mkTerm "flame_N" ;
lin flame_V = mkTerm "flame_V" ;
lin flame_out_V = mkTerm "flame_out_V" ;
lin flame_up_V = mkTerm "flame_up_V" ;
lin flamen_N = mkTerm "flamen_N" ;
lin flamenco_N = mkTerm "flamenco_N" ;
lin flameproof_A = mkTerm "flameproof_A" ;
lin flamethrower_N = mkTerm "flamethrower_N" ;
lin flamingo_N = mkTerm "flamingo_N" ;
lin flammability_N = mkTerm "flammability_N" ;
lin flammable_A = mkTerm "flammable_A" ;
lin flan_N = mkTerm "flan_N" ;
lin flange_N = mkTerm "flange_N" ;
lin flank_N = mkTerm "flank_N" ;
lin flank_V = mkTerm "flank_V" ;
lin flank_V2 = mkTerm "flank_V2" ;
lin flanker_N = mkTerm "flanker_N" ;
lin flannel_N = mkTerm "flannel_N" ;
lin flannelbush_N = mkTerm "flannelbush_N" ;
lin flannelette_N = mkTerm "flannelette_N" ;
lin flap_N = mkTerm "flap_N" ;
lin flap_V = mkTerm "flap_V" ;
lin flap_V2 = mkTerm "flap_V2" ;
lin flapjack_N = mkTerm "flapjack_N" ;
lin flapper_N = mkTerm "flapper_N" ;
lin flare_N = mkTerm "flare_N" ;
lin flare_V = mkTerm "flare_V" ;
lin flare_V2 = mkTerm "flare_V2" ;
lin flare_out_V = mkTerm "flare_out_V" ;
lin flare_path_N = mkTerm "flare_path_N" ;
lin flare_up_N = mkTerm "flare_up_N" ;
lin flare_up_V = mkTerm "flare_up_V" ;
lin flash_N = mkTerm "flash_N" ;
lin flash_V = mkTerm "flash_V" ;
lin flashback_N = mkTerm "flashback_N" ;
lin flashboard_N = mkTerm "flashboard_N" ;
lin flashbulb_N = mkTerm "flashbulb_N" ;
lin flasher_N = mkTerm "flasher_N" ;
lin flashgun_N = mkTerm "flashgun_N" ;
lin flashiness_N = mkTerm "flashiness_N" ;
lin flashing_N = mkTerm "flashing_N" ;
lin flashlight_N = mkTerm "flashlight_N" ;
lin flashover_N = mkTerm "flashover_N" ;
lin flashpoint_N = mkTerm "flashpoint_N" ;
lin flashy_A = mkTerm "flashy_A" ;
lin flask_N = mkTerm "flask_N" ;
lin flat_A = mkTerm "flat_A" ;
lin flat_Adv = mkTerm "flat_Adv" ;
lin flat_N = mkTerm "flat_N" ;
lin flat_bottomed_A = mkTerm "flat_bottomed_A" ;
lin flat_car_N = mkTerm "flat_car_N" ;
lin flat_footed_A = mkTerm "flat_footed_A" ;
lin flat_iron_N = mkTerm "flat_iron_N" ;
lin flatbed_N = mkTerm "flatbed_N" ;
lin flatbottom_A = mkTerm "flatbottom_A" ;
lin flatbread_N = mkTerm "flatbread_N" ;
lin flatbrod_N = mkTerm "flatbrod_N" ;
lin flatfish_N = mkTerm "flatfish_N" ;
lin flatfoot_N = mkTerm "flatfoot_N" ;
lin flathead_N = mkTerm "flathead_N" ;
lin flatlet_N = mkTerm "flatlet_N" ;
lin flatmate_N = mkTerm "flatmate_N" ;
lin flatness_N = mkTerm "flatness_N" ;
lin flats_N = mkTerm "flats_N" ;
lin flatten_V = mkTerm "flatten_V" ;
lin flatten_V2 = mkTerm "flatten_V2" ;
lin flatter_V2 = mkTerm "flatter_V2" ;
lin flatterer_N = mkTerm "flatterer_N" ;
lin flattering_A = mkTerm "flattering_A" ;
lin flattery_N = mkTerm "flattery_N" ;
lin flattop_N = mkTerm "flattop_N" ;
lin flatulence_N = mkTerm "flatulence_N" ;
lin flatulent_A = mkTerm "flatulent_A" ;
lin flatware_N = mkTerm "flatware_N" ;
lin flatwork_N = mkTerm "flatwork_N" ;
lin flatworm_N = mkTerm "flatworm_N" ;
lin flaunt_N = mkTerm "flaunt_N" ;
lin flaunt_V = mkTerm "flaunt_V" ;
lin flaunt_V2 = mkTerm "flaunt_V2" ;
lin flaunty_A = mkTerm "flaunty_A" ;
lin flautist_N = mkTerm "flautist_N" ;
lin flavin_N = mkTerm "flavin_N" ;
lin flavivirus_N = mkTerm "flavivirus_N" ;
lin flavone_N = mkTerm "flavone_N" ;
lin flavonoid_N = mkTerm "flavonoid_N" ;
lin flavorful_A = mkTerm "flavorful_A" ;
lin flavorlessness_N = mkTerm "flavorlessness_N" ;
lin flavorsomeness_N = mkTerm "flavorsomeness_N" ;
lin flavour_N = mkTerm "flavour_N" ;
lin flavour_V2 = mkTerm "flavour_V2" ;
lin flavourer_N = mkTerm "flavourer_N" ;
lin flavouring_N = mkTerm "flavouring_N" ;
lin flavourless_A = mkTerm "flavourless_A" ;
lin flaw_N = mkTerm "flaw_N" ;
lin flaw_V2 = mkTerm "flaw_V2" ;
lin flawless_A = mkTerm "flawless_A" ;
lin flax_N = mkTerm "flax_N" ;
lin flaxen_A = mkTerm "flaxen_A" ;
lin flay_V2 = mkTerm "flay_V2" ;
lin flea_N = mkTerm "flea_N" ;
lin flea_bite_N = mkTerm "flea_bite_N" ;
lin flea_bitten_A = mkTerm "flea_bitten_A" ;
lin fleabag_N = mkTerm "fleabag_N" ;
lin fleabane_N = mkTerm "fleabane_N" ;
lin fleapit_N = mkTerm "fleapit_N" ;
lin fleawort_N = mkTerm "fleawort_N" ;
lin flecainide_N = mkTerm "flecainide_N" ;
lin fleck_N = mkTerm "fleck_N" ;
lin fleck_V2 = mkTerm "fleck_V2" ;
lin fledged_A = mkTerm "fledged_A" ;
lin fledgeling_N = mkTerm "fledgeling_N" ;
lin fledgling_A = mkTerm "fledgling_A" ;
lin fledgling_N = mkTerm "fledgling_N" ;
lin flee_V = mkTerm "flee_V" ;
lin flee_V2 = mkTerm "flee_V2" ;
lin fleece_N = mkTerm "fleece_N" ;
lin fleece_V2 = mkTerm "fleece_V2" ;
lin fleeceable_A = mkTerm "fleeceable_A" ;
lin fleecy_A = mkTerm "fleecy_A" ;
lin fleer_N = mkTerm "fleer_N" ;
lin fleet_A = mkTerm "fleet_A" ;
lin fleet_N = mkTerm "fleet_N" ;
lin fleet_PN = mkTerm "fleet_PN" ;
lin fleet_street_PN = mkTerm "fleet_street_PN" ;
lin fleeting_A = mkTerm "fleeting_A" ;
lin fleetness_N = mkTerm "fleetness_N" ;
lin fleetwood_PN = mkTerm "fleetwood_PN" ;
lin flemish_A = mkTerm "flemish_A" ;
lin flemish_N = mkTerm "flemish_N" ;
lin flesh_N = mkTerm "flesh_N" ;
lin flesh_out_V2 = mkTerm "flesh_out_V2" ;
lin flesh_wound_N = mkTerm "flesh_wound_N" ;
lin fleshiness_N = mkTerm "fleshiness_N" ;
lin fleshly_A = mkTerm "fleshly_A" ;
lin fleshy_A = mkTerm "fleshy_A" ;
lin fleur_de_lis_N = mkTerm "fleur_de_lis_N" ;
lin flex_N = mkTerm "flex_N" ;
lin flex_V2 = mkTerm "flex_V2" ;
lin flexibility_N = mkTerm "flexibility_N" ;
lin flexible_A = mkTerm "flexible_A" ;
lin flexion_N = mkTerm "flexion_N" ;
lin flexuous_A = mkTerm "flexuous_A" ;
lin flexure_N = mkTerm "flexure_N" ;
lin flibbertigibbet_N = mkTerm "flibbertigibbet_N" ;
lin flick_N = mkTerm "flick_N" ;
lin flick_V2 = mkTerm "flick_V2" ;
lin flick_knife_N = mkTerm "flick_knife_N" ;
lin flick_over_V = mkTerm "flick_over_V" ;
lin flick_through_V2 = mkTerm "flick_through_V2" ;
lin flicker_N = mkTerm "flicker_N" ;
lin flicker_V = mkTerm "flicker_V" ;
lin flickertail_N = mkTerm "flickertail_N" ;
lin flier_N = mkTerm "flier_N" ;
lin flies_N = mkTerm "flies_N" ;
lin flight_N = mkTerm "flight_N" ;
lin flight_V2 = mkTerm "flight_V2" ;
lin flightiness_N = mkTerm "flightiness_N" ;
lin flightless_A = mkTerm "flightless_A" ;
lin flighty_A = mkTerm "flighty_A" ;
lin flimsiness_N = mkTerm "flimsiness_N" ;
lin flimsy_A = mkTerm "flimsy_A" ;
lin flimsy_N = mkTerm "flimsy_N" ;
lin flinch_V = mkTerm "flinch_V" ;
lin flinders_N = mkTerm "flinders_N" ;
lin fling_N = mkTerm "fling_N" ;
lin fling_V = mkTerm "fling_V" ;
lin fling_V2 = mkTerm "fling_V2" ;
lin flint_N = mkTerm "flint_N" ;
lin flint_PN = mkTerm "flint_PN" ;
lin flintlock_N = mkTerm "flintlock_N" ;
lin flintstone_N = mkTerm "flintstone_N" ;
lin flinty_A = mkTerm "flinty_A" ;
lin flip_A = mkTerm "flip_A" ;
lin flip_N = mkTerm "flip_N" ;
lin flip_V = mkTerm "flip_V" ;
lin flip_V2 = mkTerm "flip_V2" ;
lin flip_off_V2 = mkTerm "flip_off_V2" ;
lin flip_out_V = mkTerm "flip_out_V" ;
lin flip_through_V2 = mkTerm "flip_through_V2" ;
lin flippancy_N = mkTerm "flippancy_N" ;
lin flippant_A = mkTerm "flippant_A" ;
lin flipper_N = mkTerm "flipper_N" ;
lin flirt_N = mkTerm "flirt_N" ;
lin flirt_V = mkTerm "flirt_V" ;
lin flirtation_N = mkTerm "flirtation_N" ;
lin flirtatious_A = mkTerm "flirtatious_A" ;
lin flit_N = mkTerm "flit_N" ;
lin flit_V = mkTerm "flit_V" ;
lin flitch_N = mkTerm "flitch_N" ;
lin float_N = mkTerm "float_N" ;
lin float_V = mkTerm "float_V" ;
lin floatation_N = mkTerm "floatation_N" ;
lin floater_N = mkTerm "floater_N" ;
lin floating_N = mkTerm "floating_N" ;
lin floatplane_N = mkTerm "floatplane_N" ;
lin floccose_A = mkTerm "floccose_A" ;
lin flocculation_N = mkTerm "flocculation_N" ;
lin floccule_N = mkTerm "floccule_N" ;
lin flocculent_A = mkTerm "flocculent_A" ;
lin flock_N = mkTerm "flock_N" ;
lin flock_V = mkTerm "flock_V" ;
lin flock_V2V = mkTerm "flock_V2V" ;
lin floe_N = mkTerm "floe_N" ;
lin flog_V2 = mkTerm "flog_V2" ;
lin flog_off_V2 = mkTerm "flog_off_V2" ;
lin flogger_N = mkTerm "flogger_N" ;
lin flogging_N = mkTerm "flogging_N" ;
lin flood_N = mkTerm "flood_N" ;
lin flood_V = mkTerm "flood_V" ;
lin flood_V2 = mkTerm "flood_V2" ;
lin flood_tide_N = mkTerm "flood_tide_N" ;
lin floodgate_N = mkTerm "floodgate_N" ;
lin floodhead_N = mkTerm "floodhead_N" ;
lin flooding_N = mkTerm "flooding_N" ;
lin floodlight_V2 = mkTerm "floodlight_V2" ;
lin floodlit_A = mkTerm "floodlit_A" ;
lin floodplain_N = mkTerm "floodplain_N" ;
lin floor_N = mkTerm "floor_N" ;
lin floor_V2 = mkTerm "floor_V2" ;
lin floor_it_V = mkTerm "floor_it_V" ;
lin floor_walker_N = mkTerm "floor_walker_N" ;
lin floorboard_N = mkTerm "floorboard_N" ;
lin flooring_N = mkTerm "flooring_N" ;
lin floozie_N = mkTerm "floozie_N" ;
lin floozy_N = mkTerm "floozy_N" ;
lin flop_Adv = mkTerm "flop_Adv" ;
lin flop_N = mkTerm "flop_N" ;
lin flop_V = mkTerm "flop_V" ;
lin flop_V2 = mkTerm "flop_V2" ;
lin flophouse_N = mkTerm "flophouse_N" ;
lin floppy_A = mkTerm "floppy_A" ;
lin flora_N = mkTerm "flora_N" ;
lin flora_PN = mkTerm "flora_PN" ;
lin floral_A = mkTerm "floral_A" ;
lin florence_1_PN = mkTerm "florence_1_PN" ;
lin florence_2_PN = mkTerm "florence_2_PN" ;
lin floret_N = mkTerm "floret_N" ;
lin floricultural_A = mkTerm "floricultural_A" ;
lin floriculture_N = mkTerm "floriculture_N" ;
lin florid_A = mkTerm "florid_A" ;
lin florida_PN = mkTerm "florida_PN" ;
lin florilegium_N = mkTerm "florilegium_N" ;
lin florin_N = mkTerm "florin_N" ;
lin florist_N = mkTerm "florist_N" ;
lin florrie_PN = mkTerm "florrie_PN" ;
lin floss_N = mkTerm "floss_N" ;
lin flotation_N = mkTerm "flotation_N" ;
lin flotilla_N = mkTerm "flotilla_N" ;
lin flotsam_N = mkTerm "flotsam_N" ;
lin flounce_N = mkTerm "flounce_N" ;
lin flounce_V = mkTerm "flounce_V" ;
lin flounce_V2 = mkTerm "flounce_V2" ;
lin flounce_off_V = mkTerm "flounce_off_V" ;
lin flounce_out_V = mkTerm "flounce_out_V" ;
lin flounder_N = mkTerm "flounder_N" ;
lin flounder_V = mkTerm "flounder_V" ;
lin flour_N = mkTerm "flour_N" ;
lin flour_V2 = mkTerm "flour_V2" ;
lin flourish_N = mkTerm "flourish_N" ;
lin flourish_V = mkTerm "flourish_V" ;
lin floury_A = mkTerm "floury_A" ;
lin flout_V2 = mkTerm "flout_V2" ;
lin flow_N = mkTerm "flow_N" ;
lin flow_V = mkTerm "flow_V" ;
lin flowage_N = mkTerm "flowage_N" ;
lin flower_N = mkTerm "flower_N" ;
lin flower_V = mkTerm "flower_V" ;
lin flower_girl_N = mkTerm "flower_girl_N" ;
lin flowerbed_N = mkTerm "flowerbed_N" ;
lin flowered_A = mkTerm "flowered_A" ;
lin flowering_A = mkTerm "flowering_A" ;
lin flowerless_A = mkTerm "flowerless_A" ;
lin flowerpot_N = mkTerm "flowerpot_N" ;
lin flowery_A = mkTerm "flowery_A" ;
lin floxuridine_N = mkTerm "floxuridine_N" ;
lin flu_N = mkTerm "flu_N" ;
lin fluctuate_V = mkTerm "fluctuate_V" ;
lin fluctuation_N = mkTerm "fluctuation_N" ;
lin flue_N = mkTerm "flue_N" ;
lin fluency_N = mkTerm "fluency_N" ;
lin fluent_A = mkTerm "fluent_A" ;
lin fluff_N = mkTerm "fluff_N" ;
lin fluff_V2 = mkTerm "fluff_V2" ;
lin fluff_out_V2 = mkTerm "fluff_out_V2" ;
lin fluff_up_V2 = mkTerm "fluff_up_V2" ;
lin fluffy_A = mkTerm "fluffy_A" ;
lin flugelhorn_N = mkTerm "flugelhorn_N" ;
lin fluid_A = mkTerm "fluid_A" ;
lin fluid_N = mkTerm "fluid_N" ;
lin fluidity_N = mkTerm "fluidity_N" ;
lin fluidounce_N = mkTerm "fluidounce_N" ;
lin fluidram_N = mkTerm "fluidram_N" ;
lin fluke_N = mkTerm "fluke_N" ;
lin flume_N = mkTerm "flume_N" ;
lin flummery_N = mkTerm "flummery_N" ;
lin flummox_V2 = mkTerm "flummox_V2" ;
lin flunitrazepan_N = mkTerm "flunitrazepan_N" ;
lin flunk_V = mkTerm "flunk_V" ;
lin flunk_V2 = mkTerm "flunk_V2" ;
lin flunkey_N = mkTerm "flunkey_N" ;
lin flunky_N = mkTerm "flunky_N" ;
lin fluorapatite_N = mkTerm "fluorapatite_N" ;
lin fluorescein_N = mkTerm "fluorescein_N" ;
lin fluorescence_N = mkTerm "fluorescence_N" ;
lin fluorescent_A = mkTerm "fluorescent_A" ;
lin fluorescent_N = mkTerm "fluorescent_N" ;
lin fluoridate_V2 = mkTerm "fluoridate_V2" ;
lin fluoridation_N = mkTerm "fluoridation_N" ;
lin fluoride_N = mkTerm "fluoride_N" ;
lin fluoridization_N = mkTerm "fluoridization_N" ;
lin fluoridize_V2 = mkTerm "fluoridize_V2" ;
lin fluorine_N = mkTerm "fluorine_N" ;
lin fluorite_N = mkTerm "fluorite_N" ;
lin fluoroboride_N = mkTerm "fluoroboride_N" ;
lin fluorocarbon_N = mkTerm "fluorocarbon_N" ;
lin fluorochrome_N = mkTerm "fluorochrome_N" ;
lin fluoroform_N = mkTerm "fluoroform_N" ;
lin fluoroscope_N = mkTerm "fluoroscope_N" ;
lin fluoroscopy_N = mkTerm "fluoroscopy_N" ;
lin fluorosis_N = mkTerm "fluorosis_N" ;
lin fluorouracil_N = mkTerm "fluorouracil_N" ;
lin fluosilicate_N = mkTerm "fluosilicate_N" ;
lin fluoxetine_N = mkTerm "fluoxetine_N" ;
lin fluphenazine_N = mkTerm "fluphenazine_N" ;
lin flurazepam_N = mkTerm "flurazepam_N" ;
lin flurbiprofen_N = mkTerm "flurbiprofen_N" ;
lin flurry_N = mkTerm "flurry_N" ;
lin flurry_V2 = mkTerm "flurry_V2" ;
lin flush_A = mkTerm "flush_A" ;
lin flush_Adv = mkTerm "flush_Adv" ;
lin flush_N = mkTerm "flush_N" ;
lin flush_V = mkTerm "flush_V" ;
lin flush_V2 = mkTerm "flush_V2" ;
lin flush_out_V = mkTerm "flush_out_V" ;
lin fluster_N = mkTerm "fluster_N" ;
lin fluster_V2 = mkTerm "fluster_V2" ;
lin flute_N = mkTerm "flute_N" ;
lin flute_V = mkTerm "flute_V" ;
lin flute_V2 = mkTerm "flute_V2" ;
lin fluting_N = mkTerm "fluting_N" ;
lin flutist_N = mkTerm "flutist_N" ;
lin flutter_N = mkTerm "flutter_N" ;
lin flutter_V = mkTerm "flutter_V" ;
lin flutter_V2 = mkTerm "flutter_V2" ;
lin fluvastatin_N = mkTerm "fluvastatin_N" ;
lin fluvial_A = mkTerm "fluvial_A" ;
lin flux_N = mkTerm "flux_N" ;
lin fluxmeter_N = mkTerm "fluxmeter_N" ;
lin fly_A = mkTerm "fly_A" ;
lin fly_N = mkTerm "fly_N" ;
lin fly_V = mkTerm "fly_V" ;
lin fly_V2 = mkTerm "fly_V2" ;
lin fly_about_V = mkTerm "fly_about_V" ;
lin fly_around_V = mkTerm "fly_around_V" ;
lin fly_at_V2 = mkTerm "fly_at_V2" ;
lin fly_by_V = mkTerm "fly_by_V" ;
lin fly_fish_V = mkTerm "fly_fish_V" ;
lin fly_fishing_N = mkTerm "fly_fishing_N" ;
lin fly_into_V2 = mkTerm "fly_into_V2" ;
lin fly_out_V = mkTerm "fly_out_V" ;
lin fly_swat_N = mkTerm "fly_swat_N" ;
lin fly_swatter_N = mkTerm "fly_swatter_N" ;
lin flyaway_A = mkTerm "flyaway_A" ;
lin flyblown_A = mkTerm "flyblown_A" ;
lin flycatcher_N = mkTerm "flycatcher_N" ;
lin flyer_N = mkTerm "flyer_N" ;
lin flying_bomb_N = mkTerm "flying_bomb_N" ;
lin flying_fish_N = mkTerm "flying_fish_N" ;
lin flying_fox_N = mkTerm "flying_fox_N" ;
lin flying_squad_N = mkTerm "flying_squad_N" ;
lin flyleaf_N = mkTerm "flyleaf_N" ;
lin flyover_N = mkTerm "flyover_N" ;
lin flypaper_N = mkTerm "flypaper_N" ;
lin flypast_N = mkTerm "flypast_N" ;
lin flyspeck_N = mkTerm "flyspeck_N" ;
lin flytrap_N = mkTerm "flytrap_N" ;
lin flyweight_N = mkTerm "flyweight_N" ;
lin flywheel_N = mkTerm "flywheel_N" ;
lin fm_N = mkTerm "fm_N" ;
lin fo'c'sle_N = mkTerm "fo'c'sle_N" ;
lin fo_N = mkTerm "fo_N" ;
lin foal_N = mkTerm "foal_N" ;
lin foal_V = mkTerm "foal_V" ;
lin foam_N = mkTerm "foam_N" ;
lin foam_V = mkTerm "foam_V" ;
lin foam_rubber_N = mkTerm "foam_rubber_N" ;
lin foamflower_N = mkTerm "foamflower_N" ;
lin foaminess_N = mkTerm "foaminess_N" ;
lin foamy_A = mkTerm "foamy_A" ;
lin fob_N = mkTerm "fob_N" ;
lin fob_V2 = mkTerm "fob_V2" ;
lin fob_off_V2 = mkTerm "fob_off_V2" ;
lin fob_off_on_V3 = mkTerm "fob_off_on_V3" ;
lin fob_off_onto_V3 = mkTerm "fob_off_onto_V3" ;
lin fob_off_with_V3 = mkTerm "fob_off_with_V3" ;
lin focal_A = mkTerm "focal_A" ;
lin focalization_N = mkTerm "focalization_N" ;
lin focus_N = mkTerm "focus_N" ;
lin focus_V = mkTerm "focus_V" ;
lin focus_V2 = mkTerm "focus_V2" ;
lin focus_on_V2 = mkTerm "focus_on_V2" ;
lin fodder_N = mkTerm "fodder_N" ;
lin foe_N = mkTerm "foe_N" ;
lin foetal_A = mkTerm "foetal_A" ;
lin foetus_N = mkTerm "foetus_N" ;
lin fog_N = mkTerm "fog_N" ;
lin fog_V2 = mkTerm "fog_V2" ;
lin fogbank_N = mkTerm "fogbank_N" ;
lin fogbound_A = mkTerm "fogbound_A" ;
lin fogey_N = mkTerm "fogey_N" ;
lin foggia_PN = mkTerm "foggia_PN" ;
lin foggy_A = mkTerm "foggy_A" ;
lin foghorn_N = mkTerm "foghorn_N" ;
lin foglamp_N = mkTerm "foglamp_N" ;
lin fogsignal_N = mkTerm "fogsignal_N" ;
lin fogyish_A = mkTerm "fogyish_A" ;
lin fohn_N = mkTerm "fohn_N" ;
lin foible_N = mkTerm "foible_N" ;
lin foil_N = mkTerm "foil_N" ;
lin foil_V2 = mkTerm "foil_V2" ;
lin foist_V2 = mkTerm "foist_V2" ;
lin fold_N = mkTerm "fold_N" ;
lin fold_V = mkTerm "fold_V" ;
lin fold_V2 = mkTerm "fold_V2" ;
lin fold_up_V2 = mkTerm "fold_up_V2" ;
lin foldable_A = mkTerm "foldable_A" ;
lin folder_N = mkTerm "folder_N" ;
lin folderal_N = mkTerm "folderal_N" ;
lin folderol_N = mkTerm "folderol_N" ;
lin foldout_N = mkTerm "foldout_N" ;
lin foliaceous_A = mkTerm "foliaceous_A" ;
lin foliage_N = mkTerm "foliage_N" ;
lin foliate_A = mkTerm "foliate_A" ;
lin foliation_N = mkTerm "foliation_N" ;
lin folio_N = mkTerm "folio_N" ;
lin foliolate_A = mkTerm "foliolate_A" ;
lin folium_N = mkTerm "folium_N" ;
lin folk_N = mkTerm "folk_N" ;
lin folk_dance_N = mkTerm "folk_dance_N" ;
lin folkestone_PN = mkTerm "folkestone_PN" ;
lin folklore_N = mkTerm "folklore_N" ;
lin folks_N = mkTerm "folks_N" ;
lin folksong_N = mkTerm "folksong_N" ;
lin folksy_A = mkTerm "folksy_A" ;
lin folktale_N = mkTerm "folktale_N" ;
lin follicle_N = mkTerm "follicle_N" ;
lin follicular_A = mkTerm "follicular_A" ;
lin folliculitis_N = mkTerm "folliculitis_N" ;
lin follies_N = mkTerm "follies_N" ;
lin follow_V = mkTerm "follow_V" ;
lin follow_V2 = mkTerm "follow_V2" ;
lin follow_VS = mkTerm "follow_VS" ;
lin follow_on_N = mkTerm "follow_on_N" ;
lin follow_on_V = mkTerm "follow_on_V" ;
lin follow_on_from_V2 = mkTerm "follow_on_from_V2" ;
lin follow_through_N = mkTerm "follow_through_N" ;
lin follow_through_V = mkTerm "follow_through_V" ;
lin follow_up_N = mkTerm "follow_up_N" ;
lin follow_up_V2 = mkTerm "follow_up_V2" ;
lin follower_N = mkTerm "follower_N" ;
lin following_A = mkTerm "following_A" ;
lin following_N = mkTerm "following_N" ;
lin following_Prep = mkTerm "following_Prep" ;
lin folly_N = mkTerm "folly_N" ;
lin foment_V2 = mkTerm "foment_V2" ;
lin fomentation_N = mkTerm "fomentation_N" ;
lin fomite_N = mkTerm "fomite_N" ;
lin fond_A = mkTerm "fond_A" ;
lin fondant_N = mkTerm "fondant_N" ;
lin fondle_V2 = mkTerm "fondle_V2" ;
lin fondler_N = mkTerm "fondler_N" ;
lin fondness_N = mkTerm "fondness_N" ;
lin fondue_N = mkTerm "fondue_N" ;
lin font_N = mkTerm "font_N" ;
lin fontanelle_N = mkTerm "fontanelle_N" ;
lin fontsize_N = mkTerm "fontsize_N" ;
lin foochow_PN = mkTerm "foochow_PN" ;
lin food_N = mkTerm "food_N" ;
lin foodless_A = mkTerm "foodless_A" ;
lin foodstuff_N = mkTerm "foodstuff_N" ;
lin fool_N = mkTerm "fool_N" ;
lin fool_V2 = mkTerm "fool_V2" ;
lin fool_about_V = mkTerm "fool_about_V" ;
lin fool_around_V = mkTerm "fool_around_V" ;
lin fool_with_V2 = mkTerm "fool_with_V2" ;
lin foolery_N = mkTerm "foolery_N" ;
lin foolhardiness_N = mkTerm "foolhardiness_N" ;
lin foolhardy_A = mkTerm "foolhardy_A" ;
lin foolish_A = mkTerm "foolish_A" ;
lin foolishness_N = mkTerm "foolishness_N" ;
lin foolproof_A = mkTerm "foolproof_A" ;
lin foolscap_N = mkTerm "foolscap_N" ;
lin foot_N = mkTerm "foot_N" ;
lin foot_V = mkTerm "foot_V" ;
lin foot_V2 = mkTerm "foot_V2" ;
lin foot_and_mouth_A = mkTerm "foot_and_mouth_A" ;
lin foot_and_mouth_N = mkTerm "foot_and_mouth_N" ;
lin foot_bath_N = mkTerm "foot_bath_N" ;
lin foot_pound_N = mkTerm "foot_pound_N" ;
lin foot_race_N = mkTerm "foot_race_N" ;
lin foot_rot_N = mkTerm "foot_rot_N" ;
lin footage_N = mkTerm "footage_N" ;
lin football_N = mkTerm "football_N" ;
lin footballer_N = mkTerm "footballer_N" ;
lin footboard_N = mkTerm "footboard_N" ;
lin footbridge_N = mkTerm "footbridge_N" ;
lin footcandle_N = mkTerm "footcandle_N" ;
lin footedness_N = mkTerm "footedness_N" ;
lin footer_N = mkTerm "footer_N" ;
lin footfall_N = mkTerm "footfall_N" ;
lin footfault_N = mkTerm "footfault_N" ;
lin foothill_N = mkTerm "foothill_N" ;
lin foothold_N = mkTerm "foothold_N" ;
lin footing_N = mkTerm "footing_N" ;
lin footle_V = mkTerm "footle_V" ;
lin footle_V2 = mkTerm "footle_V2" ;
lin footless_A = mkTerm "footless_A" ;
lin footlights_N = mkTerm "footlights_N" ;
lin footlocker_N = mkTerm "footlocker_N" ;
lin footloose_A = mkTerm "footloose_A" ;
lin footman_N = mkTerm "footman_N" ;
lin footmark_N = mkTerm "footmark_N" ;
lin footnote_N = mkTerm "footnote_N" ;
lin footpad_N = mkTerm "footpad_N" ;
lin footpath_N = mkTerm "footpath_N" ;
lin footplate_N = mkTerm "footplate_N" ;
lin footprint_N = mkTerm "footprint_N" ;
lin footslog_V = mkTerm "footslog_V" ;
lin footslogger_N = mkTerm "footslogger_N" ;
lin footsore_A = mkTerm "footsore_A" ;
lin footstep_N = mkTerm "footstep_N" ;
lin footstool_N = mkTerm "footstool_N" ;
lin footsure_A = mkTerm "footsure_A" ;
lin footwall_N = mkTerm "footwall_N" ;
lin footwear_N = mkTerm "footwear_N" ;
lin footwork_N = mkTerm "footwork_N" ;
lin fop_N = mkTerm "fop_N" ;
lin foppish_A = mkTerm "foppish_A" ;
lin foppishness_N = mkTerm "foppishness_N" ;
lin for_Adv = mkTerm "for_Adv" ;
lin for_PConj = mkTerm "for_PConj" ;
lin for_example_Adv = mkTerm "for_example_Adv" ;
lin for_instance_Adv = mkTerm "for_instance_Adv" ;
lin for_starters_Adv = mkTerm "for_starters_Adv" ;
lin for_sure_Adv = mkTerm "for_sure_Adv" ;
lin for_the_sake_of_Prep = mkTerm "for_the_sake_of_Prep" ;
lin forage_N = mkTerm "forage_N" ;
lin forage_V = mkTerm "forage_V" ;
lin forager_N = mkTerm "forager_N" ;
lin foraging_N = mkTerm "foraging_N" ;
lin foram_N = mkTerm "foram_N" ;
lin foramen_N = mkTerm "foramen_N" ;
lin foray_N = mkTerm "foray_N" ;
lin foray_V = mkTerm "foray_V" ;
lin forbear_N = mkTerm "forbear_N" ;
lin forbear_V = mkTerm "forbear_V" ;
lin forbear_V2 = mkTerm "forbear_V2" ;
lin forbearance_N = mkTerm "forbearance_N" ;
lin forbid_V2 = mkTerm "forbid_V2" ;
lin forbidding_A = mkTerm "forbidding_A" ;
lin forby_Prep = mkTerm "forby_Prep" ;
lin force_N = mkTerm "force_N" ;
lin force_V = mkTerm "force_V" ;
lin force_V2 = mkTerm "force_V2" ;
lin force_V2V = mkTerm "force_V2V" ;
lin force_VS = mkTerm "force_VS" ;
lin force_feed_V2 = mkTerm "force_feed_V2" ;
lin force_land_V = mkTerm "force_land_V" ;
lin force_land_V2 = mkTerm "force_land_V2" ;
lin force_majeure_N = mkTerm "force_majeure_N" ;
lin force_out_V = mkTerm "force_out_V" ;
lin forceful_A = mkTerm "forceful_A" ;
lin forcefulness_N = mkTerm "forcefulness_N" ;
lin forceless_A = mkTerm "forceless_A" ;
lin forcemeat_N = mkTerm "forcemeat_N" ;
lin forceps_N = mkTerm "forceps_N" ;
lin forcible_A = mkTerm "forcible_A" ;
lin forcipate_A = mkTerm "forcipate_A" ;
lin ford_N = mkTerm "ford_N" ;
lin ford_V2 = mkTerm "ford_V2" ;
lin fordable_A = mkTerm "fordable_A" ;
lin fore_A = mkTerm "fore_A" ;
lin fore_Adv = mkTerm "fore_Adv" ;
lin fore_N = mkTerm "fore_N" ;
lin forearm_N = mkTerm "forearm_N" ;
lin forearm_V2 = mkTerm "forearm_V2" ;
lin forebear_N = mkTerm "forebear_N" ;
lin forebode_V2 = mkTerm "forebode_V2" ;
lin foreboding_N = mkTerm "foreboding_N" ;
lin forebrain_N = mkTerm "forebrain_N" ;
lin forecast_N = mkTerm "forecast_N" ;
lin forecast_V = mkTerm "forecast_V" ;
lin forecast_V2 = mkTerm "forecast_V2" ;
lin forecast_VS = mkTerm "forecast_VS" ;
lin forecaster_N = mkTerm "forecaster_N" ;
lin forecastle_N = mkTerm "forecastle_N" ;
lin foreclose_V = mkTerm "foreclose_V" ;
lin foreclose_V2 = mkTerm "foreclose_V2" ;
lin foreclosure_N = mkTerm "foreclosure_N" ;
lin forecourt_N = mkTerm "forecourt_N" ;
lin foredeck_N = mkTerm "foredeck_N" ;
lin foredoom_V2 = mkTerm "foredoom_V2" ;
lin forefather_N = mkTerm "forefather_N" ;
lin forefinger_N = mkTerm "forefinger_N" ;
lin forefoot_N = mkTerm "forefoot_N" ;
lin forefront_N = mkTerm "forefront_N" ;
lin foregather_V = mkTerm "foregather_V" ;
lin forego_V = mkTerm "forego_V" ;
lin forego_V2 = mkTerm "forego_V2" ;
lin foreground_N = mkTerm "foreground_N" ;
lin forehand_A = mkTerm "forehand_A" ;
lin forehand_N = mkTerm "forehand_N" ;
lin forehanded_A = mkTerm "forehanded_A" ;
lin forehead_N = mkTerm "forehead_N" ;
lin foreign_1_A = mkTerm "foreign_1_A" ;
lin foreign_2_A = mkTerm "foreign_2_A" ;
lin foreigner_N = mkTerm "foreigner_N" ;
lin foreignness_N = mkTerm "foreignness_N" ;
lin foreknow_V = mkTerm "foreknow_V" ;
lin foreknow_V2 = mkTerm "foreknow_V2" ;
lin foreknowledge_N = mkTerm "foreknowledge_N" ;
lin foreland_N = mkTerm "foreland_N" ;
lin foreleg_N = mkTerm "foreleg_N" ;
lin forelimb_N = mkTerm "forelimb_N" ;
lin forelock_N = mkTerm "forelock_N" ;
lin foreman_N = mkTerm "foreman_N" ;
lin foremanship_N = mkTerm "foremanship_N" ;
lin foremast_N = mkTerm "foremast_N" ;
lin foremost_A = mkTerm "foremost_A" ;
lin foremost_Adv = mkTerm "foremost_Adv" ;
lin foremother_N = mkTerm "foremother_N" ;
lin forename_N = mkTerm "forename_N" ;
lin forenenst_Prep = mkTerm "forenenst_Prep" ;
lin forenoon_N = mkTerm "forenoon_N" ;
lin forensic_A = mkTerm "forensic_A" ;
lin forensics_N = mkTerm "forensics_N" ;
lin foreordain_V2 = mkTerm "foreordain_V2" ;
lin forepaw_N = mkTerm "forepaw_N" ;
lin foreperson_N = mkTerm "foreperson_N" ;
lin foreplay_N = mkTerm "foreplay_N" ;
lin forequarter_N = mkTerm "forequarter_N" ;
lin forerunner_N = mkTerm "forerunner_N" ;
lin foresail_N = mkTerm "foresail_N" ;
lin foresee_V2 = mkTerm "foresee_V2" ;
lin foreseeable_A = mkTerm "foreseeable_A" ;
lin foreshadow_V2 = mkTerm "foreshadow_V2" ;
lin foreshank_N = mkTerm "foreshank_N" ;
lin foreshock_N = mkTerm "foreshock_N" ;
lin foreshore_N = mkTerm "foreshore_N" ;
lin foreshorten_V2 = mkTerm "foreshorten_V2" ;
lin foresight_N = mkTerm "foresight_N" ;
lin foreskin_N = mkTerm "foreskin_N" ;
lin forest_N = mkTerm "forest_N" ;
lin forestall_V2 = mkTerm "forestall_V2" ;
lin forestay_N = mkTerm "forestay_N" ;
lin forested_A = mkTerm "forested_A" ;
lin forester_N = mkTerm "forester_N" ;
lin forestiera_N = mkTerm "forestiera_N" ;
lin forestry_N = mkTerm "forestry_N" ;
lin foreswear_V2 = mkTerm "foreswear_V2" ;
lin foretaste_N = mkTerm "foretaste_N" ;
lin foretell_V2 = mkTerm "foretell_V2" ;
lin forethought_N = mkTerm "forethought_N" ;
lin forethoughtful_A = mkTerm "forethoughtful_A" ;
lin foretop_N = mkTerm "foretop_N" ;
lin forever_Adv = mkTerm "forever_Adv" ;
lin forewarn_V2 = mkTerm "forewarn_V2" ;
lin forewarning_N = mkTerm "forewarning_N" ;
lin forewing_N = mkTerm "forewing_N" ;
lin forewoman_N = mkTerm "forewoman_N" ;
lin foreword_N = mkTerm "foreword_N" ;
lin forfar_PN = mkTerm "forfar_PN" ;
lin forfeit_N = mkTerm "forfeit_N" ;
lin forfeit_V2 = mkTerm "forfeit_V2" ;
lin forfeiture_N = mkTerm "forfeiture_N" ;
lin forgather_V = mkTerm "forgather_V" ;
lin forge_N = mkTerm "forge_N" ;
lin forge_V = mkTerm "forge_V" ;
lin forge_V2 = mkTerm "forge_V2" ;
lin forge_ahead_V = mkTerm "forge_ahead_V" ;
lin forger_N = mkTerm "forger_N" ;
lin forgery_N = mkTerm "forgery_N" ;
lin forget_V = mkTerm "forget_V" ;
lin forget_V2 = mkTerm "forget_V2" ;
lin forget_VS = mkTerm "forget_VS" ;
lin forget_me_not_N = mkTerm "forget_me_not_N" ;
lin forgetful_A = mkTerm "forgetful_A" ;
lin forgetfulness_N = mkTerm "forgetfulness_N" ;
lin forgettable_A = mkTerm "forgettable_A" ;
lin forging_N = mkTerm "forging_N" ;
lin forgivable_A = mkTerm "forgivable_A" ;
lin forgive_V = mkTerm "forgive_V" ;
lin forgive_V2 = mkTerm "forgive_V2" ;
lin forgiveness_N = mkTerm "forgiveness_N" ;
lin forgivingly_Adv = mkTerm "forgivingly_Adv" ;
lin forgivingness_N = mkTerm "forgivingness_N" ;
lin forgo_V2 = mkTerm "forgo_V2" ;
lin forint_N = mkTerm "forint_N" ;
lin fork_1_N = mkTerm "fork_1_N" ;
lin fork_3_N = mkTerm "fork_3_N" ;
lin fork_4_N = mkTerm "fork_4_N" ;
lin fork_V = mkTerm "fork_V" ;
lin fork_V2 = mkTerm "fork_V2" ;
lin fork_out_V = mkTerm "fork_out_V" ;
lin fork_over_V = mkTerm "fork_over_V" ;
lin forklift_N = mkTerm "forklift_N" ;
lin forli_PN = mkTerm "forli_PN" ;
lin forlorn_A = mkTerm "forlorn_A" ;
lin forlornness_N = mkTerm "forlornness_N" ;
lin form_N = mkTerm "form_N" ;
lin form_V = mkTerm "form_V" ;
lin form_V2 = mkTerm "form_V2" ;
lin formal_A = mkTerm "formal_A" ;
lin formaldehyde_N = mkTerm "formaldehyde_N" ;
lin formalin_N = mkTerm "formalin_N" ;
lin formalism_N = mkTerm "formalism_N" ;
lin formalistic_A = mkTerm "formalistic_A" ;
lin formality_N = mkTerm "formality_N" ;
lin formalization_N = mkTerm "formalization_N" ;
lin formalize_V2 = mkTerm "formalize_V2" ;
lin formalwear_N = mkTerm "formalwear_N" ;
lin format_N = mkTerm "format_N" ;
lin formation_N = mkTerm "formation_N" ;
lin formative_A = mkTerm "formative_A" ;
lin formative_N = mkTerm "formative_N" ;
lin formby_PN = mkTerm "formby_PN" ;
lin former_A = mkTerm "former_A" ;
lin former_N = mkTerm "former_N" ;
lin formic_A = mkTerm "formic_A" ;
lin formica_N = mkTerm "formica_N" ;
lin formication_N = mkTerm "formication_N" ;
lin formidability_N = mkTerm "formidability_N" ;
lin formidable_A = mkTerm "formidable_A" ;
lin formless_A = mkTerm "formless_A" ;
lin formosa_PN = mkTerm "formosa_PN" ;
lin formula_N = mkTerm "formula_N" ;
lin formulaic_A = mkTerm "formulaic_A" ;
lin formulary_A = mkTerm "formulary_A" ;
lin formulary_N = mkTerm "formulary_N" ;
lin formulate_V2 = mkTerm "formulate_V2" ;
lin formulation_N = mkTerm "formulation_N" ;
lin fornenst_Prep = mkTerm "fornenst_Prep" ;
lin fornent_Prep = mkTerm "fornent_Prep" ;
lin fornicate_V = mkTerm "fornicate_V" ;
lin fornication_N = mkTerm "fornication_N" ;
lin fornix_N = mkTerm "fornix_N" ;
lin forrader_Adv = mkTerm "forrader_Adv" ;
lin forsake_V2 = mkTerm "forsake_V2" ;
lin forsaking_N = mkTerm "forsaking_N" ;
lin forsooth_Adv = mkTerm "forsooth_Adv" ;
lin forssa_PN = mkTerm "forssa_PN" ;
lin forswear_V2 = mkTerm "forswear_V2" ;
lin forsythia_N = mkTerm "forsythia_N" ;
lin fort_N = mkTerm "fort_N" ;
lin fort_lauderdale_PN = mkTerm "fort_lauderdale_PN" ;
lin fort_william_PN = mkTerm "fort_william_PN" ;
lin fort_worth_PN = mkTerm "fort_worth_PN" ;
lin fortaleza_PN = mkTerm "fortaleza_PN" ;
lin forte_A = mkTerm "forte_A" ;
lin forte_Adv = mkTerm "forte_Adv" ;
lin forte_N = mkTerm "forte_N" ;
lin fortemente_A = mkTerm "fortemente_A" ;
lin forth_Adv = mkTerm "forth_Adv" ;
lin forthcoming_A = mkTerm "forthcoming_A" ;
lin forthright_A = mkTerm "forthright_A" ;
lin forthwith_Adv = mkTerm "forthwith_Adv" ;
lin fortification_N = mkTerm "fortification_N" ;
lin fortify_V2 = mkTerm "fortify_V2" ;
lin fortissimo_A = mkTerm "fortissimo_A" ;
lin fortissimo_Adv = mkTerm "fortissimo_Adv" ;
lin fortitude_N = mkTerm "fortitude_N" ;
lin fortnight_N = mkTerm "fortnight_N" ;
lin fortnightly_A = mkTerm "fortnightly_A" ;
lin fortnightly_Adv = mkTerm "fortnightly_Adv" ;
lin fortress_N = mkTerm "fortress_N" ;
lin fortuitous_A = mkTerm "fortuitous_A" ;
lin fortuitousness_N = mkTerm "fortuitousness_N" ;
lin fortunate_A = mkTerm "fortunate_A" ;
lin fortunately_Adv = mkTerm "fortunately_Adv" ;
lin fortune_N = mkTerm "fortune_N" ;
lin fortuneteller_N = mkTerm "fortuneteller_N" ;
lin fortunetelling_N = mkTerm "fortunetelling_N" ;
lin forty_N = mkTerm "forty_N" ;
lin fortyish_A = mkTerm "fortyish_A" ;
lin forum_N = mkTerm "forum_N" ;
lin forward_A = mkTerm "forward_A" ;
lin forward_Adv = mkTerm "forward_Adv" ;
lin forward_N = mkTerm "forward_N" ;
lin forward_V2 = mkTerm "forward_V2" ;
lin forwarding_N = mkTerm "forwarding_N" ;
lin forwardness_N = mkTerm "forwardness_N" ;
lin forwards_Adv = mkTerm "forwards_Adv" ;
lin foryml_N = mkTerm "foryml_N" ;
lin fossa_N = mkTerm "fossa_N" ;
lin fosse_N = mkTerm "fosse_N" ;
lin fossil_A = mkTerm "fossil_A" ;
lin fossil_N = mkTerm "fossil_N" ;
lin fossiliferous_A = mkTerm "fossiliferous_A" ;
lin fossilization_N = mkTerm "fossilization_N" ;
lin fossilize_V = mkTerm "fossilize_V" ;
lin fossilize_V2 = mkTerm "fossilize_V2" ;
lin fossorial_A = mkTerm "fossorial_A" ;
lin foster_A = mkTerm "foster_A" ;
lin foster_V2 = mkTerm "foster_V2" ;
lin foster_brother_N = mkTerm "foster_brother_N" ;
lin foster_child_N = mkTerm "foster_child_N" ;
lin foster_father_N = mkTerm "foster_father_N" ;
lin foster_mother_N = mkTerm "foster_mother_N" ;
lin foster_parent_N = mkTerm "foster_parent_N" ;
lin foster_sister_N = mkTerm "foster_sister_N" ;
lin fostering_N = mkTerm "fostering_N" ;
lin fothergilla_N = mkTerm "fothergilla_N" ;
lin foul_A = mkTerm "foul_A" ;
lin foul_N = mkTerm "foul_N" ;
lin foul_V = mkTerm "foul_V" ;
lin foul_V2 = mkTerm "foul_V2" ;
lin foul_mouthed_A = mkTerm "foul_mouthed_A" ;
lin foul_spoken_A = mkTerm "foul_spoken_A" ;
lin foulard_N = mkTerm "foulard_N" ;
lin foulness_N = mkTerm "foulness_N" ;
lin found_N = mkTerm "found_N" ;
lin found_V2 = mkTerm "found_V2" ;
lin foundation_N = mkTerm "foundation_N" ;
lin foundation_stone_N = mkTerm "foundation_stone_N" ;
lin founder_N = mkTerm "founder_N" ;
lin founder_V = mkTerm "founder_V" ;
lin founder_V2 = mkTerm "founder_V2" ;
lin foundering_N = mkTerm "foundering_N" ;
lin foundling_N = mkTerm "foundling_N" ;
lin foundress_N = mkTerm "foundress_N" ;
lin foundry_N = mkTerm "foundry_N" ;
lin fount_N = mkTerm "fount_N" ;
lin fountain_N = mkTerm "fountain_N" ;
lin fountain_head_N = mkTerm "fountain_head_N" ;
lin fountain_pen_N = mkTerm "fountain_pen_N" ;
lin four_in_hand_N = mkTerm "four_in_hand_N" ;
lin four_part_A = mkTerm "four_part_A" ;
lin four_ply_A = mkTerm "four_ply_A" ;
lin four_poster_N = mkTerm "four_poster_N" ;
lin four_pounder_N = mkTerm "four_pounder_N" ;
lin four_wheeler_N = mkTerm "four_wheeler_N" ;
lin fourfold_A = mkTerm "fourfold_A" ;
lin fourfold_Adv = mkTerm "fourfold_Adv" ;
lin fourhanded_A = mkTerm "fourhanded_A" ;
lin fourpence_N = mkTerm "fourpence_N" ;
lin fourpenny_A = mkTerm "fourpenny_A" ;
lin fourscore_A = mkTerm "fourscore_A" ;
lin fourscore_N = mkTerm "fourscore_N" ;
lin foursome_N = mkTerm "foursome_N" ;
lin foursquare_A = mkTerm "foursquare_A" ;
lin foursquare_Adv = mkTerm "foursquare_Adv" ;
lin fovea_N = mkTerm "fovea_N" ;
lin fowey_PN = mkTerm "fowey_PN" ;
lin fowl_N = mkTerm "fowl_N" ;
lin fowl_V = mkTerm "fowl_V" ;
lin fowl_run_N = mkTerm "fowl_run_N" ;
lin fowler_N = mkTerm "fowler_N" ;
lin fowlingpiece_N = mkTerm "fowlingpiece_N" ;
lin fowlpest_N = mkTerm "fowlpest_N" ;
lin fox_N = mkTerm "fox_N" ;
lin fox_V2 = mkTerm "fox_V2" ;
lin fox_terrier_N = mkTerm "fox_terrier_N" ;
lin foxglove_N = mkTerm "foxglove_N" ;
lin foxhole_N = mkTerm "foxhole_N" ;
lin foxhound_N = mkTerm "foxhound_N" ;
lin foxhunt_N = mkTerm "foxhunt_N" ;
lin foxhunt_V = mkTerm "foxhunt_V" ;
lin foxhunter_N = mkTerm "foxhunter_N" ;
lin foxtail_N = mkTerm "foxtail_N" ;
lin foxtrot_N = mkTerm "foxtrot_N" ;
lin foxy_A = mkTerm "foxy_A" ;
lin foyer_N = mkTerm "foyer_N" ;
lin fr_PN = mkTerm "fr_PN" ;
lin fracas_N = mkTerm "fracas_N" ;
lin fractal_N = mkTerm "fractal_N" ;
lin fraction_N = mkTerm "fraction_N" ;
lin fractional_A = mkTerm "fractional_A" ;
lin fractionation_N = mkTerm "fractionation_N" ;
lin fractious_A = mkTerm "fractious_A" ;
lin fractiousness_N = mkTerm "fractiousness_N" ;
lin fracture_N = mkTerm "fracture_N" ;
lin fracture_V = mkTerm "fracture_V" ;
lin fracture_V2 = mkTerm "fracture_V2" ;
lin fragile_A = mkTerm "fragile_A" ;
lin fragility_N = mkTerm "fragility_N" ;
lin fragment_N = mkTerm "fragment_N" ;
lin fragment_V = mkTerm "fragment_V" ;
lin fragment_V2 = mkTerm "fragment_V2" ;
lin fragmental_A = mkTerm "fragmental_A" ;
lin fragmentary_A = mkTerm "fragmentary_A" ;
lin fragmentation_N = mkTerm "fragmentation_N" ;
lin fragrance_N = mkTerm "fragrance_N" ;
lin fragrant_A = mkTerm "fragrant_A" ;
lin frail_A = mkTerm "frail_A" ;
lin frail_N = mkTerm "frail_N" ;
lin frailty_N = mkTerm "frailty_N" ;
lin fraise_N = mkTerm "fraise_N" ;
lin frame_N = mkTerm "frame_N" ;
lin frame_V = mkTerm "frame_V" ;
lin frame_V2 = mkTerm "frame_V2" ;
lin frame_up_N = mkTerm "frame_up_N" ;
lin framer_N = mkTerm "framer_N" ;
lin framework_N = mkTerm "framework_N" ;
lin framing_N = mkTerm "framing_N" ;
lin frampton_cotterell_PN = mkTerm "frampton_cotterell_PN" ;
lin fran_PN = mkTerm "fran_PN" ;
lin franc_N = mkTerm "franc_N" ;
lin france_PN = mkTerm "france_PN" ;
lin frances_PN = mkTerm "frances_PN" ;
lin franchise_N = mkTerm "franchise_N" ;
lin francis_PN = mkTerm "francis_PN" ;
lin franciscan_A = mkTerm "franciscan_A" ;
lin franciscan_N = mkTerm "franciscan_N" ;
lin francium_N = mkTerm "francium_N" ;
lin frangible_A = mkTerm "frangible_A" ;
lin frangipane_N = mkTerm "frangipane_N" ;
lin frangipani_N = mkTerm "frangipani_N" ;
lin frank_A = mkTerm "frank_A" ;
lin frank_N = mkTerm "frank_N" ;
lin frank_PN = mkTerm "frank_PN" ;
lin frank_V2 = mkTerm "frank_V2" ;
lin frankfurt_PN = mkTerm "frankfurt_PN" ;
lin frankfurter_N = mkTerm "frankfurter_N" ;
lin frankie_PN = mkTerm "frankie_PN" ;
lin frankincense_N = mkTerm "frankincense_N" ;
lin franking_machine_N = mkTerm "franking_machine_N" ;
lin franklin_N = mkTerm "franklin_N" ;
lin frankly_Adv = mkTerm "frankly_Adv" ;
lin frankness_N = mkTerm "frankness_N" ;
lin frantic_A = mkTerm "frantic_A" ;
lin frappe_N = mkTerm "frappe_N" ;
lin fraserburgh_PN = mkTerm "fraserburgh_PN" ;
lin fraternal_A = mkTerm "fraternal_A" ;
lin fraternity_N = mkTerm "fraternity_N" ;
lin fraternization_N = mkTerm "fraternization_N" ;
lin fraternize_V = mkTerm "fraternize_V" ;
lin fratricide_N = mkTerm "fratricide_N" ;
lin frau_N = mkTerm "frau_N" ;
lin fraud_N = mkTerm "fraud_N" ;
lin fraudulence_N = mkTerm "fraudulence_N" ;
lin fraudulent_A = mkTerm "fraudulent_A" ;
lin fraught_A = mkTerm "fraught_A" ;
lin fraulein_N = mkTerm "fraulein_N" ;
lin fraxinella_N = mkTerm "fraxinella_N" ;
lin fray_N = mkTerm "fray_N" ;
lin fray_V = mkTerm "fray_V" ;
lin fray_V2 = mkTerm "fray_V2" ;
lin frazzle_N = mkTerm "frazzle_N" ;
lin freak_N = mkTerm "freak_N" ;
lin freak_V = mkTerm "freak_V" ;
lin freak_V2 = mkTerm "freak_V2" ;
lin freak_out_N = mkTerm "freak_out_N" ;
lin freak_out_V2 = mkTerm "freak_out_V2" ;
lin freakish_A = mkTerm "freakish_A" ;
lin freakishness_N = mkTerm "freakishness_N" ;
lin freaky_A = mkTerm "freaky_A" ;
lin freckle_N = mkTerm "freckle_N" ;
lin freckle_V = mkTerm "freckle_V" ;
lin freckle_V2 = mkTerm "freckle_V2" ;
lin freckleton_PN = mkTerm "freckleton_PN" ;
lin fred_PN = mkTerm "fred_PN" ;
lin freda_PN = mkTerm "freda_PN" ;
lin freddie_PN = mkTerm "freddie_PN" ;
lin freddy_PN = mkTerm "freddy_PN" ;
lin frederick_PN = mkTerm "frederick_PN" ;
lin frederiksberg_PN = mkTerm "frederiksberg_PN" ;
lin free_1_A = mkTerm "free_1_A" ;
lin free_2_A = mkTerm "free_2_A" ;
lin free_3_A = mkTerm "free_3_A" ;
lin free_N = mkTerm "free_N" ;
lin free_V2 = mkTerm "free_V2" ;
lin free_V2V = mkTerm "free_V2V" ;
lin free_and_easy_A = mkTerm "free_and_easy_A" ;
lin free_for_all_N = mkTerm "free_for_all_N" ;
lin free_handed_A = mkTerm "free_handed_A" ;
lin free_list_N = mkTerm "free_list_N" ;
lin free_liver_N = mkTerm "free_liver_N" ;
lin free_living_N = mkTerm "free_living_N" ;
lin free_of_A2 = mkTerm "free_of_A2" ;
lin free_range_A = mkTerm "free_range_A" ;
lin free_spoken_A = mkTerm "free_spoken_A" ;
lin free_standing_A = mkTerm "free_standing_A" ;
lin free_thinker_N = mkTerm "free_thinker_N" ;
lin free_thinking_A = mkTerm "free_thinking_A" ;
lin free_thought_N = mkTerm "free_thought_N" ;
lin free_trader_N = mkTerm "free_trader_N" ;
lin free_up_V2 = mkTerm "free_up_V2" ;
lin freebie_N = mkTerm "freebie_N" ;
lin freebooter_N = mkTerm "freebooter_N" ;
lin freeborn_A = mkTerm "freeborn_A" ;
lin freedman_N = mkTerm "freedman_N" ;
lin freedom_N = mkTerm "freedom_N" ;
lin freehand_A = mkTerm "freehand_A" ;
lin freehold_N = mkTerm "freehold_N" ;
lin freeholder_N = mkTerm "freeholder_N" ;
lin freelance_A = mkTerm "freelance_A" ;
lin freelance_N = mkTerm "freelance_N" ;
lin freelance_V = mkTerm "freelance_V" ;
lin freelancer_N = mkTerm "freelancer_N" ;
lin freeloader_N = mkTerm "freeloader_N" ;
lin freemail_N = mkTerm "freemail_N" ;
lin freeman_N = mkTerm "freeman_N" ;
lin freemason_N = mkTerm "freemason_N" ;
lin freemasonry_N = mkTerm "freemasonry_N" ;
lin freesia_N = mkTerm "freesia_N" ;
lin freestone_N = mkTerm "freestone_N" ;
lin freestyle_N = mkTerm "freestyle_N" ;
lin freetail_N = mkTerm "freetail_N" ;
lin freeware_N = mkTerm "freeware_N" ;
lin freeway_N = mkTerm "freeway_N" ;
lin freewheel_N = mkTerm "freewheel_N" ;
lin freewheel_V = mkTerm "freewheel_V" ;
lin freewill_A = mkTerm "freewill_A" ;
lin freeze_N = mkTerm "freeze_N" ;
lin freeze_V = mkTerm "freeze_V" ;
lin freeze_V2 = mkTerm "freeze_V2" ;
lin freeze_out_V2 = mkTerm "freeze_out_V2" ;
lin freeze_over_V = mkTerm "freeze_over_V" ;
lin freeze_up_V = mkTerm "freeze_up_V" ;
lin freezer_N = mkTerm "freezer_N" ;
lin freezing_mixture_N = mkTerm "freezing_mixture_N" ;
lin freezing_point_N = mkTerm "freezing_point_N" ;
lin freiburg_PN = mkTerm "freiburg_PN" ;
lin freight_N = mkTerm "freight_N" ;
lin freight_V2 = mkTerm "freight_V2" ;
lin freight_train_N = mkTerm "freight_train_N" ;
lin freighter_N = mkTerm "freighter_N" ;
lin freightliner_N = mkTerm "freightliner_N" ;
lin frenchFem_N = mkTerm "frenchFem_N" ;
lin frenchMasc_N = mkTerm "frenchMasc_N" ;
lin french_A = mkTerm "french_A" ;
lin frenetic_A = mkTerm "frenetic_A" ;
lin frenzied_A = mkTerm "frenzied_A" ;
lin frenzy_N = mkTerm "frenzy_N" ;
lin frequency_N = mkTerm "frequency_N" ;
lin frequent_A = mkTerm "frequent_A" ;
lin frequent_V2 = mkTerm "frequent_V2" ;
lin frequentative_N = mkTerm "frequentative_N" ;
lin fresco_N = mkTerm "fresco_N" ;
lin fresco_V2 = mkTerm "fresco_V2" ;
lin fresh_A = mkTerm "fresh_A" ;
lin fresh_Adv = mkTerm "fresh_Adv" ;
lin freshen_V = mkTerm "freshen_V" ;
lin freshen_V2 = mkTerm "freshen_V2" ;
lin freshen_up_V = mkTerm "freshen_up_V" ;
lin freshen_up_V2 = mkTerm "freshen_up_V2" ;
lin freshener_N = mkTerm "freshener_N" ;
lin fresher_N = mkTerm "fresher_N" ;
lin freshet_N = mkTerm "freshet_N" ;
lin freshman_A = mkTerm "freshman_A" ;
lin freshman_N = mkTerm "freshman_N" ;
lin freshness_N = mkTerm "freshness_N" ;
lin freshwater_A = mkTerm "freshwater_A" ;
lin freshwater_N = mkTerm "freshwater_N" ;
lin freshwater_PN = mkTerm "freshwater_PN" ;
lin fret_N = mkTerm "fret_N" ;
lin fret_V = mkTerm "fret_V" ;
lin fret_V2 = mkTerm "fret_V2" ;
lin fret_VS = mkTerm "fret_VS" ;
lin fretful_A = mkTerm "fretful_A" ;
lin fretsaw_N = mkTerm "fretsaw_N" ;
lin fretwork_N = mkTerm "fretwork_N" ;
lin freudian_A = mkTerm "freudian_A" ;
lin fri_PN = mkTerm "fri_PN" ;
lin friability_N = mkTerm "friability_N" ;
lin friable_A = mkTerm "friable_A" ;
lin friar_N = mkTerm "friar_N" ;
lin friary_N = mkTerm "friary_N" ;
lin fricandeau_N = mkTerm "fricandeau_N" ;
lin fricassee_N = mkTerm "fricassee_N" ;
lin fricassee_V2 = mkTerm "fricassee_V2" ;
lin fricative_A = mkTerm "fricative_A" ;
lin fricative_N = mkTerm "fricative_N" ;
lin friction_N = mkTerm "friction_N" ;
lin frictional_A = mkTerm "frictional_A" ;
lin frictionless_A = mkTerm "frictionless_A" ;
lin fridge_N = mkTerm "fridge_N" ;
lin friedcake_N = mkTerm "friedcake_N" ;
lin friend_N = mkTerm "friend_N" ;
lin friendless_A = mkTerm "friendless_A" ;
lin friendlessness_N = mkTerm "friendlessness_N" ;
lin friendliness_N = mkTerm "friendliness_N" ;
lin friendly_A = mkTerm "friendly_A" ;
lin friendly_N = mkTerm "friendly_N" ;
lin friendship_N = mkTerm "friendship_N" ;
lin frier_N = mkTerm "frier_N" ;
lin frieze_N = mkTerm "frieze_N" ;
lin frigate_N = mkTerm "frigate_N" ;
lin fright_N = mkTerm "fright_N" ;
lin fright_V2 = mkTerm "fright_V2" ;
lin frighten_V2 = mkTerm "frighten_V2" ;
lin frighten_away_V2 = mkTerm "frighten_away_V2" ;
lin frighten_off_V2 = mkTerm "frighten_off_V2" ;
lin frightened_A = mkTerm "frightened_A" ;
lin frightening_A = mkTerm "frightening_A" ;
lin frightful_A = mkTerm "frightful_A" ;
lin frightfulness_N = mkTerm "frightfulness_N" ;
lin frigid_A = mkTerm "frigid_A" ;
lin frigidity_N = mkTerm "frigidity_N" ;
lin frigorific_A = mkTerm "frigorific_A" ;
lin frijole_N = mkTerm "frijole_N" ;
lin frill_N = mkTerm "frill_N" ;
lin frilled_A = mkTerm "frilled_A" ;
lin frilly_A = mkTerm "frilly_A" ;
lin fringe_N = mkTerm "fringe_N" ;
lin fringe_V2 = mkTerm "fringe_V2" ;
lin fringepod_N = mkTerm "fringepod_N" ;
lin fringy_A = mkTerm "fringy_A" ;
lin frinton_PN = mkTerm "frinton_PN" ;
lin frippery_N = mkTerm "frippery_N" ;
lin frisk_N = mkTerm "frisk_N" ;
lin frisk_V = mkTerm "frisk_V" ;
lin frisk_V2 = mkTerm "frisk_V2" ;
lin friskiness_N = mkTerm "friskiness_N" ;
lin frisky_A = mkTerm "frisky_A" ;
lin frisson_N = mkTerm "frisson_N" ;
lin fritillary_N = mkTerm "fritillary_N" ;
lin frittata_N = mkTerm "frittata_N" ;
lin fritter_N = mkTerm "fritter_N" ;
lin fritter_V2 = mkTerm "fritter_V2" ;
lin fritter_away_V = mkTerm "fritter_away_V" ;
lin frivol_V = mkTerm "frivol_V" ;
lin frivol_V2 = mkTerm "frivol_V2" ;
lin frivolity_N = mkTerm "frivolity_N" ;
lin frivolous_A = mkTerm "frivolous_A" ;
lin frizz_N = mkTerm "frizz_N" ;
lin frizz_V2 = mkTerm "frizz_V2" ;
lin frizzle_V = mkTerm "frizzle_V" ;
lin frizzle_V2 = mkTerm "frizzle_V2" ;
lin frizzy_A = mkTerm "frizzy_A" ;
lin fro_Adv = mkTerm "fro_Adv" ;
lin frock_N = mkTerm "frock_N" ;
lin frock_coat_N = mkTerm "frock_coat_N" ;
lin frodsham_PN = mkTerm "frodsham_PN" ;
lin frog_N = mkTerm "frog_N" ;
lin frogbit_N = mkTerm "frogbit_N" ;
lin frogfish_N = mkTerm "frogfish_N" ;
lin froghopper_N = mkTerm "froghopper_N" ;
lin frogman_N = mkTerm "frogman_N" ;
lin frogmarch_V2 = mkTerm "frogmarch_V2" ;
lin frogmouth_N = mkTerm "frogmouth_N" ;
lin frolic_N = mkTerm "frolic_N" ;
lin frolic_V = mkTerm "frolic_V" ;
lin frolicsome_A = mkTerm "frolicsome_A" ;
lin from_home_Adv = mkTerm "from_home_Adv" ;
lin from_time_to_time_Adv = mkTerm "from_time_to_time_Adv" ;
lin frome_PN = mkTerm "frome_PN" ;
lin frond_N = mkTerm "frond_N" ;
lin front_A = mkTerm "front_A" ;
lin front_N = mkTerm "front_N" ;
lin front_V = mkTerm "front_V" ;
lin front_V2 = mkTerm "front_V2" ;
lin front_bench_N = mkTerm "front_bench_N" ;
lin front_bencher_N = mkTerm "front_bencher_N" ;
lin front_for_V2 = mkTerm "front_for_V2" ;
lin front_off_V2 = mkTerm "front_off_V2" ;
lin front_onto_V2 = mkTerm "front_onto_V2" ;
lin front_out_V2 = mkTerm "front_out_V2" ;
lin front_up_V = mkTerm "front_up_V" ;
lin front_up_V2 = mkTerm "front_up_V2" ;
lin frontage_N = mkTerm "frontage_N" ;
lin frontal_A = mkTerm "frontal_A" ;
lin frontal_N = mkTerm "frontal_N" ;
lin frontier_N = mkTerm "frontier_N" ;
lin frontiersman_N = mkTerm "frontiersman_N" ;
lin frontierswoman_N = mkTerm "frontierswoman_N" ;
lin frontispiece_N = mkTerm "frontispiece_N" ;
lin frontlet_N = mkTerm "frontlet_N" ;
lin frontman_N = mkTerm "frontman_N" ;
lin frore_A = mkTerm "frore_A" ;
lin frost_N = mkTerm "frost_N" ;
lin frost_V = mkTerm "frost_V" ;
lin frost_V2 = mkTerm "frost_V2" ;
lin frost_bound_A = mkTerm "frost_bound_A" ;
lin frostbite_N = mkTerm "frostbite_N" ;
lin frostbitten_A = mkTerm "frostbitten_A" ;
lin frostiness_N = mkTerm "frostiness_N" ;
lin frosting_N = mkTerm "frosting_N" ;
lin frostweed_N = mkTerm "frostweed_N" ;
lin frosty_A = mkTerm "frosty_A" ;
lin froth_N = mkTerm "froth_N" ;
lin froth_V = mkTerm "froth_V" ;
lin frothiness_N = mkTerm "frothiness_N" ;
lin frothy_A = mkTerm "frothy_A" ;
lin frottage_N = mkTerm "frottage_N" ;
lin frotteur_N = mkTerm "frotteur_N" ;
lin froward_A = mkTerm "froward_A" ;
lin froward_Prep = mkTerm "froward_Prep" ;
lin frown_N = mkTerm "frown_N" ;
lin frown_V = mkTerm "frown_V" ;
lin frown_on_V2 = mkTerm "frown_on_V2" ;
lin frowningly_Adv = mkTerm "frowningly_Adv" ;
lin frowsty_A = mkTerm "frowsty_A" ;
lin frowsy_A = mkTerm "frowsy_A" ;
lin frowzy_A = mkTerm "frowzy_A" ;
lin frozen_A = mkTerm "frozen_A" ;
lin frs_N = mkTerm "frs_N" ;
lin fructification_N = mkTerm "fructification_N" ;
lin fructify_V = mkTerm "fructify_V" ;
lin fructify_V2 = mkTerm "fructify_V2" ;
lin fructose_N = mkTerm "fructose_N" ;
lin fructosuria_N = mkTerm "fructosuria_N" ;
lin frugal_A = mkTerm "frugal_A" ;
lin frugality_N = mkTerm "frugality_N" ;
lin fruit_N = mkTerm "fruit_N" ;
lin fruit_V = mkTerm "fruit_V" ;
lin fruit_fly_N = mkTerm "fruit_fly_N" ;
lin fruitage_N = mkTerm "fruitage_N" ;
lin fruitcake_N = mkTerm "fruitcake_N" ;
lin fruiterer_N = mkTerm "fruiterer_N" ;
lin fruitful_A = mkTerm "fruitful_A" ;
lin fruitfulness_N = mkTerm "fruitfulness_N" ;
lin fruition_N = mkTerm "fruition_N" ;
lin fruitless_A = mkTerm "fruitless_A" ;
lin fruitlessness_N = mkTerm "fruitlessness_N" ;
lin fruitlet_N = mkTerm "fruitlet_N" ;
lin fruitwood_N = mkTerm "fruitwood_N" ;
lin fruity_A = mkTerm "fruity_A" ;
lin frumenty_N = mkTerm "frumenty_N" ;
lin frump_N = mkTerm "frump_N" ;
lin frumpish_A = mkTerm "frumpish_A" ;
lin frumpy_A = mkTerm "frumpy_A" ;
lin frustrate_V2 = mkTerm "frustrate_V2" ;
lin frustrating_A = mkTerm "frustrating_A" ;
lin frustration_N = mkTerm "frustration_N" ;
lin frustum_N = mkTerm "frustum_N" ;
lin fry_N = mkTerm "fry_N" ;
lin fry_V = mkTerm "fry_V" ;
lin fry_V2 = mkTerm "fry_V2" ;
lin fry_pan_N = mkTerm "fry_pan_N" ;
lin fryer_N = mkTerm "fryer_N" ;
lin frying_N = mkTerm "frying_N" ;
lin frying_pan_N = mkTerm "frying_pan_N" ;
lin ft_PN = mkTerm "ft_PN" ;
lin fuchsia_N = mkTerm "fuchsia_N" ;
lin fuck_N = mkTerm "fuck_N" ;
lin fuck_V = mkTerm "fuck_V" ;
lin fuck_V2 = mkTerm "fuck_V2" ;
lin fuck_all_N = mkTerm "fuck_all_N" ;
lin fucker_N = mkTerm "fucker_N" ;
lin fucking_A = mkTerm "fucking_A" ;
lin fucking_Adv = mkTerm "fucking_Adv" ;
lin fucking_N = mkTerm "fucking_N" ;
lin fucoid_N = mkTerm "fucoid_N" ;
lin fucus_N = mkTerm "fucus_N" ;
lin fuddle_V2 = mkTerm "fuddle_V2" ;
lin fuddy_duddy_N = mkTerm "fuddy_duddy_N" ;
lin fudge_N = mkTerm "fudge_N" ;
lin fudge_over_V = mkTerm "fudge_over_V" ;
lin fuel_N = mkTerm "fuel_N" ;
lin fuel_V = mkTerm "fuel_V" ;
lin fuel_V2 = mkTerm "fuel_V2" ;
lin fuel_up_V = mkTerm "fuel_up_V" ;
lin fueling_N = mkTerm "fueling_N" ;
lin fug_N = mkTerm "fug_N" ;
lin fugacity_N = mkTerm "fugacity_N" ;
lin fugal_A = mkTerm "fugal_A" ;
lin fuggy_A = mkTerm "fuggy_A" ;
lin fugitive_A = mkTerm "fugitive_A" ;
lin fugitive_N = mkTerm "fugitive_N" ;
lin fugleman_N = mkTerm "fugleman_N" ;
lin fugly_A = mkTerm "fugly_A" ;
lin fugu_N = mkTerm "fugu_N" ;
lin fugue_N = mkTerm "fugue_N" ;
lin fuhrer_N = mkTerm "fuhrer_N" ;
lin fuji_N = mkTerm "fuji_N" ;
lin fulcrum_N = mkTerm "fulcrum_N" ;
lin fulfil_V2 = mkTerm "fulfil_V2" ;
lin fulfill_V2 = mkTerm "fulfill_V2" ;
lin fulfillment_N = mkTerm "fulfillment_N" ;
lin fulfilment_N = mkTerm "fulfilment_N" ;
lin fulgurating_A = mkTerm "fulgurating_A" ;
lin full_A = mkTerm "full_A" ;
lin full_blooded_A = mkTerm "full_blooded_A" ;
lin full_blown_A = mkTerm "full_blown_A" ;
lin full_dress_A = mkTerm "full_dress_A" ;
lin full_fashioned_A = mkTerm "full_fashioned_A" ;
lin full_fledged_A = mkTerm "full_fledged_A" ;
lin full_grown_A = mkTerm "full_grown_A" ;
lin full_length_A = mkTerm "full_length_A" ;
lin full_page_A = mkTerm "full_page_A" ;
lin full_scale_A = mkTerm "full_scale_A" ;
lin full_time_A = mkTerm "full_time_A" ;
lin full_time_Adv = mkTerm "full_time_Adv" ;
lin fullback_N = mkTerm "fullback_N" ;
lin fuller_N = mkTerm "fuller_N" ;
lin fullerene_N = mkTerm "fullerene_N" ;
lin fullness_N = mkTerm "fullness_N" ;
lin fully_Adv = mkTerm "fully_Adv" ;
lin fully_fashioned_A = mkTerm "fully_fashioned_A" ;
lin fully_fledged_A = mkTerm "fully_fledged_A" ;
lin fully_grown_A = mkTerm "fully_grown_A" ;
lin fulmar_N = mkTerm "fulmar_N" ;
lin fulminant_A = mkTerm "fulminant_A" ;
lin fulminate_N = mkTerm "fulminate_N" ;
lin fulminate_V = mkTerm "fulminate_V" ;
lin fulmination_N = mkTerm "fulmination_N" ;
lin fulsome_A = mkTerm "fulsome_A" ;
lin fulsomeness_N = mkTerm "fulsomeness_N" ;
lin fumble_N = mkTerm "fumble_N" ;
lin fumble_V = mkTerm "fumble_V" ;
lin fumble_V2 = mkTerm "fumble_V2" ;
lin fumbler_N = mkTerm "fumbler_N" ;
lin fume_N = mkTerm "fume_N" ;
lin fume_V = mkTerm "fume_V" ;
lin fume_V2 = mkTerm "fume_V2" ;
lin fume_VS = mkTerm "fume_VS" ;
lin fumewort_N = mkTerm "fumewort_N" ;
lin fumigant_N = mkTerm "fumigant_N" ;
lin fumigate_V2 = mkTerm "fumigate_V2" ;
lin fumigation_N = mkTerm "fumigation_N" ;
lin fumigator_N = mkTerm "fumigator_N" ;
lin fumitory_N = mkTerm "fumitory_N" ;
lin fun_A = mkTerm "fun_A" ;
lin fun_N = mkTerm "fun_N" ;
lin funambulism_N = mkTerm "funambulism_N" ;
lin funambulistFem_N = mkTerm "funambulistFem_N" ;
lin funambulistMasc_N = mkTerm "funambulistMasc_N" ;
lin function_N = mkTerm "function_N" ;
lin function_V = mkTerm "function_V" ;
lin functional_A = mkTerm "functional_A" ;
lin functionalism_N = mkTerm "functionalism_N" ;
lin functionalist_N = mkTerm "functionalist_N" ;
lin functionality_N = mkTerm "functionality_N" ;
lin functionary_N = mkTerm "functionary_N" ;
lin functor_N = mkTerm "functor_N" ;
lin fund_N = mkTerm "fund_N" ;
lin fund_V2 = mkTerm "fund_V2" ;
lin fundamental_A = mkTerm "fundamental_A" ;
lin fundamental_N = mkTerm "fundamental_N" ;
lin fundamentalism_N = mkTerm "fundamentalism_N" ;
lin fundamentalist_A = mkTerm "fundamentalist_A" ;
lin fundamentalist_N = mkTerm "fundamentalist_N" ;
lin fundamentals_N = mkTerm "fundamentals_N" ;
lin funding_N = mkTerm "funding_N" ;
lin fundraiser_N = mkTerm "fundraiser_N" ;
lin fundraising_N = mkTerm "fundraising_N" ;
lin funds_N = mkTerm "funds_N" ;
lin fundus_N = mkTerm "fundus_N" ;
lin funeral_N = mkTerm "funeral_N" ;
lin funerary_A = mkTerm "funerary_A" ;
lin funereal_A = mkTerm "funereal_A" ;
lin funfair_N = mkTerm "funfair_N" ;
lin fungal_A = mkTerm "fungal_A" ;
lin fungible_A = mkTerm "fungible_A" ;
lin fungible_N = mkTerm "fungible_N" ;
lin fungicidal_A = mkTerm "fungicidal_A" ;
lin fungicide_N = mkTerm "fungicide_N" ;
lin fungoid_A = mkTerm "fungoid_A" ;
lin fungous_A = mkTerm "fungous_A" ;
lin fungus_N = mkTerm "fungus_N" ;
lin funicle_N = mkTerm "funicle_N" ;
lin funicular_A = mkTerm "funicular_A" ;
lin funicular_N = mkTerm "funicular_N" ;
lin funiculitis_N = mkTerm "funiculitis_N" ;
lin funiculus_N = mkTerm "funiculus_N" ;
lin funk_N = mkTerm "funk_N" ;
lin funk_V = mkTerm "funk_V" ;
lin funk_V2 = mkTerm "funk_V2" ;
lin funky_A = mkTerm "funky_A" ;
lin funnel_N = mkTerm "funnel_N" ;
lin funnel_V = mkTerm "funnel_V" ;
lin funnel_V2 = mkTerm "funnel_V2" ;
lin funniness_N = mkTerm "funniness_N" ;
lin funny_A = mkTerm "funny_A" ;
lin funny_bone_N = mkTerm "funny_bone_N" ;
lin funrun_N = mkTerm "funrun_N" ;
lin fur_N = mkTerm "fur_N" ;
lin furan_N = mkTerm "furan_N" ;
lin furbelow_N = mkTerm "furbelow_N" ;
lin furbish_V2 = mkTerm "furbish_V2" ;
lin furcation_N = mkTerm "furcation_N" ;
lin furcula_N = mkTerm "furcula_N" ;
lin furfural_N = mkTerm "furfural_N" ;
lin furious_A = mkTerm "furious_A" ;
lin furl_V = mkTerm "furl_V" ;
lin furl_V2 = mkTerm "furl_V2" ;
lin furlike_A = mkTerm "furlike_A" ;
lin furlong_N = mkTerm "furlong_N" ;
lin furlough_N = mkTerm "furlough_N" ;
lin furnace_N = mkTerm "furnace_N" ;
lin furnish_V2 = mkTerm "furnish_V2" ;
lin furnishing_N = mkTerm "furnishing_N" ;
lin furniture_N = mkTerm "furniture_N" ;
lin furore_N = mkTerm "furore_N" ;
lin furosemide_N = mkTerm "furosemide_N" ;
lin furred_A = mkTerm "furred_A" ;
lin furrier_N = mkTerm "furrier_N" ;
lin furring_N = mkTerm "furring_N" ;
lin furrow_N = mkTerm "furrow_N" ;
lin furrow_V = mkTerm "furrow_V" ;
lin furrow_V2 = mkTerm "furrow_V2" ;
lin furry_A = mkTerm "furry_A" ;
lin furth_PN = mkTerm "furth_PN" ;
lin further_A = mkTerm "further_A" ;
lin further_AdV = mkTerm "further_AdV" ;
lin further_Adv = mkTerm "further_Adv" ;
lin further_V2 = mkTerm "further_V2" ;
lin furtherance_N = mkTerm "furtherance_N" ;
lin furthermore_Adv = mkTerm "furthermore_Adv" ;
lin furthermost_A = mkTerm "furthermost_A" ;
lin furthest_A = mkTerm "furthest_A" ;
lin furthest_Adv = mkTerm "furthest_Adv" ;
lin furtive_A = mkTerm "furtive_A" ;
lin furtiveness_N = mkTerm "furtiveness_N" ;
lin furunculosis_N = mkTerm "furunculosis_N" ;
lin fury_N = mkTerm "fury_N" ;
lin furze_N = mkTerm "furze_N" ;
lin fuschia_N = mkTerm "fuschia_N" ;
lin fuscous_A = mkTerm "fuscous_A" ;
lin fuse_N = mkTerm "fuse_N" ;
lin fuse_V = mkTerm "fuse_V" ;
lin fuse_V2 = mkTerm "fuse_V2" ;
lin fusee_N = mkTerm "fusee_N" ;
lin fuselage_N = mkTerm "fuselage_N" ;
lin fushun_PN = mkTerm "fushun_PN" ;
lin fusible_A = mkTerm "fusible_A" ;
lin fusiform_A = mkTerm "fusiform_A" ;
lin fusil_N = mkTerm "fusil_N" ;
lin fusilier_N = mkTerm "fusilier_N" ;
lin fusillade_N = mkTerm "fusillade_N" ;
lin fusion_N = mkTerm "fusion_N" ;
lin fuss_N = mkTerm "fuss_N" ;
lin fuss_V = mkTerm "fuss_V" ;
lin fuss_V2 = mkTerm "fuss_V2" ;
lin fussiness_N = mkTerm "fussiness_N" ;
lin fusspot_N = mkTerm "fusspot_N" ;
lin fussy_A = mkTerm "fussy_A" ;
lin fustian_N = mkTerm "fustian_N" ;
lin fusty_A = mkTerm "fusty_A" ;
lin futile_A = mkTerm "futile_A" ;
lin futility_N = mkTerm "futility_N" ;
lin futon_N = mkTerm "futon_N" ;
lin future_1_N = mkTerm "future_1_N" ;
lin future_3_N = mkTerm "future_3_N" ;
lin future_A = mkTerm "future_A" ;
lin futureless_A = mkTerm "futureless_A" ;
lin futurism_N = mkTerm "futurism_N" ;
lin futuristFem_N = mkTerm "futuristFem_N" ;
lin futuristMasc_N = mkTerm "futuristMasc_N" ;
lin futuristic_A = mkTerm "futuristic_A" ;
lin futurity_N = mkTerm "futurity_N" ;
lin futurology_N = mkTerm "futurology_N" ;
lin fuze_N = mkTerm "fuze_N" ;
lin fuzz_N = mkTerm "fuzz_N" ;
lin fuzzed_A = mkTerm "fuzzed_A" ;
lin fuzzy_A = mkTerm "fuzzy_A" ;
lin fwd_PN = mkTerm "fwd_PN" ;
lin g_N = mkTerm "g_N" ;
lin g_man_N = mkTerm "g_man_N" ;
lin gab_N = mkTerm "gab_N" ;
lin gabapentin_N = mkTerm "gabapentin_N" ;
lin gabardine_N = mkTerm "gabardine_N" ;
lin gabble_N = mkTerm "gabble_N" ;
lin gabble_V = mkTerm "gabble_V" ;
lin gabble_V2 = mkTerm "gabble_V2" ;
lin gabbro_N = mkTerm "gabbro_N" ;
lin gaberdine_N = mkTerm "gaberdine_N" ;
lin gable_N = mkTerm "gable_N" ;
lin gabled_A = mkTerm "gabled_A" ;
lin gabon_PN = mkTerm "gabon_PN" ;
lin gabonese_A = mkTerm "gabonese_A" ;
lin gabonese_N = mkTerm "gabonese_N" ;
lin gad_V = mkTerm "gad_V" ;
lin gad_about_V = mkTerm "gad_about_V" ;
lin gad_around_V = mkTerm "gad_around_V" ;
lin gadabout_N = mkTerm "gadabout_N" ;
lin gaddi_N = mkTerm "gaddi_N" ;
lin gadfly_N = mkTerm "gadfly_N" ;
lin gadget_N = mkTerm "gadget_N" ;
lin gadgeteer_N = mkTerm "gadgeteer_N" ;
lin gadgetry_N = mkTerm "gadgetry_N" ;
lin gadoid_N = mkTerm "gadoid_N" ;
lin gadolinite_N = mkTerm "gadolinite_N" ;
lin gadolinium_N = mkTerm "gadolinium_N" ;
lin gael_N = mkTerm "gael_N" ;
lin gaelic_A = mkTerm "gaelic_A" ;
lin gaelic_N = mkTerm "gaelic_N" ;
lin gaff_N = mkTerm "gaff_N" ;
lin gaffe_N = mkTerm "gaffe_N" ;
lin gaffer_N = mkTerm "gaffer_N" ;
lin gaffsail_N = mkTerm "gaffsail_N" ;
lin gag_N = mkTerm "gag_N" ;
lin gag_V = mkTerm "gag_V" ;
lin gag_V2 = mkTerm "gag_V2" ;
lin gag_for_V2 = mkTerm "gag_for_V2" ;
lin gaga_A = mkTerm "gaga_A" ;
lin gage_N = mkTerm "gage_N" ;
lin gage_V2 = mkTerm "gage_V2" ;
lin gaggle_N = mkTerm "gaggle_N" ;
lin gagman_N = mkTerm "gagman_N" ;
lin gaiety_N = mkTerm "gaiety_N" ;
lin gaillardia_N = mkTerm "gaillardia_N" ;
lin gain_N = mkTerm "gain_N" ;
lin gain_V = mkTerm "gain_V" ;
lin gain_V2 = mkTerm "gain_V2" ;
lin gain_back_V = mkTerm "gain_back_V" ;
lin gainer_N = mkTerm "gainer_N" ;
lin gainful_A = mkTerm "gainful_A" ;
lin gainly_A = mkTerm "gainly_A" ;
lin gainsay_V2 = mkTerm "gainsay_V2" ;
lin gainsborough_N = mkTerm "gainsborough_N" ;
lin gainsborough_PN = mkTerm "gainsborough_PN" ;
lin gait_N = mkTerm "gait_N" ;
lin gaiter_N = mkTerm "gaiter_N" ;
lin gal_N = mkTerm "gal_N" ;
lin gala_N = mkTerm "gala_N" ;
lin galactagogue_N = mkTerm "galactagogue_N" ;
lin galactic_A = mkTerm "galactic_A" ;
lin galactocele_N = mkTerm "galactocele_N" ;
lin galactose_N = mkTerm "galactose_N" ;
lin galactosemia_N = mkTerm "galactosemia_N" ;
lin galactosis_N = mkTerm "galactosis_N" ;
lin galago_N = mkTerm "galago_N" ;
lin galangal_N = mkTerm "galangal_N" ;
lin galantine_N = mkTerm "galantine_N" ;
lin galashiels_PN = mkTerm "galashiels_PN" ;
lin galax_N = mkTerm "galax_N" ;
lin galaxy_N = mkTerm "galaxy_N" ;
lin galbanum_N = mkTerm "galbanum_N" ;
lin galbulus_N = mkTerm "galbulus_N" ;
lin gale_N = mkTerm "gale_N" ;
lin galea_N = mkTerm "galea_N" ;
lin galena_N = mkTerm "galena_N" ;
lin galere_N = mkTerm "galere_N" ;
lin galingale_N = mkTerm "galingale_N" ;
lin gall_N = mkTerm "gall_N" ;
lin gall_V2 = mkTerm "gall_V2" ;
lin gallamine_N = mkTerm "gallamine_N" ;
lin gallant_A = mkTerm "gallant_A" ;
lin gallant_N = mkTerm "gallant_N" ;
lin gallantry_N = mkTerm "gallantry_N" ;
lin gallbladder_N = mkTerm "gallbladder_N" ;
lin galleon_N = mkTerm "galleon_N" ;
lin gallery_N = mkTerm "gallery_N" ;
lin galley_N = mkTerm "galley_N" ;
lin galley_proof_N = mkTerm "galley_proof_N" ;
lin galley_slave_N = mkTerm "galley_slave_N" ;
lin gallfly_N = mkTerm "gallfly_N" ;
lin gallic_A = mkTerm "gallic_A" ;
lin gallicism_N = mkTerm "gallicism_N" ;
lin gallinaceous_A = mkTerm "gallinaceous_A" ;
lin gallinule_N = mkTerm "gallinule_N" ;
lin gallium_N = mkTerm "gallium_N" ;
lin gallivant_V = mkTerm "gallivant_V" ;
lin gallon_N = mkTerm "gallon_N" ;
lin gallop_N = mkTerm "gallop_N" ;
lin gallop_V = mkTerm "gallop_V" ;
lin gallop_V2 = mkTerm "gallop_V2" ;
lin galloway_PN = mkTerm "galloway_PN" ;
lin gallows_N = mkTerm "gallows_N" ;
lin gallows_bird_N = mkTerm "gallows_bird_N" ;
lin gallstone_N = mkTerm "gallstone_N" ;
lin gallup_PN = mkTerm "gallup_PN" ;
lin galoot_N = mkTerm "galoot_N" ;
lin galore_Adv = mkTerm "galore_Adv" ;
lin galosh_N = mkTerm "galosh_N" ;
lin galumph_V = mkTerm "galumph_V" ;
lin galvanic_A = mkTerm "galvanic_A" ;
lin galvanism_N = mkTerm "galvanism_N" ;
lin galvanization_N = mkTerm "galvanization_N" ;
lin galvanize_V2 = mkTerm "galvanize_V2" ;
lin galvanize_VS = mkTerm "galvanize_VS" ;
lin galvanizer_N = mkTerm "galvanizer_N" ;
lin galvanometer_N = mkTerm "galvanometer_N" ;
lin galway_PN = mkTerm "galway_PN" ;
lin gam_N = mkTerm "gam_N" ;
lin gambia_PN = mkTerm "gambia_PN" ;
lin gambian_A = mkTerm "gambian_A" ;
lin gambian_N = mkTerm "gambian_N" ;
lin gambist_N = mkTerm "gambist_N" ;
lin gambit_N = mkTerm "gambit_N" ;
lin gamble_N = mkTerm "gamble_N" ;
lin gamble_V = mkTerm "gamble_V" ;
lin gamble_V2 = mkTerm "gamble_V2" ;
lin gambler_N = mkTerm "gambler_N" ;
lin gambling_N = mkTerm "gambling_N" ;
lin gambling_den_N = mkTerm "gambling_den_N" ;
lin gamboge_N = mkTerm "gamboge_N" ;
lin gambol_N = mkTerm "gambol_N" ;
lin gambol_V = mkTerm "gambol_V" ;
lin gambrel_N = mkTerm "gambrel_N" ;
lin game_1_N = mkTerm "game_1_N" ;
lin game_2_N = mkTerm "game_2_N" ;
lin game_3_N = mkTerm "game_3_N" ;
lin game_A = mkTerm "game_A" ;
lin game_V = mkTerm "game_V" ;
lin game_V2 = mkTerm "game_V2" ;
lin game_bag_N = mkTerm "game_bag_N" ;
lin game_bird_N = mkTerm "game_bird_N" ;
lin game_licence_N = mkTerm "game_licence_N" ;
lin gamecock_N = mkTerm "gamecock_N" ;
lin gamekeeper_N = mkTerm "gamekeeper_N" ;
lin gamelan_N = mkTerm "gamelan_N" ;
lin gameplay_N = mkTerm "gameplay_N" ;
lin games_master_N = mkTerm "games_master_N" ;
lin games_mistress_N = mkTerm "games_mistress_N" ;
lin gamesmanship_N = mkTerm "gamesmanship_N" ;
lin gametangium_N = mkTerm "gametangium_N" ;
lin gamete_N = mkTerm "gamete_N" ;
lin gametocyte_N = mkTerm "gametocyte_N" ;
lin gametoecium_N = mkTerm "gametoecium_N" ;
lin gametogenesis_N = mkTerm "gametogenesis_N" ;
lin gametophore_N = mkTerm "gametophore_N" ;
lin gametophyte_N = mkTerm "gametophyte_N" ;
lin gamey_A = mkTerm "gamey_A" ;
lin gamine_N = mkTerm "gamine_N" ;
lin gaminess_N = mkTerm "gaminess_N" ;
lin gaming_N = mkTerm "gaming_N" ;
lin gaming_house_N = mkTerm "gaming_house_N" ;
lin gaming_table_N = mkTerm "gaming_table_N" ;
lin gamma_N = mkTerm "gamma_N" ;
lin gammon_N = mkTerm "gammon_N" ;
lin gammopathy_N = mkTerm "gammopathy_N" ;
lin gammy_A = mkTerm "gammy_A" ;
lin gamopetalous_A = mkTerm "gamopetalous_A" ;
lin gamp_N = mkTerm "gamp_N" ;
lin gamut_N = mkTerm "gamut_N" ;
lin gamy_A = mkTerm "gamy_A" ;
lin gander_N = mkTerm "gander_N" ;
lin gang_N = mkTerm "gang_N" ;
lin gang_V = mkTerm "gang_V" ;
lin gang_up_V = mkTerm "gang_up_V" ;
lin gang_up_against_V2 = mkTerm "gang_up_against_V2" ;
lin gang_up_on_V2 = mkTerm "gang_up_on_V2" ;
lin ganger_N = mkTerm "ganger_N" ;
lin gangling_A = mkTerm "gangling_A" ;
lin ganglion_N = mkTerm "ganglion_N" ;
lin gangplank_N = mkTerm "gangplank_N" ;
lin gangrene_N = mkTerm "gangrene_N" ;
lin gangrene_V = mkTerm "gangrene_V" ;
lin gangrene_V2 = mkTerm "gangrene_V2" ;
lin gangrenous_A = mkTerm "gangrenous_A" ;
lin gangsaw_N = mkTerm "gangsaw_N" ;
lin gangsta_N = mkTerm "gangsta_N" ;
lin gangster_N = mkTerm "gangster_N" ;
lin gangway_N = mkTerm "gangway_N" ;
lin gannet_N = mkTerm "gannet_N" ;
lin ganoid_N = mkTerm "ganoid_N" ;
lin ganoin_N = mkTerm "ganoin_N" ;
lin gantlet_N = mkTerm "gantlet_N" ;
lin gantry_N = mkTerm "gantry_N" ;
lin gaol_N = mkTerm "gaol_N" ;
lin gaol_V2 = mkTerm "gaol_V2" ;
lin gaolbird_N = mkTerm "gaolbird_N" ;
lin gaolbreak_N = mkTerm "gaolbreak_N" ;
lin gaoler_N = mkTerm "gaoler_N" ;
lin gap_N = mkTerm "gap_N" ;
lin gap_toothed_A = mkTerm "gap_toothed_A" ;
lin gape_N = mkTerm "gape_N" ;
lin gape_V = mkTerm "gape_V" ;
lin gar_N = mkTerm "gar_N" ;
lin garage_N = mkTerm "garage_N" ;
lin garage_V2 = mkTerm "garage_V2" ;
lin garambulla_N = mkTerm "garambulla_N" ;
lin garb_N = mkTerm "garb_N" ;
lin garb_V2 = mkTerm "garb_V2" ;
lin garbage_N = mkTerm "garbage_N" ;
lin garbage_can_N = mkTerm "garbage_can_N" ;
lin garble_V2 = mkTerm "garble_V2" ;
lin garboard_N = mkTerm "garboard_N" ;
lin garbology_N = mkTerm "garbology_N" ;
lin garden_N = mkTerm "garden_N" ;
lin garden_V = mkTerm "garden_V" ;
lin garden_truck_N = mkTerm "garden_truck_N" ;
lin gardenerFem_N = mkTerm "gardenerFem_N" ;
lin gardenerMasc_N = mkTerm "gardenerMasc_N" ;
lin gardenia_N = mkTerm "gardenia_N" ;
lin gardening_N = mkTerm "gardening_N" ;
lin gareth_PN = mkTerm "gareth_PN" ;
lin garforth_PN = mkTerm "garforth_PN" ;
lin garganey_N = mkTerm "garganey_N" ;
lin gargantuan_A = mkTerm "gargantuan_A" ;
lin gargle_N = mkTerm "gargle_N" ;
lin gargle_V = mkTerm "gargle_V" ;
lin gargle_V2 = mkTerm "gargle_V2" ;
lin gargoyle_N = mkTerm "gargoyle_N" ;
lin garibaldi_N = mkTerm "garibaldi_N" ;
lin garish_A = mkTerm "garish_A" ;
lin garishness_N = mkTerm "garishness_N" ;
lin garland_N = mkTerm "garland_N" ;
lin garland_V2 = mkTerm "garland_V2" ;
lin garlic_N = mkTerm "garlic_N" ;
lin garlicky_A = mkTerm "garlicky_A" ;
lin garment_N = mkTerm "garment_N" ;
lin garmentmaker_N = mkTerm "garmentmaker_N" ;
lin garner_N = mkTerm "garner_N" ;
lin garner_V2 = mkTerm "garner_V2" ;
lin garnet_N = mkTerm "garnet_N" ;
lin garnierite_N = mkTerm "garnierite_N" ;
lin garnish_N = mkTerm "garnish_N" ;
lin garnish_V2 = mkTerm "garnish_V2" ;
lin garnishee_N = mkTerm "garnishee_N" ;
lin garnishment_N = mkTerm "garnishment_N" ;
lin garotte_N = mkTerm "garotte_N" ;
lin garret_N = mkTerm "garret_N" ;
lin garrison_N = mkTerm "garrison_N" ;
lin garrison_V2 = mkTerm "garrison_V2" ;
lin garrote_N = mkTerm "garrote_N" ;
lin garroter_N = mkTerm "garroter_N" ;
lin garrotte_N = mkTerm "garrotte_N" ;
lin garrotte_V2 = mkTerm "garrotte_V2" ;
lin garrowhill_PN = mkTerm "garrowhill_PN" ;
lin garrulity_N = mkTerm "garrulity_N" ;
lin garrulous_A = mkTerm "garrulous_A" ;
lin garter_N = mkTerm "garter_N" ;
lin gary_PN = mkTerm "gary_PN" ;
lin gas_N = mkTerm "gas_N" ;
lin gas_V = mkTerm "gas_V" ;
lin gas_V2 = mkTerm "gas_V2" ;
lin gas_bracket_N = mkTerm "gas_bracket_N" ;
lin gas_cooker_N = mkTerm "gas_cooker_N" ;
lin gas_engine_N = mkTerm "gas_engine_N" ;
lin gas_fitter_N = mkTerm "gas_fitter_N" ;
lin gas_helmet_N = mkTerm "gas_helmet_N" ;
lin gas_holder_N = mkTerm "gas_holder_N" ;
lin gas_mask_N = mkTerm "gas_mask_N" ;
lin gas_meter_N = mkTerm "gas_meter_N" ;
lin gas_oven_N = mkTerm "gas_oven_N" ;
lin gas_ring_N = mkTerm "gas_ring_N" ;
lin gas_station_N = mkTerm "gas_station_N" ;
lin gas_stove_N = mkTerm "gas_stove_N" ;
lin gasbag_N = mkTerm "gasbag_N" ;
lin gaseous_A = mkTerm "gaseous_A" ;
lin gaseousness_N = mkTerm "gaseousness_N" ;
lin gasfield_N = mkTerm "gasfield_N" ;
lin gash_N = mkTerm "gash_N" ;
lin gash_V2 = mkTerm "gash_V2" ;
lin gasification_N = mkTerm "gasification_N" ;
lin gasify_V = mkTerm "gasify_V" ;
lin gasify_V2 = mkTerm "gasify_V2" ;
lin gasket_N = mkTerm "gasket_N" ;
lin gaskin_N = mkTerm "gaskin_N" ;
lin gaslight_N = mkTerm "gaslight_N" ;
lin gasman_N = mkTerm "gasman_N" ;
lin gasohol_N = mkTerm "gasohol_N" ;
lin gasolene_N = mkTerm "gasolene_N" ;
lin gasoline_N = mkTerm "gasoline_N" ;
lin gasometer_N = mkTerm "gasometer_N" ;
lin gasp_N = mkTerm "gasp_N" ;
lin gasp_V = mkTerm "gasp_V" ;
lin gasp_V2 = mkTerm "gasp_V2" ;
lin gassing_N = mkTerm "gassing_N" ;
lin gassy_A = mkTerm "gassy_A" ;
lin gasteromycete_N = mkTerm "gasteromycete_N" ;
lin gastrectomy_N = mkTerm "gastrectomy_N" ;
lin gastric_A = mkTerm "gastric_A" ;
lin gastrin_N = mkTerm "gastrin_N" ;
lin gastritis_N = mkTerm "gastritis_N" ;
lin gastrocnemius_N = mkTerm "gastrocnemius_N" ;
lin gastroduodenal_A = mkTerm "gastroduodenal_A" ;
lin gastroenteritis_N = mkTerm "gastroenteritis_N" ;
lin gastroenterologistFem_N = mkTerm "gastroenterologistFem_N" ;
lin gastroenterologistMasc_N = mkTerm "gastroenterologistMasc_N" ;
lin gastroenterology_N = mkTerm "gastroenterology_N" ;
lin gastroenterostomy_N = mkTerm "gastroenterostomy_N" ;
lin gastroesophageal_A = mkTerm "gastroesophageal_A" ;
lin gastrogavage_N = mkTerm "gastrogavage_N" ;
lin gastrointestinal_A = mkTerm "gastrointestinal_A" ;
lin gastromy_N = mkTerm "gastromy_N" ;
lin gastronomic_A = mkTerm "gastronomic_A" ;
lin gastronomy_N = mkTerm "gastronomy_N" ;
lin gastropod_N = mkTerm "gastropod_N" ;
lin gastroscope_N = mkTerm "gastroscope_N" ;
lin gastroscopy_N = mkTerm "gastroscopy_N" ;
lin gastrostomy_N = mkTerm "gastrostomy_N" ;
lin gastrula_N = mkTerm "gastrula_N" ;
lin gastrulation_N = mkTerm "gastrulation_N" ;
lin gasworks_N = mkTerm "gasworks_N" ;
lin gat_N = mkTerm "gat_N" ;
lin gate_N = mkTerm "gate_N" ;
lin gate_V2 = mkTerm "gate_V2" ;
lin gateau_N = mkTerm "gateau_N" ;
lin gatecrash_V2 = mkTerm "gatecrash_V2" ;
lin gatecrasher_N = mkTerm "gatecrasher_N" ;
lin gatehouse_N = mkTerm "gatehouse_N" ;
lin gatekeeper_N = mkTerm "gatekeeper_N" ;
lin gatepost_N = mkTerm "gatepost_N" ;
lin gateshead_PN = mkTerm "gateshead_PN" ;
lin gateway_N = mkTerm "gateway_N" ;
lin gather_N = mkTerm "gather_N" ;
lin gather_V = mkTerm "gather_V" ;
lin gather_V2 = mkTerm "gather_V2" ;
lin gatherer_N = mkTerm "gatherer_N" ;
lin gathering_N = mkTerm "gathering_N" ;
lin gatt_N = mkTerm "gatt_N" ;
lin gauche_A = mkTerm "gauche_A" ;
lin gaucherie_N = mkTerm "gaucherie_N" ;
lin gaucho_N = mkTerm "gaucho_N" ;
lin gaud_N = mkTerm "gaud_N" ;
lin gaudery_N = mkTerm "gaudery_N" ;
lin gaudy_A = mkTerm "gaudy_A" ;
lin gaudy_N = mkTerm "gaudy_N" ;
lin gauge_N = mkTerm "gauge_N" ;
lin gauge_V2 = mkTerm "gauge_V2" ;
lin gaul_N = mkTerm "gaul_N" ;
lin gaumless_A = mkTerm "gaumless_A" ;
lin gaunt_A = mkTerm "gaunt_A" ;
lin gauntlet_N = mkTerm "gauntlet_N" ;
lin gauntleted_A = mkTerm "gauntleted_A" ;
lin gauntness_N = mkTerm "gauntness_N" ;
lin gaur_N = mkTerm "gaur_N" ;
lin gauss_N = mkTerm "gauss_N" ;
lin gauze_N = mkTerm "gauze_N" ;
lin gauzy_A = mkTerm "gauzy_A" ;
lin gavel_N = mkTerm "gavel_N" ;
lin gavial_N = mkTerm "gavial_N" ;
lin gavin_PN = mkTerm "gavin_PN" ;
lin gavotte_N = mkTerm "gavotte_N" ;
lin gawk_N = mkTerm "gawk_N" ;
lin gawker_N = mkTerm "gawker_N" ;
lin gawkiness_N = mkTerm "gawkiness_N" ;
lin gawky_A = mkTerm "gawky_A" ;
lin gawp_V = mkTerm "gawp_V" ;
lin gay_A = mkTerm "gay_A" ;
lin gay_N = mkTerm "gay_N" ;
lin gayal_N = mkTerm "gayal_N" ;
lin gayness_N = mkTerm "gayness_N" ;
lin gazania_N = mkTerm "gazania_N" ;
lin gaze_N = mkTerm "gaze_N" ;
lin gaze_V = mkTerm "gaze_V" ;
lin gazebo_N = mkTerm "gazebo_N" ;
lin gazelle_N = mkTerm "gazelle_N" ;
lin gazette_N = mkTerm "gazette_N" ;
lin gazette_V2 = mkTerm "gazette_V2" ;
lin gazetteer_N = mkTerm "gazetteer_N" ;
lin gazpacho_N = mkTerm "gazpacho_N" ;
lin gazump_V = mkTerm "gazump_V" ;
lin gazump_V2 = mkTerm "gazump_V2" ;
lin gb_PN = mkTerm "gb_PN" ;
lin gcse_N = mkTerm "gcse_N" ;
lin gcses_N = mkTerm "gcses_N" ;
lin gdansk_PN = mkTerm "gdansk_PN" ;
lin gdn_PN = mkTerm "gdn_PN" ;
lin gdns_PN = mkTerm "gdns_PN" ;
lin gean_N = mkTerm "gean_N" ;
lin gear_N = mkTerm "gear_N" ;
lin gear_V = mkTerm "gear_V" ;
lin gear_V2 = mkTerm "gear_V2" ;
lin gear_case_N = mkTerm "gear_case_N" ;
lin gear_to_V2 = mkTerm "gear_to_V2" ;
lin gear_towards_V2 = mkTerm "gear_towards_V2" ;
lin gear_up_V = mkTerm "gear_up_V" ;
lin gearbox_N = mkTerm "gearbox_N" ;
lin gearing_N = mkTerm "gearing_N" ;
lin gearset_N = mkTerm "gearset_N" ;
lin gearshift_N = mkTerm "gearshift_N" ;
lin gecko_N = mkTerm "gecko_N" ;
lin gee_gee_N = mkTerm "gee_gee_N" ;
lin geebung_N = mkTerm "geebung_N" ;
lin geek_N = mkTerm "geek_N" ;
lin geek_out_V = mkTerm "geek_out_V" ;
lin geezer_N = mkTerm "geezer_N" ;
lin geiger_N = mkTerm "geiger_N" ;
lin geisha_N = mkTerm "geisha_N" ;
lin gel_N = mkTerm "gel_N" ;
lin gel_V = mkTerm "gel_V" ;
lin gelatin_N = mkTerm "gelatin_N" ;
lin gelatine_N = mkTerm "gelatine_N" ;
lin gelatinous_A = mkTerm "gelatinous_A" ;
lin gelatinousness_N = mkTerm "gelatinousness_N" ;
lin geld_V2 = mkTerm "geld_V2" ;
lin gelding_N = mkTerm "gelding_N" ;
lin gelechiid_N = mkTerm "gelechiid_N" ;
lin gelignite_N = mkTerm "gelignite_N" ;
lin gelligaer_PN = mkTerm "gelligaer_PN" ;
lin gelsenkirchen_PN = mkTerm "gelsenkirchen_PN" ;
lin gem_N = mkTerm "gem_N" ;
lin gemfibrozil_N = mkTerm "gemfibrozil_N" ;
lin geminate_N = mkTerm "geminate_N" ;
lin gemination_N = mkTerm "gemination_N" ;
lin gemini_PN = mkTerm "gemini_PN" ;
lin gemma_N = mkTerm "gemma_N" ;
lin gemmed_A = mkTerm "gemmed_A" ;
lin gemmiferous_A = mkTerm "gemmiferous_A" ;
lin gemmule_N = mkTerm "gemmule_N" ;
lin gempylid_N = mkTerm "gempylid_N" ;
lin gemsbok_N = mkTerm "gemsbok_N" ;
lin gen_N = mkTerm "gen_N" ;
lin gen_PN = mkTerm "gen_PN" ;
lin gen_V2 = mkTerm "gen_V2" ;
lin gendarme_N = mkTerm "gendarme_N" ;
lin gendarmerie_N = mkTerm "gendarmerie_N" ;
lin gender_1_N = mkTerm "gender_1_N" ;
lin gender_2_N = mkTerm "gender_2_N" ;
lin gene_N = mkTerm "gene_N" ;
lin gene_PN = mkTerm "gene_PN" ;
lin genealogic_A = mkTerm "genealogic_A" ;
lin genealogical_A = mkTerm "genealogical_A" ;
lin genealogist_N = mkTerm "genealogist_N" ;
lin genealogy_N = mkTerm "genealogy_N" ;
lin general_A = mkTerm "general_A" ;
lin general_N = mkTerm "general_N" ;
lin generalissimo_N = mkTerm "generalissimo_N" ;
lin generality_N = mkTerm "generality_N" ;
lin generalization_N = mkTerm "generalization_N" ;
lin generalize_V = mkTerm "generalize_V" ;
lin generalize_V2 = mkTerm "generalize_V2" ;
lin generally_Adv = mkTerm "generally_Adv" ;
lin generalship_N = mkTerm "generalship_N" ;
lin generate_V2 = mkTerm "generate_V2" ;
lin generation_N = mkTerm "generation_N" ;
lin generational_A = mkTerm "generational_A" ;
lin generative_A = mkTerm "generative_A" ;
lin generator_N = mkTerm "generator_N" ;
lin generic_A = mkTerm "generic_A" ;
lin generic_N = mkTerm "generic_N" ;
lin generosity_N = mkTerm "generosity_N" ;
lin generous_A = mkTerm "generous_A" ;
lin genesis_N = mkTerm "genesis_N" ;
lin genet_N = mkTerm "genet_N" ;
lin genetic_A = mkTerm "genetic_A" ;
lin geneticism_N = mkTerm "geneticism_N" ;
lin geneticist_N = mkTerm "geneticist_N" ;
lin genetics_N = mkTerm "genetics_N" ;
lin geneva_N = mkTerm "geneva_N" ;
lin geneva_PN = mkTerm "geneva_PN" ;
lin genial_A = mkTerm "genial_A" ;
lin geniality_N = mkTerm "geniality_N" ;
lin genic_A = mkTerm "genic_A" ;
lin geniculate_A = mkTerm "geniculate_A" ;
lin genie_N = mkTerm "genie_N" ;
lin genip_N = mkTerm "genip_N" ;
lin genipa_N = mkTerm "genipa_N" ;
lin genipap_N = mkTerm "genipap_N" ;
lin genital_A = mkTerm "genital_A" ;
lin genitalia_N = mkTerm "genitalia_N" ;
lin genitive_A = mkTerm "genitive_A" ;
lin genitive_N = mkTerm "genitive_N" ;
lin genitor_N = mkTerm "genitor_N" ;
lin genitourinary_A = mkTerm "genitourinary_A" ;
lin genius_N = mkTerm "genius_N" ;
lin genius_loci_N = mkTerm "genius_loci_N" ;
lin genlisea_N = mkTerm "genlisea_N" ;
lin genoa_PN = mkTerm "genoa_PN" ;
lin genocide_N = mkTerm "genocide_N" ;
lin genoise_N = mkTerm "genoise_N" ;
lin genome_N = mkTerm "genome_N" ;
lin genomics_N = mkTerm "genomics_N" ;
lin genotype_N = mkTerm "genotype_N" ;
lin genotypical_A = mkTerm "genotypical_A" ;
lin genova_PN = mkTerm "genova_PN" ;
lin genre_N = mkTerm "genre_N" ;
lin genre_painting_N = mkTerm "genre_painting_N" ;
lin gent_N = mkTerm "gent_N" ;
lin gentamicin_N = mkTerm "gentamicin_N" ;
lin genteel_A = mkTerm "genteel_A" ;
lin gentian_N = mkTerm "gentian_N" ;
lin gentianella_N = mkTerm "gentianella_N" ;
lin gentile_A = mkTerm "gentile_A" ;
lin gentile_N = mkTerm "gentile_N" ;
lin gentility_N = mkTerm "gentility_N" ;
lin gentle_A = mkTerm "gentle_A" ;
lin gentlefolk_N = mkTerm "gentlefolk_N" ;
lin gentleman_N = mkTerm "gentleman_N" ;
lin gentleman_at_arms_N = mkTerm "gentleman_at_arms_N" ;
lin gentlemanlike_A = mkTerm "gentlemanlike_A" ;
lin gentlemanly_A = mkTerm "gentlemanly_A" ;
lin gentleness_N = mkTerm "gentleness_N" ;
lin gentlewoman_N = mkTerm "gentlewoman_N" ;
lin gentrification_N = mkTerm "gentrification_N" ;
lin gentry_N = mkTerm "gentry_N" ;
lin genuflect_V = mkTerm "genuflect_V" ;
lin genuflection_N = mkTerm "genuflection_N" ;
lin genuflexion_N = mkTerm "genuflexion_N" ;
lin genuine_A = mkTerm "genuine_A" ;
lin genuineness_N = mkTerm "genuineness_N" ;
lin genus_N = mkTerm "genus_N" ;
lin geocentric_A = mkTerm "geocentric_A" ;
lin geochemistry_N = mkTerm "geochemistry_N" ;
lin geode_N = mkTerm "geode_N" ;
lin geodesic_N = mkTerm "geodesic_N" ;
lin geodesy_N = mkTerm "geodesy_N" ;
lin geodetic_A = mkTerm "geodetic_A" ;
lin geoduck_N = mkTerm "geoduck_N" ;
lin geoff_PN = mkTerm "geoff_PN" ;
lin geoffrey_PN = mkTerm "geoffrey_PN" ;
lin geographer_N = mkTerm "geographer_N" ;
lin geographic_A = mkTerm "geographic_A" ;
lin geographical_A = mkTerm "geographical_A" ;
lin geography_N = mkTerm "geography_N" ;
lin geologic_A = mkTerm "geologic_A" ;
lin geological_A = mkTerm "geological_A" ;
lin geologistFem_N = mkTerm "geologistFem_N" ;
lin geologistMasc_N = mkTerm "geologistMasc_N" ;
lin geology_N = mkTerm "geology_N" ;
lin geomancer_N = mkTerm "geomancer_N" ;
lin geomancy_N = mkTerm "geomancy_N" ;
lin geometer_N = mkTerm "geometer_N" ;
lin geometric_A = mkTerm "geometric_A" ;
lin geometrical_A = mkTerm "geometrical_A" ;
lin geometrid_N = mkTerm "geometrid_N" ;
lin geometry_N = mkTerm "geometry_N" ;
lin geomorphologic_A = mkTerm "geomorphologic_A" ;
lin geophagy_N = mkTerm "geophagy_N" ;
lin geophysical_A = mkTerm "geophysical_A" ;
lin geophysicist_N = mkTerm "geophysicist_N" ;
lin geophysics_N = mkTerm "geophysics_N" ;
lin geophyte_N = mkTerm "geophyte_N" ;
lin geophytic_A = mkTerm "geophytic_A" ;
lin geopolitical_A = mkTerm "geopolitical_A" ;
lin geopolitics_N = mkTerm "geopolitics_N" ;
lin geordie_N = mkTerm "geordie_N" ;
lin george_PN = mkTerm "george_PN" ;
lin georgette_N = mkTerm "georgette_N" ;
lin georgia_PN = mkTerm "georgia_PN" ;
lin georgian_A = mkTerm "georgian_A" ;
lin georgian_N = mkTerm "georgian_N" ;
lin georgie_PN = mkTerm "georgie_PN" ;
lin geostationary_A = mkTerm "geostationary_A" ;
lin geostrategic_A = mkTerm "geostrategic_A" ;
lin geostrategy_N = mkTerm "geostrategy_N" ;
lin geosynchronous_A = mkTerm "geosynchronous_A" ;
lin geothermal_A = mkTerm "geothermal_A" ;
lin geotropism_N = mkTerm "geotropism_N" ;
lin gerald_PN = mkTerm "gerald_PN" ;
lin geraldine_PN = mkTerm "geraldine_PN" ;
lin geranium_N = mkTerm "geranium_N" ;
lin gerard_PN = mkTerm "gerard_PN" ;
lin gerardia_N = mkTerm "gerardia_N" ;
lin gerbil_N = mkTerm "gerbil_N" ;
lin gerenuk_N = mkTerm "gerenuk_N" ;
lin geriatric_A = mkTerm "geriatric_A" ;
lin geriatrician_N = mkTerm "geriatrician_N" ;
lin geriatrics_N = mkTerm "geriatrics_N" ;
lin germ_N = mkTerm "germ_N" ;
lin germanFem_N = mkTerm "germanFem_N" ;
lin germanMasc_N = mkTerm "germanMasc_N" ;
lin german_A = mkTerm "german_A" ;
lin germander_N = mkTerm "germander_N" ;
lin germane_A = mkTerm "germane_A" ;
lin germaneness_N = mkTerm "germaneness_N" ;
lin germanic_A = mkTerm "germanic_A" ;
lin germanite_N = mkTerm "germanite_N" ;
lin germanium_N = mkTerm "germanium_N" ;
lin germany_PN = mkTerm "germany_PN" ;
lin germfree_A = mkTerm "germfree_A" ;
lin germicide_N = mkTerm "germicide_N" ;
lin germinal_A = mkTerm "germinal_A" ;
lin germinate_V = mkTerm "germinate_V" ;
lin germinate_V2 = mkTerm "germinate_V2" ;
lin germination_N = mkTerm "germination_N" ;
lin germy_A = mkTerm "germy_A" ;
lin gerontocracy_N = mkTerm "gerontocracy_N" ;
lin gerontologist_N = mkTerm "gerontologist_N" ;
lin gerontology_N = mkTerm "gerontology_N" ;
lin gerry_PN = mkTerm "gerry_PN" ;
lin gerrymander_N = mkTerm "gerrymander_N" ;
lin gerrymander_V2 = mkTerm "gerrymander_V2" ;
lin gertie_PN = mkTerm "gertie_PN" ;
lin gertrude_PN = mkTerm "gertrude_PN" ;
lin gerund_N = mkTerm "gerund_N" ;
lin gerundial_A = mkTerm "gerundial_A" ;
lin gesneria_N = mkTerm "gesneria_N" ;
lin gesneriad_N = mkTerm "gesneriad_N" ;
lin gesso_N = mkTerm "gesso_N" ;
lin gestalt_N = mkTerm "gestalt_N" ;
lin gestapo_N = mkTerm "gestapo_N" ;
lin gestation_N = mkTerm "gestation_N" ;
lin gestational_A = mkTerm "gestational_A" ;
lin gesticulate_V = mkTerm "gesticulate_V" ;
lin gesticulation_N = mkTerm "gesticulation_N" ;
lin gestural_A = mkTerm "gestural_A" ;
lin gesture_N = mkTerm "gesture_N" ;
lin gesture_V = mkTerm "gesture_V" ;
lin get_N = mkTerm "get_N" ;
lin get_V2 = mkTerm "get_V2" ;
lin get_V2V = mkTerm "get_V2V" ;
lin get_VV = mkTerm "get_VV" ;
lin get_about_V = mkTerm "get_about_V" ;
lin get_above_V2 = mkTerm "get_above_V2" ;
lin get_across_V = mkTerm "get_across_V" ;
lin get_across_V2 = mkTerm "get_across_V2" ;
lin get_across_to_V2 = mkTerm "get_across_to_V2" ;
lin get_after_V2 = mkTerm "get_after_V2" ;
lin get_ahead_V = mkTerm "get_ahead_V" ;
lin get_ahead_of_V2 = mkTerm "get_ahead_of_V2" ;
lin get_along_V = mkTerm "get_along_V" ;
lin get_along_in_V2 = mkTerm "get_along_in_V2" ;
lin get_along_with_V2 = mkTerm "get_along_with_V2" ;
lin get_around_V = mkTerm "get_around_V" ;
lin get_around_V2 = mkTerm "get_around_V2" ;
lin get_around_to_V2 = mkTerm "get_around_to_V2" ;
lin get_at_V2 = mkTerm "get_at_V2" ;
lin get_at_able_A = mkTerm "get_at_able_A" ;
lin get_away_V = mkTerm "get_away_V" ;
lin get_away_from_V2 = mkTerm "get_away_from_V2" ;
lin get_away_with_V2 = mkTerm "get_away_with_V2" ;
lin get_back_V = mkTerm "get_back_V" ;
lin get_back_V2 = mkTerm "get_back_V2" ;
lin get_back_at_V2 = mkTerm "get_back_at_V2" ;
lin get_back_into_V2 = mkTerm "get_back_into_V2" ;
lin get_back_to_V2 = mkTerm "get_back_to_V2" ;
lin get_back_together_V = mkTerm "get_back_together_V" ;
lin get_behind_V2 = mkTerm "get_behind_V2" ;
lin get_behind_with_V2 = mkTerm "get_behind_with_V2" ;
lin get_by_V = mkTerm "get_by_V" ;
lin get_by_V2 = mkTerm "get_by_V2" ;
lin get_by_on_V2 = mkTerm "get_by_on_V2" ;
lin get_by_with_V2 = mkTerm "get_by_with_V2" ;
lin get_down_V = mkTerm "get_down_V" ;
lin get_down_V2 = mkTerm "get_down_V2" ;
lin get_down_on_V2 = mkTerm "get_down_on_V2" ;
lin get_down_to_V2 = mkTerm "get_down_to_V2" ;
lin get_even_V = mkTerm "get_even_V" ;
lin get_in_V = mkTerm "get_in_V" ;
lin get_in_V2 = mkTerm "get_in_V2" ;
lin get_in_on_V2 = mkTerm "get_in_on_V2" ;
lin get_in_with_V2 = mkTerm "get_in_with_V2" ;
lin get_into_V2 = mkTerm "get_into_V2" ;
lin get_it_V = mkTerm "get_it_V" ;
lin get_it_off_V = mkTerm "get_it_off_V" ;
lin get_it_off_with_V2 = mkTerm "get_it_off_with_V2" ;
lin get_it_on_V = mkTerm "get_it_on_V" ;
lin get_it_on_with_V2 = mkTerm "get_it_on_with_V2" ;
lin get_it_together_V = mkTerm "get_it_together_V" ;
lin get_it_up_V = mkTerm "get_it_up_V" ;
lin get_off_V = mkTerm "get_off_V" ;
lin get_off_V2 = mkTerm "get_off_V2" ;
lin get_off_it_V2 = mkTerm "get_off_it_V2" ;
lin get_off_on_V2 = mkTerm "get_off_on_V2" ;
lin get_off_with_V2 = mkTerm "get_off_with_V2" ;
lin get_on_1_V2 = mkTerm "get_on_1_V2" ;
lin get_on_2_V2 = mkTerm "get_on_2_V2" ;
lin get_on_V = mkTerm "get_on_V" ;
lin get_on_at_V2 = mkTerm "get_on_at_V2" ;
lin get_on_for_V2 = mkTerm "get_on_for_V2" ;
lin get_on_to_V2 = mkTerm "get_on_to_V2" ;
lin get_on_with_V2 = mkTerm "get_on_with_V2" ;
lin get_onto_V2 = mkTerm "get_onto_V2" ;
lin get_out_V = mkTerm "get_out_V" ;
lin get_out_V2 = mkTerm "get_out_V2" ;
lin get_out_of_V2 = mkTerm "get_out_of_V2" ;
lin get_over_V = mkTerm "get_over_V" ;
lin get_over_V2 = mkTerm "get_over_V2" ;
lin get_over_with_V2 = mkTerm "get_over_with_V2" ;
lin get_round_V = mkTerm "get_round_V" ;
lin get_round_V2 = mkTerm "get_round_V2" ;
lin get_round_to_V2 = mkTerm "get_round_to_V2" ;
lin get_through_V = mkTerm "get_through_V" ;
lin get_through_V2 = mkTerm "get_through_V2" ;
lin get_through_V3 = mkTerm "get_through_V3" ;
lin get_through_to_V2 = mkTerm "get_through_to_V2" ;
lin get_to_V2 = mkTerm "get_to_V2" ;
lin get_together_N = mkTerm "get_together_N" ;
lin get_together_V = mkTerm "get_together_V" ;
lin get_up_N = mkTerm "get_up_N" ;
lin get_up_V = mkTerm "get_up_V" ;
lin get_up_V2 = mkTerm "get_up_V2" ;
lin get_up_to_V2 = mkTerm "get_up_to_V2" ;
lin getaway_N = mkTerm "getaway_N" ;
lin gettable_A = mkTerm "gettable_A" ;
lin geum_N = mkTerm "geum_N" ;
lin geyser_N = mkTerm "geyser_N" ;
lin ghana_PN = mkTerm "ghana_PN" ;
lin ghanaian_A = mkTerm "ghanaian_A" ;
lin ghanaian_N = mkTerm "ghanaian_N" ;
lin gharry_N = mkTerm "gharry_N" ;
lin ghastliness_N = mkTerm "ghastliness_N" ;
lin ghastly_A = mkTerm "ghastly_A" ;
lin ghat_N = mkTerm "ghat_N" ;
lin ghatti_N = mkTerm "ghatti_N" ;
lin ghee_N = mkTerm "ghee_N" ;
lin ghent_PN = mkTerm "ghent_PN" ;
lin gherkin_N = mkTerm "gherkin_N" ;
lin ghetto_N = mkTerm "ghetto_N" ;
lin ghillie_N = mkTerm "ghillie_N" ;
lin ghost_N = mkTerm "ghost_N" ;
lin ghost_V = mkTerm "ghost_V" ;
lin ghost_V2 = mkTerm "ghost_V2" ;
lin ghost_away_V2 = mkTerm "ghost_away_V2" ;
lin ghost_writer_N = mkTerm "ghost_writer_N" ;
lin ghostliness_N = mkTerm "ghostliness_N" ;
lin ghostly_A = mkTerm "ghostly_A" ;
lin ghoul_N = mkTerm "ghoul_N" ;
lin ghoulish_A = mkTerm "ghoulish_A" ;
lin ghq_PN = mkTerm "ghq_PN" ;
lin ghrelin_N = mkTerm "ghrelin_N" ;
lin gi_N = mkTerm "gi_N" ;
lin giant_A = mkTerm "giant_A" ;
lin giant_N = mkTerm "giant_N" ;
lin giantess_N = mkTerm "giantess_N" ;
lin giantism_N = mkTerm "giantism_N" ;
lin giardia_N = mkTerm "giardia_N" ;
lin giardiasis_N = mkTerm "giardiasis_N" ;
lin gib_N = mkTerm "gib_N" ;
lin gibber_V = mkTerm "gibber_V" ;
lin gibberellin_N = mkTerm "gibberellin_N" ;
lin gibberish_N = mkTerm "gibberish_N" ;
lin gibbet_N = mkTerm "gibbet_N" ;
lin gibbet_V2 = mkTerm "gibbet_V2" ;
lin gibbon_N = mkTerm "gibbon_N" ;
lin gibbous_A = mkTerm "gibbous_A" ;
lin gibbsite_N = mkTerm "gibbsite_N" ;
lin gibe_N = mkTerm "gibe_N" ;
lin gibe_V = mkTerm "gibe_V" ;
lin gibibit_N = mkTerm "gibibit_N" ;
lin gibingly_Adv = mkTerm "gibingly_Adv" ;
lin giblet_N = mkTerm "giblet_N" ;
lin gibraltar_PN = mkTerm "gibraltar_PN" ;
lin gibraltarian_A = mkTerm "gibraltarian_A" ;
lin gibraltarian_N = mkTerm "gibraltarian_N" ;
lin giddiness_N = mkTerm "giddiness_N" ;
lin giddy_A = mkTerm "giddy_A" ;
lin gidgee_N = mkTerm "gidgee_N" ;
lin giffnock_PN = mkTerm "giffnock_PN" ;
lin gift_N = mkTerm "gift_N" ;
lin gift_V2 = mkTerm "gift_V2" ;
lin gifted_A = mkTerm "gifted_A" ;
lin gig_N = mkTerm "gig_N" ;
lin gigabit_N = mkTerm "gigabit_N" ;
lin gigabyte_N = mkTerm "gigabyte_N" ;
lin gigahertz_N = mkTerm "gigahertz_N" ;
lin gigantic_A = mkTerm "gigantic_A" ;
lin gigantism_N = mkTerm "gigantism_N" ;
lin giggle_N = mkTerm "giggle_N" ;
lin giggle_V = mkTerm "giggle_V" ;
lin gigolo_N = mkTerm "gigolo_N" ;
lin gilbert_N = mkTerm "gilbert_N" ;
lin gilbert_PN = mkTerm "gilbert_PN" ;
lin gilbertian_A = mkTerm "gilbertian_A" ;
lin gild_N = mkTerm "gild_N" ;
lin gild_V2 = mkTerm "gild_V2" ;
lin gilder_N = mkTerm "gilder_N" ;
lin gildhall_N = mkTerm "gildhall_N" ;
lin gilding_N = mkTerm "gilding_N" ;
lin giles_PN = mkTerm "giles_PN" ;
lin gilfach_goch_PN = mkTerm "gilfach_goch_PN" ;
lin gill_N = mkTerm "gill_N" ;
lin gill_PN = mkTerm "gill_PN" ;
lin gillian_PN = mkTerm "gillian_PN" ;
lin gillie_N = mkTerm "gillie_N" ;
lin gillingham_PN = mkTerm "gillingham_PN" ;
lin gilt_N = mkTerm "gilt_N" ;
lin gilt_edged_A = mkTerm "gilt_edged_A" ;
lin gimbal_N = mkTerm "gimbal_N" ;
lin gimbaled_A = mkTerm "gimbaled_A" ;
lin gimcrack_A = mkTerm "gimcrack_A" ;
lin gimel_N = mkTerm "gimel_N" ;
lin gimlet_N = mkTerm "gimlet_N" ;
lin gimmick_N = mkTerm "gimmick_N" ;
lin gimmickry_N = mkTerm "gimmickry_N" ;
lin gin_N = mkTerm "gin_N" ;
lin gin_V2 = mkTerm "gin_V2" ;
lin gin_up_V2 = mkTerm "gin_up_V2" ;
lin gina_PN = mkTerm "gina_PN" ;
lin ginger_A = mkTerm "ginger_A" ;
lin ginger_N = mkTerm "ginger_N" ;
lin ginger_V2 = mkTerm "ginger_V2" ;
lin ginger_up_V2 = mkTerm "ginger_up_V2" ;
lin gingerbread_N = mkTerm "gingerbread_N" ;
lin gingerly_A = mkTerm "gingerly_A" ;
lin gingerol_N = mkTerm "gingerol_N" ;
lin gingersnap_N = mkTerm "gingersnap_N" ;
lin gingery_A = mkTerm "gingery_A" ;
lin gingham_N = mkTerm "gingham_N" ;
lin gingiva_N = mkTerm "gingiva_N" ;
lin gingival_A = mkTerm "gingival_A" ;
lin gingivitis_N = mkTerm "gingivitis_N" ;
lin gingko_N = mkTerm "gingko_N" ;
lin ginkgo_N = mkTerm "ginkgo_N" ;
lin ginseng_N = mkTerm "ginseng_N" ;
lin gipsyFem_N = mkTerm "gipsyFem_N" ;
lin gipsyMasc_N = mkTerm "gipsyMasc_N" ;
lin gipsywort_N = mkTerm "gipsywort_N" ;
lin giraffe_N = mkTerm "giraffe_N" ;
lin girandole_N = mkTerm "girandole_N" ;
lin gird_V = mkTerm "gird_V" ;
lin gird_V2 = mkTerm "gird_V2" ;
lin girder_N = mkTerm "girder_N" ;
lin girdle_N = mkTerm "girdle_N" ;
lin girdle_V2 = mkTerm "girdle_V2" ;
lin girl_N = mkTerm "girl_N" ;
lin girlfriend_N = mkTerm "girlfriend_N" ;
lin girlhood_N = mkTerm "girlhood_N" ;
lin girlish_A = mkTerm "girlish_A" ;
lin girlishness_N = mkTerm "girlishness_N" ;
lin giro_N = mkTerm "giro_N" ;
lin girth_N = mkTerm "girth_N" ;
lin girvan_PN = mkTerm "girvan_PN" ;
lin gist_N = mkTerm "gist_N" ;
lin gitana_N = mkTerm "gitana_N" ;
lin gitano_N = mkTerm "gitano_N" ;
lin give_N = mkTerm "give_N" ;
lin give_V = mkTerm "give_V" ;
lin give_V2 = mkTerm "give_V2" ;
lin give_V3 = mkTerm "give_V3" ;
lin give_away_V = mkTerm "give_away_V" ;
lin give_away_V2 = mkTerm "give_away_V2" ;
lin give_back_V2 = mkTerm "give_back_V2" ;
lin give_in_V = mkTerm "give_in_V" ;
lin give_in_V2 = mkTerm "give_in_V2" ;
lin give_in_to_V2 = mkTerm "give_in_to_V2" ;
lin give_it_to_V2 = mkTerm "give_it_to_V2" ;
lin give_it_up_for_V2 = mkTerm "give_it_up_for_V2" ;
lin give_it_up_to_V2 = mkTerm "give_it_up_to_V2" ;
lin give_of_V2 = mkTerm "give_of_V2" ;
lin give_off_V = mkTerm "give_off_V" ;
lin give_off_V2 = mkTerm "give_off_V2" ;
lin give_onto_V2 = mkTerm "give_onto_V2" ;
lin give_out_V = mkTerm "give_out_V" ;
lin give_out_V2 = mkTerm "give_out_V2" ;
lin give_over_V = mkTerm "give_over_V" ;
lin give_over_V2 = mkTerm "give_over_V2" ;
lin give_over_to_V3 = mkTerm "give_over_to_V3" ;
lin give_up_V = mkTerm "give_up_V" ;
lin give_up_V2 = mkTerm "give_up_V2" ;
lin give_up_on_V2 = mkTerm "give_up_on_V2" ;
lin give_up_to_V2 = mkTerm "give_up_to_V2" ;
lin give_way_V = mkTerm "give_way_V" ;
lin give_way_to_V2 = mkTerm "give_way_to_V2" ;
lin give_yourself_up_V = mkTerm "give_yourself_up_V" ;
lin give_yourself_up_to_V2 = mkTerm "give_yourself_up_to_V2" ;
lin giveaway_N = mkTerm "giveaway_N" ;
lin given_A = mkTerm "given_A" ;
lin given_N = mkTerm "given_N" ;
lin givenness_N = mkTerm "givenness_N" ;
lin giver_N = mkTerm "giver_N" ;
lin giveth_V2 = mkTerm "giveth_V2" ;
lin giving_N = mkTerm "giving_N" ;
lin gizzard_N = mkTerm "gizzard_N" ;
lin glabella_N = mkTerm "glabella_N" ;
lin glabellar_A = mkTerm "glabellar_A" ;
lin glabrescent_A = mkTerm "glabrescent_A" ;
lin glabrous_A = mkTerm "glabrous_A" ;
lin glace_A = mkTerm "glace_A" ;
lin glacial_A = mkTerm "glacial_A" ;
lin glaciated_A = mkTerm "glaciated_A" ;
lin glaciation_N = mkTerm "glaciation_N" ;
lin glacier_N = mkTerm "glacier_N" ;
lin glad_A = mkTerm "glad_A" ;
lin gladden_V2 = mkTerm "gladden_V2" ;
lin glade_N = mkTerm "glade_N" ;
lin gladiator_N = mkTerm "gladiator_N" ;
lin gladiatorial_A = mkTerm "gladiatorial_A" ;
lin gladiolus_N = mkTerm "gladiolus_N" ;
lin gladness_N = mkTerm "gladness_N" ;
lin gladsome_A = mkTerm "gladsome_A" ;
lin gladys_PN = mkTerm "gladys_PN" ;
lin glam_N = mkTerm "glam_N" ;
lin glamor_N = mkTerm "glamor_N" ;
lin glamorgan_PN = mkTerm "glamorgan_PN" ;
lin glamorization_N = mkTerm "glamorization_N" ;
lin glamorize_V2 = mkTerm "glamorize_V2" ;
lin glamorous_A = mkTerm "glamorous_A" ;
lin glamour_N = mkTerm "glamour_N" ;
lin glance_N = mkTerm "glance_N" ;
lin glance_V = mkTerm "glance_V" ;
lin glance_V2 = mkTerm "glance_V2" ;
lin gland_N = mkTerm "gland_N" ;
lin glanders_N = mkTerm "glanders_N" ;
lin glandular_A = mkTerm "glandular_A" ;
lin glans_N = mkTerm "glans_N" ;
lin glare_N = mkTerm "glare_N" ;
lin glare_V = mkTerm "glare_V" ;
lin glare_V2 = mkTerm "glare_V2" ;
lin glaring_A = mkTerm "glaring_A" ;
lin glasgow_PN = mkTerm "glasgow_PN" ;
lin glasnost_N = mkTerm "glasnost_N" ;
lin glass_1_N = mkTerm "glass_1_N" ;
lin glass_2_N = mkTerm "glass_2_N" ;
lin glass_V2 = mkTerm "glass_V2" ;
lin glass_blower_N = mkTerm "glass_blower_N" ;
lin glass_cutter_N = mkTerm "glass_cutter_N" ;
lin glass_wool_N = mkTerm "glass_wool_N" ;
lin glassful_N = mkTerm "glassful_N" ;
lin glasshouse_N = mkTerm "glasshouse_N" ;
lin glassmaker_N = mkTerm "glassmaker_N" ;
lin glassware_N = mkTerm "glassware_N" ;
lin glassworks_N = mkTerm "glassworks_N" ;
lin glasswort_N = mkTerm "glasswort_N" ;
lin glassy_A = mkTerm "glassy_A" ;
lin glastonbury_PN = mkTerm "glastonbury_PN" ;
lin glaswegian_A = mkTerm "glaswegian_A" ;
lin glaswegian_N = mkTerm "glaswegian_N" ;
lin glaucoma_N = mkTerm "glaucoma_N" ;
lin glauconite_N = mkTerm "glauconite_N" ;
lin glaucous_A = mkTerm "glaucous_A" ;
lin glaze_N = mkTerm "glaze_N" ;
lin glaze_V = mkTerm "glaze_V" ;
lin glaze_V2 = mkTerm "glaze_V2" ;
lin glazier_N = mkTerm "glazier_N" ;
lin gleam_N = mkTerm "gleam_N" ;
lin gleam_V = mkTerm "gleam_V" ;
lin glean_V = mkTerm "glean_V" ;
lin glean_V2 = mkTerm "glean_V2" ;
lin gleaner_N = mkTerm "gleaner_N" ;
lin gleba_N = mkTerm "gleba_N" ;
lin glebe_N = mkTerm "glebe_N" ;
lin glee_N = mkTerm "glee_N" ;
lin gleeful_A = mkTerm "gleeful_A" ;
lin gleet_N = mkTerm "gleet_N" ;
lin glen_N = mkTerm "glen_N" ;
lin glen_PN = mkTerm "glen_PN" ;
lin glengarry_N = mkTerm "glengarry_N" ;
lin glenrothes_PN = mkTerm "glenrothes_PN" ;
lin glial_A = mkTerm "glial_A" ;
lin glib_A = mkTerm "glib_A" ;
lin glibness_N = mkTerm "glibness_N" ;
lin glide_N = mkTerm "glide_N" ;
lin glide_V = mkTerm "glide_V" ;
lin glider_N = mkTerm "glider_N" ;
lin gliding_N = mkTerm "gliding_N" ;
lin glimmer_N = mkTerm "glimmer_N" ;
lin glimmer_V = mkTerm "glimmer_V" ;
lin glimmery_A = mkTerm "glimmery_A" ;
lin glimpse_N = mkTerm "glimpse_N" ;
lin glimpse_V2 = mkTerm "glimpse_V2" ;
lin glint_N = mkTerm "glint_N" ;
lin glint_V = mkTerm "glint_V" ;
lin glioblastoma_N = mkTerm "glioblastoma_N" ;
lin glioma_N = mkTerm "glioma_N" ;
lin glipizide_N = mkTerm "glipizide_N" ;
lin gliricidia_N = mkTerm "gliricidia_N" ;
lin glissade_N = mkTerm "glissade_N" ;
lin glissade_V = mkTerm "glissade_V" ;
lin glissando_A = mkTerm "glissando_A" ;
lin glissando_Adv = mkTerm "glissando_Adv" ;
lin glissando_N = mkTerm "glissando_N" ;
lin glisten_V = mkTerm "glisten_V" ;
lin glister_N = mkTerm "glister_N" ;
lin glister_V = mkTerm "glister_V" ;
lin glitter_N = mkTerm "glitter_N" ;
lin glitter_V = mkTerm "glitter_V" ;
lin gloaming_N = mkTerm "gloaming_N" ;
lin gloat_N = mkTerm "gloat_N" ;
lin gloat_V = mkTerm "gloat_V" ;
lin gloat_VS = mkTerm "gloat_VS" ;
lin gloatingly_Adv = mkTerm "gloatingly_Adv" ;
lin global_A = mkTerm "global_A" ;
lin globalization_N = mkTerm "globalization_N" ;
lin globe_N = mkTerm "globe_N" ;
lin globeflower_N = mkTerm "globeflower_N" ;
lin globetrot_V = mkTerm "globetrot_V" ;
lin globetrotter_N = mkTerm "globetrotter_N" ;
lin globigerina_N = mkTerm "globigerina_N" ;
lin globin_N = mkTerm "globin_N" ;
lin globular_A = mkTerm "globular_A" ;
lin globule_N = mkTerm "globule_N" ;
lin globulin_N = mkTerm "globulin_N" ;
lin glochidium_N = mkTerm "glochidium_N" ;
lin glockenspiel_N = mkTerm "glockenspiel_N" ;
lin glogg_N = mkTerm "glogg_N" ;
lin glomerular_A = mkTerm "glomerular_A" ;
lin glomerule_N = mkTerm "glomerule_N" ;
lin glomerulonephritis_N = mkTerm "glomerulonephritis_N" ;
lin glomerulus_N = mkTerm "glomerulus_N" ;
lin gloom_N = mkTerm "gloom_N" ;
lin gloominess_N = mkTerm "gloominess_N" ;
lin glooming_A = mkTerm "glooming_A" ;
lin gloomy_A = mkTerm "gloomy_A" ;
lin glop_N = mkTerm "glop_N" ;
lin gloria_PN = mkTerm "gloria_PN" ;
lin glorification_N = mkTerm "glorification_N" ;
lin glorify_V2 = mkTerm "glorify_V2" ;
lin gloriosa_N = mkTerm "gloriosa_N" ;
lin glorious_A = mkTerm "glorious_A" ;
lin glory_N = mkTerm "glory_N" ;
lin glory_V = mkTerm "glory_V" ;
lin glory_hole_N = mkTerm "glory_hole_N" ;
lin gloss_N = mkTerm "gloss_N" ;
lin gloss_V2 = mkTerm "gloss_V2" ;
lin gloss_over_V2 = mkTerm "gloss_over_V2" ;
lin glossalgia_N = mkTerm "glossalgia_N" ;
lin glossarist_N = mkTerm "glossarist_N" ;
lin glossary_N = mkTerm "glossary_N" ;
lin glossiness_N = mkTerm "glossiness_N" ;
lin glossitis_N = mkTerm "glossitis_N" ;
lin glossolalia_N = mkTerm "glossolalia_N" ;
lin glossop_PN = mkTerm "glossop_PN" ;
lin glossopharyngeal_A = mkTerm "glossopharyngeal_A" ;
lin glossoptosis_N = mkTerm "glossoptosis_N" ;
lin glossy_A = mkTerm "glossy_A" ;
lin glossy_N = mkTerm "glossy_N" ;
lin glottal_A = mkTerm "glottal_A" ;
lin glottis_N = mkTerm "glottis_N" ;
lin glottochronological_A = mkTerm "glottochronological_A" ;
lin glottochronology_N = mkTerm "glottochronology_N" ;
lin gloucester_PN = mkTerm "gloucester_PN" ;
lin gloucestershire_PN = mkTerm "gloucestershire_PN" ;
lin glove_N = mkTerm "glove_N" ;
lin glove_compartment_N = mkTerm "glove_compartment_N" ;
lin gloved_A = mkTerm "gloved_A" ;
lin gloveless_A = mkTerm "gloveless_A" ;
lin glow_N = mkTerm "glow_N" ;
lin glow_V = mkTerm "glow_V" ;
lin glow_worm_N = mkTerm "glow_worm_N" ;
lin glower_V = mkTerm "glower_V" ;
lin gloweringly_Adv = mkTerm "gloweringly_Adv" ;
lin glowingly_Adv = mkTerm "glowingly_Adv" ;
lin gloxinia_N = mkTerm "gloxinia_N" ;
lin glucagon_N = mkTerm "glucagon_N" ;
lin glucocorticoid_N = mkTerm "glucocorticoid_N" ;
lin glucosamine_N = mkTerm "glucosamine_N" ;
lin glucose_N = mkTerm "glucose_N" ;
lin glucoside_N = mkTerm "glucoside_N" ;
lin glucosuria_N = mkTerm "glucosuria_N" ;
lin glue_N = mkTerm "glue_N" ;
lin glue_V2 = mkTerm "glue_V2" ;
lin glue_down_V = mkTerm "glue_down_V" ;
lin glued_A = mkTerm "glued_A" ;
lin gluey_A = mkTerm "gluey_A" ;
lin glum_A = mkTerm "glum_A" ;
lin glume_N = mkTerm "glume_N" ;
lin glumness_N = mkTerm "glumness_N" ;
lin gluon_N = mkTerm "gluon_N" ;
lin glusburn_PN = mkTerm "glusburn_PN" ;
lin glut_N = mkTerm "glut_N" ;
lin glut_V2 = mkTerm "glut_V2" ;
lin glutamate_N = mkTerm "glutamate_N" ;
lin glutamine_N = mkTerm "glutamine_N" ;
lin gluteal_A = mkTerm "gluteal_A" ;
lin glutelin_N = mkTerm "glutelin_N" ;
lin gluten_N = mkTerm "gluten_N" ;
lin glutethimide_N = mkTerm "glutethimide_N" ;
lin gluteus_N = mkTerm "gluteus_N" ;
lin glutinous_A = mkTerm "glutinous_A" ;
lin glutton_N = mkTerm "glutton_N" ;
lin gluttonous_A = mkTerm "gluttonous_A" ;
lin gluttony_N = mkTerm "gluttony_N" ;
lin glyburide_N = mkTerm "glyburide_N" ;
lin glyceraldehyde_N = mkTerm "glyceraldehyde_N" ;
lin glyceride_N = mkTerm "glyceride_N" ;
lin glycerine_N = mkTerm "glycerine_N" ;
lin glycerite_N = mkTerm "glycerite_N" ;
lin glycerogelatin_N = mkTerm "glycerogelatin_N" ;
lin glycerol_N = mkTerm "glycerol_N" ;
lin glyceryl_N = mkTerm "glyceryl_N" ;
lin glycine_N = mkTerm "glycine_N" ;
lin glycogen_N = mkTerm "glycogen_N" ;
lin glycogenesis_N = mkTerm "glycogenesis_N" ;
lin glycogenic_A = mkTerm "glycogenic_A" ;
lin glycolysis_N = mkTerm "glycolysis_N" ;
lin glycoprotein_N = mkTerm "glycoprotein_N" ;
lin glycoside_N = mkTerm "glycoside_N" ;
lin glycosuria_N = mkTerm "glycosuria_N" ;
lin glyph_N = mkTerm "glyph_N" ;
lin glyptics_N = mkTerm "glyptics_N" ;
lin glyptography_N = mkTerm "glyptography_N" ;
lin gmt_PN = mkTerm "gmt_PN" ;
lin gnarled_A = mkTerm "gnarled_A" ;
lin gnash_V = mkTerm "gnash_V" ;
lin gnash_V2 = mkTerm "gnash_V2" ;
lin gnat_N = mkTerm "gnat_N" ;
lin gnatcatcher_N = mkTerm "gnatcatcher_N" ;
lin gnathion_N = mkTerm "gnathion_N" ;
lin gnathostome_N = mkTerm "gnathostome_N" ;
lin gnaw_V = mkTerm "gnaw_V" ;
lin gnaw_V2 = mkTerm "gnaw_V2" ;
lin gnaw_at_V2 = mkTerm "gnaw_at_V2" ;
lin gnaw_away_at_V2 = mkTerm "gnaw_away_at_V2" ;
lin gneiss_N = mkTerm "gneiss_N" ;
lin gnetum_N = mkTerm "gnetum_N" ;
lin gnocchi_N = mkTerm "gnocchi_N" ;
lin gnome_N = mkTerm "gnome_N" ;
lin gnomic_A = mkTerm "gnomic_A" ;
lin gnomish_A = mkTerm "gnomish_A" ;
lin gnomon_N = mkTerm "gnomon_N" ;
lin gnosis_N = mkTerm "gnosis_N" ;
lin gnostic_A = mkTerm "gnostic_A" ;
lin gnp_N = mkTerm "gnp_N" ;
lin gnu_N = mkTerm "gnu_N" ;
lin go_A = mkTerm "go_A" ;
lin go_N = mkTerm "go_N" ;
lin go_V = mkTerm "go_V" ;
lin go_VA = mkTerm "go_VA" ;
lin go_VV = mkTerm "go_VV" ;
lin go_about_V = mkTerm "go_about_V" ;
lin go_about_V2 = mkTerm "go_about_V2" ;
lin go_across_V = mkTerm "go_across_V" ;
lin go_after_V2 = mkTerm "go_after_V2" ;
lin go_against_V2 = mkTerm "go_against_V2" ;
lin go_ahead_N = mkTerm "go_ahead_N" ;
lin go_ahead_V = mkTerm "go_ahead_V" ;
lin go_ahead_with_V2 = mkTerm "go_ahead_with_V2" ;
lin go_along_V = mkTerm "go_along_V" ;
lin go_along_with_V2 = mkTerm "go_along_with_V2" ;
lin go_around_V = mkTerm "go_around_V" ;
lin go_as_you_please_A = mkTerm "go_as_you_please_A" ;
lin go_at_V2 = mkTerm "go_at_V2" ;
lin go_away_V = mkTerm "go_away_V" ;
lin go_back_V = mkTerm "go_back_V" ;
lin go_back_V2 = mkTerm "go_back_V2" ;
lin go_back_on_V2 = mkTerm "go_back_on_V2" ;
lin go_before_V = mkTerm "go_before_V" ;
lin go_below_V = mkTerm "go_below_V" ;
lin go_between_N = mkTerm "go_between_N" ;
lin go_by_N = mkTerm "go_by_N" ;
lin go_by_V = mkTerm "go_by_V" ;
lin go_by_V2 = mkTerm "go_by_V2" ;
lin go_cart_N = mkTerm "go_cart_N" ;
lin go_down_V = mkTerm "go_down_V" ;
lin go_down_on_V2 = mkTerm "go_down_on_V2" ;
lin go_down_to_V2 = mkTerm "go_down_to_V2" ;
lin go_down_with_V2 = mkTerm "go_down_with_V2" ;
lin go_for_V = mkTerm "go_for_V" ;
lin go_for_V2 = mkTerm "go_for_V2" ;
lin go_for_it_V = mkTerm "go_for_it_V" ;
lin go_forth_V = mkTerm "go_forth_V" ;
lin go_forward_V = mkTerm "go_forward_V" ;
lin go_getter_N = mkTerm "go_getter_N" ;
lin go_in_V = mkTerm "go_in_V" ;
lin go_in_for_V2 = mkTerm "go_in_for_V2" ;
lin go_in_with_V2 = mkTerm "go_in_with_V2" ;
lin go_into_V2 = mkTerm "go_into_V2" ;
lin go_it_V = mkTerm "go_it_V" ;
lin go_it_alone_V = mkTerm "go_it_alone_V" ;
lin go_kart_N = mkTerm "go_kart_N" ;
lin go_off_V = mkTerm "go_off_V" ;
lin go_off_V2 = mkTerm "go_off_V2" ;
lin go_off_with_V2 = mkTerm "go_off_with_V2" ;
lin go_on_V = mkTerm "go_on_V" ;
lin go_on_V2 = mkTerm "go_on_V2" ;
lin go_on_about_V2 = mkTerm "go_on_about_V2" ;
lin go_on_at_V2 = mkTerm "go_on_at_V2" ;
lin go_on_to_V2 = mkTerm "go_on_to_V2" ;
lin go_on_with_V2 = mkTerm "go_on_with_V2" ;
lin go_one_V = mkTerm "go_one_V" ;
lin go_out_V = mkTerm "go_out_V" ;
lin go_out_for_V2 = mkTerm "go_out_for_V2" ;
lin go_out_to_V2 = mkTerm "go_out_to_V2" ;
lin go_out_with_V2 = mkTerm "go_out_with_V2" ;
lin go_over_V = mkTerm "go_over_V" ;
lin go_over_V2 = mkTerm "go_over_V2" ;
lin go_over_to_V2 = mkTerm "go_over_to_V2" ;
lin go_past_V2 = mkTerm "go_past_V2" ;
lin go_round_V = mkTerm "go_round_V" ;
lin go_slow_N = mkTerm "go_slow_N" ;
lin go_through_V = mkTerm "go_through_V" ;
lin go_through_V2 = mkTerm "go_through_V2" ;
lin go_through_with_V2 = mkTerm "go_through_with_V2" ;
lin go_to_V2 = mkTerm "go_to_V2" ;
lin go_to_meeting_A = mkTerm "go_to_meeting_A" ;
lin go_together_V = mkTerm "go_together_V" ;
lin go_towards_V2 = mkTerm "go_towards_V2" ;
lin go_under_V = mkTerm "go_under_V" ;
lin go_up_V = mkTerm "go_up_V" ;
lin go_up_to_V2 = mkTerm "go_up_to_V2" ;
lin go_with_V2 = mkTerm "go_with_V2" ;
lin go_without_V2 = mkTerm "go_without_V2" ;
lin goad_N = mkTerm "goad_N" ;
lin goad_V2 = mkTerm "goad_V2" ;
lin goal_1_N = mkTerm "goal_1_N" ;
lin goal_2_N = mkTerm "goal_2_N" ;
lin goal_kick_N = mkTerm "goal_kick_N" ;
lin goal_line_N = mkTerm "goal_line_N" ;
lin goalie_N = mkTerm "goalie_N" ;
lin goalkeeper_N = mkTerm "goalkeeper_N" ;
lin goalless_A = mkTerm "goalless_A" ;
lin goalmouth_N = mkTerm "goalmouth_N" ;
lin goalpost_N = mkTerm "goalpost_N" ;
lin goaltender_N = mkTerm "goaltender_N" ;
lin goat_N = mkTerm "goat_N" ;
lin goatee_N = mkTerm "goatee_N" ;
lin goateed_A = mkTerm "goateed_A" ;
lin goatfish_N = mkTerm "goatfish_N" ;
lin goatherd_N = mkTerm "goatherd_N" ;
lin goatsfoot_N = mkTerm "goatsfoot_N" ;
lin goatskin_N = mkTerm "goatskin_N" ;
lin goatsucker_N = mkTerm "goatsucker_N" ;
lin gob_N = mkTerm "gob_N" ;
lin gobbet_N = mkTerm "gobbet_N" ;
lin gobble_N = mkTerm "gobble_N" ;
lin gobble_V = mkTerm "gobble_V" ;
lin gobble_V2 = mkTerm "gobble_V2" ;
lin gobbledygook_N = mkTerm "gobbledygook_N" ;
lin gobbler_N = mkTerm "gobbler_N" ;
lin goblet_N = mkTerm "goblet_N" ;
lin goblin_N = mkTerm "goblin_N" ;
lin gobsmacked_A = mkTerm "gobsmacked_A" ;
lin god_N = mkTerm "god_N" ;
lin god_PN = mkTerm "god_PN" ;
lin god_damn_A = mkTerm "god_damn_A" ;
lin god_damned_A = mkTerm "god_damned_A" ;
lin godalming_PN = mkTerm "godalming_PN" ;
lin godchild_N = mkTerm "godchild_N" ;
lin goddam_A = mkTerm "goddam_A" ;
lin goddam_Adv = mkTerm "goddam_Adv" ;
lin goddaughter_N = mkTerm "goddaughter_N" ;
lin goddess_N = mkTerm "goddess_N" ;
lin godfather_N = mkTerm "godfather_N" ;
lin godfearing_A = mkTerm "godfearing_A" ;
lin godforsaken_A = mkTerm "godforsaken_A" ;
lin godfrey_PN = mkTerm "godfrey_PN" ;
lin godhead_N = mkTerm "godhead_N" ;
lin godless_A = mkTerm "godless_A" ;
lin godlessness_N = mkTerm "godlessness_N" ;
lin godlike_A = mkTerm "godlike_A" ;
lin godliness_N = mkTerm "godliness_N" ;
lin godly_A = mkTerm "godly_A" ;
lin godmanchester_PN = mkTerm "godmanchester_PN" ;
lin godmother_N = mkTerm "godmother_N" ;
lin godown_N = mkTerm "godown_N" ;
lin godparent_N = mkTerm "godparent_N" ;
lin godsend_N = mkTerm "godsend_N" ;
lin godson_N = mkTerm "godson_N" ;
lin godspeed_N = mkTerm "godspeed_N" ;
lin godwit_N = mkTerm "godwit_N" ;
lin goethite_N = mkTerm "goethite_N" ;
lin gofer_N = mkTerm "gofer_N" ;
lin goffer_N = mkTerm "goffer_N" ;
lin goffs_oak_PN = mkTerm "goffs_oak_PN" ;
lin goggle_V = mkTerm "goggle_V" ;
lin goggle_box_N = mkTerm "goggle_box_N" ;
lin goggle_eyed_A = mkTerm "goggle_eyed_A" ;
lin goggles_N = mkTerm "goggles_N" ;
lin going_N = mkTerm "going_N" ;
lin going_over_N = mkTerm "going_over_N" ;
lin goiter_N = mkTerm "goiter_N" ;
lin goitre_N = mkTerm "goitre_N" ;
lin goitrogen_N = mkTerm "goitrogen_N" ;
lin golbourne_PN = mkTerm "golbourne_PN" ;
lin gold_A = mkTerm "gold_A" ;
lin gold_N = mkTerm "gold_N" ;
lin gold_beater_N = mkTerm "gold_beater_N" ;
lin gold_digger_N = mkTerm "gold_digger_N" ;
lin gold_dust_N = mkTerm "gold_dust_N" ;
lin gold_foil_N = mkTerm "gold_foil_N" ;
lin gold_leaf_N = mkTerm "gold_leaf_N" ;
lin gold_plate_N = mkTerm "gold_plate_N" ;
lin gold_rush_N = mkTerm "gold_rush_N" ;
lin goldbeater_N = mkTerm "goldbeater_N" ;
lin goldbrick_N = mkTerm "goldbrick_N" ;
lin goldcrest_N = mkTerm "goldcrest_N" ;
lin golden_A = mkTerm "golden_A" ;
lin goldenbush_N = mkTerm "goldenbush_N" ;
lin goldeneye_N = mkTerm "goldeneye_N" ;
lin goldenrod_N = mkTerm "goldenrod_N" ;
lin goldenseal_N = mkTerm "goldenseal_N" ;
lin goldfield_N = mkTerm "goldfield_N" ;
lin goldfields_N = mkTerm "goldfields_N" ;
lin goldfinch_N = mkTerm "goldfinch_N" ;
lin goldfish_N = mkTerm "goldfish_N" ;
lin goldilocks_N = mkTerm "goldilocks_N" ;
lin goldmine_N = mkTerm "goldmine_N" ;
lin goldsmith_N = mkTerm "goldsmith_N" ;
lin goldstone_N = mkTerm "goldstone_N" ;
lin goldthread_N = mkTerm "goldthread_N" ;
lin golem_N = mkTerm "golem_N" ;
lin golf_N = mkTerm "golf_N" ;
lin golf_V = mkTerm "golf_V" ;
lin golf_ball_N = mkTerm "golf_ball_N" ;
lin golf_club_N = mkTerm "golf_club_N" ;
lin golf_course_N = mkTerm "golf_course_N" ;
lin golf_links_N = mkTerm "golf_links_N" ;
lin golfcart_N = mkTerm "golfcart_N" ;
lin golfer_N = mkTerm "golfer_N" ;
lin golfing_N = mkTerm "golfing_N" ;
lin goliard_N = mkTerm "goliard_N" ;
lin goliath_N = mkTerm "goliath_N" ;
lin golliwog_N = mkTerm "golliwog_N" ;
lin golly_Interj = mkTerm "golly_Interj" ;
lin golosh_N = mkTerm "golosh_N" ;
lin gomphothere_N = mkTerm "gomphothere_N" ;
lin gonad_N = mkTerm "gonad_N" ;
lin gonadal_A = mkTerm "gonadal_A" ;
lin gonadotropic_A = mkTerm "gonadotropic_A" ;
lin gonadotropin_N = mkTerm "gonadotropin_N" ;
lin gondola_N = mkTerm "gondola_N" ;
lin gondolier_N = mkTerm "gondolier_N" ;
lin goner_N = mkTerm "goner_N" ;
lin gong_N = mkTerm "gong_N" ;
lin gong_V2 = mkTerm "gong_V2" ;
lin gonif_N = mkTerm "gonif_N" ;
lin goniometer_N = mkTerm "goniometer_N" ;
lin gonion_N = mkTerm "gonion_N" ;
lin gonioscopy_N = mkTerm "gonioscopy_N" ;
lin gonococcus_N = mkTerm "gonococcus_N" ;
lin gonorrhea_N = mkTerm "gonorrhea_N" ;
lin gonorrhoea_N = mkTerm "gonorrhoea_N" ;
lin goo_N = mkTerm "goo_N" ;
lin good_A = mkTerm "good_A" ;
lin good_N = mkTerm "good_N" ;
lin good_afternoon_Interj = mkTerm "good_afternoon_Interj" ;
lin good_evening_Interj = mkTerm "good_evening_Interj" ;
lin good_fellowship_N = mkTerm "good_fellowship_N" ;
lin good_for_naught_A = mkTerm "good_for_naught_A" ;
lin good_for_naught_N = mkTerm "good_for_naught_N" ;
lin good_for_nothing_A = mkTerm "good_for_nothing_A" ;
lin good_for_nothing_N = mkTerm "good_for_nothing_N" ;
lin good_humoured_A = mkTerm "good_humoured_A" ;
lin good_looking_A = mkTerm "good_looking_A" ;
lin good_luck_Interj = mkTerm "good_luck_Interj" ;
lin good_morning_Interj = mkTerm "good_morning_Interj" ;
lin good_natured_A = mkTerm "good_natured_A" ;
lin good_neighbourliness_N = mkTerm "good_neighbourliness_N" ;
lin good_night_Interj = mkTerm "good_night_Interj" ;
lin good_tempered_A = mkTerm "good_tempered_A" ;
lin good_time_A = mkTerm "good_time_A" ;
lin goodbye_Interj = mkTerm "goodbye_Interj" ;
lin goodish_A = mkTerm "goodish_A" ;
lin goodly_A = mkTerm "goodly_A" ;
lin goodness_N = mkTerm "goodness_N" ;
lin goods_N = mkTerm "goods_N" ;
lin goodwill_N = mkTerm "goodwill_N" ;
lin goody_N = mkTerm "goody_N" ;
lin goody_goody_A = mkTerm "goody_goody_A" ;
lin goody_goody_N = mkTerm "goody_goody_N" ;
lin gooey_A = mkTerm "gooey_A" ;
lin goof_N = mkTerm "goof_N" ;
lin goof_V = mkTerm "goof_V" ;
lin goof_V2 = mkTerm "goof_V2" ;
lin goof_around_V = mkTerm "goof_around_V" ;
lin goof_off_V = mkTerm "goof_off_V" ;
lin goof_up_V2 = mkTerm "goof_up_V2" ;
lin goofy_A = mkTerm "goofy_A" ;
lin googly_N = mkTerm "googly_N" ;
lin googol_N = mkTerm "googol_N" ;
lin googolplex_N = mkTerm "googolplex_N" ;
lin gook_N = mkTerm "gook_N" ;
lin goole_PN = mkTerm "goole_PN" ;
lin goon_N = mkTerm "goon_N" ;
lin goosander_N = mkTerm "goosander_N" ;
lin goose_N = mkTerm "goose_N" ;
lin goose_flesh_N = mkTerm "goose_flesh_N" ;
lin goose_step_N = mkTerm "goose_step_N" ;
lin gooseberry_N = mkTerm "gooseberry_N" ;
lin goosefish_N = mkTerm "goosefish_N" ;
lin goosefoot_N = mkTerm "goosefoot_N" ;
lin gooseneck_N = mkTerm "gooseneck_N" ;
lin gopher_N = mkTerm "gopher_N" ;
lin goral_N = mkTerm "goral_N" ;
lin gordian_A = mkTerm "gordian_A" ;
lin gordon_PN = mkTerm "gordon_PN" ;
lin gore_N = mkTerm "gore_N" ;
lin gore_V2 = mkTerm "gore_V2" ;
lin gorge_N = mkTerm "gorge_N" ;
lin gorge_V = mkTerm "gorge_V" ;
lin gorge_V2 = mkTerm "gorge_V2" ;
lin gorgeous_A = mkTerm "gorgeous_A" ;
lin gorgerin_N = mkTerm "gorgerin_N" ;
lin gorget_N = mkTerm "gorget_N" ;
lin gorgon_N = mkTerm "gorgon_N" ;
lin gorgonian_N = mkTerm "gorgonian_N" ;
lin gorgonzola_N = mkTerm "gorgonzola_N" ;
lin gorilla_N = mkTerm "gorilla_N" ;
lin gorky_PN = mkTerm "gorky_PN" ;
lin gormandize_V = mkTerm "gormandize_V" ;
lin gormless_A = mkTerm "gormless_A" ;
lin gorse_N = mkTerm "gorse_N" ;
lin gorseinon_PN = mkTerm "gorseinon_PN" ;
lin gory_A = mkTerm "gory_A" ;
lin goshawk_N = mkTerm "goshawk_N" ;
lin gosling_N = mkTerm "gosling_N" ;
lin gospel_N = mkTerm "gospel_N" ;
lin gosport_PN = mkTerm "gosport_PN" ;
lin gossamer_N = mkTerm "gossamer_N" ;
lin gossip_N = mkTerm "gossip_N" ;
lin gossip_V = mkTerm "gossip_V" ;
lin gossiping_N = mkTerm "gossiping_N" ;
lin goth_N = mkTerm "goth_N" ;
lin gothenburg_PN = mkTerm "gothenburg_PN" ;
lin gothic_A = mkTerm "gothic_A" ;
lin gothic_N = mkTerm "gothic_N" ;
lin gottingen_PN = mkTerm "gottingen_PN" ;
lin gouache_N = mkTerm "gouache_N" ;
lin gouge_N = mkTerm "gouge_N" ;
lin gouge_V2 = mkTerm "gouge_V2" ;
lin gouger_N = mkTerm "gouger_N" ;
lin goulash_N = mkTerm "goulash_N" ;
lin gourd_N = mkTerm "gourd_N" ;
lin gourde_N = mkTerm "gourde_N" ;
lin gourmand_N = mkTerm "gourmand_N" ;
lin gourmandism_N = mkTerm "gourmandism_N" ;
lin gourmet_N = mkTerm "gourmet_N" ;
lin gourock_PN = mkTerm "gourock_PN" ;
lin gout_N = mkTerm "gout_N" ;
lin gouty_A = mkTerm "gouty_A" ;
lin gov_PN = mkTerm "gov_PN" ;
lin govern_V = mkTerm "govern_V" ;
lin govern_V2 = mkTerm "govern_V2" ;
lin governance_N = mkTerm "governance_N" ;
lin governed_N = mkTerm "governed_N" ;
lin governess_N = mkTerm "governess_N" ;
lin government_N = mkTerm "government_N" ;
lin governmental_A = mkTerm "governmental_A" ;
lin governor_N = mkTerm "governor_N" ;
lin governor_general_N = mkTerm "governor_general_N" ;
lin governorship_N = mkTerm "governorship_N" ;
lin govt_N = mkTerm "govt_N" ;
lin gown_N = mkTerm "gown_N" ;
lin gown_V2 = mkTerm "gown_V2" ;
lin gp_N = mkTerm "gp_N" ;
lin grab_N = mkTerm "grab_N" ;
lin grab_V = mkTerm "grab_V" ;
lin grab_V2 = mkTerm "grab_V2" ;
lin grabber_N = mkTerm "grabber_N" ;
lin grace_N = mkTerm "grace_N" ;
lin grace_V2 = mkTerm "grace_V2" ;
lin graceful_A = mkTerm "graceful_A" ;
lin gracefulness_N = mkTerm "gracefulness_N" ;
lin graceless_A = mkTerm "graceless_A" ;
lin gracelessness_N = mkTerm "gracelessness_N" ;
lin gracilariid_N = mkTerm "gracilariid_N" ;
lin gracile_A = mkTerm "gracile_A" ;
lin gracious_A = mkTerm "gracious_A" ;
lin graciousness_N = mkTerm "graciousness_N" ;
lin grackle_N = mkTerm "grackle_N" ;
lin grad_N = mkTerm "grad_N" ;
lin gradable_A = mkTerm "gradable_A" ;
lin gradation_N = mkTerm "gradation_N" ;
lin gradational_A = mkTerm "gradational_A" ;
lin grade_N = mkTerm "grade_N" ;
lin grade_V2 = mkTerm "grade_V2" ;
lin grader_N = mkTerm "grader_N" ;
lin gradient_N = mkTerm "gradient_N" ;
lin grading_N = mkTerm "grading_N" ;
lin gradual_A = mkTerm "gradual_A" ;
lin gradual_N = mkTerm "gradual_N" ;
lin graduality_N = mkTerm "graduality_N" ;
lin gradualness_N = mkTerm "gradualness_N" ;
lin graduate_N = mkTerm "graduate_N" ;
lin graduate_V = mkTerm "graduate_V" ;
lin graduate_V2 = mkTerm "graduate_V2" ;
lin graduation_N = mkTerm "graduation_N" ;
lin graffito_N = mkTerm "graffito_N" ;
lin graft_N = mkTerm "graft_N" ;
lin graft_V = mkTerm "graft_V" ;
lin graft_V2 = mkTerm "graft_V2" ;
lin grail_N = mkTerm "grail_N" ;
lin grain_N = mkTerm "grain_N" ;
lin grained_A = mkTerm "grained_A" ;
lin grainfield_N = mkTerm "grainfield_N" ;
lin graining_N = mkTerm "graining_N" ;
lin gram_N = mkTerm "gram_N" ;
lin grama_N = mkTerm "grama_N" ;
lin gramicidin_N = mkTerm "gramicidin_N" ;
lin grammar_N = mkTerm "grammar_N" ;
lin grammarian_N = mkTerm "grammarian_N" ;
lin grammatical_A = mkTerm "grammatical_A" ;
lin gramme_N = mkTerm "gramme_N" ;
lin gramophone_N = mkTerm "gramophone_N" ;
lin grampian_PN = mkTerm "grampian_PN" ;
lin grampus_N = mkTerm "grampus_N" ;
lin granada_PN = mkTerm "granada_PN" ;
lin granadilla_N = mkTerm "granadilla_N" ;
lin granary_N = mkTerm "granary_N" ;
lin grand_A = mkTerm "grand_A" ;
lin grand_prix_N = mkTerm "grand_prix_N" ;
lin grandad_N = mkTerm "grandad_N" ;
lin grandaunt_N = mkTerm "grandaunt_N" ;
lin grandchild_N = mkTerm "grandchild_N" ;
lin granddad_N = mkTerm "granddad_N" ;
lin granddaughter_N = mkTerm "granddaughter_N" ;
lin grandee_N = mkTerm "grandee_N" ;
lin grandeur_N = mkTerm "grandeur_N" ;
lin grandfather_N = mkTerm "grandfather_N" ;
lin grandiloquence_N = mkTerm "grandiloquence_N" ;
lin grandiloquent_A = mkTerm "grandiloquent_A" ;
lin grandiose_A = mkTerm "grandiose_A" ;
lin grandiosity_N = mkTerm "grandiosity_N" ;
lin grandma_N = mkTerm "grandma_N" ;
lin grandmaster_N = mkTerm "grandmaster_N" ;
lin grandmother_N = mkTerm "grandmother_N" ;
lin grandnephew_N = mkTerm "grandnephew_N" ;
lin grandniece_N = mkTerm "grandniece_N" ;
lin grandpa_N = mkTerm "grandpa_N" ;
lin grandparent_N = mkTerm "grandparent_N" ;
lin grandson_N = mkTerm "grandson_N" ;
lin grandstand_N = mkTerm "grandstand_N" ;
lin grandstander_N = mkTerm "grandstander_N" ;
lin granduncle_N = mkTerm "granduncle_N" ;
lin grange_N = mkTerm "grange_N" ;
lin grangemouth_PN = mkTerm "grangemouth_PN" ;
lin granite_N = mkTerm "granite_N" ;
lin graniteware_N = mkTerm "graniteware_N" ;
lin granitic_A = mkTerm "granitic_A" ;
lin grannie_N = mkTerm "grannie_N" ;
lin granny_N = mkTerm "granny_N" ;
lin granola_N = mkTerm "granola_N" ;
lin grant_N = mkTerm "grant_N" ;
lin grant_V2 = mkTerm "grant_V2" ;
lin grant_V3 = mkTerm "grant_V3" ;
lin grantee_N = mkTerm "grantee_N" ;
lin granter_N = mkTerm "granter_N" ;
lin grantham_PN = mkTerm "grantham_PN" ;
lin grantor_N = mkTerm "grantor_N" ;
lin granular_A = mkTerm "granular_A" ;
lin granularity_N = mkTerm "granularity_N" ;
lin granulate_V = mkTerm "granulate_V" ;
lin granulate_V2 = mkTerm "granulate_V2" ;
lin granulation_N = mkTerm "granulation_N" ;
lin granule_N = mkTerm "granule_N" ;
lin granuliferous_A = mkTerm "granuliferous_A" ;
lin granulocyte_N = mkTerm "granulocyte_N" ;
lin granulocytic_A = mkTerm "granulocytic_A" ;
lin granuloma_N = mkTerm "granuloma_N" ;
lin granulomatous_A = mkTerm "granulomatous_A" ;
lin grape_N = mkTerm "grape_N" ;
lin grape_sugar_N = mkTerm "grape_sugar_N" ;
lin grapefruit_N = mkTerm "grapefruit_N" ;
lin grapelike_A = mkTerm "grapelike_A" ;
lin grapeshot_N = mkTerm "grapeshot_N" ;
lin grapevine_N = mkTerm "grapevine_N" ;
lin grapey_A = mkTerm "grapey_A" ;
lin graph_N = mkTerm "graph_N" ;
lin graphic_A = mkTerm "graphic_A" ;
lin graphic_N = mkTerm "graphic_N" ;
lin graphical_A = mkTerm "graphical_A" ;
lin graphics_N = mkTerm "graphics_N" ;
lin graphite_N = mkTerm "graphite_N" ;
lin graphologist_N = mkTerm "graphologist_N" ;
lin graphology_N = mkTerm "graphology_N" ;
lin grapnel_N = mkTerm "grapnel_N" ;
lin grappa_N = mkTerm "grappa_N" ;
lin grapple_V = mkTerm "grapple_V" ;
lin grappling_iron_N = mkTerm "grappling_iron_N" ;
lin grasp_N = mkTerm "grasp_N" ;
lin grasp_V = mkTerm "grasp_V" ;
lin grasp_V2 = mkTerm "grasp_V2" ;
lin grasp_at_V2 = mkTerm "grasp_at_V2" ;
lin grasping_N = mkTerm "grasping_N" ;
lin grass_N = mkTerm "grass_N" ;
lin grass_V = mkTerm "grass_V" ;
lin grass_V2 = mkTerm "grass_V2" ;
lin grass_on_V2 = mkTerm "grass_on_V2" ;
lin grass_up_V2 = mkTerm "grass_up_V2" ;
lin grassfinch_N = mkTerm "grassfinch_N" ;
lin grassfire_N = mkTerm "grassfire_N" ;
lin grasshopper_N = mkTerm "grasshopper_N" ;
lin grassland_N = mkTerm "grassland_N" ;
lin grassless_A = mkTerm "grassless_A" ;
lin grasslike_A = mkTerm "grasslike_A" ;
lin grassroots_A = mkTerm "grassroots_A" ;
lin grassy_A = mkTerm "grassy_A" ;
lin grate_N = mkTerm "grate_N" ;
lin grate_V = mkTerm "grate_V" ;
lin grate_V2 = mkTerm "grate_V2" ;
lin grateful_A = mkTerm "grateful_A" ;
lin gratefulness_N = mkTerm "gratefulness_N" ;
lin grater_N = mkTerm "grater_N" ;
lin gratification_N = mkTerm "gratification_N" ;
lin gratify_V2 = mkTerm "gratify_V2" ;
lin gratifying_A = mkTerm "gratifying_A" ;
lin grating_N = mkTerm "grating_N" ;
lin gratingly_Adv = mkTerm "gratingly_Adv" ;
lin gratis_A = mkTerm "gratis_A" ;
lin gratis_Adv = mkTerm "gratis_Adv" ;
lin gratitude_N = mkTerm "gratitude_N" ;
lin gratuitous_A = mkTerm "gratuitous_A" ;
lin gratuity_N = mkTerm "gratuity_N" ;
lin grave_A = mkTerm "grave_A" ;
lin grave_N = mkTerm "grave_N" ;
lin grave_V2 = mkTerm "grave_V2" ;
lin gravedigger_N = mkTerm "gravedigger_N" ;
lin gravel_N = mkTerm "gravel_N" ;
lin gravel_V2 = mkTerm "gravel_V2" ;
lin gravelly_A = mkTerm "gravelly_A" ;
lin gravelweed_N = mkTerm "gravelweed_N" ;
lin graven_A = mkTerm "graven_A" ;
lin graveness_N = mkTerm "graveness_N" ;
lin gravenhage_PN = mkTerm "gravenhage_PN" ;
lin graver_N = mkTerm "graver_N" ;
lin graverobber_N = mkTerm "graverobber_N" ;
lin gravesend_PN = mkTerm "gravesend_PN" ;
lin gravestone_N = mkTerm "gravestone_N" ;
lin graveyard_N = mkTerm "graveyard_N" ;
lin gravida_N = mkTerm "gravida_N" ;
lin gravidity_N = mkTerm "gravidity_N" ;
lin gravimeter_N = mkTerm "gravimeter_N" ;
lin graving_dock_N = mkTerm "graving_dock_N" ;
lin gravitate_V = mkTerm "gravitate_V" ;
lin gravitation_N = mkTerm "gravitation_N" ;
lin gravitational_A = mkTerm "gravitational_A" ;
lin graviton_N = mkTerm "graviton_N" ;
lin g