#!/usr/bin/env python
###############################################################################
# $Id$
#
# Project:  GDAL/OGR Test Suite
# Purpose:  Test SAFE driver
# Author:   Delfim Rego <delfimrego@gmail.com>
#
###############################################################################
# Copyright (c) 2009, Even Rouault <even dot rouault at mines-paris dot org>
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
###############################################################################

import sys

sys.path.append('../pymod')

import gdaltest

###############################################################################
# Test reading a - fake - SAFE dataset. Note: the tiff files are fake,
# reduced to 1% of their initial size and metadata stripped


def safe_1():

    tst = gdaltest.GDALTest(
        'SAFE',
        'SAFE_FAKE/test.SAFE/manifest.safe', 1, 65372)
    return tst.testOpen()


def safe_2():

    tst = gdaltest.GDALTest(
        'SAFE', 'SAFE_FAKE/test.SAFE/manifest.safe', 2, 3732)
    return tst.testOpen()


def safe_3():

    tst = gdaltest.GDALTest(
        'SAFE',
        'SENTINEL1_DS:data/SAFE_FAKE/test.SAFE:IW_VH', 1, 65372, filename_absolute=1)
    return tst.testOpen()


def safe_4():

    tst = gdaltest.GDALTest(
        'SAFE',
        'SENTINEL1_DS:data/SAFE_FAKE/test.SAFE:IW_VV', 1, 3732, filename_absolute=1)
    return tst.testOpen()


def safe_5():

    tst = gdaltest.GDALTest(
        'SAFE',
        'SENTINEL1_DS:data/SAFE_FAKE/test.SAFE:IW', 1, 65372, filename_absolute=1)
    return tst.testOpen()


gdaltest_list = [
    safe_1,
    safe_2,
    safe_3,
    safe_4,
    safe_5]

if __name__ == '__main__':

    gdaltest.setup_run('safe')

    gdaltest.run_tests(gdaltest_list)

    gdaltest.summarize()
