
#include "comb/weakly-unimodal-map-lex.h"
#include "comb/is-unimodal.h"

#include "fxtio.h"

#include "jjassert.h"

#include "fxttypes.h"
#include "nextarg.h"


//% Weakly unimodal map, lexicographic order.
//% Cf. OEIS sequences:
//%  A088536: [1..n] -> [1..n].
//%  A225006: [1..n] -> [1..n+1].
//%  A000124: [1..n] -> [1,2].
//%  A223718: [1..n] -> [1,2,3].
//%  A223659: [1..n] -> [1,2,3,4].
//%  A002412: [1,2,3] -> [1..n].
//%  A006324: [1,2,3,4] -> [1..n].

//  A000000: [1..n] -> [1..n+2] (not in the OEIS).
//  A000000: [1..n] -> [1..2*n] (not in the OEIS).
//  A000000: [1..2*n] -> [1..n] (not in the OEIS).
//  A000000: [1..n] -> [1..n-1] (not in the OEIS).
//  A000000: [1..n] -> [1..floor(n/2)] (not in the OEIS).

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Maps [0, 1, 2, ..., n-1] -> [0, 1, 2, ..., m] (n>=1)");

    ulong m = 3;
    NXARG(m, "Number of allowed values (m>=2)");

    weakly_unimodal_map_lex W(n, m);

    ulong ct = 0;

#if defined TIMING
#if defined WEAKLY_UNIMODAL_MAP_LEX_M1
    cout << "WEAKLY_UNIMODAL_MAP_LEX_M1 is defined" << endl;
#endif
    do  { ++ct; }  while ( W.next() );
#else

    ulong j = 1;  // position of leftmost change
    do
    {
#if 0  // With args n n: OEIS sequence A014300:
        if ( ! is_strongly_unimodal(W.data(), n) )  continue;
#endif
        ++ct;

        cout << setw(4) << ct << ":";
        W.print("  ", true);
        cout << "  " << j - 1;
//        cout << "  mp=" << W.mp_;
//        cout << "  mv=" << W.mv_;
//        cout << "  tr=" << W.tr_;
        cout << endl;

        jjassert( W.OK() );
    }
    while ( (j=W.next()) );
#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 13 13
arg 1: 13 == n  [Maps [0, 1, 2, ..., n-1] -> [0, 1, 2, ..., m] (n>=1)]  default=4
arg 2: 13 == m  [Number of allowed values (m>=2)]  default=3
 ct=2155894508
5.04user 0.00system 0:05.05elapsed 99%CPU
 ==> 2155894508/5.04 == 427,756,846 per second


Timing: (AMD Phenom II X4 945 3000MHz)

 time ./bin 13 13
arg 1: 13 == n  [Maps [0, 1, 2, ..., n-1] -> [0, 1, 2, ..., m] (n>=1)]  default=5
arg 2: 13 == m  [Number of allowed values (m>=2)]  default=3
  ct=2155894508
./bin 13 13  8.16s user 0.00s system 99% cpu 8.168 total
 ==> 2155894508/8.16 == 264,202,758 per second

*/

/*
OEIS:
echo $(for n in $(seq 1 9); do ./bin $n $((n + 1)); done | grep ct | sed 's/ct=//;')
 ==> 2 9 50 295 1792 11088 69498 439791 2803658
*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/weakly-unimodal-map-lex-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/weakly-unimodal-map-lex-demo.cc DEMOFLAGS=-DTIMING"
/// End:

