
#include "comb/setpart-noncrossing-rgs.h"

#include "fxtio.h"
#include "fxttypes.h"
#include "jjassert.h"

#include "nextarg.h"

//% Noncrossing set partitions of the n-set as restricted growth strings (RGS).
//% Lexicographic order.

// Cf. comb/catalan-rgs-to-noncrossing-setpart-rgs-demo.cc

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 5;
    NXARG(n, "Number of elements");

    setpart_noncrossing_rgs P(n);

    ulong ct = 0;

#if defined TIMING
#if defined SETPART_NONCROSSING_RGS_OPT
    cout << "SETPART_NONCROSSING_RGS_OPT is defined.\n";
#endif
    P.first();
    do  { ++ct; }  while ( P.next() );
#else  // TIMING
    do
    {
        ++ct;

        cout << setw(4) << ct << ":";
        P.print("  ", true);  // RGS
//        P.print_V("    V =  ", true);  // debug
//        P.print_M("    M = ", true);  // deb
        P.print_sets("    ", 1);  // sets
//        if ( ! P.OK() )  { cout << "  !!!"; }
        cout << endl;

        jjassert( P.OK() );
    }
    while ( P.next() );


#endif  // TIMING


    cout << " ct=" << ct;  // Catalan number n
    cout << endl;

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

time ./bin 17
arg 1: 17 == n  [Number of elements]  default=6
SETPART_NONCROSSING_RGS_OPT is defined.
 ct=129644790
1.24user 0.00system 0:01.24elapsed 100%CPU
 ==> 129644790/1.24 == 104,552,250 per second


time ./bin 17
arg 1: 17 == n  [Number of elements]  default=5
 ct=129644790
4.94user 0.00system 0:04.94elapsed 100%CPU
 ==> 129644790/4.94 == 26,243,884 per second
(rather slow!)

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/setpart-noncrossing-rgs-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/setpart-noncrossing-rgs-demo.cc DEMOFLAGS=-DTIMING"
/// End:

