
#include "comb/paren-pref.h"

#include "comb/comb-print.h"
#include "comb/paren-string-to-rgs.h"  // paren_bits_to_rgs()


#include "nextarg.h"
#include "fxtio.h"
#include "fxttypes.h"

#include "jjassert.h"



//% Generate all well-formed pairs of parentheses by prefix shifts

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong t = 5;
    NXARG(t, "Number of ones (t>0)");
    jjassert( t>0 );
    ulong s = t;
    NXARG(s, "Number of zeros (s<=t)");
    jjassert( t>=s );

    paren_pref C(t, s);

    ulong ct = 0;

#if defined TIMING

#if defined PAREN_PREF_FIXARRAYS
    cout << "PAREN_PREF_FIXARRAYS is defined." << endl;
#endif
#if defined PAREN_PREF_BASE1
    cout << "PAREN_PREF_BASE1 is defined." << endl;
#endif

    do  { ++ct; }  while ( C.next() );

#else // TIMING

    const ulong n = s + t;
    const ulong *x = C.data();
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";

        print_deltaset("    ", x, n);

        if ( s==t )  // print as paren string
        { print_deltaset("    ", x, n, ")("); }

        cout << endl;

        jjassert( C.OK() );
    }
    while ( C.next() );

#endif // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

time ./bin 18
arg 1: 18 == t  [Number of ones (t>0)]  default=5
arg 2: 18 == s  [Number of zeros (s<=t)]  default=18
PAREN_PREF_BASE1 is defined.
 ct=477638700
0.45user 0.00system 0:00.45elapsed 100%CPU
 ==> 477638700/0.45 == 1,061,419,333 per second

*/


/*
Timing: (AMD Phenom II X4 945 3000MHz)

// one-based array:
 time ./bin 18
arg 1: 18 == t  [Number of ones (t>0)]  default=5
arg 2: 18 == s  [Number of zeros (s<=t)]  default=18
 ct=477638700
./bin 18  1.04s user 0.00s system 99% cpu 1.039 total
 ==> 477638700/1.04 == 459,267,980 per second

 time ./bin 18
arg 1: 18 == t  [Number of ones (t>0)]  default=5
arg 2: 18 == s  [Number of zeros (s<=t)]  default=18
PAREN_PREF_FIXARRAYS is defined.
 ct=477638700
./bin 18  1.01s user 0.00s system 99% cpu 1.007 total
 ==> 477638700/1.01 == 472,909,603 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/paren-pref-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/paren-pref-demo.cc DEMOFLAGS=-DTIMING"
/// End:

