
#include "comb/binary-rot.h"
#include "perm/rotate.h"
#include "comb/comb-print.h"

#include "fxtio.h"

#include "nextarg.h"

//% Binary strings by rotations of prefixes.
//% This is the "cooler" order from:
//% Brett Stevens, Aaron Williams: The coolest order of binary strings,
//% 6th International Conference on Fun with Algorithms (FUN 2012),
//% San Servolo, Italy. LNCS 7288, pp.322-333, (2012).

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "Number of bits");

    binary_rot C(n);
    ulong ct = 0;
#if !defined TIMING
    const ulong * x = C.data();
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        print_deltaset("    ", x, n);
        cout << setw(4) << C.num_ones();
        cout << '\n';
    }
    while ( C.next() );
#else
    do { ++ct; }  while ( C.next() );
#endif

    std::cout << " ct = " << ct << '\n';
    return 0;
}
// -------------------------


/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

time ./bin 28
arg 1: 28 == n  [Number of bits]  default=6
 ct = 268435456
1.19user 0.00system 0:01.19elapsed 100%CPU
 ==> 268435456/1.19 == 225,576,013 per second

*/



/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/binary-rot-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/binary-rot-demo.cc DEMOFLAGS=-DTIMING"
/// End:

