// This file is part of the FXT library.
// Copyright (C) 2010, 2012 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "array-len.h"
#include "fxttypes.h"
#include "bits/bitsperlong.h"


//: num_necklaces_tab[n] == number of binary n-bit necklaces
// print("/*0:*/ 0,");
// for (n=1,65,s=0;fordiv(n,d,s=s+eulerphi(d)*2^(n/d));print("/*",n,":*/ ",s/n,","))
extern const ulong num_necklaces_tab[BITS_PER_LONG+1] = {
    /*0:*/ 0,
    /*1:*/ 2,
    /*2:*/ 3,
    /*3:*/ 4,
    /*4:*/ 6,
    /*5:*/ 8,
    /*6:*/ 14,
    /*7:*/ 20,
    /*8:*/ 36,
    /*9:*/ 60,
    /*10:*/ 108,
    /*11:*/ 188,
    /*12:*/ 352,
    /*13:*/ 632,
    /*14:*/ 1182,
    /*15:*/ 2192,
    /*16:*/ 4116,
    /*17:*/ 7712,
    /*18:*/ 14602,
    /*19:*/ 27596,
    /*20:*/ 52488,
    /*21:*/ 99880,
    /*22:*/ 190746,
    /*23:*/ 364724,
    /*24:*/ 699252,
    /*25:*/ 1342184,
    /*26:*/ 2581428,
    /*27:*/ 4971068,
    /*28:*/ 9587580,
    /*29:*/ 18512792,
    /*30:*/ 35792568,
    /*31:*/ 69273668,
    /*32:*/ 134219796,

#if ( BITS_PER_LONG > 32 )
    /*33:*/ 260301176,
    /*34:*/ 505294128,
    /*35:*/ 981706832,
    /*36:*/ 1908881900,
    /*37:*/ 3714566312,
    /*38:*/ 7233642930,
    /*39:*/ 14096303344,
    /*40:*/ 27487816992,
    /*41:*/ 53634713552,
    /*42:*/ 104715443852,
    /*43:*/ 204560302844,
    /*44:*/ 399822505524,
    /*45:*/ 781874936816,
    /*46:*/ 1529755490574,
    /*47:*/ 2994414645860,
    /*48:*/ 5864062367252,
    /*49:*/ 11488774559636,
    /*50:*/ 22517998808028,
    /*51:*/ 44152937528384,
    /*52:*/ 86607686432616,
    /*53:*/ 169947155749832,
    /*54:*/ 333599974893066,
    /*55:*/ 655069036708592,
    /*56:*/ 1286742755471400,
    /*57:*/ 2528336632928152,
    /*58:*/ 4969489253251428,
    /*59:*/ 9770521225481756,
    /*60:*/ 19215358428046176,
    /*61:*/ 37800705069076952,
    /*62:*/ 74382032589917286,
    /*63:*/ 146402730743793240,
    /*64:*/ 288230376218822676,
//    /*65:*/ 567592125344909792,

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )

#endif
};
// -------------------------

//extern const ulong num_necklaces_tab_len = ARRAY_LEN(num_necklaces_tab);


//: num_lyndon_tab[n] == number of binary n-bit Lyndon words
// print("/*0:*/ 0,");
// for (n=1,65,s=0;fordiv(n,d,s=s+moebius(d)*2^(n/d));print("/*",n,":*/ ",s/n,","))
extern const ulong num_lyndon_tab[BITS_PER_LONG+1] = {
    /*0:*/ 0,
    /*1:*/ 2,
    /*2:*/ 1,
    /*3:*/ 2,
    /*4:*/ 3,
    /*5:*/ 6,
    /*6:*/ 9,
    /*7:*/ 18,
    /*8:*/ 30,
    /*9:*/ 56,
    /*10:*/ 99,
    /*11:*/ 186,
    /*12:*/ 335,
    /*13:*/ 630,
    /*14:*/ 1161,
    /*15:*/ 2182,
    /*16:*/ 4080,
    /*17:*/ 7710,
    /*18:*/ 14532,
    /*19:*/ 27594,
    /*20:*/ 52377,
    /*21:*/ 99858,
    /*22:*/ 190557,
    /*23:*/ 364722,
    /*24:*/ 698870,
    /*25:*/ 1342176,
    /*26:*/ 2580795,
    /*27:*/ 4971008,
    /*28:*/ 9586395,
    /*29:*/ 18512790,
    /*30:*/ 35790267,
    /*31:*/ 69273666,
    /*32:*/ 134215680,

#if ( BITS_PER_LONG > 32 )
    /*33:*/ 260300986,
    /*34:*/ 505286415,
    /*35:*/ 981706806,
    /*36:*/ 1908866960,
    /*37:*/ 3714566310,
    /*38:*/ 7233615333,
    /*39:*/ 14096302710,
    /*40:*/ 27487764474,
    /*41:*/ 53634713550,
    /*42:*/ 104715342801,
    /*43:*/ 204560302842,
    /*44:*/ 399822314775,
    /*45:*/ 781874934568,
    /*46:*/ 1529755125849,
    /*47:*/ 2994414645858,
    /*48:*/ 5864061663920,
    /*49:*/ 11488774559616,
    /*50:*/ 22517997465744,
    /*51:*/ 44152937520670,
    /*52:*/ 86607683851185,
    /*53:*/ 169947155749830,
    /*54:*/ 333599969907456,
    /*55:*/ 655069036708398,
    /*56:*/ 1286742745883790,
    /*57:*/ 2528336632900554,
    /*58:*/ 4969489234738635,
    /*59:*/ 9770521225481754,
    /*60:*/ 19215358392200893,
    /*61:*/ 37800705069076950,
    /*62:*/ 74382032520643617,
    /*63:*/ 146402730743693304,
    /*64:*/ 288230376084602880,
//    /*65:*/ 567592125344909154,

#if  ( BITS_PER_LONG > 64 )
#error "Need data for BITS_PER_LONG > 64"
#endif  // ( BITS_PER_LONG > 64 )

#endif
};
// -------------------------

//extern const ulong num_lyndon_tab_len = ARRAY_LEN(num_lyndon_tab);
