
#include "comb/signed-perm-gray.h"
#include "comb/perm-trotter.h"
#include "comb/ruler-func.h"

//#include "comb/fact2perm.h"

//#include "perm/perm2ccf.h"
//#include "perm/printcycles.h"
//#include "perm/permq.h"
//#include "perm/perm-genus.h"

#include "fxttypes.h"
#include "fxtio.h"
#include "nextarg.h"
#include "jjassert.h"


//% Signed permutations (hyperoctahedral group), Gray code.
//% Every second signed permutation in the list is a pure rotation.
//% There are n! * 2^n signed permutations of n elements.
//% We flip a sign most often, the number of transpositions is minimal, as in
//%  James F. Korsh, Paul S. LaFollette: A loopless Gray code for rooted trees,
//%  ACM Transactions on Algorithms, vol.2, no.2, pp.135-152, (April-2006).

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 3;
    NXARG(n, "Signed permutations of n elements.");

    signed_perm_gray SP(n);
    SP.first();


#if defined TIMING
#if defined PERM_TROTTER_OPT
    cout << "PERM_TROTTER_OPT is defined." << endl;
#endif
    ulong ct = 0;
    do { ++ct; } while ( SP.next() );
    cout << "ct=" << ct << endl;

#else  // TIMING

    ulong ct = 0;
    do
    {
        cout << setw(4) << ct << ":";
        ++ct;

        SP.print("    ", true);
        cout << "  " << ( SP.is_rotation() ? "R" : "F" );
        cout << endl;

        jjassert( SP.OK() );
    }
    while ( SP.next() );
//    while ( SP.next_rotation() );

    cout << " ct=" << ct << endl;
#endif  // TIMING

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 8.3.0

time ./bin 10
arg 1: 10 == n  [Signed permutations of n elements.]  default=3
PERM_TROTTER_OPT is defined.
ct=3715891200
11.53user 0.00system 0:11.56elapsed 99%CPU
 ==> 3715891200 / 11.56 == 321,443,875 per second
*/



/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/signed-perm-gray-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/signed-perm-gray-demo.cc DEMOFLAGS=-DTIMING"
/// End:

