
#include "comb/peano-ndim.h"
#include "comb/mixedradix-gray.h"

#include "nextarg.h"  // NXARG()
#include "fxttypes.h"
#include "fxtio.h"
#include "jjassert.h"

//% n-dimensional Peano curve


//#define TIMING  // uncomment to disable printing


//#define DO_TEST
//
#if defined DO_TEST
#include "ds/array3d.h"
#endif


int
main(int argc, char **argv)
{
    ulong nd = 2;
#if defined DO_TEST
    nd = 3;
#else
    NXARG(nd, "Number of dimensions");
#endif

    ulong it = 2;
    NXARG(it, "Iterate");

    peano_ndim Peano( nd, it );

    const ulong dim = Peano.edge_length();
    cout << " edge_length = " << dim + 1 << endl;
    cout << " num_points = " << Peano.num_points() << endl;
#if defined DO_TEST
    cerr << "## DO_TEST active" << endl;
    array3d<ulong> Arr( dim, dim, dim );
    Arr.null();
    cout << " n_elem = " << Arr.num_elem() << endl;

    long P0[3] = { 0, 0, 0 };
#endif

#if defined TIMING
#if defined PEANO_NDIM_USE_CALC_DIR
    cout << "PEANO_NDIM_USE_CALC_DIR is defined.\n";
#endif
#endif

    ulong ct = 1;  // point zero is first
    ulong coord_idx = 0;
    long dir = 0;
    while ( Peano.next( coord_idx, dir ) )
    {
#if defined TIMING
#else
//        if ( (ct+0)%27 != 0 )  { ++ct;  continue; };

        const long * Pnt = Peano.point();
        cout << " " << setw(4) << ct << ":  ";
        cout << " [";
        for (ulong j = 0; j < nd; ++j)  cout << " " << setw(2) << Pnt[j];
        cout << " ]";
        cout << setw(6) << "xyzrstuvw"[coord_idx];
        cout << " " << (dir<0?'-':'+');
//        cout << " " << (Peano.MR.dir()<0?'-':'+');
        Peano.MR.print("    ", true );
//        cout << "  MR.dir = " << Peano.MR.dir();
        cout << endl;
#endif  // TIMING

#if defined DO_TEST

        const long * P = Peano.point();
        const ulong x = (ulong)P[0], y = (ulong)P[1], z = (ulong)P[2];
        jjassert( ! Arr.is_off( x, y, z ) );
        const ulong act = Arr[x][y][z];
        if ( 0 != act )  cout << " :: act = " << act << endl;
        jjassert( 0 == act );
        Arr[x][y][z] = ct;
        jjassert( std::abs( P[0] - P0[0] ) <= 1L );
        jjassert( std::abs( P[1] - P0[1] ) <= 1L );
        jjassert( std::abs( P[2] - P0[2] ) <= 1L );
        P0[0] = P[0];
        P0[1] = P[1];
        P0[2] = P[2];
#endif

        ++ct;
    }


    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 3 6
arg 1: 3 == nd  [Number of dimensions]  default=2
arg 2: 6 == it  [Iterate]  default=2
 edge_length = 730
 num_points = 387420489
PEANO_NDIM_USE_CALC_DIR is defined.
 ct=387420489
2.16user 0.00system 0:02.16elapsed 100%CPU
==> 387420489 / 2.16 == 179,361,337 points per second

time ./bin 3 6
arg 1: 3 == nd  [Number of dimensions]  default=2
arg 2: 6 == it  [Iterate]  default=2
 edge_length = 730
 num_points = 387420489
 ct=387420489
3.12user 0.00system 0:03.12elapsed 100%CPU
==> 387420489 / 3.12 == 124,173,233 points per second



cf. class mixedradix_gray:
time ./bin 20 3
 ct=3486784401
7.09user 0.00system 0:07.09elapsed 100%CPU
 ==> 3486784401 / 7.09 == 491,789,055 numbers per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/peano-ndim-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/peano-ndim-demo.cc DEMOFLAGS=-DTIMING"
/// End:

